.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
polytopes - Draws one of the six regular 4d polytopes rotating in 4d.
.SH SYNOPSIS
.B polytopes
[\-display \fIhost:display.screen\fP]
[\-install]
[\-visual \fIvisual\fP]
[\-window]
[\-root]
[\-delay \fIusecs\fP]
[\-fps]
[\-5-cell]
[\-8-cell]
[\-16-cell]
[\-24-cell]
[\-120-cell]
[\-600-cell]
[\-wireframe]
[\-surface]
[\-transparent]
[\-single-color]
[\-depth-colors]
[\-perspective-3d]
[\-orthographic-3d]
[\-perspective-4d]
[\-orthographic-4d]
[\-speed-wx \fIfloat\fP]
[\-speed-wy \fIfloat\fP]
[\-speed-wz \fIfloat\fP]
[\-speed-xy \fIfloat\fP]
[\-speed-xz \fIfloat\fP]
[\-speed-yz \fIfloat\fP]
.SH DESCRIPTION
The \fIpolytopes\fP program shows one of the six regular 4d polytopes
(5-cell, 8-cell, 16-cell, 24-cell, 120-cell, or 600-cell) rotating in
4d.  The program projects the 4d polytope to 3d using either a
perspective or an orthographic projection.  The projected 3d polytope
can then be projected to the screen either perspectively or
orthographically.  There are three display modes for the polytope:
mesh (wireframe), solid, or transparent.  Furthermore, the colors with
which the polytope is drawn can be set to either single color or to a
coloring according to the 4d "depth" (the w coordinate) of the
polytope in its unrotated position.  In the first case, the polytope
is drawn in red.  This coloring combined with transparency gives a
nice visual effect of the structure of the polytope.  The second mode
draws the polytope with a fully saturated color wheel in which the
edges or faces are colored accoring to their average 4d "depth".  This
mode is best combined with the wireframe mode, where it allows you to
see how different parts of the polytope are moved to the "inside" of
the projected polytope in 3d.  Of course, in 4d the cells, faces, and
edges of the polytope all have the same distance from the center of
the polytope.  Only the projection creates the appearance that some of
the cells lie "inside" the figure in 3d.
.SH OPTIONS
.I polytopes
accepts the following options:
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-install
Install a private colormap for the window.
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual
class, or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-delay \fImicroseconds\fP
How much of a delay should be introduced between steps of the
animation.  Default 25000, or 1/40th second.
.PP
The following six options are mutually exclusive.  They determine
which polytope is displayed.
.TP 8
.B \-5-cell
Display the 5-cell.  The 5-cell is the 4d analogon of a regular
tetrahedron in 3d.  It has 5 regular tetrahedra as its cells, 10
equilateral triangles as faces, 10 edges, and 5 vertices.
.TP 8
.B \-8-cell
Display the 8-cell (a.k.a. hypercube or tessaract).  The 8-cell is the
4d analogon of a cube in 3d.  It has 8 cubes as its cells, 24 squares
as faces, 32 edges, and 16 vertices.
.TP 8
.B \-16-cell
Display the 16-cell.  The 16-cell is the 4d analogon of an octahedron
in 3d.  It has 16 regular tetrahedra as its cells, 32 equilateral
triangles as faces, 24 edges, and 8 vertices.
.TP 8
.B \-24-cell
Display the 24-cell.  The 24-cell has no 3d analogon.  It has 24
regular octahedra as its cells, 96 equilateral triangles as faces, 96
edges, and 24 vertices.
.TP 8
.B \-120-cell
Display the 120-cell.  The 120-cell has no 3d analogon.  It has 120
regular dodecahedra as its cells, 720 regular pentagons as faces, 1200
edges, and 600 vertices.
.TP 8
.B \-600-cell
Display the 600-cell.  The 600-cell has no 3d analogon.  It has 600
regular tetrahedra as its cells, 1200 equilateral triangles as faces,
720 edges, and 120 vertices.
.PP
The following three options are mutually exclusive.  They determine
how the polytope is displayed.
.TP 8
.B \-wireframe
Display the polytope as a wireframe mesh.
.TP 8
.B \-surface
Display the polytope as a solid object.
.TP 8
.B \-transparent
Display the polytope as a transparent object (default).
.PP
The following two options are mutually exclusive.  They determine how
to color the polytope.
.TP 8
.B \-single-color
Display the polytope in red.
.TP 8
.B \-depth-colors
Display the polytope with a fully saturated color wheel in which the
edges or faces are colored accoring to their average 4d "depth", i.e.,
the w coordinate of the polytope in its unrotated position (default).
.PP
The following two options are mutually exclusive.  They determine how
the polytope is projected from 3d to 2d (i.e., to the screen).
.TP 8
.B \-perspective-3d
Project the polytope from 3d to 2d using a perspective projection
(default).
.TP 8
.B \-orthographic-3d
Project the polytope from 3d to 2d using an orthographic projection.
.PP
The following two options are mutually exclusive.  They determine how
the polytope is projected from 4d to 3d.
.TP 8
.B \-perspective-4d
Project the polytope from 4d to 3d using a perspective projection
(default).
.TP 8
.B \-orthographic-4d
Project the polytope from 4d to 3d using an orthographic projection.
.PP
The following six options determine the rotation speed of the polytope
around the six possible hyperplanes.  The rotation speed is measured
in degrees per frame.  The speeds should be set to relatively small
values, e.g., less than 4 in magnitude.
.TP 8
.B \-speed-wx \fIfloat\fP
Rotation speed around the wx plane (default: 1.1).
.TP 8
.B \-speed-wy \fIfloat\fP
Rotation speed around the wy plane (default: 1.3).
.TP 8
.B \-speed-wz \fIfloat\fP
Rotation speed around the wz plane (default: 1.5).
.TP 8
.B \-speed-xy \fIfloat\fP
Rotation speed around the xy plane (default: 1.7).
.TP 8
.B \-speed-xz \fIfloat\fP
Rotation speed around the xz plane (default: 1.9).
.TP 8
.B \-speed-yz \fIfloat\fP
Rotation speed around the yz plane (default: 2.1).
.SH INTERACTION
If you run this program in standalone mode you can rotate the polytope
by dragging the mouse while pressing the left mouse button.  This
rotates the polytope in 3D, i.e., around the wx, wy, and wz planes.
If you press the shift key while dragging the mouse with the left
button pressed the polytope is rotated in 4D, i.e., around the xy, xz,
and yz planes.  To examine the polytope at your leisure, it is best to
set all speeds to 0.  Otherwise, the polytope will rotate while the
left mouse button is not pressed.
.B \-fps
Display the current frame rate, CPU load, and polygon count.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 2003-2005 by Carsten Steger.  Permission to use, copy,
modify, distribute, and sell this software and its documentation for
any purpose is hereby granted without fee, provided that the above
copyright notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting documentation.
No representations are made about the suitability of this software for
any purpose.  It is provided "as is" without express or implied
warranty.
.SH AUTHOR
Carsten Steger <carsten@mirsanmir.org>, 28-sep-2005.
