/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef KEYBOARDMAIN_H
#define KEYBOARDMAIN_H

#include <QWidget>
#include <QFrame>
#include <QLabel>
#include <QVBoxLayout>
#include <QSlider>
#include <QLineEdit>
#include <QGSettings/QGSettings>
#include <QPushButton>
#include <QProcess>
#include <QDebug>
#include <QtDBus/QDBusInterface>
#include "shell/interface.h"
#include "keyboardui.h"
#include "ukcccommon.h"
using namespace ukcc;


class KeyboardMain : public QWidget, CommonInterface
{
    Q_OBJECT
    Q_PLUGIN_METADATA(IID "org.ukcc.CommonInterface")
    Q_INTERFACES(CommonInterface)
public:
    KeyboardMain();
    ~KeyboardMain() Q_DECL_OVERRIDE;

    QString plugini18nName() Q_DECL_OVERRIDE;
    int pluginTypes() Q_DECL_OVERRIDE;
    QWidget *pluginUi() Q_DECL_OVERRIDE;
    const QString name() const Q_DECL_OVERRIDE;
    bool isShowOnHomePage() const Q_DECL_OVERRIDE;
    QIcon icon() const Q_DECL_OVERRIDE;
    bool isEnable() const Q_DECL_OVERRIDE;

private:
    bool            mFirstLoad      = true;
    QString         pluginName      = "";
    int             pluginType      = 0;
    KeyboardUi      *keyBoardWidget = nullptr;
    QDBusInterface  *keyBoardDbus   = nullptr;

private:
    void initConnection();
    void initKeyboardStatus();
    void initKeyRepeat();
    void initDelay();
    void initSpeed();
    void initKeyTips();
    void initShowIconOnTray();
    void initShowIconOnDesktop();
    void initKeyboardSize();
    void initTextSize();
    void initAnimation();
    void initSoundEfects();

    void setKeyboardVisible(bool checked);

protected:
    bool eventFilter(QObject *watched, QEvent *event);

public slots:
    void keyRepeatSlot(bool checked);
    void keyDelaySlot(int value);
    void keySpeedSlot(int value);
    void keyTipsSlot(bool checked);
    void inputMethodSetSlot();

    void showIconOnTraySlot(bool checked);
    void showIconOnDesktopSlot(bool checked);
    void keyboardSizeSlot(int value);
    void textSizeSlot(int index);
    void animationSlot(bool checked);
    void soundEfectsSlot(bool checked);


    void dataChanged(QString key);
};
#endif // KEYBOARDMAIN_H
