/*
 * Decompiled with CFR 0.152.
 */
package sigstore.plugin;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.auth.openidconnect.IdToken;
import com.google.api.client.auth.openidconnect.IdTokenVerifier;
import com.google.api.client.extensions.java6.auth.oauth2.AuthorizationCodeInstalledApp;
import com.google.api.client.extensions.java6.auth.oauth2.VerificationCodeReceiver;
import com.google.api.client.extensions.jetty.auth.oauth2.LocalServerReceiver;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.v2.ApacheHttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.PemReader;
import com.google.api.client.util.store.DataStoreFactory;
import com.google.api.client.util.store.MemoryDataStoreFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.CertPath;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.ECGenParameterSpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipFile;
import javax.net.ssl.HostnameVerifier;
import jdk.security.jarsigner.JarSigner;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="sign", defaultPhase=LifecyclePhase.PACKAGE)
public class Sign
extends AbstractMojo {
    @Parameter(property="input-jar", required=true)
    private File inputJar;
    @Parameter(property="output-signed-jar")
    private File outputSignedJar;
    @Parameter(property="output-signing-cert", required=true)
    private File outputSigningCert;
    @Parameter(defaultValue="https://fulcio.sigstore.dev", property="fulcio-instance-url", required=true)
    private URL fulcioInstanceURL;
    @Parameter(defaultValue="sigstore", property="oidc-client-id", required=true)
    private String oidcClientID;
    @Parameter(defaultValue="https://oauth2.sigstore.dev/auth/auth", property="oidc-auth-url", required=true)
    private URL oidcAuthURL;
    @Parameter(defaultValue="https://oauth2.sigstore.dev/auth/token", property="oidc-token-url", required=true)
    private URL oidcTokenURL;
    @Parameter(defaultValue="https://rekor.sigstore.dev", property="rekor-instance-url", required=true)
    private URL rekorInstanceURL;
    @Parameter(property="email-address", required=true)
    private String emailAddress;

    public void execute() throws MojoExecutionException {
        KeyPair keypair;
        try {
            keypair = this.generateKeyPair();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error creating keypair:", e);
        }
        try {
            PemReader.Section section;
            GsonFactory jsonFactory = new GsonFactory();
            ApacheHttpTransport apacheTransport = new ApacheHttpTransport((HttpClient)ApacheHttpTransport.newDefaultHttpClientBuilder().setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build());
            MemoryDataStoreFactory MEMORY_STORE_FACTORY = new MemoryDataStoreFactory();
            AuthorizationCodeFlow.Builder flowBuilder = new AuthorizationCodeFlow.Builder(BearerToken.authorizationHeaderAccessMethod(), (HttpTransport)apacheTransport, (JsonFactory)jsonFactory, new GenericUrl(this.oidcTokenURL.toString()), (HttpExecuteInterceptor)new ClientParametersAuthentication(this.oidcClientID, null), this.oidcClientID, this.oidcAuthURL.toString()).enablePKCE().setScopes(List.of("openid", "email")).setCredentialCreatedListener(new AuthorizationCodeFlow.CredentialCreatedListener(){
                final /* synthetic */ DataStoreFactory val$MEMORY_STORE_FACTORY;
                {
                    this.val$MEMORY_STORE_FACTORY = dataStoreFactory;
                }

                public void onCredentialCreated(Credential credential, TokenResponse tokenResponse) throws IOException {
                    this.val$MEMORY_STORE_FACTORY.getDataStore("user").set("id_token", (Serializable)((Object)tokenResponse.get((Object)"id_token").toString()));
                }
            });
            AuthorizationCodeInstalledApp app = new AuthorizationCodeInstalledApp(flowBuilder.build(), (VerificationCodeReceiver)new LocalServerReceiver());
            app.authorize("user");
            String idTokenString = (String)((Object)MEMORY_STORE_FACTORY.getDataStore("user").get("id_token"));
            IdTokenVerifier idTokenVerifier = new IdTokenVerifier();
            IdToken parsedIdToken = IdToken.parse((JsonFactory)jsonFactory, (String)idTokenString);
            if (!idTokenVerifier.verify(parsedIdToken)) {
                throw new MojoExecutionException("id token could not be verified");
            }
            String emailFromIDToken = (String)parsedIdToken.getPayload().get((Object)"email");
            Boolean emailVerified = (Boolean)parsedIdToken.getPayload().get((Object)"email_verified");
            if (!emailFromIDToken.equals(this.emailAddress)) {
                throw new MojoExecutionException(String.format("email in ID token '%s' does not match address specified to plugin '%s'", emailFromIDToken, this.emailAddress));
            }
            if (!emailVerified.booleanValue()) {
                throw new MojoExecutionException(String.format("identity provider '%s' reports email address '%s' has not been verified", parsedIdToken.getPayload().getIssuer(), this.emailAddress));
            }
            String signedEmail = this.signEmailAddress(this.emailAddress, keypair);
            String publicKeyB64 = Base64.getEncoder().encodeToString(keypair.getPublic().getEncoded());
            HashMap<String, Object> fulcioPostContent = new HashMap<String, Object>();
            HashMap<String, String> publicKeyContent = new HashMap<String, String>();
            publicKeyContent.put("content", publicKeyB64);
            publicKeyContent.put("algorithm", "ecdsa");
            fulcioPostContent.put("signedEmailAddress", signedEmail);
            fulcioPostContent.put("publicKey", publicKeyContent);
            JsonHttpContent jsonContent = new JsonHttpContent((JsonFactory)new GsonFactory(), fulcioPostContent);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            jsonContent.writeTo((OutputStream)stream);
            GenericUrl fulcioPostUrl = new GenericUrl(this.fulcioInstanceURL + "/api/v1/signingCert");
            HttpRequest req = apacheTransport.createRequestFactory().buildPostRequest(fulcioPostUrl, (HttpContent)jsonContent);
            req.getHeaders().set("Accept", (Object)"application/pem-certificate-chain");
            req.getHeaders().set("Authorization", (Object)("Bearer " + idTokenString));
            this.getLog().info((CharSequence)"requesting signing certificate");
            HttpResponse resp = req.execute();
            this.getLog().debug((CharSequence)resp.toString());
            if (resp.getStatusCode() != 201) {
                throw new Exception("bad response from fulcio: " + resp.parseAsString());
            }
            this.getLog().info((CharSequence)"parsing signing certificate");
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            PemReader pemReader = new PemReader((Reader)new InputStreamReader(resp.getContent()));
            while ((section = pemReader.readNextSection()) != null) {
                byte[] certBytes = section.getBase64DecodedBytes();
                this.getLog().debug((CharSequence)("found certificate with value: " + new String(certBytes)));
                certList.add((X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certBytes)));
            }
            if (certList.size() == 0) {
                throw new MojoExecutionException("no certificates were found in response from Fulcio instance");
            }
            CertPath cert = cf.generateCertPath(certList);
            this.getLog().info((CharSequence)("signing JAR file, writing to " + this.outputSignedJar.getAbsolutePath()));
            JarSigner js = new JarSigner.Builder(keypair.getPrivate(), cert).digestAlgorithm("SHA-256").signatureAlgorithm("SHA256withECDSA").setProperty("internalsf", "true").signerName("sigstore").tsa(new URI("http://timestamp.digicert.com")).build();
            try (ZipFile in = new ZipFile(this.inputJar);
                 FileOutputStream out = new FileOutputStream(this.outputSignedJar);){
                js.sign(in, out);
            }
            this.getLog().info((CharSequence)("writing signing certificate to " + this.outputSigningCert.getAbsolutePath()));
            Base64.Encoder encoder = Base64.getMimeEncoder(64, System.getProperty("line.separator").getBytes());
            byte[] rawCrtText = cert.getCertificates().get(0).getEncoded();
            String encodedCertText = new String(encoder.encode(rawCrtText));
            String prettified_cert = "-----BEGIN CERTIFICATE-----" + System.getProperty("line.separator") + encodedCertText + System.getProperty("line.separator") + "-----END CERTIFICATE-----";
            if (!this.outputSigningCert.createNewFile()) {
                throw new MojoExecutionException("failed to create outputSigningCert file at " + this.outputSigningCert.getAbsolutePath());
            }
            FileWriter fw = new FileWriter(this.outputSigningCert);
            fw.write(prettified_cert);
            fw.close();
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Error posting to fulcio:", e);
        }
    }

    private KeyPair generateKeyPair() throws Exception {
        this.getLog().info((CharSequence)"generating keypair using ECDSA with secp256r1 parameters");
        ECGenParameterSpec ecSpec = new ECGenParameterSpec("secp256r1");
        KeyPairGenerator g = KeyPairGenerator.getInstance("EC");
        g.initialize(ecSpec, new SecureRandom());
        return g.generateKeyPair();
    }

    private String signEmailAddress(String emailAddress, KeyPair keypair) throws Exception {
        this.getLog().info((CharSequence)("signing email address '" + emailAddress + "' as proof of possession of private key"));
        Signature sig = Signature.getInstance("SHA256withECDSA");
        sig.initSign(keypair.getPrivate());
        sig.update(emailAddress.getBytes());
        return Base64.getEncoder().encodeToString(sig.sign());
    }
}

