% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gets.R
\name{find_item}
\alias{find_item}
\alias{find_property}
\alias{find_property}
\title{Search for Wikidata items or properties that match a search term}
\usage{
find_item(search_term, language = "en", limit = 10, ...)

find_property(search_term, language = "en", limit = 10)
}
\arguments{
\item{search_term}{a term to search for.}

\item{language}{the language to return the labels and descriptions in; this should
consist of an ISO language code. Set to "en" by default.}

\item{limit}{the number of results to return; set to 10 by default.}

\item{...}{further arguments to pass to httr's GET.}
}
\description{
\code{find_item} and \code{find_property} allow you to retrieve a set
of Wikidata items or properties where the aliase or descriptions match a particular
search term.  As with other \code{WikidataR} code, custom print methods are available;
use \code{\link{str}} to manipulate and see the underlying structure of the data.
}
\examples{

#Check for entries relating to Douglas Adams in some way
adams_items <- find_item("Douglas Adams")

#Check for properties involving the peerage
peerage_props <- find_property("peerage")

}
\seealso{
\code{\link{get_random}} for selecting a random item or property,
or \code{\link{get_item}} for selecting a specific item or property.
}
