% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinywrappers.R
\name{renderUI}
\alias{renderUI}
\title{UI Output}
\usage{
renderUI(expr, env = parent.frame(), quoted = FALSE, outputArgs = list())
}
\arguments{
\item{expr}{An expression that returns a Shiny tag object, \code{\link[=HTML]{HTML()}},
or a list of such objects.}

\item{env}{The parent environment for the reactive expression. By default,
this is the calling environment, the same as when defining an ordinary
non-reactive expression. If \code{expr} is a quosure and \code{quoted} is \code{TRUE},
then \code{env} is ignored.}

\item{quoted}{If it is \code{TRUE}, then the \code{\link[=quote]{quote()}}ed value of \code{expr}
will be used when \code{expr} is evaluated. If \code{expr} is a quosure and you
would like to use its expression as a value for \code{expr}, then you must set
\code{quoted} to \code{TRUE}.}

\item{outputArgs}{A list of arguments to be passed through to the implicit
call to \code{\link[=uiOutput]{uiOutput()}} when \code{renderUI} is used in an
interactive R Markdown document.}
}
\description{
Renders reactive HTML using the Shiny UI library.
}
\details{
The corresponding HTML output tag should be \code{div} and have the CSS class
name \code{shiny-html-output} (or use \code{\link[=uiOutput]{uiOutput()}}).
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

ui <- fluidPage(
  uiOutput("moreControls")
)

server <- function(input, output) {
  output$moreControls <- renderUI({
    tagList(
      sliderInput("n", "N", 1, 1000, 500),
      textInput("label", "Label")
    )
  })
}
shinyApp(ui, server)
}

}
\seealso{
\code{\link[=uiOutput]{uiOutput()}}
}
