% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model.R
\docType{class}
\name{Model-class}
\alias{Model-class}
\alias{Model}
\title{A Redland Model object}
\description{
A Model object is used to store the statements (triples) of an RDF model.
}
\details{
A Model may be created manually by creating \code{\link{Statement}} and adding
them to the Model using \code{\link{addStatement}}, or a Model may be read in from a
previously saved file using \code{\link{parseFileIntoModel}}. Once a Model is created,
it can be queried using \code{\link{Query}}.
}
\section{Slots}{

\describe{
\item{\code{librdf_model}}{A redland model object}
}}

\section{Methods}{

\itemize{
\code{\link{Model-initialize}}: Initialize a Model object
\code{\link{addStatement}}: Add a Statement object to the Model
\code{\link{freeModel}}: Free memory used by a librdf model object
}
}

\examples{
world <- new("World")
storage <- new("Storage", world, "hashes", name="", options="hash-type='memory'")
model <- new("Model", world, storage, options="")
}
\seealso{
View examples of creating models by viewing the \code{'redland_overview'} vignette: \code{'vignette("redland_overview")'}

\code{\link{redland}}: redland package
}
\keyword{classes}
