% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_definitions.R
\name{plot.sirspline}
\alias{plot.sirspline}
\title{\code{plot} method for sirspline-object}
\usage{
\method{plot}{sirspline}(x, conf.int = TRUE, abline = TRUE, log = FALSE, type, ylab, xlab, ...)
}
\arguments{
\item{x}{an object returned by function sirspline}

\item{conf.int}{logical; default TRUE draws also the 95 confidence intervals}

\item{abline}{logical; draws a reference line where SIR = 1}

\item{log}{logical; default FALSE. Should the y-axis be in log scale}

\item{type}{select \code{type = 'n'} to plot only figure frames}

\item{ylab}{overwrites default y-axis label; can be a vector if multiple splines fitted}

\item{xlab}{overwrites default x-axis label; can be a vector if multiple splines fitted}

\item{...}{arguments passed on to plot()}
}
\value{
Always returns \code{NULL} invisibly.
This function is called for its side effects.
}
\description{
Plot SIR splines using R base graphics.
}
\details{
In \code{plot.sirspline} almost every graphical parameter are user
adjustable, such as \code{ylim}, \code{xlim}.
\code{plot.sirsplines} calls \code{lines.splines} to add lines.

The plot axis without lines can be plotted using option \code{type = 'n'}.
On top of the frame it's then possible to add a \code{grid},
\code{abline} or text before plotting the lines (see: \code{sirspline}).
}
\seealso{
Other sir functions: 
\code{\link{lines.sirspline}()},
\code{\link{sir}()},
\code{\link{sir_exp}()},
\code{\link{sir_ratio}()},
\code{\link{sirspline}()}
}
\author{
Matti Rantanen
}
\concept{sir functions}
