T.matrices <- function( n )
{
###
### This function constructs a list of lists.  For each high level list i,
### the component is a list of n components.  These components are derived
### from the list of lists E generated by the function E.matrices
###
### Argument
### n = a positive integer for the order of an underlying square matrix
###
    if( missing( n ) )
        stop( "argument n is missing" )
    if ( !is.numeric( n ) )
        stop( "argument n is not numeric" )
    if ( n != trunc( n ) )
        stop( "argument n is not an integer" )
    if ( n < 2 )
        stop( "argument n is less than 2" )
    E <- E.matrices( n )
    T <- list()
    for ( i in 1:n ) {
        T[[i]] <- list()
        for ( j in 1:n ) {
            if ( i == j ) {
                T[[i]][[j]] <- E[[i]][[j]]
            }    
            else {
                T[[i]][[j]] <- E[[i]][[j]] + E[[j]][[i]]
            }    
        }
    }
    return( T )
}
