% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixColorSpaces.R
\name{mixColorRamps}
\alias{mixColorRamps}
\alias{mixColor1Ramps}
\alias{mixColor2Ramps}
\alias{mixColor3Ramps}
\title{Mixing color ramps}
\usage{
mixColorRamps(vars, ramps)

mixColor1Ramps(vars, ramps = colorRamp(c("blue", "black", "red")))

mixColor2Ramps(
  vars,
  ramps = list(colorRamp(c("blue", "green")), colorRamp(c("blue", "red")))
)

mixColor3Ramps(
  vars,
  ramps = list(colorRamp(c("#001A00", "#00E600")), colorRamp(c("#00001A", "#0000E6")),
    colorRamp(c("#1A0000", "#E60000")))
)
}
\arguments{
\item{vars}{a list of variables}

\item{ramps}{a list of color ramps, one for each variable.}
}
\description{
mix different color ramps
}
\details{
automatically create colors to represent a varying number of
dimensions.
}
\examples{
cols <- expand.grid(x = seq(0, 1, length.out = 10),
                    y = seq(0, 1, length.out = 10),
                    z = seq(0, 1, length.out = 10))
mixed <- mixColor3Ramps(cols)

\dontrun{
if(requireNamespace("rgl", quietly = TRUE)) {
rgl::plot3d(cols$x, cols$y, cols$z, col = mixed, pch = 15)
}

cols <- expand.grid(x = seq(0, 1, length.out = 10),
                    y = seq(0, 1, length.out = 10))
mixed <- mixColor2Ramps(cols)

if(requireNamespace("graphics", quietly = TRUE)) {
plot(cols$x, cols$y, col = mixed, pch = 15)
}
}
}
