% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkList.R
\name{checkList}
\alias{checkList}
\alias{check_list}
\alias{assertList}
\alias{assert_list}
\alias{testList}
\alias{test_list}
\alias{expect_list}
\title{Check if an argument is a list}
\usage{
checkList(x, types = character(0L), any.missing = TRUE,
  all.missing = TRUE, len = NULL, min.len = NULL, max.len = NULL,
  unique = FALSE, names = NULL, null.ok = FALSE)

check_list(x, types = character(0L), any.missing = TRUE,
  all.missing = TRUE, len = NULL, min.len = NULL, max.len = NULL,
  unique = FALSE, names = NULL, null.ok = FALSE)

assertList(x, types = character(0L), any.missing = TRUE,
  all.missing = TRUE, len = NULL, min.len = NULL, max.len = NULL,
  unique = FALSE, names = NULL, null.ok = FALSE, .var.name = vname(x),
  add = NULL)

assert_list(x, types = character(0L), any.missing = TRUE,
  all.missing = TRUE, len = NULL, min.len = NULL, max.len = NULL,
  unique = FALSE, names = NULL, null.ok = FALSE, .var.name = vname(x),
  add = NULL)

testList(x, types = character(0L), any.missing = TRUE, all.missing = TRUE,
  len = NULL, min.len = NULL, max.len = NULL, unique = FALSE,
  names = NULL, null.ok = FALSE)

test_list(x, types = character(0L), any.missing = TRUE,
  all.missing = TRUE, len = NULL, min.len = NULL, max.len = NULL,
  unique = FALSE, names = NULL, null.ok = FALSE)

expect_list(x, types = character(0L), any.missing = TRUE,
  all.missing = TRUE, len = NULL, min.len = NULL, max.len = NULL,
  unique = FALSE, names = NULL, null.ok = FALSE, info = NULL,
  label = vname(x))
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{types}{[\code{character}]\cr
Character vector of class names. Each list element must inherit
from at least one of the provided types.
The types \dQuote{logical}, \dQuote{integer}, \dQuote{integerish}, \dQuote{double},
\dQuote{numeric}, \dQuote{complex}, \dQuote{character}, \dQuote{factor}, \dQuote{atomic}, \dQuote{vector}
\dQuote{atomicvector}, \dQuote{array}, \dQuote{matrix}, \dQuote{list}, \dQuote{function},
\dQuote{environment} and \dQuote{null} are supported.
For other types \code{\link[base]{inherits}} is used as a fallback to check \code{x}'s inheritance.
Defaults to \code{character(0)} (no check).}

\item{any.missing}{[\code{logical(1)}]\cr
Are vectors with missing values allowed? Default is \code{TRUE}.}

\item{all.missing}{[\code{logical(1)}]\cr
Are vectors with only missing values allowed? Default is \code{TRUE}.}

\item{len}{[\code{integer(1)}]\cr
Exact expected length of \code{x}.}

\item{min.len}{[\code{integer(1)}]\cr
Minimal length of \code{x}.}

\item{max.len}{[\code{integer(1)}]\cr
Maximal length of \code{x}.}

\item{unique}{[\code{logical(1)}]\cr
Must all values be unique? Default is \code{FALSE}.}

\item{names}{[\code{character(1)}]\cr
Check for names. See \code{\link{checkNamed}} for possible values.
Default is \dQuote{any} which performs no check at all.
Note that you can use \code{\link{checkSubset}} to check for a specific set of names.}

\item{null.ok}{[\code{logical(1)}]\cr
If set to \code{TRUE}, \code{x} may also be \code{NULL}.
In this case only a type check of \code{x} is performed, all additional checks are disabled.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{...}{[any]\cr
Additional parameters used in a call of \code{\link{checkVector}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertList}/\code{assert_list} return 
 \code{x} invisibly, whereas
 \code{checkList}/\code{check_list} and 
 \code{testList}/\code{test_list} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertList}/\code{assert_list}
 throws an error message, 
 \code{testList}/\code{test_list}
 returns \code{FALSE},
 and \code{checkList} returns a string with the error message.
 The function \code{expect_list} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is a list
}
\note{
The test for uniqueness does differentiate between the different NA types in R.
This is require to be consistent with \code{\link[base]{unique}} while checking
scalar missing values. Also see the example.
}
\examples{
testList(list())
testList(as.list(iris), types = c("numeric", "factor"))

# Uniqueness differentiates between different NA types:
testList(list(NA, NA), unique = TRUE)
testList(list(NA, NA_real_), unique = TRUE)
}
\seealso{
Other basetypes: \code{\link{checkArray}},
  \code{\link{checkAtomicVector}},
  \code{\link{checkAtomic}}, \code{\link{checkCharacter}},
  \code{\link{checkComplex}}, \code{\link{checkDataFrame}},
  \code{\link{checkDate}}, \code{\link{checkEnvironment}},
  \code{\link{checkFactor}}, \code{\link{checkFunction}},
  \code{\link{checkIntegerish}},
  \code{\link{checkInteger}}, \code{\link{checkLogical}},
  \code{\link{checkMatrix}}, \code{\link{checkNull}},
  \code{\link{checkNumeric}}, \code{\link{checkPOSIXct}},
  \code{\link{checkVector}}
}
