% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/page.R
\name{page_sidebar}
\alias{page_sidebar}
\title{A sidebar page (i.e., dashboard)}
\usage{
page_sidebar(
  ...,
  sidebar = NULL,
  title = NULL,
  fillable = TRUE,
  fillable_mobile = FALSE,
  theme = bs_theme(),
  window_title = NA,
  lang = NULL
)
}
\arguments{
\item{...}{UI elements to display in the 'main' content area (i.e., next to
the \code{sidebar}). These arguments are passed to \code{\link[=layout_sidebar]{layout_sidebar()}}, which has
more details.}

\item{sidebar}{A \code{\link[=sidebar]{sidebar()}} object.}

\item{title}{A string, number, or \code{\link[htmltools:builder]{htmltools::tag()}} child to display as the
title (just above the \code{sidebar}).}

\item{fillable}{Whether or not the \code{main} content area should be considered a
fillable (i.e., flexbox) container.}

\item{fillable_mobile}{Whether or not the page should fill the viewport's
height on mobile devices (i.e., narrow windows).}

\item{theme}{A \code{\link[=bs_theme]{bs_theme()}} object.}

\item{window_title}{the browser window title. The default value, \code{NA}, means
to use any character strings that appear in \code{title} (if none are found, the
host URL of the page is displayed by default).}

\item{lang}{ISO 639-1 language code for the HTML page, such as "en" or "ko".
This will be used as the lang in the \code{<html>} tag, as in \code{<html lang="en">}.
The default (NULL) results in an empty string.}
}
\description{
Create a dashboard layout with a full-width header (\code{title}) and \code{\link[=sidebar]{sidebar()}}.
}
\examples{
\dontshow{if (rlang::is_interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(shiny)
library(ggplot2)

ui <- page_sidebar(
  title = "Example dashboard",
  sidebar = sidebar(
    varSelectInput("var", "Select variable", mtcars)
  ),
  card(
    full_screen = TRUE,
    card_header("My plot"),
    plotOutput("p")
  )
)

server <- function(input, output) {
  output$p <- renderPlot({
    ggplot(mtcars) + geom_histogram(aes(!!input$var))
  })
}

shinyApp(ui, server)
\dontshow{\}) # examplesIf}
}
\references{
\href{https://rstudio.github.io/bslib/articles/dashboards/index.html}{Getting Started with Dashboards}
on the bslib website.
}
\seealso{
\code{\link[=layout_columns]{layout_columns()}} and \code{\link[=layout_column_wrap]{layout_column_wrap()}} for laying out content
into rows and columns.

\code{\link[=accordion]{accordion()}} for grouping related input controls in the \code{sidebar}.

\code{\link[=card]{card()}} for wrapping outputs in the 'main' content area.

\code{\link[=value_box]{value_box()}} for highlighting values.

Other Dashboard page layouts: 
\code{\link{page_fillable}()},
\code{\link{page_navbar}()}
}
\concept{Dashboard page layouts}
