% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sequence.R
\name{padSeqEnds}
\alias{padSeqEnds}
\title{Pads ragged ends of aligned DNA sequences}
\usage{
padSeqEnds(seq, len = NULL, start = FALSE, pad_char = "N")
}
\arguments{
\item{seq}{character vector of DNA sequence strings.}

\item{len}{length to pad to. Only applies if longer than the maximum length of
the data in \code{seq}.}

\item{start}{if \code{TRUE} pad the beginning of each sequence instead of the end.}

\item{pad_char}{character to use for padding.}
}
\value{
A modified \code{seq} vector with padded sequences.
}
\description{
\code{padSeqEnds} takes a vector of DNA sequences, as character strings,
and appends the ends of each sequence with an appropriate number of \code{"N"} 
characters to create a sequence vector with uniform lengths.
}
\examples{
# Default behavior uniformly pads ragged ends
seq <- c("CCCCTGGG", "ACCCTG", "CCCC")
padSeqEnds(seq)

# Pad to fixed length
padSeqEnds(seq, len=15)

# Add padding to the beginning of the sequences instead of the ends
padSeqEnds(seq, start=TRUE)
padSeqEnds(seq, len=15, start=TRUE)

}
\seealso{
See \link{maskSeqEnds} for creating uniform masking from existing masking.
}
