% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_models.R
\name{compare_factors}
\alias{compare_factors}
\title{Plot the correlation of factors between different models}
\usage{
compare_factors(models, ...)
}
\arguments{
\item{models}{a list with \code{\link{MOFA}} objects.}

\item{...}{extra arguments passed to pheatmap}
}
\value{
Plots a heatmap of the Pearson correlation between latent factors across all input models.
}
\description{
Different \code{\link{MOFA}} objects are compared in terms of correlation between their factors.
}
\details{
If assessing model robustness across trials, the output should look like a block diagonal matrix, 
suggesting that all factors are robustly detected in all model instances.
}
\examples{
# Using an existing trained model on simulated data
file <- system.file("extdata", "model.hdf5", package = "MOFA2")
model1 <- load_model(file)
model2 <- load_model(file)

# Compare factors between models
compare_factors(list(model1,model2))
}
