## ----eval = FALSE----------------------------------------------------------
#  library(ensembldb)
#  ## Load the EnsDb package that should be installed on the MySQL server
#  library(EnsDb.Hsapiens.v75)
#  
#  ## Call the useMySQL method providing the required credentials to create
#  ## databases and inserting data on the MySQL server
#  edb_mysql <- useMySQL(EnsDb.Hsapiens.v75, host = "localhost", user = "userwrite",
#                        pass = "userpass")
#  
#  ## Use this EnsDb object
#  genes(edb_mysql)
#  

## ----eval = FALSE----------------------------------------------------------
#  library(ensembldb)
#  library(RMySQL)
#  
#  ## Connect to the MySQL database to list the databases.
#  dbcon <- dbConnect(MySQL(), host = "localhost", user = "readonly",
#                     pass = "readonly")
#  
#  ## List the available databases
#  listEnsDbs(dbcon)
#  
#  ## Connect to one of the databases and use that one.
#  dbcon <- dbConnect(MySQL(), host = "localhost", user = "readonly",
#                     pass = "readonly", dbname = "ensdb_hsapiens_v75")
#  edb <- EnsDb(dbcon)
#  edb
#  

