////////////////////////////////////////////////////////////////
//
// Copyright (C) 2005 Affymetrix, Inc.
//
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License 
// (version 2.1) as published by the Free Software Foundation.
// 
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
// or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
// for more details.
// 
// You should have received a copy of the GNU Lesser General Public License
// along with this library; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
//
////////////////////////////////////////////////////////////////

/**
 * @file   ErrHandler.h
 * @author Chuck Sugnet
 * @date   Mon Jun 26 10:13:11 2006
 * 
 * @brief Interface for doing something with the errors generated by
 * Err::errAbort().
 */

#ifndef ERRHANDLER_H
#define ERRHANDLER_H

#include <cstring>
#include <string>
//

/**
 * Abstract base class (aka interface) for handling errors that come from
 * Err::errAbort(). Write a class inheriting from ErrHandler and push it 
 * onto the handler stack via Err::pushErrHandler(). 
 */
class ErrHandler {

public:
  /** Virtual destructor for a virtual class. */
  virtual ~ErrHandler() {}

  /** Prototype for the function */
  virtual void handleError(const std::string &msg) = 0;

  /** Will this error handler be throwing exceptions? */
  virtual bool getThrows() { return false; }

  /** Will this error handler be throwing exceptions? */
  virtual void setThrows(bool doThrow) {}

  /** Will this error handler set the value returned when 
    * exiting on errors
    */

  virtual void setExitOnError(bool val) {}
  /** The value to return if the error handler returns
    * specifies the value
	*/
  virtual void setExitOnErrorValue(int val) {}

};


#endif /* ERRHANDLER_H */
