# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AADBasedSecurityPrincipal(msrest.serialization.Model):
    """AAD based security principal with associated Ledger RoleName.

    :param principal_id: UUID/GUID based Principal Id of the Security Principal.
    :type principal_id: str
    :param tenant_id: UUID/GUID based Tenant Id of the Security Principal.
    :type tenant_id: str
    :param ledger_role_name: LedgerRole associated with the Security Principal of Ledger. Possible
     values include: "Reader", "Contributor", "Administrator".
    :type ledger_role_name: str or ~confidential_ledger.models.LedgerRoleName
    """

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'ledger_role_name': {'key': 'ledgerRoleName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AADBasedSecurityPrincipal, self).__init__(**kwargs)
        self.principal_id = kwargs.get('principal_id', None)
        self.tenant_id = kwargs.get('tenant_id', None)
        self.ledger_role_name = kwargs.get('ledger_role_name', None)


class CertBasedSecurityPrincipal(msrest.serialization.Model):
    """Cert based security principal with Ledger RoleName.

    :param cert: Base64 encoded public key of the user cert (.pem or .cer).
    :type cert: str
    :param ledger_role_name: LedgerRole associated with the Security Principal of Ledger. Possible
     values include: "Reader", "Contributor", "Administrator".
    :type ledger_role_name: str or ~confidential_ledger.models.LedgerRoleName
    """

    _attribute_map = {
        'cert': {'key': 'cert', 'type': 'str'},
        'ledger_role_name': {'key': 'ledgerRoleName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertBasedSecurityPrincipal, self).__init__(**kwargs)
        self.cert = kwargs.get('cert', None)
        self.ledger_role_name = kwargs.get('ledger_role_name', None)


class Tags(msrest.serialization.Model):
    """Tags for Confidential Ledger Resource.

    :param tags: A set of tags. Additional tags for Confidential Ledger.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Tags, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class Location(msrest.serialization.Model):
    """Location of the ARM Resource.

    :param location: The Azure location where the Confidential Ledger is running.
    :type location: str
    """

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Location, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)


class Resource(msrest.serialization.Model):
    """An Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the Resource.
    :vartype name: str
    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~confidential_ledger.models.SystemData
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.name = None
        self.id = None
        self.type = None
        self.system_data = None


class ConfidentialLedger(Resource, Location, Tags):
    """Confidential Ledger. Contains the properties of Confidential Ledger Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tags: A set of tags. Additional tags for Confidential Ledger.
    :type tags: dict[str, str]
    :param location: The Azure location where the Confidential Ledger is running.
    :type location: str
    :ivar name: Name of the Resource.
    :vartype name: str
    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~confidential_ledger.models.SystemData
    :param properties: Properties of Confidential Ledger Resource.
    :type properties: ~confidential_ledger.models.LedgerProperties
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'LedgerProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConfidentialLedger, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs.get('location', None)
        self.properties = kwargs.get('properties', None)
        self.tags = kwargs.get('tags', None)
        self.name = None
        self.id = None
        self.type = None
        self.system_data = None
        self.properties = kwargs.get('properties', None)
        self.location = kwargs.get('location', None)
        self.name = None
        self.id = None
        self.type = None
        self.system_data = None
        self.properties = kwargs.get('properties', None)


class ConfidentialLedgerList(msrest.serialization.Model):
    """Object that includes an array of Confidential Ledgers and a possible link for next set.

    :param value: List of Confidential Ledgers.
    :type value: list[~confidential_ledger.models.ConfidentialLedger]
    :param next_link: The URL the client should use to fetch the next page (per server side
     paging).
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ConfidentialLedger]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConfidentialLedgerList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: object
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~confidential_ledger.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~confidential_ledger.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :param error: The error object.
    :type error: ~confidential_ledger.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class LedgerProperties(msrest.serialization.Model):
    """Additional Confidential Ledger properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar ledger_name: Unique name for the Confidential Ledger.
    :vartype ledger_name: str
    :ivar ledger_uri: Endpoint for calling Ledger Service.
    :vartype ledger_uri: str
    :ivar identity_service_uri: Endpoint for accessing network identity.
    :vartype identity_service_uri: str
    :ivar ledger_internal_namespace: Internal namespace for the Ledger.
    :vartype ledger_internal_namespace: str
    :param ledger_storage_account: Name of the Blob Storage Account for saving ledger files.
    :type ledger_storage_account: str
    :param ledger_type: Type of Confidential Ledger. Possible values include: "Unknown", "Public",
     "Private".
    :type ledger_type: str or ~confidential_ledger.models.LedgerType
    :ivar provisioning_state: Provisioning state of Ledger Resource. Possible values include:
     "Unknown", "Succeeded", "Failed", "Canceled", "Creating", "Deleting", "Updating".
    :vartype provisioning_state: str or ~confidential_ledger.models.ProvisioningState
    :param aad_based_security_principals: Array of all AAD based Security Principals.
    :type aad_based_security_principals:
     list[~confidential_ledger.models.AADBasedSecurityPrincipal]
    :param cert_based_security_principals: Array of all cert based Security Principals.
    :type cert_based_security_principals:
     list[~confidential_ledger.models.CertBasedSecurityPrincipal]
    """

    _validation = {
        'ledger_name': {'readonly': True},
        'ledger_uri': {'readonly': True},
        'identity_service_uri': {'readonly': True},
        'ledger_internal_namespace': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'ledger_name': {'key': 'ledgerName', 'type': 'str'},
        'ledger_uri': {'key': 'ledgerUri', 'type': 'str'},
        'identity_service_uri': {'key': 'identityServiceUri', 'type': 'str'},
        'ledger_internal_namespace': {'key': 'ledgerInternalNamespace', 'type': 'str'},
        'ledger_storage_account': {'key': 'ledgerStorageAccount', 'type': 'str'},
        'ledger_type': {'key': 'ledgerType', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'aad_based_security_principals': {'key': 'aadBasedSecurityPrincipals', 'type': '[AADBasedSecurityPrincipal]'},
        'cert_based_security_principals': {'key': 'certBasedSecurityPrincipals', 'type': '[CertBasedSecurityPrincipal]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LedgerProperties, self).__init__(**kwargs)
        self.ledger_name = None
        self.ledger_uri = None
        self.identity_service_uri = None
        self.ledger_internal_namespace = None
        self.ledger_storage_account = kwargs.get('ledger_storage_account', None)
        self.ledger_type = kwargs.get('ledger_type', None)
        self.provisioning_state = None
        self.aad_based_security_principals = kwargs.get('aad_based_security_principals', None)
        self.cert_based_security_principals = kwargs.get('cert_based_security_principals', None)


class ResourceProviderOperationDefinition(msrest.serialization.Model):
    """Describes the Resource Provider Operation.

    :param name: Resource provider operation name.
    :type name: str
    :param is_data_action: Indicates whether the operation is data action or not.
    :type is_data_action: bool
    :param display: Details about the operations.
    :type display: ~confidential_ledger.models.ResourceProviderOperationDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'display': {'key': 'display', 'type': 'ResourceProviderOperationDisplay'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceProviderOperationDefinition, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.is_data_action = kwargs.get('is_data_action', None)
        self.display = kwargs.get('display', None)


class ResourceProviderOperationDisplay(msrest.serialization.Model):
    """Describes the properties of the Operation.

    :param provider: Name of the resource provider.
    :type provider: str
    :param resource: Name of the resource type.
    :type resource: str
    :param operation: Name of the resource provider operation.
    :type operation: str
    :param description: Description of the resource provider operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceProviderOperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class ResourceProviderOperationList(msrest.serialization.Model):
    """List containing this Resource Provider's available operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Resource provider operations list.
    :vartype value: list[~confidential_ledger.models.ResourceProviderOperationDefinition]
    :ivar next_link: The URI that can be used to request the next page for list of Azure
     operations.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceProviderOperationDefinition]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceProviderOperationList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~confidential_ledger.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~confidential_ledger.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = kwargs.get('created_by', None)
        self.created_by_type = kwargs.get('created_by_type', None)
        self.created_at = kwargs.get('created_at', None)
        self.last_modified_by = kwargs.get('last_modified_by', None)
        self.last_modified_by_type = kwargs.get('last_modified_by_type', None)
        self.last_modified_at = kwargs.get('last_modified_at', None)
