# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AdditionalUnattendContent(Model):
    """Specifies additional XML formatted information that can be included in the
    Unattend.xml file, which is used by Windows Setup. Contents are defined by
    setting name, component name, and the pass in which the content is applied.

    :param pass_name: The pass name. Currently, the only allowable value is
     OobeSystem. Possible values include: 'OobeSystem'
    :type pass_name: str or ~azure.mgmt.compute.v2015_06_15.models.PassNames
    :param component_name: The component name. Currently, the only allowable
     value is Microsoft-Windows-Shell-Setup. Possible values include:
     'Microsoft-Windows-Shell-Setup'
    :type component_name: str or
     ~azure.mgmt.compute.v2015_06_15.models.ComponentNames
    :param setting_name: Specifies the name of the setting to which the
     content applies. Possible values are: FirstLogonCommands and AutoLogon.
     Possible values include: 'AutoLogon', 'FirstLogonCommands'
    :type setting_name: str or
     ~azure.mgmt.compute.v2015_06_15.models.SettingNames
    :param content: Specifies the XML formatted content that is added to the
     unattend.xml file for the specified path and component. The XML must be
     less than 4KB and must include the root element for the setting or feature
     that is being inserted.
    :type content: str
    """

    _attribute_map = {
        'pass_name': {'key': 'passName', 'type': 'PassNames'},
        'component_name': {'key': 'componentName', 'type': 'ComponentNames'},
        'setting_name': {'key': 'settingName', 'type': 'SettingNames'},
        'content': {'key': 'content', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AdditionalUnattendContent, self).__init__(**kwargs)
        self.pass_name = kwargs.get('pass_name', None)
        self.component_name = kwargs.get('component_name', None)
        self.setting_name = kwargs.get('setting_name', None)
        self.content = kwargs.get('content', None)


class ApiEntityReference(Model):
    """The API entity reference.

    :param id: The ARM resource id in the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApiEntityReference, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class ApiError(Model):
    """Api error.

    :param details: The Api error details
    :type details: list[~azure.mgmt.compute.v2015_06_15.models.ApiErrorBase]
    :param innererror: The Api inner error
    :type innererror: ~azure.mgmt.compute.v2015_06_15.models.InnerError
    :param code: The error code.
    :type code: str
    :param target: The target of the particular error.
    :type target: str
    :param message: The error message.
    :type message: str
    """

    _attribute_map = {
        'details': {'key': 'details', 'type': '[ApiErrorBase]'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApiError, self).__init__(**kwargs)
        self.details = kwargs.get('details', None)
        self.innererror = kwargs.get('innererror', None)
        self.code = kwargs.get('code', None)
        self.target = kwargs.get('target', None)
        self.message = kwargs.get('message', None)


class ApiErrorBase(Model):
    """Api error base.

    :param code: The error code.
    :type code: str
    :param target: The target of the particular error.
    :type target: str
    :param message: The error message.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApiErrorBase, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.target = kwargs.get('target', None)
        self.message = kwargs.get('message', None)


class Resource(Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class AvailabilitySet(Resource):
    """Specifies information about the availability set that the virtual machine
    should be assigned to. Virtual machines specified in the same availability
    set are allocated to different nodes to maximize availability. For more
    information about availability sets, see [Manage the availability of
    virtual
    machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-manage-availability?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
    <br><br> For more information on Azure planned maintenance, see [Planned
    maintenance for virtual machines in
    Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-planned-maintenance?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json)
    <br><br> Currently, a VM can only be added to availability set at creation
    time. An existing VM cannot be added to an availability set.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param platform_update_domain_count: Update Domain count.
    :type platform_update_domain_count: int
    :param platform_fault_domain_count: Fault Domain count.
    :type platform_fault_domain_count: int
    :param virtual_machines: A list of references to all virtual machines in
     the availability set.
    :type virtual_machines:
     list[~azure.mgmt.compute.v2015_06_15.models.SubResource]
    :ivar statuses: The resource status information.
    :vartype statuses:
     list[~azure.mgmt.compute.v2015_06_15.models.InstanceViewStatus]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'statuses': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'platform_update_domain_count': {'key': 'properties.platformUpdateDomainCount', 'type': 'int'},
        'platform_fault_domain_count': {'key': 'properties.platformFaultDomainCount', 'type': 'int'},
        'virtual_machines': {'key': 'properties.virtualMachines', 'type': '[SubResource]'},
        'statuses': {'key': 'properties.statuses', 'type': '[InstanceViewStatus]'},
    }

    def __init__(self, **kwargs):
        super(AvailabilitySet, self).__init__(**kwargs)
        self.platform_update_domain_count = kwargs.get('platform_update_domain_count', None)
        self.platform_fault_domain_count = kwargs.get('platform_fault_domain_count', None)
        self.virtual_machines = kwargs.get('virtual_machines', None)
        self.statuses = None


class BootDiagnostics(Model):
    """Boot Diagnostics is a debugging feature which allows you to view Console
    Output and Screenshot to diagnose VM status. <br><br> You can easily view
    the output of your console log. <br><br> Azure also enables you to see a
    screenshot of the VM from the hypervisor.

    :param enabled: Whether boot diagnostics should be enabled on the Virtual
     Machine.
    :type enabled: bool
    :param storage_uri: Uri of the storage account to use for placing the
     console output and screenshot.
    :type storage_uri: str
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'storage_uri': {'key': 'storageUri', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(BootDiagnostics, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.storage_uri = kwargs.get('storage_uri', None)


class BootDiagnosticsInstanceView(Model):
    """The instance view of a virtual machine boot diagnostics.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar console_screenshot_blob_uri: The console screenshot blob URI.
    :vartype console_screenshot_blob_uri: str
    :ivar serial_console_log_blob_uri: The Linux serial console log blob Uri.
    :vartype serial_console_log_blob_uri: str
    """

    _validation = {
        'console_screenshot_blob_uri': {'readonly': True},
        'serial_console_log_blob_uri': {'readonly': True},
    }

    _attribute_map = {
        'console_screenshot_blob_uri': {'key': 'consoleScreenshotBlobUri', 'type': 'str'},
        'serial_console_log_blob_uri': {'key': 'serialConsoleLogBlobUri', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(BootDiagnosticsInstanceView, self).__init__(**kwargs)
        self.console_screenshot_blob_uri = None
        self.serial_console_log_blob_uri = None


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class ComputeLongRunningOperationProperties(Model):
    """Compute-specific operation properties, including output.

    :param output: Operation output data (raw JSON)
    :type output: object
    """

    _attribute_map = {
        'output': {'key': 'output', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(ComputeLongRunningOperationProperties, self).__init__(**kwargs)
        self.output = kwargs.get('output', None)


class DataDisk(Model):
    """Describes a data disk.

    All required parameters must be populated in order to send to Azure.

    :param lun: Required. Specifies the logical unit number of the data disk.
     This value is used to identify data disks within the VM and therefore must
     be unique for each data disk attached to a VM.
    :type lun: int
    :param name: Required. The disk name.
    :type name: str
    :param vhd: Required. The virtual hard disk.
    :type vhd: ~azure.mgmt.compute.v2015_06_15.models.VirtualHardDisk
    :param image: The source user image virtual hard disk. The virtual hard
     disk will be copied before being attached to the virtual machine. If
     SourceImage is provided, the destination virtual hard drive must not
     exist.
    :type image: ~azure.mgmt.compute.v2015_06_15.models.VirtualHardDisk
    :param caching: Specifies the caching requirements. <br><br> Possible
     values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite**
     <br><br> Default: **None for Standard storage. ReadOnly for Premium
     storage**. Possible values include: 'None', 'ReadOnly', 'ReadWrite'
    :type caching: str or ~azure.mgmt.compute.v2015_06_15.models.CachingTypes
    :param create_option: Required. Specifies how the virtual machine should
     be created.<br><br> Possible values are:<br><br> **Attach** \\u2013 This
     value is used when you are using a specialized disk to create the virtual
     machine.<br><br> **FromImage** \\u2013 This value is used when you are
     using an image to create the virtual machine. If you are using a platform
     image, you also use the imageReference element described above. If you are
     using a marketplace image, you  also use the plan element previously
     described. Possible values include: 'FromImage', 'Empty', 'Attach'
    :type create_option: str or
     ~azure.mgmt.compute.v2015_06_15.models.DiskCreateOptionTypes
    :param disk_size_gb: Specifies the size of an empty data disk in
     gigabytes. This element can be used to overwrite the size of the disk in a
     virtual machine image. <br><br> This value cannot be larger than 1023 GB
    :type disk_size_gb: int
    """

    _validation = {
        'lun': {'required': True},
        'name': {'required': True},
        'vhd': {'required': True},
        'create_option': {'required': True},
    }

    _attribute_map = {
        'lun': {'key': 'lun', 'type': 'int'},
        'name': {'key': 'name', 'type': 'str'},
        'vhd': {'key': 'vhd', 'type': 'VirtualHardDisk'},
        'image': {'key': 'image', 'type': 'VirtualHardDisk'},
        'caching': {'key': 'caching', 'type': 'CachingTypes'},
        'create_option': {'key': 'createOption', 'type': 'DiskCreateOptionTypes'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(DataDisk, self).__init__(**kwargs)
        self.lun = kwargs.get('lun', None)
        self.name = kwargs.get('name', None)
        self.vhd = kwargs.get('vhd', None)
        self.image = kwargs.get('image', None)
        self.caching = kwargs.get('caching', None)
        self.create_option = kwargs.get('create_option', None)
        self.disk_size_gb = kwargs.get('disk_size_gb', None)


class DataDiskImage(Model):
    """Contains the data disk images information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar lun: Specifies the logical unit number of the data disk. This value
     is used to identify data disks within the VM and therefore must be unique
     for each data disk attached to a VM.
    :vartype lun: int
    """

    _validation = {
        'lun': {'readonly': True},
    }

    _attribute_map = {
        'lun': {'key': 'lun', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(DataDiskImage, self).__init__(**kwargs)
        self.lun = None


class DiagnosticsProfile(Model):
    """Specifies the boot diagnostic settings state. <br><br>Minimum api-version:
    2015-06-15.

    :param boot_diagnostics: Boot Diagnostics is a debugging feature which
     allows you to view Console Output and Screenshot to diagnose VM status.
     <br><br> You can easily view the output of your console log. <br><br>
     Azure also enables you to see a screenshot of the VM from the hypervisor.
    :type boot_diagnostics:
     ~azure.mgmt.compute.v2015_06_15.models.BootDiagnostics
    """

    _attribute_map = {
        'boot_diagnostics': {'key': 'bootDiagnostics', 'type': 'BootDiagnostics'},
    }

    def __init__(self, **kwargs):
        super(DiagnosticsProfile, self).__init__(**kwargs)
        self.boot_diagnostics = kwargs.get('boot_diagnostics', None)


class DiskEncryptionSettings(Model):
    """Describes a Encryption Settings for a Disk.

    All required parameters must be populated in order to send to Azure.

    :param disk_encryption_key: Required. Specifies the location of the disk
     encryption key, which is a Key Vault Secret.
    :type disk_encryption_key:
     ~azure.mgmt.compute.v2015_06_15.models.KeyVaultSecretReference
    :param key_encryption_key: Specifies the location of the key encryption
     key in Key Vault.
    :type key_encryption_key:
     ~azure.mgmt.compute.v2015_06_15.models.KeyVaultKeyReference
    :param enabled: Specifies whether disk encryption should be enabled on the
     virtual machine.
    :type enabled: bool
    """

    _validation = {
        'disk_encryption_key': {'required': True},
    }

    _attribute_map = {
        'disk_encryption_key': {'key': 'diskEncryptionKey', 'type': 'KeyVaultSecretReference'},
        'key_encryption_key': {'key': 'keyEncryptionKey', 'type': 'KeyVaultKeyReference'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(DiskEncryptionSettings, self).__init__(**kwargs)
        self.disk_encryption_key = kwargs.get('disk_encryption_key', None)
        self.key_encryption_key = kwargs.get('key_encryption_key', None)
        self.enabled = kwargs.get('enabled', None)


class DiskInstanceView(Model):
    """The instance view of the disk.

    :param name: The disk name.
    :type name: str
    :param statuses: The resource status information.
    :type statuses:
     list[~azure.mgmt.compute.v2015_06_15.models.InstanceViewStatus]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
    }

    def __init__(self, **kwargs):
        super(DiskInstanceView, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.statuses = kwargs.get('statuses', None)


class HardwareProfile(Model):
    """Specifies the hardware settings for the virtual machine.

    :param vm_size: Specifies the size of the virtual machine. For more
     information about virtual machine sizes, see [Sizes for virtual
     machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-sizes?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
     <br><br> The available VM sizes depend on region and availability set. For
     a list of available sizes use these APIs:  <br><br> [List all available
     virtual machine sizes in an availability
     set](https://docs.microsoft.com/rest/api/compute/availabilitysets/listavailablesizes)
     <br><br> [List all available virtual machine sizes in a
     region](https://docs.microsoft.com/rest/api/compute/virtualmachinesizes/list)
     <br><br> [List all available virtual machine sizes for
     resizing](https://docs.microsoft.com/rest/api/compute/virtualmachines/listavailablesizes).
     Possible values include: 'Basic_A0', 'Basic_A1', 'Basic_A2', 'Basic_A3',
     'Basic_A4', 'Standard_A0', 'Standard_A1', 'Standard_A2', 'Standard_A3',
     'Standard_A4', 'Standard_A5', 'Standard_A6', 'Standard_A7', 'Standard_A8',
     'Standard_A9', 'Standard_A10', 'Standard_A11', 'Standard_D1',
     'Standard_D2', 'Standard_D3', 'Standard_D4', 'Standard_D11',
     'Standard_D12', 'Standard_D13', 'Standard_D14', 'Standard_D1_v2',
     'Standard_D2_v2', 'Standard_D3_v2', 'Standard_D4_v2', 'Standard_D5_v2',
     'Standard_D11_v2', 'Standard_D12_v2', 'Standard_D13_v2',
     'Standard_D14_v2', 'Standard_DS1', 'Standard_DS2', 'Standard_DS3',
     'Standard_DS4', 'Standard_DS11', 'Standard_DS12', 'Standard_DS13',
     'Standard_DS14', 'Standard_G1', 'Standard_G2', 'Standard_G3',
     'Standard_G4', 'Standard_G5', 'Standard_GS1', 'Standard_GS2',
     'Standard_GS3', 'Standard_GS4', 'Standard_GS5'
    :type vm_size: str or
     ~azure.mgmt.compute.v2015_06_15.models.VirtualMachineSizeTypes
    """

    _attribute_map = {
        'vm_size': {'key': 'vmSize', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(HardwareProfile, self).__init__(**kwargs)
        self.vm_size = kwargs.get('vm_size', None)


class ImageReference(Model):
    """Specifies information about the image to use. You can specify information
    about platform images, marketplace images, or virtual machine images. This
    element is required when you want to use a platform image, marketplace
    image, or virtual machine image, but is not used in other creation
    operations.

    :param publisher: The image publisher.
    :type publisher: str
    :param offer: Specifies the offer of the platform image or marketplace
     image used to create the virtual machine.
    :type offer: str
    :param sku: The image SKU.
    :type sku: str
    :param version: Specifies the version of the platform image or marketplace
     image used to create the virtual machine. The allowed formats are
     Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal
     numbers. Specify 'latest' to use the latest version of an image available
     at deploy time. Even if you use 'latest', the VM image will not
     automatically update after deploy time even if a new version becomes
     available.
    :type version: str
    """

    _attribute_map = {
        'publisher': {'key': 'publisher', 'type': 'str'},
        'offer': {'key': 'offer', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ImageReference, self).__init__(**kwargs)
        self.publisher = kwargs.get('publisher', None)
        self.offer = kwargs.get('offer', None)
        self.sku = kwargs.get('sku', None)
        self.version = kwargs.get('version', None)


class InnerError(Model):
    """Inner error details.

    :param exceptiontype: The exception type.
    :type exceptiontype: str
    :param errordetail: The internal error message or exception dump.
    :type errordetail: str
    """

    _attribute_map = {
        'exceptiontype': {'key': 'exceptiontype', 'type': 'str'},
        'errordetail': {'key': 'errordetail', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(InnerError, self).__init__(**kwargs)
        self.exceptiontype = kwargs.get('exceptiontype', None)
        self.errordetail = kwargs.get('errordetail', None)


class InstanceViewStatus(Model):
    """Instance view status.

    :param code: The status code.
    :type code: str
    :param level: The level code. Possible values include: 'Info', 'Warning',
     'Error'
    :type level: str or
     ~azure.mgmt.compute.v2015_06_15.models.StatusLevelTypes
    :param display_status: The short localizable label for the status.
    :type display_status: str
    :param message: The detailed status message, including for alerts and
     error messages.
    :type message: str
    :param time: The time of the status.
    :type time: datetime
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'level': {'key': 'level', 'type': 'StatusLevelTypes'},
        'display_status': {'key': 'displayStatus', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'time': {'key': 'time', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(InstanceViewStatus, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.level = kwargs.get('level', None)
        self.display_status = kwargs.get('display_status', None)
        self.message = kwargs.get('message', None)
        self.time = kwargs.get('time', None)


class KeyVaultKeyReference(Model):
    """Describes a reference to Key Vault Key.

    All required parameters must be populated in order to send to Azure.

    :param key_url: Required. The URL referencing a key encryption key in Key
     Vault.
    :type key_url: str
    :param source_vault: Required. The relative URL of the Key Vault
     containing the key.
    :type source_vault: ~azure.mgmt.compute.v2015_06_15.models.SubResource
    """

    _validation = {
        'key_url': {'required': True},
        'source_vault': {'required': True},
    }

    _attribute_map = {
        'key_url': {'key': 'keyUrl', 'type': 'str'},
        'source_vault': {'key': 'sourceVault', 'type': 'SubResource'},
    }

    def __init__(self, **kwargs):
        super(KeyVaultKeyReference, self).__init__(**kwargs)
        self.key_url = kwargs.get('key_url', None)
        self.source_vault = kwargs.get('source_vault', None)


class KeyVaultSecretReference(Model):
    """Describes a reference to Key Vault Secret.

    All required parameters must be populated in order to send to Azure.

    :param secret_url: Required. The URL referencing a secret in a Key Vault.
    :type secret_url: str
    :param source_vault: Required. The relative URL of the Key Vault
     containing the secret.
    :type source_vault: ~azure.mgmt.compute.v2015_06_15.models.SubResource
    """

    _validation = {
        'secret_url': {'required': True},
        'source_vault': {'required': True},
    }

    _attribute_map = {
        'secret_url': {'key': 'secretUrl', 'type': 'str'},
        'source_vault': {'key': 'sourceVault', 'type': 'SubResource'},
    }

    def __init__(self, **kwargs):
        super(KeyVaultSecretReference, self).__init__(**kwargs)
        self.secret_url = kwargs.get('secret_url', None)
        self.source_vault = kwargs.get('source_vault', None)


class LinuxConfiguration(Model):
    """Specifies the Linux operating system settings on the virtual machine.
    <br><br>For a list of supported Linux distributions, see [Linux on
    Azure-Endorsed
    Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
    <br><br> For running non-endorsed distributions, see [Information for
    Non-Endorsed
    Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).

    :param disable_password_authentication: Specifies whether password
     authentication should be disabled.
    :type disable_password_authentication: bool
    :param ssh: Specifies the ssh key configuration for a Linux OS.
    :type ssh: ~azure.mgmt.compute.v2015_06_15.models.SshConfiguration
    """

    _attribute_map = {
        'disable_password_authentication': {'key': 'disablePasswordAuthentication', 'type': 'bool'},
        'ssh': {'key': 'ssh', 'type': 'SshConfiguration'},
    }

    def __init__(self, **kwargs):
        super(LinuxConfiguration, self).__init__(**kwargs)
        self.disable_password_authentication = kwargs.get('disable_password_authentication', None)
        self.ssh = kwargs.get('ssh', None)


class SubResource(Model):
    """SubResource.

    :param id: Resource Id
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SubResource, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class NetworkInterfaceReference(SubResource):
    """Describes a network interface reference.

    :param id: Resource Id
    :type id: str
    :param primary: Specifies the primary network interface in case the
     virtual machine has more than 1 network interface.
    :type primary: bool
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(NetworkInterfaceReference, self).__init__(**kwargs)
        self.primary = kwargs.get('primary', None)


class NetworkProfile(Model):
    """Specifies the network interfaces of the virtual machine.

    :param network_interfaces: Specifies the list of resource Ids for the
     network interfaces associated with the virtual machine.
    :type network_interfaces:
     list[~azure.mgmt.compute.v2015_06_15.models.NetworkInterfaceReference]
    """

    _attribute_map = {
        'network_interfaces': {'key': 'networkInterfaces', 'type': '[NetworkInterfaceReference]'},
    }

    def __init__(self, **kwargs):
        super(NetworkProfile, self).__init__(**kwargs)
        self.network_interfaces = kwargs.get('network_interfaces', None)


class OperationStatusResponse(Model):
    """Operation status response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Operation ID
    :vartype name: str
    :ivar status: Operation status
    :vartype status: str
    :ivar start_time: Start time of the operation
    :vartype start_time: datetime
    :ivar end_time: End time of the operation
    :vartype end_time: datetime
    :ivar error: Api error
    :vartype error: ~azure.mgmt.compute.v2015_06_15.models.ApiError
    """

    _validation = {
        'name': {'readonly': True},
        'status': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'error': {'key': 'error', 'type': 'ApiError'},
    }

    def __init__(self, **kwargs):
        super(OperationStatusResponse, self).__init__(**kwargs)
        self.name = None
        self.status = None
        self.start_time = None
        self.end_time = None
        self.error = None


class OSDisk(Model):
    """Specifies information about the operating system disk used by the virtual
    machine. <br><br> For more information about disks, see [About disks and
    VHDs for Azure virtual
    machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).

    All required parameters must be populated in order to send to Azure.

    :param os_type: This property allows you to specify the type of the OS
     that is included in the disk if creating a VM from user-image or a
     specialized VHD. <br><br> Possible values are: <br><br> **Windows**
     <br><br> **Linux**. Possible values include: 'Windows', 'Linux'
    :type os_type: str or
     ~azure.mgmt.compute.v2015_06_15.models.OperatingSystemTypes
    :param encryption_settings: Specifies the encryption settings for the OS
     Disk. <br><br> Minimum api-version: 2015-06-15
    :type encryption_settings:
     ~azure.mgmt.compute.v2015_06_15.models.DiskEncryptionSettings
    :param name: Required. The disk name.
    :type name: str
    :param vhd: Required. The virtual hard disk.
    :type vhd: ~azure.mgmt.compute.v2015_06_15.models.VirtualHardDisk
    :param image: The source user image virtual hard disk. The virtual hard
     disk will be copied before being attached to the virtual machine. If
     SourceImage is provided, the destination virtual hard drive must not
     exist.
    :type image: ~azure.mgmt.compute.v2015_06_15.models.VirtualHardDisk
    :param caching: Specifies the caching requirements. <br><br> Possible
     values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite**
     <br><br> Default: **None for Standard storage. ReadOnly for Premium
     storage**. Possible values include: 'None', 'ReadOnly', 'ReadWrite'
    :type caching: str or ~azure.mgmt.compute.v2015_06_15.models.CachingTypes
    :param create_option: Required. Specifies how the virtual machine should
     be created.<br><br> Possible values are:<br><br> **Attach** \\u2013 This
     value is used when you are using a specialized disk to create the virtual
     machine.<br><br> **FromImage** \\u2013 This value is used when you are
     using an image to create the virtual machine. If you are using a platform
     image, you also use the imageReference element described above. If you are
     using a marketplace image, you  also use the plan element previously
     described. Possible values include: 'FromImage', 'Empty', 'Attach'
    :type create_option: str or
     ~azure.mgmt.compute.v2015_06_15.models.DiskCreateOptionTypes
    :param disk_size_gb: Specifies the size of an empty data disk in
     gigabytes. This element can be used to overwrite the size of the disk in a
     virtual machine image. <br><br> This value cannot be larger than 1023 GB
    :type disk_size_gb: int
    """

    _validation = {
        'name': {'required': True},
        'vhd': {'required': True},
        'create_option': {'required': True},
    }

    _attribute_map = {
        'os_type': {'key': 'osType', 'type': 'OperatingSystemTypes'},
        'encryption_settings': {'key': 'encryptionSettings', 'type': 'DiskEncryptionSettings'},
        'name': {'key': 'name', 'type': 'str'},
        'vhd': {'key': 'vhd', 'type': 'VirtualHardDisk'},
        'image': {'key': 'image', 'type': 'VirtualHardDisk'},
        'caching': {'key': 'caching', 'type': 'CachingTypes'},
        'create_option': {'key': 'createOption', 'type': 'DiskCreateOptionTypes'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(OSDisk, self).__init__(**kwargs)
        self.os_type = kwargs.get('os_type', None)
        self.encryption_settings = kwargs.get('encryption_settings', None)
        self.name = kwargs.get('name', None)
        self.vhd = kwargs.get('vhd', None)
        self.image = kwargs.get('image', None)
        self.caching = kwargs.get('caching', None)
        self.create_option = kwargs.get('create_option', None)
        self.disk_size_gb = kwargs.get('disk_size_gb', None)


class OSDiskImage(Model):
    """Contains the os disk image information.

    All required parameters must be populated in order to send to Azure.

    :param operating_system: Required. The operating system of the
     osDiskImage. Possible values include: 'Windows', 'Linux'
    :type operating_system: str or
     ~azure.mgmt.compute.v2015_06_15.models.OperatingSystemTypes
    """

    _validation = {
        'operating_system': {'required': True},
    }

    _attribute_map = {
        'operating_system': {'key': 'operatingSystem', 'type': 'OperatingSystemTypes'},
    }

    def __init__(self, **kwargs):
        super(OSDiskImage, self).__init__(**kwargs)
        self.operating_system = kwargs.get('operating_system', None)


class OSProfile(Model):
    """Specifies the operating system settings for the virtual machine.

    :param computer_name: Specifies the host OS name of the virtual machine.
     <br><br> This name cannot be updated after the VM is created. <br><br>
     **Max-length (Windows):** 15 characters <br><br> **Max-length (Linux):**
     64 characters. <br><br> For naming conventions and restrictions see [Azure
     infrastructure services implementation
     guidelines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-infrastructure-subscription-accounts-guidelines?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#1-naming-conventions).
    :type computer_name: str
    :param admin_username: Specifies the name of the administrator account.
     <br><br> **Windows-only restriction:** Cannot end in "." <br><br>
     **Disallowed values:** "administrator", "admin", "user", "user1", "test",
     "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm",
     "admin2", "aspnet", "backup", "console", "david", "guest", "john",
     "owner", "root", "server", "sql", "support", "support_388945a0", "sys",
     "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1
     character <br><br> **Max-length (Linux):** 64 characters <br><br>
     **Max-length (Windows):** 20 characters  <br><br><li> For root access to
     the Linux VM, see [Using root privileges on Linux virtual machines in
     Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)<br><li>
     For a list of built-in system users on Linux that should not be used in
     this field, see [Selecting User Names for Linux on
     Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
    :type admin_username: str
    :param admin_password: Specifies the password of the administrator
     account. <br><br> **Minimum-length (Windows):** 8 characters <br><br>
     **Minimum-length (Linux):** 6 characters <br><br> **Max-length
     (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters
     <br><br> **Complexity requirements:** 3 out of 4 conditions below need to
     be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a
     digit <br> Has a special character (Regex match [\\W_]) <br><br>
     **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123",
     "Pa$$word", "pass@word1", "Password!", "Password1", "Password22",
     "iloveyou!" <br><br> For resetting the password, see [How to reset the
     Remote Desktop service or its login password in a Windows
     VM](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-reset-rdp?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json)
     <br><br> For resetting root password, see [Manage users, SSH, and check or
     repair disks on Azure Linux VMs using the VMAccess
     Extension](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-vmaccess-extension?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#reset-root-password)
    :type admin_password: str
    :param custom_data: Specifies a base-64 encoded string of custom data. The
     base-64 encoded string is decoded to a binary array that is saved as a
     file on the Virtual Machine. The maximum length of the binary array is
     65535 bytes. <br><br> For using cloud-init for your VM, see [Using
     cloud-init to customize a Linux VM during
     creation](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
    :type custom_data: str
    :param windows_configuration: Specifies Windows operating system settings
     on the virtual machine.
    :type windows_configuration:
     ~azure.mgmt.compute.v2015_06_15.models.WindowsConfiguration
    :param linux_configuration: Specifies the Linux operating system settings
     on the virtual machine. <br><br>For a list of supported Linux
     distributions, see [Linux on Azure-Endorsed
     Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
     <br><br> For running non-endorsed distributions, see [Information for
     Non-Endorsed
     Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
    :type linux_configuration:
     ~azure.mgmt.compute.v2015_06_15.models.LinuxConfiguration
    :param secrets: Specifies set of certificates that should be installed
     onto the virtual machine.
    :type secrets:
     list[~azure.mgmt.compute.v2015_06_15.models.VaultSecretGroup]
    """

    _attribute_map = {
        'computer_name': {'key': 'computerName', 'type': 'str'},
        'admin_username': {'key': 'adminUsername', 'type': 'str'},
        'admin_password': {'key': 'adminPassword', 'type': 'str'},
        'custom_data': {'key': 'customData', 'type': 'str'},
        'windows_configuration': {'key': 'windowsConfiguration', 'type': 'WindowsConfiguration'},
        'linux_configuration': {'key': 'linuxConfiguration', 'type': 'LinuxConfiguration'},
        'secrets': {'key': 'secrets', 'type': '[VaultSecretGroup]'},
    }

    def __init__(self, **kwargs):
        super(OSProfile, self).__init__(**kwargs)
        self.computer_name = kwargs.get('computer_name', None)
        self.admin_username = kwargs.get('admin_username', None)
        self.admin_password = kwargs.get('admin_password', None)
        self.custom_data = kwargs.get('custom_data', None)
        self.windows_configuration = kwargs.get('windows_configuration', None)
        self.linux_configuration = kwargs.get('linux_configuration', None)
        self.secrets = kwargs.get('secrets', None)


class Plan(Model):
    """Specifies information about the marketplace image used to create the
    virtual machine. This element is only used for marketplace images. Before
    you can use a marketplace image from an API, you must enable the image for
    programmatic use.  In the Azure portal, find the marketplace image that you
    want to use and then click **Want to deploy programmatically, Get Started
    ->**. Enter any required information and then click **Save**.

    :param name: The plan ID.
    :type name: str
    :param publisher: The publisher ID.
    :type publisher: str
    :param product: Specifies the product of the image from the marketplace.
     This is the same value as Offer under the imageReference element.
    :type product: str
    :param promotion_code: The promotion code.
    :type promotion_code: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'product': {'key': 'product', 'type': 'str'},
        'promotion_code': {'key': 'promotionCode', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Plan, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.publisher = kwargs.get('publisher', None)
        self.product = kwargs.get('product', None)
        self.promotion_code = kwargs.get('promotion_code', None)


class PurchasePlan(Model):
    """Used for establishing the purchase context of any 3rd Party artifact
    through MarketPlace.

    All required parameters must be populated in order to send to Azure.

    :param publisher: Required. The publisher ID.
    :type publisher: str
    :param name: Required. The plan ID.
    :type name: str
    :param product: Required. Specifies the product of the image from the
     marketplace. This is the same value as Offer under the imageReference
     element.
    :type product: str
    """

    _validation = {
        'publisher': {'required': True},
        'name': {'required': True},
        'product': {'required': True},
    }

    _attribute_map = {
        'publisher': {'key': 'publisher', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'product': {'key': 'product', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PurchasePlan, self).__init__(**kwargs)
        self.publisher = kwargs.get('publisher', None)
        self.name = kwargs.get('name', None)
        self.product = kwargs.get('product', None)


class Sku(Model):
    """Describes a virtual machine scale set sku.

    :param name: The sku name.
    :type name: str
    :param tier: Specifies the tier of virtual machines in a scale set.<br
     /><br /> Possible Values:<br /><br /> **Standard**<br /><br /> **Basic**
    :type tier: str
    :param capacity: Specifies the number of virtual machines in the scale
     set.
    :type capacity: long
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'long'},
    }

    def __init__(self, **kwargs):
        super(Sku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.tier = kwargs.get('tier', None)
        self.capacity = kwargs.get('capacity', None)


class SshConfiguration(Model):
    """SSH configuration for Linux based VMs running on Azure.

    :param public_keys: The list of SSH public keys used to authenticate with
     linux based VMs.
    :type public_keys:
     list[~azure.mgmt.compute.v2015_06_15.models.SshPublicKey]
    """

    _attribute_map = {
        'public_keys': {'key': 'publicKeys', 'type': '[SshPublicKey]'},
    }

    def __init__(self, **kwargs):
        super(SshConfiguration, self).__init__(**kwargs)
        self.public_keys = kwargs.get('public_keys', None)


class SshPublicKey(Model):
    """Contains information about SSH certificate public key and the path on the
    Linux VM where the public key is placed.

    :param path: Specifies the full path on the created VM where ssh public
     key is stored. If the file already exists, the specified key is appended
     to the file. Example: /home/user/.ssh/authorized_keys
    :type path: str
    :param key_data: SSH public key certificate used to authenticate with the
     VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa
     format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and
     Mac for Linux VMs in
     Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
    :type key_data: str
    """

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'key_data': {'key': 'keyData', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SshPublicKey, self).__init__(**kwargs)
        self.path = kwargs.get('path', None)
        self.key_data = kwargs.get('key_data', None)


class StorageProfile(Model):
    """Specifies the storage settings for the virtual machine disks.

    :param image_reference: Specifies information about the image to use. You
     can specify information about platform images, marketplace images, or
     virtual machine images. This element is required when you want to use a
     platform image, marketplace image, or virtual machine image, but is not
     used in other creation operations.
    :type image_reference:
     ~azure.mgmt.compute.v2015_06_15.models.ImageReference
    :param os_disk: Specifies information about the operating system disk used
     by the virtual machine. <br><br> For more information about disks, see
     [About disks and VHDs for Azure virtual
     machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
    :type os_disk: ~azure.mgmt.compute.v2015_06_15.models.OSDisk
    :param data_disks: Specifies the parameters that are used to add a data
     disk to a virtual machine. <br><br> For more information about disks, see
     [About disks and VHDs for Azure virtual
     machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
    :type data_disks: list[~azure.mgmt.compute.v2015_06_15.models.DataDisk]
    """

    _attribute_map = {
        'image_reference': {'key': 'imageReference', 'type': 'ImageReference'},
        'os_disk': {'key': 'osDisk', 'type': 'OSDisk'},
        'data_disks': {'key': 'dataDisks', 'type': '[DataDisk]'},
    }

    def __init__(self, **kwargs):
        super(StorageProfile, self).__init__(**kwargs)
        self.image_reference = kwargs.get('image_reference', None)
        self.os_disk = kwargs.get('os_disk', None)
        self.data_disks = kwargs.get('data_disks', None)


class UpdateResource(Model):
    """The Update Resource model definition.

    :param tags: Resource tags
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(UpdateResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class UpgradePolicy(Model):
    """Describes an upgrade policy - automatic or manual.

    :param mode: Specifies the mode of an upgrade to virtual machines in the
     scale set.<br /><br /> Possible values are:<br /><br /> **Manual** - You
     control the application of updates to virtual machines in the scale set.
     You do this by using the manualUpgrade action.<br /><br /> **Automatic** -
     All virtual machines in the scale set are  automatically updated at the
     same time. Possible values include: 'Automatic', 'Manual'
    :type mode: str or ~azure.mgmt.compute.v2015_06_15.models.UpgradeMode
    """

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'UpgradeMode'},
    }

    def __init__(self, **kwargs):
        super(UpgradePolicy, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)


class Usage(Model):
    """Describes Compute Resource Usage.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar unit: Required. An enum describing the unit of usage measurement.
     Default value: "Count" .
    :vartype unit: str
    :param current_value: Required. The current usage of the resource.
    :type current_value: int
    :param limit: Required. The maximum permitted usage of the resource.
    :type limit: long
    :param name: Required. The name of the type of usage.
    :type name: ~azure.mgmt.compute.v2015_06_15.models.UsageName
    """

    _validation = {
        'unit': {'required': True, 'constant': True},
        'current_value': {'required': True},
        'limit': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'int'},
        'limit': {'key': 'limit', 'type': 'long'},
        'name': {'key': 'name', 'type': 'UsageName'},
    }

    unit = "Count"

    def __init__(self, **kwargs):
        super(Usage, self).__init__(**kwargs)
        self.current_value = kwargs.get('current_value', None)
        self.limit = kwargs.get('limit', None)
        self.name = kwargs.get('name', None)


class UsageName(Model):
    """The Usage Names.

    :param value: The name of the resource.
    :type value: str
    :param localized_value: The localized name of the resource.
    :type localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UsageName, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.localized_value = kwargs.get('localized_value', None)


class VaultCertificate(Model):
    """Describes a single certificate reference in a Key Vault, and where the
    certificate should reside on the VM.

    :param certificate_url: This is the URL of a certificate that has been
     uploaded to Key Vault as a secret. For adding a secret to the Key Vault,
     see [Add a key or secret to the key
     vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add).
     In this case, your certificate needs to be It is the Base64 encoding of
     the following JSON Object which is encoded in UTF-8: <br><br> {<br>
     "data":"<Base64-encoded-certificate>",<br>  "dataType":"pfx",<br>
     "password":"<pfx-file-password>"<br>}
    :type certificate_url: str
    :param certificate_store: For Windows VMs, specifies the certificate store
     on the Virtual Machine to which the certificate should be added. The
     specified certificate store is implicitly in the LocalMachine account.
     <br><br>For Linux VMs, the certificate file is placed under the
     /var/lib/waagent directory, with the file name
     &lt;UppercaseThumbprint&gt;.crt for the X509 certificate file and
     &lt;UppercaseThumbprint&gt;.prv for private key. Both of these files are
     .pem formatted.
    :type certificate_store: str
    """

    _attribute_map = {
        'certificate_url': {'key': 'certificateUrl', 'type': 'str'},
        'certificate_store': {'key': 'certificateStore', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VaultCertificate, self).__init__(**kwargs)
        self.certificate_url = kwargs.get('certificate_url', None)
        self.certificate_store = kwargs.get('certificate_store', None)


class VaultSecretGroup(Model):
    """Describes a set of certificates which are all in the same Key Vault.

    :param source_vault: The relative URL of the Key Vault containing all of
     the certificates in VaultCertificates.
    :type source_vault: ~azure.mgmt.compute.v2015_06_15.models.SubResource
    :param vault_certificates: The list of key vault references in SourceVault
     which contain certificates.
    :type vault_certificates:
     list[~azure.mgmt.compute.v2015_06_15.models.VaultCertificate]
    """

    _attribute_map = {
        'source_vault': {'key': 'sourceVault', 'type': 'SubResource'},
        'vault_certificates': {'key': 'vaultCertificates', 'type': '[VaultCertificate]'},
    }

    def __init__(self, **kwargs):
        super(VaultSecretGroup, self).__init__(**kwargs)
        self.source_vault = kwargs.get('source_vault', None)
        self.vault_certificates = kwargs.get('vault_certificates', None)


class VirtualHardDisk(Model):
    """Describes the uri of a disk.

    :param uri: Specifies the virtual hard disk's uri.
    :type uri: str
    """

    _attribute_map = {
        'uri': {'key': 'uri', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VirtualHardDisk, self).__init__(**kwargs)
        self.uri = kwargs.get('uri', None)


class VirtualMachine(Resource):
    """Describes a Virtual Machine.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param plan: Specifies information about the marketplace image used to
     create the virtual machine. This element is only used for marketplace
     images. Before you can use a marketplace image from an API, you must
     enable the image for programmatic use.  In the Azure portal, find the
     marketplace image that you want to use and then click **Want to deploy
     programmatically, Get Started ->**. Enter any required information and
     then click **Save**.
    :type plan: ~azure.mgmt.compute.v2015_06_15.models.Plan
    :param hardware_profile: Specifies the hardware settings for the virtual
     machine.
    :type hardware_profile:
     ~azure.mgmt.compute.v2015_06_15.models.HardwareProfile
    :param storage_profile: Specifies the storage settings for the virtual
     machine disks.
    :type storage_profile:
     ~azure.mgmt.compute.v2015_06_15.models.StorageProfile
    :param os_profile: Specifies the operating system settings for the virtual
     machine.
    :type os_profile: ~azure.mgmt.compute.v2015_06_15.models.OSProfile
    :param network_profile: Specifies the network interfaces of the virtual
     machine.
    :type network_profile:
     ~azure.mgmt.compute.v2015_06_15.models.NetworkProfile
    :param diagnostics_profile: Specifies the boot diagnostic settings state.
     <br><br>Minimum api-version: 2015-06-15.
    :type diagnostics_profile:
     ~azure.mgmt.compute.v2015_06_15.models.DiagnosticsProfile
    :param availability_set: Specifies information about the availability set
     that the virtual machine should be assigned to. Virtual machines specified
     in the same availability set are allocated to different nodes to maximize
     availability. For more information about availability sets, see [Manage
     the availability of virtual
     machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-manage-availability?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
     <br><br> For more information on Azure planned maintenance, see [Planned
     maintenance for virtual machines in
     Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-planned-maintenance?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json)
     <br><br> Currently, a VM can only be added to availability set at creation
     time. An existing VM cannot be added to an availability set.
    :type availability_set: ~azure.mgmt.compute.v2015_06_15.models.SubResource
    :ivar provisioning_state: The provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar instance_view: The virtual machine instance view.
    :vartype instance_view:
     ~azure.mgmt.compute.v2015_06_15.models.VirtualMachineInstanceView
    :param license_type: Specifies that the image or disk that is being used
     was licensed on-premises. This element is only used for images that
     contain the Windows Server operating system. <br><br> Possible values are:
     <br><br> Windows_Client <br><br> Windows_Server <br><br> If this element
     is included in a request for an update, the value must match the initial
     value. This value cannot be updated. <br><br> For more information, see
     [Azure Hybrid Use Benefit for Windows
     Server](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-hybrid-use-benefit-licensing?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json)
     <br><br> Minimum api-version: 2015-06-15
    :type license_type: str
    :ivar resources: The virtual machine child extension resources.
    :vartype resources:
     list[~azure.mgmt.compute.v2015_06_15.models.VirtualMachineExtension]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'instance_view': {'readonly': True},
        'resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'plan': {'key': 'plan', 'type': 'Plan'},
        'hardware_profile': {'key': 'properties.hardwareProfile', 'type': 'HardwareProfile'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'StorageProfile'},
        'os_profile': {'key': 'properties.osProfile', 'type': 'OSProfile'},
        'network_profile': {'key': 'properties.networkProfile', 'type': 'NetworkProfile'},
        'diagnostics_profile': {'key': 'properties.diagnosticsProfile', 'type': 'DiagnosticsProfile'},
        'availability_set': {'key': 'properties.availabilitySet', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'VirtualMachineInstanceView'},
        'license_type': {'key': 'properties.licenseType', 'type': 'str'},
        'resources': {'key': 'resources', 'type': '[VirtualMachineExtension]'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachine, self).__init__(**kwargs)
        self.plan = kwargs.get('plan', None)
        self.hardware_profile = kwargs.get('hardware_profile', None)
        self.storage_profile = kwargs.get('storage_profile', None)
        self.os_profile = kwargs.get('os_profile', None)
        self.network_profile = kwargs.get('network_profile', None)
        self.diagnostics_profile = kwargs.get('diagnostics_profile', None)
        self.availability_set = kwargs.get('availability_set', None)
        self.provisioning_state = None
        self.instance_view = None
        self.license_type = kwargs.get('license_type', None)
        self.resources = None


class VirtualMachineAgentInstanceView(Model):
    """The instance view of the VM Agent running on the virtual machine.

    :param vm_agent_version: The VM Agent full version.
    :type vm_agent_version: str
    :param extension_handlers: The virtual machine extension handler instance
     view.
    :type extension_handlers:
     list[~azure.mgmt.compute.v2015_06_15.models.VirtualMachineExtensionHandlerInstanceView]
    :param statuses: The resource status information.
    :type statuses:
     list[~azure.mgmt.compute.v2015_06_15.models.InstanceViewStatus]
    """

    _attribute_map = {
        'vm_agent_version': {'key': 'vmAgentVersion', 'type': 'str'},
        'extension_handlers': {'key': 'extensionHandlers', 'type': '[VirtualMachineExtensionHandlerInstanceView]'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineAgentInstanceView, self).__init__(**kwargs)
        self.vm_agent_version = kwargs.get('vm_agent_version', None)
        self.extension_handlers = kwargs.get('extension_handlers', None)
        self.statuses = kwargs.get('statuses', None)


class VirtualMachineCaptureParameters(Model):
    """Capture Virtual Machine parameters.

    All required parameters must be populated in order to send to Azure.

    :param vhd_prefix: Required. The captured virtual hard disk's name prefix.
    :type vhd_prefix: str
    :param destination_container_name: Required. The destination container
     name.
    :type destination_container_name: str
    :param overwrite_vhds: Required. Specifies whether to overwrite the
     destination virtual hard disk, in case of conflict.
    :type overwrite_vhds: bool
    """

    _validation = {
        'vhd_prefix': {'required': True},
        'destination_container_name': {'required': True},
        'overwrite_vhds': {'required': True},
    }

    _attribute_map = {
        'vhd_prefix': {'key': 'vhdPrefix', 'type': 'str'},
        'destination_container_name': {'key': 'destinationContainerName', 'type': 'str'},
        'overwrite_vhds': {'key': 'overwriteVhds', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineCaptureParameters, self).__init__(**kwargs)
        self.vhd_prefix = kwargs.get('vhd_prefix', None)
        self.destination_container_name = kwargs.get('destination_container_name', None)
        self.overwrite_vhds = kwargs.get('overwrite_vhds', None)


class VirtualMachineCaptureResult(SubResource):
    """Resource Id.

    :param id: Resource Id
    :type id: str
    :param output: Operation output data (raw JSON)
    :type output: object
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'output': {'key': 'properties.output', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineCaptureResult, self).__init__(**kwargs)
        self.output = kwargs.get('output', None)


class VirtualMachineExtension(Resource):
    """Describes a Virtual Machine Extension.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param force_update_tag: How the extension handler should be forced to
     update even if the extension configuration has not changed.
    :type force_update_tag: str
    :param publisher: The name of the extension handler publisher.
    :type publisher: str
    :param virtual_machine_extension_type: Specifies the type of the
     extension; an example is "CustomScriptExtension".
    :type virtual_machine_extension_type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Indicates whether the extension should
     use a newer minor version if one is available at deployment time. Once
     deployed, however, the extension will not upgrade minor versions unless
     redeployed, even with this property set to true.
    :type auto_upgrade_minor_version: bool
    :param settings: Json formatted public settings for the extension.
    :type settings: object
    :param protected_settings: The extension can contain either
     protectedSettings or protectedSettingsFromKeyVault or no protected
     settings at all.
    :type protected_settings: object
    :ivar provisioning_state: The provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :param instance_view: The virtual machine extension instance view.
    :type instance_view:
     ~azure.mgmt.compute.v2015_06_15.models.VirtualMachineExtensionInstanceView
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'force_update_tag': {'key': 'properties.forceUpdateTag', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'virtual_machine_extension_type': {'key': 'properties.type', 'type': 'str'},
        'type_handler_version': {'key': 'properties.typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': 'object'},
        'protected_settings': {'key': 'properties.protectedSettings', 'type': 'object'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'VirtualMachineExtensionInstanceView'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineExtension, self).__init__(**kwargs)
        self.force_update_tag = kwargs.get('force_update_tag', None)
        self.publisher = kwargs.get('publisher', None)
        self.virtual_machine_extension_type = kwargs.get('virtual_machine_extension_type', None)
        self.type_handler_version = kwargs.get('type_handler_version', None)
        self.auto_upgrade_minor_version = kwargs.get('auto_upgrade_minor_version', None)
        self.settings = kwargs.get('settings', None)
        self.protected_settings = kwargs.get('protected_settings', None)
        self.provisioning_state = None
        self.instance_view = kwargs.get('instance_view', None)


class VirtualMachineExtensionHandlerInstanceView(Model):
    """The instance view of a virtual machine extension handler.

    :param type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :type type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param status: The extension handler status.
    :type status: ~azure.mgmt.compute.v2015_06_15.models.InstanceViewStatus
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'type_handler_version': {'key': 'typeHandlerVersion', 'type': 'str'},
        'status': {'key': 'status', 'type': 'InstanceViewStatus'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineExtensionHandlerInstanceView, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.type_handler_version = kwargs.get('type_handler_version', None)
        self.status = kwargs.get('status', None)


class VirtualMachineExtensionImage(Resource):
    """Describes a Virtual Machine Extension Image.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param operating_system: Required. The operating system this extension
     supports.
    :type operating_system: str
    :param compute_role: Required. The type of role (IaaS or PaaS) this
     extension supports.
    :type compute_role: str
    :param handler_schema: Required. The schema defined by publisher, where
     extension consumers should provide settings in a matching schema.
    :type handler_schema: str
    :param vm_scale_set_enabled: Whether the extension can be used on xRP
     VMScaleSets. By default existing extensions are usable on scalesets, but
     there might be cases where a publisher wants to explicitly indicate the
     extension is only enabled for CRP VMs but not VMSS.
    :type vm_scale_set_enabled: bool
    :param supports_multiple_extensions: Whether the handler can support
     multiple extensions.
    :type supports_multiple_extensions: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'operating_system': {'required': True},
        'compute_role': {'required': True},
        'handler_schema': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'operating_system': {'key': 'properties.operatingSystem', 'type': 'str'},
        'compute_role': {'key': 'properties.computeRole', 'type': 'str'},
        'handler_schema': {'key': 'properties.handlerSchema', 'type': 'str'},
        'vm_scale_set_enabled': {'key': 'properties.vmScaleSetEnabled', 'type': 'bool'},
        'supports_multiple_extensions': {'key': 'properties.supportsMultipleExtensions', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineExtensionImage, self).__init__(**kwargs)
        self.operating_system = kwargs.get('operating_system', None)
        self.compute_role = kwargs.get('compute_role', None)
        self.handler_schema = kwargs.get('handler_schema', None)
        self.vm_scale_set_enabled = kwargs.get('vm_scale_set_enabled', None)
        self.supports_multiple_extensions = kwargs.get('supports_multiple_extensions', None)


class VirtualMachineExtensionInstanceView(Model):
    """The instance view of a virtual machine extension.

    :param name: The virtual machine extension name.
    :type name: str
    :param type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :type type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param substatuses: The resource status information.
    :type substatuses:
     list[~azure.mgmt.compute.v2015_06_15.models.InstanceViewStatus]
    :param statuses: The resource status information.
    :type statuses:
     list[~azure.mgmt.compute.v2015_06_15.models.InstanceViewStatus]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'type_handler_version': {'key': 'typeHandlerVersion', 'type': 'str'},
        'substatuses': {'key': 'substatuses', 'type': '[InstanceViewStatus]'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineExtensionInstanceView, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = kwargs.get('type', None)
        self.type_handler_version = kwargs.get('type_handler_version', None)
        self.substatuses = kwargs.get('substatuses', None)
        self.statuses = kwargs.get('statuses', None)


class VirtualMachineExtensionUpdate(UpdateResource):
    """Describes a Virtual Machine Extension.

    :param tags: Resource tags
    :type tags: dict[str, str]
    :param force_update_tag: How the extension handler should be forced to
     update even if the extension configuration has not changed.
    :type force_update_tag: str
    :param publisher: The name of the extension handler publisher.
    :type publisher: str
    :param type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :type type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Indicates whether the extension should
     use a newer minor version if one is available at deployment time. Once
     deployed, however, the extension will not upgrade minor versions unless
     redeployed, even with this property set to true.
    :type auto_upgrade_minor_version: bool
    :param settings: Json formatted public settings for the extension.
    :type settings: object
    :param protected_settings: The extension can contain either
     protectedSettings or protectedSettingsFromKeyVault or no protected
     settings at all.
    :type protected_settings: object
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'force_update_tag': {'key': 'properties.forceUpdateTag', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'type': {'key': 'properties.type', 'type': 'str'},
        'type_handler_version': {'key': 'properties.typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': 'object'},
        'protected_settings': {'key': 'properties.protectedSettings', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineExtensionUpdate, self).__init__(**kwargs)
        self.force_update_tag = kwargs.get('force_update_tag', None)
        self.publisher = kwargs.get('publisher', None)
        self.type = kwargs.get('type', None)
        self.type_handler_version = kwargs.get('type_handler_version', None)
        self.auto_upgrade_minor_version = kwargs.get('auto_upgrade_minor_version', None)
        self.settings = kwargs.get('settings', None)
        self.protected_settings = kwargs.get('protected_settings', None)


class VirtualMachineImageResource(SubResource):
    """Virtual machine image resource information.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource Id
    :type id: str
    :param name: Required. The name of the resource.
    :type name: str
    :param location: Required. The supported Azure location of the resource.
    :type location: str
    :param tags: Specifies the tags that are assigned to the virtual machine.
     For more information about using tags, see [Using tags to organize your
     Azure
     resources](https://docs.microsoft.com/azure/azure-resource-manager/resource-group-using-tags.md).
    :type tags: dict[str, str]
    """

    _validation = {
        'name': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineImageResource, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class VirtualMachineImage(VirtualMachineImageResource):
    """Describes a Virtual Machine Image.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource Id
    :type id: str
    :param name: Required. The name of the resource.
    :type name: str
    :param location: Required. The supported Azure location of the resource.
    :type location: str
    :param tags: Specifies the tags that are assigned to the virtual machine.
     For more information about using tags, see [Using tags to organize your
     Azure
     resources](https://docs.microsoft.com/azure/azure-resource-manager/resource-group-using-tags.md).
    :type tags: dict[str, str]
    :param plan:
    :type plan: ~azure.mgmt.compute.v2015_06_15.models.PurchasePlan
    :param os_disk_image:
    :type os_disk_image: ~azure.mgmt.compute.v2015_06_15.models.OSDiskImage
    :param data_disk_images:
    :type data_disk_images:
     list[~azure.mgmt.compute.v2015_06_15.models.DataDiskImage]
    """

    _validation = {
        'name': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'plan': {'key': 'properties.plan', 'type': 'PurchasePlan'},
        'os_disk_image': {'key': 'properties.osDiskImage', 'type': 'OSDiskImage'},
        'data_disk_images': {'key': 'properties.dataDiskImages', 'type': '[DataDiskImage]'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineImage, self).__init__(**kwargs)
        self.plan = kwargs.get('plan', None)
        self.os_disk_image = kwargs.get('os_disk_image', None)
        self.data_disk_images = kwargs.get('data_disk_images', None)


class VirtualMachineInstanceView(Model):
    """The instance view of a virtual machine.

    :param platform_update_domain: Specifies the update domain of the virtual
     machine.
    :type platform_update_domain: int
    :param platform_fault_domain: Specifies the fault domain of the virtual
     machine.
    :type platform_fault_domain: int
    :param rdp_thumb_print: The Remote desktop certificate thumbprint.
    :type rdp_thumb_print: str
    :param vm_agent: The VM Agent running on the virtual machine.
    :type vm_agent:
     ~azure.mgmt.compute.v2015_06_15.models.VirtualMachineAgentInstanceView
    :param disks: The virtual machine disk information.
    :type disks: list[~azure.mgmt.compute.v2015_06_15.models.DiskInstanceView]
    :param extensions: The extensions information.
    :type extensions:
     list[~azure.mgmt.compute.v2015_06_15.models.VirtualMachineExtensionInstanceView]
    :param boot_diagnostics: Boot Diagnostics is a debugging feature which
     allows you to view Console Output and Screenshot to diagnose VM status.
     <br><br> You can easily view the output of your console log. <br><br>
     Azure also enables you to see a screenshot of the VM from the hypervisor.
    :type boot_diagnostics:
     ~azure.mgmt.compute.v2015_06_15.models.BootDiagnosticsInstanceView
    :param statuses: The resource status information.
    :type statuses:
     list[~azure.mgmt.compute.v2015_06_15.models.InstanceViewStatus]
    """

    _attribute_map = {
        'platform_update_domain': {'key': 'platformUpdateDomain', 'type': 'int'},
        'platform_fault_domain': {'key': 'platformFaultDomain', 'type': 'int'},
        'rdp_thumb_print': {'key': 'rdpThumbPrint', 'type': 'str'},
        'vm_agent': {'key': 'vmAgent', 'type': 'VirtualMachineAgentInstanceView'},
        'disks': {'key': 'disks', 'type': '[DiskInstanceView]'},
        'extensions': {'key': 'extensions', 'type': '[VirtualMachineExtensionInstanceView]'},
        'boot_diagnostics': {'key': 'bootDiagnostics', 'type': 'BootDiagnosticsInstanceView'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineInstanceView, self).__init__(**kwargs)
        self.platform_update_domain = kwargs.get('platform_update_domain', None)
        self.platform_fault_domain = kwargs.get('platform_fault_domain', None)
        self.rdp_thumb_print = kwargs.get('rdp_thumb_print', None)
        self.vm_agent = kwargs.get('vm_agent', None)
        self.disks = kwargs.get('disks', None)
        self.extensions = kwargs.get('extensions', None)
        self.boot_diagnostics = kwargs.get('boot_diagnostics', None)
        self.statuses = kwargs.get('statuses', None)


class VirtualMachineScaleSet(Resource):
    """Describes a Virtual Machine Scale Set.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param sku: The virtual machine scale set sku.
    :type sku: ~azure.mgmt.compute.v2015_06_15.models.Sku
    :param upgrade_policy: The upgrade policy.
    :type upgrade_policy: ~azure.mgmt.compute.v2015_06_15.models.UpgradePolicy
    :param virtual_machine_profile: The virtual machine profile.
    :type virtual_machine_profile:
     ~azure.mgmt.compute.v2015_06_15.models.VirtualMachineScaleSetVMProfile
    :param provisioning_state: The provisioning state, which only appears in
     the response.
    :type provisioning_state: str
    :param over_provision: Specifies whether the Virtual Machine Scale Set
     should be overprovisioned.
    :type over_provision: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'upgrade_policy': {'key': 'properties.upgradePolicy', 'type': 'UpgradePolicy'},
        'virtual_machine_profile': {'key': 'properties.virtualMachineProfile', 'type': 'VirtualMachineScaleSetVMProfile'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'over_provision': {'key': 'properties.overProvision', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineScaleSet, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.upgrade_policy = kwargs.get('upgrade_policy', None)
        self.virtual_machine_profile = kwargs.get('virtual_machine_profile', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.over_provision = kwargs.get('over_provision', None)


class VirtualMachineScaleSetExtension(SubResource):
    """Describes a Virtual Machine Scale Set Extension.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource Id
    :type id: str
    :param name: The name of the extension.
    :type name: str
    :param publisher: The name of the extension handler publisher.
    :type publisher: str
    :param type: The type of the extension handler.
    :type type: str
    :param type_handler_version: The type version of the extension handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Whether the extension handler should be
     automatically upgraded across minor versions.
    :type auto_upgrade_minor_version: bool
    :param settings: Json formatted public settings for the extension.
    :type settings: object
    :param protected_settings: Json formatted protected settings for the
     extension.
    :type protected_settings: object
    :ivar provisioning_state: The provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'type': {'key': 'properties.type', 'type': 'str'},
        'type_handler_version': {'key': 'properties.typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': 'object'},
        'protected_settings': {'key': 'properties.protectedSettings', 'type': 'object'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineScaleSetExtension, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.publisher = kwargs.get('publisher', None)
        self.type = kwargs.get('type', None)
        self.type_handler_version = kwargs.get('type_handler_version', None)
        self.auto_upgrade_minor_version = kwargs.get('auto_upgrade_minor_version', None)
        self.settings = kwargs.get('settings', None)
        self.protected_settings = kwargs.get('protected_settings', None)
        self.provisioning_state = None


class VirtualMachineScaleSetExtensionProfile(Model):
    """Describes a virtual machine scale set extension profile.

    :param extensions: The virtual machine scale set child extension
     resources.
    :type extensions:
     list[~azure.mgmt.compute.v2015_06_15.models.VirtualMachineScaleSetExtension]
    """

    _attribute_map = {
        'extensions': {'key': 'extensions', 'type': '[VirtualMachineScaleSetExtension]'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineScaleSetExtensionProfile, self).__init__(**kwargs)
        self.extensions = kwargs.get('extensions', None)


class VirtualMachineScaleSetInstanceView(Model):
    """The instance view of a virtual machine scale set.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar virtual_machine: The instance view status summary for the virtual
     machine scale set.
    :vartype virtual_machine:
     ~azure.mgmt.compute.v2015_06_15.models.VirtualMachineScaleSetInstanceViewStatusesSummary
    :ivar extensions: The extensions information.
    :vartype extensions:
     list[~azure.mgmt.compute.v2015_06_15.models.VirtualMachineScaleSetVMExtensionsSummary]
    :param statuses: The resource status information.
    :type statuses:
     list[~azure.mgmt.compute.v2015_06_15.models.InstanceViewStatus]
    """

    _validation = {
        'virtual_machine': {'readonly': True},
        'extensions': {'readonly': True},
    }

    _attribute_map = {
        'virtual_machine': {'key': 'virtualMachine', 'type': 'VirtualMachineScaleSetInstanceViewStatusesSummary'},
        'extensions': {'key': 'extensions', 'type': '[VirtualMachineScaleSetVMExtensionsSummary]'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineScaleSetInstanceView, self).__init__(**kwargs)
        self.virtual_machine = None
        self.extensions = None
        self.statuses = kwargs.get('statuses', None)


class VirtualMachineScaleSetInstanceViewStatusesSummary(Model):
    """Instance view statuses summary for virtual machines of a virtual machine
    scale set.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar statuses_summary: The extensions information.
    :vartype statuses_summary:
     list[~azure.mgmt.compute.v2015_06_15.models.VirtualMachineStatusCodeCount]
    """

    _validation = {
        'statuses_summary': {'readonly': True},
    }

    _attribute_map = {
        'statuses_summary': {'key': 'statusesSummary', 'type': '[VirtualMachineStatusCodeCount]'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineScaleSetInstanceViewStatusesSummary, self).__init__(**kwargs)
        self.statuses_summary = None


class VirtualMachineScaleSetIPConfiguration(SubResource):
    """Describes a virtual machine scale set network profile's IP configuration.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource Id
    :type id: str
    :param name: Required. The IP configuration name.
    :type name: str
    :param subnet: Required. The subnet.
    :type subnet: ~azure.mgmt.compute.v2015_06_15.models.ApiEntityReference
    :param load_balancer_backend_address_pools: The load balancer backend
     address pools.
    :type load_balancer_backend_address_pools:
     list[~azure.mgmt.compute.v2015_06_15.models.SubResource]
    :param load_balancer_inbound_nat_pools: The load balancer inbound nat
     pools.
    :type load_balancer_inbound_nat_pools:
     list[~azure.mgmt.compute.v2015_06_15.models.SubResource]
    """

    _validation = {
        'name': {'required': True},
        'subnet': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'ApiEntityReference'},
        'load_balancer_backend_address_pools': {'key': 'properties.loadBalancerBackendAddressPools', 'type': '[SubResource]'},
        'load_balancer_inbound_nat_pools': {'key': 'properties.loadBalancerInboundNatPools', 'type': '[SubResource]'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineScaleSetIPConfiguration, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.subnet = kwargs.get('subnet', None)
        self.load_balancer_backend_address_pools = kwargs.get('load_balancer_backend_address_pools', None)
        self.load_balancer_inbound_nat_pools = kwargs.get('load_balancer_inbound_nat_pools', None)


class VirtualMachineScaleSetNetworkConfiguration(SubResource):
    """Describes a virtual machine scale set network profile's network
    configurations.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource Id
    :type id: str
    :param name: Required. The network configuration name.
    :type name: str
    :param primary: Whether this is a primary NIC on a virtual machine.
    :type primary: bool
    :param ip_configurations: Required. The virtual machine scale set IP
     Configuration.
    :type ip_configurations:
     list[~azure.mgmt.compute.v2015_06_15.models.VirtualMachineScaleSetIPConfiguration]
    """

    _validation = {
        'name': {'required': True},
        'ip_configurations': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[VirtualMachineScaleSetIPConfiguration]'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineScaleSetNetworkConfiguration, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.primary = kwargs.get('primary', None)
        self.ip_configurations = kwargs.get('ip_configurations', None)


class VirtualMachineScaleSetNetworkProfile(Model):
    """Describes a virtual machine scale set network profile.

    :param network_interface_configurations: The list of network
     configurations.
    :type network_interface_configurations:
     list[~azure.mgmt.compute.v2015_06_15.models.VirtualMachineScaleSetNetworkConfiguration]
    """

    _attribute_map = {
        'network_interface_configurations': {'key': 'networkInterfaceConfigurations', 'type': '[VirtualMachineScaleSetNetworkConfiguration]'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineScaleSetNetworkProfile, self).__init__(**kwargs)
        self.network_interface_configurations = kwargs.get('network_interface_configurations', None)


class VirtualMachineScaleSetOSDisk(Model):
    """Describes a virtual machine scale set operating system disk.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The disk name.
    :type name: str
    :param caching: Specifies the caching requirements. <br><br> Possible
     values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite**
     <br><br> Default: **None for Standard storage. ReadOnly for Premium
     storage**. Possible values include: 'None', 'ReadOnly', 'ReadWrite'
    :type caching: str or ~azure.mgmt.compute.v2015_06_15.models.CachingTypes
    :param create_option: Required. Specifies how the virtual machines in the
     scale set should be created.<br><br> The only allowed value is:
     **FromImage** \\u2013 This value is used when you are using an image to
     create the virtual machine. If you are using a platform image, you also
     use the imageReference element described above. If you are using a
     marketplace image, you  also use the plan element previously described.
     Possible values include: 'FromImage', 'Empty', 'Attach'
    :type create_option: str or
     ~azure.mgmt.compute.v2015_06_15.models.DiskCreateOptionTypes
    :param os_type: This property allows you to specify the type of the OS
     that is included in the disk if creating a VM from user-image or a
     specialized VHD. <br><br> Possible values are: <br><br> **Windows**
     <br><br> **Linux**. Possible values include: 'Windows', 'Linux'
    :type os_type: str or
     ~azure.mgmt.compute.v2015_06_15.models.OperatingSystemTypes
    :param image: The Source User Image VirtualHardDisk. This VirtualHardDisk
     will be copied before using it to attach to the Virtual Machine. If
     SourceImage is provided, the destination VirtualHardDisk should not exist.
    :type image: ~azure.mgmt.compute.v2015_06_15.models.VirtualHardDisk
    :param vhd_containers: The list of virtual hard disk container uris.
    :type vhd_containers: list[str]
    """

    _validation = {
        'name': {'required': True},
        'create_option': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'caching': {'key': 'caching', 'type': 'CachingTypes'},
        'create_option': {'key': 'createOption', 'type': 'DiskCreateOptionTypes'},
        'os_type': {'key': 'osType', 'type': 'OperatingSystemTypes'},
        'image': {'key': 'image', 'type': 'VirtualHardDisk'},
        'vhd_containers': {'key': 'vhdContainers', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineScaleSetOSDisk, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.caching = kwargs.get('caching', None)
        self.create_option = kwargs.get('create_option', None)
        self.os_type = kwargs.get('os_type', None)
        self.image = kwargs.get('image', None)
        self.vhd_containers = kwargs.get('vhd_containers', None)


class VirtualMachineScaleSetOSProfile(Model):
    """Describes a virtual machine scale set OS profile.

    :param computer_name_prefix: Specifies the computer name prefix for all of
     the virtual machines in the scale set. Computer name prefixes must be 1 to
     15 characters long.
    :type computer_name_prefix: str
    :param admin_username: Specifies the name of the administrator account.
     <br><br> **Windows-only restriction:** Cannot end in "." <br><br>
     **Disallowed values:** "administrator", "admin", "user", "user1", "test",
     "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm",
     "admin2", "aspnet", "backup", "console", "david", "guest", "john",
     "owner", "root", "server", "sql", "support", "support_388945a0", "sys",
     "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1
     character <br><br> **Max-length (Linux):** 64 characters <br><br>
     **Max-length (Windows):** 20 characters  <br><br><li> For root access to
     the Linux VM, see [Using root privileges on Linux virtual machines in
     Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)<br><li>
     For a list of built-in system users on Linux that should not be used in
     this field, see [Selecting User Names for Linux on
     Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
    :type admin_username: str
    :param admin_password: Specifies the password of the administrator
     account. <br><br> **Minimum-length (Windows):** 8 characters <br><br>
     **Minimum-length (Linux):** 6 characters <br><br> **Max-length
     (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters
     <br><br> **Complexity requirements:** 3 out of 4 conditions below need to
     be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a
     digit <br> Has a special character (Regex match [\\W_]) <br><br>
     **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123",
     "Pa$$word", "pass@word1", "Password!", "Password1", "Password22",
     "iloveyou!" <br><br> For resetting the password, see [How to reset the
     Remote Desktop service or its login password in a Windows
     VM](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-reset-rdp?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json)
     <br><br> For resetting root password, see [Manage users, SSH, and check or
     repair disks on Azure Linux VMs using the VMAccess
     Extension](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-vmaccess-extension?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#reset-root-password)
    :type admin_password: str
    :param custom_data: A base-64 encoded string of custom data.
    :type custom_data: str
    :param windows_configuration: The Windows Configuration of the OS profile.
    :type windows_configuration:
     ~azure.mgmt.compute.v2015_06_15.models.WindowsConfiguration
    :param linux_configuration: The Linux Configuration of the OS profile.
    :type linux_configuration:
     ~azure.mgmt.compute.v2015_06_15.models.LinuxConfiguration
    :param secrets: The List of certificates for addition to the VM.
    :type secrets:
     list[~azure.mgmt.compute.v2015_06_15.models.VaultSecretGroup]
    """

    _attribute_map = {
        'computer_name_prefix': {'key': 'computerNamePrefix', 'type': 'str'},
        'admin_username': {'key': 'adminUsername', 'type': 'str'},
        'admin_password': {'key': 'adminPassword', 'type': 'str'},
        'custom_data': {'key': 'customData', 'type': 'str'},
        'windows_configuration': {'key': 'windowsConfiguration', 'type': 'WindowsConfiguration'},
        'linux_configuration': {'key': 'linuxConfiguration', 'type': 'LinuxConfiguration'},
        'secrets': {'key': 'secrets', 'type': '[VaultSecretGroup]'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineScaleSetOSProfile, self).__init__(**kwargs)
        self.computer_name_prefix = kwargs.get('computer_name_prefix', None)
        self.admin_username = kwargs.get('admin_username', None)
        self.admin_password = kwargs.get('admin_password', None)
        self.custom_data = kwargs.get('custom_data', None)
        self.windows_configuration = kwargs.get('windows_configuration', None)
        self.linux_configuration = kwargs.get('linux_configuration', None)
        self.secrets = kwargs.get('secrets', None)


class VirtualMachineScaleSetSku(Model):
    """Describes an available virtual machine scale set sku.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar resource_type: The type of resource the sku applies to.
    :vartype resource_type: str
    :ivar sku: The Sku.
    :vartype sku: ~azure.mgmt.compute.v2015_06_15.models.Sku
    :ivar capacity: Specifies the number of virtual machines in the scale set.
    :vartype capacity:
     ~azure.mgmt.compute.v2015_06_15.models.VirtualMachineScaleSetSkuCapacity
    """

    _validation = {
        'resource_type': {'readonly': True},
        'sku': {'readonly': True},
        'capacity': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'capacity': {'key': 'capacity', 'type': 'VirtualMachineScaleSetSkuCapacity'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineScaleSetSku, self).__init__(**kwargs)
        self.resource_type = None
        self.sku = None
        self.capacity = None


class VirtualMachineScaleSetSkuCapacity(Model):
    """Describes scaling information of a sku.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar minimum: The minimum capacity.
    :vartype minimum: long
    :ivar maximum: The maximum capacity that can be set.
    :vartype maximum: long
    :ivar default_capacity: The default capacity.
    :vartype default_capacity: long
    :ivar scale_type: The scale type applicable to the sku. Possible values
     include: 'Automatic', 'None'
    :vartype scale_type: str or
     ~azure.mgmt.compute.v2015_06_15.models.VirtualMachineScaleSetSkuScaleType
    """

    _validation = {
        'minimum': {'readonly': True},
        'maximum': {'readonly': True},
        'default_capacity': {'readonly': True},
        'scale_type': {'readonly': True},
    }

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'long'},
        'maximum': {'key': 'maximum', 'type': 'long'},
        'default_capacity': {'key': 'defaultCapacity', 'type': 'long'},
        'scale_type': {'key': 'scaleType', 'type': 'VirtualMachineScaleSetSkuScaleType'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineScaleSetSkuCapacity, self).__init__(**kwargs)
        self.minimum = None
        self.maximum = None
        self.default_capacity = None
        self.scale_type = None


class VirtualMachineScaleSetStorageProfile(Model):
    """Describes a virtual machine scale set storage profile.

    :param image_reference: The image reference.
    :type image_reference:
     ~azure.mgmt.compute.v2015_06_15.models.ImageReference
    :param os_disk: The OS disk.
    :type os_disk:
     ~azure.mgmt.compute.v2015_06_15.models.VirtualMachineScaleSetOSDisk
    """

    _attribute_map = {
        'image_reference': {'key': 'imageReference', 'type': 'ImageReference'},
        'os_disk': {'key': 'osDisk', 'type': 'VirtualMachineScaleSetOSDisk'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineScaleSetStorageProfile, self).__init__(**kwargs)
        self.image_reference = kwargs.get('image_reference', None)
        self.os_disk = kwargs.get('os_disk', None)


class VirtualMachineScaleSetVM(Resource):
    """Describes a virtual machine scale set virtual machine.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :ivar instance_id: The virtual machine instance ID.
    :vartype instance_id: str
    :ivar sku: The virtual machine SKU.
    :vartype sku: ~azure.mgmt.compute.v2015_06_15.models.Sku
    :ivar latest_model_applied: Specifies whether the latest model has been
     applied to the virtual machine.
    :vartype latest_model_applied: bool
    :ivar instance_view: The virtual machine instance view.
    :vartype instance_view:
     ~azure.mgmt.compute.v2015_06_15.models.VirtualMachineScaleSetVMInstanceView
    :param hardware_profile: Specifies the hardware settings for the virtual
     machine.
    :type hardware_profile:
     ~azure.mgmt.compute.v2015_06_15.models.HardwareProfile
    :param storage_profile: Specifies the storage settings for the virtual
     machine disks.
    :type storage_profile:
     ~azure.mgmt.compute.v2015_06_15.models.StorageProfile
    :param os_profile: Specifies the operating system settings for the virtual
     machine.
    :type os_profile: ~azure.mgmt.compute.v2015_06_15.models.OSProfile
    :param network_profile: Specifies the network interfaces of the virtual
     machine.
    :type network_profile:
     ~azure.mgmt.compute.v2015_06_15.models.NetworkProfile
    :param diagnostics_profile: Specifies the boot diagnostic settings state.
     <br><br>Minimum api-version: 2015-06-15.
    :type diagnostics_profile:
     ~azure.mgmt.compute.v2015_06_15.models.DiagnosticsProfile
    :param availability_set: Specifies information about the availability set
     that the virtual machine should be assigned to. Virtual machines specified
     in the same availability set are allocated to different nodes to maximize
     availability. For more information about availability sets, see [Manage
     the availability of virtual
     machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-manage-availability?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
     <br><br> For more information on Azure planned maintenance, see [Planned
     maintenance for virtual machines in
     Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-planned-maintenance?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json)
     <br><br> Currently, a VM can only be added to availability set at creation
     time. An existing VM cannot be added to an availability set.
    :type availability_set: ~azure.mgmt.compute.v2015_06_15.models.SubResource
    :param provisioning_state: The provisioning state, which only appears in
     the response.
    :type provisioning_state: str
    :param license_type: Specifies that the image or disk that is being used
     was licensed on-premises. This element is only used for images that
     contain the Windows Server operating system. <br><br> Possible values are:
     <br><br> Windows_Client <br><br> Windows_Server <br><br> If this element
     is included in a request for an update, the value must match the initial
     value. This value cannot be updated. <br><br> For more information, see
     [Azure Hybrid Use Benefit for Windows
     Server](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-hybrid-use-benefit-licensing?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json)
     <br><br> Minimum api-version: 2015-06-15
    :type license_type: str
    :param plan: Specifies information about the marketplace image used to
     create the virtual machine. This element is only used for marketplace
     images. Before you can use a marketplace image from an API, you must
     enable the image for programmatic use.  In the Azure portal, find the
     marketplace image that you want to use and then click **Want to deploy
     programmatically, Get Started ->**. Enter any required information and
     then click **Save**.
    :type plan: ~azure.mgmt.compute.v2015_06_15.models.Plan
    :ivar resources: The virtual machine child extension resources.
    :vartype resources:
     list[~azure.mgmt.compute.v2015_06_15.models.VirtualMachineExtension]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'instance_id': {'readonly': True},
        'sku': {'readonly': True},
        'latest_model_applied': {'readonly': True},
        'instance_view': {'readonly': True},
        'resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'instance_id': {'key': 'instanceId', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'latest_model_applied': {'key': 'properties.latestModelApplied', 'type': 'bool'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'VirtualMachineScaleSetVMInstanceView'},
        'hardware_profile': {'key': 'properties.hardwareProfile', 'type': 'HardwareProfile'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'StorageProfile'},
        'os_profile': {'key': 'properties.osProfile', 'type': 'OSProfile'},
        'network_profile': {'key': 'properties.networkProfile', 'type': 'NetworkProfile'},
        'diagnostics_profile': {'key': 'properties.diagnosticsProfile', 'type': 'DiagnosticsProfile'},
        'availability_set': {'key': 'properties.availabilitySet', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'license_type': {'key': 'properties.licenseType', 'type': 'str'},
        'plan': {'key': 'plan', 'type': 'Plan'},
        'resources': {'key': 'resources', 'type': '[VirtualMachineExtension]'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineScaleSetVM, self).__init__(**kwargs)
        self.instance_id = None
        self.sku = None
        self.latest_model_applied = None
        self.instance_view = None
        self.hardware_profile = kwargs.get('hardware_profile', None)
        self.storage_profile = kwargs.get('storage_profile', None)
        self.os_profile = kwargs.get('os_profile', None)
        self.network_profile = kwargs.get('network_profile', None)
        self.diagnostics_profile = kwargs.get('diagnostics_profile', None)
        self.availability_set = kwargs.get('availability_set', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.license_type = kwargs.get('license_type', None)
        self.plan = kwargs.get('plan', None)
        self.resources = None


class VirtualMachineScaleSetVMExtensionsSummary(Model):
    """Extensions summary for virtual machines of a virtual machine scale set.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The extension name.
    :vartype name: str
    :ivar statuses_summary: The extensions information.
    :vartype statuses_summary:
     list[~azure.mgmt.compute.v2015_06_15.models.VirtualMachineStatusCodeCount]
    """

    _validation = {
        'name': {'readonly': True},
        'statuses_summary': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'statuses_summary': {'key': 'statusesSummary', 'type': '[VirtualMachineStatusCodeCount]'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineScaleSetVMExtensionsSummary, self).__init__(**kwargs)
        self.name = None
        self.statuses_summary = None


class VirtualMachineScaleSetVMInstanceIDs(Model):
    """Specifies a list of virtual machine instance IDs from the VM scale set.

    :param instance_ids: The virtual machine scale set instance ids. Omitting
     the virtual machine scale set instance ids will result in the operation
     being performed on all virtual machines in the virtual machine scale set.
    :type instance_ids: list[str]
    """

    _attribute_map = {
        'instance_ids': {'key': 'instanceIds', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineScaleSetVMInstanceIDs, self).__init__(**kwargs)
        self.instance_ids = kwargs.get('instance_ids', None)


class VirtualMachineScaleSetVMInstanceRequiredIDs(Model):
    """Specifies a list of virtual machine instance IDs from the VM scale set.

    All required parameters must be populated in order to send to Azure.

    :param instance_ids: Required. The virtual machine scale set instance ids.
    :type instance_ids: list[str]
    """

    _validation = {
        'instance_ids': {'required': True},
    }

    _attribute_map = {
        'instance_ids': {'key': 'instanceIds', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineScaleSetVMInstanceRequiredIDs, self).__init__(**kwargs)
        self.instance_ids = kwargs.get('instance_ids', None)


class VirtualMachineScaleSetVMInstanceView(Model):
    """The instance view of a virtual machine scale set VM.

    :param platform_update_domain: The Update Domain count.
    :type platform_update_domain: int
    :param platform_fault_domain: The Fault Domain count.
    :type platform_fault_domain: int
    :param rdp_thumb_print: The Remote desktop certificate thumbprint.
    :type rdp_thumb_print: str
    :param vm_agent: The VM Agent running on the virtual machine.
    :type vm_agent:
     ~azure.mgmt.compute.v2015_06_15.models.VirtualMachineAgentInstanceView
    :param disks: The disks information.
    :type disks: list[~azure.mgmt.compute.v2015_06_15.models.DiskInstanceView]
    :param extensions: The extensions information.
    :type extensions:
     list[~azure.mgmt.compute.v2015_06_15.models.VirtualMachineExtensionInstanceView]
    :param boot_diagnostics: Boot Diagnostics is a debugging feature which
     allows you to view Console Output and Screenshot to diagnose VM status.
     <br><br> You can easily view the output of your console log. <br><br>
     Azure also enables you to see a screenshot of the VM from the hypervisor.
    :type boot_diagnostics:
     ~azure.mgmt.compute.v2015_06_15.models.BootDiagnosticsInstanceView
    :param statuses: The resource status information.
    :type statuses:
     list[~azure.mgmt.compute.v2015_06_15.models.InstanceViewStatus]
    """

    _attribute_map = {
        'platform_update_domain': {'key': 'platformUpdateDomain', 'type': 'int'},
        'platform_fault_domain': {'key': 'platformFaultDomain', 'type': 'int'},
        'rdp_thumb_print': {'key': 'rdpThumbPrint', 'type': 'str'},
        'vm_agent': {'key': 'vmAgent', 'type': 'VirtualMachineAgentInstanceView'},
        'disks': {'key': 'disks', 'type': '[DiskInstanceView]'},
        'extensions': {'key': 'extensions', 'type': '[VirtualMachineExtensionInstanceView]'},
        'boot_diagnostics': {'key': 'bootDiagnostics', 'type': 'BootDiagnosticsInstanceView'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineScaleSetVMInstanceView, self).__init__(**kwargs)
        self.platform_update_domain = kwargs.get('platform_update_domain', None)
        self.platform_fault_domain = kwargs.get('platform_fault_domain', None)
        self.rdp_thumb_print = kwargs.get('rdp_thumb_print', None)
        self.vm_agent = kwargs.get('vm_agent', None)
        self.disks = kwargs.get('disks', None)
        self.extensions = kwargs.get('extensions', None)
        self.boot_diagnostics = kwargs.get('boot_diagnostics', None)
        self.statuses = kwargs.get('statuses', None)


class VirtualMachineScaleSetVMProfile(Model):
    """Describes a virtual machine scale set virtual machine profile.

    :param os_profile: The virtual machine scale set OS profile.
    :type os_profile:
     ~azure.mgmt.compute.v2015_06_15.models.VirtualMachineScaleSetOSProfile
    :param storage_profile: The virtual machine scale set storage profile.
    :type storage_profile:
     ~azure.mgmt.compute.v2015_06_15.models.VirtualMachineScaleSetStorageProfile
    :param network_profile: The virtual machine scale set network profile.
    :type network_profile:
     ~azure.mgmt.compute.v2015_06_15.models.VirtualMachineScaleSetNetworkProfile
    :param extension_profile: The virtual machine scale set extension profile.
    :type extension_profile:
     ~azure.mgmt.compute.v2015_06_15.models.VirtualMachineScaleSetExtensionProfile
    """

    _attribute_map = {
        'os_profile': {'key': 'osProfile', 'type': 'VirtualMachineScaleSetOSProfile'},
        'storage_profile': {'key': 'storageProfile', 'type': 'VirtualMachineScaleSetStorageProfile'},
        'network_profile': {'key': 'networkProfile', 'type': 'VirtualMachineScaleSetNetworkProfile'},
        'extension_profile': {'key': 'extensionProfile', 'type': 'VirtualMachineScaleSetExtensionProfile'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineScaleSetVMProfile, self).__init__(**kwargs)
        self.os_profile = kwargs.get('os_profile', None)
        self.storage_profile = kwargs.get('storage_profile', None)
        self.network_profile = kwargs.get('network_profile', None)
        self.extension_profile = kwargs.get('extension_profile', None)


class VirtualMachineSize(Model):
    """Describes the properties of a VM size.

    :param name: The name of the virtual machine size.
    :type name: str
    :param number_of_cores: The number of cores supported by the virtual
     machine size.
    :type number_of_cores: int
    :param os_disk_size_in_mb: The OS disk size, in MB, allowed by the virtual
     machine size.
    :type os_disk_size_in_mb: int
    :param resource_disk_size_in_mb: The resource disk size, in MB, allowed by
     the virtual machine size.
    :type resource_disk_size_in_mb: int
    :param memory_in_mb: The amount of memory, in MB, supported by the virtual
     machine size.
    :type memory_in_mb: int
    :param max_data_disk_count: The maximum number of data disks that can be
     attached to the virtual machine size.
    :type max_data_disk_count: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'number_of_cores': {'key': 'numberOfCores', 'type': 'int'},
        'os_disk_size_in_mb': {'key': 'osDiskSizeInMB', 'type': 'int'},
        'resource_disk_size_in_mb': {'key': 'resourceDiskSizeInMB', 'type': 'int'},
        'memory_in_mb': {'key': 'memoryInMB', 'type': 'int'},
        'max_data_disk_count': {'key': 'maxDataDiskCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineSize, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.number_of_cores = kwargs.get('number_of_cores', None)
        self.os_disk_size_in_mb = kwargs.get('os_disk_size_in_mb', None)
        self.resource_disk_size_in_mb = kwargs.get('resource_disk_size_in_mb', None)
        self.memory_in_mb = kwargs.get('memory_in_mb', None)
        self.max_data_disk_count = kwargs.get('max_data_disk_count', None)


class VirtualMachineStatusCodeCount(Model):
    """The status code and count of the virtual machine scale set instance view
    status summary.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: The instance view status code.
    :vartype code: str
    :ivar count: The number of instances having a particular status code.
    :vartype count: int
    """

    _validation = {
        'code': {'readonly': True},
        'count': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineStatusCodeCount, self).__init__(**kwargs)
        self.code = None
        self.count = None


class WindowsConfiguration(Model):
    """Specifies Windows operating system settings on the virtual machine.

    :param provision_vm_agent: Indicates whether virtual machine agent should
     be provisioned on the virtual machine. <br><br> When this property is not
     specified in the request body, default behavior is to set it to true.
     This will ensure that VM Agent is installed on the VM so that extensions
     can be added to the VM later.
    :type provision_vm_agent: bool
    :param enable_automatic_updates: Indicates whether virtual machine is
     enabled for automatic updates.
    :type enable_automatic_updates: bool
    :param time_zone: Specifies the time zone of the virtual machine. e.g.
     "Pacific Standard Time"
    :type time_zone: str
    :param additional_unattend_content: Specifies additional base-64 encoded
     XML formatted information that can be included in the Unattend.xml file,
     which is used by Windows Setup.
    :type additional_unattend_content:
     list[~azure.mgmt.compute.v2015_06_15.models.AdditionalUnattendContent]
    :param win_rm: Specifies the Windows Remote Management listeners. This
     enables remote Windows PowerShell.
    :type win_rm: ~azure.mgmt.compute.v2015_06_15.models.WinRMConfiguration
    """

    _attribute_map = {
        'provision_vm_agent': {'key': 'provisionVMAgent', 'type': 'bool'},
        'enable_automatic_updates': {'key': 'enableAutomaticUpdates', 'type': 'bool'},
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'additional_unattend_content': {'key': 'additionalUnattendContent', 'type': '[AdditionalUnattendContent]'},
        'win_rm': {'key': 'winRM', 'type': 'WinRMConfiguration'},
    }

    def __init__(self, **kwargs):
        super(WindowsConfiguration, self).__init__(**kwargs)
        self.provision_vm_agent = kwargs.get('provision_vm_agent', None)
        self.enable_automatic_updates = kwargs.get('enable_automatic_updates', None)
        self.time_zone = kwargs.get('time_zone', None)
        self.additional_unattend_content = kwargs.get('additional_unattend_content', None)
        self.win_rm = kwargs.get('win_rm', None)


class WinRMConfiguration(Model):
    """Describes Windows Remote Management configuration of the VM.

    :param listeners: The list of Windows Remote Management listeners
    :type listeners:
     list[~azure.mgmt.compute.v2015_06_15.models.WinRMListener]
    """

    _attribute_map = {
        'listeners': {'key': 'listeners', 'type': '[WinRMListener]'},
    }

    def __init__(self, **kwargs):
        super(WinRMConfiguration, self).__init__(**kwargs)
        self.listeners = kwargs.get('listeners', None)


class WinRMListener(Model):
    """Describes Protocol and thumbprint of Windows Remote Management listener.

    :param protocol: Specifies the protocol of listener. <br><br> Possible
     values are: <br>**http** <br><br> **https**. Possible values include:
     'Http', 'Https'
    :type protocol: str or
     ~azure.mgmt.compute.v2015_06_15.models.ProtocolTypes
    :param certificate_url: This is the URL of a certificate that has been
     uploaded to Key Vault as a secret. For adding a secret to the Key Vault,
     see [Add a key or secret to the key
     vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add).
     In this case, your certificate needs to be It is the Base64 encoding of
     the following JSON Object which is encoded in UTF-8: <br><br> {<br>
     "data":"<Base64-encoded-certificate>",<br>  "dataType":"pfx",<br>
     "password":"<pfx-file-password>"<br>}
    :type certificate_url: str
    """

    _attribute_map = {
        'protocol': {'key': 'protocol', 'type': 'ProtocolTypes'},
        'certificate_url': {'key': 'certificateUrl', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(WinRMListener, self).__init__(**kwargs)
        self.protocol = kwargs.get('protocol', None)
        self.certificate_url = kwargs.get('certificate_url', None)
