# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ModuleCreateOrUpdateParameters(Model):
    """The parameters supplied to the create or update module operation.

    All required parameters must be populated in order to send to Azure.

    :param content_link: Required. Gets or sets the module content link.
    :type content_link: ~azure.mgmt.automation.models.ContentLink
    :param name: Gets or sets name of the resource.
    :type name: str
    :param location: Gets or sets the location of the resource.
    :type location: str
    :param tags: Gets or sets the tags attached to the resource.
    :type tags: dict[str, str]
    """

    _validation = {
        'content_link': {'required': True},
    }

    _attribute_map = {
        'content_link': {'key': 'properties.contentLink', 'type': 'ContentLink'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, content_link, name: str=None, location: str=None, tags=None, **kwargs) -> None:
        super(ModuleCreateOrUpdateParameters, self).__init__(**kwargs)
        self.content_link = content_link
        self.name = name
        self.location = location
        self.tags = tags
