# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class BackendCredentialsContract(Model):
    """Details of the Credentials used to connect to Backend.

    :param certificate: List of Client Certificate Thumbprint.
    :type certificate: list[str]
    :param query: Query Parameter description.
    :type query: dict[str, list[str]]
    :param header: Header Parameter description.
    :type header: dict[str, list[str]]
    :param authorization: Authorization header authentication
    :type authorization:
     ~azure.mgmt.apimanagement.models.BackendAuthorizationHeaderCredentials
    """

    _validation = {
        'certificate': {'max_items': 32},
    }

    _attribute_map = {
        'certificate': {'key': 'certificate', 'type': '[str]'},
        'query': {'key': 'query', 'type': '{[str]}'},
        'header': {'key': 'header', 'type': '{[str]}'},
        'authorization': {'key': 'authorization', 'type': 'BackendAuthorizationHeaderCredentials'},
    }

    def __init__(self, **kwargs):
        super(BackendCredentialsContract, self).__init__(**kwargs)
        self.certificate = kwargs.get('certificate', None)
        self.query = kwargs.get('query', None)
        self.header = kwargs.get('header', None)
        self.authorization = kwargs.get('authorization', None)
