/*
 * @(#)MpaDecoder.java - MPA dec
 *
 * Copyright (c) 2003-2006 by dvb.matt, All Rights Reserved. 
 * 
 * This file is part of ProjectX, a free Java based demux utility.
 * By the authors, ProjectX is intended for educational purposes only, 
 * as a non-commercial test project.
 *
 * The mostly part of audio decoding was derived from the MPEG/Audio
 * Software Simulation Group's audio codec.
 *
 * simple resampling, amplifying and others added.
 * now decoding MPEG Layer 1 + 2
 *
 *
 * This program is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package net.sourceforge.dvb.projectx.audio;


import java.io.RandomAccessFile;
import java.io.IOException;
import java.io.ByteArrayOutputStream;

import java.util.Arrays;

import net.sourceforge.dvb.projectx.parser.CommonParsing;


public class MpaDecoder extends Object {

static int ERROR_CODE=0, ERROR_CODE1=0;

static final double table_b1[] = {  // scalefactors
	2.00000000000000, 1.58740105196820, 1.25992104989487, 1.00000000000000,
	0.79370042498410, 0.62996052494744, 0.50000000000000, 0.39685026299205,
	0.31498026247372, 0.25000000000000, 0.19842513149602, 0.15749013123686,
	0.12500000000000, 0.09921256574801, 0.07874506561843, 0.06250000000000,

	0.04960628287401, 0.03937253280921, 0.03125000000000, 0.02480314143700,
	0.01968626640461, 0.01562500000000, 0.01240157071850, 0.00984313320230,
	0.00781250000000, 0.00620078535925, 0.00492156660115, 0.00390625000000,
	0.00310039267963, 0.00246078330058, 0.00195312500000, 0.00155019633981,
	
	0.00123039165029, 0.00097656250000, 0.00077509816991, 0.00061519582514,
	0.00048828125000, 0.00038754908495, 0.00030759791257, 0.00024414062500,
	0.00019377454248, 0.00015379895629, 0.00012207031250, 0.00009688727124,
	0.00007689947814, 0.00006103515625, 0.00004844363562, 0.00003844973907,

	0.00003051757813, 0.00002422181781, 0.00001922486954, 0.00001525878906,
	0.00001211090890, 0.00000961243477, 0.00000762939453, 0.00000605545445,
	0.00000480621738, 0.00000381469727, 0.00000302772723, 0.00000240310869,
	0.00000190734863, 0.00000151386361, 0.00000120155435, 1E-20
};
	
static final int table_b2ab_nbal[] = {  // sblimit 27,30
	4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2
};

static final int table_b2cd_nbal[] = { // sblimit 8,12
	4, 4, 3, 3, 3, 3, 3, 3,	3, 3, 3, 3
};

static final int table_MPG2_nbal[] = { // sblimit 30
	4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 ,2 ,2
};

static final int table_b2_4a[] = {
	0, 1, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17
      //0, 1,_3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17  changed due to grouping
};

static final int table_b2_4b[] = {
	0, 1, 2, 4, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 17
      //0, 1, 2,_3,_4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 17  changed due to grouping
};

static final int table_b2_4c[] = {
	0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16
      //0, 1, 2,_4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16 changed due to grouping
};

static final int table_b2_3a[] = {
	0, 1, 2, 4, 3, 5, 6, 17
      //0, 1, 2,_3,_4, 5, 6, 17 changed due to grouping
};

static final int table_b2_3b[] = {
	0, 1, 2, 3, 5, 6, 7, 8
      //0, 1, 2,_4, 5, 6, 7,_127 changed due to grouping
};

static final int table_b2_2[] = {
	0, 1, 2, 17
      //0, 1, 2, 17
};

static final int table_MPG2_a[] = {
	//0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15  changed due to grouping
	0, 1, 2, 4, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15
};

static final int table_MPG2_b[] = {
	//0, 1, 2, 4, 5, 6, 7, 8  changed due to grouping
	0, 1, 2, 3, 5, 6, 7, 8
};

static final int table_MPG2_c[] = {
	//0, 1, 2, 4  changed due to grouping
	0, 1, 2, 3
};

static final int table_MPG2[][] = {
	table_MPG2_a, table_MPG2_a, table_MPG2_a, table_MPG2_a,
	table_MPG2_b, table_MPG2_b, table_MPG2_b, table_MPG2_b,
	table_MPG2_b, table_MPG2_b, table_MPG2_b, table_MPG2_c,
	table_MPG2_c, table_MPG2_c, table_MPG2_c, table_MPG2_c,
	table_MPG2_c, table_MPG2_c, table_MPG2_c, table_MPG2_c,
	table_MPG2_c, table_MPG2_c, table_MPG2_c, table_MPG2_c,
	table_MPG2_c, table_MPG2_c, table_MPG2_c, table_MPG2_c,
	table_MPG2_c, table_MPG2_c
};

static final int table_b2ab[][] = { //sblimit 27,30
	table_b2_4a, table_b2_4a, table_b2_4a, table_b2_4b,
	table_b2_4b, table_b2_4b, table_b2_4b, table_b2_4b,
	table_b2_4b, table_b2_4b, table_b2_4b, table_b2_3a,
	table_b2_3a, table_b2_3a, table_b2_3a, table_b2_3a,
	table_b2_3a, table_b2_3a, table_b2_3a, table_b2_3a,
	table_b2_3a, table_b2_3a, table_b2_3a, table_b2_2,
	table_b2_2,  table_b2_2,  table_b2_2,  table_b2_2,
	table_b2_2,  table_b2_2,  table_b2_2,  table_b2_2
};

static final int table_b2cd[][] = { //sblimit 8,12
	table_b2_4c, table_b2_4c, table_b2_3b, table_b2_3b,
	table_b2_3b, table_b2_3b, table_b2_3b, table_b2_3b,
	table_b2_3b, table_b2_3b, table_b2_3b, table_b2_3b
};

static final double table_b4[][] = {  //c,d,bits,step
	{0.0,             0.0,          0,     0},
	{1.0+1.0/3.0,     1.0/2.0,      5,     3},
	{1.0+3.0/5.0,     1.0/2.0,      7,     5},
	{1.0+7.0/9.0,     1.0/2.0,     10,     9},
	{1.0+1.0/7.0,     1.0/4.0,      3,     4},
	{1.0+1.0/15.0,    1.0/8.0,      4,     8},
	{1.0+1.0/31.0,    1.0/16.0,     5,    16},
	{1.0+1.0/63.0,    1.0/32.0,     6,    32},
	{1.0+1.0/127.0,   1.0/64.0,     7,    64},
	{1.0+1.0/255.0,   1.0/128.0,    8,   128},
	{1.0+1.0/511.0,   1.0/256.0,    9,   256},
	{1.0+1.0/1023.0,  1.0/512.0,   10,   512},
	{1.0+1.0/2047.0,  1.0/1024.0,  11,  1024},
	{1.0+1.0/4095.0,  1.0/2048.0,  12,  2048},
	{1.0+1.0/8191.0,  1.0/4096.0,  13,  4096},
	{1.0+1.0/16383.0, 1.0/8192.0,  14,  8192},
	{1.0+1.0/32767.0, 1.0/16384.0, 15, 16384},
	{1.0+1.0/65535.0, 1.0/32768.0, 16, 32768}
};

static final double table_b3[] = {
	 0.000000000, -0.000015259, -0.000015259, -0.000015259,
	-0.000015259, -0.000015259, -0.000015259, -0.000030518,
	-0.000030518, -0.000030518, -0.000030518, -0.000045776,
	-0.000045776, -0.000061035, -0.000061035, -0.000076294, /* 15 */

	-0.000076294, -0.000091553, -0.000106812, -0.000106812,
	-0.000122070, -0.000137329, -0.000152588, -0.000167847,
	-0.000198364, -0.000213623, -0.000244141, -0.000259399,
	-0.000289917, -0.000320435, -0.000366211, -0.000396729, /* 31 */

	-0.000442505, -0.000473022, -0.000534058, -0.000579834,
	-0.000625610, -0.000686646, -0.000747681, -0.000808716,
	-0.000885010, -0.000961304, -0.001037598, -0.001113892,
	-0.001205444, -0.001296997, -0.001388550, -0.001480103, /* 47 */

	-0.001586914, -0.001693726, -0.001785278, -0.001907349,
	-0.002014160, -0.002120972, -0.002243042, -0.002349854,
	-0.002456665, -0.002578735, -0.002685547, -0.002792358,
	-0.002899170, -0.002990723, -0.003082275, -0.003173828, /* 63 */

	 0.003250122,  0.003326416,  0.003387451,  0.003433228,
	 0.003463745,  0.003479004,  0.003479004,  0.003463745,
	 0.003417969,  0.003372192,  0.003280640,  0.003173828,
	 0.003051758,  0.002883911,  0.002700806,  0.002487183, /* 79 */

	 0.002227783,  0.001937866,  0.001617432,  0.001266479,
	 0.000869751,  0.000442505, -0.000030518, -0.000549316,
	-0.001098633, -0.001693726, -0.002334595, -0.003005981,
	-0.003723145, -0.004486084, -0.005294800, -0.006118774, /* 95 */

	-0.007003784, -0.007919312, -0.008865356, -0.009841919,
	-0.010848999, -0.011886597, -0.012939453, -0.014022827,
	-0.015121460, -0.016235352, -0.017349243, -0.018463135,
	-0.019577026, -0.020690918, -0.021789551, -0.022857666, /* 111 */

	-0.023910522, -0.024932861, -0.025909424, -0.026840210,
	-0.027725220, -0.028533936, -0.029281616, -0.029937744,
	-0.030532837, -0.031005859, -0.031387329, -0.031661987,
	-0.031814575, -0.031845093, -0.031738281, -0.031478882, /* 127 */

	 0.031082153,  0.030517578,  0.029785156,  0.028884888,
	 0.027801514,  0.026535034,  0.025085449,  0.023422241,
	 0.021575928,  0.019531250,  0.017257690,  0.014801025,
	 0.012115479,  0.009231567,  0.006134033,  0.002822876, /* 143 */

	-0.000686646, -0.004394531, -0.008316040, -0.012420654,
	-0.016708374, -0.021179199, -0.025817871, -0.030609131,
	-0.035552979, -0.040634155, -0.045837402, -0.051132202,
	-0.056533813, -0.061996460, -0.067520142, -0.073059082, /* 159 */

	-0.078628540, -0.084182739, -0.089706421, -0.095169067,
	-0.100540161, -0.105819702, -0.110946655, -0.115921021,
	-0.120697021, -0.125259399, -0.129562378, -0.133590698,
	-0.137298584, -0.140670776, -0.143676758, -0.146255493, /* 175 */

	-0.148422241, -0.150115967, -0.151306152, -0.151962280,
	-0.152069092, -0.151596069, -0.150497437, -0.148773193,
	-0.146362305, -0.143264771, -0.139450073, -0.134887695,
	-0.129577637, -0.123474121, -0.116577148, -0.108856201, /* 191 */

	 0.100311279,  0.090927124,  0.080688477,  0.069595337,
	 0.057617187,  0.044784546,  0.031082153,  0.016510010,
	 0.001068115, -0.015228271, -0.032379150, -0.050354004,
	-0.069168091, -0.088775635, -0.109161377, -0.130310059, /* 207 */

	-0.152206421, -0.174789429, -0.198059082, -0.221984863,
	-0.246505737, -0.271591187, -0.297210693, -0.323318481,
	-0.349868774, -0.376800537, -0.404083252, -0.431655884,
	-0.459472656, -0.487472534, -0.515609741, -0.543823242, /* 223 */

	-0.572036743, -0.600219727, -0.628295898, -0.656219482,
	-0.683914185, -0.711318970, -0.738372803, -0.765029907,
	-0.791213989, -0.816864014, -0.841949463, -0.866363525,
	-0.890090942, -0.913055420, -0.935195923, -0.956481934, /* 239 */

	-0.976852417, -0.996246338, -1.014617920, -1.031936646,
	-1.048156738, -1.063217163, -1.077117920, -1.089782715,
	-1.101211548, -1.111373901, -1.120223999, -1.127746582,
	-1.133926392, -1.138763428, -1.142211914, -1.144287109, /* 255 */

	 1.144989014,  1.144287109,  1.142211914,  1.138763428,
	 1.133926392,  1.127746582,  1.120223999,  1.111373901,
	 1.101211548,  1.089782715,  1.077117920,  1.063217163,
	 1.048156738,  1.031936646,  1.014617920,  0.996246338, /* 271 */

	 0.976852417,  0.956481934,  0.935195923,  0.913055420,
	 0.890090942,  0.866363525,  0.841949463,  0.816864014,
	 0.791213989,  0.765029907,  0.738372803,  0.711318970,
	 0.683914185,  0.656219482,  0.628295898,  0.600219727, /* 287 */

	 0.572036743,  0.543823242,  0.515609741,  0.487472534,
	 0.459472656,  0.431655884,  0.404083252,  0.376800537,
	 0.349868774,  0.323318481,  0.297210693,  0.271591187,
	 0.246505737,  0.221984863,  0.198059082,  0.174789429, /* 304 */

	 0.152206421,  0.130310059,  0.109161377,  0.088775635,
	 0.069168091,  0.050354004,  0.032379150,  0.015228271,
	-0.001068115, -0.016510010, -0.031082153, -0.044784546,
	-0.057617187, -0.069595337, -0.080688477, -0.090927124, /* 319 */

	 0.100311279,  0.108856201,  0.116577148,  0.123474121,
	 0.129577637,  0.134887695,  0.139450073,  0.143264771,
	 0.146362305,  0.148773193,  0.150497437,  0.151596069,
	 0.152069092,  0.151962280,  0.151306152,  0.150115967, /* 335 */

	 0.148422241,  0.146255493,  0.143676758,  0.140670776,
	 0.137298584,  0.133590698,  0.129562378,  0.125259399,
	 0.120697021,  0.115921021,  0.110946655,  0.105819702,
	 0.100540161,  0.095169067,  0.089706421,  0.084182739, /* 351 */

	 0.078628540,  0.073059082,  0.067520142,  0.061996460,
	 0.056533813,  0.051132202,  0.045837402,  0.040634155,
	 0.035552979,  0.030609131,  0.025817871,  0.021179199,
	 0.016708374,  0.012420654,  0.008316040,  0.004394531, /* 367 */

	 0.000686646, -0.002822876, -0.006134033, -0.009231567,
	-0.012115479, -0.014801025, -0.017257690, -0.019531250,
	-0.021575928, -0.023422241, -0.025085449, -0.026535034,
	-0.027801514, -0.028884888, -0.029785156, -0.030517578, /* 383 */

	 0.031082153,  0.031478882,  0.031738281,  0.031845093,
	 0.031814575,  0.031661987,  0.031387329,  0.031005859,
	 0.030532837,  0.029937744,  0.029281616,  0.028533936,
	 0.027725220,  0.026840210,  0.025909424,  0.024932861, /* 399 */

	 0.023910522,  0.022857666,  0.021789551,  0.020690918,
	 0.019577026,  0.018463135,  0.017349243,  0.016235352,
	 0.015121460,  0.014022827,  0.012939453,  0.011886597,
	 0.010848999,  0.009841919,  0.008865356,  0.007919312, /* 415 */

	 0.007003784,  0.006118774,  0.005294800,  0.004486084,
	 0.003723145,  0.003005981,  0.002334595,  0.001693726,
	 0.001098633,  0.000549316,  0.000030518, -0.000442505,
	-0.000869751, -0.001266479, -0.001617432, -0.001937866, /* 431 */

	-0.002227783, -0.002487183, -0.002700806, -0.002883911,
	-0.003051758, -0.003173828, -0.003280640, -0.003372192,
	-0.003417969, -0.003463745, -0.003479004, -0.003479004,
	-0.003463745, -0.003433228, -0.003387451, -0.003326416, /* 447 */

	 0.003250122,  0.003173828,  0.003082275,  0.002990723,
	 0.002899170,  0.002792358,  0.002685547,  0.002578735,
	 0.002456665,  0.002349854,  0.002243042,  0.002120972,
	 0.002014160,  0.001907349,  0.001785278,  0.001693726, /* 463 */

	 0.001586914,  0.001480103,  0.001388550,  0.001296997,
	 0.001205444,  0.001113892,  0.001037598,  0.000961304,
	 0.000885010,  0.000808716,  0.000747681,  0.000686646,
	 0.000625610,  0.000579834,  0.000534058,  0.000473022, /* 479 */

	 0.000442505,  0.000396729,  0.000366211,  0.000320435,
	 0.000289917,  0.000259399,  0.000244141,  0.000213623,
	 0.000198364,  0.000167847,  0.000152588,  0.000137329,
	 0.000122070,  0.000106812,  0.000106812,  0.000091553, /* 495 */

	 0.000076294,  0.000076294,  0.000061035,  0.000061035,
	 0.000045776,  0.000045776,  0.000030518,  0.000030518,
	 0.000030518,  0.000030518,  0.000015259,  0.000015259,
	 0.000015259,  0.000015259,  0.000015259,  0.000015259  /* 511 */
};

static final double table_Nik[][] = {
	{
		 0.707106781186547573, -0.707106781186547462, -0.707106781186547684,  0.707106781186547351, 
		 0.707106781186547684, -0.707106781186547906, -0.707106781186547129,  0.707106781186547795, 
		 0.707106781186547240, -0.707106781186547795, -0.707106781186547351,  0.707106781186546352, 
		 0.707106781186547462, -0.707106781186546352, -0.707106781186547573,  0.707106781186548683, 
		 0.707106781186547573, -0.707106781186548683, -0.707106781186547684,  0.707106781186548572, 
		 0.707106781186545241, -0.707106781186546018, -0.707106781186547906,  0.707106781186548350, 
		 0.707106781186545463, -0.707106781186545796, -0.707106781186548017,  0.707106781186548239, 
		 0.707106781186545574, -0.707106781186545574, -0.707106781186548239,  0.707106781186548017, 
	},{
		 0.671558954847018330, -0.803207531480644832, -0.514102744193221772,  0.903989293123443449, 
		 0.336889853392220051, -0.970031253194544085, -0.146730474455361665,  0.998795456205172405, 
		-0.049067674327417293, -0.989176509964780903,  0.242980179903262428,  0.941544065183020806, 
		-0.427555093430283195, -0.857728610000272562,  0.595699304492433690,  0.740951125354960216, 
		-0.740951125354958884, -0.595699304492432469,  0.857728610000271452,  0.427555093430285082, 
		-0.941544065183021361, -0.242980179903264426,  0.989176509964780570,  0.049067674327415829, 
		-0.998795456205172405,  0.146730474455359611,  0.970031253194543308, -0.336889853392220606, 
		-0.903989293123444004,  0.514102744193224659,  0.803207531480644166, -0.671558954847017664, 
	},{
		 0.634393284163645488, -0.881921264348354939, -0.290284677254462442,  0.995184726672196929, 
		-0.098017140329560840, -0.956940335732208713,  0.471396736825997364,  0.773010453362736549, 
		-0.773010453362736993, -0.471396736825998308,  0.956940335732208935,  0.098017140329559285, 
		-0.995184726672197040,  0.290284677254462220,  0.881921264348354605, -0.634393284163644267, 
		-0.634393284163645932,  0.881921264348355272,  0.290284677254464329, -0.995184726672196818, 
		 0.098017140329560631,  0.956940335732208602, -0.471396736825999529, -0.773010453362734995, 
		 0.773010453362735106,  0.471396736825999307, -0.956940335732208602, -0.098017140329560382, 
		 0.995184726672196818, -0.290284677254464552, -0.881921264348353495,  0.634393284163643378, 
	},{
		 0.595699304492433357, -0.941544065183020806, -0.049067674327418029,  0.970031253194544085, 
		-0.514102744193221439, -0.671558954847018108,  0.903989293123443005,  0.146730474455361803, 
		-0.989176509964780903,  0.427555093430283306,  0.740951125354960105, -0.857728610000271674, 
		-0.242980179903263954,  0.998795456205172405, -0.336889853392221328, -0.803207531480645831, 
		 0.803207531480644388,  0.336889853392220162, -0.998795456205172294,  0.242980179903265148, 
		 0.857728610000272895, -0.740951125354960882, -0.427555093430282196,  0.989176509964780570, 
		-0.146730474455362997, -0.903989293123444004,  0.671558954847020440,  0.514102744193221883, 
		-0.970031253194543308,  0.049067674327419257,  0.941544065183021361, -0.595699304492435466, 
	},{
		 0.555570233019602289, -0.980785280403230431,  0.195090322016128304,  0.831469612302545014, 
		-0.831469612302545125, -0.195090322016128026,  0.980785280403230320, -0.555570233019601512, 
		-0.555570233019602622,  0.980785280403230431, -0.195090322016128581, -0.831469612302544903, 
		 0.831469612302545791,  0.195090322016126888, -0.980785280403230098,  0.555570233019601067, 
		 0.555570233019600179, -0.980785280403230986,  0.195090322016131440,  0.831469612302547123, 
		-0.831469612302543459, -0.195090322016130968,  0.980785280403230875, -0.555570233019600512, 
		-0.555570233019603621,  0.980785280403230209, -0.195090322016127360, -0.831469612302545569, 
		 0.831469612302545125,  0.195090322016128082, -0.980785280403230320,  0.555570233019602955, 
	},{
		 0.514102744193221661, -0.998795456205172405,  0.427555093430282140,  0.595699304492433246, 
		-0.989176509964781014,  0.336889853392220218,  0.671558954847018219, -0.970031253194544085, 
		 0.242980179903262428,  0.740951125354960105, -0.941544065183020251,  0.146730474455360332, 
		 0.803207531480645720, -0.903989293123442783,  0.049067674327416683,  0.857728610000272784, 
		-0.857728610000273228, -0.049067674327419250,  0.903989293123442339, -0.803207531480644166, 
		-0.146730474455359361,  0.941544065183021139, -0.740951125354960771, -0.242980179903264926, 
		 0.970031253194543419, -0.671558954847017664, -0.336889853392217609,  0.989176509964781125, 
		-0.595699304492435466, -0.427555093430282862,  0.998795456205172294, -0.514102744193227101, 
	},{
		 0.471396736825997587, -0.995184726672196929,  0.634393284163645599,  0.290284677254462553, 
		-0.956940335732208713,  0.773010453362736993,  0.098017140329560812, -0.881921264348354383, 
		 0.881921264348355494, -0.098017140329561242, -0.773010453362736771,  0.956940335732208824, 
		-0.290284677254462109, -0.634393284163645932,  0.995184726672196818, -0.471396736825999751, 
		-0.471396736825995866,  0.995184726672196707, -0.634393284163646598, -0.290284677254461276, 
		 0.956940335732208602, -0.773010453362737326, -0.098017140329560382,  0.881921264348355050, 
		-0.881921264348354828,  0.098017140329559896,  0.773010453362737548, -0.956940335732208491, 
		 0.290284677254460832,  0.634393284163647042, -0.995184726672197373,  0.471396736826001694, 
	},{
		 0.427555093430282196, -0.970031253194543974,  0.803207531480645054, -0.049067674327418424, 
		-0.740951125354958662,  0.989176509964781014, -0.514102744193221217, -0.336889853392219552, 
		 0.941544065183020806, -0.857728610000271674,  0.146730474455360332,  0.671558954847017331, 
		-0.998795456205172405,  0.595699304492433468,  0.242980179903260873, -0.903989293123443782, 
		 0.903989293123444115, -0.242980179903261595, -0.595699304492432913,  0.998795456205172183, 
		-0.671558954847017886, -0.146730474455359611,  0.857728610000273117, -0.941544065183021028, 
		 0.336889853392216942,  0.514102744193222105, -0.989176509964780570,  0.740951125354957996, 
		 0.049067674327416808, -0.803207531480646719,  0.970031253194545751, -0.427555093430284638, 
	},{
		 0.382683432365089837, -0.923879532511286850,  0.923879532511286850, -0.382683432365089893, 
		-0.382683432365090559,  0.923879532511286738, -0.923879532511287072,  0.382683432365089560, 
		 0.382683432365090892, -0.923879532511286294,  0.923879532511286850, -0.382683432365089227, 
		-0.382683432365091225,  0.923879532511286405, -0.923879532511285406,  0.382683432365092169, 
		 0.382683432365088283, -0.923879532511286516,  0.923879532511286627, -0.382683432365088505, 
		-0.382683432365091947,  0.923879532511288071, -0.923879532511287849,  0.382683432365091447, 
		 0.382683432365089005, -0.923879532511286850,  0.923879532511286294, -0.382683432365094389, 
		-0.382683432365092613,  0.923879532511285628, -0.923879532511284851,  0.382683432365090781, 
	},{
		 0.336889853392220051, -0.857728610000272118,  0.989176509964781014, -0.671558954847018885, 
		 0.049067674327417418,  0.595699304492433468, -0.970031253194543863,  0.903989293123442894, 
		-0.427555093430283195, -0.242980179903263954,  0.803207531480645720, -0.998795456205172405, 
		 0.740951125354958773, -0.146730474455363497, -0.514102744193224437,  0.941544065183021028, 
		-0.941544065183021250,  0.514102744193218775,  0.146730474455362997, -0.740951125354958440, 
		 0.998795456205172183, -0.803207531480643944,  0.242980179903264454,  0.427555093430279587, 
		-0.903989293123444226,  0.970031253194544085, -0.595699304492435244, -0.049067674327413380, 
		 0.671558954847013334, -0.989176509964781681,  0.857728610000270564, -0.336889853392219440, 
	},{
		 0.290284677254462331, -0.773010453362736882,  0.995184726672196818, -0.881921264348354828, 
		 0.471396736825997364,  0.098017140329560812, -0.634393284163645599,  0.956940335732209380, 
		-0.956940335732208935,  0.634393284163644378, -0.098017140329560992, -0.471396736825998752, 
		 0.881921264348354716, -0.995184726672196818,  0.773010453362735217, -0.290284677254465051, 
		-0.290284677254461276,  0.773010453362737326, -0.995184726672197151,  0.881921264348356604, 
		-0.471396736825999085, -0.098017140329560631,  0.634393284163646820, -0.956940335732209824, 
		 0.956940335732209490, -0.634393284163640381,  0.098017140329566488,  0.471396736825993867, 
		-0.881921264348353828,  0.995184726672196929, -0.773010453362736549,  0.290284677254460111, 
	},{
		 0.242980179903263982, -0.671558954847018330,  0.941544065183020695, -0.989176509964781014, 
		 0.803207531480644832, -0.427555093430281807, -0.049067674327418521,  0.514102744193220773, 
		-0.857728610000272562,  0.998795456205172405, -0.903989293123442783,  0.595699304492433468, 
		-0.146730474455363497, -0.336889853392216942,  0.740951125354960549, -0.970031253194544196, 
		 0.970031253194544196, -0.740951125354960771,  0.336889853392217165,  0.146730474455363247, 
		-0.595699304492433357,  0.903989293123442672, -0.998795456205172516,  0.857728610000270897, 
		-0.514102744193227101,  0.049067674327418764,  0.427555093430286415, -0.803207531480642611, 
		 0.989176509964781236, -0.941544065183023138,  0.671558954847019440, -0.242980179903259930, 
	},{
		 0.195090322016128331, -0.555570233019602178,  0.831469612302545014, -0.980785280403230320, 
		 0.980785280403230431, -0.831469612302545014,  0.555570233019601512, -0.195090322016128581, 
		-0.195090322016126777,  0.555570233019602844, -0.831469612302545014,  0.980785280403230098, 
		-0.980785280403230986,  0.831469612302545569, -0.555570233019600734,  0.195090322016131218, 
		 0.195090322016127610, -0.555570233019603621,  0.831469612302543459, -0.980785280403230320, 
		 0.980785280403230098, -0.831469612302547012,  0.555570233019602955, -0.195090322016126888, 
		-0.195090322016124973,  0.555570233019607285, -0.831469612302545902,  0.980785280403229764, 
		-0.980785280403229320,  0.831469612302544570, -0.555570233019605175,  0.195090322016122558, 
	},{
		 0.146730474455361748, -0.427555093430282474,  0.671558954847018108, -0.857728610000272340, 
		 0.970031253194543863, -0.998795456205172405,  0.941544065183020362, -0.803207531480644610, 
		 0.595699304492433690, -0.336889853392221328,  0.049067674327416683,  0.242980179903260873, 
		-0.514102744193224437,  0.740951125354960549, -0.903989293123443893,  0.989176509964781014, 
		-0.989176509964781014,  0.903989293123443893, -0.740951125354960549,  0.514102744193224437, 
		-0.242980179903260873, -0.049067674327420228,  0.336889853392221328, -0.595699304492433690, 
		 0.803207531480644610, -0.941544065183020362,  0.998795456205172294, -0.970031253194544751, 
		 0.857728610000274116, -0.671558954847021994,  0.427555093430287303, -0.146730474455368354, 
	},{
		 0.098017140329560548, -0.290284677254462442,  0.471396736825997975, -0.634393284163645377, 
		 0.773010453362736549, -0.881921264348354383,  0.956940335732209380, -0.995184726672197040, 
		 0.995184726672196818, -0.956940335732208824,  0.881921264348355272, -0.773010453362737548, 
		 0.634393284163643934, -0.471396736825999529,  0.290284677254461498, -0.098017140329563809, 
		-0.098017140329560382,  0.290284677254465051, -0.471396736825996476,  0.634393284163646820, 
		-0.773010453362735439,  0.881921264348355272, -0.956940335732207825,  0.995184726672196818, 
		-0.995184726672196596,  0.956940335732207270, -0.881921264348357714,  0.773010453362738659, 
		-0.634393284163645266,  0.471396736825994755, -0.290284677254456336,  0.098017140329565516, 
	},{
		 0.049067674327417904, -0.146730474455361443,  0.242980179903264232, -0.336889853392219329, 
		 0.427555093430282807, -0.514102744193220662,  0.595699304492432247, -0.671558954847017220, 
		 0.740951125354960216, -0.803207531480645831,  0.857728610000272784, -0.903989293123443782, 
		 0.941544065183021028, -0.970031253194544196,  0.989176509964781014, -0.998795456205172405, 
		 0.998795456205172405, -0.989176509964781014,  0.970031253194544085, -0.941544065183021028, 
		 0.903989293123443671, -0.857728610000272562,  0.803207531480641390, -0.740951125354960105, 
		 0.671558954847014444, -0.595699304492434911,  0.514102744193217442, -0.427555093430284194, 
		 0.336889853392215777, -0.242980179903266591,  0.146730474455357668, -0.049067674327421214, 
	},{
		 0.000000000000000061, -0.000000000000000184,  0.000000000000000306, -0.000000000000000429, 
		 0.000000000000000551,  0.000000000000001103, -0.000000000000000980,  0.000000000000000858, 
		-0.000000000000000735,  0.000000000000000613, -0.000000000000000491, -0.000000000000003185, 
		-0.000000000000000246, -0.000000000000003430, -0.000000000000000001,  0.000000000000003431, 
		 0.000000000000000244,  0.000000000000003186,  0.000000000000000489,  0.000000000000002941, 
		-0.000000000000006371, -0.000000000000004409,  0.000000000000000979,  0.000000000000002451, 
		-0.000000000000005881, -0.000000000000004899,  0.000000000000001469,  0.000000000000001961, 
		-0.000000000000005392, -0.000000000000005389,  0.000000000000001959,  0.000000000000001472, 
	},{
		-0.049067674327418008,  0.146730474455361942, -0.242980179903264509,  0.336889853392220218, 
		-0.427555093430281807,  0.514102744193222660, -0.595699304492433801,  0.671558954847018441, 
		-0.740951125354958884,  0.803207531480644388, -0.857728610000273228,  0.903989293123444115, 
		-0.941544065183021250,  0.970031253194544196, -0.989176509964781014,  0.998795456205172405, 
		-0.998795456205172405,  0.989176509964781125, -0.970031253194544307,  0.941544065183021361, 
		-0.903989293123441229,  0.857728610000269787, -0.803207531480642611,  0.740951125354956774, 
		-0.671558954847016221,  0.595699304492431358, -0.514102744193219996,  0.427555093430280642, 
		-0.336889853392218996,  0.242980179903263260, -0.146730474455361554,  0.049067674327418272, 
	},{
		-0.098017140329560645,  0.290284677254462054, -0.471396736825997476,  0.634393284163646043, 
		-0.773010453362736993,  0.881921264348355494, -0.956940335732208935,  0.995184726672196818, 
		-0.995184726672197040,  0.956940335732208491, -0.881921264348356493,  0.773010453362737104, 
		-0.634393284163643600,  0.471396736825999307, -0.290284677254461498,  0.098017140329564045, 
		 0.098017140329559896, -0.290284677254464329,  0.471396736825995644, -0.634393284163640381, 
		 0.773010453362738992, -0.881921264348354494,  0.956940335732207270, -0.995184726672197262, 
		 0.995184726672196929, -0.956940335732210157,  0.881921264348352385, -0.773010453362736216, 
		 0.634393284163647930, -0.471396736825991758,  0.290284677254460111, -0.098017140329562588, 
	},{
		-0.146730474455361859,  0.427555093430282140, -0.671558954847018885,  0.857728610000271896, 
		-0.970031253194544085,  0.998795456205172405, -0.941544065183020917,  0.803207531480645720, 
		-0.595699304492432469,  0.336889853392220162, -0.049067674327419250, -0.242980179903261595, 
		 0.514102744193218775, -0.740951125354960771,  0.903989293123443893, -0.989176509964781014, 
		 0.989176509964781125, -0.903989293123444226,  0.740951125354961215, -0.514102744193225436, 
		 0.242980179903262289,  0.049067674327411423, -0.336889853392219440,  0.595699304492437687, 
		-0.803207531480643166,  0.941544065183021806, -0.998795456205172183,  0.970031253194543752, 
		-0.857728610000268565,  0.671558954847019440, -0.427555093430278033,  0.146730474455365439, 
	},{
		-0.195090322016128193,  0.555570233019601845, -0.831469612302545125,  0.980785280403230431, 
		-0.980785280403230320,  0.831469612302544792, -0.555570233019602733,  0.195090322016126888, 
		 0.195090322016128220, -0.555570233019600956,  0.831469612302545569, -0.980785280403230986, 
		 0.980785280403230875, -0.831469612302545458,  0.555570233019600734, -0.195090322016131440, 
		-0.195090322016127138,  0.555570233019602955, -0.831469612302542904,  0.980785280403230098, 
		-0.980785280403230431,  0.831469612302544014, -0.555570233019598736,  0.195090322016122086, 
		 0.195090322016122558, -0.555570233019599069,  0.831469612302544348, -0.980785280403230542, 
		 0.980785280403229986, -0.831469612302542682,  0.555570233019596627, -0.195090322016133605, 
	},{
		-0.242980179903263871,  0.671558954847018330, -0.941544065183021028,  0.989176509964780903, 
		-0.803207531480645498,  0.427555093430281419,  0.049067674327416926, -0.514102744193222327, 
		 0.857728610000271452, -0.998795456205172294,  0.903989293123442339, -0.595699304492432913, 
		 0.146730474455362997,  0.336889853392217165, -0.740951125354960549,  0.970031253194544085, 
		-0.970031253194544307,  0.740951125354961215, -0.336889853392218053, -0.146730474455362053, 
		 0.595699304492432136, -0.903989293123441895,  0.998795456205172627, -0.857728610000275671, 
		 0.514102744193216998, -0.049067674327414358, -0.427555093430283750,  0.803207531480644943, 
		-0.989176509964780681,  0.941544065183022028, -0.671558954847022327,  0.242980179903257071, 
	},{
		-0.290284677254462387,  0.773010453362737215, -0.995184726672196929,  0.881921264348355272, 
		-0.471396736825998308, -0.098017140329561242,  0.634393284163644378, -0.956940335732208824, 
		 0.956940335732208491, -0.634393284163643378,  0.098017140329563560,  0.471396736825996254, 
		-0.881921264348354939,  0.995184726672196818, -0.773010453362735217,  0.290284677254465273, 
		 0.290284677254460832, -0.773010453362736771,  0.995184726672196263, -0.881921264348353828, 
		 0.471396736826000362,  0.098017140329566002, -0.634393284163645266,  0.956940335732207159, 
		-0.956940335732208158,  0.634393284163647930, -0.098017140329555261, -0.471396736825997364, 
		 0.881921264348352163, -0.995184726672196596,  0.773010453362738992, -0.290284677254457280, 
	},{
		-0.336889853392220162,  0.857728610000272007, -0.989176509964781125,  0.671558954847018219, 
		-0.049067674327418521, -0.595699304492433801,  0.970031253194544418, -0.903989293123443671, 
		 0.427555093430285082,  0.242980179903265148, -0.803207531480644166,  0.998795456205172183, 
		-0.740951125354958440,  0.146730474455363247,  0.514102744193224437, -0.941544065183021028, 
		 0.941544065183021361, -0.514102744193225436, -0.146730474455362053,  0.740951125354962437, 
		-0.998795456205172183,  0.803207531480644943, -0.242980179903259458, -0.427555093430277588, 
		 0.903989293123443116, -0.970031253194542975,  0.595699304492437687,  0.049067674327417300, 
		-0.671558954847021328,  0.989176509964780126, -0.857728610000272562,  0.336889853392216665, 
	},{
		-0.382683432365089726,  0.923879532511286850, -0.923879532511286738,  0.382683432365089060, 
		 0.382683432365089560, -0.923879532511286960,  0.923879532511286294, -0.382683432365091225, 
		-0.382683432365089005,  0.923879532511286738, -0.923879532511286516,  0.382683432365088505, 
		 0.382683432365091669, -0.923879532511287849,  0.923879532511285406, -0.382683432365092391, 
		-0.382683432365094389,  0.923879532511288959, -0.923879532511284296,  0.382683432365096221, 
		 0.382683432365084009, -0.923879532511284629,  0.923879532511288626, -0.382683432365093501, 
		-0.382683432365086729,  0.923879532511285739, -0.923879532511287405,  0.382683432365090781, 
		 0.382683432365089449, -0.923879532511286850,  0.923879532511286294, -0.382683432365088061, 
	},{
		-0.427555093430282251,  0.970031253194543974, -0.803207531480645387,  0.049067674327418397, 
		 0.740951125354959106, -0.989176509964780903,  0.514102744193220995,  0.336889853392221217, 
		-0.941544065183021361,  0.857728610000272895, -0.146730474455359361, -0.671558954847017886, 
		 0.998795456205172183, -0.595699304492433357, -0.242980179903260873,  0.903989293123443671, 
		-0.903989293123441229,  0.242980179903262289,  0.595699304492432136, -0.998795456205172183, 
		 0.671558954847013667,  0.146730474455364940, -0.857728610000272118,  0.941544065183021806, 
		-0.336889853392225935, -0.514102744193225880,  0.989176509964781236, -0.740951125354960105, 
		-0.049067674327413380,  0.803207531480648718, -0.970031253194543197,  0.427555093430281974, 
	},{
		-0.471396736825997698,  0.995184726672196929, -0.634393284163645377, -0.290284677254462553, 
		 0.956940335732208935, -0.773010453362736771, -0.098017140329560992,  0.881921264348355272, 
		-0.881921264348356493,  0.098017140329563560,  0.773010453362735106, -0.956940335732209713, 
		 0.290284677254465051,  0.634393284163643378, -0.995184726672197151,  0.471396736825999918, 
		 0.471396736826001694, -0.995184726672196596,  0.634393284163641824,  0.290284677254460111, 
		-0.956940335732210268,  0.773010453362738326,  0.098017140329565516, -0.881921264348354050, 
		 0.881921264348352607, -0.098017140329562588, -0.773010453362740213,  0.956940335732209380, 
		-0.290284677254457280, -0.634393284163644156,  0.995184726672196374, -0.471396736825986540, 
	},{
		-0.514102744193221661,  0.998795456205172405, -0.427555093430282696, -0.595699304492434023, 
		 0.989176509964780903, -0.336889853392219829, -0.671558954847018441,  0.970031253194544085, 
		-0.242980179903264426, -0.740951125354960882,  0.941544065183021139, -0.146730474455359611, 
		-0.803207531480643944,  0.903989293123442672, -0.049067674327420228, -0.857728610000272562, 
		 0.857728610000269787,  0.049067674327411423, -0.903989293123441895,  0.803207531480644943, 
		 0.146730474455364940, -0.941544065183023027,  0.740951125354962104,  0.242980179903262788, 
		-0.970031253194544529,  0.671558954847014444,  0.336889853392214833, -0.989176509964780681, 
		 0.595699304492432469,  0.427555093430285971, -0.998795456205172738,  0.514102744193224548, 
	},{
		-0.555570233019602289,  0.980785280403230431, -0.195090322016128026, -0.831469612302545014, 
		 0.831469612302544792,  0.195090322016128442, -0.980785280403230320,  0.555570233019600179, 
		 0.555570233019603843, -0.980785280403230209,  0.195090322016127610,  0.831469612302545236, 
		-0.831469612302545569, -0.195090322016127138,  0.980785280403230098, -0.555570233019598292, 
		-0.555570233019605619,  0.980785280403229764, -0.195090322016125445, -0.831469612302546457, 
		 0.831469612302544348,  0.195090322016129303, -0.980785280403230542,  0.555570233019602400, 
		 0.555570233019601512, -0.980785280403230764,  0.195090322016130246,  0.831469612302543792, 
		-0.831469612302547012, -0.195090322016124473,  0.980785280403232318, -0.555570233019594628, 
	},{
		-0.595699304492433357,  0.941544065183020695,  0.049067674327417418, -0.970031253194544085, 
		 0.514102744193220773,  0.671558954847018441, -0.903989293123443671, -0.146730474455363497, 
		 0.989176509964780570, -0.427555093430282196, -0.740951125354960771,  0.857728610000273117, 
		 0.242980179903264454, -0.998795456205172516,  0.336889853392221328,  0.803207531480641390, 
		-0.803207531480642611, -0.336889853392219440,  0.998795456205172627, -0.242980179903259458, 
		-0.857728610000272118,  0.740951125354962104,  0.427555093430286859, -0.989176509964780903, 
		 0.146730474455365439,  0.903989293123445892, -0.671558954847017331, -0.514102744193219108, 
		 0.970031253194542420, -0.049067674327415822, -0.941544065183024803,  0.595699304492438797, 
	},{
		-0.634393284163645377,  0.881921264348355050,  0.290284677254462664, -0.995184726672196818, 
		 0.098017140329559285,  0.956940335732208824, -0.471396736825998752, -0.773010453362737548, 
		 0.773010453362737104,  0.471396736825996254, -0.956940335732209713, -0.098017140329563560, 
		 0.995184726672197040, -0.290284677254461998, -0.881921264348357936,  0.634393284163647153, 
		 0.634393284163648263, -0.881921264348357270, -0.290284677254463386,  0.995184726672196263, 
		-0.098017140329562089, -0.956940335732210157,  0.471396736826001250,  0.773010453362738104, 
		-0.773010453362741212, -0.471396736825996920,  0.956940335732207381,  0.098017140329557217, 
		-0.995184726672197151,  0.290284677254468104,  0.881921264348361711, -0.634393284163641158, 
	},{
		-0.671558954847018441,  0.803207531480644721,  0.514102744193221328, -0.903989293123443449, 
		-0.336889853392221550,  0.970031253194543974,  0.146730474455360110, -0.998795456205172405, 
		 0.049067674327415829,  0.989176509964780570, -0.242980179903264926, -0.941544065183021028, 
		 0.427555093430279587,  0.857728610000270897, -0.595699304492433690, -0.740951125354960105, 
		 0.740951125354956774,  0.595699304492437687, -0.857728610000275671, -0.427555093430277588, 
		 0.941544065183021806,  0.242980179903262788, -0.989176509964780903, -0.049067674327420721, 
		 0.998795456205172627, -0.146730474455355253, -0.970031253194542642,  0.336889853392223604, 
		 0.903989293123448667, -0.514102744193233874, -0.803207531480637615,  0.671558954847025991, 
	},{
		-0.707106781186547462,  0.707106781186547684,  0.707106781186547795, -0.707106781186547351, 
		-0.707106781186546352,  0.707106781186547573,  0.707106781186548572, -0.707106781186547906, 
		-0.707106781186545796,  0.707106781186545574,  0.707106781186548017, -0.707106781186548350, 
		-0.707106781186545241,  0.707106781186546129,  0.707106781186542466, -0.707106781186543909, 
		-0.707106781186549793,  0.707106781186546685,  0.707106781186547018, -0.707106781186549460, 
		-0.707106781186544242,  0.707106781186552236,  0.707106781186551458, -0.707106781186544908, 
		-0.707106781186548683,  0.707106781186547684,  0.707106781186546018, -0.707106781186540467, 
		-0.707106781186543243,  0.707106781186543243,  0.707106781186540467, -0.707106781186546018, 
	},{
		-0.740951125354959217,  0.595699304492433246,  0.857728610000271896, -0.427555093430281308, 
		-0.941544065183020251,  0.242980179903264093,  0.989176509964781125, -0.049067674327419250, 
		-0.998795456205172405, -0.146730474455362997,  0.970031253194543419,  0.336889853392216942, 
		-0.903989293123444226, -0.514102744193227101,  0.803207531480644610,  0.671558954847014444, 
		-0.671558954847016221, -0.803207531480643166,  0.514102744193216998,  0.903989293123443116, 
		-0.336889853392225935, -0.970031253194544529,  0.146730474455365439,  0.998795456205172627, 
		 0.049067674327416808, -0.989176509964782014, -0.242980179903265148,  0.941544065183017476, 
		 0.427555093430285527, -0.857728610000273117, -0.595699304492427029,  0.740951125354968321, 
	},{
		-0.773010453362736993,  0.471396736825997975,  0.956940335732209046, -0.098017140329559174, 
		-0.995184726672197040, -0.290284677254462109,  0.881921264348354716,  0.634393284163643934, 
		-0.634393284163643600, -0.881921264348354939,  0.290284677254465051,  0.995184726672197040, 
		 0.098017140329559660, -0.956940335732207825, -0.471396736825992146,  0.773010453362738104, 
		 0.773010453362738659, -0.471396736826003859, -0.956940335732208158,  0.098017140329558675, 
		 0.995184726672196263,  0.290284677254459167, -0.881921264348354494, -0.634393284163649818, 
		 0.634393284163648707,  0.881921264348355161, -0.290284677254457779, -0.995184726672197817, 
		-0.098017140329574287,  0.956940335732211822,  0.471396736825992591, -0.773010453362737771, 
	},{
		-0.803207531480644832,  0.336889853392220051,  0.998795456205172405,  0.242980179903262428, 
		-0.857728610000272562, -0.740951125354958884,  0.427555093430285082,  0.989176509964780570, 
		 0.146730474455359611, -0.903989293123444004, -0.671558954847017664,  0.514102744193222105, 
		 0.970031253194544085,  0.049067674327418764, -0.941544065183020362, -0.595699304492434911, 
		 0.595699304492431358,  0.941544065183021806, -0.049067674327414358, -0.970031253194542975, 
		-0.514102744193225880,  0.671558954847014444,  0.903989293123445892, -0.146730474455355253, 
		-0.989176509964782014, -0.427555093430276256,  0.740951125354963103,  0.857728610000276670, 
		-0.242980179903268478, -0.998795456205171850, -0.336889853392216720,  0.803207531480638170, 
	},{
		-0.831469612302545347,  0.195090322016127915,  0.980785280403230320,  0.555570233019601512, 
		-0.555570233019602733, -0.980785280403230320, -0.195090322016128082,  0.831469612302547123, 
		 0.831469612302545458, -0.195090322016131218, -0.980785280403230320, -0.555570233019600179, 
		 0.555570233019601178,  0.980785280403230098,  0.195090322016123030, -0.831469612302542127, 
		-0.831469612302546457,  0.195090322016129275,  0.980785280403231319,  0.555570233019607729, 
		-0.555570233019599513, -0.980785280403230431, -0.195090322016124973,  0.831469612302548899, 
		 0.831469612302547567, -0.195090322016141293, -0.980785280403228099, -0.555570233019609283, 
		 0.555570233019597848,  0.980785280403230875,  0.195090322016126888, -0.831469612302547900, 
	},{
		-0.857728610000272007,  0.049067674327418154,  0.903989293123443449,  0.803207531480644721, 
		-0.146730474455362164, -0.941544065183020917, -0.740951125354961104,  0.242980179903261123, 
		 0.970031253194543308,  0.671558954847020440, -0.336889853392217609, -0.989176509964780570, 
		-0.595699304492435244,  0.427555093430286415,  0.998795456205172294,  0.514102744193217442, 
		-0.514102744193219996, -0.998795456205172183, -0.427555093430283750,  0.595699304492437687, 
		 0.989176509964781236,  0.336889853392214833, -0.671558954847017331, -0.970031253194542642, 
		-0.242980179903265148,  0.740951125354963103,  0.941544065183021139,  0.146730474455369797, 
		-0.803207531480652825, -0.903989293123440674, -0.049067674327418764,  0.857728610000268121, 
	},{
		-0.881921264348354939, -0.098017140329560840,  0.773010453362736549,  0.956940335732208935, 
		 0.290284677254462220, -0.634393284163645932, -0.995184726672196818, -0.471396736825999529, 
		 0.471396736825999307,  0.995184726672196818,  0.634393284163643378, -0.290284677254461998, 
		-0.956940335732207825, -0.773010453362741212,  0.098017140329565017,  0.881921264348355605, 
		 0.881921264348355827,  0.098017140329565516, -0.773010453362740879, -0.956940335732207936, 
		-0.290284677254462442,  0.634393284163643045,  0.995184726672197484,  0.471396736825993479, 
		-0.471396736825986540, -0.995184726672196707, -0.634393284163638049,  0.290284677254454948, 
		 0.956940335732209824,  0.773010453362745875, -0.098017140329557703, -0.881921264348358935, 
	},{
		-0.903989293123443338, -0.242980179903264509,  0.595699304492433468,  0.998795456205172405, 
		 0.671558954847018441, -0.146730474455362414, -0.857728610000271008, -0.941544065183021250, 
		-0.336889853392220606,  0.514102744193221883,  0.989176509964781125,  0.740951125354957996, 
		-0.049067674327413380, -0.803207531480642611, -0.970031253194544751, -0.427555093430284194, 
		 0.427555093430280642,  0.970031253194543752,  0.803207531480644943,  0.049067674327417300, 
		-0.740951125354960105, -0.989176509964780681, -0.514102744193219108,  0.336889853392223604, 
		 0.941544065183017476,  0.857728610000276670,  0.146730474455369797, -0.671558954847012890, 
		-0.998795456205172738, -0.595699304492438020,  0.242980179903258958,  0.903989293123441451, 
	},{
		-0.923879532511286738, -0.382683432365089893,  0.382683432365089060,  0.923879532511286183, 
		 0.923879532511286850,  0.382683432365089116, -0.382683432365091447, -0.923879532511286516, 
		-0.923879532511287960, -0.382683432365088283,  0.382683432365089005,  0.923879532511285517, 
		 0.923879532511288959,  0.382683432365090781, -0.382683432365093057, -0.923879532511284407, 
		-0.923879532511287294, -0.382683432365086729,  0.382683432365084009,  0.923879532511286183, 
		 0.923879532511285628,  0.382683432365095777, -0.382683432365088061, -0.923879532511287849, 
		-0.923879532511289292, -0.382683432365078569,  0.382683432365092169,  0.923879532511284074, 
		 0.923879532511282187,  0.382683432365087617, -0.382683432365083065, -0.923879532511291179, 
	},{
		-0.941544065183020806, -0.514102744193221439,  0.146730474455361803,  0.740951125354960105, 
		 0.998795456205172405,  0.803207531480644388,  0.242980179903265148, -0.427555093430282196, 
		-0.903989293123444004, -0.970031253194543308, -0.595699304492435466,  0.049067674327416808, 
		 0.671558954847013334,  0.989176509964781236,  0.857728610000274116,  0.336889853392215777, 
		-0.336889853392218996, -0.857728610000268565, -0.989176509964780681, -0.671558954847021328, 
		-0.049067674327413380,  0.595699304492432469,  0.970031253194542420,  0.903989293123448667, 
		 0.427555093430285527, -0.242980179903268478, -0.803207531480652825, -0.998795456205172738, 
		-0.740951125354957774, -0.146730474455351367,  0.514102744193213668,  0.941544065183020473, 
	},{
		-0.956940335732208824, -0.634393284163644822, -0.098017140329561492,  0.471396736825998419, 
		 0.881921264348354605,  0.995184726672196818,  0.773010453362735217,  0.290284677254461498, 
		-0.290284677254461498, -0.773010453362735217, -0.995184726672197151, -0.881921264348357936, 
		-0.471396736825992146,  0.098017140329565017,  0.634393284163647597,  0.956940335732209157, 
		 0.956940335732209157,  0.634393284163647597,  0.098017140329565017, -0.471396736825992146, 
		-0.881921264348357936, -0.995184726672196485, -0.773010453362735217, -0.290284677254461498, 
		 0.290284677254461498,  0.773010453362735217,  0.995184726672196485,  0.881921264348357936, 
		 0.471396736826004692, -0.098017140329550875, -0.634393284163636606, -0.956940335732205050, 
	},{
		-0.970031253194543974, -0.740951125354959328, -0.336889853392220107,  0.146730474455362025, 
		 0.595699304492432469,  0.903989293123443782,  0.998795456205172405,  0.857728610000271230, 
		 0.514102744193224659,  0.049067674327419257, -0.427555093430282862, -0.803207531480646719, 
		-0.989176509964781681, -0.941544065183023138, -0.671558954847021994, -0.242980179903266591, 
		 0.242980179903263260,  0.671558954847019440,  0.941544065183022028,  0.989176509964780126, 
		 0.803207531480648718,  0.427555093430285971, -0.049067674327415822, -0.514102744193233874, 
		-0.857728610000273117, -0.998795456205171850, -0.903989293123440674, -0.595699304492438020, 
		-0.146730474455351367,  0.336889853392218552,  0.740951125354949891,  0.970031253194544640, 
	},{
		-0.980785280403230431, -0.831469612302545125, -0.555570233019601512, -0.195090322016128581, 
		 0.195090322016126888,  0.555570233019600179,  0.831469612302547123,  0.980785280403230875, 
		 0.980785280403230209,  0.831469612302545125,  0.555570233019602955,  0.195090322016130246, 
		-0.195090322016132162, -0.555570233019598736, -0.831469612302546235, -0.980785280403229209, 
		-0.980785280403230542, -0.831469612302542127, -0.555570233019604398, -0.195090322016124973, 
		 0.195090322016123530,  0.555570233019603177,  0.831469612302541350,  0.980785280403230209, 
		 0.980785280403229431,  0.831469612302539129,  0.555570233019611726,  0.195090322016133605, 
		-0.195090322016128803, -0.555570233019607618, -0.831469612302552230, -0.980785280403228543, 
	},{
		-0.989176509964781014, -0.903989293123443116, -0.740951125354959217, -0.514102744193222549, 
		-0.242980179903265509,  0.049067674327415579,  0.336889853392220384,  0.595699304492435910, 
		 0.803207531480644166,  0.941544065183021361,  0.998795456205172294,  0.970031253194545751, 
		 0.857728610000270564,  0.671558954847019440,  0.427555093430287303,  0.146730474455357668, 
		-0.146730474455361554, -0.427555093430278033, -0.671558954847022327, -0.857728610000272562, 
		-0.970031253194543197, -0.998795456205172738, -0.941544065183024803, -0.803207531480637615, 
		-0.595699304492427029, -0.336889853392216720, -0.049067674327418764,  0.242980179903258958, 
		 0.514102744193213668,  0.740951125354949891,  0.903989293123447779,  0.989176509964781903, 
	},{
		-0.995184726672196929, -0.956940335732209046, -0.881921264348354716, -0.773010453362737882, 
		-0.634393284163644267, -0.471396736825999751, -0.290284677254465051, -0.098017140329563809, 
		 0.098017140329564045,  0.290284677254465273,  0.471396736825999918,  0.634393284163647153, 
		 0.773010453362738104,  0.881921264348355605,  0.956940335732209157,  0.995184726672196929, 
		 0.995184726672196929,  0.956940335732208935,  0.881921264348355383,  0.773010453362737771, 
		 0.634393284163646820,  0.471396736825999529,  0.290284677254451229,  0.098017140329563560, 
		-0.098017140329571359, -0.290284677254458723, -0.471396736826006413, -0.634393284163641824, 
		-0.773010453362742767, -0.881921264348352385, -0.956940335732211267, -0.995184726672196263, 
	},{
		-0.998795456205172405, -0.989176509964781014, -0.970031253194544085, -0.941544065183020251, 
		-0.903989293123442783, -0.857728610000273228, -0.803207531480644166, -0.740951125354960771, 
		-0.671558954847017664, -0.595699304492435466, -0.514102744193227101, -0.427555093430284638, 
		-0.336889853392219440, -0.242980179903259930, -0.146730474455368354, -0.049067674327421214, 
		 0.049067674327418272,  0.146730474455365439,  0.242980179903257071,  0.336889853392216665, 
		 0.427555093430281974,  0.514102744193224548,  0.595699304492438797,  0.671558954847025991, 
		 0.740951125354968321,  0.803207531480638170,  0.857728610000268121,  0.903989293123441451, 
		 0.941544065183020473,  0.970031253194544640,  0.989176509964781903,  0.998795456205172849, 
	},{
		-1.000000000000000000, -1.000000000000000000, -1.000000000000000000, -1.000000000000000000, 
		-1.000000000000000000, -1.000000000000000000, -1.000000000000000000, -1.000000000000000000, 
		-1.000000000000000000, -1.000000000000000000, -1.000000000000000000, -1.000000000000000000, 
		-1.000000000000000000, -1.000000000000000000, -1.000000000000000000, -1.000000000000000000, 
		-1.000000000000000000, -1.000000000000000000, -1.000000000000000000, -1.000000000000000000, 
		-1.000000000000000000, -1.000000000000000000, -1.000000000000000000, -1.000000000000000000, 
		-1.000000000000000000, -1.000000000000000000, -1.000000000000000000, -1.000000000000000000, 
		-1.000000000000000000, -1.000000000000000000, -1.000000000000000000, -1.000000000000000000, 
	},{
		-0.998795456205172405, -0.989176509964781125, -0.970031253194543863, -0.941544065183020917, 
		-0.903989293123443671, -0.857728610000271008, -0.803207531480646053, -0.740951125354958440, 
		-0.671558954847020773, -0.595699304492433468, -0.514102744193225436, -0.427555093430283306, 
		-0.336889853392218552, -0.242980179903259458, -0.146730474455368326, -0.049067674327421699, 
		 0.049067674327417300,  0.146730474455363968,  0.242980179903268950,  0.336889853392214389, 
		 0.427555093430279365,  0.514102744193233874,  0.595699304492435688,  0.671558954847012224, 
		 0.740951125354964990,  0.803207531480643500,  0.857728610000265013,  0.903989293123444892, 
		 0.941544065183018142,  0.970031253194546306,  0.989176509964780681,  0.998795456205171739, 
	},{
		-0.995184726672196929, -0.956940335732208713, -0.881921264348354383, -0.773010453362736771, 
		-0.634393284163645932, -0.471396736825995866, -0.290284677254461276, -0.098017140329560382, 
		 0.098017140329559896,  0.290284677254460832,  0.471396736826001694,  0.634393284163648263, 
		 0.773010453362738659,  0.881921264348355827,  0.956940335732209157,  0.995184726672196929, 
		 0.995184726672196929,  0.956940335732209380,  0.881921264348356382,  0.773010453362739325, 
		 0.634393284163638049,  0.471396736825989982,  0.290284677254454948,  0.098017140329553804, 
		-0.098017140329566488, -0.290284677254467161, -0.471396736826001250, -0.634393284163647930, 
		-0.773010453362738326, -0.881921264348355605, -0.956940335732208935, -0.995184726672196818, 
	},{
		-0.989176509964781014, -0.903989293123443338, -0.740951125354959994, -0.514102744193220884, 
		-0.242980179903264204,  0.049067674327419986,  0.336889853392217387,  0.595699304492432913, 
		 0.803207531480645942,  0.941544065183019807,  0.998795456205172405,  0.970031253194545306, 
		 0.857728610000270120,  0.671558954847019107,  0.427555093430287303,  0.146730474455358167, 
		-0.146730474455360582, -0.427555093430276700, -0.671558954847020884, -0.857728610000278668, 
		-0.970031253194542531, -0.998795456205172183, -0.941544065183016476, -0.803207531480648718, 
		-0.595699304492430914, -0.336889853392208394, -0.049067674327424635,  0.242980179903266591, 
		 0.514102744193232208,  0.740951125354954443,  0.903989293123444448,  0.989176509964782680, 
	},{
		-0.980785280403230431, -0.831469612302545569, -0.555570233019602622, -0.195090322016126777, 
		 0.195090322016128220,  0.555570233019603843,  0.831469612302545458,  0.980785280403230209, 
		 0.980785280403230986,  0.831469612302543792,  0.555570233019607285,  0.195090322016128803, 
		-0.195090322016133133, -0.555570233019599069, -0.831469612302546235, -0.980785280403229098, 
		-0.980785280403230764, -0.831469612302542904, -0.555570233019606063, -0.195090322016141293, 
		 0.195090322016134576,  0.555570233019600290,  0.831469612302539129,  0.980785280403232207, 
		 0.980785280403230431,  0.831469612302550010,  0.555570233019592963,  0.195090322016125917, 
		-0.195090322016122086, -0.555570233019613391, -0.831469612302547900, -0.980785280403229653, 
	},{
		-0.970031253194543974, -0.740951125354958662, -0.336889853392219552,  0.146730474455360332, 
		 0.595699304492433468,  0.903989293123444115,  0.998795456205172183,  0.857728610000273117, 
		 0.514102744193222105,  0.049067674327416808, -0.427555093430284638, -0.803207531480647607, 
		-0.989176509964781903, -0.941544065183022916, -0.671558954847021994, -0.242980179903267063, 
		 0.242980179903262289,  0.671558954847018441,  0.941544065183021361,  0.989176509964782569, 
		 0.803207531480650494,  0.427555093430289079, -0.049067674327411916, -0.514102744193217887, 
		-0.857728610000270564, -0.998795456205172294, -0.903989293123443116, -0.595699304492431692, 
		-0.146730474455358167,  0.336889853392224992,  0.740951125354963658,  0.970031253194546084, 
	},{
		-0.956940335732208824, -0.634393284163645377, -0.098017140329559174,  0.471396736825996920, 
		 0.881921264348355272,  0.995184726672196707,  0.773010453362737326,  0.290284677254465051, 
		-0.290284677254464329, -0.773010453362736771, -0.995184726672196596, -0.881921264348357270, 
		-0.471396736826003859,  0.098017140329565516,  0.634393284163647597,  0.956940335732208935, 
		 0.956940335732209380,  0.634393284163648707,  0.098017140329566974, -0.471396736825989982, 
		-0.881921264348356604, -0.995184726672198150, -0.773010453362737771, -0.290284677254452117, 
		 0.290284677254456835,  0.773010453362740879,  0.995184726672195930,  0.881921264348354272, 
		 0.471396736825985707, -0.098017140329557703, -0.634393284163652482, -0.956940335732206715, 
	},{
		-0.941544065183020806, -0.514102744193221994,  0.146730474455360582,  0.740951125354958884, 
		 0.998795456205172405,  0.803207531480643944,  0.242980179903261345, -0.427555093430278921, 
		-0.903989293123442228, -0.970031253194544418, -0.595699304492428139,  0.049067674327418279, 
		 0.671558954847014000,  0.989176509964781236,  0.857728610000274116,  0.336889853392216221, 
		-0.336889853392218053, -0.857728610000275116, -0.989176509964781014, -0.671558954847023104, 
		-0.049067674327430505,  0.595699304492441128,  0.970031253194544862,  0.903989293123444448, 
		 0.427555093430289968, -0.242980179903277027, -0.803207531480649273, -0.998795456205172294, 
		-0.740951125354962437, -0.146730474455372711,  0.514102744193231320,  0.941544065183022472, 
	},{
		-0.923879532511286850, -0.382683432365090559,  0.382683432365089560,  0.923879532511286850, 
		 0.923879532511286405,  0.382683432365088283, -0.382683432365088505, -0.923879532511287849, 
		-0.923879532511286850, -0.382683432365092613,  0.382683432365090781,  0.923879532511288737, 
		 0.923879532511288626,  0.382683432365090337, -0.382683432365093057, -0.923879532511284296, 
		-0.923879532511287627, -0.382683432365088061,  0.382683432365082177,  0.923879532511285184, 
		 0.923879532511286738,  0.382683432365085785, -0.382683432365097609, -0.923879532511291623, 
		-0.923879532511291179, -0.382683432365096665,  0.382683432365086729,  0.923879532511287072, 
		 0.923879532511284851,  0.382683432365081289, -0.382683432365102105, -0.923879532511282631, 
	},{
		-0.903989293123443227, -0.242980179903263482,  0.595699304492433912,  0.998795456205172405, 
		 0.671558954847017442, -0.146730474455363247, -0.857728610000273006, -0.941544065183020029, 
		-0.336889853392217831,  0.514102744193217887,  0.989176509964780348,  0.740951125354961770, 
		-0.049067674327414358, -0.803207531480642944, -0.970031253194544751, -0.427555093430284638, 
		 0.427555093430279809,  0.970031253194543419,  0.803207531480637615,  0.049067674327419743, 
		-0.740951125354967655, -0.989176509964781125, -0.514102744193210337,  0.336889853392219440, 
		 0.941544065183025469,  0.857728610000272118,  0.146730474455375598, -0.671558954847018774, 
		-0.998795456205173071, -0.595699304492432469,  0.242980179903251381,  0.903989293123444004, 
	},{
		-0.881921264348355050, -0.098017140329560687,  0.773010453362737993,  0.956940335732208380, 
		 0.290284677254464329, -0.634393284163646598, -0.995184726672197151, -0.471396736825996476, 
		 0.471396736825995644,  0.995184726672196263,  0.634393284163641824, -0.290284677254463386, 
		-0.956940335732208158, -0.773010453362740879,  0.098017140329565017,  0.881921264348355383, 
		 0.881921264348356382,  0.098017140329566974, -0.773010453362739658, -0.956940335732208713, 
		-0.290284677254465273,  0.634393284163640381,  0.995184726672197928,  0.471396736826009854, 
		-0.471396736826007301, -0.995184726672197595, -0.634393284163642601,  0.290284677254462442, 
		 0.956940335732207825,  0.773010453362741434, -0.098017140329549904, -0.881921264348361711, 
	},{
		-0.857728610000272118,  0.049067674327417418,  0.903989293123442894,  0.803207531480645720, 
		-0.146730474455363497, -0.941544065183021250, -0.740951125354958440,  0.242980179903264454, 
		 0.970031253194544085,  0.671558954847013334, -0.336889853392219440, -0.989176509964781903, 
		-0.595699304492434467,  0.427555093430286859,  0.998795456205172294,  0.514102744193217887, 
		-0.514102744193219108, -0.998795456205172960, -0.427555093430285527,  0.595699304492435688, 
		 0.989176509964779571,  0.336889853392231431, -0.671558954847014444, -0.970031253194543641, 
		-0.242980179903256127,  0.740951125354949891,  0.941544065183023138,  0.146730474455362025, 
		-0.803207531480648718, -0.903989293123437676, -0.049067674327426591,  0.857728610000271119, 
	},{
		-0.831469612302545236,  0.195090322016128942,  0.980785280403230431,  0.555570233019602844, 
		-0.555570233019600956, -0.980785280403230209, -0.195090322016131218,  0.831469612302545125, 
		 0.831469612302543792, -0.195090322016133605, -0.980785280403229320, -0.555570233019604842, 
		 0.555570233019601956,  0.980785280403229986,  0.195090322016123030, -0.831469612302541905, 
		-0.831469612302547012,  0.195090322016127860,  0.980785280403228099,  0.555570233019597848, 
		-0.555570233019597071, -0.980785280403228321, -0.195090322016128803,  0.831469612302538574, 
		 0.831469612302542460, -0.195090322016122086, -0.980785280403232540, -0.555570233019602733, 
		 0.555570233019592186,  0.980785280403229431,  0.195090322016134576, -0.831469612302551120, 
	},{
		-0.803207531480644943,  0.336889853392220218,  0.998795456205172405,  0.242980179903264093, 
		-0.857728610000273228, -0.740951125354958329,  0.427555093430282196,  0.989176509964781125, 
		 0.146730474455356696, -0.903989293123445004, -0.671558954847016221,  0.514102744193223327, 
		 0.970031253194543752,  0.049067674327418272, -0.941544065183020362, -0.595699304492435244, 
		 0.595699304492430581,  0.941544065183017476, -0.049067674327426598, -0.970031253194545862, 
		-0.514102744193216221,  0.671558954847022438,  0.903989293123441451, -0.146730474455364940, 
		-0.989176509964781236, -0.427555093430281086,  0.740951125354959106,  0.857728610000272562, 
		-0.242980179903261817, -0.998795456205172183, -0.336889853392224048,  0.803207531480641723, 
	},{
		-0.773010453362736882,  0.471396736825997364,  0.956940335732209380, -0.098017140329560992, 
		-0.995184726672196818, -0.290284677254461276,  0.881921264348356604,  0.634393284163646820, 
		-0.634393284163640381, -0.881921264348353828,  0.290284677254460111,  0.995184726672196263, 
		 0.098017140329558675, -0.956940335732207936, -0.471396736825992146,  0.773010453362737771, 
		 0.773010453362739325, -0.471396736825989982, -0.956940335732208713,  0.098017140329570387, 
		 0.995184726672195930,  0.290284677254462442, -0.881921264348359379, -0.634393284163653259, 
		 0.634393284163644933,  0.881921264348351053, -0.290284677254452117, -0.995184726672197040, 
		-0.098017140329552832,  0.956940335732205605,  0.471396736825999529, -0.773010453362741545, 
	},{
		-0.740951125354959106,  0.595699304492432691,  0.857728610000272451, -0.427555093430282973, 
		-0.941544065183019807,  0.242980179903264926,  0.989176509964781125, -0.049067674327415586, 
		-0.998795456205172183, -0.146730474455360582,  0.970031253194545529,  0.336889853392222216, 
		-0.903989293123444670, -0.514102744193226657,  0.803207531480644610,  0.671558954847014777, 
		-0.671558954847015444, -0.803207531480644055,  0.514102744193215333,  0.903989293123438120, 
		-0.336889853392223160, -0.970031253194545306,  0.146730474455375626,  0.998795456205172183, 
		 0.049067674327421699, -0.989176509964779127, -0.242980179903257071,  0.941544065183020140, 
		 0.427555093430291744, -0.857728610000276670, -0.595699304492433357,  0.740951125354953222, 
	}
};

static final float Resample[][] = {  //0: 48000 to 32000, 1: 48000 to 44100
	{
		-1, 0, 0.5f    // write pcm, save act pcm, save act pcm before recalc to new pcm
	},{
		-1, 0, 
		0.088435374f, 0.17687075f, 0.26530612f, 0.3537415f, 0.44217688f, 0.53061223f, 0.61904764f, 0.707483f, 0.79591835f, 0.88435376f, 0.9727891f, 0,
		0.06122449f, 0.14965986f, 0.23809524f, 0.3265306f, 0.414966f, 0.50340134f, 0.59183675f, 0.6802721f, 0.76870745f, 0.85714287f, 0.9455782f, 0,
		0.034013607f, 0.12244898f, 0.21088435f, 0.2993197f, 0.3877551f, 0.47619048f, 0.56462586f, 0.6530612f, 0.7414966f, 0.829932f, 0.9183673f, 0,
		0.006802721f, 0.0952381f, 0.18367347f, 0.27210885f, 0.3605442f, 0.4489796f, 0.53741497f, 0.6258503f, 0.71428573f, 0.8027211f, 0.89115644f, 0.97959185f, 0,
		0.06802721f, 0.15646258f, 0.24489796f, 0.33333334f, 0.4217687f, 0.5102041f, 0.5986394f, 0.68707484f, 0.7755102f, 0.8639456f, 0.95238096f, 0,
		0.040816326f, 0.1292517f, 0.21768707f, 0.30612245f, 0.39455783f, 0.4829932f, 0.5714286f, 0.65986395f, 0.7482993f, 0.8367347f, 0.92517006f, 0,
		0.013605442f, 0.10204082f, 0.1904762f, 0.27891156f, 0.36734694f, 0.45578232f, 0.5442177f, 0.63265306f, 0.7210884f, 0.8095238f, 0.8979592f, 0.9863946f, 0,
		0.07482993f, 0.1632653f, 0.25170067f, 0.34013605f, 0.42857143f, 0.5170068f, 0.60544217f, 0.6938776f, 0.7823129f, 0.8707483f, 0.9591837f, 0,
		0.04761905f, 0.13605443f, 0.2244898f, 0.31292516f, 0.40136054f, 0.48979592f, 0.5782313f, 0.6666667f, 0.75510204f, 0.8435374f, 0.9319728f, 0,
		0.020408163f, 0.108843535f, 0.19727892f, 0.2857143f, 0.37414965f, 0.46258503f, 0.5510204f, 0.6394558f, 0.72789115f, 0.81632656f, 0.9047619f, 0.99319726f, 0,
		0.08163265f, 0.17006803f, 0.2585034f, 0.3469388f, 0.43537414f, 0.52380955f, 0.6122449f, 0.70068026f, 0.78911567f, 0.877551f, 0.9659864f, 0,
		0.054421768f, 0.14285715f, 0.23129252f, 0.3197279f, 0.40816328f, 0.49659863f, 0.585034f, 0.67346936f, 0.7619048f, 0.8503401f, 0.93877554f, 0,
		0.027210884f, 0.11564626f, 0.20408164f, 0.292517f, 0.3809524f, 0.46938777f, 0.5578231f, 0.64625853f, 0.7346939f, 0.82312924f, 0.91156465f
	}
};

static final int Resample_frequency[][] = {  //0: 48000 to 32000, 1: 48000 to 44100
	{ 2, 3 },
	{ 147, 160 }
};

public static byte RIFF[] = {
	0x52, 0x49, 0x46, 0x46, //RIFF
	0, 0, 0, 0,   //32-bit filesize-8
	0x57, 0x41, 0x56, 0x45, //WAVE
	0x66, 0x6d, 0x74, 0x20, //fmt  chunk
	0, 0, 0, 0, //chunk size
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0x64, 0x61, 0x74, 0x61, //data chunk
	0, 0, 0, 0  //chunk size
};

//DM07022004 081.6 int16 new
public static byte AIFF[] = {
	0x46, 0x4F, 0x52, 0x4D, //FORM
	0, 0, 0, 0, //32-bit filesize-8
	0x41, 0x49, 0x46, 0x46, //AIFF
	0x43, 0x4F, 0x4D, 0x4D, //COMM chunk
	0, 0, 0, 0x12, //chunk size
	0, 0,  // number of channels
	0, 0, 0, 0, // number of samples
	0, 0, // bits per sample
	0, 0, 0, 0, // sample rate + ?
	0, 0, 0, 0, 0, 0, 
	0x53, 0x53, 0x4E, 0x44, //SSND chunk
	0, 0, 0, 0  //chunk size
};


static class HEADER { 
	int ID;
	int layer;
	int protection_bit;
	int bitrate_index;
	int sampling_frequency;
	int new_sampling_frequency=0; //DM30122003 081.6 int10 add
	int padding_bit;
	int private_bit;
	int mode;
	int mode_extension;
	int copyright;
	int original;
	int channel;
	int newchannel=0; //DM30122003 081.6 int10 changed
	int bound;
	int emphasis;
	int sblimit;
	int framesize;
	int bits_per_sample;

	public HEADER() {
		return;

	}
}

static class WORK { 
	double area[] = new double[2048];
	int offset;

	public WORK() {
		return;
	}
}


private static byte[] buf;
private static boolean[] Bits;
private static int BitPos=0, BufferPos=0, resample=0, Frame=0;
private static HEADER head = new HEADER();
private static WORK work = new WORK();
private static ByteArrayOutputStream out1 = new ByteArrayOutputStream();
private static ByteArrayOutputStream out2 = new ByteArrayOutputStream();
private static double saveS[] = new double[2]; //DM14052004 081.7 int02 changed

public static boolean PRESCAN = false;

private static int LEFT_RIGHT = 0;
public static boolean MOTOROLA=false, DOWNSAMPLE=false, DOWNMIX=false, 
		WAVE=true, MONO=false, RESET=false, NORMALIZE=false;

public static double MULTIPLY = 1; //DM10042004 081.7 int01 changed
public static int MAX_VALUE = 32767; //DM10042004 081.7 int01 add


public static int check_sync() {
	if ( (0xFF&buf[BufferPos]) != 0xFF || (0xF0&buf[BufferPos+1]) != 0xF0) 
		return 0;
	else 
		return 1;
}

/***
public static void loadbits(int size) {
	BitPos = BufferPos<<3;
	BufferPos += size;
}

public static int getbits(int N) {
	int Pos, Val;
	Pos = BitPos>>>3;
	Val =   (0xFF&buf[Pos])<<24 |
		(0xFF&buf[Pos+1])<<16 |
		(0xFF&buf[Pos+2])<<8 |
		(0xFF&buf[Pos+3]);
	Val <<= BitPos & 7;
	Val >>>= 32-N;
	BitPos += N;
	return Val;
}
***/

public static void loadbits(int size)
{
	Bits = new boolean[size*8];
	BitPos = 0;

	for (int a=0; a < size; a++)
		for (int b=0; b < 8; b++)
			if (((0x80>>>b) & buf[BufferPos + a]) != 0)
				Bits[(a * 8) + b] = true;

	BufferPos += size;
}

//DM10062004 081.7 int04 fixed
public static int getbits(int N)
{
	int Val=0;

	for (int a = 0; a < N && BitPos + a < Bits.length; a++)
		if (Bits[BitPos + a])
			Val |= 1<<(N - 1 - a);

	BitPos += N;
	return Val;
}

//DM10062004 081.7 int04 fixed
public static int showbits(int N)
{
	int Val=0;

	for (int a = 0; a < N && BitPos + a < Bits.length; a++)
		if (Bits[BitPos + a])
			Val |= 1<<(N-1-a);

	return Val;
}

public static void flushbits(int N) {
	BitPos += N;
}

public static void flushBuffer(int N) {
	BufferPos += N;
}

	/**
	 *
	 */
	private static byte[] intel_ByteOrder(short value)
	{
		byte b[] = new byte[2];

		if (!MOTOROLA)
		{
			b[0] = (byte)(value & 0xFF);
			b[1] = (byte)(value>>>8 & 0xFF);
		}

		else
		{
			b[0] = (byte)(value>>>8 & 0xFF);
			b[1] = (byte)(value & 0xFF);
		}

		return b;
	}

	/**
	 *
	 */
	private static void writeSample(ByteArrayOutputStream baos, short value) throws IOException
	{
		if (PRESCAN)
			return;

		baos.write(intel_ByteOrder(value));
	}

//DM30122003 081.6 int10 changed & moved+
final static int bitrate[][][] = {
	{
		{-1,8000,16000,24000,32000,40000,48000,56000,64000,
		80000,96000,112000,128000,144000,160000,0 },		//MPG-2, L3
		{-1,8000,16000,24000,32000,40000,48000,56000,64000,80000, //MPG-2, L2
		96000,112000,128000,144000,160000,0 },
		{-1,32000,48000,56000,64000,80000,96000,112000,128000, //MPG-2, L1
		144000,160000,176000,192000,224000,256000,0 }
	},{
		{-1,32000,40000,48000,56000,64000,80000,96000,
		112000,128000,160000,192000,224000,256000,320000, 0 },	//MPG-1, L3
		{-1, 32000, 48000, 56000, 64000, 80000, 96000, 112000,    //MPG-1, L2
		128000, 160000, 192000, 224000, 256000, 320000, 384000, 0 },
		{-1,32000,64000,96000,128000,160000,192000,224000,     //MPG-1, L1
		256000,288000,320000,352000,384000,416000,448000,0 }
	},{
		{-1, 6000, 8000, 10000, 12000, 16000, 20000, 24000,    //MPG-2.5, L3??
		28000, 320000, 40000, 48000, 56000, 64000, 80000, 0 },
		{-1, 6000, 8000, 10000, 12000, 16000, 20000, 24000,    //MPG-2.5, L2
		28000, 320000, 40000, 48000, 56000, 64000, 80000, 0 },
		{-1, 8000, 12000, 16000, 20000, 24000, 32000, 40000,    //MPG-2.5, L1
		48000, 560000, 64000, 80000, 96000, 112000, 128000, 0 }
	}
};


final static int frequency[][] = { 
	{ 22050,24000,16000,0 },  //MPG-2
	{ 44100,48000,32000,0 },   //MPG-1
	{ 11025,12000,8000,0 }  //MPG-2.5
}; 
//DM30122003 081.6 int10 moved-

public static int parse_header() {

	int channel_bitrate, newfrequency=0;
	int sblimit = 32;

	head.ID = 1&buf[BufferPos+1]>>>3;
	head.emphasis = 3&buf[BufferPos+3];

	if (head.ID==1 && head.emphasis==2)
		head.ID = 2;

	if ( (head.layer = 3&buf[BufferPos+1]>>>1) < 1) //DM30122003 081.6 int10 changed
		return -3;

	head.protection_bit = (1&buf[BufferPos+1]) ^ 1;

	if ( (head.bitrate_index = bitrate[head.ID][head.layer-1][0xF&buf[BufferPos+2]>>>4]) < 1) //DM30122003 081.6 int10 changed 
		return -4;

	if ( (newfrequency = frequency[head.ID][3&buf[BufferPos+2]>>>2]) == 0) 
		return -5;

	head.sampling_frequency = newfrequency;
	head.padding_bit = 1&buf[BufferPos+2]>>>1;
	head.private_bit = 1&buf[BufferPos+2];

	head.mode = 3&buf[BufferPos+3]>>>6;
	head.mode_extension = 3&buf[BufferPos+3]>>>4;;
	if (head.mode==0) 
		head.mode_extension=0;

	switch(head.mode){
	case 0: 	/* stereo */
	case 2: {	/* dual channel */
		head.channel = 2;
		head.bound = sblimit;
		break; 
	}
	case 1: {	/* intensity stereo */
		head.channel = 2;
		head.bound = (head.mode_extension + 1) << 2;
		break; 
	}
	case 3: {	/* monaural */
		head.channel = 1;
		head.bound = sblimit;
		break;
	}
	}

	head.copyright = 1&buf[BufferPos+3]>>>3;
	head.original = 1&buf[BufferPos+3]>>>2;

	if (head.ID==1 && head.layer==2) {	// MPEG-1
		if(head.channel == 2) {
			channel_bitrate = head.bitrate_index / 2;
			if(channel_bitrate < 32000) 
				return -6; /* unsupported bitrate */
		} else {
			channel_bitrate = head.bitrate_index;
			if(channel_bitrate > 192000) 
				return -7; /* unsupported bitrate */
		}
	
		if (channel_bitrate < 56000) {
			if(head.sampling_frequency == 32000) 
				head.sblimit = 12;
			else 
				head.sblimit = 8;
		} else if (channel_bitrate < 96000) 
			head.sblimit = 27;
		else {
			if (head.sampling_frequency == 48000) 
				head.sblimit = 27;
			else 
				head.sblimit = 30;
		}
		if (head.bound > head.sblimit) 
			head.bound = head.sblimit;
	} else if (head.layer==2) {		// MPEG-2
		head.sblimit = 30;
	}

	head.bits_per_sample=16;

	flushBuffer(4);
	if(head.protection_bit>0) flushBuffer(2);
	if (head.layer==2) {
		if (head.bound > head.sblimit) 
			head.bound = head.sblimit;
		head.framesize = 144*head.bitrate_index/head.sampling_frequency+head.padding_bit;
		return 2;
	}else if (head.layer==1) { //DM30122003 081.6 int10 new
		if (head.bound > head.sblimit) 
			head.bound = head.sblimit;
		head.framesize = 144*head.bitrate_index/head.sampling_frequency+head.padding_bit;
		return 1;
	} else {
		head.sblimit = 32;
		head.framesize = (12*head.bitrate_index/head.sampling_frequency+head.padding_bit)*4;
		return 3;
	}
}


public static int decode_layer2() throws IOException {

	loadbits(head.framesize-4-(head.protection_bit*2));

	short[] pcm = new short[2];
	int i,j,k,n,m;
	int step;
	int bits;
	int o1,o2;
	int code;
	int sb,ch,gr;

	int[][] allocation = new int[32][2];
	int[][] scfsi = new int[32][2];
	int[][][] scalefactor = new int[32][2][3];
	double[][][][] sample = new double[12][3][32][2];

	double[] U = new double[1024];
	double[] W = new double[1024];

	double[] s = new double[2];
	int[] ss = new int[2];
	
	final int[] table_nbal;
	final int[][] table_alloc;

	if (head.ID==1) {
		if(head.sblimit > 20) {
			table_nbal = table_b2ab_nbal;
			table_alloc = table_b2ab;
		} else {
			table_nbal = table_b2cd_nbal;
			table_alloc = table_b2cd;
		}
	} else {
		table_nbal = table_MPG2_nbal;
		table_alloc = table_MPG2;
	}

	/* read allocation */
	for(sb=0;sb<head.bound;sb++){
		for(ch=0;ch<head.channel;ch++){
			allocation[sb][ch] = table_alloc[sb][getbits(table_nbal[sb])];
		}
	}

	for(sb=head.bound;sb<head.sblimit;sb++){
		allocation[sb][0] = allocation[sb][1] = table_alloc[sb][getbits(table_nbal[sb])];
	}
	
	/* read scalefactor selection information */
	for(sb=0;sb<head.sblimit;sb++){ 
		for(ch=0;ch<head.channel;ch++){
			if(allocation[sb][ch]>0) scfsi[sb][ch] = getbits(2);
		}
	}

	/* read scalefactor */
	for(sb=0;sb<head.sblimit;sb++){
		for(ch=0;ch<head.channel;ch++){
			if(allocation[sb][ch]>0){
				scalefactor[sb][ch][0] = getbits(6);
				switch(scfsi[sb][ch]){
				case 0: {
					scalefactor[sb][ch][1] = getbits(6);
					scalefactor[sb][ch][2] = getbits(6);
					break; }
				case 1: {
					scalefactor[sb][ch][1] = scalefactor[sb][ch][0];
					scalefactor[sb][ch][2] = getbits(6);
					break; }
				case 2: {
					scalefactor[sb][ch][2] = scalefactor[sb][ch][1] = scalefactor[sb][ch][0];
					break; }
				case 3: {
					scalefactor[sb][ch][2] = scalefactor[sb][ch][1] = getbits(6);
					break; }
				}
			}
		}
	}

	/* read sample and requantize and normalize */
	for(gr=0;gr<12;gr++){
		for(sb=0;sb<head.bound;sb++){
			for(ch=0;ch<head.channel;ch++){
				n = allocation[sb][ch];
				if(n == 0){ // samples are already zero
				}else if(n < 4){
					bits = (int)table_b4[n][2]; //bits
					step = (int)table_b4[n][3]; //step
					code = getbits(bits);
					for(i=0;i<3;i++){
						m = code % step;
						m -= (step-1);
						sample[gr][i][sb][ch] = m;
						sample[gr][i][sb][ch] /= (step-1);
						sample[gr][i][sb][ch] += table_b4[n][1]; // d
						sample[gr][i][sb][ch] *= table_b4[n][0]; // c
						sample[gr][i][sb][ch] *= table_b1[scalefactor[sb][ch][gr>>>2]];
						code /= step;
					}
				}else{
					bits = (int)table_b4[n][2]; //bits
					step = (int)table_b4[n][3]; //step
					for(i=0;i<3;i++){
						m = getbits(bits);
						m -= step;
						sample[gr][i][sb][ch] = m;
						sample[gr][i][sb][ch] /= step;
						sample[gr][i][sb][ch] += table_b4[n][1]; // d
						sample[gr][i][sb][ch] *= table_b4[n][0]; // c
						sample[gr][i][sb][ch] *= table_b1[scalefactor[sb][ch][gr>>>2]];
					}
				}
			}
		}
		for(sb=head.bound;sb<head.sblimit;sb++){
			n = allocation[sb][0];
			if(n == 0){ // samples are already zero
			}else if(n < 4){
				bits = (int)table_b4[n][2]; //bits
				step = (int)table_b4[n][3]; //step
				code = getbits(bits);
				for(i=0;i<3;i++){
					m = code % step;
					m -= (step-1);
					sample[gr][i][sb][0] = m;
					sample[gr][i][sb][0] /= (step-1);
					sample[gr][i][sb][0] += table_b4[n][1]; // d
					sample[gr][i][sb][0] *= table_b4[n][0]; // c
					sample[gr][i][sb][1] = sample[gr][i][sb][0];
					sample[gr][i][sb][0] *= table_b1[scalefactor[sb][0][gr>>>2]];
					sample[gr][i][sb][1] *= table_b1[scalefactor[sb][1][gr>>>2]];
					code /= step;
				}
			}else{
				bits = (int)table_b4[n][2]; //bits
				step = (int)table_b4[n][3]; //step
				for(i=0;i<3;i++){
					m = getbits(bits);
					m -= step;
					sample[gr][i][sb][0] = m;
					sample[gr][i][sb][0] /= step;
					sample[gr][i][sb][0] += table_b4[n][1]; // d
					sample[gr][i][sb][0] *= table_b4[n][0]; // c
					sample[gr][i][sb][1] = sample[gr][i][sb][0];
					sample[gr][i][sb][0] *= table_b1[scalefactor[sb][0][gr>>>2]];
					sample[gr][i][sb][1] *= table_b1[scalefactor[sb][1][gr>>>2]];
				}
			}
		}

		/** downmix */
		if (DOWNMIX && head.channel==2) {  //12,3,32,2
			for (sb=0;sb<32;sb++)
				for (i=0;i<3;i++)
			sample[gr][i][sb][0] = (sample[gr][i][sb][0] + sample[gr][i][sb][1]) * 0.5f;
		}

	}

	/** downmix */
	if (DOWNMIX && head.channel==2) 
		head.newchannel=1;

	else 
		head.newchannel=2;

	int channel = head.channel;
	int last_resample = resample;

	writeLoop:
	while (true)
	{
		out1.reset();
		out2.reset();

		resample = last_resample;

		// subband synthesis
		for(gr = 0; gr < 12; gr++)
		{
			for(m = 0; m < 3; m++)
			{
				// shifting
				work.offset -= 128;
				work.offset &= 0x7FF;

				// matrixing
				for(i = 0; i < 64; i++)
				{
					j = work.offset + i * 2;

					for(ch = 0; ch < head.channel; ch++)
					{
						work.area[j + ch] = table_Nik[i][0] * sample[gr][m][0][ch];

						for(k = 1; k < head.sblimit; k++)
							work.area[j + ch] += table_Nik[i][k] * sample[gr][m][k][ch];
					}
				}

				// build vector U
				for(i = 0; i < 8; i++)
				{
					j = work.offset + i * 256;

					o1 = j & 0x7FF;
					o2 = (j + 192) & 0x7FF;

					for(k = 0; k < 32; k++)
					{
						j = (i * 64 + k) * 2;
						n = o1 + k * 2;

						U[j] = work.area[n];
						U[j + 1] = work.area[n + 1];

						j = (i * 64 + 32 + k) * 2;
						n = o2 + k * 2;

						U[j] = work.area[n];
						U[j + 1] = work.area[n + 1];
					}
				}

				// window
				for(i = 0; i < 512; i++)
				{
					j = i * 2;

					W[j] = U[j] * table_b3[i];
					W[j + 1] = U[j + 1] * table_b3[i];
				}

				// calc sample
				for(i = 0; i < 32; i++)
				{
					j = i * 2;

					s[0] = W[j];
					s[1] = W[j + 1];

					for(k = 1; k < 16; k++)
					{
						j = (32 * k + i) * 2;

						s[0] += W[j];
						s[1] += W[j + 1];
					}

					s[0] *= 32768;
					s[1] *= 32768;

					if (resample == Resample[LEFT_RIGHT>>>3 & 1].length)
						resample = 0;

					if (head.sampling_frequency == 48000 && (LEFT_RIGHT & 0xC) != 0)  //resample
					{
						double interpolator = Resample[LEFT_RIGHT>>>3 & 1][resample];

						if (interpolator == -1)
							resample++;

						if (interpolator == 0)
						{
							resample++;
							System.arraycopy(s, 0, saveS, 0, 2);
							continue;
						}
						else if (interpolator > 0)
						{
							resample++;
							double saveS2[] = new double[2];
							System.arraycopy(s, 0, saveS2, 0, 2);
							s[0] = interpolator * s[0] + (1 - interpolator) * saveS[0];
							s[1] = interpolator * s[1] + (1 - interpolator) * saveS[1];
							System.arraycopy(saveS2, 0, saveS, 0, 2);
						}
					}

					ss[0] = (int)(s[0] * MULTIPLY);
					ss[1] = (int)(s[1] * MULTIPLY);

					if(ss[0] > MAX_VALUE)
					{
						if (NORMALIZE)
							MULTIPLY = 1.0 * MAX_VALUE / s[0];

						pcm[0] = (short)MAX_VALUE;
					}

					else if(ss[0] < -(MAX_VALUE + 1))
					{
						if (NORMALIZE)
							MULTIPLY = Math.abs(1.0 * -(MAX_VALUE + 1) / s[0]);

						pcm[0] = (short)(-(MAX_VALUE + 1));
					}

					else
					{
						pcm[0] = (short)ss[0];
					}

					if(ss[1] > MAX_VALUE)
					{
						if (NORMALIZE)
							MULTIPLY = 1.0 * MAX_VALUE / s[1];

						pcm[1] = (short)MAX_VALUE;
					}

					else if(ss[1] < -(MAX_VALUE + 1))
					{
						if (NORMALIZE)
							MULTIPLY = Math.abs(1.0 * -(MAX_VALUE + 1) / s[1]);

						pcm[1] = (short)(-(MAX_VALUE + 1));
					}

					else
					{
						pcm[1] = (short)ss[1];
					}

					if ((LEFT_RIGHT & 1) != 1)  // exchange r<->l
						writeSample(out1, pcm[0]);

					else 
						writeSample(out1, pcm[1]);

					if (!MONO)
					{
						if (head.channel == 1)
						{ 
							if ((LEFT_RIGHT & 1) != 1) 
								writeSample(out1, pcm[0]);

							else 
								writeSample(out1, pcm[1]);

							channel = 2;
						}

						else
						{
							if ((LEFT_RIGHT & 1) != 1) 
								writeSample(out1, pcm[1]);

							else 
								writeSample(out1, pcm[0]);
						}
					}

					else
					{
						channel = 1;
						writeSample(out2, pcm[1]);
					}

					if (DOWNSAMPLE) 
						i++;
				}
			}
		}

		break;
	}

	head.newchannel = channel;

	return 1;
}


public static int decode_layer1() throws IOException {

	out1.reset();
	out2.reset();

	loadbits(head.framesize-4-(head.protection_bit*2));

	short pcm[] = new short[2];
	int i,k,n,gr;
	int o1,o2;
	
	int sb,ch;

	int allocation[][] = new int[32][2];
	int scalefactor[][] = new int[32][2];
	int sample[][][] = new int[12][32][2];
	double fraction[][][] = new double[12][32][2];

	double U[] = new double[1024];
	double W[] = new double[1024];

	double s[] = new double[2];
	int ss[] = new int[2];

	/* read allocation */
	for(sb=0;sb<head.bound;sb++){
		for(ch=0;ch<head.channel;ch++){
			allocation[sb][ch] = getbits(4);
		}
	}

	for(sb=head.bound;sb<head.sblimit;sb++){
		allocation[sb][0] = allocation[sb][1] = getbits(4);
	}
	
	/* read scalefactor */
	for(sb=0;sb<head.sblimit;sb++){
		for(ch=0;ch<head.channel;ch++){
			if(allocation[sb][ch]>0){
				scalefactor[sb][ch] = getbits(6);
			}
		}
	}


  // lay1 s = (s' + 2^(-nb+1) ) * 2^nb / (2^nb-1) , lay2 s = s' * c + d
  // read 1 sample of each allocated subband per channel, then continue with next sample for each sb , -> do this ever for 12samples per frame

	/* read sample and requantize and normalize */
	for (gr=0;gr<12;gr++) {
		for(sb=0;sb<head.bound;sb++){
			for(ch=0;ch<head.channel;ch++){
				if ( (n = allocation[sb][ch]) > 0) { // samples of interest
					sample[gr][sb][ch] = getbits(++n);  //read sample (read alloc +1 bit mehr = sample)
	
					if (((sample[gr][sb][ch]>>n-1) &1) != 1) fraction[gr][sb][ch] = -1.0;
	
					fraction[gr][sb][ch] += (double)(sample[gr][sb][ch] & ((1<<n-1)-1)) / (double) (1L<<n-1);
					fraction[gr][sb][ch] =  (double)(fraction[gr][sb][ch]+1.0/(double)(1L<<n-1)) * (double) (1L<<n) / (double) ((1L<<n)-1);
					fraction[gr][sb][ch] *= table_b1[scalefactor[sb][ch]];
				}
			}
		}
		for(sb=head.bound;sb<head.sblimit;sb++){
			if ( (n = allocation[sb][0]) > 0) { // samples of interest
				sample[gr][sb][0] = getbits(++n);  //read sample

				if (((sample[gr][sb][0]>>n-1) &1) != 1) fraction[gr][sb][0] = -1.0;

				fraction[gr][sb][0] += (double)(sample[gr][sb][0] & ((1<<n-1)-1)) / (double) (1L<<n-1);
				
				fraction[gr][sb][1] = fraction[gr][sb][0] = (double)(fraction[gr][sb][0]+1.0/(double)(1L<<n-1)) * (double) (1L<<n) / (double) ((1L<<n)-1);
				fraction[gr][sb][0] *= table_b1[scalefactor[sb][0]];
				fraction[gr][sb][1] *= table_b1[scalefactor[sb][1]];
			}
		}

		/** downmix */
		if (DOWNMIX && head.channel==2) {  //12,32,2
			for (sb=0;sb<head.sblimit;sb++)
			fraction[gr][sb][0] = (fraction[gr][sb][0] + fraction[gr][sb][1]) * 0.5f;
		}

	}

	/** downmix */
	if (DOWNMIX && head.channel==2) head.newchannel=1;
	else head.newchannel=2;
	int channel=head.channel;

	/* subband synthesis */
	for (gr=0;gr<12;gr++) {
		/* shifting */
		work.offset -= 128;
		work.offset &= 2047;
		/* matrixing */
		for(i=0;i<64;i++){
			for(ch=0;ch<head.channel;ch++){
				work.area[work.offset+i*2+ch] = table_Nik[i][0] * fraction[gr][0][ch];
				for(k=1;k<head.sblimit;k++){
					work.area[work.offset+i*2+ch] += table_Nik[i][k] * fraction[gr][k][ch];
				}
			}
		}

		/* build vector U */
		for(i=0;i<8;i++){
			o1 = (work.offset + i*256) & 2047;
			o2 = (work.offset + i*256 + 192) & 2047;
			for(k=0;k<32;k++){
				U[(i*64+k)*2+0] = work.area[o1+k*2+0];
				U[(i*64+k)*2+1] = work.area[o1+k*2+1];
				U[(i*64+32+k)*2+0] = work.area[o2+k*2+0];
				U[(i*64+32+k)*2+1] = work.area[o2+k*2+1];
			}
		}

		/* window */
		for(i=0;i<512;i++){
			W[i*2+0] = U[i*2+0]*table_b3[i];
			W[i*2+1] = U[i*2+1]*table_b3[i];
		}

		/* calc sample */
		for(i=0;i<32;i++){
			s[0] = W[i*2+0];
			s[1] = W[i*2+1];
			for(k=1;k<16;k++){
				s[0] += W[(32*k+i)*2+0];
				s[1] += W[(32*k+i)*2+1];
			}

			//DM10042004 081.7 int01 changed+
			s[0] *= 32768;
			s[1] *= 32768;

			//DM14052004 081.7 int02 changed++
			if (resample == Resample[LEFT_RIGHT>>>3 & 1].length)
				resample=0;

			if (head.sampling_frequency == 48000 && (LEFT_RIGHT & 0xC) != 0)  //resample
			{
				double interpolator = Resample[LEFT_RIGHT>>>3 & 1][resample];
				if (interpolator == -1)
					resample++;

				if (interpolator == 0)
				{
					resample++;
					System.arraycopy(s, 0, saveS, 0, 2);
					continue;
				}
				else if (interpolator > 0)
				{
					resample++;
					double saveS2[] = new double[2];
					System.arraycopy(s, 0, saveS2, 0, 2);
					s[0] = interpolator * s[0] + (1 - interpolator) * saveS[0];
					s[1] = interpolator * s[1] + (1 - interpolator) * saveS[1];
					System.arraycopy(saveS2, 0, saveS, 0, 2);
				}
			}
			//DM14052004 081.7 int02 changed++

			ss[0] = (int)(s[0] * MULTIPLY);
			ss[1] = (int)(s[1] * MULTIPLY);

			if(ss[0] > MAX_VALUE)
			{
				if (NORMALIZE)
					MULTIPLY = 1.0 * MAX_VALUE / s[0];

				pcm[0] = (short)MAX_VALUE;
			}
			else if(ss[0] < -(MAX_VALUE+1))
			{
				if (NORMALIZE)
					MULTIPLY = Math.abs(1.0 * -(MAX_VALUE+1) / s[0]);

				pcm[0] = (short)(-(MAX_VALUE+1));
			}
			else
			{
				pcm[0] = (short)ss[0];
			}

			if(ss[1] > MAX_VALUE)
			{
				if (NORMALIZE)
					MULTIPLY = 1.0 * MAX_VALUE / s[1];

				pcm[1] = (short)MAX_VALUE;
			}
			else if(ss[1] < -(MAX_VALUE+1))
			{
				if (NORMALIZE)
					MULTIPLY = Math.abs(1.0 * -(MAX_VALUE+1) / s[1]);

				pcm[1] = (short)(-(MAX_VALUE+1));
			}
			else
			{
				pcm[1] = (short)ss[1];
			}
			//DM10042004 081.7 int01 changed-

			if ((LEFT_RIGHT & 1) != 1)
				writeSample(out1, pcm[0]);

			else
				writeSample(out1, pcm[1]);
			
			if (!MONO)
			{
				if (head.channel==1)
				{ 
					if ((LEFT_RIGHT & 1) != 1)
						writeSample(out1, pcm[0]);

					else
						writeSample(out1, pcm[1]);

					channel=2;
				}
				else
				{
					if ((LEFT_RIGHT & 1) != 1) 
						writeSample(out1, pcm[1]);

					else 
						writeSample(out1, pcm[0]);
				}
			}
			else 
				channel=1;

			if (DOWNSAMPLE) 
				i++;
		}
	}

	head.newchannel = channel;

	return 1;
}

	/**
	 *
	 */
	public static void init_work(int resample_type)
	{
		Arrays.fill(work.area, 0.0);
		work.offset = 0;
		resample = 0;
		Frame = 0;
		BufferPos = 0;
		saveS = new double[2];
		LEFT_RIGHT = resample_type<<2;
	}

	/**
	 *
	 */
	private static int littleEndian(int data, int flag)
	{
		if (MOTOROLA) 
			return data;

		if (flag == 4) 
			return ( (0xFF & data>>>24) | (0xFF & data>>>16)<<8 | (0xFF & data>>>8)<<16 | (0xFF & data)<<24 );

		else 
			return ( (0xFF & data>>>8) | (0xFF & data)<<8 );
	}

	/**
	 *
	 */
	public static void fillAiff(String file, long playtime, boolean fade, int fade_millis) throws IOException
	{
		//always MSB
		RandomAccessFile aiff = new RandomAccessFile(file,"rw");

		int len = (int)(aiff.length() - 8);

		if (DOWNSAMPLE) 
			head.sampling_frequency /= 2;

		else if ((LEFT_RIGHT & 0xC) != 0 && head.sampling_frequency == 48000) 
			head.sampling_frequency = (head.sampling_frequency * Resample_frequency[LEFT_RIGHT>>>3 & 1][0]) / Resample_frequency[LEFT_RIGHT>>>3 & 1][1];

		aiff.seek(4);
		aiff.writeInt(len);  //data+chunksize

		aiff.seek(16);
		aiff.writeInt(0x12);  //chunk length
		aiff.writeShort((short)head.newchannel); //channels
		aiff.writeInt((int)(head.sampling_frequency * playtime / 1000.0)); //playtime
		aiff.writeShort((short)head.bits_per_sample); //bits_per_sample
		aiff.write(ConvertToIeeeExtended((double)head.sampling_frequency));  //sample_freq

		aiff.seek(42);
		aiff.writeInt(len - 38);  //chunk size sample data

		if (fade)
		{
			fadeIn(aiff, fade_millis, 46, len - 38);
			fadeOut(aiff, fade_millis, 46, len - 38);
		}

		aiff.close();
	}

	/**
	 *
	 */
	public static void deleteAiff(String file) throws IOException
	{
		RandomAccessFile aiff = new RandomAccessFile(file,"rw");

		aiff.seek(0);
		aiff.write(new byte[46]);

		aiff.close();
	}

	/*
	 * C O N V E R T   T O   I E E E   E X T E N D E D
	 *
	 * Copyright (C) 1988-1991 Apple Computer, Inc.
	 * All rights reserved.
	 *
	 * Machine-independent I/O routines for IEEE floating-point numbers.
	 *
	 * here: 80-bit floating point value of sample_rate in AIFF files
	 *
	 * simple Java adaption by dvb.matt 2004/02/07
	 * no deep tests..
	 */
	private static long FloatToUnsigned(double f)
	{
		return ((long)(((long)(f - 2147483648.0)) + 2147483647L) + 1);
	}

	/**
	 *
	 */
	private static byte[] ConvertToIeeeExtended(double num)
	{
		byte bytes[] = new byte[10];
		int sign;
		int expon=0;
		double fMant = 0.0, fsMant;
		long hiMant, loMant;

		if (num < 0)
		{
			sign = 0x8000;
			num *= -1;
		}
		else
			sign = 0;

		if (num == 0)
		{
			expon = 0;
			hiMant = 0;
			loMant = 0;
			}
		else
		{
			for (int a = 1; a < 32; a++)
				if ((num /= 2) < 1.0)
				{
					expon = a;
					fMant = num;
					break;
				}

			if ((expon > 16384) || !(fMant < 1))
			{    /* Infinity or NaN */
				expon = sign | 0x7FFF;
				hiMant = 0;
				loMant = 0; /* infinity */
			}
			else
			{    /* Finite */
				expon += 16382;

				if (expon < 0)
				{    /* denormalized */
					fMant *= (1L<<expon);
					expon = 0;
				}

				expon |= sign;
				fMant *= (1L<<32);
				fsMant = Math.floor(fMant); 
				hiMant = FloatToUnsigned(fsMant);
				fMant = (fMant - fsMant) * (1L<<32);
				fsMant = Math.floor(fMant); 
				loMant = FloatToUnsigned(fsMant);
			}
		}
    
		bytes[0] = (byte)(expon >> 8);
		bytes[1] = (byte)expon;
		bytes[2] = (byte)(hiMant >> 24);
		bytes[3] = (byte)(hiMant >> 16);
		bytes[4] = (byte)(hiMant >> 8);
		bytes[5] = (byte)hiMant;
		bytes[6] = (byte)(loMant >> 24);
		bytes[7] = (byte)(loMant >> 16);
		bytes[8] = (byte)(loMant >> 8);
		bytes[9] = (byte)loMant;
	
		return bytes;
	}

	/**
	 *
	 */
	public static void fillRIFF(String file, boolean fade, int fade_millis) throws IOException
	{
		RandomAccessFile riff = new RandomAccessFile(file, "rw");

		int len = (int)riff.length() - 8;

		if (DOWNSAMPLE) 
			head.sampling_frequency /= 2;

		else if ((LEFT_RIGHT & 0xC) != 0 && head.sampling_frequency == 48000) 
			head.sampling_frequency = (head.sampling_frequency * Resample_frequency[LEFT_RIGHT>>>3 & 1][0]) / Resample_frequency[LEFT_RIGHT>>>3 & 1][1];

		if (MOTOROLA)
		{ 
			riff.seek(3); 
			riff.write('X');  //RIFX nonIntel
		}

		riff.seek(4);
		riff.writeInt(littleEndian(len, 4));  //data+chunksize

		riff.seek(16);
		riff.writeInt(littleEndian(0x10, 4));  //chunk length
		riff.writeShort(littleEndian(1, 2));   //pcm
		riff.writeShort((short)littleEndian(head.newchannel, 2)); //channels
		riff.writeInt(littleEndian(head.sampling_frequency, 4));  //sample_freq
		riff.writeInt(littleEndian(head.sampling_frequency * head.newchannel * head.bits_per_sample / 8, 4)); //byterate
		riff.writeShort((short)littleEndian(head.newchannel * head.bits_per_sample / 8, 2)); //blockalign
		riff.writeShort((short)littleEndian(head.bits_per_sample, 2)); //bits_per_sample

		riff.seek(40);
		riff.writeInt(littleEndian(len - 36, 4));  //data-size

		if (fade)
		{
			fadeIn(riff, fade_millis, 44, len - 36);
			fadeOut(riff, fade_millis, 44, len - 36);
		}

		riff.close();
	}

	/**
	 *
	 */
	public static void deleteRIFF(String file) throws IOException
	{
		RandomAccessFile riff = new RandomAccessFile(file, "rw");

		riff.seek(0);
		riff.write(new byte[44]);

		riff.close();
	}

	private final static int SamplesPerFrame[] = { 0, 1152, 1152, 384 };	//u,L3,L2,L1

	/**
	 *
	 */
	public static void silentSamples(int new_sampling_frequency) throws IOException
	{
		if (DOWNSAMPLE) 
			new_sampling_frequency /= 2;

		else if ((LEFT_RIGHT & 0xC) != 0) 
			new_sampling_frequency = (new_sampling_frequency * Resample_frequency[LEFT_RIGHT>>>3 &1][0])/Resample_frequency[LEFT_RIGHT>>>3 &1][1];

		int silent_samples = head.newchannel * (head.bits_per_sample / 8) * (int)Math.abs((1.0 * SamplesPerFrame[head.layer] * new_sampling_frequency) / head.sampling_frequency);
		byte samples[] = new byte[silent_samples];

		out1.reset();
		out2.reset();

		out1.write(samples);
		out2.write(samples);
	}

	/**
	 *
	 */
	public static byte[] decodeArray(byte[] data) throws IOException
	{
		buf = data;
		BufferPos = 0;
		ERROR_CODE = ERROR_CODE1 = 0;

		double last_Multiply = MULTIPLY;

		if ( (ERROR_CODE1 = check_sync()) == 0) 
			return new byte[0];

		if ( (ERROR_CODE1 = parse_header()) < 1) 
			return new byte[0];

		if (head.new_sampling_frequency == 0)
			head.new_sampling_frequency = head.sampling_frequency;

		if (head.newchannel == 0)
			head.newchannel = DOWNMIX ? 1 : 2;

		switch (ERROR_CODE1)
		{
		case 1:	
			silentSamples(head.new_sampling_frequency);
			break;

		case 2:	
			ERROR_CODE = decode_layer2();
			break;

		case 3:	
			ERROR_CODE = decode_layer1();
		}

		if (ERROR_CODE == 1)
			head.new_sampling_frequency = head.sampling_frequency;

		if (last_Multiply != MULTIPLY)
			CommonParsing.setAudioProcessingFlags(CommonParsing.getAudioProcessingFlags() | 0x1000CL);

		return out1.toByteArray();
	}

	/**
	 *
	 */
	public static byte[] get2ndArray()
	{
		return out2.toByteArray();
	}

	/**
	 *
	 */
	private static void fadeIn(RandomAccessFile pcm_file, int fade_millis, long seek_position, int datachunk_length) throws IOException
	{
		fade(pcm_file, fade_millis, seek_position, datachunk_length, 1);
	}

	/**
	 *
	 */
	private static void fadeOut(RandomAccessFile pcm_file, int fade_millis, long seek_position, int datachunk_length) throws IOException
	{
		fade(pcm_file, fade_millis, seek_position, datachunk_length, 2);
	}

	/**
	 *
	 */
	private static void fade(RandomAccessFile pcm_file, int fade_millis, long seek_position, int datachunk_length, int fade_mode) throws IOException
	{
		int millis = (fade_millis < 0 || fade_millis > 5000) ? 2000 : fade_millis;
		int load = head.newchannel * (int)((1L * millis * head.sampling_frequency * head.bits_per_sample) / 8000);
		int bytes_per_sample = head.bits_per_sample / 8;

		if (load > datachunk_length)
			load = datachunk_length;

		double amp = 1.0;

		byte[] array = new byte[load];

		if (fade_mode == 2)
			seek_position = seek_position + datachunk_length - load;

		pcm_file.seek(seek_position);
		pcm_file.readFully(array);

		for (int i = 0; i < load; )
		{
			amp = (1.0 * (fade_mode == 2 ? (load - i) : i)) / load;

			for (int ch = 0, sample; ch < head.newchannel; ch++)
			{
				sample = (0xFF & array[i])<<8 | (0xFF & array[i + 1]);
				sample = littleEndian(sample, 2);
				sample = (0x8000 & sample) != 0 ? (0xFFFF0000 | sample) : sample;
				sample = (int) (amp * sample);
				sample = littleEndian(sample, 2);

				array[i] = (byte) (0xFF & sample>>8);
				array[i + 1] = (byte) (0xFF & sample);

				i += bytes_per_sample;
			}
		}

		pcm_file.seek(seek_position);
		pcm_file.write(array);
	}
}

