/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import com.sixlegs.png.Destination;
import com.sixlegs.png.PixelProcessor;

final class ProgressivePixelProcessor
extends PixelProcessor {
    private final PixelProcessor pp;
    private final int imgWidth;
    private final int imgHeight;
    private final Destination dst;
    private final int samples;
    private final int[] pixels;

    public ProgressivePixelProcessor(Destination dst, PixelProcessor pp, int imgWidth, int imgHeight) {
        this.pp = pp;
        this.imgWidth = imgWidth;
        this.imgHeight = imgHeight;
        this.dst = dst;
        this.samples = dst.getRaster().getNumBands();
        this.pixels = new int[this.samples * 8];
    }

    public boolean process(int[] row, int xOffset, int xStep, int yStep, int y, int width) {
        this.pp.process(row, xOffset, xStep, yStep, y, width);
        int blockHeight = xStep;
        int blockWidth = xStep - xOffset;
        if (blockWidth > 1 || blockHeight > 1) {
            int yMax = Math.min(y + blockHeight, this.imgHeight);
            int dstX = xOffset;
            for (int srcX = 0; srcX < width; ++srcX) {
                int i;
                this.dst.getPixel(dstX, y, this.pixels);
                int xMax = Math.min(dstX + blockWidth, this.imgWidth);
                int xPixels = xMax - dstX;
                int end = xPixels * this.samples;
                for (i = this.samples; i < end; ++i) {
                    this.pixels[i] = this.pixels[i - this.samples];
                }
                for (i = y; i < yMax; ++i) {
                    this.dst.setPixels(dstX, i, xPixels, this.pixels);
                }
                dstX += xStep;
            }
        }
        return true;
    }
}

