# -*- coding: utf-8 -*-
#
# Licensed under the terms of the BSD 3-Clause
# (see plotpy/LICENSE for details)

"""
Color data and pre-defined cmap objects.

This is a helper for cm.py, originally part of that file.
Separating the data (this file) from cm.py makes both easier
to deal with.

Objects visible in cm.py are the individual cmap objects ('autumn',
etc.) and a dictionary, 'datad', including all of these objects.
"""

# pylint: disable-msg=C0103
# pylint: disable-msg=C0301
# pylint: disable-msg=C0302

_binary_data = {
    "red": ((0.0, 1.0, 1.0), (1.0, 0.0, 0.0)),
    "green": ((0.0, 1.0, 1.0), (1.0, 0.0, 0.0)),
    "blue": ((0.0, 1.0, 1.0), (1.0, 0.0, 0.0)),
}


_bone_data = {
    "red": ((0.0, 0.0, 0.0), (1.0, 1.0, 1.0)),
    "green": ((0.0, 0.0, 0.0), (1.0, 1.0, 1.0)),
    "blue": ((0.0, 0.0, 0.0), (1.0, 1.0, 1.0)),
}


_autumn_data = {
    "red": ((0.0, 1.0, 1.0), (1.0, 1.0, 1.0)),
    "green": ((0.0, 0.0, 0.0), (1.0, 1.0, 1.0)),
    "blue": ((0.0, 0.0, 0.0), (1.0, 0.0, 0.0)),
}

_bone_data = {
    "red": ((0.0, 0.0, 0.0), (0.746032, 0.652778, 0.652778), (1.0, 1.0, 1.0)),
    "green": (
        (0.0, 0.0, 0.0),
        (0.365079, 0.319444, 0.319444),
        (0.746032, 0.777778, 0.777778),
        (1.0, 1.0, 1.0),
    ),
    "blue": ((0.0, 0.0, 0.0), (0.365079, 0.444444, 0.444444), (1.0, 1.0, 1.0)),
}

_cool_data = {
    "red": ((0.0, 0.0, 0.0), (1.0, 1.0, 1.0)),
    "green": ((0.0, 1.0, 1.0), (1.0, 0.0, 0.0)),
    "blue": ((0.0, 1.0, 1.0), (1.0, 1.0, 1.0)),
}

_copper_data = {
    "red": ((0.0, 0.0, 0.0), (0.809524, 1.000000, 1.000000), (1.0, 1.0, 1.0)),
    "green": ((0.0, 0.0, 0.0), (1.0, 0.7812, 0.7812)),
    "blue": ((0.0, 0.0, 0.0), (1.0, 0.4975, 0.4975)),
}

_flag_data = {
    "red": (
        (0.0, 1.0, 1.0),
        (0.015873, 1.000000, 1.000000),
        (0.031746, 0.000000, 0.000000),
        (0.047619, 0.000000, 0.000000),
        (0.063492, 1.000000, 1.000000),
        (0.079365, 1.000000, 1.000000),
        (0.095238, 0.000000, 0.000000),
        (0.111111, 0.000000, 0.000000),
        (0.126984, 1.000000, 1.000000),
        (0.142857, 1.000000, 1.000000),
        (0.158730, 0.000000, 0.000000),
        (0.174603, 0.000000, 0.000000),
        (0.190476, 1.000000, 1.000000),
        (0.206349, 1.000000, 1.000000),
        (0.222222, 0.000000, 0.000000),
        (0.238095, 0.000000, 0.000000),
        (0.253968, 1.000000, 1.000000),
        (0.269841, 1.000000, 1.000000),
        (0.285714, 0.000000, 0.000000),
        (0.301587, 0.000000, 0.000000),
        (0.317460, 1.000000, 1.000000),
        (0.333333, 1.000000, 1.000000),
        (0.349206, 0.000000, 0.000000),
        (0.365079, 0.000000, 0.000000),
        (0.380952, 1.000000, 1.000000),
        (0.396825, 1.000000, 1.000000),
        (0.412698, 0.000000, 0.000000),
        (0.428571, 0.000000, 0.000000),
        (0.444444, 1.000000, 1.000000),
        (0.460317, 1.000000, 1.000000),
        (0.476190, 0.000000, 0.000000),
        (0.492063, 0.000000, 0.000000),
        (0.507937, 1.000000, 1.000000),
        (0.523810, 1.000000, 1.000000),
        (0.539683, 0.000000, 0.000000),
        (0.555556, 0.000000, 0.000000),
        (0.571429, 1.000000, 1.000000),
        (0.587302, 1.000000, 1.000000),
        (0.603175, 0.000000, 0.000000),
        (0.619048, 0.000000, 0.000000),
        (0.634921, 1.000000, 1.000000),
        (0.650794, 1.000000, 1.000000),
        (0.666667, 0.000000, 0.000000),
        (0.682540, 0.000000, 0.000000),
        (0.698413, 1.000000, 1.000000),
        (0.714286, 1.000000, 1.000000),
        (0.730159, 0.000000, 0.000000),
        (0.746032, 0.000000, 0.000000),
        (0.761905, 1.000000, 1.000000),
        (0.777778, 1.000000, 1.000000),
        (0.793651, 0.000000, 0.000000),
        (0.809524, 0.000000, 0.000000),
        (0.825397, 1.000000, 1.000000),
        (0.841270, 1.000000, 1.000000),
        (0.857143, 0.000000, 0.000000),
        (0.873016, 0.000000, 0.000000),
        (0.888889, 1.000000, 1.000000),
        (0.904762, 1.000000, 1.000000),
        (0.920635, 0.000000, 0.000000),
        (0.936508, 0.000000, 0.000000),
        (0.952381, 1.000000, 1.000000),
        (0.968254, 1.000000, 1.000000),
        (0.984127, 0.000000, 0.000000),
        (1.0, 0.0, 0.0),
    ),
    "green": (
        (0.0, 0.0, 0.0),
        (0.015873, 1.000000, 1.000000),
        (0.031746, 0.000000, 0.000000),
        (0.063492, 0.000000, 0.000000),
        (0.079365, 1.000000, 1.000000),
        (0.095238, 0.000000, 0.000000),
        (0.126984, 0.000000, 0.000000),
        (0.142857, 1.000000, 1.000000),
        (0.158730, 0.000000, 0.000000),
        (0.190476, 0.000000, 0.000000),
        (0.206349, 1.000000, 1.000000),
        (0.222222, 0.000000, 0.000000),
        (0.253968, 0.000000, 0.000000),
        (0.269841, 1.000000, 1.000000),
        (0.285714, 0.000000, 0.000000),
        (0.317460, 0.000000, 0.000000),
        (0.333333, 1.000000, 1.000000),
        (0.349206, 0.000000, 0.000000),
        (0.380952, 0.000000, 0.000000),
        (0.396825, 1.000000, 1.000000),
        (0.412698, 0.000000, 0.000000),
        (0.444444, 0.000000, 0.000000),
        (0.460317, 1.000000, 1.000000),
        (0.476190, 0.000000, 0.000000),
        (0.507937, 0.000000, 0.000000),
        (0.523810, 1.000000, 1.000000),
        (0.539683, 0.000000, 0.000000),
        (0.571429, 0.000000, 0.000000),
        (0.587302, 1.000000, 1.000000),
        (0.603175, 0.000000, 0.000000),
        (0.634921, 0.000000, 0.000000),
        (0.650794, 1.000000, 1.000000),
        (0.666667, 0.000000, 0.000000),
        (0.698413, 0.000000, 0.000000),
        (0.714286, 1.000000, 1.000000),
        (0.730159, 0.000000, 0.000000),
        (0.761905, 0.000000, 0.000000),
        (0.777778, 1.000000, 1.000000),
        (0.793651, 0.000000, 0.000000),
        (0.825397, 0.000000, 0.000000),
        (0.841270, 1.000000, 1.000000),
        (0.857143, 0.000000, 0.000000),
        (0.888889, 0.000000, 0.000000),
        (0.904762, 1.000000, 1.000000),
        (0.920635, 0.000000, 0.000000),
        (0.952381, 0.000000, 0.000000),
        (0.968254, 1.000000, 1.000000),
        (0.984127, 0.000000, 0.000000),
        (1.0, 0.0, 0.0),
    ),
    "blue": (
        (0.0, 0.0, 0.0),
        (0.015873, 1.000000, 1.000000),
        (0.031746, 1.000000, 1.000000),
        (0.047619, 0.000000, 0.000000),
        (0.063492, 0.000000, 0.000000),
        (0.079365, 1.000000, 1.000000),
        (0.095238, 1.000000, 1.000000),
        (0.111111, 0.000000, 0.000000),
        (0.126984, 0.000000, 0.000000),
        (0.142857, 1.000000, 1.000000),
        (0.158730, 1.000000, 1.000000),
        (0.174603, 0.000000, 0.000000),
        (0.190476, 0.000000, 0.000000),
        (0.206349, 1.000000, 1.000000),
        (0.222222, 1.000000, 1.000000),
        (0.238095, 0.000000, 0.000000),
        (0.253968, 0.000000, 0.000000),
        (0.269841, 1.000000, 1.000000),
        (0.285714, 1.000000, 1.000000),
        (0.301587, 0.000000, 0.000000),
        (0.317460, 0.000000, 0.000000),
        (0.333333, 1.000000, 1.000000),
        (0.349206, 1.000000, 1.000000),
        (0.365079, 0.000000, 0.000000),
        (0.380952, 0.000000, 0.000000),
        (0.396825, 1.000000, 1.000000),
        (0.412698, 1.000000, 1.000000),
        (0.428571, 0.000000, 0.000000),
        (0.444444, 0.000000, 0.000000),
        (0.460317, 1.000000, 1.000000),
        (0.476190, 1.000000, 1.000000),
        (0.492063, 0.000000, 0.000000),
        (0.507937, 0.000000, 0.000000),
        (0.523810, 1.000000, 1.000000),
        (0.539683, 1.000000, 1.000000),
        (0.555556, 0.000000, 0.000000),
        (0.571429, 0.000000, 0.000000),
        (0.587302, 1.000000, 1.000000),
        (0.603175, 1.000000, 1.000000),
        (0.619048, 0.000000, 0.000000),
        (0.634921, 0.000000, 0.000000),
        (0.650794, 1.000000, 1.000000),
        (0.666667, 1.000000, 1.000000),
        (0.682540, 0.000000, 0.000000),
        (0.698413, 0.000000, 0.000000),
        (0.714286, 1.000000, 1.000000),
        (0.730159, 1.000000, 1.000000),
        (0.746032, 0.000000, 0.000000),
        (0.761905, 0.000000, 0.000000),
        (0.777778, 1.000000, 1.000000),
        (0.793651, 1.000000, 1.000000),
        (0.809524, 0.000000, 0.000000),
        (0.825397, 0.000000, 0.000000),
        (0.841270, 1.000000, 1.000000),
        (0.857143, 1.000000, 1.000000),
        (0.873016, 0.000000, 0.000000),
        (0.888889, 0.000000, 0.000000),
        (0.904762, 1.000000, 1.000000),
        (0.920635, 1.000000, 1.000000),
        (0.936508, 0.000000, 0.000000),
        (0.952381, 0.000000, 0.000000),
        (0.968254, 1.000000, 1.000000),
        (0.984127, 1.000000, 1.000000),
        (1.0, 0.0, 0.0),
    ),
}

_gray_data = {
    "red": ((0.0, 0, 0), (1.0, 1, 1)),
    "green": ((0.0, 0, 0), (1.0, 1, 1)),
    "blue": ((0.0, 0, 0), (1.0, 1, 1)),
}

_hot_data = {
    "red": ((0.0, 0.0416, 0.0416), (0.365079, 1.000000, 1.000000), (1.0, 1.0, 1.0)),
    "green": (
        (0.0, 0.0, 0.0),
        (0.365079, 0.000000, 0.000000),
        (0.746032, 1.000000, 1.000000),
        (1.0, 1.0, 1.0),
    ),
    "blue": ((0.0, 0.0, 0.0), (0.746032, 0.000000, 0.000000), (1.0, 1.0, 1.0)),
}

_hsv_data = {
    "red": (
        (0.0, 1.0, 1.0),
        (0.158730, 1.000000, 1.000000),
        (0.174603, 0.968750, 0.968750),
        (0.333333, 0.031250, 0.031250),
        (0.349206, 0.000000, 0.000000),
        (0.666667, 0.000000, 0.000000),
        (0.682540, 0.031250, 0.031250),
        (0.841270, 0.968750, 0.968750),
        (0.857143, 1.000000, 1.000000),
        (1.0, 1.0, 1.0),
    ),
    "green": (
        (0.0, 0.0, 0.0),
        (0.158730, 0.937500, 0.937500),
        (0.174603, 1.000000, 1.000000),
        (0.507937, 1.000000, 1.000000),
        (0.666667, 0.062500, 0.062500),
        (0.682540, 0.000000, 0.000000),
        (1.0, 0.0, 0.0),
    ),
    "blue": (
        (0.0, 0.0, 0.0),
        (0.333333, 0.000000, 0.000000),
        (0.349206, 0.062500, 0.062500),
        (0.507937, 1.000000, 1.000000),
        (0.841270, 1.000000, 1.000000),
        (0.857143, 0.937500, 0.937500),
        (1.0, 0.09375, 0.09375),
    ),
}

_jet_data = {
    "red": ((0.0, 0, 0), (0.35, 0, 0), (0.66, 1, 1), (0.89, 1, 1), (1, 0.5, 0.5)),
    "green": (
        (0.0, 0, 0),
        (0.125, 0, 0),
        (0.375, 1, 1),
        (0.64, 1, 1),
        (0.91, 0, 0),
        (1, 0, 0),
    ),
    "blue": ((0.0, 0.5, 0.5), (0.11, 1, 1), (0.34, 1, 1), (0.65, 0, 0), (1, 0, 0)),
}

_pink_data = {
    "red": (
        (0.0, 0.1178, 0.1178),
        (0.015873, 0.195857, 0.195857),
        (0.031746, 0.250661, 0.250661),
        (0.047619, 0.295468, 0.295468),
        (0.063492, 0.334324, 0.334324),
        (0.079365, 0.369112, 0.369112),
        (0.095238, 0.400892, 0.400892),
        (0.111111, 0.430331, 0.430331),
        (0.126984, 0.457882, 0.457882),
        (0.142857, 0.483867, 0.483867),
        (0.158730, 0.508525, 0.508525),
        (0.174603, 0.532042, 0.532042),
        (0.190476, 0.554563, 0.554563),
        (0.206349, 0.576204, 0.576204),
        (0.222222, 0.597061, 0.597061),
        (0.238095, 0.617213, 0.617213),
        (0.253968, 0.636729, 0.636729),
        (0.269841, 0.655663, 0.655663),
        (0.285714, 0.674066, 0.674066),
        (0.301587, 0.691980, 0.691980),
        (0.317460, 0.709441, 0.709441),
        (0.333333, 0.726483, 0.726483),
        (0.349206, 0.743134, 0.743134),
        (0.365079, 0.759421, 0.759421),
        (0.380952, 0.766356, 0.766356),
        (0.396825, 0.773229, 0.773229),
        (0.412698, 0.780042, 0.780042),
        (0.428571, 0.786796, 0.786796),
        (0.444444, 0.793492, 0.793492),
        (0.460317, 0.800132, 0.800132),
        (0.476190, 0.806718, 0.806718),
        (0.492063, 0.813250, 0.813250),
        (0.507937, 0.819730, 0.819730),
        (0.523810, 0.826160, 0.826160),
        (0.539683, 0.832539, 0.832539),
        (0.555556, 0.838870, 0.838870),
        (0.571429, 0.845154, 0.845154),
        (0.587302, 0.851392, 0.851392),
        (0.603175, 0.857584, 0.857584),
        (0.619048, 0.863731, 0.863731),
        (0.634921, 0.869835, 0.869835),
        (0.650794, 0.875897, 0.875897),
        (0.666667, 0.881917, 0.881917),
        (0.682540, 0.887896, 0.887896),
        (0.698413, 0.893835, 0.893835),
        (0.714286, 0.899735, 0.899735),
        (0.730159, 0.905597, 0.905597),
        (0.746032, 0.911421, 0.911421),
        (0.761905, 0.917208, 0.917208),
        (0.777778, 0.922958, 0.922958),
        (0.793651, 0.928673, 0.928673),
        (0.809524, 0.934353, 0.934353),
        (0.825397, 0.939999, 0.939999),
        (0.841270, 0.945611, 0.945611),
        (0.857143, 0.951190, 0.951190),
        (0.873016, 0.956736, 0.956736),
        (0.888889, 0.962250, 0.962250),
        (0.904762, 0.967733, 0.967733),
        (0.920635, 0.973185, 0.973185),
        (0.936508, 0.978607, 0.978607),
        (0.952381, 0.983999, 0.983999),
        (0.968254, 0.989361, 0.989361),
        (0.984127, 0.994695, 0.994695),
        (1.0, 1.0, 1.0),
    ),
    "green": (
        (0.0, 0.0, 0.0),
        (0.015873, 0.102869, 0.102869),
        (0.031746, 0.145479, 0.145479),
        (0.047619, 0.178174, 0.178174),
        (0.063492, 0.205738, 0.205738),
        (0.079365, 0.230022, 0.230022),
        (0.095238, 0.251976, 0.251976),
        (0.111111, 0.272166, 0.272166),
        (0.126984, 0.290957, 0.290957),
        (0.142857, 0.308607, 0.308607),
        (0.158730, 0.325300, 0.325300),
        (0.174603, 0.341178, 0.341178),
        (0.190476, 0.356348, 0.356348),
        (0.206349, 0.370899, 0.370899),
        (0.222222, 0.384900, 0.384900),
        (0.238095, 0.398410, 0.398410),
        (0.253968, 0.411476, 0.411476),
        (0.269841, 0.424139, 0.424139),
        (0.285714, 0.436436, 0.436436),
        (0.301587, 0.448395, 0.448395),
        (0.317460, 0.460044, 0.460044),
        (0.333333, 0.471405, 0.471405),
        (0.349206, 0.482498, 0.482498),
        (0.365079, 0.493342, 0.493342),
        (0.380952, 0.517549, 0.517549),
        (0.396825, 0.540674, 0.540674),
        (0.412698, 0.562849, 0.562849),
        (0.428571, 0.584183, 0.584183),
        (0.444444, 0.604765, 0.604765),
        (0.460317, 0.624669, 0.624669),
        (0.476190, 0.643958, 0.643958),
        (0.492063, 0.662687, 0.662687),
        (0.507937, 0.680900, 0.680900),
        (0.523810, 0.698638, 0.698638),
        (0.539683, 0.715937, 0.715937),
        (0.555556, 0.732828, 0.732828),
        (0.571429, 0.749338, 0.749338),
        (0.587302, 0.765493, 0.765493),
        (0.603175, 0.781313, 0.781313),
        (0.619048, 0.796819, 0.796819),
        (0.634921, 0.812029, 0.812029),
        (0.650794, 0.826960, 0.826960),
        (0.666667, 0.841625, 0.841625),
        (0.682540, 0.856040, 0.856040),
        (0.698413, 0.870216, 0.870216),
        (0.714286, 0.884164, 0.884164),
        (0.730159, 0.897896, 0.897896),
        (0.746032, 0.911421, 0.911421),
        (0.761905, 0.917208, 0.917208),
        (0.777778, 0.922958, 0.922958),
        (0.793651, 0.928673, 0.928673),
        (0.809524, 0.934353, 0.934353),
        (0.825397, 0.939999, 0.939999),
        (0.841270, 0.945611, 0.945611),
        (0.857143, 0.951190, 0.951190),
        (0.873016, 0.956736, 0.956736),
        (0.888889, 0.962250, 0.962250),
        (0.904762, 0.967733, 0.967733),
        (0.920635, 0.973185, 0.973185),
        (0.936508, 0.978607, 0.978607),
        (0.952381, 0.983999, 0.983999),
        (0.968254, 0.989361, 0.989361),
        (0.984127, 0.994695, 0.994695),
        (1.0, 1.0, 1.0),
    ),
    "blue": (
        (0.0, 0.0, 0.0),
        (0.015873, 0.102869, 0.102869),
        (0.031746, 0.145479, 0.145479),
        (0.047619, 0.178174, 0.178174),
        (0.063492, 0.205738, 0.205738),
        (0.079365, 0.230022, 0.230022),
        (0.095238, 0.251976, 0.251976),
        (0.111111, 0.272166, 0.272166),
        (0.126984, 0.290957, 0.290957),
        (0.142857, 0.308607, 0.308607),
        (0.158730, 0.325300, 0.325300),
        (0.174603, 0.341178, 0.341178),
        (0.190476, 0.356348, 0.356348),
        (0.206349, 0.370899, 0.370899),
        (0.222222, 0.384900, 0.384900),
        (0.238095, 0.398410, 0.398410),
        (0.253968, 0.411476, 0.411476),
        (0.269841, 0.424139, 0.424139),
        (0.285714, 0.436436, 0.436436),
        (0.301587, 0.448395, 0.448395),
        (0.317460, 0.460044, 0.460044),
        (0.333333, 0.471405, 0.471405),
        (0.349206, 0.482498, 0.482498),
        (0.365079, 0.493342, 0.493342),
        (0.380952, 0.503953, 0.503953),
        (0.396825, 0.514344, 0.514344),
        (0.412698, 0.524531, 0.524531),
        (0.428571, 0.534522, 0.534522),
        (0.444444, 0.544331, 0.544331),
        (0.460317, 0.553966, 0.553966),
        (0.476190, 0.563436, 0.563436),
        (0.492063, 0.572750, 0.572750),
        (0.507937, 0.581914, 0.581914),
        (0.523810, 0.590937, 0.590937),
        (0.539683, 0.599824, 0.599824),
        (0.555556, 0.608581, 0.608581),
        (0.571429, 0.617213, 0.617213),
        (0.587302, 0.625727, 0.625727),
        (0.603175, 0.634126, 0.634126),
        (0.619048, 0.642416, 0.642416),
        (0.634921, 0.650600, 0.650600),
        (0.650794, 0.658682, 0.658682),
        (0.666667, 0.666667, 0.666667),
        (0.682540, 0.674556, 0.674556),
        (0.698413, 0.682355, 0.682355),
        (0.714286, 0.690066, 0.690066),
        (0.730159, 0.697691, 0.697691),
        (0.746032, 0.705234, 0.705234),
        (0.761905, 0.727166, 0.727166),
        (0.777778, 0.748455, 0.748455),
        (0.793651, 0.769156, 0.769156),
        (0.809524, 0.789314, 0.789314),
        (0.825397, 0.808969, 0.808969),
        (0.841270, 0.828159, 0.828159),
        (0.857143, 0.846913, 0.846913),
        (0.873016, 0.865261, 0.865261),
        (0.888889, 0.883229, 0.883229),
        (0.904762, 0.900837, 0.900837),
        (0.920635, 0.918109, 0.918109),
        (0.936508, 0.935061, 0.935061),
        (0.952381, 0.951711, 0.951711),
        (0.968254, 0.968075, 0.968075),
        (0.984127, 0.984167, 0.984167),
        (1.0, 1.0, 1.0),
    ),
}

_prism_data = {
    "red": (
        (0.0, 1.0, 1.0),
        (0.031746, 1.000000, 1.000000),
        (0.047619, 0.000000, 0.000000),
        (0.063492, 0.000000, 0.000000),
        (0.079365, 0.666667, 0.666667),
        (0.095238, 1.000000, 1.000000),
        (0.126984, 1.000000, 1.000000),
        (0.142857, 0.000000, 0.000000),
        (0.158730, 0.000000, 0.000000),
        (0.174603, 0.666667, 0.666667),
        (0.190476, 1.000000, 1.000000),
        (0.222222, 1.000000, 1.000000),
        (0.238095, 0.000000, 0.000000),
        (0.253968, 0.000000, 0.000000),
        (0.269841, 0.666667, 0.666667),
        (0.285714, 1.000000, 1.000000),
        (0.317460, 1.000000, 1.000000),
        (0.333333, 0.000000, 0.000000),
        (0.349206, 0.000000, 0.000000),
        (0.365079, 0.666667, 0.666667),
        (0.380952, 1.000000, 1.000000),
        (0.412698, 1.000000, 1.000000),
        (0.428571, 0.000000, 0.000000),
        (0.444444, 0.000000, 0.000000),
        (0.460317, 0.666667, 0.666667),
        (0.476190, 1.000000, 1.000000),
        (0.507937, 1.000000, 1.000000),
        (0.523810, 0.000000, 0.000000),
        (0.539683, 0.000000, 0.000000),
        (0.555556, 0.666667, 0.666667),
        (0.571429, 1.000000, 1.000000),
        (0.603175, 1.000000, 1.000000),
        (0.619048, 0.000000, 0.000000),
        (0.634921, 0.000000, 0.000000),
        (0.650794, 0.666667, 0.666667),
        (0.666667, 1.000000, 1.000000),
        (0.698413, 1.000000, 1.000000),
        (0.714286, 0.000000, 0.000000),
        (0.730159, 0.000000, 0.000000),
        (0.746032, 0.666667, 0.666667),
        (0.761905, 1.000000, 1.000000),
        (0.793651, 1.000000, 1.000000),
        (0.809524, 0.000000, 0.000000),
        (0.825397, 0.000000, 0.000000),
        (0.841270, 0.666667, 0.666667),
        (0.857143, 1.000000, 1.000000),
        (0.888889, 1.000000, 1.000000),
        (0.904762, 0.000000, 0.000000),
        (0.920635, 0.000000, 0.000000),
        (0.936508, 0.666667, 0.666667),
        (0.952381, 1.000000, 1.000000),
        (0.984127, 1.000000, 1.000000),
        (1.0, 0.0, 0.0),
    ),
    "green": (
        (0.0, 0.0, 0.0),
        (0.031746, 1.000000, 1.000000),
        (0.047619, 1.000000, 1.000000),
        (0.063492, 0.000000, 0.000000),
        (0.095238, 0.000000, 0.000000),
        (0.126984, 1.000000, 1.000000),
        (0.142857, 1.000000, 1.000000),
        (0.158730, 0.000000, 0.000000),
        (0.190476, 0.000000, 0.000000),
        (0.222222, 1.000000, 1.000000),
        (0.238095, 1.000000, 1.000000),
        (0.253968, 0.000000, 0.000000),
        (0.285714, 0.000000, 0.000000),
        (0.317460, 1.000000, 1.000000),
        (0.333333, 1.000000, 1.000000),
        (0.349206, 0.000000, 0.000000),
        (0.380952, 0.000000, 0.000000),
        (0.412698, 1.000000, 1.000000),
        (0.428571, 1.000000, 1.000000),
        (0.444444, 0.000000, 0.000000),
        (0.476190, 0.000000, 0.000000),
        (0.507937, 1.000000, 1.000000),
        (0.523810, 1.000000, 1.000000),
        (0.539683, 0.000000, 0.000000),
        (0.571429, 0.000000, 0.000000),
        (0.603175, 1.000000, 1.000000),
        (0.619048, 1.000000, 1.000000),
        (0.634921, 0.000000, 0.000000),
        (0.666667, 0.000000, 0.000000),
        (0.698413, 1.000000, 1.000000),
        (0.714286, 1.000000, 1.000000),
        (0.730159, 0.000000, 0.000000),
        (0.761905, 0.000000, 0.000000),
        (0.793651, 1.000000, 1.000000),
        (0.809524, 1.000000, 1.000000),
        (0.825397, 0.000000, 0.000000),
        (0.857143, 0.000000, 0.000000),
        (0.888889, 1.000000, 1.000000),
        (0.904762, 1.000000, 1.000000),
        (0.920635, 0.000000, 0.000000),
        (0.952381, 0.000000, 0.000000),
        (0.984127, 1.000000, 1.000000),
        (1.0, 1.0, 1.0),
    ),
    "blue": (
        (0.0, 0.0, 0.0),
        (0.047619, 0.000000, 0.000000),
        (0.063492, 1.000000, 1.000000),
        (0.079365, 1.000000, 1.000000),
        (0.095238, 0.000000, 0.000000),
        (0.142857, 0.000000, 0.000000),
        (0.158730, 1.000000, 1.000000),
        (0.174603, 1.000000, 1.000000),
        (0.190476, 0.000000, 0.000000),
        (0.238095, 0.000000, 0.000000),
        (0.253968, 1.000000, 1.000000),
        (0.269841, 1.000000, 1.000000),
        (0.285714, 0.000000, 0.000000),
        (0.333333, 0.000000, 0.000000),
        (0.349206, 1.000000, 1.000000),
        (0.365079, 1.000000, 1.000000),
        (0.380952, 0.000000, 0.000000),
        (0.428571, 0.000000, 0.000000),
        (0.444444, 1.000000, 1.000000),
        (0.460317, 1.000000, 1.000000),
        (0.476190, 0.000000, 0.000000),
        (0.523810, 0.000000, 0.000000),
        (0.539683, 1.000000, 1.000000),
        (0.555556, 1.000000, 1.000000),
        (0.571429, 0.000000, 0.000000),
        (0.619048, 0.000000, 0.000000),
        (0.634921, 1.000000, 1.000000),
        (0.650794, 1.000000, 1.000000),
        (0.666667, 0.000000, 0.000000),
        (0.714286, 0.000000, 0.000000),
        (0.730159, 1.000000, 1.000000),
        (0.746032, 1.000000, 1.000000),
        (0.761905, 0.000000, 0.000000),
        (0.809524, 0.000000, 0.000000),
        (0.825397, 1.000000, 1.000000),
        (0.841270, 1.000000, 1.000000),
        (0.857143, 0.000000, 0.000000),
        (0.904762, 0.000000, 0.000000),
        (0.920635, 1.000000, 1.000000),
        (0.936508, 1.000000, 1.000000),
        (0.952381, 0.000000, 0.000000),
        (1.0, 0.0, 0.0),
    ),
}

_spring_data = {
    "red": ((0.0, 1.0, 1.0), (1.0, 1.0, 1.0)),
    "green": ((0.0, 0.0, 0.0), (1.0, 1.0, 1.0)),
    "blue": ((0.0, 1.0, 1.0), (1.0, 0.0, 0.0)),
}


_summer_data = {
    "red": ((0.0, 0.0, 0.0), (1.0, 1.0, 1.0)),
    "green": ((0.0, 0.5, 0.5), (1.0, 1.0, 1.0)),
    "blue": ((0.0, 0.4, 0.4), (1.0, 0.4, 0.4)),
}


_winter_data = {
    "red": ((0.0, 0.0, 0.0), (1.0, 0.0, 0.0)),
    "green": ((0.0, 0.0, 0.0), (1.0, 1.0, 1.0)),
    "blue": ((0.0, 1.0, 1.0), (1.0, 0.5, 0.5)),
}

_spectral_data = {
    "red": [
        (0.0, 0.0, 0.0),
        (0.05, 0.4667, 0.4667),
        (0.10, 0.5333, 0.5333),
        (0.15, 0.0, 0.0),
        (0.20, 0.0, 0.0),
        (0.25, 0.0, 0.0),
        (0.30, 0.0, 0.0),
        (0.35, 0.0, 0.0),
        (0.40, 0.0, 0.0),
        (0.45, 0.0, 0.0),
        (0.50, 0.0, 0.0),
        (0.55, 0.0, 0.0),
        (0.60, 0.0, 0.0),
        (0.65, 0.7333, 0.7333),
        (0.70, 0.9333, 0.9333),
        (0.75, 1.0, 1.0),
        (0.80, 1.0, 1.0),
        (0.85, 1.0, 1.0),
        (0.90, 0.8667, 0.8667),
        (0.95, 0.80, 0.80),
        (1.0, 0.80, 0.80),
    ],
    "green": [
        (0.0, 0.0, 0.0),
        (0.05, 0.0, 0.0),
        (0.10, 0.0, 0.0),
        (0.15, 0.0, 0.0),
        (0.20, 0.0, 0.0),
        (0.25, 0.4667, 0.4667),
        (0.30, 0.6000, 0.6000),
        (0.35, 0.6667, 0.6667),
        (0.40, 0.6667, 0.6667),
        (0.45, 0.6000, 0.6000),
        (0.50, 0.7333, 0.7333),
        (0.55, 0.8667, 0.8667),
        (0.60, 1.0, 1.0),
        (0.65, 1.0, 1.0),
        (0.70, 0.9333, 0.9333),
        (0.75, 0.8000, 0.8000),
        (0.80, 0.6000, 0.6000),
        (0.85, 0.0, 0.0),
        (0.90, 0.0, 0.0),
        (0.95, 0.0, 0.0),
        (1.0, 0.80, 0.80),
    ],
    "blue": [
        (0.0, 0.0, 0.0),
        (0.05, 0.5333, 0.5333),
        (0.10, 0.6000, 0.6000),
        (0.15, 0.6667, 0.6667),
        (0.20, 0.8667, 0.8667),
        (0.25, 0.8667, 0.8667),
        (0.30, 0.8667, 0.8667),
        (0.35, 0.6667, 0.6667),
        (0.40, 0.5333, 0.5333),
        (0.45, 0.0, 0.0),
        (0.5, 0.0, 0.0),
        (0.55, 0.0, 0.0),
        (0.60, 0.0, 0.0),
        (0.65, 0.0, 0.0),
        (0.70, 0.0, 0.0),
        (0.75, 0.0, 0.0),
        (0.80, 0.0, 0.0),
        (0.85, 0.0, 0.0),
        (0.90, 0.0, 0.0),
        (0.95, 0.0, 0.0),
        (1.0, 0.80, 0.80),
    ],
}


datad = {
    "autumn": _autumn_data,
    "bone": _bone_data,
    "binary": _binary_data,
    "cool": _cool_data,
    "copper": _copper_data,
    "flag": _flag_data,
    "gray": _gray_data,
    "hot": _hot_data,
    "hsv": _hsv_data,
    "jet": _jet_data,
    "pink": _pink_data,
    "prism": _prism_data,
    "spring": _spring_data,
    "summer": _summer_data,
    "winter": _winter_data,
    "spectral": _spectral_data,
}

# 34 colormaps based on color specifications and designs
# developed by Cynthia Brewer (http://colorbrewer.org).
# The ColorBrewer palettes have been included under the terms
# of an Apache-stype license (for details, see the file
# LICENSE_COLORBREWER in the license directory of the matplotlib
# source distribution).

_Accent_data = {
    "blue": [
        (0.0, 0.49803921580314636, 0.49803921580314636),
        (0.14285714285714285, 0.83137255907058716, 0.83137255907058716),
        (0.2857142857142857, 0.52549022436141968, 0.52549022436141968),
        (0.42857142857142855, 0.60000002384185791, 0.60000002384185791),
        (0.5714285714285714, 0.69019609689712524, 0.69019609689712524),
        (0.7142857142857143, 0.49803921580314636, 0.49803921580314636),
        (0.8571428571428571, 0.090196080505847931, 0.090196080505847931),
        (1.0, 0.40000000596046448, 0.40000000596046448),
    ],
    "green": [
        (0.0, 0.78823530673980713, 0.78823530673980713),
        (0.14285714285714285, 0.68235296010971069, 0.68235296010971069),
        (0.2857142857142857, 0.75294119119644165, 0.75294119119644165),
        (0.42857142857142855, 1.0, 1.0),
        (0.5714285714285714, 0.42352941632270813, 0.42352941632270813),
        (0.7142857142857143, 0.0078431377187371254, 0.0078431377187371254),
        (0.8571428571428571, 0.35686275362968445, 0.35686275362968445),
        (1.0, 0.40000000596046448, 0.40000000596046448),
    ],
    "red": [
        (0.0, 0.49803921580314636, 0.49803921580314636),
        (0.14285714285714285, 0.7450980544090271, 0.7450980544090271),
        (0.2857142857142857, 0.99215686321258545, 0.99215686321258545),
        (0.42857142857142855, 1.0, 1.0),
        (0.5714285714285714, 0.21960784494876862, 0.21960784494876862),
        (0.7142857142857143, 0.94117647409439087, 0.94117647409439087),
        (0.8571428571428571, 0.74901962280273438, 0.74901962280273438),
        (1.0, 0.40000000596046448, 0.40000000596046448),
    ],
}

_Blues_data = {
    "blue": [
        (0.0, 1.0, 1.0),
        (0.125, 0.9686274528503418, 0.9686274528503418),
        (0.25, 0.93725490570068359, 0.93725490570068359),
        (0.375, 0.88235294818878174, 0.88235294818878174),
        (0.5, 0.83921569585800171, 0.83921569585800171),
        (0.625, 0.7764706015586853, 0.7764706015586853),
        (0.75, 0.70980393886566162, 0.70980393886566162),
        (0.875, 0.61176472902297974, 0.61176472902297974),
        (1.0, 0.41960784792900085, 0.41960784792900085),
    ],
    "green": [
        (0.0, 0.9843137264251709, 0.9843137264251709),
        (0.125, 0.92156863212585449, 0.92156863212585449),
        (0.25, 0.85882353782653809, 0.85882353782653809),
        (0.375, 0.7921568751335144, 0.7921568751335144),
        (0.5, 0.68235296010971069, 0.68235296010971069),
        (0.625, 0.57254904508590698, 0.57254904508590698),
        (0.75, 0.44313725829124451, 0.44313725829124451),
        (0.875, 0.31764706969261169, 0.31764706969261169),
        (1.0, 0.18823529779911041, 0.18823529779911041),
    ],
    "red": [
        (0.0, 0.9686274528503418, 0.9686274528503418),
        (0.125, 0.87058824300765991, 0.87058824300765991),
        (0.25, 0.7764706015586853, 0.7764706015586853),
        (0.375, 0.61960786581039429, 0.61960786581039429),
        (0.5, 0.41960784792900085, 0.41960784792900085),
        (0.625, 0.25882354378700256, 0.25882354378700256),
        (0.75, 0.12941177189350128, 0.12941177189350128),
        (0.875, 0.031372550874948502, 0.031372550874948502),
        (1.0, 0.031372550874948502, 0.031372550874948502),
    ],
}

_BrBG_data = {
    "blue": [
        (0.0, 0.019607843831181526, 0.019607843831181526),
        (0.10000000000000001, 0.039215687662363052, 0.039215687662363052),
        (0.20000000000000001, 0.17647059261798859, 0.17647059261798859),
        (0.29999999999999999, 0.49019607901573181, 0.49019607901573181),
        (0.40000000000000002, 0.76470589637756348, 0.76470589637756348),
        (0.5, 0.96078431606292725, 0.96078431606292725),
        (0.59999999999999998, 0.89803922176361084, 0.89803922176361084),
        (0.69999999999999996, 0.75686275959014893, 0.75686275959014893),
        (0.80000000000000004, 0.56078433990478516, 0.56078433990478516),
        (0.90000000000000002, 0.36862745881080627, 0.36862745881080627),
        (1.0, 0.18823529779911041, 0.18823529779911041),
    ],
    "green": [
        (0.0, 0.18823529779911041, 0.18823529779911041),
        (0.10000000000000001, 0.31764706969261169, 0.31764706969261169),
        (0.20000000000000001, 0.5058823823928833, 0.5058823823928833),
        (0.29999999999999999, 0.7607843279838562, 0.7607843279838562),
        (0.40000000000000002, 0.90980392694473267, 0.90980392694473267),
        (0.5, 0.96078431606292725, 0.96078431606292725),
        (0.59999999999999998, 0.91764706373214722, 0.91764706373214722),
        (0.69999999999999996, 0.80392158031463623, 0.80392158031463623),
        (0.80000000000000004, 0.59215688705444336, 0.59215688705444336),
        (0.90000000000000002, 0.40000000596046448, 0.40000000596046448),
        (1.0, 0.23529411852359772, 0.23529411852359772),
    ],
    "red": [
        (0.0, 0.32941177487373352, 0.32941177487373352),
        (0.10000000000000001, 0.54901963472366333, 0.54901963472366333),
        (0.20000000000000001, 0.74901962280273438, 0.74901962280273438),
        (0.29999999999999999, 0.87450981140136719, 0.87450981140136719),
        (0.40000000000000002, 0.96470588445663452, 0.96470588445663452),
        (0.5, 0.96078431606292725, 0.96078431606292725),
        (0.59999999999999998, 0.78039216995239258, 0.78039216995239258),
        (0.69999999999999996, 0.50196081399917603, 0.50196081399917603),
        (0.80000000000000004, 0.20784313976764679, 0.20784313976764679),
        (0.90000000000000002, 0.0039215688593685627, 0.0039215688593685627),
        (1.0, 0.0, 0.0),
    ],
}

_BuGn_data = {
    "blue": [
        (0.0, 0.99215686321258545, 0.99215686321258545),
        (0.125, 0.97647058963775635, 0.97647058963775635),
        (0.25, 0.90196079015731812, 0.90196079015731812),
        (0.375, 0.78823530673980713, 0.78823530673980713),
        (0.5, 0.64313727617263794, 0.64313727617263794),
        (0.625, 0.46274510025978088, 0.46274510025978088),
        (0.75, 0.27058824896812439, 0.27058824896812439),
        (0.875, 0.17254902422428131, 0.17254902422428131),
        (1.0, 0.10588235408067703, 0.10588235408067703),
    ],
    "green": [
        (0.0, 0.98823529481887817, 0.98823529481887817),
        (0.125, 0.96078431606292725, 0.96078431606292725),
        (0.25, 0.92549020051956177, 0.92549020051956177),
        (0.375, 0.84705883264541626, 0.84705883264541626),
        (0.5, 0.7607843279838562, 0.7607843279838562),
        (0.625, 0.68235296010971069, 0.68235296010971069),
        (0.75, 0.54509806632995605, 0.54509806632995605),
        (0.875, 0.42745098471641541, 0.42745098471641541),
        (1.0, 0.26666668057441711, 0.26666668057441711),
    ],
    "red": [
        (0.0, 0.9686274528503418, 0.9686274528503418),
        (0.125, 0.89803922176361084, 0.89803922176361084),
        (0.25, 0.80000001192092896, 0.80000001192092896),
        (0.375, 0.60000002384185791, 0.60000002384185791),
        (0.5, 0.40000000596046448, 0.40000000596046448),
        (0.625, 0.25490197539329529, 0.25490197539329529),
        (0.75, 0.13725490868091583, 0.13725490868091583),
        (0.875, 0.0, 0.0),
        (1.0, 0.0, 0.0),
    ],
}

_BuPu_data = {
    "blue": [
        (0.0, 0.99215686321258545, 0.99215686321258545),
        (0.125, 0.95686274766921997, 0.95686274766921997),
        (0.25, 0.90196079015731812, 0.90196079015731812),
        (0.375, 0.85490196943283081, 0.85490196943283081),
        (0.5, 0.7764706015586853, 0.7764706015586853),
        (0.625, 0.69411766529083252, 0.69411766529083252),
        (0.75, 0.61568629741668701, 0.61568629741668701),
        (0.875, 0.48627451062202454, 0.48627451062202454),
        (1.0, 0.29411765933036804, 0.29411765933036804),
    ],
    "green": [
        (0.0, 0.98823529481887817, 0.98823529481887817),
        (0.125, 0.92549020051956177, 0.92549020051956177),
        (0.25, 0.82745099067687988, 0.82745099067687988),
        (0.375, 0.73725491762161255, 0.73725491762161255),
        (0.5, 0.58823531866073608, 0.58823531866073608),
        (0.625, 0.41960784792900085, 0.41960784792900085),
        (0.75, 0.25490197539329529, 0.25490197539329529),
        (0.875, 0.058823529630899429, 0.058823529630899429),
        (1.0, 0.0, 0.0),
    ],
    "red": [
        (0.0, 0.9686274528503418, 0.9686274528503418),
        (0.125, 0.87843137979507446, 0.87843137979507446),
        (0.25, 0.74901962280273438, 0.74901962280273438),
        (0.375, 0.61960786581039429, 0.61960786581039429),
        (0.5, 0.54901963472366333, 0.54901963472366333),
        (0.625, 0.54901963472366333, 0.54901963472366333),
        (0.75, 0.53333336114883423, 0.53333336114883423),
        (0.875, 0.5058823823928833, 0.5058823823928833),
        (1.0, 0.30196079611778259, 0.30196079611778259),
    ],
}

_Dark2_data = {
    "blue": [
        (0.0, 0.46666666865348816, 0.46666666865348816),
        (0.14285714285714285, 0.0078431377187371254, 0.0078431377187371254),
        (0.2857142857142857, 0.70196080207824707, 0.70196080207824707),
        (0.42857142857142855, 0.54117649793624878, 0.54117649793624878),
        (0.5714285714285714, 0.11764705926179886, 0.11764705926179886),
        (0.7142857142857143, 0.0078431377187371254, 0.0078431377187371254),
        (0.8571428571428571, 0.11372549086809158, 0.11372549086809158),
        (1.0, 0.40000000596046448, 0.40000000596046448),
    ],
    "green": [
        (0.0, 0.61960786581039429, 0.61960786581039429),
        (0.14285714285714285, 0.37254902720451355, 0.37254902720451355),
        (0.2857142857142857, 0.43921568989753723, 0.43921568989753723),
        (0.42857142857142855, 0.16078431904315948, 0.16078431904315948),
        (0.5714285714285714, 0.65098041296005249, 0.65098041296005249),
        (0.7142857142857143, 0.67058825492858887, 0.67058825492858887),
        (0.8571428571428571, 0.46274510025978088, 0.46274510025978088),
        (1.0, 0.40000000596046448, 0.40000000596046448),
    ],
    "red": [
        (0.0, 0.10588235408067703, 0.10588235408067703),
        (0.14285714285714285, 0.85098040103912354, 0.85098040103912354),
        (0.2857142857142857, 0.45882353186607361, 0.45882353186607361),
        (0.42857142857142855, 0.90588235855102539, 0.90588235855102539),
        (0.5714285714285714, 0.40000000596046448, 0.40000000596046448),
        (0.7142857142857143, 0.90196079015731812, 0.90196079015731812),
        (0.8571428571428571, 0.65098041296005249, 0.65098041296005249),
        (1.0, 0.40000000596046448, 0.40000000596046448),
    ],
}

_GnBu_data = {
    "blue": [
        (0.0, 0.94117647409439087, 0.94117647409439087),
        (0.125, 0.85882353782653809, 0.85882353782653809),
        (0.25, 0.77254903316497803, 0.77254903316497803),
        (0.375, 0.70980393886566162, 0.70980393886566162),
        (0.5, 0.76862746477127075, 0.76862746477127075),
        (0.625, 0.82745099067687988, 0.82745099067687988),
        (0.75, 0.7450980544090271, 0.7450980544090271),
        (0.875, 0.67450982332229614, 0.67450982332229614),
        (1.0, 0.5058823823928833, 0.5058823823928833),
    ],
    "green": [
        (0.0, 0.98823529481887817, 0.98823529481887817),
        (0.125, 0.9529411792755127, 0.9529411792755127),
        (0.25, 0.92156863212585449, 0.92156863212585449),
        (0.375, 0.86666667461395264, 0.86666667461395264),
        (0.5, 0.80000001192092896, 0.80000001192092896),
        (0.625, 0.70196080207824707, 0.70196080207824707),
        (0.75, 0.54901963472366333, 0.54901963472366333),
        (0.875, 0.40784314274787903, 0.40784314274787903),
        (1.0, 0.25098040699958801, 0.25098040699958801),
    ],
    "red": [
        (0.0, 0.9686274528503418, 0.9686274528503418),
        (0.125, 0.87843137979507446, 0.87843137979507446),
        (0.25, 0.80000001192092896, 0.80000001192092896),
        (0.375, 0.65882354974746704, 0.65882354974746704),
        (0.5, 0.48235294222831726, 0.48235294222831726),
        (0.625, 0.30588236451148987, 0.30588236451148987),
        (0.75, 0.16862745583057404, 0.16862745583057404),
        (0.875, 0.031372550874948502, 0.031372550874948502),
        (1.0, 0.031372550874948502, 0.031372550874948502),
    ],
}

_Greens_data = {
    "blue": [
        (0.0, 0.96078431606292725, 0.96078431606292725),
        (0.125, 0.87843137979507446, 0.87843137979507446),
        (0.25, 0.75294119119644165, 0.75294119119644165),
        (0.375, 0.60784316062927246, 0.60784316062927246),
        (0.5, 0.46274510025978088, 0.46274510025978088),
        (0.625, 0.364705890417099, 0.364705890417099),
        (0.75, 0.27058824896812439, 0.27058824896812439),
        (0.875, 0.17254902422428131, 0.17254902422428131),
        (1.0, 0.10588235408067703, 0.10588235408067703),
    ],
    "green": [
        (0.0, 0.98823529481887817, 0.98823529481887817),
        (0.125, 0.96078431606292725, 0.96078431606292725),
        (0.25, 0.91372549533843994, 0.91372549533843994),
        (0.375, 0.85098040103912354, 0.85098040103912354),
        (0.5, 0.76862746477127075, 0.76862746477127075),
        (0.625, 0.67058825492858887, 0.67058825492858887),
        (0.75, 0.54509806632995605, 0.54509806632995605),
        (0.875, 0.42745098471641541, 0.42745098471641541),
        (1.0, 0.26666668057441711, 0.26666668057441711),
    ],
    "red": [
        (0.0, 0.9686274528503418, 0.9686274528503418),
        (0.125, 0.89803922176361084, 0.89803922176361084),
        (0.25, 0.78039216995239258, 0.78039216995239258),
        (0.375, 0.63137257099151611, 0.63137257099151611),
        (0.5, 0.45490196347236633, 0.45490196347236633),
        (0.625, 0.25490197539329529, 0.25490197539329529),
        (0.75, 0.13725490868091583, 0.13725490868091583),
        (0.875, 0.0, 0.0),
        (1.0, 0.0, 0.0),
    ],
}

_Greys_data = {
    "blue": [
        (0.0, 1.0, 1.0),
        (0.125, 0.94117647409439087, 0.94117647409439087),
        (0.25, 0.85098040103912354, 0.85098040103912354),
        (0.375, 0.74117648601531982, 0.74117648601531982),
        (0.5, 0.58823531866073608, 0.58823531866073608),
        (0.625, 0.45098039507865906, 0.45098039507865906),
        (0.75, 0.32156863808631897, 0.32156863808631897),
        (0.875, 0.14509804546833038, 0.14509804546833038),
        (1.0, 0.0, 0.0),
    ],
    "green": [
        (0.0, 1.0, 1.0),
        (0.125, 0.94117647409439087, 0.94117647409439087),
        (0.25, 0.85098040103912354, 0.85098040103912354),
        (0.375, 0.74117648601531982, 0.74117648601531982),
        (0.5, 0.58823531866073608, 0.58823531866073608),
        (0.625, 0.45098039507865906, 0.45098039507865906),
        (0.75, 0.32156863808631897, 0.32156863808631897),
        (0.875, 0.14509804546833038, 0.14509804546833038),
        (1.0, 0.0, 0.0),
    ],
    "red": [
        (0.0, 1.0, 1.0),
        (0.125, 0.94117647409439087, 0.94117647409439087),
        (0.25, 0.85098040103912354, 0.85098040103912354),
        (0.375, 0.74117648601531982, 0.74117648601531982),
        (0.5, 0.58823531866073608, 0.58823531866073608),
        (0.625, 0.45098039507865906, 0.45098039507865906),
        (0.75, 0.32156863808631897, 0.32156863808631897),
        (0.875, 0.14509804546833038, 0.14509804546833038),
        (1.0, 0.0, 0.0),
    ],
}

_Oranges_data = {
    "blue": [
        (0.0, 0.92156863212585449, 0.92156863212585449),
        (0.125, 0.80784314870834351, 0.80784314870834351),
        (0.25, 0.63529413938522339, 0.63529413938522339),
        (0.375, 0.41960784792900085, 0.41960784792900085),
        (0.5, 0.23529411852359772, 0.23529411852359772),
        (0.625, 0.074509806931018829, 0.074509806931018829),
        (0.75, 0.0039215688593685627, 0.0039215688593685627),
        (0.875, 0.011764706112444401, 0.011764706112444401),
        (1.0, 0.015686275437474251, 0.015686275437474251),
    ],
    "green": [
        (0.0, 0.96078431606292725, 0.96078431606292725),
        (0.125, 0.90196079015731812, 0.90196079015731812),
        (0.25, 0.81568628549575806, 0.81568628549575806),
        (0.375, 0.68235296010971069, 0.68235296010971069),
        (0.5, 0.55294120311737061, 0.55294120311737061),
        (0.625, 0.4117647111415863, 0.4117647111415863),
        (0.75, 0.28235295414924622, 0.28235295414924622),
        (0.875, 0.21176470816135406, 0.21176470816135406),
        (1.0, 0.15294118225574493, 0.15294118225574493),
    ],
    "red": [
        (0.0, 1.0, 1.0),
        (0.125, 0.99607843160629272, 0.99607843160629272),
        (0.25, 0.99215686321258545, 0.99215686321258545),
        (0.375, 0.99215686321258545, 0.99215686321258545),
        (0.5, 0.99215686321258545, 0.99215686321258545),
        (0.625, 0.94509804248809814, 0.94509804248809814),
        (0.75, 0.85098040103912354, 0.85098040103912354),
        (0.875, 0.65098041296005249, 0.65098041296005249),
        (1.0, 0.49803921580314636, 0.49803921580314636),
    ],
}

_OrRd_data = {
    "blue": [
        (0.0, 0.92549020051956177, 0.92549020051956177),
        (0.125, 0.78431373834609985, 0.78431373834609985),
        (0.25, 0.61960786581039429, 0.61960786581039429),
        (0.375, 0.51764708757400513, 0.51764708757400513),
        (0.5, 0.3490196168422699, 0.3490196168422699),
        (0.625, 0.28235295414924622, 0.28235295414924622),
        (0.75, 0.12156862765550613, 0.12156862765550613),
        (0.875, 0.0, 0.0),
        (1.0, 0.0, 0.0),
    ],
    "green": [
        (0.0, 0.9686274528503418, 0.9686274528503418),
        (0.125, 0.90980392694473267, 0.90980392694473267),
        (0.25, 0.83137255907058716, 0.83137255907058716),
        (0.375, 0.73333334922790527, 0.73333334922790527),
        (0.5, 0.55294120311737061, 0.55294120311737061),
        (0.625, 0.3960784375667572, 0.3960784375667572),
        (0.75, 0.18823529779911041, 0.18823529779911041),
        (0.875, 0.0, 0.0),
        (1.0, 0.0, 0.0),
    ],
    "red": [
        (0.0, 1.0, 1.0),
        (0.125, 0.99607843160629272, 0.99607843160629272),
        (0.25, 0.99215686321258545, 0.99215686321258545),
        (0.375, 0.99215686321258545, 0.99215686321258545),
        (0.5, 0.98823529481887817, 0.98823529481887817),
        (0.625, 0.93725490570068359, 0.93725490570068359),
        (0.75, 0.84313726425170898, 0.84313726425170898),
        (0.875, 0.70196080207824707, 0.70196080207824707),
        (1.0, 0.49803921580314636, 0.49803921580314636),
    ],
}

_Paired_data = {
    "blue": [
        (0.0, 0.89019608497619629, 0.89019608497619629),
        (0.090909090909090912, 0.70588237047195435, 0.70588237047195435),
        (0.18181818181818182, 0.54117649793624878, 0.54117649793624878),
        (0.27272727272727271, 0.17254902422428131, 0.17254902422428131),
        (0.36363636363636365, 0.60000002384185791, 0.60000002384185791),
        (0.45454545454545453, 0.10980392247438431, 0.10980392247438431),
        (0.54545454545454541, 0.43529412150382996, 0.43529412150382996),
        (0.63636363636363635, 0.0, 0.0),
        (0.72727272727272729, 0.83921569585800171, 0.83921569585800171),
        (0.81818181818181823, 0.60392159223556519, 0.60392159223556519),
        (0.90909090909090906, 0.60000002384185791, 0.60000002384185791),
        (1.0, 0.15686275064945221, 0.15686275064945221),
    ],
    "green": [
        (0.0, 0.80784314870834351, 0.80784314870834351),
        (0.090909090909090912, 0.47058823704719543, 0.47058823704719543),
        (0.18181818181818182, 0.87450981140136719, 0.87450981140136719),
        (0.27272727272727271, 0.62745100259780884, 0.62745100259780884),
        (0.36363636363636365, 0.60392159223556519, 0.60392159223556519),
        (0.45454545454545453, 0.10196078568696976, 0.10196078568696976),
        (0.54545454545454541, 0.74901962280273438, 0.74901962280273438),
        (0.63636363636363635, 0.49803921580314636, 0.49803921580314636),
        (0.72727272727272729, 0.69803923368453979, 0.69803923368453979),
        (0.81818181818181823, 0.23921568691730499, 0.23921568691730499),
        (0.90909090909090906, 1.0, 1.0),
        (1.0, 0.3490196168422699, 0.3490196168422699),
    ],
    "red": [
        (0.0, 0.65098041296005249, 0.65098041296005249),
        (0.090909090909090912, 0.12156862765550613, 0.12156862765550613),
        (0.18181818181818182, 0.69803923368453979, 0.69803923368453979),
        (0.27272727272727271, 0.20000000298023224, 0.20000000298023224),
        (0.36363636363636365, 0.9843137264251709, 0.9843137264251709),
        (0.45454545454545453, 0.89019608497619629, 0.89019608497619629),
        (0.54545454545454541, 0.99215686321258545, 0.99215686321258545),
        (0.63636363636363635, 1.0, 1.0),
        (0.72727272727272729, 0.7921568751335144, 0.7921568751335144),
        (0.81818181818181823, 0.41568627953529358, 0.41568627953529358),
        (0.90909090909090906, 1.0, 1.0),
        (1.0, 0.69411766529083252, 0.69411766529083252),
    ],
}

_Pastel1_data = {
    "blue": [
        (0.0, 0.68235296010971069, 0.68235296010971069),
        (0.125, 0.89019608497619629, 0.89019608497619629),
        (0.25, 0.77254903316497803, 0.77254903316497803),
        (0.375, 0.89411765336990356, 0.89411765336990356),
        (0.5, 0.65098041296005249, 0.65098041296005249),
        (0.625, 0.80000001192092896, 0.80000001192092896),
        (0.75, 0.74117648601531982, 0.74117648601531982),
        (0.875, 0.92549020051956177, 0.92549020051956177),
        (1.0, 0.94901961088180542, 0.94901961088180542),
    ],
    "green": [
        (0.0, 0.70588237047195435, 0.70588237047195435),
        (0.125, 0.80392158031463623, 0.80392158031463623),
        (0.25, 0.92156863212585449, 0.92156863212585449),
        (0.375, 0.79607844352722168, 0.79607844352722168),
        (0.5, 0.85098040103912354, 0.85098040103912354),
        (0.625, 1.0, 1.0),
        (0.75, 0.84705883264541626, 0.84705883264541626),
        (0.875, 0.85490196943283081, 0.85490196943283081),
        (1.0, 0.94901961088180542, 0.94901961088180542),
    ],
    "red": [
        (0.0, 0.9843137264251709, 0.9843137264251709),
        (0.125, 0.70196080207824707, 0.70196080207824707),
        (0.25, 0.80000001192092896, 0.80000001192092896),
        (0.375, 0.87058824300765991, 0.87058824300765991),
        (0.5, 0.99607843160629272, 0.99607843160629272),
        (0.625, 1.0, 1.0),
        (0.75, 0.89803922176361084, 0.89803922176361084),
        (0.875, 0.99215686321258545, 0.99215686321258545),
        (1.0, 0.94901961088180542, 0.94901961088180542),
    ],
}

_Pastel2_data = {
    "blue": [
        (0.0, 0.80392158031463623, 0.80392158031463623),
        (0.14285714285714285, 0.67450982332229614, 0.67450982332229614),
        (0.2857142857142857, 0.90980392694473267, 0.90980392694473267),
        (0.42857142857142855, 0.89411765336990356, 0.89411765336990356),
        (0.5714285714285714, 0.78823530673980713, 0.78823530673980713),
        (0.7142857142857143, 0.68235296010971069, 0.68235296010971069),
        (0.8571428571428571, 0.80000001192092896, 0.80000001192092896),
        (1.0, 0.80000001192092896, 0.80000001192092896),
    ],
    "green": [
        (0.0, 0.88627451658248901, 0.88627451658248901),
        (0.14285714285714285, 0.80392158031463623, 0.80392158031463623),
        (0.2857142857142857, 0.83529412746429443, 0.83529412746429443),
        (0.42857142857142855, 0.7921568751335144, 0.7921568751335144),
        (0.5714285714285714, 0.96078431606292725, 0.96078431606292725),
        (0.7142857142857143, 0.94901961088180542, 0.94901961088180542),
        (0.8571428571428571, 0.88627451658248901, 0.88627451658248901),
        (1.0, 0.80000001192092896, 0.80000001192092896),
    ],
    "red": [
        (0.0, 0.70196080207824707, 0.70196080207824707),
        (0.14285714285714285, 0.99215686321258545, 0.99215686321258545),
        (0.2857142857142857, 0.79607844352722168, 0.79607844352722168),
        (0.42857142857142855, 0.95686274766921997, 0.95686274766921997),
        (0.5714285714285714, 0.90196079015731812, 0.90196079015731812),
        (0.7142857142857143, 1.0, 1.0),
        (0.8571428571428571, 0.94509804248809814, 0.94509804248809814),
        (1.0, 0.80000001192092896, 0.80000001192092896),
    ],
}

_PiYG_data = {
    "blue": [
        (0.0, 0.32156863808631897, 0.32156863808631897),
        (0.10000000000000001, 0.49019607901573181, 0.49019607901573181),
        (0.20000000000000001, 0.68235296010971069, 0.68235296010971069),
        (0.29999999999999999, 0.85490196943283081, 0.85490196943283081),
        (0.40000000000000002, 0.93725490570068359, 0.93725490570068359),
        (0.5, 0.9686274528503418, 0.9686274528503418),
        (0.59999999999999998, 0.81568628549575806, 0.81568628549575806),
        (0.69999999999999996, 0.52549022436141968, 0.52549022436141968),
        (0.80000000000000004, 0.25490197539329529, 0.25490197539329529),
        (0.90000000000000002, 0.12941177189350128, 0.12941177189350128),
        (1.0, 0.098039217293262482, 0.098039217293262482),
    ],
    "green": [
        (0.0, 0.0039215688593685627, 0.0039215688593685627),
        (0.10000000000000001, 0.10588235408067703, 0.10588235408067703),
        (0.20000000000000001, 0.46666666865348816, 0.46666666865348816),
        (0.29999999999999999, 0.7137255072593689, 0.7137255072593689),
        (0.40000000000000002, 0.87843137979507446, 0.87843137979507446),
        (0.5, 0.9686274528503418, 0.9686274528503418),
        (0.59999999999999998, 0.96078431606292725, 0.96078431606292725),
        (0.69999999999999996, 0.88235294818878174, 0.88235294818878174),
        (0.80000000000000004, 0.73725491762161255, 0.73725491762161255),
        (0.90000000000000002, 0.57254904508590698, 0.57254904508590698),
        (1.0, 0.39215686917304993, 0.39215686917304993),
    ],
    "red": [
        (0.0, 0.55686277151107788, 0.55686277151107788),
        (0.10000000000000001, 0.77254903316497803, 0.77254903316497803),
        (0.20000000000000001, 0.87058824300765991, 0.87058824300765991),
        (0.29999999999999999, 0.94509804248809814, 0.94509804248809814),
        (0.40000000000000002, 0.99215686321258545, 0.99215686321258545),
        (0.5, 0.9686274528503418, 0.9686274528503418),
        (0.59999999999999998, 0.90196079015731812, 0.90196079015731812),
        (0.69999999999999996, 0.72156864404678345, 0.72156864404678345),
        (0.80000000000000004, 0.49803921580314636, 0.49803921580314636),
        (0.90000000000000002, 0.30196079611778259, 0.30196079611778259),
        (1.0, 0.15294118225574493, 0.15294118225574493),
    ],
}

_PRGn_data = {
    "blue": [
        (0.0, 0.29411765933036804, 0.29411765933036804),
        (0.10000000000000001, 0.51372551918029785, 0.51372551918029785),
        (0.20000000000000001, 0.67058825492858887, 0.67058825492858887),
        (0.29999999999999999, 0.81176471710205078, 0.81176471710205078),
        (0.40000000000000002, 0.90980392694473267, 0.90980392694473267),
        (0.5, 0.9686274528503418, 0.9686274528503418),
        (0.59999999999999998, 0.82745099067687988, 0.82745099067687988),
        (0.69999999999999996, 0.62745100259780884, 0.62745100259780884),
        (0.80000000000000004, 0.3803921639919281, 0.3803921639919281),
        (0.90000000000000002, 0.21568627655506134, 0.21568627655506134),
        (1.0, 0.10588235408067703, 0.10588235408067703),
    ],
    "green": [
        (0.0, 0.0, 0.0),
        (0.10000000000000001, 0.16470588743686676, 0.16470588743686676),
        (0.20000000000000001, 0.43921568989753723, 0.43921568989753723),
        (0.29999999999999999, 0.64705884456634521, 0.64705884456634521),
        (0.40000000000000002, 0.83137255907058716, 0.83137255907058716),
        (0.5, 0.9686274528503418, 0.9686274528503418),
        (0.59999999999999998, 0.94117647409439087, 0.94117647409439087),
        (0.69999999999999996, 0.85882353782653809, 0.85882353782653809),
        (0.80000000000000004, 0.68235296010971069, 0.68235296010971069),
        (0.90000000000000002, 0.47058823704719543, 0.47058823704719543),
        (1.0, 0.26666668057441711, 0.26666668057441711),
    ],
    "red": [
        (0.0, 0.25098040699958801, 0.25098040699958801),
        (0.10000000000000001, 0.46274510025978088, 0.46274510025978088),
        (0.20000000000000001, 0.60000002384185791, 0.60000002384185791),
        (0.29999999999999999, 0.7607843279838562, 0.7607843279838562),
        (0.40000000000000002, 0.90588235855102539, 0.90588235855102539),
        (0.5, 0.9686274528503418, 0.9686274528503418),
        (0.59999999999999998, 0.85098040103912354, 0.85098040103912354),
        (0.69999999999999996, 0.65098041296005249, 0.65098041296005249),
        (0.80000000000000004, 0.35294118523597717, 0.35294118523597717),
        (0.90000000000000002, 0.10588235408067703, 0.10588235408067703),
        (1.0, 0.0, 0.0),
    ],
}

_PuBu_data = {
    "blue": [
        (0.0, 0.9843137264251709, 0.9843137264251709),
        (0.125, 0.94901961088180542, 0.94901961088180542),
        (0.25, 0.90196079015731812, 0.90196079015731812),
        (0.375, 0.85882353782653809, 0.85882353782653809),
        (0.5, 0.81176471710205078, 0.81176471710205078),
        (0.625, 0.75294119119644165, 0.75294119119644165),
        (0.75, 0.69019609689712524, 0.69019609689712524),
        (0.875, 0.55294120311737061, 0.55294120311737061),
        (1.0, 0.34509804844856262, 0.34509804844856262),
    ],
    "green": [
        (0.0, 0.9686274528503418, 0.9686274528503418),
        (0.125, 0.90588235855102539, 0.90588235855102539),
        (0.25, 0.81960785388946533, 0.81960785388946533),
        (0.375, 0.74117648601531982, 0.74117648601531982),
        (0.5, 0.66274511814117432, 0.66274511814117432),
        (0.625, 0.56470590829849243, 0.56470590829849243),
        (0.75, 0.43921568989753723, 0.43921568989753723),
        (0.875, 0.35294118523597717, 0.35294118523597717),
        (1.0, 0.21960784494876862, 0.21960784494876862),
    ],
    "red": [
        (0.0, 1.0, 1.0),
        (0.125, 0.92549020051956177, 0.92549020051956177),
        (0.25, 0.81568628549575806, 0.81568628549575806),
        (0.375, 0.65098041296005249, 0.65098041296005249),
        (0.5, 0.45490196347236633, 0.45490196347236633),
        (0.625, 0.21176470816135406, 0.21176470816135406),
        (0.75, 0.019607843831181526, 0.019607843831181526),
        (0.875, 0.015686275437474251, 0.015686275437474251),
        (1.0, 0.0078431377187371254, 0.0078431377187371254),
    ],
}

_PuBuGn_data = {
    "blue": [
        (0.0, 0.9843137264251709, 0.9843137264251709),
        (0.125, 0.94117647409439087, 0.94117647409439087),
        (0.25, 0.90196079015731812, 0.90196079015731812),
        (0.375, 0.85882353782653809, 0.85882353782653809),
        (0.5, 0.81176471710205078, 0.81176471710205078),
        (0.625, 0.75294119119644165, 0.75294119119644165),
        (0.75, 0.54117649793624878, 0.54117649793624878),
        (0.875, 0.3490196168422699, 0.3490196168422699),
        (1.0, 0.21176470816135406, 0.21176470816135406),
    ],
    "green": [
        (0.0, 0.9686274528503418, 0.9686274528503418),
        (0.125, 0.88627451658248901, 0.88627451658248901),
        (0.25, 0.81960785388946533, 0.81960785388946533),
        (0.375, 0.74117648601531982, 0.74117648601531982),
        (0.5, 0.66274511814117432, 0.66274511814117432),
        (0.625, 0.56470590829849243, 0.56470590829849243),
        (0.75, 0.5058823823928833, 0.5058823823928833),
        (0.875, 0.42352941632270813, 0.42352941632270813),
        (1.0, 0.27450981736183167, 0.27450981736183167),
    ],
    "red": [
        (0.0, 1.0, 1.0),
        (0.125, 0.92549020051956177, 0.92549020051956177),
        (0.25, 0.81568628549575806, 0.81568628549575806),
        (0.375, 0.65098041296005249, 0.65098041296005249),
        (0.5, 0.40392157435417175, 0.40392157435417175),
        (0.625, 0.21176470816135406, 0.21176470816135406),
        (0.75, 0.0078431377187371254, 0.0078431377187371254),
        (0.875, 0.0039215688593685627, 0.0039215688593685627),
        (1.0, 0.0039215688593685627, 0.0039215688593685627),
    ],
}

_PuOr_data = {
    "blue": [
        (0.0, 0.031372550874948502, 0.031372550874948502),
        (0.10000000000000001, 0.023529412224888802, 0.023529412224888802),
        (0.20000000000000001, 0.078431375324726105, 0.078431375324726105),
        (0.29999999999999999, 0.38823530077934265, 0.38823530077934265),
        (0.40000000000000002, 0.7137255072593689, 0.7137255072593689),
        (0.5, 0.9686274528503418, 0.9686274528503418),
        (0.59999999999999998, 0.92156863212585449, 0.92156863212585449),
        (0.69999999999999996, 0.82352942228317261, 0.82352942228317261),
        (0.80000000000000004, 0.67450982332229614, 0.67450982332229614),
        (0.90000000000000002, 0.53333336114883423, 0.53333336114883423),
        (1.0, 0.29411765933036804, 0.29411765933036804),
    ],
    "green": [
        (0.0, 0.23137255012989044, 0.23137255012989044),
        (0.10000000000000001, 0.34509804844856262, 0.34509804844856262),
        (0.20000000000000001, 0.50980395078659058, 0.50980395078659058),
        (0.29999999999999999, 0.72156864404678345, 0.72156864404678345),
        (0.40000000000000002, 0.87843137979507446, 0.87843137979507446),
        (0.5, 0.9686274528503418, 0.9686274528503418),
        (0.59999999999999998, 0.85490196943283081, 0.85490196943283081),
        (0.69999999999999996, 0.67058825492858887, 0.67058825492858887),
        (0.80000000000000004, 0.45098039507865906, 0.45098039507865906),
        (0.90000000000000002, 0.15294118225574493, 0.15294118225574493),
        (1.0, 0.0, 0.0),
    ],
    "red": [
        (0.0, 0.49803921580314636, 0.49803921580314636),
        (0.10000000000000001, 0.70196080207824707, 0.70196080207824707),
        (0.20000000000000001, 0.87843137979507446, 0.87843137979507446),
        (0.29999999999999999, 0.99215686321258545, 0.99215686321258545),
        (0.40000000000000002, 0.99607843160629272, 0.99607843160629272),
        (0.5, 0.9686274528503418, 0.9686274528503418),
        (0.59999999999999998, 0.84705883264541626, 0.84705883264541626),
        (0.69999999999999996, 0.69803923368453979, 0.69803923368453979),
        (0.80000000000000004, 0.50196081399917603, 0.50196081399917603),
        (0.90000000000000002, 0.32941177487373352, 0.32941177487373352),
        (1.0, 0.17647059261798859, 0.17647059261798859),
    ],
}

_PuRd_data = {
    "blue": [
        (0.0, 0.97647058963775635, 0.97647058963775635),
        (0.125, 0.93725490570068359, 0.93725490570068359),
        (0.25, 0.85490196943283081, 0.85490196943283081),
        (0.375, 0.78039216995239258, 0.78039216995239258),
        (0.5, 0.69019609689712524, 0.69019609689712524),
        (0.625, 0.54117649793624878, 0.54117649793624878),
        (0.75, 0.33725491166114807, 0.33725491166114807),
        (0.875, 0.26274511218070984, 0.26274511218070984),
        (1.0, 0.12156862765550613, 0.12156862765550613),
    ],
    "green": [
        (0.0, 0.95686274766921997, 0.95686274766921997),
        (0.125, 0.88235294818878174, 0.88235294818878174),
        (0.25, 0.72549021244049072, 0.72549021244049072),
        (0.375, 0.58039218187332153, 0.58039218187332153),
        (0.5, 0.3960784375667572, 0.3960784375667572),
        (0.625, 0.16078431904315948, 0.16078431904315948),
        (0.75, 0.070588238537311554, 0.070588238537311554),
        (0.875, 0.0, 0.0),
        (1.0, 0.0, 0.0),
    ],
    "red": [
        (0.0, 0.9686274528503418, 0.9686274528503418),
        (0.125, 0.90588235855102539, 0.90588235855102539),
        (0.25, 0.83137255907058716, 0.83137255907058716),
        (0.375, 0.78823530673980713, 0.78823530673980713),
        (0.5, 0.87450981140136719, 0.87450981140136719),
        (0.625, 0.90588235855102539, 0.90588235855102539),
        (0.75, 0.80784314870834351, 0.80784314870834351),
        (0.875, 0.59607845544815063, 0.59607845544815063),
        (1.0, 0.40392157435417175, 0.40392157435417175),
    ],
}

_Purples_data = {
    "blue": [
        (0.0, 0.99215686321258545, 0.99215686321258545),
        (0.125, 0.96078431606292725, 0.96078431606292725),
        (0.25, 0.92156863212585449, 0.92156863212585449),
        (0.375, 0.86274510622024536, 0.86274510622024536),
        (0.5, 0.78431373834609985, 0.78431373834609985),
        (0.625, 0.729411780834198, 0.729411780834198),
        (0.75, 0.63921570777893066, 0.63921570777893066),
        (0.875, 0.56078433990478516, 0.56078433990478516),
        (1.0, 0.49019607901573181, 0.49019607901573181),
    ],
    "green": [
        (0.0, 0.9843137264251709, 0.9843137264251709),
        (0.125, 0.92941176891326904, 0.92941176891326904),
        (0.25, 0.85490196943283081, 0.85490196943283081),
        (0.375, 0.74117648601531982, 0.74117648601531982),
        (0.5, 0.60392159223556519, 0.60392159223556519),
        (0.625, 0.49019607901573181, 0.49019607901573181),
        (0.75, 0.31764706969261169, 0.31764706969261169),
        (0.875, 0.15294118225574493, 0.15294118225574493),
        (1.0, 0.0, 0.0),
    ],
    "red": [
        (0.0, 0.98823529481887817, 0.98823529481887817),
        (0.125, 0.93725490570068359, 0.93725490570068359),
        (0.25, 0.85490196943283081, 0.85490196943283081),
        (0.375, 0.73725491762161255, 0.73725491762161255),
        (0.5, 0.61960786581039429, 0.61960786581039429),
        (0.625, 0.50196081399917603, 0.50196081399917603),
        (0.75, 0.41568627953529358, 0.41568627953529358),
        (0.875, 0.32941177487373352, 0.32941177487373352),
        (1.0, 0.24705882370471954, 0.24705882370471954),
    ],
}

_RdBu_data = {
    "blue": [
        (0.0, 0.12156862765550613, 0.12156862765550613),
        (0.10000000000000001, 0.16862745583057404, 0.16862745583057404),
        (0.20000000000000001, 0.30196079611778259, 0.30196079611778259),
        (0.29999999999999999, 0.50980395078659058, 0.50980395078659058),
        (0.40000000000000002, 0.78039216995239258, 0.78039216995239258),
        (0.5, 0.9686274528503418, 0.9686274528503418),
        (0.59999999999999998, 0.94117647409439087, 0.94117647409439087),
        (0.69999999999999996, 0.87058824300765991, 0.87058824300765991),
        (0.80000000000000004, 0.76470589637756348, 0.76470589637756348),
        (0.90000000000000002, 0.67450982332229614, 0.67450982332229614),
        (1.0, 0.3803921639919281, 0.3803921639919281),
    ],
    "green": [
        (0.0, 0.0, 0.0),
        (0.10000000000000001, 0.094117648899555206, 0.094117648899555206),
        (0.20000000000000001, 0.37647059559822083, 0.37647059559822083),
        (0.29999999999999999, 0.64705884456634521, 0.64705884456634521),
        (0.40000000000000002, 0.85882353782653809, 0.85882353782653809),
        (0.5, 0.9686274528503418, 0.9686274528503418),
        (0.59999999999999998, 0.89803922176361084, 0.89803922176361084),
        (0.69999999999999996, 0.77254903316497803, 0.77254903316497803),
        (0.80000000000000004, 0.57647061347961426, 0.57647061347961426),
        (0.90000000000000002, 0.40000000596046448, 0.40000000596046448),
        (1.0, 0.18823529779911041, 0.18823529779911041),
    ],
    "red": [
        (0.0, 0.40392157435417175, 0.40392157435417175),
        (0.10000000000000001, 0.69803923368453979, 0.69803923368453979),
        (0.20000000000000001, 0.83921569585800171, 0.83921569585800171),
        (0.29999999999999999, 0.95686274766921997, 0.95686274766921997),
        (0.40000000000000002, 0.99215686321258545, 0.99215686321258545),
        (0.5, 0.9686274528503418, 0.9686274528503418),
        (0.59999999999999998, 0.81960785388946533, 0.81960785388946533),
        (0.69999999999999996, 0.57254904508590698, 0.57254904508590698),
        (0.80000000000000004, 0.26274511218070984, 0.26274511218070984),
        (0.90000000000000002, 0.12941177189350128, 0.12941177189350128),
        (1.0, 0.019607843831181526, 0.019607843831181526),
    ],
}

_RdGy_data = {
    "blue": [
        (0.0, 0.12156862765550613, 0.12156862765550613),
        (0.10000000000000001, 0.16862745583057404, 0.16862745583057404),
        (0.20000000000000001, 0.30196079611778259, 0.30196079611778259),
        (0.29999999999999999, 0.50980395078659058, 0.50980395078659058),
        (0.40000000000000002, 0.78039216995239258, 0.78039216995239258),
        (0.5, 1.0, 1.0),
        (0.59999999999999998, 0.87843137979507446, 0.87843137979507446),
        (0.69999999999999996, 0.729411780834198, 0.729411780834198),
        (0.80000000000000004, 0.52941179275512695, 0.52941179275512695),
        (0.90000000000000002, 0.30196079611778259, 0.30196079611778259),
        (1.0, 0.10196078568696976, 0.10196078568696976),
    ],
    "green": [
        (0.0, 0.0, 0.0),
        (0.10000000000000001, 0.094117648899555206, 0.094117648899555206),
        (0.20000000000000001, 0.37647059559822083, 0.37647059559822083),
        (0.29999999999999999, 0.64705884456634521, 0.64705884456634521),
        (0.40000000000000002, 0.85882353782653809, 0.85882353782653809),
        (0.5, 1.0, 1.0),
        (0.59999999999999998, 0.87843137979507446, 0.87843137979507446),
        (0.69999999999999996, 0.729411780834198, 0.729411780834198),
        (0.80000000000000004, 0.52941179275512695, 0.52941179275512695),
        (0.90000000000000002, 0.30196079611778259, 0.30196079611778259),
        (1.0, 0.10196078568696976, 0.10196078568696976),
    ],
    "red": [
        (0.0, 0.40392157435417175, 0.40392157435417175),
        (0.10000000000000001, 0.69803923368453979, 0.69803923368453979),
        (0.20000000000000001, 0.83921569585800171, 0.83921569585800171),
        (0.29999999999999999, 0.95686274766921997, 0.95686274766921997),
        (0.40000000000000002, 0.99215686321258545, 0.99215686321258545),
        (0.5, 1.0, 1.0),
        (0.59999999999999998, 0.87843137979507446, 0.87843137979507446),
        (0.69999999999999996, 0.729411780834198, 0.729411780834198),
        (0.80000000000000004, 0.52941179275512695, 0.52941179275512695),
        (0.90000000000000002, 0.30196079611778259, 0.30196079611778259),
        (1.0, 0.10196078568696976, 0.10196078568696976),
    ],
}

_RdPu_data = {
    "blue": [
        (0.0, 0.9529411792755127, 0.9529411792755127),
        (0.125, 0.86666667461395264, 0.86666667461395264),
        (0.25, 0.75294119119644165, 0.75294119119644165),
        (0.375, 0.70980393886566162, 0.70980393886566162),
        (0.5, 0.63137257099151611, 0.63137257099151611),
        (0.625, 0.59215688705444336, 0.59215688705444336),
        (0.75, 0.49411764740943909, 0.49411764740943909),
        (0.875, 0.46666666865348816, 0.46666666865348816),
        (1.0, 0.41568627953529358, 0.41568627953529358),
    ],
    "green": [
        (0.0, 0.9686274528503418, 0.9686274528503418),
        (0.125, 0.87843137979507446, 0.87843137979507446),
        (0.25, 0.77254903316497803, 0.77254903316497803),
        (0.375, 0.62352943420410156, 0.62352943420410156),
        (0.5, 0.40784314274787903, 0.40784314274787903),
        (0.625, 0.20392157137393951, 0.20392157137393951),
        (0.75, 0.0039215688593685627, 0.0039215688593685627),
        (0.875, 0.0039215688593685627, 0.0039215688593685627),
        (1.0, 0.0, 0.0),
    ],
    "red": [
        (0.0, 1.0, 1.0),
        (0.125, 0.99215686321258545, 0.99215686321258545),
        (0.25, 0.98823529481887817, 0.98823529481887817),
        (0.375, 0.98039215803146362, 0.98039215803146362),
        (0.5, 0.9686274528503418, 0.9686274528503418),
        (0.625, 0.86666667461395264, 0.86666667461395264),
        (0.75, 0.68235296010971069, 0.68235296010971069),
        (0.875, 0.47843137383460999, 0.47843137383460999),
        (1.0, 0.28627452254295349, 0.28627452254295349),
    ],
}

_RdYlBu_data = {
    "blue": [
        (0.0, 0.14901961386203766, 0.14901961386203766),
        (0.10000000149011612, 0.15294118225574493, 0.15294118225574493),
        (0.20000000298023224, 0.26274511218070984, 0.26274511218070984),
        (0.30000001192092896, 0.3803921639919281, 0.3803921639919281),
        (0.40000000596046448, 0.56470590829849243, 0.56470590829849243),
        (0.5, 0.74901962280273438, 0.74901962280273438),
        (0.60000002384185791, 0.97254902124404907, 0.97254902124404907),
        (0.69999998807907104, 0.91372549533843994, 0.91372549533843994),
        (0.80000001192092896, 0.81960785388946533, 0.81960785388946533),
        (0.89999997615814209, 0.70588237047195435, 0.70588237047195435),
        (1.0, 0.58431375026702881, 0.58431375026702881),
    ],
    "green": [
        (0.0, 0.0, 0.0),
        (0.10000000149011612, 0.18823529779911041, 0.18823529779911041),
        (0.20000000298023224, 0.42745098471641541, 0.42745098471641541),
        (0.30000001192092896, 0.68235296010971069, 0.68235296010971069),
        (0.40000000596046448, 0.87843137979507446, 0.87843137979507446),
        (0.5, 1.0, 1.0),
        (0.60000002384185791, 0.9529411792755127, 0.9529411792755127),
        (0.69999998807907104, 0.85098040103912354, 0.85098040103912354),
        (0.80000001192092896, 0.67843139171600342, 0.67843139171600342),
        (0.89999997615814209, 0.45882353186607361, 0.45882353186607361),
        (1.0, 0.21176470816135406, 0.21176470816135406),
    ],
    "red": [
        (0.0, 0.64705884456634521, 0.64705884456634521),
        (0.10000000149011612, 0.84313726425170898, 0.84313726425170898),
        (0.20000000298023224, 0.95686274766921997, 0.95686274766921997),
        (0.30000001192092896, 0.99215686321258545, 0.99215686321258545),
        (0.40000000596046448, 0.99607843160629272, 0.99607843160629272),
        (0.5, 1.0, 1.0),
        (0.60000002384185791, 0.87843137979507446, 0.87843137979507446),
        (0.69999998807907104, 0.67058825492858887, 0.67058825492858887),
        (0.80000001192092896, 0.45490196347236633, 0.45490196347236633),
        (0.89999997615814209, 0.27058824896812439, 0.27058824896812439),
        (1.0, 0.19215686619281769, 0.19215686619281769),
    ],
}

_RdYlGn_data = {
    "blue": [
        (0.0, 0.14901961386203766, 0.14901961386203766),
        (0.10000000000000001, 0.15294118225574493, 0.15294118225574493),
        (0.20000000000000001, 0.26274511218070984, 0.26274511218070984),
        (0.29999999999999999, 0.3803921639919281, 0.3803921639919281),
        (0.40000000000000002, 0.54509806632995605, 0.54509806632995605),
        (0.5, 0.74901962280273438, 0.74901962280273438),
        (0.59999999999999998, 0.54509806632995605, 0.54509806632995605),
        (0.69999999999999996, 0.41568627953529358, 0.41568627953529358),
        (0.80000000000000004, 0.38823530077934265, 0.38823530077934265),
        (0.90000000000000002, 0.31372550129890442, 0.31372550129890442),
        (1.0, 0.21568627655506134, 0.21568627655506134),
    ],
    "green": [
        (0.0, 0.0, 0.0),
        (0.10000000000000001, 0.18823529779911041, 0.18823529779911041),
        (0.20000000000000001, 0.42745098471641541, 0.42745098471641541),
        (0.29999999999999999, 0.68235296010971069, 0.68235296010971069),
        (0.40000000000000002, 0.87843137979507446, 0.87843137979507446),
        (0.5, 1.0, 1.0),
        (0.59999999999999998, 0.93725490570068359, 0.93725490570068359),
        (0.69999999999999996, 0.85098040103912354, 0.85098040103912354),
        (0.80000000000000004, 0.74117648601531982, 0.74117648601531982),
        (0.90000000000000002, 0.59607845544815063, 0.59607845544815063),
        (1.0, 0.40784314274787903, 0.40784314274787903),
    ],
    "red": [
        (0.0, 0.64705884456634521, 0.64705884456634521),
        (0.10000000000000001, 0.84313726425170898, 0.84313726425170898),
        (0.20000000000000001, 0.95686274766921997, 0.95686274766921997),
        (0.29999999999999999, 0.99215686321258545, 0.99215686321258545),
        (0.40000000000000002, 0.99607843160629272, 0.99607843160629272),
        (0.5, 1.0, 1.0),
        (0.59999999999999998, 0.85098040103912354, 0.85098040103912354),
        (0.69999999999999996, 0.65098041296005249, 0.65098041296005249),
        (0.80000000000000004, 0.40000000596046448, 0.40000000596046448),
        (0.90000000000000002, 0.10196078568696976, 0.10196078568696976),
        (1.0, 0.0, 0.0),
    ],
}

_Reds_data = {
    "blue": [
        (0.0, 0.94117647409439087, 0.94117647409439087),
        (0.125, 0.82352942228317261, 0.82352942228317261),
        (0.25, 0.63137257099151611, 0.63137257099151611),
        (0.375, 0.44705882668495178, 0.44705882668495178),
        (0.5, 0.29019609093666077, 0.29019609093666077),
        (0.625, 0.17254902422428131, 0.17254902422428131),
        (0.75, 0.11372549086809158, 0.11372549086809158),
        (0.875, 0.08235294371843338, 0.08235294371843338),
        (1.0, 0.050980392843484879, 0.050980392843484879),
    ],
    "green": [
        (0.0, 0.96078431606292725, 0.96078431606292725),
        (0.125, 0.87843137979507446, 0.87843137979507446),
        (0.25, 0.73333334922790527, 0.73333334922790527),
        (0.375, 0.57254904508590698, 0.57254904508590698),
        (0.5, 0.41568627953529358, 0.41568627953529358),
        (0.625, 0.23137255012989044, 0.23137255012989044),
        (0.75, 0.094117648899555206, 0.094117648899555206),
        (0.875, 0.058823529630899429, 0.058823529630899429),
        (1.0, 0.0, 0.0),
    ],
    "red": [
        (0.0, 1.0, 1.0),
        (0.125, 0.99607843160629272, 0.99607843160629272),
        (0.25, 0.98823529481887817, 0.98823529481887817),
        (0.375, 0.98823529481887817, 0.98823529481887817),
        (0.5, 0.9843137264251709, 0.9843137264251709),
        (0.625, 0.93725490570068359, 0.93725490570068359),
        (0.75, 0.79607844352722168, 0.79607844352722168),
        (0.875, 0.64705884456634521, 0.64705884456634521),
        (1.0, 0.40392157435417175, 0.40392157435417175),
    ],
}

_Set1_data = {
    "blue": [
        (0.0, 0.10980392247438431, 0.10980392247438431),
        (0.125, 0.72156864404678345, 0.72156864404678345),
        (0.25, 0.29019609093666077, 0.29019609093666077),
        (0.375, 0.63921570777893066, 0.63921570777893066),
        (0.5, 0.0, 0.0),
        (0.625, 0.20000000298023224, 0.20000000298023224),
        (0.75, 0.15686275064945221, 0.15686275064945221),
        (0.875, 0.74901962280273438, 0.74901962280273438),
        (1.0, 0.60000002384185791, 0.60000002384185791),
    ],
    "green": [
        (0.0, 0.10196078568696976, 0.10196078568696976),
        (0.125, 0.49411764740943909, 0.49411764740943909),
        (0.25, 0.68627452850341797, 0.68627452850341797),
        (0.375, 0.30588236451148987, 0.30588236451148987),
        (0.5, 0.49803921580314636, 0.49803921580314636),
        (0.625, 1.0, 1.0),
        (0.75, 0.33725491166114807, 0.33725491166114807),
        (0.875, 0.5058823823928833, 0.5058823823928833),
        (1.0, 0.60000002384185791, 0.60000002384185791),
    ],
    "red": [
        (0.0, 0.89411765336990356, 0.89411765336990356),
        (0.125, 0.21568627655506134, 0.21568627655506134),
        (0.25, 0.30196079611778259, 0.30196079611778259),
        (0.375, 0.59607845544815063, 0.59607845544815063),
        (0.5, 1.0, 1.0),
        (0.625, 1.0, 1.0),
        (0.75, 0.65098041296005249, 0.65098041296005249),
        (0.875, 0.9686274528503418, 0.9686274528503418),
        (1.0, 0.60000002384185791, 0.60000002384185791),
    ],
}

_Set2_data = {
    "blue": [
        (0.0, 0.64705884456634521, 0.64705884456634521),
        (0.14285714285714285, 0.38431373238563538, 0.38431373238563538),
        (0.2857142857142857, 0.79607844352722168, 0.79607844352722168),
        (0.42857142857142855, 0.76470589637756348, 0.76470589637756348),
        (0.5714285714285714, 0.32941177487373352, 0.32941177487373352),
        (0.7142857142857143, 0.18431372940540314, 0.18431372940540314),
        (0.8571428571428571, 0.58039218187332153, 0.58039218187332153),
        (1.0, 0.70196080207824707, 0.70196080207824707),
    ],
    "green": [
        (0.0, 0.7607843279838562, 0.7607843279838562),
        (0.14285714285714285, 0.55294120311737061, 0.55294120311737061),
        (0.2857142857142857, 0.62745100259780884, 0.62745100259780884),
        (0.42857142857142855, 0.54117649793624878, 0.54117649793624878),
        (0.5714285714285714, 0.84705883264541626, 0.84705883264541626),
        (0.7142857142857143, 0.85098040103912354, 0.85098040103912354),
        (0.8571428571428571, 0.76862746477127075, 0.76862746477127075),
        (1.0, 0.70196080207824707, 0.70196080207824707),
    ],
    "red": [
        (0.0, 0.40000000596046448, 0.40000000596046448),
        (0.14285714285714285, 0.98823529481887817, 0.98823529481887817),
        (0.2857142857142857, 0.55294120311737061, 0.55294120311737061),
        (0.42857142857142855, 0.90588235855102539, 0.90588235855102539),
        (0.5714285714285714, 0.65098041296005249, 0.65098041296005249),
        (0.7142857142857143, 1.0, 1.0),
        (0.8571428571428571, 0.89803922176361084, 0.89803922176361084),
        (1.0, 0.70196080207824707, 0.70196080207824707),
    ],
}

_Set3_data = {
    "blue": [
        (0.0, 0.78039216995239258, 0.78039216995239258),
        (0.090909090909090912, 0.70196080207824707, 0.70196080207824707),
        (0.18181818181818182, 0.85490196943283081, 0.85490196943283081),
        (0.27272727272727271, 0.44705882668495178, 0.44705882668495178),
        (0.36363636363636365, 0.82745099067687988, 0.82745099067687988),
        (0.45454545454545453, 0.38431373238563538, 0.38431373238563538),
        (0.54545454545454541, 0.4117647111415863, 0.4117647111415863),
        (0.63636363636363635, 0.89803922176361084, 0.89803922176361084),
        (0.72727272727272729, 0.85098040103912354, 0.85098040103912354),
        (0.81818181818181823, 0.74117648601531982, 0.74117648601531982),
        (0.90909090909090906, 0.77254903316497803, 0.77254903316497803),
        (1.0, 0.43529412150382996, 0.43529412150382996),
    ],
    "green": [
        (0.0, 0.82745099067687988, 0.82745099067687988),
        (0.090909090909090912, 1.0, 1.0),
        (0.18181818181818182, 0.729411780834198, 0.729411780834198),
        (0.27272727272727271, 0.50196081399917603, 0.50196081399917603),
        (0.36363636363636365, 0.69411766529083252, 0.69411766529083252),
        (0.45454545454545453, 0.70588237047195435, 0.70588237047195435),
        (0.54545454545454541, 0.87058824300765991, 0.87058824300765991),
        (0.63636363636363635, 0.80392158031463623, 0.80392158031463623),
        (0.72727272727272729, 0.85098040103912354, 0.85098040103912354),
        (0.81818181818181823, 0.50196081399917603, 0.50196081399917603),
        (0.90909090909090906, 0.92156863212585449, 0.92156863212585449),
        (1.0, 0.92941176891326904, 0.92941176891326904),
    ],
    "red": [
        (0.0, 0.55294120311737061, 0.55294120311737061),
        (0.090909090909090912, 1.0, 1.0),
        (0.18181818181818182, 0.7450980544090271, 0.7450980544090271),
        (0.27272727272727271, 0.9843137264251709, 0.9843137264251709),
        (0.36363636363636365, 0.50196081399917603, 0.50196081399917603),
        (0.45454545454545453, 0.99215686321258545, 0.99215686321258545),
        (0.54545454545454541, 0.70196080207824707, 0.70196080207824707),
        (0.63636363636363635, 0.98823529481887817, 0.98823529481887817),
        (0.72727272727272729, 0.85098040103912354, 0.85098040103912354),
        (0.81818181818181823, 0.73725491762161255, 0.73725491762161255),
        (0.90909090909090906, 0.80000001192092896, 0.80000001192092896),
        (1.0, 1.0, 1.0),
    ],
}

_Spectral_data = {
    "blue": [
        (0.0, 0.25882354378700256, 0.25882354378700256),
        (0.10000000000000001, 0.30980393290519714, 0.30980393290519714),
        (0.20000000000000001, 0.26274511218070984, 0.26274511218070984),
        (0.29999999999999999, 0.3803921639919281, 0.3803921639919281),
        (0.40000000000000002, 0.54509806632995605, 0.54509806632995605),
        (0.5, 0.74901962280273438, 0.74901962280273438),
        (0.59999999999999998, 0.59607845544815063, 0.59607845544815063),
        (0.69999999999999996, 0.64313727617263794, 0.64313727617263794),
        (0.80000000000000004, 0.64705884456634521, 0.64705884456634521),
        (0.90000000000000002, 0.74117648601531982, 0.74117648601531982),
        (1.0, 0.63529413938522339, 0.63529413938522339),
    ],
    "green": [
        (0.0, 0.0039215688593685627, 0.0039215688593685627),
        (0.10000000000000001, 0.24313725531101227, 0.24313725531101227),
        (0.20000000000000001, 0.42745098471641541, 0.42745098471641541),
        (0.29999999999999999, 0.68235296010971069, 0.68235296010971069),
        (0.40000000000000002, 0.87843137979507446, 0.87843137979507446),
        (0.5, 1.0, 1.0),
        (0.59999999999999998, 0.96078431606292725, 0.96078431606292725),
        (0.69999999999999996, 0.86666667461395264, 0.86666667461395264),
        (0.80000000000000004, 0.7607843279838562, 0.7607843279838562),
        (0.90000000000000002, 0.53333336114883423, 0.53333336114883423),
        (1.0, 0.30980393290519714, 0.30980393290519714),
    ],
    "red": [
        (0.0, 0.61960786581039429, 0.61960786581039429),
        (0.10000000000000001, 0.83529412746429443, 0.83529412746429443),
        (0.20000000000000001, 0.95686274766921997, 0.95686274766921997),
        (0.29999999999999999, 0.99215686321258545, 0.99215686321258545),
        (0.40000000000000002, 0.99607843160629272, 0.99607843160629272),
        (0.5, 1.0, 1.0),
        (0.59999999999999998, 0.90196079015731812, 0.90196079015731812),
        (0.69999999999999996, 0.67058825492858887, 0.67058825492858887),
        (0.80000000000000004, 0.40000000596046448, 0.40000000596046448),
        (0.90000000000000002, 0.19607843458652496, 0.19607843458652496),
        (1.0, 0.36862745881080627, 0.36862745881080627),
    ],
}

_YlGn_data = {
    "blue": [
        (0.0, 0.89803922176361084, 0.89803922176361084),
        (0.125, 0.72549021244049072, 0.72549021244049072),
        (0.25, 0.63921570777893066, 0.63921570777893066),
        (0.375, 0.55686277151107788, 0.55686277151107788),
        (0.5, 0.47450980544090271, 0.47450980544090271),
        (0.625, 0.364705890417099, 0.364705890417099),
        (0.75, 0.26274511218070984, 0.26274511218070984),
        (0.875, 0.21568627655506134, 0.21568627655506134),
        (1.0, 0.16078431904315948, 0.16078431904315948),
    ],
    "green": [
        (0.0, 1.0, 1.0),
        (0.125, 0.98823529481887817, 0.98823529481887817),
        (0.25, 0.94117647409439087, 0.94117647409439087),
        (0.375, 0.86666667461395264, 0.86666667461395264),
        (0.5, 0.7764706015586853, 0.7764706015586853),
        (0.625, 0.67058825492858887, 0.67058825492858887),
        (0.75, 0.51764708757400513, 0.51764708757400513),
        (0.875, 0.40784314274787903, 0.40784314274787903),
        (1.0, 0.27058824896812439, 0.27058824896812439),
    ],
    "red": [
        (0.0, 1.0, 1.0),
        (0.125, 0.9686274528503418, 0.9686274528503418),
        (0.25, 0.85098040103912354, 0.85098040103912354),
        (0.375, 0.67843139171600342, 0.67843139171600342),
        (0.5, 0.47058823704719543, 0.47058823704719543),
        (0.625, 0.25490197539329529, 0.25490197539329529),
        (0.75, 0.13725490868091583, 0.13725490868091583),
        (0.875, 0.0, 0.0),
        (1.0, 0.0, 0.0),
    ],
}

_YlGnBu_data = {
    "blue": [
        (0.0, 0.85098040103912354, 0.85098040103912354),
        (0.125, 0.69411766529083252, 0.69411766529083252),
        (0.25, 0.70588237047195435, 0.70588237047195435),
        (0.375, 0.73333334922790527, 0.73333334922790527),
        (0.5, 0.76862746477127075, 0.76862746477127075),
        (0.625, 0.75294119119644165, 0.75294119119644165),
        (0.75, 0.65882354974746704, 0.65882354974746704),
        (0.875, 0.58039218187332153, 0.58039218187332153),
        (1.0, 0.34509804844856262, 0.34509804844856262),
    ],
    "green": [
        (0.0, 1.0, 1.0),
        (0.125, 0.97254902124404907, 0.97254902124404907),
        (0.25, 0.91372549533843994, 0.91372549533843994),
        (0.375, 0.80392158031463623, 0.80392158031463623),
        (0.5, 0.7137255072593689, 0.7137255072593689),
        (0.625, 0.56862747669219971, 0.56862747669219971),
        (0.75, 0.36862745881080627, 0.36862745881080627),
        (0.875, 0.20392157137393951, 0.20392157137393951),
        (1.0, 0.11372549086809158, 0.11372549086809158),
    ],
    "red": [
        (0.0, 1.0, 1.0),
        (0.125, 0.92941176891326904, 0.92941176891326904),
        (0.25, 0.78039216995239258, 0.78039216995239258),
        (0.375, 0.49803921580314636, 0.49803921580314636),
        (0.5, 0.25490197539329529, 0.25490197539329529),
        (0.625, 0.11372549086809158, 0.11372549086809158),
        (0.75, 0.13333334028720856, 0.13333334028720856),
        (0.875, 0.14509804546833038, 0.14509804546833038),
        (1.0, 0.031372550874948502, 0.031372550874948502),
    ],
}

_YlOrBr_data = {
    "blue": [
        (0.0, 0.89803922176361084, 0.89803922176361084),
        (0.125, 0.73725491762161255, 0.73725491762161255),
        (0.25, 0.56862747669219971, 0.56862747669219971),
        (0.375, 0.30980393290519714, 0.30980393290519714),
        (0.5, 0.16078431904315948, 0.16078431904315948),
        (0.625, 0.078431375324726105, 0.078431375324726105),
        (0.75, 0.0078431377187371254, 0.0078431377187371254),
        (0.875, 0.015686275437474251, 0.015686275437474251),
        (1.0, 0.023529412224888802, 0.023529412224888802),
    ],
    "green": [
        (0.0, 1.0, 1.0),
        (0.125, 0.9686274528503418, 0.9686274528503418),
        (0.25, 0.89019608497619629, 0.89019608497619629),
        (0.375, 0.76862746477127075, 0.76862746477127075),
        (0.5, 0.60000002384185791, 0.60000002384185791),
        (0.625, 0.43921568989753723, 0.43921568989753723),
        (0.75, 0.29803922772407532, 0.29803922772407532),
        (0.875, 0.20392157137393951, 0.20392157137393951),
        (1.0, 0.14509804546833038, 0.14509804546833038),
    ],
    "red": [
        (0.0, 1.0, 1.0),
        (0.125, 1.0, 1.0),
        (0.25, 0.99607843160629272, 0.99607843160629272),
        (0.375, 0.99607843160629272, 0.99607843160629272),
        (0.5, 0.99607843160629272, 0.99607843160629272),
        (0.625, 0.92549020051956177, 0.92549020051956177),
        (0.75, 0.80000001192092896, 0.80000001192092896),
        (0.875, 0.60000002384185791, 0.60000002384185791),
        (1.0, 0.40000000596046448, 0.40000000596046448),
    ],
}

_YlOrRd_data = {
    "blue": [
        (0.0, 0.80000001192092896, 0.80000001192092896),
        (0.125, 0.62745100259780884, 0.62745100259780884),
        (0.25, 0.46274510025978088, 0.46274510025978088),
        (0.375, 0.29803922772407532, 0.29803922772407532),
        (0.5, 0.23529411852359772, 0.23529411852359772),
        (0.625, 0.16470588743686676, 0.16470588743686676),
        (0.75, 0.10980392247438431, 0.10980392247438431),
        (0.875, 0.14901961386203766, 0.14901961386203766),
        (1.0, 0.14901961386203766, 0.14901961386203766),
    ],
    "green": [
        (0.0, 1.0, 1.0),
        (0.125, 0.92941176891326904, 0.92941176891326904),
        (0.25, 0.85098040103912354, 0.85098040103912354),
        (0.375, 0.69803923368453979, 0.69803923368453979),
        (0.5, 0.55294120311737061, 0.55294120311737061),
        (0.625, 0.30588236451148987, 0.30588236451148987),
        (0.75, 0.10196078568696976, 0.10196078568696976),
        (0.875, 0.0, 0.0),
        (1.0, 0.0, 0.0),
    ],
    "red": [
        (0.0, 1.0, 1.0),
        (0.125, 1.0, 1.0),
        (0.25, 0.99607843160629272, 0.99607843160629272),
        (0.375, 0.99607843160629272, 0.99607843160629272),
        (0.5, 0.99215686321258545, 0.99215686321258545),
        (0.625, 0.98823529481887817, 0.98823529481887817),
        (0.75, 0.89019608497619629, 0.89019608497619629),
        (0.875, 0.74117648601531982, 0.74117648601531982),
        (1.0, 0.50196081399917603, 0.50196081399917603),
    ],
}

# The next 7 palettes are from the Yorick scientific visalisation package,
# an evolution of the GIST package, both by David H. Munro.
# They are released under a BSD-like license (see LICENSE_YORICK in
# the license directory of the matplotlib source distribution).
_gist_earth_data = {
    "blue": [
        (0.0, 0.0, 0.0),
        (0.0042016808874905109, 0.18039216101169586, 0.18039216101169586),
        (0.0084033617749810219, 0.22745098173618317, 0.22745098173618317),
        (0.012605042196810246, 0.27058824896812439, 0.27058824896812439),
        (0.016806723549962044, 0.31764706969261169, 0.31764706969261169),
        (0.021008403971791267, 0.36078432202339172, 0.36078432202339172),
        (0.025210084393620491, 0.40784314274787903, 0.40784314274787903),
        (0.029411764815449715, 0.45490196347236633, 0.45490196347236633),
        (0.033613447099924088, 0.45490196347236633, 0.45490196347236633),
        (0.037815127521753311, 0.45490196347236633, 0.45490196347236633),
        (0.042016807943582535, 0.45490196347236633, 0.45490196347236633),
        (0.046218488365411758, 0.45490196347236633, 0.45490196347236633),
        (0.050420168787240982, 0.45882353186607361, 0.45882353186607361),
        (0.054621849209070206, 0.45882353186607361, 0.45882353186607361),
        (0.058823529630899429, 0.45882353186607361, 0.45882353186607361),
        (0.063025213778018951, 0.45882353186607361, 0.45882353186607361),
        (0.067226894199848175, 0.45882353186607361, 0.45882353186607361),
        (0.071428574621677399, 0.46274510025978088, 0.46274510025978088),
        (0.075630255043506622, 0.46274510025978088, 0.46274510025978088),
        (0.079831935465335846, 0.46274510025978088, 0.46274510025978088),
        (0.08403361588716507, 0.46274510025978088, 0.46274510025978088),
        (0.088235296308994293, 0.46274510025978088, 0.46274510025978088),
        (0.092436976730823517, 0.46666666865348816, 0.46666666865348816),
        (0.09663865715265274, 0.46666666865348816, 0.46666666865348816),
        (0.10084033757448196, 0.46666666865348816, 0.46666666865348816),
        (0.10504201799631119, 0.46666666865348816, 0.46666666865348816),
        (0.10924369841814041, 0.46666666865348816, 0.46666666865348816),
        (0.11344537883996964, 0.47058823704719543, 0.47058823704719543),
        (0.11764705926179886, 0.47058823704719543, 0.47058823704719543),
        (0.12184873968362808, 0.47058823704719543, 0.47058823704719543),
        (0.1260504275560379, 0.47058823704719543, 0.47058823704719543),
        (0.13025210797786713, 0.47058823704719543, 0.47058823704719543),
        (0.13445378839969635, 0.47450980544090271, 0.47450980544090271),
        (0.13865546882152557, 0.47450980544090271, 0.47450980544090271),
        (0.1428571492433548, 0.47450980544090271, 0.47450980544090271),
        (0.14705882966518402, 0.47450980544090271, 0.47450980544090271),
        (0.15126051008701324, 0.47450980544090271, 0.47450980544090271),
        (0.15546219050884247, 0.47843137383460999, 0.47843137383460999),
        (0.15966387093067169, 0.47843137383460999, 0.47843137383460999),
        (0.16386555135250092, 0.47843137383460999, 0.47843137383460999),
        (0.16806723177433014, 0.47843137383460999, 0.47843137383460999),
        (0.17226891219615936, 0.47843137383460999, 0.47843137383460999),
        (0.17647059261798859, 0.48235294222831726, 0.48235294222831726),
        (0.18067227303981781, 0.48235294222831726, 0.48235294222831726),
        (0.18487395346164703, 0.48235294222831726, 0.48235294222831726),
        (0.18907563388347626, 0.48235294222831726, 0.48235294222831726),
        (0.19327731430530548, 0.48235294222831726, 0.48235294222831726),
        (0.1974789947271347, 0.48627451062202454, 0.48627451062202454),
        (0.20168067514896393, 0.48627451062202454, 0.48627451062202454),
        (0.20588235557079315, 0.48627451062202454, 0.48627451062202454),
        (0.21008403599262238, 0.48627451062202454, 0.48627451062202454),
        (0.2142857164144516, 0.48627451062202454, 0.48627451062202454),
        (0.21848739683628082, 0.49019607901573181, 0.49019607901573181),
        (0.22268907725811005, 0.49019607901573181, 0.49019607901573181),
        (0.22689075767993927, 0.49019607901573181, 0.49019607901573181),
        (0.23109243810176849, 0.49019607901573181, 0.49019607901573181),
        (0.23529411852359772, 0.49019607901573181, 0.49019607901573181),
        (0.23949579894542694, 0.49411764740943909, 0.49411764740943909),
        (0.24369747936725616, 0.49411764740943909, 0.49411764740943909),
        (0.24789915978908539, 0.49411764740943909, 0.49411764740943909),
        (0.25210085511207581, 0.49411764740943909, 0.49411764740943909),
        (0.25630253553390503, 0.49411764740943909, 0.49411764740943909),
        (0.26050421595573425, 0.49803921580314636, 0.49803921580314636),
        (0.26470589637756348, 0.49803921580314636, 0.49803921580314636),
        (0.2689075767993927, 0.49803921580314636, 0.49803921580314636),
        (0.27310925722122192, 0.49803921580314636, 0.49803921580314636),
        (0.27731093764305115, 0.49803921580314636, 0.49803921580314636),
        (0.28151261806488037, 0.50196081399917603, 0.50196081399917603),
        (0.28571429848670959, 0.49411764740943909, 0.49411764740943909),
        (0.28991597890853882, 0.49019607901573181, 0.49019607901573181),
        (0.29411765933036804, 0.48627451062202454, 0.48627451062202454),
        (0.29831933975219727, 0.48235294222831726, 0.48235294222831726),
        (0.30252102017402649, 0.47843137383460999, 0.47843137383460999),
        (0.30672270059585571, 0.47058823704719543, 0.47058823704719543),
        (0.31092438101768494, 0.46666666865348816, 0.46666666865348816),
        (0.31512606143951416, 0.46274510025978088, 0.46274510025978088),
        (0.31932774186134338, 0.45882353186607361, 0.45882353186607361),
        (0.32352942228317261, 0.45098039507865906, 0.45098039507865906),
        (0.32773110270500183, 0.44705882668495178, 0.44705882668495178),
        (0.33193278312683105, 0.44313725829124451, 0.44313725829124451),
        (0.33613446354866028, 0.43529412150382996, 0.43529412150382996),
        (0.3403361439704895, 0.43137255311012268, 0.43137255311012268),
        (0.34453782439231873, 0.42745098471641541, 0.42745098471641541),
        (0.34873950481414795, 0.42352941632270813, 0.42352941632270813),
        (0.35294118523597717, 0.41568627953529358, 0.41568627953529358),
        (0.3571428656578064, 0.4117647111415863, 0.4117647111415863),
        (0.36134454607963562, 0.40784314274787903, 0.40784314274787903),
        (0.36554622650146484, 0.40000000596046448, 0.40000000596046448),
        (0.36974790692329407, 0.3960784375667572, 0.3960784375667572),
        (0.37394958734512329, 0.39215686917304993, 0.39215686917304993),
        (0.37815126776695251, 0.38431373238563538, 0.38431373238563538),
        (0.38235294818878174, 0.3803921639919281, 0.3803921639919281),
        (0.38655462861061096, 0.37647059559822083, 0.37647059559822083),
        (0.39075630903244019, 0.36862745881080627, 0.36862745881080627),
        (0.39495798945426941, 0.364705890417099, 0.364705890417099),
        (0.39915966987609863, 0.36078432202339172, 0.36078432202339172),
        (0.40336135029792786, 0.35294118523597717, 0.35294118523597717),
        (0.40756303071975708, 0.3490196168422699, 0.3490196168422699),
        (0.4117647111415863, 0.34509804844856262, 0.34509804844856262),
        (0.41596639156341553, 0.33725491166114807, 0.33725491166114807),
        (0.42016807198524475, 0.3333333432674408, 0.3333333432674408),
        (0.42436975240707397, 0.32941177487373352, 0.32941177487373352),
        (0.4285714328289032, 0.32156863808631897, 0.32156863808631897),
        (0.43277311325073242, 0.31764706969261169, 0.31764706969261169),
        (0.43697479367256165, 0.31372550129890442, 0.31372550129890442),
        (0.44117647409439087, 0.30588236451148987, 0.30588236451148987),
        (0.44537815451622009, 0.30196079611778259, 0.30196079611778259),
        (0.44957983493804932, 0.29803922772407532, 0.29803922772407532),
        (0.45378151535987854, 0.29019609093666077, 0.29019609093666077),
        (0.45798319578170776, 0.28627452254295349, 0.28627452254295349),
        (0.46218487620353699, 0.27843138575553894, 0.27843138575553894),
        (0.46638655662536621, 0.27450981736183167, 0.27450981736183167),
        (0.47058823704719543, 0.27843138575553894, 0.27843138575553894),
        (0.47478991746902466, 0.28235295414924622, 0.28235295414924622),
        (0.47899159789085388, 0.28235295414924622, 0.28235295414924622),
        (0.48319327831268311, 0.28627452254295349, 0.28627452254295349),
        (0.48739495873451233, 0.28627452254295349, 0.28627452254295349),
        (0.49159663915634155, 0.29019609093666077, 0.29019609093666077),
        (0.49579831957817078, 0.29411765933036804, 0.29411765933036804),
        (0.5, 0.29411765933036804, 0.29411765933036804),
        (0.50420171022415161, 0.29803922772407532, 0.29803922772407532),
        (0.50840336084365845, 0.29803922772407532, 0.29803922772407532),
        (0.51260507106781006, 0.30196079611778259, 0.30196079611778259),
        (0.51680672168731689, 0.30196079611778259, 0.30196079611778259),
        (0.52100843191146851, 0.30588236451148987, 0.30588236451148987),
        (0.52521008253097534, 0.30980393290519714, 0.30980393290519714),
        (0.52941179275512695, 0.30980393290519714, 0.30980393290519714),
        (0.53361344337463379, 0.31372550129890442, 0.31372550129890442),
        (0.5378151535987854, 0.31372550129890442, 0.31372550129890442),
        (0.54201680421829224, 0.31764706969261169, 0.31764706969261169),
        (0.54621851444244385, 0.32156863808631897, 0.32156863808631897),
        (0.55042016506195068, 0.32156863808631897, 0.32156863808631897),
        (0.55462187528610229, 0.32156863808631897, 0.32156863808631897),
        (0.55882352590560913, 0.32549020648002625, 0.32549020648002625),
        (0.56302523612976074, 0.32549020648002625, 0.32549020648002625),
        (0.56722688674926758, 0.32549020648002625, 0.32549020648002625),
        (0.57142859697341919, 0.32941177487373352, 0.32941177487373352),
        (0.57563024759292603, 0.32941177487373352, 0.32941177487373352),
        (0.57983195781707764, 0.32941177487373352, 0.32941177487373352),
        (0.58403360843658447, 0.3333333432674408, 0.3333333432674408),
        (0.58823531866073608, 0.3333333432674408, 0.3333333432674408),
        (0.59243696928024292, 0.3333333432674408, 0.3333333432674408),
        (0.59663867950439453, 0.33725491166114807, 0.33725491166114807),
        (0.60084033012390137, 0.33725491166114807, 0.33725491166114807),
        (0.60504204034805298, 0.33725491166114807, 0.33725491166114807),
        (0.60924369096755981, 0.34117648005485535, 0.34117648005485535),
        (0.61344540119171143, 0.34117648005485535, 0.34117648005485535),
        (0.61764705181121826, 0.34117648005485535, 0.34117648005485535),
        (0.62184876203536987, 0.34509804844856262, 0.34509804844856262),
        (0.62605041265487671, 0.34509804844856262, 0.34509804844856262),
        (0.63025212287902832, 0.34509804844856262, 0.34509804844856262),
        (0.63445377349853516, 0.3490196168422699, 0.3490196168422699),
        (0.63865548372268677, 0.3490196168422699, 0.3490196168422699),
        (0.6428571343421936, 0.3490196168422699, 0.3490196168422699),
        (0.64705884456634521, 0.35294118523597717, 0.35294118523597717),
        (0.65126049518585205, 0.35294118523597717, 0.35294118523597717),
        (0.65546220541000366, 0.35294118523597717, 0.35294118523597717),
        (0.6596638560295105, 0.35686275362968445, 0.35686275362968445),
        (0.66386556625366211, 0.35686275362968445, 0.35686275362968445),
        (0.66806721687316895, 0.35686275362968445, 0.35686275362968445),
        (0.67226892709732056, 0.36078432202339172, 0.36078432202339172),
        (0.67647057771682739, 0.36078432202339172, 0.36078432202339172),
        (0.680672287940979, 0.36078432202339172, 0.36078432202339172),
        (0.68487393856048584, 0.364705890417099, 0.364705890417099),
        (0.68907564878463745, 0.364705890417099, 0.364705890417099),
        (0.69327729940414429, 0.364705890417099, 0.364705890417099),
        (0.6974790096282959, 0.36862745881080627, 0.36862745881080627),
        (0.70168066024780273, 0.36862745881080627, 0.36862745881080627),
        (0.70588237047195435, 0.36862745881080627, 0.36862745881080627),
        (0.71008402109146118, 0.37254902720451355, 0.37254902720451355),
        (0.71428573131561279, 0.37254902720451355, 0.37254902720451355),
        (0.71848738193511963, 0.37254902720451355, 0.37254902720451355),
        (0.72268909215927124, 0.37647059559822083, 0.37647059559822083),
        (0.72689074277877808, 0.37647059559822083, 0.37647059559822083),
        (0.73109245300292969, 0.3803921639919281, 0.3803921639919281),
        (0.73529410362243652, 0.3803921639919281, 0.3803921639919281),
        (0.73949581384658813, 0.3803921639919281, 0.3803921639919281),
        (0.74369746446609497, 0.38431373238563538, 0.38431373238563538),
        (0.74789917469024658, 0.38431373238563538, 0.38431373238563538),
        (0.75210082530975342, 0.38431373238563538, 0.38431373238563538),
        (0.75630253553390503, 0.38823530077934265, 0.38823530077934265),
        (0.76050418615341187, 0.38823530077934265, 0.38823530077934265),
        (0.76470589637756348, 0.38823530077934265, 0.38823530077934265),
        (0.76890754699707031, 0.39215686917304993, 0.39215686917304993),
        (0.77310925722122192, 0.39215686917304993, 0.39215686917304993),
        (0.77731090784072876, 0.39215686917304993, 0.39215686917304993),
        (0.78151261806488037, 0.3960784375667572, 0.3960784375667572),
        (0.78571426868438721, 0.3960784375667572, 0.3960784375667572),
        (0.78991597890853882, 0.40784314274787903, 0.40784314274787903),
        (0.79411762952804565, 0.41568627953529358, 0.41568627953529358),
        (0.79831933975219727, 0.42352941632270813, 0.42352941632270813),
        (0.8025209903717041, 0.43529412150382996, 0.43529412150382996),
        (0.80672270059585571, 0.44313725829124451, 0.44313725829124451),
        (0.81092435121536255, 0.45490196347236633, 0.45490196347236633),
        (0.81512606143951416, 0.46274510025978088, 0.46274510025978088),
        (0.819327712059021, 0.47450980544090271, 0.47450980544090271),
        (0.82352942228317261, 0.48235294222831726, 0.48235294222831726),
        (0.82773107290267944, 0.49411764740943909, 0.49411764740943909),
        (0.83193278312683105, 0.5058823823928833, 0.5058823823928833),
        (0.83613443374633789, 0.51372551918029785, 0.51372551918029785),
        (0.8403361439704895, 0.52549022436141968, 0.52549022436141968),
        (0.84453779458999634, 0.5372549295425415, 0.5372549295425415),
        (0.84873950481414795, 0.54509806632995605, 0.54509806632995605),
        (0.85294115543365479, 0.55686277151107788, 0.55686277151107788),
        (0.8571428656578064, 0.56862747669219971, 0.56862747669219971),
        (0.86134451627731323, 0.58039218187332153, 0.58039218187332153),
        (0.86554622650146484, 0.58823531866073608, 0.58823531866073608),
        (0.86974787712097168, 0.60000002384185791, 0.60000002384185791),
        (0.87394958734512329, 0.61176472902297974, 0.61176472902297974),
        (0.87815123796463013, 0.62352943420410156, 0.62352943420410156),
        (0.88235294818878174, 0.63529413938522339, 0.63529413938522339),
        (0.88655459880828857, 0.64705884456634521, 0.64705884456634521),
        (0.89075630903244019, 0.65882354974746704, 0.65882354974746704),
        (0.89495795965194702, 0.66666668653488159, 0.66666668653488159),
        (0.89915966987609863, 0.67843139171600342, 0.67843139171600342),
        (0.90336132049560547, 0.69019609689712524, 0.69019609689712524),
        (0.90756303071975708, 0.70196080207824707, 0.70196080207824707),
        (0.91176468133926392, 0.7137255072593689, 0.7137255072593689),
        (0.91596639156341553, 0.72549021244049072, 0.72549021244049072),
        (0.92016804218292236, 0.74117648601531982, 0.74117648601531982),
        (0.92436975240707397, 0.75294119119644165, 0.75294119119644165),
        (0.92857140302658081, 0.76470589637756348, 0.76470589637756348),
        (0.93277311325073242, 0.7764706015586853, 0.7764706015586853),
        (0.93697476387023926, 0.78823530673980713, 0.78823530673980713),
        (0.94117647409439087, 0.80000001192092896, 0.80000001192092896),
        (0.94537812471389771, 0.81176471710205078, 0.81176471710205078),
        (0.94957983493804932, 0.82745099067687988, 0.82745099067687988),
        (0.95378148555755615, 0.83921569585800171, 0.83921569585800171),
        (0.95798319578170776, 0.85098040103912354, 0.85098040103912354),
        (0.9621848464012146, 0.86274510622024536, 0.86274510622024536),
        (0.96638655662536621, 0.87843137979507446, 0.87843137979507446),
        (0.97058820724487305, 0.89019608497619629, 0.89019608497619629),
        (0.97478991746902466, 0.90196079015731812, 0.90196079015731812),
        (0.97899156808853149, 0.91764706373214722, 0.91764706373214722),
        (0.98319327831268311, 0.92941176891326904, 0.92941176891326904),
        (0.98739492893218994, 0.94509804248809814, 0.94509804248809814),
        (0.99159663915634155, 0.95686274766921997, 0.95686274766921997),
        (0.99579828977584839, 0.97254902124404907, 0.97254902124404907),
        (1.0, 0.9843137264251709, 0.9843137264251709),
    ],
    "green": [
        (0.0, 0.0, 0.0),
        (0.0042016808874905109, 0.0, 0.0),
        (0.0084033617749810219, 0.0, 0.0),
        (0.012605042196810246, 0.0, 0.0),
        (0.016806723549962044, 0.0, 0.0),
        (0.021008403971791267, 0.0, 0.0),
        (0.025210084393620491, 0.0, 0.0),
        (0.029411764815449715, 0.0, 0.0),
        (0.033613447099924088, 0.011764706112444401, 0.011764706112444401),
        (0.037815127521753311, 0.023529412224888802, 0.023529412224888802),
        (0.042016807943582535, 0.031372550874948502, 0.031372550874948502),
        (0.046218488365411758, 0.043137256056070328, 0.043137256056070328),
        (0.050420168787240982, 0.050980392843484879, 0.050980392843484879),
        (0.054621849209070206, 0.062745101749897003, 0.062745101749897003),
        (0.058823529630899429, 0.070588238537311554, 0.070588238537311554),
        (0.063025213778018951, 0.08235294371843338, 0.08235294371843338),
        (0.067226894199848175, 0.090196080505847931, 0.090196080505847931),
        (0.071428574621677399, 0.10196078568696976, 0.10196078568696976),
        (0.075630255043506622, 0.10980392247438431, 0.10980392247438431),
        (0.079831935465335846, 0.12156862765550613, 0.12156862765550613),
        (0.08403361588716507, 0.12941177189350128, 0.12941177189350128),
        (0.088235296308994293, 0.14117647707462311, 0.14117647707462311),
        (0.092436976730823517, 0.14901961386203766, 0.14901961386203766),
        (0.09663865715265274, 0.16078431904315948, 0.16078431904315948),
        (0.10084033757448196, 0.16862745583057404, 0.16862745583057404),
        (0.10504201799631119, 0.17647059261798859, 0.17647059261798859),
        (0.10924369841814041, 0.18823529779911041, 0.18823529779911041),
        (0.11344537883996964, 0.19607843458652496, 0.19607843458652496),
        (0.11764705926179886, 0.20392157137393951, 0.20392157137393951),
        (0.12184873968362808, 0.21568627655506134, 0.21568627655506134),
        (0.1260504275560379, 0.22352941334247589, 0.22352941334247589),
        (0.13025210797786713, 0.23137255012989044, 0.23137255012989044),
        (0.13445378839969635, 0.23921568691730499, 0.23921568691730499),
        (0.13865546882152557, 0.25098040699958801, 0.25098040699958801),
        (0.1428571492433548, 0.25882354378700256, 0.25882354378700256),
        (0.14705882966518402, 0.26666668057441711, 0.26666668057441711),
        (0.15126051008701324, 0.27450981736183167, 0.27450981736183167),
        (0.15546219050884247, 0.28235295414924622, 0.28235295414924622),
        (0.15966387093067169, 0.29019609093666077, 0.29019609093666077),
        (0.16386555135250092, 0.30196079611778259, 0.30196079611778259),
        (0.16806723177433014, 0.30980393290519714, 0.30980393290519714),
        (0.17226891219615936, 0.31764706969261169, 0.31764706969261169),
        (0.17647059261798859, 0.32549020648002625, 0.32549020648002625),
        (0.18067227303981781, 0.3333333432674408, 0.3333333432674408),
        (0.18487395346164703, 0.34117648005485535, 0.34117648005485535),
        (0.18907563388347626, 0.3490196168422699, 0.3490196168422699),
        (0.19327731430530548, 0.35686275362968445, 0.35686275362968445),
        (0.1974789947271347, 0.364705890417099, 0.364705890417099),
        (0.20168067514896393, 0.37254902720451355, 0.37254902720451355),
        (0.20588235557079315, 0.3803921639919281, 0.3803921639919281),
        (0.21008403599262238, 0.38823530077934265, 0.38823530077934265),
        (0.2142857164144516, 0.39215686917304993, 0.39215686917304993),
        (0.21848739683628082, 0.40000000596046448, 0.40000000596046448),
        (0.22268907725811005, 0.40784314274787903, 0.40784314274787903),
        (0.22689075767993927, 0.41568627953529358, 0.41568627953529358),
        (0.23109243810176849, 0.42352941632270813, 0.42352941632270813),
        (0.23529411852359772, 0.42745098471641541, 0.42745098471641541),
        (0.23949579894542694, 0.43529412150382996, 0.43529412150382996),
        (0.24369747936725616, 0.44313725829124451, 0.44313725829124451),
        (0.24789915978908539, 0.45098039507865906, 0.45098039507865906),
        (0.25210085511207581, 0.45490196347236633, 0.45490196347236633),
        (0.25630253553390503, 0.46274510025978088, 0.46274510025978088),
        (0.26050421595573425, 0.47058823704719543, 0.47058823704719543),
        (0.26470589637756348, 0.47450980544090271, 0.47450980544090271),
        (0.2689075767993927, 0.48235294222831726, 0.48235294222831726),
        (0.27310925722122192, 0.49019607901573181, 0.49019607901573181),
        (0.27731093764305115, 0.49411764740943909, 0.49411764740943909),
        (0.28151261806488037, 0.50196081399917603, 0.50196081399917603),
        (0.28571429848670959, 0.50196081399917603, 0.50196081399917603),
        (0.28991597890853882, 0.5058823823928833, 0.5058823823928833),
        (0.29411765933036804, 0.5058823823928833, 0.5058823823928833),
        (0.29831933975219727, 0.50980395078659058, 0.50980395078659058),
        (0.30252102017402649, 0.51372551918029785, 0.51372551918029785),
        (0.30672270059585571, 0.51372551918029785, 0.51372551918029785),
        (0.31092438101768494, 0.51764708757400513, 0.51764708757400513),
        (0.31512606143951416, 0.5215686559677124, 0.5215686559677124),
        (0.31932774186134338, 0.5215686559677124, 0.5215686559677124),
        (0.32352942228317261, 0.52549022436141968, 0.52549022436141968),
        (0.32773110270500183, 0.52549022436141968, 0.52549022436141968),
        (0.33193278312683105, 0.52941179275512695, 0.52941179275512695),
        (0.33613446354866028, 0.53333336114883423, 0.53333336114883423),
        (0.3403361439704895, 0.53333336114883423, 0.53333336114883423),
        (0.34453782439231873, 0.5372549295425415, 0.5372549295425415),
        (0.34873950481414795, 0.54117649793624878, 0.54117649793624878),
        (0.35294118523597717, 0.54117649793624878, 0.54117649793624878),
        (0.3571428656578064, 0.54509806632995605, 0.54509806632995605),
        (0.36134454607963562, 0.54901963472366333, 0.54901963472366333),
        (0.36554622650146484, 0.54901963472366333, 0.54901963472366333),
        (0.36974790692329407, 0.55294120311737061, 0.55294120311737061),
        (0.37394958734512329, 0.55294120311737061, 0.55294120311737061),
        (0.37815126776695251, 0.55686277151107788, 0.55686277151107788),
        (0.38235294818878174, 0.56078433990478516, 0.56078433990478516),
        (0.38655462861061096, 0.56078433990478516, 0.56078433990478516),
        (0.39075630903244019, 0.56470590829849243, 0.56470590829849243),
        (0.39495798945426941, 0.56862747669219971, 0.56862747669219971),
        (0.39915966987609863, 0.56862747669219971, 0.56862747669219971),
        (0.40336135029792786, 0.57254904508590698, 0.57254904508590698),
        (0.40756303071975708, 0.57254904508590698, 0.57254904508590698),
        (0.4117647111415863, 0.57647061347961426, 0.57647061347961426),
        (0.41596639156341553, 0.58039218187332153, 0.58039218187332153),
        (0.42016807198524475, 0.58039218187332153, 0.58039218187332153),
        (0.42436975240707397, 0.58431375026702881, 0.58431375026702881),
        (0.4285714328289032, 0.58823531866073608, 0.58823531866073608),
        (0.43277311325073242, 0.58823531866073608, 0.58823531866073608),
        (0.43697479367256165, 0.59215688705444336, 0.59215688705444336),
        (0.44117647409439087, 0.59215688705444336, 0.59215688705444336),
        (0.44537815451622009, 0.59607845544815063, 0.59607845544815063),
        (0.44957983493804932, 0.60000002384185791, 0.60000002384185791),
        (0.45378151535987854, 0.60000002384185791, 0.60000002384185791),
        (0.45798319578170776, 0.60392159223556519, 0.60392159223556519),
        (0.46218487620353699, 0.60784316062927246, 0.60784316062927246),
        (0.46638655662536621, 0.60784316062927246, 0.60784316062927246),
        (0.47058823704719543, 0.61176472902297974, 0.61176472902297974),
        (0.47478991746902466, 0.61176472902297974, 0.61176472902297974),
        (0.47899159789085388, 0.61568629741668701, 0.61568629741668701),
        (0.48319327831268311, 0.61960786581039429, 0.61960786581039429),
        (0.48739495873451233, 0.61960786581039429, 0.61960786581039429),
        (0.49159663915634155, 0.62352943420410156, 0.62352943420410156),
        (0.49579831957817078, 0.62745100259780884, 0.62745100259780884),
        (0.5, 0.62745100259780884, 0.62745100259780884),
        (0.50420171022415161, 0.63137257099151611, 0.63137257099151611),
        (0.50840336084365845, 0.63137257099151611, 0.63137257099151611),
        (0.51260507106781006, 0.63529413938522339, 0.63529413938522339),
        (0.51680672168731689, 0.63921570777893066, 0.63921570777893066),
        (0.52100843191146851, 0.63921570777893066, 0.63921570777893066),
        (0.52521008253097534, 0.64313727617263794, 0.64313727617263794),
        (0.52941179275512695, 0.64705884456634521, 0.64705884456634521),
        (0.53361344337463379, 0.64705884456634521, 0.64705884456634521),
        (0.5378151535987854, 0.65098041296005249, 0.65098041296005249),
        (0.54201680421829224, 0.65098041296005249, 0.65098041296005249),
        (0.54621851444244385, 0.65490198135375977, 0.65490198135375977),
        (0.55042016506195068, 0.65882354974746704, 0.65882354974746704),
        (0.55462187528610229, 0.65882354974746704, 0.65882354974746704),
        (0.55882352590560913, 0.65882354974746704, 0.65882354974746704),
        (0.56302523612976074, 0.66274511814117432, 0.66274511814117432),
        (0.56722688674926758, 0.66274511814117432, 0.66274511814117432),
        (0.57142859697341919, 0.66666668653488159, 0.66666668653488159),
        (0.57563024759292603, 0.66666668653488159, 0.66666668653488159),
        (0.57983195781707764, 0.67058825492858887, 0.67058825492858887),
        (0.58403360843658447, 0.67058825492858887, 0.67058825492858887),
        (0.58823531866073608, 0.67450982332229614, 0.67450982332229614),
        (0.59243696928024292, 0.67450982332229614, 0.67450982332229614),
        (0.59663867950439453, 0.67450982332229614, 0.67450982332229614),
        (0.60084033012390137, 0.67843139171600342, 0.67843139171600342),
        (0.60504204034805298, 0.67843139171600342, 0.67843139171600342),
        (0.60924369096755981, 0.68235296010971069, 0.68235296010971069),
        (0.61344540119171143, 0.68235296010971069, 0.68235296010971069),
        (0.61764705181121826, 0.68627452850341797, 0.68627452850341797),
        (0.62184876203536987, 0.68627452850341797, 0.68627452850341797),
        (0.62605041265487671, 0.68627452850341797, 0.68627452850341797),
        (0.63025212287902832, 0.69019609689712524, 0.69019609689712524),
        (0.63445377349853516, 0.69019609689712524, 0.69019609689712524),
        (0.63865548372268677, 0.69411766529083252, 0.69411766529083252),
        (0.6428571343421936, 0.69411766529083252, 0.69411766529083252),
        (0.64705884456634521, 0.69803923368453979, 0.69803923368453979),
        (0.65126049518585205, 0.69803923368453979, 0.69803923368453979),
        (0.65546220541000366, 0.70196080207824707, 0.70196080207824707),
        (0.6596638560295105, 0.70196080207824707, 0.70196080207824707),
        (0.66386556625366211, 0.70196080207824707, 0.70196080207824707),
        (0.66806721687316895, 0.70588237047195435, 0.70588237047195435),
        (0.67226892709732056, 0.70588237047195435, 0.70588237047195435),
        (0.67647057771682739, 0.70980393886566162, 0.70980393886566162),
        (0.680672287940979, 0.70980393886566162, 0.70980393886566162),
        (0.68487393856048584, 0.7137255072593689, 0.7137255072593689),
        (0.68907564878463745, 0.7137255072593689, 0.7137255072593689),
        (0.69327729940414429, 0.71764707565307617, 0.71764707565307617),
        (0.6974790096282959, 0.71764707565307617, 0.71764707565307617),
        (0.70168066024780273, 0.7137255072593689, 0.7137255072593689),
        (0.70588237047195435, 0.70980393886566162, 0.70980393886566162),
        (0.71008402109146118, 0.70980393886566162, 0.70980393886566162),
        (0.71428573131561279, 0.70588237047195435, 0.70588237047195435),
        (0.71848738193511963, 0.70196080207824707, 0.70196080207824707),
        (0.72268909215927124, 0.69803923368453979, 0.69803923368453979),
        (0.72689074277877808, 0.69411766529083252, 0.69411766529083252),
        (0.73109245300292969, 0.69019609689712524, 0.69019609689712524),
        (0.73529410362243652, 0.68627452850341797, 0.68627452850341797),
        (0.73949581384658813, 0.68235296010971069, 0.68235296010971069),
        (0.74369746446609497, 0.67843139171600342, 0.67843139171600342),
        (0.74789917469024658, 0.67450982332229614, 0.67450982332229614),
        (0.75210082530975342, 0.67058825492858887, 0.67058825492858887),
        (0.75630253553390503, 0.66666668653488159, 0.66666668653488159),
        (0.76050418615341187, 0.66274511814117432, 0.66274511814117432),
        (0.76470589637756348, 0.65882354974746704, 0.65882354974746704),
        (0.76890754699707031, 0.65490198135375977, 0.65490198135375977),
        (0.77310925722122192, 0.65098041296005249, 0.65098041296005249),
        (0.77731090784072876, 0.64705884456634521, 0.64705884456634521),
        (0.78151261806488037, 0.64313727617263794, 0.64313727617263794),
        (0.78571426868438721, 0.63921570777893066, 0.63921570777893066),
        (0.78991597890853882, 0.63921570777893066, 0.63921570777893066),
        (0.79411762952804565, 0.64313727617263794, 0.64313727617263794),
        (0.79831933975219727, 0.64313727617263794, 0.64313727617263794),
        (0.8025209903717041, 0.64705884456634521, 0.64705884456634521),
        (0.80672270059585571, 0.64705884456634521, 0.64705884456634521),
        (0.81092435121536255, 0.65098041296005249, 0.65098041296005249),
        (0.81512606143951416, 0.65490198135375977, 0.65490198135375977),
        (0.819327712059021, 0.65490198135375977, 0.65490198135375977),
        (0.82352942228317261, 0.65882354974746704, 0.65882354974746704),
        (0.82773107290267944, 0.66274511814117432, 0.66274511814117432),
        (0.83193278312683105, 0.66666668653488159, 0.66666668653488159),
        (0.83613443374633789, 0.67058825492858887, 0.67058825492858887),
        (0.8403361439704895, 0.67450982332229614, 0.67450982332229614),
        (0.84453779458999634, 0.67843139171600342, 0.67843139171600342),
        (0.84873950481414795, 0.68235296010971069, 0.68235296010971069),
        (0.85294115543365479, 0.68627452850341797, 0.68627452850341797),
        (0.8571428656578064, 0.69019609689712524, 0.69019609689712524),
        (0.86134451627731323, 0.69411766529083252, 0.69411766529083252),
        (0.86554622650146484, 0.69803923368453979, 0.69803923368453979),
        (0.86974787712097168, 0.70196080207824707, 0.70196080207824707),
        (0.87394958734512329, 0.70980393886566162, 0.70980393886566162),
        (0.87815123796463013, 0.7137255072593689, 0.7137255072593689),
        (0.88235294818878174, 0.72156864404678345, 0.72156864404678345),
        (0.88655459880828857, 0.72549021244049072, 0.72549021244049072),
        (0.89075630903244019, 0.73333334922790527, 0.73333334922790527),
        (0.89495795965194702, 0.73725491762161255, 0.73725491762161255),
        (0.89915966987609863, 0.7450980544090271, 0.7450980544090271),
        (0.90336132049560547, 0.75294119119644165, 0.75294119119644165),
        (0.90756303071975708, 0.7607843279838562, 0.7607843279838562),
        (0.91176468133926392, 0.76862746477127075, 0.76862746477127075),
        (0.91596639156341553, 0.7764706015586853, 0.7764706015586853),
        (0.92016804218292236, 0.78431373834609985, 0.78431373834609985),
        (0.92436975240707397, 0.7921568751335144, 0.7921568751335144),
        (0.92857140302658081, 0.80000001192092896, 0.80000001192092896),
        (0.93277311325073242, 0.80784314870834351, 0.80784314870834351),
        (0.93697476387023926, 0.81568628549575806, 0.81568628549575806),
        (0.94117647409439087, 0.82745099067687988, 0.82745099067687988),
        (0.94537812471389771, 0.83529412746429443, 0.83529412746429443),
        (0.94957983493804932, 0.84313726425170898, 0.84313726425170898),
        (0.95378148555755615, 0.85490196943283081, 0.85490196943283081),
        (0.95798319578170776, 0.86666667461395264, 0.86666667461395264),
        (0.9621848464012146, 0.87450981140136719, 0.87450981140136719),
        (0.96638655662536621, 0.88627451658248901, 0.88627451658248901),
        (0.97058820724487305, 0.89803922176361084, 0.89803922176361084),
        (0.97478991746902466, 0.90980392694473267, 0.90980392694473267),
        (0.97899156808853149, 0.92156863212585449, 0.92156863212585449),
        (0.98319327831268311, 0.93333333730697632, 0.93333333730697632),
        (0.98739492893218994, 0.94509804248809814, 0.94509804248809814),
        (0.99159663915634155, 0.95686274766921997, 0.95686274766921997),
        (0.99579828977584839, 0.97254902124404907, 0.97254902124404907),
        (1.0, 0.9843137264251709, 0.9843137264251709),
    ],
    "red": [
        (0.0, 0.0, 0.0),
        (0.0042016808874905109, 0.0, 0.0),
        (0.0084033617749810219, 0.0, 0.0),
        (0.012605042196810246, 0.0, 0.0),
        (0.016806723549962044, 0.0, 0.0),
        (0.021008403971791267, 0.0, 0.0),
        (0.025210084393620491, 0.0, 0.0),
        (0.029411764815449715, 0.0, 0.0),
        (0.033613447099924088, 0.0, 0.0),
        (0.037815127521753311, 0.0039215688593685627, 0.0039215688593685627),
        (0.042016807943582535, 0.0078431377187371254, 0.0078431377187371254),
        (0.046218488365411758, 0.0078431377187371254, 0.0078431377187371254),
        (0.050420168787240982, 0.011764706112444401, 0.011764706112444401),
        (0.054621849209070206, 0.015686275437474251, 0.015686275437474251),
        (0.058823529630899429, 0.019607843831181526, 0.019607843831181526),
        (0.063025213778018951, 0.019607843831181526, 0.019607843831181526),
        (0.067226894199848175, 0.023529412224888802, 0.023529412224888802),
        (0.071428574621677399, 0.027450980618596077, 0.027450980618596077),
        (0.075630255043506622, 0.031372550874948502, 0.031372550874948502),
        (0.079831935465335846, 0.031372550874948502, 0.031372550874948502),
        (0.08403361588716507, 0.035294119268655777, 0.035294119268655777),
        (0.088235296308994293, 0.039215687662363052, 0.039215687662363052),
        (0.092436976730823517, 0.043137256056070328, 0.043137256056070328),
        (0.09663865715265274, 0.043137256056070328, 0.043137256056070328),
        (0.10084033757448196, 0.047058824449777603, 0.047058824449777603),
        (0.10504201799631119, 0.050980392843484879, 0.050980392843484879),
        (0.10924369841814041, 0.054901961237192154, 0.054901961237192154),
        (0.11344537883996964, 0.058823529630899429, 0.058823529630899429),
        (0.11764705926179886, 0.058823529630899429, 0.058823529630899429),
        (0.12184873968362808, 0.062745101749897003, 0.062745101749897003),
        (0.1260504275560379, 0.066666670143604279, 0.066666670143604279),
        (0.13025210797786713, 0.070588238537311554, 0.070588238537311554),
        (0.13445378839969635, 0.070588238537311554, 0.070588238537311554),
        (0.13865546882152557, 0.074509806931018829, 0.074509806931018829),
        (0.1428571492433548, 0.078431375324726105, 0.078431375324726105),
        (0.14705882966518402, 0.08235294371843338, 0.08235294371843338),
        (0.15126051008701324, 0.086274512112140656, 0.086274512112140656),
        (0.15546219050884247, 0.086274512112140656, 0.086274512112140656),
        (0.15966387093067169, 0.090196080505847931, 0.090196080505847931),
        (0.16386555135250092, 0.094117648899555206, 0.094117648899555206),
        (0.16806723177433014, 0.098039217293262482, 0.098039217293262482),
        (0.17226891219615936, 0.10196078568696976, 0.10196078568696976),
        (0.17647059261798859, 0.10196078568696976, 0.10196078568696976),
        (0.18067227303981781, 0.10588235408067703, 0.10588235408067703),
        (0.18487395346164703, 0.10980392247438431, 0.10980392247438431),
        (0.18907563388347626, 0.11372549086809158, 0.11372549086809158),
        (0.19327731430530548, 0.11764705926179886, 0.11764705926179886),
        (0.1974789947271347, 0.12156862765550613, 0.12156862765550613),
        (0.20168067514896393, 0.12156862765550613, 0.12156862765550613),
        (0.20588235557079315, 0.12549020349979401, 0.12549020349979401),
        (0.21008403599262238, 0.12941177189350128, 0.12941177189350128),
        (0.2142857164144516, 0.13333334028720856, 0.13333334028720856),
        (0.21848739683628082, 0.13725490868091583, 0.13725490868091583),
        (0.22268907725811005, 0.14117647707462311, 0.14117647707462311),
        (0.22689075767993927, 0.14117647707462311, 0.14117647707462311),
        (0.23109243810176849, 0.14509804546833038, 0.14509804546833038),
        (0.23529411852359772, 0.14901961386203766, 0.14901961386203766),
        (0.23949579894542694, 0.15294118225574493, 0.15294118225574493),
        (0.24369747936725616, 0.15686275064945221, 0.15686275064945221),
        (0.24789915978908539, 0.16078431904315948, 0.16078431904315948),
        (0.25210085511207581, 0.16078431904315948, 0.16078431904315948),
        (0.25630253553390503, 0.16470588743686676, 0.16470588743686676),
        (0.26050421595573425, 0.16862745583057404, 0.16862745583057404),
        (0.26470589637756348, 0.17254902422428131, 0.17254902422428131),
        (0.2689075767993927, 0.17647059261798859, 0.17647059261798859),
        (0.27310925722122192, 0.18039216101169586, 0.18039216101169586),
        (0.27731093764305115, 0.18431372940540314, 0.18431372940540314),
        (0.28151261806488037, 0.18823529779911041, 0.18823529779911041),
        (0.28571429848670959, 0.18823529779911041, 0.18823529779911041),
        (0.28991597890853882, 0.18823529779911041, 0.18823529779911041),
        (0.29411765933036804, 0.19215686619281769, 0.19215686619281769),
        (0.29831933975219727, 0.19215686619281769, 0.19215686619281769),
        (0.30252102017402649, 0.19607843458652496, 0.19607843458652496),
        (0.30672270059585571, 0.19607843458652496, 0.19607843458652496),
        (0.31092438101768494, 0.20000000298023224, 0.20000000298023224),
        (0.31512606143951416, 0.20000000298023224, 0.20000000298023224),
        (0.31932774186134338, 0.20392157137393951, 0.20392157137393951),
        (0.32352942228317261, 0.20392157137393951, 0.20392157137393951),
        (0.32773110270500183, 0.20784313976764679, 0.20784313976764679),
        (0.33193278312683105, 0.20784313976764679, 0.20784313976764679),
        (0.33613446354866028, 0.21176470816135406, 0.21176470816135406),
        (0.3403361439704895, 0.21176470816135406, 0.21176470816135406),
        (0.34453782439231873, 0.21568627655506134, 0.21568627655506134),
        (0.34873950481414795, 0.21568627655506134, 0.21568627655506134),
        (0.35294118523597717, 0.21960784494876862, 0.21960784494876862),
        (0.3571428656578064, 0.21960784494876862, 0.21960784494876862),
        (0.36134454607963562, 0.22352941334247589, 0.22352941334247589),
        (0.36554622650146484, 0.22352941334247589, 0.22352941334247589),
        (0.36974790692329407, 0.22745098173618317, 0.22745098173618317),
        (0.37394958734512329, 0.22745098173618317, 0.22745098173618317),
        (0.37815126776695251, 0.23137255012989044, 0.23137255012989044),
        (0.38235294818878174, 0.23137255012989044, 0.23137255012989044),
        (0.38655462861061096, 0.23529411852359772, 0.23529411852359772),
        (0.39075630903244019, 0.23921568691730499, 0.23921568691730499),
        (0.39495798945426941, 0.23921568691730499, 0.23921568691730499),
        (0.39915966987609863, 0.24313725531101227, 0.24313725531101227),
        (0.40336135029792786, 0.24313725531101227, 0.24313725531101227),
        (0.40756303071975708, 0.24705882370471954, 0.24705882370471954),
        (0.4117647111415863, 0.24705882370471954, 0.24705882370471954),
        (0.41596639156341553, 0.25098040699958801, 0.25098040699958801),
        (0.42016807198524475, 0.25098040699958801, 0.25098040699958801),
        (0.42436975240707397, 0.25490197539329529, 0.25490197539329529),
        (0.4285714328289032, 0.25490197539329529, 0.25490197539329529),
        (0.43277311325073242, 0.25882354378700256, 0.25882354378700256),
        (0.43697479367256165, 0.26274511218070984, 0.26274511218070984),
        (0.44117647409439087, 0.26274511218070984, 0.26274511218070984),
        (0.44537815451622009, 0.26666668057441711, 0.26666668057441711),
        (0.44957983493804932, 0.26666668057441711, 0.26666668057441711),
        (0.45378151535987854, 0.27058824896812439, 0.27058824896812439),
        (0.45798319578170776, 0.27058824896812439, 0.27058824896812439),
        (0.46218487620353699, 0.27450981736183167, 0.27450981736183167),
        (0.46638655662536621, 0.27843138575553894, 0.27843138575553894),
        (0.47058823704719543, 0.28627452254295349, 0.28627452254295349),
        (0.47478991746902466, 0.29803922772407532, 0.29803922772407532),
        (0.47899159789085388, 0.30588236451148987, 0.30588236451148987),
        (0.48319327831268311, 0.31764706969261169, 0.31764706969261169),
        (0.48739495873451233, 0.32549020648002625, 0.32549020648002625),
        (0.49159663915634155, 0.33725491166114807, 0.33725491166114807),
        (0.49579831957817078, 0.34509804844856262, 0.34509804844856262),
        (0.5, 0.35686275362968445, 0.35686275362968445),
        (0.50420171022415161, 0.36862745881080627, 0.36862745881080627),
        (0.50840336084365845, 0.37647059559822083, 0.37647059559822083),
        (0.51260507106781006, 0.38823530077934265, 0.38823530077934265),
        (0.51680672168731689, 0.3960784375667572, 0.3960784375667572),
        (0.52100843191146851, 0.40784314274787903, 0.40784314274787903),
        (0.52521008253097534, 0.41568627953529358, 0.41568627953529358),
        (0.52941179275512695, 0.42745098471641541, 0.42745098471641541),
        (0.53361344337463379, 0.43529412150382996, 0.43529412150382996),
        (0.5378151535987854, 0.44705882668495178, 0.44705882668495178),
        (0.54201680421829224, 0.45882353186607361, 0.45882353186607361),
        (0.54621851444244385, 0.46666666865348816, 0.46666666865348816),
        (0.55042016506195068, 0.47450980544090271, 0.47450980544090271),
        (0.55462187528610229, 0.47843137383460999, 0.47843137383460999),
        (0.55882352590560913, 0.48627451062202454, 0.48627451062202454),
        (0.56302523612976074, 0.49411764740943909, 0.49411764740943909),
        (0.56722688674926758, 0.50196081399917603, 0.50196081399917603),
        (0.57142859697341919, 0.5058823823928833, 0.5058823823928833),
        (0.57563024759292603, 0.51372551918029785, 0.51372551918029785),
        (0.57983195781707764, 0.5215686559677124, 0.5215686559677124),
        (0.58403360843658447, 0.52941179275512695, 0.52941179275512695),
        (0.58823531866073608, 0.53333336114883423, 0.53333336114883423),
        (0.59243696928024292, 0.54117649793624878, 0.54117649793624878),
        (0.59663867950439453, 0.54901963472366333, 0.54901963472366333),
        (0.60084033012390137, 0.55294120311737061, 0.55294120311737061),
        (0.60504204034805298, 0.56078433990478516, 0.56078433990478516),
        (0.60924369096755981, 0.56862747669219971, 0.56862747669219971),
        (0.61344540119171143, 0.57647061347961426, 0.57647061347961426),
        (0.61764705181121826, 0.58431375026702881, 0.58431375026702881),
        (0.62184876203536987, 0.58823531866073608, 0.58823531866073608),
        (0.62605041265487671, 0.59607845544815063, 0.59607845544815063),
        (0.63025212287902832, 0.60392159223556519, 0.60392159223556519),
        (0.63445377349853516, 0.61176472902297974, 0.61176472902297974),
        (0.63865548372268677, 0.61568629741668701, 0.61568629741668701),
        (0.6428571343421936, 0.62352943420410156, 0.62352943420410156),
        (0.64705884456634521, 0.63137257099151611, 0.63137257099151611),
        (0.65126049518585205, 0.63921570777893066, 0.63921570777893066),
        (0.65546220541000366, 0.64705884456634521, 0.64705884456634521),
        (0.6596638560295105, 0.65098041296005249, 0.65098041296005249),
        (0.66386556625366211, 0.65882354974746704, 0.65882354974746704),
        (0.66806721687316895, 0.66666668653488159, 0.66666668653488159),
        (0.67226892709732056, 0.67450982332229614, 0.67450982332229614),
        (0.67647057771682739, 0.68235296010971069, 0.68235296010971069),
        (0.680672287940979, 0.68627452850341797, 0.68627452850341797),
        (0.68487393856048584, 0.69411766529083252, 0.69411766529083252),
        (0.68907564878463745, 0.70196080207824707, 0.70196080207824707),
        (0.69327729940414429, 0.70980393886566162, 0.70980393886566162),
        (0.6974790096282959, 0.71764707565307617, 0.71764707565307617),
        (0.70168066024780273, 0.71764707565307617, 0.71764707565307617),
        (0.70588237047195435, 0.72156864404678345, 0.72156864404678345),
        (0.71008402109146118, 0.72156864404678345, 0.72156864404678345),
        (0.71428573131561279, 0.72549021244049072, 0.72549021244049072),
        (0.71848738193511963, 0.72549021244049072, 0.72549021244049072),
        (0.72268909215927124, 0.729411780834198, 0.729411780834198),
        (0.72689074277877808, 0.729411780834198, 0.729411780834198),
        (0.73109245300292969, 0.73333334922790527, 0.73333334922790527),
        (0.73529410362243652, 0.73333334922790527, 0.73333334922790527),
        (0.73949581384658813, 0.73333334922790527, 0.73333334922790527),
        (0.74369746446609497, 0.73725491762161255, 0.73725491762161255),
        (0.74789917469024658, 0.73725491762161255, 0.73725491762161255),
        (0.75210082530975342, 0.74117648601531982, 0.74117648601531982),
        (0.75630253553390503, 0.74117648601531982, 0.74117648601531982),
        (0.76050418615341187, 0.7450980544090271, 0.7450980544090271),
        (0.76470589637756348, 0.7450980544090271, 0.7450980544090271),
        (0.76890754699707031, 0.7450980544090271, 0.7450980544090271),
        (0.77310925722122192, 0.74901962280273438, 0.74901962280273438),
        (0.77731090784072876, 0.74901962280273438, 0.74901962280273438),
        (0.78151261806488037, 0.75294119119644165, 0.75294119119644165),
        (0.78571426868438721, 0.75294119119644165, 0.75294119119644165),
        (0.78991597890853882, 0.75686275959014893, 0.75686275959014893),
        (0.79411762952804565, 0.76470589637756348, 0.76470589637756348),
        (0.79831933975219727, 0.76862746477127075, 0.76862746477127075),
        (0.8025209903717041, 0.77254903316497803, 0.77254903316497803),
        (0.80672270059585571, 0.7764706015586853, 0.7764706015586853),
        (0.81092435121536255, 0.78039216995239258, 0.78039216995239258),
        (0.81512606143951416, 0.78823530673980713, 0.78823530673980713),
        (0.819327712059021, 0.7921568751335144, 0.7921568751335144),
        (0.82352942228317261, 0.79607844352722168, 0.79607844352722168),
        (0.82773107290267944, 0.80000001192092896, 0.80000001192092896),
        (0.83193278312683105, 0.80392158031463623, 0.80392158031463623),
        (0.83613443374633789, 0.81176471710205078, 0.81176471710205078),
        (0.8403361439704895, 0.81568628549575806, 0.81568628549575806),
        (0.84453779458999634, 0.81960785388946533, 0.81960785388946533),
        (0.84873950481414795, 0.82352942228317261, 0.82352942228317261),
        (0.85294115543365479, 0.82745099067687988, 0.82745099067687988),
        (0.8571428656578064, 0.83529412746429443, 0.83529412746429443),
        (0.86134451627731323, 0.83921569585800171, 0.83921569585800171),
        (0.86554622650146484, 0.84313726425170898, 0.84313726425170898),
        (0.86974787712097168, 0.84705883264541626, 0.84705883264541626),
        (0.87394958734512329, 0.85098040103912354, 0.85098040103912354),
        (0.87815123796463013, 0.85882353782653809, 0.85882353782653809),
        (0.88235294818878174, 0.86274510622024536, 0.86274510622024536),
        (0.88655459880828857, 0.86666667461395264, 0.86666667461395264),
        (0.89075630903244019, 0.87058824300765991, 0.87058824300765991),
        (0.89495795965194702, 0.87450981140136719, 0.87450981140136719),
        (0.89915966987609863, 0.88235294818878174, 0.88235294818878174),
        (0.90336132049560547, 0.88627451658248901, 0.88627451658248901),
        (0.90756303071975708, 0.89019608497619629, 0.89019608497619629),
        (0.91176468133926392, 0.89411765336990356, 0.89411765336990356),
        (0.91596639156341553, 0.89803922176361084, 0.89803922176361084),
        (0.92016804218292236, 0.90588235855102539, 0.90588235855102539),
        (0.92436975240707397, 0.90980392694473267, 0.90980392694473267),
        (0.92857140302658081, 0.91372549533843994, 0.91372549533843994),
        (0.93277311325073242, 0.91764706373214722, 0.91764706373214722),
        (0.93697476387023926, 0.92156863212585449, 0.92156863212585449),
        (0.94117647409439087, 0.92941176891326904, 0.92941176891326904),
        (0.94537812471389771, 0.93333333730697632, 0.93333333730697632),
        (0.94957983493804932, 0.93725490570068359, 0.93725490570068359),
        (0.95378148555755615, 0.94117647409439087, 0.94117647409439087),
        (0.95798319578170776, 0.94509804248809814, 0.94509804248809814),
        (0.9621848464012146, 0.9529411792755127, 0.9529411792755127),
        (0.96638655662536621, 0.95686274766921997, 0.95686274766921997),
        (0.97058820724487305, 0.96078431606292725, 0.96078431606292725),
        (0.97478991746902466, 0.96470588445663452, 0.96470588445663452),
        (0.97899156808853149, 0.9686274528503418, 0.9686274528503418),
        (0.98319327831268311, 0.97647058963775635, 0.97647058963775635),
        (0.98739492893218994, 0.98039215803146362, 0.98039215803146362),
        (0.99159663915634155, 0.9843137264251709, 0.9843137264251709),
        (0.99579828977584839, 0.98823529481887817, 0.98823529481887817),
        (1.0, 0.99215686321258545, 0.99215686321258545),
    ],
}
_gist_gray_data = {
    "blue": [
        (0.0, 0.0, 0.0),
        (0.0042016808874905109, 0.0039215688593685627, 0.0039215688593685627),
        (0.0084033617749810219, 0.0078431377187371254, 0.0078431377187371254),
        (0.012605042196810246, 0.011764706112444401, 0.011764706112444401),
        (0.016806723549962044, 0.015686275437474251, 0.015686275437474251),
        (0.021008403971791267, 0.019607843831181526, 0.019607843831181526),
        (0.025210084393620491, 0.023529412224888802, 0.023529412224888802),
        (0.029411764815449715, 0.027450980618596077, 0.027450980618596077),
        (0.033613447099924088, 0.035294119268655777, 0.035294119268655777),
        (0.037815127521753311, 0.039215687662363052, 0.039215687662363052),
        (0.042016807943582535, 0.043137256056070328, 0.043137256056070328),
        (0.046218488365411758, 0.047058824449777603, 0.047058824449777603),
        (0.050420168787240982, 0.050980392843484879, 0.050980392843484879),
        (0.054621849209070206, 0.054901961237192154, 0.054901961237192154),
        (0.058823529630899429, 0.058823529630899429, 0.058823529630899429),
        (0.063025213778018951, 0.062745101749897003, 0.062745101749897003),
        (0.067226894199848175, 0.066666670143604279, 0.066666670143604279),
        (0.071428574621677399, 0.070588238537311554, 0.070588238537311554),
        (0.075630255043506622, 0.074509806931018829, 0.074509806931018829),
        (0.079831935465335846, 0.078431375324726105, 0.078431375324726105),
        (0.08403361588716507, 0.08235294371843338, 0.08235294371843338),
        (0.088235296308994293, 0.086274512112140656, 0.086274512112140656),
        (0.092436976730823517, 0.090196080505847931, 0.090196080505847931),
        (0.09663865715265274, 0.098039217293262482, 0.098039217293262482),
        (0.10084033757448196, 0.10196078568696976, 0.10196078568696976),
        (0.10504201799631119, 0.10588235408067703, 0.10588235408067703),
        (0.10924369841814041, 0.10980392247438431, 0.10980392247438431),
        (0.11344537883996964, 0.11372549086809158, 0.11372549086809158),
        (0.11764705926179886, 0.11764705926179886, 0.11764705926179886),
        (0.12184873968362808, 0.12156862765550613, 0.12156862765550613),
        (0.1260504275560379, 0.12549020349979401, 0.12549020349979401),
        (0.13025210797786713, 0.12941177189350128, 0.12941177189350128),
        (0.13445378839969635, 0.13333334028720856, 0.13333334028720856),
        (0.13865546882152557, 0.13725490868091583, 0.13725490868091583),
        (0.1428571492433548, 0.14117647707462311, 0.14117647707462311),
        (0.14705882966518402, 0.14509804546833038, 0.14509804546833038),
        (0.15126051008701324, 0.14901961386203766, 0.14901961386203766),
        (0.15546219050884247, 0.15294118225574493, 0.15294118225574493),
        (0.15966387093067169, 0.16078431904315948, 0.16078431904315948),
        (0.16386555135250092, 0.16470588743686676, 0.16470588743686676),
        (0.16806723177433014, 0.16862745583057404, 0.16862745583057404),
        (0.17226891219615936, 0.17254902422428131, 0.17254902422428131),
        (0.17647059261798859, 0.17647059261798859, 0.17647059261798859),
        (0.18067227303981781, 0.18039216101169586, 0.18039216101169586),
        (0.18487395346164703, 0.18431372940540314, 0.18431372940540314),
        (0.18907563388347626, 0.18823529779911041, 0.18823529779911041),
        (0.19327731430530548, 0.19215686619281769, 0.19215686619281769),
        (0.1974789947271347, 0.19607843458652496, 0.19607843458652496),
        (0.20168067514896393, 0.20000000298023224, 0.20000000298023224),
        (0.20588235557079315, 0.20392157137393951, 0.20392157137393951),
        (0.21008403599262238, 0.20784313976764679, 0.20784313976764679),
        (0.2142857164144516, 0.21176470816135406, 0.21176470816135406),
        (0.21848739683628082, 0.21568627655506134, 0.21568627655506134),
        (0.22268907725811005, 0.22352941334247589, 0.22352941334247589),
        (0.22689075767993927, 0.22745098173618317, 0.22745098173618317),
        (0.23109243810176849, 0.23137255012989044, 0.23137255012989044),
        (0.23529411852359772, 0.23529411852359772, 0.23529411852359772),
        (0.23949579894542694, 0.23921568691730499, 0.23921568691730499),
        (0.24369747936725616, 0.24313725531101227, 0.24313725531101227),
        (0.24789915978908539, 0.24705882370471954, 0.24705882370471954),
        (0.25210085511207581, 0.25098040699958801, 0.25098040699958801),
        (0.25630253553390503, 0.25490197539329529, 0.25490197539329529),
        (0.26050421595573425, 0.25882354378700256, 0.25882354378700256),
        (0.26470589637756348, 0.26274511218070984, 0.26274511218070984),
        (0.2689075767993927, 0.26666668057441711, 0.26666668057441711),
        (0.27310925722122192, 0.27058824896812439, 0.27058824896812439),
        (0.27731093764305115, 0.27450981736183167, 0.27450981736183167),
        (0.28151261806488037, 0.27843138575553894, 0.27843138575553894),
        (0.28571429848670959, 0.28627452254295349, 0.28627452254295349),
        (0.28991597890853882, 0.29019609093666077, 0.29019609093666077),
        (0.29411765933036804, 0.29411765933036804, 0.29411765933036804),
        (0.29831933975219727, 0.29803922772407532, 0.29803922772407532),
        (0.30252102017402649, 0.30196079611778259, 0.30196079611778259),
        (0.30672270059585571, 0.30588236451148987, 0.30588236451148987),
        (0.31092438101768494, 0.30980393290519714, 0.30980393290519714),
        (0.31512606143951416, 0.31372550129890442, 0.31372550129890442),
        (0.31932774186134338, 0.31764706969261169, 0.31764706969261169),
        (0.32352942228317261, 0.32156863808631897, 0.32156863808631897),
        (0.32773110270500183, 0.32549020648002625, 0.32549020648002625),
        (0.33193278312683105, 0.32941177487373352, 0.32941177487373352),
        (0.33613446354866028, 0.3333333432674408, 0.3333333432674408),
        (0.3403361439704895, 0.33725491166114807, 0.33725491166114807),
        (0.34453782439231873, 0.34117648005485535, 0.34117648005485535),
        (0.34873950481414795, 0.3490196168422699, 0.3490196168422699),
        (0.35294118523597717, 0.35294118523597717, 0.35294118523597717),
        (0.3571428656578064, 0.35686275362968445, 0.35686275362968445),
        (0.36134454607963562, 0.36078432202339172, 0.36078432202339172),
        (0.36554622650146484, 0.364705890417099, 0.364705890417099),
        (0.36974790692329407, 0.36862745881080627, 0.36862745881080627),
        (0.37394958734512329, 0.37254902720451355, 0.37254902720451355),
        (0.37815126776695251, 0.37647059559822083, 0.37647059559822083),
        (0.38235294818878174, 0.3803921639919281, 0.3803921639919281),
        (0.38655462861061096, 0.38431373238563538, 0.38431373238563538),
        (0.39075630903244019, 0.38823530077934265, 0.38823530077934265),
        (0.39495798945426941, 0.39215686917304993, 0.39215686917304993),
        (0.39915966987609863, 0.3960784375667572, 0.3960784375667572),
        (0.40336135029792786, 0.40000000596046448, 0.40000000596046448),
        (0.40756303071975708, 0.40392157435417175, 0.40392157435417175),
        (0.4117647111415863, 0.4117647111415863, 0.4117647111415863),
        (0.41596639156341553, 0.41568627953529358, 0.41568627953529358),
        (0.42016807198524475, 0.41960784792900085, 0.41960784792900085),
        (0.42436975240707397, 0.42352941632270813, 0.42352941632270813),
        (0.4285714328289032, 0.42745098471641541, 0.42745098471641541),
        (0.43277311325073242, 0.43137255311012268, 0.43137255311012268),
        (0.43697479367256165, 0.43529412150382996, 0.43529412150382996),
        (0.44117647409439087, 0.43921568989753723, 0.43921568989753723),
        (0.44537815451622009, 0.44313725829124451, 0.44313725829124451),
        (0.44957983493804932, 0.44705882668495178, 0.44705882668495178),
        (0.45378151535987854, 0.45098039507865906, 0.45098039507865906),
        (0.45798319578170776, 0.45490196347236633, 0.45490196347236633),
        (0.46218487620353699, 0.45882353186607361, 0.45882353186607361),
        (0.46638655662536621, 0.46274510025978088, 0.46274510025978088),
        (0.47058823704719543, 0.46666666865348816, 0.46666666865348816),
        (0.47478991746902466, 0.47450980544090271, 0.47450980544090271),
        (0.47899159789085388, 0.47843137383460999, 0.47843137383460999),
        (0.48319327831268311, 0.48235294222831726, 0.48235294222831726),
        (0.48739495873451233, 0.48627451062202454, 0.48627451062202454),
        (0.49159663915634155, 0.49019607901573181, 0.49019607901573181),
        (0.49579831957817078, 0.49411764740943909, 0.49411764740943909),
        (0.5, 0.49803921580314636, 0.49803921580314636),
        (0.50420171022415161, 0.50196081399917603, 0.50196081399917603),
        (0.50840336084365845, 0.5058823823928833, 0.5058823823928833),
        (0.51260507106781006, 0.50980395078659058, 0.50980395078659058),
        (0.51680672168731689, 0.51372551918029785, 0.51372551918029785),
        (0.52100843191146851, 0.51764708757400513, 0.51764708757400513),
        (0.52521008253097534, 0.5215686559677124, 0.5215686559677124),
        (0.52941179275512695, 0.52549022436141968, 0.52549022436141968),
        (0.53361344337463379, 0.52941179275512695, 0.52941179275512695),
        (0.5378151535987854, 0.5372549295425415, 0.5372549295425415),
        (0.54201680421829224, 0.54117649793624878, 0.54117649793624878),
        (0.54621851444244385, 0.54509806632995605, 0.54509806632995605),
        (0.55042016506195068, 0.54901963472366333, 0.54901963472366333),
        (0.55462187528610229, 0.55294120311737061, 0.55294120311737061),
        (0.55882352590560913, 0.55686277151107788, 0.55686277151107788),
        (0.56302523612976074, 0.56078433990478516, 0.56078433990478516),
        (0.56722688674926758, 0.56470590829849243, 0.56470590829849243),
        (0.57142859697341919, 0.56862747669219971, 0.56862747669219971),
        (0.57563024759292603, 0.57254904508590698, 0.57254904508590698),
        (0.57983195781707764, 0.57647061347961426, 0.57647061347961426),
        (0.58403360843658447, 0.58039218187332153, 0.58039218187332153),
        (0.58823531866073608, 0.58431375026702881, 0.58431375026702881),
        (0.59243696928024292, 0.58823531866073608, 0.58823531866073608),
        (0.59663867950439453, 0.59215688705444336, 0.59215688705444336),
        (0.60084033012390137, 0.60000002384185791, 0.60000002384185791),
        (0.60504204034805298, 0.60392159223556519, 0.60392159223556519),
        (0.60924369096755981, 0.60784316062927246, 0.60784316062927246),
        (0.61344540119171143, 0.61176472902297974, 0.61176472902297974),
        (0.61764705181121826, 0.61568629741668701, 0.61568629741668701),
        (0.62184876203536987, 0.61960786581039429, 0.61960786581039429),
        (0.62605041265487671, 0.62352943420410156, 0.62352943420410156),
        (0.63025212287902832, 0.62745100259780884, 0.62745100259780884),
        (0.63445377349853516, 0.63137257099151611, 0.63137257099151611),
        (0.63865548372268677, 0.63529413938522339, 0.63529413938522339),
        (0.6428571343421936, 0.63921570777893066, 0.63921570777893066),
        (0.64705884456634521, 0.64313727617263794, 0.64313727617263794),
        (0.65126049518585205, 0.64705884456634521, 0.64705884456634521),
        (0.65546220541000366, 0.65098041296005249, 0.65098041296005249),
        (0.6596638560295105, 0.65490198135375977, 0.65490198135375977),
        (0.66386556625366211, 0.66274511814117432, 0.66274511814117432),
        (0.66806721687316895, 0.66666668653488159, 0.66666668653488159),
        (0.67226892709732056, 0.67058825492858887, 0.67058825492858887),
        (0.67647057771682739, 0.67450982332229614, 0.67450982332229614),
        (0.680672287940979, 0.67843139171600342, 0.67843139171600342),
        (0.68487393856048584, 0.68235296010971069, 0.68235296010971069),
        (0.68907564878463745, 0.68627452850341797, 0.68627452850341797),
        (0.69327729940414429, 0.69019609689712524, 0.69019609689712524),
        (0.6974790096282959, 0.69411766529083252, 0.69411766529083252),
        (0.70168066024780273, 0.69803923368453979, 0.69803923368453979),
        (0.70588237047195435, 0.70196080207824707, 0.70196080207824707),
        (0.71008402109146118, 0.70588237047195435, 0.70588237047195435),
        (0.71428573131561279, 0.70980393886566162, 0.70980393886566162),
        (0.71848738193511963, 0.7137255072593689, 0.7137255072593689),
        (0.72268909215927124, 0.71764707565307617, 0.71764707565307617),
        (0.72689074277877808, 0.72549021244049072, 0.72549021244049072),
        (0.73109245300292969, 0.729411780834198, 0.729411780834198),
        (0.73529410362243652, 0.73333334922790527, 0.73333334922790527),
        (0.73949581384658813, 0.73725491762161255, 0.73725491762161255),
        (0.74369746446609497, 0.74117648601531982, 0.74117648601531982),
        (0.74789917469024658, 0.7450980544090271, 0.7450980544090271),
        (0.75210082530975342, 0.74901962280273438, 0.74901962280273438),
        (0.75630253553390503, 0.75294119119644165, 0.75294119119644165),
        (0.76050418615341187, 0.75686275959014893, 0.75686275959014893),
        (0.76470589637756348, 0.7607843279838562, 0.7607843279838562),
        (0.76890754699707031, 0.76470589637756348, 0.76470589637756348),
        (0.77310925722122192, 0.76862746477127075, 0.76862746477127075),
        (0.77731090784072876, 0.77254903316497803, 0.77254903316497803),
        (0.78151261806488037, 0.7764706015586853, 0.7764706015586853),
        (0.78571426868438721, 0.78039216995239258, 0.78039216995239258),
        (0.78991597890853882, 0.78823530673980713, 0.78823530673980713),
        (0.79411762952804565, 0.7921568751335144, 0.7921568751335144),
        (0.79831933975219727, 0.79607844352722168, 0.79607844352722168),
        (0.8025209903717041, 0.80000001192092896, 0.80000001192092896),
        (0.80672270059585571, 0.80392158031463623, 0.80392158031463623),
        (0.81092435121536255, 0.80784314870834351, 0.80784314870834351),
        (0.81512606143951416, 0.81176471710205078, 0.81176471710205078),
        (0.819327712059021, 0.81568628549575806, 0.81568628549575806),
        (0.82352942228317261, 0.81960785388946533, 0.81960785388946533),
        (0.82773107290267944, 0.82352942228317261, 0.82352942228317261),
        (0.83193278312683105, 0.82745099067687988, 0.82745099067687988),
        (0.83613443374633789, 0.83137255907058716, 0.83137255907058716),
        (0.8403361439704895, 0.83529412746429443, 0.83529412746429443),
        (0.84453779458999634, 0.83921569585800171, 0.83921569585800171),
        (0.84873950481414795, 0.84313726425170898, 0.84313726425170898),
        (0.85294115543365479, 0.85098040103912354, 0.85098040103912354),
        (0.8571428656578064, 0.85490196943283081, 0.85490196943283081),
        (0.86134451627731323, 0.85882353782653809, 0.85882353782653809),
        (0.86554622650146484, 0.86274510622024536, 0.86274510622024536),
        (0.86974787712097168, 0.86666667461395264, 0.86666667461395264),
        (0.87394958734512329, 0.87058824300765991, 0.87058824300765991),
        (0.87815123796463013, 0.87450981140136719, 0.87450981140136719),
        (0.88235294818878174, 0.87843137979507446, 0.87843137979507446),
        (0.88655459880828857, 0.88235294818878174, 0.88235294818878174),
        (0.89075630903244019, 0.88627451658248901, 0.88627451658248901),
        (0.89495795965194702, 0.89019608497619629, 0.89019608497619629),
        (0.89915966987609863, 0.89411765336990356, 0.89411765336990356),
        (0.90336132049560547, 0.89803922176361084, 0.89803922176361084),
        (0.90756303071975708, 0.90196079015731812, 0.90196079015731812),
        (0.91176468133926392, 0.90588235855102539, 0.90588235855102539),
        (0.91596639156341553, 0.91372549533843994, 0.91372549533843994),
        (0.92016804218292236, 0.91764706373214722, 0.91764706373214722),
        (0.92436975240707397, 0.92156863212585449, 0.92156863212585449),
        (0.92857140302658081, 0.92549020051956177, 0.92549020051956177),
        (0.93277311325073242, 0.92941176891326904, 0.92941176891326904),
        (0.93697476387023926, 0.93333333730697632, 0.93333333730697632),
        (0.94117647409439087, 0.93725490570068359, 0.93725490570068359),
        (0.94537812471389771, 0.94117647409439087, 0.94117647409439087),
        (0.94957983493804932, 0.94509804248809814, 0.94509804248809814),
        (0.95378148555755615, 0.94901961088180542, 0.94901961088180542),
        (0.95798319578170776, 0.9529411792755127, 0.9529411792755127),
        (0.9621848464012146, 0.95686274766921997, 0.95686274766921997),
        (0.96638655662536621, 0.96078431606292725, 0.96078431606292725),
        (0.97058820724487305, 0.96470588445663452, 0.96470588445663452),
        (0.97478991746902466, 0.9686274528503418, 0.9686274528503418),
        (0.97899156808853149, 0.97647058963775635, 0.97647058963775635),
        (0.98319327831268311, 0.98039215803146362, 0.98039215803146362),
        (0.98739492893218994, 0.9843137264251709, 0.9843137264251709),
        (0.99159663915634155, 0.98823529481887817, 0.98823529481887817),
        (0.99579828977584839, 0.99215686321258545, 0.99215686321258545),
        (1.0, 0.99607843160629272, 0.99607843160629272),
    ],
    "green": [
        (0.0, 0.0, 0.0),
        (0.0042016808874905109, 0.0039215688593685627, 0.0039215688593685627),
        (0.0084033617749810219, 0.0078431377187371254, 0.0078431377187371254),
        (0.012605042196810246, 0.011764706112444401, 0.011764706112444401),
        (0.016806723549962044, 0.015686275437474251, 0.015686275437474251),
        (0.021008403971791267, 0.019607843831181526, 0.019607843831181526),
        (0.025210084393620491, 0.023529412224888802, 0.023529412224888802),
        (0.029411764815449715, 0.027450980618596077, 0.027450980618596077),
        (0.033613447099924088, 0.035294119268655777, 0.035294119268655777),
        (0.037815127521753311, 0.039215687662363052, 0.039215687662363052),
        (0.042016807943582535, 0.043137256056070328, 0.043137256056070328),
        (0.046218488365411758, 0.047058824449777603, 0.047058824449777603),
        (0.050420168787240982, 0.050980392843484879, 0.050980392843484879),
        (0.054621849209070206, 0.054901961237192154, 0.054901961237192154),
        (0.058823529630899429, 0.058823529630899429, 0.058823529630899429),
        (0.063025213778018951, 0.062745101749897003, 0.062745101749897003),
        (0.067226894199848175, 0.066666670143604279, 0.066666670143604279),
        (0.071428574621677399, 0.070588238537311554, 0.070588238537311554),
        (0.075630255043506622, 0.074509806931018829, 0.074509806931018829),
        (0.079831935465335846, 0.078431375324726105, 0.078431375324726105),
        (0.08403361588716507, 0.08235294371843338, 0.08235294371843338),
        (0.088235296308994293, 0.086274512112140656, 0.086274512112140656),
        (0.092436976730823517, 0.090196080505847931, 0.090196080505847931),
        (0.09663865715265274, 0.098039217293262482, 0.098039217293262482),
        (0.10084033757448196, 0.10196078568696976, 0.10196078568696976),
        (0.10504201799631119, 0.10588235408067703, 0.10588235408067703),
        (0.10924369841814041, 0.10980392247438431, 0.10980392247438431),
        (0.11344537883996964, 0.11372549086809158, 0.11372549086809158),
        (0.11764705926179886, 0.11764705926179886, 0.11764705926179886),
        (0.12184873968362808, 0.12156862765550613, 0.12156862765550613),
        (0.1260504275560379, 0.12549020349979401, 0.12549020349979401),
        (0.13025210797786713, 0.12941177189350128, 0.12941177189350128),
        (0.13445378839969635, 0.13333334028720856, 0.13333334028720856),
        (0.13865546882152557, 0.13725490868091583, 0.13725490868091583),
        (0.1428571492433548, 0.14117647707462311, 0.14117647707462311),
        (0.14705882966518402, 0.14509804546833038, 0.14509804546833038),
        (0.15126051008701324, 0.14901961386203766, 0.14901961386203766),
        (0.15546219050884247, 0.15294118225574493, 0.15294118225574493),
        (0.15966387093067169, 0.16078431904315948, 0.16078431904315948),
        (0.16386555135250092, 0.16470588743686676, 0.16470588743686676),
        (0.16806723177433014, 0.16862745583057404, 0.16862745583057404),
        (0.17226891219615936, 0.17254902422428131, 0.17254902422428131),
        (0.17647059261798859, 0.17647059261798859, 0.17647059261798859),
        (0.18067227303981781, 0.18039216101169586, 0.18039216101169586),
        (0.18487395346164703, 0.18431372940540314, 0.18431372940540314),
        (0.18907563388347626, 0.18823529779911041, 0.18823529779911041),
        (0.19327731430530548, 0.19215686619281769, 0.19215686619281769),
        (0.1974789947271347, 0.19607843458652496, 0.19607843458652496),
        (0.20168067514896393, 0.20000000298023224, 0.20000000298023224),
        (0.20588235557079315, 0.20392157137393951, 0.20392157137393951),
        (0.21008403599262238, 0.20784313976764679, 0.20784313976764679),
        (0.2142857164144516, 0.21176470816135406, 0.21176470816135406),
        (0.21848739683628082, 0.21568627655506134, 0.21568627655506134),
        (0.22268907725811005, 0.22352941334247589, 0.22352941334247589),
        (0.22689075767993927, 0.22745098173618317, 0.22745098173618317),
        (0.23109243810176849, 0.23137255012989044, 0.23137255012989044),
        (0.23529411852359772, 0.23529411852359772, 0.23529411852359772),
        (0.23949579894542694, 0.23921568691730499, 0.23921568691730499),
        (0.24369747936725616, 0.24313725531101227, 0.24313725531101227),
        (0.24789915978908539, 0.24705882370471954, 0.24705882370471954),
        (0.25210085511207581, 0.25098040699958801, 0.25098040699958801),
        (0.25630253553390503, 0.25490197539329529, 0.25490197539329529),
        (0.26050421595573425, 0.25882354378700256, 0.25882354378700256),
        (0.26470589637756348, 0.26274511218070984, 0.26274511218070984),
        (0.2689075767993927, 0.26666668057441711, 0.26666668057441711),
        (0.27310925722122192, 0.27058824896812439, 0.27058824896812439),
        (0.27731093764305115, 0.27450981736183167, 0.27450981736183167),
        (0.28151261806488037, 0.27843138575553894, 0.27843138575553894),
        (0.28571429848670959, 0.28627452254295349, 0.28627452254295349),
        (0.28991597890853882, 0.29019609093666077, 0.29019609093666077),
        (0.29411765933036804, 0.29411765933036804, 0.29411765933036804),
        (0.29831933975219727, 0.29803922772407532, 0.29803922772407532),
        (0.30252102017402649, 0.30196079611778259, 0.30196079611778259),
        (0.30672270059585571, 0.30588236451148987, 0.30588236451148987),
        (0.31092438101768494, 0.30980393290519714, 0.30980393290519714),
        (0.31512606143951416, 0.31372550129890442, 0.31372550129890442),
        (0.31932774186134338, 0.31764706969261169, 0.31764706969261169),
        (0.32352942228317261, 0.32156863808631897, 0.32156863808631897),
        (0.32773110270500183, 0.32549020648002625, 0.32549020648002625),
        (0.33193278312683105, 0.32941177487373352, 0.32941177487373352),
        (0.33613446354866028, 0.3333333432674408, 0.3333333432674408),
        (0.3403361439704895, 0.33725491166114807, 0.33725491166114807),
        (0.34453782439231873, 0.34117648005485535, 0.34117648005485535),
        (0.34873950481414795, 0.3490196168422699, 0.3490196168422699),
        (0.35294118523597717, 0.35294118523597717, 0.35294118523597717),
        (0.3571428656578064, 0.35686275362968445, 0.35686275362968445),
        (0.36134454607963562, 0.36078432202339172, 0.36078432202339172),
        (0.36554622650146484, 0.364705890417099, 0.364705890417099),
        (0.36974790692329407, 0.36862745881080627, 0.36862745881080627),
        (0.37394958734512329, 0.37254902720451355, 0.37254902720451355),
        (0.37815126776695251, 0.37647059559822083, 0.37647059559822083),
        (0.38235294818878174, 0.3803921639919281, 0.3803921639919281),
        (0.38655462861061096, 0.38431373238563538, 0.38431373238563538),
        (0.39075630903244019, 0.38823530077934265, 0.38823530077934265),
        (0.39495798945426941, 0.39215686917304993, 0.39215686917304993),
        (0.39915966987609863, 0.3960784375667572, 0.3960784375667572),
        (0.40336135029792786, 0.40000000596046448, 0.40000000596046448),
        (0.40756303071975708, 0.40392157435417175, 0.40392157435417175),
        (0.4117647111415863, 0.4117647111415863, 0.4117647111415863),
        (0.41596639156341553, 0.41568627953529358, 0.41568627953529358),
        (0.42016807198524475, 0.41960784792900085, 0.41960784792900085),
        (0.42436975240707397, 0.42352941632270813, 0.42352941632270813),
        (0.4285714328289032, 0.42745098471641541, 0.42745098471641541),
        (0.43277311325073242, 0.43137255311012268, 0.43137255311012268),
        (0.43697479367256165, 0.43529412150382996, 0.43529412150382996),
        (0.44117647409439087, 0.43921568989753723, 0.43921568989753723),
        (0.44537815451622009, 0.44313725829124451, 0.44313725829124451),
        (0.44957983493804932, 0.44705882668495178, 0.44705882668495178),
        (0.45378151535987854, 0.45098039507865906, 0.45098039507865906),
        (0.45798319578170776, 0.45490196347236633, 0.45490196347236633),
        (0.46218487620353699, 0.45882353186607361, 0.45882353186607361),
        (0.46638655662536621, 0.46274510025978088, 0.46274510025978088),
        (0.47058823704719543, 0.46666666865348816, 0.46666666865348816),
        (0.47478991746902466, 0.47450980544090271, 0.47450980544090271),
        (0.47899159789085388, 0.47843137383460999, 0.47843137383460999),
        (0.48319327831268311, 0.48235294222831726, 0.48235294222831726),
        (0.48739495873451233, 0.48627451062202454, 0.48627451062202454),
        (0.49159663915634155, 0.49019607901573181, 0.49019607901573181),
        (0.49579831957817078, 0.49411764740943909, 0.49411764740943909),
        (0.5, 0.49803921580314636, 0.49803921580314636),
        (0.50420171022415161, 0.50196081399917603, 0.50196081399917603),
        (0.50840336084365845, 0.5058823823928833, 0.5058823823928833),
        (0.51260507106781006, 0.50980395078659058, 0.50980395078659058),
        (0.51680672168731689, 0.51372551918029785, 0.51372551918029785),
        (0.52100843191146851, 0.51764708757400513, 0.51764708757400513),
        (0.52521008253097534, 0.5215686559677124, 0.5215686559677124),
        (0.52941179275512695, 0.52549022436141968, 0.52549022436141968),
        (0.53361344337463379, 0.52941179275512695, 0.52941179275512695),
        (0.5378151535987854, 0.5372549295425415, 0.5372549295425415),
        (0.54201680421829224, 0.54117649793624878, 0.54117649793624878),
        (0.54621851444244385, 0.54509806632995605, 0.54509806632995605),
        (0.55042016506195068, 0.54901963472366333, 0.54901963472366333),
        (0.55462187528610229, 0.55294120311737061, 0.55294120311737061),
        (0.55882352590560913, 0.55686277151107788, 0.55686277151107788),
        (0.56302523612976074, 0.56078433990478516, 0.56078433990478516),
        (0.56722688674926758, 0.56470590829849243, 0.56470590829849243),
        (0.57142859697341919, 0.56862747669219971, 0.56862747669219971),
        (0.57563024759292603, 0.57254904508590698, 0.57254904508590698),
        (0.57983195781707764, 0.57647061347961426, 0.57647061347961426),
        (0.58403360843658447, 0.58039218187332153, 0.58039218187332153),
        (0.58823531866073608, 0.58431375026702881, 0.58431375026702881),
        (0.59243696928024292, 0.58823531866073608, 0.58823531866073608),
        (0.59663867950439453, 0.59215688705444336, 0.59215688705444336),
        (0.60084033012390137, 0.60000002384185791, 0.60000002384185791),
        (0.60504204034805298, 0.60392159223556519, 0.60392159223556519),
        (0.60924369096755981, 0.60784316062927246, 0.60784316062927246),
        (0.61344540119171143, 0.61176472902297974, 0.61176472902297974),
        (0.61764705181121826, 0.61568629741668701, 0.61568629741668701),
        (0.62184876203536987, 0.61960786581039429, 0.61960786581039429),
        (0.62605041265487671, 0.62352943420410156, 0.62352943420410156),
        (0.63025212287902832, 0.62745100259780884, 0.62745100259780884),
        (0.63445377349853516, 0.63137257099151611, 0.63137257099151611),
        (0.63865548372268677, 0.63529413938522339, 0.63529413938522339),
        (0.6428571343421936, 0.63921570777893066, 0.63921570777893066),
        (0.64705884456634521, 0.64313727617263794, 0.64313727617263794),
        (0.65126049518585205, 0.64705884456634521, 0.64705884456634521),
        (0.65546220541000366, 0.65098041296005249, 0.65098041296005249),
        (0.6596638560295105, 0.65490198135375977, 0.65490198135375977),
        (0.66386556625366211, 0.66274511814117432, 0.66274511814117432),
        (0.66806721687316895, 0.66666668653488159, 0.66666668653488159),
        (0.67226892709732056, 0.67058825492858887, 0.67058825492858887),
        (0.67647057771682739, 0.67450982332229614, 0.67450982332229614),
        (0.680672287940979, 0.67843139171600342, 0.67843139171600342),
        (0.68487393856048584, 0.68235296010971069, 0.68235296010971069),
        (0.68907564878463745, 0.68627452850341797, 0.68627452850341797),
        (0.69327729940414429, 0.69019609689712524, 0.69019609689712524),
        (0.6974790096282959, 0.69411766529083252, 0.69411766529083252),
        (0.70168066024780273, 0.69803923368453979, 0.69803923368453979),
        (0.70588237047195435, 0.70196080207824707, 0.70196080207824707),
        (0.71008402109146118, 0.70588237047195435, 0.70588237047195435),
        (0.71428573131561279, 0.70980393886566162, 0.70980393886566162),
        (0.71848738193511963, 0.7137255072593689, 0.7137255072593689),
        (0.72268909215927124, 0.71764707565307617, 0.71764707565307617),
        (0.72689074277877808, 0.72549021244049072, 0.72549021244049072),
        (0.73109245300292969, 0.729411780834198, 0.729411780834198),
        (0.73529410362243652, 0.73333334922790527, 0.73333334922790527),
        (0.73949581384658813, 0.73725491762161255, 0.73725491762161255),
        (0.74369746446609497, 0.74117648601531982, 0.74117648601531982),
        (0.74789917469024658, 0.7450980544090271, 0.7450980544090271),
        (0.75210082530975342, 0.74901962280273438, 0.74901962280273438),
        (0.75630253553390503, 0.75294119119644165, 0.75294119119644165),
        (0.76050418615341187, 0.75686275959014893, 0.75686275959014893),
        (0.76470589637756348, 0.7607843279838562, 0.7607843279838562),
        (0.76890754699707031, 0.76470589637756348, 0.76470589637756348),
        (0.77310925722122192, 0.76862746477127075, 0.76862746477127075),
        (0.77731090784072876, 0.77254903316497803, 0.77254903316497803),
        (0.78151261806488037, 0.7764706015586853, 0.7764706015586853),
        (0.78571426868438721, 0.78039216995239258, 0.78039216995239258),
        (0.78991597890853882, 0.78823530673980713, 0.78823530673980713),
        (0.79411762952804565, 0.7921568751335144, 0.7921568751335144),
        (0.79831933975219727, 0.79607844352722168, 0.79607844352722168),
        (0.8025209903717041, 0.80000001192092896, 0.80000001192092896),
        (0.80672270059585571, 0.80392158031463623, 0.80392158031463623),
        (0.81092435121536255, 0.80784314870834351, 0.80784314870834351),
        (0.81512606143951416, 0.81176471710205078, 0.81176471710205078),
        (0.819327712059021, 0.81568628549575806, 0.81568628549575806),
        (0.82352942228317261, 0.81960785388946533, 0.81960785388946533),
        (0.82773107290267944, 0.82352942228317261, 0.82352942228317261),
        (0.83193278312683105, 0.82745099067687988, 0.82745099067687988),
        (0.83613443374633789, 0.83137255907058716, 0.83137255907058716),
        (0.8403361439704895, 0.83529412746429443, 0.83529412746429443),
        (0.84453779458999634, 0.83921569585800171, 0.83921569585800171),
        (0.84873950481414795, 0.84313726425170898, 0.84313726425170898),
        (0.85294115543365479, 0.85098040103912354, 0.85098040103912354),
        (0.8571428656578064, 0.85490196943283081, 0.85490196943283081),
        (0.86134451627731323, 0.85882353782653809, 0.85882353782653809),
        (0.86554622650146484, 0.86274510622024536, 0.86274510622024536),
        (0.86974787712097168, 0.86666667461395264, 0.86666667461395264),
        (0.87394958734512329, 0.87058824300765991, 0.87058824300765991),
        (0.87815123796463013, 0.87450981140136719, 0.87450981140136719),
        (0.88235294818878174, 0.87843137979507446, 0.87843137979507446),
        (0.88655459880828857, 0.88235294818878174, 0.88235294818878174),
        (0.89075630903244019, 0.88627451658248901, 0.88627451658248901),
        (0.89495795965194702, 0.89019608497619629, 0.89019608497619629),
        (0.89915966987609863, 0.89411765336990356, 0.89411765336990356),
        (0.90336132049560547, 0.89803922176361084, 0.89803922176361084),
        (0.90756303071975708, 0.90196079015731812, 0.90196079015731812),
        (0.91176468133926392, 0.90588235855102539, 0.90588235855102539),
        (0.91596639156341553, 0.91372549533843994, 0.91372549533843994),
        (0.92016804218292236, 0.91764706373214722, 0.91764706373214722),
        (0.92436975240707397, 0.92156863212585449, 0.92156863212585449),
        (0.92857140302658081, 0.92549020051956177, 0.92549020051956177),
        (0.93277311325073242, 0.92941176891326904, 0.92941176891326904),
        (0.93697476387023926, 0.93333333730697632, 0.93333333730697632),
        (0.94117647409439087, 0.93725490570068359, 0.93725490570068359),
        (0.94537812471389771, 0.94117647409439087, 0.94117647409439087),
        (0.94957983493804932, 0.94509804248809814, 0.94509804248809814),
        (0.95378148555755615, 0.94901961088180542, 0.94901961088180542),
        (0.95798319578170776, 0.9529411792755127, 0.9529411792755127),
        (0.9621848464012146, 0.95686274766921997, 0.95686274766921997),
        (0.96638655662536621, 0.96078431606292725, 0.96078431606292725),
        (0.97058820724487305, 0.96470588445663452, 0.96470588445663452),
        (0.97478991746902466, 0.9686274528503418, 0.9686274528503418),
        (0.97899156808853149, 0.97647058963775635, 0.97647058963775635),
        (0.98319327831268311, 0.98039215803146362, 0.98039215803146362),
        (0.98739492893218994, 0.9843137264251709, 0.9843137264251709),
        (0.99159663915634155, 0.98823529481887817, 0.98823529481887817),
        (0.99579828977584839, 0.99215686321258545, 0.99215686321258545),
        (1.0, 0.99607843160629272, 0.99607843160629272),
    ],
    "red": [
        (0.0, 0.0, 0.0),
        (0.0042016808874905109, 0.0039215688593685627, 0.0039215688593685627),
        (0.0084033617749810219, 0.0078431377187371254, 0.0078431377187371254),
        (0.012605042196810246, 0.011764706112444401, 0.011764706112444401),
        (0.016806723549962044, 0.015686275437474251, 0.015686275437474251),
        (0.021008403971791267, 0.019607843831181526, 0.019607843831181526),
        (0.025210084393620491, 0.023529412224888802, 0.023529412224888802),
        (0.029411764815449715, 0.027450980618596077, 0.027450980618596077),
        (0.033613447099924088, 0.035294119268655777, 0.035294119268655777),
        (0.037815127521753311, 0.039215687662363052, 0.039215687662363052),
        (0.042016807943582535, 0.043137256056070328, 0.043137256056070328),
        (0.046218488365411758, 0.047058824449777603, 0.047058824449777603),
        (0.050420168787240982, 0.050980392843484879, 0.050980392843484879),
        (0.054621849209070206, 0.054901961237192154, 0.054901961237192154),
        (0.058823529630899429, 0.058823529630899429, 0.058823529630899429),
        (0.063025213778018951, 0.062745101749897003, 0.062745101749897003),
        (0.067226894199848175, 0.066666670143604279, 0.066666670143604279),
        (0.071428574621677399, 0.070588238537311554, 0.070588238537311554),
        (0.075630255043506622, 0.074509806931018829, 0.074509806931018829),
        (0.079831935465335846, 0.078431375324726105, 0.078431375324726105),
        (0.08403361588716507, 0.08235294371843338, 0.08235294371843338),
        (0.088235296308994293, 0.086274512112140656, 0.086274512112140656),
        (0.092436976730823517, 0.090196080505847931, 0.090196080505847931),
        (0.09663865715265274, 0.098039217293262482, 0.098039217293262482),
        (0.10084033757448196, 0.10196078568696976, 0.10196078568696976),
        (0.10504201799631119, 0.10588235408067703, 0.10588235408067703),
        (0.10924369841814041, 0.10980392247438431, 0.10980392247438431),
        (0.11344537883996964, 0.11372549086809158, 0.11372549086809158),
        (0.11764705926179886, 0.11764705926179886, 0.11764705926179886),
        (0.12184873968362808, 0.12156862765550613, 0.12156862765550613),
        (0.1260504275560379, 0.12549020349979401, 0.12549020349979401),
        (0.13025210797786713, 0.12941177189350128, 0.12941177189350128),
        (0.13445378839969635, 0.13333334028720856, 0.13333334028720856),
        (0.13865546882152557, 0.13725490868091583, 0.13725490868091583),
        (0.1428571492433548, 0.14117647707462311, 0.14117647707462311),
        (0.14705882966518402, 0.14509804546833038, 0.14509804546833038),
        (0.15126051008701324, 0.14901961386203766, 0.14901961386203766),
        (0.15546219050884247, 0.15294118225574493, 0.15294118225574493),
        (0.15966387093067169, 0.16078431904315948, 0.16078431904315948),
        (0.16386555135250092, 0.16470588743686676, 0.16470588743686676),
        (0.16806723177433014, 0.16862745583057404, 0.16862745583057404),
        (0.17226891219615936, 0.17254902422428131, 0.17254902422428131),
        (0.17647059261798859, 0.17647059261798859, 0.17647059261798859),
        (0.18067227303981781, 0.18039216101169586, 0.18039216101169586),
        (0.18487395346164703, 0.18431372940540314, 0.18431372940540314),
        (0.18907563388347626, 0.18823529779911041, 0.18823529779911041),
        (0.19327731430530548, 0.19215686619281769, 0.19215686619281769),
        (0.1974789947271347, 0.19607843458652496, 0.19607843458652496),
        (0.20168067514896393, 0.20000000298023224, 0.20000000298023224),
        (0.20588235557079315, 0.20392157137393951, 0.20392157137393951),
        (0.21008403599262238, 0.20784313976764679, 0.20784313976764679),
        (0.2142857164144516, 0.21176470816135406, 0.21176470816135406),
        (0.21848739683628082, 0.21568627655506134, 0.21568627655506134),
        (0.22268907725811005, 0.22352941334247589, 0.22352941334247589),
        (0.22689075767993927, 0.22745098173618317, 0.22745098173618317),
        (0.23109243810176849, 0.23137255012989044, 0.23137255012989044),
        (0.23529411852359772, 0.23529411852359772, 0.23529411852359772),
        (0.23949579894542694, 0.23921568691730499, 0.23921568691730499),
        (0.24369747936725616, 0.24313725531101227, 0.24313725531101227),
        (0.24789915978908539, 0.24705882370471954, 0.24705882370471954),
        (0.25210085511207581, 0.25098040699958801, 0.25098040699958801),
        (0.25630253553390503, 0.25490197539329529, 0.25490197539329529),
        (0.26050421595573425, 0.25882354378700256, 0.25882354378700256),
        (0.26470589637756348, 0.26274511218070984, 0.26274511218070984),
        (0.2689075767993927, 0.26666668057441711, 0.26666668057441711),
        (0.27310925722122192, 0.27058824896812439, 0.27058824896812439),
        (0.27731093764305115, 0.27450981736183167, 0.27450981736183167),
        (0.28151261806488037, 0.27843138575553894, 0.27843138575553894),
        (0.28571429848670959, 0.28627452254295349, 0.28627452254295349),
        (0.28991597890853882, 0.29019609093666077, 0.29019609093666077),
        (0.29411765933036804, 0.29411765933036804, 0.29411765933036804),
        (0.29831933975219727, 0.29803922772407532, 0.29803922772407532),
        (0.30252102017402649, 0.30196079611778259, 0.30196079611778259),
        (0.30672270059585571, 0.30588236451148987, 0.30588236451148987),
        (0.31092438101768494, 0.30980393290519714, 0.30980393290519714),
        (0.31512606143951416, 0.31372550129890442, 0.31372550129890442),
        (0.31932774186134338, 0.31764706969261169, 0.31764706969261169),
        (0.32352942228317261, 0.32156863808631897, 0.32156863808631897),
        (0.32773110270500183, 0.32549020648002625, 0.32549020648002625),
        (0.33193278312683105, 0.32941177487373352, 0.32941177487373352),
        (0.33613446354866028, 0.3333333432674408, 0.3333333432674408),
        (0.3403361439704895, 0.33725491166114807, 0.33725491166114807),
        (0.34453782439231873, 0.34117648005485535, 0.34117648005485535),
        (0.34873950481414795, 0.3490196168422699, 0.3490196168422699),
        (0.35294118523597717, 0.35294118523597717, 0.35294118523597717),
        (0.3571428656578064, 0.35686275362968445, 0.35686275362968445),
        (0.36134454607963562, 0.36078432202339172, 0.36078432202339172),
        (0.36554622650146484, 0.364705890417099, 0.364705890417099),
        (0.36974790692329407, 0.36862745881080627, 0.36862745881080627),
        (0.37394958734512329, 0.37254902720451355, 0.37254902720451355),
        (0.37815126776695251, 0.37647059559822083, 0.37647059559822083),
        (0.38235294818878174, 0.3803921639919281, 0.3803921639919281),
        (0.38655462861061096, 0.38431373238563538, 0.38431373238563538),
        (0.39075630903244019, 0.38823530077934265, 0.38823530077934265),
        (0.39495798945426941, 0.39215686917304993, 0.39215686917304993),
        (0.39915966987609863, 0.3960784375667572, 0.3960784375667572),
        (0.40336135029792786, 0.40000000596046448, 0.40000000596046448),
        (0.40756303071975708, 0.40392157435417175, 0.40392157435417175),
        (0.4117647111415863, 0.4117647111415863, 0.4117647111415863),
        (0.41596639156341553, 0.41568627953529358, 0.41568627953529358),
        (0.42016807198524475, 0.41960784792900085, 0.41960784792900085),
        (0.42436975240707397, 0.42352941632270813, 0.42352941632270813),
        (0.4285714328289032, 0.42745098471641541, 0.42745098471641541),
        (0.43277311325073242, 0.43137255311012268, 0.43137255311012268),
        (0.43697479367256165, 0.43529412150382996, 0.43529412150382996),
        (0.44117647409439087, 0.43921568989753723, 0.43921568989753723),
        (0.44537815451622009, 0.44313725829124451, 0.44313725829124451),
        (0.44957983493804932, 0.44705882668495178, 0.44705882668495178),
        (0.45378151535987854, 0.45098039507865906, 0.45098039507865906),
        (0.45798319578170776, 0.45490196347236633, 0.45490196347236633),
        (0.46218487620353699, 0.45882353186607361, 0.45882353186607361),
        (0.46638655662536621, 0.46274510025978088, 0.46274510025978088),
        (0.47058823704719543, 0.46666666865348816, 0.46666666865348816),
        (0.47478991746902466, 0.47450980544090271, 0.47450980544090271),
        (0.47899159789085388, 0.47843137383460999, 0.47843137383460999),
        (0.48319327831268311, 0.48235294222831726, 0.48235294222831726),
        (0.48739495873451233, 0.48627451062202454, 0.48627451062202454),
        (0.49159663915634155, 0.49019607901573181, 0.49019607901573181),
        (0.49579831957817078, 0.49411764740943909, 0.49411764740943909),
        (0.5, 0.49803921580314636, 0.49803921580314636),
        (0.50420171022415161, 0.50196081399917603, 0.50196081399917603),
        (0.50840336084365845, 0.5058823823928833, 0.5058823823928833),
        (0.51260507106781006, 0.50980395078659058, 0.50980395078659058),
        (0.51680672168731689, 0.51372551918029785, 0.51372551918029785),
        (0.52100843191146851, 0.51764708757400513, 0.51764708757400513),
        (0.52521008253097534, 0.5215686559677124, 0.5215686559677124),
        (0.52941179275512695, 0.52549022436141968, 0.52549022436141968),
        (0.53361344337463379, 0.52941179275512695, 0.52941179275512695),
        (0.5378151535987854, 0.5372549295425415, 0.5372549295425415),
        (0.54201680421829224, 0.54117649793624878, 0.54117649793624878),
        (0.54621851444244385, 0.54509806632995605, 0.54509806632995605),
        (0.55042016506195068, 0.54901963472366333, 0.54901963472366333),
        (0.55462187528610229, 0.55294120311737061, 0.55294120311737061),
        (0.55882352590560913, 0.55686277151107788, 0.55686277151107788),
        (0.56302523612976074, 0.56078433990478516, 0.56078433990478516),
        (0.56722688674926758, 0.56470590829849243, 0.56470590829849243),
        (0.57142859697341919, 0.56862747669219971, 0.56862747669219971),
        (0.57563024759292603, 0.57254904508590698, 0.57254904508590698),
        (0.57983195781707764, 0.57647061347961426, 0.57647061347961426),
        (0.58403360843658447, 0.58039218187332153, 0.58039218187332153),
        (0.58823531866073608, 0.58431375026702881, 0.58431375026702881),
        (0.59243696928024292, 0.58823531866073608, 0.58823531866073608),
        (0.59663867950439453, 0.59215688705444336, 0.59215688705444336),
        (0.60084033012390137, 0.60000002384185791, 0.60000002384185791),
        (0.60504204034805298, 0.60392159223556519, 0.60392159223556519),
        (0.60924369096755981, 0.60784316062927246, 0.60784316062927246),
        (0.61344540119171143, 0.61176472902297974, 0.61176472902297974),
        (0.61764705181121826, 0.61568629741668701, 0.61568629741668701),
        (0.62184876203536987, 0.61960786581039429, 0.61960786581039429),
        (0.62605041265487671, 0.62352943420410156, 0.62352943420410156),
        (0.63025212287902832, 0.62745100259780884, 0.62745100259780884),
        (0.63445377349853516, 0.63137257099151611, 0.63137257099151611),
        (0.63865548372268677, 0.63529413938522339, 0.63529413938522339),
        (0.6428571343421936, 0.63921570777893066, 0.63921570777893066),
        (0.64705884456634521, 0.64313727617263794, 0.64313727617263794),
        (0.65126049518585205, 0.64705884456634521, 0.64705884456634521),
        (0.65546220541000366, 0.65098041296005249, 0.65098041296005249),
        (0.6596638560295105, 0.65490198135375977, 0.65490198135375977),
        (0.66386556625366211, 0.66274511814117432, 0.66274511814117432),
        (0.66806721687316895, 0.66666668653488159, 0.66666668653488159),
        (0.67226892709732056, 0.67058825492858887, 0.67058825492858887),
        (0.67647057771682739, 0.67450982332229614, 0.67450982332229614),
        (0.680672287940979, 0.67843139171600342, 0.67843139171600342),
        (0.68487393856048584, 0.68235296010971069, 0.68235296010971069),
        (0.68907564878463745, 0.68627452850341797, 0.68627452850341797),
        (0.69327729940414429, 0.69019609689712524, 0.69019609689712524),
        (0.6974790096282959, 0.69411766529083252, 0.69411766529083252),
        (0.70168066024780273, 0.69803923368453979, 0.69803923368453979),
        (0.70588237047195435, 0.70196080207824707, 0.70196080207824707),
        (0.71008402109146118, 0.70588237047195435, 0.70588237047195435),
        (0.71428573131561279, 0.70980393886566162, 0.70980393886566162),
        (0.71848738193511963, 0.7137255072593689, 0.7137255072593689),
        (0.72268909215927124, 0.71764707565307617, 0.71764707565307617),
        (0.72689074277877808, 0.72549021244049072, 0.72549021244049072),
        (0.73109245300292969, 0.729411780834198, 0.729411780834198),
        (0.73529410362243652, 0.73333334922790527, 0.73333334922790527),
        (0.73949581384658813, 0.73725491762161255, 0.73725491762161255),
        (0.74369746446609497, 0.74117648601531982, 0.74117648601531982),
        (0.74789917469024658, 0.7450980544090271, 0.7450980544090271),
        (0.75210082530975342, 0.74901962280273438, 0.74901962280273438),
        (0.75630253553390503, 0.75294119119644165, 0.75294119119644165),
        (0.76050418615341187, 0.75686275959014893, 0.75686275959014893),
        (0.76470589637756348, 0.7607843279838562, 0.7607843279838562),
        (0.76890754699707031, 0.76470589637756348, 0.76470589637756348),
        (0.77310925722122192, 0.76862746477127075, 0.76862746477127075),
        (0.77731090784072876, 0.77254903316497803, 0.77254903316497803),
        (0.78151261806488037, 0.7764706015586853, 0.7764706015586853),
        (0.78571426868438721, 0.78039216995239258, 0.78039216995239258),
        (0.78991597890853882, 0.78823530673980713, 0.78823530673980713),
        (0.79411762952804565, 0.7921568751335144, 0.7921568751335144),
        (0.79831933975219727, 0.79607844352722168, 0.79607844352722168),
        (0.8025209903717041, 0.80000001192092896, 0.80000001192092896),
        (0.80672270059585571, 0.80392158031463623, 0.80392158031463623),
        (0.81092435121536255, 0.80784314870834351, 0.80784314870834351),
        (0.81512606143951416, 0.81176471710205078, 0.81176471710205078),
        (0.819327712059021, 0.81568628549575806, 0.81568628549575806),
        (0.82352942228317261, 0.81960785388946533, 0.81960785388946533),
        (0.82773107290267944, 0.82352942228317261, 0.82352942228317261),
        (0.83193278312683105, 0.82745099067687988, 0.82745099067687988),
        (0.83613443374633789, 0.83137255907058716, 0.83137255907058716),
        (0.8403361439704895, 0.83529412746429443, 0.83529412746429443),
        (0.84453779458999634, 0.83921569585800171, 0.83921569585800171),
        (0.84873950481414795, 0.84313726425170898, 0.84313726425170898),
        (0.85294115543365479, 0.85098040103912354, 0.85098040103912354),
        (0.8571428656578064, 0.85490196943283081, 0.85490196943283081),
        (0.86134451627731323, 0.85882353782653809, 0.85882353782653809),
        (0.86554622650146484, 0.86274510622024536, 0.86274510622024536),
        (0.86974787712097168, 0.86666667461395264, 0.86666667461395264),
        (0.87394958734512329, 0.87058824300765991, 0.87058824300765991),
        (0.87815123796463013, 0.87450981140136719, 0.87450981140136719),
        (0.88235294818878174, 0.87843137979507446, 0.87843137979507446),
        (0.88655459880828857, 0.88235294818878174, 0.88235294818878174),
        (0.89075630903244019, 0.88627451658248901, 0.88627451658248901),
        (0.89495795965194702, 0.89019608497619629, 0.89019608497619629),
        (0.89915966987609863, 0.89411765336990356, 0.89411765336990356),
        (0.90336132049560547, 0.89803922176361084, 0.89803922176361084),
        (0.90756303071975708, 0.90196079015731812, 0.90196079015731812),
        (0.91176468133926392, 0.90588235855102539, 0.90588235855102539),
        (0.91596639156341553, 0.91372549533843994, 0.91372549533843994),
        (0.92016804218292236, 0.91764706373214722, 0.91764706373214722),
        (0.92436975240707397, 0.92156863212585449, 0.92156863212585449),
        (0.92857140302658081, 0.92549020051956177, 0.92549020051956177),
        (0.93277311325073242, 0.92941176891326904, 0.92941176891326904),
        (0.93697476387023926, 0.93333333730697632, 0.93333333730697632),
        (0.94117647409439087, 0.93725490570068359, 0.93725490570068359),
        (0.94537812471389771, 0.94117647409439087, 0.94117647409439087),
        (0.94957983493804932, 0.94509804248809814, 0.94509804248809814),
        (0.95378148555755615, 0.94901961088180542, 0.94901961088180542),
        (0.95798319578170776, 0.9529411792755127, 0.9529411792755127),
        (0.9621848464012146, 0.95686274766921997, 0.95686274766921997),
        (0.96638655662536621, 0.96078431606292725, 0.96078431606292725),
        (0.97058820724487305, 0.96470588445663452, 0.96470588445663452),
        (0.97478991746902466, 0.9686274528503418, 0.9686274528503418),
        (0.97899156808853149, 0.97647058963775635, 0.97647058963775635),
        (0.98319327831268311, 0.98039215803146362, 0.98039215803146362),
        (0.98739492893218994, 0.9843137264251709, 0.9843137264251709),
        (0.99159663915634155, 0.98823529481887817, 0.98823529481887817),
        (0.99579828977584839, 0.99215686321258545, 0.99215686321258545),
        (1.0, 0.99607843160629272, 0.99607843160629272),
    ],
}
_gist_heat_data = {
    "blue": [
        (0.0, 0.0, 0.0),
        (0.0042016808874905109, 0.0, 0.0),
        (0.0084033617749810219, 0.0, 0.0),
        (0.012605042196810246, 0.0, 0.0),
        (0.016806723549962044, 0.0, 0.0),
        (0.021008403971791267, 0.0, 0.0),
        (0.025210084393620491, 0.0, 0.0),
        (0.029411764815449715, 0.0, 0.0),
        (0.033613447099924088, 0.0, 0.0),
        (0.037815127521753311, 0.0, 0.0),
        (0.042016807943582535, 0.0, 0.0),
        (0.046218488365411758, 0.0, 0.0),
        (0.050420168787240982, 0.0, 0.0),
        (0.054621849209070206, 0.0, 0.0),
        (0.058823529630899429, 0.0, 0.0),
        (0.063025213778018951, 0.0, 0.0),
        (0.067226894199848175, 0.0, 0.0),
        (0.071428574621677399, 0.0, 0.0),
        (0.075630255043506622, 0.0, 0.0),
        (0.079831935465335846, 0.0, 0.0),
        (0.08403361588716507, 0.0, 0.0),
        (0.088235296308994293, 0.0, 0.0),
        (0.092436976730823517, 0.0, 0.0),
        (0.09663865715265274, 0.0, 0.0),
        (0.10084033757448196, 0.0, 0.0),
        (0.10504201799631119, 0.0, 0.0),
        (0.10924369841814041, 0.0, 0.0),
        (0.11344537883996964, 0.0, 0.0),
        (0.11764705926179886, 0.0, 0.0),
        (0.12184873968362808, 0.0, 0.0),
        (0.1260504275560379, 0.0, 0.0),
        (0.13025210797786713, 0.0, 0.0),
        (0.13445378839969635, 0.0, 0.0),
        (0.13865546882152557, 0.0, 0.0),
        (0.1428571492433548, 0.0, 0.0),
        (0.14705882966518402, 0.0, 0.0),
        (0.15126051008701324, 0.0, 0.0),
        (0.15546219050884247, 0.0, 0.0),
        (0.15966387093067169, 0.0, 0.0),
        (0.16386555135250092, 0.0, 0.0),
        (0.16806723177433014, 0.0, 0.0),
        (0.17226891219615936, 0.0, 0.0),
        (0.17647059261798859, 0.0, 0.0),
        (0.18067227303981781, 0.0, 0.0),
        (0.18487395346164703, 0.0, 0.0),
        (0.18907563388347626, 0.0, 0.0),
        (0.19327731430530548, 0.0, 0.0),
        (0.1974789947271347, 0.0, 0.0),
        (0.20168067514896393, 0.0, 0.0),
        (0.20588235557079315, 0.0, 0.0),
        (0.21008403599262238, 0.0, 0.0),
        (0.2142857164144516, 0.0, 0.0),
        (0.21848739683628082, 0.0, 0.0),
        (0.22268907725811005, 0.0, 0.0),
        (0.22689075767993927, 0.0, 0.0),
        (0.23109243810176849, 0.0, 0.0),
        (0.23529411852359772, 0.0, 0.0),
        (0.23949579894542694, 0.0, 0.0),
        (0.24369747936725616, 0.0, 0.0),
        (0.24789915978908539, 0.0, 0.0),
        (0.25210085511207581, 0.0, 0.0),
        (0.25630253553390503, 0.0, 0.0),
        (0.26050421595573425, 0.0, 0.0),
        (0.26470589637756348, 0.0, 0.0),
        (0.2689075767993927, 0.0, 0.0),
        (0.27310925722122192, 0.0, 0.0),
        (0.27731093764305115, 0.0, 0.0),
        (0.28151261806488037, 0.0, 0.0),
        (0.28571429848670959, 0.0, 0.0),
        (0.28991597890853882, 0.0, 0.0),
        (0.29411765933036804, 0.0, 0.0),
        (0.29831933975219727, 0.0, 0.0),
        (0.30252102017402649, 0.0, 0.0),
        (0.30672270059585571, 0.0, 0.0),
        (0.31092438101768494, 0.0, 0.0),
        (0.31512606143951416, 0.0, 0.0),
        (0.31932774186134338, 0.0, 0.0),
        (0.32352942228317261, 0.0, 0.0),
        (0.32773110270500183, 0.0, 0.0),
        (0.33193278312683105, 0.0, 0.0),
        (0.33613446354866028, 0.0, 0.0),
        (0.3403361439704895, 0.0, 0.0),
        (0.34453782439231873, 0.0, 0.0),
        (0.34873950481414795, 0.0, 0.0),
        (0.35294118523597717, 0.0, 0.0),
        (0.3571428656578064, 0.0, 0.0),
        (0.36134454607963562, 0.0, 0.0),
        (0.36554622650146484, 0.0, 0.0),
        (0.36974790692329407, 0.0, 0.0),
        (0.37394958734512329, 0.0, 0.0),
        (0.37815126776695251, 0.0, 0.0),
        (0.38235294818878174, 0.0, 0.0),
        (0.38655462861061096, 0.0, 0.0),
        (0.39075630903244019, 0.0, 0.0),
        (0.39495798945426941, 0.0, 0.0),
        (0.39915966987609863, 0.0, 0.0),
        (0.40336135029792786, 0.0, 0.0),
        (0.40756303071975708, 0.0, 0.0),
        (0.4117647111415863, 0.0, 0.0),
        (0.41596639156341553, 0.0, 0.0),
        (0.42016807198524475, 0.0, 0.0),
        (0.42436975240707397, 0.0, 0.0),
        (0.4285714328289032, 0.0, 0.0),
        (0.43277311325073242, 0.0, 0.0),
        (0.43697479367256165, 0.0, 0.0),
        (0.44117647409439087, 0.0, 0.0),
        (0.44537815451622009, 0.0, 0.0),
        (0.44957983493804932, 0.0, 0.0),
        (0.45378151535987854, 0.0, 0.0),
        (0.45798319578170776, 0.0, 0.0),
        (0.46218487620353699, 0.0, 0.0),
        (0.46638655662536621, 0.0, 0.0),
        (0.47058823704719543, 0.0, 0.0),
        (0.47478991746902466, 0.0, 0.0),
        (0.47899159789085388, 0.0, 0.0),
        (0.48319327831268311, 0.0, 0.0),
        (0.48739495873451233, 0.0, 0.0),
        (0.49159663915634155, 0.0, 0.0),
        (0.49579831957817078, 0.0, 0.0),
        (0.5, 0.0, 0.0),
        (0.50420171022415161, 0.0, 0.0),
        (0.50840336084365845, 0.0, 0.0),
        (0.51260507106781006, 0.0, 0.0),
        (0.51680672168731689, 0.0, 0.0),
        (0.52100843191146851, 0.0, 0.0),
        (0.52521008253097534, 0.0, 0.0),
        (0.52941179275512695, 0.0, 0.0),
        (0.53361344337463379, 0.0, 0.0),
        (0.5378151535987854, 0.0, 0.0),
        (0.54201680421829224, 0.0, 0.0),
        (0.54621851444244385, 0.0, 0.0),
        (0.55042016506195068, 0.0, 0.0),
        (0.55462187528610229, 0.0, 0.0),
        (0.55882352590560913, 0.0, 0.0),
        (0.56302523612976074, 0.0, 0.0),
        (0.56722688674926758, 0.0, 0.0),
        (0.57142859697341919, 0.0, 0.0),
        (0.57563024759292603, 0.0, 0.0),
        (0.57983195781707764, 0.0, 0.0),
        (0.58403360843658447, 0.0, 0.0),
        (0.58823531866073608, 0.0, 0.0),
        (0.59243696928024292, 0.0, 0.0),
        (0.59663867950439453, 0.0, 0.0),
        (0.60084033012390137, 0.0, 0.0),
        (0.60504204034805298, 0.0, 0.0),
        (0.60924369096755981, 0.0, 0.0),
        (0.61344540119171143, 0.0, 0.0),
        (0.61764705181121826, 0.0, 0.0),
        (0.62184876203536987, 0.0, 0.0),
        (0.62605041265487671, 0.0, 0.0),
        (0.63025212287902832, 0.0, 0.0),
        (0.63445377349853516, 0.0, 0.0),
        (0.63865548372268677, 0.0, 0.0),
        (0.6428571343421936, 0.0, 0.0),
        (0.64705884456634521, 0.0, 0.0),
        (0.65126049518585205, 0.0, 0.0),
        (0.65546220541000366, 0.0, 0.0),
        (0.6596638560295105, 0.0, 0.0),
        (0.66386556625366211, 0.0, 0.0),
        (0.66806721687316895, 0.0, 0.0),
        (0.67226892709732056, 0.0, 0.0),
        (0.67647057771682739, 0.0, 0.0),
        (0.680672287940979, 0.0, 0.0),
        (0.68487393856048584, 0.0, 0.0),
        (0.68907564878463745, 0.0, 0.0),
        (0.69327729940414429, 0.0, 0.0),
        (0.6974790096282959, 0.0, 0.0),
        (0.70168066024780273, 0.0, 0.0),
        (0.70588237047195435, 0.0, 0.0),
        (0.71008402109146118, 0.0, 0.0),
        (0.71428573131561279, 0.0, 0.0),
        (0.71848738193511963, 0.0, 0.0),
        (0.72268909215927124, 0.0, 0.0),
        (0.72689074277877808, 0.0, 0.0),
        (0.73109245300292969, 0.0, 0.0),
        (0.73529410362243652, 0.0, 0.0),
        (0.73949581384658813, 0.0, 0.0),
        (0.74369746446609497, 0.0, 0.0),
        (0.74789917469024658, 0.0, 0.0),
        (0.75210082530975342, 0.0, 0.0),
        (0.75630253553390503, 0.027450980618596077, 0.027450980618596077),
        (0.76050418615341187, 0.043137256056070328, 0.043137256056070328),
        (0.76470589637756348, 0.058823529630899429, 0.058823529630899429),
        (0.76890754699707031, 0.074509806931018829, 0.074509806931018829),
        (0.77310925722122192, 0.090196080505847931, 0.090196080505847931),
        (0.77731090784072876, 0.10588235408067703, 0.10588235408067703),
        (0.78151261806488037, 0.12156862765550613, 0.12156862765550613),
        (0.78571426868438721, 0.13725490868091583, 0.13725490868091583),
        (0.78991597890853882, 0.15294118225574493, 0.15294118225574493),
        (0.79411762952804565, 0.16862745583057404, 0.16862745583057404),
        (0.79831933975219727, 0.20000000298023224, 0.20000000298023224),
        (0.8025209903717041, 0.21176470816135406, 0.21176470816135406),
        (0.80672270059585571, 0.22745098173618317, 0.22745098173618317),
        (0.81092435121536255, 0.24313725531101227, 0.24313725531101227),
        (0.81512606143951416, 0.25882354378700256, 0.25882354378700256),
        (0.819327712059021, 0.27450981736183167, 0.27450981736183167),
        (0.82352942228317261, 0.29019609093666077, 0.29019609093666077),
        (0.82773107290267944, 0.30588236451148987, 0.30588236451148987),
        (0.83193278312683105, 0.32156863808631897, 0.32156863808631897),
        (0.83613443374633789, 0.33725491166114807, 0.33725491166114807),
        (0.8403361439704895, 0.35294118523597717, 0.35294118523597717),
        (0.84453779458999634, 0.36862745881080627, 0.36862745881080627),
        (0.84873950481414795, 0.38431373238563538, 0.38431373238563538),
        (0.85294115543365479, 0.40000000596046448, 0.40000000596046448),
        (0.8571428656578064, 0.4117647111415863, 0.4117647111415863),
        (0.86134451627731323, 0.42745098471641541, 0.42745098471641541),
        (0.86554622650146484, 0.44313725829124451, 0.44313725829124451),
        (0.86974787712097168, 0.45882353186607361, 0.45882353186607361),
        (0.87394958734512329, 0.47450980544090271, 0.47450980544090271),
        (0.87815123796463013, 0.49019607901573181, 0.49019607901573181),
        (0.88235294818878174, 0.5215686559677124, 0.5215686559677124),
        (0.88655459880828857, 0.5372549295425415, 0.5372549295425415),
        (0.89075630903244019, 0.55294120311737061, 0.55294120311737061),
        (0.89495795965194702, 0.56862747669219971, 0.56862747669219971),
        (0.89915966987609863, 0.58431375026702881, 0.58431375026702881),
        (0.90336132049560547, 0.60000002384185791, 0.60000002384185791),
        (0.90756303071975708, 0.61176472902297974, 0.61176472902297974),
        (0.91176468133926392, 0.62745100259780884, 0.62745100259780884),
        (0.91596639156341553, 0.64313727617263794, 0.64313727617263794),
        (0.92016804218292236, 0.65882354974746704, 0.65882354974746704),
        (0.92436975240707397, 0.67450982332229614, 0.67450982332229614),
        (0.92857140302658081, 0.69019609689712524, 0.69019609689712524),
        (0.93277311325073242, 0.70588237047195435, 0.70588237047195435),
        (0.93697476387023926, 0.72156864404678345, 0.72156864404678345),
        (0.94117647409439087, 0.73725491762161255, 0.73725491762161255),
        (0.94537812471389771, 0.75294119119644165, 0.75294119119644165),
        (0.94957983493804932, 0.76862746477127075, 0.76862746477127075),
        (0.95378148555755615, 0.78431373834609985, 0.78431373834609985),
        (0.95798319578170776, 0.80000001192092896, 0.80000001192092896),
        (0.9621848464012146, 0.81176471710205078, 0.81176471710205078),
        (0.96638655662536621, 0.84313726425170898, 0.84313726425170898),
        (0.97058820724487305, 0.85882353782653809, 0.85882353782653809),
        (0.97478991746902466, 0.87450981140136719, 0.87450981140136719),
        (0.97899156808853149, 0.89019608497619629, 0.89019608497619629),
        (0.98319327831268311, 0.90588235855102539, 0.90588235855102539),
        (0.98739492893218994, 0.92156863212585449, 0.92156863212585449),
        (0.99159663915634155, 0.93725490570068359, 0.93725490570068359),
        (0.99579828977584839, 0.9529411792755127, 0.9529411792755127),
        (1.0, 0.9686274528503418, 0.9686274528503418),
    ],
    "green": [
        (0.0, 0.0, 0.0),
        (0.0042016808874905109, 0.0, 0.0),
        (0.0084033617749810219, 0.0, 0.0),
        (0.012605042196810246, 0.0, 0.0),
        (0.016806723549962044, 0.0, 0.0),
        (0.021008403971791267, 0.0, 0.0),
        (0.025210084393620491, 0.0, 0.0),
        (0.029411764815449715, 0.0, 0.0),
        (0.033613447099924088, 0.0, 0.0),
        (0.037815127521753311, 0.0, 0.0),
        (0.042016807943582535, 0.0, 0.0),
        (0.046218488365411758, 0.0, 0.0),
        (0.050420168787240982, 0.0, 0.0),
        (0.054621849209070206, 0.0, 0.0),
        (0.058823529630899429, 0.0, 0.0),
        (0.063025213778018951, 0.0, 0.0),
        (0.067226894199848175, 0.0, 0.0),
        (0.071428574621677399, 0.0, 0.0),
        (0.075630255043506622, 0.0, 0.0),
        (0.079831935465335846, 0.0, 0.0),
        (0.08403361588716507, 0.0, 0.0),
        (0.088235296308994293, 0.0, 0.0),
        (0.092436976730823517, 0.0, 0.0),
        (0.09663865715265274, 0.0, 0.0),
        (0.10084033757448196, 0.0, 0.0),
        (0.10504201799631119, 0.0, 0.0),
        (0.10924369841814041, 0.0, 0.0),
        (0.11344537883996964, 0.0, 0.0),
        (0.11764705926179886, 0.0, 0.0),
        (0.12184873968362808, 0.0, 0.0),
        (0.1260504275560379, 0.0, 0.0),
        (0.13025210797786713, 0.0, 0.0),
        (0.13445378839969635, 0.0, 0.0),
        (0.13865546882152557, 0.0, 0.0),
        (0.1428571492433548, 0.0, 0.0),
        (0.14705882966518402, 0.0, 0.0),
        (0.15126051008701324, 0.0, 0.0),
        (0.15546219050884247, 0.0, 0.0),
        (0.15966387093067169, 0.0, 0.0),
        (0.16386555135250092, 0.0, 0.0),
        (0.16806723177433014, 0.0, 0.0),
        (0.17226891219615936, 0.0, 0.0),
        (0.17647059261798859, 0.0, 0.0),
        (0.18067227303981781, 0.0, 0.0),
        (0.18487395346164703, 0.0, 0.0),
        (0.18907563388347626, 0.0, 0.0),
        (0.19327731430530548, 0.0, 0.0),
        (0.1974789947271347, 0.0, 0.0),
        (0.20168067514896393, 0.0, 0.0),
        (0.20588235557079315, 0.0, 0.0),
        (0.21008403599262238, 0.0, 0.0),
        (0.2142857164144516, 0.0, 0.0),
        (0.21848739683628082, 0.0, 0.0),
        (0.22268907725811005, 0.0, 0.0),
        (0.22689075767993927, 0.0, 0.0),
        (0.23109243810176849, 0.0, 0.0),
        (0.23529411852359772, 0.0, 0.0),
        (0.23949579894542694, 0.0, 0.0),
        (0.24369747936725616, 0.0, 0.0),
        (0.24789915978908539, 0.0, 0.0),
        (0.25210085511207581, 0.0, 0.0),
        (0.25630253553390503, 0.0, 0.0),
        (0.26050421595573425, 0.0, 0.0),
        (0.26470589637756348, 0.0, 0.0),
        (0.2689075767993927, 0.0, 0.0),
        (0.27310925722122192, 0.0, 0.0),
        (0.27731093764305115, 0.0, 0.0),
        (0.28151261806488037, 0.0, 0.0),
        (0.28571429848670959, 0.0, 0.0),
        (0.28991597890853882, 0.0, 0.0),
        (0.29411765933036804, 0.0, 0.0),
        (0.29831933975219727, 0.0, 0.0),
        (0.30252102017402649, 0.0, 0.0),
        (0.30672270059585571, 0.0, 0.0),
        (0.31092438101768494, 0.0, 0.0),
        (0.31512606143951416, 0.0, 0.0),
        (0.31932774186134338, 0.0, 0.0),
        (0.32352942228317261, 0.0, 0.0),
        (0.32773110270500183, 0.0, 0.0),
        (0.33193278312683105, 0.0, 0.0),
        (0.33613446354866028, 0.0, 0.0),
        (0.3403361439704895, 0.0, 0.0),
        (0.34453782439231873, 0.0, 0.0),
        (0.34873950481414795, 0.0, 0.0),
        (0.35294118523597717, 0.0, 0.0),
        (0.3571428656578064, 0.0, 0.0),
        (0.36134454607963562, 0.0, 0.0),
        (0.36554622650146484, 0.0, 0.0),
        (0.36974790692329407, 0.0, 0.0),
        (0.37394958734512329, 0.0, 0.0),
        (0.37815126776695251, 0.0, 0.0),
        (0.38235294818878174, 0.0, 0.0),
        (0.38655462861061096, 0.0, 0.0),
        (0.39075630903244019, 0.0, 0.0),
        (0.39495798945426941, 0.0, 0.0),
        (0.39915966987609863, 0.0, 0.0),
        (0.40336135029792786, 0.0, 0.0),
        (0.40756303071975708, 0.0, 0.0),
        (0.4117647111415863, 0.0, 0.0),
        (0.41596639156341553, 0.0, 0.0),
        (0.42016807198524475, 0.0, 0.0),
        (0.42436975240707397, 0.0, 0.0),
        (0.4285714328289032, 0.0, 0.0),
        (0.43277311325073242, 0.0, 0.0),
        (0.43697479367256165, 0.0, 0.0),
        (0.44117647409439087, 0.0, 0.0),
        (0.44537815451622009, 0.0, 0.0),
        (0.44957983493804932, 0.0, 0.0),
        (0.45378151535987854, 0.0, 0.0),
        (0.45798319578170776, 0.0, 0.0),
        (0.46218487620353699, 0.0, 0.0),
        (0.46638655662536621, 0.0, 0.0),
        (0.47058823704719543, 0.0, 0.0),
        (0.47478991746902466, 0.0, 0.0),
        (0.47899159789085388, 0.0039215688593685627, 0.0039215688593685627),
        (0.48319327831268311, 0.011764706112444401, 0.011764706112444401),
        (0.48739495873451233, 0.019607843831181526, 0.019607843831181526),
        (0.49159663915634155, 0.027450980618596077, 0.027450980618596077),
        (0.49579831957817078, 0.035294119268655777, 0.035294119268655777),
        (0.5, 0.043137256056070328, 0.043137256056070328),
        (0.50420171022415161, 0.058823529630899429, 0.058823529630899429),
        (0.50840336084365845, 0.066666670143604279, 0.066666670143604279),
        (0.51260507106781006, 0.070588238537311554, 0.070588238537311554),
        (0.51680672168731689, 0.078431375324726105, 0.078431375324726105),
        (0.52100843191146851, 0.086274512112140656, 0.086274512112140656),
        (0.52521008253097534, 0.094117648899555206, 0.094117648899555206),
        (0.52941179275512695, 0.10196078568696976, 0.10196078568696976),
        (0.53361344337463379, 0.10980392247438431, 0.10980392247438431),
        (0.5378151535987854, 0.11764705926179886, 0.11764705926179886),
        (0.54201680421829224, 0.12549020349979401, 0.12549020349979401),
        (0.54621851444244385, 0.13725490868091583, 0.13725490868091583),
        (0.55042016506195068, 0.14509804546833038, 0.14509804546833038),
        (0.55462187528610229, 0.15294118225574493, 0.15294118225574493),
        (0.55882352590560913, 0.16078431904315948, 0.16078431904315948),
        (0.56302523612976074, 0.16862745583057404, 0.16862745583057404),
        (0.56722688674926758, 0.17647059261798859, 0.17647059261798859),
        (0.57142859697341919, 0.18431372940540314, 0.18431372940540314),
        (0.57563024759292603, 0.19215686619281769, 0.19215686619281769),
        (0.57983195781707764, 0.20000000298023224, 0.20000000298023224),
        (0.58403360843658447, 0.20392157137393951, 0.20392157137393951),
        (0.58823531866073608, 0.21176470816135406, 0.21176470816135406),
        (0.59243696928024292, 0.21960784494876862, 0.21960784494876862),
        (0.59663867950439453, 0.22745098173618317, 0.22745098173618317),
        (0.60084033012390137, 0.23529411852359772, 0.23529411852359772),
        (0.60504204034805298, 0.24313725531101227, 0.24313725531101227),
        (0.60924369096755981, 0.25098040699958801, 0.25098040699958801),
        (0.61344540119171143, 0.25882354378700256, 0.25882354378700256),
        (0.61764705181121826, 0.26666668057441711, 0.26666668057441711),
        (0.62184876203536987, 0.27058824896812439, 0.27058824896812439),
        (0.62605041265487671, 0.27843138575553894, 0.27843138575553894),
        (0.63025212287902832, 0.29411765933036804, 0.29411765933036804),
        (0.63445377349853516, 0.30196079611778259, 0.30196079611778259),
        (0.63865548372268677, 0.30980393290519714, 0.30980393290519714),
        (0.6428571343421936, 0.31764706969261169, 0.31764706969261169),
        (0.64705884456634521, 0.32549020648002625, 0.32549020648002625),
        (0.65126049518585205, 0.3333333432674408, 0.3333333432674408),
        (0.65546220541000366, 0.33725491166114807, 0.33725491166114807),
        (0.6596638560295105, 0.34509804844856262, 0.34509804844856262),
        (0.66386556625366211, 0.35294118523597717, 0.35294118523597717),
        (0.66806721687316895, 0.36078432202339172, 0.36078432202339172),
        (0.67226892709732056, 0.36862745881080627, 0.36862745881080627),
        (0.67647057771682739, 0.37647059559822083, 0.37647059559822083),
        (0.680672287940979, 0.38431373238563538, 0.38431373238563538),
        (0.68487393856048584, 0.39215686917304993, 0.39215686917304993),
        (0.68907564878463745, 0.40000000596046448, 0.40000000596046448),
        (0.69327729940414429, 0.40392157435417175, 0.40392157435417175),
        (0.6974790096282959, 0.4117647111415863, 0.4117647111415863),
        (0.70168066024780273, 0.41960784792900085, 0.41960784792900085),
        (0.70588237047195435, 0.42745098471641541, 0.42745098471641541),
        (0.71008402109146118, 0.43529412150382996, 0.43529412150382996),
        (0.71428573131561279, 0.45098039507865906, 0.45098039507865906),
        (0.71848738193511963, 0.45882353186607361, 0.45882353186607361),
        (0.72268909215927124, 0.46666666865348816, 0.46666666865348816),
        (0.72689074277877808, 0.47058823704719543, 0.47058823704719543),
        (0.73109245300292969, 0.47843137383460999, 0.47843137383460999),
        (0.73529410362243652, 0.48627451062202454, 0.48627451062202454),
        (0.73949581384658813, 0.49411764740943909, 0.49411764740943909),
        (0.74369746446609497, 0.50196081399917603, 0.50196081399917603),
        (0.74789917469024658, 0.50980395078659058, 0.50980395078659058),
        (0.75210082530975342, 0.51764708757400513, 0.51764708757400513),
        (0.75630253553390503, 0.53333336114883423, 0.53333336114883423),
        (0.76050418615341187, 0.5372549295425415, 0.5372549295425415),
        (0.76470589637756348, 0.54509806632995605, 0.54509806632995605),
        (0.76890754699707031, 0.55294120311737061, 0.55294120311737061),
        (0.77310925722122192, 0.56078433990478516, 0.56078433990478516),
        (0.77731090784072876, 0.56862747669219971, 0.56862747669219971),
        (0.78151261806488037, 0.57647061347961426, 0.57647061347961426),
        (0.78571426868438721, 0.58431375026702881, 0.58431375026702881),
        (0.78991597890853882, 0.59215688705444336, 0.59215688705444336),
        (0.79411762952804565, 0.60000002384185791, 0.60000002384185791),
        (0.79831933975219727, 0.61176472902297974, 0.61176472902297974),
        (0.8025209903717041, 0.61960786581039429, 0.61960786581039429),
        (0.80672270059585571, 0.62745100259780884, 0.62745100259780884),
        (0.81092435121536255, 0.63529413938522339, 0.63529413938522339),
        (0.81512606143951416, 0.64313727617263794, 0.64313727617263794),
        (0.819327712059021, 0.65098041296005249, 0.65098041296005249),
        (0.82352942228317261, 0.65882354974746704, 0.65882354974746704),
        (0.82773107290267944, 0.66666668653488159, 0.66666668653488159),
        (0.83193278312683105, 0.67058825492858887, 0.67058825492858887),
        (0.83613443374633789, 0.67843139171600342, 0.67843139171600342),
        (0.8403361439704895, 0.68627452850341797, 0.68627452850341797),
        (0.84453779458999634, 0.69411766529083252, 0.69411766529083252),
        (0.84873950481414795, 0.70196080207824707, 0.70196080207824707),
        (0.85294115543365479, 0.70980393886566162, 0.70980393886566162),
        (0.8571428656578064, 0.71764707565307617, 0.71764707565307617),
        (0.86134451627731323, 0.72549021244049072, 0.72549021244049072),
        (0.86554622650146484, 0.73333334922790527, 0.73333334922790527),
        (0.86974787712097168, 0.73725491762161255, 0.73725491762161255),
        (0.87394958734512329, 0.7450980544090271, 0.7450980544090271),
        (0.87815123796463013, 0.75294119119644165, 0.75294119119644165),
        (0.88235294818878174, 0.76862746477127075, 0.76862746477127075),
        (0.88655459880828857, 0.7764706015586853, 0.7764706015586853),
        (0.89075630903244019, 0.78431373834609985, 0.78431373834609985),
        (0.89495795965194702, 0.7921568751335144, 0.7921568751335144),
        (0.89915966987609863, 0.80000001192092896, 0.80000001192092896),
        (0.90336132049560547, 0.80392158031463623, 0.80392158031463623),
        (0.90756303071975708, 0.81176471710205078, 0.81176471710205078),
        (0.91176468133926392, 0.81960785388946533, 0.81960785388946533),
        (0.91596639156341553, 0.82745099067687988, 0.82745099067687988),
        (0.92016804218292236, 0.83529412746429443, 0.83529412746429443),
        (0.92436975240707397, 0.84313726425170898, 0.84313726425170898),
        (0.92857140302658081, 0.85098040103912354, 0.85098040103912354),
        (0.93277311325073242, 0.85882353782653809, 0.85882353782653809),
        (0.93697476387023926, 0.86666667461395264, 0.86666667461395264),
        (0.94117647409439087, 0.87058824300765991, 0.87058824300765991),
        (0.94537812471389771, 0.87843137979507446, 0.87843137979507446),
        (0.94957983493804932, 0.88627451658248901, 0.88627451658248901),
        (0.95378148555755615, 0.89411765336990356, 0.89411765336990356),
        (0.95798319578170776, 0.90196079015731812, 0.90196079015731812),
        (0.9621848464012146, 0.90980392694473267, 0.90980392694473267),
        (0.96638655662536621, 0.92549020051956177, 0.92549020051956177),
        (0.97058820724487305, 0.93333333730697632, 0.93333333730697632),
        (0.97478991746902466, 0.93725490570068359, 0.93725490570068359),
        (0.97899156808853149, 0.94509804248809814, 0.94509804248809814),
        (0.98319327831268311, 0.9529411792755127, 0.9529411792755127),
        (0.98739492893218994, 0.96078431606292725, 0.96078431606292725),
        (0.99159663915634155, 0.9686274528503418, 0.9686274528503418),
        (0.99579828977584839, 0.97647058963775635, 0.97647058963775635),
        (1.0, 0.9843137264251709, 0.9843137264251709),
    ],
    "red": [
        (0.0, 0.0, 0.0),
        (0.0042016808874905109, 0.0039215688593685627, 0.0039215688593685627),
        (0.0084033617749810219, 0.0078431377187371254, 0.0078431377187371254),
        (0.012605042196810246, 0.015686275437474251, 0.015686275437474251),
        (0.016806723549962044, 0.019607843831181526, 0.019607843831181526),
        (0.021008403971791267, 0.027450980618596077, 0.027450980618596077),
        (0.025210084393620491, 0.031372550874948502, 0.031372550874948502),
        (0.029411764815449715, 0.039215687662363052, 0.039215687662363052),
        (0.033613447099924088, 0.043137256056070328, 0.043137256056070328),
        (0.037815127521753311, 0.050980392843484879, 0.050980392843484879),
        (0.042016807943582535, 0.058823529630899429, 0.058823529630899429),
        (0.046218488365411758, 0.066666670143604279, 0.066666670143604279),
        (0.050420168787240982, 0.070588238537311554, 0.070588238537311554),
        (0.054621849209070206, 0.078431375324726105, 0.078431375324726105),
        (0.058823529630899429, 0.08235294371843338, 0.08235294371843338),
        (0.063025213778018951, 0.090196080505847931, 0.090196080505847931),
        (0.067226894199848175, 0.094117648899555206, 0.094117648899555206),
        (0.071428574621677399, 0.10196078568696976, 0.10196078568696976),
        (0.075630255043506622, 0.10588235408067703, 0.10588235408067703),
        (0.079831935465335846, 0.10980392247438431, 0.10980392247438431),
        (0.08403361588716507, 0.11764705926179886, 0.11764705926179886),
        (0.088235296308994293, 0.12156862765550613, 0.12156862765550613),
        (0.092436976730823517, 0.12941177189350128, 0.12941177189350128),
        (0.09663865715265274, 0.13333334028720856, 0.13333334028720856),
        (0.10084033757448196, 0.14117647707462311, 0.14117647707462311),
        (0.10504201799631119, 0.14509804546833038, 0.14509804546833038),
        (0.10924369841814041, 0.15294118225574493, 0.15294118225574493),
        (0.11344537883996964, 0.15686275064945221, 0.15686275064945221),
        (0.11764705926179886, 0.16470588743686676, 0.16470588743686676),
        (0.12184873968362808, 0.16862745583057404, 0.16862745583057404),
        (0.1260504275560379, 0.18039216101169586, 0.18039216101169586),
        (0.13025210797786713, 0.18431372940540314, 0.18431372940540314),
        (0.13445378839969635, 0.19215686619281769, 0.19215686619281769),
        (0.13865546882152557, 0.19607843458652496, 0.19607843458652496),
        (0.1428571492433548, 0.20392157137393951, 0.20392157137393951),
        (0.14705882966518402, 0.20784313976764679, 0.20784313976764679),
        (0.15126051008701324, 0.21568627655506134, 0.21568627655506134),
        (0.15546219050884247, 0.21960784494876862, 0.21960784494876862),
        (0.15966387093067169, 0.22352941334247589, 0.22352941334247589),
        (0.16386555135250092, 0.23137255012989044, 0.23137255012989044),
        (0.16806723177433014, 0.23529411852359772, 0.23529411852359772),
        (0.17226891219615936, 0.24313725531101227, 0.24313725531101227),
        (0.17647059261798859, 0.24705882370471954, 0.24705882370471954),
        (0.18067227303981781, 0.25490197539329529, 0.25490197539329529),
        (0.18487395346164703, 0.25882354378700256, 0.25882354378700256),
        (0.18907563388347626, 0.26666668057441711, 0.26666668057441711),
        (0.19327731430530548, 0.27058824896812439, 0.27058824896812439),
        (0.1974789947271347, 0.27450981736183167, 0.27450981736183167),
        (0.20168067514896393, 0.28235295414924622, 0.28235295414924622),
        (0.20588235557079315, 0.28627452254295349, 0.28627452254295349),
        (0.21008403599262238, 0.29803922772407532, 0.29803922772407532),
        (0.2142857164144516, 0.30588236451148987, 0.30588236451148987),
        (0.21848739683628082, 0.30980393290519714, 0.30980393290519714),
        (0.22268907725811005, 0.31764706969261169, 0.31764706969261169),
        (0.22689075767993927, 0.32156863808631897, 0.32156863808631897),
        (0.23109243810176849, 0.32941177487373352, 0.32941177487373352),
        (0.23529411852359772, 0.3333333432674408, 0.3333333432674408),
        (0.23949579894542694, 0.33725491166114807, 0.33725491166114807),
        (0.24369747936725616, 0.34509804844856262, 0.34509804844856262),
        (0.24789915978908539, 0.3490196168422699, 0.3490196168422699),
        (0.25210085511207581, 0.36078432202339172, 0.36078432202339172),
        (0.25630253553390503, 0.36862745881080627, 0.36862745881080627),
        (0.26050421595573425, 0.37254902720451355, 0.37254902720451355),
        (0.26470589637756348, 0.3803921639919281, 0.3803921639919281),
        (0.2689075767993927, 0.38431373238563538, 0.38431373238563538),
        (0.27310925722122192, 0.38823530077934265, 0.38823530077934265),
        (0.27731093764305115, 0.3960784375667572, 0.3960784375667572),
        (0.28151261806488037, 0.40000000596046448, 0.40000000596046448),
        (0.28571429848670959, 0.40784314274787903, 0.40784314274787903),
        (0.28991597890853882, 0.4117647111415863, 0.4117647111415863),
        (0.29411765933036804, 0.42352941632270813, 0.42352941632270813),
        (0.29831933975219727, 0.43137255311012268, 0.43137255311012268),
        (0.30252102017402649, 0.43529412150382996, 0.43529412150382996),
        (0.30672270059585571, 0.44313725829124451, 0.44313725829124451),
        (0.31092438101768494, 0.44705882668495178, 0.44705882668495178),
        (0.31512606143951416, 0.45098039507865906, 0.45098039507865906),
        (0.31932774186134338, 0.45882353186607361, 0.45882353186607361),
        (0.32352942228317261, 0.46274510025978088, 0.46274510025978088),
        (0.32773110270500183, 0.47058823704719543, 0.47058823704719543),
        (0.33193278312683105, 0.47450980544090271, 0.47450980544090271),
        (0.33613446354866028, 0.48235294222831726, 0.48235294222831726),
        (0.3403361439704895, 0.48627451062202454, 0.48627451062202454),
        (0.34453782439231873, 0.49411764740943909, 0.49411764740943909),
        (0.34873950481414795, 0.49803921580314636, 0.49803921580314636),
        (0.35294118523597717, 0.50196081399917603, 0.50196081399917603),
        (0.3571428656578064, 0.50980395078659058, 0.50980395078659058),
        (0.36134454607963562, 0.51372551918029785, 0.51372551918029785),
        (0.36554622650146484, 0.5215686559677124, 0.5215686559677124),
        (0.36974790692329407, 0.52549022436141968, 0.52549022436141968),
        (0.37394958734512329, 0.53333336114883423, 0.53333336114883423),
        (0.37815126776695251, 0.54509806632995605, 0.54509806632995605),
        (0.38235294818878174, 0.54901963472366333, 0.54901963472366333),
        (0.38655462861061096, 0.55294120311737061, 0.55294120311737061),
        (0.39075630903244019, 0.56078433990478516, 0.56078433990478516),
        (0.39495798945426941, 0.56470590829849243, 0.56470590829849243),
        (0.39915966987609863, 0.57254904508590698, 0.57254904508590698),
        (0.40336135029792786, 0.57647061347961426, 0.57647061347961426),
        (0.40756303071975708, 0.58431375026702881, 0.58431375026702881),
        (0.4117647111415863, 0.58823531866073608, 0.58823531866073608),
        (0.41596639156341553, 0.59607845544815063, 0.59607845544815063),
        (0.42016807198524475, 0.60000002384185791, 0.60000002384185791),
        (0.42436975240707397, 0.60784316062927246, 0.60784316062927246),
        (0.4285714328289032, 0.61176472902297974, 0.61176472902297974),
        (0.43277311325073242, 0.61568629741668701, 0.61568629741668701),
        (0.43697479367256165, 0.62352943420410156, 0.62352943420410156),
        (0.44117647409439087, 0.62745100259780884, 0.62745100259780884),
        (0.44537815451622009, 0.63529413938522339, 0.63529413938522339),
        (0.44957983493804932, 0.63921570777893066, 0.63921570777893066),
        (0.45378151535987854, 0.64705884456634521, 0.64705884456634521),
        (0.45798319578170776, 0.65098041296005249, 0.65098041296005249),
        (0.46218487620353699, 0.66274511814117432, 0.66274511814117432),
        (0.46638655662536621, 0.66666668653488159, 0.66666668653488159),
        (0.47058823704719543, 0.67450982332229614, 0.67450982332229614),
        (0.47478991746902466, 0.67843139171600342, 0.67843139171600342),
        (0.47899159789085388, 0.68627452850341797, 0.68627452850341797),
        (0.48319327831268311, 0.69019609689712524, 0.69019609689712524),
        (0.48739495873451233, 0.69803923368453979, 0.69803923368453979),
        (0.49159663915634155, 0.70196080207824707, 0.70196080207824707),
        (0.49579831957817078, 0.70980393886566162, 0.70980393886566162),
        (0.5, 0.7137255072593689, 0.7137255072593689),
        (0.50420171022415161, 0.72549021244049072, 0.72549021244049072),
        (0.50840336084365845, 0.729411780834198, 0.729411780834198),
        (0.51260507106781006, 0.73725491762161255, 0.73725491762161255),
        (0.51680672168731689, 0.74117648601531982, 0.74117648601531982),
        (0.52100843191146851, 0.74901962280273438, 0.74901962280273438),
        (0.52521008253097534, 0.75294119119644165, 0.75294119119644165),
        (0.52941179275512695, 0.7607843279838562, 0.7607843279838562),
        (0.53361344337463379, 0.76470589637756348, 0.76470589637756348),
        (0.5378151535987854, 0.77254903316497803, 0.77254903316497803),
        (0.54201680421829224, 0.7764706015586853, 0.7764706015586853),
        (0.54621851444244385, 0.78823530673980713, 0.78823530673980713),
        (0.55042016506195068, 0.7921568751335144, 0.7921568751335144),
        (0.55462187528610229, 0.80000001192092896, 0.80000001192092896),
        (0.55882352590560913, 0.80392158031463623, 0.80392158031463623),
        (0.56302523612976074, 0.81176471710205078, 0.81176471710205078),
        (0.56722688674926758, 0.81568628549575806, 0.81568628549575806),
        (0.57142859697341919, 0.82352942228317261, 0.82352942228317261),
        (0.57563024759292603, 0.82745099067687988, 0.82745099067687988),
        (0.57983195781707764, 0.83137255907058716, 0.83137255907058716),
        (0.58403360843658447, 0.83921569585800171, 0.83921569585800171),
        (0.58823531866073608, 0.84313726425170898, 0.84313726425170898),
        (0.59243696928024292, 0.85098040103912354, 0.85098040103912354),
        (0.59663867950439453, 0.85490196943283081, 0.85490196943283081),
        (0.60084033012390137, 0.86274510622024536, 0.86274510622024536),
        (0.60504204034805298, 0.86666667461395264, 0.86666667461395264),
        (0.60924369096755981, 0.87450981140136719, 0.87450981140136719),
        (0.61344540119171143, 0.87843137979507446, 0.87843137979507446),
        (0.61764705181121826, 0.88627451658248901, 0.88627451658248901),
        (0.62184876203536987, 0.89019608497619629, 0.89019608497619629),
        (0.62605041265487671, 0.89411765336990356, 0.89411765336990356),
        (0.63025212287902832, 0.90588235855102539, 0.90588235855102539),
        (0.63445377349853516, 0.91372549533843994, 0.91372549533843994),
        (0.63865548372268677, 0.91764706373214722, 0.91764706373214722),
        (0.6428571343421936, 0.92549020051956177, 0.92549020051956177),
        (0.64705884456634521, 0.92941176891326904, 0.92941176891326904),
        (0.65126049518585205, 0.93725490570068359, 0.93725490570068359),
        (0.65546220541000366, 0.94117647409439087, 0.94117647409439087),
        (0.6596638560295105, 0.94509804248809814, 0.94509804248809814),
        (0.66386556625366211, 0.9529411792755127, 0.9529411792755127),
        (0.66806721687316895, 0.95686274766921997, 0.95686274766921997),
        (0.67226892709732056, 0.96470588445663452, 0.96470588445663452),
        (0.67647057771682739, 0.9686274528503418, 0.9686274528503418),
        (0.680672287940979, 0.97647058963775635, 0.97647058963775635),
        (0.68487393856048584, 0.98039215803146362, 0.98039215803146362),
        (0.68907564878463745, 0.98823529481887817, 0.98823529481887817),
        (0.69327729940414429, 0.99215686321258545, 0.99215686321258545),
        (0.6974790096282959, 1.0, 1.0),
        (0.70168066024780273, 1.0, 1.0),
        (0.70588237047195435, 1.0, 1.0),
        (0.71008402109146118, 1.0, 1.0),
        (0.71428573131561279, 1.0, 1.0),
        (0.71848738193511963, 1.0, 1.0),
        (0.72268909215927124, 1.0, 1.0),
        (0.72689074277877808, 1.0, 1.0),
        (0.73109245300292969, 1.0, 1.0),
        (0.73529410362243652, 1.0, 1.0),
        (0.73949581384658813, 1.0, 1.0),
        (0.74369746446609497, 1.0, 1.0),
        (0.74789917469024658, 1.0, 1.0),
        (0.75210082530975342, 1.0, 1.0),
        (0.75630253553390503, 1.0, 1.0),
        (0.76050418615341187, 1.0, 1.0),
        (0.76470589637756348, 1.0, 1.0),
        (0.76890754699707031, 1.0, 1.0),
        (0.77310925722122192, 1.0, 1.0),
        (0.77731090784072876, 1.0, 1.0),
        (0.78151261806488037, 1.0, 1.0),
        (0.78571426868438721, 1.0, 1.0),
        (0.78991597890853882, 1.0, 1.0),
        (0.79411762952804565, 1.0, 1.0),
        (0.79831933975219727, 1.0, 1.0),
        (0.8025209903717041, 1.0, 1.0),
        (0.80672270059585571, 1.0, 1.0),
        (0.81092435121536255, 1.0, 1.0),
        (0.81512606143951416, 1.0, 1.0),
        (0.819327712059021, 1.0, 1.0),
        (0.82352942228317261, 1.0, 1.0),
        (0.82773107290267944, 1.0, 1.0),
        (0.83193278312683105, 1.0, 1.0),
        (0.83613443374633789, 1.0, 1.0),
        (0.8403361439704895, 1.0, 1.0),
        (0.84453779458999634, 1.0, 1.0),
        (0.84873950481414795, 1.0, 1.0),
        (0.85294115543365479, 1.0, 1.0),
        (0.8571428656578064, 1.0, 1.0),
        (0.86134451627731323, 1.0, 1.0),
        (0.86554622650146484, 1.0, 1.0),
        (0.86974787712097168, 1.0, 1.0),
        (0.87394958734512329, 1.0, 1.0),
        (0.87815123796463013, 1.0, 1.0),
        (0.88235294818878174, 1.0, 1.0),
        (0.88655459880828857, 1.0, 1.0),
        (0.89075630903244019, 1.0, 1.0),
        (0.89495795965194702, 1.0, 1.0),
        (0.89915966987609863, 1.0, 1.0),
        (0.90336132049560547, 1.0, 1.0),
        (0.90756303071975708, 1.0, 1.0),
        (0.91176468133926392, 1.0, 1.0),
        (0.91596639156341553, 1.0, 1.0),
        (0.92016804218292236, 1.0, 1.0),
        (0.92436975240707397, 1.0, 1.0),
        (0.92857140302658081, 1.0, 1.0),
        (0.93277311325073242, 1.0, 1.0),
        (0.93697476387023926, 1.0, 1.0),
        (0.94117647409439087, 1.0, 1.0),
        (0.94537812471389771, 1.0, 1.0),
        (0.94957983493804932, 1.0, 1.0),
        (0.95378148555755615, 1.0, 1.0),
        (0.95798319578170776, 1.0, 1.0),
        (0.9621848464012146, 1.0, 1.0),
        (0.96638655662536621, 1.0, 1.0),
        (0.97058820724487305, 1.0, 1.0),
        (0.97478991746902466, 1.0, 1.0),
        (0.97899156808853149, 1.0, 1.0),
        (0.98319327831268311, 1.0, 1.0),
        (0.98739492893218994, 1.0, 1.0),
        (0.99159663915634155, 1.0, 1.0),
        (0.99579828977584839, 1.0, 1.0),
        (1.0, 1.0, 1.0),
    ],
}
_gist_ncar_data = {
    "blue": [
        (0.0, 0.50196081399917603, 0.50196081399917603),
        (0.0050505050458014011, 0.45098039507865906, 0.45098039507865906),
        (0.010101010091602802, 0.40392157435417175, 0.40392157435417175),
        (0.015151515603065491, 0.35686275362968445, 0.35686275362968445),
        (0.020202020183205605, 0.30980393290519714, 0.30980393290519714),
        (0.025252524763345718, 0.25882354378700256, 0.25882354378700256),
        (0.030303031206130981, 0.21176470816135406, 0.21176470816135406),
        (0.035353533923625946, 0.16470588743686676, 0.16470588743686676),
        (0.040404040366411209, 0.11764705926179886, 0.11764705926179886),
        (0.045454546809196472, 0.070588238537311554, 0.070588238537311554),
        (0.050505049526691437, 0.019607843831181526, 0.019607843831181526),
        (0.0555555559694767, 0.047058824449777603, 0.047058824449777603),
        (0.060606062412261963, 0.14509804546833038, 0.14509804546833038),
        (0.065656565129756927, 0.23921568691730499, 0.23921568691730499),
        (0.070707067847251892, 0.3333333432674408, 0.3333333432674408),
        (0.075757578015327454, 0.43137255311012268, 0.43137255311012268),
        (0.080808080732822418, 0.52549022436141968, 0.52549022436141968),
        (0.085858583450317383, 0.61960786581039429, 0.61960786581039429),
        (0.090909093618392944, 0.71764707565307617, 0.71764707565307617),
        (0.095959596335887909, 0.81176471710205078, 0.81176471710205078),
        (0.10101009905338287, 0.90588235855102539, 0.90588235855102539),
        (0.10606060922145844, 1.0, 1.0),
        (0.1111111119389534, 1.0, 1.0),
        (0.11616161465644836, 1.0, 1.0),
        (0.12121212482452393, 1.0, 1.0),
        (0.12626262009143829, 1.0, 1.0),
        (0.13131313025951385, 1.0, 1.0),
        (0.13636364042758942, 1.0, 1.0),
        (0.14141413569450378, 1.0, 1.0),
        (0.14646464586257935, 1.0, 1.0),
        (0.15151515603065491, 1.0, 1.0),
        (0.15656565129756927, 1.0, 1.0),
        (0.16161616146564484, 1.0, 1.0),
        (0.1666666716337204, 1.0, 1.0),
        (0.17171716690063477, 1.0, 1.0),
        (0.17676767706871033, 1.0, 1.0),
        (0.18181818723678589, 1.0, 1.0),
        (0.18686868250370026, 1.0, 1.0),
        (0.19191919267177582, 1.0, 1.0),
        (0.19696970283985138, 1.0, 1.0),
        (0.20202019810676575, 1.0, 1.0),
        (0.20707070827484131, 1.0, 1.0),
        (0.21212121844291687, 0.99215686321258545, 0.99215686321258545),
        (0.21717171370983124, 0.95686274766921997, 0.95686274766921997),
        (0.2222222238779068, 0.91764706373214722, 0.91764706373214722),
        (0.22727273404598236, 0.88235294818878174, 0.88235294818878174),
        (0.23232322931289673, 0.84313726425170898, 0.84313726425170898),
        (0.23737373948097229, 0.80392158031463623, 0.80392158031463623),
        (0.24242424964904785, 0.76862746477127075, 0.76862746477127075),
        (0.24747474491596222, 0.729411780834198, 0.729411780834198),
        (0.25252524018287659, 0.69019609689712524, 0.69019609689712524),
        (0.25757575035095215, 0.65490198135375977, 0.65490198135375977),
        (0.26262626051902771, 0.61568629741668701, 0.61568629741668701),
        (0.26767677068710327, 0.56470590829849243, 0.56470590829849243),
        (0.27272728085517883, 0.50980395078659058, 0.50980395078659058),
        (0.27777779102325439, 0.45098039507865906, 0.45098039507865906),
        (0.28282827138900757, 0.39215686917304993, 0.39215686917304993),
        (0.28787878155708313, 0.3333333432674408, 0.3333333432674408),
        (0.29292929172515869, 0.27843138575553894, 0.27843138575553894),
        (0.29797980189323425, 0.21960784494876862, 0.21960784494876862),
        (0.30303031206130981, 0.16078431904315948, 0.16078431904315948),
        (0.30808082222938538, 0.10588235408067703, 0.10588235408067703),
        (0.31313130259513855, 0.047058824449777603, 0.047058824449777603),
        (0.31818181276321411, 0.0, 0.0),
        (0.32323232293128967, 0.0, 0.0),
        (0.32828283309936523, 0.0, 0.0),
        (0.3333333432674408, 0.0, 0.0),
        (0.33838382363319397, 0.0, 0.0),
        (0.34343433380126953, 0.0, 0.0),
        (0.34848484396934509, 0.0, 0.0),
        (0.35353535413742065, 0.0, 0.0),
        (0.35858586430549622, 0.0, 0.0),
        (0.36363637447357178, 0.0, 0.0),
        (0.36868685483932495, 0.0, 0.0),
        (0.37373736500740051, 0.0, 0.0),
        (0.37878787517547607, 0.0, 0.0),
        (0.38383838534355164, 0.0, 0.0),
        (0.3888888955116272, 0.0, 0.0),
        (0.39393940567970276, 0.0, 0.0),
        (0.39898988604545593, 0.0, 0.0),
        (0.40404039621353149, 0.0, 0.0),
        (0.40909090638160706, 0.0, 0.0),
        (0.41414141654968262, 0.0, 0.0),
        (0.41919192671775818, 0.0, 0.0),
        (0.42424243688583374, 0.0039215688593685627, 0.0039215688593685627),
        (0.42929291725158691, 0.027450980618596077, 0.027450980618596077),
        (0.43434342741966248, 0.050980392843484879, 0.050980392843484879),
        (0.43939393758773804, 0.074509806931018829, 0.074509806931018829),
        (0.4444444477558136, 0.094117648899555206, 0.094117648899555206),
        (0.44949495792388916, 0.11764705926179886, 0.11764705926179886),
        (0.45454546809196472, 0.14117647707462311, 0.14117647707462311),
        (0.4595959484577179, 0.16470588743686676, 0.16470588743686676),
        (0.46464645862579346, 0.18823529779911041, 0.18823529779911041),
        (0.46969696879386902, 0.21176470816135406, 0.21176470816135406),
        (0.47474747896194458, 0.23529411852359772, 0.23529411852359772),
        (0.47979798913002014, 0.22352941334247589, 0.22352941334247589),
        (0.4848484992980957, 0.20000000298023224, 0.20000000298023224),
        (0.48989897966384888, 0.17647059261798859, 0.17647059261798859),
        (0.49494948983192444, 0.15294118225574493, 0.15294118225574493),
        (0.5, 0.12941177189350128, 0.12941177189350128),
        (0.50505048036575317, 0.10980392247438431, 0.10980392247438431),
        (0.51010102033615112, 0.086274512112140656, 0.086274512112140656),
        (0.5151515007019043, 0.062745101749897003, 0.062745101749897003),
        (0.52020204067230225, 0.039215687662363052, 0.039215687662363052),
        (0.52525252103805542, 0.015686275437474251, 0.015686275437474251),
        (0.53030300140380859, 0.0, 0.0),
        (0.53535354137420654, 0.0, 0.0),
        (0.54040402173995972, 0.0, 0.0),
        (0.54545456171035767, 0.0, 0.0),
        (0.55050504207611084, 0.0, 0.0),
        (0.55555558204650879, 0.0, 0.0),
        (0.56060606241226196, 0.0, 0.0),
        (0.56565654277801514, 0.0, 0.0),
        (0.57070708274841309, 0.0, 0.0),
        (0.57575756311416626, 0.0, 0.0),
        (0.58080810308456421, 0.0, 0.0),
        (0.58585858345031738, 0.0039215688593685627, 0.0039215688593685627),
        (0.59090906381607056, 0.0078431377187371254, 0.0078431377187371254),
        (0.59595960378646851, 0.011764706112444401, 0.011764706112444401),
        (0.60101008415222168, 0.019607843831181526, 0.019607843831181526),
        (0.60606062412261963, 0.023529412224888802, 0.023529412224888802),
        (0.6111111044883728, 0.031372550874948502, 0.031372550874948502),
        (0.61616164445877075, 0.035294119268655777, 0.035294119268655777),
        (0.62121212482452393, 0.043137256056070328, 0.043137256056070328),
        (0.6262626051902771, 0.047058824449777603, 0.047058824449777603),
        (0.63131314516067505, 0.054901961237192154, 0.054901961237192154),
        (0.63636362552642822, 0.054901961237192154, 0.054901961237192154),
        (0.64141416549682617, 0.050980392843484879, 0.050980392843484879),
        (0.64646464586257935, 0.043137256056070328, 0.043137256056070328),
        (0.65151512622833252, 0.039215687662363052, 0.039215687662363052),
        (0.65656566619873047, 0.031372550874948502, 0.031372550874948502),
        (0.66161614656448364, 0.027450980618596077, 0.027450980618596077),
        (0.66666668653488159, 0.019607843831181526, 0.019607843831181526),
        (0.67171716690063477, 0.015686275437474251, 0.015686275437474251),
        (0.67676764726638794, 0.011764706112444401, 0.011764706112444401),
        (0.68181818723678589, 0.0039215688593685627, 0.0039215688593685627),
        (0.68686866760253906, 0.0, 0.0),
        (0.69191920757293701, 0.0, 0.0),
        (0.69696968793869019, 0.0, 0.0),
        (0.70202022790908813, 0.0, 0.0),
        (0.70707070827484131, 0.0, 0.0),
        (0.71212118864059448, 0.0, 0.0),
        (0.71717172861099243, 0.0, 0.0),
        (0.72222220897674561, 0.0, 0.0),
        (0.72727274894714355, 0.0, 0.0),
        (0.73232322931289673, 0.0, 0.0),
        (0.7373737096786499, 0.0, 0.0),
        (0.74242424964904785, 0.031372550874948502, 0.031372550874948502),
        (0.74747473001480103, 0.12941177189350128, 0.12941177189350128),
        (0.75252526998519897, 0.22352941334247589, 0.22352941334247589),
        (0.75757575035095215, 0.32156863808631897, 0.32156863808631897),
        (0.7626262903213501, 0.41568627953529358, 0.41568627953529358),
        (0.76767677068710327, 0.50980395078659058, 0.50980395078659058),
        (0.77272725105285645, 0.60784316062927246, 0.60784316062927246),
        (0.77777779102325439, 0.70196080207824707, 0.70196080207824707),
        (0.78282827138900757, 0.79607844352722168, 0.79607844352722168),
        (0.78787881135940552, 0.89411765336990356, 0.89411765336990356),
        (0.79292929172515869, 0.98823529481887817, 0.98823529481887817),
        (0.79797977209091187, 1.0, 1.0),
        (0.80303031206130981, 1.0, 1.0),
        (0.80808079242706299, 1.0, 1.0),
        (0.81313133239746094, 1.0, 1.0),
        (0.81818181276321411, 1.0, 1.0),
        (0.82323235273361206, 1.0, 1.0),
        (0.82828283309936523, 1.0, 1.0),
        (0.83333331346511841, 1.0, 1.0),
        (0.83838385343551636, 1.0, 1.0),
        (0.84343433380126953, 1.0, 1.0),
        (0.84848487377166748, 0.99607843160629272, 0.99607843160629272),
        (0.85353535413742065, 0.98823529481887817, 0.98823529481887817),
        (0.85858583450317383, 0.9843137264251709, 0.9843137264251709),
        (0.86363637447357178, 0.97647058963775635, 0.97647058963775635),
        (0.86868685483932495, 0.9686274528503418, 0.9686274528503418),
        (0.8737373948097229, 0.96470588445663452, 0.96470588445663452),
        (0.87878787517547607, 0.95686274766921997, 0.95686274766921997),
        (0.88383835554122925, 0.94901961088180542, 0.94901961088180542),
        (0.8888888955116272, 0.94509804248809814, 0.94509804248809814),
        (0.89393937587738037, 0.93725490570068359, 0.93725490570068359),
        (0.89898991584777832, 0.93333333730697632, 0.93333333730697632),
        (0.90404039621353149, 0.93333333730697632, 0.93333333730697632),
        (0.90909093618392944, 0.93725490570068359, 0.93725490570068359),
        (0.91414141654968262, 0.93725490570068359, 0.93725490570068359),
        (0.91919189691543579, 0.94117647409439087, 0.94117647409439087),
        (0.92424243688583374, 0.94509804248809814, 0.94509804248809814),
        (0.92929291725158691, 0.94509804248809814, 0.94509804248809814),
        (0.93434345722198486, 0.94901961088180542, 0.94901961088180542),
        (0.93939393758773804, 0.9529411792755127, 0.9529411792755127),
        (0.94444441795349121, 0.9529411792755127, 0.9529411792755127),
        (0.94949495792388916, 0.95686274766921997, 0.95686274766921997),
        (0.95454543828964233, 0.96078431606292725, 0.96078431606292725),
        (0.95959597826004028, 0.96470588445663452, 0.96470588445663452),
        (0.96464645862579346, 0.9686274528503418, 0.9686274528503418),
        (0.96969699859619141, 0.97254902124404907, 0.97254902124404907),
        (0.97474747896194458, 0.97647058963775635, 0.97647058963775635),
        (0.97979795932769775, 0.98039215803146362, 0.98039215803146362),
        (0.9848484992980957, 0.9843137264251709, 0.9843137264251709),
        (0.98989897966384888, 0.98823529481887817, 0.98823529481887817),
        (0.99494951963424683, 0.99215686321258545, 0.99215686321258545),
        (1.0, 0.99607843160629272, 0.99607843160629272),
    ],
    "green": [
        (0.0, 0.0, 0.0),
        (0.0050505050458014011, 0.035294119268655777, 0.035294119268655777),
        (0.010101010091602802, 0.074509806931018829, 0.074509806931018829),
        (0.015151515603065491, 0.10980392247438431, 0.10980392247438431),
        (0.020202020183205605, 0.14901961386203766, 0.14901961386203766),
        (0.025252524763345718, 0.18431372940540314, 0.18431372940540314),
        (0.030303031206130981, 0.22352941334247589, 0.22352941334247589),
        (0.035353533923625946, 0.25882354378700256, 0.25882354378700256),
        (0.040404040366411209, 0.29803922772407532, 0.29803922772407532),
        (0.045454546809196472, 0.3333333432674408, 0.3333333432674408),
        (0.050505049526691437, 0.37254902720451355, 0.37254902720451355),
        (0.0555555559694767, 0.36862745881080627, 0.36862745881080627),
        (0.060606062412261963, 0.3333333432674408, 0.3333333432674408),
        (0.065656565129756927, 0.29411765933036804, 0.29411765933036804),
        (0.070707067847251892, 0.25882354378700256, 0.25882354378700256),
        (0.075757578015327454, 0.21960784494876862, 0.21960784494876862),
        (0.080808080732822418, 0.18431372940540314, 0.18431372940540314),
        (0.085858583450317383, 0.14509804546833038, 0.14509804546833038),
        (0.090909093618392944, 0.10980392247438431, 0.10980392247438431),
        (0.095959596335887909, 0.070588238537311554, 0.070588238537311554),
        (0.10101009905338287, 0.035294119268655777, 0.035294119268655777),
        (0.10606060922145844, 0.0, 0.0),
        (0.1111111119389534, 0.074509806931018829, 0.074509806931018829),
        (0.11616161465644836, 0.14509804546833038, 0.14509804546833038),
        (0.12121212482452393, 0.21568627655506134, 0.21568627655506134),
        (0.12626262009143829, 0.28627452254295349, 0.28627452254295349),
        (0.13131313025951385, 0.36078432202339172, 0.36078432202339172),
        (0.13636364042758942, 0.43137255311012268, 0.43137255311012268),
        (0.14141413569450378, 0.50196081399917603, 0.50196081399917603),
        (0.14646464586257935, 0.57254904508590698, 0.57254904508590698),
        (0.15151515603065491, 0.64705884456634521, 0.64705884456634521),
        (0.15656565129756927, 0.71764707565307617, 0.71764707565307617),
        (0.16161616146564484, 0.7607843279838562, 0.7607843279838562),
        (0.1666666716337204, 0.78431373834609985, 0.78431373834609985),
        (0.17171716690063477, 0.80784314870834351, 0.80784314870834351),
        (0.17676767706871033, 0.83137255907058716, 0.83137255907058716),
        (0.18181818723678589, 0.85490196943283081, 0.85490196943283081),
        (0.18686868250370026, 0.88235294818878174, 0.88235294818878174),
        (0.19191919267177582, 0.90588235855102539, 0.90588235855102539),
        (0.19696970283985138, 0.92941176891326904, 0.92941176891326904),
        (0.20202019810676575, 0.9529411792755127, 0.9529411792755127),
        (0.20707070827484131, 0.97647058963775635, 0.97647058963775635),
        (0.21212121844291687, 0.99607843160629272, 0.99607843160629272),
        (0.21717171370983124, 0.99607843160629272, 0.99607843160629272),
        (0.2222222238779068, 0.99215686321258545, 0.99215686321258545),
        (0.22727273404598236, 0.99215686321258545, 0.99215686321258545),
        (0.23232322931289673, 0.99215686321258545, 0.99215686321258545),
        (0.23737373948097229, 0.98823529481887817, 0.98823529481887817),
        (0.24242424964904785, 0.98823529481887817, 0.98823529481887817),
        (0.24747474491596222, 0.9843137264251709, 0.9843137264251709),
        (0.25252524018287659, 0.9843137264251709, 0.9843137264251709),
        (0.25757575035095215, 0.98039215803146362, 0.98039215803146362),
        (0.26262626051902771, 0.98039215803146362, 0.98039215803146362),
        (0.26767677068710327, 0.98039215803146362, 0.98039215803146362),
        (0.27272728085517883, 0.98039215803146362, 0.98039215803146362),
        (0.27777779102325439, 0.9843137264251709, 0.9843137264251709),
        (0.28282827138900757, 0.9843137264251709, 0.9843137264251709),
        (0.28787878155708313, 0.98823529481887817, 0.98823529481887817),
        (0.29292929172515869, 0.98823529481887817, 0.98823529481887817),
        (0.29797980189323425, 0.99215686321258545, 0.99215686321258545),
        (0.30303031206130981, 0.99215686321258545, 0.99215686321258545),
        (0.30808082222938538, 0.99607843160629272, 0.99607843160629272),
        (0.31313130259513855, 0.99607843160629272, 0.99607843160629272),
        (0.31818181276321411, 0.99607843160629272, 0.99607843160629272),
        (0.32323232293128967, 0.97647058963775635, 0.97647058963775635),
        (0.32828283309936523, 0.95686274766921997, 0.95686274766921997),
        (0.3333333432674408, 0.93725490570068359, 0.93725490570068359),
        (0.33838382363319397, 0.92156863212585449, 0.92156863212585449),
        (0.34343433380126953, 0.90196079015731812, 0.90196079015731812),
        (0.34848484396934509, 0.88235294818878174, 0.88235294818878174),
        (0.35353535413742065, 0.86274510622024536, 0.86274510622024536),
        (0.35858586430549622, 0.84705883264541626, 0.84705883264541626),
        (0.36363637447357178, 0.82745099067687988, 0.82745099067687988),
        (0.36868685483932495, 0.80784314870834351, 0.80784314870834351),
        (0.37373736500740051, 0.81568628549575806, 0.81568628549575806),
        (0.37878787517547607, 0.83529412746429443, 0.83529412746429443),
        (0.38383838534355164, 0.85098040103912354, 0.85098040103912354),
        (0.3888888955116272, 0.87058824300765991, 0.87058824300765991),
        (0.39393940567970276, 0.89019608497619629, 0.89019608497619629),
        (0.39898988604545593, 0.90980392694473267, 0.90980392694473267),
        (0.40404039621353149, 0.92549020051956177, 0.92549020051956177),
        (0.40909090638160706, 0.94509804248809814, 0.94509804248809814),
        (0.41414141654968262, 0.96470588445663452, 0.96470588445663452),
        (0.41919192671775818, 0.9843137264251709, 0.9843137264251709),
        (0.42424243688583374, 1.0, 1.0),
        (0.42929291725158691, 1.0, 1.0),
        (0.43434342741966248, 1.0, 1.0),
        (0.43939393758773804, 1.0, 1.0),
        (0.4444444477558136, 1.0, 1.0),
        (0.44949495792388916, 1.0, 1.0),
        (0.45454546809196472, 1.0, 1.0),
        (0.4595959484577179, 1.0, 1.0),
        (0.46464645862579346, 1.0, 1.0),
        (0.46969696879386902, 1.0, 1.0),
        (0.47474747896194458, 1.0, 1.0),
        (0.47979798913002014, 1.0, 1.0),
        (0.4848484992980957, 1.0, 1.0),
        (0.48989897966384888, 1.0, 1.0),
        (0.49494948983192444, 1.0, 1.0),
        (0.5, 1.0, 1.0),
        (0.50505048036575317, 1.0, 1.0),
        (0.51010102033615112, 1.0, 1.0),
        (0.5151515007019043, 1.0, 1.0),
        (0.52020204067230225, 1.0, 1.0),
        (0.52525252103805542, 1.0, 1.0),
        (0.53030300140380859, 0.99215686321258545, 0.99215686321258545),
        (0.53535354137420654, 0.98039215803146362, 0.98039215803146362),
        (0.54040402173995972, 0.96470588445663452, 0.96470588445663452),
        (0.54545456171035767, 0.94901961088180542, 0.94901961088180542),
        (0.55050504207611084, 0.93333333730697632, 0.93333333730697632),
        (0.55555558204650879, 0.91764706373214722, 0.91764706373214722),
        (0.56060606241226196, 0.90588235855102539, 0.90588235855102539),
        (0.56565654277801514, 0.89019608497619629, 0.89019608497619629),
        (0.57070708274841309, 0.87450981140136719, 0.87450981140136719),
        (0.57575756311416626, 0.85882353782653809, 0.85882353782653809),
        (0.58080810308456421, 0.84313726425170898, 0.84313726425170898),
        (0.58585858345031738, 0.83137255907058716, 0.83137255907058716),
        (0.59090906381607056, 0.81960785388946533, 0.81960785388946533),
        (0.59595960378646851, 0.81176471710205078, 0.81176471710205078),
        (0.60101008415222168, 0.80000001192092896, 0.80000001192092896),
        (0.60606062412261963, 0.78823530673980713, 0.78823530673980713),
        (0.6111111044883728, 0.7764706015586853, 0.7764706015586853),
        (0.61616164445877075, 0.76470589637756348, 0.76470589637756348),
        (0.62121212482452393, 0.75294119119644165, 0.75294119119644165),
        (0.6262626051902771, 0.74117648601531982, 0.74117648601531982),
        (0.63131314516067505, 0.729411780834198, 0.729411780834198),
        (0.63636362552642822, 0.70980393886566162, 0.70980393886566162),
        (0.64141416549682617, 0.66666668653488159, 0.66666668653488159),
        (0.64646464586257935, 0.62352943420410156, 0.62352943420410156),
        (0.65151512622833252, 0.58039218187332153, 0.58039218187332153),
        (0.65656566619873047, 0.5372549295425415, 0.5372549295425415),
        (0.66161614656448364, 0.49411764740943909, 0.49411764740943909),
        (0.66666668653488159, 0.45098039507865906, 0.45098039507865906),
        (0.67171716690063477, 0.40392157435417175, 0.40392157435417175),
        (0.67676764726638794, 0.36078432202339172, 0.36078432202339172),
        (0.68181818723678589, 0.31764706969261169, 0.31764706969261169),
        (0.68686866760253906, 0.27450981736183167, 0.27450981736183167),
        (0.69191920757293701, 0.24705882370471954, 0.24705882370471954),
        (0.69696968793869019, 0.21960784494876862, 0.21960784494876862),
        (0.70202022790908813, 0.19607843458652496, 0.19607843458652496),
        (0.70707070827484131, 0.16862745583057404, 0.16862745583057404),
        (0.71212118864059448, 0.14509804546833038, 0.14509804546833038),
        (0.71717172861099243, 0.11764705926179886, 0.11764705926179886),
        (0.72222220897674561, 0.090196080505847931, 0.090196080505847931),
        (0.72727274894714355, 0.066666670143604279, 0.066666670143604279),
        (0.73232322931289673, 0.039215687662363052, 0.039215687662363052),
        (0.7373737096786499, 0.015686275437474251, 0.015686275437474251),
        (0.74242424964904785, 0.0, 0.0),
        (0.74747473001480103, 0.0, 0.0),
        (0.75252526998519897, 0.0, 0.0),
        (0.75757575035095215, 0.0, 0.0),
        (0.7626262903213501, 0.0, 0.0),
        (0.76767677068710327, 0.0, 0.0),
        (0.77272725105285645, 0.0, 0.0),
        (0.77777779102325439, 0.0, 0.0),
        (0.78282827138900757, 0.0, 0.0),
        (0.78787881135940552, 0.0, 0.0),
        (0.79292929172515869, 0.0, 0.0),
        (0.79797977209091187, 0.015686275437474251, 0.015686275437474251),
        (0.80303031206130981, 0.031372550874948502, 0.031372550874948502),
        (0.80808079242706299, 0.050980392843484879, 0.050980392843484879),
        (0.81313133239746094, 0.066666670143604279, 0.066666670143604279),
        (0.81818181276321411, 0.086274512112140656, 0.086274512112140656),
        (0.82323235273361206, 0.10588235408067703, 0.10588235408067703),
        (0.82828283309936523, 0.12156862765550613, 0.12156862765550613),
        (0.83333331346511841, 0.14117647707462311, 0.14117647707462311),
        (0.83838385343551636, 0.15686275064945221, 0.15686275064945221),
        (0.84343433380126953, 0.17647059261798859, 0.17647059261798859),
        (0.84848487377166748, 0.20000000298023224, 0.20000000298023224),
        (0.85353535413742065, 0.23137255012989044, 0.23137255012989044),
        (0.85858583450317383, 0.25882354378700256, 0.25882354378700256),
        (0.86363637447357178, 0.29019609093666077, 0.29019609093666077),
        (0.86868685483932495, 0.32156863808631897, 0.32156863808631897),
        (0.8737373948097229, 0.35294118523597717, 0.35294118523597717),
        (0.87878787517547607, 0.38431373238563538, 0.38431373238563538),
        (0.88383835554122925, 0.41568627953529358, 0.41568627953529358),
        (0.8888888955116272, 0.44313725829124451, 0.44313725829124451),
        (0.89393937587738037, 0.47450980544090271, 0.47450980544090271),
        (0.89898991584777832, 0.5058823823928833, 0.5058823823928833),
        (0.90404039621353149, 0.52941179275512695, 0.52941179275512695),
        (0.90909093618392944, 0.55294120311737061, 0.55294120311737061),
        (0.91414141654968262, 0.57254904508590698, 0.57254904508590698),
        (0.91919189691543579, 0.59607845544815063, 0.59607845544815063),
        (0.92424243688583374, 0.61960786581039429, 0.61960786581039429),
        (0.92929291725158691, 0.64313727617263794, 0.64313727617263794),
        (0.93434345722198486, 0.66274511814117432, 0.66274511814117432),
        (0.93939393758773804, 0.68627452850341797, 0.68627452850341797),
        (0.94444441795349121, 0.70980393886566162, 0.70980393886566162),
        (0.94949495792388916, 0.729411780834198, 0.729411780834198),
        (0.95454543828964233, 0.75294119119644165, 0.75294119119644165),
        (0.95959597826004028, 0.78039216995239258, 0.78039216995239258),
        (0.96464645862579346, 0.80392158031463623, 0.80392158031463623),
        (0.96969699859619141, 0.82745099067687988, 0.82745099067687988),
        (0.97474747896194458, 0.85098040103912354, 0.85098040103912354),
        (0.97979795932769775, 0.87450981140136719, 0.87450981140136719),
        (0.9848484992980957, 0.90196079015731812, 0.90196079015731812),
        (0.98989897966384888, 0.92549020051956177, 0.92549020051956177),
        (0.99494951963424683, 0.94901961088180542, 0.94901961088180542),
        (1.0, 0.97254902124404907, 0.97254902124404907),
    ],
    "red": [
        (0.0, 0.0, 0.0),
        (0.0050505050458014011, 0.0, 0.0),
        (0.010101010091602802, 0.0, 0.0),
        (0.015151515603065491, 0.0, 0.0),
        (0.020202020183205605, 0.0, 0.0),
        (0.025252524763345718, 0.0, 0.0),
        (0.030303031206130981, 0.0, 0.0),
        (0.035353533923625946, 0.0, 0.0),
        (0.040404040366411209, 0.0, 0.0),
        (0.045454546809196472, 0.0, 0.0),
        (0.050505049526691437, 0.0, 0.0),
        (0.0555555559694767, 0.0, 0.0),
        (0.060606062412261963, 0.0, 0.0),
        (0.065656565129756927, 0.0, 0.0),
        (0.070707067847251892, 0.0, 0.0),
        (0.075757578015327454, 0.0, 0.0),
        (0.080808080732822418, 0.0, 0.0),
        (0.085858583450317383, 0.0, 0.0),
        (0.090909093618392944, 0.0, 0.0),
        (0.095959596335887909, 0.0, 0.0),
        (0.10101009905338287, 0.0, 0.0),
        (0.10606060922145844, 0.0, 0.0),
        (0.1111111119389534, 0.0, 0.0),
        (0.11616161465644836, 0.0, 0.0),
        (0.12121212482452393, 0.0, 0.0),
        (0.12626262009143829, 0.0, 0.0),
        (0.13131313025951385, 0.0, 0.0),
        (0.13636364042758942, 0.0, 0.0),
        (0.14141413569450378, 0.0, 0.0),
        (0.14646464586257935, 0.0, 0.0),
        (0.15151515603065491, 0.0, 0.0),
        (0.15656565129756927, 0.0, 0.0),
        (0.16161616146564484, 0.0, 0.0),
        (0.1666666716337204, 0.0, 0.0),
        (0.17171716690063477, 0.0, 0.0),
        (0.17676767706871033, 0.0, 0.0),
        (0.18181818723678589, 0.0, 0.0),
        (0.18686868250370026, 0.0, 0.0),
        (0.19191919267177582, 0.0, 0.0),
        (0.19696970283985138, 0.0, 0.0),
        (0.20202019810676575, 0.0, 0.0),
        (0.20707070827484131, 0.0, 0.0),
        (0.21212121844291687, 0.0, 0.0),
        (0.21717171370983124, 0.0, 0.0),
        (0.2222222238779068, 0.0, 0.0),
        (0.22727273404598236, 0.0, 0.0),
        (0.23232322931289673, 0.0, 0.0),
        (0.23737373948097229, 0.0, 0.0),
        (0.24242424964904785, 0.0, 0.0),
        (0.24747474491596222, 0.0, 0.0),
        (0.25252524018287659, 0.0, 0.0),
        (0.25757575035095215, 0.0, 0.0),
        (0.26262626051902771, 0.0, 0.0),
        (0.26767677068710327, 0.0, 0.0),
        (0.27272728085517883, 0.0, 0.0),
        (0.27777779102325439, 0.0, 0.0),
        (0.28282827138900757, 0.0, 0.0),
        (0.28787878155708313, 0.0, 0.0),
        (0.29292929172515869, 0.0, 0.0),
        (0.29797980189323425, 0.0, 0.0),
        (0.30303031206130981, 0.0, 0.0),
        (0.30808082222938538, 0.0, 0.0),
        (0.31313130259513855, 0.0, 0.0),
        (0.31818181276321411, 0.0039215688593685627, 0.0039215688593685627),
        (0.32323232293128967, 0.043137256056070328, 0.043137256056070328),
        (0.32828283309936523, 0.08235294371843338, 0.08235294371843338),
        (0.3333333432674408, 0.11764705926179886, 0.11764705926179886),
        (0.33838382363319397, 0.15686275064945221, 0.15686275064945221),
        (0.34343433380126953, 0.19607843458652496, 0.19607843458652496),
        (0.34848484396934509, 0.23137255012989044, 0.23137255012989044),
        (0.35353535413742065, 0.27058824896812439, 0.27058824896812439),
        (0.35858586430549622, 0.30980393290519714, 0.30980393290519714),
        (0.36363637447357178, 0.3490196168422699, 0.3490196168422699),
        (0.36868685483932495, 0.38431373238563538, 0.38431373238563538),
        (0.37373736500740051, 0.40392157435417175, 0.40392157435417175),
        (0.37878787517547607, 0.41568627953529358, 0.41568627953529358),
        (0.38383838534355164, 0.42352941632270813, 0.42352941632270813),
        (0.3888888955116272, 0.43137255311012268, 0.43137255311012268),
        (0.39393940567970276, 0.44313725829124451, 0.44313725829124451),
        (0.39898988604545593, 0.45098039507865906, 0.45098039507865906),
        (0.40404039621353149, 0.45882353186607361, 0.45882353186607361),
        (0.40909090638160706, 0.47058823704719543, 0.47058823704719543),
        (0.41414141654968262, 0.47843137383460999, 0.47843137383460999),
        (0.41919192671775818, 0.49019607901573181, 0.49019607901573181),
        (0.42424243688583374, 0.50196081399917603, 0.50196081399917603),
        (0.42929291725158691, 0.52549022436141968, 0.52549022436141968),
        (0.43434342741966248, 0.54901963472366333, 0.54901963472366333),
        (0.43939393758773804, 0.57254904508590698, 0.57254904508590698),
        (0.4444444477558136, 0.60000002384185791, 0.60000002384185791),
        (0.44949495792388916, 0.62352943420410156, 0.62352943420410156),
        (0.45454546809196472, 0.64705884456634521, 0.64705884456634521),
        (0.4595959484577179, 0.67058825492858887, 0.67058825492858887),
        (0.46464645862579346, 0.69411766529083252, 0.69411766529083252),
        (0.46969696879386902, 0.72156864404678345, 0.72156864404678345),
        (0.47474747896194458, 0.7450980544090271, 0.7450980544090271),
        (0.47979798913002014, 0.76862746477127075, 0.76862746477127075),
        (0.4848484992980957, 0.7921568751335144, 0.7921568751335144),
        (0.48989897966384888, 0.81568628549575806, 0.81568628549575806),
        (0.49494948983192444, 0.83921569585800171, 0.83921569585800171),
        (0.5, 0.86274510622024536, 0.86274510622024536),
        (0.50505048036575317, 0.88627451658248901, 0.88627451658248901),
        (0.51010102033615112, 0.90980392694473267, 0.90980392694473267),
        (0.5151515007019043, 0.93333333730697632, 0.93333333730697632),
        (0.52020204067230225, 0.95686274766921997, 0.95686274766921997),
        (0.52525252103805542, 0.98039215803146362, 0.98039215803146362),
        (0.53030300140380859, 1.0, 1.0),
        (0.53535354137420654, 1.0, 1.0),
        (0.54040402173995972, 1.0, 1.0),
        (0.54545456171035767, 1.0, 1.0),
        (0.55050504207611084, 1.0, 1.0),
        (0.55555558204650879, 1.0, 1.0),
        (0.56060606241226196, 1.0, 1.0),
        (0.56565654277801514, 1.0, 1.0),
        (0.57070708274841309, 1.0, 1.0),
        (0.57575756311416626, 1.0, 1.0),
        (0.58080810308456421, 1.0, 1.0),
        (0.58585858345031738, 1.0, 1.0),
        (0.59090906381607056, 1.0, 1.0),
        (0.59595960378646851, 1.0, 1.0),
        (0.60101008415222168, 1.0, 1.0),
        (0.60606062412261963, 1.0, 1.0),
        (0.6111111044883728, 1.0, 1.0),
        (0.61616164445877075, 1.0, 1.0),
        (0.62121212482452393, 1.0, 1.0),
        (0.6262626051902771, 1.0, 1.0),
        (0.63131314516067505, 1.0, 1.0),
        (0.63636362552642822, 1.0, 1.0),
        (0.64141416549682617, 1.0, 1.0),
        (0.64646464586257935, 1.0, 1.0),
        (0.65151512622833252, 1.0, 1.0),
        (0.65656566619873047, 1.0, 1.0),
        (0.66161614656448364, 1.0, 1.0),
        (0.66666668653488159, 1.0, 1.0),
        (0.67171716690063477, 1.0, 1.0),
        (0.67676764726638794, 1.0, 1.0),
        (0.68181818723678589, 1.0, 1.0),
        (0.68686866760253906, 1.0, 1.0),
        (0.69191920757293701, 1.0, 1.0),
        (0.69696968793869019, 1.0, 1.0),
        (0.70202022790908813, 1.0, 1.0),
        (0.70707070827484131, 1.0, 1.0),
        (0.71212118864059448, 1.0, 1.0),
        (0.71717172861099243, 1.0, 1.0),
        (0.72222220897674561, 1.0, 1.0),
        (0.72727274894714355, 1.0, 1.0),
        (0.73232322931289673, 1.0, 1.0),
        (0.7373737096786499, 1.0, 1.0),
        (0.74242424964904785, 1.0, 1.0),
        (0.74747473001480103, 1.0, 1.0),
        (0.75252526998519897, 1.0, 1.0),
        (0.75757575035095215, 1.0, 1.0),
        (0.7626262903213501, 1.0, 1.0),
        (0.76767677068710327, 1.0, 1.0),
        (0.77272725105285645, 1.0, 1.0),
        (0.77777779102325439, 1.0, 1.0),
        (0.78282827138900757, 1.0, 1.0),
        (0.78787881135940552, 1.0, 1.0),
        (0.79292929172515869, 1.0, 1.0),
        (0.79797977209091187, 0.96470588445663452, 0.96470588445663452),
        (0.80303031206130981, 0.92549020051956177, 0.92549020051956177),
        (0.80808079242706299, 0.89019608497619629, 0.89019608497619629),
        (0.81313133239746094, 0.85098040103912354, 0.85098040103912354),
        (0.81818181276321411, 0.81568628549575806, 0.81568628549575806),
        (0.82323235273361206, 0.7764706015586853, 0.7764706015586853),
        (0.82828283309936523, 0.74117648601531982, 0.74117648601531982),
        (0.83333331346511841, 0.70196080207824707, 0.70196080207824707),
        (0.83838385343551636, 0.66666668653488159, 0.66666668653488159),
        (0.84343433380126953, 0.62745100259780884, 0.62745100259780884),
        (0.84848487377166748, 0.61960786581039429, 0.61960786581039429),
        (0.85353535413742065, 0.65098041296005249, 0.65098041296005249),
        (0.85858583450317383, 0.68235296010971069, 0.68235296010971069),
        (0.86363637447357178, 0.7137255072593689, 0.7137255072593689),
        (0.86868685483932495, 0.7450980544090271, 0.7450980544090271),
        (0.8737373948097229, 0.77254903316497803, 0.77254903316497803),
        (0.87878787517547607, 0.80392158031463623, 0.80392158031463623),
        (0.88383835554122925, 0.83529412746429443, 0.83529412746429443),
        (0.8888888955116272, 0.86666667461395264, 0.86666667461395264),
        (0.89393937587738037, 0.89803922176361084, 0.89803922176361084),
        (0.89898991584777832, 0.92941176891326904, 0.92941176891326904),
        (0.90404039621353149, 0.93333333730697632, 0.93333333730697632),
        (0.90909093618392944, 0.93725490570068359, 0.93725490570068359),
        (0.91414141654968262, 0.93725490570068359, 0.93725490570068359),
        (0.91919189691543579, 0.94117647409439087, 0.94117647409439087),
        (0.92424243688583374, 0.94509804248809814, 0.94509804248809814),
        (0.92929291725158691, 0.94509804248809814, 0.94509804248809814),
        (0.93434345722198486, 0.94901961088180542, 0.94901961088180542),
        (0.93939393758773804, 0.9529411792755127, 0.9529411792755127),
        (0.94444441795349121, 0.9529411792755127, 0.9529411792755127),
        (0.94949495792388916, 0.95686274766921997, 0.95686274766921997),
        (0.95454543828964233, 0.96078431606292725, 0.96078431606292725),
        (0.95959597826004028, 0.96470588445663452, 0.96470588445663452),
        (0.96464645862579346, 0.9686274528503418, 0.9686274528503418),
        (0.96969699859619141, 0.97254902124404907, 0.97254902124404907),
        (0.97474747896194458, 0.97647058963775635, 0.97647058963775635),
        (0.97979795932769775, 0.98039215803146362, 0.98039215803146362),
        (0.9848484992980957, 0.9843137264251709, 0.9843137264251709),
        (0.98989897966384888, 0.98823529481887817, 0.98823529481887817),
        (0.99494951963424683, 0.99215686321258545, 0.99215686321258545),
        (1.0, 0.99607843160629272, 0.99607843160629272),
    ],
}
_gist_rainbow_data = {
    "blue": [
        (0.0, 0.16470588743686676, 0.16470588743686676),
        (0.0042016808874905109, 0.14117647707462311, 0.14117647707462311),
        (0.0084033617749810219, 0.12156862765550613, 0.12156862765550613),
        (0.012605042196810246, 0.10196078568696976, 0.10196078568696976),
        (0.016806723549962044, 0.078431375324726105, 0.078431375324726105),
        (0.021008403971791267, 0.058823529630899429, 0.058823529630899429),
        (0.025210084393620491, 0.039215687662363052, 0.039215687662363052),
        (0.029411764815449715, 0.015686275437474251, 0.015686275437474251),
        (0.033613447099924088, 0.0, 0.0),
        (0.037815127521753311, 0.0, 0.0),
        (0.042016807943582535, 0.0, 0.0),
        (0.046218488365411758, 0.0, 0.0),
        (0.050420168787240982, 0.0, 0.0),
        (0.054621849209070206, 0.0, 0.0),
        (0.058823529630899429, 0.0, 0.0),
        (0.063025213778018951, 0.0, 0.0),
        (0.067226894199848175, 0.0, 0.0),
        (0.071428574621677399, 0.0, 0.0),
        (0.075630255043506622, 0.0, 0.0),
        (0.079831935465335846, 0.0, 0.0),
        (0.08403361588716507, 0.0, 0.0),
        (0.088235296308994293, 0.0, 0.0),
        (0.092436976730823517, 0.0, 0.0),
        (0.09663865715265274, 0.0, 0.0),
        (0.10084033757448196, 0.0, 0.0),
        (0.10504201799631119, 0.0, 0.0),
        (0.10924369841814041, 0.0, 0.0),
        (0.11344537883996964, 0.0, 0.0),
        (0.11764705926179886, 0.0, 0.0),
        (0.12184873968362808, 0.0, 0.0),
        (0.1260504275560379, 0.0, 0.0),
        (0.13025210797786713, 0.0, 0.0),
        (0.13445378839969635, 0.0, 0.0),
        (0.13865546882152557, 0.0, 0.0),
        (0.1428571492433548, 0.0, 0.0),
        (0.14705882966518402, 0.0, 0.0),
        (0.15126051008701324, 0.0, 0.0),
        (0.15546219050884247, 0.0, 0.0),
        (0.15966387093067169, 0.0, 0.0),
        (0.16386555135250092, 0.0, 0.0),
        (0.16806723177433014, 0.0, 0.0),
        (0.17226891219615936, 0.0, 0.0),
        (0.17647059261798859, 0.0, 0.0),
        (0.18067227303981781, 0.0, 0.0),
        (0.18487395346164703, 0.0, 0.0),
        (0.18907563388347626, 0.0, 0.0),
        (0.19327731430530548, 0.0, 0.0),
        (0.1974789947271347, 0.0, 0.0),
        (0.20168067514896393, 0.0, 0.0),
        (0.20588235557079315, 0.0, 0.0),
        (0.21008403599262238, 0.0, 0.0),
        (0.2142857164144516, 0.0, 0.0),
        (0.21848739683628082, 0.0, 0.0),
        (0.22268907725811005, 0.0, 0.0),
        (0.22689075767993927, 0.0, 0.0),
        (0.23109243810176849, 0.0, 0.0),
        (0.23529411852359772, 0.0, 0.0),
        (0.23949579894542694, 0.0, 0.0),
        (0.24369747936725616, 0.0, 0.0),
        (0.24789915978908539, 0.0, 0.0),
        (0.25210085511207581, 0.0, 0.0),
        (0.25630253553390503, 0.0, 0.0),
        (0.26050421595573425, 0.0, 0.0),
        (0.26470589637756348, 0.0, 0.0),
        (0.2689075767993927, 0.0, 0.0),
        (0.27310925722122192, 0.0, 0.0),
        (0.27731093764305115, 0.0, 0.0),
        (0.28151261806488037, 0.0, 0.0),
        (0.28571429848670959, 0.0, 0.0),
        (0.28991597890853882, 0.0, 0.0),
        (0.29411765933036804, 0.0, 0.0),
        (0.29831933975219727, 0.0, 0.0),
        (0.30252102017402649, 0.0, 0.0),
        (0.30672270059585571, 0.0, 0.0),
        (0.31092438101768494, 0.0, 0.0),
        (0.31512606143951416, 0.0, 0.0),
        (0.31932774186134338, 0.0, 0.0),
        (0.32352942228317261, 0.0, 0.0),
        (0.32773110270500183, 0.0, 0.0),
        (0.33193278312683105, 0.0, 0.0),
        (0.33613446354866028, 0.0, 0.0),
        (0.3403361439704895, 0.0, 0.0),
        (0.34453782439231873, 0.0, 0.0),
        (0.34873950481414795, 0.0, 0.0),
        (0.35294118523597717, 0.0, 0.0),
        (0.3571428656578064, 0.0, 0.0),
        (0.36134454607963562, 0.0, 0.0),
        (0.36554622650146484, 0.0, 0.0),
        (0.36974790692329407, 0.0, 0.0),
        (0.37394958734512329, 0.0, 0.0),
        (0.37815126776695251, 0.0, 0.0),
        (0.38235294818878174, 0.0, 0.0),
        (0.38655462861061096, 0.0, 0.0),
        (0.39075630903244019, 0.0, 0.0),
        (0.39495798945426941, 0.0, 0.0),
        (0.39915966987609863, 0.0, 0.0),
        (0.40336135029792786, 0.0, 0.0),
        (0.40756303071975708, 0.0039215688593685627, 0.0039215688593685627),
        (0.4117647111415863, 0.047058824449777603, 0.047058824449777603),
        (0.41596639156341553, 0.066666670143604279, 0.066666670143604279),
        (0.42016807198524475, 0.090196080505847931, 0.090196080505847931),
        (0.42436975240707397, 0.10980392247438431, 0.10980392247438431),
        (0.4285714328289032, 0.12941177189350128, 0.12941177189350128),
        (0.43277311325073242, 0.15294118225574493, 0.15294118225574493),
        (0.43697479367256165, 0.17254902422428131, 0.17254902422428131),
        (0.44117647409439087, 0.19215686619281769, 0.19215686619281769),
        (0.44537815451622009, 0.21568627655506134, 0.21568627655506134),
        (0.44957983493804932, 0.23529411852359772, 0.23529411852359772),
        (0.45378151535987854, 0.25882354378700256, 0.25882354378700256),
        (0.45798319578170776, 0.27843138575553894, 0.27843138575553894),
        (0.46218487620353699, 0.29803922772407532, 0.29803922772407532),
        (0.46638655662536621, 0.32156863808631897, 0.32156863808631897),
        (0.47058823704719543, 0.34117648005485535, 0.34117648005485535),
        (0.47478991746902466, 0.38431373238563538, 0.38431373238563538),
        (0.47899159789085388, 0.40392157435417175, 0.40392157435417175),
        (0.48319327831268311, 0.42745098471641541, 0.42745098471641541),
        (0.48739495873451233, 0.44705882668495178, 0.44705882668495178),
        (0.49159663915634155, 0.46666666865348816, 0.46666666865348816),
        (0.49579831957817078, 0.49019607901573181, 0.49019607901573181),
        (0.5, 0.50980395078659058, 0.50980395078659058),
        (0.50420171022415161, 0.52941179275512695, 0.52941179275512695),
        (0.50840336084365845, 0.55294120311737061, 0.55294120311737061),
        (0.51260507106781006, 0.57254904508590698, 0.57254904508590698),
        (0.51680672168731689, 0.59607845544815063, 0.59607845544815063),
        (0.52100843191146851, 0.61568629741668701, 0.61568629741668701),
        (0.52521008253097534, 0.63529413938522339, 0.63529413938522339),
        (0.52941179275512695, 0.65882354974746704, 0.65882354974746704),
        (0.53361344337463379, 0.67843139171600342, 0.67843139171600342),
        (0.5378151535987854, 0.72156864404678345, 0.72156864404678345),
        (0.54201680421829224, 0.74117648601531982, 0.74117648601531982),
        (0.54621851444244385, 0.76470589637756348, 0.76470589637756348),
        (0.55042016506195068, 0.78431373834609985, 0.78431373834609985),
        (0.55462187528610229, 0.80392158031463623, 0.80392158031463623),
        (0.55882352590560913, 0.82745099067687988, 0.82745099067687988),
        (0.56302523612976074, 0.84705883264541626, 0.84705883264541626),
        (0.56722688674926758, 0.87058824300765991, 0.87058824300765991),
        (0.57142859697341919, 0.89019608497619629, 0.89019608497619629),
        (0.57563024759292603, 0.90980392694473267, 0.90980392694473267),
        (0.57983195781707764, 0.93333333730697632, 0.93333333730697632),
        (0.58403360843658447, 0.9529411792755127, 0.9529411792755127),
        (0.58823531866073608, 0.97254902124404907, 0.97254902124404907),
        (0.59243696928024292, 0.99607843160629272, 0.99607843160629272),
        (0.59663867950439453, 1.0, 1.0),
        (0.60084033012390137, 1.0, 1.0),
        (0.60504204034805298, 1.0, 1.0),
        (0.60924369096755981, 1.0, 1.0),
        (0.61344540119171143, 1.0, 1.0),
        (0.61764705181121826, 1.0, 1.0),
        (0.62184876203536987, 1.0, 1.0),
        (0.62605041265487671, 1.0, 1.0),
        (0.63025212287902832, 1.0, 1.0),
        (0.63445377349853516, 1.0, 1.0),
        (0.63865548372268677, 1.0, 1.0),
        (0.6428571343421936, 1.0, 1.0),
        (0.64705884456634521, 1.0, 1.0),
        (0.65126049518585205, 1.0, 1.0),
        (0.65546220541000366, 1.0, 1.0),
        (0.6596638560295105, 1.0, 1.0),
        (0.66386556625366211, 1.0, 1.0),
        (0.66806721687316895, 1.0, 1.0),
        (0.67226892709732056, 1.0, 1.0),
        (0.67647057771682739, 1.0, 1.0),
        (0.680672287940979, 1.0, 1.0),
        (0.68487393856048584, 1.0, 1.0),
        (0.68907564878463745, 1.0, 1.0),
        (0.69327729940414429, 1.0, 1.0),
        (0.6974790096282959, 1.0, 1.0),
        (0.70168066024780273, 1.0, 1.0),
        (0.70588237047195435, 1.0, 1.0),
        (0.71008402109146118, 1.0, 1.0),
        (0.71428573131561279, 1.0, 1.0),
        (0.71848738193511963, 1.0, 1.0),
        (0.72268909215927124, 1.0, 1.0),
        (0.72689074277877808, 1.0, 1.0),
        (0.73109245300292969, 1.0, 1.0),
        (0.73529410362243652, 1.0, 1.0),
        (0.73949581384658813, 1.0, 1.0),
        (0.74369746446609497, 1.0, 1.0),
        (0.74789917469024658, 1.0, 1.0),
        (0.75210082530975342, 1.0, 1.0),
        (0.75630253553390503, 1.0, 1.0),
        (0.76050418615341187, 1.0, 1.0),
        (0.76470589637756348, 1.0, 1.0),
        (0.76890754699707031, 1.0, 1.0),
        (0.77310925722122192, 1.0, 1.0),
        (0.77731090784072876, 1.0, 1.0),
        (0.78151261806488037, 1.0, 1.0),
        (0.78571426868438721, 1.0, 1.0),
        (0.78991597890853882, 1.0, 1.0),
        (0.79411762952804565, 1.0, 1.0),
        (0.79831933975219727, 1.0, 1.0),
        (0.8025209903717041, 1.0, 1.0),
        (0.80672270059585571, 1.0, 1.0),
        (0.81092435121536255, 1.0, 1.0),
        (0.81512606143951416, 1.0, 1.0),
        (0.819327712059021, 1.0, 1.0),
        (0.82352942228317261, 1.0, 1.0),
        (0.82773107290267944, 1.0, 1.0),
        (0.83193278312683105, 1.0, 1.0),
        (0.83613443374633789, 1.0, 1.0),
        (0.8403361439704895, 1.0, 1.0),
        (0.84453779458999634, 1.0, 1.0),
        (0.84873950481414795, 1.0, 1.0),
        (0.85294115543365479, 1.0, 1.0),
        (0.8571428656578064, 1.0, 1.0),
        (0.86134451627731323, 1.0, 1.0),
        (0.86554622650146484, 1.0, 1.0),
        (0.86974787712097168, 1.0, 1.0),
        (0.87394958734512329, 1.0, 1.0),
        (0.87815123796463013, 1.0, 1.0),
        (0.88235294818878174, 1.0, 1.0),
        (0.88655459880828857, 1.0, 1.0),
        (0.89075630903244019, 1.0, 1.0),
        (0.89495795965194702, 1.0, 1.0),
        (0.89915966987609863, 1.0, 1.0),
        (0.90336132049560547, 1.0, 1.0),
        (0.90756303071975708, 1.0, 1.0),
        (0.91176468133926392, 1.0, 1.0),
        (0.91596639156341553, 1.0, 1.0),
        (0.92016804218292236, 1.0, 1.0),
        (0.92436975240707397, 1.0, 1.0),
        (0.92857140302658081, 1.0, 1.0),
        (0.93277311325073242, 1.0, 1.0),
        (0.93697476387023926, 1.0, 1.0),
        (0.94117647409439087, 1.0, 1.0),
        (0.94537812471389771, 1.0, 1.0),
        (0.94957983493804932, 1.0, 1.0),
        (0.95378148555755615, 1.0, 1.0),
        (0.95798319578170776, 1.0, 1.0),
        (0.9621848464012146, 1.0, 1.0),
        (0.96638655662536621, 0.99607843160629272, 0.99607843160629272),
        (0.97058820724487305, 0.97647058963775635, 0.97647058963775635),
        (0.97478991746902466, 0.9529411792755127, 0.9529411792755127),
        (0.97899156808853149, 0.91372549533843994, 0.91372549533843994),
        (0.98319327831268311, 0.89019608497619629, 0.89019608497619629),
        (0.98739492893218994, 0.87058824300765991, 0.87058824300765991),
        (0.99159663915634155, 0.85098040103912354, 0.85098040103912354),
        (0.99579828977584839, 0.82745099067687988, 0.82745099067687988),
        (1.0, 0.80784314870834351, 0.80784314870834351),
    ],
    "green": [
        (0.0, 0.0, 0.0),
        (0.0042016808874905109, 0.0, 0.0),
        (0.0084033617749810219, 0.0, 0.0),
        (0.012605042196810246, 0.0, 0.0),
        (0.016806723549962044, 0.0, 0.0),
        (0.021008403971791267, 0.0, 0.0),
        (0.025210084393620491, 0.0, 0.0),
        (0.029411764815449715, 0.0, 0.0),
        (0.033613447099924088, 0.019607843831181526, 0.019607843831181526),
        (0.037815127521753311, 0.043137256056070328, 0.043137256056070328),
        (0.042016807943582535, 0.062745101749897003, 0.062745101749897003),
        (0.046218488365411758, 0.086274512112140656, 0.086274512112140656),
        (0.050420168787240982, 0.10588235408067703, 0.10588235408067703),
        (0.054621849209070206, 0.12549020349979401, 0.12549020349979401),
        (0.058823529630899429, 0.14901961386203766, 0.14901961386203766),
        (0.063025213778018951, 0.16862745583057404, 0.16862745583057404),
        (0.067226894199848175, 0.18823529779911041, 0.18823529779911041),
        (0.071428574621677399, 0.21176470816135406, 0.21176470816135406),
        (0.075630255043506622, 0.23137255012989044, 0.23137255012989044),
        (0.079831935465335846, 0.25490197539329529, 0.25490197539329529),
        (0.08403361588716507, 0.27450981736183167, 0.27450981736183167),
        (0.088235296308994293, 0.29411765933036804, 0.29411765933036804),
        (0.092436976730823517, 0.31764706969261169, 0.31764706969261169),
        (0.09663865715265274, 0.35686275362968445, 0.35686275362968445),
        (0.10084033757448196, 0.3803921639919281, 0.3803921639919281),
        (0.10504201799631119, 0.40000000596046448, 0.40000000596046448),
        (0.10924369841814041, 0.42352941632270813, 0.42352941632270813),
        (0.11344537883996964, 0.44313725829124451, 0.44313725829124451),
        (0.11764705926179886, 0.46274510025978088, 0.46274510025978088),
        (0.12184873968362808, 0.48627451062202454, 0.48627451062202454),
        (0.1260504275560379, 0.5058823823928833, 0.5058823823928833),
        (0.13025210797786713, 0.52941179275512695, 0.52941179275512695),
        (0.13445378839969635, 0.54901963472366333, 0.54901963472366333),
        (0.13865546882152557, 0.56862747669219971, 0.56862747669219971),
        (0.1428571492433548, 0.59215688705444336, 0.59215688705444336),
        (0.14705882966518402, 0.61176472902297974, 0.61176472902297974),
        (0.15126051008701324, 0.63137257099151611, 0.63137257099151611),
        (0.15546219050884247, 0.65490198135375977, 0.65490198135375977),
        (0.15966387093067169, 0.69803923368453979, 0.69803923368453979),
        (0.16386555135250092, 0.71764707565307617, 0.71764707565307617),
        (0.16806723177433014, 0.73725491762161255, 0.73725491762161255),
        (0.17226891219615936, 0.7607843279838562, 0.7607843279838562),
        (0.17647059261798859, 0.78039216995239258, 0.78039216995239258),
        (0.18067227303981781, 0.80000001192092896, 0.80000001192092896),
        (0.18487395346164703, 0.82352942228317261, 0.82352942228317261),
        (0.18907563388347626, 0.84313726425170898, 0.84313726425170898),
        (0.19327731430530548, 0.86666667461395264, 0.86666667461395264),
        (0.1974789947271347, 0.88627451658248901, 0.88627451658248901),
        (0.20168067514896393, 0.90588235855102539, 0.90588235855102539),
        (0.20588235557079315, 0.92941176891326904, 0.92941176891326904),
        (0.21008403599262238, 0.94901961088180542, 0.94901961088180542),
        (0.2142857164144516, 0.9686274528503418, 0.9686274528503418),
        (0.21848739683628082, 0.99215686321258545, 0.99215686321258545),
        (0.22268907725811005, 1.0, 1.0),
        (0.22689075767993927, 1.0, 1.0),
        (0.23109243810176849, 1.0, 1.0),
        (0.23529411852359772, 1.0, 1.0),
        (0.23949579894542694, 1.0, 1.0),
        (0.24369747936725616, 1.0, 1.0),
        (0.24789915978908539, 1.0, 1.0),
        (0.25210085511207581, 1.0, 1.0),
        (0.25630253553390503, 1.0, 1.0),
        (0.26050421595573425, 1.0, 1.0),
        (0.26470589637756348, 1.0, 1.0),
        (0.2689075767993927, 1.0, 1.0),
        (0.27310925722122192, 1.0, 1.0),
        (0.27731093764305115, 1.0, 1.0),
        (0.28151261806488037, 1.0, 1.0),
        (0.28571429848670959, 1.0, 1.0),
        (0.28991597890853882, 1.0, 1.0),
        (0.29411765933036804, 1.0, 1.0),
        (0.29831933975219727, 1.0, 1.0),
        (0.30252102017402649, 1.0, 1.0),
        (0.30672270059585571, 1.0, 1.0),
        (0.31092438101768494, 1.0, 1.0),
        (0.31512606143951416, 1.0, 1.0),
        (0.31932774186134338, 1.0, 1.0),
        (0.32352942228317261, 1.0, 1.0),
        (0.32773110270500183, 1.0, 1.0),
        (0.33193278312683105, 1.0, 1.0),
        (0.33613446354866028, 1.0, 1.0),
        (0.3403361439704895, 1.0, 1.0),
        (0.34453782439231873, 1.0, 1.0),
        (0.34873950481414795, 1.0, 1.0),
        (0.35294118523597717, 1.0, 1.0),
        (0.3571428656578064, 1.0, 1.0),
        (0.36134454607963562, 1.0, 1.0),
        (0.36554622650146484, 1.0, 1.0),
        (0.36974790692329407, 1.0, 1.0),
        (0.37394958734512329, 1.0, 1.0),
        (0.37815126776695251, 1.0, 1.0),
        (0.38235294818878174, 1.0, 1.0),
        (0.38655462861061096, 1.0, 1.0),
        (0.39075630903244019, 1.0, 1.0),
        (0.39495798945426941, 1.0, 1.0),
        (0.39915966987609863, 1.0, 1.0),
        (0.40336135029792786, 1.0, 1.0),
        (0.40756303071975708, 1.0, 1.0),
        (0.4117647111415863, 1.0, 1.0),
        (0.41596639156341553, 1.0, 1.0),
        (0.42016807198524475, 1.0, 1.0),
        (0.42436975240707397, 1.0, 1.0),
        (0.4285714328289032, 1.0, 1.0),
        (0.43277311325073242, 1.0, 1.0),
        (0.43697479367256165, 1.0, 1.0),
        (0.44117647409439087, 1.0, 1.0),
        (0.44537815451622009, 1.0, 1.0),
        (0.44957983493804932, 1.0, 1.0),
        (0.45378151535987854, 1.0, 1.0),
        (0.45798319578170776, 1.0, 1.0),
        (0.46218487620353699, 1.0, 1.0),
        (0.46638655662536621, 1.0, 1.0),
        (0.47058823704719543, 1.0, 1.0),
        (0.47478991746902466, 1.0, 1.0),
        (0.47899159789085388, 1.0, 1.0),
        (0.48319327831268311, 1.0, 1.0),
        (0.48739495873451233, 1.0, 1.0),
        (0.49159663915634155, 1.0, 1.0),
        (0.49579831957817078, 1.0, 1.0),
        (0.5, 1.0, 1.0),
        (0.50420171022415161, 1.0, 1.0),
        (0.50840336084365845, 1.0, 1.0),
        (0.51260507106781006, 1.0, 1.0),
        (0.51680672168731689, 1.0, 1.0),
        (0.52100843191146851, 1.0, 1.0),
        (0.52521008253097534, 1.0, 1.0),
        (0.52941179275512695, 1.0, 1.0),
        (0.53361344337463379, 1.0, 1.0),
        (0.5378151535987854, 1.0, 1.0),
        (0.54201680421829224, 1.0, 1.0),
        (0.54621851444244385, 1.0, 1.0),
        (0.55042016506195068, 1.0, 1.0),
        (0.55462187528610229, 1.0, 1.0),
        (0.55882352590560913, 1.0, 1.0),
        (0.56302523612976074, 1.0, 1.0),
        (0.56722688674926758, 1.0, 1.0),
        (0.57142859697341919, 1.0, 1.0),
        (0.57563024759292603, 1.0, 1.0),
        (0.57983195781707764, 1.0, 1.0),
        (0.58403360843658447, 1.0, 1.0),
        (0.58823531866073608, 1.0, 1.0),
        (0.59243696928024292, 1.0, 1.0),
        (0.59663867950439453, 0.98039215803146362, 0.98039215803146362),
        (0.60084033012390137, 0.93725490570068359, 0.93725490570068359),
        (0.60504204034805298, 0.91764706373214722, 0.91764706373214722),
        (0.60924369096755981, 0.89411765336990356, 0.89411765336990356),
        (0.61344540119171143, 0.87450981140136719, 0.87450981140136719),
        (0.61764705181121826, 0.85490196943283081, 0.85490196943283081),
        (0.62184876203536987, 0.83137255907058716, 0.83137255907058716),
        (0.62605041265487671, 0.81176471710205078, 0.81176471710205078),
        (0.63025212287902832, 0.78823530673980713, 0.78823530673980713),
        (0.63445377349853516, 0.76862746477127075, 0.76862746477127075),
        (0.63865548372268677, 0.74901962280273438, 0.74901962280273438),
        (0.6428571343421936, 0.72549021244049072, 0.72549021244049072),
        (0.64705884456634521, 0.70588237047195435, 0.70588237047195435),
        (0.65126049518585205, 0.68235296010971069, 0.68235296010971069),
        (0.65546220541000366, 0.66274511814117432, 0.66274511814117432),
        (0.6596638560295105, 0.64313727617263794, 0.64313727617263794),
        (0.66386556625366211, 0.60000002384185791, 0.60000002384185791),
        (0.66806721687316895, 0.58039218187332153, 0.58039218187332153),
        (0.67226892709732056, 0.55686277151107788, 0.55686277151107788),
        (0.67647057771682739, 0.5372549295425415, 0.5372549295425415),
        (0.680672287940979, 0.51372551918029785, 0.51372551918029785),
        (0.68487393856048584, 0.49411764740943909, 0.49411764740943909),
        (0.68907564878463745, 0.47450980544090271, 0.47450980544090271),
        (0.69327729940414429, 0.45098039507865906, 0.45098039507865906),
        (0.6974790096282959, 0.43137255311012268, 0.43137255311012268),
        (0.70168066024780273, 0.4117647111415863, 0.4117647111415863),
        (0.70588237047195435, 0.38823530077934265, 0.38823530077934265),
        (0.71008402109146118, 0.36862745881080627, 0.36862745881080627),
        (0.71428573131561279, 0.34509804844856262, 0.34509804844856262),
        (0.71848738193511963, 0.32549020648002625, 0.32549020648002625),
        (0.72268909215927124, 0.30588236451148987, 0.30588236451148987),
        (0.72689074277877808, 0.26274511218070984, 0.26274511218070984),
        (0.73109245300292969, 0.24313725531101227, 0.24313725531101227),
        (0.73529410362243652, 0.21960784494876862, 0.21960784494876862),
        (0.73949581384658813, 0.20000000298023224, 0.20000000298023224),
        (0.74369746446609497, 0.17647059261798859, 0.17647059261798859),
        (0.74789917469024658, 0.15686275064945221, 0.15686275064945221),
        (0.75210082530975342, 0.13725490868091583, 0.13725490868091583),
        (0.75630253553390503, 0.11372549086809158, 0.11372549086809158),
        (0.76050418615341187, 0.094117648899555206, 0.094117648899555206),
        (0.76470589637756348, 0.070588238537311554, 0.070588238537311554),
        (0.76890754699707031, 0.050980392843484879, 0.050980392843484879),
        (0.77310925722122192, 0.031372550874948502, 0.031372550874948502),
        (0.77731090784072876, 0.0078431377187371254, 0.0078431377187371254),
        (0.78151261806488037, 0.0, 0.0),
        (0.78571426868438721, 0.0, 0.0),
        (0.78991597890853882, 0.0, 0.0),
        (0.79411762952804565, 0.0, 0.0),
        (0.79831933975219727, 0.0, 0.0),
        (0.8025209903717041, 0.0, 0.0),
        (0.80672270059585571, 0.0, 0.0),
        (0.81092435121536255, 0.0, 0.0),
        (0.81512606143951416, 0.0, 0.0),
        (0.819327712059021, 0.0, 0.0),
        (0.82352942228317261, 0.0, 0.0),
        (0.82773107290267944, 0.0, 0.0),
        (0.83193278312683105, 0.0, 0.0),
        (0.83613443374633789, 0.0, 0.0),
        (0.8403361439704895, 0.0, 0.0),
        (0.84453779458999634, 0.0, 0.0),
        (0.84873950481414795, 0.0, 0.0),
        (0.85294115543365479, 0.0, 0.0),
        (0.8571428656578064, 0.0, 0.0),
        (0.86134451627731323, 0.0, 0.0),
        (0.86554622650146484, 0.0, 0.0),
        (0.86974787712097168, 0.0, 0.0),
        (0.87394958734512329, 0.0, 0.0),
        (0.87815123796463013, 0.0, 0.0),
        (0.88235294818878174, 0.0, 0.0),
        (0.88655459880828857, 0.0, 0.0),
        (0.89075630903244019, 0.0, 0.0),
        (0.89495795965194702, 0.0, 0.0),
        (0.89915966987609863, 0.0, 0.0),
        (0.90336132049560547, 0.0, 0.0),
        (0.90756303071975708, 0.0, 0.0),
        (0.91176468133926392, 0.0, 0.0),
        (0.91596639156341553, 0.0, 0.0),
        (0.92016804218292236, 0.0, 0.0),
        (0.92436975240707397, 0.0, 0.0),
        (0.92857140302658081, 0.0, 0.0),
        (0.93277311325073242, 0.0, 0.0),
        (0.93697476387023926, 0.0, 0.0),
        (0.94117647409439087, 0.0, 0.0),
        (0.94537812471389771, 0.0, 0.0),
        (0.94957983493804932, 0.0, 0.0),
        (0.95378148555755615, 0.0, 0.0),
        (0.95798319578170776, 0.0, 0.0),
        (0.9621848464012146, 0.0, 0.0),
        (0.96638655662536621, 0.0, 0.0),
        (0.97058820724487305, 0.0, 0.0),
        (0.97478991746902466, 0.0, 0.0),
        (0.97899156808853149, 0.0, 0.0),
        (0.98319327831268311, 0.0, 0.0),
        (0.98739492893218994, 0.0, 0.0),
        (0.99159663915634155, 0.0, 0.0),
        (0.99579828977584839, 0.0, 0.0),
        (1.0, 0.0, 0.0),
    ],
    "red": [
        (0.0, 1.0, 1.0),
        (0.0042016808874905109, 1.0, 1.0),
        (0.0084033617749810219, 1.0, 1.0),
        (0.012605042196810246, 1.0, 1.0),
        (0.016806723549962044, 1.0, 1.0),
        (0.021008403971791267, 1.0, 1.0),
        (0.025210084393620491, 1.0, 1.0),
        (0.029411764815449715, 1.0, 1.0),
        (0.033613447099924088, 1.0, 1.0),
        (0.037815127521753311, 1.0, 1.0),
        (0.042016807943582535, 1.0, 1.0),
        (0.046218488365411758, 1.0, 1.0),
        (0.050420168787240982, 1.0, 1.0),
        (0.054621849209070206, 1.0, 1.0),
        (0.058823529630899429, 1.0, 1.0),
        (0.063025213778018951, 1.0, 1.0),
        (0.067226894199848175, 1.0, 1.0),
        (0.071428574621677399, 1.0, 1.0),
        (0.075630255043506622, 1.0, 1.0),
        (0.079831935465335846, 1.0, 1.0),
        (0.08403361588716507, 1.0, 1.0),
        (0.088235296308994293, 1.0, 1.0),
        (0.092436976730823517, 1.0, 1.0),
        (0.09663865715265274, 1.0, 1.0),
        (0.10084033757448196, 1.0, 1.0),
        (0.10504201799631119, 1.0, 1.0),
        (0.10924369841814041, 1.0, 1.0),
        (0.11344537883996964, 1.0, 1.0),
        (0.11764705926179886, 1.0, 1.0),
        (0.12184873968362808, 1.0, 1.0),
        (0.1260504275560379, 1.0, 1.0),
        (0.13025210797786713, 1.0, 1.0),
        (0.13445378839969635, 1.0, 1.0),
        (0.13865546882152557, 1.0, 1.0),
        (0.1428571492433548, 1.0, 1.0),
        (0.14705882966518402, 1.0, 1.0),
        (0.15126051008701324, 1.0, 1.0),
        (0.15546219050884247, 1.0, 1.0),
        (0.15966387093067169, 1.0, 1.0),
        (0.16386555135250092, 1.0, 1.0),
        (0.16806723177433014, 1.0, 1.0),
        (0.17226891219615936, 1.0, 1.0),
        (0.17647059261798859, 1.0, 1.0),
        (0.18067227303981781, 1.0, 1.0),
        (0.18487395346164703, 1.0, 1.0),
        (0.18907563388347626, 1.0, 1.0),
        (0.19327731430530548, 1.0, 1.0),
        (0.1974789947271347, 1.0, 1.0),
        (0.20168067514896393, 1.0, 1.0),
        (0.20588235557079315, 1.0, 1.0),
        (0.21008403599262238, 1.0, 1.0),
        (0.2142857164144516, 1.0, 1.0),
        (0.21848739683628082, 1.0, 1.0),
        (0.22268907725811005, 0.96078431606292725, 0.96078431606292725),
        (0.22689075767993927, 0.94117647409439087, 0.94117647409439087),
        (0.23109243810176849, 0.92156863212585449, 0.92156863212585449),
        (0.23529411852359772, 0.89803922176361084, 0.89803922176361084),
        (0.23949579894542694, 0.87843137979507446, 0.87843137979507446),
        (0.24369747936725616, 0.85882353782653809, 0.85882353782653809),
        (0.24789915978908539, 0.83529412746429443, 0.83529412746429443),
        (0.25210085511207581, 0.81568628549575806, 0.81568628549575806),
        (0.25630253553390503, 0.7921568751335144, 0.7921568751335144),
        (0.26050421595573425, 0.77254903316497803, 0.77254903316497803),
        (0.26470589637756348, 0.75294119119644165, 0.75294119119644165),
        (0.2689075767993927, 0.729411780834198, 0.729411780834198),
        (0.27310925722122192, 0.70980393886566162, 0.70980393886566162),
        (0.27731093764305115, 0.68627452850341797, 0.68627452850341797),
        (0.28151261806488037, 0.66666668653488159, 0.66666668653488159),
        (0.28571429848670959, 0.62352943420410156, 0.62352943420410156),
        (0.28991597890853882, 0.60392159223556519, 0.60392159223556519),
        (0.29411765933036804, 0.58431375026702881, 0.58431375026702881),
        (0.29831933975219727, 0.56078433990478516, 0.56078433990478516),
        (0.30252102017402649, 0.54117649793624878, 0.54117649793624878),
        (0.30672270059585571, 0.51764708757400513, 0.51764708757400513),
        (0.31092438101768494, 0.49803921580314636, 0.49803921580314636),
        (0.31512606143951416, 0.47843137383460999, 0.47843137383460999),
        (0.31932774186134338, 0.45490196347236633, 0.45490196347236633),
        (0.32352942228317261, 0.43529412150382996, 0.43529412150382996),
        (0.32773110270500183, 0.41568627953529358, 0.41568627953529358),
        (0.33193278312683105, 0.39215686917304993, 0.39215686917304993),
        (0.33613446354866028, 0.37254902720451355, 0.37254902720451355),
        (0.3403361439704895, 0.3490196168422699, 0.3490196168422699),
        (0.34453782439231873, 0.32941177487373352, 0.32941177487373352),
        (0.34873950481414795, 0.28627452254295349, 0.28627452254295349),
        (0.35294118523597717, 0.26666668057441711, 0.26666668057441711),
        (0.3571428656578064, 0.24705882370471954, 0.24705882370471954),
        (0.36134454607963562, 0.22352941334247589, 0.22352941334247589),
        (0.36554622650146484, 0.20392157137393951, 0.20392157137393951),
        (0.36974790692329407, 0.18039216101169586, 0.18039216101169586),
        (0.37394958734512329, 0.16078431904315948, 0.16078431904315948),
        (0.37815126776695251, 0.14117647707462311, 0.14117647707462311),
        (0.38235294818878174, 0.11764705926179886, 0.11764705926179886),
        (0.38655462861061096, 0.098039217293262482, 0.098039217293262482),
        (0.39075630903244019, 0.074509806931018829, 0.074509806931018829),
        (0.39495798945426941, 0.054901961237192154, 0.054901961237192154),
        (0.39915966987609863, 0.035294119268655777, 0.035294119268655777),
        (0.40336135029792786, 0.011764706112444401, 0.011764706112444401),
        (0.40756303071975708, 0.0, 0.0),
        (0.4117647111415863, 0.0, 0.0),
        (0.41596639156341553, 0.0, 0.0),
        (0.42016807198524475, 0.0, 0.0),
        (0.42436975240707397, 0.0, 0.0),
        (0.4285714328289032, 0.0, 0.0),
        (0.43277311325073242, 0.0, 0.0),
        (0.43697479367256165, 0.0, 0.0),
        (0.44117647409439087, 0.0, 0.0),
        (0.44537815451622009, 0.0, 0.0),
        (0.44957983493804932, 0.0, 0.0),
        (0.45378151535987854, 0.0, 0.0),
        (0.45798319578170776, 0.0, 0.0),
        (0.46218487620353699, 0.0, 0.0),
        (0.46638655662536621, 0.0, 0.0),
        (0.47058823704719543, 0.0, 0.0),
        (0.47478991746902466, 0.0, 0.0),
        (0.47899159789085388, 0.0, 0.0),
        (0.48319327831268311, 0.0, 0.0),
        (0.48739495873451233, 0.0, 0.0),
        (0.49159663915634155, 0.0, 0.0),
        (0.49579831957817078, 0.0, 0.0),
        (0.5, 0.0, 0.0),
        (0.50420171022415161, 0.0, 0.0),
        (0.50840336084365845, 0.0, 0.0),
        (0.51260507106781006, 0.0, 0.0),
        (0.51680672168731689, 0.0, 0.0),
        (0.52100843191146851, 0.0, 0.0),
        (0.52521008253097534, 0.0, 0.0),
        (0.52941179275512695, 0.0, 0.0),
        (0.53361344337463379, 0.0, 0.0),
        (0.5378151535987854, 0.0, 0.0),
        (0.54201680421829224, 0.0, 0.0),
        (0.54621851444244385, 0.0, 0.0),
        (0.55042016506195068, 0.0, 0.0),
        (0.55462187528610229, 0.0, 0.0),
        (0.55882352590560913, 0.0, 0.0),
        (0.56302523612976074, 0.0, 0.0),
        (0.56722688674926758, 0.0, 0.0),
        (0.57142859697341919, 0.0, 0.0),
        (0.57563024759292603, 0.0, 0.0),
        (0.57983195781707764, 0.0, 0.0),
        (0.58403360843658447, 0.0, 0.0),
        (0.58823531866073608, 0.0, 0.0),
        (0.59243696928024292, 0.0, 0.0),
        (0.59663867950439453, 0.0, 0.0),
        (0.60084033012390137, 0.0, 0.0),
        (0.60504204034805298, 0.0, 0.0),
        (0.60924369096755981, 0.0, 0.0),
        (0.61344540119171143, 0.0, 0.0),
        (0.61764705181121826, 0.0, 0.0),
        (0.62184876203536987, 0.0, 0.0),
        (0.62605041265487671, 0.0, 0.0),
        (0.63025212287902832, 0.0, 0.0),
        (0.63445377349853516, 0.0, 0.0),
        (0.63865548372268677, 0.0, 0.0),
        (0.6428571343421936, 0.0, 0.0),
        (0.64705884456634521, 0.0, 0.0),
        (0.65126049518585205, 0.0, 0.0),
        (0.65546220541000366, 0.0, 0.0),
        (0.6596638560295105, 0.0, 0.0),
        (0.66386556625366211, 0.0, 0.0),
        (0.66806721687316895, 0.0, 0.0),
        (0.67226892709732056, 0.0, 0.0),
        (0.67647057771682739, 0.0, 0.0),
        (0.680672287940979, 0.0, 0.0),
        (0.68487393856048584, 0.0, 0.0),
        (0.68907564878463745, 0.0, 0.0),
        (0.69327729940414429, 0.0, 0.0),
        (0.6974790096282959, 0.0, 0.0),
        (0.70168066024780273, 0.0, 0.0),
        (0.70588237047195435, 0.0, 0.0),
        (0.71008402109146118, 0.0, 0.0),
        (0.71428573131561279, 0.0, 0.0),
        (0.71848738193511963, 0.0, 0.0),
        (0.72268909215927124, 0.0, 0.0),
        (0.72689074277877808, 0.0, 0.0),
        (0.73109245300292969, 0.0, 0.0),
        (0.73529410362243652, 0.0, 0.0),
        (0.73949581384658813, 0.0, 0.0),
        (0.74369746446609497, 0.0, 0.0),
        (0.74789917469024658, 0.0, 0.0),
        (0.75210082530975342, 0.0, 0.0),
        (0.75630253553390503, 0.0, 0.0),
        (0.76050418615341187, 0.0, 0.0),
        (0.76470589637756348, 0.0, 0.0),
        (0.76890754699707031, 0.0, 0.0),
        (0.77310925722122192, 0.0, 0.0),
        (0.77731090784072876, 0.0, 0.0),
        (0.78151261806488037, 0.0078431377187371254, 0.0078431377187371254),
        (0.78571426868438721, 0.027450980618596077, 0.027450980618596077),
        (0.78991597890853882, 0.070588238537311554, 0.070588238537311554),
        (0.79411762952804565, 0.094117648899555206, 0.094117648899555206),
        (0.79831933975219727, 0.11372549086809158, 0.11372549086809158),
        (0.8025209903717041, 0.13333334028720856, 0.13333334028720856),
        (0.80672270059585571, 0.15686275064945221, 0.15686275064945221),
        (0.81092435121536255, 0.17647059261798859, 0.17647059261798859),
        (0.81512606143951416, 0.19607843458652496, 0.19607843458652496),
        (0.819327712059021, 0.21960784494876862, 0.21960784494876862),
        (0.82352942228317261, 0.23921568691730499, 0.23921568691730499),
        (0.82773107290267944, 0.26274511218070984, 0.26274511218070984),
        (0.83193278312683105, 0.28235295414924622, 0.28235295414924622),
        (0.83613443374633789, 0.30196079611778259, 0.30196079611778259),
        (0.8403361439704895, 0.32549020648002625, 0.32549020648002625),
        (0.84453779458999634, 0.34509804844856262, 0.34509804844856262),
        (0.84873950481414795, 0.364705890417099, 0.364705890417099),
        (0.85294115543365479, 0.40784314274787903, 0.40784314274787903),
        (0.8571428656578064, 0.43137255311012268, 0.43137255311012268),
        (0.86134451627731323, 0.45098039507865906, 0.45098039507865906),
        (0.86554622650146484, 0.47058823704719543, 0.47058823704719543),
        (0.86974787712097168, 0.49411764740943909, 0.49411764740943909),
        (0.87394958734512329, 0.51372551918029785, 0.51372551918029785),
        (0.87815123796463013, 0.53333336114883423, 0.53333336114883423),
        (0.88235294818878174, 0.55686277151107788, 0.55686277151107788),
        (0.88655459880828857, 0.57647061347961426, 0.57647061347961426),
        (0.89075630903244019, 0.60000002384185791, 0.60000002384185791),
        (0.89495795965194702, 0.61960786581039429, 0.61960786581039429),
        (0.89915966987609863, 0.63921570777893066, 0.63921570777893066),
        (0.90336132049560547, 0.66274511814117432, 0.66274511814117432),
        (0.90756303071975708, 0.68235296010971069, 0.68235296010971069),
        (0.91176468133926392, 0.70588237047195435, 0.70588237047195435),
        (0.91596639156341553, 0.7450980544090271, 0.7450980544090271),
        (0.92016804218292236, 0.76862746477127075, 0.76862746477127075),
        (0.92436975240707397, 0.78823530673980713, 0.78823530673980713),
        (0.92857140302658081, 0.80784314870834351, 0.80784314870834351),
        (0.93277311325073242, 0.83137255907058716, 0.83137255907058716),
        (0.93697476387023926, 0.85098040103912354, 0.85098040103912354),
        (0.94117647409439087, 0.87450981140136719, 0.87450981140136719),
        (0.94537812471389771, 0.89411765336990356, 0.89411765336990356),
        (0.94957983493804932, 0.91372549533843994, 0.91372549533843994),
        (0.95378148555755615, 0.93725490570068359, 0.93725490570068359),
        (0.95798319578170776, 0.95686274766921997, 0.95686274766921997),
        (0.9621848464012146, 0.97647058963775635, 0.97647058963775635),
        (0.96638655662536621, 1.0, 1.0),
        (0.97058820724487305, 1.0, 1.0),
        (0.97478991746902466, 1.0, 1.0),
        (0.97899156808853149, 1.0, 1.0),
        (0.98319327831268311, 1.0, 1.0),
        (0.98739492893218994, 1.0, 1.0),
        (0.99159663915634155, 1.0, 1.0),
        (0.99579828977584839, 1.0, 1.0),
        (1.0, 1.0, 1.0),
    ],
}
_gist_stern_data = {
    "blue": [
        (0.0, 0.0, 0.0),
        (0.0042016808874905109, 0.0039215688593685627, 0.0039215688593685627),
        (0.0084033617749810219, 0.011764706112444401, 0.011764706112444401),
        (0.012605042196810246, 0.019607843831181526, 0.019607843831181526),
        (0.016806723549962044, 0.027450980618596077, 0.027450980618596077),
        (0.021008403971791267, 0.035294119268655777, 0.035294119268655777),
        (0.025210084393620491, 0.043137256056070328, 0.043137256056070328),
        (0.029411764815449715, 0.050980392843484879, 0.050980392843484879),
        (0.033613447099924088, 0.058823529630899429, 0.058823529630899429),
        (0.037815127521753311, 0.066666670143604279, 0.066666670143604279),
        (0.042016807943582535, 0.08235294371843338, 0.08235294371843338),
        (0.046218488365411758, 0.090196080505847931, 0.090196080505847931),
        (0.050420168787240982, 0.098039217293262482, 0.098039217293262482),
        (0.054621849209070206, 0.10588235408067703, 0.10588235408067703),
        (0.058823529630899429, 0.11372549086809158, 0.11372549086809158),
        (0.063025213778018951, 0.12156862765550613, 0.12156862765550613),
        (0.067226894199848175, 0.12941177189350128, 0.12941177189350128),
        (0.071428574621677399, 0.13725490868091583, 0.13725490868091583),
        (0.075630255043506622, 0.14509804546833038, 0.14509804546833038),
        (0.079831935465335846, 0.15294118225574493, 0.15294118225574493),
        (0.08403361588716507, 0.16078431904315948, 0.16078431904315948),
        (0.088235296308994293, 0.16862745583057404, 0.16862745583057404),
        (0.092436976730823517, 0.17647059261798859, 0.17647059261798859),
        (0.09663865715265274, 0.18431372940540314, 0.18431372940540314),
        (0.10084033757448196, 0.19215686619281769, 0.19215686619281769),
        (0.10504201799631119, 0.20000000298023224, 0.20000000298023224),
        (0.10924369841814041, 0.20784313976764679, 0.20784313976764679),
        (0.11344537883996964, 0.21568627655506134, 0.21568627655506134),
        (0.11764705926179886, 0.22352941334247589, 0.22352941334247589),
        (0.12184873968362808, 0.23137255012989044, 0.23137255012989044),
        (0.1260504275560379, 0.24705882370471954, 0.24705882370471954),
        (0.13025210797786713, 0.25490197539329529, 0.25490197539329529),
        (0.13445378839969635, 0.26274511218070984, 0.26274511218070984),
        (0.13865546882152557, 0.27058824896812439, 0.27058824896812439),
        (0.1428571492433548, 0.27843138575553894, 0.27843138575553894),
        (0.14705882966518402, 0.28627452254295349, 0.28627452254295349),
        (0.15126051008701324, 0.29411765933036804, 0.29411765933036804),
        (0.15546219050884247, 0.30196079611778259, 0.30196079611778259),
        (0.15966387093067169, 0.30980393290519714, 0.30980393290519714),
        (0.16386555135250092, 0.31764706969261169, 0.31764706969261169),
        (0.16806723177433014, 0.32549020648002625, 0.32549020648002625),
        (0.17226891219615936, 0.3333333432674408, 0.3333333432674408),
        (0.17647059261798859, 0.34117648005485535, 0.34117648005485535),
        (0.18067227303981781, 0.3490196168422699, 0.3490196168422699),
        (0.18487395346164703, 0.35686275362968445, 0.35686275362968445),
        (0.18907563388347626, 0.364705890417099, 0.364705890417099),
        (0.19327731430530548, 0.37254902720451355, 0.37254902720451355),
        (0.1974789947271347, 0.3803921639919281, 0.3803921639919281),
        (0.20168067514896393, 0.38823530077934265, 0.38823530077934265),
        (0.20588235557079315, 0.3960784375667572, 0.3960784375667572),
        (0.21008403599262238, 0.4117647111415863, 0.4117647111415863),
        (0.2142857164144516, 0.41960784792900085, 0.41960784792900085),
        (0.21848739683628082, 0.42745098471641541, 0.42745098471641541),
        (0.22268907725811005, 0.43529412150382996, 0.43529412150382996),
        (0.22689075767993927, 0.44313725829124451, 0.44313725829124451),
        (0.23109243810176849, 0.45098039507865906, 0.45098039507865906),
        (0.23529411852359772, 0.45882353186607361, 0.45882353186607361),
        (0.23949579894542694, 0.46666666865348816, 0.46666666865348816),
        (0.24369747936725616, 0.47450980544090271, 0.47450980544090271),
        (0.24789915978908539, 0.48235294222831726, 0.48235294222831726),
        (0.25210085511207581, 0.49803921580314636, 0.49803921580314636),
        (0.25630253553390503, 0.5058823823928833, 0.5058823823928833),
        (0.26050421595573425, 0.51372551918029785, 0.51372551918029785),
        (0.26470589637756348, 0.5215686559677124, 0.5215686559677124),
        (0.2689075767993927, 0.52941179275512695, 0.52941179275512695),
        (0.27310925722122192, 0.5372549295425415, 0.5372549295425415),
        (0.27731093764305115, 0.54509806632995605, 0.54509806632995605),
        (0.28151261806488037, 0.55294120311737061, 0.55294120311737061),
        (0.28571429848670959, 0.56078433990478516, 0.56078433990478516),
        (0.28991597890853882, 0.56862747669219971, 0.56862747669219971),
        (0.29411765933036804, 0.58431375026702881, 0.58431375026702881),
        (0.29831933975219727, 0.59215688705444336, 0.59215688705444336),
        (0.30252102017402649, 0.60000002384185791, 0.60000002384185791),
        (0.30672270059585571, 0.60784316062927246, 0.60784316062927246),
        (0.31092438101768494, 0.61568629741668701, 0.61568629741668701),
        (0.31512606143951416, 0.62352943420410156, 0.62352943420410156),
        (0.31932774186134338, 0.63137257099151611, 0.63137257099151611),
        (0.32352942228317261, 0.63921570777893066, 0.63921570777893066),
        (0.32773110270500183, 0.64705884456634521, 0.64705884456634521),
        (0.33193278312683105, 0.65490198135375977, 0.65490198135375977),
        (0.33613446354866028, 0.66274511814117432, 0.66274511814117432),
        (0.3403361439704895, 0.67058825492858887, 0.67058825492858887),
        (0.34453782439231873, 0.67843139171600342, 0.67843139171600342),
        (0.34873950481414795, 0.68627452850341797, 0.68627452850341797),
        (0.35294118523597717, 0.69411766529083252, 0.69411766529083252),
        (0.3571428656578064, 0.70196080207824707, 0.70196080207824707),
        (0.36134454607963562, 0.70980393886566162, 0.70980393886566162),
        (0.36554622650146484, 0.71764707565307617, 0.71764707565307617),
        (0.36974790692329407, 0.72549021244049072, 0.72549021244049072),
        (0.37394958734512329, 0.73333334922790527, 0.73333334922790527),
        (0.37815126776695251, 0.74901962280273438, 0.74901962280273438),
        (0.38235294818878174, 0.75686275959014893, 0.75686275959014893),
        (0.38655462861061096, 0.76470589637756348, 0.76470589637756348),
        (0.39075630903244019, 0.77254903316497803, 0.77254903316497803),
        (0.39495798945426941, 0.78039216995239258, 0.78039216995239258),
        (0.39915966987609863, 0.78823530673980713, 0.78823530673980713),
        (0.40336135029792786, 0.79607844352722168, 0.79607844352722168),
        (0.40756303071975708, 0.80392158031463623, 0.80392158031463623),
        (0.4117647111415863, 0.81176471710205078, 0.81176471710205078),
        (0.41596639156341553, 0.81960785388946533, 0.81960785388946533),
        (0.42016807198524475, 0.82745099067687988, 0.82745099067687988),
        (0.42436975240707397, 0.83529412746429443, 0.83529412746429443),
        (0.4285714328289032, 0.84313726425170898, 0.84313726425170898),
        (0.43277311325073242, 0.85098040103912354, 0.85098040103912354),
        (0.43697479367256165, 0.85882353782653809, 0.85882353782653809),
        (0.44117647409439087, 0.86666667461395264, 0.86666667461395264),
        (0.44537815451622009, 0.87450981140136719, 0.87450981140136719),
        (0.44957983493804932, 0.88235294818878174, 0.88235294818878174),
        (0.45378151535987854, 0.89019608497619629, 0.89019608497619629),
        (0.45798319578170776, 0.89803922176361084, 0.89803922176361084),
        (0.46218487620353699, 0.91372549533843994, 0.91372549533843994),
        (0.46638655662536621, 0.92156863212585449, 0.92156863212585449),
        (0.47058823704719543, 0.92941176891326904, 0.92941176891326904),
        (0.47478991746902466, 0.93725490570068359, 0.93725490570068359),
        (0.47899159789085388, 0.94509804248809814, 0.94509804248809814),
        (0.48319327831268311, 0.9529411792755127, 0.9529411792755127),
        (0.48739495873451233, 0.96078431606292725, 0.96078431606292725),
        (0.49159663915634155, 0.9686274528503418, 0.9686274528503418),
        (0.49579831957817078, 0.97647058963775635, 0.97647058963775635),
        (0.5, 0.9843137264251709, 0.9843137264251709),
        (0.50420171022415161, 1.0, 1.0),
        (0.50840336084365845, 0.9843137264251709, 0.9843137264251709),
        (0.51260507106781006, 0.9686274528503418, 0.9686274528503418),
        (0.51680672168731689, 0.9529411792755127, 0.9529411792755127),
        (0.52100843191146851, 0.93333333730697632, 0.93333333730697632),
        (0.52521008253097534, 0.91764706373214722, 0.91764706373214722),
        (0.52941179275512695, 0.90196079015731812, 0.90196079015731812),
        (0.53361344337463379, 0.88627451658248901, 0.88627451658248901),
        (0.5378151535987854, 0.86666667461395264, 0.86666667461395264),
        (0.54201680421829224, 0.85098040103912354, 0.85098040103912354),
        (0.54621851444244385, 0.81960785388946533, 0.81960785388946533),
        (0.55042016506195068, 0.80000001192092896, 0.80000001192092896),
        (0.55462187528610229, 0.78431373834609985, 0.78431373834609985),
        (0.55882352590560913, 0.76862746477127075, 0.76862746477127075),
        (0.56302523612976074, 0.75294119119644165, 0.75294119119644165),
        (0.56722688674926758, 0.73333334922790527, 0.73333334922790527),
        (0.57142859697341919, 0.71764707565307617, 0.71764707565307617),
        (0.57563024759292603, 0.70196080207824707, 0.70196080207824707),
        (0.57983195781707764, 0.68627452850341797, 0.68627452850341797),
        (0.58403360843658447, 0.66666668653488159, 0.66666668653488159),
        (0.58823531866073608, 0.65098041296005249, 0.65098041296005249),
        (0.59243696928024292, 0.63529413938522339, 0.63529413938522339),
        (0.59663867950439453, 0.61960786581039429, 0.61960786581039429),
        (0.60084033012390137, 0.60000002384185791, 0.60000002384185791),
        (0.60504204034805298, 0.58431375026702881, 0.58431375026702881),
        (0.60924369096755981, 0.56862747669219971, 0.56862747669219971),
        (0.61344540119171143, 0.55294120311737061, 0.55294120311737061),
        (0.61764705181121826, 0.53333336114883423, 0.53333336114883423),
        (0.62184876203536987, 0.51764708757400513, 0.51764708757400513),
        (0.62605041265487671, 0.50196081399917603, 0.50196081399917603),
        (0.63025212287902832, 0.46666666865348816, 0.46666666865348816),
        (0.63445377349853516, 0.45098039507865906, 0.45098039507865906),
        (0.63865548372268677, 0.43529412150382996, 0.43529412150382996),
        (0.6428571343421936, 0.41960784792900085, 0.41960784792900085),
        (0.64705884456634521, 0.40000000596046448, 0.40000000596046448),
        (0.65126049518585205, 0.38431373238563538, 0.38431373238563538),
        (0.65546220541000366, 0.36862745881080627, 0.36862745881080627),
        (0.6596638560295105, 0.35294118523597717, 0.35294118523597717),
        (0.66386556625366211, 0.3333333432674408, 0.3333333432674408),
        (0.66806721687316895, 0.31764706969261169, 0.31764706969261169),
        (0.67226892709732056, 0.30196079611778259, 0.30196079611778259),
        (0.67647057771682739, 0.28627452254295349, 0.28627452254295349),
        (0.680672287940979, 0.26666668057441711, 0.26666668057441711),
        (0.68487393856048584, 0.25098040699958801, 0.25098040699958801),
        (0.68907564878463745, 0.23529411852359772, 0.23529411852359772),
        (0.69327729940414429, 0.21960784494876862, 0.21960784494876862),
        (0.6974790096282959, 0.20000000298023224, 0.20000000298023224),
        (0.70168066024780273, 0.18431372940540314, 0.18431372940540314),
        (0.70588237047195435, 0.16862745583057404, 0.16862745583057404),
        (0.71008402109146118, 0.15294118225574493, 0.15294118225574493),
        (0.71428573131561279, 0.11764705926179886, 0.11764705926179886),
        (0.71848738193511963, 0.10196078568696976, 0.10196078568696976),
        (0.72268909215927124, 0.086274512112140656, 0.086274512112140656),
        (0.72689074277877808, 0.066666670143604279, 0.066666670143604279),
        (0.73109245300292969, 0.050980392843484879, 0.050980392843484879),
        (0.73529410362243652, 0.035294119268655777, 0.035294119268655777),
        (0.73949581384658813, 0.019607843831181526, 0.019607843831181526),
        (0.74369746446609497, 0.0, 0.0),
        (0.74789917469024658, 0.011764706112444401, 0.011764706112444401),
        (0.75210082530975342, 0.027450980618596077, 0.027450980618596077),
        (0.75630253553390503, 0.058823529630899429, 0.058823529630899429),
        (0.76050418615341187, 0.074509806931018829, 0.074509806931018829),
        (0.76470589637756348, 0.086274512112140656, 0.086274512112140656),
        (0.76890754699707031, 0.10196078568696976, 0.10196078568696976),
        (0.77310925722122192, 0.11764705926179886, 0.11764705926179886),
        (0.77731090784072876, 0.13333334028720856, 0.13333334028720856),
        (0.78151261806488037, 0.14901961386203766, 0.14901961386203766),
        (0.78571426868438721, 0.16078431904315948, 0.16078431904315948),
        (0.78991597890853882, 0.17647059261798859, 0.17647059261798859),
        (0.79411762952804565, 0.19215686619281769, 0.19215686619281769),
        (0.79831933975219727, 0.22352941334247589, 0.22352941334247589),
        (0.8025209903717041, 0.23529411852359772, 0.23529411852359772),
        (0.80672270059585571, 0.25098040699958801, 0.25098040699958801),
        (0.81092435121536255, 0.26666668057441711, 0.26666668057441711),
        (0.81512606143951416, 0.28235295414924622, 0.28235295414924622),
        (0.819327712059021, 0.29803922772407532, 0.29803922772407532),
        (0.82352942228317261, 0.30980393290519714, 0.30980393290519714),
        (0.82773107290267944, 0.32549020648002625, 0.32549020648002625),
        (0.83193278312683105, 0.34117648005485535, 0.34117648005485535),
        (0.83613443374633789, 0.35686275362968445, 0.35686275362968445),
        (0.8403361439704895, 0.37254902720451355, 0.37254902720451355),
        (0.84453779458999634, 0.38431373238563538, 0.38431373238563538),
        (0.84873950481414795, 0.40000000596046448, 0.40000000596046448),
        (0.85294115543365479, 0.41568627953529358, 0.41568627953529358),
        (0.8571428656578064, 0.43137255311012268, 0.43137255311012268),
        (0.86134451627731323, 0.44705882668495178, 0.44705882668495178),
        (0.86554622650146484, 0.45882353186607361, 0.45882353186607361),
        (0.86974787712097168, 0.47450980544090271, 0.47450980544090271),
        (0.87394958734512329, 0.49019607901573181, 0.49019607901573181),
        (0.87815123796463013, 0.5058823823928833, 0.5058823823928833),
        (0.88235294818878174, 0.5372549295425415, 0.5372549295425415),
        (0.88655459880828857, 0.54901963472366333, 0.54901963472366333),
        (0.89075630903244019, 0.56470590829849243, 0.56470590829849243),
        (0.89495795965194702, 0.58039218187332153, 0.58039218187332153),
        (0.89915966987609863, 0.59607845544815063, 0.59607845544815063),
        (0.90336132049560547, 0.61176472902297974, 0.61176472902297974),
        (0.90756303071975708, 0.62352943420410156, 0.62352943420410156),
        (0.91176468133926392, 0.63921570777893066, 0.63921570777893066),
        (0.91596639156341553, 0.65490198135375977, 0.65490198135375977),
        (0.92016804218292236, 0.67058825492858887, 0.67058825492858887),
        (0.92436975240707397, 0.68627452850341797, 0.68627452850341797),
        (0.92857140302658081, 0.69803923368453979, 0.69803923368453979),
        (0.93277311325073242, 0.7137255072593689, 0.7137255072593689),
        (0.93697476387023926, 0.729411780834198, 0.729411780834198),
        (0.94117647409439087, 0.7450980544090271, 0.7450980544090271),
        (0.94537812471389771, 0.7607843279838562, 0.7607843279838562),
        (0.94957983493804932, 0.77254903316497803, 0.77254903316497803),
        (0.95378148555755615, 0.78823530673980713, 0.78823530673980713),
        (0.95798319578170776, 0.80392158031463623, 0.80392158031463623),
        (0.9621848464012146, 0.81960785388946533, 0.81960785388946533),
        (0.96638655662536621, 0.84705883264541626, 0.84705883264541626),
        (0.97058820724487305, 0.86274510622024536, 0.86274510622024536),
        (0.97478991746902466, 0.87843137979507446, 0.87843137979507446),
        (0.97899156808853149, 0.89411765336990356, 0.89411765336990356),
        (0.98319327831268311, 0.90980392694473267, 0.90980392694473267),
        (0.98739492893218994, 0.92156863212585449, 0.92156863212585449),
        (0.99159663915634155, 0.93725490570068359, 0.93725490570068359),
        (0.99579828977584839, 0.9529411792755127, 0.9529411792755127),
        (1.0, 0.9686274528503418, 0.9686274528503418),
    ],
    "green": [
        (0.0, 0.0, 0.0),
        (0.0042016808874905109, 0.0039215688593685627, 0.0039215688593685627),
        (0.0084033617749810219, 0.0078431377187371254, 0.0078431377187371254),
        (0.012605042196810246, 0.011764706112444401, 0.011764706112444401),
        (0.016806723549962044, 0.015686275437474251, 0.015686275437474251),
        (0.021008403971791267, 0.019607843831181526, 0.019607843831181526),
        (0.025210084393620491, 0.023529412224888802, 0.023529412224888802),
        (0.029411764815449715, 0.027450980618596077, 0.027450980618596077),
        (0.033613447099924088, 0.031372550874948502, 0.031372550874948502),
        (0.037815127521753311, 0.035294119268655777, 0.035294119268655777),
        (0.042016807943582535, 0.043137256056070328, 0.043137256056070328),
        (0.046218488365411758, 0.047058824449777603, 0.047058824449777603),
        (0.050420168787240982, 0.050980392843484879, 0.050980392843484879),
        (0.054621849209070206, 0.054901961237192154, 0.054901961237192154),
        (0.058823529630899429, 0.058823529630899429, 0.058823529630899429),
        (0.063025213778018951, 0.062745101749897003, 0.062745101749897003),
        (0.067226894199848175, 0.066666670143604279, 0.066666670143604279),
        (0.071428574621677399, 0.070588238537311554, 0.070588238537311554),
        (0.075630255043506622, 0.074509806931018829, 0.074509806931018829),
        (0.079831935465335846, 0.078431375324726105, 0.078431375324726105),
        (0.08403361588716507, 0.08235294371843338, 0.08235294371843338),
        (0.088235296308994293, 0.086274512112140656, 0.086274512112140656),
        (0.092436976730823517, 0.090196080505847931, 0.090196080505847931),
        (0.09663865715265274, 0.094117648899555206, 0.094117648899555206),
        (0.10084033757448196, 0.098039217293262482, 0.098039217293262482),
        (0.10504201799631119, 0.10196078568696976, 0.10196078568696976),
        (0.10924369841814041, 0.10588235408067703, 0.10588235408067703),
        (0.11344537883996964, 0.10980392247438431, 0.10980392247438431),
        (0.11764705926179886, 0.11372549086809158, 0.11372549086809158),
        (0.12184873968362808, 0.11764705926179886, 0.11764705926179886),
        (0.1260504275560379, 0.12549020349979401, 0.12549020349979401),
        (0.13025210797786713, 0.12941177189350128, 0.12941177189350128),
        (0.13445378839969635, 0.13333334028720856, 0.13333334028720856),
        (0.13865546882152557, 0.13725490868091583, 0.13725490868091583),
        (0.1428571492433548, 0.14117647707462311, 0.14117647707462311),
        (0.14705882966518402, 0.14509804546833038, 0.14509804546833038),
        (0.15126051008701324, 0.14901961386203766, 0.14901961386203766),
        (0.15546219050884247, 0.15294118225574493, 0.15294118225574493),
        (0.15966387093067169, 0.15686275064945221, 0.15686275064945221),
        (0.16386555135250092, 0.16078431904315948, 0.16078431904315948),
        (0.16806723177433014, 0.16470588743686676, 0.16470588743686676),
        (0.17226891219615936, 0.16862745583057404, 0.16862745583057404),
        (0.17647059261798859, 0.17254902422428131, 0.17254902422428131),
        (0.18067227303981781, 0.17647059261798859, 0.17647059261798859),
        (0.18487395346164703, 0.18039216101169586, 0.18039216101169586),
        (0.18907563388347626, 0.18431372940540314, 0.18431372940540314),
        (0.19327731430530548, 0.18823529779911041, 0.18823529779911041),
        (0.1974789947271347, 0.19215686619281769, 0.19215686619281769),
        (0.20168067514896393, 0.19607843458652496, 0.19607843458652496),
        (0.20588235557079315, 0.20000000298023224, 0.20000000298023224),
        (0.21008403599262238, 0.20784313976764679, 0.20784313976764679),
        (0.2142857164144516, 0.21176470816135406, 0.21176470816135406),
        (0.21848739683628082, 0.21568627655506134, 0.21568627655506134),
        (0.22268907725811005, 0.21960784494876862, 0.21960784494876862),
        (0.22689075767993927, 0.22352941334247589, 0.22352941334247589),
        (0.23109243810176849, 0.22745098173618317, 0.22745098173618317),
        (0.23529411852359772, 0.23137255012989044, 0.23137255012989044),
        (0.23949579894542694, 0.23529411852359772, 0.23529411852359772),
        (0.24369747936725616, 0.23921568691730499, 0.23921568691730499),
        (0.24789915978908539, 0.24313725531101227, 0.24313725531101227),
        (0.25210085511207581, 0.25098040699958801, 0.25098040699958801),
        (0.25630253553390503, 0.25490197539329529, 0.25490197539329529),
        (0.26050421595573425, 0.25882354378700256, 0.25882354378700256),
        (0.26470589637756348, 0.26274511218070984, 0.26274511218070984),
        (0.2689075767993927, 0.26666668057441711, 0.26666668057441711),
        (0.27310925722122192, 0.27058824896812439, 0.27058824896812439),
        (0.27731093764305115, 0.27450981736183167, 0.27450981736183167),
        (0.28151261806488037, 0.27843138575553894, 0.27843138575553894),
        (0.28571429848670959, 0.28235295414924622, 0.28235295414924622),
        (0.28991597890853882, 0.28627452254295349, 0.28627452254295349),
        (0.29411765933036804, 0.29411765933036804, 0.29411765933036804),
        (0.29831933975219727, 0.29803922772407532, 0.29803922772407532),
        (0.30252102017402649, 0.30196079611778259, 0.30196079611778259),
        (0.30672270059585571, 0.30588236451148987, 0.30588236451148987),
        (0.31092438101768494, 0.30980393290519714, 0.30980393290519714),
        (0.31512606143951416, 0.31372550129890442, 0.31372550129890442),
        (0.31932774186134338, 0.31764706969261169, 0.31764706969261169),
        (0.32352942228317261, 0.32156863808631897, 0.32156863808631897),
        (0.32773110270500183, 0.32549020648002625, 0.32549020648002625),
        (0.33193278312683105, 0.32941177487373352, 0.32941177487373352),
        (0.33613446354866028, 0.3333333432674408, 0.3333333432674408),
        (0.3403361439704895, 0.33725491166114807, 0.33725491166114807),
        (0.34453782439231873, 0.34117648005485535, 0.34117648005485535),
        (0.34873950481414795, 0.34509804844856262, 0.34509804844856262),
        (0.35294118523597717, 0.3490196168422699, 0.3490196168422699),
        (0.3571428656578064, 0.35294118523597717, 0.35294118523597717),
        (0.36134454607963562, 0.35686275362968445, 0.35686275362968445),
        (0.36554622650146484, 0.36078432202339172, 0.36078432202339172),
        (0.36974790692329407, 0.364705890417099, 0.364705890417099),
        (0.37394958734512329, 0.36862745881080627, 0.36862745881080627),
        (0.37815126776695251, 0.37647059559822083, 0.37647059559822083),
        (0.38235294818878174, 0.3803921639919281, 0.3803921639919281),
        (0.38655462861061096, 0.38431373238563538, 0.38431373238563538),
        (0.39075630903244019, 0.38823530077934265, 0.38823530077934265),
        (0.39495798945426941, 0.39215686917304993, 0.39215686917304993),
        (0.39915966987609863, 0.3960784375667572, 0.3960784375667572),
        (0.40336135029792786, 0.40000000596046448, 0.40000000596046448),
        (0.40756303071975708, 0.40392157435417175, 0.40392157435417175),
        (0.4117647111415863, 0.40784314274787903, 0.40784314274787903),
        (0.41596639156341553, 0.4117647111415863, 0.4117647111415863),
        (0.42016807198524475, 0.41568627953529358, 0.41568627953529358),
        (0.42436975240707397, 0.41960784792900085, 0.41960784792900085),
        (0.4285714328289032, 0.42352941632270813, 0.42352941632270813),
        (0.43277311325073242, 0.42745098471641541, 0.42745098471641541),
        (0.43697479367256165, 0.43137255311012268, 0.43137255311012268),
        (0.44117647409439087, 0.43529412150382996, 0.43529412150382996),
        (0.44537815451622009, 0.43921568989753723, 0.43921568989753723),
        (0.44957983493804932, 0.44313725829124451, 0.44313725829124451),
        (0.45378151535987854, 0.44705882668495178, 0.44705882668495178),
        (0.45798319578170776, 0.45098039507865906, 0.45098039507865906),
        (0.46218487620353699, 0.45882353186607361, 0.45882353186607361),
        (0.46638655662536621, 0.46274510025978088, 0.46274510025978088),
        (0.47058823704719543, 0.46666666865348816, 0.46666666865348816),
        (0.47478991746902466, 0.47058823704719543, 0.47058823704719543),
        (0.47899159789085388, 0.47450980544090271, 0.47450980544090271),
        (0.48319327831268311, 0.47843137383460999, 0.47843137383460999),
        (0.48739495873451233, 0.48235294222831726, 0.48235294222831726),
        (0.49159663915634155, 0.48627451062202454, 0.48627451062202454),
        (0.49579831957817078, 0.49019607901573181, 0.49019607901573181),
        (0.5, 0.49411764740943909, 0.49411764740943909),
        (0.50420171022415161, 0.50196081399917603, 0.50196081399917603),
        (0.50840336084365845, 0.5058823823928833, 0.5058823823928833),
        (0.51260507106781006, 0.50980395078659058, 0.50980395078659058),
        (0.51680672168731689, 0.51372551918029785, 0.51372551918029785),
        (0.52100843191146851, 0.51764708757400513, 0.51764708757400513),
        (0.52521008253097534, 0.5215686559677124, 0.5215686559677124),
        (0.52941179275512695, 0.52549022436141968, 0.52549022436141968),
        (0.53361344337463379, 0.52941179275512695, 0.52941179275512695),
        (0.5378151535987854, 0.53333336114883423, 0.53333336114883423),
        (0.54201680421829224, 0.5372549295425415, 0.5372549295425415),
        (0.54621851444244385, 0.54509806632995605, 0.54509806632995605),
        (0.55042016506195068, 0.54901963472366333, 0.54901963472366333),
        (0.55462187528610229, 0.55294120311737061, 0.55294120311737061),
        (0.55882352590560913, 0.55686277151107788, 0.55686277151107788),
        (0.56302523612976074, 0.56078433990478516, 0.56078433990478516),
        (0.56722688674926758, 0.56470590829849243, 0.56470590829849243),
        (0.57142859697341919, 0.56862747669219971, 0.56862747669219971),
        (0.57563024759292603, 0.57254904508590698, 0.57254904508590698),
        (0.57983195781707764, 0.57647061347961426, 0.57647061347961426),
        (0.58403360843658447, 0.58039218187332153, 0.58039218187332153),
        (0.58823531866073608, 0.58431375026702881, 0.58431375026702881),
        (0.59243696928024292, 0.58823531866073608, 0.58823531866073608),
        (0.59663867950439453, 0.59215688705444336, 0.59215688705444336),
        (0.60084033012390137, 0.59607845544815063, 0.59607845544815063),
        (0.60504204034805298, 0.60000002384185791, 0.60000002384185791),
        (0.60924369096755981, 0.60392159223556519, 0.60392159223556519),
        (0.61344540119171143, 0.60784316062927246, 0.60784316062927246),
        (0.61764705181121826, 0.61176472902297974, 0.61176472902297974),
        (0.62184876203536987, 0.61568629741668701, 0.61568629741668701),
        (0.62605041265487671, 0.61960786581039429, 0.61960786581039429),
        (0.63025212287902832, 0.62745100259780884, 0.62745100259780884),
        (0.63445377349853516, 0.63137257099151611, 0.63137257099151611),
        (0.63865548372268677, 0.63529413938522339, 0.63529413938522339),
        (0.6428571343421936, 0.63921570777893066, 0.63921570777893066),
        (0.64705884456634521, 0.64313727617263794, 0.64313727617263794),
        (0.65126049518585205, 0.64705884456634521, 0.64705884456634521),
        (0.65546220541000366, 0.65098041296005249, 0.65098041296005249),
        (0.6596638560295105, 0.65490198135375977, 0.65490198135375977),
        (0.66386556625366211, 0.65882354974746704, 0.65882354974746704),
        (0.66806721687316895, 0.66274511814117432, 0.66274511814117432),
        (0.67226892709732056, 0.66666668653488159, 0.66666668653488159),
        (0.67647057771682739, 0.67058825492858887, 0.67058825492858887),
        (0.680672287940979, 0.67450982332229614, 0.67450982332229614),
        (0.68487393856048584, 0.67843139171600342, 0.67843139171600342),
        (0.68907564878463745, 0.68235296010971069, 0.68235296010971069),
        (0.69327729940414429, 0.68627452850341797, 0.68627452850341797),
        (0.6974790096282959, 0.69019609689712524, 0.69019609689712524),
        (0.70168066024780273, 0.69411766529083252, 0.69411766529083252),
        (0.70588237047195435, 0.69803923368453979, 0.69803923368453979),
        (0.71008402109146118, 0.70196080207824707, 0.70196080207824707),
        (0.71428573131561279, 0.70980393886566162, 0.70980393886566162),
        (0.71848738193511963, 0.7137255072593689, 0.7137255072593689),
        (0.72268909215927124, 0.71764707565307617, 0.71764707565307617),
        (0.72689074277877808, 0.72156864404678345, 0.72156864404678345),
        (0.73109245300292969, 0.72549021244049072, 0.72549021244049072),
        (0.73529410362243652, 0.729411780834198, 0.729411780834198),
        (0.73949581384658813, 0.73333334922790527, 0.73333334922790527),
        (0.74369746446609497, 0.73725491762161255, 0.73725491762161255),
        (0.74789917469024658, 0.74117648601531982, 0.74117648601531982),
        (0.75210082530975342, 0.7450980544090271, 0.7450980544090271),
        (0.75630253553390503, 0.75294119119644165, 0.75294119119644165),
        (0.76050418615341187, 0.75686275959014893, 0.75686275959014893),
        (0.76470589637756348, 0.7607843279838562, 0.7607843279838562),
        (0.76890754699707031, 0.76470589637756348, 0.76470589637756348),
        (0.77310925722122192, 0.76862746477127075, 0.76862746477127075),
        (0.77731090784072876, 0.77254903316497803, 0.77254903316497803),
        (0.78151261806488037, 0.7764706015586853, 0.7764706015586853),
        (0.78571426868438721, 0.78039216995239258, 0.78039216995239258),
        (0.78991597890853882, 0.78431373834609985, 0.78431373834609985),
        (0.79411762952804565, 0.78823530673980713, 0.78823530673980713),
        (0.79831933975219727, 0.79607844352722168, 0.79607844352722168),
        (0.8025209903717041, 0.80000001192092896, 0.80000001192092896),
        (0.80672270059585571, 0.80392158031463623, 0.80392158031463623),
        (0.81092435121536255, 0.80784314870834351, 0.80784314870834351),
        (0.81512606143951416, 0.81176471710205078, 0.81176471710205078),
        (0.819327712059021, 0.81568628549575806, 0.81568628549575806),
        (0.82352942228317261, 0.81960785388946533, 0.81960785388946533),
        (0.82773107290267944, 0.82352942228317261, 0.82352942228317261),
        (0.83193278312683105, 0.82745099067687988, 0.82745099067687988),
        (0.83613443374633789, 0.83137255907058716, 0.83137255907058716),
        (0.8403361439704895, 0.83529412746429443, 0.83529412746429443),
        (0.84453779458999634, 0.83921569585800171, 0.83921569585800171),
        (0.84873950481414795, 0.84313726425170898, 0.84313726425170898),
        (0.85294115543365479, 0.84705883264541626, 0.84705883264541626),
        (0.8571428656578064, 0.85098040103912354, 0.85098040103912354),
        (0.86134451627731323, 0.85490196943283081, 0.85490196943283081),
        (0.86554622650146484, 0.85882353782653809, 0.85882353782653809),
        (0.86974787712097168, 0.86274510622024536, 0.86274510622024536),
        (0.87394958734512329, 0.86666667461395264, 0.86666667461395264),
        (0.87815123796463013, 0.87058824300765991, 0.87058824300765991),
        (0.88235294818878174, 0.87843137979507446, 0.87843137979507446),
        (0.88655459880828857, 0.88235294818878174, 0.88235294818878174),
        (0.89075630903244019, 0.88627451658248901, 0.88627451658248901),
        (0.89495795965194702, 0.89019608497619629, 0.89019608497619629),
        (0.89915966987609863, 0.89411765336990356, 0.89411765336990356),
        (0.90336132049560547, 0.89803922176361084, 0.89803922176361084),
        (0.90756303071975708, 0.90196079015731812, 0.90196079015731812),
        (0.91176468133926392, 0.90588235855102539, 0.90588235855102539),
        (0.91596639156341553, 0.90980392694473267, 0.90980392694473267),
        (0.92016804218292236, 0.91372549533843994, 0.91372549533843994),
        (0.92436975240707397, 0.91764706373214722, 0.91764706373214722),
        (0.92857140302658081, 0.92156863212585449, 0.92156863212585449),
        (0.93277311325073242, 0.92549020051956177, 0.92549020051956177),
        (0.93697476387023926, 0.92941176891326904, 0.92941176891326904),
        (0.94117647409439087, 0.93333333730697632, 0.93333333730697632),
        (0.94537812471389771, 0.93725490570068359, 0.93725490570068359),
        (0.94957983493804932, 0.94117647409439087, 0.94117647409439087),
        (0.95378148555755615, 0.94509804248809814, 0.94509804248809814),
        (0.95798319578170776, 0.94901961088180542, 0.94901961088180542),
        (0.9621848464012146, 0.9529411792755127, 0.9529411792755127),
        (0.96638655662536621, 0.96078431606292725, 0.96078431606292725),
        (0.97058820724487305, 0.96470588445663452, 0.96470588445663452),
        (0.97478991746902466, 0.9686274528503418, 0.9686274528503418),
        (0.97899156808853149, 0.97254902124404907, 0.97254902124404907),
        (0.98319327831268311, 0.97647058963775635, 0.97647058963775635),
        (0.98739492893218994, 0.98039215803146362, 0.98039215803146362),
        (0.99159663915634155, 0.9843137264251709, 0.9843137264251709),
        (0.99579828977584839, 0.98823529481887817, 0.98823529481887817),
        (1.0, 0.99215686321258545, 0.99215686321258545),
    ],
    "red": [
        (0.0, 0.0, 0.0),
        (0.0042016808874905109, 0.070588238537311554, 0.070588238537311554),
        (0.0084033617749810219, 0.14117647707462311, 0.14117647707462311),
        (0.012605042196810246, 0.21176470816135406, 0.21176470816135406),
        (0.016806723549962044, 0.28235295414924622, 0.28235295414924622),
        (0.021008403971791267, 0.35294118523597717, 0.35294118523597717),
        (0.025210084393620491, 0.42352941632270813, 0.42352941632270813),
        (0.029411764815449715, 0.49803921580314636, 0.49803921580314636),
        (0.033613447099924088, 0.56862747669219971, 0.56862747669219971),
        (0.037815127521753311, 0.63921570777893066, 0.63921570777893066),
        (0.042016807943582535, 0.78039216995239258, 0.78039216995239258),
        (0.046218488365411758, 0.85098040103912354, 0.85098040103912354),
        (0.050420168787240982, 0.92156863212585449, 0.92156863212585449),
        (0.054621849209070206, 0.99607843160629272, 0.99607843160629272),
        (0.058823529630899429, 0.97647058963775635, 0.97647058963775635),
        (0.063025213778018951, 0.95686274766921997, 0.95686274766921997),
        (0.067226894199848175, 0.93725490570068359, 0.93725490570068359),
        (0.071428574621677399, 0.91764706373214722, 0.91764706373214722),
        (0.075630255043506622, 0.89803922176361084, 0.89803922176361084),
        (0.079831935465335846, 0.87450981140136719, 0.87450981140136719),
        (0.08403361588716507, 0.85490196943283081, 0.85490196943283081),
        (0.088235296308994293, 0.83529412746429443, 0.83529412746429443),
        (0.092436976730823517, 0.81568628549575806, 0.81568628549575806),
        (0.09663865715265274, 0.79607844352722168, 0.79607844352722168),
        (0.10084033757448196, 0.77254903316497803, 0.77254903316497803),
        (0.10504201799631119, 0.75294119119644165, 0.75294119119644165),
        (0.10924369841814041, 0.73333334922790527, 0.73333334922790527),
        (0.11344537883996964, 0.7137255072593689, 0.7137255072593689),
        (0.11764705926179886, 0.69411766529083252, 0.69411766529083252),
        (0.12184873968362808, 0.67450982332229614, 0.67450982332229614),
        (0.1260504275560379, 0.63137257099151611, 0.63137257099151611),
        (0.13025210797786713, 0.61176472902297974, 0.61176472902297974),
        (0.13445378839969635, 0.59215688705444336, 0.59215688705444336),
        (0.13865546882152557, 0.57254904508590698, 0.57254904508590698),
        (0.1428571492433548, 0.54901963472366333, 0.54901963472366333),
        (0.14705882966518402, 0.52941179275512695, 0.52941179275512695),
        (0.15126051008701324, 0.50980395078659058, 0.50980395078659058),
        (0.15546219050884247, 0.49019607901573181, 0.49019607901573181),
        (0.15966387093067169, 0.47058823704719543, 0.47058823704719543),
        (0.16386555135250092, 0.45098039507865906, 0.45098039507865906),
        (0.16806723177433014, 0.42745098471641541, 0.42745098471641541),
        (0.17226891219615936, 0.40784314274787903, 0.40784314274787903),
        (0.17647059261798859, 0.38823530077934265, 0.38823530077934265),
        (0.18067227303981781, 0.36862745881080627, 0.36862745881080627),
        (0.18487395346164703, 0.3490196168422699, 0.3490196168422699),
        (0.18907563388347626, 0.32549020648002625, 0.32549020648002625),
        (0.19327731430530548, 0.30588236451148987, 0.30588236451148987),
        (0.1974789947271347, 0.28627452254295349, 0.28627452254295349),
        (0.20168067514896393, 0.26666668057441711, 0.26666668057441711),
        (0.20588235557079315, 0.24705882370471954, 0.24705882370471954),
        (0.21008403599262238, 0.20392157137393951, 0.20392157137393951),
        (0.2142857164144516, 0.18431372940540314, 0.18431372940540314),
        (0.21848739683628082, 0.16470588743686676, 0.16470588743686676),
        (0.22268907725811005, 0.14509804546833038, 0.14509804546833038),
        (0.22689075767993927, 0.12549020349979401, 0.12549020349979401),
        (0.23109243810176849, 0.10196078568696976, 0.10196078568696976),
        (0.23529411852359772, 0.08235294371843338, 0.08235294371843338),
        (0.23949579894542694, 0.062745101749897003, 0.062745101749897003),
        (0.24369747936725616, 0.043137256056070328, 0.043137256056070328),
        (0.24789915978908539, 0.023529412224888802, 0.023529412224888802),
        (0.25210085511207581, 0.25098040699958801, 0.25098040699958801),
        (0.25630253553390503, 0.25490197539329529, 0.25490197539329529),
        (0.26050421595573425, 0.25882354378700256, 0.25882354378700256),
        (0.26470589637756348, 0.26274511218070984, 0.26274511218070984),
        (0.2689075767993927, 0.26666668057441711, 0.26666668057441711),
        (0.27310925722122192, 0.27058824896812439, 0.27058824896812439),
        (0.27731093764305115, 0.27450981736183167, 0.27450981736183167),
        (0.28151261806488037, 0.27843138575553894, 0.27843138575553894),
        (0.28571429848670959, 0.28235295414924622, 0.28235295414924622),
        (0.28991597890853882, 0.28627452254295349, 0.28627452254295349),
        (0.29411765933036804, 0.29411765933036804, 0.29411765933036804),
        (0.29831933975219727, 0.29803922772407532, 0.29803922772407532),
        (0.30252102017402649, 0.30196079611778259, 0.30196079611778259),
        (0.30672270059585571, 0.30588236451148987, 0.30588236451148987),
        (0.31092438101768494, 0.30980393290519714, 0.30980393290519714),
        (0.31512606143951416, 0.31372550129890442, 0.31372550129890442),
        (0.31932774186134338, 0.31764706969261169, 0.31764706969261169),
        (0.32352942228317261, 0.32156863808631897, 0.32156863808631897),
        (0.32773110270500183, 0.32549020648002625, 0.32549020648002625),
        (0.33193278312683105, 0.32941177487373352, 0.32941177487373352),
        (0.33613446354866028, 0.3333333432674408, 0.3333333432674408),
        (0.3403361439704895, 0.33725491166114807, 0.33725491166114807),
        (0.34453782439231873, 0.34117648005485535, 0.34117648005485535),
        (0.34873950481414795, 0.34509804844856262, 0.34509804844856262),
        (0.35294118523597717, 0.3490196168422699, 0.3490196168422699),
        (0.3571428656578064, 0.35294118523597717, 0.35294118523597717),
        (0.36134454607963562, 0.35686275362968445, 0.35686275362968445),
        (0.36554622650146484, 0.36078432202339172, 0.36078432202339172),
        (0.36974790692329407, 0.364705890417099, 0.364705890417099),
        (0.37394958734512329, 0.36862745881080627, 0.36862745881080627),
        (0.37815126776695251, 0.37647059559822083, 0.37647059559822083),
        (0.38235294818878174, 0.3803921639919281, 0.3803921639919281),
        (0.38655462861061096, 0.38431373238563538, 0.38431373238563538),
        (0.39075630903244019, 0.38823530077934265, 0.38823530077934265),
        (0.39495798945426941, 0.39215686917304993, 0.39215686917304993),
        (0.39915966987609863, 0.3960784375667572, 0.3960784375667572),
        (0.40336135029792786, 0.40000000596046448, 0.40000000596046448),
        (0.40756303071975708, 0.40392157435417175, 0.40392157435417175),
        (0.4117647111415863, 0.40784314274787903, 0.40784314274787903),
        (0.41596639156341553, 0.4117647111415863, 0.4117647111415863),
        (0.42016807198524475, 0.41568627953529358, 0.41568627953529358),
        (0.42436975240707397, 0.41960784792900085, 0.41960784792900085),
        (0.4285714328289032, 0.42352941632270813, 0.42352941632270813),
        (0.43277311325073242, 0.42745098471641541, 0.42745098471641541),
        (0.43697479367256165, 0.43137255311012268, 0.43137255311012268),
        (0.44117647409439087, 0.43529412150382996, 0.43529412150382996),
        (0.44537815451622009, 0.43921568989753723, 0.43921568989753723),
        (0.44957983493804932, 0.44313725829124451, 0.44313725829124451),
        (0.45378151535987854, 0.44705882668495178, 0.44705882668495178),
        (0.45798319578170776, 0.45098039507865906, 0.45098039507865906),
        (0.46218487620353699, 0.45882353186607361, 0.45882353186607361),
        (0.46638655662536621, 0.46274510025978088, 0.46274510025978088),
        (0.47058823704719543, 0.46666666865348816, 0.46666666865348816),
        (0.47478991746902466, 0.47058823704719543, 0.47058823704719543),
        (0.47899159789085388, 0.47450980544090271, 0.47450980544090271),
        (0.48319327831268311, 0.47843137383460999, 0.47843137383460999),
        (0.48739495873451233, 0.48235294222831726, 0.48235294222831726),
        (0.49159663915634155, 0.48627451062202454, 0.48627451062202454),
        (0.49579831957817078, 0.49019607901573181, 0.49019607901573181),
        (0.5, 0.49411764740943909, 0.49411764740943909),
        (0.50420171022415161, 0.50196081399917603, 0.50196081399917603),
        (0.50840336084365845, 0.5058823823928833, 0.5058823823928833),
        (0.51260507106781006, 0.50980395078659058, 0.50980395078659058),
        (0.51680672168731689, 0.51372551918029785, 0.51372551918029785),
        (0.52100843191146851, 0.51764708757400513, 0.51764708757400513),
        (0.52521008253097534, 0.5215686559677124, 0.5215686559677124),
        (0.52941179275512695, 0.52549022436141968, 0.52549022436141968),
        (0.53361344337463379, 0.52941179275512695, 0.52941179275512695),
        (0.5378151535987854, 0.53333336114883423, 0.53333336114883423),
        (0.54201680421829224, 0.5372549295425415, 0.5372549295425415),
        (0.54621851444244385, 0.54509806632995605, 0.54509806632995605),
        (0.55042016506195068, 0.54901963472366333, 0.54901963472366333),
        (0.55462187528610229, 0.55294120311737061, 0.55294120311737061),
        (0.55882352590560913, 0.55686277151107788, 0.55686277151107788),
        (0.56302523612976074, 0.56078433990478516, 0.56078433990478516),
        (0.56722688674926758, 0.56470590829849243, 0.56470590829849243),
        (0.57142859697341919, 0.56862747669219971, 0.56862747669219971),
        (0.57563024759292603, 0.57254904508590698, 0.57254904508590698),
        (0.57983195781707764, 0.57647061347961426, 0.57647061347961426),
        (0.58403360843658447, 0.58039218187332153, 0.58039218187332153),
        (0.58823531866073608, 0.58431375026702881, 0.58431375026702881),
        (0.59243696928024292, 0.58823531866073608, 0.58823531866073608),
        (0.59663867950439453, 0.59215688705444336, 0.59215688705444336),
        (0.60084033012390137, 0.59607845544815063, 0.59607845544815063),
        (0.60504204034805298, 0.60000002384185791, 0.60000002384185791),
        (0.60924369096755981, 0.60392159223556519, 0.60392159223556519),
        (0.61344540119171143, 0.60784316062927246, 0.60784316062927246),
        (0.61764705181121826, 0.61176472902297974, 0.61176472902297974),
        (0.62184876203536987, 0.61568629741668701, 0.61568629741668701),
        (0.62605041265487671, 0.61960786581039429, 0.61960786581039429),
        (0.63025212287902832, 0.62745100259780884, 0.62745100259780884),
        (0.63445377349853516, 0.63137257099151611, 0.63137257099151611),
        (0.63865548372268677, 0.63529413938522339, 0.63529413938522339),
        (0.6428571343421936, 0.63921570777893066, 0.63921570777893066),
        (0.64705884456634521, 0.64313727617263794, 0.64313727617263794),
        (0.65126049518585205, 0.64705884456634521, 0.64705884456634521),
        (0.65546220541000366, 0.65098041296005249, 0.65098041296005249),
        (0.6596638560295105, 0.65490198135375977, 0.65490198135375977),
        (0.66386556625366211, 0.65882354974746704, 0.65882354974746704),
        (0.66806721687316895, 0.66274511814117432, 0.66274511814117432),
        (0.67226892709732056, 0.66666668653488159, 0.66666668653488159),
        (0.67647057771682739, 0.67058825492858887, 0.67058825492858887),
        (0.680672287940979, 0.67450982332229614, 0.67450982332229614),
        (0.68487393856048584, 0.67843139171600342, 0.67843139171600342),
        (0.68907564878463745, 0.68235296010971069, 0.68235296010971069),
        (0.69327729940414429, 0.68627452850341797, 0.68627452850341797),
        (0.6974790096282959, 0.69019609689712524, 0.69019609689712524),
        (0.70168066024780273, 0.69411766529083252, 0.69411766529083252),
        (0.70588237047195435, 0.69803923368453979, 0.69803923368453979),
        (0.71008402109146118, 0.70196080207824707, 0.70196080207824707),
        (0.71428573131561279, 0.70980393886566162, 0.70980393886566162),
        (0.71848738193511963, 0.7137255072593689, 0.7137255072593689),
        (0.72268909215927124, 0.71764707565307617, 0.71764707565307617),
        (0.72689074277877808, 0.72156864404678345, 0.72156864404678345),
        (0.73109245300292969, 0.72549021244049072, 0.72549021244049072),
        (0.73529410362243652, 0.729411780834198, 0.729411780834198),
        (0.73949581384658813, 0.73333334922790527, 0.73333334922790527),
        (0.74369746446609497, 0.73725491762161255, 0.73725491762161255),
        (0.74789917469024658, 0.74117648601531982, 0.74117648601531982),
        (0.75210082530975342, 0.7450980544090271, 0.7450980544090271),
        (0.75630253553390503, 0.75294119119644165, 0.75294119119644165),
        (0.76050418615341187, 0.75686275959014893, 0.75686275959014893),
        (0.76470589637756348, 0.7607843279838562, 0.7607843279838562),
        (0.76890754699707031, 0.76470589637756348, 0.76470589637756348),
        (0.77310925722122192, 0.76862746477127075, 0.76862746477127075),
        (0.77731090784072876, 0.77254903316497803, 0.77254903316497803),
        (0.78151261806488037, 0.7764706015586853, 0.7764706015586853),
        (0.78571426868438721, 0.78039216995239258, 0.78039216995239258),
        (0.78991597890853882, 0.78431373834609985, 0.78431373834609985),
        (0.79411762952804565, 0.78823530673980713, 0.78823530673980713),
        (0.79831933975219727, 0.79607844352722168, 0.79607844352722168),
        (0.8025209903717041, 0.80000001192092896, 0.80000001192092896),
        (0.80672270059585571, 0.80392158031463623, 0.80392158031463623),
        (0.81092435121536255, 0.80784314870834351, 0.80784314870834351),
        (0.81512606143951416, 0.81176471710205078, 0.81176471710205078),
        (0.819327712059021, 0.81568628549575806, 0.81568628549575806),
        (0.82352942228317261, 0.81960785388946533, 0.81960785388946533),
        (0.82773107290267944, 0.82352942228317261, 0.82352942228317261),
        (0.83193278312683105, 0.82745099067687988, 0.82745099067687988),
        (0.83613443374633789, 0.83137255907058716, 0.83137255907058716),
        (0.8403361439704895, 0.83529412746429443, 0.83529412746429443),
        (0.84453779458999634, 0.83921569585800171, 0.83921569585800171),
        (0.84873950481414795, 0.84313726425170898, 0.84313726425170898),
        (0.85294115543365479, 0.84705883264541626, 0.84705883264541626),
        (0.8571428656578064, 0.85098040103912354, 0.85098040103912354),
        (0.86134451627731323, 0.85490196943283081, 0.85490196943283081),
        (0.86554622650146484, 0.85882353782653809, 0.85882353782653809),
        (0.86974787712097168, 0.86274510622024536, 0.86274510622024536),
        (0.87394958734512329, 0.86666667461395264, 0.86666667461395264),
        (0.87815123796463013, 0.87058824300765991, 0.87058824300765991),
        (0.88235294818878174, 0.87843137979507446, 0.87843137979507446),
        (0.88655459880828857, 0.88235294818878174, 0.88235294818878174),
        (0.89075630903244019, 0.88627451658248901, 0.88627451658248901),
        (0.89495795965194702, 0.89019608497619629, 0.89019608497619629),
        (0.89915966987609863, 0.89411765336990356, 0.89411765336990356),
        (0.90336132049560547, 0.89803922176361084, 0.89803922176361084),
        (0.90756303071975708, 0.90196079015731812, 0.90196079015731812),
        (0.91176468133926392, 0.90588235855102539, 0.90588235855102539),
        (0.91596639156341553, 0.90980392694473267, 0.90980392694473267),
        (0.92016804218292236, 0.91372549533843994, 0.91372549533843994),
        (0.92436975240707397, 0.91764706373214722, 0.91764706373214722),
        (0.92857140302658081, 0.92156863212585449, 0.92156863212585449),
        (0.93277311325073242, 0.92549020051956177, 0.92549020051956177),
        (0.93697476387023926, 0.92941176891326904, 0.92941176891326904),
        (0.94117647409439087, 0.93333333730697632, 0.93333333730697632),
        (0.94537812471389771, 0.93725490570068359, 0.93725490570068359),
        (0.94957983493804932, 0.94117647409439087, 0.94117647409439087),
        (0.95378148555755615, 0.94509804248809814, 0.94509804248809814),
        (0.95798319578170776, 0.94901961088180542, 0.94901961088180542),
        (0.9621848464012146, 0.9529411792755127, 0.9529411792755127),
        (0.96638655662536621, 0.96078431606292725, 0.96078431606292725),
        (0.97058820724487305, 0.96470588445663452, 0.96470588445663452),
        (0.97478991746902466, 0.9686274528503418, 0.9686274528503418),
        (0.97899156808853149, 0.97254902124404907, 0.97254902124404907),
        (0.98319327831268311, 0.97647058963775635, 0.97647058963775635),
        (0.98739492893218994, 0.98039215803146362, 0.98039215803146362),
        (0.99159663915634155, 0.9843137264251709, 0.9843137264251709),
        (0.99579828977584839, 0.98823529481887817, 0.98823529481887817),
        (1.0, 0.99215686321258545, 0.99215686321258545),
    ],
}
_gist_yarg_data = {
    "blue": [
        (0.0, 1.0, 1.0),
        (0.0042016808874905109, 0.99607843160629272, 0.99607843160629272),
        (0.0084033617749810219, 0.99215686321258545, 0.99215686321258545),
        (0.012605042196810246, 0.98823529481887817, 0.98823529481887817),
        (0.016806723549962044, 0.9843137264251709, 0.9843137264251709),
        (0.021008403971791267, 0.98039215803146362, 0.98039215803146362),
        (0.025210084393620491, 0.97647058963775635, 0.97647058963775635),
        (0.029411764815449715, 0.97254902124404907, 0.97254902124404907),
        (0.033613447099924088, 0.96470588445663452, 0.96470588445663452),
        (0.037815127521753311, 0.96078431606292725, 0.96078431606292725),
        (0.042016807943582535, 0.95686274766921997, 0.95686274766921997),
        (0.046218488365411758, 0.9529411792755127, 0.9529411792755127),
        (0.050420168787240982, 0.94901961088180542, 0.94901961088180542),
        (0.054621849209070206, 0.94509804248809814, 0.94509804248809814),
        (0.058823529630899429, 0.94117647409439087, 0.94117647409439087),
        (0.063025213778018951, 0.93725490570068359, 0.93725490570068359),
        (0.067226894199848175, 0.93333333730697632, 0.93333333730697632),
        (0.071428574621677399, 0.92941176891326904, 0.92941176891326904),
        (0.075630255043506622, 0.92549020051956177, 0.92549020051956177),
        (0.079831935465335846, 0.92156863212585449, 0.92156863212585449),
        (0.08403361588716507, 0.91764706373214722, 0.91764706373214722),
        (0.088235296308994293, 0.91372549533843994, 0.91372549533843994),
        (0.092436976730823517, 0.90980392694473267, 0.90980392694473267),
        (0.09663865715265274, 0.90196079015731812, 0.90196079015731812),
        (0.10084033757448196, 0.89803922176361084, 0.89803922176361084),
        (0.10504201799631119, 0.89411765336990356, 0.89411765336990356),
        (0.10924369841814041, 0.89019608497619629, 0.89019608497619629),
        (0.11344537883996964, 0.88627451658248901, 0.88627451658248901),
        (0.11764705926179886, 0.88235294818878174, 0.88235294818878174),
        (0.12184873968362808, 0.87843137979507446, 0.87843137979507446),
        (0.1260504275560379, 0.87450981140136719, 0.87450981140136719),
        (0.13025210797786713, 0.87058824300765991, 0.87058824300765991),
        (0.13445378839969635, 0.86666667461395264, 0.86666667461395264),
        (0.13865546882152557, 0.86274510622024536, 0.86274510622024536),
        (0.1428571492433548, 0.85882353782653809, 0.85882353782653809),
        (0.14705882966518402, 0.85490196943283081, 0.85490196943283081),
        (0.15126051008701324, 0.85098040103912354, 0.85098040103912354),
        (0.15546219050884247, 0.84705883264541626, 0.84705883264541626),
        (0.15966387093067169, 0.83921569585800171, 0.83921569585800171),
        (0.16386555135250092, 0.83529412746429443, 0.83529412746429443),
        (0.16806723177433014, 0.83137255907058716, 0.83137255907058716),
        (0.17226891219615936, 0.82745099067687988, 0.82745099067687988),
        (0.17647059261798859, 0.82352942228317261, 0.82352942228317261),
        (0.18067227303981781, 0.81960785388946533, 0.81960785388946533),
        (0.18487395346164703, 0.81568628549575806, 0.81568628549575806),
        (0.18907563388347626, 0.81176471710205078, 0.81176471710205078),
        (0.19327731430530548, 0.80784314870834351, 0.80784314870834351),
        (0.1974789947271347, 0.80392158031463623, 0.80392158031463623),
        (0.20168067514896393, 0.80000001192092896, 0.80000001192092896),
        (0.20588235557079315, 0.79607844352722168, 0.79607844352722168),
        (0.21008403599262238, 0.7921568751335144, 0.7921568751335144),
        (0.2142857164144516, 0.78823530673980713, 0.78823530673980713),
        (0.21848739683628082, 0.78431373834609985, 0.78431373834609985),
        (0.22268907725811005, 0.7764706015586853, 0.7764706015586853),
        (0.22689075767993927, 0.77254903316497803, 0.77254903316497803),
        (0.23109243810176849, 0.76862746477127075, 0.76862746477127075),
        (0.23529411852359772, 0.76470589637756348, 0.76470589637756348),
        (0.23949579894542694, 0.7607843279838562, 0.7607843279838562),
        (0.24369747936725616, 0.75686275959014893, 0.75686275959014893),
        (0.24789915978908539, 0.75294119119644165, 0.75294119119644165),
        (0.25210085511207581, 0.74901962280273438, 0.74901962280273438),
        (0.25630253553390503, 0.7450980544090271, 0.7450980544090271),
        (0.26050421595573425, 0.74117648601531982, 0.74117648601531982),
        (0.26470589637756348, 0.73725491762161255, 0.73725491762161255),
        (0.2689075767993927, 0.73333334922790527, 0.73333334922790527),
        (0.27310925722122192, 0.729411780834198, 0.729411780834198),
        (0.27731093764305115, 0.72549021244049072, 0.72549021244049072),
        (0.28151261806488037, 0.72156864404678345, 0.72156864404678345),
        (0.28571429848670959, 0.7137255072593689, 0.7137255072593689),
        (0.28991597890853882, 0.70980393886566162, 0.70980393886566162),
        (0.29411765933036804, 0.70588237047195435, 0.70588237047195435),
        (0.29831933975219727, 0.70196080207824707, 0.70196080207824707),
        (0.30252102017402649, 0.69803923368453979, 0.69803923368453979),
        (0.30672270059585571, 0.69411766529083252, 0.69411766529083252),
        (0.31092438101768494, 0.69019609689712524, 0.69019609689712524),
        (0.31512606143951416, 0.68627452850341797, 0.68627452850341797),
        (0.31932774186134338, 0.68235296010971069, 0.68235296010971069),
        (0.32352942228317261, 0.67843139171600342, 0.67843139171600342),
        (0.32773110270500183, 0.67450982332229614, 0.67450982332229614),
        (0.33193278312683105, 0.67058825492858887, 0.67058825492858887),
        (0.33613446354866028, 0.66666668653488159, 0.66666668653488159),
        (0.3403361439704895, 0.66274511814117432, 0.66274511814117432),
        (0.34453782439231873, 0.65882354974746704, 0.65882354974746704),
        (0.34873950481414795, 0.65098041296005249, 0.65098041296005249),
        (0.35294118523597717, 0.64705884456634521, 0.64705884456634521),
        (0.3571428656578064, 0.64313727617263794, 0.64313727617263794),
        (0.36134454607963562, 0.63921570777893066, 0.63921570777893066),
        (0.36554622650146484, 0.63529413938522339, 0.63529413938522339),
        (0.36974790692329407, 0.63137257099151611, 0.63137257099151611),
        (0.37394958734512329, 0.62745100259780884, 0.62745100259780884),
        (0.37815126776695251, 0.62352943420410156, 0.62352943420410156),
        (0.38235294818878174, 0.61960786581039429, 0.61960786581039429),
        (0.38655462861061096, 0.61568629741668701, 0.61568629741668701),
        (0.39075630903244019, 0.61176472902297974, 0.61176472902297974),
        (0.39495798945426941, 0.60784316062927246, 0.60784316062927246),
        (0.39915966987609863, 0.60392159223556519, 0.60392159223556519),
        (0.40336135029792786, 0.60000002384185791, 0.60000002384185791),
        (0.40756303071975708, 0.59607845544815063, 0.59607845544815063),
        (0.4117647111415863, 0.58823531866073608, 0.58823531866073608),
        (0.41596639156341553, 0.58431375026702881, 0.58431375026702881),
        (0.42016807198524475, 0.58039218187332153, 0.58039218187332153),
        (0.42436975240707397, 0.57647061347961426, 0.57647061347961426),
        (0.4285714328289032, 0.57254904508590698, 0.57254904508590698),
        (0.43277311325073242, 0.56862747669219971, 0.56862747669219971),
        (0.43697479367256165, 0.56470590829849243, 0.56470590829849243),
        (0.44117647409439087, 0.56078433990478516, 0.56078433990478516),
        (0.44537815451622009, 0.55686277151107788, 0.55686277151107788),
        (0.44957983493804932, 0.55294120311737061, 0.55294120311737061),
        (0.45378151535987854, 0.54901963472366333, 0.54901963472366333),
        (0.45798319578170776, 0.54509806632995605, 0.54509806632995605),
        (0.46218487620353699, 0.54117649793624878, 0.54117649793624878),
        (0.46638655662536621, 0.5372549295425415, 0.5372549295425415),
        (0.47058823704719543, 0.53333336114883423, 0.53333336114883423),
        (0.47478991746902466, 0.52549022436141968, 0.52549022436141968),
        (0.47899159789085388, 0.5215686559677124, 0.5215686559677124),
        (0.48319327831268311, 0.51764708757400513, 0.51764708757400513),
        (0.48739495873451233, 0.51372551918029785, 0.51372551918029785),
        (0.49159663915634155, 0.50980395078659058, 0.50980395078659058),
        (0.49579831957817078, 0.5058823823928833, 0.5058823823928833),
        (0.5, 0.50196081399917603, 0.50196081399917603),
        (0.50420171022415161, 0.49803921580314636, 0.49803921580314636),
        (0.50840336084365845, 0.49411764740943909, 0.49411764740943909),
        (0.51260507106781006, 0.49019607901573181, 0.49019607901573181),
        (0.51680672168731689, 0.48627451062202454, 0.48627451062202454),
        (0.52100843191146851, 0.48235294222831726, 0.48235294222831726),
        (0.52521008253097534, 0.47843137383460999, 0.47843137383460999),
        (0.52941179275512695, 0.47450980544090271, 0.47450980544090271),
        (0.53361344337463379, 0.47058823704719543, 0.47058823704719543),
        (0.5378151535987854, 0.46274510025978088, 0.46274510025978088),
        (0.54201680421829224, 0.45882353186607361, 0.45882353186607361),
        (0.54621851444244385, 0.45490196347236633, 0.45490196347236633),
        (0.55042016506195068, 0.45098039507865906, 0.45098039507865906),
        (0.55462187528610229, 0.44705882668495178, 0.44705882668495178),
        (0.55882352590560913, 0.44313725829124451, 0.44313725829124451),
        (0.56302523612976074, 0.43921568989753723, 0.43921568989753723),
        (0.56722688674926758, 0.43529412150382996, 0.43529412150382996),
        (0.57142859697341919, 0.43137255311012268, 0.43137255311012268),
        (0.57563024759292603, 0.42745098471641541, 0.42745098471641541),
        (0.57983195781707764, 0.42352941632270813, 0.42352941632270813),
        (0.58403360843658447, 0.41960784792900085, 0.41960784792900085),
        (0.58823531866073608, 0.41568627953529358, 0.41568627953529358),
        (0.59243696928024292, 0.4117647111415863, 0.4117647111415863),
        (0.59663867950439453, 0.40784314274787903, 0.40784314274787903),
        (0.60084033012390137, 0.40000000596046448, 0.40000000596046448),
        (0.60504204034805298, 0.3960784375667572, 0.3960784375667572),
        (0.60924369096755981, 0.39215686917304993, 0.39215686917304993),
        (0.61344540119171143, 0.38823530077934265, 0.38823530077934265),
        (0.61764705181121826, 0.38431373238563538, 0.38431373238563538),
        (0.62184876203536987, 0.3803921639919281, 0.3803921639919281),
        (0.62605041265487671, 0.37647059559822083, 0.37647059559822083),
        (0.63025212287902832, 0.37254902720451355, 0.37254902720451355),
        (0.63445377349853516, 0.36862745881080627, 0.36862745881080627),
        (0.63865548372268677, 0.364705890417099, 0.364705890417099),
        (0.6428571343421936, 0.36078432202339172, 0.36078432202339172),
        (0.64705884456634521, 0.35686275362968445, 0.35686275362968445),
        (0.65126049518585205, 0.35294118523597717, 0.35294118523597717),
        (0.65546220541000366, 0.3490196168422699, 0.3490196168422699),
        (0.6596638560295105, 0.34509804844856262, 0.34509804844856262),
        (0.66386556625366211, 0.33725491166114807, 0.33725491166114807),
        (0.66806721687316895, 0.3333333432674408, 0.3333333432674408),
        (0.67226892709732056, 0.32941177487373352, 0.32941177487373352),
        (0.67647057771682739, 0.32549020648002625, 0.32549020648002625),
        (0.680672287940979, 0.32156863808631897, 0.32156863808631897),
        (0.68487393856048584, 0.31764706969261169, 0.31764706969261169),
        (0.68907564878463745, 0.31372550129890442, 0.31372550129890442),
        (0.69327729940414429, 0.30980393290519714, 0.30980393290519714),
        (0.6974790096282959, 0.30588236451148987, 0.30588236451148987),
        (0.70168066024780273, 0.30196079611778259, 0.30196079611778259),
        (0.70588237047195435, 0.29803922772407532, 0.29803922772407532),
        (0.71008402109146118, 0.29411765933036804, 0.29411765933036804),
        (0.71428573131561279, 0.29019609093666077, 0.29019609093666077),
        (0.71848738193511963, 0.28627452254295349, 0.28627452254295349),
        (0.72268909215927124, 0.28235295414924622, 0.28235295414924622),
        (0.72689074277877808, 0.27450981736183167, 0.27450981736183167),
        (0.73109245300292969, 0.27058824896812439, 0.27058824896812439),
        (0.73529410362243652, 0.26666668057441711, 0.26666668057441711),
        (0.73949581384658813, 0.26274511218070984, 0.26274511218070984),
        (0.74369746446609497, 0.25882354378700256, 0.25882354378700256),
        (0.74789917469024658, 0.25490197539329529, 0.25490197539329529),
        (0.75210082530975342, 0.25098040699958801, 0.25098040699958801),
        (0.75630253553390503, 0.24705882370471954, 0.24705882370471954),
        (0.76050418615341187, 0.24313725531101227, 0.24313725531101227),
        (0.76470589637756348, 0.23921568691730499, 0.23921568691730499),
        (0.76890754699707031, 0.23529411852359772, 0.23529411852359772),
        (0.77310925722122192, 0.23137255012989044, 0.23137255012989044),
        (0.77731090784072876, 0.22745098173618317, 0.22745098173618317),
        (0.78151261806488037, 0.22352941334247589, 0.22352941334247589),
        (0.78571426868438721, 0.21960784494876862, 0.21960784494876862),
        (0.78991597890853882, 0.21176470816135406, 0.21176470816135406),
        (0.79411762952804565, 0.20784313976764679, 0.20784313976764679),
        (0.79831933975219727, 0.20392157137393951, 0.20392157137393951),
        (0.8025209903717041, 0.20000000298023224, 0.20000000298023224),
        (0.80672270059585571, 0.19607843458652496, 0.19607843458652496),
        (0.81092435121536255, 0.19215686619281769, 0.19215686619281769),
        (0.81512606143951416, 0.18823529779911041, 0.18823529779911041),
        (0.819327712059021, 0.18431372940540314, 0.18431372940540314),
        (0.82352942228317261, 0.18039216101169586, 0.18039216101169586),
        (0.82773107290267944, 0.17647059261798859, 0.17647059261798859),
        (0.83193278312683105, 0.17254902422428131, 0.17254902422428131),
        (0.83613443374633789, 0.16862745583057404, 0.16862745583057404),
        (0.8403361439704895, 0.16470588743686676, 0.16470588743686676),
        (0.84453779458999634, 0.16078431904315948, 0.16078431904315948),
        (0.84873950481414795, 0.15686275064945221, 0.15686275064945221),
        (0.85294115543365479, 0.14901961386203766, 0.14901961386203766),
        (0.8571428656578064, 0.14509804546833038, 0.14509804546833038),
        (0.86134451627731323, 0.14117647707462311, 0.14117647707462311),
        (0.86554622650146484, 0.13725490868091583, 0.13725490868091583),
        (0.86974787712097168, 0.13333334028720856, 0.13333334028720856),
        (0.87394958734512329, 0.12941177189350128, 0.12941177189350128),
        (0.87815123796463013, 0.12549020349979401, 0.12549020349979401),
        (0.88235294818878174, 0.12156862765550613, 0.12156862765550613),
        (0.88655459880828857, 0.11764705926179886, 0.11764705926179886),
        (0.89075630903244019, 0.11372549086809158, 0.11372549086809158),
        (0.89495795965194702, 0.10980392247438431, 0.10980392247438431),
        (0.89915966987609863, 0.10588235408067703, 0.10588235408067703),
        (0.90336132049560547, 0.10196078568696976, 0.10196078568696976),
        (0.90756303071975708, 0.098039217293262482, 0.098039217293262482),
        (0.91176468133926392, 0.094117648899555206, 0.094117648899555206),
        (0.91596639156341553, 0.086274512112140656, 0.086274512112140656),
        (0.92016804218292236, 0.08235294371843338, 0.08235294371843338),
        (0.92436975240707397, 0.078431375324726105, 0.078431375324726105),
        (0.92857140302658081, 0.074509806931018829, 0.074509806931018829),
        (0.93277311325073242, 0.070588238537311554, 0.070588238537311554),
        (0.93697476387023926, 0.066666670143604279, 0.066666670143604279),
        (0.94117647409439087, 0.062745101749897003, 0.062745101749897003),
        (0.94537812471389771, 0.058823529630899429, 0.058823529630899429),
        (0.94957983493804932, 0.054901961237192154, 0.054901961237192154),
        (0.95378148555755615, 0.050980392843484879, 0.050980392843484879),
        (0.95798319578170776, 0.047058824449777603, 0.047058824449777603),
        (0.9621848464012146, 0.043137256056070328, 0.043137256056070328),
        (0.96638655662536621, 0.039215687662363052, 0.039215687662363052),
        (0.97058820724487305, 0.035294119268655777, 0.035294119268655777),
        (0.97478991746902466, 0.031372550874948502, 0.031372550874948502),
        (0.97899156808853149, 0.023529412224888802, 0.023529412224888802),
        (0.98319327831268311, 0.019607843831181526, 0.019607843831181526),
        (0.98739492893218994, 0.015686275437474251, 0.015686275437474251),
        (0.99159663915634155, 0.011764706112444401, 0.011764706112444401),
        (0.99579828977584839, 0.0078431377187371254, 0.0078431377187371254),
        (1.0, 0.0039215688593685627, 0.0039215688593685627),
    ],
    "green": [
        (0.0, 1.0, 1.0),
        (0.0042016808874905109, 0.99607843160629272, 0.99607843160629272),
        (0.0084033617749810219, 0.99215686321258545, 0.99215686321258545),
        (0.012605042196810246, 0.98823529481887817, 0.98823529481887817),
        (0.016806723549962044, 0.9843137264251709, 0.9843137264251709),
        (0.021008403971791267, 0.98039215803146362, 0.98039215803146362),
        (0.025210084393620491, 0.97647058963775635, 0.97647058963775635),
        (0.029411764815449715, 0.97254902124404907, 0.97254902124404907),
        (0.033613447099924088, 0.96470588445663452, 0.96470588445663452),
        (0.037815127521753311, 0.96078431606292725, 0.96078431606292725),
        (0.042016807943582535, 0.95686274766921997, 0.95686274766921997),
        (0.046218488365411758, 0.9529411792755127, 0.9529411792755127),
        (0.050420168787240982, 0.94901961088180542, 0.94901961088180542),
        (0.054621849209070206, 0.94509804248809814, 0.94509804248809814),
        (0.058823529630899429, 0.94117647409439087, 0.94117647409439087),
        (0.063025213778018951, 0.93725490570068359, 0.93725490570068359),
        (0.067226894199848175, 0.93333333730697632, 0.93333333730697632),
        (0.071428574621677399, 0.92941176891326904, 0.92941176891326904),
        (0.075630255043506622, 0.92549020051956177, 0.92549020051956177),
        (0.079831935465335846, 0.92156863212585449, 0.92156863212585449),
        (0.08403361588716507, 0.91764706373214722, 0.91764706373214722),
        (0.088235296308994293, 0.91372549533843994, 0.91372549533843994),
        (0.092436976730823517, 0.90980392694473267, 0.90980392694473267),
        (0.09663865715265274, 0.90196079015731812, 0.90196079015731812),
        (0.10084033757448196, 0.89803922176361084, 0.89803922176361084),
        (0.10504201799631119, 0.89411765336990356, 0.89411765336990356),
        (0.10924369841814041, 0.89019608497619629, 0.89019608497619629),
        (0.11344537883996964, 0.88627451658248901, 0.88627451658248901),
        (0.11764705926179886, 0.88235294818878174, 0.88235294818878174),
        (0.12184873968362808, 0.87843137979507446, 0.87843137979507446),
        (0.1260504275560379, 0.87450981140136719, 0.87450981140136719),
        (0.13025210797786713, 0.87058824300765991, 0.87058824300765991),
        (0.13445378839969635, 0.86666667461395264, 0.86666667461395264),
        (0.13865546882152557, 0.86274510622024536, 0.86274510622024536),
        (0.1428571492433548, 0.85882353782653809, 0.85882353782653809),
        (0.14705882966518402, 0.85490196943283081, 0.85490196943283081),
        (0.15126051008701324, 0.85098040103912354, 0.85098040103912354),
        (0.15546219050884247, 0.84705883264541626, 0.84705883264541626),
        (0.15966387093067169, 0.83921569585800171, 0.83921569585800171),
        (0.16386555135250092, 0.83529412746429443, 0.83529412746429443),
        (0.16806723177433014, 0.83137255907058716, 0.83137255907058716),
        (0.17226891219615936, 0.82745099067687988, 0.82745099067687988),
        (0.17647059261798859, 0.82352942228317261, 0.82352942228317261),
        (0.18067227303981781, 0.81960785388946533, 0.81960785388946533),
        (0.18487395346164703, 0.81568628549575806, 0.81568628549575806),
        (0.18907563388347626, 0.81176471710205078, 0.81176471710205078),
        (0.19327731430530548, 0.80784314870834351, 0.80784314870834351),
        (0.1974789947271347, 0.80392158031463623, 0.80392158031463623),
        (0.20168067514896393, 0.80000001192092896, 0.80000001192092896),
        (0.20588235557079315, 0.79607844352722168, 0.79607844352722168),
        (0.21008403599262238, 0.7921568751335144, 0.7921568751335144),
        (0.2142857164144516, 0.78823530673980713, 0.78823530673980713),
        (0.21848739683628082, 0.78431373834609985, 0.78431373834609985),
        (0.22268907725811005, 0.7764706015586853, 0.7764706015586853),
        (0.22689075767993927, 0.77254903316497803, 0.77254903316497803),
        (0.23109243810176849, 0.76862746477127075, 0.76862746477127075),
        (0.23529411852359772, 0.76470589637756348, 0.76470589637756348),
        (0.23949579894542694, 0.7607843279838562, 0.7607843279838562),
        (0.24369747936725616, 0.75686275959014893, 0.75686275959014893),
        (0.24789915978908539, 0.75294119119644165, 0.75294119119644165),
        (0.25210085511207581, 0.74901962280273438, 0.74901962280273438),
        (0.25630253553390503, 0.7450980544090271, 0.7450980544090271),
        (0.26050421595573425, 0.74117648601531982, 0.74117648601531982),
        (0.26470589637756348, 0.73725491762161255, 0.73725491762161255),
        (0.2689075767993927, 0.73333334922790527, 0.73333334922790527),
        (0.27310925722122192, 0.729411780834198, 0.729411780834198),
        (0.27731093764305115, 0.72549021244049072, 0.72549021244049072),
        (0.28151261806488037, 0.72156864404678345, 0.72156864404678345),
        (0.28571429848670959, 0.7137255072593689, 0.7137255072593689),
        (0.28991597890853882, 0.70980393886566162, 0.70980393886566162),
        (0.29411765933036804, 0.70588237047195435, 0.70588237047195435),
        (0.29831933975219727, 0.70196080207824707, 0.70196080207824707),
        (0.30252102017402649, 0.69803923368453979, 0.69803923368453979),
        (0.30672270059585571, 0.69411766529083252, 0.69411766529083252),
        (0.31092438101768494, 0.69019609689712524, 0.69019609689712524),
        (0.31512606143951416, 0.68627452850341797, 0.68627452850341797),
        (0.31932774186134338, 0.68235296010971069, 0.68235296010971069),
        (0.32352942228317261, 0.67843139171600342, 0.67843139171600342),
        (0.32773110270500183, 0.67450982332229614, 0.67450982332229614),
        (0.33193278312683105, 0.67058825492858887, 0.67058825492858887),
        (0.33613446354866028, 0.66666668653488159, 0.66666668653488159),
        (0.3403361439704895, 0.66274511814117432, 0.66274511814117432),
        (0.34453782439231873, 0.65882354974746704, 0.65882354974746704),
        (0.34873950481414795, 0.65098041296005249, 0.65098041296005249),
        (0.35294118523597717, 0.64705884456634521, 0.64705884456634521),
        (0.3571428656578064, 0.64313727617263794, 0.64313727617263794),
        (0.36134454607963562, 0.63921570777893066, 0.63921570777893066),
        (0.36554622650146484, 0.63529413938522339, 0.63529413938522339),
        (0.36974790692329407, 0.63137257099151611, 0.63137257099151611),
        (0.37394958734512329, 0.62745100259780884, 0.62745100259780884),
        (0.37815126776695251, 0.62352943420410156, 0.62352943420410156),
        (0.38235294818878174, 0.61960786581039429, 0.61960786581039429),
        (0.38655462861061096, 0.61568629741668701, 0.61568629741668701),
        (0.39075630903244019, 0.61176472902297974, 0.61176472902297974),
        (0.39495798945426941, 0.60784316062927246, 0.60784316062927246),
        (0.39915966987609863, 0.60392159223556519, 0.60392159223556519),
        (0.40336135029792786, 0.60000002384185791, 0.60000002384185791),
        (0.40756303071975708, 0.59607845544815063, 0.59607845544815063),
        (0.4117647111415863, 0.58823531866073608, 0.58823531866073608),
        (0.41596639156341553, 0.58431375026702881, 0.58431375026702881),
        (0.42016807198524475, 0.58039218187332153, 0.58039218187332153),
        (0.42436975240707397, 0.57647061347961426, 0.57647061347961426),
        (0.4285714328289032, 0.57254904508590698, 0.57254904508590698),
        (0.43277311325073242, 0.56862747669219971, 0.56862747669219971),
        (0.43697479367256165, 0.56470590829849243, 0.56470590829849243),
        (0.44117647409439087, 0.56078433990478516, 0.56078433990478516),
        (0.44537815451622009, 0.55686277151107788, 0.55686277151107788),
        (0.44957983493804932, 0.55294120311737061, 0.55294120311737061),
        (0.45378151535987854, 0.54901963472366333, 0.54901963472366333),
        (0.45798319578170776, 0.54509806632995605, 0.54509806632995605),
        (0.46218487620353699, 0.54117649793624878, 0.54117649793624878),
        (0.46638655662536621, 0.5372549295425415, 0.5372549295425415),
        (0.47058823704719543, 0.53333336114883423, 0.53333336114883423),
        (0.47478991746902466, 0.52549022436141968, 0.52549022436141968),
        (0.47899159789085388, 0.5215686559677124, 0.5215686559677124),
        (0.48319327831268311, 0.51764708757400513, 0.51764708757400513),
        (0.48739495873451233, 0.51372551918029785, 0.51372551918029785),
        (0.49159663915634155, 0.50980395078659058, 0.50980395078659058),
        (0.49579831957817078, 0.5058823823928833, 0.5058823823928833),
        (0.5, 0.50196081399917603, 0.50196081399917603),
        (0.50420171022415161, 0.49803921580314636, 0.49803921580314636),
        (0.50840336084365845, 0.49411764740943909, 0.49411764740943909),
        (0.51260507106781006, 0.49019607901573181, 0.49019607901573181),
        (0.51680672168731689, 0.48627451062202454, 0.48627451062202454),
        (0.52100843191146851, 0.48235294222831726, 0.48235294222831726),
        (0.52521008253097534, 0.47843137383460999, 0.47843137383460999),
        (0.52941179275512695, 0.47450980544090271, 0.47450980544090271),
        (0.53361344337463379, 0.47058823704719543, 0.47058823704719543),
        (0.5378151535987854, 0.46274510025978088, 0.46274510025978088),
        (0.54201680421829224, 0.45882353186607361, 0.45882353186607361),
        (0.54621851444244385, 0.45490196347236633, 0.45490196347236633),
        (0.55042016506195068, 0.45098039507865906, 0.45098039507865906),
        (0.55462187528610229, 0.44705882668495178, 0.44705882668495178),
        (0.55882352590560913, 0.44313725829124451, 0.44313725829124451),
        (0.56302523612976074, 0.43921568989753723, 0.43921568989753723),
        (0.56722688674926758, 0.43529412150382996, 0.43529412150382996),
        (0.57142859697341919, 0.43137255311012268, 0.43137255311012268),
        (0.57563024759292603, 0.42745098471641541, 0.42745098471641541),
        (0.57983195781707764, 0.42352941632270813, 0.42352941632270813),
        (0.58403360843658447, 0.41960784792900085, 0.41960784792900085),
        (0.58823531866073608, 0.41568627953529358, 0.41568627953529358),
        (0.59243696928024292, 0.4117647111415863, 0.4117647111415863),
        (0.59663867950439453, 0.40784314274787903, 0.40784314274787903),
        (0.60084033012390137, 0.40000000596046448, 0.40000000596046448),
        (0.60504204034805298, 0.3960784375667572, 0.3960784375667572),
        (0.60924369096755981, 0.39215686917304993, 0.39215686917304993),
        (0.61344540119171143, 0.38823530077934265, 0.38823530077934265),
        (0.61764705181121826, 0.38431373238563538, 0.38431373238563538),
        (0.62184876203536987, 0.3803921639919281, 0.3803921639919281),
        (0.62605041265487671, 0.37647059559822083, 0.37647059559822083),
        (0.63025212287902832, 0.37254902720451355, 0.37254902720451355),
        (0.63445377349853516, 0.36862745881080627, 0.36862745881080627),
        (0.63865548372268677, 0.364705890417099, 0.364705890417099),
        (0.6428571343421936, 0.36078432202339172, 0.36078432202339172),
        (0.64705884456634521, 0.35686275362968445, 0.35686275362968445),
        (0.65126049518585205, 0.35294118523597717, 0.35294118523597717),
        (0.65546220541000366, 0.3490196168422699, 0.3490196168422699),
        (0.6596638560295105, 0.34509804844856262, 0.34509804844856262),
        (0.66386556625366211, 0.33725491166114807, 0.33725491166114807),
        (0.66806721687316895, 0.3333333432674408, 0.3333333432674408),
        (0.67226892709732056, 0.32941177487373352, 0.32941177487373352),
        (0.67647057771682739, 0.32549020648002625, 0.32549020648002625),
        (0.680672287940979, 0.32156863808631897, 0.32156863808631897),
        (0.68487393856048584, 0.31764706969261169, 0.31764706969261169),
        (0.68907564878463745, 0.31372550129890442, 0.31372550129890442),
        (0.69327729940414429, 0.30980393290519714, 0.30980393290519714),
        (0.6974790096282959, 0.30588236451148987, 0.30588236451148987),
        (0.70168066024780273, 0.30196079611778259, 0.30196079611778259),
        (0.70588237047195435, 0.29803922772407532, 0.29803922772407532),
        (0.71008402109146118, 0.29411765933036804, 0.29411765933036804),
        (0.71428573131561279, 0.29019609093666077, 0.29019609093666077),
        (0.71848738193511963, 0.28627452254295349, 0.28627452254295349),
        (0.72268909215927124, 0.28235295414924622, 0.28235295414924622),
        (0.72689074277877808, 0.27450981736183167, 0.27450981736183167),
        (0.73109245300292969, 0.27058824896812439, 0.27058824896812439),
        (0.73529410362243652, 0.26666668057441711, 0.26666668057441711),
        (0.73949581384658813, 0.26274511218070984, 0.26274511218070984),
        (0.74369746446609497, 0.25882354378700256, 0.25882354378700256),
        (0.74789917469024658, 0.25490197539329529, 0.25490197539329529),
        (0.75210082530975342, 0.25098040699958801, 0.25098040699958801),
        (0.75630253553390503, 0.24705882370471954, 0.24705882370471954),
        (0.76050418615341187, 0.24313725531101227, 0.24313725531101227),
        (0.76470589637756348, 0.23921568691730499, 0.23921568691730499),
        (0.76890754699707031, 0.23529411852359772, 0.23529411852359772),
        (0.77310925722122192, 0.23137255012989044, 0.23137255012989044),
        (0.77731090784072876, 0.22745098173618317, 0.22745098173618317),
        (0.78151261806488037, 0.22352941334247589, 0.22352941334247589),
        (0.78571426868438721, 0.21960784494876862, 0.21960784494876862),
        (0.78991597890853882, 0.21176470816135406, 0.21176470816135406),
        (0.79411762952804565, 0.20784313976764679, 0.20784313976764679),
        (0.79831933975219727, 0.20392157137393951, 0.20392157137393951),
        (0.8025209903717041, 0.20000000298023224, 0.20000000298023224),
        (0.80672270059585571, 0.19607843458652496, 0.19607843458652496),
        (0.81092435121536255, 0.19215686619281769, 0.19215686619281769),
        (0.81512606143951416, 0.18823529779911041, 0.18823529779911041),
        (0.819327712059021, 0.18431372940540314, 0.18431372940540314),
        (0.82352942228317261, 0.18039216101169586, 0.18039216101169586),
        (0.82773107290267944, 0.17647059261798859, 0.17647059261798859),
        (0.83193278312683105, 0.17254902422428131, 0.17254902422428131),
        (0.83613443374633789, 0.16862745583057404, 0.16862745583057404),
        (0.8403361439704895, 0.16470588743686676, 0.16470588743686676),
        (0.84453779458999634, 0.16078431904315948, 0.16078431904315948),
        (0.84873950481414795, 0.15686275064945221, 0.15686275064945221),
        (0.85294115543365479, 0.14901961386203766, 0.14901961386203766),
        (0.8571428656578064, 0.14509804546833038, 0.14509804546833038),
        (0.86134451627731323, 0.14117647707462311, 0.14117647707462311),
        (0.86554622650146484, 0.13725490868091583, 0.13725490868091583),
        (0.86974787712097168, 0.13333334028720856, 0.13333334028720856),
        (0.87394958734512329, 0.12941177189350128, 0.12941177189350128),
        (0.87815123796463013, 0.12549020349979401, 0.12549020349979401),
        (0.88235294818878174, 0.12156862765550613, 0.12156862765550613),
        (0.88655459880828857, 0.11764705926179886, 0.11764705926179886),
        (0.89075630903244019, 0.11372549086809158, 0.11372549086809158),
        (0.89495795965194702, 0.10980392247438431, 0.10980392247438431),
        (0.89915966987609863, 0.10588235408067703, 0.10588235408067703),
        (0.90336132049560547, 0.10196078568696976, 0.10196078568696976),
        (0.90756303071975708, 0.098039217293262482, 0.098039217293262482),
        (0.91176468133926392, 0.094117648899555206, 0.094117648899555206),
        (0.91596639156341553, 0.086274512112140656, 0.086274512112140656),
        (0.92016804218292236, 0.08235294371843338, 0.08235294371843338),
        (0.92436975240707397, 0.078431375324726105, 0.078431375324726105),
        (0.92857140302658081, 0.074509806931018829, 0.074509806931018829),
        (0.93277311325073242, 0.070588238537311554, 0.070588238537311554),
        (0.93697476387023926, 0.066666670143604279, 0.066666670143604279),
        (0.94117647409439087, 0.062745101749897003, 0.062745101749897003),
        (0.94537812471389771, 0.058823529630899429, 0.058823529630899429),
        (0.94957983493804932, 0.054901961237192154, 0.054901961237192154),
        (0.95378148555755615, 0.050980392843484879, 0.050980392843484879),
        (0.95798319578170776, 0.047058824449777603, 0.047058824449777603),
        (0.9621848464012146, 0.043137256056070328, 0.043137256056070328),
        (0.96638655662536621, 0.039215687662363052, 0.039215687662363052),
        (0.97058820724487305, 0.035294119268655777, 0.035294119268655777),
        (0.97478991746902466, 0.031372550874948502, 0.031372550874948502),
        (0.97899156808853149, 0.023529412224888802, 0.023529412224888802),
        (0.98319327831268311, 0.019607843831181526, 0.019607843831181526),
        (0.98739492893218994, 0.015686275437474251, 0.015686275437474251),
        (0.99159663915634155, 0.011764706112444401, 0.011764706112444401),
        (0.99579828977584839, 0.0078431377187371254, 0.0078431377187371254),
        (1.0, 0.0039215688593685627, 0.0039215688593685627),
    ],
    "red": [
        (0.0, 1.0, 1.0),
        (0.0042016808874905109, 0.99607843160629272, 0.99607843160629272),
        (0.0084033617749810219, 0.99215686321258545, 0.99215686321258545),
        (0.012605042196810246, 0.98823529481887817, 0.98823529481887817),
        (0.016806723549962044, 0.9843137264251709, 0.9843137264251709),
        (0.021008403971791267, 0.98039215803146362, 0.98039215803146362),
        (0.025210084393620491, 0.97647058963775635, 0.97647058963775635),
        (0.029411764815449715, 0.97254902124404907, 0.97254902124404907),
        (0.033613447099924088, 0.96470588445663452, 0.96470588445663452),
        (0.037815127521753311, 0.96078431606292725, 0.96078431606292725),
        (0.042016807943582535, 0.95686274766921997, 0.95686274766921997),
        (0.046218488365411758, 0.9529411792755127, 0.9529411792755127),
        (0.050420168787240982, 0.94901961088180542, 0.94901961088180542),
        (0.054621849209070206, 0.94509804248809814, 0.94509804248809814),
        (0.058823529630899429, 0.94117647409439087, 0.94117647409439087),
        (0.063025213778018951, 0.93725490570068359, 0.93725490570068359),
        (0.067226894199848175, 0.93333333730697632, 0.93333333730697632),
        (0.071428574621677399, 0.92941176891326904, 0.92941176891326904),
        (0.075630255043506622, 0.92549020051956177, 0.92549020051956177),
        (0.079831935465335846, 0.92156863212585449, 0.92156863212585449),
        (0.08403361588716507, 0.91764706373214722, 0.91764706373214722),
        (0.088235296308994293, 0.91372549533843994, 0.91372549533843994),
        (0.092436976730823517, 0.90980392694473267, 0.90980392694473267),
        (0.09663865715265274, 0.90196079015731812, 0.90196079015731812),
        (0.10084033757448196, 0.89803922176361084, 0.89803922176361084),
        (0.10504201799631119, 0.89411765336990356, 0.89411765336990356),
        (0.10924369841814041, 0.89019608497619629, 0.89019608497619629),
        (0.11344537883996964, 0.88627451658248901, 0.88627451658248901),
        (0.11764705926179886, 0.88235294818878174, 0.88235294818878174),
        (0.12184873968362808, 0.87843137979507446, 0.87843137979507446),
        (0.1260504275560379, 0.87450981140136719, 0.87450981140136719),
        (0.13025210797786713, 0.87058824300765991, 0.87058824300765991),
        (0.13445378839969635, 0.86666667461395264, 0.86666667461395264),
        (0.13865546882152557, 0.86274510622024536, 0.86274510622024536),
        (0.1428571492433548, 0.85882353782653809, 0.85882353782653809),
        (0.14705882966518402, 0.85490196943283081, 0.85490196943283081),
        (0.15126051008701324, 0.85098040103912354, 0.85098040103912354),
        (0.15546219050884247, 0.84705883264541626, 0.84705883264541626),
        (0.15966387093067169, 0.83921569585800171, 0.83921569585800171),
        (0.16386555135250092, 0.83529412746429443, 0.83529412746429443),
        (0.16806723177433014, 0.83137255907058716, 0.83137255907058716),
        (0.17226891219615936, 0.82745099067687988, 0.82745099067687988),
        (0.17647059261798859, 0.82352942228317261, 0.82352942228317261),
        (0.18067227303981781, 0.81960785388946533, 0.81960785388946533),
        (0.18487395346164703, 0.81568628549575806, 0.81568628549575806),
        (0.18907563388347626, 0.81176471710205078, 0.81176471710205078),
        (0.19327731430530548, 0.80784314870834351, 0.80784314870834351),
        (0.1974789947271347, 0.80392158031463623, 0.80392158031463623),
        (0.20168067514896393, 0.80000001192092896, 0.80000001192092896),
        (0.20588235557079315, 0.79607844352722168, 0.79607844352722168),
        (0.21008403599262238, 0.7921568751335144, 0.7921568751335144),
        (0.2142857164144516, 0.78823530673980713, 0.78823530673980713),
        (0.21848739683628082, 0.78431373834609985, 0.78431373834609985),
        (0.22268907725811005, 0.7764706015586853, 0.7764706015586853),
        (0.22689075767993927, 0.77254903316497803, 0.77254903316497803),
        (0.23109243810176849, 0.76862746477127075, 0.76862746477127075),
        (0.23529411852359772, 0.76470589637756348, 0.76470589637756348),
        (0.23949579894542694, 0.7607843279838562, 0.7607843279838562),
        (0.24369747936725616, 0.75686275959014893, 0.75686275959014893),
        (0.24789915978908539, 0.75294119119644165, 0.75294119119644165),
        (0.25210085511207581, 0.74901962280273438, 0.74901962280273438),
        (0.25630253553390503, 0.7450980544090271, 0.7450980544090271),
        (0.26050421595573425, 0.74117648601531982, 0.74117648601531982),
        (0.26470589637756348, 0.73725491762161255, 0.73725491762161255),
        (0.2689075767993927, 0.73333334922790527, 0.73333334922790527),
        (0.27310925722122192, 0.729411780834198, 0.729411780834198),
        (0.27731093764305115, 0.72549021244049072, 0.72549021244049072),
        (0.28151261806488037, 0.72156864404678345, 0.72156864404678345),
        (0.28571429848670959, 0.7137255072593689, 0.7137255072593689),
        (0.28991597890853882, 0.70980393886566162, 0.70980393886566162),
        (0.29411765933036804, 0.70588237047195435, 0.70588237047195435),
        (0.29831933975219727, 0.70196080207824707, 0.70196080207824707),
        (0.30252102017402649, 0.69803923368453979, 0.69803923368453979),
        (0.30672270059585571, 0.69411766529083252, 0.69411766529083252),
        (0.31092438101768494, 0.69019609689712524, 0.69019609689712524),
        (0.31512606143951416, 0.68627452850341797, 0.68627452850341797),
        (0.31932774186134338, 0.68235296010971069, 0.68235296010971069),
        (0.32352942228317261, 0.67843139171600342, 0.67843139171600342),
        (0.32773110270500183, 0.67450982332229614, 0.67450982332229614),
        (0.33193278312683105, 0.67058825492858887, 0.67058825492858887),
        (0.33613446354866028, 0.66666668653488159, 0.66666668653488159),
        (0.3403361439704895, 0.66274511814117432, 0.66274511814117432),
        (0.34453782439231873, 0.65882354974746704, 0.65882354974746704),
        (0.34873950481414795, 0.65098041296005249, 0.65098041296005249),
        (0.35294118523597717, 0.64705884456634521, 0.64705884456634521),
        (0.3571428656578064, 0.64313727617263794, 0.64313727617263794),
        (0.36134454607963562, 0.63921570777893066, 0.63921570777893066),
        (0.36554622650146484, 0.63529413938522339, 0.63529413938522339),
        (0.36974790692329407, 0.63137257099151611, 0.63137257099151611),
        (0.37394958734512329, 0.62745100259780884, 0.62745100259780884),
        (0.37815126776695251, 0.62352943420410156, 0.62352943420410156),
        (0.38235294818878174, 0.61960786581039429, 0.61960786581039429),
        (0.38655462861061096, 0.61568629741668701, 0.61568629741668701),
        (0.39075630903244019, 0.61176472902297974, 0.61176472902297974),
        (0.39495798945426941, 0.60784316062927246, 0.60784316062927246),
        (0.39915966987609863, 0.60392159223556519, 0.60392159223556519),
        (0.40336135029792786, 0.60000002384185791, 0.60000002384185791),
        (0.40756303071975708, 0.59607845544815063, 0.59607845544815063),
        (0.4117647111415863, 0.58823531866073608, 0.58823531866073608),
        (0.41596639156341553, 0.58431375026702881, 0.58431375026702881),
        (0.42016807198524475, 0.58039218187332153, 0.58039218187332153),
        (0.42436975240707397, 0.57647061347961426, 0.57647061347961426),
        (0.4285714328289032, 0.57254904508590698, 0.57254904508590698),
        (0.43277311325073242, 0.56862747669219971, 0.56862747669219971),
        (0.43697479367256165, 0.56470590829849243, 0.56470590829849243),
        (0.44117647409439087, 0.56078433990478516, 0.56078433990478516),
        (0.44537815451622009, 0.55686277151107788, 0.55686277151107788),
        (0.44957983493804932, 0.55294120311737061, 0.55294120311737061),
        (0.45378151535987854, 0.54901963472366333, 0.54901963472366333),
        (0.45798319578170776, 0.54509806632995605, 0.54509806632995605),
        (0.46218487620353699, 0.54117649793624878, 0.54117649793624878),
        (0.46638655662536621, 0.5372549295425415, 0.5372549295425415),
        (0.47058823704719543, 0.53333336114883423, 0.53333336114883423),
        (0.47478991746902466, 0.52549022436141968, 0.52549022436141968),
        (0.47899159789085388, 0.5215686559677124, 0.5215686559677124),
        (0.48319327831268311, 0.51764708757400513, 0.51764708757400513),
        (0.48739495873451233, 0.51372551918029785, 0.51372551918029785),
        (0.49159663915634155, 0.50980395078659058, 0.50980395078659058),
        (0.49579831957817078, 0.5058823823928833, 0.5058823823928833),
        (0.5, 0.50196081399917603, 0.50196081399917603),
        (0.50420171022415161, 0.49803921580314636, 0.49803921580314636),
        (0.50840336084365845, 0.49411764740943909, 0.49411764740943909),
        (0.51260507106781006, 0.49019607901573181, 0.49019607901573181),
        (0.51680672168731689, 0.48627451062202454, 0.48627451062202454),
        (0.52100843191146851, 0.48235294222831726, 0.48235294222831726),
        (0.52521008253097534, 0.47843137383460999, 0.47843137383460999),
        (0.52941179275512695, 0.47450980544090271, 0.47450980544090271),
        (0.53361344337463379, 0.47058823704719543, 0.47058823704719543),
        (0.5378151535987854, 0.46274510025978088, 0.46274510025978088),
        (0.54201680421829224, 0.45882353186607361, 0.45882353186607361),
        (0.54621851444244385, 0.45490196347236633, 0.45490196347236633),
        (0.55042016506195068, 0.45098039507865906, 0.45098039507865906),
        (0.55462187528610229, 0.44705882668495178, 0.44705882668495178),
        (0.55882352590560913, 0.44313725829124451, 0.44313725829124451),
        (0.56302523612976074, 0.43921568989753723, 0.43921568989753723),
        (0.56722688674926758, 0.43529412150382996, 0.43529412150382996),
        (0.57142859697341919, 0.43137255311012268, 0.43137255311012268),
        (0.57563024759292603, 0.42745098471641541, 0.42745098471641541),
        (0.57983195781707764, 0.42352941632270813, 0.42352941632270813),
        (0.58403360843658447, 0.41960784792900085, 0.41960784792900085),
        (0.58823531866073608, 0.41568627953529358, 0.41568627953529358),
        (0.59243696928024292, 0.4117647111415863, 0.4117647111415863),
        (0.59663867950439453, 0.40784314274787903, 0.40784314274787903),
        (0.60084033012390137, 0.40000000596046448, 0.40000000596046448),
        (0.60504204034805298, 0.3960784375667572, 0.3960784375667572),
        (0.60924369096755981, 0.39215686917304993, 0.39215686917304993),
        (0.61344540119171143, 0.38823530077934265, 0.38823530077934265),
        (0.61764705181121826, 0.38431373238563538, 0.38431373238563538),
        (0.62184876203536987, 0.3803921639919281, 0.3803921639919281),
        (0.62605041265487671, 0.37647059559822083, 0.37647059559822083),
        (0.63025212287902832, 0.37254902720451355, 0.37254902720451355),
        (0.63445377349853516, 0.36862745881080627, 0.36862745881080627),
        (0.63865548372268677, 0.364705890417099, 0.364705890417099),
        (0.6428571343421936, 0.36078432202339172, 0.36078432202339172),
        (0.64705884456634521, 0.35686275362968445, 0.35686275362968445),
        (0.65126049518585205, 0.35294118523597717, 0.35294118523597717),
        (0.65546220541000366, 0.3490196168422699, 0.3490196168422699),
        (0.6596638560295105, 0.34509804844856262, 0.34509804844856262),
        (0.66386556625366211, 0.33725491166114807, 0.33725491166114807),
        (0.66806721687316895, 0.3333333432674408, 0.3333333432674408),
        (0.67226892709732056, 0.32941177487373352, 0.32941177487373352),
        (0.67647057771682739, 0.32549020648002625, 0.32549020648002625),
        (0.680672287940979, 0.32156863808631897, 0.32156863808631897),
        (0.68487393856048584, 0.31764706969261169, 0.31764706969261169),
        (0.68907564878463745, 0.31372550129890442, 0.31372550129890442),
        (0.69327729940414429, 0.30980393290519714, 0.30980393290519714),
        (0.6974790096282959, 0.30588236451148987, 0.30588236451148987),
        (0.70168066024780273, 0.30196079611778259, 0.30196079611778259),
        (0.70588237047195435, 0.29803922772407532, 0.29803922772407532),
        (0.71008402109146118, 0.29411765933036804, 0.29411765933036804),
        (0.71428573131561279, 0.29019609093666077, 0.29019609093666077),
        (0.71848738193511963, 0.28627452254295349, 0.28627452254295349),
        (0.72268909215927124, 0.28235295414924622, 0.28235295414924622),
        (0.72689074277877808, 0.27450981736183167, 0.27450981736183167),
        (0.73109245300292969, 0.27058824896812439, 0.27058824896812439),
        (0.73529410362243652, 0.26666668057441711, 0.26666668057441711),
        (0.73949581384658813, 0.26274511218070984, 0.26274511218070984),
        (0.74369746446609497, 0.25882354378700256, 0.25882354378700256),
        (0.74789917469024658, 0.25490197539329529, 0.25490197539329529),
        (0.75210082530975342, 0.25098040699958801, 0.25098040699958801),
        (0.75630253553390503, 0.24705882370471954, 0.24705882370471954),
        (0.76050418615341187, 0.24313725531101227, 0.24313725531101227),
        (0.76470589637756348, 0.23921568691730499, 0.23921568691730499),
        (0.76890754699707031, 0.23529411852359772, 0.23529411852359772),
        (0.77310925722122192, 0.23137255012989044, 0.23137255012989044),
        (0.77731090784072876, 0.22745098173618317, 0.22745098173618317),
        (0.78151261806488037, 0.22352941334247589, 0.22352941334247589),
        (0.78571426868438721, 0.21960784494876862, 0.21960784494876862),
        (0.78991597890853882, 0.21176470816135406, 0.21176470816135406),
        (0.79411762952804565, 0.20784313976764679, 0.20784313976764679),
        (0.79831933975219727, 0.20392157137393951, 0.20392157137393951),
        (0.8025209903717041, 0.20000000298023224, 0.20000000298023224),
        (0.80672270059585571, 0.19607843458652496, 0.19607843458652496),
        (0.81092435121536255, 0.19215686619281769, 0.19215686619281769),
        (0.81512606143951416, 0.18823529779911041, 0.18823529779911041),
        (0.819327712059021, 0.18431372940540314, 0.18431372940540314),
        (0.82352942228317261, 0.18039216101169586, 0.18039216101169586),
        (0.82773107290267944, 0.17647059261798859, 0.17647059261798859),
        (0.83193278312683105, 0.17254902422428131, 0.17254902422428131),
        (0.83613443374633789, 0.16862745583057404, 0.16862745583057404),
        (0.8403361439704895, 0.16470588743686676, 0.16470588743686676),
        (0.84453779458999634, 0.16078431904315948, 0.16078431904315948),
        (0.84873950481414795, 0.15686275064945221, 0.15686275064945221),
        (0.85294115543365479, 0.14901961386203766, 0.14901961386203766),
        (0.8571428656578064, 0.14509804546833038, 0.14509804546833038),
        (0.86134451627731323, 0.14117647707462311, 0.14117647707462311),
        (0.86554622650146484, 0.13725490868091583, 0.13725490868091583),
        (0.86974787712097168, 0.13333334028720856, 0.13333334028720856),
        (0.87394958734512329, 0.12941177189350128, 0.12941177189350128),
        (0.87815123796463013, 0.12549020349979401, 0.12549020349979401),
        (0.88235294818878174, 0.12156862765550613, 0.12156862765550613),
        (0.88655459880828857, 0.11764705926179886, 0.11764705926179886),
        (0.89075630903244019, 0.11372549086809158, 0.11372549086809158),
        (0.89495795965194702, 0.10980392247438431, 0.10980392247438431),
        (0.89915966987609863, 0.10588235408067703, 0.10588235408067703),
        (0.90336132049560547, 0.10196078568696976, 0.10196078568696976),
        (0.90756303071975708, 0.098039217293262482, 0.098039217293262482),
        (0.91176468133926392, 0.094117648899555206, 0.094117648899555206),
        (0.91596639156341553, 0.086274512112140656, 0.086274512112140656),
        (0.92016804218292236, 0.08235294371843338, 0.08235294371843338),
        (0.92436975240707397, 0.078431375324726105, 0.078431375324726105),
        (0.92857140302658081, 0.074509806931018829, 0.074509806931018829),
        (0.93277311325073242, 0.070588238537311554, 0.070588238537311554),
        (0.93697476387023926, 0.066666670143604279, 0.066666670143604279),
        (0.94117647409439087, 0.062745101749897003, 0.062745101749897003),
        (0.94537812471389771, 0.058823529630899429, 0.058823529630899429),
        (0.94957983493804932, 0.054901961237192154, 0.054901961237192154),
        (0.95378148555755615, 0.050980392843484879, 0.050980392843484879),
        (0.95798319578170776, 0.047058824449777603, 0.047058824449777603),
        (0.9621848464012146, 0.043137256056070328, 0.043137256056070328),
        (0.96638655662536621, 0.039215687662363052, 0.039215687662363052),
        (0.97058820724487305, 0.035294119268655777, 0.035294119268655777),
        (0.97478991746902466, 0.031372550874948502, 0.031372550874948502),
        (0.97899156808853149, 0.023529412224888802, 0.023529412224888802),
        (0.98319327831268311, 0.019607843831181526, 0.019607843831181526),
        (0.98739492893218994, 0.015686275437474251, 0.015686275437474251),
        (0.99159663915634155, 0.011764706112444401, 0.011764706112444401),
        (0.99579828977584839, 0.0078431377187371254, 0.0078431377187371254),
        (1.0, 0.0039215688593685627, 0.0039215688593685627),
    ],
}

datad["Accent"] = _Accent_data
datad["Blues"] = _Blues_data
datad["BrBG"] = _BrBG_data
datad["BuGn"] = _BuGn_data
datad["BuPu"] = _BuPu_data
datad["Dark2"] = _Dark2_data
datad["GnBu"] = _GnBu_data
datad["Greens"] = _Greens_data
datad["Greys"] = _Greys_data
datad["Oranges"] = _Oranges_data
datad["OrRd"] = _OrRd_data
datad["Paired"] = _Paired_data
datad["Pastel1"] = _Pastel1_data
datad["Pastel2"] = _Pastel2_data
datad["PiYG"] = _PiYG_data
datad["PRGn"] = _PRGn_data
datad["PuBu"] = _PuBu_data
datad["PuBuGn"] = _PuBuGn_data
datad["PuOr"] = _PuOr_data
datad["PuRd"] = _PuRd_data
datad["Purples"] = _Purples_data
datad["RdBu"] = _RdBu_data
datad["RdGy"] = _RdGy_data
datad["RdPu"] = _RdPu_data
datad["RdYlBu"] = _RdYlBu_data
datad["RdYlGn"] = _RdYlGn_data
datad["Reds"] = _Reds_data
datad["Set1"] = _Set1_data
datad["Set2"] = _Set2_data
datad["Set3"] = _Set3_data
datad["Spectral"] = _Spectral_data
datad["YlGn"] = _YlGn_data
datad["YlGnBu"] = _YlGnBu_data
datad["YlOrBr"] = _YlOrBr_data
datad["YlOrRd"] = _YlOrRd_data
datad["gist_earth"] = _gist_earth_data
datad["gist_gray"] = _gist_gray_data
datad["gist_heat"] = _gist_heat_data
datad["gist_ncar"] = _gist_ncar_data
datad["gist_rainbow"] = _gist_rainbow_data
datad["gist_stern"] = _gist_stern_data
datad["gist_yarg"] = _gist_yarg_data
