/*
*   Copyright 2008 by David Palacio <dpalacio@uninorte.edu.co>
*
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License version 2,
*   or (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details
*
*   You should have received a copy of the GNU Library General Public
*   License along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include "plasma-nextwallpaper.h"
#include <QSizeF>

#include <KIcon>
#include <Plasma/Corona>
#include <Plasma/Wallpaper>
#include <Plasma/Containment>

#include <QtGui/QGraphicsLinearLayout>
NextWallpaper::NextWallpaper(QObject *parent, const QVariantList &args)
    : Plasma::Applet(parent, args)
{
    QGraphicsLinearLayout* layout = new QGraphicsLinearLayout(this);
    m_icon = new Plasma::IconWidget(KIcon("preferences-desktop-wallpaper"), QString(), this);
    layout->addItem(m_icon);
    setBackgroundHints(DefaultBackground);
    resize(m_icon->iconSize());
    connect(m_icon, SIGNAL(clicked()), this, SLOT(nextWallpaper()));
}

void NextWallpaper::nextWallpaper()
{
    Plasma::Wallpaper* wallpaper = containment()->corona()->containmentForScreen(containment()->screen())->wallpaper();
    if(!wallpaper)
        return;
    QMetaObject::invokeMethod( wallpaper, "nextSlide" );
}

#include "plasma-nextwallpaper.moc"
