/***********************************************************************************
* CPU Load: Plasmoid to monitor CPU Load.
* Copyright (C) 2008  Alexey Tyapkin
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/
// Here we avoid loading the header multiple times
#ifndef CPULOAD_HEADER
#define CPULOAD_HEADER
// We need the Plasma Applet headers
#include <KIcon>
 
#include <Plasma/Applet>
#include <Plasma/Svg>
#include <Plasma/DataEngine>
#include <QFont>
#include <qwidget.h>
#include <QDialog>
#include <QFontMetrics>
#include <QLabel>
#include <QPen>
#include <QSizeF>

#include <plasma/paintutils.h>

#include "ui_cpuLoadSettings.h"
 
class QSizeF;
 
// Define our plasma Applet
class cpuload : public Plasma::Applet
{
    Q_OBJECT
    public:
	enum {
		columns = 31,
		rows	= 10,
		cellWidth  = 10,
		cellHeight = 10,
		cUser	= 0x000000,
		cSystem = 0x585858,
		cDisk	= 0xffffff,
		cNice	= 0xa0a0a0,
		cGrid	= 0xc3c3c3,
		cCPULoadLabel	= 0x585858,
		cCPULoadValue	= 0x585858,
		cCPUName	= 0x585858,
		CPULoadLabelFontSize = 20,
		CPULoadValueFontSize = 16,
		CPUNameFontSize   = 8,
		GraphInfoFontSize = 8
	};
	static const QString defaultFontFamily;

        // Basic Create/Destroy
        cpuload(QObject *parent, const QVariantList &args);
        ~cpuload();
 
        // The paintInterface procedure paints the applet to screen
        void paintInterface(QPainter *painter,
                const QStyleOptionGraphicsItem *option,
                const QRect& contentsRect);
	void init();
	QSizeF contentSizeHint() const;
protected:
	inline bool test(int ifcpu1, int ifcpu2, int ifcpu3, int iscpu1, int iscpu2, int iscpu3) {
		if (((int)(ifcpu1 != iscpu1) + (int)(ifcpu2 != iscpu2) + (int)(ifcpu3 != iscpu3)) > 0)  {
			return true;
		}
		return false;
	}

	int computeHeight3(QFont f, int height, int ystep, int infoSize, int loadSize); 
	void readConfig();
	void writeConfig();
	void defaultsToCfg();
	void plasmoidToCfg();
	void DrawText(QPainter *p, int iCols, int iRows, int iCellWidth, int iCellHeight, int iInfoWidth, int iInfoHeight, int iNameHeight, QColor cUser, QColor cSystem, QColor cDisk, QColor cNice, QColor cCpuLoadLabel, QColor cCpuName, QFont font, int szInfo, int szCpuLoadLabel, int szCpuName);

	void DrawGrid(QPainter *p, int iCols, int iRows, int iCellWidth, int iCellHeight, int iInfoWidth, int iInfoHeight, QColor cGridColor);

public slots:
	void showConfigurationInterface();
	void updatePreview();
	void cfgToPlasmoid();
	void clicked ( QAbstractButton *button);

protected slots:
        void dataUpdated(const QString& source, const Plasma::DataEngine::Data &data);

    private:
        KIcon m_icon;
	int iXCount;
	int iYCount;
	int iXStep;
	int iYStep;
	int iWidth, iWidth1, iWidth2, iWidth3;
	int iHeight, iHeight1, iHeight3;
	int iCPU, iCPU1, iCPU2, iCpuLoad;
	int iSCPU, iSCPU1, iSCPU2;
	int iNCPU, iNCPU1, iNCPU2;
	int iDCPU, iDCPU1, iDCPU2;
	int iCPULoadLabel, iCPULoadValue, iCPUName, iGraphInfo;

        QPixmap *pm;
	QPixmap *dpm;
	QBitmap *mask;
	QRect	rCPUValue;
	QRect	rGraphErase;
	QString cpuInfo[4];
	QPen	pens[4];

	QPixmap *preview;

	QPainterPath cpuNiceGraph;
	QPainterPath cpuDiskGraph;
	QPainterPath cpuSysGraph;
	QPainterPath cpuGraph;

	QColor userColor;
	QColor diskColor;
	QColor niceColor;
	QColor systemColor;
	QColor gridColor;
	QColor cpuLoadLabelColor;
	QColor cpuLoadValueColor;
	QColor cpuNameColor;

	QFont plasmoidFont;
	QString sCpuModel;
	
	QDialog	*cfg_dialog;
	Ui_cpuLoadSettings cfg;

	QVector<int> vIdle;
	QVector<int> vLoad;
	QLabel previewLabel;
};

const QString cpuload::defaultFontFamily="DejaVu Sans";
// This is the command that links your applet to the .desktop file
K_EXPORT_PLASMA_APPLET(cpuload, cpuload)
#endif
