<?php

namespace libphonenumber\Tests\Issues;

use libphonenumber\NumberParseException;
use libphonenumber\PhoneNumberUtil;
use PHPUnit\Framework\TestCase;

class CodeCoverageTest extends TestCase
{
    /**
     * @var PhoneNumberUtil
     */
    private $phoneUtil;

    public function setUp(): void
    {
        PhoneNumberUtil::resetInstance();
        $this->phoneUtil = PhoneNumberUtil::getInstance();
    }

    public function testNullException()
    {
        try {
            $this->phoneUtil->parse(null, null);
        } catch (\Exception $e) {
            if (!$e instanceof NumberParseException) {
                throw $e;
            }
            $this->assertEquals('libphonenumber\\NumberParseException', \get_class($e));
            $this->assertEquals('The phone number supplied was null.', $e->getMessage());

            $this->assertEquals('Error type: 1. The phone number supplied was null.', (string) $e);
        }
    }

    public function testTooShortNumber()
    {
        try {
            $this->phoneUtil->parse('+441', 'GB');
        } catch (\Exception $e) {
            $this->assertEquals('libphonenumber\\NumberParseException', \get_class($e));
            $this->assertEquals('The string supplied is too short to be a phone number.', $e->getMessage());
            $this->assertEquals(3, $e->getCode());

            $this->assertEquals('Error type: 3. The string supplied is too short to be a phone number.', (string) $e);
        }
    }
}
