#include "Tracert.h"

#include "common.h"
#include "TrException.h"
#include "Reply.h"
#include "Time.h"

#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/time.h>
#include <errno.h>

ConcurrentTracert::ConcurrentTracert (Options* opts, int ttl) : TracertImpl(opts) {
  // Initialisation

  ttl_max = ttl;
  
  log(INFO, "Concurrent algo");
}

ConcurrentTracert::~ConcurrentTracert () {
}

bool
ConcurrentTracert::trace () {
  // number of probes sent and received for a given ttl
  nbr_probes_sent      = 0;
  nbr_replies_received = 0;
  all_probes_sent      = false;

  // Iterate on ttl from ttl_initial to ttl_max
  for (int i = opts->ttl_initial; i <= ttl_max; i++) {
    pthread_mutex_lock(&lock);
    
    // Create a new list of probes with the same ttl
    probes_by_ttl[i]           = new ListProbes();
    ListProbes* lprobes        = probes_by_ttl[i];
    lprobes->ttl               = i;
    
    // In this list, create "max_try" timed probes and send them
    lprobes->probes            = new TimedProbe*[opts->max_try];
    
    pthread_mutex_unlock(&lock);
    
    for (int j = 0; j < opts->max_try; j++) {
      
      lprobes->probes[j] = sendProbe(id_current++);

      // Wait "delay_between_probes" before sending the next one
      usleep(opts->delay_between_probes * 1000);
    }
    
    ttl_current++;
  }

  pthread_mutex_lock(&lock);
  // All probes for this ttl have been sent
  all_probes_sent = true;

  waitProbes();
  
  pthread_mutex_unlock(&lock);

  // Indicates the success of the traceroute
  return true;
}

uint8
ConcurrentTracert::getMaxTTL () {
  return ttl_max;
}

uint8
ConcurrentTracert::getNbrReplies(uint8 ttl) {
  log(WARN, "TODO");
  return 0;
}
