module.exports = {
	prettier: true,
	space: true,
	nodeVersion: false,
	extends: [
		'xo-lass',
	],
	envs: [
		'node',
		'browser',
	],
	overrides: [
		{
			files: 'test/**/*.js',
			envs: [
				'mocha',
			],
			rules: {
				'block-scoped-var': 'warn',
				complexity: 'warn',
				'default-case': 'warn',
				eqeqeq: 'warn',
				'func-name-matching': 'warn',
				'func-names': 'warn',
				'guard-for-in': 'warn',
				'handle-callback-err': 'warn',
				'import/no-extraneous-dependencies': 'warn',
				'import/no-unassigned-import': 'warn',
				'import/order': 'warn',
				'max-nested-callbacks': 'warn',
				'new-cap': 'warn',
				'no-eq-null': 'warn',
				'no-extend-native': 'warn',
				'no-implicit-coercion': 'warn',
				'no-multi-assign': 'warn',
				'no-negated-condition': 'off',
				'no-prototype-builtins': 'warn',
				'no-redeclare': 'warn',
				'no-undef': 'warn',
				'no-unused-expressions': 'warn',
				'no-unused-vars': 'warn',
				'no-use-extend-native/no-use-extend-native': 'warn',
				'no-useless-escape': 'warn',
				'no-var': 'warn',
				'no-void': 'warn',
				'n/no-deprecated-api': 'warn',
				'prefer-rest-params': 'warn',
				'prefer-spread': 'warn',
				'unicorn/filename-case': 'warn',
				'valid-jsdoc': 'warn',
				'n/no-path-concat': 'warn',
				'unicorn/no-empty-file': 'warn',
				'unicorn/expiring-todo-comments': 'off',
				'n/prefer-global/buffer': 'off',
				'n/prefer-global/process': 'off',
			},
		},
	],
	rules: {
		'unicorn/prevent-abbreviations': [
			'warn',
			{
				replacements: {
					res: false,
					args: false,
					fn: false,
					err: false,
					e: false,
					i: false,
				},
			},
		],
		'no-bitwise': 'warn',
		'n/prefer-global/buffer': 'off',
		'n/prefer-global/process': 'off',
		'unicorn/no-new-array': 'warn',
		'unicorn/no-this-assignment': 'warn',
		'unicorn/prefer-spread': 'warn',
		'unicorn/catch-error-name': 'warn',
		'unicorn/prefer-code-point': 'warn',
		'n/no-unsupported-features': [
			'error',
			{
				version: 8,
				ignores: [
					'syntax',
				],
			},
		],
    'unicorn/prefer-optional-catch-binding': 'off',
    'no-unused-vars': 'off',
    'unicorn/expiring-todo-comments': 'off'
	},
	globals: [],
};
