# Jasmine-Core 3.0 Release Notes

## Summary

Jasmine 3.0 is a major release of Jasmine, and as such includes some breaking changes in addition to various new features.

There is also a 2.99 release of Jasmine that will present deprecation warnings for suites that will encounter different behavior in 3.0.

## Breaking Changes

* Replace old "catch exceptions" logic with proper fail fast with error reporting
  - Fixes [#414](https://github.com/jasmine/jasmine/issues/414)
  - Fixes [jasmine/jasmine-npm#16](https://github.com/jasmine/jasmine-npm/issues/16)

* Detect an Error passed to `done` and add an expectation failure
  - Fixes [#567](https://github.com/jasmine/jasmine/issues/567)

* Unify status for xdescribe and xit
  - Ensure *All's only execute if at least one child will run
  - Specs will report a status of `excluded` instead of disabled
  - Fixes [#1418](https://github.com/jasmine/jasmine/issues/1418)

* Suite level errors all report the same way (on suiteDone)

* Refactor QueueRunner and remove references to functions that Jasmine is done with

* expect(null).toEqual(jasmine.any(Object)) no longer passes
  - Fixes [#1255](https://github.com/jasmine/jasmine/issues/1255)

* Default to running tests in random order

* The `identity` of a Jasmnine Spy is now a property and no longer a method

* Additionally, Jasmine 3.0 drops support for older browsers and environments. Notably:
  - Internet Explorer 8 and 9
  - Ruby 1.x (for the Ruby gem)
  - Rails 3.x (for the Ruby gem)
  - Python 2.x (for the Python wheel)
  - Nodejs 0.x (for the NPM package)

## Changes

* Remove node modules from python wheel, and update languages

* Allow reporter callbacks to be asynchronous
  - Fixes [#842](https://github.com/jasmine/jasmine/issues/842)

* Allow adding custom spy strategies

* Add the ability to specify the strategy to use for a spy based on which parameters are passed

* Added links to re-run the suites containing a failing spec

* Added a toHaveClass matcher

* More informative pretty-printing of DOM elements

* Allow jasmine-npm to handle its own load errors

* Treat random= as a no-op rather than disabling randomization

* Use prototype for spy strategy for better memory management

* Remove console.js altogether

* Add safari 10 and update readme to include edge

* Determine overall status in core, not reporters

* Filter Jasmine frames from stack traces

* Treat afterAll errors at any level as failures

* Improved reporting of load errors and afterAll errors
  - Pass file and line number to reporters when present
  - Show file and line number in the HTML reporter when present
  - Visually separate adjacent errors in the HTML reporter

* Report loading errors as loading errors, not afterAll errors

* HTML reporter reports overall failure if there are any global errors

* Fail if error events (e.g. syntax errors) occur during loading

* Allow use of a predicate function to validate thrown exceptions

* Check truthiness of toThrowError args, not arg count

------

_Release Notes generated with _[Anchorman](http://github.com/infews/anchorman)_
