// Generated by CoffeeScript 1.10.0
(function() {
  var Case, Liquid, PromiseReduce,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Liquid = require("../../liquid");

  PromiseReduce = require("../../promise_reduce");

  module.exports = Case = (function(superClass) {
    var Syntax, SyntaxHelp, WhenSyntax;

    extend(Case, superClass);

    SyntaxHelp = "Syntax Error in tag 'case' - Valid syntax: case [expression]";

    Syntax = RegExp("(" + Liquid.QuotedFragment.source + ")");

    WhenSyntax = RegExp("(" + Liquid.QuotedFragment.source + ")(?:(?:\\s+or\\s+|\\s*\\,\\s*)(" + Liquid.QuotedFragment.source + "))?");

    function Case(template, tagName, markup) {
      var match;
      this.blocks = [];
      match = Syntax.exec(markup);
      if (!match) {
        throw new Liquid.SyntaxError(SyntaxHelp);
      }
      this.markup = markup;
      Case.__super__.constructor.apply(this, arguments);
    }

    Case.prototype.unknownTag = function(tag, markup) {
      if (tag === "when" || tag === "else") {
        return this.pushBlock(tag, markup);
      } else {
        return Case.__super__.unknownTag.apply(this, arguments);
      }
    };

    Case.prototype.render = function(context) {
      return context.stack((function(_this) {
        return function() {
          return PromiseReduce(_this.blocks, function(chosenBlock, block) {
            if (chosenBlock != null) {
              return chosenBlock;
            }
            return Promise.resolve().then(function() {
              return block.evaluate(context);
            }).then(function(ok) {
              if (ok) {
                return block;
              }
            });
          }, null).then(function(block) {
            if (block != null) {
              return _this.renderAll(block.attachment, context);
            } else {
              return "";
            }
          });
        };
      })(this));
    };

    Case.prototype.pushBlock = function(tag, markup) {
      var block, expressions, i, len, nodelist, ref, results, value;
      if (tag === "else") {
        block = new Liquid.ElseCondition();
        this.blocks.push(block);
        return this.nodelist = block.attach([]);
      } else {
        expressions = Liquid.Helpers.scan(markup, WhenSyntax);
        nodelist = [];
        ref = expressions[0];
        results = [];
        for (i = 0, len = ref.length; i < len; i++) {
          value = ref[i];
          if (value) {
            block = new Liquid.Condition(this.markup, '==', value);
            this.blocks.push(block);
            results.push(this.nodelist = block.attach(nodelist));
          } else {
            results.push(void 0);
          }
        }
        return results;
      }
    };

    return Case;

  })(Liquid.Block);

}).call(this);

//# sourceMappingURL=case.js.map
