# Generating a code coverage report

## Get set up 
- Enable `nightly` Rust:
```bash
rustup override set nightly
```
- Build the demangler:
```bash
cargo install rustfilt
```

- Install Grcov
```bash
cargo install grcov
```

## Generate the report
- Build the program with coverage profiling enabled in the Rust compiler:
```bash
RUSTFLAGS="-C instrument-coverage" make
```
- Run all of the tests:
```bash
make test
#or 
cargo test
sudo bats test/
sudo bats test-dhcp/
```
- Use `grcov` to generate a report:
```bash
grcov . -s . --binary-path ./targets/release/ -t html --branch --ignore-not-existing --ignore '../*' --ignore '/*' -o target/coverage/
```

## Access the report
- To view the code coverage report, you can open the html file generated by `grcov` in your browser:
```bash
firefox target/coverage/index.html
```

- You will now have a large collection of raw profiling data in the form of default_*.profraw files. Now that the report has been created, you can delete these files.


### Additional Resources
- **Instrumentation-based Code Coverage**: https://doc.rust-lang.org/rustc/instrument-coverage.html#-c-instrument-coverageoptions
