// 
// CVPixelBufferPoolSettings.cs: Implements settings for CVPixelBufferPool
//
// Authors: Marek Safar (marek.safar@gmail.com)
//     
// Copyright 2012, Xamarin Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

using System;

using MonoMac.Foundation;
using MonoMac.CoreFoundation;
using MonoMac.ObjCRuntime;

namespace MonoMac.CoreVideo {

	public class CVPixelBufferPoolSettings : DictionaryContainer
	{
#if !COREBUILD
		public CVPixelBufferPoolSettings ()
			: base (new NSMutableDictionary ())
		{
		}

		public CVPixelBufferPoolSettings (NSDictionary dictionary)
			: base (dictionary)
		{
		}

		public int? MinimumBufferCount {
			set {
				SetNumberValue (CVPixelBufferPool.MinimumBufferCountKey, value);
			}
			get {
				return GetInt32Value (CVPixelBufferPool.MinimumBufferCountKey);
			}
		}

		public double? MaximumBufferAgeInSeconds {
			set {
				SetNumberValue (CVPixelBufferPool.MaximumBufferAgeKey, value);
			}
			get {
				return GetDoubleValue (CVPixelBufferPool.MaximumBufferAgeKey);
			}
		}
#endif
	}

	public class CVPixelBufferPoolAllocationSettings : DictionaryContainer
	{
		static readonly NSString ThresholdKey;

		static CVPixelBufferPoolAllocationSettings ()
		{
			var handle = Dlfcn.dlopen (Constants.CoreVideoLibrary, 0);
			if (handle == IntPtr.Zero)
				return;
			try {
				ThresholdKey = Dlfcn.GetStringConstant (handle, "kCVPixelBufferPoolAllocationThresholdKey");
			} finally {
				Dlfcn.dlclose (handle);
			}
		}

#if !COREBUILD
		public CVPixelBufferPoolAllocationSettings ()
			: base (new NSMutableDictionary ())
		{
		}

		public CVPixelBufferPoolAllocationSettings (NSDictionary dictionary)
			: base (dictionary)
		{
		}

		public int? Threshold {
			set {
				SetNumberValue (ThresholdKey, value);
			}
			get {
				return GetInt32Value (ThresholdKey);
			}
		}
#endif
	}
}
