"use strict";

var helpers = require("../../helpers/helpers");

exports["US/Mountain"] = {

	"guess:by:offset" : helpers.makeTestGuess("US/Mountain", { offset: true, expect: "America/Denver" }),

	"guess:by:abbr" : helpers.makeTestGuess("US/Mountain", { abbr: true, expect: "America/Denver" }),

	"1883" : helpers.makeTestYear("US/Mountain", [
		["1883-11-18T19:00:00+00:00", "12:00:00", "MST", 420]
	]),

	"1918" : helpers.makeTestYear("US/Mountain", [
		["1918-03-31T08:59:59+00:00", "01:59:59", "MST", 420],
		["1918-03-31T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1918-10-27T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1918-10-27T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1919" : helpers.makeTestYear("US/Mountain", [
		["1919-03-30T08:59:59+00:00", "01:59:59", "MST", 420],
		["1919-03-30T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1919-10-26T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1919-10-26T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1920" : helpers.makeTestYear("US/Mountain", [
		["1920-03-28T08:59:59+00:00", "01:59:59", "MST", 420],
		["1920-03-28T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1920-10-31T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1920-10-31T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1921" : helpers.makeTestYear("US/Mountain", [
		["1921-03-27T08:59:59+00:00", "01:59:59", "MST", 420],
		["1921-03-27T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1921-05-22T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1921-05-22T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1942" : helpers.makeTestYear("US/Mountain", [
		["1942-02-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["1942-02-09T09:00:00+00:00", "03:00:00", "MWT", 360]
	]),

	"1945" : helpers.makeTestYear("US/Mountain", [
		["1945-08-14T22:59:59+00:00", "16:59:59", "MWT", 360],
		["1945-08-14T23:00:00+00:00", "17:00:00", "MPT", 360],
		["1945-09-30T07:59:59+00:00", "01:59:59", "MPT", 360],
		["1945-09-30T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1965" : helpers.makeTestYear("US/Mountain", [
		["1965-04-25T08:59:59+00:00", "01:59:59", "MST", 420],
		["1965-04-25T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1965-10-31T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1965-10-31T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1966" : helpers.makeTestYear("US/Mountain", [
		["1966-04-24T08:59:59+00:00", "01:59:59", "MST", 420],
		["1966-04-24T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1966-10-30T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1966-10-30T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1967" : helpers.makeTestYear("US/Mountain", [
		["1967-04-30T08:59:59+00:00", "01:59:59", "MST", 420],
		["1967-04-30T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1967-10-29T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1967-10-29T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1968" : helpers.makeTestYear("US/Mountain", [
		["1968-04-28T08:59:59+00:00", "01:59:59", "MST", 420],
		["1968-04-28T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1968-10-27T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1968-10-27T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1969" : helpers.makeTestYear("US/Mountain", [
		["1969-04-27T08:59:59+00:00", "01:59:59", "MST", 420],
		["1969-04-27T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1969-10-26T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1969-10-26T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1970" : helpers.makeTestYear("US/Mountain", [
		["1970-04-26T08:59:59+00:00", "01:59:59", "MST", 420],
		["1970-04-26T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1970-10-25T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1970-10-25T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1971" : helpers.makeTestYear("US/Mountain", [
		["1971-04-25T08:59:59+00:00", "01:59:59", "MST", 420],
		["1971-04-25T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1971-10-31T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1971-10-31T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1972" : helpers.makeTestYear("US/Mountain", [
		["1972-04-30T08:59:59+00:00", "01:59:59", "MST", 420],
		["1972-04-30T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1972-10-29T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1972-10-29T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1973" : helpers.makeTestYear("US/Mountain", [
		["1973-04-29T08:59:59+00:00", "01:59:59", "MST", 420],
		["1973-04-29T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1973-10-28T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1973-10-28T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1974" : helpers.makeTestYear("US/Mountain", [
		["1974-01-06T08:59:59+00:00", "01:59:59", "MST", 420],
		["1974-01-06T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1974-10-27T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1974-10-27T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1975" : helpers.makeTestYear("US/Mountain", [
		["1975-02-23T08:59:59+00:00", "01:59:59", "MST", 420],
		["1975-02-23T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1975-10-26T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1975-10-26T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1976" : helpers.makeTestYear("US/Mountain", [
		["1976-04-25T08:59:59+00:00", "01:59:59", "MST", 420],
		["1976-04-25T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1976-10-31T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1976-10-31T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1977" : helpers.makeTestYear("US/Mountain", [
		["1977-04-24T08:59:59+00:00", "01:59:59", "MST", 420],
		["1977-04-24T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1977-10-30T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1977-10-30T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1978" : helpers.makeTestYear("US/Mountain", [
		["1978-04-30T08:59:59+00:00", "01:59:59", "MST", 420],
		["1978-04-30T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1978-10-29T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1978-10-29T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1979" : helpers.makeTestYear("US/Mountain", [
		["1979-04-29T08:59:59+00:00", "01:59:59", "MST", 420],
		["1979-04-29T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1979-10-28T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1979-10-28T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1980" : helpers.makeTestYear("US/Mountain", [
		["1980-04-27T08:59:59+00:00", "01:59:59", "MST", 420],
		["1980-04-27T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1980-10-26T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1980-10-26T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1981" : helpers.makeTestYear("US/Mountain", [
		["1981-04-26T08:59:59+00:00", "01:59:59", "MST", 420],
		["1981-04-26T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1981-10-25T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1981-10-25T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1982" : helpers.makeTestYear("US/Mountain", [
		["1982-04-25T08:59:59+00:00", "01:59:59", "MST", 420],
		["1982-04-25T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1982-10-31T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1982-10-31T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1983" : helpers.makeTestYear("US/Mountain", [
		["1983-04-24T08:59:59+00:00", "01:59:59", "MST", 420],
		["1983-04-24T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1983-10-30T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1983-10-30T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1984" : helpers.makeTestYear("US/Mountain", [
		["1984-04-29T08:59:59+00:00", "01:59:59", "MST", 420],
		["1984-04-29T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1984-10-28T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1984-10-28T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1985" : helpers.makeTestYear("US/Mountain", [
		["1985-04-28T08:59:59+00:00", "01:59:59", "MST", 420],
		["1985-04-28T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1985-10-27T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1985-10-27T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1986" : helpers.makeTestYear("US/Mountain", [
		["1986-04-27T08:59:59+00:00", "01:59:59", "MST", 420],
		["1986-04-27T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1986-10-26T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1986-10-26T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1987" : helpers.makeTestYear("US/Mountain", [
		["1987-04-05T08:59:59+00:00", "01:59:59", "MST", 420],
		["1987-04-05T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1987-10-25T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1987-10-25T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1988" : helpers.makeTestYear("US/Mountain", [
		["1988-04-03T08:59:59+00:00", "01:59:59", "MST", 420],
		["1988-04-03T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1988-10-30T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1988-10-30T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1989" : helpers.makeTestYear("US/Mountain", [
		["1989-04-02T08:59:59+00:00", "01:59:59", "MST", 420],
		["1989-04-02T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1989-10-29T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1989-10-29T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1990" : helpers.makeTestYear("US/Mountain", [
		["1990-04-01T08:59:59+00:00", "01:59:59", "MST", 420],
		["1990-04-01T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1990-10-28T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1990-10-28T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1991" : helpers.makeTestYear("US/Mountain", [
		["1991-04-07T08:59:59+00:00", "01:59:59", "MST", 420],
		["1991-04-07T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1991-10-27T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1991-10-27T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1992" : helpers.makeTestYear("US/Mountain", [
		["1992-04-05T08:59:59+00:00", "01:59:59", "MST", 420],
		["1992-04-05T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1992-10-25T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1992-10-25T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1993" : helpers.makeTestYear("US/Mountain", [
		["1993-04-04T08:59:59+00:00", "01:59:59", "MST", 420],
		["1993-04-04T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1993-10-31T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1993-10-31T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1994" : helpers.makeTestYear("US/Mountain", [
		["1994-04-03T08:59:59+00:00", "01:59:59", "MST", 420],
		["1994-04-03T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1994-10-30T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1994-10-30T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1995" : helpers.makeTestYear("US/Mountain", [
		["1995-04-02T08:59:59+00:00", "01:59:59", "MST", 420],
		["1995-04-02T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1995-10-29T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1995-10-29T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1996" : helpers.makeTestYear("US/Mountain", [
		["1996-04-07T08:59:59+00:00", "01:59:59", "MST", 420],
		["1996-04-07T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1996-10-27T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1996-10-27T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1997" : helpers.makeTestYear("US/Mountain", [
		["1997-04-06T08:59:59+00:00", "01:59:59", "MST", 420],
		["1997-04-06T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1997-10-26T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1997-10-26T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1998" : helpers.makeTestYear("US/Mountain", [
		["1998-04-05T08:59:59+00:00", "01:59:59", "MST", 420],
		["1998-04-05T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1998-10-25T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1998-10-25T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1999" : helpers.makeTestYear("US/Mountain", [
		["1999-04-04T08:59:59+00:00", "01:59:59", "MST", 420],
		["1999-04-04T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1999-10-31T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1999-10-31T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2000" : helpers.makeTestYear("US/Mountain", [
		["2000-04-02T08:59:59+00:00", "01:59:59", "MST", 420],
		["2000-04-02T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2000-10-29T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2000-10-29T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2001" : helpers.makeTestYear("US/Mountain", [
		["2001-04-01T08:59:59+00:00", "01:59:59", "MST", 420],
		["2001-04-01T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2001-10-28T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2001-10-28T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2002" : helpers.makeTestYear("US/Mountain", [
		["2002-04-07T08:59:59+00:00", "01:59:59", "MST", 420],
		["2002-04-07T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2002-10-27T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2002-10-27T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2003" : helpers.makeTestYear("US/Mountain", [
		["2003-04-06T08:59:59+00:00", "01:59:59", "MST", 420],
		["2003-04-06T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2003-10-26T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2003-10-26T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2004" : helpers.makeTestYear("US/Mountain", [
		["2004-04-04T08:59:59+00:00", "01:59:59", "MST", 420],
		["2004-04-04T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2004-10-31T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2004-10-31T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2005" : helpers.makeTestYear("US/Mountain", [
		["2005-04-03T08:59:59+00:00", "01:59:59", "MST", 420],
		["2005-04-03T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2005-10-30T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2005-10-30T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2006" : helpers.makeTestYear("US/Mountain", [
		["2006-04-02T08:59:59+00:00", "01:59:59", "MST", 420],
		["2006-04-02T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2006-10-29T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2006-10-29T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2007" : helpers.makeTestYear("US/Mountain", [
		["2007-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2007-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2007-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2007-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2008" : helpers.makeTestYear("US/Mountain", [
		["2008-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2008-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2008-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2008-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2009" : helpers.makeTestYear("US/Mountain", [
		["2009-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2009-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2009-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2009-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2010" : helpers.makeTestYear("US/Mountain", [
		["2010-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2010-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2010-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2010-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2011" : helpers.makeTestYear("US/Mountain", [
		["2011-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2011-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2011-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2011-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2012" : helpers.makeTestYear("US/Mountain", [
		["2012-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2012-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2012-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2012-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2013" : helpers.makeTestYear("US/Mountain", [
		["2013-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2013-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2013-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2013-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2014" : helpers.makeTestYear("US/Mountain", [
		["2014-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2014-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2014-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2014-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2015" : helpers.makeTestYear("US/Mountain", [
		["2015-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2015-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2015-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2015-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2016" : helpers.makeTestYear("US/Mountain", [
		["2016-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2016-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2016-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2016-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2017" : helpers.makeTestYear("US/Mountain", [
		["2017-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2017-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2017-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2017-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2018" : helpers.makeTestYear("US/Mountain", [
		["2018-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2018-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2018-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2018-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2019" : helpers.makeTestYear("US/Mountain", [
		["2019-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2019-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2019-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2019-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2020" : helpers.makeTestYear("US/Mountain", [
		["2020-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2020-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2020-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2020-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2021" : helpers.makeTestYear("US/Mountain", [
		["2021-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2021-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2021-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2021-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2022" : helpers.makeTestYear("US/Mountain", [
		["2022-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2022-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2022-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2022-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2023" : helpers.makeTestYear("US/Mountain", [
		["2023-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2023-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2023-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2023-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2024" : helpers.makeTestYear("US/Mountain", [
		["2024-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2024-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2024-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2024-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2025" : helpers.makeTestYear("US/Mountain", [
		["2025-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2025-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2025-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2025-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2026" : helpers.makeTestYear("US/Mountain", [
		["2026-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2026-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2026-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2026-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2027" : helpers.makeTestYear("US/Mountain", [
		["2027-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2027-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2027-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2027-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2028" : helpers.makeTestYear("US/Mountain", [
		["2028-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2028-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2028-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2028-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2029" : helpers.makeTestYear("US/Mountain", [
		["2029-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2029-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2029-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2029-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2030" : helpers.makeTestYear("US/Mountain", [
		["2030-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2030-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2030-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2030-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2031" : helpers.makeTestYear("US/Mountain", [
		["2031-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2031-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2031-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2031-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2032" : helpers.makeTestYear("US/Mountain", [
		["2032-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2032-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2032-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2032-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2033" : helpers.makeTestYear("US/Mountain", [
		["2033-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2033-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2033-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2033-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2034" : helpers.makeTestYear("US/Mountain", [
		["2034-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2034-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2034-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2034-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2035" : helpers.makeTestYear("US/Mountain", [
		["2035-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2035-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2035-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2035-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2036" : helpers.makeTestYear("US/Mountain", [
		["2036-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2036-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2036-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2036-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2037" : helpers.makeTestYear("US/Mountain", [
		["2037-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2037-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2037-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2037-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2038" : helpers.makeTestYear("US/Mountain", [
		["2038-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2038-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2038-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2038-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2039" : helpers.makeTestYear("US/Mountain", [
		["2039-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2039-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2039-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2039-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2040" : helpers.makeTestYear("US/Mountain", [
		["2040-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2040-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2040-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2040-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2041" : helpers.makeTestYear("US/Mountain", [
		["2041-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2041-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2041-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2041-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2042" : helpers.makeTestYear("US/Mountain", [
		["2042-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2042-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2042-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2042-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2043" : helpers.makeTestYear("US/Mountain", [
		["2043-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2043-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2043-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2043-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2044" : helpers.makeTestYear("US/Mountain", [
		["2044-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2044-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2044-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2044-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2045" : helpers.makeTestYear("US/Mountain", [
		["2045-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2045-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2045-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2045-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2046" : helpers.makeTestYear("US/Mountain", [
		["2046-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2046-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2046-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2046-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2047" : helpers.makeTestYear("US/Mountain", [
		["2047-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2047-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2047-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2047-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2048" : helpers.makeTestYear("US/Mountain", [
		["2048-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2048-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2048-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2048-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2049" : helpers.makeTestYear("US/Mountain", [
		["2049-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2049-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2049-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2049-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2050" : helpers.makeTestYear("US/Mountain", [
		["2050-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2050-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2050-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2050-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2051" : helpers.makeTestYear("US/Mountain", [
		["2051-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2051-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2051-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2051-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2052" : helpers.makeTestYear("US/Mountain", [
		["2052-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2052-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2052-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2052-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2053" : helpers.makeTestYear("US/Mountain", [
		["2053-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2053-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2053-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2053-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2054" : helpers.makeTestYear("US/Mountain", [
		["2054-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2054-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2054-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2054-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2055" : helpers.makeTestYear("US/Mountain", [
		["2055-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2055-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2055-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2055-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2056" : helpers.makeTestYear("US/Mountain", [
		["2056-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2056-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2056-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2056-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2057" : helpers.makeTestYear("US/Mountain", [
		["2057-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2057-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2057-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2057-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2058" : helpers.makeTestYear("US/Mountain", [
		["2058-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2058-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2058-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2058-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2059" : helpers.makeTestYear("US/Mountain", [
		["2059-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2059-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2059-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2059-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2060" : helpers.makeTestYear("US/Mountain", [
		["2060-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2060-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2060-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2060-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2061" : helpers.makeTestYear("US/Mountain", [
		["2061-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2061-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2061-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2061-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2062" : helpers.makeTestYear("US/Mountain", [
		["2062-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2062-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2062-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2062-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2063" : helpers.makeTestYear("US/Mountain", [
		["2063-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2063-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2063-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2063-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2064" : helpers.makeTestYear("US/Mountain", [
		["2064-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2064-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2064-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2064-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2065" : helpers.makeTestYear("US/Mountain", [
		["2065-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2065-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2065-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2065-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2066" : helpers.makeTestYear("US/Mountain", [
		["2066-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2066-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2066-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2066-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2067" : helpers.makeTestYear("US/Mountain", [
		["2067-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2067-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2067-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2067-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2068" : helpers.makeTestYear("US/Mountain", [
		["2068-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2068-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2068-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2068-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2069" : helpers.makeTestYear("US/Mountain", [
		["2069-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2069-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2069-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2069-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2070" : helpers.makeTestYear("US/Mountain", [
		["2070-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2070-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2070-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2070-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2071" : helpers.makeTestYear("US/Mountain", [
		["2071-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2071-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2071-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2071-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2072" : helpers.makeTestYear("US/Mountain", [
		["2072-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2072-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2072-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2072-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2073" : helpers.makeTestYear("US/Mountain", [
		["2073-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2073-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2073-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2073-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2074" : helpers.makeTestYear("US/Mountain", [
		["2074-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2074-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2074-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2074-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2075" : helpers.makeTestYear("US/Mountain", [
		["2075-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2075-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2075-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2075-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2076" : helpers.makeTestYear("US/Mountain", [
		["2076-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2076-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2076-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2076-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2077" : helpers.makeTestYear("US/Mountain", [
		["2077-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2077-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2077-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2077-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2078" : helpers.makeTestYear("US/Mountain", [
		["2078-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2078-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2078-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2078-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2079" : helpers.makeTestYear("US/Mountain", [
		["2079-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2079-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2079-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2079-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2080" : helpers.makeTestYear("US/Mountain", [
		["2080-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2080-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2080-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2080-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2081" : helpers.makeTestYear("US/Mountain", [
		["2081-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2081-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2081-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2081-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2082" : helpers.makeTestYear("US/Mountain", [
		["2082-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2082-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2082-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2082-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2083" : helpers.makeTestYear("US/Mountain", [
		["2083-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2083-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2083-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2083-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2084" : helpers.makeTestYear("US/Mountain", [
		["2084-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2084-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2084-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2084-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2085" : helpers.makeTestYear("US/Mountain", [
		["2085-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2085-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2085-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2085-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2086" : helpers.makeTestYear("US/Mountain", [
		["2086-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2086-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2086-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2086-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2087" : helpers.makeTestYear("US/Mountain", [
		["2087-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2087-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2087-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2087-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2088" : helpers.makeTestYear("US/Mountain", [
		["2088-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2088-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2088-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2088-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2089" : helpers.makeTestYear("US/Mountain", [
		["2089-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2089-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2089-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2089-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2090" : helpers.makeTestYear("US/Mountain", [
		["2090-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2090-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2090-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2090-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2091" : helpers.makeTestYear("US/Mountain", [
		["2091-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2091-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2091-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2091-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2092" : helpers.makeTestYear("US/Mountain", [
		["2092-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2092-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2092-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2092-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2093" : helpers.makeTestYear("US/Mountain", [
		["2093-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2093-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2093-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2093-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2094" : helpers.makeTestYear("US/Mountain", [
		["2094-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2094-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2094-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2094-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2095" : helpers.makeTestYear("US/Mountain", [
		["2095-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2095-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2095-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2095-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2096" : helpers.makeTestYear("US/Mountain", [
		["2096-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2096-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2096-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2096-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2097" : helpers.makeTestYear("US/Mountain", [
		["2097-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2097-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2097-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2097-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2098" : helpers.makeTestYear("US/Mountain", [
		["2098-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2098-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2098-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2098-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2099" : helpers.makeTestYear("US/Mountain", [
		["2099-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2099-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2099-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2099-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2100" : helpers.makeTestYear("US/Mountain", [
		["2100-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2100-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2100-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2100-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2101" : helpers.makeTestYear("US/Mountain", [
		["2101-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2101-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2101-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2101-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2102" : helpers.makeTestYear("US/Mountain", [
		["2102-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2102-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2102-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2102-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2103" : helpers.makeTestYear("US/Mountain", [
		["2103-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2103-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2103-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2103-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2104" : helpers.makeTestYear("US/Mountain", [
		["2104-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2104-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2104-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2104-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2105" : helpers.makeTestYear("US/Mountain", [
		["2105-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2105-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2105-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2105-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2106" : helpers.makeTestYear("US/Mountain", [
		["2106-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2106-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2106-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2106-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2107" : helpers.makeTestYear("US/Mountain", [
		["2107-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2107-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2107-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2107-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2108" : helpers.makeTestYear("US/Mountain", [
		["2108-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2108-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2108-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2108-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2109" : helpers.makeTestYear("US/Mountain", [
		["2109-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2109-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2109-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2109-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2110" : helpers.makeTestYear("US/Mountain", [
		["2110-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2110-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2110-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2110-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2111" : helpers.makeTestYear("US/Mountain", [
		["2111-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2111-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2111-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2111-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2112" : helpers.makeTestYear("US/Mountain", [
		["2112-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2112-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2112-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2112-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2113" : helpers.makeTestYear("US/Mountain", [
		["2113-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2113-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2113-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2113-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2114" : helpers.makeTestYear("US/Mountain", [
		["2114-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2114-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2114-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2114-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2115" : helpers.makeTestYear("US/Mountain", [
		["2115-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2115-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2115-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2115-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2116" : helpers.makeTestYear("US/Mountain", [
		["2116-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2116-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2116-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2116-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2117" : helpers.makeTestYear("US/Mountain", [
		["2117-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2117-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2117-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2117-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2118" : helpers.makeTestYear("US/Mountain", [
		["2118-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2118-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2118-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2118-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2119" : helpers.makeTestYear("US/Mountain", [
		["2119-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2119-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2119-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2119-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2120" : helpers.makeTestYear("US/Mountain", [
		["2120-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2120-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2120-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2120-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2121" : helpers.makeTestYear("US/Mountain", [
		["2121-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2121-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2121-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2121-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2122" : helpers.makeTestYear("US/Mountain", [
		["2122-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2122-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2122-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2122-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2123" : helpers.makeTestYear("US/Mountain", [
		["2123-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2123-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2123-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2123-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2124" : helpers.makeTestYear("US/Mountain", [
		["2124-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2124-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2124-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2124-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2125" : helpers.makeTestYear("US/Mountain", [
		["2125-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2125-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2125-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2125-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2126" : helpers.makeTestYear("US/Mountain", [
		["2126-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2126-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2126-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2126-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2127" : helpers.makeTestYear("US/Mountain", [
		["2127-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2127-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2127-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2127-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2128" : helpers.makeTestYear("US/Mountain", [
		["2128-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2128-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2128-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2128-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2129" : helpers.makeTestYear("US/Mountain", [
		["2129-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2129-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2129-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2129-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2130" : helpers.makeTestYear("US/Mountain", [
		["2130-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2130-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2130-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2130-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2131" : helpers.makeTestYear("US/Mountain", [
		["2131-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2131-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2131-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2131-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2132" : helpers.makeTestYear("US/Mountain", [
		["2132-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2132-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2132-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2132-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2133" : helpers.makeTestYear("US/Mountain", [
		["2133-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2133-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2133-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2133-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2134" : helpers.makeTestYear("US/Mountain", [
		["2134-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2134-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2134-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2134-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2135" : helpers.makeTestYear("US/Mountain", [
		["2135-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2135-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2135-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2135-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2136" : helpers.makeTestYear("US/Mountain", [
		["2136-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2136-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2136-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2136-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2137" : helpers.makeTestYear("US/Mountain", [
		["2137-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2137-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2137-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2137-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2138" : helpers.makeTestYear("US/Mountain", [
		["2138-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2138-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2138-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2138-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2139" : helpers.makeTestYear("US/Mountain", [
		["2139-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2139-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2139-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2139-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2140" : helpers.makeTestYear("US/Mountain", [
		["2140-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2140-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2140-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2140-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2141" : helpers.makeTestYear("US/Mountain", [
		["2141-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2141-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2141-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2141-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2142" : helpers.makeTestYear("US/Mountain", [
		["2142-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2142-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2142-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2142-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2143" : helpers.makeTestYear("US/Mountain", [
		["2143-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2143-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2143-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2143-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2144" : helpers.makeTestYear("US/Mountain", [
		["2144-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2144-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2144-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2144-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2145" : helpers.makeTestYear("US/Mountain", [
		["2145-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2145-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2145-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2145-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2146" : helpers.makeTestYear("US/Mountain", [
		["2146-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2146-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2146-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2146-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2147" : helpers.makeTestYear("US/Mountain", [
		["2147-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2147-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2147-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2147-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2148" : helpers.makeTestYear("US/Mountain", [
		["2148-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2148-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2148-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2148-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2149" : helpers.makeTestYear("US/Mountain", [
		["2149-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2149-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2149-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2149-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2150" : helpers.makeTestYear("US/Mountain", [
		["2150-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2150-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2150-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2150-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2151" : helpers.makeTestYear("US/Mountain", [
		["2151-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2151-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2151-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2151-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2152" : helpers.makeTestYear("US/Mountain", [
		["2152-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2152-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2152-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2152-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2153" : helpers.makeTestYear("US/Mountain", [
		["2153-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2153-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2153-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2153-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2154" : helpers.makeTestYear("US/Mountain", [
		["2154-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2154-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2154-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2154-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2155" : helpers.makeTestYear("US/Mountain", [
		["2155-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2155-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2155-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2155-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2156" : helpers.makeTestYear("US/Mountain", [
		["2156-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2156-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2156-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2156-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2157" : helpers.makeTestYear("US/Mountain", [
		["2157-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2157-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2157-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2157-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2158" : helpers.makeTestYear("US/Mountain", [
		["2158-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2158-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2158-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2158-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2159" : helpers.makeTestYear("US/Mountain", [
		["2159-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2159-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2159-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2159-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2160" : helpers.makeTestYear("US/Mountain", [
		["2160-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2160-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2160-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2160-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2161" : helpers.makeTestYear("US/Mountain", [
		["2161-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2161-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2161-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2161-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2162" : helpers.makeTestYear("US/Mountain", [
		["2162-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2162-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2162-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2162-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2163" : helpers.makeTestYear("US/Mountain", [
		["2163-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2163-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2163-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2163-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2164" : helpers.makeTestYear("US/Mountain", [
		["2164-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2164-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2164-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2164-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2165" : helpers.makeTestYear("US/Mountain", [
		["2165-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2165-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2165-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2165-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2166" : helpers.makeTestYear("US/Mountain", [
		["2166-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2166-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2166-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2166-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2167" : helpers.makeTestYear("US/Mountain", [
		["2167-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2167-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2167-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2167-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2168" : helpers.makeTestYear("US/Mountain", [
		["2168-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2168-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2168-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2168-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2169" : helpers.makeTestYear("US/Mountain", [
		["2169-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2169-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2169-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2169-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2170" : helpers.makeTestYear("US/Mountain", [
		["2170-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2170-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2170-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2170-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2171" : helpers.makeTestYear("US/Mountain", [
		["2171-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2171-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2171-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2171-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2172" : helpers.makeTestYear("US/Mountain", [
		["2172-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2172-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2172-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2172-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2173" : helpers.makeTestYear("US/Mountain", [
		["2173-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2173-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2173-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2173-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2174" : helpers.makeTestYear("US/Mountain", [
		["2174-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2174-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2174-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2174-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2175" : helpers.makeTestYear("US/Mountain", [
		["2175-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2175-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2175-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2175-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2176" : helpers.makeTestYear("US/Mountain", [
		["2176-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2176-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2176-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2176-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2177" : helpers.makeTestYear("US/Mountain", [
		["2177-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2177-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2177-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2177-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2178" : helpers.makeTestYear("US/Mountain", [
		["2178-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2178-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2178-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2178-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2179" : helpers.makeTestYear("US/Mountain", [
		["2179-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2179-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2179-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2179-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2180" : helpers.makeTestYear("US/Mountain", [
		["2180-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2180-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2180-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2180-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2181" : helpers.makeTestYear("US/Mountain", [
		["2181-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2181-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2181-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2181-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2182" : helpers.makeTestYear("US/Mountain", [
		["2182-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2182-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2182-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2182-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2183" : helpers.makeTestYear("US/Mountain", [
		["2183-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2183-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2183-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2183-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2184" : helpers.makeTestYear("US/Mountain", [
		["2184-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2184-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2184-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2184-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2185" : helpers.makeTestYear("US/Mountain", [
		["2185-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2185-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2185-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2185-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2186" : helpers.makeTestYear("US/Mountain", [
		["2186-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2186-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2186-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2186-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2187" : helpers.makeTestYear("US/Mountain", [
		["2187-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2187-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2187-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2187-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2188" : helpers.makeTestYear("US/Mountain", [
		["2188-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2188-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2188-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2188-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2189" : helpers.makeTestYear("US/Mountain", [
		["2189-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2189-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2189-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2189-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2190" : helpers.makeTestYear("US/Mountain", [
		["2190-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2190-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2190-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2190-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2191" : helpers.makeTestYear("US/Mountain", [
		["2191-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2191-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2191-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2191-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2192" : helpers.makeTestYear("US/Mountain", [
		["2192-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2192-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2192-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2192-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2193" : helpers.makeTestYear("US/Mountain", [
		["2193-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2193-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2193-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2193-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2194" : helpers.makeTestYear("US/Mountain", [
		["2194-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2194-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2194-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2194-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2195" : helpers.makeTestYear("US/Mountain", [
		["2195-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2195-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2195-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2195-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2196" : helpers.makeTestYear("US/Mountain", [
		["2196-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2196-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2196-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2196-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2197" : helpers.makeTestYear("US/Mountain", [
		["2197-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2197-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2197-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2197-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2198" : helpers.makeTestYear("US/Mountain", [
		["2198-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2198-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2198-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2198-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2199" : helpers.makeTestYear("US/Mountain", [
		["2199-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2199-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2199-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2199-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2200" : helpers.makeTestYear("US/Mountain", [
		["2200-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2200-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2200-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2200-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2201" : helpers.makeTestYear("US/Mountain", [
		["2201-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2201-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2201-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2201-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2202" : helpers.makeTestYear("US/Mountain", [
		["2202-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2202-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2202-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2202-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2203" : helpers.makeTestYear("US/Mountain", [
		["2203-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2203-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2203-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2203-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2204" : helpers.makeTestYear("US/Mountain", [
		["2204-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2204-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2204-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2204-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2205" : helpers.makeTestYear("US/Mountain", [
		["2205-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2205-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2205-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2205-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2206" : helpers.makeTestYear("US/Mountain", [
		["2206-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2206-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2206-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2206-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2207" : helpers.makeTestYear("US/Mountain", [
		["2207-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2207-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2207-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2207-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2208" : helpers.makeTestYear("US/Mountain", [
		["2208-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2208-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2208-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2208-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2209" : helpers.makeTestYear("US/Mountain", [
		["2209-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2209-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2209-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2209-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2210" : helpers.makeTestYear("US/Mountain", [
		["2210-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2210-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2210-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2210-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2211" : helpers.makeTestYear("US/Mountain", [
		["2211-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2211-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2211-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2211-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2212" : helpers.makeTestYear("US/Mountain", [
		["2212-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2212-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2212-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2212-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2213" : helpers.makeTestYear("US/Mountain", [
		["2213-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2213-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2213-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2213-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2214" : helpers.makeTestYear("US/Mountain", [
		["2214-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2214-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2214-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2214-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2215" : helpers.makeTestYear("US/Mountain", [
		["2215-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2215-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2215-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2215-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2216" : helpers.makeTestYear("US/Mountain", [
		["2216-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2216-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2216-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2216-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2217" : helpers.makeTestYear("US/Mountain", [
		["2217-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2217-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2217-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2217-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2218" : helpers.makeTestYear("US/Mountain", [
		["2218-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2218-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2218-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2218-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2219" : helpers.makeTestYear("US/Mountain", [
		["2219-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2219-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2219-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2219-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2220" : helpers.makeTestYear("US/Mountain", [
		["2220-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2220-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2220-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2220-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2221" : helpers.makeTestYear("US/Mountain", [
		["2221-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2221-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2221-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2221-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2222" : helpers.makeTestYear("US/Mountain", [
		["2222-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2222-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2222-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2222-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2223" : helpers.makeTestYear("US/Mountain", [
		["2223-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2223-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2223-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2223-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2224" : helpers.makeTestYear("US/Mountain", [
		["2224-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2224-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2224-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2224-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2225" : helpers.makeTestYear("US/Mountain", [
		["2225-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2225-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2225-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2225-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2226" : helpers.makeTestYear("US/Mountain", [
		["2226-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2226-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2226-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2226-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2227" : helpers.makeTestYear("US/Mountain", [
		["2227-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2227-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2227-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2227-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2228" : helpers.makeTestYear("US/Mountain", [
		["2228-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2228-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2228-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2228-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2229" : helpers.makeTestYear("US/Mountain", [
		["2229-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2229-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2229-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2229-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2230" : helpers.makeTestYear("US/Mountain", [
		["2230-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2230-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2230-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2230-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2231" : helpers.makeTestYear("US/Mountain", [
		["2231-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2231-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2231-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2231-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2232" : helpers.makeTestYear("US/Mountain", [
		["2232-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2232-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2232-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2232-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2233" : helpers.makeTestYear("US/Mountain", [
		["2233-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2233-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2233-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2233-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2234" : helpers.makeTestYear("US/Mountain", [
		["2234-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2234-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2234-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2234-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2235" : helpers.makeTestYear("US/Mountain", [
		["2235-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2235-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2235-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2235-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2236" : helpers.makeTestYear("US/Mountain", [
		["2236-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2236-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2236-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2236-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2237" : helpers.makeTestYear("US/Mountain", [
		["2237-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2237-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2237-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2237-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2238" : helpers.makeTestYear("US/Mountain", [
		["2238-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2238-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2238-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2238-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2239" : helpers.makeTestYear("US/Mountain", [
		["2239-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2239-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2239-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2239-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2240" : helpers.makeTestYear("US/Mountain", [
		["2240-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2240-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2240-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2240-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2241" : helpers.makeTestYear("US/Mountain", [
		["2241-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2241-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2241-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2241-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2242" : helpers.makeTestYear("US/Mountain", [
		["2242-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2242-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2242-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2242-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2243" : helpers.makeTestYear("US/Mountain", [
		["2243-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2243-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2243-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2243-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2244" : helpers.makeTestYear("US/Mountain", [
		["2244-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2244-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2244-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2244-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2245" : helpers.makeTestYear("US/Mountain", [
		["2245-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2245-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2245-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2245-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2246" : helpers.makeTestYear("US/Mountain", [
		["2246-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2246-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2246-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2246-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2247" : helpers.makeTestYear("US/Mountain", [
		["2247-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2247-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2247-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2247-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2248" : helpers.makeTestYear("US/Mountain", [
		["2248-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2248-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2248-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2248-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2249" : helpers.makeTestYear("US/Mountain", [
		["2249-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2249-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2249-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2249-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2250" : helpers.makeTestYear("US/Mountain", [
		["2250-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2250-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2250-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2250-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2251" : helpers.makeTestYear("US/Mountain", [
		["2251-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2251-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2251-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2251-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2252" : helpers.makeTestYear("US/Mountain", [
		["2252-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2252-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2252-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2252-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2253" : helpers.makeTestYear("US/Mountain", [
		["2253-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2253-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2253-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2253-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2254" : helpers.makeTestYear("US/Mountain", [
		["2254-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2254-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2254-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2254-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2255" : helpers.makeTestYear("US/Mountain", [
		["2255-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2255-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2255-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2255-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2256" : helpers.makeTestYear("US/Mountain", [
		["2256-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2256-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2256-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2256-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2257" : helpers.makeTestYear("US/Mountain", [
		["2257-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2257-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2257-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2257-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2258" : helpers.makeTestYear("US/Mountain", [
		["2258-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2258-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2258-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2258-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2259" : helpers.makeTestYear("US/Mountain", [
		["2259-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2259-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2259-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2259-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2260" : helpers.makeTestYear("US/Mountain", [
		["2260-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2260-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2260-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2260-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2261" : helpers.makeTestYear("US/Mountain", [
		["2261-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2261-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2261-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2261-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2262" : helpers.makeTestYear("US/Mountain", [
		["2262-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2262-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2262-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2262-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2263" : helpers.makeTestYear("US/Mountain", [
		["2263-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2263-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2263-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2263-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2264" : helpers.makeTestYear("US/Mountain", [
		["2264-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2264-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2264-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2264-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2265" : helpers.makeTestYear("US/Mountain", [
		["2265-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2265-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2265-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2265-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2266" : helpers.makeTestYear("US/Mountain", [
		["2266-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2266-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2266-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2266-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2267" : helpers.makeTestYear("US/Mountain", [
		["2267-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2267-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2267-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2267-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2268" : helpers.makeTestYear("US/Mountain", [
		["2268-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2268-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2268-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2268-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2269" : helpers.makeTestYear("US/Mountain", [
		["2269-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2269-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2269-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2269-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2270" : helpers.makeTestYear("US/Mountain", [
		["2270-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2270-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2270-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2270-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2271" : helpers.makeTestYear("US/Mountain", [
		["2271-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2271-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2271-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2271-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2272" : helpers.makeTestYear("US/Mountain", [
		["2272-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2272-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2272-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2272-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2273" : helpers.makeTestYear("US/Mountain", [
		["2273-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2273-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2273-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2273-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2274" : helpers.makeTestYear("US/Mountain", [
		["2274-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2274-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2274-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2274-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2275" : helpers.makeTestYear("US/Mountain", [
		["2275-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2275-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2275-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2275-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2276" : helpers.makeTestYear("US/Mountain", [
		["2276-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2276-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2276-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2276-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2277" : helpers.makeTestYear("US/Mountain", [
		["2277-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2277-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2277-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2277-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2278" : helpers.makeTestYear("US/Mountain", [
		["2278-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2278-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2278-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2278-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2279" : helpers.makeTestYear("US/Mountain", [
		["2279-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2279-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2279-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2279-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2280" : helpers.makeTestYear("US/Mountain", [
		["2280-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2280-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2280-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2280-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2281" : helpers.makeTestYear("US/Mountain", [
		["2281-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2281-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2281-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2281-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2282" : helpers.makeTestYear("US/Mountain", [
		["2282-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2282-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2282-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2282-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2283" : helpers.makeTestYear("US/Mountain", [
		["2283-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2283-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2283-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2283-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2284" : helpers.makeTestYear("US/Mountain", [
		["2284-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2284-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2284-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2284-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2285" : helpers.makeTestYear("US/Mountain", [
		["2285-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2285-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2285-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2285-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2286" : helpers.makeTestYear("US/Mountain", [
		["2286-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2286-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2286-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2286-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2287" : helpers.makeTestYear("US/Mountain", [
		["2287-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2287-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2287-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2287-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2288" : helpers.makeTestYear("US/Mountain", [
		["2288-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2288-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2288-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2288-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2289" : helpers.makeTestYear("US/Mountain", [
		["2289-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2289-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2289-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2289-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2290" : helpers.makeTestYear("US/Mountain", [
		["2290-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2290-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2290-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2290-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2291" : helpers.makeTestYear("US/Mountain", [
		["2291-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2291-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2291-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2291-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2292" : helpers.makeTestYear("US/Mountain", [
		["2292-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2292-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2292-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2292-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2293" : helpers.makeTestYear("US/Mountain", [
		["2293-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2293-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2293-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2293-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2294" : helpers.makeTestYear("US/Mountain", [
		["2294-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2294-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2294-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2294-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2295" : helpers.makeTestYear("US/Mountain", [
		["2295-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2295-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2295-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2295-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2296" : helpers.makeTestYear("US/Mountain", [
		["2296-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2296-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2296-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2296-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2297" : helpers.makeTestYear("US/Mountain", [
		["2297-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2297-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2297-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2297-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2298" : helpers.makeTestYear("US/Mountain", [
		["2298-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2298-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2298-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2298-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2299" : helpers.makeTestYear("US/Mountain", [
		["2299-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2299-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2299-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2299-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2300" : helpers.makeTestYear("US/Mountain", [
		["2300-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2300-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2300-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2300-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2301" : helpers.makeTestYear("US/Mountain", [
		["2301-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2301-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2301-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2301-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2302" : helpers.makeTestYear("US/Mountain", [
		["2302-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2302-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2302-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2302-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2303" : helpers.makeTestYear("US/Mountain", [
		["2303-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2303-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2303-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2303-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2304" : helpers.makeTestYear("US/Mountain", [
		["2304-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2304-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2304-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2304-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2305" : helpers.makeTestYear("US/Mountain", [
		["2305-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2305-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2305-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2305-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2306" : helpers.makeTestYear("US/Mountain", [
		["2306-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2306-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2306-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2306-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2307" : helpers.makeTestYear("US/Mountain", [
		["2307-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2307-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2307-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2307-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2308" : helpers.makeTestYear("US/Mountain", [
		["2308-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2308-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2308-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2308-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2309" : helpers.makeTestYear("US/Mountain", [
		["2309-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2309-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2309-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2309-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2310" : helpers.makeTestYear("US/Mountain", [
		["2310-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2310-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2310-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2310-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2311" : helpers.makeTestYear("US/Mountain", [
		["2311-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2311-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2311-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2311-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2312" : helpers.makeTestYear("US/Mountain", [
		["2312-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2312-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2312-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2312-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2313" : helpers.makeTestYear("US/Mountain", [
		["2313-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2313-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2313-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2313-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2314" : helpers.makeTestYear("US/Mountain", [
		["2314-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2314-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2314-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2314-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2315" : helpers.makeTestYear("US/Mountain", [
		["2315-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2315-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2315-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2315-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2316" : helpers.makeTestYear("US/Mountain", [
		["2316-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2316-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2316-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2316-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2317" : helpers.makeTestYear("US/Mountain", [
		["2317-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2317-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2317-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2317-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2318" : helpers.makeTestYear("US/Mountain", [
		["2318-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2318-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2318-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2318-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2319" : helpers.makeTestYear("US/Mountain", [
		["2319-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2319-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2319-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2319-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2320" : helpers.makeTestYear("US/Mountain", [
		["2320-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2320-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2320-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2320-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2321" : helpers.makeTestYear("US/Mountain", [
		["2321-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2321-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2321-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2321-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2322" : helpers.makeTestYear("US/Mountain", [
		["2322-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2322-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2322-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2322-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2323" : helpers.makeTestYear("US/Mountain", [
		["2323-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2323-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2323-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2323-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2324" : helpers.makeTestYear("US/Mountain", [
		["2324-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2324-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2324-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2324-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2325" : helpers.makeTestYear("US/Mountain", [
		["2325-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2325-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2325-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2325-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2326" : helpers.makeTestYear("US/Mountain", [
		["2326-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2326-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2326-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2326-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2327" : helpers.makeTestYear("US/Mountain", [
		["2327-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2327-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2327-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2327-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2328" : helpers.makeTestYear("US/Mountain", [
		["2328-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2328-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2328-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2328-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2329" : helpers.makeTestYear("US/Mountain", [
		["2329-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2329-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2329-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2329-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2330" : helpers.makeTestYear("US/Mountain", [
		["2330-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2330-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2330-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2330-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2331" : helpers.makeTestYear("US/Mountain", [
		["2331-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2331-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2331-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2331-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2332" : helpers.makeTestYear("US/Mountain", [
		["2332-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2332-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2332-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2332-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2333" : helpers.makeTestYear("US/Mountain", [
		["2333-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2333-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2333-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2333-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2334" : helpers.makeTestYear("US/Mountain", [
		["2334-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2334-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2334-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2334-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2335" : helpers.makeTestYear("US/Mountain", [
		["2335-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2335-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2335-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2335-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2336" : helpers.makeTestYear("US/Mountain", [
		["2336-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2336-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2336-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2336-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2337" : helpers.makeTestYear("US/Mountain", [
		["2337-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2337-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2337-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2337-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2338" : helpers.makeTestYear("US/Mountain", [
		["2338-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2338-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2338-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2338-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2339" : helpers.makeTestYear("US/Mountain", [
		["2339-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2339-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2339-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2339-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2340" : helpers.makeTestYear("US/Mountain", [
		["2340-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2340-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2340-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2340-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2341" : helpers.makeTestYear("US/Mountain", [
		["2341-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2341-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2341-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2341-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2342" : helpers.makeTestYear("US/Mountain", [
		["2342-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2342-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2342-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2342-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2343" : helpers.makeTestYear("US/Mountain", [
		["2343-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2343-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2343-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2343-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2344" : helpers.makeTestYear("US/Mountain", [
		["2344-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2344-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2344-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2344-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2345" : helpers.makeTestYear("US/Mountain", [
		["2345-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2345-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2345-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2345-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2346" : helpers.makeTestYear("US/Mountain", [
		["2346-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2346-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2346-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2346-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2347" : helpers.makeTestYear("US/Mountain", [
		["2347-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2347-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2347-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2347-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2348" : helpers.makeTestYear("US/Mountain", [
		["2348-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2348-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2348-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2348-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2349" : helpers.makeTestYear("US/Mountain", [
		["2349-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2349-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2349-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2349-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2350" : helpers.makeTestYear("US/Mountain", [
		["2350-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2350-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2350-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2350-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2351" : helpers.makeTestYear("US/Mountain", [
		["2351-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2351-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2351-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2351-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2352" : helpers.makeTestYear("US/Mountain", [
		["2352-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2352-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2352-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2352-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2353" : helpers.makeTestYear("US/Mountain", [
		["2353-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2353-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2353-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2353-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2354" : helpers.makeTestYear("US/Mountain", [
		["2354-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2354-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2354-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2354-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2355" : helpers.makeTestYear("US/Mountain", [
		["2355-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2355-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2355-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2355-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2356" : helpers.makeTestYear("US/Mountain", [
		["2356-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2356-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2356-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2356-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2357" : helpers.makeTestYear("US/Mountain", [
		["2357-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2357-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2357-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2357-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2358" : helpers.makeTestYear("US/Mountain", [
		["2358-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2358-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2358-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2358-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2359" : helpers.makeTestYear("US/Mountain", [
		["2359-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2359-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2359-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2359-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2360" : helpers.makeTestYear("US/Mountain", [
		["2360-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2360-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2360-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2360-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2361" : helpers.makeTestYear("US/Mountain", [
		["2361-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2361-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2361-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2361-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2362" : helpers.makeTestYear("US/Mountain", [
		["2362-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2362-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2362-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2362-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2363" : helpers.makeTestYear("US/Mountain", [
		["2363-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2363-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2363-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2363-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2364" : helpers.makeTestYear("US/Mountain", [
		["2364-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2364-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2364-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2364-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2365" : helpers.makeTestYear("US/Mountain", [
		["2365-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2365-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2365-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2365-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2366" : helpers.makeTestYear("US/Mountain", [
		["2366-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2366-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2366-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2366-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2367" : helpers.makeTestYear("US/Mountain", [
		["2367-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2367-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2367-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2367-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2368" : helpers.makeTestYear("US/Mountain", [
		["2368-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2368-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2368-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2368-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2369" : helpers.makeTestYear("US/Mountain", [
		["2369-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2369-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2369-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2369-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2370" : helpers.makeTestYear("US/Mountain", [
		["2370-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2370-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2370-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2370-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2371" : helpers.makeTestYear("US/Mountain", [
		["2371-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2371-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2371-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2371-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2372" : helpers.makeTestYear("US/Mountain", [
		["2372-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2372-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2372-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2372-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2373" : helpers.makeTestYear("US/Mountain", [
		["2373-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2373-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2373-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2373-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2374" : helpers.makeTestYear("US/Mountain", [
		["2374-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2374-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2374-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2374-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2375" : helpers.makeTestYear("US/Mountain", [
		["2375-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2375-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2375-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2375-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2376" : helpers.makeTestYear("US/Mountain", [
		["2376-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2376-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2376-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2376-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2377" : helpers.makeTestYear("US/Mountain", [
		["2377-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2377-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2377-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2377-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2378" : helpers.makeTestYear("US/Mountain", [
		["2378-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2378-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2378-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2378-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2379" : helpers.makeTestYear("US/Mountain", [
		["2379-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2379-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2379-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2379-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2380" : helpers.makeTestYear("US/Mountain", [
		["2380-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2380-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2380-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2380-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2381" : helpers.makeTestYear("US/Mountain", [
		["2381-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2381-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2381-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2381-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2382" : helpers.makeTestYear("US/Mountain", [
		["2382-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2382-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2382-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2382-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2383" : helpers.makeTestYear("US/Mountain", [
		["2383-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2383-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2383-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2383-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2384" : helpers.makeTestYear("US/Mountain", [
		["2384-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2384-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2384-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2384-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2385" : helpers.makeTestYear("US/Mountain", [
		["2385-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2385-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2385-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2385-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2386" : helpers.makeTestYear("US/Mountain", [
		["2386-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2386-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2386-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2386-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2387" : helpers.makeTestYear("US/Mountain", [
		["2387-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2387-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2387-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2387-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2388" : helpers.makeTestYear("US/Mountain", [
		["2388-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2388-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2388-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2388-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2389" : helpers.makeTestYear("US/Mountain", [
		["2389-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2389-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2389-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2389-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2390" : helpers.makeTestYear("US/Mountain", [
		["2390-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2390-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2390-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2390-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2391" : helpers.makeTestYear("US/Mountain", [
		["2391-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2391-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2391-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2391-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2392" : helpers.makeTestYear("US/Mountain", [
		["2392-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2392-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2392-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2392-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2393" : helpers.makeTestYear("US/Mountain", [
		["2393-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2393-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2393-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2393-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2394" : helpers.makeTestYear("US/Mountain", [
		["2394-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2394-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2394-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2394-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2395" : helpers.makeTestYear("US/Mountain", [
		["2395-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2395-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2395-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2395-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2396" : helpers.makeTestYear("US/Mountain", [
		["2396-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2396-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2396-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2396-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2397" : helpers.makeTestYear("US/Mountain", [
		["2397-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2397-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2397-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2397-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2398" : helpers.makeTestYear("US/Mountain", [
		["2398-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2398-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2398-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2398-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2399" : helpers.makeTestYear("US/Mountain", [
		["2399-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2399-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2399-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2399-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2400" : helpers.makeTestYear("US/Mountain", [
		["2400-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2400-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2400-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2400-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2401" : helpers.makeTestYear("US/Mountain", [
		["2401-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2401-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2401-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2401-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2402" : helpers.makeTestYear("US/Mountain", [
		["2402-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2402-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2402-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2402-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2403" : helpers.makeTestYear("US/Mountain", [
		["2403-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2403-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2403-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2403-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2404" : helpers.makeTestYear("US/Mountain", [
		["2404-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2404-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2404-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2404-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2405" : helpers.makeTestYear("US/Mountain", [
		["2405-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2405-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2405-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2405-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2406" : helpers.makeTestYear("US/Mountain", [
		["2406-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2406-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2406-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2406-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2407" : helpers.makeTestYear("US/Mountain", [
		["2407-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2407-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2407-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2407-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2408" : helpers.makeTestYear("US/Mountain", [
		["2408-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2408-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2408-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2408-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2409" : helpers.makeTestYear("US/Mountain", [
		["2409-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2409-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2409-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2409-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2410" : helpers.makeTestYear("US/Mountain", [
		["2410-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2410-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2410-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2410-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2411" : helpers.makeTestYear("US/Mountain", [
		["2411-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2411-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2411-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2411-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2412" : helpers.makeTestYear("US/Mountain", [
		["2412-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2412-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2412-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2412-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2413" : helpers.makeTestYear("US/Mountain", [
		["2413-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2413-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2413-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2413-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2414" : helpers.makeTestYear("US/Mountain", [
		["2414-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2414-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2414-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2414-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2415" : helpers.makeTestYear("US/Mountain", [
		["2415-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2415-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2415-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2415-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2416" : helpers.makeTestYear("US/Mountain", [
		["2416-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2416-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2416-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2416-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2417" : helpers.makeTestYear("US/Mountain", [
		["2417-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2417-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2417-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2417-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2418" : helpers.makeTestYear("US/Mountain", [
		["2418-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2418-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2418-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2418-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2419" : helpers.makeTestYear("US/Mountain", [
		["2419-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2419-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2419-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2419-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2420" : helpers.makeTestYear("US/Mountain", [
		["2420-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2420-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2420-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2420-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2421" : helpers.makeTestYear("US/Mountain", [
		["2421-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2421-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2421-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2421-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2422" : helpers.makeTestYear("US/Mountain", [
		["2422-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2422-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2422-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2422-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2423" : helpers.makeTestYear("US/Mountain", [
		["2423-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2423-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2423-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2423-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2424" : helpers.makeTestYear("US/Mountain", [
		["2424-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2424-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2424-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2424-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2425" : helpers.makeTestYear("US/Mountain", [
		["2425-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2425-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2425-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2425-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2426" : helpers.makeTestYear("US/Mountain", [
		["2426-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2426-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2426-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2426-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2427" : helpers.makeTestYear("US/Mountain", [
		["2427-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2427-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2427-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2427-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2428" : helpers.makeTestYear("US/Mountain", [
		["2428-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2428-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2428-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2428-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2429" : helpers.makeTestYear("US/Mountain", [
		["2429-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2429-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2429-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2429-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2430" : helpers.makeTestYear("US/Mountain", [
		["2430-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2430-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2430-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2430-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2431" : helpers.makeTestYear("US/Mountain", [
		["2431-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2431-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2431-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2431-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2432" : helpers.makeTestYear("US/Mountain", [
		["2432-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2432-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2432-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2432-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2433" : helpers.makeTestYear("US/Mountain", [
		["2433-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2433-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2433-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2433-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2434" : helpers.makeTestYear("US/Mountain", [
		["2434-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2434-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2434-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2434-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2435" : helpers.makeTestYear("US/Mountain", [
		["2435-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2435-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2435-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2435-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2436" : helpers.makeTestYear("US/Mountain", [
		["2436-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2436-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2436-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2436-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2437" : helpers.makeTestYear("US/Mountain", [
		["2437-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2437-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2437-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2437-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2438" : helpers.makeTestYear("US/Mountain", [
		["2438-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2438-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2438-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2438-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2439" : helpers.makeTestYear("US/Mountain", [
		["2439-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2439-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2439-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2439-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2440" : helpers.makeTestYear("US/Mountain", [
		["2440-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2440-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2440-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2440-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2441" : helpers.makeTestYear("US/Mountain", [
		["2441-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2441-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2441-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2441-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2442" : helpers.makeTestYear("US/Mountain", [
		["2442-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2442-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2442-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2442-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2443" : helpers.makeTestYear("US/Mountain", [
		["2443-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2443-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2443-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2443-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2444" : helpers.makeTestYear("US/Mountain", [
		["2444-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2444-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2444-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2444-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2445" : helpers.makeTestYear("US/Mountain", [
		["2445-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2445-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2445-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2445-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2446" : helpers.makeTestYear("US/Mountain", [
		["2446-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2446-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2446-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2446-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2447" : helpers.makeTestYear("US/Mountain", [
		["2447-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2447-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2447-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2447-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2448" : helpers.makeTestYear("US/Mountain", [
		["2448-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2448-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2448-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2448-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2449" : helpers.makeTestYear("US/Mountain", [
		["2449-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2449-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2449-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2449-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2450" : helpers.makeTestYear("US/Mountain", [
		["2450-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2450-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2450-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2450-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2451" : helpers.makeTestYear("US/Mountain", [
		["2451-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2451-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2451-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2451-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2452" : helpers.makeTestYear("US/Mountain", [
		["2452-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2452-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2452-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2452-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2453" : helpers.makeTestYear("US/Mountain", [
		["2453-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2453-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2453-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2453-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2454" : helpers.makeTestYear("US/Mountain", [
		["2454-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2454-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2454-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2454-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2455" : helpers.makeTestYear("US/Mountain", [
		["2455-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2455-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2455-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2455-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2456" : helpers.makeTestYear("US/Mountain", [
		["2456-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2456-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2456-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2456-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2457" : helpers.makeTestYear("US/Mountain", [
		["2457-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2457-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2457-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2457-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2458" : helpers.makeTestYear("US/Mountain", [
		["2458-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2458-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2458-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2458-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2459" : helpers.makeTestYear("US/Mountain", [
		["2459-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2459-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2459-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2459-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2460" : helpers.makeTestYear("US/Mountain", [
		["2460-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2460-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2460-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2460-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2461" : helpers.makeTestYear("US/Mountain", [
		["2461-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2461-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2461-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2461-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2462" : helpers.makeTestYear("US/Mountain", [
		["2462-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2462-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2462-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2462-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2463" : helpers.makeTestYear("US/Mountain", [
		["2463-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2463-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2463-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2463-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2464" : helpers.makeTestYear("US/Mountain", [
		["2464-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2464-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2464-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2464-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2465" : helpers.makeTestYear("US/Mountain", [
		["2465-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2465-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2465-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2465-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2466" : helpers.makeTestYear("US/Mountain", [
		["2466-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2466-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2466-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2466-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2467" : helpers.makeTestYear("US/Mountain", [
		["2467-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2467-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2467-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2467-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2468" : helpers.makeTestYear("US/Mountain", [
		["2468-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2468-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2468-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2468-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2469" : helpers.makeTestYear("US/Mountain", [
		["2469-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2469-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2469-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2469-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2470" : helpers.makeTestYear("US/Mountain", [
		["2470-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2470-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2470-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2470-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2471" : helpers.makeTestYear("US/Mountain", [
		["2471-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2471-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2471-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2471-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2472" : helpers.makeTestYear("US/Mountain", [
		["2472-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2472-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2472-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2472-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2473" : helpers.makeTestYear("US/Mountain", [
		["2473-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2473-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2473-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2473-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2474" : helpers.makeTestYear("US/Mountain", [
		["2474-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2474-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2474-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2474-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2475" : helpers.makeTestYear("US/Mountain", [
		["2475-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2475-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2475-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2475-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2476" : helpers.makeTestYear("US/Mountain", [
		["2476-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2476-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2476-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2476-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2477" : helpers.makeTestYear("US/Mountain", [
		["2477-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2477-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2477-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2477-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2478" : helpers.makeTestYear("US/Mountain", [
		["2478-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2478-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2478-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2478-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2479" : helpers.makeTestYear("US/Mountain", [
		["2479-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2479-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2479-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2479-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2480" : helpers.makeTestYear("US/Mountain", [
		["2480-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2480-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2480-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2480-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2481" : helpers.makeTestYear("US/Mountain", [
		["2481-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2481-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2481-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2481-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2482" : helpers.makeTestYear("US/Mountain", [
		["2482-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2482-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2482-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2482-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2483" : helpers.makeTestYear("US/Mountain", [
		["2483-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2483-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2483-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2483-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2484" : helpers.makeTestYear("US/Mountain", [
		["2484-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2484-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2484-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2484-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2485" : helpers.makeTestYear("US/Mountain", [
		["2485-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2485-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2485-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2485-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2486" : helpers.makeTestYear("US/Mountain", [
		["2486-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2486-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2486-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2486-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2487" : helpers.makeTestYear("US/Mountain", [
		["2487-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2487-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2487-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2487-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2488" : helpers.makeTestYear("US/Mountain", [
		["2488-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2488-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2488-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2488-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2489" : helpers.makeTestYear("US/Mountain", [
		["2489-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2489-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2489-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2489-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2490" : helpers.makeTestYear("US/Mountain", [
		["2490-03-12T08:59:59+00:00", "01:59:59", "MST", 420],
		["2490-03-12T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2490-11-05T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2490-11-05T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2491" : helpers.makeTestYear("US/Mountain", [
		["2491-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2491-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2491-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2491-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2492" : helpers.makeTestYear("US/Mountain", [
		["2492-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2492-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2492-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2492-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2493" : helpers.makeTestYear("US/Mountain", [
		["2493-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2493-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2493-11-01T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2493-11-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2494" : helpers.makeTestYear("US/Mountain", [
		["2494-03-14T08:59:59+00:00", "01:59:59", "MST", 420],
		["2494-03-14T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2494-11-07T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2494-11-07T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2495" : helpers.makeTestYear("US/Mountain", [
		["2495-03-13T08:59:59+00:00", "01:59:59", "MST", 420],
		["2495-03-13T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2495-11-06T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2495-11-06T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2496" : helpers.makeTestYear("US/Mountain", [
		["2496-03-11T08:59:59+00:00", "01:59:59", "MST", 420],
		["2496-03-11T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2496-11-04T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2496-11-04T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2497" : helpers.makeTestYear("US/Mountain", [
		["2497-03-10T08:59:59+00:00", "01:59:59", "MST", 420],
		["2497-03-10T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2497-11-03T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2497-11-03T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2498" : helpers.makeTestYear("US/Mountain", [
		["2498-03-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["2498-03-09T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2498-11-02T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2498-11-02T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2499" : helpers.makeTestYear("US/Mountain", [
		["2499-03-08T08:59:59+00:00", "01:59:59", "MST", 420],
		["2499-03-08T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2499-11-01T07:59:59+00:00", "01:59:59", "MDT", 360]
	])
};