"use strict";

var helpers = require("../../helpers/helpers");

exports["America/Miquelon"] = {

	"guess:by:offset" : helpers.makeTestGuess("America/Miquelon", { offset: true }),

	"guess:by:abbr" : helpers.makeTestGuess("America/Miquelon", { abbr: true }),

	"1911" : helpers.makeTestYear("America/Miquelon", [
		["1911-05-15T03:44:40+00:00", "23:44:40", "AST", 240]
	]),

	"1980" : helpers.makeTestYear("America/Miquelon", [
		["1980-05-01T03:59:59+00:00", "23:59:59", "AST", 240],
		["1980-05-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1987" : helpers.makeTestYear("America/Miquelon", [
		["1987-04-05T04:59:59+00:00", "01:59:59", "-03", 180],
		["1987-04-05T05:00:00+00:00", "03:00:00", "-02", 120],
		["1987-10-25T03:59:59+00:00", "01:59:59", "-02", 120],
		["1987-10-25T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1988" : helpers.makeTestYear("America/Miquelon", [
		["1988-04-03T04:59:59+00:00", "01:59:59", "-03", 180],
		["1988-04-03T05:00:00+00:00", "03:00:00", "-02", 120],
		["1988-10-30T03:59:59+00:00", "01:59:59", "-02", 120],
		["1988-10-30T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1989" : helpers.makeTestYear("America/Miquelon", [
		["1989-04-02T04:59:59+00:00", "01:59:59", "-03", 180],
		["1989-04-02T05:00:00+00:00", "03:00:00", "-02", 120],
		["1989-10-29T03:59:59+00:00", "01:59:59", "-02", 120],
		["1989-10-29T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1990" : helpers.makeTestYear("America/Miquelon", [
		["1990-04-01T04:59:59+00:00", "01:59:59", "-03", 180],
		["1990-04-01T05:00:00+00:00", "03:00:00", "-02", 120],
		["1990-10-28T03:59:59+00:00", "01:59:59", "-02", 120],
		["1990-10-28T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1991" : helpers.makeTestYear("America/Miquelon", [
		["1991-04-07T04:59:59+00:00", "01:59:59", "-03", 180],
		["1991-04-07T05:00:00+00:00", "03:00:00", "-02", 120],
		["1991-10-27T03:59:59+00:00", "01:59:59", "-02", 120],
		["1991-10-27T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1992" : helpers.makeTestYear("America/Miquelon", [
		["1992-04-05T04:59:59+00:00", "01:59:59", "-03", 180],
		["1992-04-05T05:00:00+00:00", "03:00:00", "-02", 120],
		["1992-10-25T03:59:59+00:00", "01:59:59", "-02", 120],
		["1992-10-25T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1993" : helpers.makeTestYear("America/Miquelon", [
		["1993-04-04T04:59:59+00:00", "01:59:59", "-03", 180],
		["1993-04-04T05:00:00+00:00", "03:00:00", "-02", 120],
		["1993-10-31T03:59:59+00:00", "01:59:59", "-02", 120],
		["1993-10-31T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1994" : helpers.makeTestYear("America/Miquelon", [
		["1994-04-03T04:59:59+00:00", "01:59:59", "-03", 180],
		["1994-04-03T05:00:00+00:00", "03:00:00", "-02", 120],
		["1994-10-30T03:59:59+00:00", "01:59:59", "-02", 120],
		["1994-10-30T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1995" : helpers.makeTestYear("America/Miquelon", [
		["1995-04-02T04:59:59+00:00", "01:59:59", "-03", 180],
		["1995-04-02T05:00:00+00:00", "03:00:00", "-02", 120],
		["1995-10-29T03:59:59+00:00", "01:59:59", "-02", 120],
		["1995-10-29T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1996" : helpers.makeTestYear("America/Miquelon", [
		["1996-04-07T04:59:59+00:00", "01:59:59", "-03", 180],
		["1996-04-07T05:00:00+00:00", "03:00:00", "-02", 120],
		["1996-10-27T03:59:59+00:00", "01:59:59", "-02", 120],
		["1996-10-27T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1997" : helpers.makeTestYear("America/Miquelon", [
		["1997-04-06T04:59:59+00:00", "01:59:59", "-03", 180],
		["1997-04-06T05:00:00+00:00", "03:00:00", "-02", 120],
		["1997-10-26T03:59:59+00:00", "01:59:59", "-02", 120],
		["1997-10-26T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1998" : helpers.makeTestYear("America/Miquelon", [
		["1998-04-05T04:59:59+00:00", "01:59:59", "-03", 180],
		["1998-04-05T05:00:00+00:00", "03:00:00", "-02", 120],
		["1998-10-25T03:59:59+00:00", "01:59:59", "-02", 120],
		["1998-10-25T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1999" : helpers.makeTestYear("America/Miquelon", [
		["1999-04-04T04:59:59+00:00", "01:59:59", "-03", 180],
		["1999-04-04T05:00:00+00:00", "03:00:00", "-02", 120],
		["1999-10-31T03:59:59+00:00", "01:59:59", "-02", 120],
		["1999-10-31T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2000" : helpers.makeTestYear("America/Miquelon", [
		["2000-04-02T04:59:59+00:00", "01:59:59", "-03", 180],
		["2000-04-02T05:00:00+00:00", "03:00:00", "-02", 120],
		["2000-10-29T03:59:59+00:00", "01:59:59", "-02", 120],
		["2000-10-29T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2001" : helpers.makeTestYear("America/Miquelon", [
		["2001-04-01T04:59:59+00:00", "01:59:59", "-03", 180],
		["2001-04-01T05:00:00+00:00", "03:00:00", "-02", 120],
		["2001-10-28T03:59:59+00:00", "01:59:59", "-02", 120],
		["2001-10-28T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2002" : helpers.makeTestYear("America/Miquelon", [
		["2002-04-07T04:59:59+00:00", "01:59:59", "-03", 180],
		["2002-04-07T05:00:00+00:00", "03:00:00", "-02", 120],
		["2002-10-27T03:59:59+00:00", "01:59:59", "-02", 120],
		["2002-10-27T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2003" : helpers.makeTestYear("America/Miquelon", [
		["2003-04-06T04:59:59+00:00", "01:59:59", "-03", 180],
		["2003-04-06T05:00:00+00:00", "03:00:00", "-02", 120],
		["2003-10-26T03:59:59+00:00", "01:59:59", "-02", 120],
		["2003-10-26T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2004" : helpers.makeTestYear("America/Miquelon", [
		["2004-04-04T04:59:59+00:00", "01:59:59", "-03", 180],
		["2004-04-04T05:00:00+00:00", "03:00:00", "-02", 120],
		["2004-10-31T03:59:59+00:00", "01:59:59", "-02", 120],
		["2004-10-31T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2005" : helpers.makeTestYear("America/Miquelon", [
		["2005-04-03T04:59:59+00:00", "01:59:59", "-03", 180],
		["2005-04-03T05:00:00+00:00", "03:00:00", "-02", 120],
		["2005-10-30T03:59:59+00:00", "01:59:59", "-02", 120],
		["2005-10-30T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2006" : helpers.makeTestYear("America/Miquelon", [
		["2006-04-02T04:59:59+00:00", "01:59:59", "-03", 180],
		["2006-04-02T05:00:00+00:00", "03:00:00", "-02", 120],
		["2006-10-29T03:59:59+00:00", "01:59:59", "-02", 120],
		["2006-10-29T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2007" : helpers.makeTestYear("America/Miquelon", [
		["2007-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2007-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2007-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2007-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2008" : helpers.makeTestYear("America/Miquelon", [
		["2008-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2008-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2008-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2008-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2009" : helpers.makeTestYear("America/Miquelon", [
		["2009-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2009-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2009-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2009-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2010" : helpers.makeTestYear("America/Miquelon", [
		["2010-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2010-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2010-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2010-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2011" : helpers.makeTestYear("America/Miquelon", [
		["2011-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2011-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2011-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2011-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2012" : helpers.makeTestYear("America/Miquelon", [
		["2012-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2012-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2012-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2012-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2013" : helpers.makeTestYear("America/Miquelon", [
		["2013-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2013-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2013-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2013-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2014" : helpers.makeTestYear("America/Miquelon", [
		["2014-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2014-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2014-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2014-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2015" : helpers.makeTestYear("America/Miquelon", [
		["2015-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2015-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2015-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2015-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2016" : helpers.makeTestYear("America/Miquelon", [
		["2016-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2016-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2016-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2016-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2017" : helpers.makeTestYear("America/Miquelon", [
		["2017-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2017-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2017-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2017-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2018" : helpers.makeTestYear("America/Miquelon", [
		["2018-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2018-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2018-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2018-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2019" : helpers.makeTestYear("America/Miquelon", [
		["2019-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2019-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2019-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2019-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2020" : helpers.makeTestYear("America/Miquelon", [
		["2020-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2020-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2020-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2020-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2021" : helpers.makeTestYear("America/Miquelon", [
		["2021-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2021-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2021-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2021-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2022" : helpers.makeTestYear("America/Miquelon", [
		["2022-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2022-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2022-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2022-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2023" : helpers.makeTestYear("America/Miquelon", [
		["2023-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2023-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2023-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2023-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2024" : helpers.makeTestYear("America/Miquelon", [
		["2024-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2024-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2024-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2024-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2025" : helpers.makeTestYear("America/Miquelon", [
		["2025-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2025-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2025-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2025-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2026" : helpers.makeTestYear("America/Miquelon", [
		["2026-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2026-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2026-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2026-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2027" : helpers.makeTestYear("America/Miquelon", [
		["2027-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2027-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2027-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2027-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2028" : helpers.makeTestYear("America/Miquelon", [
		["2028-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2028-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2028-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2028-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2029" : helpers.makeTestYear("America/Miquelon", [
		["2029-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2029-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2029-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2029-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2030" : helpers.makeTestYear("America/Miquelon", [
		["2030-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2030-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2030-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2030-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2031" : helpers.makeTestYear("America/Miquelon", [
		["2031-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2031-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2031-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2031-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2032" : helpers.makeTestYear("America/Miquelon", [
		["2032-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2032-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2032-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2032-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2033" : helpers.makeTestYear("America/Miquelon", [
		["2033-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2033-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2033-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2033-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2034" : helpers.makeTestYear("America/Miquelon", [
		["2034-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2034-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2034-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2034-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2035" : helpers.makeTestYear("America/Miquelon", [
		["2035-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2035-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2035-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2035-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2036" : helpers.makeTestYear("America/Miquelon", [
		["2036-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2036-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2036-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2036-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2037" : helpers.makeTestYear("America/Miquelon", [
		["2037-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2037-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2037-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2037-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2038" : helpers.makeTestYear("America/Miquelon", [
		["2038-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2038-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2038-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2038-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2039" : helpers.makeTestYear("America/Miquelon", [
		["2039-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2039-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2039-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2039-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2040" : helpers.makeTestYear("America/Miquelon", [
		["2040-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2040-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2040-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2040-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2041" : helpers.makeTestYear("America/Miquelon", [
		["2041-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2041-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2041-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2041-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2042" : helpers.makeTestYear("America/Miquelon", [
		["2042-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2042-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2042-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2042-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2043" : helpers.makeTestYear("America/Miquelon", [
		["2043-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2043-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2043-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2043-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2044" : helpers.makeTestYear("America/Miquelon", [
		["2044-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2044-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2044-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2044-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2045" : helpers.makeTestYear("America/Miquelon", [
		["2045-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2045-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2045-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2045-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2046" : helpers.makeTestYear("America/Miquelon", [
		["2046-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2046-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2046-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2046-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2047" : helpers.makeTestYear("America/Miquelon", [
		["2047-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2047-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2047-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2047-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2048" : helpers.makeTestYear("America/Miquelon", [
		["2048-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2048-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2048-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2048-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2049" : helpers.makeTestYear("America/Miquelon", [
		["2049-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2049-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2049-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2049-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2050" : helpers.makeTestYear("America/Miquelon", [
		["2050-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2050-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2050-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2050-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2051" : helpers.makeTestYear("America/Miquelon", [
		["2051-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2051-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2051-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2051-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2052" : helpers.makeTestYear("America/Miquelon", [
		["2052-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2052-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2052-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2052-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2053" : helpers.makeTestYear("America/Miquelon", [
		["2053-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2053-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2053-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2053-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2054" : helpers.makeTestYear("America/Miquelon", [
		["2054-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2054-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2054-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2054-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2055" : helpers.makeTestYear("America/Miquelon", [
		["2055-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2055-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2055-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2055-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2056" : helpers.makeTestYear("America/Miquelon", [
		["2056-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2056-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2056-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2056-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2057" : helpers.makeTestYear("America/Miquelon", [
		["2057-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2057-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2057-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2057-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2058" : helpers.makeTestYear("America/Miquelon", [
		["2058-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2058-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2058-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2058-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2059" : helpers.makeTestYear("America/Miquelon", [
		["2059-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2059-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2059-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2059-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2060" : helpers.makeTestYear("America/Miquelon", [
		["2060-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2060-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2060-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2060-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2061" : helpers.makeTestYear("America/Miquelon", [
		["2061-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2061-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2061-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2061-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2062" : helpers.makeTestYear("America/Miquelon", [
		["2062-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2062-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2062-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2062-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2063" : helpers.makeTestYear("America/Miquelon", [
		["2063-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2063-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2063-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2063-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2064" : helpers.makeTestYear("America/Miquelon", [
		["2064-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2064-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2064-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2064-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2065" : helpers.makeTestYear("America/Miquelon", [
		["2065-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2065-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2065-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2065-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2066" : helpers.makeTestYear("America/Miquelon", [
		["2066-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2066-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2066-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2066-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2067" : helpers.makeTestYear("America/Miquelon", [
		["2067-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2067-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2067-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2067-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2068" : helpers.makeTestYear("America/Miquelon", [
		["2068-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2068-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2068-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2068-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2069" : helpers.makeTestYear("America/Miquelon", [
		["2069-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2069-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2069-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2069-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2070" : helpers.makeTestYear("America/Miquelon", [
		["2070-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2070-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2070-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2070-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2071" : helpers.makeTestYear("America/Miquelon", [
		["2071-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2071-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2071-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2071-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2072" : helpers.makeTestYear("America/Miquelon", [
		["2072-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2072-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2072-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2072-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2073" : helpers.makeTestYear("America/Miquelon", [
		["2073-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2073-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2073-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2073-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2074" : helpers.makeTestYear("America/Miquelon", [
		["2074-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2074-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2074-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2074-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2075" : helpers.makeTestYear("America/Miquelon", [
		["2075-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2075-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2075-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2075-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2076" : helpers.makeTestYear("America/Miquelon", [
		["2076-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2076-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2076-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2076-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2077" : helpers.makeTestYear("America/Miquelon", [
		["2077-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2077-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2077-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2077-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2078" : helpers.makeTestYear("America/Miquelon", [
		["2078-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2078-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2078-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2078-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2079" : helpers.makeTestYear("America/Miquelon", [
		["2079-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2079-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2079-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2079-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2080" : helpers.makeTestYear("America/Miquelon", [
		["2080-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2080-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2080-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2080-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2081" : helpers.makeTestYear("America/Miquelon", [
		["2081-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2081-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2081-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2081-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2082" : helpers.makeTestYear("America/Miquelon", [
		["2082-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2082-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2082-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2082-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2083" : helpers.makeTestYear("America/Miquelon", [
		["2083-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2083-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2083-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2083-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2084" : helpers.makeTestYear("America/Miquelon", [
		["2084-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2084-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2084-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2084-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2085" : helpers.makeTestYear("America/Miquelon", [
		["2085-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2085-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2085-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2085-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2086" : helpers.makeTestYear("America/Miquelon", [
		["2086-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2086-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2086-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2086-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2087" : helpers.makeTestYear("America/Miquelon", [
		["2087-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2087-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2087-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2087-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2088" : helpers.makeTestYear("America/Miquelon", [
		["2088-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2088-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2088-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2088-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2089" : helpers.makeTestYear("America/Miquelon", [
		["2089-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2089-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2089-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2089-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2090" : helpers.makeTestYear("America/Miquelon", [
		["2090-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2090-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2090-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2090-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2091" : helpers.makeTestYear("America/Miquelon", [
		["2091-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2091-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2091-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2091-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2092" : helpers.makeTestYear("America/Miquelon", [
		["2092-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2092-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2092-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2092-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2093" : helpers.makeTestYear("America/Miquelon", [
		["2093-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2093-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2093-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2093-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2094" : helpers.makeTestYear("America/Miquelon", [
		["2094-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2094-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2094-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2094-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2095" : helpers.makeTestYear("America/Miquelon", [
		["2095-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2095-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2095-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2095-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2096" : helpers.makeTestYear("America/Miquelon", [
		["2096-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2096-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2096-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2096-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2097" : helpers.makeTestYear("America/Miquelon", [
		["2097-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2097-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2097-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2097-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2098" : helpers.makeTestYear("America/Miquelon", [
		["2098-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2098-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2098-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2098-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2099" : helpers.makeTestYear("America/Miquelon", [
		["2099-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2099-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2099-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2099-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2100" : helpers.makeTestYear("America/Miquelon", [
		["2100-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2100-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2100-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2100-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2101" : helpers.makeTestYear("America/Miquelon", [
		["2101-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2101-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2101-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2101-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2102" : helpers.makeTestYear("America/Miquelon", [
		["2102-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2102-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2102-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2102-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2103" : helpers.makeTestYear("America/Miquelon", [
		["2103-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2103-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2103-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2103-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2104" : helpers.makeTestYear("America/Miquelon", [
		["2104-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2104-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2104-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2104-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2105" : helpers.makeTestYear("America/Miquelon", [
		["2105-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2105-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2105-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2105-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2106" : helpers.makeTestYear("America/Miquelon", [
		["2106-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2106-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2106-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2106-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2107" : helpers.makeTestYear("America/Miquelon", [
		["2107-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2107-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2107-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2107-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2108" : helpers.makeTestYear("America/Miquelon", [
		["2108-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2108-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2108-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2108-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2109" : helpers.makeTestYear("America/Miquelon", [
		["2109-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2109-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2109-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2109-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2110" : helpers.makeTestYear("America/Miquelon", [
		["2110-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2110-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2110-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2110-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2111" : helpers.makeTestYear("America/Miquelon", [
		["2111-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2111-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2111-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2111-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2112" : helpers.makeTestYear("America/Miquelon", [
		["2112-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2112-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2112-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2112-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2113" : helpers.makeTestYear("America/Miquelon", [
		["2113-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2113-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2113-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2113-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2114" : helpers.makeTestYear("America/Miquelon", [
		["2114-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2114-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2114-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2114-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2115" : helpers.makeTestYear("America/Miquelon", [
		["2115-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2115-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2115-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2115-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2116" : helpers.makeTestYear("America/Miquelon", [
		["2116-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2116-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2116-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2116-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2117" : helpers.makeTestYear("America/Miquelon", [
		["2117-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2117-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2117-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2117-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2118" : helpers.makeTestYear("America/Miquelon", [
		["2118-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2118-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2118-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2118-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2119" : helpers.makeTestYear("America/Miquelon", [
		["2119-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2119-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2119-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2119-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2120" : helpers.makeTestYear("America/Miquelon", [
		["2120-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2120-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2120-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2120-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2121" : helpers.makeTestYear("America/Miquelon", [
		["2121-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2121-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2121-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2121-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2122" : helpers.makeTestYear("America/Miquelon", [
		["2122-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2122-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2122-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2122-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2123" : helpers.makeTestYear("America/Miquelon", [
		["2123-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2123-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2123-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2123-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2124" : helpers.makeTestYear("America/Miquelon", [
		["2124-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2124-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2124-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2124-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2125" : helpers.makeTestYear("America/Miquelon", [
		["2125-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2125-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2125-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2125-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2126" : helpers.makeTestYear("America/Miquelon", [
		["2126-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2126-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2126-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2126-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2127" : helpers.makeTestYear("America/Miquelon", [
		["2127-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2127-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2127-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2127-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2128" : helpers.makeTestYear("America/Miquelon", [
		["2128-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2128-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2128-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2128-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2129" : helpers.makeTestYear("America/Miquelon", [
		["2129-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2129-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2129-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2129-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2130" : helpers.makeTestYear("America/Miquelon", [
		["2130-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2130-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2130-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2130-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2131" : helpers.makeTestYear("America/Miquelon", [
		["2131-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2131-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2131-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2131-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2132" : helpers.makeTestYear("America/Miquelon", [
		["2132-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2132-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2132-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2132-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2133" : helpers.makeTestYear("America/Miquelon", [
		["2133-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2133-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2133-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2133-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2134" : helpers.makeTestYear("America/Miquelon", [
		["2134-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2134-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2134-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2134-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2135" : helpers.makeTestYear("America/Miquelon", [
		["2135-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2135-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2135-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2135-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2136" : helpers.makeTestYear("America/Miquelon", [
		["2136-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2136-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2136-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2136-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2137" : helpers.makeTestYear("America/Miquelon", [
		["2137-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2137-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2137-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2137-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2138" : helpers.makeTestYear("America/Miquelon", [
		["2138-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2138-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2138-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2138-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2139" : helpers.makeTestYear("America/Miquelon", [
		["2139-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2139-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2139-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2139-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2140" : helpers.makeTestYear("America/Miquelon", [
		["2140-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2140-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2140-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2140-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2141" : helpers.makeTestYear("America/Miquelon", [
		["2141-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2141-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2141-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2141-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2142" : helpers.makeTestYear("America/Miquelon", [
		["2142-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2142-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2142-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2142-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2143" : helpers.makeTestYear("America/Miquelon", [
		["2143-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2143-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2143-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2143-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2144" : helpers.makeTestYear("America/Miquelon", [
		["2144-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2144-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2144-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2144-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2145" : helpers.makeTestYear("America/Miquelon", [
		["2145-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2145-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2145-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2145-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2146" : helpers.makeTestYear("America/Miquelon", [
		["2146-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2146-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2146-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2146-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2147" : helpers.makeTestYear("America/Miquelon", [
		["2147-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2147-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2147-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2147-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2148" : helpers.makeTestYear("America/Miquelon", [
		["2148-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2148-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2148-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2148-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2149" : helpers.makeTestYear("America/Miquelon", [
		["2149-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2149-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2149-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2149-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2150" : helpers.makeTestYear("America/Miquelon", [
		["2150-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2150-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2150-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2150-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2151" : helpers.makeTestYear("America/Miquelon", [
		["2151-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2151-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2151-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2151-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2152" : helpers.makeTestYear("America/Miquelon", [
		["2152-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2152-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2152-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2152-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2153" : helpers.makeTestYear("America/Miquelon", [
		["2153-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2153-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2153-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2153-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2154" : helpers.makeTestYear("America/Miquelon", [
		["2154-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2154-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2154-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2154-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2155" : helpers.makeTestYear("America/Miquelon", [
		["2155-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2155-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2155-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2155-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2156" : helpers.makeTestYear("America/Miquelon", [
		["2156-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2156-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2156-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2156-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2157" : helpers.makeTestYear("America/Miquelon", [
		["2157-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2157-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2157-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2157-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2158" : helpers.makeTestYear("America/Miquelon", [
		["2158-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2158-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2158-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2158-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2159" : helpers.makeTestYear("America/Miquelon", [
		["2159-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2159-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2159-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2159-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2160" : helpers.makeTestYear("America/Miquelon", [
		["2160-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2160-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2160-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2160-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2161" : helpers.makeTestYear("America/Miquelon", [
		["2161-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2161-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2161-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2161-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2162" : helpers.makeTestYear("America/Miquelon", [
		["2162-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2162-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2162-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2162-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2163" : helpers.makeTestYear("America/Miquelon", [
		["2163-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2163-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2163-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2163-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2164" : helpers.makeTestYear("America/Miquelon", [
		["2164-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2164-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2164-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2164-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2165" : helpers.makeTestYear("America/Miquelon", [
		["2165-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2165-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2165-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2165-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2166" : helpers.makeTestYear("America/Miquelon", [
		["2166-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2166-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2166-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2166-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2167" : helpers.makeTestYear("America/Miquelon", [
		["2167-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2167-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2167-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2167-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2168" : helpers.makeTestYear("America/Miquelon", [
		["2168-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2168-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2168-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2168-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2169" : helpers.makeTestYear("America/Miquelon", [
		["2169-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2169-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2169-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2169-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2170" : helpers.makeTestYear("America/Miquelon", [
		["2170-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2170-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2170-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2170-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2171" : helpers.makeTestYear("America/Miquelon", [
		["2171-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2171-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2171-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2171-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2172" : helpers.makeTestYear("America/Miquelon", [
		["2172-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2172-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2172-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2172-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2173" : helpers.makeTestYear("America/Miquelon", [
		["2173-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2173-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2173-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2173-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2174" : helpers.makeTestYear("America/Miquelon", [
		["2174-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2174-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2174-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2174-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2175" : helpers.makeTestYear("America/Miquelon", [
		["2175-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2175-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2175-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2175-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2176" : helpers.makeTestYear("America/Miquelon", [
		["2176-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2176-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2176-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2176-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2177" : helpers.makeTestYear("America/Miquelon", [
		["2177-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2177-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2177-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2177-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2178" : helpers.makeTestYear("America/Miquelon", [
		["2178-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2178-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2178-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2178-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2179" : helpers.makeTestYear("America/Miquelon", [
		["2179-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2179-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2179-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2179-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2180" : helpers.makeTestYear("America/Miquelon", [
		["2180-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2180-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2180-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2180-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2181" : helpers.makeTestYear("America/Miquelon", [
		["2181-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2181-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2181-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2181-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2182" : helpers.makeTestYear("America/Miquelon", [
		["2182-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2182-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2182-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2182-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2183" : helpers.makeTestYear("America/Miquelon", [
		["2183-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2183-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2183-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2183-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2184" : helpers.makeTestYear("America/Miquelon", [
		["2184-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2184-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2184-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2184-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2185" : helpers.makeTestYear("America/Miquelon", [
		["2185-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2185-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2185-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2185-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2186" : helpers.makeTestYear("America/Miquelon", [
		["2186-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2186-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2186-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2186-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2187" : helpers.makeTestYear("America/Miquelon", [
		["2187-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2187-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2187-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2187-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2188" : helpers.makeTestYear("America/Miquelon", [
		["2188-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2188-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2188-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2188-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2189" : helpers.makeTestYear("America/Miquelon", [
		["2189-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2189-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2189-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2189-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2190" : helpers.makeTestYear("America/Miquelon", [
		["2190-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2190-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2190-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2190-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2191" : helpers.makeTestYear("America/Miquelon", [
		["2191-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2191-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2191-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2191-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2192" : helpers.makeTestYear("America/Miquelon", [
		["2192-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2192-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2192-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2192-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2193" : helpers.makeTestYear("America/Miquelon", [
		["2193-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2193-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2193-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2193-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2194" : helpers.makeTestYear("America/Miquelon", [
		["2194-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2194-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2194-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2194-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2195" : helpers.makeTestYear("America/Miquelon", [
		["2195-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2195-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2195-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2195-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2196" : helpers.makeTestYear("America/Miquelon", [
		["2196-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2196-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2196-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2196-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2197" : helpers.makeTestYear("America/Miquelon", [
		["2197-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2197-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2197-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2197-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2198" : helpers.makeTestYear("America/Miquelon", [
		["2198-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2198-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2198-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2198-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2199" : helpers.makeTestYear("America/Miquelon", [
		["2199-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2199-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2199-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2199-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2200" : helpers.makeTestYear("America/Miquelon", [
		["2200-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2200-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2200-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2200-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2201" : helpers.makeTestYear("America/Miquelon", [
		["2201-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2201-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2201-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2201-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2202" : helpers.makeTestYear("America/Miquelon", [
		["2202-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2202-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2202-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2202-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2203" : helpers.makeTestYear("America/Miquelon", [
		["2203-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2203-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2203-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2203-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2204" : helpers.makeTestYear("America/Miquelon", [
		["2204-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2204-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2204-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2204-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2205" : helpers.makeTestYear("America/Miquelon", [
		["2205-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2205-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2205-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2205-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2206" : helpers.makeTestYear("America/Miquelon", [
		["2206-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2206-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2206-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2206-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2207" : helpers.makeTestYear("America/Miquelon", [
		["2207-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2207-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2207-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2207-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2208" : helpers.makeTestYear("America/Miquelon", [
		["2208-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2208-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2208-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2208-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2209" : helpers.makeTestYear("America/Miquelon", [
		["2209-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2209-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2209-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2209-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2210" : helpers.makeTestYear("America/Miquelon", [
		["2210-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2210-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2210-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2210-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2211" : helpers.makeTestYear("America/Miquelon", [
		["2211-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2211-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2211-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2211-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2212" : helpers.makeTestYear("America/Miquelon", [
		["2212-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2212-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2212-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2212-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2213" : helpers.makeTestYear("America/Miquelon", [
		["2213-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2213-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2213-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2213-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2214" : helpers.makeTestYear("America/Miquelon", [
		["2214-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2214-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2214-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2214-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2215" : helpers.makeTestYear("America/Miquelon", [
		["2215-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2215-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2215-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2215-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2216" : helpers.makeTestYear("America/Miquelon", [
		["2216-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2216-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2216-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2216-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2217" : helpers.makeTestYear("America/Miquelon", [
		["2217-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2217-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2217-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2217-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2218" : helpers.makeTestYear("America/Miquelon", [
		["2218-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2218-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2218-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2218-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2219" : helpers.makeTestYear("America/Miquelon", [
		["2219-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2219-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2219-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2219-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2220" : helpers.makeTestYear("America/Miquelon", [
		["2220-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2220-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2220-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2220-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2221" : helpers.makeTestYear("America/Miquelon", [
		["2221-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2221-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2221-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2221-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2222" : helpers.makeTestYear("America/Miquelon", [
		["2222-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2222-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2222-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2222-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2223" : helpers.makeTestYear("America/Miquelon", [
		["2223-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2223-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2223-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2223-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2224" : helpers.makeTestYear("America/Miquelon", [
		["2224-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2224-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2224-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2224-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2225" : helpers.makeTestYear("America/Miquelon", [
		["2225-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2225-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2225-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2225-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2226" : helpers.makeTestYear("America/Miquelon", [
		["2226-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2226-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2226-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2226-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2227" : helpers.makeTestYear("America/Miquelon", [
		["2227-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2227-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2227-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2227-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2228" : helpers.makeTestYear("America/Miquelon", [
		["2228-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2228-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2228-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2228-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2229" : helpers.makeTestYear("America/Miquelon", [
		["2229-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2229-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2229-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2229-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2230" : helpers.makeTestYear("America/Miquelon", [
		["2230-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2230-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2230-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2230-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2231" : helpers.makeTestYear("America/Miquelon", [
		["2231-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2231-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2231-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2231-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2232" : helpers.makeTestYear("America/Miquelon", [
		["2232-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2232-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2232-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2232-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2233" : helpers.makeTestYear("America/Miquelon", [
		["2233-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2233-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2233-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2233-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2234" : helpers.makeTestYear("America/Miquelon", [
		["2234-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2234-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2234-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2234-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2235" : helpers.makeTestYear("America/Miquelon", [
		["2235-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2235-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2235-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2235-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2236" : helpers.makeTestYear("America/Miquelon", [
		["2236-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2236-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2236-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2236-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2237" : helpers.makeTestYear("America/Miquelon", [
		["2237-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2237-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2237-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2237-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2238" : helpers.makeTestYear("America/Miquelon", [
		["2238-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2238-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2238-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2238-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2239" : helpers.makeTestYear("America/Miquelon", [
		["2239-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2239-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2239-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2239-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2240" : helpers.makeTestYear("America/Miquelon", [
		["2240-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2240-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2240-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2240-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2241" : helpers.makeTestYear("America/Miquelon", [
		["2241-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2241-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2241-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2241-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2242" : helpers.makeTestYear("America/Miquelon", [
		["2242-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2242-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2242-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2242-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2243" : helpers.makeTestYear("America/Miquelon", [
		["2243-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2243-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2243-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2243-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2244" : helpers.makeTestYear("America/Miquelon", [
		["2244-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2244-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2244-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2244-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2245" : helpers.makeTestYear("America/Miquelon", [
		["2245-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2245-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2245-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2245-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2246" : helpers.makeTestYear("America/Miquelon", [
		["2246-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2246-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2246-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2246-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2247" : helpers.makeTestYear("America/Miquelon", [
		["2247-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2247-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2247-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2247-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2248" : helpers.makeTestYear("America/Miquelon", [
		["2248-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2248-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2248-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2248-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2249" : helpers.makeTestYear("America/Miquelon", [
		["2249-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2249-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2249-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2249-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2250" : helpers.makeTestYear("America/Miquelon", [
		["2250-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2250-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2250-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2250-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2251" : helpers.makeTestYear("America/Miquelon", [
		["2251-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2251-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2251-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2251-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2252" : helpers.makeTestYear("America/Miquelon", [
		["2252-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2252-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2252-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2252-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2253" : helpers.makeTestYear("America/Miquelon", [
		["2253-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2253-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2253-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2253-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2254" : helpers.makeTestYear("America/Miquelon", [
		["2254-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2254-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2254-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2254-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2255" : helpers.makeTestYear("America/Miquelon", [
		["2255-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2255-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2255-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2255-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2256" : helpers.makeTestYear("America/Miquelon", [
		["2256-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2256-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2256-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2256-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2257" : helpers.makeTestYear("America/Miquelon", [
		["2257-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2257-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2257-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2257-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2258" : helpers.makeTestYear("America/Miquelon", [
		["2258-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2258-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2258-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2258-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2259" : helpers.makeTestYear("America/Miquelon", [
		["2259-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2259-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2259-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2259-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2260" : helpers.makeTestYear("America/Miquelon", [
		["2260-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2260-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2260-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2260-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2261" : helpers.makeTestYear("America/Miquelon", [
		["2261-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2261-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2261-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2261-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2262" : helpers.makeTestYear("America/Miquelon", [
		["2262-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2262-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2262-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2262-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2263" : helpers.makeTestYear("America/Miquelon", [
		["2263-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2263-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2263-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2263-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2264" : helpers.makeTestYear("America/Miquelon", [
		["2264-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2264-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2264-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2264-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2265" : helpers.makeTestYear("America/Miquelon", [
		["2265-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2265-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2265-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2265-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2266" : helpers.makeTestYear("America/Miquelon", [
		["2266-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2266-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2266-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2266-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2267" : helpers.makeTestYear("America/Miquelon", [
		["2267-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2267-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2267-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2267-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2268" : helpers.makeTestYear("America/Miquelon", [
		["2268-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2268-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2268-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2268-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2269" : helpers.makeTestYear("America/Miquelon", [
		["2269-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2269-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2269-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2269-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2270" : helpers.makeTestYear("America/Miquelon", [
		["2270-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2270-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2270-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2270-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2271" : helpers.makeTestYear("America/Miquelon", [
		["2271-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2271-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2271-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2271-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2272" : helpers.makeTestYear("America/Miquelon", [
		["2272-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2272-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2272-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2272-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2273" : helpers.makeTestYear("America/Miquelon", [
		["2273-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2273-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2273-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2273-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2274" : helpers.makeTestYear("America/Miquelon", [
		["2274-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2274-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2274-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2274-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2275" : helpers.makeTestYear("America/Miquelon", [
		["2275-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2275-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2275-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2275-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2276" : helpers.makeTestYear("America/Miquelon", [
		["2276-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2276-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2276-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2276-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2277" : helpers.makeTestYear("America/Miquelon", [
		["2277-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2277-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2277-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2277-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2278" : helpers.makeTestYear("America/Miquelon", [
		["2278-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2278-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2278-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2278-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2279" : helpers.makeTestYear("America/Miquelon", [
		["2279-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2279-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2279-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2279-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2280" : helpers.makeTestYear("America/Miquelon", [
		["2280-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2280-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2280-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2280-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2281" : helpers.makeTestYear("America/Miquelon", [
		["2281-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2281-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2281-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2281-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2282" : helpers.makeTestYear("America/Miquelon", [
		["2282-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2282-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2282-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2282-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2283" : helpers.makeTestYear("America/Miquelon", [
		["2283-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2283-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2283-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2283-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2284" : helpers.makeTestYear("America/Miquelon", [
		["2284-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2284-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2284-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2284-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2285" : helpers.makeTestYear("America/Miquelon", [
		["2285-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2285-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2285-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2285-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2286" : helpers.makeTestYear("America/Miquelon", [
		["2286-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2286-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2286-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2286-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2287" : helpers.makeTestYear("America/Miquelon", [
		["2287-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2287-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2287-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2287-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2288" : helpers.makeTestYear("America/Miquelon", [
		["2288-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2288-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2288-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2288-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2289" : helpers.makeTestYear("America/Miquelon", [
		["2289-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2289-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2289-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2289-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2290" : helpers.makeTestYear("America/Miquelon", [
		["2290-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2290-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2290-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2290-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2291" : helpers.makeTestYear("America/Miquelon", [
		["2291-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2291-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2291-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2291-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2292" : helpers.makeTestYear("America/Miquelon", [
		["2292-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2292-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2292-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2292-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2293" : helpers.makeTestYear("America/Miquelon", [
		["2293-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2293-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2293-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2293-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2294" : helpers.makeTestYear("America/Miquelon", [
		["2294-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2294-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2294-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2294-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2295" : helpers.makeTestYear("America/Miquelon", [
		["2295-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2295-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2295-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2295-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2296" : helpers.makeTestYear("America/Miquelon", [
		["2296-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2296-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2296-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2296-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2297" : helpers.makeTestYear("America/Miquelon", [
		["2297-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2297-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2297-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2297-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2298" : helpers.makeTestYear("America/Miquelon", [
		["2298-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2298-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2298-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2298-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2299" : helpers.makeTestYear("America/Miquelon", [
		["2299-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2299-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2299-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2299-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2300" : helpers.makeTestYear("America/Miquelon", [
		["2300-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2300-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2300-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2300-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2301" : helpers.makeTestYear("America/Miquelon", [
		["2301-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2301-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2301-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2301-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2302" : helpers.makeTestYear("America/Miquelon", [
		["2302-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2302-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2302-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2302-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2303" : helpers.makeTestYear("America/Miquelon", [
		["2303-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2303-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2303-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2303-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2304" : helpers.makeTestYear("America/Miquelon", [
		["2304-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2304-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2304-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2304-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2305" : helpers.makeTestYear("America/Miquelon", [
		["2305-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2305-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2305-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2305-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2306" : helpers.makeTestYear("America/Miquelon", [
		["2306-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2306-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2306-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2306-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2307" : helpers.makeTestYear("America/Miquelon", [
		["2307-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2307-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2307-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2307-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2308" : helpers.makeTestYear("America/Miquelon", [
		["2308-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2308-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2308-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2308-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2309" : helpers.makeTestYear("America/Miquelon", [
		["2309-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2309-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2309-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2309-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2310" : helpers.makeTestYear("America/Miquelon", [
		["2310-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2310-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2310-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2310-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2311" : helpers.makeTestYear("America/Miquelon", [
		["2311-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2311-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2311-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2311-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2312" : helpers.makeTestYear("America/Miquelon", [
		["2312-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2312-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2312-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2312-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2313" : helpers.makeTestYear("America/Miquelon", [
		["2313-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2313-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2313-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2313-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2314" : helpers.makeTestYear("America/Miquelon", [
		["2314-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2314-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2314-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2314-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2315" : helpers.makeTestYear("America/Miquelon", [
		["2315-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2315-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2315-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2315-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2316" : helpers.makeTestYear("America/Miquelon", [
		["2316-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2316-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2316-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2316-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2317" : helpers.makeTestYear("America/Miquelon", [
		["2317-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2317-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2317-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2317-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2318" : helpers.makeTestYear("America/Miquelon", [
		["2318-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2318-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2318-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2318-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2319" : helpers.makeTestYear("America/Miquelon", [
		["2319-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2319-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2319-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2319-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2320" : helpers.makeTestYear("America/Miquelon", [
		["2320-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2320-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2320-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2320-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2321" : helpers.makeTestYear("America/Miquelon", [
		["2321-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2321-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2321-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2321-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2322" : helpers.makeTestYear("America/Miquelon", [
		["2322-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2322-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2322-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2322-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2323" : helpers.makeTestYear("America/Miquelon", [
		["2323-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2323-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2323-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2323-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2324" : helpers.makeTestYear("America/Miquelon", [
		["2324-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2324-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2324-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2324-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2325" : helpers.makeTestYear("America/Miquelon", [
		["2325-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2325-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2325-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2325-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2326" : helpers.makeTestYear("America/Miquelon", [
		["2326-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2326-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2326-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2326-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2327" : helpers.makeTestYear("America/Miquelon", [
		["2327-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2327-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2327-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2327-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2328" : helpers.makeTestYear("America/Miquelon", [
		["2328-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2328-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2328-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2328-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2329" : helpers.makeTestYear("America/Miquelon", [
		["2329-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2329-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2329-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2329-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2330" : helpers.makeTestYear("America/Miquelon", [
		["2330-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2330-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2330-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2330-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2331" : helpers.makeTestYear("America/Miquelon", [
		["2331-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2331-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2331-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2331-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2332" : helpers.makeTestYear("America/Miquelon", [
		["2332-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2332-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2332-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2332-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2333" : helpers.makeTestYear("America/Miquelon", [
		["2333-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2333-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2333-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2333-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2334" : helpers.makeTestYear("America/Miquelon", [
		["2334-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2334-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2334-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2334-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2335" : helpers.makeTestYear("America/Miquelon", [
		["2335-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2335-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2335-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2335-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2336" : helpers.makeTestYear("America/Miquelon", [
		["2336-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2336-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2336-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2336-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2337" : helpers.makeTestYear("America/Miquelon", [
		["2337-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2337-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2337-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2337-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2338" : helpers.makeTestYear("America/Miquelon", [
		["2338-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2338-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2338-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2338-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2339" : helpers.makeTestYear("America/Miquelon", [
		["2339-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2339-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2339-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2339-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2340" : helpers.makeTestYear("America/Miquelon", [
		["2340-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2340-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2340-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2340-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2341" : helpers.makeTestYear("America/Miquelon", [
		["2341-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2341-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2341-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2341-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2342" : helpers.makeTestYear("America/Miquelon", [
		["2342-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2342-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2342-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2342-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2343" : helpers.makeTestYear("America/Miquelon", [
		["2343-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2343-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2343-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2343-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2344" : helpers.makeTestYear("America/Miquelon", [
		["2344-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2344-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2344-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2344-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2345" : helpers.makeTestYear("America/Miquelon", [
		["2345-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2345-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2345-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2345-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2346" : helpers.makeTestYear("America/Miquelon", [
		["2346-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2346-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2346-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2346-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2347" : helpers.makeTestYear("America/Miquelon", [
		["2347-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2347-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2347-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2347-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2348" : helpers.makeTestYear("America/Miquelon", [
		["2348-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2348-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2348-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2348-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2349" : helpers.makeTestYear("America/Miquelon", [
		["2349-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2349-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2349-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2349-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2350" : helpers.makeTestYear("America/Miquelon", [
		["2350-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2350-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2350-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2350-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2351" : helpers.makeTestYear("America/Miquelon", [
		["2351-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2351-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2351-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2351-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2352" : helpers.makeTestYear("America/Miquelon", [
		["2352-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2352-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2352-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2352-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2353" : helpers.makeTestYear("America/Miquelon", [
		["2353-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2353-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2353-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2353-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2354" : helpers.makeTestYear("America/Miquelon", [
		["2354-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2354-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2354-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2354-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2355" : helpers.makeTestYear("America/Miquelon", [
		["2355-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2355-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2355-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2355-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2356" : helpers.makeTestYear("America/Miquelon", [
		["2356-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2356-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2356-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2356-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2357" : helpers.makeTestYear("America/Miquelon", [
		["2357-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2357-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2357-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2357-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2358" : helpers.makeTestYear("America/Miquelon", [
		["2358-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2358-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2358-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2358-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2359" : helpers.makeTestYear("America/Miquelon", [
		["2359-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2359-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2359-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2359-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2360" : helpers.makeTestYear("America/Miquelon", [
		["2360-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2360-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2360-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2360-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2361" : helpers.makeTestYear("America/Miquelon", [
		["2361-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2361-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2361-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2361-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2362" : helpers.makeTestYear("America/Miquelon", [
		["2362-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2362-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2362-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2362-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2363" : helpers.makeTestYear("America/Miquelon", [
		["2363-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2363-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2363-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2363-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2364" : helpers.makeTestYear("America/Miquelon", [
		["2364-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2364-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2364-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2364-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2365" : helpers.makeTestYear("America/Miquelon", [
		["2365-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2365-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2365-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2365-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2366" : helpers.makeTestYear("America/Miquelon", [
		["2366-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2366-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2366-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2366-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2367" : helpers.makeTestYear("America/Miquelon", [
		["2367-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2367-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2367-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2367-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2368" : helpers.makeTestYear("America/Miquelon", [
		["2368-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2368-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2368-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2368-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2369" : helpers.makeTestYear("America/Miquelon", [
		["2369-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2369-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2369-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2369-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2370" : helpers.makeTestYear("America/Miquelon", [
		["2370-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2370-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2370-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2370-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2371" : helpers.makeTestYear("America/Miquelon", [
		["2371-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2371-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2371-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2371-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2372" : helpers.makeTestYear("America/Miquelon", [
		["2372-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2372-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2372-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2372-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2373" : helpers.makeTestYear("America/Miquelon", [
		["2373-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2373-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2373-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2373-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2374" : helpers.makeTestYear("America/Miquelon", [
		["2374-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2374-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2374-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2374-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2375" : helpers.makeTestYear("America/Miquelon", [
		["2375-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2375-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2375-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2375-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2376" : helpers.makeTestYear("America/Miquelon", [
		["2376-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2376-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2376-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2376-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2377" : helpers.makeTestYear("America/Miquelon", [
		["2377-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2377-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2377-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2377-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2378" : helpers.makeTestYear("America/Miquelon", [
		["2378-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2378-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2378-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2378-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2379" : helpers.makeTestYear("America/Miquelon", [
		["2379-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2379-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2379-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2379-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2380" : helpers.makeTestYear("America/Miquelon", [
		["2380-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2380-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2380-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2380-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2381" : helpers.makeTestYear("America/Miquelon", [
		["2381-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2381-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2381-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2381-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2382" : helpers.makeTestYear("America/Miquelon", [
		["2382-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2382-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2382-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2382-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2383" : helpers.makeTestYear("America/Miquelon", [
		["2383-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2383-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2383-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2383-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2384" : helpers.makeTestYear("America/Miquelon", [
		["2384-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2384-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2384-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2384-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2385" : helpers.makeTestYear("America/Miquelon", [
		["2385-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2385-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2385-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2385-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2386" : helpers.makeTestYear("America/Miquelon", [
		["2386-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2386-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2386-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2386-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2387" : helpers.makeTestYear("America/Miquelon", [
		["2387-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2387-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2387-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2387-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2388" : helpers.makeTestYear("America/Miquelon", [
		["2388-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2388-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2388-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2388-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2389" : helpers.makeTestYear("America/Miquelon", [
		["2389-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2389-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2389-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2389-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2390" : helpers.makeTestYear("America/Miquelon", [
		["2390-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2390-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2390-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2390-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2391" : helpers.makeTestYear("America/Miquelon", [
		["2391-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2391-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2391-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2391-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2392" : helpers.makeTestYear("America/Miquelon", [
		["2392-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2392-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2392-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2392-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2393" : helpers.makeTestYear("America/Miquelon", [
		["2393-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2393-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2393-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2393-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2394" : helpers.makeTestYear("America/Miquelon", [
		["2394-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2394-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2394-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2394-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2395" : helpers.makeTestYear("America/Miquelon", [
		["2395-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2395-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2395-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2395-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2396" : helpers.makeTestYear("America/Miquelon", [
		["2396-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2396-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2396-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2396-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2397" : helpers.makeTestYear("America/Miquelon", [
		["2397-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2397-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2397-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2397-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2398" : helpers.makeTestYear("America/Miquelon", [
		["2398-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2398-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2398-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2398-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2399" : helpers.makeTestYear("America/Miquelon", [
		["2399-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2399-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2399-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2399-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2400" : helpers.makeTestYear("America/Miquelon", [
		["2400-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2400-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2400-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2400-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2401" : helpers.makeTestYear("America/Miquelon", [
		["2401-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2401-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2401-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2401-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2402" : helpers.makeTestYear("America/Miquelon", [
		["2402-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2402-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2402-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2402-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2403" : helpers.makeTestYear("America/Miquelon", [
		["2403-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2403-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2403-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2403-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2404" : helpers.makeTestYear("America/Miquelon", [
		["2404-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2404-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2404-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2404-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2405" : helpers.makeTestYear("America/Miquelon", [
		["2405-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2405-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2405-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2405-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2406" : helpers.makeTestYear("America/Miquelon", [
		["2406-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2406-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2406-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2406-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2407" : helpers.makeTestYear("America/Miquelon", [
		["2407-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2407-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2407-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2407-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2408" : helpers.makeTestYear("America/Miquelon", [
		["2408-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2408-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2408-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2408-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2409" : helpers.makeTestYear("America/Miquelon", [
		["2409-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2409-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2409-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2409-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2410" : helpers.makeTestYear("America/Miquelon", [
		["2410-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2410-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2410-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2410-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2411" : helpers.makeTestYear("America/Miquelon", [
		["2411-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2411-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2411-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2411-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2412" : helpers.makeTestYear("America/Miquelon", [
		["2412-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2412-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2412-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2412-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2413" : helpers.makeTestYear("America/Miquelon", [
		["2413-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2413-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2413-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2413-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2414" : helpers.makeTestYear("America/Miquelon", [
		["2414-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2414-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2414-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2414-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2415" : helpers.makeTestYear("America/Miquelon", [
		["2415-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2415-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2415-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2415-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2416" : helpers.makeTestYear("America/Miquelon", [
		["2416-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2416-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2416-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2416-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2417" : helpers.makeTestYear("America/Miquelon", [
		["2417-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2417-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2417-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2417-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2418" : helpers.makeTestYear("America/Miquelon", [
		["2418-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2418-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2418-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2418-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2419" : helpers.makeTestYear("America/Miquelon", [
		["2419-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2419-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2419-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2419-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2420" : helpers.makeTestYear("America/Miquelon", [
		["2420-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2420-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2420-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2420-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2421" : helpers.makeTestYear("America/Miquelon", [
		["2421-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2421-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2421-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2421-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2422" : helpers.makeTestYear("America/Miquelon", [
		["2422-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2422-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2422-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2422-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2423" : helpers.makeTestYear("America/Miquelon", [
		["2423-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2423-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2423-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2423-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2424" : helpers.makeTestYear("America/Miquelon", [
		["2424-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2424-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2424-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2424-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2425" : helpers.makeTestYear("America/Miquelon", [
		["2425-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2425-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2425-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2425-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2426" : helpers.makeTestYear("America/Miquelon", [
		["2426-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2426-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2426-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2426-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2427" : helpers.makeTestYear("America/Miquelon", [
		["2427-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2427-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2427-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2427-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2428" : helpers.makeTestYear("America/Miquelon", [
		["2428-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2428-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2428-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2428-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2429" : helpers.makeTestYear("America/Miquelon", [
		["2429-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2429-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2429-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2429-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2430" : helpers.makeTestYear("America/Miquelon", [
		["2430-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2430-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2430-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2430-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2431" : helpers.makeTestYear("America/Miquelon", [
		["2431-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2431-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2431-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2431-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2432" : helpers.makeTestYear("America/Miquelon", [
		["2432-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2432-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2432-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2432-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2433" : helpers.makeTestYear("America/Miquelon", [
		["2433-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2433-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2433-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2433-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2434" : helpers.makeTestYear("America/Miquelon", [
		["2434-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2434-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2434-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2434-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2435" : helpers.makeTestYear("America/Miquelon", [
		["2435-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2435-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2435-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2435-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2436" : helpers.makeTestYear("America/Miquelon", [
		["2436-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2436-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2436-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2436-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2437" : helpers.makeTestYear("America/Miquelon", [
		["2437-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2437-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2437-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2437-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2438" : helpers.makeTestYear("America/Miquelon", [
		["2438-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2438-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2438-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2438-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2439" : helpers.makeTestYear("America/Miquelon", [
		["2439-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2439-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2439-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2439-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2440" : helpers.makeTestYear("America/Miquelon", [
		["2440-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2440-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2440-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2440-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2441" : helpers.makeTestYear("America/Miquelon", [
		["2441-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2441-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2441-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2441-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2442" : helpers.makeTestYear("America/Miquelon", [
		["2442-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2442-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2442-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2442-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2443" : helpers.makeTestYear("America/Miquelon", [
		["2443-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2443-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2443-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2443-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2444" : helpers.makeTestYear("America/Miquelon", [
		["2444-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2444-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2444-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2444-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2445" : helpers.makeTestYear("America/Miquelon", [
		["2445-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2445-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2445-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2445-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2446" : helpers.makeTestYear("America/Miquelon", [
		["2446-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2446-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2446-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2446-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2447" : helpers.makeTestYear("America/Miquelon", [
		["2447-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2447-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2447-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2447-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2448" : helpers.makeTestYear("America/Miquelon", [
		["2448-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2448-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2448-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2448-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2449" : helpers.makeTestYear("America/Miquelon", [
		["2449-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2449-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2449-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2449-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2450" : helpers.makeTestYear("America/Miquelon", [
		["2450-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2450-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2450-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2450-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2451" : helpers.makeTestYear("America/Miquelon", [
		["2451-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2451-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2451-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2451-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2452" : helpers.makeTestYear("America/Miquelon", [
		["2452-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2452-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2452-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2452-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2453" : helpers.makeTestYear("America/Miquelon", [
		["2453-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2453-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2453-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2453-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2454" : helpers.makeTestYear("America/Miquelon", [
		["2454-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2454-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2454-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2454-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2455" : helpers.makeTestYear("America/Miquelon", [
		["2455-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2455-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2455-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2455-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2456" : helpers.makeTestYear("America/Miquelon", [
		["2456-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2456-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2456-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2456-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2457" : helpers.makeTestYear("America/Miquelon", [
		["2457-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2457-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2457-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2457-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2458" : helpers.makeTestYear("America/Miquelon", [
		["2458-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2458-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2458-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2458-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2459" : helpers.makeTestYear("America/Miquelon", [
		["2459-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2459-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2459-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2459-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2460" : helpers.makeTestYear("America/Miquelon", [
		["2460-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2460-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2460-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2460-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2461" : helpers.makeTestYear("America/Miquelon", [
		["2461-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2461-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2461-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2461-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2462" : helpers.makeTestYear("America/Miquelon", [
		["2462-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2462-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2462-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2462-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2463" : helpers.makeTestYear("America/Miquelon", [
		["2463-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2463-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2463-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2463-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2464" : helpers.makeTestYear("America/Miquelon", [
		["2464-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2464-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2464-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2464-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2465" : helpers.makeTestYear("America/Miquelon", [
		["2465-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2465-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2465-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2465-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2466" : helpers.makeTestYear("America/Miquelon", [
		["2466-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2466-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2466-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2466-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2467" : helpers.makeTestYear("America/Miquelon", [
		["2467-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2467-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2467-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2467-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2468" : helpers.makeTestYear("America/Miquelon", [
		["2468-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2468-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2468-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2468-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2469" : helpers.makeTestYear("America/Miquelon", [
		["2469-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2469-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2469-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2469-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2470" : helpers.makeTestYear("America/Miquelon", [
		["2470-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2470-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2470-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2470-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2471" : helpers.makeTestYear("America/Miquelon", [
		["2471-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2471-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2471-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2471-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2472" : helpers.makeTestYear("America/Miquelon", [
		["2472-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2472-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2472-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2472-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2473" : helpers.makeTestYear("America/Miquelon", [
		["2473-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2473-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2473-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2473-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2474" : helpers.makeTestYear("America/Miquelon", [
		["2474-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2474-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2474-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2474-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2475" : helpers.makeTestYear("America/Miquelon", [
		["2475-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2475-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2475-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2475-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2476" : helpers.makeTestYear("America/Miquelon", [
		["2476-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2476-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2476-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2476-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2477" : helpers.makeTestYear("America/Miquelon", [
		["2477-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2477-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2477-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2477-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2478" : helpers.makeTestYear("America/Miquelon", [
		["2478-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2478-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2478-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2478-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2479" : helpers.makeTestYear("America/Miquelon", [
		["2479-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2479-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2479-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2479-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2480" : helpers.makeTestYear("America/Miquelon", [
		["2480-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2480-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2480-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2480-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2481" : helpers.makeTestYear("America/Miquelon", [
		["2481-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2481-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2481-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2481-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2482" : helpers.makeTestYear("America/Miquelon", [
		["2482-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2482-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2482-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2482-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2483" : helpers.makeTestYear("America/Miquelon", [
		["2483-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2483-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2483-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2483-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2484" : helpers.makeTestYear("America/Miquelon", [
		["2484-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2484-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2484-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2484-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2485" : helpers.makeTestYear("America/Miquelon", [
		["2485-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2485-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2485-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2485-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2486" : helpers.makeTestYear("America/Miquelon", [
		["2486-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2486-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2486-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2486-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2487" : helpers.makeTestYear("America/Miquelon", [
		["2487-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2487-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2487-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2487-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2488" : helpers.makeTestYear("America/Miquelon", [
		["2488-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2488-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2488-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2488-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2489" : helpers.makeTestYear("America/Miquelon", [
		["2489-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2489-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2489-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2489-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2490" : helpers.makeTestYear("America/Miquelon", [
		["2490-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2490-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2490-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2490-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2491" : helpers.makeTestYear("America/Miquelon", [
		["2491-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2491-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2491-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2491-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2492" : helpers.makeTestYear("America/Miquelon", [
		["2492-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2492-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2492-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2492-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2493" : helpers.makeTestYear("America/Miquelon", [
		["2493-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2493-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2493-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2493-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2494" : helpers.makeTestYear("America/Miquelon", [
		["2494-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2494-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2494-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2494-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2495" : helpers.makeTestYear("America/Miquelon", [
		["2495-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2495-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2495-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2495-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2496" : helpers.makeTestYear("America/Miquelon", [
		["2496-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2496-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2496-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2496-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2497" : helpers.makeTestYear("America/Miquelon", [
		["2497-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2497-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2497-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2497-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2498" : helpers.makeTestYear("America/Miquelon", [
		["2498-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2498-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2498-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2498-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2499" : helpers.makeTestYear("America/Miquelon", [
		["2499-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2499-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2499-11-01T03:59:59+00:00", "01:59:59", "-02", 120]
	])
};