/*
 * This file is part of the Ubuntu TV Media Scanner
 * Copyright (C) 2012-2013 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: Jim Hodapp <jim.hodapp@canonical.com>
 * Authored by: Mathias Hasselmann <mathias@openismus.com>
 */
#include "mediascanner/refreshpolicy.h"

// Boost C++
#include <boost/filesystem.hpp>

// Media Scanner Library
#include "mediascanner/logging.h"
#include "mediascanner/writablemediaindex.h"

namespace mediascanner {

static const logging::Domain kTrace("trace/refresh", logging::trace());

RefreshPolicy::~RefreshPolicy() {
}

RefreshPolicyPtr RefreshPolicy::default_policy() {
    static const RefreshPolicyPtr default_policy(new InstantRefreshPolicy);
    return default_policy;
}

bool InstantRefreshPolicy::OnBeginReading(MediaIndex *index) {
    if (index->is_current())
        return true;

    kTrace("Index is not up to date anymore. Reopening \"{1}\".")
            % index->path();

    return index->Reopen();
}

bool InstantRefreshPolicy::OnBeginWriting(WritableMediaIndex *index) {
    return OnBeginReading(index);
}

} // namespace mediascanner
