/***************************************************************************
 *   Copyright (C) 2006-2007 by Julien Lemoine, Simon Viennot              *
 *   lapinot@tuxfamily.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "widgetoperation.h"
#include "tirage.h"

#include <QtGui>

//valeurs conventionnelles pour identifier les 4 oprations
//les 4 valeurs doivent se suivre (pour les boucles)
const int WidgetOperation::Plus=1;
const int WidgetOperation::Moins=2;
const int WidgetOperation::Fois=3;
const int WidgetOperation::Divise=4;

//dfinition des pointeurs statiques vers les pixmap
QPixmap * WidgetOperation::pixPlus=0;
QPixmap * WidgetOperation::pixMoins=0;
QPixmap * WidgetOperation::pixFois=0;
QPixmap * WidgetOperation::pixDivise=0;
QPixmap * WidgetOperation::pixVide=0;

//Cration d'un widget avec un bouton d'opration
//numW : identifiant qui doit tre unique pour chaque plaque/opration
//opW : type d'opration (Plus, Moins, Fois, Divise)
//cliquableW : indique si la plaque d'opration est cliquable ou non
WidgetOperation::WidgetOperation( QWidget *parent, int numW, int opW, bool cliquableW)
        : QWidget( parent) {
	
	//init des pixmap si ncessaire(une seule fois)
	if(!pixPlus) {
		pixPlus   = new QPixmap( QString(":/images/grand_plus.png") );
	}
	if(!pixMoins) {
		pixMoins  = new QPixmap( QString(":/images/grand_moins.png") );
	}
	if(!pixFois) {
		pixFois   = new QPixmap( QString(":/images/grand_fois.png") );
	}
	if(!pixDivise) {
		pixDivise = new QPixmap( QString(":/images/grand_divise.png") );
	}
	if(!pixVide) {
		pixVide   = new QPixmap( QString("") );
	}
	
	//init du numro de widget
	//num est un identifiant unique qui doit tre diffrent pour chaque plaque
	num=numW;
	cliquable=cliquableW;
	
	QVBoxLayout *vboxLayout = new QVBoxLayout( this );
	vboxLayout->setSpacing(0);
	vboxLayout->setMargin(0);
	
	//on cre un pushbutton si le widget est cliquable, un label sinon
	if(cliquable){
		pbOperation = new QPushButton( "", this);
		pbOperation->setFlat( true );
		pbOperation->setFixedSize( 32, 32 );
		connect( pbOperation, SIGNAL(clicked()), this, SLOT(mousePressEvent()) );
		vboxLayout->addWidget( pbOperation );
	} else{
		lbOperation = new QLabel(this);
		lbOperation->setFixedSize( 32, 32 );
		lbOperation->setAlignment( Qt::AlignHCenter );
		vboxLayout->addWidget( lbOperation );
	}
	
	//affichage de l'image
	changeOperation(numW, opW);
}

//fonction appele ds qu'il y a un clic
void WidgetOperation::mousePressEvent() {
	emit valeur(num,500+op);
}

//met  jour l'image affiche par le widget
void WidgetOperation::changeOperation(int numW, int opW) {
	if(num!=numW) return;
	op=opW;
	QPixmap* pix=pixVide;
	
	if(op==Plus) {
		pix=pixPlus;
	} else
	if(op==Moins) {
		pix=pixMoins;
	} else
	if(op==Fois) {
		pix=pixFois;
	} else
	if(op==Divise) {
		pix=pixDivise;
	}
	
	if(cliquable){
		pbOperation->setIcon( *pix );
		pbOperation->setIconSize( QSize(28,28) );
	} else{
		lbOperation->setPixmap( *pix );
	}
}

//suppression des rfrences vers les pointeurs
//ATTENTION : cette fonction doit tre imprativement appele si on relance l'appli Qt
//(aprs un changement de langue par exemple)
void WidgetOperation::nettoyagePixmap() {
	pixPlus=0;
	pixMoins=0;
	pixFois=0;
	pixDivise=0;
	pixVide=0;
}
