//**************************************************************************************************
//                                         SimnGnuCap.hpp                                          *
//                                        ----------------                                         *
// Description : A class to contain the values required to define a GNU-Cap simulation.            *
// Started     : 2008-05-07                                                                        *
// Last Update : 2015-04-08                                                                        *
// Copyright   : (C) 2008 by MSWaters                                                              *
//**************************************************************************************************

//**************************************************************************************************
//                                                                                                 *
//      This program is free software; you can redistribute it and/or modify it under the          *
//      terms of the GNU General Public License as published by the Free Software Foundation;      *
//      either version 3 of the License, or (at your option) any later version.                    *
//                                                                                                 *
//**************************************************************************************************

#ifndef SIMNGNUCAP_HPP
#define SIMNGNUCAP_HPP

// Application Includes

#include "TypeDefs.hpp"
#include "base/SimnBase.hpp"
#include "gnucap/commands/CmdGnuCapOPT.hpp"
#include "gnucap/commands/CmdGnuCapOP.hpp"
#include "gnucap/commands/CmdGnuCapDC.hpp"
#include "gnucap/commands/CmdGnuCapAC.hpp"
#include "gnucap/commands/CmdGnuCapTR.hpp"
#include "gnucap/commands/CmdGnuCapFO.hpp"
#include "gnucap/commands/CmdGnuCapPR.hpp"
#include "gnucap/commands/CmdGnuCapGEN.hpp"
#include "netlist/SimnNgSpice.hpp"

class SimnNgSpice;

//**************************************************************************************************

class SimnGnuCap : public SimnBase
{
  public :

    CmdGnuCapOP   m_oCmdOP;
    CmdGnuCapDC   m_oCmdDC;
    CmdGnuCapAC   m_oCmdAC;
    CmdGnuCapTR   m_oCmdTR;
    CmdGnuCapFO   m_oCmdFO;

    CmdGnuCapOPT  m_oCmdOPT;
    CmdGnuCapPR   m_oCmdPR;
    CmdGnuCapGEN  m_oCmdGEN;

  private :

    // Function to extract information from the circuit description
    virtual  bool  bLoadSimEng ( void );
    virtual  bool  bLoadSimCmds( void );
    virtual  bool  bLoadSigSrc ( void );

  public :

                   SimnGnuCap( void );
                  ~SimnGnuCap( );

    virtual  bool  bClear     ( void );
    virtual  bool  bClrCmds   ( void );
    virtual  bool  bClrTstPts ( void );

    virtual  bool  bValidate  ( void );

    virtual  bool  bLoad      ( void );
    virtual  bool  bSave      ( void );

    virtual  bool  bSetAnaType( eTypeCmd eAnaType ) { return( m_oCmdPR.bSetAnaType( eAnaType ) ); }

    virtual  bool  bAddTstNode( const wxString & rosName );
    virtual  bool  bAddTstCpnt( const wxString & rosName );

    virtual        eTypeCmd           eGetAnaType ( void ) const { return( m_oCmdPR.eGetAnaType());}
    virtual  const wxArrayString & rosaGetTstNodes( void ) const { return( m_oCmdPR.m_osaNodes ); }
    virtual  const wxArrayString & rosaGetTstCpnts( void ) const { return( m_oCmdPR.m_osaCpnts ); }

    SimnGnuCap & operator = ( const SimnNgSpice & roSimn );

    virtual  void  Print( const wxString & rosPrefix=wxT("  ") );
};

//**************************************************************************************************

#endif // SIMNGNUCAP_HPP
