// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dynamodb

import (
	"fmt"
	"net/url"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/crr"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opBatchGetItem = "BatchGetItem"

// BatchGetItemRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetItem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetItem for more information on using the BatchGetItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetItemRequest method.
//    req, resp := client.BatchGetItemRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/BatchGetItem
func (c *DynamoDB) BatchGetItemRequest(input *BatchGetItemInput) (req *request.Request, output *BatchGetItemOutput) {
	op := &request.Operation{
		Name:       opBatchGetItem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"RequestItems"},
			OutputTokens:    []string{"UnprocessedKeys"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &BatchGetItemInput{}
	}

	output = &BatchGetItemOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// BatchGetItem API operation for Amazon DynamoDB.
//
// The BatchGetItem operation returns the attributes of one or more items from
// one or more tables. You identify requested items by primary key.
//
// A single operation can retrieve up to 16 MB of data, which can contain as
// many as 100 items. BatchGetItem returns a partial result if the response
// size limit is exceeded, the table's provisioned throughput is exceeded, or
// an internal processing failure occurs. If a partial result is returned, the
// operation returns a value for UnprocessedKeys. You can use this value to
// retry the operation starting with the next item to get.
//
// If you request more than 100 items, BatchGetItem returns a ValidationException
// with the message "Too many items requested for the BatchGetItem call."
//
// For example, if you ask to retrieve 100 items, but each individual item is
// 300 KB in size, the system returns 52 items (so as not to exceed the 16 MB
// limit). It also returns an appropriate UnprocessedKeys value so you can get
// the next page of results. If desired, your application can include its own
// logic to assemble the pages of results into one dataset.
//
// If none of the items can be processed due to insufficient provisioned throughput
// on all of the tables in the request, then BatchGetItem returns a ProvisionedThroughputExceededException.
// If at least one of the items is successfully processed, then BatchGetItem
// completes successfully, while returning the keys of the unread items in UnprocessedKeys.
//
// If DynamoDB returns any unprocessed items, you should retry the batch operation
// on those items. However, we strongly recommend that you use an exponential
// backoff algorithm. If you retry the batch operation immediately, the underlying
// read or write requests can still fail due to throttling on the individual
// tables. If you delay the batch operation using exponential backoff, the individual
// requests in the batch are much more likely to succeed.
//
// For more information, see Batch Operations and Error Handling (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ErrorHandling.html#BatchOperations)
// in the Amazon DynamoDB Developer Guide.
//
// By default, BatchGetItem performs eventually consistent reads on every table
// in the request. If you want strongly consistent reads instead, you can set
// ConsistentRead to true for any or all tables.
//
// In order to minimize response latency, BatchGetItem retrieves items in parallel.
//
// When designing your application, keep in mind that DynamoDB does not return
// items in any particular order. To help parse the response by item, include
// the primary key values for the items in your request in the ProjectionExpression
// parameter.
//
// If a requested item does not exist, it is not returned in the result. Requests
// for nonexistent items consume the minimum read capacity units according to
// the type of read. For more information, see Working with Tables (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#CapacityUnitCalculations)
// in the Amazon DynamoDB Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation BatchGetItem for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeProvisionedThroughputExceededException "ProvisionedThroughputExceededException"
//   Your request rate is too high. The AWS SDKs for DynamoDB automatically retry
//   requests that receive this exception. Your request is eventually successful,
//   unless your retry queue is too large to finish. Reduce the frequency of requests
//   and use exponential backoff. For more information, go to Error Retries and
//   Exponential Backoff (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff)
//   in the Amazon DynamoDB Developer Guide.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeRequestLimitExceeded "RequestLimitExceeded"
//   Throughput exceeds the current throughput limit for your account. Please
//   contact AWS Support at AWS Support (https://aws.amazon.com/support) to request
//   a limit increase.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/BatchGetItem
func (c *DynamoDB) BatchGetItem(input *BatchGetItemInput) (*BatchGetItemOutput, error) {
	req, out := c.BatchGetItemRequest(input)
	return out, req.Send()
}

// BatchGetItemWithContext is the same as BatchGetItem with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) BatchGetItemWithContext(ctx aws.Context, input *BatchGetItemInput, opts ...request.Option) (*BatchGetItemOutput, error) {
	req, out := c.BatchGetItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// BatchGetItemPages iterates over the pages of a BatchGetItem operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See BatchGetItem method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a BatchGetItem operation.
//    pageNum := 0
//    err := client.BatchGetItemPages(params,
//        func(page *dynamodb.BatchGetItemOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DynamoDB) BatchGetItemPages(input *BatchGetItemInput, fn func(*BatchGetItemOutput, bool) bool) error {
	return c.BatchGetItemPagesWithContext(aws.BackgroundContext(), input, fn)
}

// BatchGetItemPagesWithContext same as BatchGetItemPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) BatchGetItemPagesWithContext(ctx aws.Context, input *BatchGetItemInput, fn func(*BatchGetItemOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *BatchGetItemInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.BatchGetItemRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*BatchGetItemOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opBatchWriteItem = "BatchWriteItem"

// BatchWriteItemRequest generates a "aws/request.Request" representing the
// client's request for the BatchWriteItem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchWriteItem for more information on using the BatchWriteItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchWriteItemRequest method.
//    req, resp := client.BatchWriteItemRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/BatchWriteItem
func (c *DynamoDB) BatchWriteItemRequest(input *BatchWriteItemInput) (req *request.Request, output *BatchWriteItemOutput) {
	op := &request.Operation{
		Name:       opBatchWriteItem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchWriteItemInput{}
	}

	output = &BatchWriteItemOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// BatchWriteItem API operation for Amazon DynamoDB.
//
// The BatchWriteItem operation puts or deletes multiple items in one or more
// tables. A single call to BatchWriteItem can write up to 16 MB of data, which
// can comprise as many as 25 put or delete requests. Individual items to be
// written can be as large as 400 KB.
//
// BatchWriteItem cannot update items. To update items, use the UpdateItem action.
//
// The individual PutItem and DeleteItem operations specified in BatchWriteItem
// are atomic; however BatchWriteItem as a whole is not. If any requested operations
// fail because the table's provisioned throughput is exceeded or an internal
// processing failure occurs, the failed operations are returned in the UnprocessedItems
// response parameter. You can investigate and optionally resend the requests.
// Typically, you would call BatchWriteItem in a loop. Each iteration would
// check for unprocessed items and submit a new BatchWriteItem request with
// those unprocessed items until all items have been processed.
//
// If none of the items can be processed due to insufficient provisioned throughput
// on all of the tables in the request, then BatchWriteItem returns a ProvisionedThroughputExceededException.
//
// If DynamoDB returns any unprocessed items, you should retry the batch operation
// on those items. However, we strongly recommend that you use an exponential
// backoff algorithm. If you retry the batch operation immediately, the underlying
// read or write requests can still fail due to throttling on the individual
// tables. If you delay the batch operation using exponential backoff, the individual
// requests in the batch are much more likely to succeed.
//
// For more information, see Batch Operations and Error Handling (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ErrorHandling.html#Programming.Errors.BatchOperations)
// in the Amazon DynamoDB Developer Guide.
//
// With BatchWriteItem, you can efficiently write or delete large amounts of
// data, such as from Amazon EMR, or copy data from another database into DynamoDB.
// In order to improve performance with these large-scale operations, BatchWriteItem
// does not behave in the same way as individual PutItem and DeleteItem calls
// would. For example, you cannot specify conditions on individual put and delete
// requests, and BatchWriteItem does not return deleted items in the response.
//
// If you use a programming language that supports concurrency, you can use
// threads to write items in parallel. Your application must include the necessary
// logic to manage the threads. With languages that don't support threading,
// you must update or delete the specified items one at a time. In both situations,
// BatchWriteItem performs the specified put and delete operations in parallel,
// giving you the power of the thread pool approach without having to introduce
// complexity into your application.
//
// Parallel processing reduces latency, but each specified put and delete request
// consumes the same number of write capacity units whether it is processed
// in parallel or not. Delete operations on nonexistent items consume one write
// capacity unit.
//
// If one or more of the following is true, DynamoDB rejects the entire batch
// write operation:
//
//    * One or more tables specified in the BatchWriteItem request does not
//    exist.
//
//    * Primary key attributes specified on an item in the request do not match
//    those in the corresponding table's primary key schema.
//
//    * You try to perform multiple operations on the same item in the same
//    BatchWriteItem request. For example, you cannot put and delete the same
//    item in the same BatchWriteItem request.
//
//    * Your request contains at least two items with identical hash and range
//    keys (which essentially is two put operations).
//
//    * There are more than 25 requests in the batch.
//
//    * Any individual item in a batch exceeds 400 KB.
//
//    * The total request size exceeds 16 MB.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation BatchWriteItem for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeProvisionedThroughputExceededException "ProvisionedThroughputExceededException"
//   Your request rate is too high. The AWS SDKs for DynamoDB automatically retry
//   requests that receive this exception. Your request is eventually successful,
//   unless your retry queue is too large to finish. Reduce the frequency of requests
//   and use exponential backoff. For more information, go to Error Retries and
//   Exponential Backoff (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff)
//   in the Amazon DynamoDB Developer Guide.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeItemCollectionSizeLimitExceededException "ItemCollectionSizeLimitExceededException"
//   An item collection is too large. This exception is only returned for tables
//   that have one or more local secondary indexes.
//
//   * ErrCodeRequestLimitExceeded "RequestLimitExceeded"
//   Throughput exceeds the current throughput limit for your account. Please
//   contact AWS Support at AWS Support (https://aws.amazon.com/support) to request
//   a limit increase.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/BatchWriteItem
func (c *DynamoDB) BatchWriteItem(input *BatchWriteItemInput) (*BatchWriteItemOutput, error) {
	req, out := c.BatchWriteItemRequest(input)
	return out, req.Send()
}

// BatchWriteItemWithContext is the same as BatchWriteItem with the addition of
// the ability to pass a context and additional request options.
//
// See BatchWriteItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) BatchWriteItemWithContext(ctx aws.Context, input *BatchWriteItemInput, opts ...request.Option) (*BatchWriteItemOutput, error) {
	req, out := c.BatchWriteItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBackup = "CreateBackup"

// CreateBackupRequest generates a "aws/request.Request" representing the
// client's request for the CreateBackup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBackup for more information on using the CreateBackup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateBackupRequest method.
//    req, resp := client.CreateBackupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/CreateBackup
func (c *DynamoDB) CreateBackupRequest(input *CreateBackupInput) (req *request.Request, output *CreateBackupOutput) {
	op := &request.Operation{
		Name:       opCreateBackup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBackupInput{}
	}

	output = &CreateBackupOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// CreateBackup API operation for Amazon DynamoDB.
//
// Creates a backup for an existing table.
//
// Each time you create an on-demand backup, the entire table data is backed
// up. There is no limit to the number of on-demand backups that can be taken.
//
// When you create an on-demand backup, a time marker of the request is cataloged,
// and the backup is created asynchronously, by applying all changes until the
// time of the request to the last full table snapshot. Backup requests are
// processed instantaneously and become available for restore within minutes.
//
// You can call CreateBackup at a maximum rate of 50 times per second.
//
// All backups in DynamoDB work without consuming any provisioned throughput
// on the table.
//
// If you submit a backup request on 2018-12-14 at 14:25:00, the backup is guaranteed
// to contain all data committed to the table up to 14:24:00, and data committed
// after 14:26:00 will not be. The backup might contain data modifications made
// between 14:24:00 and 14:26:00. On-demand backup does not support causal consistency.
//
// Along with data, the following are also included on the backups:
//
//    * Global secondary indexes (GSIs)
//
//    * Local secondary indexes (LSIs)
//
//    * Streams
//
//    * Provisioned read and write capacity
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation CreateBackup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTableNotFoundException "TableNotFoundException"
//   A source table with the name TableName does not currently exist within the
//   subscriber's account.
//
//   * ErrCodeTableInUseException "TableInUseException"
//   A target table with the specified name is either being created or deleted.
//
//   * ErrCodeContinuousBackupsUnavailableException "ContinuousBackupsUnavailableException"
//   Backups have not yet been enabled for this table.
//
//   * ErrCodeBackupInUseException "BackupInUseException"
//   There is another ongoing conflicting backup control plane operation on the
//   table. The backup is either being created, deleted or restored to a table.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   There is no limit to the number of daily on-demand backups that can be taken.
//
//   Up to 50 simultaneous table operations are allowed per account. These operations
//   include CreateTable, UpdateTable, DeleteTable,UpdateTimeToLive, RestoreTableFromBackup,
//   and RestoreTableToPointInTime.
//
//   The only exception is when you are creating a table with one or more secondary
//   indexes. You can have up to 25 such requests running at a time; however,
//   if the table or index specifications are complex, DynamoDB might temporarily
//   reduce the number of concurrent operations.
//
//   There is a soft account limit of 256 tables.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/CreateBackup
func (c *DynamoDB) CreateBackup(input *CreateBackupInput) (*CreateBackupOutput, error) {
	req, out := c.CreateBackupRequest(input)
	return out, req.Send()
}

// CreateBackupWithContext is the same as CreateBackup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBackup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) CreateBackupWithContext(ctx aws.Context, input *CreateBackupInput, opts ...request.Option) (*CreateBackupOutput, error) {
	req, out := c.CreateBackupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGlobalTable = "CreateGlobalTable"

// CreateGlobalTableRequest generates a "aws/request.Request" representing the
// client's request for the CreateGlobalTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGlobalTable for more information on using the CreateGlobalTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGlobalTableRequest method.
//    req, resp := client.CreateGlobalTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/CreateGlobalTable
func (c *DynamoDB) CreateGlobalTableRequest(input *CreateGlobalTableInput) (req *request.Request, output *CreateGlobalTableOutput) {
	op := &request.Operation{
		Name:       opCreateGlobalTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGlobalTableInput{}
	}

	output = &CreateGlobalTableOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// CreateGlobalTable API operation for Amazon DynamoDB.
//
// Creates a global table from an existing table. A global table creates a replication
// relationship between two or more DynamoDB tables with the same table name
// in the provided Regions.
//
// This method only applies to Version 2017.11.29 (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html)
// of global tables.
//
// If you want to add a new replica table to a global table, each of the following
// conditions must be true:
//
//    * The table must have the same primary key as all of the other replicas.
//
//    * The table must have the same name as all of the other replicas.
//
//    * The table must have DynamoDB Streams enabled, with the stream containing
//    both the new and the old images of the item.
//
//    * None of the replica tables in the global table can contain any data.
//
// If global secondary indexes are specified, then the following conditions
// must also be met:
//
//    * The global secondary indexes must have the same name.
//
//    * The global secondary indexes must have the same hash key and sort key
//    (if present).
//
// Write capacity settings should be set consistently across your replica tables
// and secondary indexes. DynamoDB strongly recommends enabling auto scaling
// to manage the write capacity settings for all of your global tables replicas
// and indexes.
//
// If you prefer to manage write capacity settings manually, you should provision
// equal replicated write capacity units to your replica tables. You should
// also provision equal replicated write capacity units to matching secondary
// indexes across your global table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation CreateGlobalTable for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   There is no limit to the number of daily on-demand backups that can be taken.
//
//   Up to 50 simultaneous table operations are allowed per account. These operations
//   include CreateTable, UpdateTable, DeleteTable,UpdateTimeToLive, RestoreTableFromBackup,
//   and RestoreTableToPointInTime.
//
//   The only exception is when you are creating a table with one or more secondary
//   indexes. You can have up to 25 such requests running at a time; however,
//   if the table or index specifications are complex, DynamoDB might temporarily
//   reduce the number of concurrent operations.
//
//   There is a soft account limit of 256 tables.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeGlobalTableAlreadyExistsException "GlobalTableAlreadyExistsException"
//   The specified global table already exists.
//
//   * ErrCodeTableNotFoundException "TableNotFoundException"
//   A source table with the name TableName does not currently exist within the
//   subscriber's account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/CreateGlobalTable
func (c *DynamoDB) CreateGlobalTable(input *CreateGlobalTableInput) (*CreateGlobalTableOutput, error) {
	req, out := c.CreateGlobalTableRequest(input)
	return out, req.Send()
}

// CreateGlobalTableWithContext is the same as CreateGlobalTable with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGlobalTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) CreateGlobalTableWithContext(ctx aws.Context, input *CreateGlobalTableInput, opts ...request.Option) (*CreateGlobalTableOutput, error) {
	req, out := c.CreateGlobalTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTable = "CreateTable"

// CreateTableRequest generates a "aws/request.Request" representing the
// client's request for the CreateTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTable for more information on using the CreateTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTableRequest method.
//    req, resp := client.CreateTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/CreateTable
func (c *DynamoDB) CreateTableRequest(input *CreateTableInput) (req *request.Request, output *CreateTableOutput) {
	op := &request.Operation{
		Name:       opCreateTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTableInput{}
	}

	output = &CreateTableOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// CreateTable API operation for Amazon DynamoDB.
//
// The CreateTable operation adds a new table to your account. In an AWS account,
// table names must be unique within each Region. That is, you can have two
// tables with same name if you create the tables in different Regions.
//
// CreateTable is an asynchronous operation. Upon receiving a CreateTable request,
// DynamoDB immediately returns a response with a TableStatus of CREATING. After
// the table is created, DynamoDB sets the TableStatus to ACTIVE. You can perform
// read and write operations only on an ACTIVE table.
//
// You can optionally define secondary indexes on the new table, as part of
// the CreateTable operation. If you want to create multiple tables with secondary
// indexes on them, you must create the tables sequentially. Only one table
// with secondary indexes can be in the CREATING state at any given time.
//
// You can use the DescribeTable action to check the table status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation CreateTable for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The operation conflicts with the resource's availability. For example, you
//   attempted to recreate an existing table, or tried to delete a table currently
//   in the CREATING state.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   There is no limit to the number of daily on-demand backups that can be taken.
//
//   Up to 50 simultaneous table operations are allowed per account. These operations
//   include CreateTable, UpdateTable, DeleteTable,UpdateTimeToLive, RestoreTableFromBackup,
//   and RestoreTableToPointInTime.
//
//   The only exception is when you are creating a table with one or more secondary
//   indexes. You can have up to 25 such requests running at a time; however,
//   if the table or index specifications are complex, DynamoDB might temporarily
//   reduce the number of concurrent operations.
//
//   There is a soft account limit of 256 tables.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/CreateTable
func (c *DynamoDB) CreateTable(input *CreateTableInput) (*CreateTableOutput, error) {
	req, out := c.CreateTableRequest(input)
	return out, req.Send()
}

// CreateTableWithContext is the same as CreateTable with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) CreateTableWithContext(ctx aws.Context, input *CreateTableInput, opts ...request.Option) (*CreateTableOutput, error) {
	req, out := c.CreateTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBackup = "DeleteBackup"

// DeleteBackupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBackup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBackup for more information on using the DeleteBackup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBackupRequest method.
//    req, resp := client.DeleteBackupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteBackup
func (c *DynamoDB) DeleteBackupRequest(input *DeleteBackupInput) (req *request.Request, output *DeleteBackupOutput) {
	op := &request.Operation{
		Name:       opDeleteBackup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteBackupInput{}
	}

	output = &DeleteBackupOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// DeleteBackup API operation for Amazon DynamoDB.
//
// Deletes an existing backup of a table.
//
// You can call DeleteBackup at a maximum rate of 10 times per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation DeleteBackup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBackupNotFoundException "BackupNotFoundException"
//   Backup not found for the given BackupARN.
//
//   * ErrCodeBackupInUseException "BackupInUseException"
//   There is another ongoing conflicting backup control plane operation on the
//   table. The backup is either being created, deleted or restored to a table.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   There is no limit to the number of daily on-demand backups that can be taken.
//
//   Up to 50 simultaneous table operations are allowed per account. These operations
//   include CreateTable, UpdateTable, DeleteTable,UpdateTimeToLive, RestoreTableFromBackup,
//   and RestoreTableToPointInTime.
//
//   The only exception is when you are creating a table with one or more secondary
//   indexes. You can have up to 25 such requests running at a time; however,
//   if the table or index specifications are complex, DynamoDB might temporarily
//   reduce the number of concurrent operations.
//
//   There is a soft account limit of 256 tables.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteBackup
func (c *DynamoDB) DeleteBackup(input *DeleteBackupInput) (*DeleteBackupOutput, error) {
	req, out := c.DeleteBackupRequest(input)
	return out, req.Send()
}

// DeleteBackupWithContext is the same as DeleteBackup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBackup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) DeleteBackupWithContext(ctx aws.Context, input *DeleteBackupInput, opts ...request.Option) (*DeleteBackupOutput, error) {
	req, out := c.DeleteBackupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteItem = "DeleteItem"

// DeleteItemRequest generates a "aws/request.Request" representing the
// client's request for the DeleteItem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteItem for more information on using the DeleteItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteItemRequest method.
//    req, resp := client.DeleteItemRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteItem
func (c *DynamoDB) DeleteItemRequest(input *DeleteItemInput) (req *request.Request, output *DeleteItemOutput) {
	op := &request.Operation{
		Name:       opDeleteItem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteItemInput{}
	}

	output = &DeleteItemOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// DeleteItem API operation for Amazon DynamoDB.
//
// Deletes a single item in a table by primary key. You can perform a conditional
// delete operation that deletes the item if it exists, or if it has an expected
// attribute value.
//
// In addition to deleting an item, you can also return the item's attribute
// values in the same operation, using the ReturnValues parameter.
//
// Unless you specify conditions, the DeleteItem is an idempotent operation;
// running it multiple times on the same item or attribute does not result in
// an error response.
//
// Conditional deletes are useful for deleting items only if specific conditions
// are met. If those conditions are met, DynamoDB performs the delete. Otherwise,
// the item is not deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation DeleteItem for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConditionalCheckFailedException "ConditionalCheckFailedException"
//   A condition specified in the operation could not be evaluated.
//
//   * ErrCodeProvisionedThroughputExceededException "ProvisionedThroughputExceededException"
//   Your request rate is too high. The AWS SDKs for DynamoDB automatically retry
//   requests that receive this exception. Your request is eventually successful,
//   unless your retry queue is too large to finish. Reduce the frequency of requests
//   and use exponential backoff. For more information, go to Error Retries and
//   Exponential Backoff (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff)
//   in the Amazon DynamoDB Developer Guide.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeItemCollectionSizeLimitExceededException "ItemCollectionSizeLimitExceededException"
//   An item collection is too large. This exception is only returned for tables
//   that have one or more local secondary indexes.
//
//   * ErrCodeTransactionConflictException "TransactionConflictException"
//   Operation was rejected because there is an ongoing transaction for the item.
//
//   * ErrCodeRequestLimitExceeded "RequestLimitExceeded"
//   Throughput exceeds the current throughput limit for your account. Please
//   contact AWS Support at AWS Support (https://aws.amazon.com/support) to request
//   a limit increase.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteItem
func (c *DynamoDB) DeleteItem(input *DeleteItemInput) (*DeleteItemOutput, error) {
	req, out := c.DeleteItemRequest(input)
	return out, req.Send()
}

// DeleteItemWithContext is the same as DeleteItem with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) DeleteItemWithContext(ctx aws.Context, input *DeleteItemInput, opts ...request.Option) (*DeleteItemOutput, error) {
	req, out := c.DeleteItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTable = "DeleteTable"

// DeleteTableRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTable for more information on using the DeleteTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTableRequest method.
//    req, resp := client.DeleteTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteTable
func (c *DynamoDB) DeleteTableRequest(input *DeleteTableInput) (req *request.Request, output *DeleteTableOutput) {
	op := &request.Operation{
		Name:       opDeleteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTableInput{}
	}

	output = &DeleteTableOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// DeleteTable API operation for Amazon DynamoDB.
//
// The DeleteTable operation deletes a table and all of its items. After a DeleteTable
// request, the specified table is in the DELETING state until DynamoDB completes
// the deletion. If the table is in the ACTIVE state, you can delete it. If
// a table is in CREATING or UPDATING states, then DynamoDB returns a ResourceInUseException.
// If the specified table does not exist, DynamoDB returns a ResourceNotFoundException.
// If table is already in the DELETING state, no error is returned.
//
// DynamoDB might continue to accept data read and write operations, such as
// GetItem and PutItem, on a table in the DELETING state until the table deletion
// is complete.
//
// When you delete a table, any indexes on that table are also deleted.
//
// If you have DynamoDB Streams enabled on the table, then the corresponding
// stream on that table goes into the DISABLED state, and the stream is automatically
// deleted after 24 hours.
//
// Use the DescribeTable action to check the status of the table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation DeleteTable for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The operation conflicts with the resource's availability. For example, you
//   attempted to recreate an existing table, or tried to delete a table currently
//   in the CREATING state.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   There is no limit to the number of daily on-demand backups that can be taken.
//
//   Up to 50 simultaneous table operations are allowed per account. These operations
//   include CreateTable, UpdateTable, DeleteTable,UpdateTimeToLive, RestoreTableFromBackup,
//   and RestoreTableToPointInTime.
//
//   The only exception is when you are creating a table with one or more secondary
//   indexes. You can have up to 25 such requests running at a time; however,
//   if the table or index specifications are complex, DynamoDB might temporarily
//   reduce the number of concurrent operations.
//
//   There is a soft account limit of 256 tables.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteTable
func (c *DynamoDB) DeleteTable(input *DeleteTableInput) (*DeleteTableOutput, error) {
	req, out := c.DeleteTableRequest(input)
	return out, req.Send()
}

// DeleteTableWithContext is the same as DeleteTable with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) DeleteTableWithContext(ctx aws.Context, input *DeleteTableInput, opts ...request.Option) (*DeleteTableOutput, error) {
	req, out := c.DeleteTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBackup = "DescribeBackup"

// DescribeBackupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBackup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBackup for more information on using the DescribeBackup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeBackupRequest method.
//    req, resp := client.DescribeBackupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeBackup
func (c *DynamoDB) DescribeBackupRequest(input *DescribeBackupInput) (req *request.Request, output *DescribeBackupOutput) {
	op := &request.Operation{
		Name:       opDescribeBackup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeBackupInput{}
	}

	output = &DescribeBackupOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// DescribeBackup API operation for Amazon DynamoDB.
//
// Describes an existing backup of a table.
//
// You can call DescribeBackup at a maximum rate of 10 times per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation DescribeBackup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBackupNotFoundException "BackupNotFoundException"
//   Backup not found for the given BackupARN.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeBackup
func (c *DynamoDB) DescribeBackup(input *DescribeBackupInput) (*DescribeBackupOutput, error) {
	req, out := c.DescribeBackupRequest(input)
	return out, req.Send()
}

// DescribeBackupWithContext is the same as DescribeBackup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBackup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) DescribeBackupWithContext(ctx aws.Context, input *DescribeBackupInput, opts ...request.Option) (*DescribeBackupOutput, error) {
	req, out := c.DescribeBackupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeContinuousBackups = "DescribeContinuousBackups"

// DescribeContinuousBackupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeContinuousBackups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeContinuousBackups for more information on using the DescribeContinuousBackups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeContinuousBackupsRequest method.
//    req, resp := client.DescribeContinuousBackupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeContinuousBackups
func (c *DynamoDB) DescribeContinuousBackupsRequest(input *DescribeContinuousBackupsInput) (req *request.Request, output *DescribeContinuousBackupsOutput) {
	op := &request.Operation{
		Name:       opDescribeContinuousBackups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeContinuousBackupsInput{}
	}

	output = &DescribeContinuousBackupsOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// DescribeContinuousBackups API operation for Amazon DynamoDB.
//
// Checks the status of continuous backups and point in time recovery on the
// specified table. Continuous backups are ENABLED on all tables at table creation.
// If point in time recovery is enabled, PointInTimeRecoveryStatus will be set
// to ENABLED.
//
// After continuous backups and point in time recovery are enabled, you can
// restore to any point in time within EarliestRestorableDateTime and LatestRestorableDateTime.
//
// LatestRestorableDateTime is typically 5 minutes before the current time.
// You can restore your table to any point in time during the last 35 days.
//
// You can call DescribeContinuousBackups at a maximum rate of 10 times per
// second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation DescribeContinuousBackups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTableNotFoundException "TableNotFoundException"
//   A source table with the name TableName does not currently exist within the
//   subscriber's account.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeContinuousBackups
func (c *DynamoDB) DescribeContinuousBackups(input *DescribeContinuousBackupsInput) (*DescribeContinuousBackupsOutput, error) {
	req, out := c.DescribeContinuousBackupsRequest(input)
	return out, req.Send()
}

// DescribeContinuousBackupsWithContext is the same as DescribeContinuousBackups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeContinuousBackups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) DescribeContinuousBackupsWithContext(ctx aws.Context, input *DescribeContinuousBackupsInput, opts ...request.Option) (*DescribeContinuousBackupsOutput, error) {
	req, out := c.DescribeContinuousBackupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeContributorInsights = "DescribeContributorInsights"

// DescribeContributorInsightsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeContributorInsights operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeContributorInsights for more information on using the DescribeContributorInsights
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeContributorInsightsRequest method.
//    req, resp := client.DescribeContributorInsightsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeContributorInsights
func (c *DynamoDB) DescribeContributorInsightsRequest(input *DescribeContributorInsightsInput) (req *request.Request, output *DescribeContributorInsightsOutput) {
	op := &request.Operation{
		Name:       opDescribeContributorInsights,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeContributorInsightsInput{}
	}

	output = &DescribeContributorInsightsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeContributorInsights API operation for Amazon DynamoDB.
//
// Returns information about contributor insights, for a given table or global
// secondary index.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation DescribeContributorInsights for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeContributorInsights
func (c *DynamoDB) DescribeContributorInsights(input *DescribeContributorInsightsInput) (*DescribeContributorInsightsOutput, error) {
	req, out := c.DescribeContributorInsightsRequest(input)
	return out, req.Send()
}

// DescribeContributorInsightsWithContext is the same as DescribeContributorInsights with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeContributorInsights for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) DescribeContributorInsightsWithContext(ctx aws.Context, input *DescribeContributorInsightsInput, opts ...request.Option) (*DescribeContributorInsightsOutput, error) {
	req, out := c.DescribeContributorInsightsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEndpoints = "DescribeEndpoints"

// DescribeEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEndpoints for more information on using the DescribeEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEndpointsRequest method.
//    req, resp := client.DescribeEndpointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeEndpoints
func (c *DynamoDB) DescribeEndpointsRequest(input *DescribeEndpointsInput) (req *request.Request, output *DescribeEndpointsOutput) {
	op := &request.Operation{
		Name:       opDescribeEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEndpointsInput{}
	}

	output = &DescribeEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEndpoints API operation for Amazon DynamoDB.
//
// Returns the regional endpoint information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation DescribeEndpoints for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeEndpoints
func (c *DynamoDB) DescribeEndpoints(input *DescribeEndpointsInput) (*DescribeEndpointsOutput, error) {
	req, out := c.DescribeEndpointsRequest(input)
	return out, req.Send()
}

// DescribeEndpointsWithContext is the same as DescribeEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) DescribeEndpointsWithContext(ctx aws.Context, input *DescribeEndpointsInput, opts ...request.Option) (*DescribeEndpointsOutput, error) {
	req, out := c.DescribeEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type discovererDescribeEndpoints struct {
	Client        *DynamoDB
	Required      bool
	EndpointCache *crr.EndpointCache
	Params        map[string]*string
	Key           string
}

func (d *discovererDescribeEndpoints) Discover() (crr.Endpoint, error) {
	input := &DescribeEndpointsInput{}

	resp, err := d.Client.DescribeEndpoints(input)
	if err != nil {
		return crr.Endpoint{}, err
	}

	endpoint := crr.Endpoint{
		Key: d.Key,
	}

	for _, e := range resp.Endpoints {
		if e.Address == nil {
			continue
		}

		cachedInMinutes := aws.Int64Value(e.CachePeriodInMinutes)
		u, err := url.Parse(*e.Address)
		if err != nil {
			continue
		}

		addr := crr.WeightedAddress{
			URL:     u,
			Expired: time.Now().Add(time.Duration(cachedInMinutes) * time.Minute),
		}

		endpoint.Add(addr)
	}

	d.EndpointCache.Add(endpoint)

	return endpoint, nil
}

func (d *discovererDescribeEndpoints) Handler(r *request.Request) {
	endpointKey := crr.BuildEndpointKey(d.Params)
	d.Key = endpointKey

	endpoint, err := d.EndpointCache.Get(d, endpointKey, d.Required)
	if err != nil {
		r.Error = err
		return
	}

	if endpoint.URL != nil && len(endpoint.URL.String()) > 0 {
		r.HTTPRequest.URL = endpoint.URL
	}
}

const opDescribeGlobalTable = "DescribeGlobalTable"

// DescribeGlobalTableRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGlobalTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGlobalTable for more information on using the DescribeGlobalTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeGlobalTableRequest method.
//    req, resp := client.DescribeGlobalTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeGlobalTable
func (c *DynamoDB) DescribeGlobalTableRequest(input *DescribeGlobalTableInput) (req *request.Request, output *DescribeGlobalTableOutput) {
	op := &request.Operation{
		Name:       opDescribeGlobalTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeGlobalTableInput{}
	}

	output = &DescribeGlobalTableOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// DescribeGlobalTable API operation for Amazon DynamoDB.
//
// Returns information about the specified global table.
//
// This method only applies to Version 2017.11.29 (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html)
// of global tables.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation DescribeGlobalTable for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeGlobalTableNotFoundException "GlobalTableNotFoundException"
//   The specified global table does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeGlobalTable
func (c *DynamoDB) DescribeGlobalTable(input *DescribeGlobalTableInput) (*DescribeGlobalTableOutput, error) {
	req, out := c.DescribeGlobalTableRequest(input)
	return out, req.Send()
}

// DescribeGlobalTableWithContext is the same as DescribeGlobalTable with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGlobalTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) DescribeGlobalTableWithContext(ctx aws.Context, input *DescribeGlobalTableInput, opts ...request.Option) (*DescribeGlobalTableOutput, error) {
	req, out := c.DescribeGlobalTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGlobalTableSettings = "DescribeGlobalTableSettings"

// DescribeGlobalTableSettingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGlobalTableSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGlobalTableSettings for more information on using the DescribeGlobalTableSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeGlobalTableSettingsRequest method.
//    req, resp := client.DescribeGlobalTableSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeGlobalTableSettings
func (c *DynamoDB) DescribeGlobalTableSettingsRequest(input *DescribeGlobalTableSettingsInput) (req *request.Request, output *DescribeGlobalTableSettingsOutput) {
	op := &request.Operation{
		Name:       opDescribeGlobalTableSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeGlobalTableSettingsInput{}
	}

	output = &DescribeGlobalTableSettingsOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// DescribeGlobalTableSettings API operation for Amazon DynamoDB.
//
// Describes Region-specific settings for a global table.
//
// This method only applies to Version 2017.11.29 (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html)
// of global tables.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation DescribeGlobalTableSettings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeGlobalTableNotFoundException "GlobalTableNotFoundException"
//   The specified global table does not exist.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeGlobalTableSettings
func (c *DynamoDB) DescribeGlobalTableSettings(input *DescribeGlobalTableSettingsInput) (*DescribeGlobalTableSettingsOutput, error) {
	req, out := c.DescribeGlobalTableSettingsRequest(input)
	return out, req.Send()
}

// DescribeGlobalTableSettingsWithContext is the same as DescribeGlobalTableSettings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGlobalTableSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) DescribeGlobalTableSettingsWithContext(ctx aws.Context, input *DescribeGlobalTableSettingsInput, opts ...request.Option) (*DescribeGlobalTableSettingsOutput, error) {
	req, out := c.DescribeGlobalTableSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLimits = "DescribeLimits"

// DescribeLimitsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLimits operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLimits for more information on using the DescribeLimits
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLimitsRequest method.
//    req, resp := client.DescribeLimitsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeLimits
func (c *DynamoDB) DescribeLimitsRequest(input *DescribeLimitsInput) (req *request.Request, output *DescribeLimitsOutput) {
	op := &request.Operation{
		Name:       opDescribeLimits,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLimitsInput{}
	}

	output = &DescribeLimitsOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// DescribeLimits API operation for Amazon DynamoDB.
//
// Returns the current provisioned-capacity limits for your AWS account in a
// Region, both for the Region as a whole and for any one DynamoDB table that
// you create there.
//
// When you establish an AWS account, the account has initial limits on the
// maximum read capacity units and write capacity units that you can provision
// across all of your DynamoDB tables in a given Region. Also, there are per-table
// limits that apply when you create a table there. For more information, see
// Limits (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html)
// page in the Amazon DynamoDB Developer Guide.
//
// Although you can increase these limits by filing a case at AWS Support Center
// (https://console.aws.amazon.com/support/home#/), obtaining the increase is
// not instantaneous. The DescribeLimits action lets you write code to compare
// the capacity you are currently using to those limits imposed by your account
// so that you have enough time to apply for an increase before you hit a limit.
//
// For example, you could use one of the AWS SDKs to do the following:
//
// Call DescribeLimits for a particular Region to obtain your current account
// limits on provisioned capacity there.
//
// Create a variable to hold the aggregate read capacity units provisioned for
// all your tables in that Region, and one to hold the aggregate write capacity
// units. Zero them both.
//
// Call ListTables to obtain a list of all your DynamoDB tables.
//
// For each table name listed by ListTables, do the following:
//
//    * Call DescribeTable with the table name.
//
//    * Use the data returned by DescribeTable to add the read capacity units
//    and write capacity units provisioned for the table itself to your variables.
//
//    * If the table has one or more global secondary indexes (GSIs), loop over
//    these GSIs and add their provisioned capacity values to your variables
//    as well.
//
// Report the account limits for that Region returned by DescribeLimits, along
// with the total current provisioned capacity levels you have calculated.
//
// This will let you see whether you are getting close to your account-level
// limits.
//
// The per-table limits apply only when you are creating a new table. They restrict
// the sum of the provisioned capacity of the new table itself and all its global
// secondary indexes.
//
// For existing tables and their GSIs, DynamoDB doesn't let you increase provisioned
// capacity extremely rapidly. But the only upper limit that applies is that
// the aggregate provisioned capacity over all your tables and GSIs cannot exceed
// either of the per-account limits.
//
// DescribeLimits should only be called periodically. You can expect throttling
// errors if you call it more than once in a minute.
//
// The DescribeLimits Request element has no content.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation DescribeLimits for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeLimits
func (c *DynamoDB) DescribeLimits(input *DescribeLimitsInput) (*DescribeLimitsOutput, error) {
	req, out := c.DescribeLimitsRequest(input)
	return out, req.Send()
}

// DescribeLimitsWithContext is the same as DescribeLimits with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLimits for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) DescribeLimitsWithContext(ctx aws.Context, input *DescribeLimitsInput, opts ...request.Option) (*DescribeLimitsOutput, error) {
	req, out := c.DescribeLimitsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTable = "DescribeTable"

// DescribeTableRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTable for more information on using the DescribeTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTableRequest method.
//    req, resp := client.DescribeTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeTable
func (c *DynamoDB) DescribeTableRequest(input *DescribeTableInput) (req *request.Request, output *DescribeTableOutput) {
	op := &request.Operation{
		Name:       opDescribeTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTableInput{}
	}

	output = &DescribeTableOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// DescribeTable API operation for Amazon DynamoDB.
//
// Returns information about the table, including the current status of the
// table, when it was created, the primary key schema, and any indexes on the
// table.
//
// If you issue a DescribeTable request immediately after a CreateTable request,
// DynamoDB might return a ResourceNotFoundException. This is because DescribeTable
// uses an eventually consistent query, and the metadata for your table might
// not be available at that moment. Wait for a few seconds, and then try the
// DescribeTable request again.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation DescribeTable for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeTable
func (c *DynamoDB) DescribeTable(input *DescribeTableInput) (*DescribeTableOutput, error) {
	req, out := c.DescribeTableRequest(input)
	return out, req.Send()
}

// DescribeTableWithContext is the same as DescribeTable with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) DescribeTableWithContext(ctx aws.Context, input *DescribeTableInput, opts ...request.Option) (*DescribeTableOutput, error) {
	req, out := c.DescribeTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTableReplicaAutoScaling = "DescribeTableReplicaAutoScaling"

// DescribeTableReplicaAutoScalingRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTableReplicaAutoScaling operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTableReplicaAutoScaling for more information on using the DescribeTableReplicaAutoScaling
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTableReplicaAutoScalingRequest method.
//    req, resp := client.DescribeTableReplicaAutoScalingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeTableReplicaAutoScaling
func (c *DynamoDB) DescribeTableReplicaAutoScalingRequest(input *DescribeTableReplicaAutoScalingInput) (req *request.Request, output *DescribeTableReplicaAutoScalingOutput) {
	op := &request.Operation{
		Name:       opDescribeTableReplicaAutoScaling,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTableReplicaAutoScalingInput{}
	}

	output = &DescribeTableReplicaAutoScalingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTableReplicaAutoScaling API operation for Amazon DynamoDB.
//
// Describes auto scaling settings across replicas of the global table at once.
//
// This method only applies to Version 2019.11.21 (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html)
// of global tables.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation DescribeTableReplicaAutoScaling for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeTableReplicaAutoScaling
func (c *DynamoDB) DescribeTableReplicaAutoScaling(input *DescribeTableReplicaAutoScalingInput) (*DescribeTableReplicaAutoScalingOutput, error) {
	req, out := c.DescribeTableReplicaAutoScalingRequest(input)
	return out, req.Send()
}

// DescribeTableReplicaAutoScalingWithContext is the same as DescribeTableReplicaAutoScaling with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTableReplicaAutoScaling for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) DescribeTableReplicaAutoScalingWithContext(ctx aws.Context, input *DescribeTableReplicaAutoScalingInput, opts ...request.Option) (*DescribeTableReplicaAutoScalingOutput, error) {
	req, out := c.DescribeTableReplicaAutoScalingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTimeToLive = "DescribeTimeToLive"

// DescribeTimeToLiveRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTimeToLive operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTimeToLive for more information on using the DescribeTimeToLive
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTimeToLiveRequest method.
//    req, resp := client.DescribeTimeToLiveRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeTimeToLive
func (c *DynamoDB) DescribeTimeToLiveRequest(input *DescribeTimeToLiveInput) (req *request.Request, output *DescribeTimeToLiveOutput) {
	op := &request.Operation{
		Name:       opDescribeTimeToLive,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTimeToLiveInput{}
	}

	output = &DescribeTimeToLiveOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// DescribeTimeToLive API operation for Amazon DynamoDB.
//
// Gives a description of the Time to Live (TTL) status on the specified table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation DescribeTimeToLive for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeTimeToLive
func (c *DynamoDB) DescribeTimeToLive(input *DescribeTimeToLiveInput) (*DescribeTimeToLiveOutput, error) {
	req, out := c.DescribeTimeToLiveRequest(input)
	return out, req.Send()
}

// DescribeTimeToLiveWithContext is the same as DescribeTimeToLive with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTimeToLive for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) DescribeTimeToLiveWithContext(ctx aws.Context, input *DescribeTimeToLiveInput, opts ...request.Option) (*DescribeTimeToLiveOutput, error) {
	req, out := c.DescribeTimeToLiveRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetItem = "GetItem"

// GetItemRequest generates a "aws/request.Request" representing the
// client's request for the GetItem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetItem for more information on using the GetItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetItemRequest method.
//    req, resp := client.GetItemRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/GetItem
func (c *DynamoDB) GetItemRequest(input *GetItemInput) (req *request.Request, output *GetItemOutput) {
	op := &request.Operation{
		Name:       opGetItem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetItemInput{}
	}

	output = &GetItemOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// GetItem API operation for Amazon DynamoDB.
//
// The GetItem operation returns a set of attributes for the item with the given
// primary key. If there is no matching item, GetItem does not return any data
// and there will be no Item element in the response.
//
// GetItem provides an eventually consistent read by default. If your application
// requires a strongly consistent read, set ConsistentRead to true. Although
// a strongly consistent read might take more time than an eventually consistent
// read, it always returns the last updated value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation GetItem for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeProvisionedThroughputExceededException "ProvisionedThroughputExceededException"
//   Your request rate is too high. The AWS SDKs for DynamoDB automatically retry
//   requests that receive this exception. Your request is eventually successful,
//   unless your retry queue is too large to finish. Reduce the frequency of requests
//   and use exponential backoff. For more information, go to Error Retries and
//   Exponential Backoff (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff)
//   in the Amazon DynamoDB Developer Guide.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeRequestLimitExceeded "RequestLimitExceeded"
//   Throughput exceeds the current throughput limit for your account. Please
//   contact AWS Support at AWS Support (https://aws.amazon.com/support) to request
//   a limit increase.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/GetItem
func (c *DynamoDB) GetItem(input *GetItemInput) (*GetItemOutput, error) {
	req, out := c.GetItemRequest(input)
	return out, req.Send()
}

// GetItemWithContext is the same as GetItem with the addition of
// the ability to pass a context and additional request options.
//
// See GetItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) GetItemWithContext(ctx aws.Context, input *GetItemInput, opts ...request.Option) (*GetItemOutput, error) {
	req, out := c.GetItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBackups = "ListBackups"

// ListBackupsRequest generates a "aws/request.Request" representing the
// client's request for the ListBackups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBackups for more information on using the ListBackups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListBackupsRequest method.
//    req, resp := client.ListBackupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListBackups
func (c *DynamoDB) ListBackupsRequest(input *ListBackupsInput) (req *request.Request, output *ListBackupsOutput) {
	op := &request.Operation{
		Name:       opListBackups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListBackupsInput{}
	}

	output = &ListBackupsOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// ListBackups API operation for Amazon DynamoDB.
//
// List backups associated with an AWS account. To list backups for a given
// table, specify TableName. ListBackups returns a paginated list of results
// with at most 1 MB worth of items in a page. You can also specify a limit
// for the maximum number of entries to be returned in a page.
//
// In the request, start time is inclusive, but end time is exclusive. Note
// that these limits are for the time at which the original backup was requested.
//
// You can call ListBackups a maximum of five times per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation ListBackups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListBackups
func (c *DynamoDB) ListBackups(input *ListBackupsInput) (*ListBackupsOutput, error) {
	req, out := c.ListBackupsRequest(input)
	return out, req.Send()
}

// ListBackupsWithContext is the same as ListBackups with the addition of
// the ability to pass a context and additional request options.
//
// See ListBackups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) ListBackupsWithContext(ctx aws.Context, input *ListBackupsInput, opts ...request.Option) (*ListBackupsOutput, error) {
	req, out := c.ListBackupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListContributorInsights = "ListContributorInsights"

// ListContributorInsightsRequest generates a "aws/request.Request" representing the
// client's request for the ListContributorInsights operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListContributorInsights for more information on using the ListContributorInsights
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListContributorInsightsRequest method.
//    req, resp := client.ListContributorInsightsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListContributorInsights
func (c *DynamoDB) ListContributorInsightsRequest(input *ListContributorInsightsInput) (req *request.Request, output *ListContributorInsightsOutput) {
	op := &request.Operation{
		Name:       opListContributorInsights,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListContributorInsightsInput{}
	}

	output = &ListContributorInsightsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListContributorInsights API operation for Amazon DynamoDB.
//
// Returns a list of ContributorInsightsSummary for a table and all its global
// secondary indexes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation ListContributorInsights for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListContributorInsights
func (c *DynamoDB) ListContributorInsights(input *ListContributorInsightsInput) (*ListContributorInsightsOutput, error) {
	req, out := c.ListContributorInsightsRequest(input)
	return out, req.Send()
}

// ListContributorInsightsWithContext is the same as ListContributorInsights with the addition of
// the ability to pass a context and additional request options.
//
// See ListContributorInsights for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) ListContributorInsightsWithContext(ctx aws.Context, input *ListContributorInsightsInput, opts ...request.Option) (*ListContributorInsightsOutput, error) {
	req, out := c.ListContributorInsightsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListContributorInsightsPages iterates over the pages of a ListContributorInsights operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListContributorInsights method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListContributorInsights operation.
//    pageNum := 0
//    err := client.ListContributorInsightsPages(params,
//        func(page *dynamodb.ListContributorInsightsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DynamoDB) ListContributorInsightsPages(input *ListContributorInsightsInput, fn func(*ListContributorInsightsOutput, bool) bool) error {
	return c.ListContributorInsightsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListContributorInsightsPagesWithContext same as ListContributorInsightsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) ListContributorInsightsPagesWithContext(ctx aws.Context, input *ListContributorInsightsInput, fn func(*ListContributorInsightsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListContributorInsightsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListContributorInsightsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListContributorInsightsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListGlobalTables = "ListGlobalTables"

// ListGlobalTablesRequest generates a "aws/request.Request" representing the
// client's request for the ListGlobalTables operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGlobalTables for more information on using the ListGlobalTables
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGlobalTablesRequest method.
//    req, resp := client.ListGlobalTablesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListGlobalTables
func (c *DynamoDB) ListGlobalTablesRequest(input *ListGlobalTablesInput) (req *request.Request, output *ListGlobalTablesOutput) {
	op := &request.Operation{
		Name:       opListGlobalTables,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListGlobalTablesInput{}
	}

	output = &ListGlobalTablesOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// ListGlobalTables API operation for Amazon DynamoDB.
//
// Lists all global tables that have a replica in the specified Region.
//
// This method only applies to Version 2017.11.29 (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html)
// of global tables.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation ListGlobalTables for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListGlobalTables
func (c *DynamoDB) ListGlobalTables(input *ListGlobalTablesInput) (*ListGlobalTablesOutput, error) {
	req, out := c.ListGlobalTablesRequest(input)
	return out, req.Send()
}

// ListGlobalTablesWithContext is the same as ListGlobalTables with the addition of
// the ability to pass a context and additional request options.
//
// See ListGlobalTables for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) ListGlobalTablesWithContext(ctx aws.Context, input *ListGlobalTablesInput, opts ...request.Option) (*ListGlobalTablesOutput, error) {
	req, out := c.ListGlobalTablesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTables = "ListTables"

// ListTablesRequest generates a "aws/request.Request" representing the
// client's request for the ListTables operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTables for more information on using the ListTables
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTablesRequest method.
//    req, resp := client.ListTablesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListTables
func (c *DynamoDB) ListTablesRequest(input *ListTablesInput) (req *request.Request, output *ListTablesOutput) {
	op := &request.Operation{
		Name:       opListTables,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"ExclusiveStartTableName"},
			OutputTokens:    []string{"LastEvaluatedTableName"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTablesInput{}
	}

	output = &ListTablesOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// ListTables API operation for Amazon DynamoDB.
//
// Returns an array of table names associated with the current account and endpoint.
// The output from ListTables is paginated, with each page returning a maximum
// of 100 table names.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation ListTables for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListTables
func (c *DynamoDB) ListTables(input *ListTablesInput) (*ListTablesOutput, error) {
	req, out := c.ListTablesRequest(input)
	return out, req.Send()
}

// ListTablesWithContext is the same as ListTables with the addition of
// the ability to pass a context and additional request options.
//
// See ListTables for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) ListTablesWithContext(ctx aws.Context, input *ListTablesInput, opts ...request.Option) (*ListTablesOutput, error) {
	req, out := c.ListTablesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTablesPages iterates over the pages of a ListTables operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTables method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTables operation.
//    pageNum := 0
//    err := client.ListTablesPages(params,
//        func(page *dynamodb.ListTablesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DynamoDB) ListTablesPages(input *ListTablesInput, fn func(*ListTablesOutput, bool) bool) error {
	return c.ListTablesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTablesPagesWithContext same as ListTablesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) ListTablesPagesWithContext(ctx aws.Context, input *ListTablesInput, fn func(*ListTablesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTablesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTablesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTablesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsOfResource = "ListTagsOfResource"

// ListTagsOfResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsOfResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsOfResource for more information on using the ListTagsOfResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsOfResourceRequest method.
//    req, resp := client.ListTagsOfResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListTagsOfResource
func (c *DynamoDB) ListTagsOfResourceRequest(input *ListTagsOfResourceInput) (req *request.Request, output *ListTagsOfResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsOfResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsOfResourceInput{}
	}

	output = &ListTagsOfResourceOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// ListTagsOfResource API operation for Amazon DynamoDB.
//
// List all tags on an Amazon DynamoDB resource. You can call ListTagsOfResource
// up to 10 times per second, per account.
//
// For an overview on tagging DynamoDB resources, see Tagging for DynamoDB (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html)
// in the Amazon DynamoDB Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation ListTagsOfResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListTagsOfResource
func (c *DynamoDB) ListTagsOfResource(input *ListTagsOfResourceInput) (*ListTagsOfResourceOutput, error) {
	req, out := c.ListTagsOfResourceRequest(input)
	return out, req.Send()
}

// ListTagsOfResourceWithContext is the same as ListTagsOfResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsOfResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) ListTagsOfResourceWithContext(ctx aws.Context, input *ListTagsOfResourceInput, opts ...request.Option) (*ListTagsOfResourceOutput, error) {
	req, out := c.ListTagsOfResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutItem = "PutItem"

// PutItemRequest generates a "aws/request.Request" representing the
// client's request for the PutItem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutItem for more information on using the PutItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutItemRequest method.
//    req, resp := client.PutItemRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/PutItem
func (c *DynamoDB) PutItemRequest(input *PutItemInput) (req *request.Request, output *PutItemOutput) {
	op := &request.Operation{
		Name:       opPutItem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutItemInput{}
	}

	output = &PutItemOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// PutItem API operation for Amazon DynamoDB.
//
// Creates a new item, or replaces an old item with a new item. If an item that
// has the same primary key as the new item already exists in the specified
// table, the new item completely replaces the existing item. You can perform
// a conditional put operation (add a new item if one with the specified primary
// key doesn't exist), or replace an existing item if it has certain attribute
// values. You can return the item's attribute values in the same operation,
// using the ReturnValues parameter.
//
// This topic provides general information about the PutItem API.
//
// For information on how to call the PutItem API using the AWS SDK in specific
// languages, see the following:
//
//    * PutItem in the AWS Command Line Interface (http://docs.aws.amazon.com/goto/aws-cli/dynamodb-2012-08-10/PutItem)
//
//    * PutItem in the AWS SDK for .NET (http://docs.aws.amazon.com/goto/DotNetSDKV3/dynamodb-2012-08-10/PutItem)
//
//    * PutItem in the AWS SDK for C++ (http://docs.aws.amazon.com/goto/SdkForCpp/dynamodb-2012-08-10/PutItem)
//
//    * PutItem in the AWS SDK for Go (http://docs.aws.amazon.com/goto/SdkForGoV1/dynamodb-2012-08-10/PutItem)
//
//    * PutItem in the AWS SDK for Java (http://docs.aws.amazon.com/goto/SdkForJava/dynamodb-2012-08-10/PutItem)
//
//    * PutItem in the AWS SDK for JavaScript (http://docs.aws.amazon.com/goto/AWSJavaScriptSDK/dynamodb-2012-08-10/PutItem)
//
//    * PutItem in the AWS SDK for PHP V3 (http://docs.aws.amazon.com/goto/SdkForPHPV3/dynamodb-2012-08-10/PutItem)
//
//    * PutItem in the AWS SDK for Python (http://docs.aws.amazon.com/goto/boto3/dynamodb-2012-08-10/PutItem)
//
//    * PutItem in the AWS SDK for Ruby V2 (http://docs.aws.amazon.com/goto/SdkForRubyV2/dynamodb-2012-08-10/PutItem)
//
// When you add an item, the primary key attributes are the only required attributes.
// Attribute values cannot be null. String and Binary type attributes must have
// lengths greater than zero. Set type attributes cannot be empty. Requests
// with empty values will be rejected with a ValidationException exception.
//
// To prevent a new item from replacing an existing item, use a conditional
// expression that contains the attribute_not_exists function with the name
// of the attribute being used as the partition key for the table. Since every
// record must contain that attribute, the attribute_not_exists function will
// only succeed if no matching item exists.
//
// For more information about PutItem, see Working with Items (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithItems.html)
// in the Amazon DynamoDB Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation PutItem for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConditionalCheckFailedException "ConditionalCheckFailedException"
//   A condition specified in the operation could not be evaluated.
//
//   * ErrCodeProvisionedThroughputExceededException "ProvisionedThroughputExceededException"
//   Your request rate is too high. The AWS SDKs for DynamoDB automatically retry
//   requests that receive this exception. Your request is eventually successful,
//   unless your retry queue is too large to finish. Reduce the frequency of requests
//   and use exponential backoff. For more information, go to Error Retries and
//   Exponential Backoff (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff)
//   in the Amazon DynamoDB Developer Guide.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeItemCollectionSizeLimitExceededException "ItemCollectionSizeLimitExceededException"
//   An item collection is too large. This exception is only returned for tables
//   that have one or more local secondary indexes.
//
//   * ErrCodeTransactionConflictException "TransactionConflictException"
//   Operation was rejected because there is an ongoing transaction for the item.
//
//   * ErrCodeRequestLimitExceeded "RequestLimitExceeded"
//   Throughput exceeds the current throughput limit for your account. Please
//   contact AWS Support at AWS Support (https://aws.amazon.com/support) to request
//   a limit increase.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/PutItem
func (c *DynamoDB) PutItem(input *PutItemInput) (*PutItemOutput, error) {
	req, out := c.PutItemRequest(input)
	return out, req.Send()
}

// PutItemWithContext is the same as PutItem with the addition of
// the ability to pass a context and additional request options.
//
// See PutItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) PutItemWithContext(ctx aws.Context, input *PutItemInput, opts ...request.Option) (*PutItemOutput, error) {
	req, out := c.PutItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opQuery = "Query"

// QueryRequest generates a "aws/request.Request" representing the
// client's request for the Query operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Query for more information on using the Query
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the QueryRequest method.
//    req, resp := client.QueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Query
func (c *DynamoDB) QueryRequest(input *QueryInput) (req *request.Request, output *QueryOutput) {
	op := &request.Operation{
		Name:       opQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"ExclusiveStartKey"},
			OutputTokens:    []string{"LastEvaluatedKey"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &QueryInput{}
	}

	output = &QueryOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// Query API operation for Amazon DynamoDB.
//
// The Query operation finds items based on primary key values. You can query
// any table or secondary index that has a composite primary key (a partition
// key and a sort key).
//
// Use the KeyConditionExpression parameter to provide a specific value for
// the partition key. The Query operation will return all of the items from
// the table or index with that partition key value. You can optionally narrow
// the scope of the Query operation by specifying a sort key value and a comparison
// operator in KeyConditionExpression. To further refine the Query results,
// you can optionally provide a FilterExpression. A FilterExpression determines
// which items within the results should be returned to you. All of the other
// results are discarded.
//
// A Query operation always returns a result set. If no matching items are found,
// the result set will be empty. Queries that do not return results consume
// the minimum number of read capacity units for that type of read operation.
//
// DynamoDB calculates the number of read capacity units consumed based on item
// size, not on the amount of data that is returned to an application. The number
// of capacity units consumed will be the same whether you request all of the
// attributes (the default behavior) or just some of them (using a projection
// expression). The number will also be the same whether or not you use a FilterExpression.
//
// Query results are always sorted by the sort key value. If the data type of
// the sort key is Number, the results are returned in numeric order; otherwise,
// the results are returned in order of UTF-8 bytes. By default, the sort order
// is ascending. To reverse the order, set the ScanIndexForward parameter to
// false.
//
// A single Query operation will read up to the maximum number of items set
// (if using the Limit parameter) or a maximum of 1 MB of data and then apply
// any filtering to the results using FilterExpression. If LastEvaluatedKey
// is present in the response, you will need to paginate the result set. For
// more information, see Paginating the Results (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Query.html#Query.Pagination)
// in the Amazon DynamoDB Developer Guide.
//
// FilterExpression is applied after a Query finishes, but before the results
// are returned. A FilterExpression cannot contain partition key or sort key
// attributes. You need to specify those attributes in the KeyConditionExpression.
//
// A Query operation can return an empty result set and a LastEvaluatedKey if
// all the items read for the page of results are filtered out.
//
// You can query a table, a local secondary index, or a global secondary index.
// For a query on a table or on a local secondary index, you can set the ConsistentRead
// parameter to true and obtain a strongly consistent result. Global secondary
// indexes support eventually consistent reads only, so do not specify ConsistentRead
// when querying a global secondary index.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation Query for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeProvisionedThroughputExceededException "ProvisionedThroughputExceededException"
//   Your request rate is too high. The AWS SDKs for DynamoDB automatically retry
//   requests that receive this exception. Your request is eventually successful,
//   unless your retry queue is too large to finish. Reduce the frequency of requests
//   and use exponential backoff. For more information, go to Error Retries and
//   Exponential Backoff (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff)
//   in the Amazon DynamoDB Developer Guide.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeRequestLimitExceeded "RequestLimitExceeded"
//   Throughput exceeds the current throughput limit for your account. Please
//   contact AWS Support at AWS Support (https://aws.amazon.com/support) to request
//   a limit increase.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Query
func (c *DynamoDB) Query(input *QueryInput) (*QueryOutput, error) {
	req, out := c.QueryRequest(input)
	return out, req.Send()
}

// QueryWithContext is the same as Query with the addition of
// the ability to pass a context and additional request options.
//
// See Query for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) QueryWithContext(ctx aws.Context, input *QueryInput, opts ...request.Option) (*QueryOutput, error) {
	req, out := c.QueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// QueryPages iterates over the pages of a Query operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See Query method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a Query operation.
//    pageNum := 0
//    err := client.QueryPages(params,
//        func(page *dynamodb.QueryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DynamoDB) QueryPages(input *QueryInput, fn func(*QueryOutput, bool) bool) error {
	return c.QueryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// QueryPagesWithContext same as QueryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) QueryPagesWithContext(ctx aws.Context, input *QueryInput, fn func(*QueryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *QueryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.QueryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*QueryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opRestoreTableFromBackup = "RestoreTableFromBackup"

// RestoreTableFromBackupRequest generates a "aws/request.Request" representing the
// client's request for the RestoreTableFromBackup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreTableFromBackup for more information on using the RestoreTableFromBackup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestoreTableFromBackupRequest method.
//    req, resp := client.RestoreTableFromBackupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/RestoreTableFromBackup
func (c *DynamoDB) RestoreTableFromBackupRequest(input *RestoreTableFromBackupInput) (req *request.Request, output *RestoreTableFromBackupOutput) {
	op := &request.Operation{
		Name:       opRestoreTableFromBackup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreTableFromBackupInput{}
	}

	output = &RestoreTableFromBackupOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// RestoreTableFromBackup API operation for Amazon DynamoDB.
//
// Creates a new table from an existing backup. Any number of users can execute
// up to 4 concurrent restores (any type of restore) in a given account.
//
// You can call RestoreTableFromBackup at a maximum rate of 10 times per second.
//
// You must manually set up the following on the restored table:
//
//    * Auto scaling policies
//
//    * IAM policies
//
//    * Amazon CloudWatch metrics and alarms
//
//    * Tags
//
//    * Stream settings
//
//    * Time to Live (TTL) settings
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation RestoreTableFromBackup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTableAlreadyExistsException "TableAlreadyExistsException"
//   A target table with the specified name already exists.
//
//   * ErrCodeTableInUseException "TableInUseException"
//   A target table with the specified name is either being created or deleted.
//
//   * ErrCodeBackupNotFoundException "BackupNotFoundException"
//   Backup not found for the given BackupARN.
//
//   * ErrCodeBackupInUseException "BackupInUseException"
//   There is another ongoing conflicting backup control plane operation on the
//   table. The backup is either being created, deleted or restored to a table.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   There is no limit to the number of daily on-demand backups that can be taken.
//
//   Up to 50 simultaneous table operations are allowed per account. These operations
//   include CreateTable, UpdateTable, DeleteTable,UpdateTimeToLive, RestoreTableFromBackup,
//   and RestoreTableToPointInTime.
//
//   The only exception is when you are creating a table with one or more secondary
//   indexes. You can have up to 25 such requests running at a time; however,
//   if the table or index specifications are complex, DynamoDB might temporarily
//   reduce the number of concurrent operations.
//
//   There is a soft account limit of 256 tables.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/RestoreTableFromBackup
func (c *DynamoDB) RestoreTableFromBackup(input *RestoreTableFromBackupInput) (*RestoreTableFromBackupOutput, error) {
	req, out := c.RestoreTableFromBackupRequest(input)
	return out, req.Send()
}

// RestoreTableFromBackupWithContext is the same as RestoreTableFromBackup with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreTableFromBackup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) RestoreTableFromBackupWithContext(ctx aws.Context, input *RestoreTableFromBackupInput, opts ...request.Option) (*RestoreTableFromBackupOutput, error) {
	req, out := c.RestoreTableFromBackupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreTableToPointInTime = "RestoreTableToPointInTime"

// RestoreTableToPointInTimeRequest generates a "aws/request.Request" representing the
// client's request for the RestoreTableToPointInTime operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreTableToPointInTime for more information on using the RestoreTableToPointInTime
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestoreTableToPointInTimeRequest method.
//    req, resp := client.RestoreTableToPointInTimeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/RestoreTableToPointInTime
func (c *DynamoDB) RestoreTableToPointInTimeRequest(input *RestoreTableToPointInTimeInput) (req *request.Request, output *RestoreTableToPointInTimeOutput) {
	op := &request.Operation{
		Name:       opRestoreTableToPointInTime,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreTableToPointInTimeInput{}
	}

	output = &RestoreTableToPointInTimeOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// RestoreTableToPointInTime API operation for Amazon DynamoDB.
//
// Restores the specified table to the specified point in time within EarliestRestorableDateTime
// and LatestRestorableDateTime. You can restore your table to any point in
// time during the last 35 days. Any number of users can execute up to 4 concurrent
// restores (any type of restore) in a given account.
//
// When you restore using point in time recovery, DynamoDB restores your table
// data to the state based on the selected date and time (day:hour:minute:second)
// to a new table.
//
// Along with data, the following are also included on the new restored table
// using point in time recovery:
//
//    * Global secondary indexes (GSIs)
//
//    * Local secondary indexes (LSIs)
//
//    * Provisioned read and write capacity
//
//    * Encryption settings All these settings come from the current settings
//    of the source table at the time of restore.
//
// You must manually set up the following on the restored table:
//
//    * Auto scaling policies
//
//    * IAM policies
//
//    * Amazon CloudWatch metrics and alarms
//
//    * Tags
//
//    * Stream settings
//
//    * Time to Live (TTL) settings
//
//    * Point in time recovery settings
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation RestoreTableToPointInTime for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTableAlreadyExistsException "TableAlreadyExistsException"
//   A target table with the specified name already exists.
//
//   * ErrCodeTableNotFoundException "TableNotFoundException"
//   A source table with the name TableName does not currently exist within the
//   subscriber's account.
//
//   * ErrCodeTableInUseException "TableInUseException"
//   A target table with the specified name is either being created or deleted.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   There is no limit to the number of daily on-demand backups that can be taken.
//
//   Up to 50 simultaneous table operations are allowed per account. These operations
//   include CreateTable, UpdateTable, DeleteTable,UpdateTimeToLive, RestoreTableFromBackup,
//   and RestoreTableToPointInTime.
//
//   The only exception is when you are creating a table with one or more secondary
//   indexes. You can have up to 25 such requests running at a time; however,
//   if the table or index specifications are complex, DynamoDB might temporarily
//   reduce the number of concurrent operations.
//
//   There is a soft account limit of 256 tables.
//
//   * ErrCodeInvalidRestoreTimeException "InvalidRestoreTimeException"
//   An invalid restore time was specified. RestoreDateTime must be between EarliestRestorableDateTime
//   and LatestRestorableDateTime.
//
//   * ErrCodePointInTimeRecoveryUnavailableException "PointInTimeRecoveryUnavailableException"
//   Point in time recovery has not yet been enabled for this source table.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/RestoreTableToPointInTime
func (c *DynamoDB) RestoreTableToPointInTime(input *RestoreTableToPointInTimeInput) (*RestoreTableToPointInTimeOutput, error) {
	req, out := c.RestoreTableToPointInTimeRequest(input)
	return out, req.Send()
}

// RestoreTableToPointInTimeWithContext is the same as RestoreTableToPointInTime with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreTableToPointInTime for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) RestoreTableToPointInTimeWithContext(ctx aws.Context, input *RestoreTableToPointInTimeInput, opts ...request.Option) (*RestoreTableToPointInTimeOutput, error) {
	req, out := c.RestoreTableToPointInTimeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opScan = "Scan"

// ScanRequest generates a "aws/request.Request" representing the
// client's request for the Scan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Scan for more information on using the Scan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ScanRequest method.
//    req, resp := client.ScanRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Scan
func (c *DynamoDB) ScanRequest(input *ScanInput) (req *request.Request, output *ScanOutput) {
	op := &request.Operation{
		Name:       opScan,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"ExclusiveStartKey"},
			OutputTokens:    []string{"LastEvaluatedKey"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ScanInput{}
	}

	output = &ScanOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// Scan API operation for Amazon DynamoDB.
//
// The Scan operation returns one or more items and item attributes by accessing
// every item in a table or a secondary index. To have DynamoDB return fewer
// items, you can provide a FilterExpression operation.
//
// If the total number of scanned items exceeds the maximum dataset size limit
// of 1 MB, the scan stops and results are returned to the user as a LastEvaluatedKey
// value to continue the scan in a subsequent operation. The results also include
// the number of items exceeding the limit. A scan can result in no table data
// meeting the filter criteria.
//
// A single Scan operation reads up to the maximum number of items set (if using
// the Limit parameter) or a maximum of 1 MB of data and then apply any filtering
// to the results using FilterExpression. If LastEvaluatedKey is present in
// the response, you need to paginate the result set. For more information,
// see Paginating the Results (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Scan.html#Scan.Pagination)
// in the Amazon DynamoDB Developer Guide.
//
// Scan operations proceed sequentially; however, for faster performance on
// a large table or secondary index, applications can request a parallel Scan
// operation by providing the Segment and TotalSegments parameters. For more
// information, see Parallel Scan (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Scan.html#Scan.ParallelScan)
// in the Amazon DynamoDB Developer Guide.
//
// Scan uses eventually consistent reads when accessing the data in a table;
// therefore, the result set might not include the changes to data in the table
// immediately before the operation began. If you need a consistent copy of
// the data, as of the time that the Scan begins, you can set the ConsistentRead
// parameter to true.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation Scan for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeProvisionedThroughputExceededException "ProvisionedThroughputExceededException"
//   Your request rate is too high. The AWS SDKs for DynamoDB automatically retry
//   requests that receive this exception. Your request is eventually successful,
//   unless your retry queue is too large to finish. Reduce the frequency of requests
//   and use exponential backoff. For more information, go to Error Retries and
//   Exponential Backoff (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff)
//   in the Amazon DynamoDB Developer Guide.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeRequestLimitExceeded "RequestLimitExceeded"
//   Throughput exceeds the current throughput limit for your account. Please
//   contact AWS Support at AWS Support (https://aws.amazon.com/support) to request
//   a limit increase.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Scan
func (c *DynamoDB) Scan(input *ScanInput) (*ScanOutput, error) {
	req, out := c.ScanRequest(input)
	return out, req.Send()
}

// ScanWithContext is the same as Scan with the addition of
// the ability to pass a context and additional request options.
//
// See Scan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) ScanWithContext(ctx aws.Context, input *ScanInput, opts ...request.Option) (*ScanOutput, error) {
	req, out := c.ScanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ScanPages iterates over the pages of a Scan operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See Scan method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a Scan operation.
//    pageNum := 0
//    err := client.ScanPages(params,
//        func(page *dynamodb.ScanOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DynamoDB) ScanPages(input *ScanInput, fn func(*ScanOutput, bool) bool) error {
	return c.ScanPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ScanPagesWithContext same as ScanPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) ScanPagesWithContext(ctx aws.Context, input *ScanInput, fn func(*ScanOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ScanInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ScanRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ScanOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TagResource
func (c *DynamoDB) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// TagResource API operation for Amazon DynamoDB.
//
// Associate a set of tags with an Amazon DynamoDB resource. You can then activate
// these user-defined tags so that they appear on the Billing and Cost Management
// console for cost allocation tracking. You can call TagResource up to five
// times per second, per account.
//
// For an overview on tagging DynamoDB resources, see Tagging for DynamoDB (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html)
// in the Amazon DynamoDB Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation TagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   There is no limit to the number of daily on-demand backups that can be taken.
//
//   Up to 50 simultaneous table operations are allowed per account. These operations
//   include CreateTable, UpdateTable, DeleteTable,UpdateTimeToLive, RestoreTableFromBackup,
//   and RestoreTableToPointInTime.
//
//   The only exception is when you are creating a table with one or more secondary
//   indexes. You can have up to 25 such requests running at a time; however,
//   if the table or index specifications are complex, DynamoDB might temporarily
//   reduce the number of concurrent operations.
//
//   There is a soft account limit of 256 tables.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The operation conflicts with the resource's availability. For example, you
//   attempted to recreate an existing table, or tried to delete a table currently
//   in the CREATING state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TagResource
func (c *DynamoDB) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTransactGetItems = "TransactGetItems"

// TransactGetItemsRequest generates a "aws/request.Request" representing the
// client's request for the TransactGetItems operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TransactGetItems for more information on using the TransactGetItems
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TransactGetItemsRequest method.
//    req, resp := client.TransactGetItemsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TransactGetItems
func (c *DynamoDB) TransactGetItemsRequest(input *TransactGetItemsInput) (req *request.Request, output *TransactGetItemsOutput) {
	op := &request.Operation{
		Name:       opTransactGetItems,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TransactGetItemsInput{}
	}

	output = &TransactGetItemsOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// TransactGetItems API operation for Amazon DynamoDB.
//
// TransactGetItems is a synchronous operation that atomically retrieves multiple
// items from one or more tables (but not from indexes) in a single account
// and Region. A TransactGetItems call can contain up to 25 TransactGetItem
// objects, each of which contains a Get structure that specifies an item to
// retrieve from a table in the account and Region. A call to TransactGetItems
// cannot retrieve items from tables in more than one AWS account or Region.
// The aggregate size of the items in the transaction cannot exceed 4 MB.
//
// DynamoDB rejects the entire TransactGetItems request if any of the following
// is true:
//
//    * A conflicting operation is in the process of updating an item to be
//    read.
//
//    * There is insufficient provisioned capacity for the transaction to be
//    completed.
//
//    * There is a user error, such as an invalid data format.
//
//    * The aggregate size of the items in the transaction cannot exceed 4 MB.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation TransactGetItems for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeTransactionCanceledException "TransactionCanceledException"
//   The entire transaction request was canceled.
//
//   DynamoDB cancels a TransactWriteItems request under the following circumstances:
//
//      * A condition in one of the condition expressions is not met.
//
//      * A table in the TransactWriteItems request is in a different account
//      or region.
//
//      * More than one action in the TransactWriteItems operation targets the
//      same item.
//
//      * There is insufficient provisioned capacity for the transaction to be
//      completed.
//
//      * An item size becomes too large (larger than 400 KB), or a local secondary
//      index (LSI) becomes too large, or a similar validation error occurs because
//      of changes made by the transaction.
//
//      * There is a user error, such as an invalid data format.
//
//   DynamoDB cancels a TransactGetItems request under the following circumstances:
//
//      * There is an ongoing TransactGetItems operation that conflicts with a
//      concurrent PutItem, UpdateItem, DeleteItem or TransactWriteItems request.
//      In this case the TransactGetItems operation fails with a TransactionCanceledException.
//
//      * A table in the TransactGetItems request is in a different account or
//      region.
//
//      * There is insufficient provisioned capacity for the transaction to be
//      completed.
//
//      * There is a user error, such as an invalid data format.
//
//   If using Java, DynamoDB lists the cancellation reasons on the CancellationReasons
//   property. This property is not set for other languages. Transaction cancellation
//   reasons are ordered in the order of requested items, if an item has no error
//   it will have NONE code and Null message.
//
//   Cancellation reason codes and possible error messages:
//
//      * No Errors: Code: NONE Message: null
//
//      * Conditional Check Failed: Code: ConditionalCheckFailed Message: The
//      conditional request failed.
//
//      * Item Collection Size Limit Exceeded: Code: ItemCollectionSizeLimitExceeded
//      Message: Collection size exceeded.
//
//      * Transaction Conflict: Code: TransactionConflict Message: Transaction
//      is ongoing for the item.
//
//      * Provisioned Throughput Exceeded: Code: ProvisionedThroughputExceeded
//      Messages: The level of configured provisioned throughput for the table
//      was exceeded. Consider increasing your provisioning level with the UpdateTable
//      API. This Message is received when provisioned throughput is exceeded
//      is on a provisioned DynamoDB table. The level of configured provisioned
//      throughput for one or more global secondary indexes of the table was exceeded.
//      Consider increasing your provisioning level for the under-provisioned
//      global secondary indexes with the UpdateTable API. This message is returned
//      when provisioned throughput is exceeded is on a provisioned GSI.
//
//      * Throttling Error: Code: ThrottlingError Messages: Throughput exceeds
//      the current capacity of your table or index. DynamoDB is automatically
//      scaling your table or index so please try again shortly. If exceptions
//      persist, check if you have a hot key: https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/bp-partition-key-design.html.
//      This message is returned when writes get throttled on an On-Demand table
//      as DynamoDB is automatically scaling the table. Throughput exceeds the
//      current capacity for one or more global secondary indexes. DynamoDB is
//      automatically scaling your index so please try again shortly. This message
//      is returned when when writes get throttled on an On-Demand GSI as DynamoDB
//      is automatically scaling the GSI.
//
//      * Validation Error: Code: ValidationError Messages: One or more parameter
//      values were invalid. The update expression attempted to update the secondary
//      index key beyond allowed size limits. The update expression attempted
//      to update the secondary index key to unsupported type. An operand in the
//      update expression has an incorrect data type. Item size to update has
//      exceeded the maximum allowed size. Number overflow. Attempting to store
//      a number with magnitude larger than supported range. Type mismatch for
//      attribute to update. Nesting Levels have exceeded supported limits. The
//      document path provided in the update expression is invalid for update.
//      The provided expression refers to an attribute that does not exist in
//      the item.
//
//   * ErrCodeProvisionedThroughputExceededException "ProvisionedThroughputExceededException"
//   Your request rate is too high. The AWS SDKs for DynamoDB automatically retry
//   requests that receive this exception. Your request is eventually successful,
//   unless your retry queue is too large to finish. Reduce the frequency of requests
//   and use exponential backoff. For more information, go to Error Retries and
//   Exponential Backoff (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff)
//   in the Amazon DynamoDB Developer Guide.
//
//   * ErrCodeRequestLimitExceeded "RequestLimitExceeded"
//   Throughput exceeds the current throughput limit for your account. Please
//   contact AWS Support at AWS Support (https://aws.amazon.com/support) to request
//   a limit increase.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TransactGetItems
func (c *DynamoDB) TransactGetItems(input *TransactGetItemsInput) (*TransactGetItemsOutput, error) {
	req, out := c.TransactGetItemsRequest(input)
	return out, req.Send()
}

// TransactGetItemsWithContext is the same as TransactGetItems with the addition of
// the ability to pass a context and additional request options.
//
// See TransactGetItems for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) TransactGetItemsWithContext(ctx aws.Context, input *TransactGetItemsInput, opts ...request.Option) (*TransactGetItemsOutput, error) {
	req, out := c.TransactGetItemsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTransactWriteItems = "TransactWriteItems"

// TransactWriteItemsRequest generates a "aws/request.Request" representing the
// client's request for the TransactWriteItems operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TransactWriteItems for more information on using the TransactWriteItems
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TransactWriteItemsRequest method.
//    req, resp := client.TransactWriteItemsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TransactWriteItems
func (c *DynamoDB) TransactWriteItemsRequest(input *TransactWriteItemsInput) (req *request.Request, output *TransactWriteItemsOutput) {
	op := &request.Operation{
		Name:       opTransactWriteItems,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TransactWriteItemsInput{}
	}

	output = &TransactWriteItemsOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// TransactWriteItems API operation for Amazon DynamoDB.
//
// TransactWriteItems is a synchronous write operation that groups up to 25
// action requests. These actions can target items in different tables, but
// not in different AWS accounts or Regions, and no two actions can target the
// same item. For example, you cannot both ConditionCheck and Update the same
// item. The aggregate size of the items in the transaction cannot exceed 4
// MB.
//
// The actions are completed atomically so that either all of them succeed,
// or all of them fail. They are defined by the following objects:
//
//    * Put — Initiates a PutItem operation to write a new item. This structure
//    specifies the primary key of the item to be written, the name of the table
//    to write it in, an optional condition expression that must be satisfied
//    for the write to succeed, a list of the item's attributes, and a field
//    indicating whether to retrieve the item's attributes if the condition
//    is not met.
//
//    * Update — Initiates an UpdateItem operation to update an existing item.
//    This structure specifies the primary key of the item to be updated, the
//    name of the table where it resides, an optional condition expression that
//    must be satisfied for the update to succeed, an expression that defines
//    one or more attributes to be updated, and a field indicating whether to
//    retrieve the item's attributes if the condition is not met.
//
//    * Delete — Initiates a DeleteItem operation to delete an existing item.
//    This structure specifies the primary key of the item to be deleted, the
//    name of the table where it resides, an optional condition expression that
//    must be satisfied for the deletion to succeed, and a field indicating
//    whether to retrieve the item's attributes if the condition is not met.
//
//    * ConditionCheck — Applies a condition to an item that is not being
//    modified by the transaction. This structure specifies the primary key
//    of the item to be checked, the name of the table where it resides, a condition
//    expression that must be satisfied for the transaction to succeed, and
//    a field indicating whether to retrieve the item's attributes if the condition
//    is not met.
//
// DynamoDB rejects the entire TransactWriteItems request if any of the following
// is true:
//
//    * A condition in one of the condition expressions is not met.
//
//    * An ongoing operation is in the process of updating the same item.
//
//    * There is insufficient provisioned capacity for the transaction to be
//    completed.
//
//    * An item size becomes too large (bigger than 400 KB), a local secondary
//    index (LSI) becomes too large, or a similar validation error occurs because
//    of changes made by the transaction.
//
//    * The aggregate size of the items in the transaction exceeds 4 MB.
//
//    * There is a user error, such as an invalid data format.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation TransactWriteItems for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeTransactionCanceledException "TransactionCanceledException"
//   The entire transaction request was canceled.
//
//   DynamoDB cancels a TransactWriteItems request under the following circumstances:
//
//      * A condition in one of the condition expressions is not met.
//
//      * A table in the TransactWriteItems request is in a different account
//      or region.
//
//      * More than one action in the TransactWriteItems operation targets the
//      same item.
//
//      * There is insufficient provisioned capacity for the transaction to be
//      completed.
//
//      * An item size becomes too large (larger than 400 KB), or a local secondary
//      index (LSI) becomes too large, or a similar validation error occurs because
//      of changes made by the transaction.
//
//      * There is a user error, such as an invalid data format.
//
//   DynamoDB cancels a TransactGetItems request under the following circumstances:
//
//      * There is an ongoing TransactGetItems operation that conflicts with a
//      concurrent PutItem, UpdateItem, DeleteItem or TransactWriteItems request.
//      In this case the TransactGetItems operation fails with a TransactionCanceledException.
//
//      * A table in the TransactGetItems request is in a different account or
//      region.
//
//      * There is insufficient provisioned capacity for the transaction to be
//      completed.
//
//      * There is a user error, such as an invalid data format.
//
//   If using Java, DynamoDB lists the cancellation reasons on the CancellationReasons
//   property. This property is not set for other languages. Transaction cancellation
//   reasons are ordered in the order of requested items, if an item has no error
//   it will have NONE code and Null message.
//
//   Cancellation reason codes and possible error messages:
//
//      * No Errors: Code: NONE Message: null
//
//      * Conditional Check Failed: Code: ConditionalCheckFailed Message: The
//      conditional request failed.
//
//      * Item Collection Size Limit Exceeded: Code: ItemCollectionSizeLimitExceeded
//      Message: Collection size exceeded.
//
//      * Transaction Conflict: Code: TransactionConflict Message: Transaction
//      is ongoing for the item.
//
//      * Provisioned Throughput Exceeded: Code: ProvisionedThroughputExceeded
//      Messages: The level of configured provisioned throughput for the table
//      was exceeded. Consider increasing your provisioning level with the UpdateTable
//      API. This Message is received when provisioned throughput is exceeded
//      is on a provisioned DynamoDB table. The level of configured provisioned
//      throughput for one or more global secondary indexes of the table was exceeded.
//      Consider increasing your provisioning level for the under-provisioned
//      global secondary indexes with the UpdateTable API. This message is returned
//      when provisioned throughput is exceeded is on a provisioned GSI.
//
//      * Throttling Error: Code: ThrottlingError Messages: Throughput exceeds
//      the current capacity of your table or index. DynamoDB is automatically
//      scaling your table or index so please try again shortly. If exceptions
//      persist, check if you have a hot key: https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/bp-partition-key-design.html.
//      This message is returned when writes get throttled on an On-Demand table
//      as DynamoDB is automatically scaling the table. Throughput exceeds the
//      current capacity for one or more global secondary indexes. DynamoDB is
//      automatically scaling your index so please try again shortly. This message
//      is returned when when writes get throttled on an On-Demand GSI as DynamoDB
//      is automatically scaling the GSI.
//
//      * Validation Error: Code: ValidationError Messages: One or more parameter
//      values were invalid. The update expression attempted to update the secondary
//      index key beyond allowed size limits. The update expression attempted
//      to update the secondary index key to unsupported type. An operand in the
//      update expression has an incorrect data type. Item size to update has
//      exceeded the maximum allowed size. Number overflow. Attempting to store
//      a number with magnitude larger than supported range. Type mismatch for
//      attribute to update. Nesting Levels have exceeded supported limits. The
//      document path provided in the update expression is invalid for update.
//      The provided expression refers to an attribute that does not exist in
//      the item.
//
//   * ErrCodeTransactionInProgressException "TransactionInProgressException"
//   The transaction with the given request token is already in progress.
//
//   * ErrCodeIdempotentParameterMismatchException "IdempotentParameterMismatchException"
//   DynamoDB rejected the request because you retried a request with a different
//   payload but with an idempotent token that was already used.
//
//   * ErrCodeProvisionedThroughputExceededException "ProvisionedThroughputExceededException"
//   Your request rate is too high. The AWS SDKs for DynamoDB automatically retry
//   requests that receive this exception. Your request is eventually successful,
//   unless your retry queue is too large to finish. Reduce the frequency of requests
//   and use exponential backoff. For more information, go to Error Retries and
//   Exponential Backoff (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff)
//   in the Amazon DynamoDB Developer Guide.
//
//   * ErrCodeRequestLimitExceeded "RequestLimitExceeded"
//   Throughput exceeds the current throughput limit for your account. Please
//   contact AWS Support at AWS Support (https://aws.amazon.com/support) to request
//   a limit increase.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TransactWriteItems
func (c *DynamoDB) TransactWriteItems(input *TransactWriteItemsInput) (*TransactWriteItemsOutput, error) {
	req, out := c.TransactWriteItemsRequest(input)
	return out, req.Send()
}

// TransactWriteItemsWithContext is the same as TransactWriteItems with the addition of
// the ability to pass a context and additional request options.
//
// See TransactWriteItems for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) TransactWriteItemsWithContext(ctx aws.Context, input *TransactWriteItemsInput, opts ...request.Option) (*TransactWriteItemsOutput, error) {
	req, out := c.TransactWriteItemsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UntagResource
func (c *DynamoDB) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// UntagResource API operation for Amazon DynamoDB.
//
// Removes the association of tags from an Amazon DynamoDB resource. You can
// call UntagResource up to five times per second, per account.
//
// For an overview on tagging DynamoDB resources, see Tagging for DynamoDB (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html)
// in the Amazon DynamoDB Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation UntagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   There is no limit to the number of daily on-demand backups that can be taken.
//
//   Up to 50 simultaneous table operations are allowed per account. These operations
//   include CreateTable, UpdateTable, DeleteTable,UpdateTimeToLive, RestoreTableFromBackup,
//   and RestoreTableToPointInTime.
//
//   The only exception is when you are creating a table with one or more secondary
//   indexes. You can have up to 25 such requests running at a time; however,
//   if the table or index specifications are complex, DynamoDB might temporarily
//   reduce the number of concurrent operations.
//
//   There is a soft account limit of 256 tables.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The operation conflicts with the resource's availability. For example, you
//   attempted to recreate an existing table, or tried to delete a table currently
//   in the CREATING state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UntagResource
func (c *DynamoDB) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateContinuousBackups = "UpdateContinuousBackups"

// UpdateContinuousBackupsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateContinuousBackups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateContinuousBackups for more information on using the UpdateContinuousBackups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateContinuousBackupsRequest method.
//    req, resp := client.UpdateContinuousBackupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateContinuousBackups
func (c *DynamoDB) UpdateContinuousBackupsRequest(input *UpdateContinuousBackupsInput) (req *request.Request, output *UpdateContinuousBackupsOutput) {
	op := &request.Operation{
		Name:       opUpdateContinuousBackups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateContinuousBackupsInput{}
	}

	output = &UpdateContinuousBackupsOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// UpdateContinuousBackups API operation for Amazon DynamoDB.
//
// UpdateContinuousBackups enables or disables point in time recovery for the
// specified table. A successful UpdateContinuousBackups call returns the current
// ContinuousBackupsDescription. Continuous backups are ENABLED on all tables
// at table creation. If point in time recovery is enabled, PointInTimeRecoveryStatus
// will be set to ENABLED.
//
// Once continuous backups and point in time recovery are enabled, you can restore
// to any point in time within EarliestRestorableDateTime and LatestRestorableDateTime.
//
// LatestRestorableDateTime is typically 5 minutes before the current time.
// You can restore your table to any point in time during the last 35 days.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation UpdateContinuousBackups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTableNotFoundException "TableNotFoundException"
//   A source table with the name TableName does not currently exist within the
//   subscriber's account.
//
//   * ErrCodeContinuousBackupsUnavailableException "ContinuousBackupsUnavailableException"
//   Backups have not yet been enabled for this table.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateContinuousBackups
func (c *DynamoDB) UpdateContinuousBackups(input *UpdateContinuousBackupsInput) (*UpdateContinuousBackupsOutput, error) {
	req, out := c.UpdateContinuousBackupsRequest(input)
	return out, req.Send()
}

// UpdateContinuousBackupsWithContext is the same as UpdateContinuousBackups with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateContinuousBackups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) UpdateContinuousBackupsWithContext(ctx aws.Context, input *UpdateContinuousBackupsInput, opts ...request.Option) (*UpdateContinuousBackupsOutput, error) {
	req, out := c.UpdateContinuousBackupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateContributorInsights = "UpdateContributorInsights"

// UpdateContributorInsightsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateContributorInsights operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateContributorInsights for more information on using the UpdateContributorInsights
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateContributorInsightsRequest method.
//    req, resp := client.UpdateContributorInsightsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateContributorInsights
func (c *DynamoDB) UpdateContributorInsightsRequest(input *UpdateContributorInsightsInput) (req *request.Request, output *UpdateContributorInsightsOutput) {
	op := &request.Operation{
		Name:       opUpdateContributorInsights,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateContributorInsightsInput{}
	}

	output = &UpdateContributorInsightsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateContributorInsights API operation for Amazon DynamoDB.
//
// Updates the status for contributor insights for a specific table or index.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation UpdateContributorInsights for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateContributorInsights
func (c *DynamoDB) UpdateContributorInsights(input *UpdateContributorInsightsInput) (*UpdateContributorInsightsOutput, error) {
	req, out := c.UpdateContributorInsightsRequest(input)
	return out, req.Send()
}

// UpdateContributorInsightsWithContext is the same as UpdateContributorInsights with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateContributorInsights for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) UpdateContributorInsightsWithContext(ctx aws.Context, input *UpdateContributorInsightsInput, opts ...request.Option) (*UpdateContributorInsightsOutput, error) {
	req, out := c.UpdateContributorInsightsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGlobalTable = "UpdateGlobalTable"

// UpdateGlobalTableRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGlobalTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGlobalTable for more information on using the UpdateGlobalTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGlobalTableRequest method.
//    req, resp := client.UpdateGlobalTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateGlobalTable
func (c *DynamoDB) UpdateGlobalTableRequest(input *UpdateGlobalTableInput) (req *request.Request, output *UpdateGlobalTableOutput) {
	op := &request.Operation{
		Name:       opUpdateGlobalTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGlobalTableInput{}
	}

	output = &UpdateGlobalTableOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// UpdateGlobalTable API operation for Amazon DynamoDB.
//
// Adds or removes replicas in the specified global table. The global table
// must already exist to be able to use this operation. Any replica to be added
// must be empty, have the same name as the global table, have the same key
// schema, have DynamoDB Streams enabled, and have the same provisioned and
// maximum write capacity units.
//
// Although you can use UpdateGlobalTable to add replicas and remove replicas
// in a single request, for simplicity we recommend that you issue separate
// requests for adding or removing replicas.
//
// If global secondary indexes are specified, then the following conditions
// must also be met:
//
//    * The global secondary indexes must have the same name.
//
//    * The global secondary indexes must have the same hash key and sort key
//    (if present).
//
//    * The global secondary indexes must have the same provisioned and maximum
//    write capacity units.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation UpdateGlobalTable for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeGlobalTableNotFoundException "GlobalTableNotFoundException"
//   The specified global table does not exist.
//
//   * ErrCodeReplicaAlreadyExistsException "ReplicaAlreadyExistsException"
//   The specified replica is already part of the global table.
//
//   * ErrCodeReplicaNotFoundException "ReplicaNotFoundException"
//   The specified replica is no longer part of the global table.
//
//   * ErrCodeTableNotFoundException "TableNotFoundException"
//   A source table with the name TableName does not currently exist within the
//   subscriber's account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateGlobalTable
func (c *DynamoDB) UpdateGlobalTable(input *UpdateGlobalTableInput) (*UpdateGlobalTableOutput, error) {
	req, out := c.UpdateGlobalTableRequest(input)
	return out, req.Send()
}

// UpdateGlobalTableWithContext is the same as UpdateGlobalTable with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGlobalTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) UpdateGlobalTableWithContext(ctx aws.Context, input *UpdateGlobalTableInput, opts ...request.Option) (*UpdateGlobalTableOutput, error) {
	req, out := c.UpdateGlobalTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGlobalTableSettings = "UpdateGlobalTableSettings"

// UpdateGlobalTableSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGlobalTableSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGlobalTableSettings for more information on using the UpdateGlobalTableSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGlobalTableSettingsRequest method.
//    req, resp := client.UpdateGlobalTableSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateGlobalTableSettings
func (c *DynamoDB) UpdateGlobalTableSettingsRequest(input *UpdateGlobalTableSettingsInput) (req *request.Request, output *UpdateGlobalTableSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateGlobalTableSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGlobalTableSettingsInput{}
	}

	output = &UpdateGlobalTableSettingsOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// UpdateGlobalTableSettings API operation for Amazon DynamoDB.
//
// Updates settings for a global table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation UpdateGlobalTableSettings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeGlobalTableNotFoundException "GlobalTableNotFoundException"
//   The specified global table does not exist.
//
//   * ErrCodeReplicaNotFoundException "ReplicaNotFoundException"
//   The specified replica is no longer part of the global table.
//
//   * ErrCodeIndexNotFoundException "IndexNotFoundException"
//   The operation tried to access a nonexistent index.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   There is no limit to the number of daily on-demand backups that can be taken.
//
//   Up to 50 simultaneous table operations are allowed per account. These operations
//   include CreateTable, UpdateTable, DeleteTable,UpdateTimeToLive, RestoreTableFromBackup,
//   and RestoreTableToPointInTime.
//
//   The only exception is when you are creating a table with one or more secondary
//   indexes. You can have up to 25 such requests running at a time; however,
//   if the table or index specifications are complex, DynamoDB might temporarily
//   reduce the number of concurrent operations.
//
//   There is a soft account limit of 256 tables.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The operation conflicts with the resource's availability. For example, you
//   attempted to recreate an existing table, or tried to delete a table currently
//   in the CREATING state.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateGlobalTableSettings
func (c *DynamoDB) UpdateGlobalTableSettings(input *UpdateGlobalTableSettingsInput) (*UpdateGlobalTableSettingsOutput, error) {
	req, out := c.UpdateGlobalTableSettingsRequest(input)
	return out, req.Send()
}

// UpdateGlobalTableSettingsWithContext is the same as UpdateGlobalTableSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGlobalTableSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) UpdateGlobalTableSettingsWithContext(ctx aws.Context, input *UpdateGlobalTableSettingsInput, opts ...request.Option) (*UpdateGlobalTableSettingsOutput, error) {
	req, out := c.UpdateGlobalTableSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateItem = "UpdateItem"

// UpdateItemRequest generates a "aws/request.Request" representing the
// client's request for the UpdateItem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateItem for more information on using the UpdateItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateItemRequest method.
//    req, resp := client.UpdateItemRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateItem
func (c *DynamoDB) UpdateItemRequest(input *UpdateItemInput) (req *request.Request, output *UpdateItemOutput) {
	op := &request.Operation{
		Name:       opUpdateItem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateItemInput{}
	}

	output = &UpdateItemOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// UpdateItem API operation for Amazon DynamoDB.
//
// Edits an existing item's attributes, or adds a new item to the table if it
// does not already exist. You can put, delete, or add attribute values. You
// can also perform a conditional update on an existing item (insert a new attribute
// name-value pair if it doesn't exist, or replace an existing name-value pair
// if it has certain expected attribute values).
//
// You can also return the item's attribute values in the same UpdateItem operation
// using the ReturnValues parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation UpdateItem for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConditionalCheckFailedException "ConditionalCheckFailedException"
//   A condition specified in the operation could not be evaluated.
//
//   * ErrCodeProvisionedThroughputExceededException "ProvisionedThroughputExceededException"
//   Your request rate is too high. The AWS SDKs for DynamoDB automatically retry
//   requests that receive this exception. Your request is eventually successful,
//   unless your retry queue is too large to finish. Reduce the frequency of requests
//   and use exponential backoff. For more information, go to Error Retries and
//   Exponential Backoff (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff)
//   in the Amazon DynamoDB Developer Guide.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeItemCollectionSizeLimitExceededException "ItemCollectionSizeLimitExceededException"
//   An item collection is too large. This exception is only returned for tables
//   that have one or more local secondary indexes.
//
//   * ErrCodeTransactionConflictException "TransactionConflictException"
//   Operation was rejected because there is an ongoing transaction for the item.
//
//   * ErrCodeRequestLimitExceeded "RequestLimitExceeded"
//   Throughput exceeds the current throughput limit for your account. Please
//   contact AWS Support at AWS Support (https://aws.amazon.com/support) to request
//   a limit increase.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateItem
func (c *DynamoDB) UpdateItem(input *UpdateItemInput) (*UpdateItemOutput, error) {
	req, out := c.UpdateItemRequest(input)
	return out, req.Send()
}

// UpdateItemWithContext is the same as UpdateItem with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) UpdateItemWithContext(ctx aws.Context, input *UpdateItemInput, opts ...request.Option) (*UpdateItemOutput, error) {
	req, out := c.UpdateItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTable = "UpdateTable"

// UpdateTableRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTable for more information on using the UpdateTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTableRequest method.
//    req, resp := client.UpdateTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateTable
func (c *DynamoDB) UpdateTableRequest(input *UpdateTableInput) (req *request.Request, output *UpdateTableOutput) {
	op := &request.Operation{
		Name:       opUpdateTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTableInput{}
	}

	output = &UpdateTableOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// UpdateTable API operation for Amazon DynamoDB.
//
// Modifies the provisioned throughput settings, global secondary indexes, or
// DynamoDB Streams settings for a given table.
//
// You can only perform one of the following operations at once:
//
//    * Modify the provisioned throughput settings of the table.
//
//    * Enable or disable DynamoDB Streams on the table.
//
//    * Remove a global secondary index from the table.
//
//    * Create a new global secondary index on the table. After the index begins
//    backfilling, you can use UpdateTable to perform other operations.
//
// UpdateTable is an asynchronous operation; while it is executing, the table
// status changes from ACTIVE to UPDATING. While it is UPDATING, you cannot
// issue another UpdateTable request. When the table returns to the ACTIVE state,
// the UpdateTable operation is complete.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation UpdateTable for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The operation conflicts with the resource's availability. For example, you
//   attempted to recreate an existing table, or tried to delete a table currently
//   in the CREATING state.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   There is no limit to the number of daily on-demand backups that can be taken.
//
//   Up to 50 simultaneous table operations are allowed per account. These operations
//   include CreateTable, UpdateTable, DeleteTable,UpdateTimeToLive, RestoreTableFromBackup,
//   and RestoreTableToPointInTime.
//
//   The only exception is when you are creating a table with one or more secondary
//   indexes. You can have up to 25 such requests running at a time; however,
//   if the table or index specifications are complex, DynamoDB might temporarily
//   reduce the number of concurrent operations.
//
//   There is a soft account limit of 256 tables.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateTable
func (c *DynamoDB) UpdateTable(input *UpdateTableInput) (*UpdateTableOutput, error) {
	req, out := c.UpdateTableRequest(input)
	return out, req.Send()
}

// UpdateTableWithContext is the same as UpdateTable with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) UpdateTableWithContext(ctx aws.Context, input *UpdateTableInput, opts ...request.Option) (*UpdateTableOutput, error) {
	req, out := c.UpdateTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTableReplicaAutoScaling = "UpdateTableReplicaAutoScaling"

// UpdateTableReplicaAutoScalingRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTableReplicaAutoScaling operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTableReplicaAutoScaling for more information on using the UpdateTableReplicaAutoScaling
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTableReplicaAutoScalingRequest method.
//    req, resp := client.UpdateTableReplicaAutoScalingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateTableReplicaAutoScaling
func (c *DynamoDB) UpdateTableReplicaAutoScalingRequest(input *UpdateTableReplicaAutoScalingInput) (req *request.Request, output *UpdateTableReplicaAutoScalingOutput) {
	op := &request.Operation{
		Name:       opUpdateTableReplicaAutoScaling,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTableReplicaAutoScalingInput{}
	}

	output = &UpdateTableReplicaAutoScalingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTableReplicaAutoScaling API operation for Amazon DynamoDB.
//
// Updates auto scaling settings on your global tables at once.
//
// This method only applies to Version 2019.11.21 (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html)
// of global tables.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation UpdateTableReplicaAutoScaling for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The operation conflicts with the resource's availability. For example, you
//   attempted to recreate an existing table, or tried to delete a table currently
//   in the CREATING state.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   There is no limit to the number of daily on-demand backups that can be taken.
//
//   Up to 50 simultaneous table operations are allowed per account. These operations
//   include CreateTable, UpdateTable, DeleteTable,UpdateTimeToLive, RestoreTableFromBackup,
//   and RestoreTableToPointInTime.
//
//   The only exception is when you are creating a table with one or more secondary
//   indexes. You can have up to 25 such requests running at a time; however,
//   if the table or index specifications are complex, DynamoDB might temporarily
//   reduce the number of concurrent operations.
//
//   There is a soft account limit of 256 tables.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateTableReplicaAutoScaling
func (c *DynamoDB) UpdateTableReplicaAutoScaling(input *UpdateTableReplicaAutoScalingInput) (*UpdateTableReplicaAutoScalingOutput, error) {
	req, out := c.UpdateTableReplicaAutoScalingRequest(input)
	return out, req.Send()
}

// UpdateTableReplicaAutoScalingWithContext is the same as UpdateTableReplicaAutoScaling with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTableReplicaAutoScaling for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) UpdateTableReplicaAutoScalingWithContext(ctx aws.Context, input *UpdateTableReplicaAutoScalingInput, opts ...request.Option) (*UpdateTableReplicaAutoScalingOutput, error) {
	req, out := c.UpdateTableReplicaAutoScalingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTimeToLive = "UpdateTimeToLive"

// UpdateTimeToLiveRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTimeToLive operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTimeToLive for more information on using the UpdateTimeToLive
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTimeToLiveRequest method.
//    req, resp := client.UpdateTimeToLiveRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateTimeToLive
func (c *DynamoDB) UpdateTimeToLiveRequest(input *UpdateTimeToLiveInput) (req *request.Request, output *UpdateTimeToLiveOutput) {
	op := &request.Operation{
		Name:       opUpdateTimeToLive,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTimeToLiveInput{}
	}

	output = &UpdateTimeToLiveOutput{}
	req = c.newRequest(op, input, output)
	if aws.BoolValue(req.Config.EnableEndpointDiscovery) {
		de := discovererDescribeEndpoints{
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// UpdateTimeToLive API operation for Amazon DynamoDB.
//
// The UpdateTimeToLive method enables or disables Time to Live (TTL) for the
// specified table. A successful UpdateTimeToLive call returns the current TimeToLiveSpecification.
// It can take up to one hour for the change to fully process. Any additional
// UpdateTimeToLive calls for the same table during this one hour duration result
// in a ValidationException.
//
// TTL compares the current time in epoch time format to the time stored in
// the TTL attribute of an item. If the epoch time value stored in the attribute
// is less than the current time, the item is marked as expired and subsequently
// deleted.
//
// The epoch time format is the number of seconds elapsed since 12:00:00 AM
// January 1, 1970 UTC.
//
// DynamoDB deletes expired items on a best-effort basis to ensure availability
// of throughput for other data operations.
//
// DynamoDB typically deletes expired items within two days of expiration. The
// exact duration within which an item gets deleted after expiration is specific
// to the nature of the workload. Items that have expired and not been deleted
// will still show up in reads, queries, and scans.
//
// As items are deleted, they are removed from any local secondary index and
// global secondary index immediately in the same eventually consistent way
// as a standard delete operation.
//
// For more information, see Time To Live (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/TTL.html)
// in the Amazon DynamoDB Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation UpdateTimeToLive for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The operation conflicts with the resource's availability. For example, you
//   attempted to recreate an existing table, or tried to delete a table currently
//   in the CREATING state.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   There is no limit to the number of daily on-demand backups that can be taken.
//
//   Up to 50 simultaneous table operations are allowed per account. These operations
//   include CreateTable, UpdateTable, DeleteTable,UpdateTimeToLive, RestoreTableFromBackup,
//   and RestoreTableToPointInTime.
//
//   The only exception is when you are creating a table with one or more secondary
//   indexes. You can have up to 25 such requests running at a time; however,
//   if the table or index specifications are complex, DynamoDB might temporarily
//   reduce the number of concurrent operations.
//
//   There is a soft account limit of 256 tables.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateTimeToLive
func (c *DynamoDB) UpdateTimeToLive(input *UpdateTimeToLiveInput) (*UpdateTimeToLiveOutput, error) {
	req, out := c.UpdateTimeToLiveRequest(input)
	return out, req.Send()
}

// UpdateTimeToLiveWithContext is the same as UpdateTimeToLive with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTimeToLive for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) UpdateTimeToLiveWithContext(ctx aws.Context, input *UpdateTimeToLiveInput, opts ...request.Option) (*UpdateTimeToLiveOutput, error) {
	req, out := c.UpdateTimeToLiveRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Contains details of a table archival operation.
type ArchivalSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the backup the table was archived to, when
	// applicable in the archival reason. If you wish to restore this backup to
	// the same table name, you will need to delete the original table.
	ArchivalBackupArn *string `min:"37" type:"string"`

	// The date and time when table archival was initiated by DynamoDB, in UNIX
	// epoch time format.
	ArchivalDateTime *time.Time `type:"timestamp"`

	// The reason DynamoDB archived the table. Currently, the only possible value
	// is:
	//
	//    * INACCESSIBLE_ENCRYPTION_CREDENTIALS - The table was archived due to
	//    the table's AWS KMS key being inaccessible for more than seven days. An
	//    On-Demand backup was created at the archival time.
	ArchivalReason *string `type:"string"`
}

// String returns the string representation
func (s ArchivalSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ArchivalSummary) GoString() string {
	return s.String()
}

// SetArchivalBackupArn sets the ArchivalBackupArn field's value.
func (s *ArchivalSummary) SetArchivalBackupArn(v string) *ArchivalSummary {
	s.ArchivalBackupArn = &v
	return s
}

// SetArchivalDateTime sets the ArchivalDateTime field's value.
func (s *ArchivalSummary) SetArchivalDateTime(v time.Time) *ArchivalSummary {
	s.ArchivalDateTime = &v
	return s
}

// SetArchivalReason sets the ArchivalReason field's value.
func (s *ArchivalSummary) SetArchivalReason(v string) *ArchivalSummary {
	s.ArchivalReason = &v
	return s
}

// Represents an attribute for describing the key schema for the table and indexes.
type AttributeDefinition struct {
	_ struct{} `type:"structure"`

	// A name for the attribute.
	//
	// AttributeName is a required field
	AttributeName *string `min:"1" type:"string" required:"true"`

	// The data type for the attribute, where:
	//
	//    * S - the attribute is of type String
	//
	//    * N - the attribute is of type Number
	//
	//    * B - the attribute is of type Binary
	//
	// AttributeType is a required field
	AttributeType *string `type:"string" required:"true" enum:"ScalarAttributeType"`
}

// String returns the string representation
func (s AttributeDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttributeDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttributeDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttributeDefinition"}
	if s.AttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeName"))
	}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributeName", 1))
	}
	if s.AttributeType == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeName sets the AttributeName field's value.
func (s *AttributeDefinition) SetAttributeName(v string) *AttributeDefinition {
	s.AttributeName = &v
	return s
}

// SetAttributeType sets the AttributeType field's value.
func (s *AttributeDefinition) SetAttributeType(v string) *AttributeDefinition {
	s.AttributeType = &v
	return s
}

// Represents the data for an attribute.
//
// Each attribute value is described as a name-value pair. The name is the data
// type, and the value is the data itself.
//
// For more information, see Data Types (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes)
// in the Amazon DynamoDB Developer Guide.
type AttributeValue struct {
	_ struct{} `type:"structure"`

	// An attribute of type Binary. For example:
	//
	// "B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"
	//
	// B is automatically base64 encoded/decoded by the SDK.
	B []byte `type:"blob"`

	// An attribute of type Boolean. For example:
	//
	// "BOOL": true
	BOOL *bool `type:"boolean"`

	// An attribute of type Binary Set. For example:
	//
	// "BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]
	BS [][]byte `type:"list"`

	// An attribute of type List. For example:
	//
	// "L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]
	L []*AttributeValue `type:"list"`

	// An attribute of type Map. For example:
	//
	// "M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}
	M map[string]*AttributeValue `type:"map"`

	// An attribute of type Number. For example:
	//
	// "N": "123.45"
	//
	// Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
	// across languages and libraries. However, DynamoDB treats them as number type
	// attributes for mathematical operations.
	N *string `type:"string"`

	// An attribute of type Number Set. For example:
	//
	// "NS": ["42.2", "-19", "7.5", "3.14"]
	//
	// Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
	// across languages and libraries. However, DynamoDB treats them as number type
	// attributes for mathematical operations.
	NS []*string `type:"list"`

	// An attribute of type Null. For example:
	//
	// "NULL": true
	NULL *bool `type:"boolean"`

	// An attribute of type String. For example:
	//
	// "S": "Hello"
	S *string `type:"string"`

	// An attribute of type String Set. For example:
	//
	// "SS": ["Giraffe", "Hippo" ,"Zebra"]
	SS []*string `type:"list"`
}

// String returns the string representation
func (s AttributeValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttributeValue) GoString() string {
	return s.String()
}

// SetB sets the B field's value.
func (s *AttributeValue) SetB(v []byte) *AttributeValue {
	s.B = v
	return s
}

// SetBOOL sets the BOOL field's value.
func (s *AttributeValue) SetBOOL(v bool) *AttributeValue {
	s.BOOL = &v
	return s
}

// SetBS sets the BS field's value.
func (s *AttributeValue) SetBS(v [][]byte) *AttributeValue {
	s.BS = v
	return s
}

// SetL sets the L field's value.
func (s *AttributeValue) SetL(v []*AttributeValue) *AttributeValue {
	s.L = v
	return s
}

// SetM sets the M field's value.
func (s *AttributeValue) SetM(v map[string]*AttributeValue) *AttributeValue {
	s.M = v
	return s
}

// SetN sets the N field's value.
func (s *AttributeValue) SetN(v string) *AttributeValue {
	s.N = &v
	return s
}

// SetNS sets the NS field's value.
func (s *AttributeValue) SetNS(v []*string) *AttributeValue {
	s.NS = v
	return s
}

// SetNULL sets the NULL field's value.
func (s *AttributeValue) SetNULL(v bool) *AttributeValue {
	s.NULL = &v
	return s
}

// SetS sets the S field's value.
func (s *AttributeValue) SetS(v string) *AttributeValue {
	s.S = &v
	return s
}

// SetSS sets the SS field's value.
func (s *AttributeValue) SetSS(v []*string) *AttributeValue {
	s.SS = v
	return s
}

// For the UpdateItem operation, represents the attributes to be modified, the
// action to perform on each, and the new value for each.
//
// You cannot use UpdateItem to update any primary key attributes. Instead,
// you will need to delete the item, and then use PutItem to create a new item
// with new attributes.
//
// Attribute values cannot be null; string and binary type attributes must have
// lengths greater than zero; and set type attributes must not be empty. Requests
// with empty values will be rejected with a ValidationException exception.
type AttributeValueUpdate struct {
	_ struct{} `type:"structure"`

	// Specifies how to perform the update. Valid values are PUT (default), DELETE,
	// and ADD. The behavior depends on whether the specified primary key already
	// exists in the table.
	//
	// If an item with the specified Key is found in the table:
	//
	//    * PUT - Adds the specified attribute to the item. If the attribute already
	//    exists, it is replaced by the new value.
	//
	//    * DELETE - If no value is specified, the attribute and its value are removed
	//    from the item. The data type of the specified value must match the existing
	//    value's data type. If a set of values is specified, then those values
	//    are subtracted from the old set. For example, if the attribute value was
	//    the set [a,b,c] and the DELETE action specified [a,c], then the final
	//    attribute value would be [b]. Specifying an empty set is an error.
	//
	//    * ADD - If the attribute does not already exist, then the attribute and
	//    its values are added to the item. If the attribute does exist, then the
	//    behavior of ADD depends on the data type of the attribute: If the existing
	//    attribute is a number, and if Value is also a number, then the Value is
	//    mathematically added to the existing attribute. If Value is a negative
	//    number, then it is subtracted from the existing attribute. If you use
	//    ADD to increment or decrement a number value for an item that doesn't
	//    exist before the update, DynamoDB uses 0 as the initial value. In addition,
	//    if you use ADD to update an existing item, and intend to increment or
	//    decrement an attribute value which does not yet exist, DynamoDB uses 0
	//    as the initial value. For example, suppose that the item you want to update
	//    does not yet have an attribute named itemcount, but you decide to ADD
	//    the number 3 to this attribute anyway, even though it currently does not
	//    exist. DynamoDB will create the itemcount attribute, set its initial value
	//    to 0, and finally add 3 to it. The result will be a new itemcount attribute
	//    in the item, with a value of 3. If the existing data type is a set, and
	//    if the Value is also a set, then the Value is added to the existing set.
	//    (This is a set operation, not mathematical addition.) For example, if
	//    the attribute value was the set [1,2], and the ADD action specified [3],
	//    then the final attribute value would be [1,2,3]. An error occurs if an
	//    Add action is specified for a set attribute and the attribute type specified
	//    does not match the existing set type. Both sets must have the same primitive
	//    data type. For example, if the existing data type is a set of strings,
	//    the Value must also be a set of strings. The same holds true for number
	//    sets and binary sets. This action is only valid for an existing attribute
	//    whose data type is number or is a set. Do not use ADD for any other data
	//    types.
	//
	// If no item with the specified Key is found:
	//
	//    * PUT - DynamoDB creates a new item with the specified primary key, and
	//    then adds the attribute.
	//
	//    * DELETE - Nothing happens; there is no attribute to delete.
	//
	//    * ADD - DynamoDB creates an item with the supplied primary key and number
	//    (or set of numbers) for the attribute value. The only data types allowed
	//    are number and number set; no other data types can be specified.
	Action *string `type:"string" enum:"AttributeAction"`

	// Represents the data for an attribute.
	//
	// Each attribute value is described as a name-value pair. The name is the data
	// type, and the value is the data itself.
	//
	// For more information, see Data Types (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes)
	// in the Amazon DynamoDB Developer Guide.
	Value *AttributeValue `type:"structure"`
}

// String returns the string representation
func (s AttributeValueUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttributeValueUpdate) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *AttributeValueUpdate) SetAction(v string) *AttributeValueUpdate {
	s.Action = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AttributeValueUpdate) SetValue(v *AttributeValue) *AttributeValueUpdate {
	s.Value = v
	return s
}

// Represents the properties of the scaling policy.
type AutoScalingPolicyDescription struct {
	_ struct{} `type:"structure"`

	// The name of the scaling policy.
	PolicyName *string `min:"1" type:"string"`

	// Represents a target tracking scaling policy configuration.
	TargetTrackingScalingPolicyConfiguration *AutoScalingTargetTrackingScalingPolicyConfigurationDescription `type:"structure"`
}

// String returns the string representation
func (s AutoScalingPolicyDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoScalingPolicyDescription) GoString() string {
	return s.String()
}

// SetPolicyName sets the PolicyName field's value.
func (s *AutoScalingPolicyDescription) SetPolicyName(v string) *AutoScalingPolicyDescription {
	s.PolicyName = &v
	return s
}

// SetTargetTrackingScalingPolicyConfiguration sets the TargetTrackingScalingPolicyConfiguration field's value.
func (s *AutoScalingPolicyDescription) SetTargetTrackingScalingPolicyConfiguration(v *AutoScalingTargetTrackingScalingPolicyConfigurationDescription) *AutoScalingPolicyDescription {
	s.TargetTrackingScalingPolicyConfiguration = v
	return s
}

// Represents the auto scaling policy to be modified.
type AutoScalingPolicyUpdate struct {
	_ struct{} `type:"structure"`

	// The name of the scaling policy.
	PolicyName *string `min:"1" type:"string"`

	// Represents a target tracking scaling policy configuration.
	//
	// TargetTrackingScalingPolicyConfiguration is a required field
	TargetTrackingScalingPolicyConfiguration *AutoScalingTargetTrackingScalingPolicyConfigurationUpdate `type:"structure" required:"true"`
}

// String returns the string representation
func (s AutoScalingPolicyUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoScalingPolicyUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoScalingPolicyUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoScalingPolicyUpdate"}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.TargetTrackingScalingPolicyConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetTrackingScalingPolicyConfiguration"))
	}
	if s.TargetTrackingScalingPolicyConfiguration != nil {
		if err := s.TargetTrackingScalingPolicyConfiguration.Validate(); err != nil {
			invalidParams.AddNested("TargetTrackingScalingPolicyConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *AutoScalingPolicyUpdate) SetPolicyName(v string) *AutoScalingPolicyUpdate {
	s.PolicyName = &v
	return s
}

// SetTargetTrackingScalingPolicyConfiguration sets the TargetTrackingScalingPolicyConfiguration field's value.
func (s *AutoScalingPolicyUpdate) SetTargetTrackingScalingPolicyConfiguration(v *AutoScalingTargetTrackingScalingPolicyConfigurationUpdate) *AutoScalingPolicyUpdate {
	s.TargetTrackingScalingPolicyConfiguration = v
	return s
}

// Represents the auto scaling settings for a global table or global secondary
// index.
type AutoScalingSettingsDescription struct {
	_ struct{} `type:"structure"`

	// Disabled auto scaling for this global table or global secondary index.
	AutoScalingDisabled *bool `type:"boolean"`

	// Role ARN used for configuring the auto scaling policy.
	AutoScalingRoleArn *string `type:"string"`

	// The maximum capacity units that a global table or global secondary index
	// should be scaled up to.
	MaximumUnits *int64 `min:"1" type:"long"`

	// The minimum capacity units that a global table or global secondary index
	// should be scaled down to.
	MinimumUnits *int64 `min:"1" type:"long"`

	// Information about the scaling policies.
	ScalingPolicies []*AutoScalingPolicyDescription `type:"list"`
}

// String returns the string representation
func (s AutoScalingSettingsDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoScalingSettingsDescription) GoString() string {
	return s.String()
}

// SetAutoScalingDisabled sets the AutoScalingDisabled field's value.
func (s *AutoScalingSettingsDescription) SetAutoScalingDisabled(v bool) *AutoScalingSettingsDescription {
	s.AutoScalingDisabled = &v
	return s
}

// SetAutoScalingRoleArn sets the AutoScalingRoleArn field's value.
func (s *AutoScalingSettingsDescription) SetAutoScalingRoleArn(v string) *AutoScalingSettingsDescription {
	s.AutoScalingRoleArn = &v
	return s
}

// SetMaximumUnits sets the MaximumUnits field's value.
func (s *AutoScalingSettingsDescription) SetMaximumUnits(v int64) *AutoScalingSettingsDescription {
	s.MaximumUnits = &v
	return s
}

// SetMinimumUnits sets the MinimumUnits field's value.
func (s *AutoScalingSettingsDescription) SetMinimumUnits(v int64) *AutoScalingSettingsDescription {
	s.MinimumUnits = &v
	return s
}

// SetScalingPolicies sets the ScalingPolicies field's value.
func (s *AutoScalingSettingsDescription) SetScalingPolicies(v []*AutoScalingPolicyDescription) *AutoScalingSettingsDescription {
	s.ScalingPolicies = v
	return s
}

// Represents the auto scaling settings to be modified for a global table or
// global secondary index.
type AutoScalingSettingsUpdate struct {
	_ struct{} `type:"structure"`

	// Disabled auto scaling for this global table or global secondary index.
	AutoScalingDisabled *bool `type:"boolean"`

	// Role ARN used for configuring auto scaling policy.
	AutoScalingRoleArn *string `min:"1" type:"string"`

	// The maximum capacity units that a global table or global secondary index
	// should be scaled up to.
	MaximumUnits *int64 `min:"1" type:"long"`

	// The minimum capacity units that a global table or global secondary index
	// should be scaled down to.
	MinimumUnits *int64 `min:"1" type:"long"`

	// The scaling policy to apply for scaling target global table or global secondary
	// index capacity units.
	ScalingPolicyUpdate *AutoScalingPolicyUpdate `type:"structure"`
}

// String returns the string representation
func (s AutoScalingSettingsUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoScalingSettingsUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoScalingSettingsUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoScalingSettingsUpdate"}
	if s.AutoScalingRoleArn != nil && len(*s.AutoScalingRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingRoleArn", 1))
	}
	if s.MaximumUnits != nil && *s.MaximumUnits < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaximumUnits", 1))
	}
	if s.MinimumUnits != nil && *s.MinimumUnits < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MinimumUnits", 1))
	}
	if s.ScalingPolicyUpdate != nil {
		if err := s.ScalingPolicyUpdate.Validate(); err != nil {
			invalidParams.AddNested("ScalingPolicyUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingDisabled sets the AutoScalingDisabled field's value.
func (s *AutoScalingSettingsUpdate) SetAutoScalingDisabled(v bool) *AutoScalingSettingsUpdate {
	s.AutoScalingDisabled = &v
	return s
}

// SetAutoScalingRoleArn sets the AutoScalingRoleArn field's value.
func (s *AutoScalingSettingsUpdate) SetAutoScalingRoleArn(v string) *AutoScalingSettingsUpdate {
	s.AutoScalingRoleArn = &v
	return s
}

// SetMaximumUnits sets the MaximumUnits field's value.
func (s *AutoScalingSettingsUpdate) SetMaximumUnits(v int64) *AutoScalingSettingsUpdate {
	s.MaximumUnits = &v
	return s
}

// SetMinimumUnits sets the MinimumUnits field's value.
func (s *AutoScalingSettingsUpdate) SetMinimumUnits(v int64) *AutoScalingSettingsUpdate {
	s.MinimumUnits = &v
	return s
}

// SetScalingPolicyUpdate sets the ScalingPolicyUpdate field's value.
func (s *AutoScalingSettingsUpdate) SetScalingPolicyUpdate(v *AutoScalingPolicyUpdate) *AutoScalingSettingsUpdate {
	s.ScalingPolicyUpdate = v
	return s
}

// Represents the properties of a target tracking scaling policy.
type AutoScalingTargetTrackingScalingPolicyConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// Indicates whether scale in by the target tracking policy is disabled. If
	// the value is true, scale in is disabled and the target tracking policy won't
	// remove capacity from the scalable resource. Otherwise, scale in is enabled
	// and the target tracking policy can remove capacity from the scalable resource.
	// The default value is false.
	DisableScaleIn *bool `type:"boolean"`

	// The amount of time, in seconds, after a scale in activity completes before
	// another scale in activity can start. The cooldown period is used to block
	// subsequent scale in requests until it has expired. You should scale in conservatively
	// to protect your application's availability. However, if another alarm triggers
	// a scale out policy during the cooldown period after a scale-in, application
	// auto scaling scales out your scalable target immediately.
	ScaleInCooldown *int64 `type:"integer"`

	// The amount of time, in seconds, after a scale out activity completes before
	// another scale out activity can start. While the cooldown period is in effect,
	// the capacity that has been added by the previous scale out event that initiated
	// the cooldown is calculated as part of the desired capacity for the next scale
	// out. You should continuously (but not excessively) scale out.
	ScaleOutCooldown *int64 `type:"integer"`

	// The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
	// (Base 10) or 2e-360 to 2e360 (Base 2).
	//
	// TargetValue is a required field
	TargetValue *float64 `type:"double" required:"true"`
}

// String returns the string representation
func (s AutoScalingTargetTrackingScalingPolicyConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoScalingTargetTrackingScalingPolicyConfigurationDescription) GoString() string {
	return s.String()
}

// SetDisableScaleIn sets the DisableScaleIn field's value.
func (s *AutoScalingTargetTrackingScalingPolicyConfigurationDescription) SetDisableScaleIn(v bool) *AutoScalingTargetTrackingScalingPolicyConfigurationDescription {
	s.DisableScaleIn = &v
	return s
}

// SetScaleInCooldown sets the ScaleInCooldown field's value.
func (s *AutoScalingTargetTrackingScalingPolicyConfigurationDescription) SetScaleInCooldown(v int64) *AutoScalingTargetTrackingScalingPolicyConfigurationDescription {
	s.ScaleInCooldown = &v
	return s
}

// SetScaleOutCooldown sets the ScaleOutCooldown field's value.
func (s *AutoScalingTargetTrackingScalingPolicyConfigurationDescription) SetScaleOutCooldown(v int64) *AutoScalingTargetTrackingScalingPolicyConfigurationDescription {
	s.ScaleOutCooldown = &v
	return s
}

// SetTargetValue sets the TargetValue field's value.
func (s *AutoScalingTargetTrackingScalingPolicyConfigurationDescription) SetTargetValue(v float64) *AutoScalingTargetTrackingScalingPolicyConfigurationDescription {
	s.TargetValue = &v
	return s
}

// Represents the settings of a target tracking scaling policy that will be
// modified.
type AutoScalingTargetTrackingScalingPolicyConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// Indicates whether scale in by the target tracking policy is disabled. If
	// the value is true, scale in is disabled and the target tracking policy won't
	// remove capacity from the scalable resource. Otherwise, scale in is enabled
	// and the target tracking policy can remove capacity from the scalable resource.
	// The default value is false.
	DisableScaleIn *bool `type:"boolean"`

	// The amount of time, in seconds, after a scale in activity completes before
	// another scale in activity can start. The cooldown period is used to block
	// subsequent scale in requests until it has expired. You should scale in conservatively
	// to protect your application's availability. However, if another alarm triggers
	// a scale out policy during the cooldown period after a scale-in, application
	// auto scaling scales out your scalable target immediately.
	ScaleInCooldown *int64 `type:"integer"`

	// The amount of time, in seconds, after a scale out activity completes before
	// another scale out activity can start. While the cooldown period is in effect,
	// the capacity that has been added by the previous scale out event that initiated
	// the cooldown is calculated as part of the desired capacity for the next scale
	// out. You should continuously (but not excessively) scale out.
	ScaleOutCooldown *int64 `type:"integer"`

	// The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
	// (Base 10) or 2e-360 to 2e360 (Base 2).
	//
	// TargetValue is a required field
	TargetValue *float64 `type:"double" required:"true"`
}

// String returns the string representation
func (s AutoScalingTargetTrackingScalingPolicyConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoScalingTargetTrackingScalingPolicyConfigurationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoScalingTargetTrackingScalingPolicyConfigurationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoScalingTargetTrackingScalingPolicyConfigurationUpdate"}
	if s.TargetValue == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisableScaleIn sets the DisableScaleIn field's value.
func (s *AutoScalingTargetTrackingScalingPolicyConfigurationUpdate) SetDisableScaleIn(v bool) *AutoScalingTargetTrackingScalingPolicyConfigurationUpdate {
	s.DisableScaleIn = &v
	return s
}

// SetScaleInCooldown sets the ScaleInCooldown field's value.
func (s *AutoScalingTargetTrackingScalingPolicyConfigurationUpdate) SetScaleInCooldown(v int64) *AutoScalingTargetTrackingScalingPolicyConfigurationUpdate {
	s.ScaleInCooldown = &v
	return s
}

// SetScaleOutCooldown sets the ScaleOutCooldown field's value.
func (s *AutoScalingTargetTrackingScalingPolicyConfigurationUpdate) SetScaleOutCooldown(v int64) *AutoScalingTargetTrackingScalingPolicyConfigurationUpdate {
	s.ScaleOutCooldown = &v
	return s
}

// SetTargetValue sets the TargetValue field's value.
func (s *AutoScalingTargetTrackingScalingPolicyConfigurationUpdate) SetTargetValue(v float64) *AutoScalingTargetTrackingScalingPolicyConfigurationUpdate {
	s.TargetValue = &v
	return s
}

// Contains the description of the backup created for the table.
type BackupDescription struct {
	_ struct{} `type:"structure"`

	// Contains the details of the backup created for the table.
	BackupDetails *BackupDetails `type:"structure"`

	// Contains the details of the table when the backup was created.
	SourceTableDetails *SourceTableDetails `type:"structure"`

	// Contains the details of the features enabled on the table when the backup
	// was created. For example, LSIs, GSIs, streams, TTL.
	SourceTableFeatureDetails *SourceTableFeatureDetails `type:"structure"`
}

// String returns the string representation
func (s BackupDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BackupDescription) GoString() string {
	return s.String()
}

// SetBackupDetails sets the BackupDetails field's value.
func (s *BackupDescription) SetBackupDetails(v *BackupDetails) *BackupDescription {
	s.BackupDetails = v
	return s
}

// SetSourceTableDetails sets the SourceTableDetails field's value.
func (s *BackupDescription) SetSourceTableDetails(v *SourceTableDetails) *BackupDescription {
	s.SourceTableDetails = v
	return s
}

// SetSourceTableFeatureDetails sets the SourceTableFeatureDetails field's value.
func (s *BackupDescription) SetSourceTableFeatureDetails(v *SourceTableFeatureDetails) *BackupDescription {
	s.SourceTableFeatureDetails = v
	return s
}

// Contains the details of the backup created for the table.
type BackupDetails struct {
	_ struct{} `type:"structure"`

	// ARN associated with the backup.
	//
	// BackupArn is a required field
	BackupArn *string `min:"37" type:"string" required:"true"`

	// Time at which the backup was created. This is the request time of the backup.
	//
	// BackupCreationDateTime is a required field
	BackupCreationDateTime *time.Time `type:"timestamp" required:"true"`

	// Time at which the automatic on-demand backup created by DynamoDB will expire.
	// This SYSTEM on-demand backup expires automatically 35 days after its creation.
	BackupExpiryDateTime *time.Time `type:"timestamp"`

	// Name of the requested backup.
	//
	// BackupName is a required field
	BackupName *string `min:"3" type:"string" required:"true"`

	// Size of the backup in bytes.
	BackupSizeBytes *int64 `type:"long"`

	// Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
	//
	// BackupStatus is a required field
	BackupStatus *string `type:"string" required:"true" enum:"BackupStatus"`

	// BackupType:
	//
	//    * USER - You create and manage these using the on-demand backup feature.
	//
	//    * SYSTEM - If you delete a table with point-in-time recovery enabled,
	//    a SYSTEM backup is automatically created and is retained for 35 days (at
	//    no additional cost). System backups allow you to restore the deleted table
	//    to the state it was in just before the point of deletion.
	//
	//    * AWS_BACKUP - On-demand backup created by you from AWS Backup service.
	//
	// BackupType is a required field
	BackupType *string `type:"string" required:"true" enum:"BackupType"`
}

// String returns the string representation
func (s BackupDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BackupDetails) GoString() string {
	return s.String()
}

// SetBackupArn sets the BackupArn field's value.
func (s *BackupDetails) SetBackupArn(v string) *BackupDetails {
	s.BackupArn = &v
	return s
}

// SetBackupCreationDateTime sets the BackupCreationDateTime field's value.
func (s *BackupDetails) SetBackupCreationDateTime(v time.Time) *BackupDetails {
	s.BackupCreationDateTime = &v
	return s
}

// SetBackupExpiryDateTime sets the BackupExpiryDateTime field's value.
func (s *BackupDetails) SetBackupExpiryDateTime(v time.Time) *BackupDetails {
	s.BackupExpiryDateTime = &v
	return s
}

// SetBackupName sets the BackupName field's value.
func (s *BackupDetails) SetBackupName(v string) *BackupDetails {
	s.BackupName = &v
	return s
}

// SetBackupSizeBytes sets the BackupSizeBytes field's value.
func (s *BackupDetails) SetBackupSizeBytes(v int64) *BackupDetails {
	s.BackupSizeBytes = &v
	return s
}

// SetBackupStatus sets the BackupStatus field's value.
func (s *BackupDetails) SetBackupStatus(v string) *BackupDetails {
	s.BackupStatus = &v
	return s
}

// SetBackupType sets the BackupType field's value.
func (s *BackupDetails) SetBackupType(v string) *BackupDetails {
	s.BackupType = &v
	return s
}

// Contains details for the backup.
type BackupSummary struct {
	_ struct{} `type:"structure"`

	// ARN associated with the backup.
	BackupArn *string `min:"37" type:"string"`

	// Time at which the backup was created.
	BackupCreationDateTime *time.Time `type:"timestamp"`

	// Time at which the automatic on-demand backup created by DynamoDB will expire.
	// This SYSTEM on-demand backup expires automatically 35 days after its creation.
	BackupExpiryDateTime *time.Time `type:"timestamp"`

	// Name of the specified backup.
	BackupName *string `min:"3" type:"string"`

	// Size of the backup in bytes.
	BackupSizeBytes *int64 `type:"long"`

	// Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
	BackupStatus *string `type:"string" enum:"BackupStatus"`

	// BackupType:
	//
	//    * USER - You create and manage these using the on-demand backup feature.
	//
	//    * SYSTEM - If you delete a table with point-in-time recovery enabled,
	//    a SYSTEM backup is automatically created and is retained for 35 days (at
	//    no additional cost). System backups allow you to restore the deleted table
	//    to the state it was in just before the point of deletion.
	//
	//    * AWS_BACKUP - On-demand backup created by you from AWS Backup service.
	BackupType *string `type:"string" enum:"BackupType"`

	// ARN associated with the table.
	TableArn *string `type:"string"`

	// Unique identifier for the table.
	TableId *string `type:"string"`

	// Name of the table.
	TableName *string `min:"3" type:"string"`
}

// String returns the string representation
func (s BackupSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BackupSummary) GoString() string {
	return s.String()
}

// SetBackupArn sets the BackupArn field's value.
func (s *BackupSummary) SetBackupArn(v string) *BackupSummary {
	s.BackupArn = &v
	return s
}

// SetBackupCreationDateTime sets the BackupCreationDateTime field's value.
func (s *BackupSummary) SetBackupCreationDateTime(v time.Time) *BackupSummary {
	s.BackupCreationDateTime = &v
	return s
}

// SetBackupExpiryDateTime sets the BackupExpiryDateTime field's value.
func (s *BackupSummary) SetBackupExpiryDateTime(v time.Time) *BackupSummary {
	s.BackupExpiryDateTime = &v
	return s
}

// SetBackupName sets the BackupName field's value.
func (s *BackupSummary) SetBackupName(v string) *BackupSummary {
	s.BackupName = &v
	return s
}

// SetBackupSizeBytes sets the BackupSizeBytes field's value.
func (s *BackupSummary) SetBackupSizeBytes(v int64) *BackupSummary {
	s.BackupSizeBytes = &v
	return s
}

// SetBackupStatus sets the BackupStatus field's value.
func (s *BackupSummary) SetBackupStatus(v string) *BackupSummary {
	s.BackupStatus = &v
	return s
}

// SetBackupType sets the BackupType field's value.
func (s *BackupSummary) SetBackupType(v string) *BackupSummary {
	s.BackupType = &v
	return s
}

// SetTableArn sets the TableArn field's value.
func (s *BackupSummary) SetTableArn(v string) *BackupSummary {
	s.TableArn = &v
	return s
}

// SetTableId sets the TableId field's value.
func (s *BackupSummary) SetTableId(v string) *BackupSummary {
	s.TableId = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *BackupSummary) SetTableName(v string) *BackupSummary {
	s.TableName = &v
	return s
}

// Represents the input of a BatchGetItem operation.
type BatchGetItemInput struct {
	_ struct{} `type:"structure"`

	// A map of one or more table names and, for each table, a map that describes
	// one or more items to retrieve from that table. Each table name can be used
	// only once per BatchGetItem request.
	//
	// Each element in the map of items to retrieve consists of the following:
	//
	//    * ConsistentRead - If true, a strongly consistent read is used; if false
	//    (the default), an eventually consistent read is used.
	//
	//    * ExpressionAttributeNames - One or more substitution tokens for attribute
	//    names in the ProjectionExpression parameter. The following are some use
	//    cases for using ExpressionAttributeNames: To access an attribute whose
	//    name conflicts with a DynamoDB reserved word. To create a placeholder
	//    for repeating occurrences of an attribute name in an expression. To prevent
	//    special characters in an attribute name from being misinterpreted in an
	//    expression. Use the # character in an expression to dereference an attribute
	//    name. For example, consider the following attribute name: Percentile The
	//    name of this attribute conflicts with a reserved word, so it cannot be
	//    used directly in an expression. (For the complete list of reserved words,
	//    see Reserved Words (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
	//    in the Amazon DynamoDB Developer Guide). To work around this, you could
	//    specify the following for ExpressionAttributeNames: {"#P":"Percentile"}
	//    You could then use this substitution in an expression, as in this example:
	//    #P = :val Tokens that begin with the : character are expression attribute
	//    values, which are placeholders for the actual value at runtime. For more
	//    information about expression attribute names, see Accessing Item Attributes
	//    (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
	//    in the Amazon DynamoDB Developer Guide.
	//
	//    * Keys - An array of primary key attribute values that define specific
	//    items in the table. For each primary key, you must provide all of the
	//    key attributes. For example, with a simple primary key, you only need
	//    to provide the partition key value. For a composite key, you must provide
	//    both the partition key value and the sort key value.
	//
	//    * ProjectionExpression - A string that identifies one or more attributes
	//    to retrieve from the table. These attributes can include scalars, sets,
	//    or elements of a JSON document. The attributes in the expression must
	//    be separated by commas. If no attribute names are specified, then all
	//    attributes are returned. If any of the requested attributes are not found,
	//    they do not appear in the result. For more information, see Accessing
	//    Item Attributes (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
	//    in the Amazon DynamoDB Developer Guide.
	//
	//    * AttributesToGet - This is a legacy parameter. Use ProjectionExpression
	//    instead. For more information, see AttributesToGet (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html)
	//    in the Amazon DynamoDB Developer Guide.
	//
	// RequestItems is a required field
	RequestItems map[string]*KeysAndAttributes `min:"1" type:"map" required:"true"`

	// Determines the level of detail about provisioned throughput consumption that
	// is returned in the response:
	//
	//    * INDEXES - The response includes the aggregate ConsumedCapacity for the
	//    operation, together with ConsumedCapacity for each table and secondary
	//    index that was accessed. Note that some operations, such as GetItem and
	//    BatchGetItem, do not access any indexes at all. In these cases, specifying
	//    INDEXES will only return ConsumedCapacity information for table(s).
	//
	//    * TOTAL - The response includes only the aggregate ConsumedCapacity for
	//    the operation.
	//
	//    * NONE - No ConsumedCapacity details are included in the response.
	ReturnConsumedCapacity *string `type:"string" enum:"ReturnConsumedCapacity"`
}

// String returns the string representation
func (s BatchGetItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetItemInput"}
	if s.RequestItems == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestItems"))
	}
	if s.RequestItems != nil && len(s.RequestItems) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestItems", 1))
	}
	if s.RequestItems != nil {
		for i, v := range s.RequestItems {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RequestItems", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRequestItems sets the RequestItems field's value.
func (s *BatchGetItemInput) SetRequestItems(v map[string]*KeysAndAttributes) *BatchGetItemInput {
	s.RequestItems = v
	return s
}

// SetReturnConsumedCapacity sets the ReturnConsumedCapacity field's value.
func (s *BatchGetItemInput) SetReturnConsumedCapacity(v string) *BatchGetItemInput {
	s.ReturnConsumedCapacity = &v
	return s
}

// Represents the output of a BatchGetItem operation.
type BatchGetItemOutput struct {
	_ struct{} `type:"structure"`

	// The read capacity units consumed by the entire BatchGetItem operation.
	//
	// Each element consists of:
	//
	//    * TableName - The table that consumed the provisioned throughput.
	//
	//    * CapacityUnits - The total number of capacity units consumed.
	ConsumedCapacity []*ConsumedCapacity `type:"list"`

	// A map of table name to a list of items. Each object in Responses consists
	// of a table name, along with a map of attribute data consisting of the data
	// type and attribute value.
	Responses map[string][]map[string]*AttributeValue `type:"map"`

	// A map of tables and their respective keys that were not processed with the
	// current response. The UnprocessedKeys value is in the same form as RequestItems,
	// so the value can be provided directly to a subsequent BatchGetItem operation.
	// For more information, see RequestItems in the Request Parameters section.
	//
	// Each element consists of:
	//
	//    * Keys - An array of primary key attribute values that define specific
	//    items in the table.
	//
	//    * ProjectionExpression - One or more attributes to be retrieved from the
	//    table or index. By default, all attributes are returned. If a requested
	//    attribute is not found, it does not appear in the result.
	//
	//    * ConsistentRead - The consistency of a read operation. If set to true,
	//    then a strongly consistent read is used; otherwise, an eventually consistent
	//    read is used.
	//
	// If there are no unprocessed keys remaining, the response contains an empty
	// UnprocessedKeys map.
	UnprocessedKeys map[string]*KeysAndAttributes `min:"1" type:"map"`
}

// String returns the string representation
func (s BatchGetItemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetItemOutput) GoString() string {
	return s.String()
}

// SetConsumedCapacity sets the ConsumedCapacity field's value.
func (s *BatchGetItemOutput) SetConsumedCapacity(v []*ConsumedCapacity) *BatchGetItemOutput {
	s.ConsumedCapacity = v
	return s
}

// SetResponses sets the Responses field's value.
func (s *BatchGetItemOutput) SetResponses(v map[string][]map[string]*AttributeValue) *BatchGetItemOutput {
	s.Responses = v
	return s
}

// SetUnprocessedKeys sets the UnprocessedKeys field's value.
func (s *BatchGetItemOutput) SetUnprocessedKeys(v map[string]*KeysAndAttributes) *BatchGetItemOutput {
	s.UnprocessedKeys = v
	return s
}

// Represents the input of a BatchWriteItem operation.
type BatchWriteItemInput struct {
	_ struct{} `type:"structure"`

	// A map of one or more table names and, for each table, a list of operations
	// to be performed (DeleteRequest or PutRequest). Each element in the map consists
	// of the following:
	//
	//    * DeleteRequest - Perform a DeleteItem operation on the specified item.
	//    The item to be deleted is identified by a Key subelement: Key - A map
	//    of primary key attribute values that uniquely identify the item. Each
	//    entry in this map consists of an attribute name and an attribute value.
	//    For each primary key, you must provide all of the key attributes. For
	//    example, with a simple primary key, you only need to provide a value for
	//    the partition key. For a composite primary key, you must provide values
	//    for both the partition key and the sort key.
	//
	//    * PutRequest - Perform a PutItem operation on the specified item. The
	//    item to be put is identified by an Item subelement: Item - A map of attributes
	//    and their values. Each entry in this map consists of an attribute name
	//    and an attribute value. Attribute values must not be null; string and
	//    binary type attributes must have lengths greater than zero; and set type
	//    attributes must not be empty. Requests that contain empty values are rejected
	//    with a ValidationException exception. If you specify any attributes that
	//    are part of an index key, then the data types for those attributes must
	//    match those of the schema in the table's attribute definition.
	//
	// RequestItems is a required field
	RequestItems map[string][]*WriteRequest `min:"1" type:"map" required:"true"`

	// Determines the level of detail about provisioned throughput consumption that
	// is returned in the response:
	//
	//    * INDEXES - The response includes the aggregate ConsumedCapacity for the
	//    operation, together with ConsumedCapacity for each table and secondary
	//    index that was accessed. Note that some operations, such as GetItem and
	//    BatchGetItem, do not access any indexes at all. In these cases, specifying
	//    INDEXES will only return ConsumedCapacity information for table(s).
	//
	//    * TOTAL - The response includes only the aggregate ConsumedCapacity for
	//    the operation.
	//
	//    * NONE - No ConsumedCapacity details are included in the response.
	ReturnConsumedCapacity *string `type:"string" enum:"ReturnConsumedCapacity"`

	// Determines whether item collection metrics are returned. If set to SIZE,
	// the response includes statistics about item collections, if any, that were
	// modified during the operation are returned in the response. If set to NONE
	// (the default), no statistics are returned.
	ReturnItemCollectionMetrics *string `type:"string" enum:"ReturnItemCollectionMetrics"`
}

// String returns the string representation
func (s BatchWriteItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchWriteItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchWriteItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchWriteItemInput"}
	if s.RequestItems == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestItems"))
	}
	if s.RequestItems != nil && len(s.RequestItems) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRequestItems sets the RequestItems field's value.
func (s *BatchWriteItemInput) SetRequestItems(v map[string][]*WriteRequest) *BatchWriteItemInput {
	s.RequestItems = v
	return s
}

// SetReturnConsumedCapacity sets the ReturnConsumedCapacity field's value.
func (s *BatchWriteItemInput) SetReturnConsumedCapacity(v string) *BatchWriteItemInput {
	s.ReturnConsumedCapacity = &v
	return s
}

// SetReturnItemCollectionMetrics sets the ReturnItemCollectionMetrics field's value.
func (s *BatchWriteItemInput) SetReturnItemCollectionMetrics(v string) *BatchWriteItemInput {
	s.ReturnItemCollectionMetrics = &v
	return s
}

// Represents the output of a BatchWriteItem operation.
type BatchWriteItemOutput struct {
	_ struct{} `type:"structure"`

	// The capacity units consumed by the entire BatchWriteItem operation.
	//
	// Each element consists of:
	//
	//    * TableName - The table that consumed the provisioned throughput.
	//
	//    * CapacityUnits - The total number of capacity units consumed.
	ConsumedCapacity []*ConsumedCapacity `type:"list"`

	// A list of tables that were processed by BatchWriteItem and, for each table,
	// information about any item collections that were affected by individual DeleteItem
	// or PutItem operations.
	//
	// Each entry consists of the following subelements:
	//
	//    * ItemCollectionKey - The partition key value of the item collection.
	//    This is the same as the partition key value of the item.
	//
	//    * SizeEstimateRangeGB - An estimate of item collection size, expressed
	//    in GB. This is a two-element array containing a lower bound and an upper
	//    bound for the estimate. The estimate includes the size of all the items
	//    in the table, plus the size of all attributes projected into all of the
	//    local secondary indexes on the table. Use this estimate to measure whether
	//    a local secondary index is approaching its size limit. The estimate is
	//    subject to change over time; therefore, do not rely on the precision or
	//    accuracy of the estimate.
	ItemCollectionMetrics map[string][]*ItemCollectionMetrics `type:"map"`

	// A map of tables and requests against those tables that were not processed.
	// The UnprocessedItems value is in the same form as RequestItems, so you can
	// provide this value directly to a subsequent BatchGetItem operation. For more
	// information, see RequestItems in the Request Parameters section.
	//
	// Each UnprocessedItems entry consists of a table name and, for that table,
	// a list of operations to perform (DeleteRequest or PutRequest).
	//
	//    * DeleteRequest - Perform a DeleteItem operation on the specified item.
	//    The item to be deleted is identified by a Key subelement: Key - A map
	//    of primary key attribute values that uniquely identify the item. Each
	//    entry in this map consists of an attribute name and an attribute value.
	//
	//    * PutRequest - Perform a PutItem operation on the specified item. The
	//    item to be put is identified by an Item subelement: Item - A map of attributes
	//    and their values. Each entry in this map consists of an attribute name
	//    and an attribute value. Attribute values must not be null; string and
	//    binary type attributes must have lengths greater than zero; and set type
	//    attributes must not be empty. Requests that contain empty values will
	//    be rejected with a ValidationException exception. If you specify any attributes
	//    that are part of an index key, then the data types for those attributes
	//    must match those of the schema in the table's attribute definition.
	//
	// If there are no unprocessed items remaining, the response contains an empty
	// UnprocessedItems map.
	UnprocessedItems map[string][]*WriteRequest `min:"1" type:"map"`
}

// String returns the string representation
func (s BatchWriteItemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchWriteItemOutput) GoString() string {
	return s.String()
}

// SetConsumedCapacity sets the ConsumedCapacity field's value.
func (s *BatchWriteItemOutput) SetConsumedCapacity(v []*ConsumedCapacity) *BatchWriteItemOutput {
	s.ConsumedCapacity = v
	return s
}

// SetItemCollectionMetrics sets the ItemCollectionMetrics field's value.
func (s *BatchWriteItemOutput) SetItemCollectionMetrics(v map[string][]*ItemCollectionMetrics) *BatchWriteItemOutput {
	s.ItemCollectionMetrics = v
	return s
}

// SetUnprocessedItems sets the UnprocessedItems field's value.
func (s *BatchWriteItemOutput) SetUnprocessedItems(v map[string][]*WriteRequest) *BatchWriteItemOutput {
	s.UnprocessedItems = v
	return s
}

// Contains the details for the read/write capacity mode.
type BillingModeSummary struct {
	_ struct{} `type:"structure"`

	// Controls how you are charged for read and write throughput and how you manage
	// capacity. This setting can be changed later.
	//
	//    * PROVISIONED - Sets the read/write capacity mode to PROVISIONED. We recommend
	//    using PROVISIONED for predictable workloads.
	//
	//    * PAY_PER_REQUEST - Sets the read/write capacity mode to PAY_PER_REQUEST.
	//    We recommend using PAY_PER_REQUEST for unpredictable workloads.
	BillingMode *string `type:"string" enum:"BillingMode"`

	// Represents the time when PAY_PER_REQUEST was last set as the read/write capacity
	// mode.
	LastUpdateToPayPerRequestDateTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s BillingModeSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BillingModeSummary) GoString() string {
	return s.String()
}

// SetBillingMode sets the BillingMode field's value.
func (s *BillingModeSummary) SetBillingMode(v string) *BillingModeSummary {
	s.BillingMode = &v
	return s
}

// SetLastUpdateToPayPerRequestDateTime sets the LastUpdateToPayPerRequestDateTime field's value.
func (s *BillingModeSummary) SetLastUpdateToPayPerRequestDateTime(v time.Time) *BillingModeSummary {
	s.LastUpdateToPayPerRequestDateTime = &v
	return s
}

// An ordered list of errors for each item in the request which caused the transaction
// to get cancelled. The values of the list are ordered according to the ordering
// of the TransactWriteItems request parameter. If no error occurred for the
// associated item an error with a Null code and Null message will be present.
type CancellationReason struct {
	_ struct{} `type:"structure"`

	// Status code for the result of the cancelled transaction.
	Code *string `type:"string"`

	// Item in the request which caused the transaction to get cancelled.
	Item map[string]*AttributeValue `type:"map"`

	// Cancellation reason message description.
	Message *string `type:"string"`
}

// String returns the string representation
func (s CancellationReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancellationReason) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *CancellationReason) SetCode(v string) *CancellationReason {
	s.Code = &v
	return s
}

// SetItem sets the Item field's value.
func (s *CancellationReason) SetItem(v map[string]*AttributeValue) *CancellationReason {
	s.Item = v
	return s
}

// SetMessage sets the Message field's value.
func (s *CancellationReason) SetMessage(v string) *CancellationReason {
	s.Message = &v
	return s
}

// Represents the amount of provisioned throughput capacity consumed on a table
// or an index.
type Capacity struct {
	_ struct{} `type:"structure"`

	// The total number of capacity units consumed on a table or an index.
	CapacityUnits *float64 `type:"double"`

	// The total number of read capacity units consumed on a table or an index.
	ReadCapacityUnits *float64 `type:"double"`

	// The total number of write capacity units consumed on a table or an index.
	WriteCapacityUnits *float64 `type:"double"`
}

// String returns the string representation
func (s Capacity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Capacity) GoString() string {
	return s.String()
}

// SetCapacityUnits sets the CapacityUnits field's value.
func (s *Capacity) SetCapacityUnits(v float64) *Capacity {
	s.CapacityUnits = &v
	return s
}

// SetReadCapacityUnits sets the ReadCapacityUnits field's value.
func (s *Capacity) SetReadCapacityUnits(v float64) *Capacity {
	s.ReadCapacityUnits = &v
	return s
}

// SetWriteCapacityUnits sets the WriteCapacityUnits field's value.
func (s *Capacity) SetWriteCapacityUnits(v float64) *Capacity {
	s.WriteCapacityUnits = &v
	return s
}

// Represents the selection criteria for a Query or Scan operation:
//
//    * For a Query operation, Condition is used for specifying the KeyConditions
//    to use when querying a table or an index. For KeyConditions, only the
//    following comparison operators are supported: EQ | LE | LT | GE | GT |
//    BEGINS_WITH | BETWEEN Condition is also used in a QueryFilter, which evaluates
//    the query results and returns only the desired values.
//
//    * For a Scan operation, Condition is used in a ScanFilter, which evaluates
//    the scan results and returns only the desired values.
type Condition struct {
	_ struct{} `type:"structure"`

	// One or more values to evaluate against the supplied attribute. The number
	// of values in the list depends on the ComparisonOperator being used.
	//
	// For type Number, value comparisons are numeric.
	//
	// String value comparisons for greater than, equals, or less than are based
	// on ASCII character code values. For example, a is greater than A, and a is
	// greater than B. For a list of code values, see http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters
	// (http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters).
	//
	// For Binary, DynamoDB treats each byte of the binary data as unsigned when
	// it compares binary values.
	AttributeValueList []*AttributeValue `type:"list"`

	// A comparator for evaluating attributes. For example, equals, greater than,
	// less than, etc.
	//
	// The following comparison operators are available:
	//
	// EQ | NE | LE | LT | GE | GT | NOT_NULL | NULL | CONTAINS | NOT_CONTAINS |
	// BEGINS_WITH | IN | BETWEEN
	//
	// The following are descriptions of each comparison operator.
	//
	//    * EQ : Equal. EQ is supported for all data types, including lists and
	//    maps. AttributeValueList can contain only one AttributeValue element of
	//    type String, Number, Binary, String Set, Number Set, or Binary Set. If
	//    an item contains an AttributeValue element of a different type than the
	//    one provided in the request, the value does not match. For example, {"S":"6"}
	//    does not equal {"N":"6"}. Also, {"N":"6"} does not equal {"NS":["6", "2",
	//    "1"]}.
	//
	//    * NE : Not equal. NE is supported for all data types, including lists
	//    and maps. AttributeValueList can contain only one AttributeValue of type
	//    String, Number, Binary, String Set, Number Set, or Binary Set. If an item
	//    contains an AttributeValue of a different type than the one provided in
	//    the request, the value does not match. For example, {"S":"6"} does not
	//    equal {"N":"6"}. Also, {"N":"6"} does not equal {"NS":["6", "2", "1"]}.
	//
	//    * LE : Less than or equal. AttributeValueList can contain only one AttributeValue
	//    element of type String, Number, or Binary (not a set type). If an item
	//    contains an AttributeValue element of a different type than the one provided
	//    in the request, the value does not match. For example, {"S":"6"} does
	//    not equal {"N":"6"}. Also, {"N":"6"} does not compare to {"NS":["6", "2",
	//    "1"]}.
	//
	//    * LT : Less than. AttributeValueList can contain only one AttributeValue
	//    of type String, Number, or Binary (not a set type). If an item contains
	//    an AttributeValue element of a different type than the one provided in
	//    the request, the value does not match. For example, {"S":"6"} does not
	//    equal {"N":"6"}. Also, {"N":"6"} does not compare to {"NS":["6", "2",
	//    "1"]}.
	//
	//    * GE : Greater than or equal. AttributeValueList can contain only one
	//    AttributeValue element of type String, Number, or Binary (not a set type).
	//    If an item contains an AttributeValue element of a different type than
	//    the one provided in the request, the value does not match. For example,
	//    {"S":"6"} does not equal {"N":"6"}. Also, {"N":"6"} does not compare to
	//    {"NS":["6", "2", "1"]}.
	//
	//    * GT : Greater than. AttributeValueList can contain only one AttributeValue
	//    element of type String, Number, or Binary (not a set type). If an item
	//    contains an AttributeValue element of a different type than the one provided
	//    in the request, the value does not match. For example, {"S":"6"} does
	//    not equal {"N":"6"}. Also, {"N":"6"} does not compare to {"NS":["6", "2",
	//    "1"]}.
	//
	//    * NOT_NULL : The attribute exists. NOT_NULL is supported for all data
	//    types, including lists and maps. This operator tests for the existence
	//    of an attribute, not its data type. If the data type of attribute "a"
	//    is null, and you evaluate it using NOT_NULL, the result is a Boolean true.
	//    This result is because the attribute "a" exists; its data type is not
	//    relevant to the NOT_NULL comparison operator.
	//
	//    * NULL : The attribute does not exist. NULL is supported for all data
	//    types, including lists and maps. This operator tests for the nonexistence
	//    of an attribute, not its data type. If the data type of attribute "a"
	//    is null, and you evaluate it using NULL, the result is a Boolean false.
	//    This is because the attribute "a" exists; its data type is not relevant
	//    to the NULL comparison operator.
	//
	//    * CONTAINS : Checks for a subsequence, or value in a set. AttributeValueList
	//    can contain only one AttributeValue element of type String, Number, or
	//    Binary (not a set type). If the target attribute of the comparison is
	//    of type String, then the operator checks for a substring match. If the
	//    target attribute of the comparison is of type Binary, then the operator
	//    looks for a subsequence of the target that matches the input. If the target
	//    attribute of the comparison is a set ("SS", "NS", or "BS"), then the operator
	//    evaluates to true if it finds an exact match with any member of the set.
	//    CONTAINS is supported for lists: When evaluating "a CONTAINS b", "a" can
	//    be a list; however, "b" cannot be a set, a map, or a list.
	//
	//    * NOT_CONTAINS : Checks for absence of a subsequence, or absence of a
	//    value in a set. AttributeValueList can contain only one AttributeValue
	//    element of type String, Number, or Binary (not a set type). If the target
	//    attribute of the comparison is a String, then the operator checks for
	//    the absence of a substring match. If the target attribute of the comparison
	//    is Binary, then the operator checks for the absence of a subsequence of
	//    the target that matches the input. If the target attribute of the comparison
	//    is a set ("SS", "NS", or "BS"), then the operator evaluates to true if
	//    it does not find an exact match with any member of the set. NOT_CONTAINS
	//    is supported for lists: When evaluating "a NOT CONTAINS b", "a" can be
	//    a list; however, "b" cannot be a set, a map, or a list.
	//
	//    * BEGINS_WITH : Checks for a prefix. AttributeValueList can contain only
	//    one AttributeValue of type String or Binary (not a Number or a set type).
	//    The target attribute of the comparison must be of type String or Binary
	//    (not a Number or a set type).
	//
	//    * IN : Checks for matching elements in a list. AttributeValueList can
	//    contain one or more AttributeValue elements of type String, Number, or
	//    Binary. These attributes are compared against an existing attribute of
	//    an item. If any elements of the input are equal to the item attribute,
	//    the expression evaluates to true.
	//
	//    * BETWEEN : Greater than or equal to the first value, and less than or
	//    equal to the second value. AttributeValueList must contain two AttributeValue
	//    elements of the same type, either String, Number, or Binary (not a set
	//    type). A target attribute matches if the target value is greater than,
	//    or equal to, the first element and less than, or equal to, the second
	//    element. If an item contains an AttributeValue element of a different
	//    type than the one provided in the request, the value does not match. For
	//    example, {"S":"6"} does not compare to {"N":"6"}. Also, {"N":"6"} does
	//    not compare to {"NS":["6", "2", "1"]}
	//
	// For usage examples of AttributeValueList and ComparisonOperator, see Legacy
	// Conditional Parameters (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.html)
	// in the Amazon DynamoDB Developer Guide.
	//
	// ComparisonOperator is a required field
	ComparisonOperator *string `type:"string" required:"true" enum:"ComparisonOperator"`
}

// String returns the string representation
func (s Condition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Condition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Condition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Condition"}
	if s.ComparisonOperator == nil {
		invalidParams.Add(request.NewErrParamRequired("ComparisonOperator"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeValueList sets the AttributeValueList field's value.
func (s *Condition) SetAttributeValueList(v []*AttributeValue) *Condition {
	s.AttributeValueList = v
	return s
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *Condition) SetComparisonOperator(v string) *Condition {
	s.ComparisonOperator = &v
	return s
}

// Represents a request to perform a check that an item exists or to check the
// condition of specific attributes of the item.
type ConditionCheck struct {
	_ struct{} `type:"structure"`

	// A condition that must be satisfied in order for a conditional update to succeed.
	//
	// ConditionExpression is a required field
	ConditionExpression *string `type:"string" required:"true"`

	// One or more substitution tokens for attribute names in an expression.
	ExpressionAttributeNames map[string]*string `type:"map"`

	// One or more values that can be substituted in an expression.
	ExpressionAttributeValues map[string]*AttributeValue `type:"map"`

	// The primary key of the item to be checked. Each element consists of an attribute
	// name and a value for that attribute.
	//
	// Key is a required field
	Key map[string]*AttributeValue `type:"map" required:"true"`

	// Use ReturnValuesOnConditionCheckFailure to get the item attributes if the
	// ConditionCheck condition fails. For ReturnValuesOnConditionCheckFailure,
	// the valid values are: NONE and ALL_OLD.
	ReturnValuesOnConditionCheckFailure *string `type:"string" enum:"ReturnValuesOnConditionCheckFailure"`

	// Name of the table for the check item request.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s ConditionCheck) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConditionCheck) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConditionCheck) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConditionCheck"}
	if s.ConditionExpression == nil {
		invalidParams.Add(request.NewErrParamRequired("ConditionExpression"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConditionExpression sets the ConditionExpression field's value.
func (s *ConditionCheck) SetConditionExpression(v string) *ConditionCheck {
	s.ConditionExpression = &v
	return s
}

// SetExpressionAttributeNames sets the ExpressionAttributeNames field's value.
func (s *ConditionCheck) SetExpressionAttributeNames(v map[string]*string) *ConditionCheck {
	s.ExpressionAttributeNames = v
	return s
}

// SetExpressionAttributeValues sets the ExpressionAttributeValues field's value.
func (s *ConditionCheck) SetExpressionAttributeValues(v map[string]*AttributeValue) *ConditionCheck {
	s.ExpressionAttributeValues = v
	return s
}

// SetKey sets the Key field's value.
func (s *ConditionCheck) SetKey(v map[string]*AttributeValue) *ConditionCheck {
	s.Key = v
	return s
}

// SetReturnValuesOnConditionCheckFailure sets the ReturnValuesOnConditionCheckFailure field's value.
func (s *ConditionCheck) SetReturnValuesOnConditionCheckFailure(v string) *ConditionCheck {
	s.ReturnValuesOnConditionCheckFailure = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *ConditionCheck) SetTableName(v string) *ConditionCheck {
	s.TableName = &v
	return s
}

// The capacity units consumed by an operation. The data returned includes the
// total provisioned throughput consumed, along with statistics for the table
// and any indexes involved in the operation. ConsumedCapacity is only returned
// if the request asked for it. For more information, see Provisioned Throughput
// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html)
// in the Amazon DynamoDB Developer Guide.
type ConsumedCapacity struct {
	_ struct{} `type:"structure"`

	// The total number of capacity units consumed by the operation.
	CapacityUnits *float64 `type:"double"`

	// The amount of throughput consumed on each global index affected by the operation.
	GlobalSecondaryIndexes map[string]*Capacity `type:"map"`

	// The amount of throughput consumed on each local index affected by the operation.
	LocalSecondaryIndexes map[string]*Capacity `type:"map"`

	// The total number of read capacity units consumed by the operation.
	ReadCapacityUnits *float64 `type:"double"`

	// The amount of throughput consumed on the table affected by the operation.
	Table *Capacity `type:"structure"`

	// The name of the table that was affected by the operation.
	TableName *string `min:"3" type:"string"`

	// The total number of write capacity units consumed by the operation.
	WriteCapacityUnits *float64 `type:"double"`
}

// String returns the string representation
func (s ConsumedCapacity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConsumedCapacity) GoString() string {
	return s.String()
}

// SetCapacityUnits sets the CapacityUnits field's value.
func (s *ConsumedCapacity) SetCapacityUnits(v float64) *ConsumedCapacity {
	s.CapacityUnits = &v
	return s
}

// SetGlobalSecondaryIndexes sets the GlobalSecondaryIndexes field's value.
func (s *ConsumedCapacity) SetGlobalSecondaryIndexes(v map[string]*Capacity) *ConsumedCapacity {
	s.GlobalSecondaryIndexes = v
	return s
}

// SetLocalSecondaryIndexes sets the LocalSecondaryIndexes field's value.
func (s *ConsumedCapacity) SetLocalSecondaryIndexes(v map[string]*Capacity) *ConsumedCapacity {
	s.LocalSecondaryIndexes = v
	return s
}

// SetReadCapacityUnits sets the ReadCapacityUnits field's value.
func (s *ConsumedCapacity) SetReadCapacityUnits(v float64) *ConsumedCapacity {
	s.ReadCapacityUnits = &v
	return s
}

// SetTable sets the Table field's value.
func (s *ConsumedCapacity) SetTable(v *Capacity) *ConsumedCapacity {
	s.Table = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *ConsumedCapacity) SetTableName(v string) *ConsumedCapacity {
	s.TableName = &v
	return s
}

// SetWriteCapacityUnits sets the WriteCapacityUnits field's value.
func (s *ConsumedCapacity) SetWriteCapacityUnits(v float64) *ConsumedCapacity {
	s.WriteCapacityUnits = &v
	return s
}

// Represents the continuous backups and point in time recovery settings on
// the table.
type ContinuousBackupsDescription struct {
	_ struct{} `type:"structure"`

	// ContinuousBackupsStatus can be one of the following states: ENABLED, DISABLED
	//
	// ContinuousBackupsStatus is a required field
	ContinuousBackupsStatus *string `type:"string" required:"true" enum:"ContinuousBackupsStatus"`

	// The description of the point in time recovery settings applied to the table.
	PointInTimeRecoveryDescription *PointInTimeRecoveryDescription `type:"structure"`
}

// String returns the string representation
func (s ContinuousBackupsDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContinuousBackupsDescription) GoString() string {
	return s.String()
}

// SetContinuousBackupsStatus sets the ContinuousBackupsStatus field's value.
func (s *ContinuousBackupsDescription) SetContinuousBackupsStatus(v string) *ContinuousBackupsDescription {
	s.ContinuousBackupsStatus = &v
	return s
}

// SetPointInTimeRecoveryDescription sets the PointInTimeRecoveryDescription field's value.
func (s *ContinuousBackupsDescription) SetPointInTimeRecoveryDescription(v *PointInTimeRecoveryDescription) *ContinuousBackupsDescription {
	s.PointInTimeRecoveryDescription = v
	return s
}

// Represents a Contributor Insights summary entry..
type ContributorInsightsSummary struct {
	_ struct{} `type:"structure"`

	// Describes the current status for contributor insights for the given table
	// and index, if applicable.
	ContributorInsightsStatus *string `type:"string" enum:"ContributorInsightsStatus"`

	// Name of the index associated with the summary, if any.
	IndexName *string `min:"3" type:"string"`

	// Name of the table associated with the summary.
	TableName *string `min:"3" type:"string"`
}

// String returns the string representation
func (s ContributorInsightsSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContributorInsightsSummary) GoString() string {
	return s.String()
}

// SetContributorInsightsStatus sets the ContributorInsightsStatus field's value.
func (s *ContributorInsightsSummary) SetContributorInsightsStatus(v string) *ContributorInsightsSummary {
	s.ContributorInsightsStatus = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *ContributorInsightsSummary) SetIndexName(v string) *ContributorInsightsSummary {
	s.IndexName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *ContributorInsightsSummary) SetTableName(v string) *ContributorInsightsSummary {
	s.TableName = &v
	return s
}

type CreateBackupInput struct {
	_ struct{} `type:"structure"`

	// Specified name for the backup.
	//
	// BackupName is a required field
	BackupName *string `min:"3" type:"string" required:"true"`

	// The name of the table.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateBackupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBackupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBackupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBackupInput"}
	if s.BackupName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupName"))
	}
	if s.BackupName != nil && len(*s.BackupName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BackupName", 3))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupName sets the BackupName field's value.
func (s *CreateBackupInput) SetBackupName(v string) *CreateBackupInput {
	s.BackupName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *CreateBackupInput) SetTableName(v string) *CreateBackupInput {
	s.TableName = &v
	return s
}

type CreateBackupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of the backup created for the table.
	BackupDetails *BackupDetails `type:"structure"`
}

// String returns the string representation
func (s CreateBackupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBackupOutput) GoString() string {
	return s.String()
}

// SetBackupDetails sets the BackupDetails field's value.
func (s *CreateBackupOutput) SetBackupDetails(v *BackupDetails) *CreateBackupOutput {
	s.BackupDetails = v
	return s
}

// Represents a new global secondary index to be added to an existing table.
type CreateGlobalSecondaryIndexAction struct {
	_ struct{} `type:"structure"`

	// The name of the global secondary index to be created.
	//
	// IndexName is a required field
	IndexName *string `min:"3" type:"string" required:"true"`

	// The key schema for the global secondary index.
	//
	// KeySchema is a required field
	KeySchema []*KeySchemaElement `min:"1" type:"list" required:"true"`

	// Represents attributes that are copied (projected) from the table into an
	// index. These are in addition to the primary key attributes and index key
	// attributes, which are automatically projected.
	//
	// Projection is a required field
	Projection *Projection `type:"structure" required:"true"`

	// Represents the provisioned throughput settings for the specified global secondary
	// index.
	//
	// For current minimum and maximum provisioned throughput values, see Limits
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html)
	// in the Amazon DynamoDB Developer Guide.
	ProvisionedThroughput *ProvisionedThroughput `type:"structure"`
}

// String returns the string representation
func (s CreateGlobalSecondaryIndexAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGlobalSecondaryIndexAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGlobalSecondaryIndexAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGlobalSecondaryIndexAction"}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 3))
	}
	if s.KeySchema == nil {
		invalidParams.Add(request.NewErrParamRequired("KeySchema"))
	}
	if s.KeySchema != nil && len(s.KeySchema) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeySchema", 1))
	}
	if s.Projection == nil {
		invalidParams.Add(request.NewErrParamRequired("Projection"))
	}
	if s.KeySchema != nil {
		for i, v := range s.KeySchema {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "KeySchema", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Projection != nil {
		if err := s.Projection.Validate(); err != nil {
			invalidParams.AddNested("Projection", err.(request.ErrInvalidParams))
		}
	}
	if s.ProvisionedThroughput != nil {
		if err := s.ProvisionedThroughput.Validate(); err != nil {
			invalidParams.AddNested("ProvisionedThroughput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexName sets the IndexName field's value.
func (s *CreateGlobalSecondaryIndexAction) SetIndexName(v string) *CreateGlobalSecondaryIndexAction {
	s.IndexName = &v
	return s
}

// SetKeySchema sets the KeySchema field's value.
func (s *CreateGlobalSecondaryIndexAction) SetKeySchema(v []*KeySchemaElement) *CreateGlobalSecondaryIndexAction {
	s.KeySchema = v
	return s
}

// SetProjection sets the Projection field's value.
func (s *CreateGlobalSecondaryIndexAction) SetProjection(v *Projection) *CreateGlobalSecondaryIndexAction {
	s.Projection = v
	return s
}

// SetProvisionedThroughput sets the ProvisionedThroughput field's value.
func (s *CreateGlobalSecondaryIndexAction) SetProvisionedThroughput(v *ProvisionedThroughput) *CreateGlobalSecondaryIndexAction {
	s.ProvisionedThroughput = v
	return s
}

type CreateGlobalTableInput struct {
	_ struct{} `type:"structure"`

	// The global table name.
	//
	// GlobalTableName is a required field
	GlobalTableName *string `min:"3" type:"string" required:"true"`

	// The Regions where the global table needs to be created.
	//
	// ReplicationGroup is a required field
	ReplicationGroup []*Replica `type:"list" required:"true"`
}

// String returns the string representation
func (s CreateGlobalTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGlobalTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGlobalTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGlobalTableInput"}
	if s.GlobalTableName == nil {
		invalidParams.Add(request.NewErrParamRequired("GlobalTableName"))
	}
	if s.GlobalTableName != nil && len(*s.GlobalTableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("GlobalTableName", 3))
	}
	if s.ReplicationGroup == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationGroup"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGlobalTableName sets the GlobalTableName field's value.
func (s *CreateGlobalTableInput) SetGlobalTableName(v string) *CreateGlobalTableInput {
	s.GlobalTableName = &v
	return s
}

// SetReplicationGroup sets the ReplicationGroup field's value.
func (s *CreateGlobalTableInput) SetReplicationGroup(v []*Replica) *CreateGlobalTableInput {
	s.ReplicationGroup = v
	return s
}

type CreateGlobalTableOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of the global table.
	GlobalTableDescription *GlobalTableDescription `type:"structure"`
}

// String returns the string representation
func (s CreateGlobalTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGlobalTableOutput) GoString() string {
	return s.String()
}

// SetGlobalTableDescription sets the GlobalTableDescription field's value.
func (s *CreateGlobalTableOutput) SetGlobalTableDescription(v *GlobalTableDescription) *CreateGlobalTableOutput {
	s.GlobalTableDescription = v
	return s
}

// Represents a replica to be added.
type CreateReplicaAction struct {
	_ struct{} `type:"structure"`

	// The Region of the replica to be added.
	//
	// RegionName is a required field
	RegionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateReplicaAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReplicaAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReplicaAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReplicaAction"}
	if s.RegionName == nil {
		invalidParams.Add(request.NewErrParamRequired("RegionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRegionName sets the RegionName field's value.
func (s *CreateReplicaAction) SetRegionName(v string) *CreateReplicaAction {
	s.RegionName = &v
	return s
}

// Represents a replica to be created.
type CreateReplicationGroupMemberAction struct {
	_ struct{} `type:"structure"`

	// Replica-specific global secondary index settings.
	GlobalSecondaryIndexes []*ReplicaGlobalSecondaryIndex `min:"1" type:"list"`

	// The AWS KMS customer master key (CMK) that should be used for AWS KMS encryption
	// in the new replica. To specify a CMK, use its key ID, Amazon Resource Name
	// (ARN), alias name, or alias ARN. Note that you should only provide this parameter
	// if the key is different from the default DynamoDB KMS master key alias/aws/dynamodb.
	KMSMasterKeyId *string `type:"string"`

	// Replica-specific provisioned throughput. If not specified, uses the source
	// table's provisioned throughput settings.
	ProvisionedThroughputOverride *ProvisionedThroughputOverride `type:"structure"`

	// The Region where the new replica will be created.
	//
	// RegionName is a required field
	RegionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateReplicationGroupMemberAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReplicationGroupMemberAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReplicationGroupMemberAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReplicationGroupMemberAction"}
	if s.GlobalSecondaryIndexes != nil && len(s.GlobalSecondaryIndexes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GlobalSecondaryIndexes", 1))
	}
	if s.RegionName == nil {
		invalidParams.Add(request.NewErrParamRequired("RegionName"))
	}
	if s.GlobalSecondaryIndexes != nil {
		for i, v := range s.GlobalSecondaryIndexes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "GlobalSecondaryIndexes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ProvisionedThroughputOverride != nil {
		if err := s.ProvisionedThroughputOverride.Validate(); err != nil {
			invalidParams.AddNested("ProvisionedThroughputOverride", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGlobalSecondaryIndexes sets the GlobalSecondaryIndexes field's value.
func (s *CreateReplicationGroupMemberAction) SetGlobalSecondaryIndexes(v []*ReplicaGlobalSecondaryIndex) *CreateReplicationGroupMemberAction {
	s.GlobalSecondaryIndexes = v
	return s
}

// SetKMSMasterKeyId sets the KMSMasterKeyId field's value.
func (s *CreateReplicationGroupMemberAction) SetKMSMasterKeyId(v string) *CreateReplicationGroupMemberAction {
	s.KMSMasterKeyId = &v
	return s
}

// SetProvisionedThroughputOverride sets the ProvisionedThroughputOverride field's value.
func (s *CreateReplicationGroupMemberAction) SetProvisionedThroughputOverride(v *ProvisionedThroughputOverride) *CreateReplicationGroupMemberAction {
	s.ProvisionedThroughputOverride = v
	return s
}

// SetRegionName sets the RegionName field's value.
func (s *CreateReplicationGroupMemberAction) SetRegionName(v string) *CreateReplicationGroupMemberAction {
	s.RegionName = &v
	return s
}

// Represents the input of a CreateTable operation.
type CreateTableInput struct {
	_ struct{} `type:"structure"`

	// An array of attributes that describe the key schema for the table and indexes.
	//
	// AttributeDefinitions is a required field
	AttributeDefinitions []*AttributeDefinition `type:"list" required:"true"`

	// Controls how you are charged for read and write throughput and how you manage
	// capacity. This setting can be changed later.
	//
	//    * PROVISIONED - We recommend using PROVISIONED for predictable workloads.
	//    PROVISIONED sets the billing mode to Provisioned Mode (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual).
	//
	//    * PAY_PER_REQUEST - We recommend using PAY_PER_REQUEST for unpredictable
	//    workloads. PAY_PER_REQUEST sets the billing mode to On-Demand Mode (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand).
	BillingMode *string `type:"string" enum:"BillingMode"`

	// One or more global secondary indexes (the maximum is 20) to be created on
	// the table. Each global secondary index in the array includes the following:
	//
	//    * IndexName - The name of the global secondary index. Must be unique only
	//    for this table.
	//
	//    * KeySchema - Specifies the key schema for the global secondary index.
	//
	//    * Projection - Specifies attributes that are copied (projected) from the
	//    table into the index. These are in addition to the primary key attributes
	//    and index key attributes, which are automatically projected. Each attribute
	//    specification is composed of: ProjectionType - One of the following: KEYS_ONLY
	//    - Only the index and primary keys are projected into the index. INCLUDE
	//    - Only the specified table attributes are projected into the index. The
	//    list of projected attributes is in NonKeyAttributes. ALL - All of the
	//    table attributes are projected into the index. NonKeyAttributes - A list
	//    of one or more non-key attribute names that are projected into the secondary
	//    index. The total count of attributes provided in NonKeyAttributes, summed
	//    across all of the secondary indexes, must not exceed 100. If you project
	//    the same attribute into two different indexes, this counts as two distinct
	//    attributes when determining the total.
	//
	//    * ProvisionedThroughput - The provisioned throughput settings for the
	//    global secondary index, consisting of read and write capacity units.
	GlobalSecondaryIndexes []*GlobalSecondaryIndex `type:"list"`

	// Specifies the attributes that make up the primary key for a table or an index.
	// The attributes in KeySchema must also be defined in the AttributeDefinitions
	// array. For more information, see Data Model (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html)
	// in the Amazon DynamoDB Developer Guide.
	//
	// Each KeySchemaElement in the array is composed of:
	//
	//    * AttributeName - The name of this key attribute.
	//
	//    * KeyType - The role that the key attribute will assume: HASH - partition
	//    key RANGE - sort key
	//
	// The partition key of an item is also known as its hash attribute. The term
	// "hash attribute" derives from the DynamoDB usage of an internal hash function
	// to evenly distribute data items across partitions, based on their partition
	// key values.
	//
	// The sort key of an item is also known as its range attribute. The term "range
	// attribute" derives from the way DynamoDB stores items with the same partition
	// key physically close together, in sorted order by the sort key value.
	//
	// For a simple primary key (partition key), you must provide exactly one element
	// with a KeyType of HASH.
	//
	// For a composite primary key (partition key and sort key), you must provide
	// exactly two elements, in this order: The first element must have a KeyType
	// of HASH, and the second element must have a KeyType of RANGE.
	//
	// For more information, see Working with Tables (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key)
	// in the Amazon DynamoDB Developer Guide.
	//
	// KeySchema is a required field
	KeySchema []*KeySchemaElement `min:"1" type:"list" required:"true"`

	// One or more local secondary indexes (the maximum is 5) to be created on the
	// table. Each index is scoped to a given partition key value. There is a 10
	// GB size limit per partition key value; otherwise, the size of a local secondary
	// index is unconstrained.
	//
	// Each local secondary index in the array includes the following:
	//
	//    * IndexName - The name of the local secondary index. Must be unique only
	//    for this table.
	//
	//    * KeySchema - Specifies the key schema for the local secondary index.
	//    The key schema must begin with the same partition key as the table.
	//
	//    * Projection - Specifies attributes that are copied (projected) from the
	//    table into the index. These are in addition to the primary key attributes
	//    and index key attributes, which are automatically projected. Each attribute
	//    specification is composed of: ProjectionType - One of the following: KEYS_ONLY
	//    - Only the index and primary keys are projected into the index. INCLUDE
	//    - Only the specified table attributes are projected into the index. The
	//    list of projected attributes is in NonKeyAttributes. ALL - All of the
	//    table attributes are projected into the index. NonKeyAttributes - A list
	//    of one or more non-key attribute names that are projected into the secondary
	//    index. The total count of attributes provided in NonKeyAttributes, summed
	//    across all of the secondary indexes, must not exceed 100. If you project
	//    the same attribute into two different indexes, this counts as two distinct
	//    attributes when determining the total.
	LocalSecondaryIndexes []*LocalSecondaryIndex `type:"list"`

	// Represents the provisioned throughput settings for a specified table or index.
	// The settings can be modified using the UpdateTable operation.
	//
	// If you set BillingMode as PROVISIONED, you must specify this property. If
	// you set BillingMode as PAY_PER_REQUEST, you cannot specify this property.
	//
	// For current minimum and maximum provisioned throughput values, see Limits
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html)
	// in the Amazon DynamoDB Developer Guide.
	ProvisionedThroughput *ProvisionedThroughput `type:"structure"`

	// Represents the settings used to enable server-side encryption.
	SSESpecification *SSESpecification `type:"structure"`

	// The settings for DynamoDB Streams on the table. These settings consist of:
	//
	//    * StreamEnabled - Indicates whether DynamoDB Streams is to be enabled
	//    (true) or disabled (false).
	//
	//    * StreamViewType - When an item in the table is modified, StreamViewType
	//    determines what information is written to the table's stream. Valid values
	//    for StreamViewType are: KEYS_ONLY - Only the key attributes of the modified
	//    item are written to the stream. NEW_IMAGE - The entire item, as it appears
	//    after it was modified, is written to the stream. OLD_IMAGE - The entire
	//    item, as it appeared before it was modified, is written to the stream.
	//    NEW_AND_OLD_IMAGES - Both the new and the old item images of the item
	//    are written to the stream.
	StreamSpecification *StreamSpecification `type:"structure"`

	// The name of the table to create.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`

	// A list of key-value pairs to label the table. For more information, see Tagging
	// for DynamoDB (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html).
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTableInput"}
	if s.AttributeDefinitions == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeDefinitions"))
	}
	if s.KeySchema == nil {
		invalidParams.Add(request.NewErrParamRequired("KeySchema"))
	}
	if s.KeySchema != nil && len(s.KeySchema) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeySchema", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}
	if s.AttributeDefinitions != nil {
		for i, v := range s.AttributeDefinitions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AttributeDefinitions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.GlobalSecondaryIndexes != nil {
		for i, v := range s.GlobalSecondaryIndexes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "GlobalSecondaryIndexes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.KeySchema != nil {
		for i, v := range s.KeySchema {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "KeySchema", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.LocalSecondaryIndexes != nil {
		for i, v := range s.LocalSecondaryIndexes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LocalSecondaryIndexes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ProvisionedThroughput != nil {
		if err := s.ProvisionedThroughput.Validate(); err != nil {
			invalidParams.AddNested("ProvisionedThroughput", err.(request.ErrInvalidParams))
		}
	}
	if s.StreamSpecification != nil {
		if err := s.StreamSpecification.Validate(); err != nil {
			invalidParams.AddNested("StreamSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeDefinitions sets the AttributeDefinitions field's value.
func (s *CreateTableInput) SetAttributeDefinitions(v []*AttributeDefinition) *CreateTableInput {
	s.AttributeDefinitions = v
	return s
}

// SetBillingMode sets the BillingMode field's value.
func (s *CreateTableInput) SetBillingMode(v string) *CreateTableInput {
	s.BillingMode = &v
	return s
}

// SetGlobalSecondaryIndexes sets the GlobalSecondaryIndexes field's value.
func (s *CreateTableInput) SetGlobalSecondaryIndexes(v []*GlobalSecondaryIndex) *CreateTableInput {
	s.GlobalSecondaryIndexes = v
	return s
}

// SetKeySchema sets the KeySchema field's value.
func (s *CreateTableInput) SetKeySchema(v []*KeySchemaElement) *CreateTableInput {
	s.KeySchema = v
	return s
}

// SetLocalSecondaryIndexes sets the LocalSecondaryIndexes field's value.
func (s *CreateTableInput) SetLocalSecondaryIndexes(v []*LocalSecondaryIndex) *CreateTableInput {
	s.LocalSecondaryIndexes = v
	return s
}

// SetProvisionedThroughput sets the ProvisionedThroughput field's value.
func (s *CreateTableInput) SetProvisionedThroughput(v *ProvisionedThroughput) *CreateTableInput {
	s.ProvisionedThroughput = v
	return s
}

// SetSSESpecification sets the SSESpecification field's value.
func (s *CreateTableInput) SetSSESpecification(v *SSESpecification) *CreateTableInput {
	s.SSESpecification = v
	return s
}

// SetStreamSpecification sets the StreamSpecification field's value.
func (s *CreateTableInput) SetStreamSpecification(v *StreamSpecification) *CreateTableInput {
	s.StreamSpecification = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *CreateTableInput) SetTableName(v string) *CreateTableInput {
	s.TableName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTableInput) SetTags(v []*Tag) *CreateTableInput {
	s.Tags = v
	return s
}

// Represents the output of a CreateTable operation.
type CreateTableOutput struct {
	_ struct{} `type:"structure"`

	// Represents the properties of the table.
	TableDescription *TableDescription `type:"structure"`
}

// String returns the string representation
func (s CreateTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTableOutput) GoString() string {
	return s.String()
}

// SetTableDescription sets the TableDescription field's value.
func (s *CreateTableOutput) SetTableDescription(v *TableDescription) *CreateTableOutput {
	s.TableDescription = v
	return s
}

// Represents a request to perform a DeleteItem operation.
type Delete struct {
	_ struct{} `type:"structure"`

	// A condition that must be satisfied in order for a conditional delete to succeed.
	ConditionExpression *string `type:"string"`

	// One or more substitution tokens for attribute names in an expression.
	ExpressionAttributeNames map[string]*string `type:"map"`

	// One or more values that can be substituted in an expression.
	ExpressionAttributeValues map[string]*AttributeValue `type:"map"`

	// The primary key of the item to be deleted. Each element consists of an attribute
	// name and a value for that attribute.
	//
	// Key is a required field
	Key map[string]*AttributeValue `type:"map" required:"true"`

	// Use ReturnValuesOnConditionCheckFailure to get the item attributes if the
	// Delete condition fails. For ReturnValuesOnConditionCheckFailure, the valid
	// values are: NONE and ALL_OLD.
	ReturnValuesOnConditionCheckFailure *string `type:"string" enum:"ReturnValuesOnConditionCheckFailure"`

	// Name of the table in which the item to be deleted resides.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s Delete) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Delete) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Delete) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Delete"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConditionExpression sets the ConditionExpression field's value.
func (s *Delete) SetConditionExpression(v string) *Delete {
	s.ConditionExpression = &v
	return s
}

// SetExpressionAttributeNames sets the ExpressionAttributeNames field's value.
func (s *Delete) SetExpressionAttributeNames(v map[string]*string) *Delete {
	s.ExpressionAttributeNames = v
	return s
}

// SetExpressionAttributeValues sets the ExpressionAttributeValues field's value.
func (s *Delete) SetExpressionAttributeValues(v map[string]*AttributeValue) *Delete {
	s.ExpressionAttributeValues = v
	return s
}

// SetKey sets the Key field's value.
func (s *Delete) SetKey(v map[string]*AttributeValue) *Delete {
	s.Key = v
	return s
}

// SetReturnValuesOnConditionCheckFailure sets the ReturnValuesOnConditionCheckFailure field's value.
func (s *Delete) SetReturnValuesOnConditionCheckFailure(v string) *Delete {
	s.ReturnValuesOnConditionCheckFailure = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *Delete) SetTableName(v string) *Delete {
	s.TableName = &v
	return s
}

type DeleteBackupInput struct {
	_ struct{} `type:"structure"`

	// The ARN associated with the backup.
	//
	// BackupArn is a required field
	BackupArn *string `min:"37" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBackupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBackupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBackupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBackupInput"}
	if s.BackupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupArn"))
	}
	if s.BackupArn != nil && len(*s.BackupArn) < 37 {
		invalidParams.Add(request.NewErrParamMinLen("BackupArn", 37))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupArn sets the BackupArn field's value.
func (s *DeleteBackupInput) SetBackupArn(v string) *DeleteBackupInput {
	s.BackupArn = &v
	return s
}

type DeleteBackupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the description of the backup created for the table.
	BackupDescription *BackupDescription `type:"structure"`
}

// String returns the string representation
func (s DeleteBackupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBackupOutput) GoString() string {
	return s.String()
}

// SetBackupDescription sets the BackupDescription field's value.
func (s *DeleteBackupOutput) SetBackupDescription(v *BackupDescription) *DeleteBackupOutput {
	s.BackupDescription = v
	return s
}

// Represents a global secondary index to be deleted from an existing table.
type DeleteGlobalSecondaryIndexAction struct {
	_ struct{} `type:"structure"`

	// The name of the global secondary index to be deleted.
	//
	// IndexName is a required field
	IndexName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGlobalSecondaryIndexAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGlobalSecondaryIndexAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGlobalSecondaryIndexAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGlobalSecondaryIndexAction"}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexName sets the IndexName field's value.
func (s *DeleteGlobalSecondaryIndexAction) SetIndexName(v string) *DeleteGlobalSecondaryIndexAction {
	s.IndexName = &v
	return s
}

// Represents the input of a DeleteItem operation.
type DeleteItemInput struct {
	_ struct{} `type:"structure"`

	// A condition that must be satisfied in order for a conditional DeleteItem
	// to succeed.
	//
	// An expression can contain any of the following:
	//
	//    * Functions: attribute_exists | attribute_not_exists | attribute_type
	//    | contains | begins_with | size These function names are case-sensitive.
	//
	//    * Comparison operators: = | <> | < | > | <= | >= | BETWEEN | IN
	//
	//    * Logical operators: AND | OR | NOT
	//
	// For more information about condition expressions, see Condition Expressions
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html)
	// in the Amazon DynamoDB Developer Guide.
	ConditionExpression *string `type:"string"`

	// This is a legacy parameter. Use ConditionExpression instead. For more information,
	// see ConditionalOperator (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html)
	// in the Amazon DynamoDB Developer Guide.
	ConditionalOperator *string `type:"string" enum:"ConditionalOperator"`

	// This is a legacy parameter. Use ConditionExpression instead. For more information,
	// see Expected (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html)
	// in the Amazon DynamoDB Developer Guide.
	Expected map[string]*ExpectedAttributeValue `type:"map"`

	// One or more substitution tokens for attribute names in an expression. The
	// following are some use cases for using ExpressionAttributeNames:
	//
	//    * To access an attribute whose name conflicts with a DynamoDB reserved
	//    word.
	//
	//    * To create a placeholder for repeating occurrences of an attribute name
	//    in an expression.
	//
	//    * To prevent special characters in an attribute name from being misinterpreted
	//    in an expression.
	//
	// Use the # character in an expression to dereference an attribute name. For
	// example, consider the following attribute name:
	//
	//    * Percentile
	//
	// The name of this attribute conflicts with a reserved word, so it cannot be
	// used directly in an expression. (For the complete list of reserved words,
	// see Reserved Words (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
	// in the Amazon DynamoDB Developer Guide). To work around this, you could specify
	// the following for ExpressionAttributeNames:
	//
	//    * {"#P":"Percentile"}
	//
	// You could then use this substitution in an expression, as in this example:
	//
	//    * #P = :val
	//
	// Tokens that begin with the : character are expression attribute values, which
	// are placeholders for the actual value at runtime.
	//
	// For more information on expression attribute names, see Specifying Item Attributes
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
	// in the Amazon DynamoDB Developer Guide.
	ExpressionAttributeNames map[string]*string `type:"map"`

	// One or more values that can be substituted in an expression.
	//
	// Use the : (colon) character in an expression to dereference an attribute
	// value. For example, suppose that you wanted to check whether the value of
	// the ProductStatus attribute was one of the following:
	//
	// Available | Backordered | Discontinued
	//
	// You would first need to specify ExpressionAttributeValues as follows:
	//
	// { ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"}
	// }
	//
	// You could then use these values in an expression, such as this:
	//
	// ProductStatus IN (:avail, :back, :disc)
	//
	// For more information on expression attribute values, see Condition Expressions
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html)
	// in the Amazon DynamoDB Developer Guide.
	ExpressionAttributeValues map[string]*AttributeValue `type:"map"`

	// A map of attribute names to AttributeValue objects, representing the primary
	// key of the item to delete.
	//
	// For the primary key, you must provide all of the attributes. For example,
	// with a simple primary key, you only need to provide a value for the partition
	// key. For a composite primary key, you must provide values for both the partition
	// key and the sort key.
	//
	// Key is a required field
	Key map[string]*AttributeValue `type:"map" required:"true"`

	// Determines the level of detail about provisioned throughput consumption that
	// is returned in the response:
	//
	//    * INDEXES - The response includes the aggregate ConsumedCapacity for the
	//    operation, together with ConsumedCapacity for each table and secondary
	//    index that was accessed. Note that some operations, such as GetItem and
	//    BatchGetItem, do not access any indexes at all. In these cases, specifying
	//    INDEXES will only return ConsumedCapacity information for table(s).
	//
	//    * TOTAL - The response includes only the aggregate ConsumedCapacity for
	//    the operation.
	//
	//    * NONE - No ConsumedCapacity details are included in the response.
	ReturnConsumedCapacity *string `type:"string" enum:"ReturnConsumedCapacity"`

	// Determines whether item collection metrics are returned. If set to SIZE,
	// the response includes statistics about item collections, if any, that were
	// modified during the operation are returned in the response. If set to NONE
	// (the default), no statistics are returned.
	ReturnItemCollectionMetrics *string `type:"string" enum:"ReturnItemCollectionMetrics"`

	// Use ReturnValues if you want to get the item attributes as they appeared
	// before they were deleted. For DeleteItem, the valid values are:
	//
	//    * NONE - If ReturnValues is not specified, or if its value is NONE, then
	//    nothing is returned. (This setting is the default for ReturnValues.)
	//
	//    * ALL_OLD - The content of the old item is returned.
	//
	// The ReturnValues parameter is used by several DynamoDB operations; however,
	// DeleteItem does not recognize any values other than NONE or ALL_OLD.
	ReturnValues *string `type:"string" enum:"ReturnValue"`

	// The name of the table from which to delete the item.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteItemInput"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConditionExpression sets the ConditionExpression field's value.
func (s *DeleteItemInput) SetConditionExpression(v string) *DeleteItemInput {
	s.ConditionExpression = &v
	return s
}

// SetConditionalOperator sets the ConditionalOperator field's value.
func (s *DeleteItemInput) SetConditionalOperator(v string) *DeleteItemInput {
	s.ConditionalOperator = &v
	return s
}

// SetExpected sets the Expected field's value.
func (s *DeleteItemInput) SetExpected(v map[string]*ExpectedAttributeValue) *DeleteItemInput {
	s.Expected = v
	return s
}

// SetExpressionAttributeNames sets the ExpressionAttributeNames field's value.
func (s *DeleteItemInput) SetExpressionAttributeNames(v map[string]*string) *DeleteItemInput {
	s.ExpressionAttributeNames = v
	return s
}

// SetExpressionAttributeValues sets the ExpressionAttributeValues field's value.
func (s *DeleteItemInput) SetExpressionAttributeValues(v map[string]*AttributeValue) *DeleteItemInput {
	s.ExpressionAttributeValues = v
	return s
}

// SetKey sets the Key field's value.
func (s *DeleteItemInput) SetKey(v map[string]*AttributeValue) *DeleteItemInput {
	s.Key = v
	return s
}

// SetReturnConsumedCapacity sets the ReturnConsumedCapacity field's value.
func (s *DeleteItemInput) SetReturnConsumedCapacity(v string) *DeleteItemInput {
	s.ReturnConsumedCapacity = &v
	return s
}

// SetReturnItemCollectionMetrics sets the ReturnItemCollectionMetrics field's value.
func (s *DeleteItemInput) SetReturnItemCollectionMetrics(v string) *DeleteItemInput {
	s.ReturnItemCollectionMetrics = &v
	return s
}

// SetReturnValues sets the ReturnValues field's value.
func (s *DeleteItemInput) SetReturnValues(v string) *DeleteItemInput {
	s.ReturnValues = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *DeleteItemInput) SetTableName(v string) *DeleteItemInput {
	s.TableName = &v
	return s
}

// Represents the output of a DeleteItem operation.
type DeleteItemOutput struct {
	_ struct{} `type:"structure"`

	// A map of attribute names to AttributeValue objects, representing the item
	// as it appeared before the DeleteItem operation. This map appears in the response
	// only if ReturnValues was specified as ALL_OLD in the request.
	Attributes map[string]*AttributeValue `type:"map"`

	// The capacity units consumed by the DeleteItem operation. The data returned
	// includes the total provisioned throughput consumed, along with statistics
	// for the table and any indexes involved in the operation. ConsumedCapacity
	// is only returned if the ReturnConsumedCapacity parameter was specified. For
	// more information, see Provisioned Mode (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html)
	// in the Amazon DynamoDB Developer Guide.
	ConsumedCapacity *ConsumedCapacity `type:"structure"`

	// Information about item collections, if any, that were affected by the DeleteItem
	// operation. ItemCollectionMetrics is only returned if the ReturnItemCollectionMetrics
	// parameter was specified. If the table does not have any local secondary indexes,
	// this information is not returned in the response.
	//
	// Each ItemCollectionMetrics element consists of:
	//
	//    * ItemCollectionKey - The partition key value of the item collection.
	//    This is the same as the partition key value of the item itself.
	//
	//    * SizeEstimateRangeGB - An estimate of item collection size, in gigabytes.
	//    This value is a two-element array containing a lower bound and an upper
	//    bound for the estimate. The estimate includes the size of all the items
	//    in the table, plus the size of all attributes projected into all of the
	//    local secondary indexes on that table. Use this estimate to measure whether
	//    a local secondary index is approaching its size limit. The estimate is
	//    subject to change over time; therefore, do not rely on the precision or
	//    accuracy of the estimate.
	ItemCollectionMetrics *ItemCollectionMetrics `type:"structure"`
}

// String returns the string representation
func (s DeleteItemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteItemOutput) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *DeleteItemOutput) SetAttributes(v map[string]*AttributeValue) *DeleteItemOutput {
	s.Attributes = v
	return s
}

// SetConsumedCapacity sets the ConsumedCapacity field's value.
func (s *DeleteItemOutput) SetConsumedCapacity(v *ConsumedCapacity) *DeleteItemOutput {
	s.ConsumedCapacity = v
	return s
}

// SetItemCollectionMetrics sets the ItemCollectionMetrics field's value.
func (s *DeleteItemOutput) SetItemCollectionMetrics(v *ItemCollectionMetrics) *DeleteItemOutput {
	s.ItemCollectionMetrics = v
	return s
}

// Represents a replica to be removed.
type DeleteReplicaAction struct {
	_ struct{} `type:"structure"`

	// The Region of the replica to be removed.
	//
	// RegionName is a required field
	RegionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteReplicaAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReplicaAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReplicaAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReplicaAction"}
	if s.RegionName == nil {
		invalidParams.Add(request.NewErrParamRequired("RegionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRegionName sets the RegionName field's value.
func (s *DeleteReplicaAction) SetRegionName(v string) *DeleteReplicaAction {
	s.RegionName = &v
	return s
}

// Represents a replica to be deleted.
type DeleteReplicationGroupMemberAction struct {
	_ struct{} `type:"structure"`

	// The Region where the replica exists.
	//
	// RegionName is a required field
	RegionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteReplicationGroupMemberAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReplicationGroupMemberAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReplicationGroupMemberAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReplicationGroupMemberAction"}
	if s.RegionName == nil {
		invalidParams.Add(request.NewErrParamRequired("RegionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRegionName sets the RegionName field's value.
func (s *DeleteReplicationGroupMemberAction) SetRegionName(v string) *DeleteReplicationGroupMemberAction {
	s.RegionName = &v
	return s
}

// Represents a request to perform a DeleteItem operation on an item.
type DeleteRequest struct {
	_ struct{} `type:"structure"`

	// A map of attribute name to attribute values, representing the primary key
	// of the item to delete. All of the table's primary key attributes must be
	// specified, and their data types must match those of the table's key schema.
	//
	// Key is a required field
	Key map[string]*AttributeValue `type:"map" required:"true"`
}

// String returns the string representation
func (s DeleteRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRequest) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *DeleteRequest) SetKey(v map[string]*AttributeValue) *DeleteRequest {
	s.Key = v
	return s
}

// Represents the input of a DeleteTable operation.
type DeleteTableInput struct {
	_ struct{} `type:"structure"`

	// The name of the table to delete.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTableInput"}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTableName sets the TableName field's value.
func (s *DeleteTableInput) SetTableName(v string) *DeleteTableInput {
	s.TableName = &v
	return s
}

// Represents the output of a DeleteTable operation.
type DeleteTableOutput struct {
	_ struct{} `type:"structure"`

	// Represents the properties of a table.
	TableDescription *TableDescription `type:"structure"`
}

// String returns the string representation
func (s DeleteTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTableOutput) GoString() string {
	return s.String()
}

// SetTableDescription sets the TableDescription field's value.
func (s *DeleteTableOutput) SetTableDescription(v *TableDescription) *DeleteTableOutput {
	s.TableDescription = v
	return s
}

type DescribeBackupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) associated with the backup.
	//
	// BackupArn is a required field
	BackupArn *string `min:"37" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeBackupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBackupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBackupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBackupInput"}
	if s.BackupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupArn"))
	}
	if s.BackupArn != nil && len(*s.BackupArn) < 37 {
		invalidParams.Add(request.NewErrParamMinLen("BackupArn", 37))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupArn sets the BackupArn field's value.
func (s *DescribeBackupInput) SetBackupArn(v string) *DescribeBackupInput {
	s.BackupArn = &v
	return s
}

type DescribeBackupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the description of the backup created for the table.
	BackupDescription *BackupDescription `type:"structure"`
}

// String returns the string representation
func (s DescribeBackupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBackupOutput) GoString() string {
	return s.String()
}

// SetBackupDescription sets the BackupDescription field's value.
func (s *DescribeBackupOutput) SetBackupDescription(v *BackupDescription) *DescribeBackupOutput {
	s.BackupDescription = v
	return s
}

type DescribeContinuousBackupsInput struct {
	_ struct{} `type:"structure"`

	// Name of the table for which the customer wants to check the continuous backups
	// and point in time recovery settings.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeContinuousBackupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeContinuousBackupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeContinuousBackupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeContinuousBackupsInput"}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTableName sets the TableName field's value.
func (s *DescribeContinuousBackupsInput) SetTableName(v string) *DescribeContinuousBackupsInput {
	s.TableName = &v
	return s
}

type DescribeContinuousBackupsOutput struct {
	_ struct{} `type:"structure"`

	// Represents the continuous backups and point in time recovery settings on
	// the table.
	ContinuousBackupsDescription *ContinuousBackupsDescription `type:"structure"`
}

// String returns the string representation
func (s DescribeContinuousBackupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeContinuousBackupsOutput) GoString() string {
	return s.String()
}

// SetContinuousBackupsDescription sets the ContinuousBackupsDescription field's value.
func (s *DescribeContinuousBackupsOutput) SetContinuousBackupsDescription(v *ContinuousBackupsDescription) *DescribeContinuousBackupsOutput {
	s.ContinuousBackupsDescription = v
	return s
}

type DescribeContributorInsightsInput struct {
	_ struct{} `type:"structure"`

	// The name of the global secondary index to describe, if applicable.
	IndexName *string `min:"3" type:"string"`

	// The name of the table to describe.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeContributorInsightsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeContributorInsightsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeContributorInsightsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeContributorInsightsInput"}
	if s.IndexName != nil && len(*s.IndexName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 3))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexName sets the IndexName field's value.
func (s *DescribeContributorInsightsInput) SetIndexName(v string) *DescribeContributorInsightsInput {
	s.IndexName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *DescribeContributorInsightsInput) SetTableName(v string) *DescribeContributorInsightsInput {
	s.TableName = &v
	return s
}

type DescribeContributorInsightsOutput struct {
	_ struct{} `type:"structure"`

	// List of names of the associated Alpine rules.
	ContributorInsightsRuleList []*string `type:"list"`

	// Current Status contributor insights.
	ContributorInsightsStatus *string `type:"string" enum:"ContributorInsightsStatus"`

	// Returns information about the last failure that encountered.
	//
	// The most common exceptions for a FAILED status are:
	//
	//    * LimitExceededException - Per-account Amazon CloudWatch Contributor Insights
	//    rule limit reached. Please disable Contributor Insights for other tables/indexes
	//    OR disable Contributor Insights rules before retrying.
	//
	//    * AccessDeniedException - Amazon CloudWatch Contributor Insights rules
	//    cannot be modified due to insufficient permissions.
	//
	//    * AccessDeniedException - Failed to create service-linked role for Contributor
	//    Insights due to insufficient permissions.
	//
	//    * InternalServerError - Failed to create Amazon CloudWatch Contributor
	//    Insights rules. Please retry request.
	FailureException *FailureException `type:"structure"`

	// The name of the global secondary index being described.
	IndexName *string `min:"3" type:"string"`

	// Timestamp of the last time the status was changed.
	LastUpdateDateTime *time.Time `type:"timestamp"`

	// The name of the table being described.
	TableName *string `min:"3" type:"string"`
}

// String returns the string representation
func (s DescribeContributorInsightsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeContributorInsightsOutput) GoString() string {
	return s.String()
}

// SetContributorInsightsRuleList sets the ContributorInsightsRuleList field's value.
func (s *DescribeContributorInsightsOutput) SetContributorInsightsRuleList(v []*string) *DescribeContributorInsightsOutput {
	s.ContributorInsightsRuleList = v
	return s
}

// SetContributorInsightsStatus sets the ContributorInsightsStatus field's value.
func (s *DescribeContributorInsightsOutput) SetContributorInsightsStatus(v string) *DescribeContributorInsightsOutput {
	s.ContributorInsightsStatus = &v
	return s
}

// SetFailureException sets the FailureException field's value.
func (s *DescribeContributorInsightsOutput) SetFailureException(v *FailureException) *DescribeContributorInsightsOutput {
	s.FailureException = v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *DescribeContributorInsightsOutput) SetIndexName(v string) *DescribeContributorInsightsOutput {
	s.IndexName = &v
	return s
}

// SetLastUpdateDateTime sets the LastUpdateDateTime field's value.
func (s *DescribeContributorInsightsOutput) SetLastUpdateDateTime(v time.Time) *DescribeContributorInsightsOutput {
	s.LastUpdateDateTime = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *DescribeContributorInsightsOutput) SetTableName(v string) *DescribeContributorInsightsOutput {
	s.TableName = &v
	return s
}

type DescribeEndpointsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointsInput) GoString() string {
	return s.String()
}

type DescribeEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// List of endpoints.
	//
	// Endpoints is a required field
	Endpoints []*Endpoint `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointsOutput) GoString() string {
	return s.String()
}

// SetEndpoints sets the Endpoints field's value.
func (s *DescribeEndpointsOutput) SetEndpoints(v []*Endpoint) *DescribeEndpointsOutput {
	s.Endpoints = v
	return s
}

type DescribeGlobalTableInput struct {
	_ struct{} `type:"structure"`

	// The name of the global table.
	//
	// GlobalTableName is a required field
	GlobalTableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeGlobalTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGlobalTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGlobalTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGlobalTableInput"}
	if s.GlobalTableName == nil {
		invalidParams.Add(request.NewErrParamRequired("GlobalTableName"))
	}
	if s.GlobalTableName != nil && len(*s.GlobalTableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("GlobalTableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGlobalTableName sets the GlobalTableName field's value.
func (s *DescribeGlobalTableInput) SetGlobalTableName(v string) *DescribeGlobalTableInput {
	s.GlobalTableName = &v
	return s
}

type DescribeGlobalTableOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of the global table.
	GlobalTableDescription *GlobalTableDescription `type:"structure"`
}

// String returns the string representation
func (s DescribeGlobalTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGlobalTableOutput) GoString() string {
	return s.String()
}

// SetGlobalTableDescription sets the GlobalTableDescription field's value.
func (s *DescribeGlobalTableOutput) SetGlobalTableDescription(v *GlobalTableDescription) *DescribeGlobalTableOutput {
	s.GlobalTableDescription = v
	return s
}

type DescribeGlobalTableSettingsInput struct {
	_ struct{} `type:"structure"`

	// The name of the global table to describe.
	//
	// GlobalTableName is a required field
	GlobalTableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeGlobalTableSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGlobalTableSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGlobalTableSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGlobalTableSettingsInput"}
	if s.GlobalTableName == nil {
		invalidParams.Add(request.NewErrParamRequired("GlobalTableName"))
	}
	if s.GlobalTableName != nil && len(*s.GlobalTableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("GlobalTableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGlobalTableName sets the GlobalTableName field's value.
func (s *DescribeGlobalTableSettingsInput) SetGlobalTableName(v string) *DescribeGlobalTableSettingsInput {
	s.GlobalTableName = &v
	return s
}

type DescribeGlobalTableSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The name of the global table.
	GlobalTableName *string `min:"3" type:"string"`

	// The Region-specific settings for the global table.
	ReplicaSettings []*ReplicaSettingsDescription `type:"list"`
}

// String returns the string representation
func (s DescribeGlobalTableSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGlobalTableSettingsOutput) GoString() string {
	return s.String()
}

// SetGlobalTableName sets the GlobalTableName field's value.
func (s *DescribeGlobalTableSettingsOutput) SetGlobalTableName(v string) *DescribeGlobalTableSettingsOutput {
	s.GlobalTableName = &v
	return s
}

// SetReplicaSettings sets the ReplicaSettings field's value.
func (s *DescribeGlobalTableSettingsOutput) SetReplicaSettings(v []*ReplicaSettingsDescription) *DescribeGlobalTableSettingsOutput {
	s.ReplicaSettings = v
	return s
}

// Represents the input of a DescribeLimits operation. Has no content.
type DescribeLimitsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLimitsInput) GoString() string {
	return s.String()
}

// Represents the output of a DescribeLimits operation.
type DescribeLimitsOutput struct {
	_ struct{} `type:"structure"`

	// The maximum total read capacity units that your account allows you to provision
	// across all of your tables in this Region.
	AccountMaxReadCapacityUnits *int64 `min:"1" type:"long"`

	// The maximum total write capacity units that your account allows you to provision
	// across all of your tables in this Region.
	AccountMaxWriteCapacityUnits *int64 `min:"1" type:"long"`

	// The maximum read capacity units that your account allows you to provision
	// for a new table that you are creating in this Region, including the read
	// capacity units provisioned for its global secondary indexes (GSIs).
	TableMaxReadCapacityUnits *int64 `min:"1" type:"long"`

	// The maximum write capacity units that your account allows you to provision
	// for a new table that you are creating in this Region, including the write
	// capacity units provisioned for its global secondary indexes (GSIs).
	TableMaxWriteCapacityUnits *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s DescribeLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLimitsOutput) GoString() string {
	return s.String()
}

// SetAccountMaxReadCapacityUnits sets the AccountMaxReadCapacityUnits field's value.
func (s *DescribeLimitsOutput) SetAccountMaxReadCapacityUnits(v int64) *DescribeLimitsOutput {
	s.AccountMaxReadCapacityUnits = &v
	return s
}

// SetAccountMaxWriteCapacityUnits sets the AccountMaxWriteCapacityUnits field's value.
func (s *DescribeLimitsOutput) SetAccountMaxWriteCapacityUnits(v int64) *DescribeLimitsOutput {
	s.AccountMaxWriteCapacityUnits = &v
	return s
}

// SetTableMaxReadCapacityUnits sets the TableMaxReadCapacityUnits field's value.
func (s *DescribeLimitsOutput) SetTableMaxReadCapacityUnits(v int64) *DescribeLimitsOutput {
	s.TableMaxReadCapacityUnits = &v
	return s
}

// SetTableMaxWriteCapacityUnits sets the TableMaxWriteCapacityUnits field's value.
func (s *DescribeLimitsOutput) SetTableMaxWriteCapacityUnits(v int64) *DescribeLimitsOutput {
	s.TableMaxWriteCapacityUnits = &v
	return s
}

// Represents the input of a DescribeTable operation.
type DescribeTableInput struct {
	_ struct{} `type:"structure"`

	// The name of the table to describe.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTableInput"}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTableName sets the TableName field's value.
func (s *DescribeTableInput) SetTableName(v string) *DescribeTableInput {
	s.TableName = &v
	return s
}

// Represents the output of a DescribeTable operation.
type DescribeTableOutput struct {
	_ struct{} `type:"structure"`

	// The properties of the table.
	Table *TableDescription `type:"structure"`
}

// String returns the string representation
func (s DescribeTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTableOutput) GoString() string {
	return s.String()
}

// SetTable sets the Table field's value.
func (s *DescribeTableOutput) SetTable(v *TableDescription) *DescribeTableOutput {
	s.Table = v
	return s
}

type DescribeTableReplicaAutoScalingInput struct {
	_ struct{} `type:"structure"`

	// The name of the table.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTableReplicaAutoScalingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTableReplicaAutoScalingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTableReplicaAutoScalingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTableReplicaAutoScalingInput"}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTableName sets the TableName field's value.
func (s *DescribeTableReplicaAutoScalingInput) SetTableName(v string) *DescribeTableReplicaAutoScalingInput {
	s.TableName = &v
	return s
}

type DescribeTableReplicaAutoScalingOutput struct {
	_ struct{} `type:"structure"`

	// Represents the auto scaling properties of the table.
	TableAutoScalingDescription *TableAutoScalingDescription `type:"structure"`
}

// String returns the string representation
func (s DescribeTableReplicaAutoScalingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTableReplicaAutoScalingOutput) GoString() string {
	return s.String()
}

// SetTableAutoScalingDescription sets the TableAutoScalingDescription field's value.
func (s *DescribeTableReplicaAutoScalingOutput) SetTableAutoScalingDescription(v *TableAutoScalingDescription) *DescribeTableReplicaAutoScalingOutput {
	s.TableAutoScalingDescription = v
	return s
}

type DescribeTimeToLiveInput struct {
	_ struct{} `type:"structure"`

	// The name of the table to be described.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTimeToLiveInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTimeToLiveInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTimeToLiveInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTimeToLiveInput"}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTableName sets the TableName field's value.
func (s *DescribeTimeToLiveInput) SetTableName(v string) *DescribeTimeToLiveInput {
	s.TableName = &v
	return s
}

type DescribeTimeToLiveOutput struct {
	_ struct{} `type:"structure"`

	// The description of the Time to Live (TTL) status on the specified table.
	TimeToLiveDescription *TimeToLiveDescription `type:"structure"`
}

// String returns the string representation
func (s DescribeTimeToLiveOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTimeToLiveOutput) GoString() string {
	return s.String()
}

// SetTimeToLiveDescription sets the TimeToLiveDescription field's value.
func (s *DescribeTimeToLiveOutput) SetTimeToLiveDescription(v *TimeToLiveDescription) *DescribeTimeToLiveOutput {
	s.TimeToLiveDescription = v
	return s
}

// An endpoint information details.
type Endpoint struct {
	_ struct{} `type:"structure"`

	// IP address of the endpoint.
	//
	// Address is a required field
	Address *string `type:"string" required:"true"`

	// Endpoint cache time to live (TTL) value.
	//
	// CachePeriodInMinutes is a required field
	CachePeriodInMinutes *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Endpoint) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *Endpoint) SetAddress(v string) *Endpoint {
	s.Address = &v
	return s
}

// SetCachePeriodInMinutes sets the CachePeriodInMinutes field's value.
func (s *Endpoint) SetCachePeriodInMinutes(v int64) *Endpoint {
	s.CachePeriodInMinutes = &v
	return s
}

// Represents a condition to be compared with an attribute value. This condition
// can be used with DeleteItem, PutItem, or UpdateItem operations; if the comparison
// evaluates to true, the operation succeeds; if not, the operation fails. You
// can use ExpectedAttributeValue in one of two different ways:
//
//    * Use AttributeValueList to specify one or more values to compare against
//    an attribute. Use ComparisonOperator to specify how you want to perform
//    the comparison. If the comparison evaluates to true, then the conditional
//    operation succeeds.
//
//    * Use Value to specify a value that DynamoDB will compare against an attribute.
//    If the values match, then ExpectedAttributeValue evaluates to true and
//    the conditional operation succeeds. Optionally, you can also set Exists
//    to false, indicating that you do not expect to find the attribute value
//    in the table. In this case, the conditional operation succeeds only if
//    the comparison evaluates to false.
//
// Value and Exists are incompatible with AttributeValueList and ComparisonOperator.
// Note that if you use both sets of parameters at once, DynamoDB will return
// a ValidationException exception.
type ExpectedAttributeValue struct {
	_ struct{} `type:"structure"`

	// One or more values to evaluate against the supplied attribute. The number
	// of values in the list depends on the ComparisonOperator being used.
	//
	// For type Number, value comparisons are numeric.
	//
	// String value comparisons for greater than, equals, or less than are based
	// on ASCII character code values. For example, a is greater than A, and a is
	// greater than B. For a list of code values, see http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters
	// (http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters).
	//
	// For Binary, DynamoDB treats each byte of the binary data as unsigned when
	// it compares binary values.
	//
	// For information on specifying data types in JSON, see JSON Data Format (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataFormat.html)
	// in the Amazon DynamoDB Developer Guide.
	AttributeValueList []*AttributeValue `type:"list"`

	// A comparator for evaluating attributes in the AttributeValueList. For example,
	// equals, greater than, less than, etc.
	//
	// The following comparison operators are available:
	//
	// EQ | NE | LE | LT | GE | GT | NOT_NULL | NULL | CONTAINS | NOT_CONTAINS |
	// BEGINS_WITH | IN | BETWEEN
	//
	// The following are descriptions of each comparison operator.
	//
	//    * EQ : Equal. EQ is supported for all data types, including lists and
	//    maps. AttributeValueList can contain only one AttributeValue element of
	//    type String, Number, Binary, String Set, Number Set, or Binary Set. If
	//    an item contains an AttributeValue element of a different type than the
	//    one provided in the request, the value does not match. For example, {"S":"6"}
	//    does not equal {"N":"6"}. Also, {"N":"6"} does not equal {"NS":["6", "2",
	//    "1"]}.
	//
	//    * NE : Not equal. NE is supported for all data types, including lists
	//    and maps. AttributeValueList can contain only one AttributeValue of type
	//    String, Number, Binary, String Set, Number Set, or Binary Set. If an item
	//    contains an AttributeValue of a different type than the one provided in
	//    the request, the value does not match. For example, {"S":"6"} does not
	//    equal {"N":"6"}. Also, {"N":"6"} does not equal {"NS":["6", "2", "1"]}.
	//
	//    * LE : Less than or equal. AttributeValueList can contain only one AttributeValue
	//    element of type String, Number, or Binary (not a set type). If an item
	//    contains an AttributeValue element of a different type than the one provided
	//    in the request, the value does not match. For example, {"S":"6"} does
	//    not equal {"N":"6"}. Also, {"N":"6"} does not compare to {"NS":["6", "2",
	//    "1"]}.
	//
	//    * LT : Less than. AttributeValueList can contain only one AttributeValue
	//    of type String, Number, or Binary (not a set type). If an item contains
	//    an AttributeValue element of a different type than the one provided in
	//    the request, the value does not match. For example, {"S":"6"} does not
	//    equal {"N":"6"}. Also, {"N":"6"} does not compare to {"NS":["6", "2",
	//    "1"]}.
	//
	//    * GE : Greater than or equal. AttributeValueList can contain only one
	//    AttributeValue element of type String, Number, or Binary (not a set type).
	//    If an item contains an AttributeValue element of a different type than
	//    the one provided in the request, the value does not match. For example,
	//    {"S":"6"} does not equal {"N":"6"}. Also, {"N":"6"} does not compare to
	//    {"NS":["6", "2", "1"]}.
	//
	//    * GT : Greater than. AttributeValueList can contain only one AttributeValue
	//    element of type String, Number, or Binary (not a set type). If an item
	//    contains an AttributeValue element of a different type than the one provided
	//    in the request, the value does not match. For example, {"S":"6"} does
	//    not equal {"N":"6"}. Also, {"N":"6"} does not compare to {"NS":["6", "2",
	//    "1"]}.
	//
	//    * NOT_NULL : The attribute exists. NOT_NULL is supported for all data
	//    types, including lists and maps. This operator tests for the existence
	//    of an attribute, not its data type. If the data type of attribute "a"
	//    is null, and you evaluate it using NOT_NULL, the result is a Boolean true.
	//    This result is because the attribute "a" exists; its data type is not
	//    relevant to the NOT_NULL comparison operator.
	//
	//    * NULL : The attribute does not exist. NULL is supported for all data
	//    types, including lists and maps. This operator tests for the nonexistence
	//    of an attribute, not its data type. If the data type of attribute "a"
	//    is null, and you evaluate it using NULL, the result is a Boolean false.
	//    This is because the attribute "a" exists; its data type is not relevant
	//    to the NULL comparison operator.
	//
	//    * CONTAINS : Checks for a subsequence, or value in a set. AttributeValueList
	//    can contain only one AttributeValue element of type String, Number, or
	//    Binary (not a set type). If the target attribute of the comparison is
	//    of type String, then the operator checks for a substring match. If the
	//    target attribute of the comparison is of type Binary, then the operator
	//    looks for a subsequence of the target that matches the input. If the target
	//    attribute of the comparison is a set ("SS", "NS", or "BS"), then the operator
	//    evaluates to true if it finds an exact match with any member of the set.
	//    CONTAINS is supported for lists: When evaluating "a CONTAINS b", "a" can
	//    be a list; however, "b" cannot be a set, a map, or a list.
	//
	//    * NOT_CONTAINS : Checks for absence of a subsequence, or absence of a
	//    value in a set. AttributeValueList can contain only one AttributeValue
	//    element of type String, Number, or Binary (not a set type). If the target
	//    attribute of the comparison is a String, then the operator checks for
	//    the absence of a substring match. If the target attribute of the comparison
	//    is Binary, then the operator checks for the absence of a subsequence of
	//    the target that matches the input. If the target attribute of the comparison
	//    is a set ("SS", "NS", or "BS"), then the operator evaluates to true if
	//    it does not find an exact match with any member of the set. NOT_CONTAINS
	//    is supported for lists: When evaluating "a NOT CONTAINS b", "a" can be
	//    a list; however, "b" cannot be a set, a map, or a list.
	//
	//    * BEGINS_WITH : Checks for a prefix. AttributeValueList can contain only
	//    one AttributeValue of type String or Binary (not a Number or a set type).
	//    The target attribute of the comparison must be of type String or Binary
	//    (not a Number or a set type).
	//
	//    * IN : Checks for matching elements in a list. AttributeValueList can
	//    contain one or more AttributeValue elements of type String, Number, or
	//    Binary. These attributes are compared against an existing attribute of
	//    an item. If any elements of the input are equal to the item attribute,
	//    the expression evaluates to true.
	//
	//    * BETWEEN : Greater than or equal to the first value, and less than or
	//    equal to the second value. AttributeValueList must contain two AttributeValue
	//    elements of the same type, either String, Number, or Binary (not a set
	//    type). A target attribute matches if the target value is greater than,
	//    or equal to, the first element and less than, or equal to, the second
	//    element. If an item contains an AttributeValue element of a different
	//    type than the one provided in the request, the value does not match. For
	//    example, {"S":"6"} does not compare to {"N":"6"}. Also, {"N":"6"} does
	//    not compare to {"NS":["6", "2", "1"]}
	ComparisonOperator *string `type:"string" enum:"ComparisonOperator"`

	// Causes DynamoDB to evaluate the value before attempting a conditional operation:
	//
	//    * If Exists is true, DynamoDB will check to see if that attribute value
	//    already exists in the table. If it is found, then the operation succeeds.
	//    If it is not found, the operation fails with a ConditionCheckFailedException.
	//
	//    * If Exists is false, DynamoDB assumes that the attribute value does not
	//    exist in the table. If in fact the value does not exist, then the assumption
	//    is valid and the operation succeeds. If the value is found, despite the
	//    assumption that it does not exist, the operation fails with a ConditionCheckFailedException.
	//
	// The default setting for Exists is true. If you supply a Value all by itself,
	// DynamoDB assumes the attribute exists: You don't have to set Exists to true,
	// because it is implied.
	//
	// DynamoDB returns a ValidationException if:
	//
	//    * Exists is true but there is no Value to check. (You expect a value to
	//    exist, but don't specify what that value is.)
	//
	//    * Exists is false but you also provide a Value. (You cannot expect an
	//    attribute to have a value, while also expecting it not to exist.)
	Exists *bool `type:"boolean"`

	// Represents the data for the expected attribute.
	//
	// Each attribute value is described as a name-value pair. The name is the data
	// type, and the value is the data itself.
	//
	// For more information, see Data Types (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes)
	// in the Amazon DynamoDB Developer Guide.
	Value *AttributeValue `type:"structure"`
}

// String returns the string representation
func (s ExpectedAttributeValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExpectedAttributeValue) GoString() string {
	return s.String()
}

// SetAttributeValueList sets the AttributeValueList field's value.
func (s *ExpectedAttributeValue) SetAttributeValueList(v []*AttributeValue) *ExpectedAttributeValue {
	s.AttributeValueList = v
	return s
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *ExpectedAttributeValue) SetComparisonOperator(v string) *ExpectedAttributeValue {
	s.ComparisonOperator = &v
	return s
}

// SetExists sets the Exists field's value.
func (s *ExpectedAttributeValue) SetExists(v bool) *ExpectedAttributeValue {
	s.Exists = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ExpectedAttributeValue) SetValue(v *AttributeValue) *ExpectedAttributeValue {
	s.Value = v
	return s
}

// Represents a failure a contributor insights operation.
type FailureException struct {
	_ struct{} `type:"structure"`

	// Description of the failure.
	ExceptionDescription *string `type:"string"`

	// Exception name.
	ExceptionName *string `type:"string"`
}

// String returns the string representation
func (s FailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailureException) GoString() string {
	return s.String()
}

// SetExceptionDescription sets the ExceptionDescription field's value.
func (s *FailureException) SetExceptionDescription(v string) *FailureException {
	s.ExceptionDescription = &v
	return s
}

// SetExceptionName sets the ExceptionName field's value.
func (s *FailureException) SetExceptionName(v string) *FailureException {
	s.ExceptionName = &v
	return s
}

// Specifies an item and related attribute values to retrieve in a TransactGetItem
// object.
type Get struct {
	_ struct{} `type:"structure"`

	// One or more substitution tokens for attribute names in the ProjectionExpression
	// parameter.
	ExpressionAttributeNames map[string]*string `type:"map"`

	// A map of attribute names to AttributeValue objects that specifies the primary
	// key of the item to retrieve.
	//
	// Key is a required field
	Key map[string]*AttributeValue `type:"map" required:"true"`

	// A string that identifies one or more attributes of the specified item to
	// retrieve from the table. The attributes in the expression must be separated
	// by commas. If no attribute names are specified, then all attributes of the
	// specified item are returned. If any of the requested attributes are not found,
	// they do not appear in the result.
	ProjectionExpression *string `type:"string"`

	// The name of the table from which to retrieve the specified item.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s Get) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Get) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Get) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Get"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpressionAttributeNames sets the ExpressionAttributeNames field's value.
func (s *Get) SetExpressionAttributeNames(v map[string]*string) *Get {
	s.ExpressionAttributeNames = v
	return s
}

// SetKey sets the Key field's value.
func (s *Get) SetKey(v map[string]*AttributeValue) *Get {
	s.Key = v
	return s
}

// SetProjectionExpression sets the ProjectionExpression field's value.
func (s *Get) SetProjectionExpression(v string) *Get {
	s.ProjectionExpression = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *Get) SetTableName(v string) *Get {
	s.TableName = &v
	return s
}

// Represents the input of a GetItem operation.
type GetItemInput struct {
	_ struct{} `type:"structure"`

	// This is a legacy parameter. Use ProjectionExpression instead. For more information,
	// see AttributesToGet (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html)
	// in the Amazon DynamoDB Developer Guide.
	AttributesToGet []*string `min:"1" type:"list"`

	// Determines the read consistency model: If set to true, then the operation
	// uses strongly consistent reads; otherwise, the operation uses eventually
	// consistent reads.
	ConsistentRead *bool `type:"boolean"`

	// One or more substitution tokens for attribute names in an expression. The
	// following are some use cases for using ExpressionAttributeNames:
	//
	//    * To access an attribute whose name conflicts with a DynamoDB reserved
	//    word.
	//
	//    * To create a placeholder for repeating occurrences of an attribute name
	//    in an expression.
	//
	//    * To prevent special characters in an attribute name from being misinterpreted
	//    in an expression.
	//
	// Use the # character in an expression to dereference an attribute name. For
	// example, consider the following attribute name:
	//
	//    * Percentile
	//
	// The name of this attribute conflicts with a reserved word, so it cannot be
	// used directly in an expression. (For the complete list of reserved words,
	// see Reserved Words (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
	// in the Amazon DynamoDB Developer Guide). To work around this, you could specify
	// the following for ExpressionAttributeNames:
	//
	//    * {"#P":"Percentile"}
	//
	// You could then use this substitution in an expression, as in this example:
	//
	//    * #P = :val
	//
	// Tokens that begin with the : character are expression attribute values, which
	// are placeholders for the actual value at runtime.
	//
	// For more information on expression attribute names, see Specifying Item Attributes
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
	// in the Amazon DynamoDB Developer Guide.
	ExpressionAttributeNames map[string]*string `type:"map"`

	// A map of attribute names to AttributeValue objects, representing the primary
	// key of the item to retrieve.
	//
	// For the primary key, you must provide all of the attributes. For example,
	// with a simple primary key, you only need to provide a value for the partition
	// key. For a composite primary key, you must provide values for both the partition
	// key and the sort key.
	//
	// Key is a required field
	Key map[string]*AttributeValue `type:"map" required:"true"`

	// A string that identifies one or more attributes to retrieve from the table.
	// These attributes can include scalars, sets, or elements of a JSON document.
	// The attributes in the expression must be separated by commas.
	//
	// If no attribute names are specified, then all attributes are returned. If
	// any of the requested attributes are not found, they do not appear in the
	// result.
	//
	// For more information, see Specifying Item Attributes (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
	// in the Amazon DynamoDB Developer Guide.
	ProjectionExpression *string `type:"string"`

	// Determines the level of detail about provisioned throughput consumption that
	// is returned in the response:
	//
	//    * INDEXES - The response includes the aggregate ConsumedCapacity for the
	//    operation, together with ConsumedCapacity for each table and secondary
	//    index that was accessed. Note that some operations, such as GetItem and
	//    BatchGetItem, do not access any indexes at all. In these cases, specifying
	//    INDEXES will only return ConsumedCapacity information for table(s).
	//
	//    * TOTAL - The response includes only the aggregate ConsumedCapacity for
	//    the operation.
	//
	//    * NONE - No ConsumedCapacity details are included in the response.
	ReturnConsumedCapacity *string `type:"string" enum:"ReturnConsumedCapacity"`

	// The name of the table containing the requested item.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s GetItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetItemInput"}
	if s.AttributesToGet != nil && len(s.AttributesToGet) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributesToGet", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributesToGet sets the AttributesToGet field's value.
func (s *GetItemInput) SetAttributesToGet(v []*string) *GetItemInput {
	s.AttributesToGet = v
	return s
}

// SetConsistentRead sets the ConsistentRead field's value.
func (s *GetItemInput) SetConsistentRead(v bool) *GetItemInput {
	s.ConsistentRead = &v
	return s
}

// SetExpressionAttributeNames sets the ExpressionAttributeNames field's value.
func (s *GetItemInput) SetExpressionAttributeNames(v map[string]*string) *GetItemInput {
	s.ExpressionAttributeNames = v
	return s
}

// SetKey sets the Key field's value.
func (s *GetItemInput) SetKey(v map[string]*AttributeValue) *GetItemInput {
	s.Key = v
	return s
}

// SetProjectionExpression sets the ProjectionExpression field's value.
func (s *GetItemInput) SetProjectionExpression(v string) *GetItemInput {
	s.ProjectionExpression = &v
	return s
}

// SetReturnConsumedCapacity sets the ReturnConsumedCapacity field's value.
func (s *GetItemInput) SetReturnConsumedCapacity(v string) *GetItemInput {
	s.ReturnConsumedCapacity = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *GetItemInput) SetTableName(v string) *GetItemInput {
	s.TableName = &v
	return s
}

// Represents the output of a GetItem operation.
type GetItemOutput struct {
	_ struct{} `type:"structure"`

	// The capacity units consumed by the GetItem operation. The data returned includes
	// the total provisioned throughput consumed, along with statistics for the
	// table and any indexes involved in the operation. ConsumedCapacity is only
	// returned if the ReturnConsumedCapacity parameter was specified. For more
	// information, see Read/Write Capacity Mode (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html)
	// in the Amazon DynamoDB Developer Guide.
	ConsumedCapacity *ConsumedCapacity `type:"structure"`

	// A map of attribute names to AttributeValue objects, as specified by ProjectionExpression.
	Item map[string]*AttributeValue `type:"map"`
}

// String returns the string representation
func (s GetItemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetItemOutput) GoString() string {
	return s.String()
}

// SetConsumedCapacity sets the ConsumedCapacity field's value.
func (s *GetItemOutput) SetConsumedCapacity(v *ConsumedCapacity) *GetItemOutput {
	s.ConsumedCapacity = v
	return s
}

// SetItem sets the Item field's value.
func (s *GetItemOutput) SetItem(v map[string]*AttributeValue) *GetItemOutput {
	s.Item = v
	return s
}

// Represents the properties of a global secondary index.
type GlobalSecondaryIndex struct {
	_ struct{} `type:"structure"`

	// The name of the global secondary index. The name must be unique among all
	// other indexes on this table.
	//
	// IndexName is a required field
	IndexName *string `min:"3" type:"string" required:"true"`

	// The complete key schema for a global secondary index, which consists of one
	// or more pairs of attribute names and key types:
	//
	//    * HASH - partition key
	//
	//    * RANGE - sort key
	//
	// The partition key of an item is also known as its hash attribute. The term
	// "hash attribute" derives from DynamoDB's usage of an internal hash function
	// to evenly distribute data items across partitions, based on their partition
	// key values.
	//
	// The sort key of an item is also known as its range attribute. The term "range
	// attribute" derives from the way DynamoDB stores items with the same partition
	// key physically close together, in sorted order by the sort key value.
	//
	// KeySchema is a required field
	KeySchema []*KeySchemaElement `min:"1" type:"list" required:"true"`

	// Represents attributes that are copied (projected) from the table into the
	// global secondary index. These are in addition to the primary key attributes
	// and index key attributes, which are automatically projected.
	//
	// Projection is a required field
	Projection *Projection `type:"structure" required:"true"`

	// Represents the provisioned throughput settings for the specified global secondary
	// index.
	//
	// For current minimum and maximum provisioned throughput values, see Limits
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html)
	// in the Amazon DynamoDB Developer Guide.
	ProvisionedThroughput *ProvisionedThroughput `type:"structure"`
}

// String returns the string representation
func (s GlobalSecondaryIndex) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GlobalSecondaryIndex) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GlobalSecondaryIndex) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GlobalSecondaryIndex"}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 3))
	}
	if s.KeySchema == nil {
		invalidParams.Add(request.NewErrParamRequired("KeySchema"))
	}
	if s.KeySchema != nil && len(s.KeySchema) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeySchema", 1))
	}
	if s.Projection == nil {
		invalidParams.Add(request.NewErrParamRequired("Projection"))
	}
	if s.KeySchema != nil {
		for i, v := range s.KeySchema {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "KeySchema", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Projection != nil {
		if err := s.Projection.Validate(); err != nil {
			invalidParams.AddNested("Projection", err.(request.ErrInvalidParams))
		}
	}
	if s.ProvisionedThroughput != nil {
		if err := s.ProvisionedThroughput.Validate(); err != nil {
			invalidParams.AddNested("ProvisionedThroughput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexName sets the IndexName field's value.
func (s *GlobalSecondaryIndex) SetIndexName(v string) *GlobalSecondaryIndex {
	s.IndexName = &v
	return s
}

// SetKeySchema sets the KeySchema field's value.
func (s *GlobalSecondaryIndex) SetKeySchema(v []*KeySchemaElement) *GlobalSecondaryIndex {
	s.KeySchema = v
	return s
}

// SetProjection sets the Projection field's value.
func (s *GlobalSecondaryIndex) SetProjection(v *Projection) *GlobalSecondaryIndex {
	s.Projection = v
	return s
}

// SetProvisionedThroughput sets the ProvisionedThroughput field's value.
func (s *GlobalSecondaryIndex) SetProvisionedThroughput(v *ProvisionedThroughput) *GlobalSecondaryIndex {
	s.ProvisionedThroughput = v
	return s
}

// Represents the auto scaling settings of a global secondary index for a global
// table that will be modified.
type GlobalSecondaryIndexAutoScalingUpdate struct {
	_ struct{} `type:"structure"`

	// The name of the global secondary index.
	IndexName *string `min:"3" type:"string"`

	// Represents the auto scaling settings to be modified for a global table or
	// global secondary index.
	ProvisionedWriteCapacityAutoScalingUpdate *AutoScalingSettingsUpdate `type:"structure"`
}

// String returns the string representation
func (s GlobalSecondaryIndexAutoScalingUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GlobalSecondaryIndexAutoScalingUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GlobalSecondaryIndexAutoScalingUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GlobalSecondaryIndexAutoScalingUpdate"}
	if s.IndexName != nil && len(*s.IndexName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 3))
	}
	if s.ProvisionedWriteCapacityAutoScalingUpdate != nil {
		if err := s.ProvisionedWriteCapacityAutoScalingUpdate.Validate(); err != nil {
			invalidParams.AddNested("ProvisionedWriteCapacityAutoScalingUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexName sets the IndexName field's value.
func (s *GlobalSecondaryIndexAutoScalingUpdate) SetIndexName(v string) *GlobalSecondaryIndexAutoScalingUpdate {
	s.IndexName = &v
	return s
}

// SetProvisionedWriteCapacityAutoScalingUpdate sets the ProvisionedWriteCapacityAutoScalingUpdate field's value.
func (s *GlobalSecondaryIndexAutoScalingUpdate) SetProvisionedWriteCapacityAutoScalingUpdate(v *AutoScalingSettingsUpdate) *GlobalSecondaryIndexAutoScalingUpdate {
	s.ProvisionedWriteCapacityAutoScalingUpdate = v
	return s
}

// Represents the properties of a global secondary index.
type GlobalSecondaryIndexDescription struct {
	_ struct{} `type:"structure"`

	// Indicates whether the index is currently backfilling. Backfilling is the
	// process of reading items from the table and determining whether they can
	// be added to the index. (Not all items will qualify: For example, a partition
	// key cannot have any duplicate values.) If an item can be added to the index,
	// DynamoDB will do so. After all items have been processed, the backfilling
	// operation is complete and Backfilling is false.
	//
	// You can delete an index that is being created during the Backfilling phase
	// when IndexStatus is set to CREATING and Backfilling is true. You can't delete
	// the index that is being created when IndexStatus is set to CREATING and Backfilling
	// is false.
	//
	// For indexes that were created during a CreateTable operation, the Backfilling
	// attribute does not appear in the DescribeTable output.
	Backfilling *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) that uniquely identifies the index.
	IndexArn *string `type:"string"`

	// The name of the global secondary index.
	IndexName *string `min:"3" type:"string"`

	// The total size of the specified index, in bytes. DynamoDB updates this value
	// approximately every six hours. Recent changes might not be reflected in this
	// value.
	IndexSizeBytes *int64 `type:"long"`

	// The current state of the global secondary index:
	//
	//    * CREATING - The index is being created.
	//
	//    * UPDATING - The index is being updated.
	//
	//    * DELETING - The index is being deleted.
	//
	//    * ACTIVE - The index is ready for use.
	IndexStatus *string `type:"string" enum:"IndexStatus"`

	// The number of items in the specified index. DynamoDB updates this value approximately
	// every six hours. Recent changes might not be reflected in this value.
	ItemCount *int64 `type:"long"`

	// The complete key schema for a global secondary index, which consists of one
	// or more pairs of attribute names and key types:
	//
	//    * HASH - partition key
	//
	//    * RANGE - sort key
	//
	// The partition key of an item is also known as its hash attribute. The term
	// "hash attribute" derives from DynamoDB's usage of an internal hash function
	// to evenly distribute data items across partitions, based on their partition
	// key values.
	//
	// The sort key of an item is also known as its range attribute. The term "range
	// attribute" derives from the way DynamoDB stores items with the same partition
	// key physically close together, in sorted order by the sort key value.
	KeySchema []*KeySchemaElement `min:"1" type:"list"`

	// Represents attributes that are copied (projected) from the table into the
	// global secondary index. These are in addition to the primary key attributes
	// and index key attributes, which are automatically projected.
	Projection *Projection `type:"structure"`

	// Represents the provisioned throughput settings for the specified global secondary
	// index.
	//
	// For current minimum and maximum provisioned throughput values, see Limits
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html)
	// in the Amazon DynamoDB Developer Guide.
	ProvisionedThroughput *ProvisionedThroughputDescription `type:"structure"`
}

// String returns the string representation
func (s GlobalSecondaryIndexDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GlobalSecondaryIndexDescription) GoString() string {
	return s.String()
}

// SetBackfilling sets the Backfilling field's value.
func (s *GlobalSecondaryIndexDescription) SetBackfilling(v bool) *GlobalSecondaryIndexDescription {
	s.Backfilling = &v
	return s
}

// SetIndexArn sets the IndexArn field's value.
func (s *GlobalSecondaryIndexDescription) SetIndexArn(v string) *GlobalSecondaryIndexDescription {
	s.IndexArn = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *GlobalSecondaryIndexDescription) SetIndexName(v string) *GlobalSecondaryIndexDescription {
	s.IndexName = &v
	return s
}

// SetIndexSizeBytes sets the IndexSizeBytes field's value.
func (s *GlobalSecondaryIndexDescription) SetIndexSizeBytes(v int64) *GlobalSecondaryIndexDescription {
	s.IndexSizeBytes = &v
	return s
}

// SetIndexStatus sets the IndexStatus field's value.
func (s *GlobalSecondaryIndexDescription) SetIndexStatus(v string) *GlobalSecondaryIndexDescription {
	s.IndexStatus = &v
	return s
}

// SetItemCount sets the ItemCount field's value.
func (s *GlobalSecondaryIndexDescription) SetItemCount(v int64) *GlobalSecondaryIndexDescription {
	s.ItemCount = &v
	return s
}

// SetKeySchema sets the KeySchema field's value.
func (s *GlobalSecondaryIndexDescription) SetKeySchema(v []*KeySchemaElement) *GlobalSecondaryIndexDescription {
	s.KeySchema = v
	return s
}

// SetProjection sets the Projection field's value.
func (s *GlobalSecondaryIndexDescription) SetProjection(v *Projection) *GlobalSecondaryIndexDescription {
	s.Projection = v
	return s
}

// SetProvisionedThroughput sets the ProvisionedThroughput field's value.
func (s *GlobalSecondaryIndexDescription) SetProvisionedThroughput(v *ProvisionedThroughputDescription) *GlobalSecondaryIndexDescription {
	s.ProvisionedThroughput = v
	return s
}

// Represents the properties of a global secondary index for the table when
// the backup was created.
type GlobalSecondaryIndexInfo struct {
	_ struct{} `type:"structure"`

	// The name of the global secondary index.
	IndexName *string `min:"3" type:"string"`

	// The complete key schema for a global secondary index, which consists of one
	// or more pairs of attribute names and key types:
	//
	//    * HASH - partition key
	//
	//    * RANGE - sort key
	//
	// The partition key of an item is also known as its hash attribute. The term
	// "hash attribute" derives from DynamoDB's usage of an internal hash function
	// to evenly distribute data items across partitions, based on their partition
	// key values.
	//
	// The sort key of an item is also known as its range attribute. The term "range
	// attribute" derives from the way DynamoDB stores items with the same partition
	// key physically close together, in sorted order by the sort key value.
	KeySchema []*KeySchemaElement `min:"1" type:"list"`

	// Represents attributes that are copied (projected) from the table into the
	// global secondary index. These are in addition to the primary key attributes
	// and index key attributes, which are automatically projected.
	Projection *Projection `type:"structure"`

	// Represents the provisioned throughput settings for the specified global secondary
	// index.
	ProvisionedThroughput *ProvisionedThroughput `type:"structure"`
}

// String returns the string representation
func (s GlobalSecondaryIndexInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GlobalSecondaryIndexInfo) GoString() string {
	return s.String()
}

// SetIndexName sets the IndexName field's value.
func (s *GlobalSecondaryIndexInfo) SetIndexName(v string) *GlobalSecondaryIndexInfo {
	s.IndexName = &v
	return s
}

// SetKeySchema sets the KeySchema field's value.
func (s *GlobalSecondaryIndexInfo) SetKeySchema(v []*KeySchemaElement) *GlobalSecondaryIndexInfo {
	s.KeySchema = v
	return s
}

// SetProjection sets the Projection field's value.
func (s *GlobalSecondaryIndexInfo) SetProjection(v *Projection) *GlobalSecondaryIndexInfo {
	s.Projection = v
	return s
}

// SetProvisionedThroughput sets the ProvisionedThroughput field's value.
func (s *GlobalSecondaryIndexInfo) SetProvisionedThroughput(v *ProvisionedThroughput) *GlobalSecondaryIndexInfo {
	s.ProvisionedThroughput = v
	return s
}

// Represents one of the following:
//
//    * A new global secondary index to be added to an existing table.
//
//    * New provisioned throughput parameters for an existing global secondary
//    index.
//
//    * An existing global secondary index to be removed from an existing table.
type GlobalSecondaryIndexUpdate struct {
	_ struct{} `type:"structure"`

	// The parameters required for creating a global secondary index on an existing
	// table:
	//
	//    * IndexName
	//
	//    * KeySchema
	//
	//    * AttributeDefinitions
	//
	//    * Projection
	//
	//    * ProvisionedThroughput
	Create *CreateGlobalSecondaryIndexAction `type:"structure"`

	// The name of an existing global secondary index to be removed.
	Delete *DeleteGlobalSecondaryIndexAction `type:"structure"`

	// The name of an existing global secondary index, along with new provisioned
	// throughput settings to be applied to that index.
	Update *UpdateGlobalSecondaryIndexAction `type:"structure"`
}

// String returns the string representation
func (s GlobalSecondaryIndexUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GlobalSecondaryIndexUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GlobalSecondaryIndexUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GlobalSecondaryIndexUpdate"}
	if s.Create != nil {
		if err := s.Create.Validate(); err != nil {
			invalidParams.AddNested("Create", err.(request.ErrInvalidParams))
		}
	}
	if s.Delete != nil {
		if err := s.Delete.Validate(); err != nil {
			invalidParams.AddNested("Delete", err.(request.ErrInvalidParams))
		}
	}
	if s.Update != nil {
		if err := s.Update.Validate(); err != nil {
			invalidParams.AddNested("Update", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreate sets the Create field's value.
func (s *GlobalSecondaryIndexUpdate) SetCreate(v *CreateGlobalSecondaryIndexAction) *GlobalSecondaryIndexUpdate {
	s.Create = v
	return s
}

// SetDelete sets the Delete field's value.
func (s *GlobalSecondaryIndexUpdate) SetDelete(v *DeleteGlobalSecondaryIndexAction) *GlobalSecondaryIndexUpdate {
	s.Delete = v
	return s
}

// SetUpdate sets the Update field's value.
func (s *GlobalSecondaryIndexUpdate) SetUpdate(v *UpdateGlobalSecondaryIndexAction) *GlobalSecondaryIndexUpdate {
	s.Update = v
	return s
}

// Represents the properties of a global table.
type GlobalTable struct {
	_ struct{} `type:"structure"`

	// The global table name.
	GlobalTableName *string `min:"3" type:"string"`

	// The Regions where the global table has replicas.
	ReplicationGroup []*Replica `type:"list"`
}

// String returns the string representation
func (s GlobalTable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GlobalTable) GoString() string {
	return s.String()
}

// SetGlobalTableName sets the GlobalTableName field's value.
func (s *GlobalTable) SetGlobalTableName(v string) *GlobalTable {
	s.GlobalTableName = &v
	return s
}

// SetReplicationGroup sets the ReplicationGroup field's value.
func (s *GlobalTable) SetReplicationGroup(v []*Replica) *GlobalTable {
	s.ReplicationGroup = v
	return s
}

// Contains details about the global table.
type GlobalTableDescription struct {
	_ struct{} `type:"structure"`

	// The creation time of the global table.
	CreationDateTime *time.Time `type:"timestamp"`

	// The unique identifier of the global table.
	GlobalTableArn *string `type:"string"`

	// The global table name.
	GlobalTableName *string `min:"3" type:"string"`

	// The current state of the global table:
	//
	//    * CREATING - The global table is being created.
	//
	//    * UPDATING - The global table is being updated.
	//
	//    * DELETING - The global table is being deleted.
	//
	//    * ACTIVE - The global table is ready for use.
	GlobalTableStatus *string `type:"string" enum:"GlobalTableStatus"`

	// The Regions where the global table has replicas.
	ReplicationGroup []*ReplicaDescription `type:"list"`
}

// String returns the string representation
func (s GlobalTableDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GlobalTableDescription) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *GlobalTableDescription) SetCreationDateTime(v time.Time) *GlobalTableDescription {
	s.CreationDateTime = &v
	return s
}

// SetGlobalTableArn sets the GlobalTableArn field's value.
func (s *GlobalTableDescription) SetGlobalTableArn(v string) *GlobalTableDescription {
	s.GlobalTableArn = &v
	return s
}

// SetGlobalTableName sets the GlobalTableName field's value.
func (s *GlobalTableDescription) SetGlobalTableName(v string) *GlobalTableDescription {
	s.GlobalTableName = &v
	return s
}

// SetGlobalTableStatus sets the GlobalTableStatus field's value.
func (s *GlobalTableDescription) SetGlobalTableStatus(v string) *GlobalTableDescription {
	s.GlobalTableStatus = &v
	return s
}

// SetReplicationGroup sets the ReplicationGroup field's value.
func (s *GlobalTableDescription) SetReplicationGroup(v []*ReplicaDescription) *GlobalTableDescription {
	s.ReplicationGroup = v
	return s
}

// Represents the settings of a global secondary index for a global table that
// will be modified.
type GlobalTableGlobalSecondaryIndexSettingsUpdate struct {
	_ struct{} `type:"structure"`

	// The name of the global secondary index. The name must be unique among all
	// other indexes on this table.
	//
	// IndexName is a required field
	IndexName *string `min:"3" type:"string" required:"true"`

	// Auto scaling settings for managing a global secondary index's write capacity
	// units.
	ProvisionedWriteCapacityAutoScalingSettingsUpdate *AutoScalingSettingsUpdate `type:"structure"`

	// The maximum number of writes consumed per second before DynamoDB returns
	// a ThrottlingException.
	ProvisionedWriteCapacityUnits *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s GlobalTableGlobalSecondaryIndexSettingsUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GlobalTableGlobalSecondaryIndexSettingsUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GlobalTableGlobalSecondaryIndexSettingsUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GlobalTableGlobalSecondaryIndexSettingsUpdate"}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 3))
	}
	if s.ProvisionedWriteCapacityUnits != nil && *s.ProvisionedWriteCapacityUnits < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ProvisionedWriteCapacityUnits", 1))
	}
	if s.ProvisionedWriteCapacityAutoScalingSettingsUpdate != nil {
		if err := s.ProvisionedWriteCapacityAutoScalingSettingsUpdate.Validate(); err != nil {
			invalidParams.AddNested("ProvisionedWriteCapacityAutoScalingSettingsUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexName sets the IndexName field's value.
func (s *GlobalTableGlobalSecondaryIndexSettingsUpdate) SetIndexName(v string) *GlobalTableGlobalSecondaryIndexSettingsUpdate {
	s.IndexName = &v
	return s
}

// SetProvisionedWriteCapacityAutoScalingSettingsUpdate sets the ProvisionedWriteCapacityAutoScalingSettingsUpdate field's value.
func (s *GlobalTableGlobalSecondaryIndexSettingsUpdate) SetProvisionedWriteCapacityAutoScalingSettingsUpdate(v *AutoScalingSettingsUpdate) *GlobalTableGlobalSecondaryIndexSettingsUpdate {
	s.ProvisionedWriteCapacityAutoScalingSettingsUpdate = v
	return s
}

// SetProvisionedWriteCapacityUnits sets the ProvisionedWriteCapacityUnits field's value.
func (s *GlobalTableGlobalSecondaryIndexSettingsUpdate) SetProvisionedWriteCapacityUnits(v int64) *GlobalTableGlobalSecondaryIndexSettingsUpdate {
	s.ProvisionedWriteCapacityUnits = &v
	return s
}

// Information about item collections, if any, that were affected by the operation.
// ItemCollectionMetrics is only returned if the request asked for it. If the
// table does not have any local secondary indexes, this information is not
// returned in the response.
type ItemCollectionMetrics struct {
	_ struct{} `type:"structure"`

	// The partition key value of the item collection. This value is the same as
	// the partition key value of the item.
	ItemCollectionKey map[string]*AttributeValue `type:"map"`

	// An estimate of item collection size, in gigabytes. This value is a two-element
	// array containing a lower bound and an upper bound for the estimate. The estimate
	// includes the size of all the items in the table, plus the size of all attributes
	// projected into all of the local secondary indexes on that table. Use this
	// estimate to measure whether a local secondary index is approaching its size
	// limit.
	//
	// The estimate is subject to change over time; therefore, do not rely on the
	// precision or accuracy of the estimate.
	SizeEstimateRangeGB []*float64 `type:"list"`
}

// String returns the string representation
func (s ItemCollectionMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ItemCollectionMetrics) GoString() string {
	return s.String()
}

// SetItemCollectionKey sets the ItemCollectionKey field's value.
func (s *ItemCollectionMetrics) SetItemCollectionKey(v map[string]*AttributeValue) *ItemCollectionMetrics {
	s.ItemCollectionKey = v
	return s
}

// SetSizeEstimateRangeGB sets the SizeEstimateRangeGB field's value.
func (s *ItemCollectionMetrics) SetSizeEstimateRangeGB(v []*float64) *ItemCollectionMetrics {
	s.SizeEstimateRangeGB = v
	return s
}

// Details for the requested item.
type ItemResponse struct {
	_ struct{} `type:"structure"`

	// Map of attribute data consisting of the data type and attribute value.
	Item map[string]*AttributeValue `type:"map"`
}

// String returns the string representation
func (s ItemResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ItemResponse) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *ItemResponse) SetItem(v map[string]*AttributeValue) *ItemResponse {
	s.Item = v
	return s
}

// Represents a single element of a key schema. A key schema specifies the attributes
// that make up the primary key of a table, or the key attributes of an index.
//
// A KeySchemaElement represents exactly one attribute of the primary key. For
// example, a simple primary key would be represented by one KeySchemaElement
// (for the partition key). A composite primary key would require one KeySchemaElement
// for the partition key, and another KeySchemaElement for the sort key.
//
// A KeySchemaElement must be a scalar, top-level attribute (not a nested attribute).
// The data type must be one of String, Number, or Binary. The attribute cannot
// be nested within a List or a Map.
type KeySchemaElement struct {
	_ struct{} `type:"structure"`

	// The name of a key attribute.
	//
	// AttributeName is a required field
	AttributeName *string `min:"1" type:"string" required:"true"`

	// The role that this key attribute will assume:
	//
	//    * HASH - partition key
	//
	//    * RANGE - sort key
	//
	// The partition key of an item is also known as its hash attribute. The term
	// "hash attribute" derives from DynamoDB's usage of an internal hash function
	// to evenly distribute data items across partitions, based on their partition
	// key values.
	//
	// The sort key of an item is also known as its range attribute. The term "range
	// attribute" derives from the way DynamoDB stores items with the same partition
	// key physically close together, in sorted order by the sort key value.
	//
	// KeyType is a required field
	KeyType *string `type:"string" required:"true" enum:"KeyType"`
}

// String returns the string representation
func (s KeySchemaElement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeySchemaElement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KeySchemaElement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KeySchemaElement"}
	if s.AttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeName"))
	}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributeName", 1))
	}
	if s.KeyType == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeName sets the AttributeName field's value.
func (s *KeySchemaElement) SetAttributeName(v string) *KeySchemaElement {
	s.AttributeName = &v
	return s
}

// SetKeyType sets the KeyType field's value.
func (s *KeySchemaElement) SetKeyType(v string) *KeySchemaElement {
	s.KeyType = &v
	return s
}

// Represents a set of primary keys and, for each key, the attributes to retrieve
// from the table.
//
// For each primary key, you must provide all of the key attributes. For example,
// with a simple primary key, you only need to provide the partition key. For
// a composite primary key, you must provide both the partition key and the
// sort key.
type KeysAndAttributes struct {
	_ struct{} `type:"structure"`

	// This is a legacy parameter. Use ProjectionExpression instead. For more information,
	// see Legacy Conditional Parameters (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.html)
	// in the Amazon DynamoDB Developer Guide.
	AttributesToGet []*string `min:"1" type:"list"`

	// The consistency of a read operation. If set to true, then a strongly consistent
	// read is used; otherwise, an eventually consistent read is used.
	ConsistentRead *bool `type:"boolean"`

	// One or more substitution tokens for attribute names in an expression. The
	// following are some use cases for using ExpressionAttributeNames:
	//
	//    * To access an attribute whose name conflicts with a DynamoDB reserved
	//    word.
	//
	//    * To create a placeholder for repeating occurrences of an attribute name
	//    in an expression.
	//
	//    * To prevent special characters in an attribute name from being misinterpreted
	//    in an expression.
	//
	// Use the # character in an expression to dereference an attribute name. For
	// example, consider the following attribute name:
	//
	//    * Percentile
	//
	// The name of this attribute conflicts with a reserved word, so it cannot be
	// used directly in an expression. (For the complete list of reserved words,
	// see Reserved Words (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
	// in the Amazon DynamoDB Developer Guide). To work around this, you could specify
	// the following for ExpressionAttributeNames:
	//
	//    * {"#P":"Percentile"}
	//
	// You could then use this substitution in an expression, as in this example:
	//
	//    * #P = :val
	//
	// Tokens that begin with the : character are expression attribute values, which
	// are placeholders for the actual value at runtime.
	//
	// For more information on expression attribute names, see Accessing Item Attributes
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
	// in the Amazon DynamoDB Developer Guide.
	ExpressionAttributeNames map[string]*string `type:"map"`

	// The primary key attribute values that define the items and the attributes
	// associated with the items.
	//
	// Keys is a required field
	Keys []map[string]*AttributeValue `min:"1" type:"list" required:"true"`

	// A string that identifies one or more attributes to retrieve from the table.
	// These attributes can include scalars, sets, or elements of a JSON document.
	// The attributes in the ProjectionExpression must be separated by commas.
	//
	// If no attribute names are specified, then all attributes will be returned.
	// If any of the requested attributes are not found, they will not appear in
	// the result.
	//
	// For more information, see Accessing Item Attributes (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
	// in the Amazon DynamoDB Developer Guide.
	ProjectionExpression *string `type:"string"`
}

// String returns the string representation
func (s KeysAndAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeysAndAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KeysAndAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KeysAndAttributes"}
	if s.AttributesToGet != nil && len(s.AttributesToGet) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributesToGet", 1))
	}
	if s.Keys == nil {
		invalidParams.Add(request.NewErrParamRequired("Keys"))
	}
	if s.Keys != nil && len(s.Keys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Keys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributesToGet sets the AttributesToGet field's value.
func (s *KeysAndAttributes) SetAttributesToGet(v []*string) *KeysAndAttributes {
	s.AttributesToGet = v
	return s
}

// SetConsistentRead sets the ConsistentRead field's value.
func (s *KeysAndAttributes) SetConsistentRead(v bool) *KeysAndAttributes {
	s.ConsistentRead = &v
	return s
}

// SetExpressionAttributeNames sets the ExpressionAttributeNames field's value.
func (s *KeysAndAttributes) SetExpressionAttributeNames(v map[string]*string) *KeysAndAttributes {
	s.ExpressionAttributeNames = v
	return s
}

// SetKeys sets the Keys field's value.
func (s *KeysAndAttributes) SetKeys(v []map[string]*AttributeValue) *KeysAndAttributes {
	s.Keys = v
	return s
}

// SetProjectionExpression sets the ProjectionExpression field's value.
func (s *KeysAndAttributes) SetProjectionExpression(v string) *KeysAndAttributes {
	s.ProjectionExpression = &v
	return s
}

type ListBackupsInput struct {
	_ struct{} `type:"structure"`

	// The backups from the table specified by BackupType are listed.
	//
	// Where BackupType can be:
	//
	//    * USER - On-demand backup created by you.
	//
	//    * SYSTEM - On-demand backup automatically created by DynamoDB.
	//
	//    * ALL - All types of on-demand backups (USER and SYSTEM).
	BackupType *string `type:"string" enum:"BackupTypeFilter"`

	// LastEvaluatedBackupArn is the Amazon Resource Name (ARN) of the backup last
	// evaluated when the current page of results was returned, inclusive of the
	// current page of results. This value may be specified as the ExclusiveStartBackupArn
	// of a new ListBackups operation in order to fetch the next page of results.
	ExclusiveStartBackupArn *string `min:"37" type:"string"`

	// Maximum number of backups to return at once.
	Limit *int64 `min:"1" type:"integer"`

	// The backups from the table specified by TableName are listed.
	TableName *string `min:"3" type:"string"`

	// Only backups created after this time are listed. TimeRangeLowerBound is inclusive.
	TimeRangeLowerBound *time.Time `type:"timestamp"`

	// Only backups created before this time are listed. TimeRangeUpperBound is
	// exclusive.
	TimeRangeUpperBound *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s ListBackupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBackupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBackupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBackupsInput"}
	if s.ExclusiveStartBackupArn != nil && len(*s.ExclusiveStartBackupArn) < 37 {
		invalidParams.Add(request.NewErrParamMinLen("ExclusiveStartBackupArn", 37))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupType sets the BackupType field's value.
func (s *ListBackupsInput) SetBackupType(v string) *ListBackupsInput {
	s.BackupType = &v
	return s
}

// SetExclusiveStartBackupArn sets the ExclusiveStartBackupArn field's value.
func (s *ListBackupsInput) SetExclusiveStartBackupArn(v string) *ListBackupsInput {
	s.ExclusiveStartBackupArn = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListBackupsInput) SetLimit(v int64) *ListBackupsInput {
	s.Limit = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *ListBackupsInput) SetTableName(v string) *ListBackupsInput {
	s.TableName = &v
	return s
}

// SetTimeRangeLowerBound sets the TimeRangeLowerBound field's value.
func (s *ListBackupsInput) SetTimeRangeLowerBound(v time.Time) *ListBackupsInput {
	s.TimeRangeLowerBound = &v
	return s
}

// SetTimeRangeUpperBound sets the TimeRangeUpperBound field's value.
func (s *ListBackupsInput) SetTimeRangeUpperBound(v time.Time) *ListBackupsInput {
	s.TimeRangeUpperBound = &v
	return s
}

type ListBackupsOutput struct {
	_ struct{} `type:"structure"`

	// List of BackupSummary objects.
	BackupSummaries []*BackupSummary `type:"list"`

	// The ARN of the backup last evaluated when the current page of results was
	// returned, inclusive of the current page of results. This value may be specified
	// as the ExclusiveStartBackupArn of a new ListBackups operation in order to
	// fetch the next page of results.
	//
	// If LastEvaluatedBackupArn is empty, then the last page of results has been
	// processed and there are no more results to be retrieved.
	//
	// If LastEvaluatedBackupArn is not empty, this may or may not indicate that
	// there is more data to be returned. All results are guaranteed to have been
	// returned if and only if no value for LastEvaluatedBackupArn is returned.
	LastEvaluatedBackupArn *string `min:"37" type:"string"`
}

// String returns the string representation
func (s ListBackupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBackupsOutput) GoString() string {
	return s.String()
}

// SetBackupSummaries sets the BackupSummaries field's value.
func (s *ListBackupsOutput) SetBackupSummaries(v []*BackupSummary) *ListBackupsOutput {
	s.BackupSummaries = v
	return s
}

// SetLastEvaluatedBackupArn sets the LastEvaluatedBackupArn field's value.
func (s *ListBackupsOutput) SetLastEvaluatedBackupArn(v string) *ListBackupsOutput {
	s.LastEvaluatedBackupArn = &v
	return s
}

type ListContributorInsightsInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of results to return per page.
	MaxResults *int64 `type:"integer"`

	// A token to for the desired page, if there is one.
	NextToken *string `type:"string"`

	// The name of the table.
	TableName *string `min:"3" type:"string"`
}

// String returns the string representation
func (s ListContributorInsightsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListContributorInsightsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListContributorInsightsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListContributorInsightsInput"}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListContributorInsightsInput) SetMaxResults(v int64) *ListContributorInsightsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListContributorInsightsInput) SetNextToken(v string) *ListContributorInsightsInput {
	s.NextToken = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *ListContributorInsightsInput) SetTableName(v string) *ListContributorInsightsInput {
	s.TableName = &v
	return s
}

type ListContributorInsightsOutput struct {
	_ struct{} `type:"structure"`

	// A list of ContributorInsightsSummary.
	ContributorInsightsSummaries []*ContributorInsightsSummary `type:"list"`

	// A token to go to the next page if there is one.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListContributorInsightsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListContributorInsightsOutput) GoString() string {
	return s.String()
}

// SetContributorInsightsSummaries sets the ContributorInsightsSummaries field's value.
func (s *ListContributorInsightsOutput) SetContributorInsightsSummaries(v []*ContributorInsightsSummary) *ListContributorInsightsOutput {
	s.ContributorInsightsSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListContributorInsightsOutput) SetNextToken(v string) *ListContributorInsightsOutput {
	s.NextToken = &v
	return s
}

type ListGlobalTablesInput struct {
	_ struct{} `type:"structure"`

	// The first global table name that this operation will evaluate.
	ExclusiveStartGlobalTableName *string `min:"3" type:"string"`

	// The maximum number of table names to return.
	Limit *int64 `min:"1" type:"integer"`

	// Lists the global tables in a specific Region.
	RegionName *string `type:"string"`
}

// String returns the string representation
func (s ListGlobalTablesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGlobalTablesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGlobalTablesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGlobalTablesInput"}
	if s.ExclusiveStartGlobalTableName != nil && len(*s.ExclusiveStartGlobalTableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ExclusiveStartGlobalTableName", 3))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExclusiveStartGlobalTableName sets the ExclusiveStartGlobalTableName field's value.
func (s *ListGlobalTablesInput) SetExclusiveStartGlobalTableName(v string) *ListGlobalTablesInput {
	s.ExclusiveStartGlobalTableName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListGlobalTablesInput) SetLimit(v int64) *ListGlobalTablesInput {
	s.Limit = &v
	return s
}

// SetRegionName sets the RegionName field's value.
func (s *ListGlobalTablesInput) SetRegionName(v string) *ListGlobalTablesInput {
	s.RegionName = &v
	return s
}

type ListGlobalTablesOutput struct {
	_ struct{} `type:"structure"`

	// List of global table names.
	GlobalTables []*GlobalTable `type:"list"`

	// Last evaluated global table name.
	LastEvaluatedGlobalTableName *string `min:"3" type:"string"`
}

// String returns the string representation
func (s ListGlobalTablesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGlobalTablesOutput) GoString() string {
	return s.String()
}

// SetGlobalTables sets the GlobalTables field's value.
func (s *ListGlobalTablesOutput) SetGlobalTables(v []*GlobalTable) *ListGlobalTablesOutput {
	s.GlobalTables = v
	return s
}

// SetLastEvaluatedGlobalTableName sets the LastEvaluatedGlobalTableName field's value.
func (s *ListGlobalTablesOutput) SetLastEvaluatedGlobalTableName(v string) *ListGlobalTablesOutput {
	s.LastEvaluatedGlobalTableName = &v
	return s
}

// Represents the input of a ListTables operation.
type ListTablesInput struct {
	_ struct{} `type:"structure"`

	// The first table name that this operation will evaluate. Use the value that
	// was returned for LastEvaluatedTableName in a previous operation, so that
	// you can obtain the next page of results.
	ExclusiveStartTableName *string `min:"3" type:"string"`

	// A maximum number of table names to return. If this parameter is not specified,
	// the limit is 100.
	Limit *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s ListTablesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTablesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTablesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTablesInput"}
	if s.ExclusiveStartTableName != nil && len(*s.ExclusiveStartTableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ExclusiveStartTableName", 3))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExclusiveStartTableName sets the ExclusiveStartTableName field's value.
func (s *ListTablesInput) SetExclusiveStartTableName(v string) *ListTablesInput {
	s.ExclusiveStartTableName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListTablesInput) SetLimit(v int64) *ListTablesInput {
	s.Limit = &v
	return s
}

// Represents the output of a ListTables operation.
type ListTablesOutput struct {
	_ struct{} `type:"structure"`

	// The name of the last table in the current page of results. Use this value
	// as the ExclusiveStartTableName in a new request to obtain the next page of
	// results, until all the table names are returned.
	//
	// If you do not receive a LastEvaluatedTableName value in the response, this
	// means that there are no more table names to be retrieved.
	LastEvaluatedTableName *string `min:"3" type:"string"`

	// The names of the tables associated with the current account at the current
	// endpoint. The maximum size of this array is 100.
	//
	// If LastEvaluatedTableName also appears in the output, you can use this value
	// as the ExclusiveStartTableName parameter in a subsequent ListTables request
	// and obtain the next page of results.
	TableNames []*string `type:"list"`
}

// String returns the string representation
func (s ListTablesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTablesOutput) GoString() string {
	return s.String()
}

// SetLastEvaluatedTableName sets the LastEvaluatedTableName field's value.
func (s *ListTablesOutput) SetLastEvaluatedTableName(v string) *ListTablesOutput {
	s.LastEvaluatedTableName = &v
	return s
}

// SetTableNames sets the TableNames field's value.
func (s *ListTablesOutput) SetTableNames(v []*string) *ListTablesOutput {
	s.TableNames = v
	return s
}

type ListTagsOfResourceInput struct {
	_ struct{} `type:"structure"`

	// An optional string that, if supplied, must be copied from the output of a
	// previous call to ListTagOfResource. When provided in this manner, this API
	// fetches the next page of results.
	NextToken *string `type:"string"`

	// The Amazon DynamoDB resource with tags to be listed. This value is an Amazon
	// Resource Name (ARN).
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsOfResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsOfResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsOfResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsOfResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsOfResourceInput) SetNextToken(v string) *ListTagsOfResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsOfResourceInput) SetResourceArn(v string) *ListTagsOfResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsOfResourceOutput struct {
	_ struct{} `type:"structure"`

	// If this value is returned, there are additional results to be displayed.
	// To retrieve them, call ListTagsOfResource again, with NextToken set to this
	// value.
	NextToken *string `type:"string"`

	// The tags currently associated with the Amazon DynamoDB resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsOfResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsOfResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsOfResourceOutput) SetNextToken(v string) *ListTagsOfResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsOfResourceOutput) SetTags(v []*Tag) *ListTagsOfResourceOutput {
	s.Tags = v
	return s
}

// Represents the properties of a local secondary index.
type LocalSecondaryIndex struct {
	_ struct{} `type:"structure"`

	// The name of the local secondary index. The name must be unique among all
	// other indexes on this table.
	//
	// IndexName is a required field
	IndexName *string `min:"3" type:"string" required:"true"`

	// The complete key schema for the local secondary index, consisting of one
	// or more pairs of attribute names and key types:
	//
	//    * HASH - partition key
	//
	//    * RANGE - sort key
	//
	// The partition key of an item is also known as its hash attribute. The term
	// "hash attribute" derives from DynamoDB's usage of an internal hash function
	// to evenly distribute data items across partitions, based on their partition
	// key values.
	//
	// The sort key of an item is also known as its range attribute. The term "range
	// attribute" derives from the way DynamoDB stores items with the same partition
	// key physically close together, in sorted order by the sort key value.
	//
	// KeySchema is a required field
	KeySchema []*KeySchemaElement `min:"1" type:"list" required:"true"`

	// Represents attributes that are copied (projected) from the table into the
	// local secondary index. These are in addition to the primary key attributes
	// and index key attributes, which are automatically projected.
	//
	// Projection is a required field
	Projection *Projection `type:"structure" required:"true"`
}

// String returns the string representation
func (s LocalSecondaryIndex) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LocalSecondaryIndex) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LocalSecondaryIndex) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LocalSecondaryIndex"}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 3))
	}
	if s.KeySchema == nil {
		invalidParams.Add(request.NewErrParamRequired("KeySchema"))
	}
	if s.KeySchema != nil && len(s.KeySchema) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeySchema", 1))
	}
	if s.Projection == nil {
		invalidParams.Add(request.NewErrParamRequired("Projection"))
	}
	if s.KeySchema != nil {
		for i, v := range s.KeySchema {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "KeySchema", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Projection != nil {
		if err := s.Projection.Validate(); err != nil {
			invalidParams.AddNested("Projection", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexName sets the IndexName field's value.
func (s *LocalSecondaryIndex) SetIndexName(v string) *LocalSecondaryIndex {
	s.IndexName = &v
	return s
}

// SetKeySchema sets the KeySchema field's value.
func (s *LocalSecondaryIndex) SetKeySchema(v []*KeySchemaElement) *LocalSecondaryIndex {
	s.KeySchema = v
	return s
}

// SetProjection sets the Projection field's value.
func (s *LocalSecondaryIndex) SetProjection(v *Projection) *LocalSecondaryIndex {
	s.Projection = v
	return s
}

// Represents the properties of a local secondary index.
type LocalSecondaryIndexDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that uniquely identifies the index.
	IndexArn *string `type:"string"`

	// Represents the name of the local secondary index.
	IndexName *string `min:"3" type:"string"`

	// The total size of the specified index, in bytes. DynamoDB updates this value
	// approximately every six hours. Recent changes might not be reflected in this
	// value.
	IndexSizeBytes *int64 `type:"long"`

	// The number of items in the specified index. DynamoDB updates this value approximately
	// every six hours. Recent changes might not be reflected in this value.
	ItemCount *int64 `type:"long"`

	// The complete key schema for the local secondary index, consisting of one
	// or more pairs of attribute names and key types:
	//
	//    * HASH - partition key
	//
	//    * RANGE - sort key
	//
	// The partition key of an item is also known as its hash attribute. The term
	// "hash attribute" derives from DynamoDB's usage of an internal hash function
	// to evenly distribute data items across partitions, based on their partition
	// key values.
	//
	// The sort key of an item is also known as its range attribute. The term "range
	// attribute" derives from the way DynamoDB stores items with the same partition
	// key physically close together, in sorted order by the sort key value.
	KeySchema []*KeySchemaElement `min:"1" type:"list"`

	// Represents attributes that are copied (projected) from the table into the
	// global secondary index. These are in addition to the primary key attributes
	// and index key attributes, which are automatically projected.
	Projection *Projection `type:"structure"`
}

// String returns the string representation
func (s LocalSecondaryIndexDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LocalSecondaryIndexDescription) GoString() string {
	return s.String()
}

// SetIndexArn sets the IndexArn field's value.
func (s *LocalSecondaryIndexDescription) SetIndexArn(v string) *LocalSecondaryIndexDescription {
	s.IndexArn = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *LocalSecondaryIndexDescription) SetIndexName(v string) *LocalSecondaryIndexDescription {
	s.IndexName = &v
	return s
}

// SetIndexSizeBytes sets the IndexSizeBytes field's value.
func (s *LocalSecondaryIndexDescription) SetIndexSizeBytes(v int64) *LocalSecondaryIndexDescription {
	s.IndexSizeBytes = &v
	return s
}

// SetItemCount sets the ItemCount field's value.
func (s *LocalSecondaryIndexDescription) SetItemCount(v int64) *LocalSecondaryIndexDescription {
	s.ItemCount = &v
	return s
}

// SetKeySchema sets the KeySchema field's value.
func (s *LocalSecondaryIndexDescription) SetKeySchema(v []*KeySchemaElement) *LocalSecondaryIndexDescription {
	s.KeySchema = v
	return s
}

// SetProjection sets the Projection field's value.
func (s *LocalSecondaryIndexDescription) SetProjection(v *Projection) *LocalSecondaryIndexDescription {
	s.Projection = v
	return s
}

// Represents the properties of a local secondary index for the table when the
// backup was created.
type LocalSecondaryIndexInfo struct {
	_ struct{} `type:"structure"`

	// Represents the name of the local secondary index.
	IndexName *string `min:"3" type:"string"`

	// The complete key schema for a local secondary index, which consists of one
	// or more pairs of attribute names and key types:
	//
	//    * HASH - partition key
	//
	//    * RANGE - sort key
	//
	// The partition key of an item is also known as its hash attribute. The term
	// "hash attribute" derives from DynamoDB's usage of an internal hash function
	// to evenly distribute data items across partitions, based on their partition
	// key values.
	//
	// The sort key of an item is also known as its range attribute. The term "range
	// attribute" derives from the way DynamoDB stores items with the same partition
	// key physically close together, in sorted order by the sort key value.
	KeySchema []*KeySchemaElement `min:"1" type:"list"`

	// Represents attributes that are copied (projected) from the table into the
	// global secondary index. These are in addition to the primary key attributes
	// and index key attributes, which are automatically projected.
	Projection *Projection `type:"structure"`
}

// String returns the string representation
func (s LocalSecondaryIndexInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LocalSecondaryIndexInfo) GoString() string {
	return s.String()
}

// SetIndexName sets the IndexName field's value.
func (s *LocalSecondaryIndexInfo) SetIndexName(v string) *LocalSecondaryIndexInfo {
	s.IndexName = &v
	return s
}

// SetKeySchema sets the KeySchema field's value.
func (s *LocalSecondaryIndexInfo) SetKeySchema(v []*KeySchemaElement) *LocalSecondaryIndexInfo {
	s.KeySchema = v
	return s
}

// SetProjection sets the Projection field's value.
func (s *LocalSecondaryIndexInfo) SetProjection(v *Projection) *LocalSecondaryIndexInfo {
	s.Projection = v
	return s
}

// The description of the point in time settings applied to the table.
type PointInTimeRecoveryDescription struct {
	_ struct{} `type:"structure"`

	// Specifies the earliest point in time you can restore your table to. You can
	// restore your table to any point in time during the last 35 days.
	EarliestRestorableDateTime *time.Time `type:"timestamp"`

	// LatestRestorableDateTime is typically 5 minutes before the current time.
	LatestRestorableDateTime *time.Time `type:"timestamp"`

	// The current state of point in time recovery:
	//
	//    * ENABLING - Point in time recovery is being enabled.
	//
	//    * ENABLED - Point in time recovery is enabled.
	//
	//    * DISABLED - Point in time recovery is disabled.
	PointInTimeRecoveryStatus *string `type:"string" enum:"PointInTimeRecoveryStatus"`
}

// String returns the string representation
func (s PointInTimeRecoveryDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PointInTimeRecoveryDescription) GoString() string {
	return s.String()
}

// SetEarliestRestorableDateTime sets the EarliestRestorableDateTime field's value.
func (s *PointInTimeRecoveryDescription) SetEarliestRestorableDateTime(v time.Time) *PointInTimeRecoveryDescription {
	s.EarliestRestorableDateTime = &v
	return s
}

// SetLatestRestorableDateTime sets the LatestRestorableDateTime field's value.
func (s *PointInTimeRecoveryDescription) SetLatestRestorableDateTime(v time.Time) *PointInTimeRecoveryDescription {
	s.LatestRestorableDateTime = &v
	return s
}

// SetPointInTimeRecoveryStatus sets the PointInTimeRecoveryStatus field's value.
func (s *PointInTimeRecoveryDescription) SetPointInTimeRecoveryStatus(v string) *PointInTimeRecoveryDescription {
	s.PointInTimeRecoveryStatus = &v
	return s
}

// Represents the settings used to enable point in time recovery.
type PointInTimeRecoverySpecification struct {
	_ struct{} `type:"structure"`

	// Indicates whether point in time recovery is enabled (true) or disabled (false)
	// on the table.
	//
	// PointInTimeRecoveryEnabled is a required field
	PointInTimeRecoveryEnabled *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s PointInTimeRecoverySpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PointInTimeRecoverySpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PointInTimeRecoverySpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PointInTimeRecoverySpecification"}
	if s.PointInTimeRecoveryEnabled == nil {
		invalidParams.Add(request.NewErrParamRequired("PointInTimeRecoveryEnabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPointInTimeRecoveryEnabled sets the PointInTimeRecoveryEnabled field's value.
func (s *PointInTimeRecoverySpecification) SetPointInTimeRecoveryEnabled(v bool) *PointInTimeRecoverySpecification {
	s.PointInTimeRecoveryEnabled = &v
	return s
}

// Represents attributes that are copied (projected) from the table into an
// index. These are in addition to the primary key attributes and index key
// attributes, which are automatically projected.
type Projection struct {
	_ struct{} `type:"structure"`

	// Represents the non-key attribute names which will be projected into the index.
	//
	// For local secondary indexes, the total count of NonKeyAttributes summed across
	// all of the local secondary indexes, must not exceed 20. If you project the
	// same attribute into two different indexes, this counts as two distinct attributes
	// when determining the total.
	NonKeyAttributes []*string `min:"1" type:"list"`

	// The set of attributes that are projected into the index:
	//
	//    * KEYS_ONLY - Only the index and primary keys are projected into the index.
	//
	//    * INCLUDE - Only the specified table attributes are projected into the
	//    index. The list of projected attributes is in NonKeyAttributes.
	//
	//    * ALL - All of the table attributes are projected into the index.
	ProjectionType *string `type:"string" enum:"ProjectionType"`
}

// String returns the string representation
func (s Projection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Projection) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Projection) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Projection"}
	if s.NonKeyAttributes != nil && len(s.NonKeyAttributes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NonKeyAttributes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNonKeyAttributes sets the NonKeyAttributes field's value.
func (s *Projection) SetNonKeyAttributes(v []*string) *Projection {
	s.NonKeyAttributes = v
	return s
}

// SetProjectionType sets the ProjectionType field's value.
func (s *Projection) SetProjectionType(v string) *Projection {
	s.ProjectionType = &v
	return s
}

// Represents the provisioned throughput settings for a specified table or index.
// The settings can be modified using the UpdateTable operation.
//
// For current minimum and maximum provisioned throughput values, see Limits
// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html)
// in the Amazon DynamoDB Developer Guide.
type ProvisionedThroughput struct {
	_ struct{} `type:"structure"`

	// The maximum number of strongly consistent reads consumed per second before
	// DynamoDB returns a ThrottlingException. For more information, see Specifying
	// Read and Write Requirements (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput)
	// in the Amazon DynamoDB Developer Guide.
	//
	// If read/write capacity mode is PAY_PER_REQUEST the value is set to 0.
	//
	// ReadCapacityUnits is a required field
	ReadCapacityUnits *int64 `min:"1" type:"long" required:"true"`

	// The maximum number of writes consumed per second before DynamoDB returns
	// a ThrottlingException. For more information, see Specifying Read and Write
	// Requirements (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput)
	// in the Amazon DynamoDB Developer Guide.
	//
	// If read/write capacity mode is PAY_PER_REQUEST the value is set to 0.
	//
	// WriteCapacityUnits is a required field
	WriteCapacityUnits *int64 `min:"1" type:"long" required:"true"`
}

// String returns the string representation
func (s ProvisionedThroughput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProvisionedThroughput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProvisionedThroughput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProvisionedThroughput"}
	if s.ReadCapacityUnits == nil {
		invalidParams.Add(request.NewErrParamRequired("ReadCapacityUnits"))
	}
	if s.ReadCapacityUnits != nil && *s.ReadCapacityUnits < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ReadCapacityUnits", 1))
	}
	if s.WriteCapacityUnits == nil {
		invalidParams.Add(request.NewErrParamRequired("WriteCapacityUnits"))
	}
	if s.WriteCapacityUnits != nil && *s.WriteCapacityUnits < 1 {
		invalidParams.Add(request.NewErrParamMinValue("WriteCapacityUnits", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReadCapacityUnits sets the ReadCapacityUnits field's value.
func (s *ProvisionedThroughput) SetReadCapacityUnits(v int64) *ProvisionedThroughput {
	s.ReadCapacityUnits = &v
	return s
}

// SetWriteCapacityUnits sets the WriteCapacityUnits field's value.
func (s *ProvisionedThroughput) SetWriteCapacityUnits(v int64) *ProvisionedThroughput {
	s.WriteCapacityUnits = &v
	return s
}

// Represents the provisioned throughput settings for the table, consisting
// of read and write capacity units, along with data about increases and decreases.
type ProvisionedThroughputDescription struct {
	_ struct{} `type:"structure"`

	// The date and time of the last provisioned throughput decrease for this table.
	LastDecreaseDateTime *time.Time `type:"timestamp"`

	// The date and time of the last provisioned throughput increase for this table.
	LastIncreaseDateTime *time.Time `type:"timestamp"`

	// The number of provisioned throughput decreases for this table during this
	// UTC calendar day. For current maximums on provisioned throughput decreases,
	// see Limits (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html)
	// in the Amazon DynamoDB Developer Guide.
	NumberOfDecreasesToday *int64 `min:"1" type:"long"`

	// The maximum number of strongly consistent reads consumed per second before
	// DynamoDB returns a ThrottlingException. Eventually consistent reads require
	// less effort than strongly consistent reads, so a setting of 50 ReadCapacityUnits
	// per second provides 100 eventually consistent ReadCapacityUnits per second.
	ReadCapacityUnits *int64 `type:"long"`

	// The maximum number of writes consumed per second before DynamoDB returns
	// a ThrottlingException.
	WriteCapacityUnits *int64 `type:"long"`
}

// String returns the string representation
func (s ProvisionedThroughputDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProvisionedThroughputDescription) GoString() string {
	return s.String()
}

// SetLastDecreaseDateTime sets the LastDecreaseDateTime field's value.
func (s *ProvisionedThroughputDescription) SetLastDecreaseDateTime(v time.Time) *ProvisionedThroughputDescription {
	s.LastDecreaseDateTime = &v
	return s
}

// SetLastIncreaseDateTime sets the LastIncreaseDateTime field's value.
func (s *ProvisionedThroughputDescription) SetLastIncreaseDateTime(v time.Time) *ProvisionedThroughputDescription {
	s.LastIncreaseDateTime = &v
	return s
}

// SetNumberOfDecreasesToday sets the NumberOfDecreasesToday field's value.
func (s *ProvisionedThroughputDescription) SetNumberOfDecreasesToday(v int64) *ProvisionedThroughputDescription {
	s.NumberOfDecreasesToday = &v
	return s
}

// SetReadCapacityUnits sets the ReadCapacityUnits field's value.
func (s *ProvisionedThroughputDescription) SetReadCapacityUnits(v int64) *ProvisionedThroughputDescription {
	s.ReadCapacityUnits = &v
	return s
}

// SetWriteCapacityUnits sets the WriteCapacityUnits field's value.
func (s *ProvisionedThroughputDescription) SetWriteCapacityUnits(v int64) *ProvisionedThroughputDescription {
	s.WriteCapacityUnits = &v
	return s
}

// Replica-specific provisioned throughput settings. If not specified, uses
// the source table's provisioned throughput settings.
type ProvisionedThroughputOverride struct {
	_ struct{} `type:"structure"`

	// Replica-specific read capacity units. If not specified, uses the source table's
	// read capacity settings.
	ReadCapacityUnits *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s ProvisionedThroughputOverride) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProvisionedThroughputOverride) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProvisionedThroughputOverride) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProvisionedThroughputOverride"}
	if s.ReadCapacityUnits != nil && *s.ReadCapacityUnits < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ReadCapacityUnits", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReadCapacityUnits sets the ReadCapacityUnits field's value.
func (s *ProvisionedThroughputOverride) SetReadCapacityUnits(v int64) *ProvisionedThroughputOverride {
	s.ReadCapacityUnits = &v
	return s
}

// Represents a request to perform a PutItem operation.
type Put struct {
	_ struct{} `type:"structure"`

	// A condition that must be satisfied in order for a conditional update to succeed.
	ConditionExpression *string `type:"string"`

	// One or more substitution tokens for attribute names in an expression.
	ExpressionAttributeNames map[string]*string `type:"map"`

	// One or more values that can be substituted in an expression.
	ExpressionAttributeValues map[string]*AttributeValue `type:"map"`

	// A map of attribute name to attribute values, representing the primary key
	// of the item to be written by PutItem. All of the table's primary key attributes
	// must be specified, and their data types must match those of the table's key
	// schema. If any attributes are present in the item that are part of an index
	// key schema for the table, their types must match the index key schema.
	//
	// Item is a required field
	Item map[string]*AttributeValue `type:"map" required:"true"`

	// Use ReturnValuesOnConditionCheckFailure to get the item attributes if the
	// Put condition fails. For ReturnValuesOnConditionCheckFailure, the valid values
	// are: NONE and ALL_OLD.
	ReturnValuesOnConditionCheckFailure *string `type:"string" enum:"ReturnValuesOnConditionCheckFailure"`

	// Name of the table in which to write the item.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s Put) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Put) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Put) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Put"}
	if s.Item == nil {
		invalidParams.Add(request.NewErrParamRequired("Item"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConditionExpression sets the ConditionExpression field's value.
func (s *Put) SetConditionExpression(v string) *Put {
	s.ConditionExpression = &v
	return s
}

// SetExpressionAttributeNames sets the ExpressionAttributeNames field's value.
func (s *Put) SetExpressionAttributeNames(v map[string]*string) *Put {
	s.ExpressionAttributeNames = v
	return s
}

// SetExpressionAttributeValues sets the ExpressionAttributeValues field's value.
func (s *Put) SetExpressionAttributeValues(v map[string]*AttributeValue) *Put {
	s.ExpressionAttributeValues = v
	return s
}

// SetItem sets the Item field's value.
func (s *Put) SetItem(v map[string]*AttributeValue) *Put {
	s.Item = v
	return s
}

// SetReturnValuesOnConditionCheckFailure sets the ReturnValuesOnConditionCheckFailure field's value.
func (s *Put) SetReturnValuesOnConditionCheckFailure(v string) *Put {
	s.ReturnValuesOnConditionCheckFailure = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *Put) SetTableName(v string) *Put {
	s.TableName = &v
	return s
}

// Represents the input of a PutItem operation.
type PutItemInput struct {
	_ struct{} `type:"structure"`

	// A condition that must be satisfied in order for a conditional PutItem operation
	// to succeed.
	//
	// An expression can contain any of the following:
	//
	//    * Functions: attribute_exists | attribute_not_exists | attribute_type
	//    | contains | begins_with | size These function names are case-sensitive.
	//
	//    * Comparison operators: = | <> | < | > | <= | >= | BETWEEN | IN
	//
	//    * Logical operators: AND | OR | NOT
	//
	// For more information on condition expressions, see Condition Expressions
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html)
	// in the Amazon DynamoDB Developer Guide.
	ConditionExpression *string `type:"string"`

	// This is a legacy parameter. Use ConditionExpression instead. For more information,
	// see ConditionalOperator (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html)
	// in the Amazon DynamoDB Developer Guide.
	ConditionalOperator *string `type:"string" enum:"ConditionalOperator"`

	// This is a legacy parameter. Use ConditionExpression instead. For more information,
	// see Expected (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html)
	// in the Amazon DynamoDB Developer Guide.
	Expected map[string]*ExpectedAttributeValue `type:"map"`

	// One or more substitution tokens for attribute names in an expression. The
	// following are some use cases for using ExpressionAttributeNames:
	//
	//    * To access an attribute whose name conflicts with a DynamoDB reserved
	//    word.
	//
	//    * To create a placeholder for repeating occurrences of an attribute name
	//    in an expression.
	//
	//    * To prevent special characters in an attribute name from being misinterpreted
	//    in an expression.
	//
	// Use the # character in an expression to dereference an attribute name. For
	// example, consider the following attribute name:
	//
	//    * Percentile
	//
	// The name of this attribute conflicts with a reserved word, so it cannot be
	// used directly in an expression. (For the complete list of reserved words,
	// see Reserved Words (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
	// in the Amazon DynamoDB Developer Guide). To work around this, you could specify
	// the following for ExpressionAttributeNames:
	//
	//    * {"#P":"Percentile"}
	//
	// You could then use this substitution in an expression, as in this example:
	//
	//    * #P = :val
	//
	// Tokens that begin with the : character are expression attribute values, which
	// are placeholders for the actual value at runtime.
	//
	// For more information on expression attribute names, see Specifying Item Attributes
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
	// in the Amazon DynamoDB Developer Guide.
	ExpressionAttributeNames map[string]*string `type:"map"`

	// One or more values that can be substituted in an expression.
	//
	// Use the : (colon) character in an expression to dereference an attribute
	// value. For example, suppose that you wanted to check whether the value of
	// the ProductStatus attribute was one of the following:
	//
	// Available | Backordered | Discontinued
	//
	// You would first need to specify ExpressionAttributeValues as follows:
	//
	// { ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"}
	// }
	//
	// You could then use these values in an expression, such as this:
	//
	// ProductStatus IN (:avail, :back, :disc)
	//
	// For more information on expression attribute values, see Condition Expressions
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html)
	// in the Amazon DynamoDB Developer Guide.
	ExpressionAttributeValues map[string]*AttributeValue `type:"map"`

	// A map of attribute name/value pairs, one for each attribute. Only the primary
	// key attributes are required; you can optionally provide other attribute name-value
	// pairs for the item.
	//
	// You must provide all of the attributes for the primary key. For example,
	// with a simple primary key, you only need to provide a value for the partition
	// key. For a composite primary key, you must provide both values for both the
	// partition key and the sort key.
	//
	// If you specify any attributes that are part of an index key, then the data
	// types for those attributes must match those of the schema in the table's
	// attribute definition.
	//
	// For more information about primary keys, see Primary Key (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.CoreComponents.html#HowItWorks.CoreComponents.PrimaryKey)
	// in the Amazon DynamoDB Developer Guide.
	//
	// Each element in the Item map is an AttributeValue object.
	//
	// Item is a required field
	Item map[string]*AttributeValue `type:"map" required:"true"`

	// Determines the level of detail about provisioned throughput consumption that
	// is returned in the response:
	//
	//    * INDEXES - The response includes the aggregate ConsumedCapacity for the
	//    operation, together with ConsumedCapacity for each table and secondary
	//    index that was accessed. Note that some operations, such as GetItem and
	//    BatchGetItem, do not access any indexes at all. In these cases, specifying
	//    INDEXES will only return ConsumedCapacity information for table(s).
	//
	//    * TOTAL - The response includes only the aggregate ConsumedCapacity for
	//    the operation.
	//
	//    * NONE - No ConsumedCapacity details are included in the response.
	ReturnConsumedCapacity *string `type:"string" enum:"ReturnConsumedCapacity"`

	// Determines whether item collection metrics are returned. If set to SIZE,
	// the response includes statistics about item collections, if any, that were
	// modified during the operation are returned in the response. If set to NONE
	// (the default), no statistics are returned.
	ReturnItemCollectionMetrics *string `type:"string" enum:"ReturnItemCollectionMetrics"`

	// Use ReturnValues if you want to get the item attributes as they appeared
	// before they were updated with the PutItem request. For PutItem, the valid
	// values are:
	//
	//    * NONE - If ReturnValues is not specified, or if its value is NONE, then
	//    nothing is returned. (This setting is the default for ReturnValues.)
	//
	//    * ALL_OLD - If PutItem overwrote an attribute name-value pair, then the
	//    content of the old item is returned.
	//
	// The ReturnValues parameter is used by several DynamoDB operations; however,
	// PutItem does not recognize any values other than NONE or ALL_OLD.
	ReturnValues *string `type:"string" enum:"ReturnValue"`

	// The name of the table to contain the item.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s PutItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutItemInput"}
	if s.Item == nil {
		invalidParams.Add(request.NewErrParamRequired("Item"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConditionExpression sets the ConditionExpression field's value.
func (s *PutItemInput) SetConditionExpression(v string) *PutItemInput {
	s.ConditionExpression = &v
	return s
}

// SetConditionalOperator sets the ConditionalOperator field's value.
func (s *PutItemInput) SetConditionalOperator(v string) *PutItemInput {
	s.ConditionalOperator = &v
	return s
}

// SetExpected sets the Expected field's value.
func (s *PutItemInput) SetExpected(v map[string]*ExpectedAttributeValue) *PutItemInput {
	s.Expected = v
	return s
}

// SetExpressionAttributeNames sets the ExpressionAttributeNames field's value.
func (s *PutItemInput) SetExpressionAttributeNames(v map[string]*string) *PutItemInput {
	s.ExpressionAttributeNames = v
	return s
}

// SetExpressionAttributeValues sets the ExpressionAttributeValues field's value.
func (s *PutItemInput) SetExpressionAttributeValues(v map[string]*AttributeValue) *PutItemInput {
	s.ExpressionAttributeValues = v
	return s
}

// SetItem sets the Item field's value.
func (s *PutItemInput) SetItem(v map[string]*AttributeValue) *PutItemInput {
	s.Item = v
	return s
}

// SetReturnConsumedCapacity sets the ReturnConsumedCapacity field's value.
func (s *PutItemInput) SetReturnConsumedCapacity(v string) *PutItemInput {
	s.ReturnConsumedCapacity = &v
	return s
}

// SetReturnItemCollectionMetrics sets the ReturnItemCollectionMetrics field's value.
func (s *PutItemInput) SetReturnItemCollectionMetrics(v string) *PutItemInput {
	s.ReturnItemCollectionMetrics = &v
	return s
}

// SetReturnValues sets the ReturnValues field's value.
func (s *PutItemInput) SetReturnValues(v string) *PutItemInput {
	s.ReturnValues = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *PutItemInput) SetTableName(v string) *PutItemInput {
	s.TableName = &v
	return s
}

// Represents the output of a PutItem operation.
type PutItemOutput struct {
	_ struct{} `type:"structure"`

	// The attribute values as they appeared before the PutItem operation, but only
	// if ReturnValues is specified as ALL_OLD in the request. Each element consists
	// of an attribute name and an attribute value.
	Attributes map[string]*AttributeValue `type:"map"`

	// The capacity units consumed by the PutItem operation. The data returned includes
	// the total provisioned throughput consumed, along with statistics for the
	// table and any indexes involved in the operation. ConsumedCapacity is only
	// returned if the ReturnConsumedCapacity parameter was specified. For more
	// information, see Read/Write Capacity Mode (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html)
	// in the Amazon DynamoDB Developer Guide.
	ConsumedCapacity *ConsumedCapacity `type:"structure"`

	// Information about item collections, if any, that were affected by the PutItem
	// operation. ItemCollectionMetrics is only returned if the ReturnItemCollectionMetrics
	// parameter was specified. If the table does not have any local secondary indexes,
	// this information is not returned in the response.
	//
	// Each ItemCollectionMetrics element consists of:
	//
	//    * ItemCollectionKey - The partition key value of the item collection.
	//    This is the same as the partition key value of the item itself.
	//
	//    * SizeEstimateRangeGB - An estimate of item collection size, in gigabytes.
	//    This value is a two-element array containing a lower bound and an upper
	//    bound for the estimate. The estimate includes the size of all the items
	//    in the table, plus the size of all attributes projected into all of the
	//    local secondary indexes on that table. Use this estimate to measure whether
	//    a local secondary index is approaching its size limit. The estimate is
	//    subject to change over time; therefore, do not rely on the precision or
	//    accuracy of the estimate.
	ItemCollectionMetrics *ItemCollectionMetrics `type:"structure"`
}

// String returns the string representation
func (s PutItemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutItemOutput) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *PutItemOutput) SetAttributes(v map[string]*AttributeValue) *PutItemOutput {
	s.Attributes = v
	return s
}

// SetConsumedCapacity sets the ConsumedCapacity field's value.
func (s *PutItemOutput) SetConsumedCapacity(v *ConsumedCapacity) *PutItemOutput {
	s.ConsumedCapacity = v
	return s
}

// SetItemCollectionMetrics sets the ItemCollectionMetrics field's value.
func (s *PutItemOutput) SetItemCollectionMetrics(v *ItemCollectionMetrics) *PutItemOutput {
	s.ItemCollectionMetrics = v
	return s
}

// Represents a request to perform a PutItem operation on an item.
type PutRequest struct {
	_ struct{} `type:"structure"`

	// A map of attribute name to attribute values, representing the primary key
	// of an item to be processed by PutItem. All of the table's primary key attributes
	// must be specified, and their data types must match those of the table's key
	// schema. If any attributes are present in the item that are part of an index
	// key schema for the table, their types must match the index key schema.
	//
	// Item is a required field
	Item map[string]*AttributeValue `type:"map" required:"true"`
}

// String returns the string representation
func (s PutRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRequest) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *PutRequest) SetItem(v map[string]*AttributeValue) *PutRequest {
	s.Item = v
	return s
}

// Represents the input of a Query operation.
type QueryInput struct {
	_ struct{} `type:"structure"`

	// This is a legacy parameter. Use ProjectionExpression instead. For more information,
	// see AttributesToGet (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html)
	// in the Amazon DynamoDB Developer Guide.
	AttributesToGet []*string `min:"1" type:"list"`

	// This is a legacy parameter. Use FilterExpression instead. For more information,
	// see ConditionalOperator (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html)
	// in the Amazon DynamoDB Developer Guide.
	ConditionalOperator *string `type:"string" enum:"ConditionalOperator"`

	// Determines the read consistency model: If set to true, then the operation
	// uses strongly consistent reads; otherwise, the operation uses eventually
	// consistent reads.
	//
	// Strongly consistent reads are not supported on global secondary indexes.
	// If you query a global secondary index with ConsistentRead set to true, you
	// will receive a ValidationException.
	ConsistentRead *bool `type:"boolean"`

	// The primary key of the first item that this operation will evaluate. Use
	// the value that was returned for LastEvaluatedKey in the previous operation.
	//
	// The data type for ExclusiveStartKey must be String, Number, or Binary. No
	// set data types are allowed.
	ExclusiveStartKey map[string]*AttributeValue `type:"map"`

	// One or more substitution tokens for attribute names in an expression. The
	// following are some use cases for using ExpressionAttributeNames:
	//
	//    * To access an attribute whose name conflicts with a DynamoDB reserved
	//    word.
	//
	//    * To create a placeholder for repeating occurrences of an attribute name
	//    in an expression.
	//
	//    * To prevent special characters in an attribute name from being misinterpreted
	//    in an expression.
	//
	// Use the # character in an expression to dereference an attribute name. For
	// example, consider the following attribute name:
	//
	//    * Percentile
	//
	// The name of this attribute conflicts with a reserved word, so it cannot be
	// used directly in an expression. (For the complete list of reserved words,
	// see Reserved Words (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
	// in the Amazon DynamoDB Developer Guide). To work around this, you could specify
	// the following for ExpressionAttributeNames:
	//
	//    * {"#P":"Percentile"}
	//
	// You could then use this substitution in an expression, as in this example:
	//
	//    * #P = :val
	//
	// Tokens that begin with the : character are expression attribute values, which
	// are placeholders for the actual value at runtime.
	//
	// For more information on expression attribute names, see Specifying Item Attributes
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
	// in the Amazon DynamoDB Developer Guide.
	ExpressionAttributeNames map[string]*string `type:"map"`

	// One or more values that can be substituted in an expression.
	//
	// Use the : (colon) character in an expression to dereference an attribute
	// value. For example, suppose that you wanted to check whether the value of
	// the ProductStatus attribute was one of the following:
	//
	// Available | Backordered | Discontinued
	//
	// You would first need to specify ExpressionAttributeValues as follows:
	//
	// { ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"}
	// }
	//
	// You could then use these values in an expression, such as this:
	//
	// ProductStatus IN (:avail, :back, :disc)
	//
	// For more information on expression attribute values, see Specifying Conditions
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html)
	// in the Amazon DynamoDB Developer Guide.
	ExpressionAttributeValues map[string]*AttributeValue `type:"map"`

	// A string that contains conditions that DynamoDB applies after the Query operation,
	// but before the data is returned to you. Items that do not satisfy the FilterExpression
	// criteria are not returned.
	//
	// A FilterExpression does not allow key attributes. You cannot define a filter
	// expression based on a partition key or a sort key.
	//
	// A FilterExpression is applied after the items have already been read; the
	// process of filtering does not consume any additional read capacity units.
	//
	// For more information, see Filter Expressions (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults)
	// in the Amazon DynamoDB Developer Guide.
	FilterExpression *string `type:"string"`

	// The name of an index to query. This index can be any local secondary index
	// or global secondary index on the table. Note that if you use the IndexName
	// parameter, you must also provide TableName.
	IndexName *string `min:"3" type:"string"`

	// The condition that specifies the key values for items to be retrieved by
	// the Query action.
	//
	// The condition must perform an equality test on a single partition key value.
	//
	// The condition can optionally perform one of several comparison tests on a
	// single sort key value. This allows Query to retrieve one item with a given
	// partition key value and sort key value, or several items that have the same
	// partition key value but different sort key values.
	//
	// The partition key equality test is required, and must be specified in the
	// following format:
	//
	// partitionKeyName = :partitionkeyval
	//
	// If you also want to provide a condition for the sort key, it must be combined
	// using AND with the condition for the sort key. Following is an example, using
	// the = comparison operator for the sort key:
	//
	// partitionKeyName = :partitionkeyval AND sortKeyName = :sortkeyval
	//
	// Valid comparisons for the sort key condition are as follows:
	//
	//    * sortKeyName = :sortkeyval - true if the sort key value is equal to :sortkeyval.
	//
	//    * sortKeyName < :sortkeyval - true if the sort key value is less than
	//    :sortkeyval.
	//
	//    * sortKeyName <= :sortkeyval - true if the sort key value is less than
	//    or equal to :sortkeyval.
	//
	//    * sortKeyName > :sortkeyval - true if the sort key value is greater than
	//    :sortkeyval.
	//
	//    * sortKeyName >= :sortkeyval - true if the sort key value is greater than
	//    or equal to :sortkeyval.
	//
	//    * sortKeyName BETWEEN :sortkeyval1 AND :sortkeyval2 - true if the sort
	//    key value is greater than or equal to :sortkeyval1, and less than or equal
	//    to :sortkeyval2.
	//
	//    * begins_with ( sortKeyName, :sortkeyval ) - true if the sort key value
	//    begins with a particular operand. (You cannot use this function with a
	//    sort key that is of type Number.) Note that the function name begins_with
	//    is case-sensitive.
	//
	// Use the ExpressionAttributeValues parameter to replace tokens such as :partitionval
	// and :sortval with actual values at runtime.
	//
	// You can optionally use the ExpressionAttributeNames parameter to replace
	// the names of the partition key and sort key with placeholder tokens. This
	// option might be necessary if an attribute name conflicts with a DynamoDB
	// reserved word. For example, the following KeyConditionExpression parameter
	// causes an error because Size is a reserved word:
	//
	//    * Size = :myval
	//
	// To work around this, define a placeholder (such a #S) to represent the attribute
	// name Size. KeyConditionExpression then is as follows:
	//
	//    * #S = :myval
	//
	// For a list of reserved words, see Reserved Words (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
	// in the Amazon DynamoDB Developer Guide.
	//
	// For more information on ExpressionAttributeNames and ExpressionAttributeValues,
	// see Using Placeholders for Attribute Names and Values (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ExpressionPlaceholders.html)
	// in the Amazon DynamoDB Developer Guide.
	KeyConditionExpression *string `type:"string"`

	// This is a legacy parameter. Use KeyConditionExpression instead. For more
	// information, see KeyConditions (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.KeyConditions.html)
	// in the Amazon DynamoDB Developer Guide.
	KeyConditions map[string]*Condition `type:"map"`

	// The maximum number of items to evaluate (not necessarily the number of matching
	// items). If DynamoDB processes the number of items up to the limit while processing
	// the results, it stops the operation and returns the matching values up to
	// that point, and a key in LastEvaluatedKey to apply in a subsequent operation,
	// so that you can pick up where you left off. Also, if the processed dataset
	// size exceeds 1 MB before DynamoDB reaches this limit, it stops the operation
	// and returns the matching values up to the limit, and a key in LastEvaluatedKey
	// to apply in a subsequent operation to continue the operation. For more information,
	// see Query and Scan (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html)
	// in the Amazon DynamoDB Developer Guide.
	Limit *int64 `min:"1" type:"integer"`

	// A string that identifies one or more attributes to retrieve from the table.
	// These attributes can include scalars, sets, or elements of a JSON document.
	// The attributes in the expression must be separated by commas.
	//
	// If no attribute names are specified, then all attributes will be returned.
	// If any of the requested attributes are not found, they will not appear in
	// the result.
	//
	// For more information, see Accessing Item Attributes (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
	// in the Amazon DynamoDB Developer Guide.
	ProjectionExpression *string `type:"string"`

	// This is a legacy parameter. Use FilterExpression instead. For more information,
	// see QueryFilter (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.QueryFilter.html)
	// in the Amazon DynamoDB Developer Guide.
	QueryFilter map[string]*Condition `type:"map"`

	// Determines the level of detail about provisioned throughput consumption that
	// is returned in the response:
	//
	//    * INDEXES - The response includes the aggregate ConsumedCapacity for the
	//    operation, together with ConsumedCapacity for each table and secondary
	//    index that was accessed. Note that some operations, such as GetItem and
	//    BatchGetItem, do not access any indexes at all. In these cases, specifying
	//    INDEXES will only return ConsumedCapacity information for table(s).
	//
	//    * TOTAL - The response includes only the aggregate ConsumedCapacity for
	//    the operation.
	//
	//    * NONE - No ConsumedCapacity details are included in the response.
	ReturnConsumedCapacity *string `type:"string" enum:"ReturnConsumedCapacity"`

	// Specifies the order for index traversal: If true (default), the traversal
	// is performed in ascending order; if false, the traversal is performed in
	// descending order.
	//
	// Items with the same partition key value are stored in sorted order by sort
	// key. If the sort key data type is Number, the results are stored in numeric
	// order. For type String, the results are stored in order of UTF-8 bytes. For
	// type Binary, DynamoDB treats each byte of the binary data as unsigned.
	//
	// If ScanIndexForward is true, DynamoDB returns the results in the order in
	// which they are stored (by sort key value). This is the default behavior.
	// If ScanIndexForward is false, DynamoDB reads the results in reverse order
	// by sort key value, and then returns the results to the client.
	ScanIndexForward *bool `type:"boolean"`

	// The attributes to be returned in the result. You can retrieve all item attributes,
	// specific item attributes, the count of matching items, or in the case of
	// an index, some or all of the attributes projected into the index.
	//
	//    * ALL_ATTRIBUTES - Returns all of the item attributes from the specified
	//    table or index. If you query a local secondary index, then for each matching
	//    item in the index, DynamoDB fetches the entire item from the parent table.
	//    If the index is configured to project all item attributes, then all of
	//    the data can be obtained from the local secondary index, and no fetching
	//    is required.
	//
	//    * ALL_PROJECTED_ATTRIBUTES - Allowed only when querying an index. Retrieves
	//    all attributes that have been projected into the index. If the index is
	//    configured to project all attributes, this return value is equivalent
	//    to specifying ALL_ATTRIBUTES.
	//
	//    * COUNT - Returns the number of matching items, rather than the matching
	//    items themselves.
	//
	//    * SPECIFIC_ATTRIBUTES - Returns only the attributes listed in AttributesToGet.
	//    This return value is equivalent to specifying AttributesToGet without
	//    specifying any value for Select. If you query or scan a local secondary
	//    index and request only attributes that are projected into that index,
	//    the operation will read only the index and not the table. If any of the
	//    requested attributes are not projected into the local secondary index,
	//    DynamoDB fetches each of these attributes from the parent table. This
	//    extra fetching incurs additional throughput cost and latency. If you query
	//    or scan a global secondary index, you can only request attributes that
	//    are projected into the index. Global secondary index queries cannot fetch
	//    attributes from the parent table.
	//
	// If neither Select nor AttributesToGet are specified, DynamoDB defaults to
	// ALL_ATTRIBUTES when accessing a table, and ALL_PROJECTED_ATTRIBUTES when
	// accessing an index. You cannot use both Select and AttributesToGet together
	// in a single request, unless the value for Select is SPECIFIC_ATTRIBUTES.
	// (This usage is equivalent to specifying AttributesToGet without any value
	// for Select.)
	//
	// If you use the ProjectionExpression parameter, then the value for Select
	// can only be SPECIFIC_ATTRIBUTES. Any other value for Select will return an
	// error.
	Select *string `type:"string" enum:"Select"`

	// The name of the table containing the requested items.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s QueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueryInput"}
	if s.AttributesToGet != nil && len(s.AttributesToGet) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributesToGet", 1))
	}
	if s.IndexName != nil && len(*s.IndexName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 3))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}
	if s.KeyConditions != nil {
		for i, v := range s.KeyConditions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "KeyConditions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.QueryFilter != nil {
		for i, v := range s.QueryFilter {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "QueryFilter", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributesToGet sets the AttributesToGet field's value.
func (s *QueryInput) SetAttributesToGet(v []*string) *QueryInput {
	s.AttributesToGet = v
	return s
}

// SetConditionalOperator sets the ConditionalOperator field's value.
func (s *QueryInput) SetConditionalOperator(v string) *QueryInput {
	s.ConditionalOperator = &v
	return s
}

// SetConsistentRead sets the ConsistentRead field's value.
func (s *QueryInput) SetConsistentRead(v bool) *QueryInput {
	s.ConsistentRead = &v
	return s
}

// SetExclusiveStartKey sets the ExclusiveStartKey field's value.
func (s *QueryInput) SetExclusiveStartKey(v map[string]*AttributeValue) *QueryInput {
	s.ExclusiveStartKey = v
	return s
}

// SetExpressionAttributeNames sets the ExpressionAttributeNames field's value.
func (s *QueryInput) SetExpressionAttributeNames(v map[string]*string) *QueryInput {
	s.ExpressionAttributeNames = v
	return s
}

// SetExpressionAttributeValues sets the ExpressionAttributeValues field's value.
func (s *QueryInput) SetExpressionAttributeValues(v map[string]*AttributeValue) *QueryInput {
	s.ExpressionAttributeValues = v
	return s
}

// SetFilterExpression sets the FilterExpression field's value.
func (s *QueryInput) SetFilterExpression(v string) *QueryInput {
	s.FilterExpression = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *QueryInput) SetIndexName(v string) *QueryInput {
	s.IndexName = &v
	return s
}

// SetKeyConditionExpression sets the KeyConditionExpression field's value.
func (s *QueryInput) SetKeyConditionExpression(v string) *QueryInput {
	s.KeyConditionExpression = &v
	return s
}

// SetKeyConditions sets the KeyConditions field's value.
func (s *QueryInput) SetKeyConditions(v map[string]*Condition) *QueryInput {
	s.KeyConditions = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *QueryInput) SetLimit(v int64) *QueryInput {
	s.Limit = &v
	return s
}

// SetProjectionExpression sets the ProjectionExpression field's value.
func (s *QueryInput) SetProjectionExpression(v string) *QueryInput {
	s.ProjectionExpression = &v
	return s
}

// SetQueryFilter sets the QueryFilter field's value.
func (s *QueryInput) SetQueryFilter(v map[string]*Condition) *QueryInput {
	s.QueryFilter = v
	return s
}

// SetReturnConsumedCapacity sets the ReturnConsumedCapacity field's value.
func (s *QueryInput) SetReturnConsumedCapacity(v string) *QueryInput {
	s.ReturnConsumedCapacity = &v
	return s
}

// SetScanIndexForward sets the ScanIndexForward field's value.
func (s *QueryInput) SetScanIndexForward(v bool) *QueryInput {
	s.ScanIndexForward = &v
	return s
}

// SetSelect sets the Select field's value.
func (s *QueryInput) SetSelect(v string) *QueryInput {
	s.Select = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *QueryInput) SetTableName(v string) *QueryInput {
	s.TableName = &v
	return s
}

// Represents the output of a Query operation.
type QueryOutput struct {
	_ struct{} `type:"structure"`

	// The capacity units consumed by the Query operation. The data returned includes
	// the total provisioned throughput consumed, along with statistics for the
	// table and any indexes involved in the operation. ConsumedCapacity is only
	// returned if the ReturnConsumedCapacity parameter was specified. For more
	// information, see Provisioned Throughput (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html)
	// in the Amazon DynamoDB Developer Guide.
	ConsumedCapacity *ConsumedCapacity `type:"structure"`

	// The number of items in the response.
	//
	// If you used a QueryFilter in the request, then Count is the number of items
	// returned after the filter was applied, and ScannedCount is the number of
	// matching items before the filter was applied.
	//
	// If you did not use a filter in the request, then Count and ScannedCount are
	// the same.
	Count *int64 `type:"integer"`

	// An array of item attributes that match the query criteria. Each element in
	// this array consists of an attribute name and the value for that attribute.
	Items []map[string]*AttributeValue `type:"list"`

	// The primary key of the item where the operation stopped, inclusive of the
	// previous result set. Use this value to start a new operation, excluding this
	// value in the new request.
	//
	// If LastEvaluatedKey is empty, then the "last page" of results has been processed
	// and there is no more data to be retrieved.
	//
	// If LastEvaluatedKey is not empty, it does not necessarily mean that there
	// is more data in the result set. The only way to know when you have reached
	// the end of the result set is when LastEvaluatedKey is empty.
	LastEvaluatedKey map[string]*AttributeValue `type:"map"`

	// The number of items evaluated, before any QueryFilter is applied. A high
	// ScannedCount value with few, or no, Count results indicates an inefficient
	// Query operation. For more information, see Count and ScannedCount (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#Count)
	// in the Amazon DynamoDB Developer Guide.
	//
	// If you did not use a filter in the request, then ScannedCount is the same
	// as Count.
	ScannedCount *int64 `type:"integer"`
}

// String returns the string representation
func (s QueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryOutput) GoString() string {
	return s.String()
}

// SetConsumedCapacity sets the ConsumedCapacity field's value.
func (s *QueryOutput) SetConsumedCapacity(v *ConsumedCapacity) *QueryOutput {
	s.ConsumedCapacity = v
	return s
}

// SetCount sets the Count field's value.
func (s *QueryOutput) SetCount(v int64) *QueryOutput {
	s.Count = &v
	return s
}

// SetItems sets the Items field's value.
func (s *QueryOutput) SetItems(v []map[string]*AttributeValue) *QueryOutput {
	s.Items = v
	return s
}

// SetLastEvaluatedKey sets the LastEvaluatedKey field's value.
func (s *QueryOutput) SetLastEvaluatedKey(v map[string]*AttributeValue) *QueryOutput {
	s.LastEvaluatedKey = v
	return s
}

// SetScannedCount sets the ScannedCount field's value.
func (s *QueryOutput) SetScannedCount(v int64) *QueryOutput {
	s.ScannedCount = &v
	return s
}

// Represents the properties of a replica.
type Replica struct {
	_ struct{} `type:"structure"`

	// The Region where the replica needs to be created.
	RegionName *string `type:"string"`
}

// String returns the string representation
func (s Replica) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Replica) GoString() string {
	return s.String()
}

// SetRegionName sets the RegionName field's value.
func (s *Replica) SetRegionName(v string) *Replica {
	s.RegionName = &v
	return s
}

// Represents the auto scaling settings of the replica.
type ReplicaAutoScalingDescription struct {
	_ struct{} `type:"structure"`

	// Replica-specific global secondary index auto scaling settings.
	GlobalSecondaryIndexes []*ReplicaGlobalSecondaryIndexAutoScalingDescription `type:"list"`

	// The Region where the replica exists.
	RegionName *string `type:"string"`

	// Represents the auto scaling settings for a global table or global secondary
	// index.
	ReplicaProvisionedReadCapacityAutoScalingSettings *AutoScalingSettingsDescription `type:"structure"`

	// Represents the auto scaling settings for a global table or global secondary
	// index.
	ReplicaProvisionedWriteCapacityAutoScalingSettings *AutoScalingSettingsDescription `type:"structure"`

	// The current state of the replica:
	//
	//    * CREATING - The replica is being created.
	//
	//    * UPDATING - The replica is being updated.
	//
	//    * DELETING - The replica is being deleted.
	//
	//    * ACTIVE - The replica is ready for use.
	ReplicaStatus *string `type:"string" enum:"ReplicaStatus"`
}

// String returns the string representation
func (s ReplicaAutoScalingDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicaAutoScalingDescription) GoString() string {
	return s.String()
}

// SetGlobalSecondaryIndexes sets the GlobalSecondaryIndexes field's value.
func (s *ReplicaAutoScalingDescription) SetGlobalSecondaryIndexes(v []*ReplicaGlobalSecondaryIndexAutoScalingDescription) *ReplicaAutoScalingDescription {
	s.GlobalSecondaryIndexes = v
	return s
}

// SetRegionName sets the RegionName field's value.
func (s *ReplicaAutoScalingDescription) SetRegionName(v string) *ReplicaAutoScalingDescription {
	s.RegionName = &v
	return s
}

// SetReplicaProvisionedReadCapacityAutoScalingSettings sets the ReplicaProvisionedReadCapacityAutoScalingSettings field's value.
func (s *ReplicaAutoScalingDescription) SetReplicaProvisionedReadCapacityAutoScalingSettings(v *AutoScalingSettingsDescription) *ReplicaAutoScalingDescription {
	s.ReplicaProvisionedReadCapacityAutoScalingSettings = v
	return s
}

// SetReplicaProvisionedWriteCapacityAutoScalingSettings sets the ReplicaProvisionedWriteCapacityAutoScalingSettings field's value.
func (s *ReplicaAutoScalingDescription) SetReplicaProvisionedWriteCapacityAutoScalingSettings(v *AutoScalingSettingsDescription) *ReplicaAutoScalingDescription {
	s.ReplicaProvisionedWriteCapacityAutoScalingSettings = v
	return s
}

// SetReplicaStatus sets the ReplicaStatus field's value.
func (s *ReplicaAutoScalingDescription) SetReplicaStatus(v string) *ReplicaAutoScalingDescription {
	s.ReplicaStatus = &v
	return s
}

// Represents the auto scaling settings of a replica that will be modified.
type ReplicaAutoScalingUpdate struct {
	_ struct{} `type:"structure"`

	// The Region where the replica exists.
	//
	// RegionName is a required field
	RegionName *string `type:"string" required:"true"`

	// Represents the auto scaling settings of global secondary indexes that will
	// be modified.
	ReplicaGlobalSecondaryIndexUpdates []*ReplicaGlobalSecondaryIndexAutoScalingUpdate `type:"list"`

	// Represents the auto scaling settings to be modified for a global table or
	// global secondary index.
	ReplicaProvisionedReadCapacityAutoScalingUpdate *AutoScalingSettingsUpdate `type:"structure"`
}

// String returns the string representation
func (s ReplicaAutoScalingUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicaAutoScalingUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicaAutoScalingUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReplicaAutoScalingUpdate"}
	if s.RegionName == nil {
		invalidParams.Add(request.NewErrParamRequired("RegionName"))
	}
	if s.ReplicaGlobalSecondaryIndexUpdates != nil {
		for i, v := range s.ReplicaGlobalSecondaryIndexUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ReplicaGlobalSecondaryIndexUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ReplicaProvisionedReadCapacityAutoScalingUpdate != nil {
		if err := s.ReplicaProvisionedReadCapacityAutoScalingUpdate.Validate(); err != nil {
			invalidParams.AddNested("ReplicaProvisionedReadCapacityAutoScalingUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRegionName sets the RegionName field's value.
func (s *ReplicaAutoScalingUpdate) SetRegionName(v string) *ReplicaAutoScalingUpdate {
	s.RegionName = &v
	return s
}

// SetReplicaGlobalSecondaryIndexUpdates sets the ReplicaGlobalSecondaryIndexUpdates field's value.
func (s *ReplicaAutoScalingUpdate) SetReplicaGlobalSecondaryIndexUpdates(v []*ReplicaGlobalSecondaryIndexAutoScalingUpdate) *ReplicaAutoScalingUpdate {
	s.ReplicaGlobalSecondaryIndexUpdates = v
	return s
}

// SetReplicaProvisionedReadCapacityAutoScalingUpdate sets the ReplicaProvisionedReadCapacityAutoScalingUpdate field's value.
func (s *ReplicaAutoScalingUpdate) SetReplicaProvisionedReadCapacityAutoScalingUpdate(v *AutoScalingSettingsUpdate) *ReplicaAutoScalingUpdate {
	s.ReplicaProvisionedReadCapacityAutoScalingUpdate = v
	return s
}

// Contains the details of the replica.
type ReplicaDescription struct {
	_ struct{} `type:"structure"`

	// Replica-specific global secondary index settings.
	GlobalSecondaryIndexes []*ReplicaGlobalSecondaryIndexDescription `type:"list"`

	// The AWS KMS customer master key (CMK) of the replica that will be used for
	// AWS KMS encryption.
	KMSMasterKeyId *string `type:"string"`

	// Replica-specific provisioned throughput. If not described, uses the source
	// table's provisioned throughput settings.
	ProvisionedThroughputOverride *ProvisionedThroughputOverride `type:"structure"`

	// The name of the Region.
	RegionName *string `type:"string"`

	// The current state of the replica:
	//
	//    * CREATING - The replica is being created.
	//
	//    * UPDATING - The replica is being updated.
	//
	//    * DELETING - The replica is being deleted.
	//
	//    * ACTIVE - The replica is ready for use.
	ReplicaStatus *string `type:"string" enum:"ReplicaStatus"`

	// Detailed information about the replica status.
	ReplicaStatusDescription *string `type:"string"`

	// Specifies the progress of a Create, Update, or Delete action on the replica
	// as a percentage.
	ReplicaStatusPercentProgress *string `type:"string"`
}

// String returns the string representation
func (s ReplicaDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicaDescription) GoString() string {
	return s.String()
}

// SetGlobalSecondaryIndexes sets the GlobalSecondaryIndexes field's value.
func (s *ReplicaDescription) SetGlobalSecondaryIndexes(v []*ReplicaGlobalSecondaryIndexDescription) *ReplicaDescription {
	s.GlobalSecondaryIndexes = v
	return s
}

// SetKMSMasterKeyId sets the KMSMasterKeyId field's value.
func (s *ReplicaDescription) SetKMSMasterKeyId(v string) *ReplicaDescription {
	s.KMSMasterKeyId = &v
	return s
}

// SetProvisionedThroughputOverride sets the ProvisionedThroughputOverride field's value.
func (s *ReplicaDescription) SetProvisionedThroughputOverride(v *ProvisionedThroughputOverride) *ReplicaDescription {
	s.ProvisionedThroughputOverride = v
	return s
}

// SetRegionName sets the RegionName field's value.
func (s *ReplicaDescription) SetRegionName(v string) *ReplicaDescription {
	s.RegionName = &v
	return s
}

// SetReplicaStatus sets the ReplicaStatus field's value.
func (s *ReplicaDescription) SetReplicaStatus(v string) *ReplicaDescription {
	s.ReplicaStatus = &v
	return s
}

// SetReplicaStatusDescription sets the ReplicaStatusDescription field's value.
func (s *ReplicaDescription) SetReplicaStatusDescription(v string) *ReplicaDescription {
	s.ReplicaStatusDescription = &v
	return s
}

// SetReplicaStatusPercentProgress sets the ReplicaStatusPercentProgress field's value.
func (s *ReplicaDescription) SetReplicaStatusPercentProgress(v string) *ReplicaDescription {
	s.ReplicaStatusPercentProgress = &v
	return s
}

// Represents the properties of a replica global secondary index.
type ReplicaGlobalSecondaryIndex struct {
	_ struct{} `type:"structure"`

	// The name of the global secondary index.
	//
	// IndexName is a required field
	IndexName *string `min:"3" type:"string" required:"true"`

	// Replica table GSI-specific provisioned throughput. If not specified, uses
	// the source table GSI's read capacity settings.
	ProvisionedThroughputOverride *ProvisionedThroughputOverride `type:"structure"`
}

// String returns the string representation
func (s ReplicaGlobalSecondaryIndex) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicaGlobalSecondaryIndex) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicaGlobalSecondaryIndex) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReplicaGlobalSecondaryIndex"}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 3))
	}
	if s.ProvisionedThroughputOverride != nil {
		if err := s.ProvisionedThroughputOverride.Validate(); err != nil {
			invalidParams.AddNested("ProvisionedThroughputOverride", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexName sets the IndexName field's value.
func (s *ReplicaGlobalSecondaryIndex) SetIndexName(v string) *ReplicaGlobalSecondaryIndex {
	s.IndexName = &v
	return s
}

// SetProvisionedThroughputOverride sets the ProvisionedThroughputOverride field's value.
func (s *ReplicaGlobalSecondaryIndex) SetProvisionedThroughputOverride(v *ProvisionedThroughputOverride) *ReplicaGlobalSecondaryIndex {
	s.ProvisionedThroughputOverride = v
	return s
}

// Represents the auto scaling configuration for a replica global secondary
// index.
type ReplicaGlobalSecondaryIndexAutoScalingDescription struct {
	_ struct{} `type:"structure"`

	// The name of the global secondary index.
	IndexName *string `min:"3" type:"string"`

	// The current state of the replica global secondary index:
	//
	//    * CREATING - The index is being created.
	//
	//    * UPDATING - The index is being updated.
	//
	//    * DELETING - The index is being deleted.
	//
	//    * ACTIVE - The index is ready for use.
	IndexStatus *string `type:"string" enum:"IndexStatus"`

	// Represents the auto scaling settings for a global table or global secondary
	// index.
	ProvisionedReadCapacityAutoScalingSettings *AutoScalingSettingsDescription `type:"structure"`

	// Represents the auto scaling settings for a global table or global secondary
	// index.
	ProvisionedWriteCapacityAutoScalingSettings *AutoScalingSettingsDescription `type:"structure"`
}

// String returns the string representation
func (s ReplicaGlobalSecondaryIndexAutoScalingDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicaGlobalSecondaryIndexAutoScalingDescription) GoString() string {
	return s.String()
}

// SetIndexName sets the IndexName field's value.
func (s *ReplicaGlobalSecondaryIndexAutoScalingDescription) SetIndexName(v string) *ReplicaGlobalSecondaryIndexAutoScalingDescription {
	s.IndexName = &v
	return s
}

// SetIndexStatus sets the IndexStatus field's value.
func (s *ReplicaGlobalSecondaryIndexAutoScalingDescription) SetIndexStatus(v string) *ReplicaGlobalSecondaryIndexAutoScalingDescription {
	s.IndexStatus = &v
	return s
}

// SetProvisionedReadCapacityAutoScalingSettings sets the ProvisionedReadCapacityAutoScalingSettings field's value.
func (s *ReplicaGlobalSecondaryIndexAutoScalingDescription) SetProvisionedReadCapacityAutoScalingSettings(v *AutoScalingSettingsDescription) *ReplicaGlobalSecondaryIndexAutoScalingDescription {
	s.ProvisionedReadCapacityAutoScalingSettings = v
	return s
}

// SetProvisionedWriteCapacityAutoScalingSettings sets the ProvisionedWriteCapacityAutoScalingSettings field's value.
func (s *ReplicaGlobalSecondaryIndexAutoScalingDescription) SetProvisionedWriteCapacityAutoScalingSettings(v *AutoScalingSettingsDescription) *ReplicaGlobalSecondaryIndexAutoScalingDescription {
	s.ProvisionedWriteCapacityAutoScalingSettings = v
	return s
}

// Represents the auto scaling settings of a global secondary index for a replica
// that will be modified.
type ReplicaGlobalSecondaryIndexAutoScalingUpdate struct {
	_ struct{} `type:"structure"`

	// The name of the global secondary index.
	IndexName *string `min:"3" type:"string"`

	// Represents the auto scaling settings to be modified for a global table or
	// global secondary index.
	ProvisionedReadCapacityAutoScalingUpdate *AutoScalingSettingsUpdate `type:"structure"`
}

// String returns the string representation
func (s ReplicaGlobalSecondaryIndexAutoScalingUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicaGlobalSecondaryIndexAutoScalingUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicaGlobalSecondaryIndexAutoScalingUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReplicaGlobalSecondaryIndexAutoScalingUpdate"}
	if s.IndexName != nil && len(*s.IndexName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 3))
	}
	if s.ProvisionedReadCapacityAutoScalingUpdate != nil {
		if err := s.ProvisionedReadCapacityAutoScalingUpdate.Validate(); err != nil {
			invalidParams.AddNested("ProvisionedReadCapacityAutoScalingUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexName sets the IndexName field's value.
func (s *ReplicaGlobalSecondaryIndexAutoScalingUpdate) SetIndexName(v string) *ReplicaGlobalSecondaryIndexAutoScalingUpdate {
	s.IndexName = &v
	return s
}

// SetProvisionedReadCapacityAutoScalingUpdate sets the ProvisionedReadCapacityAutoScalingUpdate field's value.
func (s *ReplicaGlobalSecondaryIndexAutoScalingUpdate) SetProvisionedReadCapacityAutoScalingUpdate(v *AutoScalingSettingsUpdate) *ReplicaGlobalSecondaryIndexAutoScalingUpdate {
	s.ProvisionedReadCapacityAutoScalingUpdate = v
	return s
}

// Represents the properties of a replica global secondary index.
type ReplicaGlobalSecondaryIndexDescription struct {
	_ struct{} `type:"structure"`

	// The name of the global secondary index.
	IndexName *string `min:"3" type:"string"`

	// If not described, uses the source table GSI's read capacity settings.
	ProvisionedThroughputOverride *ProvisionedThroughputOverride `type:"structure"`
}

// String returns the string representation
func (s ReplicaGlobalSecondaryIndexDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicaGlobalSecondaryIndexDescription) GoString() string {
	return s.String()
}

// SetIndexName sets the IndexName field's value.
func (s *ReplicaGlobalSecondaryIndexDescription) SetIndexName(v string) *ReplicaGlobalSecondaryIndexDescription {
	s.IndexName = &v
	return s
}

// SetProvisionedThroughputOverride sets the ProvisionedThroughputOverride field's value.
func (s *ReplicaGlobalSecondaryIndexDescription) SetProvisionedThroughputOverride(v *ProvisionedThroughputOverride) *ReplicaGlobalSecondaryIndexDescription {
	s.ProvisionedThroughputOverride = v
	return s
}

// Represents the properties of a global secondary index.
type ReplicaGlobalSecondaryIndexSettingsDescription struct {
	_ struct{} `type:"structure"`

	// The name of the global secondary index. The name must be unique among all
	// other indexes on this table.
	//
	// IndexName is a required field
	IndexName *string `min:"3" type:"string" required:"true"`

	// The current status of the global secondary index:
	//
	//    * CREATING - The global secondary index is being created.
	//
	//    * UPDATING - The global secondary index is being updated.
	//
	//    * DELETING - The global secondary index is being deleted.
	//
	//    * ACTIVE - The global secondary index is ready for use.
	IndexStatus *string `type:"string" enum:"IndexStatus"`

	// Auto scaling settings for a global secondary index replica's read capacity
	// units.
	ProvisionedReadCapacityAutoScalingSettings *AutoScalingSettingsDescription `type:"structure"`

	// The maximum number of strongly consistent reads consumed per second before
	// DynamoDB returns a ThrottlingException.
	ProvisionedReadCapacityUnits *int64 `min:"1" type:"long"`

	// Auto scaling settings for a global secondary index replica's write capacity
	// units.
	ProvisionedWriteCapacityAutoScalingSettings *AutoScalingSettingsDescription `type:"structure"`

	// The maximum number of writes consumed per second before DynamoDB returns
	// a ThrottlingException.
	ProvisionedWriteCapacityUnits *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s ReplicaGlobalSecondaryIndexSettingsDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicaGlobalSecondaryIndexSettingsDescription) GoString() string {
	return s.String()
}

// SetIndexName sets the IndexName field's value.
func (s *ReplicaGlobalSecondaryIndexSettingsDescription) SetIndexName(v string) *ReplicaGlobalSecondaryIndexSettingsDescription {
	s.IndexName = &v
	return s
}

// SetIndexStatus sets the IndexStatus field's value.
func (s *ReplicaGlobalSecondaryIndexSettingsDescription) SetIndexStatus(v string) *ReplicaGlobalSecondaryIndexSettingsDescription {
	s.IndexStatus = &v
	return s
}

// SetProvisionedReadCapacityAutoScalingSettings sets the ProvisionedReadCapacityAutoScalingSettings field's value.
func (s *ReplicaGlobalSecondaryIndexSettingsDescription) SetProvisionedReadCapacityAutoScalingSettings(v *AutoScalingSettingsDescription) *ReplicaGlobalSecondaryIndexSettingsDescription {
	s.ProvisionedReadCapacityAutoScalingSettings = v
	return s
}

// SetProvisionedReadCapacityUnits sets the ProvisionedReadCapacityUnits field's value.
func (s *ReplicaGlobalSecondaryIndexSettingsDescription) SetProvisionedReadCapacityUnits(v int64) *ReplicaGlobalSecondaryIndexSettingsDescription {
	s.ProvisionedReadCapacityUnits = &v
	return s
}

// SetProvisionedWriteCapacityAutoScalingSettings sets the ProvisionedWriteCapacityAutoScalingSettings field's value.
func (s *ReplicaGlobalSecondaryIndexSettingsDescription) SetProvisionedWriteCapacityAutoScalingSettings(v *AutoScalingSettingsDescription) *ReplicaGlobalSecondaryIndexSettingsDescription {
	s.ProvisionedWriteCapacityAutoScalingSettings = v
	return s
}

// SetProvisionedWriteCapacityUnits sets the ProvisionedWriteCapacityUnits field's value.
func (s *ReplicaGlobalSecondaryIndexSettingsDescription) SetProvisionedWriteCapacityUnits(v int64) *ReplicaGlobalSecondaryIndexSettingsDescription {
	s.ProvisionedWriteCapacityUnits = &v
	return s
}

// Represents the settings of a global secondary index for a global table that
// will be modified.
type ReplicaGlobalSecondaryIndexSettingsUpdate struct {
	_ struct{} `type:"structure"`

	// The name of the global secondary index. The name must be unique among all
	// other indexes on this table.
	//
	// IndexName is a required field
	IndexName *string `min:"3" type:"string" required:"true"`

	// Auto scaling settings for managing a global secondary index replica's read
	// capacity units.
	ProvisionedReadCapacityAutoScalingSettingsUpdate *AutoScalingSettingsUpdate `type:"structure"`

	// The maximum number of strongly consistent reads consumed per second before
	// DynamoDB returns a ThrottlingException.
	ProvisionedReadCapacityUnits *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s ReplicaGlobalSecondaryIndexSettingsUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicaGlobalSecondaryIndexSettingsUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicaGlobalSecondaryIndexSettingsUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReplicaGlobalSecondaryIndexSettingsUpdate"}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 3))
	}
	if s.ProvisionedReadCapacityUnits != nil && *s.ProvisionedReadCapacityUnits < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ProvisionedReadCapacityUnits", 1))
	}
	if s.ProvisionedReadCapacityAutoScalingSettingsUpdate != nil {
		if err := s.ProvisionedReadCapacityAutoScalingSettingsUpdate.Validate(); err != nil {
			invalidParams.AddNested("ProvisionedReadCapacityAutoScalingSettingsUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexName sets the IndexName field's value.
func (s *ReplicaGlobalSecondaryIndexSettingsUpdate) SetIndexName(v string) *ReplicaGlobalSecondaryIndexSettingsUpdate {
	s.IndexName = &v
	return s
}

// SetProvisionedReadCapacityAutoScalingSettingsUpdate sets the ProvisionedReadCapacityAutoScalingSettingsUpdate field's value.
func (s *ReplicaGlobalSecondaryIndexSettingsUpdate) SetProvisionedReadCapacityAutoScalingSettingsUpdate(v *AutoScalingSettingsUpdate) *ReplicaGlobalSecondaryIndexSettingsUpdate {
	s.ProvisionedReadCapacityAutoScalingSettingsUpdate = v
	return s
}

// SetProvisionedReadCapacityUnits sets the ProvisionedReadCapacityUnits field's value.
func (s *ReplicaGlobalSecondaryIndexSettingsUpdate) SetProvisionedReadCapacityUnits(v int64) *ReplicaGlobalSecondaryIndexSettingsUpdate {
	s.ProvisionedReadCapacityUnits = &v
	return s
}

// Represents the properties of a replica.
type ReplicaSettingsDescription struct {
	_ struct{} `type:"structure"`

	// The Region name of the replica.
	//
	// RegionName is a required field
	RegionName *string `type:"string" required:"true"`

	// The read/write capacity mode of the replica.
	ReplicaBillingModeSummary *BillingModeSummary `type:"structure"`

	// Replica global secondary index settings for the global table.
	ReplicaGlobalSecondaryIndexSettings []*ReplicaGlobalSecondaryIndexSettingsDescription `type:"list"`

	// Auto scaling settings for a global table replica's read capacity units.
	ReplicaProvisionedReadCapacityAutoScalingSettings *AutoScalingSettingsDescription `type:"structure"`

	// The maximum number of strongly consistent reads consumed per second before
	// DynamoDB returns a ThrottlingException. For more information, see Specifying
	// Read and Write Requirements (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput)
	// in the Amazon DynamoDB Developer Guide.
	ReplicaProvisionedReadCapacityUnits *int64 `type:"long"`

	// Auto scaling settings for a global table replica's write capacity units.
	ReplicaProvisionedWriteCapacityAutoScalingSettings *AutoScalingSettingsDescription `type:"structure"`

	// The maximum number of writes consumed per second before DynamoDB returns
	// a ThrottlingException. For more information, see Specifying Read and Write
	// Requirements (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput)
	// in the Amazon DynamoDB Developer Guide.
	ReplicaProvisionedWriteCapacityUnits *int64 `type:"long"`

	// The current state of the Region:
	//
	//    * CREATING - The Region is being created.
	//
	//    * UPDATING - The Region is being updated.
	//
	//    * DELETING - The Region is being deleted.
	//
	//    * ACTIVE - The Region is ready for use.
	ReplicaStatus *string `type:"string" enum:"ReplicaStatus"`
}

// String returns the string representation
func (s ReplicaSettingsDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicaSettingsDescription) GoString() string {
	return s.String()
}

// SetRegionName sets the RegionName field's value.
func (s *ReplicaSettingsDescription) SetRegionName(v string) *ReplicaSettingsDescription {
	s.RegionName = &v
	return s
}

// SetReplicaBillingModeSummary sets the ReplicaBillingModeSummary field's value.
func (s *ReplicaSettingsDescription) SetReplicaBillingModeSummary(v *BillingModeSummary) *ReplicaSettingsDescription {
	s.ReplicaBillingModeSummary = v
	return s
}

// SetReplicaGlobalSecondaryIndexSettings sets the ReplicaGlobalSecondaryIndexSettings field's value.
func (s *ReplicaSettingsDescription) SetReplicaGlobalSecondaryIndexSettings(v []*ReplicaGlobalSecondaryIndexSettingsDescription) *ReplicaSettingsDescription {
	s.ReplicaGlobalSecondaryIndexSettings = v
	return s
}

// SetReplicaProvisionedReadCapacityAutoScalingSettings sets the ReplicaProvisionedReadCapacityAutoScalingSettings field's value.
func (s *ReplicaSettingsDescription) SetReplicaProvisionedReadCapacityAutoScalingSettings(v *AutoScalingSettingsDescription) *ReplicaSettingsDescription {
	s.ReplicaProvisionedReadCapacityAutoScalingSettings = v
	return s
}

// SetReplicaProvisionedReadCapacityUnits sets the ReplicaProvisionedReadCapacityUnits field's value.
func (s *ReplicaSettingsDescription) SetReplicaProvisionedReadCapacityUnits(v int64) *ReplicaSettingsDescription {
	s.ReplicaProvisionedReadCapacityUnits = &v
	return s
}

// SetReplicaProvisionedWriteCapacityAutoScalingSettings sets the ReplicaProvisionedWriteCapacityAutoScalingSettings field's value.
func (s *ReplicaSettingsDescription) SetReplicaProvisionedWriteCapacityAutoScalingSettings(v *AutoScalingSettingsDescription) *ReplicaSettingsDescription {
	s.ReplicaProvisionedWriteCapacityAutoScalingSettings = v
	return s
}

// SetReplicaProvisionedWriteCapacityUnits sets the ReplicaProvisionedWriteCapacityUnits field's value.
func (s *ReplicaSettingsDescription) SetReplicaProvisionedWriteCapacityUnits(v int64) *ReplicaSettingsDescription {
	s.ReplicaProvisionedWriteCapacityUnits = &v
	return s
}

// SetReplicaStatus sets the ReplicaStatus field's value.
func (s *ReplicaSettingsDescription) SetReplicaStatus(v string) *ReplicaSettingsDescription {
	s.ReplicaStatus = &v
	return s
}

// Represents the settings for a global table in a Region that will be modified.
type ReplicaSettingsUpdate struct {
	_ struct{} `type:"structure"`

	// The Region of the replica to be added.
	//
	// RegionName is a required field
	RegionName *string `type:"string" required:"true"`

	// Represents the settings of a global secondary index for a global table that
	// will be modified.
	ReplicaGlobalSecondaryIndexSettingsUpdate []*ReplicaGlobalSecondaryIndexSettingsUpdate `min:"1" type:"list"`

	// Auto scaling settings for managing a global table replica's read capacity
	// units.
	ReplicaProvisionedReadCapacityAutoScalingSettingsUpdate *AutoScalingSettingsUpdate `type:"structure"`

	// The maximum number of strongly consistent reads consumed per second before
	// DynamoDB returns a ThrottlingException. For more information, see Specifying
	// Read and Write Requirements (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput)
	// in the Amazon DynamoDB Developer Guide.
	ReplicaProvisionedReadCapacityUnits *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s ReplicaSettingsUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicaSettingsUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicaSettingsUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReplicaSettingsUpdate"}
	if s.RegionName == nil {
		invalidParams.Add(request.NewErrParamRequired("RegionName"))
	}
	if s.ReplicaGlobalSecondaryIndexSettingsUpdate != nil && len(s.ReplicaGlobalSecondaryIndexSettingsUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReplicaGlobalSecondaryIndexSettingsUpdate", 1))
	}
	if s.ReplicaProvisionedReadCapacityUnits != nil && *s.ReplicaProvisionedReadCapacityUnits < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ReplicaProvisionedReadCapacityUnits", 1))
	}
	if s.ReplicaGlobalSecondaryIndexSettingsUpdate != nil {
		for i, v := range s.ReplicaGlobalSecondaryIndexSettingsUpdate {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ReplicaGlobalSecondaryIndexSettingsUpdate", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ReplicaProvisionedReadCapacityAutoScalingSettingsUpdate != nil {
		if err := s.ReplicaProvisionedReadCapacityAutoScalingSettingsUpdate.Validate(); err != nil {
			invalidParams.AddNested("ReplicaProvisionedReadCapacityAutoScalingSettingsUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRegionName sets the RegionName field's value.
func (s *ReplicaSettingsUpdate) SetRegionName(v string) *ReplicaSettingsUpdate {
	s.RegionName = &v
	return s
}

// SetReplicaGlobalSecondaryIndexSettingsUpdate sets the ReplicaGlobalSecondaryIndexSettingsUpdate field's value.
func (s *ReplicaSettingsUpdate) SetReplicaGlobalSecondaryIndexSettingsUpdate(v []*ReplicaGlobalSecondaryIndexSettingsUpdate) *ReplicaSettingsUpdate {
	s.ReplicaGlobalSecondaryIndexSettingsUpdate = v
	return s
}

// SetReplicaProvisionedReadCapacityAutoScalingSettingsUpdate sets the ReplicaProvisionedReadCapacityAutoScalingSettingsUpdate field's value.
func (s *ReplicaSettingsUpdate) SetReplicaProvisionedReadCapacityAutoScalingSettingsUpdate(v *AutoScalingSettingsUpdate) *ReplicaSettingsUpdate {
	s.ReplicaProvisionedReadCapacityAutoScalingSettingsUpdate = v
	return s
}

// SetReplicaProvisionedReadCapacityUnits sets the ReplicaProvisionedReadCapacityUnits field's value.
func (s *ReplicaSettingsUpdate) SetReplicaProvisionedReadCapacityUnits(v int64) *ReplicaSettingsUpdate {
	s.ReplicaProvisionedReadCapacityUnits = &v
	return s
}

// Represents one of the following:
//
//    * A new replica to be added to an existing global table.
//
//    * New parameters for an existing replica.
//
//    * An existing replica to be removed from an existing global table.
type ReplicaUpdate struct {
	_ struct{} `type:"structure"`

	// The parameters required for creating a replica on an existing global table.
	Create *CreateReplicaAction `type:"structure"`

	// The name of the existing replica to be removed.
	Delete *DeleteReplicaAction `type:"structure"`
}

// String returns the string representation
func (s ReplicaUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicaUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicaUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReplicaUpdate"}
	if s.Create != nil {
		if err := s.Create.Validate(); err != nil {
			invalidParams.AddNested("Create", err.(request.ErrInvalidParams))
		}
	}
	if s.Delete != nil {
		if err := s.Delete.Validate(); err != nil {
			invalidParams.AddNested("Delete", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreate sets the Create field's value.
func (s *ReplicaUpdate) SetCreate(v *CreateReplicaAction) *ReplicaUpdate {
	s.Create = v
	return s
}

// SetDelete sets the Delete field's value.
func (s *ReplicaUpdate) SetDelete(v *DeleteReplicaAction) *ReplicaUpdate {
	s.Delete = v
	return s
}

// Represents one of the following:
//
//    * A new replica to be added to an existing regional table or global table.
//    This request invokes the CreateTableReplica action in the destination
//    Region.
//
//    * New parameters for an existing replica. This request invokes the UpdateTable
//    action in the destination Region.
//
//    * An existing replica to be deleted. The request invokes the DeleteTableReplica
//    action in the destination Region, deleting the replica and all if its
//    items in the destination Region.
type ReplicationGroupUpdate struct {
	_ struct{} `type:"structure"`

	// The parameters required for creating a replica for the table.
	Create *CreateReplicationGroupMemberAction `type:"structure"`

	// The parameters required for deleting a replica for the table.
	Delete *DeleteReplicationGroupMemberAction `type:"structure"`

	// The parameters required for updating a replica for the table.
	Update *UpdateReplicationGroupMemberAction `type:"structure"`
}

// String returns the string representation
func (s ReplicationGroupUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationGroupUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicationGroupUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReplicationGroupUpdate"}
	if s.Create != nil {
		if err := s.Create.Validate(); err != nil {
			invalidParams.AddNested("Create", err.(request.ErrInvalidParams))
		}
	}
	if s.Delete != nil {
		if err := s.Delete.Validate(); err != nil {
			invalidParams.AddNested("Delete", err.(request.ErrInvalidParams))
		}
	}
	if s.Update != nil {
		if err := s.Update.Validate(); err != nil {
			invalidParams.AddNested("Update", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreate sets the Create field's value.
func (s *ReplicationGroupUpdate) SetCreate(v *CreateReplicationGroupMemberAction) *ReplicationGroupUpdate {
	s.Create = v
	return s
}

// SetDelete sets the Delete field's value.
func (s *ReplicationGroupUpdate) SetDelete(v *DeleteReplicationGroupMemberAction) *ReplicationGroupUpdate {
	s.Delete = v
	return s
}

// SetUpdate sets the Update field's value.
func (s *ReplicationGroupUpdate) SetUpdate(v *UpdateReplicationGroupMemberAction) *ReplicationGroupUpdate {
	s.Update = v
	return s
}

// Contains details for the restore.
type RestoreSummary struct {
	_ struct{} `type:"structure"`

	// Point in time or source backup time.
	//
	// RestoreDateTime is a required field
	RestoreDateTime *time.Time `type:"timestamp" required:"true"`

	// Indicates if a restore is in progress or not.
	//
	// RestoreInProgress is a required field
	RestoreInProgress *bool `type:"boolean" required:"true"`

	// The Amazon Resource Name (ARN) of the backup from which the table was restored.
	SourceBackupArn *string `min:"37" type:"string"`

	// The ARN of the source table of the backup that is being restored.
	SourceTableArn *string `type:"string"`
}

// String returns the string representation
func (s RestoreSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreSummary) GoString() string {
	return s.String()
}

// SetRestoreDateTime sets the RestoreDateTime field's value.
func (s *RestoreSummary) SetRestoreDateTime(v time.Time) *RestoreSummary {
	s.RestoreDateTime = &v
	return s
}

// SetRestoreInProgress sets the RestoreInProgress field's value.
func (s *RestoreSummary) SetRestoreInProgress(v bool) *RestoreSummary {
	s.RestoreInProgress = &v
	return s
}

// SetSourceBackupArn sets the SourceBackupArn field's value.
func (s *RestoreSummary) SetSourceBackupArn(v string) *RestoreSummary {
	s.SourceBackupArn = &v
	return s
}

// SetSourceTableArn sets the SourceTableArn field's value.
func (s *RestoreSummary) SetSourceTableArn(v string) *RestoreSummary {
	s.SourceTableArn = &v
	return s
}

type RestoreTableFromBackupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) associated with the backup.
	//
	// BackupArn is a required field
	BackupArn *string `min:"37" type:"string" required:"true"`

	// The billing mode of the restored table.
	BillingModeOverride *string `type:"string" enum:"BillingMode"`

	// List of global secondary indexes for the restored table. The indexes provided
	// should match existing secondary indexes. You can choose to exclude some or
	// all of the indexes at the time of restore.
	GlobalSecondaryIndexOverride []*GlobalSecondaryIndex `type:"list"`

	// List of local secondary indexes for the restored table. The indexes provided
	// should match existing secondary indexes. You can choose to exclude some or
	// all of the indexes at the time of restore.
	LocalSecondaryIndexOverride []*LocalSecondaryIndex `type:"list"`

	// Provisioned throughput settings for the restored table.
	ProvisionedThroughputOverride *ProvisionedThroughput `type:"structure"`

	// The name of the new table to which the backup must be restored.
	//
	// TargetTableName is a required field
	TargetTableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s RestoreTableFromBackupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreTableFromBackupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreTableFromBackupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreTableFromBackupInput"}
	if s.BackupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupArn"))
	}
	if s.BackupArn != nil && len(*s.BackupArn) < 37 {
		invalidParams.Add(request.NewErrParamMinLen("BackupArn", 37))
	}
	if s.TargetTableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetTableName"))
	}
	if s.TargetTableName != nil && len(*s.TargetTableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TargetTableName", 3))
	}
	if s.GlobalSecondaryIndexOverride != nil {
		for i, v := range s.GlobalSecondaryIndexOverride {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "GlobalSecondaryIndexOverride", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.LocalSecondaryIndexOverride != nil {
		for i, v := range s.LocalSecondaryIndexOverride {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LocalSecondaryIndexOverride", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ProvisionedThroughputOverride != nil {
		if err := s.ProvisionedThroughputOverride.Validate(); err != nil {
			invalidParams.AddNested("ProvisionedThroughputOverride", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupArn sets the BackupArn field's value.
func (s *RestoreTableFromBackupInput) SetBackupArn(v string) *RestoreTableFromBackupInput {
	s.BackupArn = &v
	return s
}

// SetBillingModeOverride sets the BillingModeOverride field's value.
func (s *RestoreTableFromBackupInput) SetBillingModeOverride(v string) *RestoreTableFromBackupInput {
	s.BillingModeOverride = &v
	return s
}

// SetGlobalSecondaryIndexOverride sets the GlobalSecondaryIndexOverride field's value.
func (s *RestoreTableFromBackupInput) SetGlobalSecondaryIndexOverride(v []*GlobalSecondaryIndex) *RestoreTableFromBackupInput {
	s.GlobalSecondaryIndexOverride = v
	return s
}

// SetLocalSecondaryIndexOverride sets the LocalSecondaryIndexOverride field's value.
func (s *RestoreTableFromBackupInput) SetLocalSecondaryIndexOverride(v []*LocalSecondaryIndex) *RestoreTableFromBackupInput {
	s.LocalSecondaryIndexOverride = v
	return s
}

// SetProvisionedThroughputOverride sets the ProvisionedThroughputOverride field's value.
func (s *RestoreTableFromBackupInput) SetProvisionedThroughputOverride(v *ProvisionedThroughput) *RestoreTableFromBackupInput {
	s.ProvisionedThroughputOverride = v
	return s
}

// SetTargetTableName sets the TargetTableName field's value.
func (s *RestoreTableFromBackupInput) SetTargetTableName(v string) *RestoreTableFromBackupInput {
	s.TargetTableName = &v
	return s
}

type RestoreTableFromBackupOutput struct {
	_ struct{} `type:"structure"`

	// The description of the table created from an existing backup.
	TableDescription *TableDescription `type:"structure"`
}

// String returns the string representation
func (s RestoreTableFromBackupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreTableFromBackupOutput) GoString() string {
	return s.String()
}

// SetTableDescription sets the TableDescription field's value.
func (s *RestoreTableFromBackupOutput) SetTableDescription(v *TableDescription) *RestoreTableFromBackupOutput {
	s.TableDescription = v
	return s
}

type RestoreTableToPointInTimeInput struct {
	_ struct{} `type:"structure"`

	// The billing mode of the restored table.
	BillingModeOverride *string `type:"string" enum:"BillingMode"`

	// List of global secondary indexes for the restored table. The indexes provided
	// should match existing secondary indexes. You can choose to exclude some or
	// all of the indexes at the time of restore.
	GlobalSecondaryIndexOverride []*GlobalSecondaryIndex `type:"list"`

	// List of local secondary indexes for the restored table. The indexes provided
	// should match existing secondary indexes. You can choose to exclude some or
	// all of the indexes at the time of restore.
	LocalSecondaryIndexOverride []*LocalSecondaryIndex `type:"list"`

	// Provisioned throughput settings for the restored table.
	ProvisionedThroughputOverride *ProvisionedThroughput `type:"structure"`

	// Time in the past to restore the table to.
	RestoreDateTime *time.Time `type:"timestamp"`

	// Name of the source table that is being restored.
	//
	// SourceTableName is a required field
	SourceTableName *string `min:"3" type:"string" required:"true"`

	// The name of the new table to which it must be restored to.
	//
	// TargetTableName is a required field
	TargetTableName *string `min:"3" type:"string" required:"true"`

	// Restore the table to the latest possible time. LatestRestorableDateTime is
	// typically 5 minutes before the current time.
	UseLatestRestorableTime *bool `type:"boolean"`
}

// String returns the string representation
func (s RestoreTableToPointInTimeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreTableToPointInTimeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreTableToPointInTimeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreTableToPointInTimeInput"}
	if s.SourceTableName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceTableName"))
	}
	if s.SourceTableName != nil && len(*s.SourceTableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("SourceTableName", 3))
	}
	if s.TargetTableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetTableName"))
	}
	if s.TargetTableName != nil && len(*s.TargetTableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TargetTableName", 3))
	}
	if s.GlobalSecondaryIndexOverride != nil {
		for i, v := range s.GlobalSecondaryIndexOverride {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "GlobalSecondaryIndexOverride", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.LocalSecondaryIndexOverride != nil {
		for i, v := range s.LocalSecondaryIndexOverride {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LocalSecondaryIndexOverride", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ProvisionedThroughputOverride != nil {
		if err := s.ProvisionedThroughputOverride.Validate(); err != nil {
			invalidParams.AddNested("ProvisionedThroughputOverride", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBillingModeOverride sets the BillingModeOverride field's value.
func (s *RestoreTableToPointInTimeInput) SetBillingModeOverride(v string) *RestoreTableToPointInTimeInput {
	s.BillingModeOverride = &v
	return s
}

// SetGlobalSecondaryIndexOverride sets the GlobalSecondaryIndexOverride field's value.
func (s *RestoreTableToPointInTimeInput) SetGlobalSecondaryIndexOverride(v []*GlobalSecondaryIndex) *RestoreTableToPointInTimeInput {
	s.GlobalSecondaryIndexOverride = v
	return s
}

// SetLocalSecondaryIndexOverride sets the LocalSecondaryIndexOverride field's value.
func (s *RestoreTableToPointInTimeInput) SetLocalSecondaryIndexOverride(v []*LocalSecondaryIndex) *RestoreTableToPointInTimeInput {
	s.LocalSecondaryIndexOverride = v
	return s
}

// SetProvisionedThroughputOverride sets the ProvisionedThroughputOverride field's value.
func (s *RestoreTableToPointInTimeInput) SetProvisionedThroughputOverride(v *ProvisionedThroughput) *RestoreTableToPointInTimeInput {
	s.ProvisionedThroughputOverride = v
	return s
}

// SetRestoreDateTime sets the RestoreDateTime field's value.
func (s *RestoreTableToPointInTimeInput) SetRestoreDateTime(v time.Time) *RestoreTableToPointInTimeInput {
	s.RestoreDateTime = &v
	return s
}

// SetSourceTableName sets the SourceTableName field's value.
func (s *RestoreTableToPointInTimeInput) SetSourceTableName(v string) *RestoreTableToPointInTimeInput {
	s.SourceTableName = &v
	return s
}

// SetTargetTableName sets the TargetTableName field's value.
func (s *RestoreTableToPointInTimeInput) SetTargetTableName(v string) *RestoreTableToPointInTimeInput {
	s.TargetTableName = &v
	return s
}

// SetUseLatestRestorableTime sets the UseLatestRestorableTime field's value.
func (s *RestoreTableToPointInTimeInput) SetUseLatestRestorableTime(v bool) *RestoreTableToPointInTimeInput {
	s.UseLatestRestorableTime = &v
	return s
}

type RestoreTableToPointInTimeOutput struct {
	_ struct{} `type:"structure"`

	// Represents the properties of a table.
	TableDescription *TableDescription `type:"structure"`
}

// String returns the string representation
func (s RestoreTableToPointInTimeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreTableToPointInTimeOutput) GoString() string {
	return s.String()
}

// SetTableDescription sets the TableDescription field's value.
func (s *RestoreTableToPointInTimeOutput) SetTableDescription(v *TableDescription) *RestoreTableToPointInTimeOutput {
	s.TableDescription = v
	return s
}

// The description of the server-side encryption status on the specified table.
type SSEDescription struct {
	_ struct{} `type:"structure"`

	// Indicates the time, in UNIX epoch date format, when DynamoDB detected that
	// the table's AWS KMS key was inaccessible. This attribute will automatically
	// be cleared when DynamoDB detects that the table's AWS KMS key is accessible
	// again. DynamoDB will initiate the table archival process when table's AWS
	// KMS key remains inaccessible for more than seven days from this date.
	InaccessibleEncryptionDateTime *time.Time `type:"timestamp"`

	// The AWS KMS customer master key (CMK) ARN used for the AWS KMS encryption.
	KMSMasterKeyArn *string `type:"string"`

	// Server-side encryption type. The only supported value is:
	//
	//    * KMS - Server-side encryption that uses AWS Key Management Service. The
	//    key is stored in your account and is managed by AWS KMS (AWS KMS charges
	//    apply).
	SSEType *string `type:"string" enum:"SSEType"`

	// Represents the current state of server-side encryption. The only supported
	// values are:
	//
	//    * ENABLED - Server-side encryption is enabled.
	//
	//    * UPDATING - Server-side encryption is being updated.
	Status *string `type:"string" enum:"SSEStatus"`
}

// String returns the string representation
func (s SSEDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SSEDescription) GoString() string {
	return s.String()
}

// SetInaccessibleEncryptionDateTime sets the InaccessibleEncryptionDateTime field's value.
func (s *SSEDescription) SetInaccessibleEncryptionDateTime(v time.Time) *SSEDescription {
	s.InaccessibleEncryptionDateTime = &v
	return s
}

// SetKMSMasterKeyArn sets the KMSMasterKeyArn field's value.
func (s *SSEDescription) SetKMSMasterKeyArn(v string) *SSEDescription {
	s.KMSMasterKeyArn = &v
	return s
}

// SetSSEType sets the SSEType field's value.
func (s *SSEDescription) SetSSEType(v string) *SSEDescription {
	s.SSEType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SSEDescription) SetStatus(v string) *SSEDescription {
	s.Status = &v
	return s
}

// Represents the settings used to enable server-side encryption.
type SSESpecification struct {
	_ struct{} `type:"structure"`

	// Indicates whether server-side encryption is done using an AWS managed CMK
	// or an AWS owned CMK. If enabled (true), server-side encryption type is set
	// to KMS and an AWS managed CMK is used (AWS KMS charges apply). If disabled
	// (false) or not specified, server-side encryption is set to AWS owned CMK.
	Enabled *bool `type:"boolean"`

	// The AWS KMS customer master key (CMK) that should be used for the AWS KMS
	// encryption. To specify a CMK, use its key ID, Amazon Resource Name (ARN),
	// alias name, or alias ARN. Note that you should only provide this parameter
	// if the key is different from the default DynamoDB customer master key alias/aws/dynamodb.
	KMSMasterKeyId *string `type:"string"`

	// Server-side encryption type. The only supported value is:
	//
	//    * KMS - Server-side encryption that uses AWS Key Management Service. The
	//    key is stored in your account and is managed by AWS KMS (AWS KMS charges
	//    apply).
	SSEType *string `type:"string" enum:"SSEType"`
}

// String returns the string representation
func (s SSESpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SSESpecification) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *SSESpecification) SetEnabled(v bool) *SSESpecification {
	s.Enabled = &v
	return s
}

// SetKMSMasterKeyId sets the KMSMasterKeyId field's value.
func (s *SSESpecification) SetKMSMasterKeyId(v string) *SSESpecification {
	s.KMSMasterKeyId = &v
	return s
}

// SetSSEType sets the SSEType field's value.
func (s *SSESpecification) SetSSEType(v string) *SSESpecification {
	s.SSEType = &v
	return s
}

// Represents the input of a Scan operation.
type ScanInput struct {
	_ struct{} `type:"structure"`

	// This is a legacy parameter. Use ProjectionExpression instead. For more information,
	// see AttributesToGet (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html)
	// in the Amazon DynamoDB Developer Guide.
	AttributesToGet []*string `min:"1" type:"list"`

	// This is a legacy parameter. Use FilterExpression instead. For more information,
	// see ConditionalOperator (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html)
	// in the Amazon DynamoDB Developer Guide.
	ConditionalOperator *string `type:"string" enum:"ConditionalOperator"`

	// A Boolean value that determines the read consistency model during the scan:
	//
	//    * If ConsistentRead is false, then the data returned from Scan might not
	//    contain the results from other recently completed write operations (PutItem,
	//    UpdateItem, or DeleteItem).
	//
	//    * If ConsistentRead is true, then all of the write operations that completed
	//    before the Scan began are guaranteed to be contained in the Scan response.
	//
	// The default setting for ConsistentRead is false.
	//
	// The ConsistentRead parameter is not supported on global secondary indexes.
	// If you scan a global secondary index with ConsistentRead set to true, you
	// will receive a ValidationException.
	ConsistentRead *bool `type:"boolean"`

	// The primary key of the first item that this operation will evaluate. Use
	// the value that was returned for LastEvaluatedKey in the previous operation.
	//
	// The data type for ExclusiveStartKey must be String, Number or Binary. No
	// set data types are allowed.
	//
	// In a parallel scan, a Scan request that includes ExclusiveStartKey must specify
	// the same segment whose previous Scan returned the corresponding value of
	// LastEvaluatedKey.
	ExclusiveStartKey map[string]*AttributeValue `type:"map"`

	// One or more substitution tokens for attribute names in an expression. The
	// following are some use cases for using ExpressionAttributeNames:
	//
	//    * To access an attribute whose name conflicts with a DynamoDB reserved
	//    word.
	//
	//    * To create a placeholder for repeating occurrences of an attribute name
	//    in an expression.
	//
	//    * To prevent special characters in an attribute name from being misinterpreted
	//    in an expression.
	//
	// Use the # character in an expression to dereference an attribute name. For
	// example, consider the following attribute name:
	//
	//    * Percentile
	//
	// The name of this attribute conflicts with a reserved word, so it cannot be
	// used directly in an expression. (For the complete list of reserved words,
	// see Reserved Words (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
	// in the Amazon DynamoDB Developer Guide). To work around this, you could specify
	// the following for ExpressionAttributeNames:
	//
	//    * {"#P":"Percentile"}
	//
	// You could then use this substitution in an expression, as in this example:
	//
	//    * #P = :val
	//
	// Tokens that begin with the : character are expression attribute values, which
	// are placeholders for the actual value at runtime.
	//
	// For more information on expression attribute names, see Specifying Item Attributes
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
	// in the Amazon DynamoDB Developer Guide.
	ExpressionAttributeNames map[string]*string `type:"map"`

	// One or more values that can be substituted in an expression.
	//
	// Use the : (colon) character in an expression to dereference an attribute
	// value. For example, suppose that you wanted to check whether the value of
	// the ProductStatus attribute was one of the following:
	//
	// Available | Backordered | Discontinued
	//
	// You would first need to specify ExpressionAttributeValues as follows:
	//
	// { ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"}
	// }
	//
	// You could then use these values in an expression, such as this:
	//
	// ProductStatus IN (:avail, :back, :disc)
	//
	// For more information on expression attribute values, see Condition Expressions
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html)
	// in the Amazon DynamoDB Developer Guide.
	ExpressionAttributeValues map[string]*AttributeValue `type:"map"`

	// A string that contains conditions that DynamoDB applies after the Scan operation,
	// but before the data is returned to you. Items that do not satisfy the FilterExpression
	// criteria are not returned.
	//
	// A FilterExpression is applied after the items have already been read; the
	// process of filtering does not consume any additional read capacity units.
	//
	// For more information, see Filter Expressions (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults)
	// in the Amazon DynamoDB Developer Guide.
	FilterExpression *string `type:"string"`

	// The name of a secondary index to scan. This index can be any local secondary
	// index or global secondary index. Note that if you use the IndexName parameter,
	// you must also provide TableName.
	IndexName *string `min:"3" type:"string"`

	// The maximum number of items to evaluate (not necessarily the number of matching
	// items). If DynamoDB processes the number of items up to the limit while processing
	// the results, it stops the operation and returns the matching values up to
	// that point, and a key in LastEvaluatedKey to apply in a subsequent operation,
	// so that you can pick up where you left off. Also, if the processed dataset
	// size exceeds 1 MB before DynamoDB reaches this limit, it stops the operation
	// and returns the matching values up to the limit, and a key in LastEvaluatedKey
	// to apply in a subsequent operation to continue the operation. For more information,
	// see Working with Queries (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html)
	// in the Amazon DynamoDB Developer Guide.
	Limit *int64 `min:"1" type:"integer"`

	// A string that identifies one or more attributes to retrieve from the specified
	// table or index. These attributes can include scalars, sets, or elements of
	// a JSON document. The attributes in the expression must be separated by commas.
	//
	// If no attribute names are specified, then all attributes will be returned.
	// If any of the requested attributes are not found, they will not appear in
	// the result.
	//
	// For more information, see Specifying Item Attributes (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
	// in the Amazon DynamoDB Developer Guide.
	ProjectionExpression *string `type:"string"`

	// Determines the level of detail about provisioned throughput consumption that
	// is returned in the response:
	//
	//    * INDEXES - The response includes the aggregate ConsumedCapacity for the
	//    operation, together with ConsumedCapacity for each table and secondary
	//    index that was accessed. Note that some operations, such as GetItem and
	//    BatchGetItem, do not access any indexes at all. In these cases, specifying
	//    INDEXES will only return ConsumedCapacity information for table(s).
	//
	//    * TOTAL - The response includes only the aggregate ConsumedCapacity for
	//    the operation.
	//
	//    * NONE - No ConsumedCapacity details are included in the response.
	ReturnConsumedCapacity *string `type:"string" enum:"ReturnConsumedCapacity"`

	// This is a legacy parameter. Use FilterExpression instead. For more information,
	// see ScanFilter (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ScanFilter.html)
	// in the Amazon DynamoDB Developer Guide.
	ScanFilter map[string]*Condition `type:"map"`

	// For a parallel Scan request, Segment identifies an individual segment to
	// be scanned by an application worker.
	//
	// Segment IDs are zero-based, so the first segment is always 0. For example,
	// if you want to use four application threads to scan a table or an index,
	// then the first thread specifies a Segment value of 0, the second thread specifies
	// 1, and so on.
	//
	// The value of LastEvaluatedKey returned from a parallel Scan request must
	// be used as ExclusiveStartKey with the same segment ID in a subsequent Scan
	// operation.
	//
	// The value for Segment must be greater than or equal to 0, and less than the
	// value provided for TotalSegments.
	//
	// If you provide Segment, you must also provide TotalSegments.
	Segment *int64 `type:"integer"`

	// The attributes to be returned in the result. You can retrieve all item attributes,
	// specific item attributes, the count of matching items, or in the case of
	// an index, some or all of the attributes projected into the index.
	//
	//    * ALL_ATTRIBUTES - Returns all of the item attributes from the specified
	//    table or index. If you query a local secondary index, then for each matching
	//    item in the index, DynamoDB fetches the entire item from the parent table.
	//    If the index is configured to project all item attributes, then all of
	//    the data can be obtained from the local secondary index, and no fetching
	//    is required.
	//
	//    * ALL_PROJECTED_ATTRIBUTES - Allowed only when querying an index. Retrieves
	//    all attributes that have been projected into the index. If the index is
	//    configured to project all attributes, this return value is equivalent
	//    to specifying ALL_ATTRIBUTES.
	//
	//    * COUNT - Returns the number of matching items, rather than the matching
	//    items themselves.
	//
	//    * SPECIFIC_ATTRIBUTES - Returns only the attributes listed in AttributesToGet.
	//    This return value is equivalent to specifying AttributesToGet without
	//    specifying any value for Select. If you query or scan a local secondary
	//    index and request only attributes that are projected into that index,
	//    the operation reads only the index and not the table. If any of the requested
	//    attributes are not projected into the local secondary index, DynamoDB
	//    fetches each of these attributes from the parent table. This extra fetching
	//    incurs additional throughput cost and latency. If you query or scan a
	//    global secondary index, you can only request attributes that are projected
	//    into the index. Global secondary index queries cannot fetch attributes
	//    from the parent table.
	//
	// If neither Select nor AttributesToGet are specified, DynamoDB defaults to
	// ALL_ATTRIBUTES when accessing a table, and ALL_PROJECTED_ATTRIBUTES when
	// accessing an index. You cannot use both Select and AttributesToGet together
	// in a single request, unless the value for Select is SPECIFIC_ATTRIBUTES.
	// (This usage is equivalent to specifying AttributesToGet without any value
	// for Select.)
	//
	// If you use the ProjectionExpression parameter, then the value for Select
	// can only be SPECIFIC_ATTRIBUTES. Any other value for Select will return an
	// error.
	Select *string `type:"string" enum:"Select"`

	// The name of the table containing the requested items; or, if you provide
	// IndexName, the name of the table to which that index belongs.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`

	// For a parallel Scan request, TotalSegments represents the total number of
	// segments into which the Scan operation will be divided. The value of TotalSegments
	// corresponds to the number of application workers that will perform the parallel
	// scan. For example, if you want to use four application threads to scan a
	// table or an index, specify a TotalSegments value of 4.
	//
	// The value for TotalSegments must be greater than or equal to 1, and less
	// than or equal to 1000000. If you specify a TotalSegments value of 1, the
	// Scan operation will be sequential rather than parallel.
	//
	// If you specify TotalSegments, you must also specify Segment.
	TotalSegments *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s ScanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScanInput"}
	if s.AttributesToGet != nil && len(s.AttributesToGet) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributesToGet", 1))
	}
	if s.IndexName != nil && len(*s.IndexName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 3))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}
	if s.TotalSegments != nil && *s.TotalSegments < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TotalSegments", 1))
	}
	if s.ScanFilter != nil {
		for i, v := range s.ScanFilter {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ScanFilter", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributesToGet sets the AttributesToGet field's value.
func (s *ScanInput) SetAttributesToGet(v []*string) *ScanInput {
	s.AttributesToGet = v
	return s
}

// SetConditionalOperator sets the ConditionalOperator field's value.
func (s *ScanInput) SetConditionalOperator(v string) *ScanInput {
	s.ConditionalOperator = &v
	return s
}

// SetConsistentRead sets the ConsistentRead field's value.
func (s *ScanInput) SetConsistentRead(v bool) *ScanInput {
	s.ConsistentRead = &v
	return s
}

// SetExclusiveStartKey sets the ExclusiveStartKey field's value.
func (s *ScanInput) SetExclusiveStartKey(v map[string]*AttributeValue) *ScanInput {
	s.ExclusiveStartKey = v
	return s
}

// SetExpressionAttributeNames sets the ExpressionAttributeNames field's value.
func (s *ScanInput) SetExpressionAttributeNames(v map[string]*string) *ScanInput {
	s.ExpressionAttributeNames = v
	return s
}

// SetExpressionAttributeValues sets the ExpressionAttributeValues field's value.
func (s *ScanInput) SetExpressionAttributeValues(v map[string]*AttributeValue) *ScanInput {
	s.ExpressionAttributeValues = v
	return s
}

// SetFilterExpression sets the FilterExpression field's value.
func (s *ScanInput) SetFilterExpression(v string) *ScanInput {
	s.FilterExpression = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *ScanInput) SetIndexName(v string) *ScanInput {
	s.IndexName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ScanInput) SetLimit(v int64) *ScanInput {
	s.Limit = &v
	return s
}

// SetProjectionExpression sets the ProjectionExpression field's value.
func (s *ScanInput) SetProjectionExpression(v string) *ScanInput {
	s.ProjectionExpression = &v
	return s
}

// SetReturnConsumedCapacity sets the ReturnConsumedCapacity field's value.
func (s *ScanInput) SetReturnConsumedCapacity(v string) *ScanInput {
	s.ReturnConsumedCapacity = &v
	return s
}

// SetScanFilter sets the ScanFilter field's value.
func (s *ScanInput) SetScanFilter(v map[string]*Condition) *ScanInput {
	s.ScanFilter = v
	return s
}

// SetSegment sets the Segment field's value.
func (s *ScanInput) SetSegment(v int64) *ScanInput {
	s.Segment = &v
	return s
}

// SetSelect sets the Select field's value.
func (s *ScanInput) SetSelect(v string) *ScanInput {
	s.Select = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *ScanInput) SetTableName(v string) *ScanInput {
	s.TableName = &v
	return s
}

// SetTotalSegments sets the TotalSegments field's value.
func (s *ScanInput) SetTotalSegments(v int64) *ScanInput {
	s.TotalSegments = &v
	return s
}

// Represents the output of a Scan operation.
type ScanOutput struct {
	_ struct{} `type:"structure"`

	// The capacity units consumed by the Scan operation. The data returned includes
	// the total provisioned throughput consumed, along with statistics for the
	// table and any indexes involved in the operation. ConsumedCapacity is only
	// returned if the ReturnConsumedCapacity parameter was specified. For more
	// information, see Provisioned Throughput (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html)
	// in the Amazon DynamoDB Developer Guide.
	ConsumedCapacity *ConsumedCapacity `type:"structure"`

	// The number of items in the response.
	//
	// If you set ScanFilter in the request, then Count is the number of items returned
	// after the filter was applied, and ScannedCount is the number of matching
	// items before the filter was applied.
	//
	// If you did not use a filter in the request, then Count is the same as ScannedCount.
	Count *int64 `type:"integer"`

	// An array of item attributes that match the scan criteria. Each element in
	// this array consists of an attribute name and the value for that attribute.
	Items []map[string]*AttributeValue `type:"list"`

	// The primary key of the item where the operation stopped, inclusive of the
	// previous result set. Use this value to start a new operation, excluding this
	// value in the new request.
	//
	// If LastEvaluatedKey is empty, then the "last page" of results has been processed
	// and there is no more data to be retrieved.
	//
	// If LastEvaluatedKey is not empty, it does not necessarily mean that there
	// is more data in the result set. The only way to know when you have reached
	// the end of the result set is when LastEvaluatedKey is empty.
	LastEvaluatedKey map[string]*AttributeValue `type:"map"`

	// The number of items evaluated, before any ScanFilter is applied. A high ScannedCount
	// value with few, or no, Count results indicates an inefficient Scan operation.
	// For more information, see Count and ScannedCount (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#Count)
	// in the Amazon DynamoDB Developer Guide.
	//
	// If you did not use a filter in the request, then ScannedCount is the same
	// as Count.
	ScannedCount *int64 `type:"integer"`
}

// String returns the string representation
func (s ScanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScanOutput) GoString() string {
	return s.String()
}

// SetConsumedCapacity sets the ConsumedCapacity field's value.
func (s *ScanOutput) SetConsumedCapacity(v *ConsumedCapacity) *ScanOutput {
	s.ConsumedCapacity = v
	return s
}

// SetCount sets the Count field's value.
func (s *ScanOutput) SetCount(v int64) *ScanOutput {
	s.Count = &v
	return s
}

// SetItems sets the Items field's value.
func (s *ScanOutput) SetItems(v []map[string]*AttributeValue) *ScanOutput {
	s.Items = v
	return s
}

// SetLastEvaluatedKey sets the LastEvaluatedKey field's value.
func (s *ScanOutput) SetLastEvaluatedKey(v map[string]*AttributeValue) *ScanOutput {
	s.LastEvaluatedKey = v
	return s
}

// SetScannedCount sets the ScannedCount field's value.
func (s *ScanOutput) SetScannedCount(v int64) *ScanOutput {
	s.ScannedCount = &v
	return s
}

// Contains the details of the table when the backup was created.
type SourceTableDetails struct {
	_ struct{} `type:"structure"`

	// Controls how you are charged for read and write throughput and how you manage
	// capacity. This setting can be changed later.
	//
	//    * PROVISIONED - Sets the read/write capacity mode to PROVISIONED. We recommend
	//    using PROVISIONED for predictable workloads.
	//
	//    * PAY_PER_REQUEST - Sets the read/write capacity mode to PAY_PER_REQUEST.
	//    We recommend using PAY_PER_REQUEST for unpredictable workloads.
	BillingMode *string `type:"string" enum:"BillingMode"`

	// Number of items in the table. Note that this is an approximate value.
	ItemCount *int64 `type:"long"`

	// Schema of the table.
	//
	// KeySchema is a required field
	KeySchema []*KeySchemaElement `min:"1" type:"list" required:"true"`

	// Read IOPs and Write IOPS on the table when the backup was created.
	//
	// ProvisionedThroughput is a required field
	ProvisionedThroughput *ProvisionedThroughput `type:"structure" required:"true"`

	// ARN of the table for which backup was created.
	TableArn *string `type:"string"`

	// Time when the source table was created.
	//
	// TableCreationDateTime is a required field
	TableCreationDateTime *time.Time `type:"timestamp" required:"true"`

	// Unique identifier for the table for which the backup was created.
	//
	// TableId is a required field
	TableId *string `type:"string" required:"true"`

	// The name of the table for which the backup was created.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`

	// Size of the table in bytes. Note that this is an approximate value.
	TableSizeBytes *int64 `type:"long"`
}

// String returns the string representation
func (s SourceTableDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceTableDetails) GoString() string {
	return s.String()
}

// SetBillingMode sets the BillingMode field's value.
func (s *SourceTableDetails) SetBillingMode(v string) *SourceTableDetails {
	s.BillingMode = &v
	return s
}

// SetItemCount sets the ItemCount field's value.
func (s *SourceTableDetails) SetItemCount(v int64) *SourceTableDetails {
	s.ItemCount = &v
	return s
}

// SetKeySchema sets the KeySchema field's value.
func (s *SourceTableDetails) SetKeySchema(v []*KeySchemaElement) *SourceTableDetails {
	s.KeySchema = v
	return s
}

// SetProvisionedThroughput sets the ProvisionedThroughput field's value.
func (s *SourceTableDetails) SetProvisionedThroughput(v *ProvisionedThroughput) *SourceTableDetails {
	s.ProvisionedThroughput = v
	return s
}

// SetTableArn sets the TableArn field's value.
func (s *SourceTableDetails) SetTableArn(v string) *SourceTableDetails {
	s.TableArn = &v
	return s
}

// SetTableCreationDateTime sets the TableCreationDateTime field's value.
func (s *SourceTableDetails) SetTableCreationDateTime(v time.Time) *SourceTableDetails {
	s.TableCreationDateTime = &v
	return s
}

// SetTableId sets the TableId field's value.
func (s *SourceTableDetails) SetTableId(v string) *SourceTableDetails {
	s.TableId = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *SourceTableDetails) SetTableName(v string) *SourceTableDetails {
	s.TableName = &v
	return s
}

// SetTableSizeBytes sets the TableSizeBytes field's value.
func (s *SourceTableDetails) SetTableSizeBytes(v int64) *SourceTableDetails {
	s.TableSizeBytes = &v
	return s
}

// Contains the details of the features enabled on the table when the backup
// was created. For example, LSIs, GSIs, streams, TTL.
type SourceTableFeatureDetails struct {
	_ struct{} `type:"structure"`

	// Represents the GSI properties for the table when the backup was created.
	// It includes the IndexName, KeySchema, Projection, and ProvisionedThroughput
	// for the GSIs on the table at the time of backup.
	GlobalSecondaryIndexes []*GlobalSecondaryIndexInfo `type:"list"`

	// Represents the LSI properties for the table when the backup was created.
	// It includes the IndexName, KeySchema and Projection for the LSIs on the table
	// at the time of backup.
	LocalSecondaryIndexes []*LocalSecondaryIndexInfo `type:"list"`

	// The description of the server-side encryption status on the table when the
	// backup was created.
	SSEDescription *SSEDescription `type:"structure"`

	// Stream settings on the table when the backup was created.
	StreamDescription *StreamSpecification `type:"structure"`

	// Time to Live settings on the table when the backup was created.
	TimeToLiveDescription *TimeToLiveDescription `type:"structure"`
}

// String returns the string representation
func (s SourceTableFeatureDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceTableFeatureDetails) GoString() string {
	return s.String()
}

// SetGlobalSecondaryIndexes sets the GlobalSecondaryIndexes field's value.
func (s *SourceTableFeatureDetails) SetGlobalSecondaryIndexes(v []*GlobalSecondaryIndexInfo) *SourceTableFeatureDetails {
	s.GlobalSecondaryIndexes = v
	return s
}

// SetLocalSecondaryIndexes sets the LocalSecondaryIndexes field's value.
func (s *SourceTableFeatureDetails) SetLocalSecondaryIndexes(v []*LocalSecondaryIndexInfo) *SourceTableFeatureDetails {
	s.LocalSecondaryIndexes = v
	return s
}

// SetSSEDescription sets the SSEDescription field's value.
func (s *SourceTableFeatureDetails) SetSSEDescription(v *SSEDescription) *SourceTableFeatureDetails {
	s.SSEDescription = v
	return s
}

// SetStreamDescription sets the StreamDescription field's value.
func (s *SourceTableFeatureDetails) SetStreamDescription(v *StreamSpecification) *SourceTableFeatureDetails {
	s.StreamDescription = v
	return s
}

// SetTimeToLiveDescription sets the TimeToLiveDescription field's value.
func (s *SourceTableFeatureDetails) SetTimeToLiveDescription(v *TimeToLiveDescription) *SourceTableFeatureDetails {
	s.TimeToLiveDescription = v
	return s
}

// Represents the DynamoDB Streams configuration for a table in DynamoDB.
type StreamSpecification struct {
	_ struct{} `type:"structure"`

	// Indicates whether DynamoDB Streams is enabled (true) or disabled (false)
	// on the table.
	//
	// StreamEnabled is a required field
	StreamEnabled *bool `type:"boolean" required:"true"`

	// When an item in the table is modified, StreamViewType determines what information
	// is written to the stream for this table. Valid values for StreamViewType
	// are:
	//
	//    * KEYS_ONLY - Only the key attributes of the modified item are written
	//    to the stream.
	//
	//    * NEW_IMAGE - The entire item, as it appears after it was modified, is
	//    written to the stream.
	//
	//    * OLD_IMAGE - The entire item, as it appeared before it was modified,
	//    is written to the stream.
	//
	//    * NEW_AND_OLD_IMAGES - Both the new and the old item images of the item
	//    are written to the stream.
	StreamViewType *string `type:"string" enum:"StreamViewType"`
}

// String returns the string representation
func (s StreamSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StreamSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StreamSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StreamSpecification"}
	if s.StreamEnabled == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamEnabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStreamEnabled sets the StreamEnabled field's value.
func (s *StreamSpecification) SetStreamEnabled(v bool) *StreamSpecification {
	s.StreamEnabled = &v
	return s
}

// SetStreamViewType sets the StreamViewType field's value.
func (s *StreamSpecification) SetStreamViewType(v string) *StreamSpecification {
	s.StreamViewType = &v
	return s
}

// Represents the auto scaling configuration for a global table.
type TableAutoScalingDescription struct {
	_ struct{} `type:"structure"`

	// Represents replicas of the global table.
	Replicas []*ReplicaAutoScalingDescription `type:"list"`

	// The name of the table.
	TableName *string `min:"3" type:"string"`

	// The current state of the table:
	//
	//    * CREATING - The table is being created.
	//
	//    * UPDATING - The table is being updated.
	//
	//    * DELETING - The table is being deleted.
	//
	//    * ACTIVE - The table is ready for use.
	TableStatus *string `type:"string" enum:"TableStatus"`
}

// String returns the string representation
func (s TableAutoScalingDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TableAutoScalingDescription) GoString() string {
	return s.String()
}

// SetReplicas sets the Replicas field's value.
func (s *TableAutoScalingDescription) SetReplicas(v []*ReplicaAutoScalingDescription) *TableAutoScalingDescription {
	s.Replicas = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *TableAutoScalingDescription) SetTableName(v string) *TableAutoScalingDescription {
	s.TableName = &v
	return s
}

// SetTableStatus sets the TableStatus field's value.
func (s *TableAutoScalingDescription) SetTableStatus(v string) *TableAutoScalingDescription {
	s.TableStatus = &v
	return s
}

// Represents the properties of a table.
type TableDescription struct {
	_ struct{} `type:"structure"`

	// Contains information about the table archive.
	ArchivalSummary *ArchivalSummary `type:"structure"`

	// An array of AttributeDefinition objects. Each of these objects describes
	// one attribute in the table and index key schema.
	//
	// Each AttributeDefinition object in this array is composed of:
	//
	//    * AttributeName - The name of the attribute.
	//
	//    * AttributeType - The data type for the attribute.
	AttributeDefinitions []*AttributeDefinition `type:"list"`

	// Contains the details for the read/write capacity mode.
	BillingModeSummary *BillingModeSummary `type:"structure"`

	// The date and time when the table was created, in UNIX epoch time (http://www.epochconverter.com/)
	// format.
	CreationDateTime *time.Time `type:"timestamp"`

	// The global secondary indexes, if any, on the table. Each index is scoped
	// to a given partition key value. Each element is composed of:
	//
	//    * Backfilling - If true, then the index is currently in the backfilling
	//    phase. Backfilling occurs only when a new global secondary index is added
	//    to the table. It is the process by which DynamoDB populates the new index
	//    with data from the table. (This attribute does not appear for indexes
	//    that were created during a CreateTable operation.) You can delete an index
	//    that is being created during the Backfilling phase when IndexStatus is
	//    set to CREATING and Backfilling is true. You can't delete the index that
	//    is being created when IndexStatus is set to CREATING and Backfilling is
	//    false. (This attribute does not appear for indexes that were created during
	//    a CreateTable operation.)
	//
	//    * IndexName - The name of the global secondary index.
	//
	//    * IndexSizeBytes - The total size of the global secondary index, in bytes.
	//    DynamoDB updates this value approximately every six hours. Recent changes
	//    might not be reflected in this value.
	//
	//    * IndexStatus - The current status of the global secondary index: CREATING
	//    - The index is being created. UPDATING - The index is being updated. DELETING
	//    - The index is being deleted. ACTIVE - The index is ready for use.
	//
	//    * ItemCount - The number of items in the global secondary index. DynamoDB
	//    updates this value approximately every six hours. Recent changes might
	//    not be reflected in this value.
	//
	//    * KeySchema - Specifies the complete index key schema. The attribute names
	//    in the key schema must be between 1 and 255 characters (inclusive). The
	//    key schema must begin with the same partition key as the table.
	//
	//    * Projection - Specifies attributes that are copied (projected) from the
	//    table into the index. These are in addition to the primary key attributes
	//    and index key attributes, which are automatically projected. Each attribute
	//    specification is composed of: ProjectionType - One of the following: KEYS_ONLY
	//    - Only the index and primary keys are projected into the index. INCLUDE
	//    - Only the specified table attributes are projected into the index. The
	//    list of projected attributes is in NonKeyAttributes. ALL - All of the
	//    table attributes are projected into the index. NonKeyAttributes - A list
	//    of one or more non-key attribute names that are projected into the secondary
	//    index. The total count of attributes provided in NonKeyAttributes, summed
	//    across all of the secondary indexes, must not exceed 20. If you project
	//    the same attribute into two different indexes, this counts as two distinct
	//    attributes when determining the total.
	//
	//    * ProvisionedThroughput - The provisioned throughput settings for the
	//    global secondary index, consisting of read and write capacity units, along
	//    with data about increases and decreases.
	//
	// If the table is in the DELETING state, no information about indexes will
	// be returned.
	GlobalSecondaryIndexes []*GlobalSecondaryIndexDescription `type:"list"`

	// Represents the version of global tables (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html)
	// in use, if the table is replicated across AWS Regions.
	GlobalTableVersion *string `type:"string"`

	// The number of items in the specified table. DynamoDB updates this value approximately
	// every six hours. Recent changes might not be reflected in this value.
	ItemCount *int64 `type:"long"`

	// The primary key structure for the table. Each KeySchemaElement consists of:
	//
	//    * AttributeName - The name of the attribute.
	//
	//    * KeyType - The role of the attribute: HASH - partition key RANGE - sort
	//    key The partition key of an item is also known as its hash attribute.
	//    The term "hash attribute" derives from DynamoDB's usage of an internal
	//    hash function to evenly distribute data items across partitions, based
	//    on their partition key values. The sort key of an item is also known as
	//    its range attribute. The term "range attribute" derives from the way DynamoDB
	//    stores items with the same partition key physically close together, in
	//    sorted order by the sort key value.
	//
	// For more information about primary keys, see Primary Key (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModelPrimaryKey)
	// in the Amazon DynamoDB Developer Guide.
	KeySchema []*KeySchemaElement `min:"1" type:"list"`

	// The Amazon Resource Name (ARN) that uniquely identifies the latest stream
	// for this table.
	LatestStreamArn *string `min:"37" type:"string"`

	// A timestamp, in ISO 8601 format, for this stream.
	//
	// Note that LatestStreamLabel is not a unique identifier for the stream, because
	// it is possible that a stream from another table might have the same timestamp.
	// However, the combination of the following three elements is guaranteed to
	// be unique:
	//
	//    * AWS customer ID
	//
	//    * Table name
	//
	//    * StreamLabel
	LatestStreamLabel *string `type:"string"`

	// Represents one or more local secondary indexes on the table. Each index is
	// scoped to a given partition key value. Tables with one or more local secondary
	// indexes are subject to an item collection size limit, where the amount of
	// data within a given item collection cannot exceed 10 GB. Each element is
	// composed of:
	//
	//    * IndexName - The name of the local secondary index.
	//
	//    * KeySchema - Specifies the complete index key schema. The attribute names
	//    in the key schema must be between 1 and 255 characters (inclusive). The
	//    key schema must begin with the same partition key as the table.
	//
	//    * Projection - Specifies attributes that are copied (projected) from the
	//    table into the index. These are in addition to the primary key attributes
	//    and index key attributes, which are automatically projected. Each attribute
	//    specification is composed of: ProjectionType - One of the following: KEYS_ONLY
	//    - Only the index and primary keys are projected into the index. INCLUDE
	//    - Only the specified table attributes are projected into the index. The
	//    list of projected attributes is in NonKeyAttributes. ALL - All of the
	//    table attributes are projected into the index. NonKeyAttributes - A list
	//    of one or more non-key attribute names that are projected into the secondary
	//    index. The total count of attributes provided in NonKeyAttributes, summed
	//    across all of the secondary indexes, must not exceed 20. If you project
	//    the same attribute into two different indexes, this counts as two distinct
	//    attributes when determining the total.
	//
	//    * IndexSizeBytes - Represents the total size of the index, in bytes. DynamoDB
	//    updates this value approximately every six hours. Recent changes might
	//    not be reflected in this value.
	//
	//    * ItemCount - Represents the number of items in the index. DynamoDB updates
	//    this value approximately every six hours. Recent changes might not be
	//    reflected in this value.
	//
	// If the table is in the DELETING state, no information about indexes will
	// be returned.
	LocalSecondaryIndexes []*LocalSecondaryIndexDescription `type:"list"`

	// The provisioned throughput settings for the table, consisting of read and
	// write capacity units, along with data about increases and decreases.
	ProvisionedThroughput *ProvisionedThroughputDescription `type:"structure"`

	// Represents replicas of the table.
	Replicas []*ReplicaDescription `type:"list"`

	// Contains details for the restore.
	RestoreSummary *RestoreSummary `type:"structure"`

	// The description of the server-side encryption status on the specified table.
	SSEDescription *SSEDescription `type:"structure"`

	// The current DynamoDB Streams configuration for the table.
	StreamSpecification *StreamSpecification `type:"structure"`

	// The Amazon Resource Name (ARN) that uniquely identifies the table.
	TableArn *string `type:"string"`

	// Unique identifier for the table for which the backup was created.
	TableId *string `type:"string"`

	// The name of the table.
	TableName *string `min:"3" type:"string"`

	// The total size of the specified table, in bytes. DynamoDB updates this value
	// approximately every six hours. Recent changes might not be reflected in this
	// value.
	TableSizeBytes *int64 `type:"long"`

	// The current state of the table:
	//
	//    * CREATING - The table is being created.
	//
	//    * UPDATING - The table is being updated.
	//
	//    * DELETING - The table is being deleted.
	//
	//    * ACTIVE - The table is ready for use.
	//
	//    * INACCESSIBLE_ENCRYPTION_CREDENTIALS - The AWS KMS key used to encrypt
	//    the table in inaccessible. Table operations may fail due to failure to
	//    use the AWS KMS key. DynamoDB will initiate the table archival process
	//    when a table's AWS KMS key remains inaccessible for more than seven days.
	//
	//    * ARCHIVING - The table is being archived. Operations are not allowed
	//    until archival is complete.
	//
	//    * ARCHIVED - The table has been archived. See the ArchivalReason for more
	//    information.
	TableStatus *string `type:"string" enum:"TableStatus"`
}

// String returns the string representation
func (s TableDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TableDescription) GoString() string {
	return s.String()
}

// SetArchivalSummary sets the ArchivalSummary field's value.
func (s *TableDescription) SetArchivalSummary(v *ArchivalSummary) *TableDescription {
	s.ArchivalSummary = v
	return s
}

// SetAttributeDefinitions sets the AttributeDefinitions field's value.
func (s *TableDescription) SetAttributeDefinitions(v []*AttributeDefinition) *TableDescription {
	s.AttributeDefinitions = v
	return s
}

// SetBillingModeSummary sets the BillingModeSummary field's value.
func (s *TableDescription) SetBillingModeSummary(v *BillingModeSummary) *TableDescription {
	s.BillingModeSummary = v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *TableDescription) SetCreationDateTime(v time.Time) *TableDescription {
	s.CreationDateTime = &v
	return s
}

// SetGlobalSecondaryIndexes sets the GlobalSecondaryIndexes field's value.
func (s *TableDescription) SetGlobalSecondaryIndexes(v []*GlobalSecondaryIndexDescription) *TableDescription {
	s.GlobalSecondaryIndexes = v
	return s
}

// SetGlobalTableVersion sets the GlobalTableVersion field's value.
func (s *TableDescription) SetGlobalTableVersion(v string) *TableDescription {
	s.GlobalTableVersion = &v
	return s
}

// SetItemCount sets the ItemCount field's value.
func (s *TableDescription) SetItemCount(v int64) *TableDescription {
	s.ItemCount = &v
	return s
}

// SetKeySchema sets the KeySchema field's value.
func (s *TableDescription) SetKeySchema(v []*KeySchemaElement) *TableDescription {
	s.KeySchema = v
	return s
}

// SetLatestStreamArn sets the LatestStreamArn field's value.
func (s *TableDescription) SetLatestStreamArn(v string) *TableDescription {
	s.LatestStreamArn = &v
	return s
}

// SetLatestStreamLabel sets the LatestStreamLabel field's value.
func (s *TableDescription) SetLatestStreamLabel(v string) *TableDescription {
	s.LatestStreamLabel = &v
	return s
}

// SetLocalSecondaryIndexes sets the LocalSecondaryIndexes field's value.
func (s *TableDescription) SetLocalSecondaryIndexes(v []*LocalSecondaryIndexDescription) *TableDescription {
	s.LocalSecondaryIndexes = v
	return s
}

// SetProvisionedThroughput sets the ProvisionedThroughput field's value.
func (s *TableDescription) SetProvisionedThroughput(v *ProvisionedThroughputDescription) *TableDescription {
	s.ProvisionedThroughput = v
	return s
}

// SetReplicas sets the Replicas field's value.
func (s *TableDescription) SetReplicas(v []*ReplicaDescription) *TableDescription {
	s.Replicas = v
	return s
}

// SetRestoreSummary sets the RestoreSummary field's value.
func (s *TableDescription) SetRestoreSummary(v *RestoreSummary) *TableDescription {
	s.RestoreSummary = v
	return s
}

// SetSSEDescription sets the SSEDescription field's value.
func (s *TableDescription) SetSSEDescription(v *SSEDescription) *TableDescription {
	s.SSEDescription = v
	return s
}

// SetStreamSpecification sets the StreamSpecification field's value.
func (s *TableDescription) SetStreamSpecification(v *StreamSpecification) *TableDescription {
	s.StreamSpecification = v
	return s
}

// SetTableArn sets the TableArn field's value.
func (s *TableDescription) SetTableArn(v string) *TableDescription {
	s.TableArn = &v
	return s
}

// SetTableId sets the TableId field's value.
func (s *TableDescription) SetTableId(v string) *TableDescription {
	s.TableId = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *TableDescription) SetTableName(v string) *TableDescription {
	s.TableName = &v
	return s
}

// SetTableSizeBytes sets the TableSizeBytes field's value.
func (s *TableDescription) SetTableSizeBytes(v int64) *TableDescription {
	s.TableSizeBytes = &v
	return s
}

// SetTableStatus sets the TableStatus field's value.
func (s *TableDescription) SetTableStatus(v string) *TableDescription {
	s.TableStatus = &v
	return s
}

// Describes a tag. A tag is a key-value pair. You can add up to 50 tags to
// a single DynamoDB table.
//
// AWS-assigned tag names and values are automatically assigned the aws: prefix,
// which the user cannot assign. AWS-assigned tag names do not count towards
// the tag limit of 50. User-assigned tag names have the prefix user: in the
// Cost Allocation Report. You cannot backdate the application of a tag.
//
// For an overview on tagging DynamoDB resources, see Tagging for DynamoDB (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html)
// in the Amazon DynamoDB Developer Guide.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag. Tag keys are case sensitive. Each DynamoDB table can
	// only have up to one tag with the same key. If you try to add an existing
	// tag (same key), the existing tag value will be updated to the new value.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag. Tag values are case-sensitive and can be null.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// Identifies the Amazon DynamoDB resource to which tags should be added. This
	// value is an Amazon Resource Name (ARN).
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// The tags to be assigned to the Amazon DynamoDB resource.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The description of the Time to Live (TTL) status on the specified table.
type TimeToLiveDescription struct {
	_ struct{} `type:"structure"`

	// The name of the TTL attribute for items in the table.
	AttributeName *string `min:"1" type:"string"`

	// The TTL status for the table.
	TimeToLiveStatus *string `type:"string" enum:"TimeToLiveStatus"`
}

// String returns the string representation
func (s TimeToLiveDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeToLiveDescription) GoString() string {
	return s.String()
}

// SetAttributeName sets the AttributeName field's value.
func (s *TimeToLiveDescription) SetAttributeName(v string) *TimeToLiveDescription {
	s.AttributeName = &v
	return s
}

// SetTimeToLiveStatus sets the TimeToLiveStatus field's value.
func (s *TimeToLiveDescription) SetTimeToLiveStatus(v string) *TimeToLiveDescription {
	s.TimeToLiveStatus = &v
	return s
}

// Represents the settings used to enable or disable Time to Live (TTL) for
// the specified table.
type TimeToLiveSpecification struct {
	_ struct{} `type:"structure"`

	// The name of the TTL attribute used to store the expiration time for items
	// in the table.
	//
	// AttributeName is a required field
	AttributeName *string `min:"1" type:"string" required:"true"`

	// Indicates whether TTL is to be enabled (true) or disabled (false) on the
	// table.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s TimeToLiveSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeToLiveSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimeToLiveSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TimeToLiveSpecification"}
	if s.AttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeName"))
	}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributeName", 1))
	}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeName sets the AttributeName field's value.
func (s *TimeToLiveSpecification) SetAttributeName(v string) *TimeToLiveSpecification {
	s.AttributeName = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *TimeToLiveSpecification) SetEnabled(v bool) *TimeToLiveSpecification {
	s.Enabled = &v
	return s
}

// Specifies an item to be retrieved as part of the transaction.
type TransactGetItem struct {
	_ struct{} `type:"structure"`

	// Contains the primary key that identifies the item to get, together with the
	// name of the table that contains the item, and optionally the specific attributes
	// of the item to retrieve.
	//
	// Get is a required field
	Get *Get `type:"structure" required:"true"`
}

// String returns the string representation
func (s TransactGetItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TransactGetItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransactGetItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TransactGetItem"}
	if s.Get == nil {
		invalidParams.Add(request.NewErrParamRequired("Get"))
	}
	if s.Get != nil {
		if err := s.Get.Validate(); err != nil {
			invalidParams.AddNested("Get", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGet sets the Get field's value.
func (s *TransactGetItem) SetGet(v *Get) *TransactGetItem {
	s.Get = v
	return s
}

type TransactGetItemsInput struct {
	_ struct{} `type:"structure"`

	// A value of TOTAL causes consumed capacity information to be returned, and
	// a value of NONE prevents that information from being returned. No other value
	// is valid.
	ReturnConsumedCapacity *string `type:"string" enum:"ReturnConsumedCapacity"`

	// An ordered array of up to 25 TransactGetItem objects, each of which contains
	// a Get structure.
	//
	// TransactItems is a required field
	TransactItems []*TransactGetItem `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TransactGetItemsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TransactGetItemsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransactGetItemsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TransactGetItemsInput"}
	if s.TransactItems == nil {
		invalidParams.Add(request.NewErrParamRequired("TransactItems"))
	}
	if s.TransactItems != nil && len(s.TransactItems) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TransactItems", 1))
	}
	if s.TransactItems != nil {
		for i, v := range s.TransactItems {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TransactItems", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReturnConsumedCapacity sets the ReturnConsumedCapacity field's value.
func (s *TransactGetItemsInput) SetReturnConsumedCapacity(v string) *TransactGetItemsInput {
	s.ReturnConsumedCapacity = &v
	return s
}

// SetTransactItems sets the TransactItems field's value.
func (s *TransactGetItemsInput) SetTransactItems(v []*TransactGetItem) *TransactGetItemsInput {
	s.TransactItems = v
	return s
}

type TransactGetItemsOutput struct {
	_ struct{} `type:"structure"`

	// If the ReturnConsumedCapacity value was TOTAL, this is an array of ConsumedCapacity
	// objects, one for each table addressed by TransactGetItem objects in the TransactItems
	// parameter. These ConsumedCapacity objects report the read-capacity units
	// consumed by the TransactGetItems call in that table.
	ConsumedCapacity []*ConsumedCapacity `type:"list"`

	// An ordered array of up to 25 ItemResponse objects, each of which corresponds
	// to the TransactGetItem object in the same position in the TransactItems array.
	// Each ItemResponse object contains a Map of the name-value pairs that are
	// the projected attributes of the requested item.
	//
	// If a requested item could not be retrieved, the corresponding ItemResponse
	// object is Null, or if the requested item has no projected attributes, the
	// corresponding ItemResponse object is an empty Map.
	Responses []*ItemResponse `min:"1" type:"list"`
}

// String returns the string representation
func (s TransactGetItemsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TransactGetItemsOutput) GoString() string {
	return s.String()
}

// SetConsumedCapacity sets the ConsumedCapacity field's value.
func (s *TransactGetItemsOutput) SetConsumedCapacity(v []*ConsumedCapacity) *TransactGetItemsOutput {
	s.ConsumedCapacity = v
	return s
}

// SetResponses sets the Responses field's value.
func (s *TransactGetItemsOutput) SetResponses(v []*ItemResponse) *TransactGetItemsOutput {
	s.Responses = v
	return s
}

// A list of requests that can perform update, put, delete, or check operations
// on multiple items in one or more tables atomically.
type TransactWriteItem struct {
	_ struct{} `type:"structure"`

	// A request to perform a check item operation.
	ConditionCheck *ConditionCheck `type:"structure"`

	// A request to perform a DeleteItem operation.
	Delete *Delete `type:"structure"`

	// A request to perform a PutItem operation.
	Put *Put `type:"structure"`

	// A request to perform an UpdateItem operation.
	Update *Update `type:"structure"`
}

// String returns the string representation
func (s TransactWriteItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TransactWriteItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransactWriteItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TransactWriteItem"}
	if s.ConditionCheck != nil {
		if err := s.ConditionCheck.Validate(); err != nil {
			invalidParams.AddNested("ConditionCheck", err.(request.ErrInvalidParams))
		}
	}
	if s.Delete != nil {
		if err := s.Delete.Validate(); err != nil {
			invalidParams.AddNested("Delete", err.(request.ErrInvalidParams))
		}
	}
	if s.Put != nil {
		if err := s.Put.Validate(); err != nil {
			invalidParams.AddNested("Put", err.(request.ErrInvalidParams))
		}
	}
	if s.Update != nil {
		if err := s.Update.Validate(); err != nil {
			invalidParams.AddNested("Update", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConditionCheck sets the ConditionCheck field's value.
func (s *TransactWriteItem) SetConditionCheck(v *ConditionCheck) *TransactWriteItem {
	s.ConditionCheck = v
	return s
}

// SetDelete sets the Delete field's value.
func (s *TransactWriteItem) SetDelete(v *Delete) *TransactWriteItem {
	s.Delete = v
	return s
}

// SetPut sets the Put field's value.
func (s *TransactWriteItem) SetPut(v *Put) *TransactWriteItem {
	s.Put = v
	return s
}

// SetUpdate sets the Update field's value.
func (s *TransactWriteItem) SetUpdate(v *Update) *TransactWriteItem {
	s.Update = v
	return s
}

type TransactWriteItemsInput struct {
	_ struct{} `type:"structure"`

	// Providing a ClientRequestToken makes the call to TransactWriteItems idempotent,
	// meaning that multiple identical calls have the same effect as one single
	// call.
	//
	// Although multiple identical calls using the same client request token produce
	// the same result on the server (no side effects), the responses to the calls
	// might not be the same. If the ReturnConsumedCapacity> parameter is set, then
	// the initial TransactWriteItems call returns the amount of write capacity
	// units consumed in making the changes. Subsequent TransactWriteItems calls
	// with the same client token return the number of read capacity units consumed
	// in reading the item.
	//
	// A client request token is valid for 10 minutes after the first request that
	// uses it is completed. After 10 minutes, any request with the same client
	// token is treated as a new request. Do not resubmit the same request with
	// the same client token for more than 10 minutes, or the result might not be
	// idempotent.
	//
	// If you submit a request with the same client token but a change in other
	// parameters within the 10-minute idempotency window, DynamoDB returns an IdempotentParameterMismatch
	// exception.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// Determines the level of detail about provisioned throughput consumption that
	// is returned in the response:
	//
	//    * INDEXES - The response includes the aggregate ConsumedCapacity for the
	//    operation, together with ConsumedCapacity for each table and secondary
	//    index that was accessed. Note that some operations, such as GetItem and
	//    BatchGetItem, do not access any indexes at all. In these cases, specifying
	//    INDEXES will only return ConsumedCapacity information for table(s).
	//
	//    * TOTAL - The response includes only the aggregate ConsumedCapacity for
	//    the operation.
	//
	//    * NONE - No ConsumedCapacity details are included in the response.
	ReturnConsumedCapacity *string `type:"string" enum:"ReturnConsumedCapacity"`

	// Determines whether item collection metrics are returned. If set to SIZE,
	// the response includes statistics about item collections (if any), that were
	// modified during the operation and are returned in the response. If set to
	// NONE (the default), no statistics are returned.
	ReturnItemCollectionMetrics *string `type:"string" enum:"ReturnItemCollectionMetrics"`

	// An ordered array of up to 25 TransactWriteItem objects, each of which contains
	// a ConditionCheck, Put, Update, or Delete object. These can operate on items
	// in different tables, but the tables must reside in the same AWS account and
	// Region, and no two of them can operate on the same item.
	//
	// TransactItems is a required field
	TransactItems []*TransactWriteItem `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TransactWriteItemsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TransactWriteItemsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransactWriteItemsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TransactWriteItemsInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.TransactItems == nil {
		invalidParams.Add(request.NewErrParamRequired("TransactItems"))
	}
	if s.TransactItems != nil && len(s.TransactItems) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TransactItems", 1))
	}
	if s.TransactItems != nil {
		for i, v := range s.TransactItems {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TransactItems", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *TransactWriteItemsInput) SetClientRequestToken(v string) *TransactWriteItemsInput {
	s.ClientRequestToken = &v
	return s
}

// SetReturnConsumedCapacity sets the ReturnConsumedCapacity field's value.
func (s *TransactWriteItemsInput) SetReturnConsumedCapacity(v string) *TransactWriteItemsInput {
	s.ReturnConsumedCapacity = &v
	return s
}

// SetReturnItemCollectionMetrics sets the ReturnItemCollectionMetrics field's value.
func (s *TransactWriteItemsInput) SetReturnItemCollectionMetrics(v string) *TransactWriteItemsInput {
	s.ReturnItemCollectionMetrics = &v
	return s
}

// SetTransactItems sets the TransactItems field's value.
func (s *TransactWriteItemsInput) SetTransactItems(v []*TransactWriteItem) *TransactWriteItemsInput {
	s.TransactItems = v
	return s
}

type TransactWriteItemsOutput struct {
	_ struct{} `type:"structure"`

	// The capacity units consumed by the entire TransactWriteItems operation. The
	// values of the list are ordered according to the ordering of the TransactItems
	// request parameter.
	ConsumedCapacity []*ConsumedCapacity `type:"list"`

	// A list of tables that were processed by TransactWriteItems and, for each
	// table, information about any item collections that were affected by individual
	// UpdateItem, PutItem, or DeleteItem operations.
	ItemCollectionMetrics map[string][]*ItemCollectionMetrics `type:"map"`
}

// String returns the string representation
func (s TransactWriteItemsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TransactWriteItemsOutput) GoString() string {
	return s.String()
}

// SetConsumedCapacity sets the ConsumedCapacity field's value.
func (s *TransactWriteItemsOutput) SetConsumedCapacity(v []*ConsumedCapacity) *TransactWriteItemsOutput {
	s.ConsumedCapacity = v
	return s
}

// SetItemCollectionMetrics sets the ItemCollectionMetrics field's value.
func (s *TransactWriteItemsOutput) SetItemCollectionMetrics(v map[string][]*ItemCollectionMetrics) *TransactWriteItemsOutput {
	s.ItemCollectionMetrics = v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The DynamoDB resource that the tags will be removed from. This value is an
	// Amazon Resource Name (ARN).
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// A list of tag keys. Existing tags of the resource whose keys are members
	// of this list will be removed from the DynamoDB resource.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// Represents a request to perform an UpdateItem operation.
type Update struct {
	_ struct{} `type:"structure"`

	// A condition that must be satisfied in order for a conditional update to succeed.
	ConditionExpression *string `type:"string"`

	// One or more substitution tokens for attribute names in an expression.
	ExpressionAttributeNames map[string]*string `type:"map"`

	// One or more values that can be substituted in an expression.
	ExpressionAttributeValues map[string]*AttributeValue `type:"map"`

	// The primary key of the item to be updated. Each element consists of an attribute
	// name and a value for that attribute.
	//
	// Key is a required field
	Key map[string]*AttributeValue `type:"map" required:"true"`

	// Use ReturnValuesOnConditionCheckFailure to get the item attributes if the
	// Update condition fails. For ReturnValuesOnConditionCheckFailure, the valid
	// values are: NONE, ALL_OLD, UPDATED_OLD, ALL_NEW, UPDATED_NEW.
	ReturnValuesOnConditionCheckFailure *string `type:"string" enum:"ReturnValuesOnConditionCheckFailure"`

	// Name of the table for the UpdateItem request.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`

	// An expression that defines one or more attributes to be updated, the action
	// to be performed on them, and new value(s) for them.
	//
	// UpdateExpression is a required field
	UpdateExpression *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Update) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Update) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Update) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Update"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}
	if s.UpdateExpression == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdateExpression"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConditionExpression sets the ConditionExpression field's value.
func (s *Update) SetConditionExpression(v string) *Update {
	s.ConditionExpression = &v
	return s
}

// SetExpressionAttributeNames sets the ExpressionAttributeNames field's value.
func (s *Update) SetExpressionAttributeNames(v map[string]*string) *Update {
	s.ExpressionAttributeNames = v
	return s
}

// SetExpressionAttributeValues sets the ExpressionAttributeValues field's value.
func (s *Update) SetExpressionAttributeValues(v map[string]*AttributeValue) *Update {
	s.ExpressionAttributeValues = v
	return s
}

// SetKey sets the Key field's value.
func (s *Update) SetKey(v map[string]*AttributeValue) *Update {
	s.Key = v
	return s
}

// SetReturnValuesOnConditionCheckFailure sets the ReturnValuesOnConditionCheckFailure field's value.
func (s *Update) SetReturnValuesOnConditionCheckFailure(v string) *Update {
	s.ReturnValuesOnConditionCheckFailure = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *Update) SetTableName(v string) *Update {
	s.TableName = &v
	return s
}

// SetUpdateExpression sets the UpdateExpression field's value.
func (s *Update) SetUpdateExpression(v string) *Update {
	s.UpdateExpression = &v
	return s
}

type UpdateContinuousBackupsInput struct {
	_ struct{} `type:"structure"`

	// Represents the settings used to enable point in time recovery.
	//
	// PointInTimeRecoverySpecification is a required field
	PointInTimeRecoverySpecification *PointInTimeRecoverySpecification `type:"structure" required:"true"`

	// The name of the table.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateContinuousBackupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateContinuousBackupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateContinuousBackupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateContinuousBackupsInput"}
	if s.PointInTimeRecoverySpecification == nil {
		invalidParams.Add(request.NewErrParamRequired("PointInTimeRecoverySpecification"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}
	if s.PointInTimeRecoverySpecification != nil {
		if err := s.PointInTimeRecoverySpecification.Validate(); err != nil {
			invalidParams.AddNested("PointInTimeRecoverySpecification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPointInTimeRecoverySpecification sets the PointInTimeRecoverySpecification field's value.
func (s *UpdateContinuousBackupsInput) SetPointInTimeRecoverySpecification(v *PointInTimeRecoverySpecification) *UpdateContinuousBackupsInput {
	s.PointInTimeRecoverySpecification = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *UpdateContinuousBackupsInput) SetTableName(v string) *UpdateContinuousBackupsInput {
	s.TableName = &v
	return s
}

type UpdateContinuousBackupsOutput struct {
	_ struct{} `type:"structure"`

	// Represents the continuous backups and point in time recovery settings on
	// the table.
	ContinuousBackupsDescription *ContinuousBackupsDescription `type:"structure"`
}

// String returns the string representation
func (s UpdateContinuousBackupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateContinuousBackupsOutput) GoString() string {
	return s.String()
}

// SetContinuousBackupsDescription sets the ContinuousBackupsDescription field's value.
func (s *UpdateContinuousBackupsOutput) SetContinuousBackupsDescription(v *ContinuousBackupsDescription) *UpdateContinuousBackupsOutput {
	s.ContinuousBackupsDescription = v
	return s
}

type UpdateContributorInsightsInput struct {
	_ struct{} `type:"structure"`

	// Represents the contributor insights action.
	//
	// ContributorInsightsAction is a required field
	ContributorInsightsAction *string `type:"string" required:"true" enum:"ContributorInsightsAction"`

	// The global secondary index name, if applicable.
	IndexName *string `min:"3" type:"string"`

	// The name of the table.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateContributorInsightsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateContributorInsightsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateContributorInsightsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateContributorInsightsInput"}
	if s.ContributorInsightsAction == nil {
		invalidParams.Add(request.NewErrParamRequired("ContributorInsightsAction"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 3))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContributorInsightsAction sets the ContributorInsightsAction field's value.
func (s *UpdateContributorInsightsInput) SetContributorInsightsAction(v string) *UpdateContributorInsightsInput {
	s.ContributorInsightsAction = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *UpdateContributorInsightsInput) SetIndexName(v string) *UpdateContributorInsightsInput {
	s.IndexName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *UpdateContributorInsightsInput) SetTableName(v string) *UpdateContributorInsightsInput {
	s.TableName = &v
	return s
}

type UpdateContributorInsightsOutput struct {
	_ struct{} `type:"structure"`

	// The status of contributor insights
	ContributorInsightsStatus *string `type:"string" enum:"ContributorInsightsStatus"`

	// The name of the global secondary index, if applicable.
	IndexName *string `min:"3" type:"string"`

	// The name of the table.
	TableName *string `min:"3" type:"string"`
}

// String returns the string representation
func (s UpdateContributorInsightsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateContributorInsightsOutput) GoString() string {
	return s.String()
}

// SetContributorInsightsStatus sets the ContributorInsightsStatus field's value.
func (s *UpdateContributorInsightsOutput) SetContributorInsightsStatus(v string) *UpdateContributorInsightsOutput {
	s.ContributorInsightsStatus = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *UpdateContributorInsightsOutput) SetIndexName(v string) *UpdateContributorInsightsOutput {
	s.IndexName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *UpdateContributorInsightsOutput) SetTableName(v string) *UpdateContributorInsightsOutput {
	s.TableName = &v
	return s
}

// Represents the new provisioned throughput settings to be applied to a global
// secondary index.
type UpdateGlobalSecondaryIndexAction struct {
	_ struct{} `type:"structure"`

	// The name of the global secondary index to be updated.
	//
	// IndexName is a required field
	IndexName *string `min:"3" type:"string" required:"true"`

	// Represents the provisioned throughput settings for the specified global secondary
	// index.
	//
	// For current minimum and maximum provisioned throughput values, see Limits
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html)
	// in the Amazon DynamoDB Developer Guide.
	//
	// ProvisionedThroughput is a required field
	ProvisionedThroughput *ProvisionedThroughput `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateGlobalSecondaryIndexAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGlobalSecondaryIndexAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGlobalSecondaryIndexAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGlobalSecondaryIndexAction"}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 3))
	}
	if s.ProvisionedThroughput == nil {
		invalidParams.Add(request.NewErrParamRequired("ProvisionedThroughput"))
	}
	if s.ProvisionedThroughput != nil {
		if err := s.ProvisionedThroughput.Validate(); err != nil {
			invalidParams.AddNested("ProvisionedThroughput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexName sets the IndexName field's value.
func (s *UpdateGlobalSecondaryIndexAction) SetIndexName(v string) *UpdateGlobalSecondaryIndexAction {
	s.IndexName = &v
	return s
}

// SetProvisionedThroughput sets the ProvisionedThroughput field's value.
func (s *UpdateGlobalSecondaryIndexAction) SetProvisionedThroughput(v *ProvisionedThroughput) *UpdateGlobalSecondaryIndexAction {
	s.ProvisionedThroughput = v
	return s
}

type UpdateGlobalTableInput struct {
	_ struct{} `type:"structure"`

	// The global table name.
	//
	// GlobalTableName is a required field
	GlobalTableName *string `min:"3" type:"string" required:"true"`

	// A list of Regions that should be added or removed from the global table.
	//
	// ReplicaUpdates is a required field
	ReplicaUpdates []*ReplicaUpdate `type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateGlobalTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGlobalTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGlobalTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGlobalTableInput"}
	if s.GlobalTableName == nil {
		invalidParams.Add(request.NewErrParamRequired("GlobalTableName"))
	}
	if s.GlobalTableName != nil && len(*s.GlobalTableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("GlobalTableName", 3))
	}
	if s.ReplicaUpdates == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicaUpdates"))
	}
	if s.ReplicaUpdates != nil {
		for i, v := range s.ReplicaUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ReplicaUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGlobalTableName sets the GlobalTableName field's value.
func (s *UpdateGlobalTableInput) SetGlobalTableName(v string) *UpdateGlobalTableInput {
	s.GlobalTableName = &v
	return s
}

// SetReplicaUpdates sets the ReplicaUpdates field's value.
func (s *UpdateGlobalTableInput) SetReplicaUpdates(v []*ReplicaUpdate) *UpdateGlobalTableInput {
	s.ReplicaUpdates = v
	return s
}

type UpdateGlobalTableOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of the global table.
	GlobalTableDescription *GlobalTableDescription `type:"structure"`
}

// String returns the string representation
func (s UpdateGlobalTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGlobalTableOutput) GoString() string {
	return s.String()
}

// SetGlobalTableDescription sets the GlobalTableDescription field's value.
func (s *UpdateGlobalTableOutput) SetGlobalTableDescription(v *GlobalTableDescription) *UpdateGlobalTableOutput {
	s.GlobalTableDescription = v
	return s
}

type UpdateGlobalTableSettingsInput struct {
	_ struct{} `type:"structure"`

	// The billing mode of the global table. If GlobalTableBillingMode is not specified,
	// the global table defaults to PROVISIONED capacity billing mode.
	//
	//    * PROVISIONED - We recommend using PROVISIONED for predictable workloads.
	//    PROVISIONED sets the billing mode to Provisioned Mode (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual).
	//
	//    * PAY_PER_REQUEST - We recommend using PAY_PER_REQUEST for unpredictable
	//    workloads. PAY_PER_REQUEST sets the billing mode to On-Demand Mode (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand).
	GlobalTableBillingMode *string `type:"string" enum:"BillingMode"`

	// Represents the settings of a global secondary index for a global table that
	// will be modified.
	GlobalTableGlobalSecondaryIndexSettingsUpdate []*GlobalTableGlobalSecondaryIndexSettingsUpdate `min:"1" type:"list"`

	// The name of the global table
	//
	// GlobalTableName is a required field
	GlobalTableName *string `min:"3" type:"string" required:"true"`

	// Auto scaling settings for managing provisioned write capacity for the global
	// table.
	GlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate *AutoScalingSettingsUpdate `type:"structure"`

	// The maximum number of writes consumed per second before DynamoDB returns
	// a ThrottlingException.
	GlobalTableProvisionedWriteCapacityUnits *int64 `min:"1" type:"long"`

	// Represents the settings for a global table in a Region that will be modified.
	ReplicaSettingsUpdate []*ReplicaSettingsUpdate `min:"1" type:"list"`
}

// String returns the string representation
func (s UpdateGlobalTableSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGlobalTableSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGlobalTableSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGlobalTableSettingsInput"}
	if s.GlobalTableGlobalSecondaryIndexSettingsUpdate != nil && len(s.GlobalTableGlobalSecondaryIndexSettingsUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GlobalTableGlobalSecondaryIndexSettingsUpdate", 1))
	}
	if s.GlobalTableName == nil {
		invalidParams.Add(request.NewErrParamRequired("GlobalTableName"))
	}
	if s.GlobalTableName != nil && len(*s.GlobalTableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("GlobalTableName", 3))
	}
	if s.GlobalTableProvisionedWriteCapacityUnits != nil && *s.GlobalTableProvisionedWriteCapacityUnits < 1 {
		invalidParams.Add(request.NewErrParamMinValue("GlobalTableProvisionedWriteCapacityUnits", 1))
	}
	if s.ReplicaSettingsUpdate != nil && len(s.ReplicaSettingsUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReplicaSettingsUpdate", 1))
	}
	if s.GlobalTableGlobalSecondaryIndexSettingsUpdate != nil {
		for i, v := range s.GlobalTableGlobalSecondaryIndexSettingsUpdate {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "GlobalTableGlobalSecondaryIndexSettingsUpdate", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.GlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate != nil {
		if err := s.GlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate.Validate(); err != nil {
			invalidParams.AddNested("GlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.ReplicaSettingsUpdate != nil {
		for i, v := range s.ReplicaSettingsUpdate {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ReplicaSettingsUpdate", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGlobalTableBillingMode sets the GlobalTableBillingMode field's value.
func (s *UpdateGlobalTableSettingsInput) SetGlobalTableBillingMode(v string) *UpdateGlobalTableSettingsInput {
	s.GlobalTableBillingMode = &v
	return s
}

// SetGlobalTableGlobalSecondaryIndexSettingsUpdate sets the GlobalTableGlobalSecondaryIndexSettingsUpdate field's value.
func (s *UpdateGlobalTableSettingsInput) SetGlobalTableGlobalSecondaryIndexSettingsUpdate(v []*GlobalTableGlobalSecondaryIndexSettingsUpdate) *UpdateGlobalTableSettingsInput {
	s.GlobalTableGlobalSecondaryIndexSettingsUpdate = v
	return s
}

// SetGlobalTableName sets the GlobalTableName field's value.
func (s *UpdateGlobalTableSettingsInput) SetGlobalTableName(v string) *UpdateGlobalTableSettingsInput {
	s.GlobalTableName = &v
	return s
}

// SetGlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate sets the GlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate field's value.
func (s *UpdateGlobalTableSettingsInput) SetGlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate(v *AutoScalingSettingsUpdate) *UpdateGlobalTableSettingsInput {
	s.GlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate = v
	return s
}

// SetGlobalTableProvisionedWriteCapacityUnits sets the GlobalTableProvisionedWriteCapacityUnits field's value.
func (s *UpdateGlobalTableSettingsInput) SetGlobalTableProvisionedWriteCapacityUnits(v int64) *UpdateGlobalTableSettingsInput {
	s.GlobalTableProvisionedWriteCapacityUnits = &v
	return s
}

// SetReplicaSettingsUpdate sets the ReplicaSettingsUpdate field's value.
func (s *UpdateGlobalTableSettingsInput) SetReplicaSettingsUpdate(v []*ReplicaSettingsUpdate) *UpdateGlobalTableSettingsInput {
	s.ReplicaSettingsUpdate = v
	return s
}

type UpdateGlobalTableSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The name of the global table.
	GlobalTableName *string `min:"3" type:"string"`

	// The Region-specific settings for the global table.
	ReplicaSettings []*ReplicaSettingsDescription `type:"list"`
}

// String returns the string representation
func (s UpdateGlobalTableSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGlobalTableSettingsOutput) GoString() string {
	return s.String()
}

// SetGlobalTableName sets the GlobalTableName field's value.
func (s *UpdateGlobalTableSettingsOutput) SetGlobalTableName(v string) *UpdateGlobalTableSettingsOutput {
	s.GlobalTableName = &v
	return s
}

// SetReplicaSettings sets the ReplicaSettings field's value.
func (s *UpdateGlobalTableSettingsOutput) SetReplicaSettings(v []*ReplicaSettingsDescription) *UpdateGlobalTableSettingsOutput {
	s.ReplicaSettings = v
	return s
}

// Represents the input of an UpdateItem operation.
type UpdateItemInput struct {
	_ struct{} `type:"structure"`

	// This is a legacy parameter. Use UpdateExpression instead. For more information,
	// see AttributeUpdates (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributeUpdates.html)
	// in the Amazon DynamoDB Developer Guide.
	AttributeUpdates map[string]*AttributeValueUpdate `type:"map"`

	// A condition that must be satisfied in order for a conditional update to succeed.
	//
	// An expression can contain any of the following:
	//
	//    * Functions: attribute_exists | attribute_not_exists | attribute_type
	//    | contains | begins_with | size These function names are case-sensitive.
	//
	//    * Comparison operators: = | <> | < | > | <= | >= | BETWEEN | IN
	//
	//    * Logical operators: AND | OR | NOT
	//
	// For more information about condition expressions, see Specifying Conditions
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html)
	// in the Amazon DynamoDB Developer Guide.
	ConditionExpression *string `type:"string"`

	// This is a legacy parameter. Use ConditionExpression instead. For more information,
	// see ConditionalOperator (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html)
	// in the Amazon DynamoDB Developer Guide.
	ConditionalOperator *string `type:"string" enum:"ConditionalOperator"`

	// This is a legacy parameter. Use ConditionExpression instead. For more information,
	// see Expected (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html)
	// in the Amazon DynamoDB Developer Guide.
	Expected map[string]*ExpectedAttributeValue `type:"map"`

	// One or more substitution tokens for attribute names in an expression. The
	// following are some use cases for using ExpressionAttributeNames:
	//
	//    * To access an attribute whose name conflicts with a DynamoDB reserved
	//    word.
	//
	//    * To create a placeholder for repeating occurrences of an attribute name
	//    in an expression.
	//
	//    * To prevent special characters in an attribute name from being misinterpreted
	//    in an expression.
	//
	// Use the # character in an expression to dereference an attribute name. For
	// example, consider the following attribute name:
	//
	//    * Percentile
	//
	// The name of this attribute conflicts with a reserved word, so it cannot be
	// used directly in an expression. (For the complete list of reserved words,
	// see Reserved Words (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
	// in the Amazon DynamoDB Developer Guide.) To work around this, you could specify
	// the following for ExpressionAttributeNames:
	//
	//    * {"#P":"Percentile"}
	//
	// You could then use this substitution in an expression, as in this example:
	//
	//    * #P = :val
	//
	// Tokens that begin with the : character are expression attribute values, which
	// are placeholders for the actual value at runtime.
	//
	// For more information about expression attribute names, see Specifying Item
	// Attributes (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
	// in the Amazon DynamoDB Developer Guide.
	ExpressionAttributeNames map[string]*string `type:"map"`

	// One or more values that can be substituted in an expression.
	//
	// Use the : (colon) character in an expression to dereference an attribute
	// value. For example, suppose that you wanted to check whether the value of
	// the ProductStatus attribute was one of the following:
	//
	// Available | Backordered | Discontinued
	//
	// You would first need to specify ExpressionAttributeValues as follows:
	//
	// { ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"}
	// }
	//
	// You could then use these values in an expression, such as this:
	//
	// ProductStatus IN (:avail, :back, :disc)
	//
	// For more information on expression attribute values, see Condition Expressions
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html)
	// in the Amazon DynamoDB Developer Guide.
	ExpressionAttributeValues map[string]*AttributeValue `type:"map"`

	// The primary key of the item to be updated. Each element consists of an attribute
	// name and a value for that attribute.
	//
	// For the primary key, you must provide all of the attributes. For example,
	// with a simple primary key, you only need to provide a value for the partition
	// key. For a composite primary key, you must provide values for both the partition
	// key and the sort key.
	//
	// Key is a required field
	Key map[string]*AttributeValue `type:"map" required:"true"`

	// Determines the level of detail about provisioned throughput consumption that
	// is returned in the response:
	//
	//    * INDEXES - The response includes the aggregate ConsumedCapacity for the
	//    operation, together with ConsumedCapacity for each table and secondary
	//    index that was accessed. Note that some operations, such as GetItem and
	//    BatchGetItem, do not access any indexes at all. In these cases, specifying
	//    INDEXES will only return ConsumedCapacity information for table(s).
	//
	//    * TOTAL - The response includes only the aggregate ConsumedCapacity for
	//    the operation.
	//
	//    * NONE - No ConsumedCapacity details are included in the response.
	ReturnConsumedCapacity *string `type:"string" enum:"ReturnConsumedCapacity"`

	// Determines whether item collection metrics are returned. If set to SIZE,
	// the response includes statistics about item collections, if any, that were
	// modified during the operation are returned in the response. If set to NONE
	// (the default), no statistics are returned.
	ReturnItemCollectionMetrics *string `type:"string" enum:"ReturnItemCollectionMetrics"`

	// Use ReturnValues if you want to get the item attributes as they appear before
	// or after they are updated. For UpdateItem, the valid values are:
	//
	//    * NONE - If ReturnValues is not specified, or if its value is NONE, then
	//    nothing is returned. (This setting is the default for ReturnValues.)
	//
	//    * ALL_OLD - Returns all of the attributes of the item, as they appeared
	//    before the UpdateItem operation.
	//
	//    * UPDATED_OLD - Returns only the updated attributes, as they appeared
	//    before the UpdateItem operation.
	//
	//    * ALL_NEW - Returns all of the attributes of the item, as they appear
	//    after the UpdateItem operation.
	//
	//    * UPDATED_NEW - Returns only the updated attributes, as they appear after
	//    the UpdateItem operation.
	//
	// There is no additional cost associated with requesting a return value aside
	// from the small network and processing overhead of receiving a larger response.
	// No read capacity units are consumed.
	//
	// The values returned are strongly consistent.
	ReturnValues *string `type:"string" enum:"ReturnValue"`

	// The name of the table containing the item to update.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`

	// An expression that defines one or more attributes to be updated, the action
	// to be performed on them, and new values for them.
	//
	// The following action values are available for UpdateExpression.
	//
	//    * SET - Adds one or more attributes and values to an item. If any of these
	//    attributes already exist, they are replaced by the new values. You can
	//    also use SET to add or subtract from an attribute that is of type Number.
	//    For example: SET myNum = myNum + :val SET supports the following functions:
	//    if_not_exists (path, operand) - if the item does not contain an attribute
	//    at the specified path, then if_not_exists evaluates to operand; otherwise,
	//    it evaluates to path. You can use this function to avoid overwriting an
	//    attribute that may already be present in the item. list_append (operand,
	//    operand) - evaluates to a list with a new element added to it. You can
	//    append the new element to the start or the end of the list by reversing
	//    the order of the operands. These function names are case-sensitive.
	//
	//    * REMOVE - Removes one or more attributes from an item.
	//
	//    * ADD - Adds the specified value to the item, if the attribute does not
	//    already exist. If the attribute does exist, then the behavior of ADD depends
	//    on the data type of the attribute: If the existing attribute is a number,
	//    and if Value is also a number, then Value is mathematically added to the
	//    existing attribute. If Value is a negative number, then it is subtracted
	//    from the existing attribute. If you use ADD to increment or decrement
	//    a number value for an item that doesn't exist before the update, DynamoDB
	//    uses 0 as the initial value. Similarly, if you use ADD for an existing
	//    item to increment or decrement an attribute value that doesn't exist before
	//    the update, DynamoDB uses 0 as the initial value. For example, suppose
	//    that the item you want to update doesn't have an attribute named itemcount,
	//    but you decide to ADD the number 3 to this attribute anyway. DynamoDB
	//    will create the itemcount attribute, set its initial value to 0, and finally
	//    add 3 to it. The result will be a new itemcount attribute in the item,
	//    with a value of 3. If the existing data type is a set and if Value is
	//    also a set, then Value is added to the existing set. For example, if the
	//    attribute value is the set [1,2], and the ADD action specified [3], then
	//    the final attribute value is [1,2,3]. An error occurs if an ADD action
	//    is specified for a set attribute and the attribute type specified does
	//    not match the existing set type. Both sets must have the same primitive
	//    data type. For example, if the existing data type is a set of strings,
	//    the Value must also be a set of strings. The ADD action only supports
	//    Number and set data types. In addition, ADD can only be used on top-level
	//    attributes, not nested attributes.
	//
	//    * DELETE - Deletes an element from a set. If a set of values is specified,
	//    then those values are subtracted from the old set. For example, if the
	//    attribute value was the set [a,b,c] and the DELETE action specifies [a,c],
	//    then the final attribute value is [b]. Specifying an empty set is an error.
	//    The DELETE action only supports set data types. In addition, DELETE can
	//    only be used on top-level attributes, not nested attributes.
	//
	// You can have many actions in a single expression, such as the following:
	// SET a=:value1, b=:value2 DELETE :value3, :value4, :value5
	//
	// For more information on update expressions, see Modifying Items and Attributes
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Modifying.html)
	// in the Amazon DynamoDB Developer Guide.
	UpdateExpression *string `type:"string"`
}

// String returns the string representation
func (s UpdateItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateItemInput"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeUpdates sets the AttributeUpdates field's value.
func (s *UpdateItemInput) SetAttributeUpdates(v map[string]*AttributeValueUpdate) *UpdateItemInput {
	s.AttributeUpdates = v
	return s
}

// SetConditionExpression sets the ConditionExpression field's value.
func (s *UpdateItemInput) SetConditionExpression(v string) *UpdateItemInput {
	s.ConditionExpression = &v
	return s
}

// SetConditionalOperator sets the ConditionalOperator field's value.
func (s *UpdateItemInput) SetConditionalOperator(v string) *UpdateItemInput {
	s.ConditionalOperator = &v
	return s
}

// SetExpected sets the Expected field's value.
func (s *UpdateItemInput) SetExpected(v map[string]*ExpectedAttributeValue) *UpdateItemInput {
	s.Expected = v
	return s
}

// SetExpressionAttributeNames sets the ExpressionAttributeNames field's value.
func (s *UpdateItemInput) SetExpressionAttributeNames(v map[string]*string) *UpdateItemInput {
	s.ExpressionAttributeNames = v
	return s
}

// SetExpressionAttributeValues sets the ExpressionAttributeValues field's value.
func (s *UpdateItemInput) SetExpressionAttributeValues(v map[string]*AttributeValue) *UpdateItemInput {
	s.ExpressionAttributeValues = v
	return s
}

// SetKey sets the Key field's value.
func (s *UpdateItemInput) SetKey(v map[string]*AttributeValue) *UpdateItemInput {
	s.Key = v
	return s
}

// SetReturnConsumedCapacity sets the ReturnConsumedCapacity field's value.
func (s *UpdateItemInput) SetReturnConsumedCapacity(v string) *UpdateItemInput {
	s.ReturnConsumedCapacity = &v
	return s
}

// SetReturnItemCollectionMetrics sets the ReturnItemCollectionMetrics field's value.
func (s *UpdateItemInput) SetReturnItemCollectionMetrics(v string) *UpdateItemInput {
	s.ReturnItemCollectionMetrics = &v
	return s
}

// SetReturnValues sets the ReturnValues field's value.
func (s *UpdateItemInput) SetReturnValues(v string) *UpdateItemInput {
	s.ReturnValues = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *UpdateItemInput) SetTableName(v string) *UpdateItemInput {
	s.TableName = &v
	return s
}

// SetUpdateExpression sets the UpdateExpression field's value.
func (s *UpdateItemInput) SetUpdateExpression(v string) *UpdateItemInput {
	s.UpdateExpression = &v
	return s
}

// Represents the output of an UpdateItem operation.
type UpdateItemOutput struct {
	_ struct{} `type:"structure"`

	// A map of attribute values as they appear before or after the UpdateItem operation,
	// as determined by the ReturnValues parameter.
	//
	// The Attributes map is only present if ReturnValues was specified as something
	// other than NONE in the request. Each element represents one attribute.
	Attributes map[string]*AttributeValue `type:"map"`

	// The capacity units consumed by the UpdateItem operation. The data returned
	// includes the total provisioned throughput consumed, along with statistics
	// for the table and any indexes involved in the operation. ConsumedCapacity
	// is only returned if the ReturnConsumedCapacity parameter was specified. For
	// more information, see Provisioned Throughput (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html)
	// in the Amazon DynamoDB Developer Guide.
	ConsumedCapacity *ConsumedCapacity `type:"structure"`

	// Information about item collections, if any, that were affected by the UpdateItem
	// operation. ItemCollectionMetrics is only returned if the ReturnItemCollectionMetrics
	// parameter was specified. If the table does not have any local secondary indexes,
	// this information is not returned in the response.
	//
	// Each ItemCollectionMetrics element consists of:
	//
	//    * ItemCollectionKey - The partition key value of the item collection.
	//    This is the same as the partition key value of the item itself.
	//
	//    * SizeEstimateRangeGB - An estimate of item collection size, in gigabytes.
	//    This value is a two-element array containing a lower bound and an upper
	//    bound for the estimate. The estimate includes the size of all the items
	//    in the table, plus the size of all attributes projected into all of the
	//    local secondary indexes on that table. Use this estimate to measure whether
	//    a local secondary index is approaching its size limit. The estimate is
	//    subject to change over time; therefore, do not rely on the precision or
	//    accuracy of the estimate.
	ItemCollectionMetrics *ItemCollectionMetrics `type:"structure"`
}

// String returns the string representation
func (s UpdateItemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateItemOutput) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *UpdateItemOutput) SetAttributes(v map[string]*AttributeValue) *UpdateItemOutput {
	s.Attributes = v
	return s
}

// SetConsumedCapacity sets the ConsumedCapacity field's value.
func (s *UpdateItemOutput) SetConsumedCapacity(v *ConsumedCapacity) *UpdateItemOutput {
	s.ConsumedCapacity = v
	return s
}

// SetItemCollectionMetrics sets the ItemCollectionMetrics field's value.
func (s *UpdateItemOutput) SetItemCollectionMetrics(v *ItemCollectionMetrics) *UpdateItemOutput {
	s.ItemCollectionMetrics = v
	return s
}

// Represents a replica to be modified.
type UpdateReplicationGroupMemberAction struct {
	_ struct{} `type:"structure"`

	// Replica-specific global secondary index settings.
	GlobalSecondaryIndexes []*ReplicaGlobalSecondaryIndex `min:"1" type:"list"`

	// The AWS KMS customer master key (CMK) of the replica that should be used
	// for AWS KMS encryption. To specify a CMK, use its key ID, Amazon Resource
	// Name (ARN), alias name, or alias ARN. Note that you should only provide this
	// parameter if the key is different from the default DynamoDB KMS master key
	// alias/aws/dynamodb.
	KMSMasterKeyId *string `type:"string"`

	// Replica-specific provisioned throughput. If not specified, uses the source
	// table's provisioned throughput settings.
	ProvisionedThroughputOverride *ProvisionedThroughputOverride `type:"structure"`

	// The Region where the replica exists.
	//
	// RegionName is a required field
	RegionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateReplicationGroupMemberAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateReplicationGroupMemberAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateReplicationGroupMemberAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateReplicationGroupMemberAction"}
	if s.GlobalSecondaryIndexes != nil && len(s.GlobalSecondaryIndexes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GlobalSecondaryIndexes", 1))
	}
	if s.RegionName == nil {
		invalidParams.Add(request.NewErrParamRequired("RegionName"))
	}
	if s.GlobalSecondaryIndexes != nil {
		for i, v := range s.GlobalSecondaryIndexes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "GlobalSecondaryIndexes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ProvisionedThroughputOverride != nil {
		if err := s.ProvisionedThroughputOverride.Validate(); err != nil {
			invalidParams.AddNested("ProvisionedThroughputOverride", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGlobalSecondaryIndexes sets the GlobalSecondaryIndexes field's value.
func (s *UpdateReplicationGroupMemberAction) SetGlobalSecondaryIndexes(v []*ReplicaGlobalSecondaryIndex) *UpdateReplicationGroupMemberAction {
	s.GlobalSecondaryIndexes = v
	return s
}

// SetKMSMasterKeyId sets the KMSMasterKeyId field's value.
func (s *UpdateReplicationGroupMemberAction) SetKMSMasterKeyId(v string) *UpdateReplicationGroupMemberAction {
	s.KMSMasterKeyId = &v
	return s
}

// SetProvisionedThroughputOverride sets the ProvisionedThroughputOverride field's value.
func (s *UpdateReplicationGroupMemberAction) SetProvisionedThroughputOverride(v *ProvisionedThroughputOverride) *UpdateReplicationGroupMemberAction {
	s.ProvisionedThroughputOverride = v
	return s
}

// SetRegionName sets the RegionName field's value.
func (s *UpdateReplicationGroupMemberAction) SetRegionName(v string) *UpdateReplicationGroupMemberAction {
	s.RegionName = &v
	return s
}

// Represents the input of an UpdateTable operation.
type UpdateTableInput struct {
	_ struct{} `type:"structure"`

	// An array of attributes that describe the key schema for the table and indexes.
	// If you are adding a new global secondary index to the table, AttributeDefinitions
	// must include the key element(s) of the new index.
	AttributeDefinitions []*AttributeDefinition `type:"list"`

	// Controls how you are charged for read and write throughput and how you manage
	// capacity. When switching from pay-per-request to provisioned capacity, initial
	// provisioned capacity values must be set. The initial provisioned capacity
	// values are estimated based on the consumed read and write capacity of your
	// table and global secondary indexes over the past 30 minutes.
	//
	//    * PROVISIONED - We recommend using PROVISIONED for predictable workloads.
	//    PROVISIONED sets the billing mode to Provisioned Mode (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual).
	//
	//    * PAY_PER_REQUEST - We recommend using PAY_PER_REQUEST for unpredictable
	//    workloads. PAY_PER_REQUEST sets the billing mode to On-Demand Mode (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand).
	BillingMode *string `type:"string" enum:"BillingMode"`

	// An array of one or more global secondary indexes for the table. For each
	// index in the array, you can request one action:
	//
	//    * Create - add a new global secondary index to the table.
	//
	//    * Update - modify the provisioned throughput settings of an existing global
	//    secondary index.
	//
	//    * Delete - remove a global secondary index from the table.
	//
	// You can create or delete only one global secondary index per UpdateTable
	// operation.
	//
	// For more information, see Managing Global Secondary Indexes (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html)
	// in the Amazon DynamoDB Developer Guide.
	GlobalSecondaryIndexUpdates []*GlobalSecondaryIndexUpdate `type:"list"`

	// The new provisioned throughput settings for the specified table or index.
	ProvisionedThroughput *ProvisionedThroughput `type:"structure"`

	// A list of replica update actions (create, delete, or update) for the table.
	//
	// This property only applies to Version 2019.11.21 (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html)
	// of global tables.
	ReplicaUpdates []*ReplicationGroupUpdate `min:"1" type:"list"`

	// The new server-side encryption settings for the specified table.
	SSESpecification *SSESpecification `type:"structure"`

	// Represents the DynamoDB Streams configuration for the table.
	//
	// You receive a ResourceInUseException if you try to enable a stream on a table
	// that already has a stream, or if you try to disable a stream on a table that
	// doesn't have a stream.
	StreamSpecification *StreamSpecification `type:"structure"`

	// The name of the table to be updated.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTableInput"}
	if s.ReplicaUpdates != nil && len(s.ReplicaUpdates) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReplicaUpdates", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}
	if s.AttributeDefinitions != nil {
		for i, v := range s.AttributeDefinitions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AttributeDefinitions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.GlobalSecondaryIndexUpdates != nil {
		for i, v := range s.GlobalSecondaryIndexUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "GlobalSecondaryIndexUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ProvisionedThroughput != nil {
		if err := s.ProvisionedThroughput.Validate(); err != nil {
			invalidParams.AddNested("ProvisionedThroughput", err.(request.ErrInvalidParams))
		}
	}
	if s.ReplicaUpdates != nil {
		for i, v := range s.ReplicaUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ReplicaUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.StreamSpecification != nil {
		if err := s.StreamSpecification.Validate(); err != nil {
			invalidParams.AddNested("StreamSpecification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeDefinitions sets the AttributeDefinitions field's value.
func (s *UpdateTableInput) SetAttributeDefinitions(v []*AttributeDefinition) *UpdateTableInput {
	s.AttributeDefinitions = v
	return s
}

// SetBillingMode sets the BillingMode field's value.
func (s *UpdateTableInput) SetBillingMode(v string) *UpdateTableInput {
	s.BillingMode = &v
	return s
}

// SetGlobalSecondaryIndexUpdates sets the GlobalSecondaryIndexUpdates field's value.
func (s *UpdateTableInput) SetGlobalSecondaryIndexUpdates(v []*GlobalSecondaryIndexUpdate) *UpdateTableInput {
	s.GlobalSecondaryIndexUpdates = v
	return s
}

// SetProvisionedThroughput sets the ProvisionedThroughput field's value.
func (s *UpdateTableInput) SetProvisionedThroughput(v *ProvisionedThroughput) *UpdateTableInput {
	s.ProvisionedThroughput = v
	return s
}

// SetReplicaUpdates sets the ReplicaUpdates field's value.
func (s *UpdateTableInput) SetReplicaUpdates(v []*ReplicationGroupUpdate) *UpdateTableInput {
	s.ReplicaUpdates = v
	return s
}

// SetSSESpecification sets the SSESpecification field's value.
func (s *UpdateTableInput) SetSSESpecification(v *SSESpecification) *UpdateTableInput {
	s.SSESpecification = v
	return s
}

// SetStreamSpecification sets the StreamSpecification field's value.
func (s *UpdateTableInput) SetStreamSpecification(v *StreamSpecification) *UpdateTableInput {
	s.StreamSpecification = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *UpdateTableInput) SetTableName(v string) *UpdateTableInput {
	s.TableName = &v
	return s
}

// Represents the output of an UpdateTable operation.
type UpdateTableOutput struct {
	_ struct{} `type:"structure"`

	// Represents the properties of the table.
	TableDescription *TableDescription `type:"structure"`
}

// String returns the string representation
func (s UpdateTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTableOutput) GoString() string {
	return s.String()
}

// SetTableDescription sets the TableDescription field's value.
func (s *UpdateTableOutput) SetTableDescription(v *TableDescription) *UpdateTableOutput {
	s.TableDescription = v
	return s
}

type UpdateTableReplicaAutoScalingInput struct {
	_ struct{} `type:"structure"`

	// Represents the auto scaling settings of the global secondary indexes of the
	// replica to be updated.
	GlobalSecondaryIndexUpdates []*GlobalSecondaryIndexAutoScalingUpdate `min:"1" type:"list"`

	// Represents the auto scaling settings to be modified for a global table or
	// global secondary index.
	ProvisionedWriteCapacityAutoScalingUpdate *AutoScalingSettingsUpdate `type:"structure"`

	// Represents the auto scaling settings of replicas of the table that will be
	// modified.
	ReplicaUpdates []*ReplicaAutoScalingUpdate `min:"1" type:"list"`

	// The name of the global table to be updated.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateTableReplicaAutoScalingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTableReplicaAutoScalingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTableReplicaAutoScalingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTableReplicaAutoScalingInput"}
	if s.GlobalSecondaryIndexUpdates != nil && len(s.GlobalSecondaryIndexUpdates) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GlobalSecondaryIndexUpdates", 1))
	}
	if s.ReplicaUpdates != nil && len(s.ReplicaUpdates) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReplicaUpdates", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}
	if s.GlobalSecondaryIndexUpdates != nil {
		for i, v := range s.GlobalSecondaryIndexUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "GlobalSecondaryIndexUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ProvisionedWriteCapacityAutoScalingUpdate != nil {
		if err := s.ProvisionedWriteCapacityAutoScalingUpdate.Validate(); err != nil {
			invalidParams.AddNested("ProvisionedWriteCapacityAutoScalingUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.ReplicaUpdates != nil {
		for i, v := range s.ReplicaUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ReplicaUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGlobalSecondaryIndexUpdates sets the GlobalSecondaryIndexUpdates field's value.
func (s *UpdateTableReplicaAutoScalingInput) SetGlobalSecondaryIndexUpdates(v []*GlobalSecondaryIndexAutoScalingUpdate) *UpdateTableReplicaAutoScalingInput {
	s.GlobalSecondaryIndexUpdates = v
	return s
}

// SetProvisionedWriteCapacityAutoScalingUpdate sets the ProvisionedWriteCapacityAutoScalingUpdate field's value.
func (s *UpdateTableReplicaAutoScalingInput) SetProvisionedWriteCapacityAutoScalingUpdate(v *AutoScalingSettingsUpdate) *UpdateTableReplicaAutoScalingInput {
	s.ProvisionedWriteCapacityAutoScalingUpdate = v
	return s
}

// SetReplicaUpdates sets the ReplicaUpdates field's value.
func (s *UpdateTableReplicaAutoScalingInput) SetReplicaUpdates(v []*ReplicaAutoScalingUpdate) *UpdateTableReplicaAutoScalingInput {
	s.ReplicaUpdates = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *UpdateTableReplicaAutoScalingInput) SetTableName(v string) *UpdateTableReplicaAutoScalingInput {
	s.TableName = &v
	return s
}

type UpdateTableReplicaAutoScalingOutput struct {
	_ struct{} `type:"structure"`

	// Returns information about the auto scaling settings of a table with replicas.
	TableAutoScalingDescription *TableAutoScalingDescription `type:"structure"`
}

// String returns the string representation
func (s UpdateTableReplicaAutoScalingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTableReplicaAutoScalingOutput) GoString() string {
	return s.String()
}

// SetTableAutoScalingDescription sets the TableAutoScalingDescription field's value.
func (s *UpdateTableReplicaAutoScalingOutput) SetTableAutoScalingDescription(v *TableAutoScalingDescription) *UpdateTableReplicaAutoScalingOutput {
	s.TableAutoScalingDescription = v
	return s
}

// Represents the input of an UpdateTimeToLive operation.
type UpdateTimeToLiveInput struct {
	_ struct{} `type:"structure"`

	// The name of the table to be configured.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`

	// Represents the settings used to enable or disable Time to Live for the specified
	// table.
	//
	// TimeToLiveSpecification is a required field
	TimeToLiveSpecification *TimeToLiveSpecification `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateTimeToLiveInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTimeToLiveInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTimeToLiveInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTimeToLiveInput"}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}
	if s.TimeToLiveSpecification == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeToLiveSpecification"))
	}
	if s.TimeToLiveSpecification != nil {
		if err := s.TimeToLiveSpecification.Validate(); err != nil {
			invalidParams.AddNested("TimeToLiveSpecification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTableName sets the TableName field's value.
func (s *UpdateTimeToLiveInput) SetTableName(v string) *UpdateTimeToLiveInput {
	s.TableName = &v
	return s
}

// SetTimeToLiveSpecification sets the TimeToLiveSpecification field's value.
func (s *UpdateTimeToLiveInput) SetTimeToLiveSpecification(v *TimeToLiveSpecification) *UpdateTimeToLiveInput {
	s.TimeToLiveSpecification = v
	return s
}

type UpdateTimeToLiveOutput struct {
	_ struct{} `type:"structure"`

	// Represents the output of an UpdateTimeToLive operation.
	TimeToLiveSpecification *TimeToLiveSpecification `type:"structure"`
}

// String returns the string representation
func (s UpdateTimeToLiveOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTimeToLiveOutput) GoString() string {
	return s.String()
}

// SetTimeToLiveSpecification sets the TimeToLiveSpecification field's value.
func (s *UpdateTimeToLiveOutput) SetTimeToLiveSpecification(v *TimeToLiveSpecification) *UpdateTimeToLiveOutput {
	s.TimeToLiveSpecification = v
	return s
}

// Represents an operation to perform - either DeleteItem or PutItem. You can
// only request one of these operations, not both, in a single WriteRequest.
// If you do need to perform both of these operations, you need to provide two
// separate WriteRequest objects.
type WriteRequest struct {
	_ struct{} `type:"structure"`

	// A request to perform a DeleteItem operation.
	DeleteRequest *DeleteRequest `type:"structure"`

	// A request to perform a PutItem operation.
	PutRequest *PutRequest `type:"structure"`
}

// String returns the string representation
func (s WriteRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WriteRequest) GoString() string {
	return s.String()
}

// SetDeleteRequest sets the DeleteRequest field's value.
func (s *WriteRequest) SetDeleteRequest(v *DeleteRequest) *WriteRequest {
	s.DeleteRequest = v
	return s
}

// SetPutRequest sets the PutRequest field's value.
func (s *WriteRequest) SetPutRequest(v *PutRequest) *WriteRequest {
	s.PutRequest = v
	return s
}

const (
	// AttributeActionAdd is a AttributeAction enum value
	AttributeActionAdd = "ADD"

	// AttributeActionPut is a AttributeAction enum value
	AttributeActionPut = "PUT"

	// AttributeActionDelete is a AttributeAction enum value
	AttributeActionDelete = "DELETE"
)

const (
	// BackupStatusCreating is a BackupStatus enum value
	BackupStatusCreating = "CREATING"

	// BackupStatusDeleted is a BackupStatus enum value
	BackupStatusDeleted = "DELETED"

	// BackupStatusAvailable is a BackupStatus enum value
	BackupStatusAvailable = "AVAILABLE"
)

const (
	// BackupTypeUser is a BackupType enum value
	BackupTypeUser = "USER"

	// BackupTypeSystem is a BackupType enum value
	BackupTypeSystem = "SYSTEM"

	// BackupTypeAwsBackup is a BackupType enum value
	BackupTypeAwsBackup = "AWS_BACKUP"
)

const (
	// BackupTypeFilterUser is a BackupTypeFilter enum value
	BackupTypeFilterUser = "USER"

	// BackupTypeFilterSystem is a BackupTypeFilter enum value
	BackupTypeFilterSystem = "SYSTEM"

	// BackupTypeFilterAwsBackup is a BackupTypeFilter enum value
	BackupTypeFilterAwsBackup = "AWS_BACKUP"

	// BackupTypeFilterAll is a BackupTypeFilter enum value
	BackupTypeFilterAll = "ALL"
)

const (
	// BillingModeProvisioned is a BillingMode enum value
	BillingModeProvisioned = "PROVISIONED"

	// BillingModePayPerRequest is a BillingMode enum value
	BillingModePayPerRequest = "PAY_PER_REQUEST"
)

const (
	// ComparisonOperatorEq is a ComparisonOperator enum value
	ComparisonOperatorEq = "EQ"

	// ComparisonOperatorNe is a ComparisonOperator enum value
	ComparisonOperatorNe = "NE"

	// ComparisonOperatorIn is a ComparisonOperator enum value
	ComparisonOperatorIn = "IN"

	// ComparisonOperatorLe is a ComparisonOperator enum value
	ComparisonOperatorLe = "LE"

	// ComparisonOperatorLt is a ComparisonOperator enum value
	ComparisonOperatorLt = "LT"

	// ComparisonOperatorGe is a ComparisonOperator enum value
	ComparisonOperatorGe = "GE"

	// ComparisonOperatorGt is a ComparisonOperator enum value
	ComparisonOperatorGt = "GT"

	// ComparisonOperatorBetween is a ComparisonOperator enum value
	ComparisonOperatorBetween = "BETWEEN"

	// ComparisonOperatorNotNull is a ComparisonOperator enum value
	ComparisonOperatorNotNull = "NOT_NULL"

	// ComparisonOperatorNull is a ComparisonOperator enum value
	ComparisonOperatorNull = "NULL"

	// ComparisonOperatorContains is a ComparisonOperator enum value
	ComparisonOperatorContains = "CONTAINS"

	// ComparisonOperatorNotContains is a ComparisonOperator enum value
	ComparisonOperatorNotContains = "NOT_CONTAINS"

	// ComparisonOperatorBeginsWith is a ComparisonOperator enum value
	ComparisonOperatorBeginsWith = "BEGINS_WITH"
)

const (
	// ConditionalOperatorAnd is a ConditionalOperator enum value
	ConditionalOperatorAnd = "AND"

	// ConditionalOperatorOr is a ConditionalOperator enum value
	ConditionalOperatorOr = "OR"
)

const (
	// ContinuousBackupsStatusEnabled is a ContinuousBackupsStatus enum value
	ContinuousBackupsStatusEnabled = "ENABLED"

	// ContinuousBackupsStatusDisabled is a ContinuousBackupsStatus enum value
	ContinuousBackupsStatusDisabled = "DISABLED"
)

const (
	// ContributorInsightsActionEnable is a ContributorInsightsAction enum value
	ContributorInsightsActionEnable = "ENABLE"

	// ContributorInsightsActionDisable is a ContributorInsightsAction enum value
	ContributorInsightsActionDisable = "DISABLE"
)

const (
	// ContributorInsightsStatusEnabling is a ContributorInsightsStatus enum value
	ContributorInsightsStatusEnabling = "ENABLING"

	// ContributorInsightsStatusEnabled is a ContributorInsightsStatus enum value
	ContributorInsightsStatusEnabled = "ENABLED"

	// ContributorInsightsStatusDisabling is a ContributorInsightsStatus enum value
	ContributorInsightsStatusDisabling = "DISABLING"

	// ContributorInsightsStatusDisabled is a ContributorInsightsStatus enum value
	ContributorInsightsStatusDisabled = "DISABLED"

	// ContributorInsightsStatusFailed is a ContributorInsightsStatus enum value
	ContributorInsightsStatusFailed = "FAILED"
)

const (
	// GlobalTableStatusCreating is a GlobalTableStatus enum value
	GlobalTableStatusCreating = "CREATING"

	// GlobalTableStatusActive is a GlobalTableStatus enum value
	GlobalTableStatusActive = "ACTIVE"

	// GlobalTableStatusDeleting is a GlobalTableStatus enum value
	GlobalTableStatusDeleting = "DELETING"

	// GlobalTableStatusUpdating is a GlobalTableStatus enum value
	GlobalTableStatusUpdating = "UPDATING"
)

const (
	// IndexStatusCreating is a IndexStatus enum value
	IndexStatusCreating = "CREATING"

	// IndexStatusUpdating is a IndexStatus enum value
	IndexStatusUpdating = "UPDATING"

	// IndexStatusDeleting is a IndexStatus enum value
	IndexStatusDeleting = "DELETING"

	// IndexStatusActive is a IndexStatus enum value
	IndexStatusActive = "ACTIVE"
)

const (
	// KeyTypeHash is a KeyType enum value
	KeyTypeHash = "HASH"

	// KeyTypeRange is a KeyType enum value
	KeyTypeRange = "RANGE"
)

const (
	// PointInTimeRecoveryStatusEnabled is a PointInTimeRecoveryStatus enum value
	PointInTimeRecoveryStatusEnabled = "ENABLED"

	// PointInTimeRecoveryStatusDisabled is a PointInTimeRecoveryStatus enum value
	PointInTimeRecoveryStatusDisabled = "DISABLED"
)

const (
	// ProjectionTypeAll is a ProjectionType enum value
	ProjectionTypeAll = "ALL"

	// ProjectionTypeKeysOnly is a ProjectionType enum value
	ProjectionTypeKeysOnly = "KEYS_ONLY"

	// ProjectionTypeInclude is a ProjectionType enum value
	ProjectionTypeInclude = "INCLUDE"
)

const (
	// ReplicaStatusCreating is a ReplicaStatus enum value
	ReplicaStatusCreating = "CREATING"

	// ReplicaStatusCreationFailed is a ReplicaStatus enum value
	ReplicaStatusCreationFailed = "CREATION_FAILED"

	// ReplicaStatusUpdating is a ReplicaStatus enum value
	ReplicaStatusUpdating = "UPDATING"

	// ReplicaStatusDeleting is a ReplicaStatus enum value
	ReplicaStatusDeleting = "DELETING"

	// ReplicaStatusActive is a ReplicaStatus enum value
	ReplicaStatusActive = "ACTIVE"
)

// Determines the level of detail about provisioned throughput consumption that
// is returned in the response:
//
//    * INDEXES - The response includes the aggregate ConsumedCapacity for the
//    operation, together with ConsumedCapacity for each table and secondary
//    index that was accessed. Note that some operations, such as GetItem and
//    BatchGetItem, do not access any indexes at all. In these cases, specifying
//    INDEXES will only return ConsumedCapacity information for table(s).
//
//    * TOTAL - The response includes only the aggregate ConsumedCapacity for
//    the operation.
//
//    * NONE - No ConsumedCapacity details are included in the response.
const (
	// ReturnConsumedCapacityIndexes is a ReturnConsumedCapacity enum value
	ReturnConsumedCapacityIndexes = "INDEXES"

	// ReturnConsumedCapacityTotal is a ReturnConsumedCapacity enum value
	ReturnConsumedCapacityTotal = "TOTAL"

	// ReturnConsumedCapacityNone is a ReturnConsumedCapacity enum value
	ReturnConsumedCapacityNone = "NONE"
)

const (
	// ReturnItemCollectionMetricsSize is a ReturnItemCollectionMetrics enum value
	ReturnItemCollectionMetricsSize = "SIZE"

	// ReturnItemCollectionMetricsNone is a ReturnItemCollectionMetrics enum value
	ReturnItemCollectionMetricsNone = "NONE"
)

const (
	// ReturnValueNone is a ReturnValue enum value
	ReturnValueNone = "NONE"

	// ReturnValueAllOld is a ReturnValue enum value
	ReturnValueAllOld = "ALL_OLD"

	// ReturnValueUpdatedOld is a ReturnValue enum value
	ReturnValueUpdatedOld = "UPDATED_OLD"

	// ReturnValueAllNew is a ReturnValue enum value
	ReturnValueAllNew = "ALL_NEW"

	// ReturnValueUpdatedNew is a ReturnValue enum value
	ReturnValueUpdatedNew = "UPDATED_NEW"
)

const (
	// ReturnValuesOnConditionCheckFailureAllOld is a ReturnValuesOnConditionCheckFailure enum value
	ReturnValuesOnConditionCheckFailureAllOld = "ALL_OLD"

	// ReturnValuesOnConditionCheckFailureNone is a ReturnValuesOnConditionCheckFailure enum value
	ReturnValuesOnConditionCheckFailureNone = "NONE"
)

const (
	// SSEStatusEnabling is a SSEStatus enum value
	SSEStatusEnabling = "ENABLING"

	// SSEStatusEnabled is a SSEStatus enum value
	SSEStatusEnabled = "ENABLED"

	// SSEStatusDisabling is a SSEStatus enum value
	SSEStatusDisabling = "DISABLING"

	// SSEStatusDisabled is a SSEStatus enum value
	SSEStatusDisabled = "DISABLED"

	// SSEStatusUpdating is a SSEStatus enum value
	SSEStatusUpdating = "UPDATING"
)

const (
	// SSETypeAes256 is a SSEType enum value
	SSETypeAes256 = "AES256"

	// SSETypeKms is a SSEType enum value
	SSETypeKms = "KMS"
)

const (
	// ScalarAttributeTypeS is a ScalarAttributeType enum value
	ScalarAttributeTypeS = "S"

	// ScalarAttributeTypeN is a ScalarAttributeType enum value
	ScalarAttributeTypeN = "N"

	// ScalarAttributeTypeB is a ScalarAttributeType enum value
	ScalarAttributeTypeB = "B"
)

const (
	// SelectAllAttributes is a Select enum value
	SelectAllAttributes = "ALL_ATTRIBUTES"

	// SelectAllProjectedAttributes is a Select enum value
	SelectAllProjectedAttributes = "ALL_PROJECTED_ATTRIBUTES"

	// SelectSpecificAttributes is a Select enum value
	SelectSpecificAttributes = "SPECIFIC_ATTRIBUTES"

	// SelectCount is a Select enum value
	SelectCount = "COUNT"
)

const (
	// StreamViewTypeNewImage is a StreamViewType enum value
	StreamViewTypeNewImage = "NEW_IMAGE"

	// StreamViewTypeOldImage is a StreamViewType enum value
	StreamViewTypeOldImage = "OLD_IMAGE"

	// StreamViewTypeNewAndOldImages is a StreamViewType enum value
	StreamViewTypeNewAndOldImages = "NEW_AND_OLD_IMAGES"

	// StreamViewTypeKeysOnly is a StreamViewType enum value
	StreamViewTypeKeysOnly = "KEYS_ONLY"
)

const (
	// TableStatusCreating is a TableStatus enum value
	TableStatusCreating = "CREATING"

	// TableStatusUpdating is a TableStatus enum value
	TableStatusUpdating = "UPDATING"

	// TableStatusDeleting is a TableStatus enum value
	TableStatusDeleting = "DELETING"

	// TableStatusActive is a TableStatus enum value
	TableStatusActive = "ACTIVE"

	// TableStatusInaccessibleEncryptionCredentials is a TableStatus enum value
	TableStatusInaccessibleEncryptionCredentials = "INACCESSIBLE_ENCRYPTION_CREDENTIALS"

	// TableStatusArchiving is a TableStatus enum value
	TableStatusArchiving = "ARCHIVING"

	// TableStatusArchived is a TableStatus enum value
	TableStatusArchived = "ARCHIVED"
)

const (
	// TimeToLiveStatusEnabling is a TimeToLiveStatus enum value
	TimeToLiveStatusEnabling = "ENABLING"

	// TimeToLiveStatusDisabling is a TimeToLiveStatus enum value
	TimeToLiveStatusDisabling = "DISABLING"

	// TimeToLiveStatusEnabled is a TimeToLiveStatus enum value
	TimeToLiveStatusEnabled = "ENABLED"

	// TimeToLiveStatusDisabled is a TimeToLiveStatus enum value
	TimeToLiveStatusDisabled = "DISABLED"
)
