%javamethodmodifiers lpx_put_solution(glp_prob *lp, int inval, const int *p_stat, const int *d_stat, const double *obj_val, const int r_stat[], const double r_prim[], const double r_dual[], const int c_stat[], const double c_prim[], const double c_dual[]) "
/**
 * lpx_put_solution - store basic solution components .
 * <p>SYNOPSIS</p>
 * <p>void lpx_put_solution(glp_prob *lp, int inval, const int *p_stat, const int *d_stat, const double *obj_val, const int r_stat[], const double r_prim[], const double r_dual[], const int c_stat[], const double c_prim[], const double c_dual[])</p>
 * <p>DESCRIPTION</p>
 * <p>The routine lpx_put_solution stores basic solution components to the specified problem object.</p>
 * <p>The parameter inval is the basis factorization invalidity flag. If this flag is clear, the current status of the basis factorization remains unchanged. If this flag is set, the routine invalidates the basis factorization.</p>
 * <p>The parameter p_stat is a pointer to the status of primal basic solution, which should be specified as follows:</p>
 * <p>GLP_UNDEF - primal solution is undefined; GLP_FEAS - primal solution is feasible; GLP_INFEAS - primal solution is infeasible; GLP_NOFEAS - no primal feasible solution exists.</p>
 * <p>If the parameter p_stat is NULL, the current status of primal basic solution remains unchanged.</p>
 * <p>The parameter d_stat is a pointer to the status of dual basic solution, which should be specified as follows:</p>
 * <p>GLP_UNDEF - dual solution is undefined; GLP_FEAS - dual solution is feasible; GLP_INFEAS - dual solution is infeasible; GLP_NOFEAS - no dual feasible solution exists.</p>
 * <p>If the parameter d_stat is NULL, the current status of dual basic solution remains unchanged.</p>
 * <p>The parameter obj_val is a pointer to the objective function value. If it is NULL, the current value of the objective function remains unchanged.</p>
 * <p>The array element r_stat[i], 1 <= i <= m (where m is the number of rows in the problem object), specifies the status of i-th auxiliary variable, which should be specified as follows:</p>
 * <p>GLP_BS - basic variable; GLP_NL - non-basic variable on lower bound; GLP_NU - non-basic variable on upper bound; GLP_NF - non-basic free variable; GLP_NS - non-basic fixed variable.</p>
 * <p>If the parameter r_stat is NULL, the current statuses of auxiliary variables remain unchanged.</p>
 * <p>The array element r_prim[i], 1 <= i <= m (where m is the number of rows in the problem object), specifies a primal value of i-th auxiliary variable. If the parameter r_prim is NULL, the current primal values of auxiliary variables remain unchanged.</p>
 * <p>The array element r_dual[i], 1 <= i <= m (where m is the number of rows in the problem object), specifies a dual value (reduced cost) of i-th auxiliary variable. If the parameter r_dual is NULL, the current dual values of auxiliary variables remain unchanged.</p>
 * <p>The array element c_stat[j], 1 <= j <= n (where n is the number of columns in the problem object), specifies the status of j-th structural variable, which should be specified as follows:</p>
 * <p>GLP_BS - basic variable; GLP_NL - non-basic variable on lower bound; GLP_NU - non-basic variable on upper bound; GLP_NF - non-basic free variable; GLP_NS - non-basic fixed variable.</p>
 * <p>If the parameter c_stat is NULL, the current statuses of structural variables remain unchanged.</p>
 * <p>The array element c_prim[j], 1 <= j <= n (where n is the number of columns in the problem object), specifies a primal value of j-th structural variable. If the parameter c_prim is NULL, the current primal values of structural variables remain unchanged.</p>
 * <p>The array element c_dual[j], 1 <= j <= n (where n is the number of columns in the problem object), specifies a dual value (reduced cost) of j-th structural variable. If the parameter c_dual is NULL, the current dual values of structural variables remain unchanged. </p>
 */
public";

%javamethodmodifiers lpx_put_mip_soln(LPX *lp, int i_stat, double row_mipx[], double col_mipx[]) "
/**
 */
public";

%javamethodmodifiers _glp_analyze_row(glp_prob *P, int len, const int ind[], const double val[], int type, double rhs, double eps, int *_piv, double *_x, double *_dx, double *_y, double *_dy, double *_dz) "
/**
 * glp_analyze_row - simulate one iteration of dual simplex method .
 * <p>SYNOPSIS</p>
 * <p>int glp_analyze_row(glp_prob *P, int len, const int ind[], const double val[], int type, double rhs, double eps, int *piv, double *x, double *dx, double *y, double *dy, double *dz);</p>
 * <p>DESCRIPTION</p>
 * <p>Let the current basis be optimal or dual feasible, and there be specified a row (constraint), which is violated by the current basic solution. The routine glp_analyze_row simulates one iteration of the dual simplex method to determine some information on the adjacent basis (see below), where the specified row becomes active constraint (i.e. its auxiliary variable becomes non-basic).</p>
 * <p>The current basic solution associated with the problem object passed to the routine must be dual feasible, and its primal components must be defined.</p>
 * <p>The row to be analyzed must be previously transformed either with the routine glp_eval_tab_row (if the row is in the problem object) or with the routine glp_transform_row (if the row is external, i.e. not in the problem object). This is needed to express the row only through (auxiliary and structural) variables, which are non-basic in the current basis:</p>
 * <p>y = alfa[1] * xN[1] + alfa[2] * xN[2] + ... + alfa[n] * xN[n],</p>
 * <p>where y is an auxiliary variable of the row, alfa[j] is an influence coefficient, xN[j] is a non-basic variable.</p>
 * <p>The row is passed to the routine in sparse format. Ordinal numbers of non-basic variables are stored in locations ind[1], ..., ind[len], where numbers 1 to m denote auxiliary variables while numbers m+1 to m+n denote structural variables. Corresponding non-zero coefficients alfa[j] are stored in locations val[1], ..., val[len]. The arrays ind and val are ot changed on exit.</p>
 * <p>The parameters type and rhs specify the row type and its right-hand side as follows:</p>
 * <p>type = GLP_LO: y = sum alfa[j] * xN[j] >= rhs</p>
 * <p>type = GLP_UP: y = sum alfa[j] * xN[j] <= rhs</p>
 * <p>The parameter eps is an absolute tolerance (small positive number) used by the routine to skip small coefficients alfa[j] on performing the dual ratio test.</p>
 * <p>If the operation was successful, the routine stores the following information to corresponding location (if some parameter is NULL, its value is not stored):</p>
 * <p>piv index in the array ind and val, 1 <= piv <= len, determining the non-basic variable, which would enter the adjacent basis;</p>
 * <p>x value of the non-basic variable in the current basis;</p>
 * <p>dx difference between values of the non-basic variable in the adjacent and current bases, dx = x.new - x.old;</p>
 * <p>y value of the row (i.e. of its auxiliary variable) in the current basis;</p>
 * <p>dy difference between values of the row in the adjacent and current bases, dy = y.new - y.old;</p>
 * <p>dz difference between values of the objective function in the adjacent and current bases, dz = z.new - z.old. Note that in case of minimization dz >= 0, and in case of maximization dz <= 0, i.e. in the adjacent basis the objective function always gets worse (degrades). </p>
 */
public";

%javamethodmodifiers _glp_mpl_init_rand(glp_tran *tran, int seed) "
/**
 */
public";

%javamethodmodifiers glp_skpgen(int n, int r, int type, int v, int s, int a[], int *b, int c[]) "
/**
 */
public";

%javamethodmodifiers _glp_intopt1(glp_prob *P, const glp_iocp *parm) "
/**
 */
public";

%javamethodmodifiers create_prob(glp_prob *lp) "
/**
 * glp_create_prob - create problem object .
 * <p>SYNOPSIS</p>
 * <p>glp_prob *glp_create_prob(void);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_create_prob creates a new problem object, which is initially \"empty\", i.e. has no rows and columns.</p>
 * <p>RETURNS</p>
 * <p>The routine returns a pointer to the object created, which should be used in any subsequent operations on this object. </p>
 */
public";

%javamethodmodifiers glp_create_prob(void) "
/**
 */
public";

%javamethodmodifiers glp_set_prob_name(glp_prob *lp, const char *name) "
/**
 * glp_set_prob_name - assign (change) problem name .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_prob_name(glp_prob *lp, const char *name);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_prob_name assigns a given symbolic name (1 up to 255 characters) to the specified problem object.</p>
 * <p>If the parameter name is NULL or empty string, the routine erases an existing symbolic name of the problem object. </p>
 */
public";

%javamethodmodifiers glp_set_obj_name(glp_prob *lp, const char *name) "
/**
 * glp_set_obj_name - assign (change) objective function name .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_obj_name(glp_prob *lp, const char *name);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_obj_name assigns a given symbolic name (1 up to 255 characters) to the objective function of the specified problem object.</p>
 * <p>If the parameter name is NULL or empty string, the routine erases an existing name of the objective function. </p>
 */
public";

%javamethodmodifiers glp_set_obj_dir(glp_prob *lp, int dir) "
/**
 * glp_set_obj_dir - set (change) optimization direction flag .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_obj_dir(glp_prob *lp, int dir);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_obj_dir sets (changes) optimization direction flag (i.e. \"sense\" of the objective function) as specified by the parameter dir:</p>
 * <p>GLP_MIN - minimization; GLP_MAX - maximization. </p>
 */
public";

%javamethodmodifiers glp_add_rows(glp_prob *lp, int nrs) "
/**
 * glp_add_rows - add new rows to problem object .
 * <p>SYNOPSIS</p>
 * <p>int glp_add_rows(glp_prob *lp, int nrs);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_add_rows adds nrs rows (constraints) to the specified problem object. New rows are always added to the end of the row list, so the ordinal numbers of existing rows remain unchanged.</p>
 * <p>Being added each new row is initially free (unbounded) and has empty list of the constraint coefficients.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_add_rows returns the ordinal number of the first new row added to the problem object. </p>
 */
public";

%javamethodmodifiers glp_add_cols(glp_prob *lp, int ncs) "
/**
 * glp_add_cols - add new columns to problem object .
 * <p>SYNOPSIS</p>
 * <p>int glp_add_cols(glp_prob *lp, int ncs);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_add_cols adds ncs columns (structural variables) to the specified problem object. New columns are always added to the end of the column list, so the ordinal numbers of existing columns remain unchanged.</p>
 * <p>Being added each new column is initially fixed at zero and has empty list of the constraint coefficients.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_add_cols returns the ordinal number of the first new column added to the problem object. </p>
 */
public";

%javamethodmodifiers glp_set_row_name(glp_prob *lp, int i, const char *name) "
/**
 * glp_set_row_name - assign (change) row name .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_row_name(glp_prob *lp, int i, const char *name);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_row_name assigns a given symbolic name (1 up to 255 characters) to i-th row (auxiliary variable) of the specified problem object.</p>
 * <p>If the parameter name is NULL or empty string, the routine erases an existing name of i-th row. </p>
 */
public";

%javamethodmodifiers glp_set_col_name(glp_prob *lp, int j, const char *name) "
/**
 * glp_set_col_name - assign (change) column name .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_col_name(glp_prob *lp, int j, const char *name);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_col_name assigns a given symbolic name (1 up to 255 characters) to j-th column (structural variable) of the specified problem object.</p>
 * <p>If the parameter name is NULL or empty string, the routine erases an existing name of j-th column. </p>
 */
public";

%javamethodmodifiers glp_set_row_bnds(glp_prob *lp, int i, int type, double lb, double ub) "
/**
 * glp_set_row_bnds - set (change) row bounds .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_row_bnds(glp_prob *lp, int i, int type, double lb, double ub);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_row_bnds sets (changes) the type and bounds of i-th row (auxiliary variable) of the specified problem object.</p>
 * <p>Parameters type, lb, and ub specify the type, lower bound, and upper bound, respectively, as follows:</p>
 * <p>Type Bounds Comments ------------------------------------------------------ GLP_FR -inf < x < +inf Free variable GLP_LO lb <= x < +inf Variable with lower bound GLP_UP -inf < x <= ub Variable with upper bound GLP_DB lb <= x <= ub Double-bounded variable GLP_FX x = lb Fixed variable</p>
 * <p>where x is the auxiliary variable associated with i-th row.</p>
 * <p>If the row has no lower bound, the parameter lb is ignored. If the row has no upper bound, the parameter ub is ignored. If the row is an equality constraint (i.e. the corresponding auxiliary variable is of fixed type), only the parameter lb is used while the parameter ub is ignored. </p>
 */
public";

%javamethodmodifiers glp_set_col_bnds(glp_prob *lp, int j, int type, double lb, double ub) "
/**
 * glp_set_col_bnds - set (change) column bounds .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_col_bnds(glp_prob *lp, int j, int type, double lb, double ub);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_col_bnds sets (changes) the type and bounds of j-th column (structural variable) of the specified problem object.</p>
 * <p>Parameters type, lb, and ub specify the type, lower bound, and upper bound, respectively, as follows:</p>
 * <p>Type Bounds Comments ------------------------------------------------------ GLP_FR -inf < x < +inf Free variable GLP_LO lb <= x < +inf Variable with lower bound GLP_UP -inf < x <= ub Variable with upper bound GLP_DB lb <= x <= ub Double-bounded variable GLP_FX x = lb Fixed variable</p>
 * <p>where x is the structural variable associated with j-th column.</p>
 * <p>If the column has no lower bound, the parameter lb is ignored. If the column has no upper bound, the parameter ub is ignored. If the column is of fixed type, only the parameter lb is used while the parameter ub is ignored. </p>
 */
public";

%javamethodmodifiers glp_set_obj_coef(glp_prob *lp, int j, double coef) "
/**
 * glp_set_obj_coef - set (change) obj. .
 * <p>coefficient or constant term</p>
 * <p>SYNOPSIS</p>
 * <p>void glp_set_obj_coef(glp_prob *lp, int j, double coef);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_obj_coef sets (changes) objective coefficient at j-th column (structural variable) of the specified problem object.</p>
 * <p>If the parameter j is 0, the routine sets (changes) the constant term (\"shift\") of the objective function. </p>
 */
public";

%javamethodmodifiers glp_set_mat_row(glp_prob *lp, int i, int len, const int ind[], const double val[]) "
/**
 * glp_set_mat_row - set (replace) row of the constraint matrix .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_mat_row(glp_prob *lp, int i, int len, const int ind[], const double val[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_mat_row stores (replaces) the contents of i-th row of the constraint matrix of the specified problem object.</p>
 * <p>Column indices and numeric values of new row elements must be placed in locations ind[1], ..., ind[len] and val[1], ..., val[len], where 0 <= len <= n is the new length of i-th row, n is the current number of columns in the problem object. Elements with identical column indices are not allowed. Zero elements are allowed, but they are not stored in the constraint matrix.</p>
 * <p>If the parameter len is zero, the parameters ind and/or val can be specified as NULL. </p>
 */
public";

%javamethodmodifiers glp_set_mat_col(glp_prob *lp, int j, int len, const int ind[], const double val[]) "
/**
 * glp_set_mat_col - set (replace) column of the constraint matrix .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_mat_col(glp_prob *lp, int j, int len, const int ind[], const double val[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_mat_col stores (replaces) the contents of j-th column of the constraint matrix of the specified problem object.</p>
 * <p>Row indices and numeric values of new column elements must be placed in locations ind[1], ..., ind[len] and val[1], ..., val[len], where 0 <= len <= m is the new length of j-th column, m is the current number of rows in the problem object. Elements with identical column indices are not allowed. Zero elements are allowed, but they are not stored in the constraint matrix.</p>
 * <p>If the parameter len is zero, the parameters ind and/or val can be specified as NULL. </p>
 */
public";

%javamethodmodifiers glp_load_matrix(glp_prob *lp, int ne, const int ia[], const int ja[], const double ar[]) "
/**
 * glp_load_matrix - load (replace) the whole constraint matrix .
 * <p>SYNOPSIS</p>
 * <p>void glp_load_matrix(glp_prob *lp, int ne, const int ia[], const int ja[], const double ar[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_load_matrix loads the constraint matrix passed in the arrays ia, ja, and ar into the specified problem object. Before loading the current contents of the constraint matrix is destroyed.</p>
 * <p>Constraint coefficients (elements of the constraint matrix) must be specified as triplets (ia[k], ja[k], ar[k]) for k = 1, ..., ne, where ia[k] is the row index, ja[k] is the column index, ar[k] is a numeric value of corresponding constraint coefficient. The parameter ne specifies the total number of (non-zero) elements in the matrix to be loaded. Coefficients with identical indices are not allowed. Zero coefficients are allowed, however, they are not stored in the constraint matrix.</p>
 * <p>If the parameter ne is zero, the parameters ia, ja, and ar can be specified as NULL. </p>
 */
public";

%javamethodmodifiers glp_check_dup(int m, int n, int ne, const int ia[], const int ja[]) "
/**
 * glp_check_dup - check for duplicate elements in sparse matrix .
 * <p>SYNOPSIS</p>
 * <p>int glp_check_dup(int m, int n, int ne, const int ia[], const int ja[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_check_dup checks for duplicate elements (that is, elements with identical indices) in a sparse matrix specified in the coordinate format.</p>
 * <p>The parameters m and n specifies, respectively, the number of rows and columns in the matrix, m >= 0, n >= 0.</p>
 * <p>The parameter ne specifies the number of (structurally) non-zero elements in the matrix, ne >= 0.</p>
 * <p>Elements of the matrix are specified as doublets (ia[k],ja[k]) for k = 1,...,ne, where ia[k] is a row index, ja[k] is a column index.</p>
 * <p>The routine glp_check_dup can be used prior to a call to the routine glp_load_matrix to check that the constraint matrix to be loaded has no duplicate elements.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_check_dup returns one of the following values:</p>
 * <p>0 - the matrix has no duplicate elements;</p>
 * <p>-k - indices ia[k] or/and ja[k] are out of range;</p>
 * <p>+k - element (ia[k],ja[k]) is duplicate. </p>
 */
public";

%javamethodmodifiers glp_sort_matrix(glp_prob *P) "
/**
 * glp_sort_matrix - sort elements of the constraint matrix .
 * <p>SYNOPSIS</p>
 * <p>void glp_sort_matrix(glp_prob *P);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_sort_matrix sorts elements of the constraint matrix rebuilding its row and column linked lists. On exit from the routine the constraint matrix is not changed, however, elements in the row linked lists become ordered by ascending column indices, and the elements in the column linked lists become ordered by ascending row indices. </p>
 */
public";

%javamethodmodifiers glp_del_rows(glp_prob *lp, int nrs, const int num[]) "
/**
 * glp_del_rows - delete rows from problem object .
 * <p>SYNOPSIS</p>
 * <p>void glp_del_rows(glp_prob *lp, int nrs, const int num[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_del_rows deletes rows from the specified problem object. Ordinal numbers of rows to be deleted should be placed in locations num[1], ..., num[nrs], where nrs > 0.</p>
 * <p>Note that deleting rows involves changing ordinal numbers of other rows remaining in the problem object. New ordinal numbers of the remaining rows are assigned under the assumption that the original order of rows is not changed. </p>
 */
public";

%javamethodmodifiers glp_del_cols(glp_prob *lp, int ncs, const int num[]) "
/**
 * glp_del_cols - delete columns from problem object .
 * <p>SYNOPSIS</p>
 * <p>void glp_del_cols(glp_prob *lp, int ncs, const int num[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_del_cols deletes columns from the specified problem object. Ordinal numbers of columns to be deleted should be placed in locations num[1], ..., num[ncs], where ncs > 0.</p>
 * <p>Note that deleting columns involves changing ordinal numbers of other columns remaining in the problem object. New ordinal numbers of the remaining columns are assigned under the assumption that the original order of columns is not changed. </p>
 */
public";

%javamethodmodifiers glp_copy_prob(glp_prob *dest, glp_prob *prob, int names) "
/**
 * glp_copy_prob - copy problem object content .
 * <p>SYNOPSIS</p>
 * <p>void glp_copy_prob(glp_prob *dest, glp_prob *prob, int names);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_copy_prob copies the content of the problem object prob to the problem object dest.</p>
 * <p>The parameter names is a flag. If it is non-zero, the routine also copies all symbolic names; otherwise, if it is zero, symbolic names are not copied. </p>
 */
public";

%javamethodmodifiers delete_prob(glp_prob *lp) "
/**
 * glp_erase_prob - erase problem object content .
 * <p>glp_delete_prob - delete problem object</p>
 * <p>SYNOPSIS</p>
 * <p>void glp_erase_prob(glp_prob *lp);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_erase_prob erases the content of the specified problem object. The effect of this operation is the same as if the problem object would be deleted with the routine glp_delete_prob and then created anew with the routine glp_create_prob, with exception that the handle (pointer) to the problem object remains valid.</p>
 * <p>SYNOPSIS</p>
 * <p>void glp_delete_prob(glp_prob *lp);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_delete_prob deletes the specified problem object and frees all the memory allocated to it. </p>
 */
public";

%javamethodmodifiers glp_erase_prob(glp_prob *lp) "
/**
 */
public";

%javamethodmodifiers glp_delete_prob(glp_prob *lp) "
/**
 */
public";

%javamethodmodifiers glp_get_prob_name(glp_prob *lp) "
/**
 * glp_get_prob_name - retrieve problem name .
 * <p>SYNOPSIS</p>
 * <p>const char *glp_get_prob_name(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_prob_name returns a pointer to an internal buffer, which contains symbolic name of the problem. However, if the problem has no assigned name, the routine returns NULL. </p>
 */
public";

%javamethodmodifiers glp_get_obj_name(glp_prob *lp) "
/**
 * glp_get_obj_name - retrieve objective function name .
 * <p>SYNOPSIS</p>
 * <p>const char *glp_get_obj_name(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_obj_name returns a pointer to an internal buffer, which contains a symbolic name of the objective function. However, if the objective function has no assigned name, the routine returns NULL. </p>
 */
public";

%javamethodmodifiers glp_get_obj_dir(glp_prob *lp) "
/**
 * glp_get_obj_dir - retrieve optimization direction flag .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_obj_dir(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_obj_dir returns the optimization direction flag (i.e. \"sense\" of the objective function):</p>
 * <p>GLP_MIN - minimization; GLP_MAX - maximization. </p>
 */
public";

%javamethodmodifiers glp_get_num_rows(glp_prob *lp) "
/**
 * glp_get_num_rows - retrieve number of rows .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_num_rows(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_num_rows returns the current number of rows in the specified problem object. </p>
 */
public";

%javamethodmodifiers glp_get_num_cols(glp_prob *lp) "
/**
 * glp_get_num_cols - retrieve number of columns .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_num_cols(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_num_cols returns the current number of columns in the specified problem object. </p>
 */
public";

%javamethodmodifiers glp_get_row_name(glp_prob *lp, int i) "
/**
 * glp_get_row_name - retrieve row name .
 * <p>SYNOPSIS</p>
 * <p>const char *glp_get_row_name(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_row_name returns a pointer to an internal buffer, which contains symbolic name of i-th row. However, if i-th row has no assigned name, the routine returns NULL. </p>
 */
public";

%javamethodmodifiers glp_get_col_name(glp_prob *lp, int j) "
/**
 * glp_get_col_name - retrieve column name .
 * <p>SYNOPSIS</p>
 * <p>const char *glp_get_col_name(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_col_name returns a pointer to an internal buffer, which contains symbolic name of j-th column. However, if j-th column has no assigned name, the routine returns NULL. </p>
 */
public";

%javamethodmodifiers glp_get_row_type(glp_prob *lp, int i) "
/**
 * glp_get_row_type - retrieve row type .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_row_type(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_row_type returns the type of i-th row, i.e. the type of corresponding auxiliary variable, as follows:</p>
 * <p>GLP_FR - free (unbounded) variable; GLP_LO - variable with lower bound; GLP_UP - variable with upper bound; GLP_DB - double-bounded variable; GLP_FX - fixed variable. </p>
 */
public";

%javamethodmodifiers glp_get_row_lb(glp_prob *lp, int i) "
/**
 * glp_get_row_lb - retrieve row lower bound .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_row_lb(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_row_lb returns the lower bound of i-th row, i.e. the lower bound of corresponding auxiliary variable. However, if the row has no lower bound, the routine returns -DBL_MAX. </p>
 */
public";

%javamethodmodifiers glp_get_row_ub(glp_prob *lp, int i) "
/**
 * glp_get_row_ub - retrieve row upper bound .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_row_ub(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_row_ub returns the upper bound of i-th row, i.e. the upper bound of corresponding auxiliary variable. However, if the row has no upper bound, the routine returns +DBL_MAX. </p>
 */
public";

%javamethodmodifiers glp_get_col_type(glp_prob *lp, int j) "
/**
 * glp_get_col_type - retrieve column type .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_col_type(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_col_type returns the type of j-th column, i.e. the type of corresponding structural variable, as follows:</p>
 * <p>GLP_FR - free (unbounded) variable; GLP_LO - variable with lower bound; GLP_UP - variable with upper bound; GLP_DB - double-bounded variable; GLP_FX - fixed variable. </p>
 */
public";

%javamethodmodifiers glp_get_col_lb(glp_prob *lp, int j) "
/**
 * glp_get_col_lb - retrieve column lower bound .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_col_lb(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_col_lb returns the lower bound of j-th column, i.e. the lower bound of corresponding structural variable. However, if the column has no lower bound, the routine returns -DBL_MAX. </p>
 */
public";

%javamethodmodifiers glp_get_col_ub(glp_prob *lp, int j) "
/**
 * glp_get_col_ub - retrieve column upper bound .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_col_ub(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_col_ub returns the upper bound of j-th column, i.e. the upper bound of corresponding structural variable. However, if the column has no upper bound, the routine returns +DBL_MAX. </p>
 */
public";

%javamethodmodifiers glp_get_obj_coef(glp_prob *lp, int j) "
/**
 * glp_get_obj_coef - retrieve obj. .
 * <p>coefficient or constant term</p>
 * <p>SYNOPSIS</p>
 * <p>double glp_get_obj_coef(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_obj_coef returns the objective coefficient at j-th structural variable (column) of the specified problem object.</p>
 * <p>If the parameter j is zero, the routine returns the constant term (\"shift\") of the objective function. </p>
 */
public";

%javamethodmodifiers glp_get_num_nz(glp_prob *lp) "
/**
 * glp_get_num_nz - retrieve number of constraint coefficients .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_num_nz(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_num_nz returns the number of (non-zero) elements in the constraint matrix of the specified problem object. </p>
 */
public";

%javamethodmodifiers glp_get_mat_row(glp_prob *lp, int i, int ind[], double val[]) "
/**
 * glp_get_mat_row - retrieve row of the constraint matrix .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_mat_row(glp_prob *lp, int i, int ind[], double val[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_get_mat_row scans (non-zero) elements of i-th row of the constraint matrix of the specified problem object and stores their column indices and numeric values to locations ind[1], ..., ind[len] and val[1], ..., val[len], respectively, where 0 <= len <= n is the number of elements in i-th row, n is the number of columns.</p>
 * <p>The parameter ind and/or val can be specified as NULL, in which case corresponding information is not stored.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_mat_row returns the length len, i.e. the number of (non-zero) elements in i-th row. </p>
 */
public";

%javamethodmodifiers glp_get_mat_col(glp_prob *lp, int j, int ind[], double val[]) "
/**
 * glp_get_mat_col - retrieve column of the constraint matrix .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_mat_col(glp_prob *lp, int j, int ind[], double val[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_get_mat_col scans (non-zero) elements of j-th column of the constraint matrix of the specified problem object and stores their row indices and numeric values to locations ind[1], ..., ind[len] and val[1], ..., val[len], respectively, where 0 <= len <= m is the number of elements in j-th column, m is the number of rows.</p>
 * <p>The parameter ind or/and val can be specified as NULL, in which case corresponding information is not stored.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_mat_col returns the length len, i.e. the number of (non-zero) elements in j-th column. </p>
 */
public";

%javamethodmodifiers glp_create_index(glp_prob *lp) "
/**
 * glp_create_index - create the name index .
 * <p>SYNOPSIS</p>
 * <p>void glp_create_index(glp_prob *lp);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_create_index creates the name index for the specified problem object. The name index is an auxiliary data structure, which is intended to quickly (i.e. for logarithmic time) find rows and columns by their names.</p>
 * <p>This routine can be called at any time. If the name index already exists, the routine does nothing. </p>
 */
public";

%javamethodmodifiers glp_find_row(glp_prob *lp, const char *name) "
/**
 * glp_find_row - find row by its name .
 * <p>SYNOPSIS</p>
 * <p>int glp_find_row(glp_prob *lp, const char *name);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_find_row returns the ordinal number of a row, which is assigned (by the routine glp_set_row_name) the specified symbolic name. If no such row exists, the routine returns 0. </p>
 */
public";

%javamethodmodifiers glp_find_col(glp_prob *lp, const char *name) "
/**
 * glp_find_col - find column by its name .
 * <p>SYNOPSIS</p>
 * <p>int glp_find_col(glp_prob *lp, const char *name);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_find_col returns the ordinal number of a column, which is assigned (by the routine glp_set_col_name) the specified symbolic name. If no such column exists, the routine returns 0. </p>
 */
public";

%javamethodmodifiers glp_delete_index(glp_prob *lp) "
/**
 * glp_delete_index - delete the name index .
 * <p>SYNOPSIS</p>
 * <p>void glp_delete_index(glp_prob *lp);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_delete_index deletes the name index previously created by the routine glp_create_index and frees the memory allocated to this auxiliary data structure.</p>
 * <p>This routine can be called at any time. If the name index does not exist, the routine does nothing. </p>
 */
public";

%javamethodmodifiers glp_set_rii(glp_prob *lp, int i, double rii) "
/**
 * glp_set_rii - set (change) row scale factor .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_rii(glp_prob *lp, int i, double rii);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_rii sets (changes) the scale factor r[i,i] for i-th row of the specified problem object. </p>
 */
public";

%javamethodmodifiers glp_set_sjj(glp_prob *lp, int j, double sjj) "
/**
 * glp_set sjj - set (change) column scale factor .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_sjj(glp_prob *lp, int j, double sjj);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_sjj sets (changes) the scale factor s[j,j] for j-th column of the specified problem object. </p>
 */
public";

%javamethodmodifiers glp_get_rii(glp_prob *lp, int i) "
/**
 * glp_get_rii - retrieve row scale factor .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_rii(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_rii returns current scale factor r[i,i] for i-th row of the specified problem object. </p>
 */
public";

%javamethodmodifiers glp_get_sjj(glp_prob *lp, int j) "
/**
 * glp_get_sjj - retrieve column scale factor .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_sjj(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_sjj returns current scale factor s[j,j] for j-th column of the specified problem object. </p>
 */
public";

%javamethodmodifiers glp_unscale_prob(glp_prob *lp) "
/**
 * glp_unscale_prob - unscale problem data .
 * <p>SYNOPSIS</p>
 * <p>void glp_unscale_prob(glp_prob *lp);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_unscale_prob performs unscaling of problem data for the specified problem object.</p>
 * <p>\"Unscaling\" means replacing the current scaling matrices R and S by unity matrices that cancels the scaling effect. </p>
 */
public";

%javamethodmodifiers glp_set_row_stat(glp_prob *lp, int i, int stat) "
/**
 * glp_set_row_stat - set (change) row status .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_row_stat(glp_prob *lp, int i, int stat);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_row_stat sets (changes) status of the auxiliary variable associated with i-th row.</p>
 * <p>The new status of the auxiliary variable should be specified by the parameter stat as follows:</p>
 * <p>GLP_BS - basic variable; GLP_NL - non-basic variable; GLP_NU - non-basic variable on its upper bound; if the variable is not double-bounded, this means the same as GLP_NL (only in case of this routine); GLP_NF - the same as GLP_NL (only in case of this routine); GLP_NS - the same as GLP_NL (only in case of this routine). </p>
 */
public";

%javamethodmodifiers glp_set_col_stat(glp_prob *lp, int j, int stat) "
/**
 * glp_set_col_stat - set (change) column status .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_col_stat(glp_prob *lp, int j, int stat);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_col_stat sets (changes) status of the structural variable associated with j-th column.</p>
 * <p>The new status of the structural variable should be specified by the parameter stat as follows:</p>
 * <p>GLP_BS - basic variable; GLP_NL - non-basic variable; GLP_NU - non-basic variable on its upper bound; if the variable is not double-bounded, this means the same as GLP_NL (only in case of this routine); GLP_NF - the same as GLP_NL (only in case of this routine); GLP_NS - the same as GLP_NL (only in case of this routine). </p>
 */
public";

%javamethodmodifiers glp_std_basis(glp_prob *lp) "
/**
 * glp_std_basis - construct standard initial LP basis .
 * <p>SYNOPSIS</p>
 * <p>void glp_std_basis(glp_prob *lp);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_std_basis builds the \"standard\" (trivial) initial basis for the specified problem object.</p>
 * <p>In the \"standard\" basis all auxiliary variables are basic, and all structural variables are non-basic. </p>
 */
public";

%javamethodmodifiers trivial_lp(glp_prob *P, const glp_smcp *parm) "
/**
 * glp_simplex - solve LP problem with the simplex method .
 * <p>SYNOPSIS</p>
 * <p>int glp_simplex(glp_prob *P, const glp_smcp *parm);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_simplex is a driver to the LP solver based on the simplex method. This routine retrieves problem data from the specified problem object, calls the solver to solve the problem instance, and stores results of computations back into the problem object.</p>
 * <p>The simplex solver has a set of control parameters. Values of the control parameters can be passed in a structure glp_smcp, which the parameter parm points to.</p>
 * <p>The parameter parm can be specified as NULL, in which case the LP solver uses default settings.</p>
 * <p>RETURNS</p>
 * <p>0 The LP problem instance has been successfully solved. This code does not necessarily mean that the solver has found optimal solution. It only means that the solution process was successful.</p>
 * <p>GLP_EBADB Unable to start the search, because the initial basis specified in the problem object is invalid--the number of basic (auxiliary and structural) variables is not the same as the number of rows in the problem object.</p>
 * <p>GLP_ESING Unable to start the search, because the basis matrix correspodning to the initial basis is singular within the working precision.</p>
 * <p>GLP_ECOND Unable to start the search, because the basis matrix correspodning to the initial basis is ill-conditioned, i.e. its condition number is too large.</p>
 * <p>GLP_EBOUND Unable to start the search, because some double-bounded variables have incorrect bounds.</p>
 * <p>GLP_EFAIL The search was prematurely terminated due to the solver failure.</p>
 * <p>GLP_EOBJLL The search was prematurely terminated, because the objective function being maximized has reached its lower limit and continues decreasing (dual simplex only).</p>
 * <p>GLP_EOBJUL The search was prematurely terminated, because the objective function being minimized has reached its upper limit and continues increasing (dual simplex only).</p>
 * <p>GLP_EITLIM The search was prematurely terminated, because the simplex iteration limit has been exceeded.</p>
 * <p>GLP_ETMLIM The search was prematurely terminated, because the time limit has been exceeded.</p>
 * <p>GLP_ENOPFS The LP problem instance has no primal feasible solution (only if the LP presolver is used).</p>
 * <p>GLP_ENODFS The LP problem instance has no dual feasible solution (only if the LP presolver is used). </p>
 */
public";

%javamethodmodifiers solve_lp(glp_prob *P, const glp_smcp *parm) "
/**
 */
public";

%javamethodmodifiers preprocess_and_solve_lp(glp_prob *P, const glp_smcp *parm) "
/**
 */
public";

%javamethodmodifiers glp_simplex(glp_prob *P, const glp_smcp *parm) "
/**
 */
public";

%javamethodmodifiers glp_init_smcp(glp_smcp *parm) "
/**
 * glp_init_smcp - initialize simplex method control parameters .
 * <p>SYNOPSIS</p>
 * <p>void glp_init_smcp(glp_smcp *parm);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_init_smcp initializes control parameters, which are used by the simplex solver, with default values.</p>
 * <p>Default values of the control parameters are stored in a glp_smcp structure, which the parameter parm points to. </p>
 */
public";

%javamethodmodifiers glp_get_status(glp_prob *lp) "
/**
 * glp_get_status - retrieve generic status of basic solution .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_status(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_status reports the generic status of the basic solution for the specified problem object as follows:</p>
 * <p>GLP_OPT - solution is optimal; GLP_FEAS - solution is feasible; GLP_INFEAS - solution is infeasible; GLP_NOFEAS - problem has no feasible solution; GLP_UNBND - problem has unbounded solution; GLP_UNDEF - solution is undefined. </p>
 */
public";

%javamethodmodifiers glp_get_prim_stat(glp_prob *lp) "
/**
 * glp_get_prim_stat - retrieve status of primal basic solution .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_prim_stat(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_prim_stat reports the status of the primal basic solution for the specified problem object as follows:</p>
 * <p>GLP_UNDEF - primal solution is undefined; GLP_FEAS - primal solution is feasible; GLP_INFEAS - primal solution is infeasible; GLP_NOFEAS - no primal feasible solution exists. </p>
 */
public";

%javamethodmodifiers glp_get_dual_stat(glp_prob *lp) "
/**
 * glp_get_dual_stat - retrieve status of dual basic solution .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_dual_stat(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_dual_stat reports the status of the dual basic solution for the specified problem object as follows:</p>
 * <p>GLP_UNDEF - dual solution is undefined; GLP_FEAS - dual solution is feasible; GLP_INFEAS - dual solution is infeasible; GLP_NOFEAS - no dual feasible solution exists. </p>
 */
public";

%javamethodmodifiers glp_get_obj_val(glp_prob *lp) "
/**
 * glp_get_obj_val - retrieve objective value (basic solution) .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_obj_val(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_obj_val returns value of the objective function for basic solution. </p>
 */
public";

%javamethodmodifiers glp_get_row_stat(glp_prob *lp, int i) "
/**
 * glp_get_row_stat - retrieve row status .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_row_stat(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_row_stat returns current status assigned to the auxiliary variable associated with i-th row as follows:</p>
 * <p>GLP_BS - basic variable; GLP_NL - non-basic variable on its lower bound; GLP_NU - non-basic variable on its upper bound; GLP_NF - non-basic free (unbounded) variable; GLP_NS - non-basic fixed variable. </p>
 */
public";

%javamethodmodifiers glp_get_row_prim(glp_prob *lp, int i) "
/**
 * glp_get_row_prim - retrieve row primal value (basic solution) .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_row_prim(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_row_prim returns primal value of the auxiliary variable associated with i-th row. </p>
 */
public";

%javamethodmodifiers glp_get_row_dual(glp_prob *lp, int i) "
/**
 * glp_get_row_dual - retrieve row dual value (basic solution) .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_row_dual(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_row_dual returns dual value (i.e. reduced cost) of the auxiliary variable associated with i-th row. </p>
 */
public";

%javamethodmodifiers glp_get_col_stat(glp_prob *lp, int j) "
/**
 * glp_get_col_stat - retrieve column status .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_col_stat(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_col_stat returns current status assigned to the structural variable associated with j-th column as follows:</p>
 * <p>GLP_BS - basic variable; GLP_NL - non-basic variable on its lower bound; GLP_NU - non-basic variable on its upper bound; GLP_NF - non-basic free (unbounded) variable; GLP_NS - non-basic fixed variable. </p>
 */
public";

%javamethodmodifiers glp_get_col_prim(glp_prob *lp, int j) "
/**
 * glp_get_col_prim - retrieve column primal value (basic solution) .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_col_prim(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_col_prim returns primal value of the structural variable associated with j-th column. </p>
 */
public";

%javamethodmodifiers glp_get_col_dual(glp_prob *lp, int j) "
/**
 * glp_get_col_dual - retrieve column dual value (basic solution) .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_col_dual(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_col_dual returns dual value (i.e. reduced cost) of the structural variable associated with j-th column. </p>
 */
public";

%javamethodmodifiers glp_get_unbnd_ray(glp_prob *lp) "
/**
 * glp_get_unbnd_ray - determine variable causing unboundedness .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_unbnd_ray(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_unbnd_ray returns the number k of a variable, which causes primal or dual unboundedness. If 1 <= k <= m, it is k-th auxiliary variable, and if m+1 <= k <= m+n, it is (k-m)-th structural variable, where m is the number of rows, n is the number of columns in the problem object. If such variable is not defined, the routine returns 0.</p>
 * <p>COMMENTS</p>
 * <p>If it is not exactly known which version of the simplex solver detected unboundedness, i.e. whether the unboundedness is primal or dual, it is sufficient to check the status of the variable reported with the routine glp_get_row_stat or glp_get_col_stat. If the variable is non-basic, the unboundedness is primal, otherwise, if the variable is basic, the unboundedness is dual (the latter case means that the problem has no primal feasible dolution). </p>
 */
public";

%javamethodmodifiers set_d_eps(mpq_t x, double val) "
/**
 * glp_exact - solve LP problem in exact arithmetic .
 * <p>SYNOPSIS</p>
 * <p>int glp_exact(glp_prob *lp, const glp_smcp *parm);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_exact is a tentative implementation of the primal two-phase simplex method based on exact (rational) arithmetic. It is similar to the routine glp_simplex, however, for all internal computations it uses arithmetic of rational numbers, which is exact in mathematical sense, i.e. free of round-off errors unlike floating point arithmetic.</p>
 * <p>Note that the routine glp_exact uses inly two control parameters passed in the structure glp_smcp, namely, it_lim and tm_lim.</p>
 * <p>RETURNS</p>
 * <p>0 The LP problem instance has been successfully solved. This code does not necessarily mean that the solver has found optimal solution. It only means that the solution process was successful.</p>
 * <p>GLP_EBADB Unable to start the search, because the initial basis specified in the problem object is invalid--the number of basic (auxiliary and structural) variables is not the same as the number of rows in the problem object.</p>
 * <p>GLP_ESING Unable to start the search, because the basis matrix correspodning to the initial basis is exactly singular.</p>
 * <p>GLP_EBOUND Unable to start the search, because some double-bounded variables have incorrect bounds.</p>
 * <p>GLP_EFAIL The problem has no rows/columns.</p>
 * <p>GLP_EITLIM The search was prematurely terminated, because the simplex iteration limit has been exceeded.</p>
 * <p>GLP_ETMLIM The search was prematurely terminated, because the time limit has been exceeded. </p>
 */
public";

%javamethodmodifiers load_data(SSX *ssx, LPX *lp) "
/**
 */
public";

%javamethodmodifiers load_basis(SSX *ssx, LPX *lp) "
/**
 */
public";

%javamethodmodifiers glp_exact(glp_prob *lp, const glp_smcp *parm) "
/**
 */
public";

%javamethodmodifiers transform(NPP *npp) "
/**
 * glp_interior - solve LP problem with the interior-point method .
 * <p>SYNOPSIS</p>
 * <p>int glp_interior(glp_prob *P, const glp_iptcp *parm);</p>
 * <p>The routine glp_interior is a driver to the LP solver based on the interior-point method.</p>
 * <p>The interior-point solver has a set of control parameters. Values of the control parameters can be passed in a structure glp_iptcp, which the parameter parm points to.</p>
 * <p>Currently this routine implements an easy variant of the primal-dual interior-point method based on Mehrotra's technique.</p>
 * <p>This routine transforms the original LP problem to an equivalent LP problem in the standard formulation (all constraints are equalities, all variables are non-negative), calls the routine ipm_main to solve the transformed problem, and then transforms an obtained solution to the solution of the original problem.</p>
 * <p>RETURNS</p>
 * <p>0 The LP problem instance has been successfully solved. This code does not necessarily mean that the solver has found optimal solution. It only means that the solution process was successful.</p>
 * <p>GLP_EFAIL The problem has no rows/columns.</p>
 * <p>GLP_ENOCVG Very slow convergence or divergence.</p>
 * <p>GLP_EITLIM Iteration limit exceeded.</p>
 * <p>GLP_EINSTAB Numerical instability on solving Newtonian system. </p>
 */
public";

%javamethodmodifiers glp_interior(glp_prob *P, const glp_iptcp *parm) "
/**
 */
public";

%javamethodmodifiers glp_init_iptcp(glp_iptcp *parm) "
/**
 * glp_init_iptcp - initialize interior-point solver control parameters .
 * <p>SYNOPSIS</p>
 * <p>void glp_init_iptcp(glp_iptcp *parm);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_init_iptcp initializes control parameters, which are used by the interior-point solver, with default values.</p>
 * <p>Default values of the control parameters are stored in the glp_iptcp structure, which the parameter parm points to. </p>
 */
public";

%javamethodmodifiers glp_ipt_status(glp_prob *lp) "
/**
 * glp_ipt_status - retrieve status of interior-point solution .
 * <p>SYNOPSIS</p>
 * <p>int glp_ipt_status(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ipt_status reports the status of solution found by the interior-point solver as follows:</p>
 * <p>GLP_UNDEF - interior-point solution is undefined; GLP_OPT - interior-point solution is optimal; GLP_INFEAS - interior-point solution is infeasible; GLP_NOFEAS - no feasible solution exists. </p>
 */
public";

%javamethodmodifiers glp_ipt_obj_val(glp_prob *lp) "
/**
 * glp_ipt_obj_val - retrieve objective value (interior point) .
 * <p>SYNOPSIS</p>
 * <p>double glp_ipt_obj_val(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ipt_obj_val returns value of the objective function for interior-point solution. </p>
 */
public";

%javamethodmodifiers glp_ipt_row_prim(glp_prob *lp, int i) "
/**
 * glp_ipt_row_prim - retrieve row primal value (interior point) .
 * <p>SYNOPSIS</p>
 * <p>double glp_ipt_row_prim(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ipt_row_prim returns primal value of the auxiliary variable associated with i-th row. </p>
 */
public";

%javamethodmodifiers glp_ipt_row_dual(glp_prob *lp, int i) "
/**
 * glp_ipt_row_dual - retrieve row dual value (interior point) .
 * <p>SYNOPSIS</p>
 * <p>double glp_ipt_row_dual(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ipt_row_dual returns dual value (i.e. reduced cost) of the auxiliary variable associated with i-th row. </p>
 */
public";

%javamethodmodifiers glp_ipt_col_prim(glp_prob *lp, int j) "
/**
 * glp_ipt_col_prim - retrieve column primal value (interior point) .
 * <p>SYNOPSIS</p>
 * <p>double glp_ipt_col_prim(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ipt_col_prim returns primal value of the structural variable associated with j-th column. </p>
 */
public";

%javamethodmodifiers glp_ipt_col_dual(glp_prob *lp, int j) "
/**
 * glp_ipt_col_dual - retrieve column dual value (interior point) .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplpx.h\" double glp_ipt_col_dual(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ipt_col_dual returns dual value (i.e. reduced cost) of the structural variable associated with j-th column. </p>
 */
public";

%javamethodmodifiers glp_set_col_kind(glp_prob *mip, int j, int kind) "
/**
 * glp_set_col_kind - set (change) column kind .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_col_kind(glp_prob *mip, int j, int kind);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_col_kind sets (changes) the kind of j-th column (structural variable) as specified by the parameter kind:</p>
 * <p>GLP_CV - continuous variable; GLP_IV - integer variable; GLP_BV - binary variable. </p>
 */
public";

%javamethodmodifiers glp_get_col_kind(glp_prob *mip, int j) "
/**
 * glp_get_col_kind - retrieve column kind .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_col_kind(glp_prob *mip, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_col_kind returns the kind of j-th column, i.e. the kind of corresponding structural variable, as follows:</p>
 * <p>GLP_CV - continuous variable; GLP_IV - integer variable; GLP_BV - binary variable </p>
 */
public";

%javamethodmodifiers glp_get_num_int(glp_prob *mip) "
/**
 * glp_get_num_int - retrieve number of integer columns .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_num_int(glp_prob *mip);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_num_int returns the current number of columns, which are marked as integer. </p>
 */
public";

%javamethodmodifiers glp_get_num_bin(glp_prob *mip) "
/**
 * glp_get_num_bin - retrieve number of binary columns .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_num_bin(glp_prob *mip);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_num_bin returns the current number of columns, which are marked as binary. </p>
 */
public";

%javamethodmodifiers solve_mip(glp_prob *P, const glp_iocp *parm) "
/**
 * glp_intopt - solve MIP problem with the branch-and-bound method .
 * <p>SYNOPSIS</p>
 * <p>int glp_intopt(glp_prob *P, const glp_iocp *parm);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_intopt is a driver to the MIP solver based on the branch-and-bound method.</p>
 * <p>On entry the problem object should contain optimal solution to LP relaxation (which can be obtained with the routine glp_simplex).</p>
 * <p>The MIP solver has a set of control parameters. Values of the control parameters can be passed in a structure glp_iocp, which the parameter parm points to.</p>
 * <p>The parameter parm can be specified as NULL, in which case the MIP solver uses default settings.</p>
 * <p>RETURNS</p>
 * <p>0 The MIP problem instance has been successfully solved. This code does not necessarily mean that the solver has found optimal solution. It only means that the solution process was successful.</p>
 * <p>GLP_EBOUND Unable to start the search, because some double-bounded variables have incorrect bounds or some integer variables have non-integer (fractional) bounds.</p>
 * <p>GLP_EROOT Unable to start the search, because optimal basis for initial LP relaxation is not provided.</p>
 * <p>GLP_EFAIL The search was prematurely terminated due to the solver failure.</p>
 * <p>GLP_EMIPGAP The search was prematurely terminated, because the relative mip gap tolerance has been reached.</p>
 * <p>GLP_ETMLIM The search was prematurely terminated, because the time limit has been exceeded.</p>
 * <p>GLP_ENOPFS The MIP problem instance has no primal feasible solution (only if the MIP presolver is used).</p>
 * <p>GLP_ENODFS LP relaxation of the MIP problem instance has no dual feasible solution (only if the MIP presolver is used).</p>
 * <p>GLP_ESTOP The search was prematurely terminated by application. </p>
 */
public";

%javamethodmodifiers preprocess_and_solve_mip(glp_prob *P, const glp_iocp *parm) "
/**
 */
public";

%javamethodmodifiers _glp_intopt1(glp_prob *P, const glp_iocp *parm) "
/**
 */
public";

%javamethodmodifiers glp_intopt(glp_prob *P, const glp_iocp *parm) "
/**
 */
public";

%javamethodmodifiers glp_init_iocp(glp_iocp *parm) "
/**
 * glp_init_iocp - initialize integer optimizer control parameters .
 * <p>SYNOPSIS</p>
 * <p>void glp_init_iocp(glp_iocp *parm);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_init_iocp initializes control parameters, which are used by the integer optimizer, with default values.</p>
 * <p>Default values of the control parameters are stored in a glp_iocp structure, which the parameter parm points to. </p>
 */
public";

%javamethodmodifiers glp_mip_status(glp_prob *mip) "
/**
 * glp_mip_status - retrieve status of MIP solution .
 * <p>SYNOPSIS</p>
 * <p>int glp_mip_status(glp_prob *mip);</p>
 * <p>RETURNS</p>
 * <p>The routine lpx_mip_status reports the status of MIP solution found by the branch-and-bound solver as follows:</p>
 * <p>GLP_UNDEF - MIP solution is undefined; GLP_OPT - MIP solution is integer optimal; GLP_FEAS - MIP solution is integer feasible but its optimality (or non-optimality) has not been proven, perhaps due to premature termination of the search; GLP_NOFEAS - problem has no integer feasible solution (proven by the solver). </p>
 */
public";

%javamethodmodifiers glp_mip_obj_val(glp_prob *mip) "
/**
 * glp_mip_obj_val - retrieve objective value (MIP solution) .
 * <p>SYNOPSIS</p>
 * <p>double glp_mip_obj_val(glp_prob *mip);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_mip_obj_val returns value of the objective function for MIP solution. </p>
 */
public";

%javamethodmodifiers glp_mip_row_val(glp_prob *mip, int i) "
/**
 * glp_mip_row_val - retrieve row value (MIP solution) .
 * <p>SYNOPSIS</p>
 * <p>double glp_mip_row_val(glp_prob *mip, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_mip_row_val returns value of the auxiliary variable associated with i-th row. </p>
 */
public";

%javamethodmodifiers glp_mip_col_val(glp_prob *mip, int j) "
/**
 * glp_mip_col_val - retrieve column value (MIP solution) .
 * <p>SYNOPSIS</p>
 * <p>double glp_mip_col_val(glp_prob *mip, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_mip_col_val returns value of the structural variable associated with j-th column. </p>
 */
public";

%javamethodmodifiers glp_check_kkt(glp_prob *P, int sol, int cond, double *_ae_max, int *_ae_ind, double *_re_max, int *_re_ind) "
/**
 */
public";

%javamethodmodifiers glp_print_sol(glp_prob *P, const char *fname) "
/**
 */
public";

%javamethodmodifiers glp_read_sol(glp_prob *lp, const char *fname) "
/**
 * glp_read_sol - read basic solution from text file .
 * <p>SYNOPSIS</p>
 * <p>int glp_read_sol(glp_prob *lp, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_read_sol reads basic solution from a text file whose name is specified by the parameter fname into the problem object.</p>
 * <p>For the file format see description of the routine glp_write_sol.</p>
 * <p>RETURNS</p>
 * <p>On success the routine returns zero, otherwise non-zero. </p>
 */
public";

%javamethodmodifiers glp_write_sol(glp_prob *lp, const char *fname) "
/**
 * glp_write_sol - write basic solution to text file .
 * <p>SYNOPSIS</p>
 * <p>int glp_write_sol(glp_prob *lp, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_write_sol writes the current basic solution to a text file whose name is specified by the parameter fname. This file can be read back with the routine glp_read_sol.</p>
 * <p>RETURNS</p>
 * <p>On success the routine returns zero, otherwise non-zero.</p>
 * <p>FILE FORMAT</p>
 * <p>The file created by the routine glp_write_sol is a plain text file, which contains the following information:</p>
 * <p>m n p_stat d_stat obj_val r_stat[1] r_prim[1] r_dual[1] . . . r_stat[m] r_prim[m] r_dual[m] c_stat[1] c_prim[1] c_dual[1] . . . c_stat[n] c_prim[n] c_dual[n]</p>
 * <p>where: m is the number of rows (auxiliary variables); n is the number of columns (structural variables); p_stat is the primal status of the basic solution (GLP_UNDEF = 1, GLP_FEAS = 2, GLP_INFEAS = 3, or GLP_NOFEAS = 4); d_stat is the dual status of the basic solution (GLP_UNDEF = 1, GLP_FEAS = 2, GLP_INFEAS = 3, or GLP_NOFEAS = 4); obj_val is the objective value; r_stat[i], i = 1,...,m, is the status of i-th row (GLP_BS = 1, GLP_NL = 2, GLP_NU = 3, GLP_NF = 4, or GLP_NS = 5); r_prim[i], i = 1,...,m, is the primal value of i-th row; r_dual[i], i = 1,...,m, is the dual value of i-th row; c_stat[j], j = 1,...,n, is the status of j-th column (GLP_BS = 1, GLP_NL = 2, GLP_NU = 3, GLP_NF = 4, or GLP_NS = 5); c_prim[j], j = 1,...,n, is the primal value of j-th column; c_dual[j], j = 1,...,n, is the dual value of j-th column. </p>
 */
public";

%javamethodmodifiers format(char buf[13+1], double x) "
/**
 */
public";

%javamethodmodifiers glp_print_ranges(glp_prob *P, int len, const int list[], int flags, const char *fname) "
/**
 */
public";

%javamethodmodifiers glp_print_ipt(glp_prob *P, const char *fname) "
/**
 */
public";

%javamethodmodifiers glp_read_ipt(glp_prob *lp, const char *fname) "
/**
 * glp_read_ipt - read interior-point solution from text file .
 * <p>SYNOPSIS</p>
 * <p>int glp_read_ipt(glp_prob *lp, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_read_ipt reads interior-point solution from a text file whose name is specified by the parameter fname into the problem object.</p>
 * <p>For the file format see description of the routine glp_write_ipt.</p>
 * <p>RETURNS</p>
 * <p>On success the routine returns zero, otherwise non-zero. </p>
 */
public";

%javamethodmodifiers glp_write_ipt(glp_prob *lp, const char *fname) "
/**
 * glp_write_ipt - write interior-point solution to text file .
 * <p>SYNOPSIS</p>
 * <p>int glp_write_ipt(glp_prob *lp, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_write_ipt writes the current interior-point solution to a text file whose name is specified by the parameter fname. This file can be read back with the routine glp_read_ipt.</p>
 * <p>RETURNS</p>
 * <p>On success the routine returns zero, otherwise non-zero.</p>
 * <p>FILE FORMAT</p>
 * <p>The file created by the routine glp_write_ipt is a plain text file, which contains the following information:</p>
 * <p>m n stat obj_val r_prim[1] r_dual[1] . . . r_prim[m] r_dual[m] c_prim[1] c_dual[1] . . . c_prim[n] c_dual[n]</p>
 * <p>where: m is the number of rows (auxiliary variables); n is the number of columns (structural variables); stat is the solution status (GLP_UNDEF = 1 or GLP_OPT = 5); obj_val is the objective value; r_prim[i], i = 1,...,m, is the primal value of i-th row; r_dual[i], i = 1,...,m, is the dual value of i-th row; c_prim[j], j = 1,...,n, is the primal value of j-th column; c_dual[j], j = 1,...,n, is the dual value of j-th column. </p>
 */
public";

%javamethodmodifiers glp_print_mip(glp_prob *P, const char *fname) "
/**
 */
public";

%javamethodmodifiers glp_read_mip(glp_prob *mip, const char *fname) "
/**
 * glp_read_mip - read MIP solution from text file .
 * <p>SYNOPSIS</p>
 * <p>int glp_read_mip(glp_prob *mip, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_read_mip reads MIP solution from a text file whose name is specified by the parameter fname into the problem object.</p>
 * <p>For the file format see description of the routine glp_write_mip.</p>
 * <p>RETURNS</p>
 * <p>On success the routine returns zero, otherwise non-zero. </p>
 */
public";

%javamethodmodifiers glp_write_mip(glp_prob *mip, const char *fname) "
/**
 * glp_write_mip - write MIP solution to text file .
 * <p>SYNOPSIS</p>
 * <p>int glp_write_mip(glp_prob *mip, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_write_mip writes the current MIP solution to a text file whose name is specified by the parameter fname. This file can be read back with the routine glp_read_mip.</p>
 * <p>RETURNS</p>
 * <p>On success the routine returns zero, otherwise non-zero.</p>
 * <p>FILE FORMAT</p>
 * <p>The file created by the routine glp_write_sol is a plain text file, which contains the following information:</p>
 * <p>m n stat obj_val r_val[1] . . . r_val[m] c_val[1] . . . c_val[n]</p>
 * <p>where: m is the number of rows (auxiliary variables); n is the number of columns (structural variables); stat is the solution status (GLP_UNDEF = 1, GLP_FEAS = 2, GLP_NOFEAS = 4, or GLP_OPT = 5); obj_val is the objective value; r_val[i], i = 1,...,m, is the value of i-th row; c_val[j], j = 1,...,n, is the value of j-th column. </p>
 */
public";

%javamethodmodifiers glp_bf_exists(glp_prob *lp) "
/**
 * glp_bf_exists - check if the basis factorization exists .
 * <p>SYNOPSIS</p>
 * <p>int glp_bf_exists(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>If the basis factorization for the current basis associated with the specified problem object exists and therefore is available for computations, the routine glp_bf_exists returns non-zero. Otherwise the routine returns zero. </p>
 */
public";

%javamethodmodifiers b_col(void *info, int j, int ind[], double val[]) "
/**
 * glp_factorize - compute the basis factorization .
 * <p>SYNOPSIS</p>
 * <p>int glp_factorize(glp_prob *lp);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_factorize computes the basis factorization for the current basis associated with the specified problem object.</p>
 * <p>RETURNS</p>
 * <p>0 The basis factorization has been successfully computed.</p>
 * <p>GLP_EBADB The basis matrix is invalid, i.e. the number of basic (auxiliary and structural) variables differs from the number of rows in the problem object.</p>
 * <p>GLP_ESING The basis matrix is singular within the working precision.</p>
 * <p>GLP_ECOND The basis matrix is ill-conditioned. </p>
 */
public";

%javamethodmodifiers copy_bfcp(glp_prob *lp) "
/**
 * glp_set_bfcp - change basis factorization control parameters .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_bfcp(glp_prob *lp, const glp_bfcp *parm);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_bfcp changes control parameters, which are used by internal GLPK routines in computing and updating the basis factorization associated with the specified problem object.</p>
 * <p>New values of the control parameters should be passed in a structure glp_bfcp, which the parameter parm points to.</p>
 * <p>The parameter parm can be specified as NULL, in which case all control parameters are reset to their default values. </p>
 */
public";

%javamethodmodifiers glp_factorize(glp_prob *lp) "
/**
 */
public";

%javamethodmodifiers glp_bf_updated(glp_prob *lp) "
/**
 * glp_bf_updated - check if the basis factorization has been updated .
 * <p>SYNOPSIS</p>
 * <p>int glp_bf_updated(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>If the basis factorization has been just computed from scratch, the routine glp_bf_updated returns zero. Otherwise, if the factorization has been updated one or more times, the routine returns non-zero. </p>
 */
public";

%javamethodmodifiers glp_get_bfcp(glp_prob *lp, glp_bfcp *parm) "
/**
 * glp_get_bfcp - retrieve basis factorization control parameters .
 * <p>SYNOPSIS</p>
 * <p>void glp_get_bfcp(glp_prob *lp, glp_bfcp *parm);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_get_bfcp retrieves control parameters, which are used on computing and updating the basis factorization associated with the specified problem object.</p>
 * <p>Current values of control parameters are stored by the routine in a glp_bfcp structure, which the parameter parm points to. </p>
 */
public";

%javamethodmodifiers glp_set_bfcp(glp_prob *lp, const glp_bfcp *parm) "
/**
 */
public";

%javamethodmodifiers glp_get_bhead(glp_prob *lp, int k) "
/**
 * glp_get_bhead - retrieve the basis header information .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_bhead(glp_prob *lp, int k);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_get_bhead returns the basis header information for the current basis associated with the specified problem object.</p>
 * <p>RETURNS</p>
 * <p>If xB[k], 1 <= k <= m, is i-th auxiliary variable (1 <= i <= m), the routine returns i. Otherwise, if xB[k] is j-th structural variable (1 <= j <= n), the routine returns m+j. Here m is the number of rows and n is the number of columns in the problem object. </p>
 */
public";

%javamethodmodifiers glp_get_row_bind(glp_prob *lp, int i) "
/**
 * glp_get_row_bind - retrieve row index in the basis header .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_row_bind(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_row_bind returns the index k of basic variable xB[k], 1 <= k <= m, which is i-th auxiliary variable, 1 <= i <= m, in the current basis associated with the specified problem object, where m is the number of rows. However, if i-th auxiliary variable is non-basic, the routine returns zero. </p>
 */
public";

%javamethodmodifiers glp_get_col_bind(glp_prob *lp, int j) "
/**
 * glp_get_col_bind - retrieve column index in the basis header .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_col_bind(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_col_bind returns the index k of basic variable xB[k], 1 <= k <= m, which is j-th structural variable, 1 <= j <= n, in the current basis associated with the specified problem object, where m is the number of rows, n is the number of columns. However, if j-th structural variable is non-basic, the routine returns zero. </p>
 */
public";

%javamethodmodifiers glp_ftran(glp_prob *lp, double x[]) "
/**
 * glp_ftran - perform forward transformation (solve system B*x = b) .
 * <p>SYNOPSIS</p>
 * <p>void glp_ftran(glp_prob *lp, double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_ftran performs forward transformation, i.e. solves the system B*x = b, where B is the basis matrix corresponding to the current basis for the specified problem object, x is the vector of unknowns to be computed, b is the vector of right-hand sides.</p>
 * <p>On entry elements of the vector b should be stored in dense format in locations x[1], ..., x[m], where m is the number of rows. On exit the routine stores elements of the vector x in the same locations.</p>
 * <p>SCALING/UNSCALING</p>
 * <p>Let A~ = (I | -A) is the augmented constraint matrix of the original (unscaled) problem. In the scaled LP problem instead the matrix A the scaled matrix A\" = R*A*S is actually used, so</p>
 * <p>A~\" = (I | A\") = (I | R*A*S) = (R*I*inv(R) | R*A*S) = (1) = R*(I | A)*S~ = R*A~*S~,</p>
 * <p>is the scaled augmented constraint matrix, where R and S are diagonal scaling matrices used to scale rows and columns of the matrix A, and</p>
 * <p>S~ = diag(inv(R) | S) (2)</p>
 * <p>is an augmented diagonal scaling matrix.</p>
 * <p>By definition:</p>
 * <p>A~ = (B | N), (3)</p>
 * <p>where B is the basic matrix, which consists of basic columns of the augmented constraint matrix A~, and N is a matrix, which consists of non-basic columns of A~. From (1) it follows that:</p>
 * <p>A~\" = (B\" | N\") = (R*B*SB | R*N*SN), (4)</p>
 * <p>where SB and SN are parts of the augmented scaling matrix S~, which correspond to basic and non-basic variables, respectively. Therefore</p>
 * <p>B\" = R*B*SB, (5)</p>
 * <p>which is the scaled basis matrix. </p>
 */
public";

%javamethodmodifiers glp_btran(glp_prob *lp, double x[]) "
/**
 * glp_btran - perform backward transformation (solve system B'*x = b) .
 * <p>SYNOPSIS</p>
 * <p>void glp_btran(glp_prob *lp, double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_btran performs backward transformation, i.e. solves the system B'*x = b, where B' is a matrix transposed to the basis matrix corresponding to the current basis for the specified problem problem object, x is the vector of unknowns to be computed, b is the vector of right-hand sides.</p>
 * <p>On entry elements of the vector b should be stored in dense format in locations x[1], ..., x[m], where m is the number of rows. On exit the routine stores elements of the vector x in the same locations.</p>
 * <p>SCALING/UNSCALING</p>
 * <p>See comments to the routine glp_ftran. </p>
 */
public";

%javamethodmodifiers glp_warm_up(glp_prob *P) "
/**
 * glp_warm_up - \"warm up\" LP basis .
 * <p>SYNOPSIS</p>
 * <p>int glp_warm_up(glp_prob *P);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_warm_up \"warms up\" the LP basis for the specified problem object using current statuses assigned to rows and columns (that is, to auxiliary and structural variables).</p>
 * <p>This operation includes computing factorization of the basis matrix (if it does not exist), computing primal and dual components of basic solution, and determining the solution status.</p>
 * <p>RETURNS</p>
 * <p>0 The operation has been successfully performed.</p>
 * <p>GLP_EBADB The basis matrix is invalid, i.e. the number of basic (auxiliary and structural) variables differs from the number of rows in the problem object.</p>
 * <p>GLP_ESING The basis matrix is singular within the working precision.</p>
 * <p>GLP_ECOND The basis matrix is ill-conditioned. </p>
 */
public";

%javamethodmodifiers glp_eval_tab_row(glp_prob *lp, int k, int ind[], double val[]) "
/**
 * glp_eval_tab_row - compute row of the simplex tableau .
 * <p>SYNOPSIS</p>
 * <p>int glp_eval_tab_row(glp_prob *lp, int k, int ind[], double val[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_eval_tab_row computes a row of the current simplex tableau for the basic variable, which is specified by the number k: if 1 <= k <= m, x[k] is k-th auxiliary variable; if m+1 <= k <= m+n, x[k] is (k-m)-th structural variable, where m is number of rows, and n is number of columns. The current basis must be available.</p>
 * <p>The routine stores column indices and numerical values of non-zero elements of the computed row using sparse format to the locations ind[1], ..., ind[len] and val[1], ..., val[len], respectively, where 0 <= len <= n is number of non-zeros returned on exit.</p>
 * <p>Element indices stored in the array ind have the same sense as the index k, i.e. indices 1 to m denote auxiliary variables and indices m+1 to m+n denote structural ones (all these variables are obviously non-basic by definition).</p>
 * <p>The computed row shows how the specified basic variable x[k] = xB[i] depends on non-basic variables:</p>
 * <p>xB[i] = alfa[i,1]*xN[1] + alfa[i,2]*xN[2] + ... + alfa[i,n]*xN[n],</p>
 * <p>where alfa[i,j] are elements of the simplex table row, xN[j] are non-basic (auxiliary and structural) variables.</p>
 * <p>RETURNS</p>
 * <p>The routine returns number of non-zero elements in the simplex table row stored in the arrays ind and val.</p>
 * <p>BACKGROUND</p>
 * <p>The system of equality constraints of the LP problem is:</p>
 * <p>xR = A * xS, (1)</p>
 * <p>where xR is the vector of auxliary variables, xS is the vector of structural variables, A is the matrix of constraint coefficients.</p>
 * <p>The system (1) can be written in homogenous form as follows:</p>
 * <p>A~ * x = 0, (2)</p>
 * <p>where A~ = (I | -A) is the augmented constraint matrix (has m rows and m+n columns), x = (xR | xS) is the vector of all (auxiliary and structural) variables.</p>
 * <p>By definition for the current basis we have:</p>
 * <p>A~ = (B | N), (3)</p>
 * <p>where B is the basis matrix. Thus, the system (2) can be written as:</p>
 * <p>B * xB + N * xN = 0. (4)</p>
 * <p>From (4) it follows that:</p>
 * <p>xB = A^ * xN, (5)</p>
 * <p>where the matrix</p>
 * <p>A^ = - inv(B) * N (6)</p>
 * <p>is called the simplex table.</p>
 * <p>It is understood that i-th row of the simplex table is:</p>
 * <p>e * A^ = - e * inv(B) * N, (7)</p>
 * <p>where e is a unity vector with e[i] = 1.</p>
 * <p>To compute i-th row of the simplex table the routine first computes i-th row of the inverse:</p>
 * <p>rho = inv(B') * e, (8)</p>
 * <p>where B' is a matrix transposed to B, and then computes elements of i-th row of the simplex table as scalar products:</p>
 * <p>alfa[i,j] = - rho * N[j] for all j, (9)</p>
 * <p>where N[j] is a column of the augmented constraint matrix A~, which corresponds to some non-basic auxiliary or structural variable. </p>
 */
public";

%javamethodmodifiers glp_eval_tab_col(glp_prob *lp, int k, int ind[], double val[]) "
/**
 * glp_eval_tab_col - compute column of the simplex tableau .
 * <p>SYNOPSIS</p>
 * <p>int glp_eval_tab_col(glp_prob *lp, int k, int ind[], double val[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_eval_tab_col computes a column of the current simplex table for the non-basic variable, which is specified by the number k: if 1 <= k <= m, x[k] is k-th auxiliary variable; if m+1 <= k <= m+n, x[k] is (k-m)-th structural variable, where m is number of rows, and n is number of columns. The current basis must be available.</p>
 * <p>The routine stores row indices and numerical values of non-zero elements of the computed column using sparse format to the locations ind[1], ..., ind[len] and val[1], ..., val[len] respectively, where 0 <= len <= m is number of non-zeros returned on exit.</p>
 * <p>Element indices stored in the array ind have the same sense as the index k, i.e. indices 1 to m denote auxiliary variables and indices m+1 to m+n denote structural ones (all these variables are obviously basic by the definition).</p>
 * <p>The computed column shows how basic variables depend on the specified non-basic variable x[k] = xN[j]:</p>
 * <p>xB[1] = ... + alfa[1,j]*xN[j] + ... xB[2] = ... + alfa[2,j]*xN[j] + ... . . . . . . xB[m] = ... + alfa[m,j]*xN[j] + ...</p>
 * <p>where alfa[i,j] are elements of the simplex table column, xB[i] are basic (auxiliary and structural) variables.</p>
 * <p>RETURNS</p>
 * <p>The routine returns number of non-zero elements in the simplex table column stored in the arrays ind and val.</p>
 * <p>BACKGROUND</p>
 * <p>As it was explained in comments to the routine glp_eval_tab_row (see above) the simplex table is the following matrix:</p>
 * <p>A^ = - inv(B) * N. (1)</p>
 * <p>Therefore j-th column of the simplex table is:</p>
 * <p>A^ * e = - inv(B) * N * e = - inv(B) * N[j], (2)</p>
 * <p>where e is a unity vector with e[j] = 1, B is the basis matrix, N[j] is a column of the augmented constraint matrix A~, which corresponds to the given non-basic auxiliary or structural variable. </p>
 */
public";

%javamethodmodifiers glp_transform_row(glp_prob *P, int len, int ind[], double val[]) "
/**
 * glp_transform_row - transform explicitly specified row .
 * <p>SYNOPSIS</p>
 * <p>int glp_transform_row(glp_prob *P, int len, int ind[], double val[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_transform_row performs the same operation as the routine glp_eval_tab_row with exception that the row to be transformed is specified explicitly as a sparse vector.</p>
 * <p>The explicitly specified row may be thought as a linear form:</p>
 * <p>x = a[1]*x[m+1] + a[2]*x[m+2] + ... + a[n]*x[m+n], (1)</p>
 * <p>where x is an auxiliary variable for this row, a[j] are coefficients of the linear form, x[m+j] are structural variables.</p>
 * <p>On entry column indices and numerical values of non-zero elements of the row should be stored in locations ind[1], ..., ind[len] and val[1], ..., val[len], where len is the number of non-zero elements.</p>
 * <p>This routine uses the system of equality constraints and the current basis in order to express the auxiliary variable x in (1) through the current non-basic variables (as if the transformed row were added to the problem object and its auxiliary variable were basic), i.e. the resultant row has the form:</p>
 * <p>x = alfa[1]*xN[1] + alfa[2]*xN[2] + ... + alfa[n]*xN[n], (2)</p>
 * <p>where xN[j] are non-basic (auxiliary or structural) variables, n is the number of columns in the LP problem object.</p>
 * <p>On exit the routine stores indices and numerical values of non-zero elements of the resultant row (2) in locations ind[1], ..., ind[len'] and val[1], ..., val[len'], where 0 <= len' <= n is the number of non-zero elements in the resultant row returned by the routine. Note that indices (numbers) of non-basic variables stored in the array ind correspond to original ordinal numbers of variables: indices 1 to m mean auxiliary variables and indices m+1 to m+n mean structural ones.</p>
 * <p>RETURNS</p>
 * <p>The routine returns len', which is the number of non-zero elements in the resultant row stored in the arrays ind and val.</p>
 * <p>BACKGROUND</p>
 * <p>The explicitly specified row (1) is transformed in the same way as it were the objective function row.</p>
 * <p>From (1) it follows that:</p>
 * <p>x = aB * xB + aN * xN, (3)</p>
 * <p>where xB is the vector of basic variables, xN is the vector of non-basic variables.</p>
 * <p>The simplex table, which corresponds to the current basis, is:</p>
 * <p>xB = [-inv(B) * N] * xN. (4)</p>
 * <p>Therefore substituting xB from (4) to (3) we have:</p>
 * <p>x = aB * [-inv(B) * N] * xN + aN * xN = (5) = rho * (-N) * xN + aN * xN = alfa * xN,</p>
 * <p>where:</p>
 * <p>rho = inv(B') * aB, (6)</p>
 * <p>and</p>
 * <p>alfa = aN + rho * (-N) (7)</p>
 * <p>is the resultant row computed by the routine. </p>
 */
public";

%javamethodmodifiers glp_transform_col(glp_prob *P, int len, int ind[], double val[]) "
/**
 * glp_transform_col - transform explicitly specified column .
 * <p>SYNOPSIS</p>
 * <p>int glp_transform_col(glp_prob *P, int len, int ind[], double val[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_transform_col performs the same operation as the routine glp_eval_tab_col with exception that the column to be transformed is specified explicitly as a sparse vector.</p>
 * <p>The explicitly specified column may be thought as if it were added to the original system of equality constraints:</p>
 * <p>x[1] = a[1,1]*x[m+1] + ... + a[1,n]*x[m+n] + a[1]*x x[2] = a[2,1]*x[m+1] + ... + a[2,n]*x[m+n] + a[2]*x (1) . . . . . . . . . . . . . . . x[m] = a[m,1]*x[m+1] + ... + a[m,n]*x[m+n] + a[m]*x</p>
 * <p>where x[i] are auxiliary variables, x[m+j] are structural variables, x is a structural variable for the explicitly specified column, a[i] are constraint coefficients for x.</p>
 * <p>On entry row indices and numerical values of non-zero elements of the column should be stored in locations ind[1], ..., ind[len] and val[1], ..., val[len], where len is the number of non-zero elements.</p>
 * <p>This routine uses the system of equality constraints and the current basis in order to express the current basic variables through the structural variable x in (1) (as if the transformed column were added to the problem object and the variable x were non-basic), i.e. the resultant column has the form:</p>
 * <p>xB[1] = ... + alfa[1]*x xB[2] = ... + alfa[2]*x (2) . . . . . . xB[m] = ... + alfa[m]*x</p>
 * <p>where xB are basic (auxiliary and structural) variables, m is the number of rows in the problem object.</p>
 * <p>On exit the routine stores indices and numerical values of non-zero elements of the resultant column (2) in locations ind[1], ..., ind[len'] and val[1], ..., val[len'], where 0 <= len' <= m is the number of non-zero element in the resultant column returned by the routine. Note that indices (numbers) of basic variables stored in the array ind correspond to original ordinal numbers of variables: indices 1 to m mean auxiliary variables and indices m+1 to m+n mean structural ones.</p>
 * <p>RETURNS</p>
 * <p>The routine returns len', which is the number of non-zero elements in the resultant column stored in the arrays ind and val.</p>
 * <p>BACKGROUND</p>
 * <p>The explicitly specified column (1) is transformed in the same way as any other column of the constraint matrix using the formula:</p>
 * <p>alfa = inv(B) * a, (3)</p>
 * <p>where alfa is the resultant column computed by the routine. </p>
 */
public";

%javamethodmodifiers glp_prim_rtest(glp_prob *P, int len, const int ind[], const double val[], int dir, double eps) "
/**
 * glp_prim_rtest - perform primal ratio test .
 * <p>SYNOPSIS</p>
 * <p>int glp_prim_rtest(glp_prob *P, int len, const int ind[], const double val[], int dir, double eps);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_prim_rtest performs the primal ratio test using an explicitly specified column of the simplex table.</p>
 * <p>The current basic solution associated with the LP problem object must be primal feasible.</p>
 * <p>The explicitly specified column of the simplex table shows how the basic variables xB depend on some non-basic variable x (which is not necessarily presented in the problem object):</p>
 * <p>xB[1] = ... + alfa[1] * x + ... xB[2] = ... + alfa[2] * x + ... (*) . . . . . . . . xB[m] = ... + alfa[m] * x + ...</p>
 * <p>The column (*) is specifed on entry to the routine using the sparse format. Ordinal numbers of basic variables xB[i] should be placed in locations ind[1], ..., ind[len], where ordinal number 1 to m denote auxiliary variables, and ordinal numbers m+1 to m+n denote structural variables. The corresponding non-zero coefficients alfa[i] should be placed in locations val[1], ..., val[len]. The arrays ind and val are not changed on exit.</p>
 * <p>The parameter dir specifies direction in which the variable x changes on entering the basis: +1 means increasing, -1 means decreasing.</p>
 * <p>The parameter eps is an absolute tolerance (small positive number) used by the routine to skip small alfa[j] of the row (*).</p>
 * <p>The routine determines which basic variable (among specified in ind[1], ..., ind[len]) should leave the basis in order to keep primal feasibility.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_prim_rtest returns the index piv in the arrays ind and val corresponding to the pivot element chosen, 1 <= piv <= len. If the adjacent basic solution is primal unbounded and therefore the choice cannot be made, the routine returns zero.</p>
 * <p>COMMENTS</p>
 * <p>If the non-basic variable x is presented in the LP problem object, the column (*) can be computed with the routine glp_eval_tab_col; otherwise it can be computed with the routine glp_transform_col. </p>
 */
public";

%javamethodmodifiers glp_dual_rtest(glp_prob *P, int len, const int ind[], const double val[], int dir, double eps) "
/**
 * glp_dual_rtest - perform dual ratio test .
 * <p>SYNOPSIS</p>
 * <p>int glp_dual_rtest(glp_prob *P, int len, const int ind[], const double val[], int dir, double eps);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_dual_rtest performs the dual ratio test using an explicitly specified row of the simplex table.</p>
 * <p>The current basic solution associated with the LP problem object must be dual feasible.</p>
 * <p>The explicitly specified row of the simplex table is a linear form that shows how some basic variable x (which is not necessarily presented in the problem object) depends on non-basic variables xN:</p>
 * <p>x = alfa[1] * xN[1] + alfa[2] * xN[2] + ... + alfa[n] * xN[n]. (*)</p>
 * <p>The row (*) is specified on entry to the routine using the sparse format. Ordinal numbers of non-basic variables xN[j] should be placed in locations ind[1], ..., ind[len], where ordinal numbers 1 to m denote auxiliary variables, and ordinal numbers m+1 to m+n denote structural variables. The corresponding non-zero coefficients alfa[j] should be placed in locations val[1], ..., val[len]. The arrays ind and val are not changed on exit.</p>
 * <p>The parameter dir specifies direction in which the variable x changes on leaving the basis: +1 means that x goes to its lower bound, and -1 means that x goes to its upper bound.</p>
 * <p>The parameter eps is an absolute tolerance (small positive number) used by the routine to skip small alfa[j] of the row (*).</p>
 * <p>The routine determines which non-basic variable (among specified in ind[1], ..., ind[len]) should enter the basis in order to keep dual feasibility.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_dual_rtest returns the index piv in the arrays ind and val corresponding to the pivot element chosen, 1 <= piv <= len. If the adjacent basic solution is dual unbounded and therefore the choice cannot be made, the routine returns zero.</p>
 * <p>COMMENTS</p>
 * <p>If the basic variable x is presented in the LP problem object, the row (*) can be computed with the routine glp_eval_tab_row; otherwise it can be computed with the routine glp_transform_row. </p>
 */
public";

%javamethodmodifiers _glp_analyze_row(glp_prob *P, int len, const int ind[], const double val[], int type, double rhs, double eps, int *_piv, double *_x, double *_dx, double *_y, double *_dy, double *_dz) "
/**
 * glp_analyze_row - simulate one iteration of dual simplex method .
 * <p>SYNOPSIS</p>
 * <p>int glp_analyze_row(glp_prob *P, int len, const int ind[], const double val[], int type, double rhs, double eps, int *piv, double *x, double *dx, double *y, double *dy, double *dz);</p>
 * <p>DESCRIPTION</p>
 * <p>Let the current basis be optimal or dual feasible, and there be specified a row (constraint), which is violated by the current basic solution. The routine glp_analyze_row simulates one iteration of the dual simplex method to determine some information on the adjacent basis (see below), where the specified row becomes active constraint (i.e. its auxiliary variable becomes non-basic).</p>
 * <p>The current basic solution associated with the problem object passed to the routine must be dual feasible, and its primal components must be defined.</p>
 * <p>The row to be analyzed must be previously transformed either with the routine glp_eval_tab_row (if the row is in the problem object) or with the routine glp_transform_row (if the row is external, i.e. not in the problem object). This is needed to express the row only through (auxiliary and structural) variables, which are non-basic in the current basis:</p>
 * <p>y = alfa[1] * xN[1] + alfa[2] * xN[2] + ... + alfa[n] * xN[n],</p>
 * <p>where y is an auxiliary variable of the row, alfa[j] is an influence coefficient, xN[j] is a non-basic variable.</p>
 * <p>The row is passed to the routine in sparse format. Ordinal numbers of non-basic variables are stored in locations ind[1], ..., ind[len], where numbers 1 to m denote auxiliary variables while numbers m+1 to m+n denote structural variables. Corresponding non-zero coefficients alfa[j] are stored in locations val[1], ..., val[len]. The arrays ind and val are ot changed on exit.</p>
 * <p>The parameters type and rhs specify the row type and its right-hand side as follows:</p>
 * <p>type = GLP_LO: y = sum alfa[j] * xN[j] >= rhs</p>
 * <p>type = GLP_UP: y = sum alfa[j] * xN[j] <= rhs</p>
 * <p>The parameter eps is an absolute tolerance (small positive number) used by the routine to skip small coefficients alfa[j] on performing the dual ratio test.</p>
 * <p>If the operation was successful, the routine stores the following information to corresponding location (if some parameter is NULL, its value is not stored):</p>
 * <p>piv index in the array ind and val, 1 <= piv <= len, determining the non-basic variable, which would enter the adjacent basis;</p>
 * <p>x value of the non-basic variable in the current basis;</p>
 * <p>dx difference between values of the non-basic variable in the adjacent and current bases, dx = x.new - x.old;</p>
 * <p>y value of the row (i.e. of its auxiliary variable) in the current basis;</p>
 * <p>dy difference between values of the row in the adjacent and current bases, dy = y.new - y.old;</p>
 * <p>dz difference between values of the objective function in the adjacent and current bases, dz = z.new - z.old. Note that in case of minimization dz >= 0, and in case of maximization dz <= 0, i.e. in the adjacent basis the objective function always gets worse (degrades). </p>
 */
public";

%javamethodmodifiers glp_analyze_bound(glp_prob *P, int k, double *value1, int *var1, double *value2, int *var2) "
/**
 * glp_analyze_bound - analyze active bound of non-basic variable .
 * <p>SYNOPSIS</p>
 * <p>void glp_analyze_bound(glp_prob *P, int k, double *limit1, int *var1, double *limit2, int *var2);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_analyze_bound analyzes the effect of varying the active bound of specified non-basic variable.</p>
 * <p>The non-basic variable is specified by the parameter k, where 1 <= k <= m means auxiliary variable of corresponding row while m+1 <= k <= m+n means structural variable (column).</p>
 * <p>Note that the current basic solution must be optimal, and the basis factorization must exist.</p>
 * <p>Results of the analysis have the following meaning.</p>
 * <p>value1 is the minimal value of the active bound, at which the basis still remains primal feasible and thus optimal. -DBL_MAX means that the active bound has no lower limit.</p>
 * <p>var1 is the ordinal number of an auxiliary (1 to m) or structural (m+1 to n) basic variable, which reaches its bound first and thereby limits further decreasing the active bound being analyzed. if value1 = -DBL_MAX, var1 is set to 0.</p>
 * <p>value2 is the maximal value of the active bound, at which the basis still remains primal feasible and thus optimal. +DBL_MAX means that the active bound has no upper limit.</p>
 * <p>var2 is the ordinal number of an auxiliary (1 to m) or structural (m+1 to n) basic variable, which reaches its bound first and thereby limits further increasing the active bound being analyzed. if value2 = +DBL_MAX, var2 is set to 0. </p>
 */
public";

%javamethodmodifiers glp_analyze_coef(glp_prob *P, int k, double *coef1, int *var1, double *value1, double *coef2, int *var2, double *value2) "
/**
 * glp_analyze_coef - analyze objective coefficient at basic variable .
 * <p>SYNOPSIS</p>
 * <p>void glp_analyze_coef(glp_prob *P, int k, double *coef1, int *var1, double *value1, double *coef2, int *var2, double *value2);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_analyze_coef analyzes the effect of varying the objective coefficient at specified basic variable.</p>
 * <p>The basic variable is specified by the parameter k, where 1 <= k <= m means auxiliary variable of corresponding row while m+1 <= k <= m+n means structural variable (column).</p>
 * <p>Note that the current basic solution must be optimal, and the basis factorization must exist.</p>
 * <p>Results of the analysis have the following meaning.</p>
 * <p>coef1 is the minimal value of the objective coefficient, at which the basis still remains dual feasible and thus optimal. -DBL_MAX means that the objective coefficient has no lower limit.</p>
 * <p>var1 is the ordinal number of an auxiliary (1 to m) or structural (m+1 to n) non-basic variable, whose reduced cost reaches its zero bound first and thereby limits further decreasing the objective coefficient being analyzed. If coef1 = -DBL_MAX, var1 is set to 0.</p>
 * <p>value1 is value of the basic variable being analyzed in an adjacent basis, which is defined as follows. Let the objective coefficient reaches its minimal value (coef1) and continues decreasing. Then the reduced cost of the limiting non-basic variable (var1) becomes dual infeasible and the current basis becomes non-optimal that forces the limiting non-basic variable to enter the basis replacing there some basic variable that leaves the basis to keep primal feasibility. Should note that on determining the adjacent basis current bounds of the basic variable being analyzed are ignored as if it were free (unbounded) variable, so it cannot leave the basis. It may happen that no dual feasible adjacent basis exists, in which case value1 is set to -DBL_MAX or +DBL_MAX.</p>
 * <p>coef2 is the maximal value of the objective coefficient, at which the basis still remains dual feasible and thus optimal. +DBL_MAX means that the objective coefficient has no upper limit.</p>
 * <p>var2 is the ordinal number of an auxiliary (1 to m) or structural (m+1 to n) non-basic variable, whose reduced cost reaches its zero bound first and thereby limits further increasing the objective coefficient being analyzed. If coef2 = +DBL_MAX, var2 is set to 0.</p>
 * <p>value2 is value of the basic variable being analyzed in an adjacent basis, which is defined exactly in the same way as value1 above with exception that now the objective coefficient is increasing. </p>
 */
public";

%javamethodmodifiers glp_ios_reason(glp_tree *tree) "
/**
 * glp_ios_reason - determine reason for calling the callback routine .
 * <p>SYNOPSIS</p>
 * <p>glp_ios_reason(glp_tree *tree);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ios_reason returns a code, which indicates why the user-defined callback routine is being called. </p>
 */
public";

%javamethodmodifiers glp_ios_get_prob(glp_tree *tree) "
/**
 * glp_ios_get_prob - access the problem object .
 * <p>SYNOPSIS</p>
 * <p>glp_prob *glp_ios_get_prob(glp_tree *tree);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_ios_get_prob can be called from the user-defined callback routine to access the problem object, which is used by the MIP solver. It is the original problem object passed to the routine glp_intopt if the MIP presolver is not used; otherwise it is an internal problem object built by the presolver. If the current subproblem exists, LP segment of the problem object corresponds to its LP relaxation.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ios_get_prob returns a pointer to the problem object used by the MIP solver. </p>
 */
public";

%javamethodmodifiers glp_ios_tree_size(glp_tree *tree, int *a_cnt, int *n_cnt, int *t_cnt) "
/**
 * glp_ios_tree_size - determine size of the branch-and-bound tree .
 * <p>SYNOPSIS</p>
 * <p>void glp_ios_tree_size(glp_tree *tree, int *a_cnt, int *n_cnt, int *t_cnt);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_ios_tree_size stores the following three counts which characterize the current size of the branch-and-bound tree:</p>
 * <p>a_cnt is the current number of active nodes, i.e. the current size of the active list;</p>
 * <p>n_cnt is the current number of all (active and inactive) nodes;</p>
 * <p>t_cnt is the total number of nodes including those which have been already removed from the tree. This count is increased whenever a new node appears in the tree and never decreased.</p>
 * <p>If some of the parameters a_cnt, n_cnt, t_cnt is a null pointer, the corresponding count is not stored. </p>
 */
public";

%javamethodmodifiers glp_ios_curr_node(glp_tree *tree) "
/**
 * glp_ios_curr_node - determine current active subproblem .
 * <p>SYNOPSIS</p>
 * <p>int glp_ios_curr_node(glp_tree *tree);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ios_curr_node returns the reference number of the current active subproblem. However, if the current subproblem does not exist, the routine returns zero. </p>
 */
public";

%javamethodmodifiers glp_ios_next_node(glp_tree *tree, int p) "
/**
 * glp_ios_next_node - determine next active subproblem .
 * <p>SYNOPSIS</p>
 * <p>int glp_ios_next_node(glp_tree *tree, int p);</p>
 * <p>RETURNS</p>
 * <p>If the parameter p is zero, the routine glp_ios_next_node returns the reference number of the first active subproblem. However, if the tree is empty, zero is returned.</p>
 * <p>If the parameter p is not zero, it must specify the reference number of some active subproblem, in which case the routine returns the reference number of the next active subproblem. However, if there is no next active subproblem in the list, zero is returned.</p>
 * <p>All subproblems in the active list are ordered chronologically, i.e. subproblem A precedes subproblem B if A was created before B. </p>
 */
public";

%javamethodmodifiers glp_ios_prev_node(glp_tree *tree, int p) "
/**
 * glp_ios_prev_node - determine previous active subproblem .
 * <p>SYNOPSIS</p>
 * <p>int glp_ios_prev_node(glp_tree *tree, int p);</p>
 * <p>RETURNS</p>
 * <p>If the parameter p is zero, the routine glp_ios_prev_node returns the reference number of the last active subproblem. However, if the tree is empty, zero is returned.</p>
 * <p>If the parameter p is not zero, it must specify the reference number of some active subproblem, in which case the routine returns the reference number of the previous active subproblem. However, if there is no previous active subproblem in the list, zero is returned.</p>
 * <p>All subproblems in the active list are ordered chronologically, i.e. subproblem A precedes subproblem B if A was created before B. </p>
 */
public";

%javamethodmodifiers glp_ios_up_node(glp_tree *tree, int p) "
/**
 * glp_ios_up_node - determine parent subproblem .
 * <p>SYNOPSIS</p>
 * <p>int glp_ios_up_node(glp_tree *tree, int p);</p>
 * <p>RETURNS</p>
 * <p>The parameter p must specify the reference number of some (active or inactive) subproblem, in which case the routine iet_get_up_node returns the reference number of its parent subproblem. However, if the specified subproblem is the root of the tree and, therefore, has no parent, the routine returns zero. </p>
 */
public";

%javamethodmodifiers glp_ios_node_level(glp_tree *tree, int p) "
/**
 * glp_ios_node_level - determine subproblem level .
 * <p>SYNOPSIS</p>
 * <p>int glp_ios_node_level(glp_tree *tree, int p);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ios_node_level returns the level of the subproblem, whose reference number is p, in the branch-and-bound tree. (The root subproblem has level 0, and the level of any other subproblem is the level of its parent plus one.) </p>
 */
public";

%javamethodmodifiers glp_ios_node_bound(glp_tree *tree, int p) "
/**
 * glp_ios_node_bound - determine subproblem local bound .
 * <p>SYNOPSIS</p>
 * <p>double glp_ios_node_bound(glp_tree *tree, int p);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ios_node_bound returns the local bound for (active or inactive) subproblem, whose reference number is p.</p>
 * <p>COMMENTS</p>
 * <p>The local bound for subproblem p is an lower (minimization) or upper (maximization) bound for integer optimal solution to this subproblem (not to the original problem). This bound is local in the sense that only subproblems in the subtree rooted at node p cannot have better integer feasible solutions.</p>
 * <p>On creating a subproblem (due to the branching step) its local bound is inherited from its parent and then may get only stronger (never weaker). For the root subproblem its local bound is initially set to -DBL_MAX (minimization) or +DBL_MAX (maximization) and then improved as the root LP relaxation has been solved.</p>
 * <p>Note that the local bound is not necessarily the optimal objective value to corresponding LP relaxation; it may be stronger. </p>
 */
public";

%javamethodmodifiers glp_ios_best_node(glp_tree *tree) "
/**
 * glp_ios_best_node - find active subproblem with best local bound .
 * <p>SYNOPSIS</p>
 * <p>int glp_ios_best_node(glp_tree *tree);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ios_best_node returns the reference number of the active subproblem, whose local bound is best (i.e. smallest in case of minimization or largest in case of maximization). However, if the tree is empty, the routine returns zero.</p>
 * <p>COMMENTS</p>
 * <p>The best local bound is an lower (minimization) or upper (maximization) bound for integer optimal solution to the original MIP problem. </p>
 */
public";

%javamethodmodifiers glp_ios_mip_gap(glp_tree *tree) "
/**
 * glp_ios_mip_gap - compute relative MIP gap .
 * <p>SYNOPSIS</p>
 * <p>double glp_ios_mip_gap(glp_tree *tree);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_ios_mip_gap computes the relative MIP gap with the following formula:</p>
 * <p>gap = |best_mip - best_bnd| / (|best_mip| + DBL_EPSILON),</p>
 * <p>where best_mip is the best integer feasible solution found so far, best_bnd is the best (global) bound. If no integer feasible solution has been found yet, gap is set to DBL_MAX.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ios_mip_gap returns the relative MIP gap. </p>
 */
public";

%javamethodmodifiers glp_ios_node_data(glp_tree *tree, int p) "
/**
 * glp_ios_node_data - access subproblem application-specific data .
 * <p>SYNOPSIS</p>
 * <p>void *glp_ios_node_data(glp_tree *tree, int p);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_ios_node_data allows the application accessing a memory block allocated for the subproblem (which may be active or inactive), whose reference number is p.</p>
 * <p>The size of the block is defined by the control parameter cb_size passed to the routine glp_intopt. The block is initialized by binary zeros on creating corresponding subproblem, and its contents is kept until the subproblem will be removed from the tree.</p>
 * <p>The application may use these memory blocks to store specific data for each subproblem.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ios_node_data returns a pointer to the memory block for the specified subproblem. Note that if cb_size = 0, the routine returns a null pointer. </p>
 */
public";

%javamethodmodifiers glp_ios_row_attr(glp_tree *tree, int i, glp_attr *attr) "
/**
 * glp_ios_row_attr - retrieve additional row attributes .
 * <p>SYNOPSIS</p>
 * <p>void glp_ios_row_attr(glp_tree *tree, int i, glp_attr *attr);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_ios_row_attr retrieves additional attributes of row i and stores them in the structure glp_attr. </p>
 */
public";

%javamethodmodifiers glp_ios_pool_size(glp_tree *tree) "
/**
 */
public";

%javamethodmodifiers glp_ios_add_row(glp_tree *tree, const char *name, int klass, int flags, int len, const int ind[], const double val[], int type, double rhs) "
/**
 */
public";

%javamethodmodifiers glp_ios_del_row(glp_tree *tree, int i) "
/**
 */
public";

%javamethodmodifiers glp_ios_clear_pool(glp_tree *tree) "
/**
 */
public";

%javamethodmodifiers glp_ios_can_branch(glp_tree *tree, int j) "
/**
 * glp_ios_can_branch - check if can branch upon specified variable .
 * <p>SYNOPSIS</p>
 * <p>int glp_ios_can_branch(glp_tree *tree, int j);</p>
 * <p>RETURNS</p>
 * <p>If j-th variable (column) can be used to branch upon, the routine glp_ios_can_branch returns non-zero, otherwise zero. </p>
 */
public";

%javamethodmodifiers glp_ios_branch_upon(glp_tree *tree, int j, int sel) "
/**
 * glp_ios_branch_upon - choose variable to branch upon .
 * <p>SYNOPSIS</p>
 * <p>void glp_ios_branch_upon(glp_tree *tree, int j, int sel);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_ios_branch_upon can be called from the user-defined callback routine in response to the reason GLP_IBRANCH to choose a branching variable, whose ordinal number is j. Should note that only variables, for which the routine glp_ios_can_branch returns non-zero, can be used to branch upon.</p>
 * <p>The parameter sel is a flag that indicates which branch (subproblem) should be selected next to continue the search:</p>
 * <p>GLP_DN_BRNCH - select down-branch; GLP_UP_BRNCH - select up-branch; GLP_NO_BRNCH - use general selection technique. </p>
 */
public";

%javamethodmodifiers glp_ios_select_node(glp_tree *tree, int p) "
/**
 * glp_ios_select_node - select subproblem to continue the search .
 * <p>SYNOPSIS</p>
 * <p>void glp_ios_select_node(glp_tree *tree, int p);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_ios_select_node can be called from the user-defined callback routine in response to the reason GLP_ISELECT to select an active subproblem, whose reference number is p. The search will be continued from the subproblem selected. </p>
 */
public";

%javamethodmodifiers glp_ios_heur_sol(glp_tree *tree, const double x[]) "
/**
 * glp_ios_heur_sol - provide solution found by heuristic .
 * <p>SYNOPSIS</p>
 * <p>int glp_ios_heur_sol(glp_tree *tree, const double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_ios_heur_sol can be called from the user-defined callback routine in response to the reason GLP_IHEUR to provide an integer feasible solution found by a primal heuristic.</p>
 * <p>Primal values of *all* variables (columns) found by the heuristic should be placed in locations x[1], ..., x[n], where n is the number of columns in the original problem object. Note that the routine glp_ios_heur_sol *does not* check primal feasibility of the solution provided.</p>
 * <p>Using the solution passed in the array x the routine computes value of the objective function. If the objective value is better than the best known integer feasible solution, the routine computes values of auxiliary variables (rows) and stores all solution components in the problem object.</p>
 * <p>RETURNS</p>
 * <p>If the provided solution is accepted, the routine glp_ios_heur_sol returns zero. Otherwise, if the provided solution is rejected, the routine returns non-zero. </p>
 */
public";

%javamethodmodifiers glp_ios_terminate(glp_tree *tree) "
/**
 * glp_ios_terminate - terminate the solution process. .
 * <p>SYNOPSIS</p>
 * <p>void glp_ios_terminate(glp_tree *tree);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_ios_terminate sets a flag indicating that the MIP solver should prematurely terminate the search. </p>
 */
public";

%javamethodmodifiers glp_mpl_alloc_wksp(void) "
/**
 */
public";

%javamethodmodifiers _glp_mpl_init_rand(glp_tran *tran, int seed) "
/**
 */
public";

%javamethodmodifiers glp_mpl_read_model(glp_tran *tran, const char *fname, int skip) "
/**
 */
public";

%javamethodmodifiers glp_mpl_read_data(glp_tran *tran, const char *fname) "
/**
 */
public";

%javamethodmodifiers glp_mpl_generate(glp_tran *tran, const char *fname) "
/**
 */
public";

%javamethodmodifiers glp_mpl_build_prob(glp_tran *tran, glp_prob *prob) "
/**
 */
public";

%javamethodmodifiers glp_mpl_postsolve(glp_tran *tran, glp_prob *prob, int sol) "
/**
 */
public";

%javamethodmodifiers glp_mpl_free_wksp(glp_tran *tran) "
/**
 */
public";

%javamethodmodifiers create_graph(glp_graph *G, int v_size, int a_size) "
/**
 * glp_create_graph - create graph .
 * <p>SYNOPSIS</p>
 * <p>glp_graph *glp_create_graph(int v_size, int a_size);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine creates a new graph, which initially is empty, i.e. has no vertices and arcs.</p>
 * <p>The parameter v_size specifies the size of data associated with each vertex of the graph (0 to 256 bytes).</p>
 * <p>The parameter a_size specifies the size of data associated with each arc of the graph (0 to 256 bytes).</p>
 * <p>RETURNS</p>
 * <p>The routine returns a pointer to the graph created. </p>
 */
public";

%javamethodmodifiers glp_create_graph(int v_size, int a_size) "
/**
 */
public";

%javamethodmodifiers glp_set_graph_name(glp_graph *G, const char *name) "
/**
 * glp_set_graph_name - assign (change) graph name .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_graph_name(glp_graph *G, const char *name);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_graph_name assigns a symbolic name specified by the character string name (1 to 255 chars) to the graph.</p>
 * <p>If the parameter name is NULL or an empty string, the routine erases the existing symbolic name of the graph. </p>
 */
public";

%javamethodmodifiers glp_add_vertices(glp_graph *G, int nadd) "
/**
 * glp_add_vertices - add new vertices to graph .
 * <p>SYNOPSIS</p>
 * <p>int glp_add_vertices(glp_graph *G, int nadd);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_add_vertices adds nadd vertices to the specified graph. New vertices are always added to the end of the vertex list, so ordinal numbers of existing vertices remain unchanged.</p>
 * <p>Being added each new vertex is isolated (has no incident arcs).</p>
 * <p>RETURNS</p>
 * <p>The routine glp_add_vertices returns an ordinal number of the first new vertex added to the graph. </p>
 */
public";

%javamethodmodifiers glp_set_vertex_name(glp_graph *G, int i, const char *name) "
/**
 */
public";

%javamethodmodifiers glp_add_arc(glp_graph *G, int i, int j) "
/**
 * glp_add_arc - add new arc to graph .
 * <p>SYNOPSIS</p>
 * <p>glp_arc *glp_add_arc(glp_graph *G, int i, int j);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_add_arc adds a new arc to the specified graph.</p>
 * <p>The parameters i and j specify the ordinal numbers of, resp., tail and head vertices of the arc. Note that self-loops and multiple arcs are allowed.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_add_arc returns a pointer to the arc added. </p>
 */
public";

%javamethodmodifiers glp_del_vertices(glp_graph *G, int ndel, const int num[]) "
/**
 * glp_del_vertices - delete vertices from graph .
 * <p>SYNOPSIS</p>
 * <p>void glp_del_vertices(glp_graph *G, int ndel, const int num[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_del_vertices deletes vertices along with all incident arcs from the specified graph. Ordinal numbers of vertices to be deleted should be placed in locations num[1], ..., num[ndel], ndel > 0.</p>
 * <p>Note that deleting vertices involves changing ordinal numbers of other vertices remaining in the graph. New ordinal numbers of the remaining vertices are assigned under the assumption that the original order of vertices is not changed. </p>
 */
public";

%javamethodmodifiers glp_del_arc(glp_graph *G, glp_arc *a) "
/**
 * glp_del_arc - delete arc from graph .
 * <p>SYNOPSIS</p>
 * <p>void glp_del_arc(glp_graph *G, glp_arc *a);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_del_arc deletes an arc from the specified graph. The arc to be deleted must exist. </p>
 */
public";

%javamethodmodifiers delete_graph(glp_graph *G) "
/**
 * glp_erase_graph - erase graph content .
 * <p>SYNOPSIS</p>
 * <p>void glp_erase_graph(glp_graph *G, int v_size, int a_size);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_erase_graph erases the content of the specified graph. The effect of this operation is the same as if the graph would be deleted with the routine glp_delete_graph and then created anew with the routine glp_create_graph, with exception that the handle (pointer) to the graph remains valid. </p>
 */
public";

%javamethodmodifiers glp_erase_graph(glp_graph *G, int v_size, int a_size) "
/**
 */
public";

%javamethodmodifiers glp_delete_graph(glp_graph *G) "
/**
 * glp_delete_graph - delete graph .
 * <p>SYNOPSIS</p>
 * <p>void glp_delete_graph(glp_graph *G);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_delete_graph deletes the specified graph and frees all the memory allocated to this program object. </p>
 */
public";

%javamethodmodifiers glp_create_v_index(glp_graph *G) "
/**
 */
public";

%javamethodmodifiers glp_find_vertex(glp_graph *G, const char *name) "
/**
 */
public";

%javamethodmodifiers glp_delete_v_index(glp_graph *G) "
/**
 */
public";

%javamethodmodifiers glp_read_graph(glp_graph *G, const char *fname) "
/**
 * glp_read_graph - read graph from plain text file .
 * <p>SYNOPSIS</p>
 * <p>int glp_read_graph(glp_graph *G, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_read_graph reads a graph from a plain text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public";

%javamethodmodifiers glp_write_graph(glp_graph *G, const char *fname) "
/**
 * glp_write_graph - write graph to plain text file .
 * <p>SYNOPSIS</p>
 * <p>int glp_write_graph(glp_graph *G, const char *fname).</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_write_graph writes the specified graph to a plain text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public";

%javamethodmodifiers glp_weak_comp(glp_graph *G, int v_num) "
/**
 * glp_weak_comp - find all weakly connected components of graph .
 * <p>SYNOPSIS</p>
 * <p>int glp_weak_comp(glp_graph *G, int v_num);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_weak_comp finds all weakly connected components of the specified graph.</p>
 * <p>The parameter v_num specifies an offset of the field of type int in the vertex data block, to which the routine stores the number of a (weakly) connected component containing that vertex. If v_num < 0, no component numbers are stored.</p>
 * <p>The components are numbered in arbitrary order from 1 to nc, where nc is the total number of components found, 0 <= nc <= |V|.</p>
 * <p>RETURNS</p>
 * <p>The routine returns nc, the total number of components found. </p>
 */
public";

%javamethodmodifiers glp_strong_comp(glp_graph *G, int v_num) "
/**
 * glp_strong_comp - find all strongly connected components of graph .
 * <p>SYNOPSIS</p>
 * <p>int glp_strong_comp(glp_graph *G, int v_num);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_strong_comp finds all strongly connected components of the specified graph.</p>
 * <p>The parameter v_num specifies an offset of the field of type int in the vertex data block, to which the routine stores the number of a strongly connected component containing that vertex. If v_num < 0, no component numbers are stored.</p>
 * <p>The components are numbered in arbitrary order from 1 to nc, where nc is the total number of components found, 0 <= nc <= |V|. However, the component numbering has the property that for every arc (i->j) in the graph the condition num(i) >= num(j) holds.</p>
 * <p>RETURNS</p>
 * <p>The routine returns nc, the total number of components found. </p>
 */
public";

%javamethodmodifiers top_sort(glp_graph *G, int num[]) "
/**
 * glp_top_sort - topological sorting of acyclic digraph .
 * <p>SYNOPSIS</p>
 * <p>int glp_top_sort(glp_graph *G, int v_num);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_top_sort performs topological sorting of vertices of the specified acyclic digraph.</p>
 * <p>The parameter v_num specifies an offset of the field of type int in the vertex data block, to which the routine stores the vertex number assigned. If v_num < 0, vertex numbers are not stored.</p>
 * <p>The vertices are numbered from 1 to n, where n is the total number of vertices in the graph. The vertex numbering has the property that for every arc (i->j) in the graph the condition num(i) < num(j) holds. Special case num(i) = 0 means that vertex i is not assigned a number, because the graph is *not* acyclic.</p>
 * <p>RETURNS</p>
 * <p>If the graph is acyclic and therefore all the vertices have been assigned numbers, the routine glp_top_sort returns zero. Otherwise, if the graph is not acyclic, the routine returns the number of vertices which have not been numbered, i.e. for which num(i) = 0. </p>
 */
public";

%javamethodmodifiers glp_top_sort(glp_graph *G, int v_num) "
/**
 */
public";

%javamethodmodifiers glp_mincost_lp(glp_prob *lp, glp_graph *G, int names, int v_rhs, int a_low, int a_cap, int a_cost) "
/**
 * glp_mincost_lp - convert minimum cost flow problem to LP .
 * <p>SYNOPSIS</p>
 * <p>void glp_mincost_lp(glp_prob *lp, glp_graph *G, int names, int v_rhs, int a_low, int a_cap, int a_cost);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_mincost_lp builds an LP problem, which corresponds to the minimum cost flow problem on the specified network G. </p>
 */
public";

%javamethodmodifiers glp_mincost_okalg(glp_graph *G, int v_rhs, int a_low, int a_cap, int a_cost, double *sol, int a_x, int v_pi) "
/**
 */
public";

%javamethodmodifiers overflow(int u, int v) "
/**
 */
public";

%javamethodmodifiers glp_mincost_relax4(glp_graph *G, int v_rhs, int a_low, int a_cap, int a_cost, int crash, double *sol, int a_x, int a_rc) "
/**
 */
public";

%javamethodmodifiers glp_maxflow_lp(glp_prob *lp, glp_graph *G, int names, int s, int t, int a_cap) "
/**
 * glp_maxflow_lp - convert maximum flow problem to LP .
 * <p>SYNOPSIS</p>
 * <p>void glp_maxflow_lp(glp_prob *lp, glp_graph *G, int names, int s, int t, int a_cap);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_maxflow_lp builds an LP problem, which corresponds to the maximum flow problem on the specified network G. </p>
 */
public";

%javamethodmodifiers glp_maxflow_ffalg(glp_graph *G, int s, int t, int a_cap, double *sol, int a_x, int v_cut) "
/**
 */
public";

%javamethodmodifiers glp_check_asnprob(glp_graph *G, int v_set) "
/**
 * glp_check_asnprob - check correctness of assignment problem data .
 * <p>SYNOPSIS</p>
 * <p>int glp_check_asnprob(glp_graph *G, int v_set);</p>
 * <p>RETURNS</p>
 * <p>If the specified assignment problem data are correct, the routine glp_check_asnprob returns zero, otherwise, non-zero. </p>
 */
public";

%javamethodmodifiers glp_asnprob_lp(glp_prob *P, int form, glp_graph *G, int names, int v_set, int a_cost) "
/**
 * glp_asnprob_lp - convert assignment problem to LP .
 * <p>SYNOPSIS</p>
 * <p>int glp_asnprob_lp(glp_prob *P, int form, glp_graph *G, int names, int v_set, int a_cost);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_asnprob_lp builds an LP problem, which corresponds to the assignment problem on the specified graph G.</p>
 * <p>RETURNS</p>
 * <p>If the LP problem has been successfully built, the routine returns zero, otherwise, non-zero. </p>
 */
public";

%javamethodmodifiers glp_asnprob_okalg(int form, glp_graph *G, int v_set, int a_cost, double *sol, int a_x) "
/**
 */
public";

%javamethodmodifiers glp_asnprob_hall(glp_graph *G, int v_set, int a_x) "
/**
 * glp_asnprob_hall - find bipartite matching of maximum cardinality .
 * <p>SYNOPSIS</p>
 * <p>int glp_asnprob_hall(glp_graph *G, int v_set, int a_x);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_asnprob_hall finds a matching of maximal cardinality in the specified bipartite graph G. It uses a version of the Fortran routine MC21A developed by I.S.Duff [1], which implements Hall's algorithm [2].</p>
 * <p>RETURNS</p>
 * <p>The routine glp_asnprob_hall returns the cardinality of the matching found. However, if the specified graph is incorrect (as detected by the routine glp_check_asnprob), the routine returns negative value.</p>
 * <p>REFERENCES</p>
 * <p>1. I.S.Duff, Algorithm 575: Permutations for zero-free diagonal, ACM Trans. on Math. Softw. 7 (1981), 387-390.</p>
 * <p>2. M.Hall, \"An Algorithm for distinct representatives,\" Amer. Math. Monthly 63 (1956), 716-717. </p>
 */
public";

%javamethodmodifiers sorting(glp_graph *G, int list[]) "
/**
 * glp_cpp - solve critical path problem .
 * <p>SYNOPSIS</p>
 * <p>double glp_cpp(glp_graph *G, int v_t, int v_es, int v_ls);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_cpp solves the critical path problem represented in the form of the project network.</p>
 * <p>The parameter G is a pointer to the graph object, which specifies the project network. This graph must be acyclic. Multiple arcs are allowed being considered as single arcs.</p>
 * <p>The parameter v_t specifies an offset of the field of type double in the vertex data block, which contains time t[i] >= 0 needed to perform corresponding job j. If v_t < 0, it is assumed that t[i] = 1 for all jobs.</p>
 * <p>The parameter v_es specifies an offset of the field of type double in the vertex data block, to which the routine stores earliest start time for corresponding job. If v_es < 0, this time is not stored.</p>
 * <p>The parameter v_ls specifies an offset of the field of type double in the vertex data block, to which the routine stores latest start time for corresponding job. If v_ls < 0, this time is not stored.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_cpp returns the minimal project duration, that is, minimal time needed to perform all jobs in the project. </p>
 */
public";

%javamethodmodifiers glp_cpp(glp_graph *G, int v_t, int v_es, int v_ls) "
/**
 */
public";

%javamethodmodifiers set_edge(int nv, unsigned char a[], int i, int j) "
/**
 */
public";

%javamethodmodifiers glp_wclique_exact(glp_graph *G, int v_wgt, double *sol, int v_set) "
/**
 */
public";

%javamethodmodifiers glp_minisat1(glp_prob *P) "
/**
 */
public";

%javamethodmodifiers glp_intfeas1(glp_prob *P, int use_bound, int obj_bound) "
/**
 */
public";

%javamethodmodifiers print_help(const char *my_name) "
/**
 */
public";

%javamethodmodifiers print_version(int briefly) "
/**
 */
public";

%javamethodmodifiers parse_cmdline(struct csa *csa, int argc, const char *argv[]) "
/**
 */
public";

%javamethodmodifiers glp_main(int argc, const char *argv[]) "
/**
 */
public";

%javamethodmodifiers avl_create_tree(int(*fcmp)(void *info, const void *key1, const void *key2), void *info) "
/**
 */
public";

%javamethodmodifiers avl_strcmp(void *info, const void *key1, const void *key2) "
/**
 */
public";

%javamethodmodifiers rotate_subtree(AVL *tree, AVLNODE *node) "
/**
 */
public";

%javamethodmodifiers avl_insert_node(AVL *tree, const void *key) "
/**
 */
public";

%javamethodmodifiers avl_set_node_type(AVLNODE *node, int type) "
/**
 */
public";

%javamethodmodifiers avl_set_node_link(AVLNODE *node, void *link) "
/**
 */
public";

%javamethodmodifiers avl_find_node(AVL *tree, const void *key) "
/**
 */
public";

%javamethodmodifiers avl_get_node_type(AVLNODE *node) "
/**
 */
public";

%javamethodmodifiers avl_get_node_link(AVLNODE *node) "
/**
 */
public";

%javamethodmodifiers find_next_node(AVL *tree, AVLNODE *node) "
/**
 */
public";

%javamethodmodifiers avl_delete_node(AVL *tree, AVLNODE *node) "
/**
 */
public";

%javamethodmodifiers avl_delete_tree(AVL *tree) "
/**
 */
public";

%javamethodmodifiers avl_create_tree(int(*fcmp)(void *info, const void *key1, const void *key2), void *info) "
/**
 */
public";

%javamethodmodifiers avl_strcmp(void *info, const void *key1, const void *key2) "
/**
 */
public";

%javamethodmodifiers avl_insert_node(AVL *tree, const void *key) "
/**
 */
public";

%javamethodmodifiers avl_set_node_type(AVLNODE *node, int type) "
/**
 */
public";

%javamethodmodifiers avl_set_node_link(AVLNODE *node, void *link) "
/**
 */
public";

%javamethodmodifiers avl_find_node(AVL *tree, const void *key) "
/**
 */
public";

%javamethodmodifiers avl_get_node_type(AVLNODE *node) "
/**
 */
public";

%javamethodmodifiers avl_get_node_link(AVLNODE *node) "
/**
 */
public";

%javamethodmodifiers avl_delete_node(AVL *tree, AVLNODE *node) "
/**
 */
public";

%javamethodmodifiers avl_delete_tree(AVL *tree) "
/**
 */
public";

%javamethodmodifiers bfd_create_it(void) "
/**
 * bfd_create_it - create LP basis factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpbfd.h\" BFD *bfd_create_it(void);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine bfd_create_it creates a program object, which represents a factorization of LP basis.</p>
 * <p>RETURNS</p>
 * <p>The routine bfd_create_it returns a pointer to the object created. </p>
 */
public";

%javamethodmodifiers bfd_set_parm(BFD *bfd, const void *_parm) "
/**
 */
public";

%javamethodmodifiers bfd_factorize(BFD *bfd, int m, const int bh[], int(*col)(void *info, int j, int ind[], double val[]), void *info) "
/**
 * bfd_factorize - compute LP basis factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpbfd.h\" int bfd_factorize(BFD *bfd, int m, int bh[], int (*col)(void *info, int j, int ind[], double val[]), void *info);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine bfd_factorize computes the factorization of the basis matrix B specified by the routine col.</p>
 * <p>The parameter bfd specified the basis factorization data structure created with the routine bfd_create_it.</p>
 * <p>The parameter m specifies the order of B, m > 0.</p>
 * <p>The array bh specifies the basis header: bh[j], 1 <= j <= m, is the number of j-th column of B in some original matrix. The array bh is optional and can be specified as NULL.</p>
 * <p>The formal routine col specifies the matrix B to be factorized. To obtain j-th column of A the routine bfd_factorize calls the routine col with the parameter j (1 <= j <= n). In response the routine col should store row indices and numerical values of non-zero elements of j-th column of B to locations ind[1,...,len] and val[1,...,len], respectively, where len is the number of non-zeros in j-th column returned on exit. Neither zero nor duplicate elements are allowed.</p>
 * <p>The parameter info is a transit pointer passed to the routine col.</p>
 * <p>RETURNS</p>
 * <p>0 The factorization has been successfully computed.</p>
 * <p>BFD_ESING The specified matrix is singular within the working precision.</p>
 * <p>BFD_ECOND The specified matrix is ill-conditioned.</p>
 * <p>For more details see comments to the routine luf_factorize. </p>
 */
public";

%javamethodmodifiers bfd_ftran(BFD *bfd, double x[]) "
/**
 * bfd_ftran - perform forward transformation (solve system B*x = b) .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpbfd.h\" void bfd_ftran(BFD *bfd, double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine bfd_ftran performs forward transformation, i.e. solves the system B*x = b, where B is the basis matrix, x is the vector of unknowns to be computed, b is the vector of right-hand sides.</p>
 * <p>On entry elements of the vector b should be stored in dense format in locations x[1], ..., x[m], where m is the number of rows. On exit the routine stores elements of the vector x in the same locations. </p>
 */
public";

%javamethodmodifiers bfd_btran(BFD *bfd, double x[]) "
/**
 * bfd_btran - perform backward transformation (solve system B'*x = b) .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpbfd.h\" void bfd_btran(BFD *bfd, double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine bfd_btran performs backward transformation, i.e. solves the system B'*x = b, where B' is a matrix transposed to the basis matrix B, x is the vector of unknowns to be computed, b is the vector of right-hand sides.</p>
 * <p>On entry elements of the vector b should be stored in dense format in locations x[1], ..., x[m], where m is the number of rows. On exit the routine stores elements of the vector x in the same locations. </p>
 */
public";

%javamethodmodifiers bfd_update_it(BFD *bfd, int j, int bh, int len, const int ind[], const double val[]) "
/**
 * bfd_update_it - update LP basis factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpbfd.h\" int bfd_update_it(BFD *bfd, int j, int bh, int len, const int ind[], const double val[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine bfd_update_it updates the factorization of the basis matrix B after replacing its j-th column by a new vector.</p>
 * <p>The parameter j specifies the number of column of B, which has been replaced, 1 <= j <= m, where m is the order of B.</p>
 * <p>The parameter bh specifies the basis header entry for the new column of B, which is the number of the new column in some original matrix. This parameter is optional and can be specified as 0.</p>
 * <p>Row indices and numerical values of non-zero elements of the new column of B should be placed in locations ind[1], ..., ind[len] and val[1], ..., val[len], resp., where len is the number of non-zeros in the column. Neither zero nor duplicate elements are allowed.</p>
 * <p>RETURNS</p>
 * <p>0 The factorization has been successfully updated.</p>
 * <p>BFD_ESING New basis matrix is singular within the working precision.</p>
 * <p>BFD_ECHECK The factorization is inaccurate.</p>
 * <p>BFD_ELIMIT Factorization update limit has been reached.</p>
 * <p>BFD_EROOM Overflow of the sparse vector area.</p>
 * <p>In case of non-zero return code the factorization becomes invalid. It should not be used until it has been recomputed with the routine bfd_factorize. </p>
 */
public";

%javamethodmodifiers bfd_get_count(BFD *bfd) "
/**
 */
public";

%javamethodmodifiers bfd_delete_it(BFD *bfd) "
/**
 * bfd_delete_it - delete LP basis factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpbfd.h\" void bfd_delete_it(BFD *bfd);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine bfd_delete_it deletes LP basis factorization specified by the parameter fhv and frees all memory allocated to this program object. </p>
 */
public";

%javamethodmodifiers bfd_create_it(void) "
/**
 * bfd_create_it - create LP basis factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpbfd.h\" BFD *bfd_create_it(void);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine bfd_create_it creates a program object, which represents a factorization of LP basis.</p>
 * <p>RETURNS</p>
 * <p>The routine bfd_create_it returns a pointer to the object created. </p>
 */
public";

%javamethodmodifiers bfd_set_parm(BFD *bfd, const void *parm) "
/**
 */
public";

%javamethodmodifiers bfd_factorize(BFD *bfd, int m, const int bh[], int(*col)(void *info, int j, int ind[], double val[]), void *info) "
/**
 * bfd_factorize - compute LP basis factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpbfd.h\" int bfd_factorize(BFD *bfd, int m, int bh[], int (*col)(void *info, int j, int ind[], double val[]), void *info);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine bfd_factorize computes the factorization of the basis matrix B specified by the routine col.</p>
 * <p>The parameter bfd specified the basis factorization data structure created with the routine bfd_create_it.</p>
 * <p>The parameter m specifies the order of B, m > 0.</p>
 * <p>The array bh specifies the basis header: bh[j], 1 <= j <= m, is the number of j-th column of B in some original matrix. The array bh is optional and can be specified as NULL.</p>
 * <p>The formal routine col specifies the matrix B to be factorized. To obtain j-th column of A the routine bfd_factorize calls the routine col with the parameter j (1 <= j <= n). In response the routine col should store row indices and numerical values of non-zero elements of j-th column of B to locations ind[1,...,len] and val[1,...,len], respectively, where len is the number of non-zeros in j-th column returned on exit. Neither zero nor duplicate elements are allowed.</p>
 * <p>The parameter info is a transit pointer passed to the routine col.</p>
 * <p>RETURNS</p>
 * <p>0 The factorization has been successfully computed.</p>
 * <p>BFD_ESING The specified matrix is singular within the working precision.</p>
 * <p>BFD_ECOND The specified matrix is ill-conditioned.</p>
 * <p>For more details see comments to the routine luf_factorize. </p>
 */
public";

%javamethodmodifiers bfd_ftran(BFD *bfd, double x[]) "
/**
 * bfd_ftran - perform forward transformation (solve system B*x = b) .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpbfd.h\" void bfd_ftran(BFD *bfd, double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine bfd_ftran performs forward transformation, i.e. solves the system B*x = b, where B is the basis matrix, x is the vector of unknowns to be computed, b is the vector of right-hand sides.</p>
 * <p>On entry elements of the vector b should be stored in dense format in locations x[1], ..., x[m], where m is the number of rows. On exit the routine stores elements of the vector x in the same locations. </p>
 */
public";

%javamethodmodifiers bfd_btran(BFD *bfd, double x[]) "
/**
 * bfd_btran - perform backward transformation (solve system B'*x = b) .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpbfd.h\" void bfd_btran(BFD *bfd, double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine bfd_btran performs backward transformation, i.e. solves the system B'*x = b, where B' is a matrix transposed to the basis matrix B, x is the vector of unknowns to be computed, b is the vector of right-hand sides.</p>
 * <p>On entry elements of the vector b should be stored in dense format in locations x[1], ..., x[m], where m is the number of rows. On exit the routine stores elements of the vector x in the same locations. </p>
 */
public";

%javamethodmodifiers bfd_update_it(BFD *bfd, int j, int bh, int len, const int ind[], const double val[]) "
/**
 * bfd_update_it - update LP basis factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpbfd.h\" int bfd_update_it(BFD *bfd, int j, int bh, int len, const int ind[], const double val[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine bfd_update_it updates the factorization of the basis matrix B after replacing its j-th column by a new vector.</p>
 * <p>The parameter j specifies the number of column of B, which has been replaced, 1 <= j <= m, where m is the order of B.</p>
 * <p>The parameter bh specifies the basis header entry for the new column of B, which is the number of the new column in some original matrix. This parameter is optional and can be specified as 0.</p>
 * <p>Row indices and numerical values of non-zero elements of the new column of B should be placed in locations ind[1], ..., ind[len] and val[1], ..., val[len], resp., where len is the number of non-zeros in the column. Neither zero nor duplicate elements are allowed.</p>
 * <p>RETURNS</p>
 * <p>0 The factorization has been successfully updated.</p>
 * <p>BFD_ESING New basis matrix is singular within the working precision.</p>
 * <p>BFD_ECHECK The factorization is inaccurate.</p>
 * <p>BFD_ELIMIT Factorization update limit has been reached.</p>
 * <p>BFD_EROOM Overflow of the sparse vector area.</p>
 * <p>In case of non-zero return code the factorization becomes invalid. It should not be used until it has been recomputed with the routine bfd_factorize. </p>
 */
public";

%javamethodmodifiers bfd_get_count(BFD *bfd) "
/**
 */
public";

%javamethodmodifiers bfd_delete_it(BFD *bfd) "
/**
 * bfd_delete_it - delete LP basis factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpbfd.h\" void bfd_delete_it(BFD *bfd);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine bfd_delete_it deletes LP basis factorization specified by the parameter fhv and frees all memory allocated to this program object. </p>
 */
public";

%javamethodmodifiers bfx_create_binv(void) "
/**
 */
public";

%javamethodmodifiers bfx_factorize(BFX *binv, int m, int(*col)(void *info, int j, int ind[], mpq_t val[]), void *info) "
/**
 */
public";

%javamethodmodifiers bfx_ftran(BFX *binv, mpq_t x[], int save) "
/**
 */
public";

%javamethodmodifiers bfx_btran(BFX *binv, mpq_t x[]) "
/**
 */
public";

%javamethodmodifiers bfx_update(BFX *binv, int j) "
/**
 */
public";

%javamethodmodifiers bfx_delete_binv(BFX *binv) "
/**
 */
public";

%javamethodmodifiers bfx_create_binv(void) "
/**
 */
public";

%javamethodmodifiers bfx_is_valid(BFX *binv) "
/**
 */
public";

%javamethodmodifiers bfx_invalidate(BFX *binv) "
/**
 */
public";

%javamethodmodifiers bfx_factorize(BFX *binv, int m, int(*col)(void *info, int j, int ind[], mpq_t val[]), void *info) "
/**
 */
public";

%javamethodmodifiers bfx_ftran(BFX *binv, mpq_t x[], int save) "
/**
 */
public";

%javamethodmodifiers bfx_btran(BFX *binv, mpq_t x[]) "
/**
 */
public";

%javamethodmodifiers bfx_update(BFX *binv, int j) "
/**
 */
public";

%javamethodmodifiers bfx_delete_binv(BFX *binv) "
/**
 */
public";

%javamethodmodifiers glp_init_cpxcp(glp_cpxcp *parm) "
/**
 * glp_init_cpxcp - initialize CPLEX LP format control parameters .
 * <p>SYNOPSIS</p>
 * <p>void glp_init_cpxcp(glp_cpxcp *parm):</p>
 * <p>The routine glp_init_cpxcp initializes control parameters used by the CPLEX LP input/output routines glp_read_lp and glp_write_lp with default values.</p>
 * <p>Default values of the control parameters are stored in the glp_cpxcp structure, which the parameter parm points to. </p>
 */
public";

%javamethodmodifiers check_parm(const char *func, const glp_cpxcp *parm) "
/**
 */
public";

%javamethodmodifiers error(struct csa *csa, const char *fmt,...) "
/**
 */
public";

%javamethodmodifiers warning(struct csa *csa, const char *fmt,...) "
/**
 */
public";

%javamethodmodifiers read_char(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers add_char(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers the_same(char *s1, char *s2) "
/**
 */
public";

%javamethodmodifiers scan_token(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers find_col(struct csa *csa, char *name) "
/**
 */
public";

%javamethodmodifiers parse_linear_form(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers parse_objective(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers parse_constraints(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers set_lower_bound(struct csa *csa, int j, double lb) "
/**
 */
public";

%javamethodmodifiers set_upper_bound(struct csa *csa, int j, double ub) "
/**
 */
public";

%javamethodmodifiers parse_bounds(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers parse_integer(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers glp_read_lp(glp_prob *P, const glp_cpxcp *parm, const char *fname) "
/**
 */
public";

%javamethodmodifiers check_name(char *name) "
/**
 */
public";

%javamethodmodifiers adjust_name(char *name) "
/**
 */
public";

%javamethodmodifiers row_name(struct csa *csa, int i, char rname[255+1]) "
/**
 */
public";

%javamethodmodifiers col_name(struct csa *csa, int j, char cname[255+1]) "
/**
 */
public";

%javamethodmodifiers glp_write_lp(glp_prob *P, const glp_cpxcp *parm, const char *fname) "
/**
 */
public";

%javamethodmodifiers dmp_create_pool(void) "
/**
 * dmp_create_pool - create dynamic memory pool .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpdmp.h\" DMP *dmp_create_pool(void);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine dmp_create_pool creates a dynamic memory pool.</p>
 * <p>RETURNS</p>
 * <p>The routine returns a pointer to the memory pool created. </p>
 */
public";

%javamethodmodifiers dmp_get_atom(DMP *pool, int size) "
/**
 * dmp_get_atom - get free atom from dynamic memory pool .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpdmp.h\" void *dmp_get_atom(DMP *pool, int size);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine dmp_get_atom obtains a free atom (memory block) from the specified memory pool.</p>
 * <p>The parameter size is the atom size, in bytes, 1 <= size <= 256.</p>
 * <p>Note that the free atom contains arbitrary data, not binary zeros.</p>
 * <p>RETURNS</p>
 * <p>The routine returns a pointer to the free atom obtained. </p>
 */
public";

%javamethodmodifiers dmp_free_atom(DMP *pool, void *atom, int size) "
/**
 * dmp_free_atom - return atom to dynamic memory pool .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpdmp.h\" void dmp_free_atom(DMP *pool, void *atom, int size);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine dmp_free_atom returns the specified atom (memory block) to the specified memory pool, making it free.</p>
 * <p>The parameter size is the atom size, in bytes, 1 <= size <= 256.</p>
 * <p>Note that the atom can be returned only to the pool, from which it was obtained, and its size must be exactly the same as on obtaining it from the pool. </p>
 */
public";

%javamethodmodifiers dmp_in_use(DMP *pool) "
/**
 * dmp_in_use - determine how many atoms are still in use .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpdmp.h\" glp_long dmp_in_use(DMP *pool);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine dmp_in_use determines how many atoms allocated from the specified memory pool with the routine dmp_get_atom are still in use, i.e. not returned to the pool with the routine dmp_free_atom.</p>
 * <p>RETURNS</p>
 * <p>The routine returns the number of atoms which are still in use. </p>
 */
public";

%javamethodmodifiers dmp_delete_pool(DMP *pool) "
/**
 * dmp_delete_pool - delete dynamic memory pool .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpdmp.h\" void dmp_delete_pool(DMP *pool);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine dmp_delete_pool deletes the specified dynamic memory pool and frees all the memory allocated to this object. </p>
 */
public";

%javamethodmodifiers dmp_create_pool(void) "
/**
 * dmp_create_pool - create dynamic memory pool .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpdmp.h\" DMP *dmp_create_pool(void);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine dmp_create_pool creates a dynamic memory pool.</p>
 * <p>RETURNS</p>
 * <p>The routine returns a pointer to the memory pool created. </p>
 */
public";

%javamethodmodifiers dmp_get_atom(DMP *pool, int size) "
/**
 * dmp_get_atom - get free atom from dynamic memory pool .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpdmp.h\" void *dmp_get_atom(DMP *pool, int size);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine dmp_get_atom obtains a free atom (memory block) from the specified memory pool.</p>
 * <p>The parameter size is the atom size, in bytes, 1 <= size <= 256.</p>
 * <p>Note that the free atom contains arbitrary data, not binary zeros.</p>
 * <p>RETURNS</p>
 * <p>The routine returns a pointer to the free atom obtained. </p>
 */
public";

%javamethodmodifiers dmp_free_atom(DMP *pool, void *atom, int size) "
/**
 * dmp_free_atom - return atom to dynamic memory pool .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpdmp.h\" void dmp_free_atom(DMP *pool, void *atom, int size);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine dmp_free_atom returns the specified atom (memory block) to the specified memory pool, making it free.</p>
 * <p>The parameter size is the atom size, in bytes, 1 <= size <= 256.</p>
 * <p>Note that the atom can be returned only to the pool, from which it was obtained, and its size must be exactly the same as on obtaining it from the pool. </p>
 */
public";

%javamethodmodifiers dmp_in_use(DMP *pool) "
/**
 * dmp_in_use - determine how many atoms are still in use .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpdmp.h\" glp_long dmp_in_use(DMP *pool);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine dmp_in_use determines how many atoms allocated from the specified memory pool with the routine dmp_get_atom are still in use, i.e. not returned to the pool with the routine dmp_free_atom.</p>
 * <p>RETURNS</p>
 * <p>The routine returns the number of atoms which are still in use. </p>
 */
public";

%javamethodmodifiers dmp_delete_pool(DMP *pool) "
/**
 * dmp_delete_pool - delete dynamic memory pool .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpdmp.h\" void dmp_delete_pool(DMP *pool);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine dmp_delete_pool deletes the specified dynamic memory pool and frees all the memory allocated to this object. </p>
 */
public";

%javamethodmodifiers error(struct csa *csa, const char *fmt,...) "
/**
 */
public";

%javamethodmodifiers warning(struct csa *csa, const char *fmt,...) "
/**
 */
public";

%javamethodmodifiers read_char(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers read_designator(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers read_field(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers end_of_line(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers check_int(struct csa *csa, double num) "
/**
 */
public";

%javamethodmodifiers glp_read_mincost(glp_graph *G, int v_rhs, int a_low, int a_cap, int a_cost, const char *fname) "
/**
 * glp_read_mincost - read min-cost flow problem data in DIMACS format .
 * <p>SYNOPSIS</p>
 * <p>int glp_read_mincost(glp_graph *G, int v_rhs, int a_low, int a_cap, int a_cost, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_read_mincost reads minimum cost flow problem data in DIMACS format from a text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public";

%javamethodmodifiers glp_write_mincost(glp_graph *G, int v_rhs, int a_low, int a_cap, int a_cost, const char *fname) "
/**
 * glp_write_mincost - write min-cost flow problem data in DIMACS format .
 * <p>SYNOPSIS</p>
 * <p>int glp_write_mincost(glp_graph *G, int v_rhs, int a_low, int a_cap, int a_cost, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_write_mincost writes minimum cost flow problem data in DIMACS format to a text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public";

%javamethodmodifiers glp_read_maxflow(glp_graph *G, int *_s, int *_t, int a_cap, const char *fname) "
/**
 * glp_read_maxflow - read maximum flow problem data in DIMACS format .
 * <p>SYNOPSIS</p>
 * <p>int glp_read_maxflow(glp_graph *G, int *s, int *t, int a_cap, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_read_maxflow reads maximum flow problem data in DIMACS format from a text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public";

%javamethodmodifiers glp_write_maxflow(glp_graph *G, int s, int t, int a_cap, const char *fname) "
/**
 * glp_write_maxflow - write maximum flow problem data in DIMACS format .
 * <p>SYNOPSIS</p>
 * <p>int glp_write_maxflow(glp_graph *G, int s, int t, int a_cap, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_write_maxflow writes maximum flow problem data in DIMACS format to a text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public";

%javamethodmodifiers glp_read_asnprob(glp_graph *G, int v_set, int a_cost, const char *fname) "
/**
 * glp_read_asnprob - read assignment problem data in DIMACS format .
 * <p>SYNOPSIS</p>
 * <p>int glp_read_asnprob(glp_graph *G, int v_set, int a_cost, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_read_asnprob reads assignment problem data in DIMACS format from a text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public";

%javamethodmodifiers glp_write_asnprob(glp_graph *G, int v_set, int a_cost, const char *fname) "
/**
 * glp_write_asnprob - write assignment problem data in DIMACS format .
 * <p>SYNOPSIS</p>
 * <p>int glp_write_asnprob(glp_graph *G, int v_set, int a_cost, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_write_asnprob writes assignment problem data in DIMACS format to a text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public";

%javamethodmodifiers glp_read_ccdata(glp_graph *G, int v_wgt, const char *fname) "
/**
 * glp_read_ccdata - read graph in DIMACS clique/coloring format .
 * <p>SYNOPSIS</p>
 * <p>int glp_read_ccdata(glp_graph *G, int v_wgt, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_read_ccdata reads an (undirected) graph in DIMACS clique/coloring format from a text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public";

%javamethodmodifiers glp_write_ccdata(glp_graph *G, int v_wgt, const char *fname) "
/**
 * glp_write_ccdata - write graph in DIMACS clique/coloring format .
 * <p>SYNOPSIS</p>
 * <p>int glp_write_ccdata(glp_graph *G, int v_wgt, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_write_ccdata writes the specified graph in DIMACS clique/coloring format to a text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public";

%javamethodmodifiers glp_read_prob(glp_prob *P, int flags, const char *fname) "
/**
 * glp_read_prob - read problem data in GLPK format .
 * <p>SYNOPSIS</p>
 * <p>int glp_read_prob(glp_prob *P, int flags, const char *fname);</p>
 * <p>The routine glp_read_prob reads problem data in GLPK LP/MIP format from a text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public";

%javamethodmodifiers glp_write_prob(glp_prob *P, int flags, const char *fname) "
/**
 * glp_write_prob - write problem data in GLPK format .
 * <p>SYNOPSIS</p>
 * <p>int glp_write_prob(glp_prob *P, int flags, const char *fname);</p>
 * <p>The routine glp_write_prob writes problem data in GLPK LP/MIP format to a text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public";

%javamethodmodifiers glp_read_cnfsat(glp_prob *P, const char *fname) "
/**
 */
public";

%javamethodmodifiers glp_check_cnfsat(glp_prob *P) "
/**
 */
public";

%javamethodmodifiers glp_write_cnfsat(glp_prob *P, const char *fname) "
/**
 */
public";

%javamethodmodifiers get_env_ptr(void) "
/**
 * get_env_ptr - retrieve pointer to environment block .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpenv.h\" ENV *get_env_ptr(void);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine get_env_ptr retrieves and returns a pointer to the GLPK environment block.</p>
 * <p>If the GLPK environment has not been initialized yet, the routine performs initialization. If initialization fails, the routine prints an error message to stderr and terminates the program.</p>
 * <p>RETURNS</p>
 * <p>The routine returns a pointer to the environment block. </p>
 */
public";

%javamethodmodifiers tls_set_ptr(void *ptr) "
/**
 * tls_set_ptr - store global pointer in TLS .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpenv.h\" void tls_set_ptr(void *ptr);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine tls_set_ptr stores a pointer specified by the parameter ptr in the Thread Local Storage (TLS). </p>
 */
public";

%javamethodmodifiers tls_get_ptr(void) "
/**
 * tls_get_ptr - retrieve global pointer from TLS .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpenv.h\" void *tls_get_ptr(void);</p>
 * <p>RETURNS</p>
 * <p>The routine tls_get_ptr returns a pointer previously stored by the routine tls_set_ptr. If the latter has not been called yet, NULL is returned. </p>
 */
public";

%javamethodmodifiers glp_printf(const char *fmt,...) "
/**
 * glp_printf - write formatted output to terminal .
 * <p>SYNOPSIS</p>
 * <p>void glp_printf(const char *fmt, ...);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_printf uses the format control string fmt to format its parameters and writes the formatted output to the terminal. </p>
 */
public";

%javamethodmodifiers glp_vprintf(const char *fmt, va_list arg) "
/**
 * glp_vprintf - write formatted output to terminal .
 * <p>SYNOPSIS</p>
 * <p>void glp_vprintf(const char *fmt, va_list arg);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_vprintf uses the format control string fmt to format its parameters specified by the list arg and writes the formatted output to the terminal. </p>
 */
public";

%javamethodmodifiers glp_error_(const char *file, int line) "
/**
 */
public";

%javamethodmodifiers glp_assert_(const char *expr, const char *file, int line) "
/**
 * glp_assert - check for logical condition .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" void glp_assert(int expr);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_assert (implemented as a macro) checks for a logical condition specified by the parameter expr. If the condition is false (i.e. the value of expr is zero), the routine writes a message to the terminal and abnormally terminates the program. </p>
 */
public";

%javamethodmodifiers glp_malloc(int size) "
/**
 * glp_malloc - allocate memory block .
 * <p>SYNOPSIS</p>
 * <p>void *glp_malloc(int size);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_malloc allocates a memory block of size bytes long.</p>
 * <p>Note that being allocated the memory block contains arbitrary data (not binary zeros).</p>
 * <p>RETURNS</p>
 * <p>The routine glp_malloc returns a pointer to the allocated block. To free this block the routine glp_free (not free!) must be used. </p>
 */
public";

%javamethodmodifiers glp_calloc(int n, int size) "
/**
 * glp_calloc - allocate memory block .
 * <p>SYNOPSIS</p>
 * <p>void *glp_calloc(int n, int size);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_calloc allocates a memory block of n * size bytes long.</p>
 * <p>Note that being allocated the memory block contains arbitrary data (not binary zeros).</p>
 * <p>RETURNS</p>
 * <p>The routine glp_calloc returns a pointer to the allocated block. To free this block the routine glp_free (not free!) must be used. </p>
 */
public";

%javamethodmodifiers glp_realloc(void *ptr, int n, int size) "
/**
 */
public";

%javamethodmodifiers glp_free(void *ptr) "
/**
 * glp_free - free memory block .
 * <p>SYNOPSIS</p>
 * <p>void glp_free(void *ptr);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_free frees a memory block pointed to by ptr, which was previuosly allocated by the routine glp_malloc or glp_calloc. </p>
 */
public";

%javamethodmodifiers glp_time(void) "
/**
 */
public";

%javamethodmodifiers glp_difftime(glp_long t1, glp_long t0) "
/**
 * glp_difftime - compute difference between two time values .
 * <p>SYNOPSIS</p>
 * <p>double glp_difftime(glp_long t1, glp_long t0);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_difftime returns the difference between two time values t1 and t0, expressed in seconds. </p>
 */
public";

%javamethodmodifiers lib_err_msg(const char *msg) "
/**
 * lib_err_msg - save error message string .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpenv.h\" void lib_err_msg(const char *msg);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine lib_err_msg saves an error message string specified by the parameter msg. The message is obtained by some library routines with a call to strerror(errno). </p>
 */
public";

%javamethodmodifiers xerrmsg(void) "
/**
 * xerrmsg - retrieve error message string .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpenv.h\" const char *xerrmsg(void);</p>
 * <p>RETURNS</p>
 * <p>The routine xerrmsg returns a pointer to an error message string previously set by some library routine to indicate an error. </p>
 */
public";

%javamethodmodifiers xfopen(const char *fname, const char *mode) "
/**
 */
public";

%javamethodmodifiers xferror(XFILE *file) "
/**
 */
public";

%javamethodmodifiers xfeof(XFILE *file) "
/**
 */
public";

%javamethodmodifiers xfgetc(XFILE *file) "
/**
 */
public";

%javamethodmodifiers xfputc(int c, XFILE *file) "
/**
 */
public";

%javamethodmodifiers xfflush(XFILE *fp) "
/**
 */
public";

%javamethodmodifiers xfclose(XFILE *file) "
/**
 */
public";

%javamethodmodifiers xfprintf(XFILE *file, const char *fmt,...) "
/**
 */
public";

%javamethodmodifiers xdlopen(const char *module) "
/**
 */
public";

%javamethodmodifiers xdlsym(void *h, const char *symbol) "
/**
 */
public";

%javamethodmodifiers xdlclose(void *h) "
/**
 */
public";

%javamethodmodifiers glp_init_env(void) "
/**
 * glp_init_env - initialize GLPK environment .
 * <p>SYNOPSIS</p>
 * <p>int glp_init_env(void);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_init_env initializes the GLPK environment. Normally the application program does not need to call this routine, because it is called automatically on the first call to any API routine.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_init_env returns one of the following codes:</p>
 * <p>0 - initialization successful; 1 - environment has been already initialized; 2 - initialization failed (insufficient memory); 3 - initialization failed (unsupported programming model). </p>
 */
public";

%javamethodmodifiers get_env_ptr(void) "
/**
 * get_env_ptr - retrieve pointer to environment block .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpenv.h\" ENV *get_env_ptr(void);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine get_env_ptr retrieves and returns a pointer to the GLPK environment block.</p>
 * <p>If the GLPK environment has not been initialized yet, the routine performs initialization. If initialization fails, the routine prints an error message to stderr and terminates the program.</p>
 * <p>RETURNS</p>
 * <p>The routine returns a pointer to the environment block. </p>
 */
public";

%javamethodmodifiers glp_version(void) "
/**
 * glp_version - determine library version .
 * <p>SYNOPSIS</p>
 * <p>const char *glp_version(void);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_version returns a pointer to a null-terminated character string, which specifies the version of the GLPK library in the form \"X.Y\", where X is the major version number, and Y is the minor version number, for example, \"4.16\". </p>
 */
public";

%javamethodmodifiers glp_free_env(void) "
/**
 * glp_free_env - free GLPK environment .
 * <p>SYNOPSIS</p>
 * <p>int glp_free_env(void);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_free_env frees all resources used by GLPK routines (memory blocks, etc.) which are currently still in use.</p>
 * <p>Normally the application program does not need to call this routine, because GLPK routines always free all unused resources. However, if the application program even has deleted all problem objects, there will be several memory blocks still allocated for the library needs. For some reasons the application program may want GLPK to free this memory, in which case it should call glp_free_env.</p>
 * <p>Note that a call to glp_free_env invalidates all problem objects as if no GLPK routine were called.</p>
 * <p>RETURNS</p>
 * <p>0 - termination successful; 1 - environment is inactive (was not initialized). </p>
 */
public";

%javamethodmodifiers tls_set_ptr(void *ptr) "
/**
 * tls_set_ptr - store global pointer in TLS .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpenv.h\" void tls_set_ptr(void *ptr);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine tls_set_ptr stores a pointer specified by the parameter ptr in the Thread Local Storage (TLS). </p>
 */
public";

%javamethodmodifiers tls_get_ptr(void) "
/**
 * tls_get_ptr - retrieve global pointer from TLS .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpenv.h\" void *tls_get_ptr(void);</p>
 * <p>RETURNS</p>
 * <p>The routine tls_get_ptr returns a pointer previously stored by the routine tls_set_ptr. If the latter has not been called yet, NULL is returned. </p>
 */
public";

%javamethodmodifiers glp_printf(const char *fmt,...) "
/**
 * glp_printf - write formatted output to terminal .
 * <p>SYNOPSIS</p>
 * <p>void glp_printf(const char *fmt, ...);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_printf uses the format control string fmt to format its parameters and writes the formatted output to the terminal. </p>
 */
public";

%javamethodmodifiers glp_vprintf(const char *fmt, va_list arg) "
/**
 * glp_vprintf - write formatted output to terminal .
 * <p>SYNOPSIS</p>
 * <p>void glp_vprintf(const char *fmt, va_list arg);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_vprintf uses the format control string fmt to format its parameters specified by the list arg and writes the formatted output to the terminal. </p>
 */
public";

%javamethodmodifiers glp_term_out(int flag) "
/**
 * glp_term_out - enable/disable terminal output .
 * <p>SYNOPSIS</p>
 * <p>int glp_term_out(int flag);</p>
 * <p>DESCRIPTION</p>
 * <p>Depending on the parameter flag the routine glp_term_out enables or disables terminal output performed by glpk routines:</p>
 * <p>GLP_ON - enable terminal output; GLP_OFF - disable terminal output.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_term_out returns the previous value of the terminal output flag. </p>
 */
public";

%javamethodmodifiers glp_term_hook(int(*func)(void *info, const char *s), void *info) "
/**
 * glp_term_hook - install hook to intercept terminal output .
 * <p>SYNOPSIS</p>
 * <p>void glp_term_hook(int (*func)(void *info, const char *s), void *info);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_term_hook installs a user-defined hook routine to intercept all terminal output performed by glpk routines.</p>
 * <p>This feature can be used to redirect the terminal output to other destination, for example to a file or a text window.</p>
 * <p>The parameter func specifies the user-defined hook routine. It is called from an internal printing routine, which passes to it two parameters: info and s. The parameter info is a transit pointer, specified in the corresponding call to the routine glp_term_hook; it may be used to pass some information to the hook routine. The parameter s is a pointer to the null terminated character string, which is intended to be written to the terminal. If the hook routine returns zero, the printing routine writes the string s to the terminal in a usual way; otherwise, if the hook routine returns non-zero, no terminal output is performed.</p>
 * <p>To uninstall the hook routine the parameters func and info should be specified as NULL. </p>
 */
public";

%javamethodmodifiers glp_open_tee(const char *fname) "
/**
 * glp_open_tee - start copying terminal output to text file .
 * <p>SYNOPSIS</p>
 * <p>int glp_open_tee(const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_open_tee starts copying all the terminal output to an output text file, whose name is specified by the character string fname.</p>
 * <p>RETURNS</p>
 * <p>0 - operation successful 1 - copying terminal output is already active 2 - unable to create output file </p>
 */
public";

%javamethodmodifiers glp_close_tee(void) "
/**
 * glp_close_tee - stop copying terminal output to text file .
 * <p>SYNOPSIS</p>
 * <p>int glp_close_tee(void);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_close_tee stops copying the terminal output to the output text file previously open by the routine glp_open_tee closing that file.</p>
 * <p>RETURNS</p>
 * <p>0 - operation successful 1 - copying terminal output was not started </p>
 */
public";

%javamethodmodifiers error(const char *fmt,...) "
/**
 * glp_error - display error message and terminate execution .
 * <p>SYNOPSIS</p>
 * <p>void glp_error(const char *fmt, ...);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_error (implemented as a macro) formats its parameters using the format control string fmt, writes the formatted message to the terminal, and abnormally terminates the program. </p>
 */
public";

%javamethodmodifiers glp_error_(const char *file, int line) "
/**
 */
public";

%javamethodmodifiers glp_assert_(const char *expr, const char *file, int line) "
/**
 * glp_assert - check for logical condition .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" void glp_assert(int expr);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_assert (implemented as a macro) checks for a logical condition specified by the parameter expr. If the condition is false (i.e. the value of expr is zero), the routine writes a message to the terminal and abnormally terminates the program. </p>
 */
public";

%javamethodmodifiers glp_error_hook(void(*func)(void *info), void *info) "
/**
 * glp_error_hook - install hook to intercept abnormal termination .
 * <p>SYNOPSIS</p>
 * <p>void glp_error_hook(void (*func)(void *info), void *info);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_error_hook installs a user-defined hook routine to intercept abnormal termination.</p>
 * <p>The parameter func specifies the user-defined hook routine. It is called from the routine glp_error before the latter calls the abort function to abnormally terminate the application program because of fatal error. The parameter info is a transit pointer, specified in the corresponding call to the routine glp_error_hook; it may be used to pass some information to the hook routine.</p>
 * <p>To uninstall the hook routine the parameters func and info should be specified as NULL. </p>
 */
public";

%javamethodmodifiers dma(const char *func, void *ptr, size_t size) "
/**
 */
public";

%javamethodmodifiers glp_malloc(int size) "
/**
 * glp_malloc - allocate memory block .
 * <p>SYNOPSIS</p>
 * <p>void *glp_malloc(int size);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_malloc allocates a memory block of size bytes long.</p>
 * <p>Note that being allocated the memory block contains arbitrary data (not binary zeros).</p>
 * <p>RETURNS</p>
 * <p>The routine glp_malloc returns a pointer to the allocated block. To free this block the routine glp_free (not free!) must be used. </p>
 */
public";

%javamethodmodifiers glp_calloc(int n, int size) "
/**
 * glp_calloc - allocate memory block .
 * <p>SYNOPSIS</p>
 * <p>void *glp_calloc(int n, int size);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_calloc allocates a memory block of n * size bytes long.</p>
 * <p>Note that being allocated the memory block contains arbitrary data (not binary zeros).</p>
 * <p>RETURNS</p>
 * <p>The routine glp_calloc returns a pointer to the allocated block. To free this block the routine glp_free (not free!) must be used. </p>
 */
public";

%javamethodmodifiers glp_realloc(void *ptr, int n, int size) "
/**
 */
public";

%javamethodmodifiers glp_free(void *ptr) "
/**
 * glp_free - free memory block .
 * <p>SYNOPSIS</p>
 * <p>void glp_free(void *ptr);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_free frees a memory block pointed to by ptr, which was previuosly allocated by the routine glp_malloc or glp_calloc. </p>
 */
public";

%javamethodmodifiers glp_mem_limit(int limit) "
/**
 * glp_mem_limit - set memory usage limit .
 * <p>SYNOPSIS</p>
 * <p>void glp_mem_limit(int limit);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_mem_limit limits the amount of memory available for dynamic allocation (in GLPK routines) to limit megabytes. </p>
 */
public";

%javamethodmodifiers glp_mem_usage(int *count, int *cpeak, size_t *total, size_t *tpeak) "
/**
 * glp_mem_usage - get memory usage information .
 * <p>SYNOPSIS</p>
 * <p>void glp_mem_usage(int *count, int *cpeak, size_t *total, size_t *tpeak);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_mem_usage reports some information about utilization of the memory by GLPK routines. Information is stored to locations specified by corresponding parameters (see below). Any parameter can be specified as NULL, in which case its value is not stored.</p>
 * <p>*count is the number of the memory blocks currently allocated by the routines glp_malloc and glp_calloc (one call to glp_malloc or glp_calloc results in allocating one memory block).</p>
 * <p>*cpeak is the peak value of *count reached since the initialization of the GLPK library environment.</p>
 * <p>*total is the total amount, in bytes, of the memory blocks currently allocated by the routines glp_malloc and glp_calloc.</p>
 * <p>*tpeak is the peak value of *total reached since the initialization of the GLPK library envirionment. </p>
 */
public";

%javamethodmodifiers glp_time(void) "
/**
 */
public";

%javamethodmodifiers glp_difftime(glp_long t1, glp_long t0) "
/**
 * glp_difftime - compute difference between two time values .
 * <p>SYNOPSIS</p>
 * <p>double glp_difftime(glp_long t1, glp_long t0);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_difftime returns the difference between two time values t1 and t0, expressed in seconds. </p>
 */
public";

%javamethodmodifiers lib_err_msg(const char *msg) "
/**
 * lib_err_msg - save error message string .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpenv.h\" void lib_err_msg(const char *msg);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine lib_err_msg saves an error message string specified by the parameter msg. The message is obtained by some library routines with a call to strerror(errno). </p>
 */
public";

%javamethodmodifiers xerrmsg(void) "
/**
 * xerrmsg - retrieve error message string .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpenv.h\" const char *xerrmsg(void);</p>
 * <p>RETURNS</p>
 * <p>The routine xerrmsg returns a pointer to an error message string previously set by some library routine to indicate an error. </p>
 */
public";

%javamethodmodifiers c_fopen(const char *fname, const char *mode) "
/**
 * xfopen - open a stream .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpenv.h\" XFILE *xfopen(const char *fname, const char *mode);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine xfopen opens the file whose name is a string pointed to by fname and associates a stream with it.</p>
 * <p>The parameter mode points to a string, which indicates the open mode and should be one of the following:</p>
 * <p>\"r\" open text file for reading; \"w\" truncate to zero length or create text file for writing; \"rb\" open binary file for reading; \"wb\" truncate to zero length or create binary file for writing.</p>
 * <p>RETURNS</p>
 * <p>The routine xfopen returns a pointer to the object controlling the stream. If the open operation fails, xfopen returns NULL. </p>
 */
public";

%javamethodmodifiers z_fopen(const char *fname, const char *mode) "
/**
 */
public";

%javamethodmodifiers is_gz_file(const char *fname) "
/**
 */
public";

%javamethodmodifiers xfopen(const char *fname, const char *mode) "
/**
 */
public";

%javamethodmodifiers c_fgetc(void *fh) "
/**
 * xfgetc - read character from the stream .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpenv.h\" int xfgetc(XFILE *fp);</p>
 * <p>DESCRIPTION</p>
 * <p>If the end-of-file indicator for the input stream pointed to by fp is not set and a next character is present, the routine xfgetc obtains that character as an unsigned char converted to an int and advances the associated file position indicator for the stream (if defined).</p>
 * <p>RETURNS</p>
 * <p>If the end-of-file indicator for the stream is set, or if the stream is at end-of-file, the end-of-file indicator for the stream is set and the routine xfgetc returns XEOF. Otherwise, the routine xfgetc returns the next character from the input stream pointed to by fp. If a read error occurs, the error indicator for the stream is set and the xfgetc routine returns XEOF.</p>
 * <p>Note: An end-of-file and a read error can be distinguished by use of the routines xfeof and xferror. </p>
 */
public";

%javamethodmodifiers z_fgetc(void *fh) "
/**
 */
public";

%javamethodmodifiers xfgetc(XFILE *fp) "
/**
 */
public";

%javamethodmodifiers c_fputc(int c, void *fh) "
/**
 * xfputc - write character to the stream .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpenv.h\" int xfputc(int c, XFILE *fp);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine xfputc writes the character specified by c (converted to an unsigned char) to the output stream pointed to by fp, at the position indicated by the associated file position indicator (if defined), and advances the indicator appropriately.</p>
 * <p>RETURNS</p>
 * <p>The routine xfputc returns the character written. If a write error occurs, the error indicator for the stream is set and xfputc returns XEOF. </p>
 */
public";

%javamethodmodifiers z_fputc(int c, void *fh) "
/**
 */
public";

%javamethodmodifiers xfputc(int c, XFILE *fp) "
/**
 */
public";

%javamethodmodifiers c_ferror(void *fh) "
/**
 * xferror - test error indicator for the stream .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpenv.h\" int xferror(XFILE *fp);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine xferror tests the error indicator for the stream pointed to by fp.</p>
 * <p>RETURNS</p>
 * <p>The routine xferror returns non-zero if and only if the error indicator is set for the stream. </p>
 */
public";

%javamethodmodifiers z_ferror(void *fh) "
/**
 */
public";

%javamethodmodifiers xferror(XFILE *fp) "
/**
 */
public";

%javamethodmodifiers c_feof(void *fh) "
/**
 * xfeof - test end-of-file indicator for the stream .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpenv.h\" int xfeof(XFILE *fp);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine xfeof tests the end-of-file indicator for the stream pointed to by fp.</p>
 * <p>RETURNS</p>
 * <p>The routine xfeof returns non-zero if and only if the end-of-file indicator is set for the stream. </p>
 */
public";

%javamethodmodifiers z_feof(void *fh) "
/**
 */
public";

%javamethodmodifiers xfeof(XFILE *fp) "
/**
 */
public";

%javamethodmodifiers xfprintf(XFILE *file, const char *fmt,...) "
/**
 */
public";

%javamethodmodifiers c_fflush(void *fh) "
/**
 * xfflush - flush the stream .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpenv.h\" int xfflush(XFILE *fp);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine xfflush causes any unwritten data for the output stream pointed to by fp to be written to the associated file.</p>
 * <p>RETURNS</p>
 * <p>The routine xfflush returns zero if the stream was successfully flushed. Otherwise, xfflush sets the error indicator for the stream and returns XEOF. </p>
 */
public";

%javamethodmodifiers z_fflush(void *fh) "
/**
 */
public";

%javamethodmodifiers xfflush(XFILE *fp) "
/**
 */
public";

%javamethodmodifiers c_fclose(void *fh) "
/**
 * xfclose - close the stream .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpenv.h\" int xfclose(XFILE *fp);</p>
 * <p>DESCRIPTION</p>
 * <p>A successful call to the routine xfclose causes the stream pointed to by fp to be flushed and the associated file to be closed. Whether or not the call succeeds, the stream is disassociated from the file.</p>
 * <p>RETURNS</p>
 * <p>The routine xfclose returns zero if the stream was successfully closed, or XEOF if any errors were detected. </p>
 */
public";

%javamethodmodifiers z_fclose(void *fh) "
/**
 */
public";

%javamethodmodifiers xfclose(XFILE *fp) "
/**
 */
public";

%javamethodmodifiers xdlopen(const char *module) "
/**
 */
public";

%javamethodmodifiers xdlsym(void *h, const char *symbol) "
/**
 */
public";

%javamethodmodifiers xdlclose(void *h) "
/**
 */
public";

%javamethodmodifiers fhv_create_it(void) "
/**
 * fhv_create_it - create LP basis factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpfhv.h\" FHV *fhv_create_it(void);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine fhv_create_it creates a program object, which represents a factorization of LP basis.</p>
 * <p>RETURNS</p>
 * <p>The routine fhv_create_it returns a pointer to the object created. </p>
 */
public";

%javamethodmodifiers fhv_factorize(FHV *fhv, int m, int(*col)(void *info, int j, int ind[], double val[]), void *info) "
/**
 * fhv_factorize - compute LP basis factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpfhv.h\" int fhv_factorize(FHV *fhv, int m, int (*col)(void *info, int j, int ind[], double val[]), void *info);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine fhv_factorize computes the factorization of the basis matrix B specified by the routine col.</p>
 * <p>The parameter fhv specified the basis factorization data structure created by the routine fhv_create_it.</p>
 * <p>The parameter m specifies the order of B, m > 0.</p>
 * <p>The formal routine col specifies the matrix B to be factorized. To obtain j-th column of A the routine fhv_factorize calls the routine col with the parameter j (1 <= j <= n). In response the routine col should store row indices and numerical values of non-zero elements of j-th column of B to locations ind[1,...,len] and val[1,...,len], respectively, where len is the number of non-zeros in j-th column returned on exit. Neither zero nor duplicate elements are allowed.</p>
 * <p>The parameter info is a transit pointer passed to the routine col.</p>
 * <p>RETURNS</p>
 * <p>0 The factorization has been successfully computed.</p>
 * <p>FHV_ESING The specified matrix is singular within the working precision.</p>
 * <p>FHV_ECOND The specified matrix is ill-conditioned.</p>
 * <p>For more details see comments to the routine luf_factorize.</p>
 * <p>ALGORITHM</p>
 * <p>The routine fhv_factorize calls the routine luf_factorize (see the module GLPLUF), which actually computes LU-factorization of the basis matrix B in the form</p>
 * <p>[B] = (F, V, P, Q),</p>
 * <p>where F and V are such matrices that</p>
 * <p>B = F * V,</p>
 * <p>and P and Q are such permutation matrices that the matrix</p>
 * <p>L = P * F * inv(P)</p>
 * <p>is lower triangular with unity diagonal, and the matrix</p>
 * <p>U = P * V * Q</p>
 * <p>is upper triangular.</p>
 * <p>In order to build the complete representation of the factorization (see formula (1) in the file glpfhv.h) the routine fhv_factorize just additionally sets H = I and P0 = P. </p>
 */
public";

%javamethodmodifiers fhv_h_solve(FHV *fhv, int tr, double x[]) "
/**
 * fhv_h_solve - solve system H*x = b or H'*x = b .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpfhv.h\" void fhv_h_solve(FHV *fhv, int tr, double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine fhv_h_solve solves either the system H*x = b (if the flag tr is zero) or the system H'*x = b (if the flag tr is non-zero), where the matrix H is a component of the factorization specified by the parameter fhv, H' is a matrix transposed to H.</p>
 * <p>On entry the array x should contain elements of the right-hand side vector b in locations x[1], ..., x[m], where m is the order of the matrix H. On exit this array will contain elements of the solution vector x in the same locations. </p>
 */
public";

%javamethodmodifiers fhv_ftran(FHV *fhv, double x[]) "
/**
 * fhv_ftran - perform forward transformation (solve system B*x = b) .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpfhv.h\" void fhv_ftran(FHV *fhv, double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine fhv_ftran performs forward transformation, i.e. solves the system B*x = b, where B is the basis matrix, x is the vector of unknowns to be computed, b is the vector of right-hand sides.</p>
 * <p>On entry elements of the vector b should be stored in dense format in locations x[1], ..., x[m], where m is the number of rows. On exit the routine stores elements of the vector x in the same locations. </p>
 */
public";

%javamethodmodifiers fhv_btran(FHV *fhv, double x[]) "
/**
 * fhv_btran - perform backward transformation (solve system B'*x = b) .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpfhv.h\" void fhv_btran(FHV *fhv, double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine fhv_btran performs backward transformation, i.e. solves the system B'*x = b, where B' is a matrix transposed to the basis matrix B, x is the vector of unknowns to be computed, b is the vector of right-hand sides.</p>
 * <p>On entry elements of the vector b should be stored in dense format in locations x[1], ..., x[m], where m is the number of rows. On exit the routine stores elements of the vector x in the same locations. </p>
 */
public";

%javamethodmodifiers fhv_update_it(FHV *fhv, int j, int len, const int ind[], const double val[]) "
/**
 * fhv_update_it - update LP basis factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpfhv.h\" int fhv_update_it(FHV *fhv, int j, int len, const int ind[], const double val[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine fhv_update_it updates the factorization of the basis matrix B after replacing its j-th column by a new vector.</p>
 * <p>The parameter j specifies the number of column of B, which has been replaced, 1 <= j <= m, where m is the order of B.</p>
 * <p>Row indices and numerical values of non-zero elements of the new column of B should be placed in locations ind[1], ..., ind[len] and val[1], ..., val[len], resp., where len is the number of non-zeros in the column. Neither zero nor duplicate elements are allowed.</p>
 * <p>RETURNS</p>
 * <p>0 The factorization has been successfully updated.</p>
 * <p>FHV_ESING The adjacent basis matrix is structurally singular, since after changing j-th column of matrix V by the new column (see algorithm below) the case k1 > k2 occured.</p>
 * <p>FHV_ECHECK The factorization is inaccurate, since after transforming k2-th row of matrix U = P*V*Q, its diagonal element u[k2,k2] is zero or close to zero,</p>
 * <p>FHV_ELIMIT Maximal number of H factors has been reached.</p>
 * <p>FHV_EROOM Overflow of the sparse vector area.</p>
 * <p>In case of non-zero return code the factorization becomes invalid. It should not be used until it has been recomputed with the routine fhv_factorize.</p>
 * <p>ALGORITHM</p>
 * <p>The routine fhv_update_it is based on the transformation proposed by Forrest and Tomlin.</p>
 * <p>Let j-th column of the basis matrix B have been replaced by new column B[j]. In order to keep the equality B = F*H*V j-th column of matrix V should be replaced by the column inv(F*H)*B[j].</p>
 * <p>From the standpoint of matrix U = P*V*Q, replacement of j-th column of matrix V is equivalent to replacement of k1-th column of matrix U, where k1 is determined by permutation matrix Q. Thus, matrix U loses its upper triangular form and becomes the following:</p>
 * <p>1 k1 k2 m 1 x x * x x x x x x x . x * x x x x x x x k1 . . * x x x x x x x . . * x x x x x x x . . * . x x x x x x . . * . . x x x x x . . * . . . x x x x k2 . . * . . . . x x x . . . . . . . . x x m . . . . . . . . . x</p>
 * <p>where row index k2 corresponds to the lowest non-zero element of k1-th column.</p>
 * <p>The routine moves rows and columns k1+1, k1+2, ..., k2 of matrix U by one position to the left and upwards and moves k1-th row and k1-th column to position k2. As the result of such symmetric permutations matrix U becomes the following:</p>
 * <p>1 k1 k2 m 1 x x x x x x x * x x . x x x x x x * x x k1 . . x x x x x * x x . . . x x x x * x x . . . . x x x * x x . . . . . x x * x x . . . . . . x * x x k2 . . x x x x x * x x . . . . . . . . x x m . . . . . . . . . x</p>
 * <p>Then the routine performs gaussian elimination to eliminate elements u[k2,k1], u[k2,k1+1], ..., u[k2,k2-1] using diagonal elements u[k1,k1], u[k1+1,k1+1], ..., u[k2-1,k2-1] as pivots in the same way as described in comments to the routine luf_factorize (see the module GLPLUF). Note that actually all operations are performed on matrix V, not on matrix U. During the elimination process the routine permutes neither rows nor columns, so only k2-th row of matrix U is changed.</p>
 * <p>To keep the main equality B = F*H*V, each time when the routine applies elementary gaussian transformation to the transformed row of matrix V (which corresponds to k2-th row of matrix U), it also adds a new element (gaussian multiplier) to the current row-like factor of matrix H, which corresponds to the transformed row of matrix V. </p>
 */
public";

%javamethodmodifiers fhv_delete_it(FHV *fhv) "
/**
 * fhv_delete_it - delete LP basis factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpfhv.h\" void fhv_delete_it(FHV *fhv);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine fhv_delete_it deletes LP basis factorization specified by the parameter fhv and frees all memory allocated to this program object. </p>
 */
public";

%javamethodmodifiers fhv_create_it(void) "
/**
 * fhv_create_it - create LP basis factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpfhv.h\" FHV *fhv_create_it(void);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine fhv_create_it creates a program object, which represents a factorization of LP basis.</p>
 * <p>RETURNS</p>
 * <p>The routine fhv_create_it returns a pointer to the object created. </p>
 */
public";

%javamethodmodifiers fhv_factorize(FHV *fhv, int m, int(*col)(void *info, int j, int ind[], double val[]), void *info) "
/**
 * fhv_factorize - compute LP basis factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpfhv.h\" int fhv_factorize(FHV *fhv, int m, int (*col)(void *info, int j, int ind[], double val[]), void *info);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine fhv_factorize computes the factorization of the basis matrix B specified by the routine col.</p>
 * <p>The parameter fhv specified the basis factorization data structure created by the routine fhv_create_it.</p>
 * <p>The parameter m specifies the order of B, m > 0.</p>
 * <p>The formal routine col specifies the matrix B to be factorized. To obtain j-th column of A the routine fhv_factorize calls the routine col with the parameter j (1 <= j <= n). In response the routine col should store row indices and numerical values of non-zero elements of j-th column of B to locations ind[1,...,len] and val[1,...,len], respectively, where len is the number of non-zeros in j-th column returned on exit. Neither zero nor duplicate elements are allowed.</p>
 * <p>The parameter info is a transit pointer passed to the routine col.</p>
 * <p>RETURNS</p>
 * <p>0 The factorization has been successfully computed.</p>
 * <p>FHV_ESING The specified matrix is singular within the working precision.</p>
 * <p>FHV_ECOND The specified matrix is ill-conditioned.</p>
 * <p>For more details see comments to the routine luf_factorize.</p>
 * <p>ALGORITHM</p>
 * <p>The routine fhv_factorize calls the routine luf_factorize (see the module GLPLUF), which actually computes LU-factorization of the basis matrix B in the form</p>
 * <p>[B] = (F, V, P, Q),</p>
 * <p>where F and V are such matrices that</p>
 * <p>B = F * V,</p>
 * <p>and P and Q are such permutation matrices that the matrix</p>
 * <p>L = P * F * inv(P)</p>
 * <p>is lower triangular with unity diagonal, and the matrix</p>
 * <p>U = P * V * Q</p>
 * <p>is upper triangular.</p>
 * <p>In order to build the complete representation of the factorization (see formula (1) in the file glpfhv.h) the routine fhv_factorize just additionally sets H = I and P0 = P. </p>
 */
public";

%javamethodmodifiers fhv_h_solve(FHV *fhv, int tr, double x[]) "
/**
 * fhv_h_solve - solve system H*x = b or H'*x = b .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpfhv.h\" void fhv_h_solve(FHV *fhv, int tr, double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine fhv_h_solve solves either the system H*x = b (if the flag tr is zero) or the system H'*x = b (if the flag tr is non-zero), where the matrix H is a component of the factorization specified by the parameter fhv, H' is a matrix transposed to H.</p>
 * <p>On entry the array x should contain elements of the right-hand side vector b in locations x[1], ..., x[m], where m is the order of the matrix H. On exit this array will contain elements of the solution vector x in the same locations. </p>
 */
public";

%javamethodmodifiers fhv_ftran(FHV *fhv, double x[]) "
/**
 * fhv_ftran - perform forward transformation (solve system B*x = b) .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpfhv.h\" void fhv_ftran(FHV *fhv, double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine fhv_ftran performs forward transformation, i.e. solves the system B*x = b, where B is the basis matrix, x is the vector of unknowns to be computed, b is the vector of right-hand sides.</p>
 * <p>On entry elements of the vector b should be stored in dense format in locations x[1], ..., x[m], where m is the number of rows. On exit the routine stores elements of the vector x in the same locations. </p>
 */
public";

%javamethodmodifiers fhv_btran(FHV *fhv, double x[]) "
/**
 * fhv_btran - perform backward transformation (solve system B'*x = b) .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpfhv.h\" void fhv_btran(FHV *fhv, double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine fhv_btran performs backward transformation, i.e. solves the system B'*x = b, where B' is a matrix transposed to the basis matrix B, x is the vector of unknowns to be computed, b is the vector of right-hand sides.</p>
 * <p>On entry elements of the vector b should be stored in dense format in locations x[1], ..., x[m], where m is the number of rows. On exit the routine stores elements of the vector x in the same locations. </p>
 */
public";

%javamethodmodifiers fhv_update_it(FHV *fhv, int j, int len, const int ind[], const double val[]) "
/**
 * fhv_update_it - update LP basis factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpfhv.h\" int fhv_update_it(FHV *fhv, int j, int len, const int ind[], const double val[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine fhv_update_it updates the factorization of the basis matrix B after replacing its j-th column by a new vector.</p>
 * <p>The parameter j specifies the number of column of B, which has been replaced, 1 <= j <= m, where m is the order of B.</p>
 * <p>Row indices and numerical values of non-zero elements of the new column of B should be placed in locations ind[1], ..., ind[len] and val[1], ..., val[len], resp., where len is the number of non-zeros in the column. Neither zero nor duplicate elements are allowed.</p>
 * <p>RETURNS</p>
 * <p>0 The factorization has been successfully updated.</p>
 * <p>FHV_ESING The adjacent basis matrix is structurally singular, since after changing j-th column of matrix V by the new column (see algorithm below) the case k1 > k2 occured.</p>
 * <p>FHV_ECHECK The factorization is inaccurate, since after transforming k2-th row of matrix U = P*V*Q, its diagonal element u[k2,k2] is zero or close to zero,</p>
 * <p>FHV_ELIMIT Maximal number of H factors has been reached.</p>
 * <p>FHV_EROOM Overflow of the sparse vector area.</p>
 * <p>In case of non-zero return code the factorization becomes invalid. It should not be used until it has been recomputed with the routine fhv_factorize.</p>
 * <p>ALGORITHM</p>
 * <p>The routine fhv_update_it is based on the transformation proposed by Forrest and Tomlin.</p>
 * <p>Let j-th column of the basis matrix B have been replaced by new column B[j]. In order to keep the equality B = F*H*V j-th column of matrix V should be replaced by the column inv(F*H)*B[j].</p>
 * <p>From the standpoint of matrix U = P*V*Q, replacement of j-th column of matrix V is equivalent to replacement of k1-th column of matrix U, where k1 is determined by permutation matrix Q. Thus, matrix U loses its upper triangular form and becomes the following:</p>
 * <p>1 k1 k2 m 1 x x * x x x x x x x . x * x x x x x x x k1 . . * x x x x x x x . . * x x x x x x x . . * . x x x x x x . . * . . x x x x x . . * . . . x x x x k2 . . * . . . . x x x . . . . . . . . x x m . . . . . . . . . x</p>
 * <p>where row index k2 corresponds to the lowest non-zero element of k1-th column.</p>
 * <p>The routine moves rows and columns k1+1, k1+2, ..., k2 of matrix U by one position to the left and upwards and moves k1-th row and k1-th column to position k2. As the result of such symmetric permutations matrix U becomes the following:</p>
 * <p>1 k1 k2 m 1 x x x x x x x * x x . x x x x x x * x x k1 . . x x x x x * x x . . . x x x x * x x . . . . x x x * x x . . . . . x x * x x . . . . . . x * x x k2 . . x x x x x * x x . . . . . . . . x x m . . . . . . . . . x</p>
 * <p>Then the routine performs gaussian elimination to eliminate elements u[k2,k1], u[k2,k1+1], ..., u[k2,k2-1] using diagonal elements u[k1,k1], u[k1+1,k1+1], ..., u[k2-1,k2-1] as pivots in the same way as described in comments to the routine luf_factorize (see the module GLPLUF). Note that actually all operations are performed on matrix V, not on matrix U. During the elimination process the routine permutes neither rows nor columns, so only k2-th row of matrix U is changed.</p>
 * <p>To keep the main equality B = F*H*V, each time when the routine applies elementary gaussian transformation to the transformed row of matrix V (which corresponds to k2-th row of matrix U), it also adds a new element (gaussian multiplier) to the current row-like factor of matrix H, which corresponds to the transformed row of matrix V. </p>
 */
public";

%javamethodmodifiers fhv_delete_it(FHV *fhv) "
/**
 * fhv_delete_it - delete LP basis factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpfhv.h\" void fhv_delete_it(FHV *fhv);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine fhv_delete_it deletes LP basis factorization specified by the parameter fhv and frees all memory allocated to this program object. </p>
 */
public";

%javamethodmodifiers gmp_get_atom(int size) "
/**
 */
public";

%javamethodmodifiers gmp_free_atom(void *ptr, int size) "
/**
 */
public";

%javamethodmodifiers gmp_pool_count(void) "
/**
 */
public";

%javamethodmodifiers gmp_get_work(int size) "
/**
 */
public";

%javamethodmodifiers gmp_free_mem(void) "
/**
 */
public";

%javamethodmodifiers _mpz_init(void) "
/**
 */
public";

%javamethodmodifiers mpz_clear(mpz_t x) "
/**
 */
public";

%javamethodmodifiers mpz_set(mpz_t z, mpz_t x) "
/**
 */
public";

%javamethodmodifiers mpz_set_si(mpz_t x, int val) "
/**
 */
public";

%javamethodmodifiers mpz_get_d(mpz_t x) "
/**
 */
public";

%javamethodmodifiers mpz_get_d_2exp(int *exp, mpz_t x) "
/**
 */
public";

%javamethodmodifiers mpz_swap(mpz_t x, mpz_t y) "
/**
 */
public";

%javamethodmodifiers normalize(mpz_t x) "
/**
 */
public";

%javamethodmodifiers mpz_add(mpz_t z, mpz_t x, mpz_t y) "
/**
 */
public";

%javamethodmodifiers mpz_sub(mpz_t z, mpz_t x, mpz_t y) "
/**
 */
public";

%javamethodmodifiers mpz_mul(mpz_t z, mpz_t x, mpz_t y) "
/**
 */
public";

%javamethodmodifiers mpz_neg(mpz_t z, mpz_t x) "
/**
 */
public";

%javamethodmodifiers mpz_abs(mpz_t z, mpz_t x) "
/**
 */
public";

%javamethodmodifiers mpz_div(mpz_t q, mpz_t r, mpz_t x, mpz_t y) "
/**
 */
public";

%javamethodmodifiers mpz_gcd(mpz_t z, mpz_t x, mpz_t y) "
/**
 */
public";

%javamethodmodifiers mpz_cmp(mpz_t x, mpz_t y) "
/**
 */
public";

%javamethodmodifiers mpz_sgn(mpz_t x) "
/**
 */
public";

%javamethodmodifiers mpz_out_str(void *_fp, int base, mpz_t x) "
/**
 */
public";

%javamethodmodifiers _mpq_init(void) "
/**
 */
public";

%javamethodmodifiers mpq_clear(mpq_t x) "
/**
 */
public";

%javamethodmodifiers mpq_canonicalize(mpq_t x) "
/**
 */
public";

%javamethodmodifiers mpq_set(mpq_t z, mpq_t x) "
/**
 */
public";

%javamethodmodifiers mpq_set_si(mpq_t x, int p, unsigned int q) "
/**
 */
public";

%javamethodmodifiers mpq_get_d(mpq_t x) "
/**
 */
public";

%javamethodmodifiers mpq_set_d(mpq_t x, double val) "
/**
 */
public";

%javamethodmodifiers mpq_add(mpq_t z, mpq_t x, mpq_t y) "
/**
 */
public";

%javamethodmodifiers mpq_sub(mpq_t z, mpq_t x, mpq_t y) "
/**
 */
public";

%javamethodmodifiers mpq_mul(mpq_t z, mpq_t x, mpq_t y) "
/**
 */
public";

%javamethodmodifiers mpq_div(mpq_t z, mpq_t x, mpq_t y) "
/**
 */
public";

%javamethodmodifiers mpq_neg(mpq_t z, mpq_t x) "
/**
 */
public";

%javamethodmodifiers mpq_abs(mpq_t z, mpq_t x) "
/**
 */
public";

%javamethodmodifiers mpq_cmp(mpq_t x, mpq_t y) "
/**
 */
public";

%javamethodmodifiers mpq_sgn(mpq_t x) "
/**
 */
public";

%javamethodmodifiers mpq_out_str(void *_fp, int base, mpq_t x) "
/**
 */
public";

%javamethodmodifiers gmp_get_atom(int size) "
/**
 */
public";

%javamethodmodifiers gmp_free_atom(void *ptr, int size) "
/**
 */
public";

%javamethodmodifiers gmp_pool_count(void) "
/**
 */
public";

%javamethodmodifiers gmp_get_work(int size) "
/**
 */
public";

%javamethodmodifiers gmp_free_mem(void) "
/**
 */
public";

%javamethodmodifiers _mpz_init(void) "
/**
 */
public";

%javamethodmodifiers mpz_clear(mpz_t x) "
/**
 */
public";

%javamethodmodifiers mpz_set(mpz_t z, mpz_t x) "
/**
 */
public";

%javamethodmodifiers mpz_set_si(mpz_t x, int val) "
/**
 */
public";

%javamethodmodifiers mpz_get_d(mpz_t x) "
/**
 */
public";

%javamethodmodifiers mpz_get_d_2exp(int *exp, mpz_t x) "
/**
 */
public";

%javamethodmodifiers mpz_swap(mpz_t x, mpz_t y) "
/**
 */
public";

%javamethodmodifiers mpz_add(mpz_t, mpz_t, mpz_t) "
/**
 */
public";

%javamethodmodifiers mpz_sub(mpz_t, mpz_t, mpz_t) "
/**
 */
public";

%javamethodmodifiers mpz_mul(mpz_t, mpz_t, mpz_t) "
/**
 */
public";

%javamethodmodifiers mpz_neg(mpz_t z, mpz_t x) "
/**
 */
public";

%javamethodmodifiers mpz_abs(mpz_t z, mpz_t x) "
/**
 */
public";

%javamethodmodifiers mpz_div(mpz_t q, mpz_t r, mpz_t x, mpz_t y) "
/**
 */
public";

%javamethodmodifiers mpz_gcd(mpz_t z, mpz_t x, mpz_t y) "
/**
 */
public";

%javamethodmodifiers mpz_cmp(mpz_t x, mpz_t y) "
/**
 */
public";

%javamethodmodifiers mpz_sgn(mpz_t x) "
/**
 */
public";

%javamethodmodifiers mpz_out_str(void *fp, int base, mpz_t x) "
/**
 */
public";

%javamethodmodifiers _mpq_init(void) "
/**
 */
public";

%javamethodmodifiers mpq_clear(mpq_t x) "
/**
 */
public";

%javamethodmodifiers mpq_canonicalize(mpq_t x) "
/**
 */
public";

%javamethodmodifiers mpq_set(mpq_t z, mpq_t x) "
/**
 */
public";

%javamethodmodifiers mpq_set_si(mpq_t x, int p, unsigned int q) "
/**
 */
public";

%javamethodmodifiers mpq_get_d(mpq_t x) "
/**
 */
public";

%javamethodmodifiers mpq_set_d(mpq_t x, double val) "
/**
 */
public";

%javamethodmodifiers mpq_add(mpq_t z, mpq_t x, mpq_t y) "
/**
 */
public";

%javamethodmodifiers mpq_sub(mpq_t z, mpq_t x, mpq_t y) "
/**
 */
public";

%javamethodmodifiers mpq_mul(mpq_t z, mpq_t x, mpq_t y) "
/**
 */
public";

%javamethodmodifiers mpq_div(mpq_t z, mpq_t x, mpq_t y) "
/**
 */
public";

%javamethodmodifiers mpq_neg(mpq_t z, mpq_t x) "
/**
 */
public";

%javamethodmodifiers mpq_abs(mpq_t z, mpq_t x) "
/**
 */
public";

%javamethodmodifiers mpq_cmp(mpq_t x, mpq_t y) "
/**
 */
public";

%javamethodmodifiers mpq_sgn(mpq_t x) "
/**
 */
public";

%javamethodmodifiers mpq_out_str(void *fp, int base, mpq_t x) "
/**
 */
public";

%javamethodmodifiers read_card(struct dsa *dsa) "
/**
 */
public";

%javamethodmodifiers scan_int(struct dsa *dsa, char *fld, int pos, int width, int *val) "
/**
 */
public";

%javamethodmodifiers parse_fmt(struct dsa *dsa, char *fmt) "
/**
 */
public";

%javamethodmodifiers read_int_array(struct dsa *dsa, char *name, char *fmt, int n, int val[]) "
/**
 */
public";

%javamethodmodifiers read_real_array(struct dsa *dsa, char *name, char *fmt, int n, double val[]) "
/**
 */
public";

%javamethodmodifiers hbm_read_mat(const char *fname) "
/**
 */
public";

%javamethodmodifiers hbm_free_mat(HBM *hbm) "
/**
 * hbm_free_mat - free sparse matrix in Harwell-Boeing format .
 * <p>SYNOPSIS</p>
 * <p>#include \"glphbm.h\" void hbm_free_mat(HBM *hbm);</p>
 * <p>DESCRIPTION</p>
 * <p>The hbm_free_mat routine frees all the memory allocated to the data structure containing a sparse matrix in the Harwell-Boeing format. </p>
 */
public";

%javamethodmodifiers hbm_read_mat(const char *fname) "
/**
 */
public";

%javamethodmodifiers hbm_free_mat(HBM *hbm) "
/**
 * hbm_free_mat - free sparse matrix in Harwell-Boeing format .
 * <p>SYNOPSIS</p>
 * <p>#include \"glphbm.h\" void hbm_free_mat(HBM *hbm);</p>
 * <p>DESCRIPTION</p>
 * <p>The hbm_free_mat routine frees all the memory allocated to the data structure containing a sparse matrix in the Harwell-Boeing format. </p>
 */
public";

%javamethodmodifiers triang(int m, int n, void *info, int(*mat)(void *info, int k, int ndx[]), int rn[], int cn[]) "
/**
 */
public";

%javamethodmodifiers mat(void *info, int k, int ndx[]) "
/**
 */
public";

%javamethodmodifiers adv_basis(glp_prob *lp) "
/**
 */
public";

%javamethodmodifiers glp_adv_basis(glp_prob *lp, int flags) "
/**
 * glp_adv_basis - construct advanced initial LP basis .
 * <p>SYNOPSIS</p>
 * <p>void glp_adv_basis(glp_prob *lp, int flags);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_adv_basis constructs an advanced initial basis for the specified problem object.</p>
 * <p>The parameter flags is reserved for use in the future and must be specified as zero. </p>
 */
public";

%javamethodmodifiers fcmp(const void *ptr1, const void *ptr2) "
/**
 */
public";

%javamethodmodifiers get_column(glp_prob *lp, int j, int ind[], double val[]) "
/**
 */
public";

%javamethodmodifiers cpx_basis(glp_prob *lp) "
/**
 */
public";

%javamethodmodifiers glp_cpx_basis(glp_prob *lp) "
/**
 * glp_cpx_basis - construct Bixby's initial LP basis .
 * <p>SYNOPSIS</p>
 * <p>void glp_cpx_basis(glp_prob *lp);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_cpx_basis constructs an advanced initial basis for the specified problem object.</p>
 * <p>The routine is based on Bixby's algorithm described in the paper:</p>
 * <p>Robert E. Bixby. Implementing the Simplex Method: The Initial Basis. ORSA Journal on Computing, Vol. 4, No. 3, 1992, pp. 267-84. </p>
 */
public";

%javamethodmodifiers ios_create_tree(glp_prob *mip, const glp_iocp *parm) "
/**
 */
public";

%javamethodmodifiers ios_revive_node(glp_tree *tree, int p) "
/**
 * ios_revive_node - revive specified subproblem .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_revive_node(glp_tree *tree, int p);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_revive_node revives the specified subproblem, whose reference number is p, and thereby makes it the current subproblem. Note that the specified subproblem must be active. Besides, if the current subproblem already exists, it must be frozen before reviving another subproblem. </p>
 */
public";

%javamethodmodifiers ios_freeze_node(glp_tree *tree) "
/**
 * ios_freeze_node - freeze current subproblem .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_freeze_node(glp_tree *tree);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_freeze_node freezes the current subproblem. </p>
 */
public";

%javamethodmodifiers ios_clone_node(glp_tree *tree, int p, int nnn, int ref[]) "
/**
 */
public";

%javamethodmodifiers ios_delete_node(glp_tree *tree, int p) "
/**
 * ios_delete_node - delete specified subproblem .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_delete_node(glp_tree *tree, int p);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_delete_node deletes the specified subproblem, whose reference number is p. The subproblem must be active and must be in the frozen state (i.e. it must not be the current subproblem).</p>
 * <p>Note that deletion is performed recursively, i.e. if a subproblem to be deleted is the only child of its parent, the parent subproblem is also deleted, etc. </p>
 */
public";

%javamethodmodifiers ios_delete_tree(glp_tree *tree) "
/**
 * ios_delete_tree - delete branch-and-bound tree .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_delete_tree(glp_tree *tree);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_delete_tree deletes the branch-and-bound tree, which the parameter tree points to, and frees all the memory allocated to this program object.</p>
 * <p>On exit components of the problem object are restored to correspond to the original MIP passed to the routine ios_create_tree. </p>
 */
public";

%javamethodmodifiers ios_eval_degrad(glp_tree *tree, int j, double *dn, double *up) "
/**
 * ios_eval_degrad - estimate obj. .
 * <p>degrad. for down- and up-branches</p>
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_eval_degrad(glp_tree *tree, int j, double *dn, double *up);</p>
 * <p>DESCRIPTION</p>
 * <p>Given optimal basis to LP relaxation of the current subproblem the routine ios_eval_degrad performs the dual ratio test to compute the objective values in the adjacent basis for down- and up-branches, which are stored in locations *dn and *up, assuming that x[j] is a variable chosen to branch upon. </p>
 */
public";

%javamethodmodifiers ios_round_bound(glp_tree *tree, double bound) "
/**
 * ios_round_bound - improve local bound by rounding .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" double ios_round_bound(glp_tree *tree, double bound);</p>
 * <p>RETURNS</p>
 * <p>For the given local bound for any integer feasible solution to the current subproblem the routine ios_round_bound returns an improved local bound for the same integer feasible solution.</p>
 * <p>BACKGROUND</p>
 * <p>Let the current subproblem has the following objective function:</p>
 * <p>z = sum c[j] * x[j] + s >= b, (1) j in J</p>
 * <p>where J = {j: c[j] is non-zero and integer, x[j] is integer}, s is the sum of terms corresponding to fixed variables, b is an initial local bound (minimization).</p>
 * <p>From (1) it follows that:</p>
 * <p>d * sum (c[j] / d) * x[j] + s >= b, (2) j in J</p>
 * <p>or, equivalently,</p>
 * <p>sum (c[j] / d) * x[j] >= (b - s) / d = h, (3) j in J</p>
 * <p>where d = gcd(c[j]). Since the left-hand side of (3) is integer, h = (b - s) / d can be rounded up to the nearest integer:</p>
 * <p>h' = ceil(h) = (b' - s) / d, (4)</p>
 * <p>that gives an rounded, improved local bound:</p>
 * <p>b' = d * h' + s. (5)</p>
 * <p>In case of maximization '>=' in (1) should be replaced by '<=' that leads to the following formula:</p>
 * <p>h' = floor(h) = (b' - s) / d, (6)</p>
 * <p>which should used in the same way as (4).</p>
 * <p>NOTE: If b is a valid local bound for a child of the current subproblem, b' is also valid for that child subproblem. </p>
 */
public";

%javamethodmodifiers ios_is_hopeful(glp_tree *tree, double bound) "
/**
 * ios_is_hopeful - check if subproblem is hopeful .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" int ios_is_hopeful(glp_tree *tree, double bound);</p>
 * <p>DESCRIPTION</p>
 * <p>Given the local bound of a subproblem the routine ios_is_hopeful checks if the subproblem can have an integer optimal solution which is better than the best one currently known.</p>
 * <p>RETURNS</p>
 * <p>If the subproblem can have a better integer optimal solution, the routine returns non-zero; otherwise, if the corresponding branch can be pruned, the routine returns zero. </p>
 */
public";

%javamethodmodifiers ios_best_node(glp_tree *tree) "
/**
 * ios_best_node - find active node with best local bound .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" int ios_best_node(glp_tree *tree);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_best_node finds an active node whose local bound is best among other active nodes.</p>
 * <p>It is understood that the integer optimal solution of the original mip problem cannot be better than the best bound, so the best bound is an lower (minimization) or upper (maximization) global bound for the original problem.</p>
 * <p>RETURNS</p>
 * <p>The routine ios_best_node returns the subproblem reference number for the best node. However, if the tree is empty, it returns zero. </p>
 */
public";

%javamethodmodifiers ios_relative_gap(glp_tree *tree) "
/**
 * ios_relative_gap - compute relative mip gap .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" double ios_relative_gap(glp_tree *tree);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_relative_gap computes the relative mip gap using the formula:</p>
 * <p>gap = |best_mip - best_bnd| / (|best_mip| + DBL_EPSILON),</p>
 * <p>where best_mip is the best integer feasible solution found so far, best_bnd is the best (global) bound. If no integer feasible solution has been found yet, rel_gap is set to DBL_MAX.</p>
 * <p>RETURNS</p>
 * <p>The routine ios_relative_gap returns the relative mip gap. </p>
 */
public";

%javamethodmodifiers ios_solve_node(glp_tree *tree) "
/**
 * ios_solve_node - solve LP relaxation of current subproblem .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" int ios_solve_node(glp_tree *tree);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_solve_node re-optimizes LP relaxation of the current subproblem using the dual simplex method.</p>
 * <p>RETURNS</p>
 * <p>The routine returns the code which is reported by glp_simplex. </p>
 */
public";

%javamethodmodifiers ios_create_pool(glp_tree *tree) "
/**
 */
public";

%javamethodmodifiers ios_add_row(glp_tree *tree, IOSPOOL *pool, const char *name, int klass, int flags, int len, const int ind[], const double val[], int type, double rhs) "
/**
 */
public";

%javamethodmodifiers ios_find_row(IOSPOOL *pool, int i) "
/**
 */
public";

%javamethodmodifiers ios_del_row(glp_tree *tree, IOSPOOL *pool, int i) "
/**
 */
public";

%javamethodmodifiers ios_clear_pool(glp_tree *tree, IOSPOOL *pool) "
/**
 */
public";

%javamethodmodifiers ios_delete_pool(glp_tree *tree, IOSPOOL *pool) "
/**
 */
public";

%javamethodmodifiers ios_preprocess_node(glp_tree *tree, int max_pass) "
/**
 * ios_preprocess_node - preprocess current subproblem .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" int ios_preprocess_node(glp_tree *tree, int max_pass);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_preprocess_node performs basic preprocessing of the current subproblem.</p>
 * <p>RETURNS</p>
 * <p>If no primal infeasibility is detected, the routine returns zero, otherwise non-zero. </p>
 */
public";

%javamethodmodifiers ios_driver(glp_tree *tree) "
/**
 * ios_driver - branch-and-cut driver .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" int ios_driver(glp_tree *T);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_driver is a branch-and-cut driver. It controls the MIP solution process.</p>
 * <p>RETURNS</p>
 * <p>0 The MIP problem instance has been successfully solved. This code does not necessarily mean that the solver has found optimal solution. It only means that the solution process was successful.</p>
 * <p>GLP_EFAIL The search was prematurely terminated due to the solver failure.</p>
 * <p>GLP_EMIPGAP The search was prematurely terminated, because the relative mip gap tolerance has been reached.</p>
 * <p>GLP_ETMLIM The search was prematurely terminated, because the time limit has been exceeded.</p>
 * <p>GLP_ESTOP The search was prematurely terminated by application. </p>
 */
public";

%javamethodmodifiers ios_create_vec(int n) "
/**
 * ios_create_vec - create sparse vector .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" IOSVEC *ios_create_vec(int n);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_create_vec creates a sparse vector of dimension n, which initially is a null vector.</p>
 * <p>RETURNS</p>
 * <p>The routine returns a pointer to the vector created. </p>
 */
public";

%javamethodmodifiers ios_check_vec(IOSVEC *v) "
/**
 * ios_check_vec - check that sparse vector has correct representation .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_check_vec(IOSVEC *v);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_check_vec checks that a sparse vector specified by the parameter v has correct representation.</p>
 * <p>NOTE</p>
 * <p>Complexity of this operation is O(n). </p>
 */
public";

%javamethodmodifiers ios_get_vj(IOSVEC *v, int j) "
/**
 * ios_get_vj - retrieve component of sparse vector .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" double ios_get_vj(IOSVEC *v, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine ios_get_vj returns j-th component of a sparse vector specified by the parameter v. </p>
 */
public";

%javamethodmodifiers ios_set_vj(IOSVEC *v, int j, double val) "
/**
 * ios_set_vj - set/change component of sparse vector .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_set_vj(IOSVEC *v, int j, double val);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_set_vj assigns val to j-th component of a sparse vector specified by the parameter v. </p>
 */
public";

%javamethodmodifiers ios_clear_vec(IOSVEC *v) "
/**
 * ios_clear_vec - set all components of sparse vector to zero .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_clear_vec(IOSVEC *v);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_clear_vec sets all components of a sparse vector specified by the parameter v to zero. </p>
 */
public";

%javamethodmodifiers ios_clean_vec(IOSVEC *v, double eps) "
/**
 * ios_clean_vec - remove zero or small components from sparse vector .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_clean_vec(IOSVEC *v, double eps);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_clean_vec removes zero components and components whose magnitude is less than eps from a sparse vector specified by the parameter v. If eps is 0.0, only zero components are removed. </p>
 */
public";

%javamethodmodifiers ios_copy_vec(IOSVEC *x, IOSVEC *y) "
/**
 * ios_copy_vec - copy sparse vector (x := y) .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_copy_vec(IOSVEC *x, IOSVEC *y);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_copy_vec copies a sparse vector specified by the parameter y to a sparse vector specified by the parameter x. </p>
 */
public";

%javamethodmodifiers ios_linear_comb(IOSVEC *x, double a, IOSVEC *y) "
/**
 * ios_linear_comb - compute linear combination (x := x + a * y) .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_linear_comb(IOSVEC *x, double a, IOSVEC *y);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_linear_comb computes the linear combination</p>
 * <p>x := x + a * y,</p>
 * <p>where x and y are sparse vectors, a is a scalar. </p>
 */
public";

%javamethodmodifiers ios_delete_vec(IOSVEC *v) "
/**
 * ios_delete_vec - delete sparse vector .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_delete_vec(IOSVEC *v);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_delete_vec deletes a sparse vector specified by the parameter v freeing all the memory allocated to this object. </p>
 */
public";

%javamethodmodifiers ios_gmi_gen(glp_tree *tree) "
/**
 */
public";

%javamethodmodifiers ios_mir_init(glp_tree *tree) "
/**
 */
public";

%javamethodmodifiers ios_mir_gen(glp_tree *tree, void *gen) "
/**
 */
public";

%javamethodmodifiers ios_mir_term(void *gen) "
/**
 * ios_mir_term - terminate MIR cut generator .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_mir_term(void *gen);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_mir_term deletes the MIR cut generator working area freeing all the memory allocated to it. </p>
 */
public";

%javamethodmodifiers ios_cov_gen(glp_tree *tree) "
/**
 * ios_cov_gen - generate mixed cover cuts .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_cov_gen(glp_tree *tree);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_cov_gen generates mixed cover cuts for the current point and adds them to the cut pool. </p>
 */
public";

%javamethodmodifiers ios_clq_init(glp_tree *tree) "
/**
 */
public";

%javamethodmodifiers ios_clq_gen(glp_tree *tree, void *gen) "
/**
 * ios_clq_gen - generate clique cuts .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_clq_gen(glp_tree *tree, void *gen);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_clq_gen generates clique cuts for the current point and adds them to the clique pool. </p>
 */
public";

%javamethodmodifiers ios_clq_term(void *gen) "
/**
 */
public";

%javamethodmodifiers ios_pcost_init(glp_tree *tree) "
/**
 */
public";

%javamethodmodifiers ios_pcost_branch(glp_tree *T, int *next) "
/**
 */
public";

%javamethodmodifiers ios_pcost_update(glp_tree *tree) "
/**
 */
public";

%javamethodmodifiers ios_pcost_free(glp_tree *tree) "
/**
 */
public";

%javamethodmodifiers ios_feas_pump(glp_tree *T) "
/**
 */
public";

%javamethodmodifiers ios_process_cuts(glp_tree *T) "
/**
 */
public";

%javamethodmodifiers ios_choose_node(glp_tree *T) "
/**
 */
public";

%javamethodmodifiers ios_choose_var(glp_tree *T, int *next) "
/**
 */
public";

%javamethodmodifiers new_node(glp_tree *tree, IOSNPD *parent) "
/**
 * ios_create_tree - create branch-and-bound tree .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" glp_tree *ios_create_tree(glp_prob *mip, const glp_iocp *parm);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_create_tree creates the branch-and-bound tree.</p>
 * <p>Being created the tree consists of the only root subproblem whose reference number is 1. Note that initially the root subproblem is in frozen state and therefore needs to be revived.</p>
 * <p>RETURNS</p>
 * <p>The routine returns a pointer to the tree created. </p>
 */
public";

%javamethodmodifiers ios_create_tree(glp_prob *mip, const glp_iocp *parm) "
/**
 */
public";

%javamethodmodifiers ios_revive_node(glp_tree *tree, int p) "
/**
 * ios_revive_node - revive specified subproblem .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_revive_node(glp_tree *tree, int p);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_revive_node revives the specified subproblem, whose reference number is p, and thereby makes it the current subproblem. Note that the specified subproblem must be active. Besides, if the current subproblem already exists, it must be frozen before reviving another subproblem. </p>
 */
public";

%javamethodmodifiers ios_freeze_node(glp_tree *tree) "
/**
 * ios_freeze_node - freeze current subproblem .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_freeze_node(glp_tree *tree);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_freeze_node freezes the current subproblem. </p>
 */
public";

%javamethodmodifiers get_slot(glp_tree *tree) "
/**
 * ios_clone_node - clone specified subproblem .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_clone_node(glp_tree *tree, int p, int nnn, int ref[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_clone_node clones the specified subproblem, whose reference number is p, creating its nnn exact copies. Note that the specified subproblem must be active and must be in the frozen state (i.e. it must not be the current subproblem).</p>
 * <p>Each clone, an exact copy of the specified subproblem, becomes a new active subproblem added to the end of the active list. After cloning the specified subproblem becomes inactive.</p>
 * <p>The reference numbers of clone subproblems are stored to locations ref[1], ..., ref[nnn]. </p>
 */
public";

%javamethodmodifiers ios_clone_node(glp_tree *tree, int p, int nnn, int ref[]) "
/**
 */
public";

%javamethodmodifiers ios_delete_node(glp_tree *tree, int p) "
/**
 * ios_delete_node - delete specified subproblem .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_delete_node(glp_tree *tree, int p);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_delete_node deletes the specified subproblem, whose reference number is p. The subproblem must be active and must be in the frozen state (i.e. it must not be the current subproblem).</p>
 * <p>Note that deletion is performed recursively, i.e. if a subproblem to be deleted is the only child of its parent, the parent subproblem is also deleted, etc. </p>
 */
public";

%javamethodmodifiers ios_delete_tree(glp_tree *tree) "
/**
 * ios_delete_tree - delete branch-and-bound tree .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_delete_tree(glp_tree *tree);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_delete_tree deletes the branch-and-bound tree, which the parameter tree points to, and frees all the memory allocated to this program object.</p>
 * <p>On exit components of the problem object are restored to correspond to the original MIP passed to the routine ios_create_tree. </p>
 */
public";

%javamethodmodifiers ios_eval_degrad(glp_tree *tree, int j, double *dn, double *up) "
/**
 * ios_eval_degrad - estimate obj. .
 * <p>degrad. for down- and up-branches</p>
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_eval_degrad(glp_tree *tree, int j, double *dn, double *up);</p>
 * <p>DESCRIPTION</p>
 * <p>Given optimal basis to LP relaxation of the current subproblem the routine ios_eval_degrad performs the dual ratio test to compute the objective values in the adjacent basis for down- and up-branches, which are stored in locations *dn and *up, assuming that x[j] is a variable chosen to branch upon. </p>
 */
public";

%javamethodmodifiers ios_round_bound(glp_tree *tree, double bound) "
/**
 * ios_round_bound - improve local bound by rounding .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" double ios_round_bound(glp_tree *tree, double bound);</p>
 * <p>RETURNS</p>
 * <p>For the given local bound for any integer feasible solution to the current subproblem the routine ios_round_bound returns an improved local bound for the same integer feasible solution.</p>
 * <p>BACKGROUND</p>
 * <p>Let the current subproblem has the following objective function:</p>
 * <p>z = sum c[j] * x[j] + s >= b, (1) j in J</p>
 * <p>where J = {j: c[j] is non-zero and integer, x[j] is integer}, s is the sum of terms corresponding to fixed variables, b is an initial local bound (minimization).</p>
 * <p>From (1) it follows that:</p>
 * <p>d * sum (c[j] / d) * x[j] + s >= b, (2) j in J</p>
 * <p>or, equivalently,</p>
 * <p>sum (c[j] / d) * x[j] >= (b - s) / d = h, (3) j in J</p>
 * <p>where d = gcd(c[j]). Since the left-hand side of (3) is integer, h = (b - s) / d can be rounded up to the nearest integer:</p>
 * <p>h' = ceil(h) = (b' - s) / d, (4)</p>
 * <p>that gives an rounded, improved local bound:</p>
 * <p>b' = d * h' + s. (5)</p>
 * <p>In case of maximization '>=' in (1) should be replaced by '<=' that leads to the following formula:</p>
 * <p>h' = floor(h) = (b' - s) / d, (6)</p>
 * <p>which should used in the same way as (4).</p>
 * <p>NOTE: If b is a valid local bound for a child of the current subproblem, b' is also valid for that child subproblem. </p>
 */
public";

%javamethodmodifiers ios_is_hopeful(glp_tree *tree, double bound) "
/**
 * ios_is_hopeful - check if subproblem is hopeful .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" int ios_is_hopeful(glp_tree *tree, double bound);</p>
 * <p>DESCRIPTION</p>
 * <p>Given the local bound of a subproblem the routine ios_is_hopeful checks if the subproblem can have an integer optimal solution which is better than the best one currently known.</p>
 * <p>RETURNS</p>
 * <p>If the subproblem can have a better integer optimal solution, the routine returns non-zero; otherwise, if the corresponding branch can be pruned, the routine returns zero. </p>
 */
public";

%javamethodmodifiers ios_best_node(glp_tree *tree) "
/**
 * ios_best_node - find active node with best local bound .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" int ios_best_node(glp_tree *tree);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_best_node finds an active node whose local bound is best among other active nodes.</p>
 * <p>It is understood that the integer optimal solution of the original mip problem cannot be better than the best bound, so the best bound is an lower (minimization) or upper (maximization) global bound for the original problem.</p>
 * <p>RETURNS</p>
 * <p>The routine ios_best_node returns the subproblem reference number for the best node. However, if the tree is empty, it returns zero. </p>
 */
public";

%javamethodmodifiers ios_relative_gap(glp_tree *tree) "
/**
 * ios_relative_gap - compute relative mip gap .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" double ios_relative_gap(glp_tree *tree);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_relative_gap computes the relative mip gap using the formula:</p>
 * <p>gap = |best_mip - best_bnd| / (|best_mip| + DBL_EPSILON),</p>
 * <p>where best_mip is the best integer feasible solution found so far, best_bnd is the best (global) bound. If no integer feasible solution has been found yet, rel_gap is set to DBL_MAX.</p>
 * <p>RETURNS</p>
 * <p>The routine ios_relative_gap returns the relative mip gap. </p>
 */
public";

%javamethodmodifiers ios_solve_node(glp_tree *tree) "
/**
 * ios_solve_node - solve LP relaxation of current subproblem .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" int ios_solve_node(glp_tree *tree);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_solve_node re-optimizes LP relaxation of the current subproblem using the dual simplex method.</p>
 * <p>RETURNS</p>
 * <p>The routine returns the code which is reported by glp_simplex. </p>
 */
public";

%javamethodmodifiers ios_create_pool(glp_tree *tree) "
/**
 */
public";

%javamethodmodifiers ios_add_row(glp_tree *tree, IOSPOOL *pool, const char *name, int klass, int flags, int len, const int ind[], const double val[], int type, double rhs) "
/**
 */
public";

%javamethodmodifiers ios_find_row(IOSPOOL *pool, int i) "
/**
 */
public";

%javamethodmodifiers ios_del_row(glp_tree *tree, IOSPOOL *pool, int i) "
/**
 */
public";

%javamethodmodifiers ios_clear_pool(glp_tree *tree, IOSPOOL *pool) "
/**
 */
public";

%javamethodmodifiers ios_delete_pool(glp_tree *tree, IOSPOOL *pool) "
/**
 */
public";

%javamethodmodifiers prepare_row_info(int n, const double a[], const double l[], const double u[], struct f_info *f) "
/**
 */
public";

%javamethodmodifiers row_implied_bounds(const struct f_info *f, double *LL, double *UU) "
/**
 */
public";

%javamethodmodifiers col_implied_bounds(const struct f_info *f, int n, const double a[], double L, double U, const double l[], const double u[], int k, double *ll, double *uu) "
/**
 */
public";

%javamethodmodifiers check_row_bounds(const struct f_info *f, double *L_, double *U_) "
/**
 */
public";

%javamethodmodifiers check_col_bounds(const struct f_info *f, int n, const double a[], double L, double U, const double l[], const double u[], int flag, int j, double *_lj, double *_uj) "
/**
 */
public";

%javamethodmodifiers check_efficiency(int flag, double l, double u, double ll, double uu) "
/**
 */
public";

%javamethodmodifiers basic_preprocessing(glp_prob *mip, double L[], double U[], double l[], double u[], int nrs, const int num[], int max_pass) "
/**
 */
public";

%javamethodmodifiers ios_preprocess_node(glp_tree *tree, int max_pass) "
/**
 * ios_preprocess_node - preprocess current subproblem .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" int ios_preprocess_node(glp_tree *tree, int max_pass);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_preprocess_node performs basic preprocessing of the current subproblem.</p>
 * <p>RETURNS</p>
 * <p>If no primal infeasibility is detected, the routine returns zero, otherwise non-zero. </p>
 */
public";

%javamethodmodifiers show_progress(glp_tree *T, int bingo) "
/**
 */
public";

%javamethodmodifiers is_branch_hopeful(glp_tree *T, int p) "
/**
 */
public";

%javamethodmodifiers check_integrality(glp_tree *T) "
/**
 */
public";

%javamethodmodifiers record_solution(glp_tree *T) "
/**
 */
public";

%javamethodmodifiers fix_by_red_cost(glp_tree *T) "
/**
 */
public";

%javamethodmodifiers branch_on(glp_tree *T, int j, int next) "
/**
 */
public";

%javamethodmodifiers cleanup_the_tree(glp_tree *T) "
/**
 */
public";

%javamethodmodifiers generate_cuts(glp_tree *T) "
/**
 */
public";

%javamethodmodifiers remove_cuts(glp_tree *T) "
/**
 */
public";

%javamethodmodifiers display_cut_info(glp_tree *T) "
/**
 */
public";

%javamethodmodifiers ios_driver(glp_tree *T) "
/**
 * ios_driver - branch-and-cut driver .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" int ios_driver(glp_tree *T);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_driver is a branch-and-cut driver. It controls the MIP solution process.</p>
 * <p>RETURNS</p>
 * <p>0 The MIP problem instance has been successfully solved. This code does not necessarily mean that the solver has found optimal solution. It only means that the solution process was successful.</p>
 * <p>GLP_EFAIL The search was prematurely terminated due to the solver failure.</p>
 * <p>GLP_EMIPGAP The search was prematurely terminated, because the relative mip gap tolerance has been reached.</p>
 * <p>GLP_ETMLIM The search was prematurely terminated, because the time limit has been exceeded.</p>
 * <p>GLP_ESTOP The search was prematurely terminated by application. </p>
 */
public";

%javamethodmodifiers ios_create_vec(int n) "
/**
 * ios_create_vec - create sparse vector .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" IOSVEC *ios_create_vec(int n);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_create_vec creates a sparse vector of dimension n, which initially is a null vector.</p>
 * <p>RETURNS</p>
 * <p>The routine returns a pointer to the vector created. </p>
 */
public";

%javamethodmodifiers ios_check_vec(IOSVEC *v) "
/**
 * ios_check_vec - check that sparse vector has correct representation .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_check_vec(IOSVEC *v);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_check_vec checks that a sparse vector specified by the parameter v has correct representation.</p>
 * <p>NOTE</p>
 * <p>Complexity of this operation is O(n). </p>
 */
public";

%javamethodmodifiers ios_get_vj(IOSVEC *v, int j) "
/**
 * ios_get_vj - retrieve component of sparse vector .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" double ios_get_vj(IOSVEC *v, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine ios_get_vj returns j-th component of a sparse vector specified by the parameter v. </p>
 */
public";

%javamethodmodifiers ios_set_vj(IOSVEC *v, int j, double val) "
/**
 * ios_set_vj - set/change component of sparse vector .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_set_vj(IOSVEC *v, int j, double val);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_set_vj assigns val to j-th component of a sparse vector specified by the parameter v. </p>
 */
public";

%javamethodmodifiers ios_clear_vec(IOSVEC *v) "
/**
 * ios_clear_vec - set all components of sparse vector to zero .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_clear_vec(IOSVEC *v);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_clear_vec sets all components of a sparse vector specified by the parameter v to zero. </p>
 */
public";

%javamethodmodifiers ios_clean_vec(IOSVEC *v, double eps) "
/**
 * ios_clean_vec - remove zero or small components from sparse vector .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_clean_vec(IOSVEC *v, double eps);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_clean_vec removes zero components and components whose magnitude is less than eps from a sparse vector specified by the parameter v. If eps is 0.0, only zero components are removed. </p>
 */
public";

%javamethodmodifiers ios_copy_vec(IOSVEC *x, IOSVEC *y) "
/**
 * ios_copy_vec - copy sparse vector (x := y) .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_copy_vec(IOSVEC *x, IOSVEC *y);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_copy_vec copies a sparse vector specified by the parameter y to a sparse vector specified by the parameter x. </p>
 */
public";

%javamethodmodifiers ios_linear_comb(IOSVEC *x, double a, IOSVEC *y) "
/**
 * ios_linear_comb - compute linear combination (x := x + a * y) .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_linear_comb(IOSVEC *x, double a, IOSVEC *y);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_linear_comb computes the linear combination</p>
 * <p>x := x + a * y,</p>
 * <p>where x and y are sparse vectors, a is a scalar. </p>
 */
public";

%javamethodmodifiers ios_delete_vec(IOSVEC *v) "
/**
 * ios_delete_vec - delete sparse vector .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_delete_vec(IOSVEC *v);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_delete_vec deletes a sparse vector specified by the parameter v freeing all the memory allocated to this object. </p>
 */
public";

%javamethodmodifiers gen_cut(glp_tree *tree, struct worka *worka, int j) "
/**
 */
public";

%javamethodmodifiers fcmp(const void *p1, const void *p2) "
/**
 */
public";

%javamethodmodifiers ios_gmi_gen(glp_tree *tree) "
/**
 */
public";

%javamethodmodifiers set_row_attrib(glp_tree *tree, struct MIR *mir) "
/**
 * ios_mir_init - initialize MIR cut generator .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void *ios_mir_init(glp_tree *tree);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_mir_init initializes the MIR cut generator assuming that the current subproblem is the root subproblem.</p>
 * <p>RETURNS</p>
 * <p>The routine ios_mir_init returns a pointer to the MIR cut generator working area. </p>
 */
public";

%javamethodmodifiers set_col_attrib(glp_tree *tree, struct MIR *mir) "
/**
 */
public";

%javamethodmodifiers set_var_bounds(glp_tree *tree, struct MIR *mir) "
/**
 */
public";

%javamethodmodifiers mark_useless_rows(glp_tree *tree, struct MIR *mir) "
/**
 */
public";

%javamethodmodifiers ios_mir_init(glp_tree *tree) "
/**
 */
public";

%javamethodmodifiers get_current_point(glp_tree *tree, struct MIR *mir) "
/**
 * ios_mir_gen - generate MIR cuts .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_mir_gen(glp_tree *tree, void *gen, IOSPOOL *pool);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_mir_gen generates MIR cuts for the current point and adds them to the cut pool. </p>
 */
public";

%javamethodmodifiers initial_agg_row(glp_tree *tree, struct MIR *mir, int i) "
/**
 */
public";

%javamethodmodifiers subst_fixed_vars(struct MIR *mir) "
/**
 */
public";

%javamethodmodifiers bound_subst_heur(struct MIR *mir) "
/**
 */
public";

%javamethodmodifiers build_mod_row(struct MIR *mir) "
/**
 */
public";

%javamethodmodifiers mir_ineq(const int n, const double a[], const double b, double alpha[], double *beta, double *gamma) "
/**
 */
public";

%javamethodmodifiers cmir_ineq(const int n, const double a[], const double b, const double u[], const char cset[], const double delta, double alpha[], double *beta, double *gamma) "
/**
 */
public";

%javamethodmodifiers cmir_cmp(const void *p1, const void *p2) "
/**
 */
public";

%javamethodmodifiers cmir_sep(const int n, const double a[], const double b, const double u[], const double x[], const double s, double alpha[], double *beta, double *gamma) "
/**
 */
public";

%javamethodmodifiers generate(struct MIR *mir) "
/**
 */
public";

%javamethodmodifiers back_subst(struct MIR *mir) "
/**
 */
public";

%javamethodmodifiers subst_aux_vars(glp_tree *tree, struct MIR *mir) "
/**
 */
public";

%javamethodmodifiers add_cut(glp_tree *tree, struct MIR *mir) "
/**
 */
public";

%javamethodmodifiers aggregate_row(glp_tree *tree, struct MIR *mir) "
/**
 */
public";

%javamethodmodifiers ios_mir_gen(glp_tree *tree, void *gen) "
/**
 */
public";

%javamethodmodifiers ios_mir_term(void *gen) "
/**
 * ios_mir_term - terminate MIR cut generator .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_mir_term(void *gen);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_mir_term deletes the MIR cut generator working area freeing all the memory allocated to it. </p>
 */
public";

%javamethodmodifiers cover2(int n, double a[], double b, double u, double x[], double y, int cov[], double *_alfa, double *_beta) "
/**
 */
public";

%javamethodmodifiers cover3(int n, double a[], double b, double u, double x[], double y, int cov[], double *_alfa, double *_beta) "
/**
 */
public";

%javamethodmodifiers cover4(int n, double a[], double b, double u, double x[], double y, int cov[], double *_alfa, double *_beta) "
/**
 */
public";

%javamethodmodifiers cover(int n, double a[], double b, double u, double x[], double y, int cov[], double *alfa, double *beta) "
/**
 */
public";

%javamethodmodifiers lpx_cover_cut(LPX *lp, int len, int ind[], double val[], double work[]) "
/**
 */
public";

%javamethodmodifiers lpx_eval_row(LPX *lp, int len, int ind[], double val[]) "
/**
 */
public";

%javamethodmodifiers ios_cov_gen(glp_tree *tree) "
/**
 * ios_cov_gen - generate mixed cover cuts .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_cov_gen(glp_tree *tree);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_cov_gen generates mixed cover cuts for the current point and adds them to the cut pool. </p>
 */
public";

%javamethodmodifiers get_row_lb(LPX *lp, int i) "
/**
 */
public";

%javamethodmodifiers get_row_ub(LPX *lp, int i) "
/**
 */
public";

%javamethodmodifiers get_col_lb(LPX *lp, int j) "
/**
 */
public";

%javamethodmodifiers get_col_ub(LPX *lp, int j) "
/**
 */
public";

%javamethodmodifiers is_binary(LPX *lp, int j) "
/**
 */
public";

%javamethodmodifiers eval_lf_min(LPX *lp, int len, int ind[], double val[]) "
/**
 */
public";

%javamethodmodifiers eval_lf_max(LPX *lp, int len, int ind[], double val[]) "
/**
 */
public";

%javamethodmodifiers probing(int len, double val[], double L, double U, double lf_min, double lf_max, int p, int set, int q) "
/**
 */
public";

%javamethodmodifiers lpx_add_cog_edge(void *_cog, int i, int j) "
/**
 */
public";

%javamethodmodifiers lpx_create_cog(LPX *lp) "
/**
 */
public";

%javamethodmodifiers sub(struct dsa *dsa, int ct, int table[], int level, int weight, int l_weight) "
/**
 */
public";

%javamethodmodifiers wclique(int _n, int w[], unsigned char _a[], int sol[]) "
/**
 */
public";

%javamethodmodifiers lpx_clique_cut(LPX *lp, void *_cog, int ind[], double val[]) "
/**
 */
public";

%javamethodmodifiers lpx_delete_cog(void *_cog) "
/**
 */
public";

%javamethodmodifiers ios_clq_init(glp_tree *tree) "
/**
 */
public";

%javamethodmodifiers ios_clq_gen(glp_tree *tree, void *gen) "
/**
 * ios_clq_gen - generate clique cuts .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" void ios_clq_gen(glp_tree *tree, void *gen);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_clq_gen generates clique cuts for the current point and adds them to the clique pool. </p>
 */
public";

%javamethodmodifiers ios_clq_term(void *gen) "
/**
 */
public";

%javamethodmodifiers branch_first(glp_tree *T, int *next) "
/**
 * ios_choose_var - select variable to branch on .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" int ios_choose_var(glp_tree *T, int *next);</p>
 * <p>The routine ios_choose_var chooses a variable from the candidate list to branch on. Additionally the routine provides a flag stored in the location next to suggests which of the child subproblems should be solved next.</p>
 * <p>RETURNS</p>
 * <p>The routine ios_choose_var returns the ordinal number of the column choosen. </p>
 */
public";

%javamethodmodifiers branch_last(glp_tree *T, int *next) "
/**
 */
public";

%javamethodmodifiers branch_mostf(glp_tree *T, int *next) "
/**
 */
public";

%javamethodmodifiers branch_drtom(glp_tree *T, int *next) "
/**
 */
public";

%javamethodmodifiers ios_choose_var(glp_tree *T, int *next) "
/**
 */
public";

%javamethodmodifiers ios_pcost_init(glp_tree *tree) "
/**
 */
public";

%javamethodmodifiers eval_degrad(glp_prob *P, int j, double bnd) "
/**
 */
public";

%javamethodmodifiers ios_pcost_update(glp_tree *tree) "
/**
 */
public";

%javamethodmodifiers ios_pcost_free(glp_tree *tree) "
/**
 */
public";

%javamethodmodifiers eval_psi(glp_tree *T, int j, int brnch) "
/**
 */
public";

%javamethodmodifiers progress(glp_tree *T) "
/**
 */
public";

%javamethodmodifiers ios_pcost_branch(glp_tree *T, int *_next) "
/**
 */
public";

%javamethodmodifiers fcmp(const void *x, const void *y) "
/**
 */
public";

%javamethodmodifiers ios_feas_pump(glp_tree *T) "
/**
 */
public";

%javamethodmodifiers fcmp(const void *arg1, const void *arg2) "
/**
 */
public";

%javamethodmodifiers parallel(IOSCUT *a, IOSCUT *b, double work[]) "
/**
 */
public";

%javamethodmodifiers ios_process_cuts(glp_tree *T) "
/**
 */
public";

%javamethodmodifiers most_feas(glp_tree *T) "
/**
 * ios_choose_node - select subproblem to continue the search .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpios.h\" int ios_choose_node(glp_tree *T);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ios_choose_node selects a subproblem from the active list to continue the search. The choice depends on the backtracking technique option.</p>
 * <p>RETURNS</p>
 * <p>The routine ios_choose_node return the reference number of the subproblem selected. </p>
 */
public";

%javamethodmodifiers best_proj(glp_tree *T) "
/**
 */
public";

%javamethodmodifiers best_node(glp_tree *T) "
/**
 */
public";

%javamethodmodifiers ios_choose_node(glp_tree *T) "
/**
 */
public";

%javamethodmodifiers initialize(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers A_by_vec(struct csa *csa, double x[], double y[]) "
/**
 */
public";

%javamethodmodifiers AT_by_vec(struct csa *csa, double x[], double y[]) "
/**
 */
public";

%javamethodmodifiers decomp_NE(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers solve_NE(struct csa *csa, double y[]) "
/**
 */
public";

%javamethodmodifiers solve_NS(struct csa *csa, double p[], double q[], double r[], double dx[], double dy[], double dz[]) "
/**
 */
public";

%javamethodmodifiers initial_point(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers basic_info(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers make_step(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers terminate(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers ipm_main(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers ipm_solve(glp_prob *P, const glp_iptcp *parm) "
/**
 * ipm_solve - core LP solver based on the interior-point method .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpipm.h\" int ipm_solve(glp_prob *P, const glp_iptcp *parm);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ipm_solve is a core LP solver based on the primal-dual interior-point method.</p>
 * <p>The routine assumes the following standard formulation of LP problem to be solved:</p>
 * <p>minimize</p>
 * <p>F = c[0] + c[1]*x[1] + c[2]*x[2] + ... + c[n]*x[n]</p>
 * <p>subject to linear constraints</p>
 * <p>a[1,1]*x[1] + a[1,2]*x[2] + ... + a[1,n]*x[n] = b[1]</p>
 * <p>a[2,1]*x[1] + a[2,2]*x[2] + ... + a[2,n]*x[n] = b[2]</p>
 * <p>. . . . . .</p>
 * <p>a[m,1]*x[1] + a[m,2]*x[2] + ... + a[m,n]*x[n] = b[m]</p>
 * <p>and non-negative variables</p>
 * <p>x[1] >= 0, x[2] >= 0, ..., x[n] >= 0</p>
 * <p>where: F is the objective function; x[1], ..., x[n] are (structural) variables; c[0] is a constant term of the objective function; c[1], ..., c[n] are objective coefficients; a[1,1], ..., a[m,n] are constraint coefficients; b[1], ..., b[n] are right-hand sides.</p>
 * <p>The solution is three vectors x, y, and z, which are stored by the routine in the arrays x, y, and z, respectively. These vectors correspond to the best primal-dual point found during optimization. They are approximate solution of the following system (which is the Karush-Kuhn-Tucker optimality conditions):</p>
 * <p>A*x = b (primal feasibility condition)</p>
 * <p>A'*y + z = c (dual feasibility condition)</p>
 * <p>x'*z = 0 (primal-dual complementarity condition)</p>
 * <p>x >= 0, z >= 0 (non-negativity condition)</p>
 * <p>where: x[1], ..., x[n] are primal (structural) variables; y[1], ..., y[m] are dual variables (Lagrange multipliers) for equality constraints; z[1], ..., z[n] are dual variables (Lagrange multipliers) for non-negativity constraints.</p>
 * <p>RETURNS</p>
 * <p>0 LP has been successfully solved.</p>
 * <p>GLP_ENOCVG No convergence.</p>
 * <p>GLP_EITLIM Iteration limit exceeded.</p>
 * <p>GLP_EINSTAB Numeric instability on solving Newtonian system.</p>
 * <p>In case of non-zero return code the routine returns the best point, which has been reached during optimization. </p>
 */
public";

%javamethodmodifiers ipm_solve(glp_prob *P, const glp_iptcp *parm) "
/**
 * ipm_solve - core LP solver based on the interior-point method .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpipm.h\" int ipm_solve(glp_prob *P, const glp_iptcp *parm);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ipm_solve is a core LP solver based on the primal-dual interior-point method.</p>
 * <p>The routine assumes the following standard formulation of LP problem to be solved:</p>
 * <p>minimize</p>
 * <p>F = c[0] + c[1]*x[1] + c[2]*x[2] + ... + c[n]*x[n]</p>
 * <p>subject to linear constraints</p>
 * <p>a[1,1]*x[1] + a[1,2]*x[2] + ... + a[1,n]*x[n] = b[1]</p>
 * <p>a[2,1]*x[1] + a[2,2]*x[2] + ... + a[2,n]*x[n] = b[2]</p>
 * <p>. . . . . .</p>
 * <p>a[m,1]*x[1] + a[m,2]*x[2] + ... + a[m,n]*x[n] = b[m]</p>
 * <p>and non-negative variables</p>
 * <p>x[1] >= 0, x[2] >= 0, ..., x[n] >= 0</p>
 * <p>where: F is the objective function; x[1], ..., x[n] are (structural) variables; c[0] is a constant term of the objective function; c[1], ..., c[n] are objective coefficients; a[1,1], ..., a[m,n] are constraint coefficients; b[1], ..., b[n] are right-hand sides.</p>
 * <p>The solution is three vectors x, y, and z, which are stored by the routine in the arrays x, y, and z, respectively. These vectors correspond to the best primal-dual point found during optimization. They are approximate solution of the following system (which is the Karush-Kuhn-Tucker optimality conditions):</p>
 * <p>A*x = b (primal feasibility condition)</p>
 * <p>A'*y + z = c (dual feasibility condition)</p>
 * <p>x'*z = 0 (primal-dual complementarity condition)</p>
 * <p>x >= 0, z >= 0 (non-negativity condition)</p>
 * <p>where: x[1], ..., x[n] are primal (structural) variables; y[1], ..., y[m] are dual variables (Lagrange multipliers) for equality constraints; z[1], ..., z[n] are dual variables (Lagrange multipliers) for non-negativity constraints.</p>
 * <p>RETURNS</p>
 * <p>0 LP has been successfully solved.</p>
 * <p>GLP_ENOCVG No convergence.</p>
 * <p>GLP_EITLIM Iteration limit exceeded.</p>
 * <p>GLP_EINSTAB Numeric instability on solving Newtonian system.</p>
 * <p>In case of non-zero return code the routine returns the best point, which has been reached during optimization. </p>
 */
public";

%javamethodmodifiers glp_create_prob(void) "
/**
 */
public";

%javamethodmodifiers glp_set_prob_name(glp_prob *P, const char *name) "
/**
 * glp_set_prob_name - assign (change) problem name .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_prob_name(glp_prob *lp, const char *name);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_prob_name assigns a given symbolic name (1 up to 255 characters) to the specified problem object.</p>
 * <p>If the parameter name is NULL or empty string, the routine erases an existing symbolic name of the problem object. </p>
 */
public";

%javamethodmodifiers glp_set_obj_name(glp_prob *P, const char *name) "
/**
 * glp_set_obj_name - assign (change) objective function name .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_obj_name(glp_prob *lp, const char *name);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_obj_name assigns a given symbolic name (1 up to 255 characters) to the objective function of the specified problem object.</p>
 * <p>If the parameter name is NULL or empty string, the routine erases an existing name of the objective function. </p>
 */
public";

%javamethodmodifiers glp_set_obj_dir(glp_prob *P, int dir) "
/**
 * glp_set_obj_dir - set (change) optimization direction flag .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_obj_dir(glp_prob *lp, int dir);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_obj_dir sets (changes) optimization direction flag (i.e. \"sense\" of the objective function) as specified by the parameter dir:</p>
 * <p>GLP_MIN - minimization; GLP_MAX - maximization. </p>
 */
public";

%javamethodmodifiers glp_add_rows(glp_prob *P, int nrs) "
/**
 * glp_add_rows - add new rows to problem object .
 * <p>SYNOPSIS</p>
 * <p>int glp_add_rows(glp_prob *lp, int nrs);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_add_rows adds nrs rows (constraints) to the specified problem object. New rows are always added to the end of the row list, so the ordinal numbers of existing rows remain unchanged.</p>
 * <p>Being added each new row is initially free (unbounded) and has empty list of the constraint coefficients.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_add_rows returns the ordinal number of the first new row added to the problem object. </p>
 */
public";

%javamethodmodifiers glp_add_cols(glp_prob *P, int ncs) "
/**
 * glp_add_cols - add new columns to problem object .
 * <p>SYNOPSIS</p>
 * <p>int glp_add_cols(glp_prob *lp, int ncs);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_add_cols adds ncs columns (structural variables) to the specified problem object. New columns are always added to the end of the column list, so the ordinal numbers of existing columns remain unchanged.</p>
 * <p>Being added each new column is initially fixed at zero and has empty list of the constraint coefficients.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_add_cols returns the ordinal number of the first new column added to the problem object. </p>
 */
public";

%javamethodmodifiers glp_set_row_name(glp_prob *P, int i, const char *name) "
/**
 * glp_set_row_name - assign (change) row name .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_row_name(glp_prob *lp, int i, const char *name);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_row_name assigns a given symbolic name (1 up to 255 characters) to i-th row (auxiliary variable) of the specified problem object.</p>
 * <p>If the parameter name is NULL or empty string, the routine erases an existing name of i-th row. </p>
 */
public";

%javamethodmodifiers glp_set_col_name(glp_prob *P, int j, const char *name) "
/**
 * glp_set_col_name - assign (change) column name .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_col_name(glp_prob *lp, int j, const char *name);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_col_name assigns a given symbolic name (1 up to 255 characters) to j-th column (structural variable) of the specified problem object.</p>
 * <p>If the parameter name is NULL or empty string, the routine erases an existing name of j-th column. </p>
 */
public";

%javamethodmodifiers glp_set_row_bnds(glp_prob *P, int i, int type, double lb, double ub) "
/**
 * glp_set_row_bnds - set (change) row bounds .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_row_bnds(glp_prob *lp, int i, int type, double lb, double ub);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_row_bnds sets (changes) the type and bounds of i-th row (auxiliary variable) of the specified problem object.</p>
 * <p>Parameters type, lb, and ub specify the type, lower bound, and upper bound, respectively, as follows:</p>
 * <p>Type Bounds Comments ------------------------------------------------------ GLP_FR -inf < x < +inf Free variable GLP_LO lb <= x < +inf Variable with lower bound GLP_UP -inf < x <= ub Variable with upper bound GLP_DB lb <= x <= ub Double-bounded variable GLP_FX x = lb Fixed variable</p>
 * <p>where x is the auxiliary variable associated with i-th row.</p>
 * <p>If the row has no lower bound, the parameter lb is ignored. If the row has no upper bound, the parameter ub is ignored. If the row is an equality constraint (i.e. the corresponding auxiliary variable is of fixed type), only the parameter lb is used while the parameter ub is ignored. </p>
 */
public";

%javamethodmodifiers glp_set_col_bnds(glp_prob *P, int j, int type, double lb, double ub) "
/**
 * glp_set_col_bnds - set (change) column bounds .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_col_bnds(glp_prob *lp, int j, int type, double lb, double ub);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_col_bnds sets (changes) the type and bounds of j-th column (structural variable) of the specified problem object.</p>
 * <p>Parameters type, lb, and ub specify the type, lower bound, and upper bound, respectively, as follows:</p>
 * <p>Type Bounds Comments ------------------------------------------------------ GLP_FR -inf < x < +inf Free variable GLP_LO lb <= x < +inf Variable with lower bound GLP_UP -inf < x <= ub Variable with upper bound GLP_DB lb <= x <= ub Double-bounded variable GLP_FX x = lb Fixed variable</p>
 * <p>where x is the structural variable associated with j-th column.</p>
 * <p>If the column has no lower bound, the parameter lb is ignored. If the column has no upper bound, the parameter ub is ignored. If the column is of fixed type, only the parameter lb is used while the parameter ub is ignored. </p>
 */
public";

%javamethodmodifiers glp_set_obj_coef(glp_prob *P, int j, double coef) "
/**
 * glp_set_obj_coef - set (change) obj. .
 * <p>coefficient or constant term</p>
 * <p>SYNOPSIS</p>
 * <p>void glp_set_obj_coef(glp_prob *lp, int j, double coef);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_obj_coef sets (changes) objective coefficient at j-th column (structural variable) of the specified problem object.</p>
 * <p>If the parameter j is 0, the routine sets (changes) the constant term (\"shift\") of the objective function. </p>
 */
public";

%javamethodmodifiers glp_set_mat_row(glp_prob *P, int i, int len, const int ind[], const double val[]) "
/**
 * glp_set_mat_row - set (replace) row of the constraint matrix .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_mat_row(glp_prob *lp, int i, int len, const int ind[], const double val[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_mat_row stores (replaces) the contents of i-th row of the constraint matrix of the specified problem object.</p>
 * <p>Column indices and numeric values of new row elements must be placed in locations ind[1], ..., ind[len] and val[1], ..., val[len], where 0 <= len <= n is the new length of i-th row, n is the current number of columns in the problem object. Elements with identical column indices are not allowed. Zero elements are allowed, but they are not stored in the constraint matrix.</p>
 * <p>If the parameter len is zero, the parameters ind and/or val can be specified as NULL. </p>
 */
public";

%javamethodmodifiers glp_set_mat_col(glp_prob *P, int j, int len, const int ind[], const double val[]) "
/**
 * glp_set_mat_col - set (replace) column of the constraint matrix .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_mat_col(glp_prob *lp, int j, int len, const int ind[], const double val[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_mat_col stores (replaces) the contents of j-th column of the constraint matrix of the specified problem object.</p>
 * <p>Row indices and numeric values of new column elements must be placed in locations ind[1], ..., ind[len] and val[1], ..., val[len], where 0 <= len <= m is the new length of j-th column, m is the current number of rows in the problem object. Elements with identical column indices are not allowed. Zero elements are allowed, but they are not stored in the constraint matrix.</p>
 * <p>If the parameter len is zero, the parameters ind and/or val can be specified as NULL. </p>
 */
public";

%javamethodmodifiers glp_load_matrix(glp_prob *P, int ne, const int ia[], const int ja[], const double ar[]) "
/**
 * glp_load_matrix - load (replace) the whole constraint matrix .
 * <p>SYNOPSIS</p>
 * <p>void glp_load_matrix(glp_prob *lp, int ne, const int ia[], const int ja[], const double ar[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_load_matrix loads the constraint matrix passed in the arrays ia, ja, and ar into the specified problem object. Before loading the current contents of the constraint matrix is destroyed.</p>
 * <p>Constraint coefficients (elements of the constraint matrix) must be specified as triplets (ia[k], ja[k], ar[k]) for k = 1, ..., ne, where ia[k] is the row index, ja[k] is the column index, ar[k] is a numeric value of corresponding constraint coefficient. The parameter ne specifies the total number of (non-zero) elements in the matrix to be loaded. Coefficients with identical indices are not allowed. Zero coefficients are allowed, however, they are not stored in the constraint matrix.</p>
 * <p>If the parameter ne is zero, the parameters ia, ja, and ar can be specified as NULL. </p>
 */
public";

%javamethodmodifiers glp_check_dup(int m, int n, int ne, const int ia[], const int ja[]) "
/**
 * glp_check_dup - check for duplicate elements in sparse matrix .
 * <p>SYNOPSIS</p>
 * <p>int glp_check_dup(int m, int n, int ne, const int ia[], const int ja[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_check_dup checks for duplicate elements (that is, elements with identical indices) in a sparse matrix specified in the coordinate format.</p>
 * <p>The parameters m and n specifies, respectively, the number of rows and columns in the matrix, m >= 0, n >= 0.</p>
 * <p>The parameter ne specifies the number of (structurally) non-zero elements in the matrix, ne >= 0.</p>
 * <p>Elements of the matrix are specified as doublets (ia[k],ja[k]) for k = 1,...,ne, where ia[k] is a row index, ja[k] is a column index.</p>
 * <p>The routine glp_check_dup can be used prior to a call to the routine glp_load_matrix to check that the constraint matrix to be loaded has no duplicate elements.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_check_dup returns one of the following values:</p>
 * <p>0 - the matrix has no duplicate elements;</p>
 * <p>-k - indices ia[k] or/and ja[k] are out of range;</p>
 * <p>+k - element (ia[k],ja[k]) is duplicate. </p>
 */
public";

%javamethodmodifiers glp_sort_matrix(glp_prob *P) "
/**
 * glp_sort_matrix - sort elements of the constraint matrix .
 * <p>SYNOPSIS</p>
 * <p>void glp_sort_matrix(glp_prob *P);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_sort_matrix sorts elements of the constraint matrix rebuilding its row and column linked lists. On exit from the routine the constraint matrix is not changed, however, elements in the row linked lists become ordered by ascending column indices, and the elements in the column linked lists become ordered by ascending row indices. </p>
 */
public";

%javamethodmodifiers glp_del_rows(glp_prob *P, int nrs, const int num[]) "
/**
 * glp_del_rows - delete rows from problem object .
 * <p>SYNOPSIS</p>
 * <p>void glp_del_rows(glp_prob *lp, int nrs, const int num[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_del_rows deletes rows from the specified problem object. Ordinal numbers of rows to be deleted should be placed in locations num[1], ..., num[nrs], where nrs > 0.</p>
 * <p>Note that deleting rows involves changing ordinal numbers of other rows remaining in the problem object. New ordinal numbers of the remaining rows are assigned under the assumption that the original order of rows is not changed. </p>
 */
public";

%javamethodmodifiers glp_del_cols(glp_prob *P, int ncs, const int num[]) "
/**
 * glp_del_cols - delete columns from problem object .
 * <p>SYNOPSIS</p>
 * <p>void glp_del_cols(glp_prob *lp, int ncs, const int num[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_del_cols deletes columns from the specified problem object. Ordinal numbers of columns to be deleted should be placed in locations num[1], ..., num[ncs], where ncs > 0.</p>
 * <p>Note that deleting columns involves changing ordinal numbers of other columns remaining in the problem object. New ordinal numbers of the remaining columns are assigned under the assumption that the original order of columns is not changed. </p>
 */
public";

%javamethodmodifiers glp_copy_prob(glp_prob *dest, glp_prob *prob, int names) "
/**
 * glp_copy_prob - copy problem object content .
 * <p>SYNOPSIS</p>
 * <p>void glp_copy_prob(glp_prob *dest, glp_prob *prob, int names);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_copy_prob copies the content of the problem object prob to the problem object dest.</p>
 * <p>The parameter names is a flag. If it is non-zero, the routine also copies all symbolic names; otherwise, if it is zero, symbolic names are not copied. </p>
 */
public";

%javamethodmodifiers glp_erase_prob(glp_prob *P) "
/**
 */
public";

%javamethodmodifiers glp_delete_prob(glp_prob *P) "
/**
 */
public";

%javamethodmodifiers glp_get_prob_name(glp_prob *P) "
/**
 * glp_get_prob_name - retrieve problem name .
 * <p>SYNOPSIS</p>
 * <p>const char *glp_get_prob_name(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_prob_name returns a pointer to an internal buffer, which contains symbolic name of the problem. However, if the problem has no assigned name, the routine returns NULL. </p>
 */
public";

%javamethodmodifiers glp_get_obj_name(glp_prob *P) "
/**
 * glp_get_obj_name - retrieve objective function name .
 * <p>SYNOPSIS</p>
 * <p>const char *glp_get_obj_name(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_obj_name returns a pointer to an internal buffer, which contains a symbolic name of the objective function. However, if the objective function has no assigned name, the routine returns NULL. </p>
 */
public";

%javamethodmodifiers glp_get_obj_dir(glp_prob *P) "
/**
 * glp_get_obj_dir - retrieve optimization direction flag .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_obj_dir(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_obj_dir returns the optimization direction flag (i.e. \"sense\" of the objective function):</p>
 * <p>GLP_MIN - minimization; GLP_MAX - maximization. </p>
 */
public";

%javamethodmodifiers glp_get_num_rows(glp_prob *P) "
/**
 * glp_get_num_rows - retrieve number of rows .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_num_rows(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_num_rows returns the current number of rows in the specified problem object. </p>
 */
public";

%javamethodmodifiers glp_get_num_cols(glp_prob *P) "
/**
 * glp_get_num_cols - retrieve number of columns .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_num_cols(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_num_cols returns the current number of columns in the specified problem object. </p>
 */
public";

%javamethodmodifiers glp_get_row_name(glp_prob *P, int i) "
/**
 * glp_get_row_name - retrieve row name .
 * <p>SYNOPSIS</p>
 * <p>const char *glp_get_row_name(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_row_name returns a pointer to an internal buffer, which contains symbolic name of i-th row. However, if i-th row has no assigned name, the routine returns NULL. </p>
 */
public";

%javamethodmodifiers glp_get_col_name(glp_prob *P, int j) "
/**
 * glp_get_col_name - retrieve column name .
 * <p>SYNOPSIS</p>
 * <p>const char *glp_get_col_name(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_col_name returns a pointer to an internal buffer, which contains symbolic name of j-th column. However, if j-th column has no assigned name, the routine returns NULL. </p>
 */
public";

%javamethodmodifiers glp_get_row_type(glp_prob *P, int i) "
/**
 * glp_get_row_type - retrieve row type .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_row_type(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_row_type returns the type of i-th row, i.e. the type of corresponding auxiliary variable, as follows:</p>
 * <p>GLP_FR - free (unbounded) variable; GLP_LO - variable with lower bound; GLP_UP - variable with upper bound; GLP_DB - double-bounded variable; GLP_FX - fixed variable. </p>
 */
public";

%javamethodmodifiers glp_get_row_lb(glp_prob *P, int i) "
/**
 * glp_get_row_lb - retrieve row lower bound .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_row_lb(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_row_lb returns the lower bound of i-th row, i.e. the lower bound of corresponding auxiliary variable. However, if the row has no lower bound, the routine returns -DBL_MAX. </p>
 */
public";

%javamethodmodifiers glp_get_row_ub(glp_prob *P, int i) "
/**
 * glp_get_row_ub - retrieve row upper bound .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_row_ub(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_row_ub returns the upper bound of i-th row, i.e. the upper bound of corresponding auxiliary variable. However, if the row has no upper bound, the routine returns +DBL_MAX. </p>
 */
public";

%javamethodmodifiers glp_get_col_type(glp_prob *P, int j) "
/**
 * glp_get_col_type - retrieve column type .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_col_type(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_col_type returns the type of j-th column, i.e. the type of corresponding structural variable, as follows:</p>
 * <p>GLP_FR - free (unbounded) variable; GLP_LO - variable with lower bound; GLP_UP - variable with upper bound; GLP_DB - double-bounded variable; GLP_FX - fixed variable. </p>
 */
public";

%javamethodmodifiers glp_get_col_lb(glp_prob *P, int j) "
/**
 * glp_get_col_lb - retrieve column lower bound .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_col_lb(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_col_lb returns the lower bound of j-th column, i.e. the lower bound of corresponding structural variable. However, if the column has no lower bound, the routine returns -DBL_MAX. </p>
 */
public";

%javamethodmodifiers glp_get_col_ub(glp_prob *P, int j) "
/**
 * glp_get_col_ub - retrieve column upper bound .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_col_ub(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_col_ub returns the upper bound of j-th column, i.e. the upper bound of corresponding structural variable. However, if the column has no upper bound, the routine returns +DBL_MAX. </p>
 */
public";

%javamethodmodifiers glp_get_obj_coef(glp_prob *P, int j) "
/**
 * glp_get_obj_coef - retrieve obj. .
 * <p>coefficient or constant term</p>
 * <p>SYNOPSIS</p>
 * <p>double glp_get_obj_coef(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_obj_coef returns the objective coefficient at j-th structural variable (column) of the specified problem object.</p>
 * <p>If the parameter j is zero, the routine returns the constant term (\"shift\") of the objective function. </p>
 */
public";

%javamethodmodifiers glp_get_num_nz(glp_prob *P) "
/**
 * glp_get_num_nz - retrieve number of constraint coefficients .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_num_nz(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_num_nz returns the number of (non-zero) elements in the constraint matrix of the specified problem object. </p>
 */
public";

%javamethodmodifiers glp_get_mat_row(glp_prob *P, int i, int ind[], double val[]) "
/**
 * glp_get_mat_row - retrieve row of the constraint matrix .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_mat_row(glp_prob *lp, int i, int ind[], double val[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_get_mat_row scans (non-zero) elements of i-th row of the constraint matrix of the specified problem object and stores their column indices and numeric values to locations ind[1], ..., ind[len] and val[1], ..., val[len], respectively, where 0 <= len <= n is the number of elements in i-th row, n is the number of columns.</p>
 * <p>The parameter ind and/or val can be specified as NULL, in which case corresponding information is not stored.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_mat_row returns the length len, i.e. the number of (non-zero) elements in i-th row. </p>
 */
public";

%javamethodmodifiers glp_get_mat_col(glp_prob *P, int j, int ind[], double val[]) "
/**
 * glp_get_mat_col - retrieve column of the constraint matrix .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_mat_col(glp_prob *lp, int j, int ind[], double val[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_get_mat_col scans (non-zero) elements of j-th column of the constraint matrix of the specified problem object and stores their row indices and numeric values to locations ind[1], ..., ind[len] and val[1], ..., val[len], respectively, where 0 <= len <= m is the number of elements in j-th column, m is the number of rows.</p>
 * <p>The parameter ind or/and val can be specified as NULL, in which case corresponding information is not stored.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_mat_col returns the length len, i.e. the number of (non-zero) elements in j-th column. </p>
 */
public";

%javamethodmodifiers glp_create_index(glp_prob *P) "
/**
 * glp_create_index - create the name index .
 * <p>SYNOPSIS</p>
 * <p>void glp_create_index(glp_prob *lp);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_create_index creates the name index for the specified problem object. The name index is an auxiliary data structure, which is intended to quickly (i.e. for logarithmic time) find rows and columns by their names.</p>
 * <p>This routine can be called at any time. If the name index already exists, the routine does nothing. </p>
 */
public";

%javamethodmodifiers glp_find_row(glp_prob *P, const char *name) "
/**
 * glp_find_row - find row by its name .
 * <p>SYNOPSIS</p>
 * <p>int glp_find_row(glp_prob *lp, const char *name);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_find_row returns the ordinal number of a row, which is assigned (by the routine glp_set_row_name) the specified symbolic name. If no such row exists, the routine returns 0. </p>
 */
public";

%javamethodmodifiers glp_find_col(glp_prob *P, const char *name) "
/**
 * glp_find_col - find column by its name .
 * <p>SYNOPSIS</p>
 * <p>int glp_find_col(glp_prob *lp, const char *name);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_find_col returns the ordinal number of a column, which is assigned (by the routine glp_set_col_name) the specified symbolic name. If no such column exists, the routine returns 0. </p>
 */
public";

%javamethodmodifiers glp_delete_index(glp_prob *P) "
/**
 * glp_delete_index - delete the name index .
 * <p>SYNOPSIS</p>
 * <p>void glp_delete_index(glp_prob *lp);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_delete_index deletes the name index previously created by the routine glp_create_index and frees the memory allocated to this auxiliary data structure.</p>
 * <p>This routine can be called at any time. If the name index does not exist, the routine does nothing. </p>
 */
public";

%javamethodmodifiers glp_set_rii(glp_prob *P, int i, double rii) "
/**
 * glp_set_rii - set (change) row scale factor .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_rii(glp_prob *lp, int i, double rii);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_rii sets (changes) the scale factor r[i,i] for i-th row of the specified problem object. </p>
 */
public";

%javamethodmodifiers glp_set_sjj(glp_prob *P, int j, double sjj) "
/**
 * glp_set sjj - set (change) column scale factor .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_sjj(glp_prob *lp, int j, double sjj);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_sjj sets (changes) the scale factor s[j,j] for j-th column of the specified problem object. </p>
 */
public";

%javamethodmodifiers glp_get_rii(glp_prob *P, int i) "
/**
 * glp_get_rii - retrieve row scale factor .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_rii(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_rii returns current scale factor r[i,i] for i-th row of the specified problem object. </p>
 */
public";

%javamethodmodifiers glp_get_sjj(glp_prob *P, int j) "
/**
 * glp_get_sjj - retrieve column scale factor .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_sjj(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_sjj returns current scale factor s[j,j] for j-th column of the specified problem object. </p>
 */
public";

%javamethodmodifiers glp_scale_prob(glp_prob *P, int flags) "
/**
 * glp_scale_prob - scale problem data .
 * <p>SYNOPSIS</p>
 * <p>void glp_scale_prob(glp_prob *lp, int flags);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_scale_prob performs automatic scaling of problem data for the specified problem object.</p>
 * <p>The parameter flags specifies scaling options used by the routine. Options can be combined with the bitwise OR operator and may be the following:</p>
 * <p>GLP_SF_GM perform geometric mean scaling; GLP_SF_EQ perform equilibration scaling; GLP_SF_2N round scale factors to nearest power of two; GLP_SF_SKIP skip scaling, if the problem is well scaled.</p>
 * <p>The parameter flags may be specified as GLP_SF_AUTO, in which case the routine chooses scaling options automatically. </p>
 */
public";

%javamethodmodifiers glp_unscale_prob(glp_prob *P) "
/**
 * glp_unscale_prob - unscale problem data .
 * <p>SYNOPSIS</p>
 * <p>void glp_unscale_prob(glp_prob *lp);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_unscale_prob performs unscaling of problem data for the specified problem object.</p>
 * <p>\"Unscaling\" means replacing the current scaling matrices R and S by unity matrices that cancels the scaling effect. </p>
 */
public";

%javamethodmodifiers glp_set_row_stat(glp_prob *P, int i, int stat) "
/**
 * glp_set_row_stat - set (change) row status .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_row_stat(glp_prob *lp, int i, int stat);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_row_stat sets (changes) status of the auxiliary variable associated with i-th row.</p>
 * <p>The new status of the auxiliary variable should be specified by the parameter stat as follows:</p>
 * <p>GLP_BS - basic variable; GLP_NL - non-basic variable; GLP_NU - non-basic variable on its upper bound; if the variable is not double-bounded, this means the same as GLP_NL (only in case of this routine); GLP_NF - the same as GLP_NL (only in case of this routine); GLP_NS - the same as GLP_NL (only in case of this routine). </p>
 */
public";

%javamethodmodifiers glp_set_col_stat(glp_prob *P, int j, int stat) "
/**
 * glp_set_col_stat - set (change) column status .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_col_stat(glp_prob *lp, int j, int stat);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_col_stat sets (changes) status of the structural variable associated with j-th column.</p>
 * <p>The new status of the structural variable should be specified by the parameter stat as follows:</p>
 * <p>GLP_BS - basic variable; GLP_NL - non-basic variable; GLP_NU - non-basic variable on its upper bound; if the variable is not double-bounded, this means the same as GLP_NL (only in case of this routine); GLP_NF - the same as GLP_NL (only in case of this routine); GLP_NS - the same as GLP_NL (only in case of this routine). </p>
 */
public";

%javamethodmodifiers glp_std_basis(glp_prob *P) "
/**
 * glp_std_basis - construct standard initial LP basis .
 * <p>SYNOPSIS</p>
 * <p>void glp_std_basis(glp_prob *lp);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_std_basis builds the \"standard\" (trivial) initial basis for the specified problem object.</p>
 * <p>In the \"standard\" basis all auxiliary variables are basic, and all structural variables are non-basic. </p>
 */
public";

%javamethodmodifiers glp_adv_basis(glp_prob *P, int flags) "
/**
 * glp_adv_basis - construct advanced initial LP basis .
 * <p>SYNOPSIS</p>
 * <p>void glp_adv_basis(glp_prob *lp, int flags);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_adv_basis constructs an advanced initial basis for the specified problem object.</p>
 * <p>The parameter flags is reserved for use in the future and must be specified as zero. </p>
 */
public";

%javamethodmodifiers glp_cpx_basis(glp_prob *P) "
/**
 * glp_cpx_basis - construct Bixby's initial LP basis .
 * <p>SYNOPSIS</p>
 * <p>void glp_cpx_basis(glp_prob *lp);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_cpx_basis constructs an advanced initial basis for the specified problem object.</p>
 * <p>The routine is based on Bixby's algorithm described in the paper:</p>
 * <p>Robert E. Bixby. Implementing the Simplex Method: The Initial Basis. ORSA Journal on Computing, Vol. 4, No. 3, 1992, pp. 267-84. </p>
 */
public";

%javamethodmodifiers glp_simplex(glp_prob *P, const glp_smcp *parm) "
/**
 */
public";

%javamethodmodifiers glp_exact(glp_prob *P, const glp_smcp *parm) "
/**
 */
public";

%javamethodmodifiers glp_init_smcp(glp_smcp *parm) "
/**
 * glp_init_smcp - initialize simplex method control parameters .
 * <p>SYNOPSIS</p>
 * <p>void glp_init_smcp(glp_smcp *parm);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_init_smcp initializes control parameters, which are used by the simplex solver, with default values.</p>
 * <p>Default values of the control parameters are stored in a glp_smcp structure, which the parameter parm points to. </p>
 */
public";

%javamethodmodifiers glp_get_status(glp_prob *P) "
/**
 * glp_get_status - retrieve generic status of basic solution .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_status(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_status reports the generic status of the basic solution for the specified problem object as follows:</p>
 * <p>GLP_OPT - solution is optimal; GLP_FEAS - solution is feasible; GLP_INFEAS - solution is infeasible; GLP_NOFEAS - problem has no feasible solution; GLP_UNBND - problem has unbounded solution; GLP_UNDEF - solution is undefined. </p>
 */
public";

%javamethodmodifiers glp_get_prim_stat(glp_prob *P) "
/**
 * glp_get_prim_stat - retrieve status of primal basic solution .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_prim_stat(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_prim_stat reports the status of the primal basic solution for the specified problem object as follows:</p>
 * <p>GLP_UNDEF - primal solution is undefined; GLP_FEAS - primal solution is feasible; GLP_INFEAS - primal solution is infeasible; GLP_NOFEAS - no primal feasible solution exists. </p>
 */
public";

%javamethodmodifiers glp_get_dual_stat(glp_prob *P) "
/**
 * glp_get_dual_stat - retrieve status of dual basic solution .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_dual_stat(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_dual_stat reports the status of the dual basic solution for the specified problem object as follows:</p>
 * <p>GLP_UNDEF - dual solution is undefined; GLP_FEAS - dual solution is feasible; GLP_INFEAS - dual solution is infeasible; GLP_NOFEAS - no dual feasible solution exists. </p>
 */
public";

%javamethodmodifiers glp_get_obj_val(glp_prob *P) "
/**
 * glp_get_obj_val - retrieve objective value (basic solution) .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_obj_val(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_obj_val returns value of the objective function for basic solution. </p>
 */
public";

%javamethodmodifiers glp_get_row_stat(glp_prob *P, int i) "
/**
 * glp_get_row_stat - retrieve row status .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_row_stat(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_row_stat returns current status assigned to the auxiliary variable associated with i-th row as follows:</p>
 * <p>GLP_BS - basic variable; GLP_NL - non-basic variable on its lower bound; GLP_NU - non-basic variable on its upper bound; GLP_NF - non-basic free (unbounded) variable; GLP_NS - non-basic fixed variable. </p>
 */
public";

%javamethodmodifiers glp_get_row_prim(glp_prob *P, int i) "
/**
 * glp_get_row_prim - retrieve row primal value (basic solution) .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_row_prim(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_row_prim returns primal value of the auxiliary variable associated with i-th row. </p>
 */
public";

%javamethodmodifiers glp_get_row_dual(glp_prob *P, int i) "
/**
 * glp_get_row_dual - retrieve row dual value (basic solution) .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_row_dual(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_row_dual returns dual value (i.e. reduced cost) of the auxiliary variable associated with i-th row. </p>
 */
public";

%javamethodmodifiers glp_get_col_stat(glp_prob *P, int j) "
/**
 * glp_get_col_stat - retrieve column status .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_col_stat(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_col_stat returns current status assigned to the structural variable associated with j-th column as follows:</p>
 * <p>GLP_BS - basic variable; GLP_NL - non-basic variable on its lower bound; GLP_NU - non-basic variable on its upper bound; GLP_NF - non-basic free (unbounded) variable; GLP_NS - non-basic fixed variable. </p>
 */
public";

%javamethodmodifiers glp_get_col_prim(glp_prob *P, int j) "
/**
 * glp_get_col_prim - retrieve column primal value (basic solution) .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_col_prim(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_col_prim returns primal value of the structural variable associated with j-th column. </p>
 */
public";

%javamethodmodifiers glp_get_col_dual(glp_prob *P, int j) "
/**
 * glp_get_col_dual - retrieve column dual value (basic solution) .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_col_dual(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_col_dual returns dual value (i.e. reduced cost) of the structural variable associated with j-th column. </p>
 */
public";

%javamethodmodifiers glp_get_unbnd_ray(glp_prob *P) "
/**
 * glp_get_unbnd_ray - determine variable causing unboundedness .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_unbnd_ray(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_unbnd_ray returns the number k of a variable, which causes primal or dual unboundedness. If 1 <= k <= m, it is k-th auxiliary variable, and if m+1 <= k <= m+n, it is (k-m)-th structural variable, where m is the number of rows, n is the number of columns in the problem object. If such variable is not defined, the routine returns 0.</p>
 * <p>COMMENTS</p>
 * <p>If it is not exactly known which version of the simplex solver detected unboundedness, i.e. whether the unboundedness is primal or dual, it is sufficient to check the status of the variable reported with the routine glp_get_row_stat or glp_get_col_stat. If the variable is non-basic, the unboundedness is primal, otherwise, if the variable is basic, the unboundedness is dual (the latter case means that the problem has no primal feasible dolution). </p>
 */
public";

%javamethodmodifiers glp_interior(glp_prob *P, const glp_iptcp *parm) "
/**
 */
public";

%javamethodmodifiers glp_init_iptcp(glp_iptcp *parm) "
/**
 * glp_init_iptcp - initialize interior-point solver control parameters .
 * <p>SYNOPSIS</p>
 * <p>void glp_init_iptcp(glp_iptcp *parm);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_init_iptcp initializes control parameters, which are used by the interior-point solver, with default values.</p>
 * <p>Default values of the control parameters are stored in the glp_iptcp structure, which the parameter parm points to. </p>
 */
public";

%javamethodmodifiers glp_ipt_status(glp_prob *P) "
/**
 * glp_ipt_status - retrieve status of interior-point solution .
 * <p>SYNOPSIS</p>
 * <p>int glp_ipt_status(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ipt_status reports the status of solution found by the interior-point solver as follows:</p>
 * <p>GLP_UNDEF - interior-point solution is undefined; GLP_OPT - interior-point solution is optimal; GLP_INFEAS - interior-point solution is infeasible; GLP_NOFEAS - no feasible solution exists. </p>
 */
public";

%javamethodmodifiers glp_ipt_obj_val(glp_prob *P) "
/**
 * glp_ipt_obj_val - retrieve objective value (interior point) .
 * <p>SYNOPSIS</p>
 * <p>double glp_ipt_obj_val(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ipt_obj_val returns value of the objective function for interior-point solution. </p>
 */
public";

%javamethodmodifiers glp_ipt_row_prim(glp_prob *P, int i) "
/**
 * glp_ipt_row_prim - retrieve row primal value (interior point) .
 * <p>SYNOPSIS</p>
 * <p>double glp_ipt_row_prim(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ipt_row_prim returns primal value of the auxiliary variable associated with i-th row. </p>
 */
public";

%javamethodmodifiers glp_ipt_row_dual(glp_prob *P, int i) "
/**
 * glp_ipt_row_dual - retrieve row dual value (interior point) .
 * <p>SYNOPSIS</p>
 * <p>double glp_ipt_row_dual(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ipt_row_dual returns dual value (i.e. reduced cost) of the auxiliary variable associated with i-th row. </p>
 */
public";

%javamethodmodifiers glp_ipt_col_prim(glp_prob *P, int j) "
/**
 * glp_ipt_col_prim - retrieve column primal value (interior point) .
 * <p>SYNOPSIS</p>
 * <p>double glp_ipt_col_prim(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ipt_col_prim returns primal value of the structural variable associated with j-th column. </p>
 */
public";

%javamethodmodifiers glp_ipt_col_dual(glp_prob *P, int j) "
/**
 * glp_ipt_col_dual - retrieve column dual value (interior point) .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplpx.h\" double glp_ipt_col_dual(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ipt_col_dual returns dual value (i.e. reduced cost) of the structural variable associated with j-th column. </p>
 */
public";

%javamethodmodifiers glp_set_col_kind(glp_prob *P, int j, int kind) "
/**
 * glp_set_col_kind - set (change) column kind .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_col_kind(glp_prob *mip, int j, int kind);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_col_kind sets (changes) the kind of j-th column (structural variable) as specified by the parameter kind:</p>
 * <p>GLP_CV - continuous variable; GLP_IV - integer variable; GLP_BV - binary variable. </p>
 */
public";

%javamethodmodifiers glp_get_col_kind(glp_prob *P, int j) "
/**
 * glp_get_col_kind - retrieve column kind .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_col_kind(glp_prob *mip, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_col_kind returns the kind of j-th column, i.e. the kind of corresponding structural variable, as follows:</p>
 * <p>GLP_CV - continuous variable; GLP_IV - integer variable; GLP_BV - binary variable </p>
 */
public";

%javamethodmodifiers glp_get_num_int(glp_prob *P) "
/**
 * glp_get_num_int - retrieve number of integer columns .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_num_int(glp_prob *mip);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_num_int returns the current number of columns, which are marked as integer. </p>
 */
public";

%javamethodmodifiers glp_get_num_bin(glp_prob *P) "
/**
 * glp_get_num_bin - retrieve number of binary columns .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_num_bin(glp_prob *mip);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_num_bin returns the current number of columns, which are marked as binary. </p>
 */
public";

%javamethodmodifiers glp_intopt(glp_prob *P, const glp_iocp *parm) "
/**
 */
public";

%javamethodmodifiers glp_init_iocp(glp_iocp *parm) "
/**
 * glp_init_iocp - initialize integer optimizer control parameters .
 * <p>SYNOPSIS</p>
 * <p>void glp_init_iocp(glp_iocp *parm);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_init_iocp initializes control parameters, which are used by the integer optimizer, with default values.</p>
 * <p>Default values of the control parameters are stored in a glp_iocp structure, which the parameter parm points to. </p>
 */
public";

%javamethodmodifiers glp_mip_status(glp_prob *P) "
/**
 * glp_mip_status - retrieve status of MIP solution .
 * <p>SYNOPSIS</p>
 * <p>int glp_mip_status(glp_prob *mip);</p>
 * <p>RETURNS</p>
 * <p>The routine lpx_mip_status reports the status of MIP solution found by the branch-and-bound solver as follows:</p>
 * <p>GLP_UNDEF - MIP solution is undefined; GLP_OPT - MIP solution is integer optimal; GLP_FEAS - MIP solution is integer feasible but its optimality (or non-optimality) has not been proven, perhaps due to premature termination of the search; GLP_NOFEAS - problem has no integer feasible solution (proven by the solver). </p>
 */
public";

%javamethodmodifiers glp_mip_obj_val(glp_prob *P) "
/**
 * glp_mip_obj_val - retrieve objective value (MIP solution) .
 * <p>SYNOPSIS</p>
 * <p>double glp_mip_obj_val(glp_prob *mip);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_mip_obj_val returns value of the objective function for MIP solution. </p>
 */
public";

%javamethodmodifiers glp_mip_row_val(glp_prob *P, int i) "
/**
 * glp_mip_row_val - retrieve row value (MIP solution) .
 * <p>SYNOPSIS</p>
 * <p>double glp_mip_row_val(glp_prob *mip, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_mip_row_val returns value of the auxiliary variable associated with i-th row. </p>
 */
public";

%javamethodmodifiers glp_mip_col_val(glp_prob *P, int j) "
/**
 * glp_mip_col_val - retrieve column value (MIP solution) .
 * <p>SYNOPSIS</p>
 * <p>double glp_mip_col_val(glp_prob *mip, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_mip_col_val returns value of the structural variable associated with j-th column. </p>
 */
public";

%javamethodmodifiers glp_check_kkt(glp_prob *P, int sol, int cond, double *ae_max, int *ae_ind, double *re_max, int *re_ind) "
/**
 */
public";

%javamethodmodifiers glp_print_sol(glp_prob *P, const char *fname) "
/**
 */
public";

%javamethodmodifiers glp_read_sol(glp_prob *P, const char *fname) "
/**
 * glp_read_sol - read basic solution from text file .
 * <p>SYNOPSIS</p>
 * <p>int glp_read_sol(glp_prob *lp, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_read_sol reads basic solution from a text file whose name is specified by the parameter fname into the problem object.</p>
 * <p>For the file format see description of the routine glp_write_sol.</p>
 * <p>RETURNS</p>
 * <p>On success the routine returns zero, otherwise non-zero. </p>
 */
public";

%javamethodmodifiers glp_write_sol(glp_prob *P, const char *fname) "
/**
 * glp_write_sol - write basic solution to text file .
 * <p>SYNOPSIS</p>
 * <p>int glp_write_sol(glp_prob *lp, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_write_sol writes the current basic solution to a text file whose name is specified by the parameter fname. This file can be read back with the routine glp_read_sol.</p>
 * <p>RETURNS</p>
 * <p>On success the routine returns zero, otherwise non-zero.</p>
 * <p>FILE FORMAT</p>
 * <p>The file created by the routine glp_write_sol is a plain text file, which contains the following information:</p>
 * <p>m n p_stat d_stat obj_val r_stat[1] r_prim[1] r_dual[1] . . . r_stat[m] r_prim[m] r_dual[m] c_stat[1] c_prim[1] c_dual[1] . . . c_stat[n] c_prim[n] c_dual[n]</p>
 * <p>where: m is the number of rows (auxiliary variables); n is the number of columns (structural variables); p_stat is the primal status of the basic solution (GLP_UNDEF = 1, GLP_FEAS = 2, GLP_INFEAS = 3, or GLP_NOFEAS = 4); d_stat is the dual status of the basic solution (GLP_UNDEF = 1, GLP_FEAS = 2, GLP_INFEAS = 3, or GLP_NOFEAS = 4); obj_val is the objective value; r_stat[i], i = 1,...,m, is the status of i-th row (GLP_BS = 1, GLP_NL = 2, GLP_NU = 3, GLP_NF = 4, or GLP_NS = 5); r_prim[i], i = 1,...,m, is the primal value of i-th row; r_dual[i], i = 1,...,m, is the dual value of i-th row; c_stat[j], j = 1,...,n, is the status of j-th column (GLP_BS = 1, GLP_NL = 2, GLP_NU = 3, GLP_NF = 4, or GLP_NS = 5); c_prim[j], j = 1,...,n, is the primal value of j-th column; c_dual[j], j = 1,...,n, is the dual value of j-th column. </p>
 */
public";

%javamethodmodifiers glp_print_ranges(glp_prob *P, int len, const int list[], int flags, const char *fname) "
/**
 */
public";

%javamethodmodifiers glp_print_ipt(glp_prob *P, const char *fname) "
/**
 */
public";

%javamethodmodifiers glp_read_ipt(glp_prob *P, const char *fname) "
/**
 * glp_read_ipt - read interior-point solution from text file .
 * <p>SYNOPSIS</p>
 * <p>int glp_read_ipt(glp_prob *lp, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_read_ipt reads interior-point solution from a text file whose name is specified by the parameter fname into the problem object.</p>
 * <p>For the file format see description of the routine glp_write_ipt.</p>
 * <p>RETURNS</p>
 * <p>On success the routine returns zero, otherwise non-zero. </p>
 */
public";

%javamethodmodifiers glp_write_ipt(glp_prob *P, const char *fname) "
/**
 * glp_write_ipt - write interior-point solution to text file .
 * <p>SYNOPSIS</p>
 * <p>int glp_write_ipt(glp_prob *lp, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_write_ipt writes the current interior-point solution to a text file whose name is specified by the parameter fname. This file can be read back with the routine glp_read_ipt.</p>
 * <p>RETURNS</p>
 * <p>On success the routine returns zero, otherwise non-zero.</p>
 * <p>FILE FORMAT</p>
 * <p>The file created by the routine glp_write_ipt is a plain text file, which contains the following information:</p>
 * <p>m n stat obj_val r_prim[1] r_dual[1] . . . r_prim[m] r_dual[m] c_prim[1] c_dual[1] . . . c_prim[n] c_dual[n]</p>
 * <p>where: m is the number of rows (auxiliary variables); n is the number of columns (structural variables); stat is the solution status (GLP_UNDEF = 1 or GLP_OPT = 5); obj_val is the objective value; r_prim[i], i = 1,...,m, is the primal value of i-th row; r_dual[i], i = 1,...,m, is the dual value of i-th row; c_prim[j], j = 1,...,n, is the primal value of j-th column; c_dual[j], j = 1,...,n, is the dual value of j-th column. </p>
 */
public";

%javamethodmodifiers glp_print_mip(glp_prob *P, const char *fname) "
/**
 */
public";

%javamethodmodifiers glp_read_mip(glp_prob *P, const char *fname) "
/**
 * glp_read_mip - read MIP solution from text file .
 * <p>SYNOPSIS</p>
 * <p>int glp_read_mip(glp_prob *mip, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_read_mip reads MIP solution from a text file whose name is specified by the parameter fname into the problem object.</p>
 * <p>For the file format see description of the routine glp_write_mip.</p>
 * <p>RETURNS</p>
 * <p>On success the routine returns zero, otherwise non-zero. </p>
 */
public";

%javamethodmodifiers glp_write_mip(glp_prob *P, const char *fname) "
/**
 * glp_write_mip - write MIP solution to text file .
 * <p>SYNOPSIS</p>
 * <p>int glp_write_mip(glp_prob *mip, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_write_mip writes the current MIP solution to a text file whose name is specified by the parameter fname. This file can be read back with the routine glp_read_mip.</p>
 * <p>RETURNS</p>
 * <p>On success the routine returns zero, otherwise non-zero.</p>
 * <p>FILE FORMAT</p>
 * <p>The file created by the routine glp_write_sol is a plain text file, which contains the following information:</p>
 * <p>m n stat obj_val r_val[1] . . . r_val[m] c_val[1] . . . c_val[n]</p>
 * <p>where: m is the number of rows (auxiliary variables); n is the number of columns (structural variables); stat is the solution status (GLP_UNDEF = 1, GLP_FEAS = 2, GLP_NOFEAS = 4, or GLP_OPT = 5); obj_val is the objective value; r_val[i], i = 1,...,m, is the value of i-th row; c_val[j], j = 1,...,n, is the value of j-th column. </p>
 */
public";

%javamethodmodifiers glp_bf_exists(glp_prob *P) "
/**
 * glp_bf_exists - check if the basis factorization exists .
 * <p>SYNOPSIS</p>
 * <p>int glp_bf_exists(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>If the basis factorization for the current basis associated with the specified problem object exists and therefore is available for computations, the routine glp_bf_exists returns non-zero. Otherwise the routine returns zero. </p>
 */
public";

%javamethodmodifiers glp_factorize(glp_prob *P) "
/**
 */
public";

%javamethodmodifiers glp_bf_updated(glp_prob *P) "
/**
 * glp_bf_updated - check if the basis factorization has been updated .
 * <p>SYNOPSIS</p>
 * <p>int glp_bf_updated(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>If the basis factorization has been just computed from scratch, the routine glp_bf_updated returns zero. Otherwise, if the factorization has been updated one or more times, the routine returns non-zero. </p>
 */
public";

%javamethodmodifiers glp_get_bfcp(glp_prob *P, glp_bfcp *parm) "
/**
 * glp_get_bfcp - retrieve basis factorization control parameters .
 * <p>SYNOPSIS</p>
 * <p>void glp_get_bfcp(glp_prob *lp, glp_bfcp *parm);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_get_bfcp retrieves control parameters, which are used on computing and updating the basis factorization associated with the specified problem object.</p>
 * <p>Current values of control parameters are stored by the routine in a glp_bfcp structure, which the parameter parm points to. </p>
 */
public";

%javamethodmodifiers glp_set_bfcp(glp_prob *P, const glp_bfcp *parm) "
/**
 */
public";

%javamethodmodifiers glp_get_bhead(glp_prob *P, int k) "
/**
 * glp_get_bhead - retrieve the basis header information .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_bhead(glp_prob *lp, int k);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_get_bhead returns the basis header information for the current basis associated with the specified problem object.</p>
 * <p>RETURNS</p>
 * <p>If xB[k], 1 <= k <= m, is i-th auxiliary variable (1 <= i <= m), the routine returns i. Otherwise, if xB[k] is j-th structural variable (1 <= j <= n), the routine returns m+j. Here m is the number of rows and n is the number of columns in the problem object. </p>
 */
public";

%javamethodmodifiers glp_get_row_bind(glp_prob *P, int i) "
/**
 * glp_get_row_bind - retrieve row index in the basis header .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_row_bind(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_row_bind returns the index k of basic variable xB[k], 1 <= k <= m, which is i-th auxiliary variable, 1 <= i <= m, in the current basis associated with the specified problem object, where m is the number of rows. However, if i-th auxiliary variable is non-basic, the routine returns zero. </p>
 */
public";

%javamethodmodifiers glp_get_col_bind(glp_prob *P, int j) "
/**
 * glp_get_col_bind - retrieve column index in the basis header .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_col_bind(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_col_bind returns the index k of basic variable xB[k], 1 <= k <= m, which is j-th structural variable, 1 <= j <= n, in the current basis associated with the specified problem object, where m is the number of rows, n is the number of columns. However, if j-th structural variable is non-basic, the routine returns zero. </p>
 */
public";

%javamethodmodifiers glp_ftran(glp_prob *P, double x[]) "
/**
 * glp_ftran - perform forward transformation (solve system B*x = b) .
 * <p>SYNOPSIS</p>
 * <p>void glp_ftran(glp_prob *lp, double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_ftran performs forward transformation, i.e. solves the system B*x = b, where B is the basis matrix corresponding to the current basis for the specified problem object, x is the vector of unknowns to be computed, b is the vector of right-hand sides.</p>
 * <p>On entry elements of the vector b should be stored in dense format in locations x[1], ..., x[m], where m is the number of rows. On exit the routine stores elements of the vector x in the same locations.</p>
 * <p>SCALING/UNSCALING</p>
 * <p>Let A~ = (I | -A) is the augmented constraint matrix of the original (unscaled) problem. In the scaled LP problem instead the matrix A the scaled matrix A\" = R*A*S is actually used, so</p>
 * <p>A~\" = (I | A\") = (I | R*A*S) = (R*I*inv(R) | R*A*S) = (1) = R*(I | A)*S~ = R*A~*S~,</p>
 * <p>is the scaled augmented constraint matrix, where R and S are diagonal scaling matrices used to scale rows and columns of the matrix A, and</p>
 * <p>S~ = diag(inv(R) | S) (2)</p>
 * <p>is an augmented diagonal scaling matrix.</p>
 * <p>By definition:</p>
 * <p>A~ = (B | N), (3)</p>
 * <p>where B is the basic matrix, which consists of basic columns of the augmented constraint matrix A~, and N is a matrix, which consists of non-basic columns of A~. From (1) it follows that:</p>
 * <p>A~\" = (B\" | N\") = (R*B*SB | R*N*SN), (4)</p>
 * <p>where SB and SN are parts of the augmented scaling matrix S~, which correspond to basic and non-basic variables, respectively. Therefore</p>
 * <p>B\" = R*B*SB, (5)</p>
 * <p>which is the scaled basis matrix. </p>
 */
public";

%javamethodmodifiers glp_btran(glp_prob *P, double x[]) "
/**
 * glp_btran - perform backward transformation (solve system B'*x = b) .
 * <p>SYNOPSIS</p>
 * <p>void glp_btran(glp_prob *lp, double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_btran performs backward transformation, i.e. solves the system B'*x = b, where B' is a matrix transposed to the basis matrix corresponding to the current basis for the specified problem problem object, x is the vector of unknowns to be computed, b is the vector of right-hand sides.</p>
 * <p>On entry elements of the vector b should be stored in dense format in locations x[1], ..., x[m], where m is the number of rows. On exit the routine stores elements of the vector x in the same locations.</p>
 * <p>SCALING/UNSCALING</p>
 * <p>See comments to the routine glp_ftran. </p>
 */
public";

%javamethodmodifiers glp_warm_up(glp_prob *P) "
/**
 * glp_warm_up - \"warm up\" LP basis .
 * <p>SYNOPSIS</p>
 * <p>int glp_warm_up(glp_prob *P);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_warm_up \"warms up\" the LP basis for the specified problem object using current statuses assigned to rows and columns (that is, to auxiliary and structural variables).</p>
 * <p>This operation includes computing factorization of the basis matrix (if it does not exist), computing primal and dual components of basic solution, and determining the solution status.</p>
 * <p>RETURNS</p>
 * <p>0 The operation has been successfully performed.</p>
 * <p>GLP_EBADB The basis matrix is invalid, i.e. the number of basic (auxiliary and structural) variables differs from the number of rows in the problem object.</p>
 * <p>GLP_ESING The basis matrix is singular within the working precision.</p>
 * <p>GLP_ECOND The basis matrix is ill-conditioned. </p>
 */
public";

%javamethodmodifiers glp_eval_tab_row(glp_prob *P, int k, int ind[], double val[]) "
/**
 * glp_eval_tab_row - compute row of the simplex tableau .
 * <p>SYNOPSIS</p>
 * <p>int glp_eval_tab_row(glp_prob *lp, int k, int ind[], double val[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_eval_tab_row computes a row of the current simplex tableau for the basic variable, which is specified by the number k: if 1 <= k <= m, x[k] is k-th auxiliary variable; if m+1 <= k <= m+n, x[k] is (k-m)-th structural variable, where m is number of rows, and n is number of columns. The current basis must be available.</p>
 * <p>The routine stores column indices and numerical values of non-zero elements of the computed row using sparse format to the locations ind[1], ..., ind[len] and val[1], ..., val[len], respectively, where 0 <= len <= n is number of non-zeros returned on exit.</p>
 * <p>Element indices stored in the array ind have the same sense as the index k, i.e. indices 1 to m denote auxiliary variables and indices m+1 to m+n denote structural ones (all these variables are obviously non-basic by definition).</p>
 * <p>The computed row shows how the specified basic variable x[k] = xB[i] depends on non-basic variables:</p>
 * <p>xB[i] = alfa[i,1]*xN[1] + alfa[i,2]*xN[2] + ... + alfa[i,n]*xN[n],</p>
 * <p>where alfa[i,j] are elements of the simplex table row, xN[j] are non-basic (auxiliary and structural) variables.</p>
 * <p>RETURNS</p>
 * <p>The routine returns number of non-zero elements in the simplex table row stored in the arrays ind and val.</p>
 * <p>BACKGROUND</p>
 * <p>The system of equality constraints of the LP problem is:</p>
 * <p>xR = A * xS, (1)</p>
 * <p>where xR is the vector of auxliary variables, xS is the vector of structural variables, A is the matrix of constraint coefficients.</p>
 * <p>The system (1) can be written in homogenous form as follows:</p>
 * <p>A~ * x = 0, (2)</p>
 * <p>where A~ = (I | -A) is the augmented constraint matrix (has m rows and m+n columns), x = (xR | xS) is the vector of all (auxiliary and structural) variables.</p>
 * <p>By definition for the current basis we have:</p>
 * <p>A~ = (B | N), (3)</p>
 * <p>where B is the basis matrix. Thus, the system (2) can be written as:</p>
 * <p>B * xB + N * xN = 0. (4)</p>
 * <p>From (4) it follows that:</p>
 * <p>xB = A^ * xN, (5)</p>
 * <p>where the matrix</p>
 * <p>A^ = - inv(B) * N (6)</p>
 * <p>is called the simplex table.</p>
 * <p>It is understood that i-th row of the simplex table is:</p>
 * <p>e * A^ = - e * inv(B) * N, (7)</p>
 * <p>where e is a unity vector with e[i] = 1.</p>
 * <p>To compute i-th row of the simplex table the routine first computes i-th row of the inverse:</p>
 * <p>rho = inv(B') * e, (8)</p>
 * <p>where B' is a matrix transposed to B, and then computes elements of i-th row of the simplex table as scalar products:</p>
 * <p>alfa[i,j] = - rho * N[j] for all j, (9)</p>
 * <p>where N[j] is a column of the augmented constraint matrix A~, which corresponds to some non-basic auxiliary or structural variable. </p>
 */
public";

%javamethodmodifiers glp_eval_tab_col(glp_prob *P, int k, int ind[], double val[]) "
/**
 * glp_eval_tab_col - compute column of the simplex tableau .
 * <p>SYNOPSIS</p>
 * <p>int glp_eval_tab_col(glp_prob *lp, int k, int ind[], double val[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_eval_tab_col computes a column of the current simplex table for the non-basic variable, which is specified by the number k: if 1 <= k <= m, x[k] is k-th auxiliary variable; if m+1 <= k <= m+n, x[k] is (k-m)-th structural variable, where m is number of rows, and n is number of columns. The current basis must be available.</p>
 * <p>The routine stores row indices and numerical values of non-zero elements of the computed column using sparse format to the locations ind[1], ..., ind[len] and val[1], ..., val[len] respectively, where 0 <= len <= m is number of non-zeros returned on exit.</p>
 * <p>Element indices stored in the array ind have the same sense as the index k, i.e. indices 1 to m denote auxiliary variables and indices m+1 to m+n denote structural ones (all these variables are obviously basic by the definition).</p>
 * <p>The computed column shows how basic variables depend on the specified non-basic variable x[k] = xN[j]:</p>
 * <p>xB[1] = ... + alfa[1,j]*xN[j] + ... xB[2] = ... + alfa[2,j]*xN[j] + ... . . . . . . xB[m] = ... + alfa[m,j]*xN[j] + ...</p>
 * <p>where alfa[i,j] are elements of the simplex table column, xB[i] are basic (auxiliary and structural) variables.</p>
 * <p>RETURNS</p>
 * <p>The routine returns number of non-zero elements in the simplex table column stored in the arrays ind and val.</p>
 * <p>BACKGROUND</p>
 * <p>As it was explained in comments to the routine glp_eval_tab_row (see above) the simplex table is the following matrix:</p>
 * <p>A^ = - inv(B) * N. (1)</p>
 * <p>Therefore j-th column of the simplex table is:</p>
 * <p>A^ * e = - inv(B) * N * e = - inv(B) * N[j], (2)</p>
 * <p>where e is a unity vector with e[j] = 1, B is the basis matrix, N[j] is a column of the augmented constraint matrix A~, which corresponds to the given non-basic auxiliary or structural variable. </p>
 */
public";

%javamethodmodifiers glp_transform_row(glp_prob *P, int len, int ind[], double val[]) "
/**
 * glp_transform_row - transform explicitly specified row .
 * <p>SYNOPSIS</p>
 * <p>int glp_transform_row(glp_prob *P, int len, int ind[], double val[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_transform_row performs the same operation as the routine glp_eval_tab_row with exception that the row to be transformed is specified explicitly as a sparse vector.</p>
 * <p>The explicitly specified row may be thought as a linear form:</p>
 * <p>x = a[1]*x[m+1] + a[2]*x[m+2] + ... + a[n]*x[m+n], (1)</p>
 * <p>where x is an auxiliary variable for this row, a[j] are coefficients of the linear form, x[m+j] are structural variables.</p>
 * <p>On entry column indices and numerical values of non-zero elements of the row should be stored in locations ind[1], ..., ind[len] and val[1], ..., val[len], where len is the number of non-zero elements.</p>
 * <p>This routine uses the system of equality constraints and the current basis in order to express the auxiliary variable x in (1) through the current non-basic variables (as if the transformed row were added to the problem object and its auxiliary variable were basic), i.e. the resultant row has the form:</p>
 * <p>x = alfa[1]*xN[1] + alfa[2]*xN[2] + ... + alfa[n]*xN[n], (2)</p>
 * <p>where xN[j] are non-basic (auxiliary or structural) variables, n is the number of columns in the LP problem object.</p>
 * <p>On exit the routine stores indices and numerical values of non-zero elements of the resultant row (2) in locations ind[1], ..., ind[len'] and val[1], ..., val[len'], where 0 <= len' <= n is the number of non-zero elements in the resultant row returned by the routine. Note that indices (numbers) of non-basic variables stored in the array ind correspond to original ordinal numbers of variables: indices 1 to m mean auxiliary variables and indices m+1 to m+n mean structural ones.</p>
 * <p>RETURNS</p>
 * <p>The routine returns len', which is the number of non-zero elements in the resultant row stored in the arrays ind and val.</p>
 * <p>BACKGROUND</p>
 * <p>The explicitly specified row (1) is transformed in the same way as it were the objective function row.</p>
 * <p>From (1) it follows that:</p>
 * <p>x = aB * xB + aN * xN, (3)</p>
 * <p>where xB is the vector of basic variables, xN is the vector of non-basic variables.</p>
 * <p>The simplex table, which corresponds to the current basis, is:</p>
 * <p>xB = [-inv(B) * N] * xN. (4)</p>
 * <p>Therefore substituting xB from (4) to (3) we have:</p>
 * <p>x = aB * [-inv(B) * N] * xN + aN * xN = (5) = rho * (-N) * xN + aN * xN = alfa * xN,</p>
 * <p>where:</p>
 * <p>rho = inv(B') * aB, (6)</p>
 * <p>and</p>
 * <p>alfa = aN + rho * (-N) (7)</p>
 * <p>is the resultant row computed by the routine. </p>
 */
public";

%javamethodmodifiers glp_transform_col(glp_prob *P, int len, int ind[], double val[]) "
/**
 * glp_transform_col - transform explicitly specified column .
 * <p>SYNOPSIS</p>
 * <p>int glp_transform_col(glp_prob *P, int len, int ind[], double val[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_transform_col performs the same operation as the routine glp_eval_tab_col with exception that the column to be transformed is specified explicitly as a sparse vector.</p>
 * <p>The explicitly specified column may be thought as if it were added to the original system of equality constraints:</p>
 * <p>x[1] = a[1,1]*x[m+1] + ... + a[1,n]*x[m+n] + a[1]*x x[2] = a[2,1]*x[m+1] + ... + a[2,n]*x[m+n] + a[2]*x (1) . . . . . . . . . . . . . . . x[m] = a[m,1]*x[m+1] + ... + a[m,n]*x[m+n] + a[m]*x</p>
 * <p>where x[i] are auxiliary variables, x[m+j] are structural variables, x is a structural variable for the explicitly specified column, a[i] are constraint coefficients for x.</p>
 * <p>On entry row indices and numerical values of non-zero elements of the column should be stored in locations ind[1], ..., ind[len] and val[1], ..., val[len], where len is the number of non-zero elements.</p>
 * <p>This routine uses the system of equality constraints and the current basis in order to express the current basic variables through the structural variable x in (1) (as if the transformed column were added to the problem object and the variable x were non-basic), i.e. the resultant column has the form:</p>
 * <p>xB[1] = ... + alfa[1]*x xB[2] = ... + alfa[2]*x (2) . . . . . . xB[m] = ... + alfa[m]*x</p>
 * <p>where xB are basic (auxiliary and structural) variables, m is the number of rows in the problem object.</p>
 * <p>On exit the routine stores indices and numerical values of non-zero elements of the resultant column (2) in locations ind[1], ..., ind[len'] and val[1], ..., val[len'], where 0 <= len' <= m is the number of non-zero element in the resultant column returned by the routine. Note that indices (numbers) of basic variables stored in the array ind correspond to original ordinal numbers of variables: indices 1 to m mean auxiliary variables and indices m+1 to m+n mean structural ones.</p>
 * <p>RETURNS</p>
 * <p>The routine returns len', which is the number of non-zero elements in the resultant column stored in the arrays ind and val.</p>
 * <p>BACKGROUND</p>
 * <p>The explicitly specified column (1) is transformed in the same way as any other column of the constraint matrix using the formula:</p>
 * <p>alfa = inv(B) * a, (3)</p>
 * <p>where alfa is the resultant column computed by the routine. </p>
 */
public";

%javamethodmodifiers glp_prim_rtest(glp_prob *P, int len, const int ind[], const double val[], int dir, double eps) "
/**
 * glp_prim_rtest - perform primal ratio test .
 * <p>SYNOPSIS</p>
 * <p>int glp_prim_rtest(glp_prob *P, int len, const int ind[], const double val[], int dir, double eps);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_prim_rtest performs the primal ratio test using an explicitly specified column of the simplex table.</p>
 * <p>The current basic solution associated with the LP problem object must be primal feasible.</p>
 * <p>The explicitly specified column of the simplex table shows how the basic variables xB depend on some non-basic variable x (which is not necessarily presented in the problem object):</p>
 * <p>xB[1] = ... + alfa[1] * x + ... xB[2] = ... + alfa[2] * x + ... (*) . . . . . . . . xB[m] = ... + alfa[m] * x + ...</p>
 * <p>The column (*) is specifed on entry to the routine using the sparse format. Ordinal numbers of basic variables xB[i] should be placed in locations ind[1], ..., ind[len], where ordinal number 1 to m denote auxiliary variables, and ordinal numbers m+1 to m+n denote structural variables. The corresponding non-zero coefficients alfa[i] should be placed in locations val[1], ..., val[len]. The arrays ind and val are not changed on exit.</p>
 * <p>The parameter dir specifies direction in which the variable x changes on entering the basis: +1 means increasing, -1 means decreasing.</p>
 * <p>The parameter eps is an absolute tolerance (small positive number) used by the routine to skip small alfa[j] of the row (*).</p>
 * <p>The routine determines which basic variable (among specified in ind[1], ..., ind[len]) should leave the basis in order to keep primal feasibility.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_prim_rtest returns the index piv in the arrays ind and val corresponding to the pivot element chosen, 1 <= piv <= len. If the adjacent basic solution is primal unbounded and therefore the choice cannot be made, the routine returns zero.</p>
 * <p>COMMENTS</p>
 * <p>If the non-basic variable x is presented in the LP problem object, the column (*) can be computed with the routine glp_eval_tab_col; otherwise it can be computed with the routine glp_transform_col. </p>
 */
public";

%javamethodmodifiers glp_dual_rtest(glp_prob *P, int len, const int ind[], const double val[], int dir, double eps) "
/**
 * glp_dual_rtest - perform dual ratio test .
 * <p>SYNOPSIS</p>
 * <p>int glp_dual_rtest(glp_prob *P, int len, const int ind[], const double val[], int dir, double eps);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_dual_rtest performs the dual ratio test using an explicitly specified row of the simplex table.</p>
 * <p>The current basic solution associated with the LP problem object must be dual feasible.</p>
 * <p>The explicitly specified row of the simplex table is a linear form that shows how some basic variable x (which is not necessarily presented in the problem object) depends on non-basic variables xN:</p>
 * <p>x = alfa[1] * xN[1] + alfa[2] * xN[2] + ... + alfa[n] * xN[n]. (*)</p>
 * <p>The row (*) is specified on entry to the routine using the sparse format. Ordinal numbers of non-basic variables xN[j] should be placed in locations ind[1], ..., ind[len], where ordinal numbers 1 to m denote auxiliary variables, and ordinal numbers m+1 to m+n denote structural variables. The corresponding non-zero coefficients alfa[j] should be placed in locations val[1], ..., val[len]. The arrays ind and val are not changed on exit.</p>
 * <p>The parameter dir specifies direction in which the variable x changes on leaving the basis: +1 means that x goes to its lower bound, and -1 means that x goes to its upper bound.</p>
 * <p>The parameter eps is an absolute tolerance (small positive number) used by the routine to skip small alfa[j] of the row (*).</p>
 * <p>The routine determines which non-basic variable (among specified in ind[1], ..., ind[len]) should enter the basis in order to keep dual feasibility.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_dual_rtest returns the index piv in the arrays ind and val corresponding to the pivot element chosen, 1 <= piv <= len. If the adjacent basic solution is dual unbounded and therefore the choice cannot be made, the routine returns zero.</p>
 * <p>COMMENTS</p>
 * <p>If the basic variable x is presented in the LP problem object, the row (*) can be computed with the routine glp_eval_tab_row; otherwise it can be computed with the routine glp_transform_row. </p>
 */
public";

%javamethodmodifiers glp_analyze_bound(glp_prob *P, int k, double *value1, int *var1, double *value2, int *var2) "
/**
 * glp_analyze_bound - analyze active bound of non-basic variable .
 * <p>SYNOPSIS</p>
 * <p>void glp_analyze_bound(glp_prob *P, int k, double *limit1, int *var1, double *limit2, int *var2);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_analyze_bound analyzes the effect of varying the active bound of specified non-basic variable.</p>
 * <p>The non-basic variable is specified by the parameter k, where 1 <= k <= m means auxiliary variable of corresponding row while m+1 <= k <= m+n means structural variable (column).</p>
 * <p>Note that the current basic solution must be optimal, and the basis factorization must exist.</p>
 * <p>Results of the analysis have the following meaning.</p>
 * <p>value1 is the minimal value of the active bound, at which the basis still remains primal feasible and thus optimal. -DBL_MAX means that the active bound has no lower limit.</p>
 * <p>var1 is the ordinal number of an auxiliary (1 to m) or structural (m+1 to n) basic variable, which reaches its bound first and thereby limits further decreasing the active bound being analyzed. if value1 = -DBL_MAX, var1 is set to 0.</p>
 * <p>value2 is the maximal value of the active bound, at which the basis still remains primal feasible and thus optimal. +DBL_MAX means that the active bound has no upper limit.</p>
 * <p>var2 is the ordinal number of an auxiliary (1 to m) or structural (m+1 to n) basic variable, which reaches its bound first and thereby limits further increasing the active bound being analyzed. if value2 = +DBL_MAX, var2 is set to 0. </p>
 */
public";

%javamethodmodifiers glp_analyze_coef(glp_prob *P, int k, double *coef1, int *var1, double *value1, double *coef2, int *var2, double *value2) "
/**
 * glp_analyze_coef - analyze objective coefficient at basic variable .
 * <p>SYNOPSIS</p>
 * <p>void glp_analyze_coef(glp_prob *P, int k, double *coef1, int *var1, double *value1, double *coef2, int *var2, double *value2);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_analyze_coef analyzes the effect of varying the objective coefficient at specified basic variable.</p>
 * <p>The basic variable is specified by the parameter k, where 1 <= k <= m means auxiliary variable of corresponding row while m+1 <= k <= m+n means structural variable (column).</p>
 * <p>Note that the current basic solution must be optimal, and the basis factorization must exist.</p>
 * <p>Results of the analysis have the following meaning.</p>
 * <p>coef1 is the minimal value of the objective coefficient, at which the basis still remains dual feasible and thus optimal. -DBL_MAX means that the objective coefficient has no lower limit.</p>
 * <p>var1 is the ordinal number of an auxiliary (1 to m) or structural (m+1 to n) non-basic variable, whose reduced cost reaches its zero bound first and thereby limits further decreasing the objective coefficient being analyzed. If coef1 = -DBL_MAX, var1 is set to 0.</p>
 * <p>value1 is value of the basic variable being analyzed in an adjacent basis, which is defined as follows. Let the objective coefficient reaches its minimal value (coef1) and continues decreasing. Then the reduced cost of the limiting non-basic variable (var1) becomes dual infeasible and the current basis becomes non-optimal that forces the limiting non-basic variable to enter the basis replacing there some basic variable that leaves the basis to keep primal feasibility. Should note that on determining the adjacent basis current bounds of the basic variable being analyzed are ignored as if it were free (unbounded) variable, so it cannot leave the basis. It may happen that no dual feasible adjacent basis exists, in which case value1 is set to -DBL_MAX or +DBL_MAX.</p>
 * <p>coef2 is the maximal value of the objective coefficient, at which the basis still remains dual feasible and thus optimal. +DBL_MAX means that the objective coefficient has no upper limit.</p>
 * <p>var2 is the ordinal number of an auxiliary (1 to m) or structural (m+1 to n) non-basic variable, whose reduced cost reaches its zero bound first and thereby limits further increasing the objective coefficient being analyzed. If coef2 = +DBL_MAX, var2 is set to 0.</p>
 * <p>value2 is value of the basic variable being analyzed in an adjacent basis, which is defined exactly in the same way as value1 above with exception that now the objective coefficient is increasing. </p>
 */
public";

%javamethodmodifiers glp_ios_reason(glp_tree *T) "
/**
 * glp_ios_reason - determine reason for calling the callback routine .
 * <p>SYNOPSIS</p>
 * <p>glp_ios_reason(glp_tree *tree);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ios_reason returns a code, which indicates why the user-defined callback routine is being called. </p>
 */
public";

%javamethodmodifiers glp_ios_get_prob(glp_tree *T) "
/**
 * glp_ios_get_prob - access the problem object .
 * <p>SYNOPSIS</p>
 * <p>glp_prob *glp_ios_get_prob(glp_tree *tree);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_ios_get_prob can be called from the user-defined callback routine to access the problem object, which is used by the MIP solver. It is the original problem object passed to the routine glp_intopt if the MIP presolver is not used; otherwise it is an internal problem object built by the presolver. If the current subproblem exists, LP segment of the problem object corresponds to its LP relaxation.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ios_get_prob returns a pointer to the problem object used by the MIP solver. </p>
 */
public";

%javamethodmodifiers glp_ios_tree_size(glp_tree *T, int *a_cnt, int *n_cnt, int *t_cnt) "
/**
 * glp_ios_tree_size - determine size of the branch-and-bound tree .
 * <p>SYNOPSIS</p>
 * <p>void glp_ios_tree_size(glp_tree *tree, int *a_cnt, int *n_cnt, int *t_cnt);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_ios_tree_size stores the following three counts which characterize the current size of the branch-and-bound tree:</p>
 * <p>a_cnt is the current number of active nodes, i.e. the current size of the active list;</p>
 * <p>n_cnt is the current number of all (active and inactive) nodes;</p>
 * <p>t_cnt is the total number of nodes including those which have been already removed from the tree. This count is increased whenever a new node appears in the tree and never decreased.</p>
 * <p>If some of the parameters a_cnt, n_cnt, t_cnt is a null pointer, the corresponding count is not stored. </p>
 */
public";

%javamethodmodifiers glp_ios_curr_node(glp_tree *T) "
/**
 * glp_ios_curr_node - determine current active subproblem .
 * <p>SYNOPSIS</p>
 * <p>int glp_ios_curr_node(glp_tree *tree);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ios_curr_node returns the reference number of the current active subproblem. However, if the current subproblem does not exist, the routine returns zero. </p>
 */
public";

%javamethodmodifiers glp_ios_next_node(glp_tree *T, int p) "
/**
 * glp_ios_next_node - determine next active subproblem .
 * <p>SYNOPSIS</p>
 * <p>int glp_ios_next_node(glp_tree *tree, int p);</p>
 * <p>RETURNS</p>
 * <p>If the parameter p is zero, the routine glp_ios_next_node returns the reference number of the first active subproblem. However, if the tree is empty, zero is returned.</p>
 * <p>If the parameter p is not zero, it must specify the reference number of some active subproblem, in which case the routine returns the reference number of the next active subproblem. However, if there is no next active subproblem in the list, zero is returned.</p>
 * <p>All subproblems in the active list are ordered chronologically, i.e. subproblem A precedes subproblem B if A was created before B. </p>
 */
public";

%javamethodmodifiers glp_ios_prev_node(glp_tree *T, int p) "
/**
 * glp_ios_prev_node - determine previous active subproblem .
 * <p>SYNOPSIS</p>
 * <p>int glp_ios_prev_node(glp_tree *tree, int p);</p>
 * <p>RETURNS</p>
 * <p>If the parameter p is zero, the routine glp_ios_prev_node returns the reference number of the last active subproblem. However, if the tree is empty, zero is returned.</p>
 * <p>If the parameter p is not zero, it must specify the reference number of some active subproblem, in which case the routine returns the reference number of the previous active subproblem. However, if there is no previous active subproblem in the list, zero is returned.</p>
 * <p>All subproblems in the active list are ordered chronologically, i.e. subproblem A precedes subproblem B if A was created before B. </p>
 */
public";

%javamethodmodifiers glp_ios_up_node(glp_tree *T, int p) "
/**
 * glp_ios_up_node - determine parent subproblem .
 * <p>SYNOPSIS</p>
 * <p>int glp_ios_up_node(glp_tree *tree, int p);</p>
 * <p>RETURNS</p>
 * <p>The parameter p must specify the reference number of some (active or inactive) subproblem, in which case the routine iet_get_up_node returns the reference number of its parent subproblem. However, if the specified subproblem is the root of the tree and, therefore, has no parent, the routine returns zero. </p>
 */
public";

%javamethodmodifiers glp_ios_node_level(glp_tree *T, int p) "
/**
 * glp_ios_node_level - determine subproblem level .
 * <p>SYNOPSIS</p>
 * <p>int glp_ios_node_level(glp_tree *tree, int p);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ios_node_level returns the level of the subproblem, whose reference number is p, in the branch-and-bound tree. (The root subproblem has level 0, and the level of any other subproblem is the level of its parent plus one.) </p>
 */
public";

%javamethodmodifiers glp_ios_node_bound(glp_tree *T, int p) "
/**
 * glp_ios_node_bound - determine subproblem local bound .
 * <p>SYNOPSIS</p>
 * <p>double glp_ios_node_bound(glp_tree *tree, int p);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ios_node_bound returns the local bound for (active or inactive) subproblem, whose reference number is p.</p>
 * <p>COMMENTS</p>
 * <p>The local bound for subproblem p is an lower (minimization) or upper (maximization) bound for integer optimal solution to this subproblem (not to the original problem). This bound is local in the sense that only subproblems in the subtree rooted at node p cannot have better integer feasible solutions.</p>
 * <p>On creating a subproblem (due to the branching step) its local bound is inherited from its parent and then may get only stronger (never weaker). For the root subproblem its local bound is initially set to -DBL_MAX (minimization) or +DBL_MAX (maximization) and then improved as the root LP relaxation has been solved.</p>
 * <p>Note that the local bound is not necessarily the optimal objective value to corresponding LP relaxation; it may be stronger. </p>
 */
public";

%javamethodmodifiers glp_ios_best_node(glp_tree *T) "
/**
 * glp_ios_best_node - find active subproblem with best local bound .
 * <p>SYNOPSIS</p>
 * <p>int glp_ios_best_node(glp_tree *tree);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ios_best_node returns the reference number of the active subproblem, whose local bound is best (i.e. smallest in case of minimization or largest in case of maximization). However, if the tree is empty, the routine returns zero.</p>
 * <p>COMMENTS</p>
 * <p>The best local bound is an lower (minimization) or upper (maximization) bound for integer optimal solution to the original MIP problem. </p>
 */
public";

%javamethodmodifiers glp_ios_mip_gap(glp_tree *T) "
/**
 * glp_ios_mip_gap - compute relative MIP gap .
 * <p>SYNOPSIS</p>
 * <p>double glp_ios_mip_gap(glp_tree *tree);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_ios_mip_gap computes the relative MIP gap with the following formula:</p>
 * <p>gap = |best_mip - best_bnd| / (|best_mip| + DBL_EPSILON),</p>
 * <p>where best_mip is the best integer feasible solution found so far, best_bnd is the best (global) bound. If no integer feasible solution has been found yet, gap is set to DBL_MAX.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ios_mip_gap returns the relative MIP gap. </p>
 */
public";

%javamethodmodifiers glp_ios_node_data(glp_tree *T, int p) "
/**
 * glp_ios_node_data - access subproblem application-specific data .
 * <p>SYNOPSIS</p>
 * <p>void *glp_ios_node_data(glp_tree *tree, int p);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_ios_node_data allows the application accessing a memory block allocated for the subproblem (which may be active or inactive), whose reference number is p.</p>
 * <p>The size of the block is defined by the control parameter cb_size passed to the routine glp_intopt. The block is initialized by binary zeros on creating corresponding subproblem, and its contents is kept until the subproblem will be removed from the tree.</p>
 * <p>The application may use these memory blocks to store specific data for each subproblem.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ios_node_data returns a pointer to the memory block for the specified subproblem. Note that if cb_size = 0, the routine returns a null pointer. </p>
 */
public";

%javamethodmodifiers glp_ios_row_attr(glp_tree *T, int i, glp_attr *attr) "
/**
 * glp_ios_row_attr - retrieve additional row attributes .
 * <p>SYNOPSIS</p>
 * <p>void glp_ios_row_attr(glp_tree *tree, int i, glp_attr *attr);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_ios_row_attr retrieves additional attributes of row i and stores them in the structure glp_attr. </p>
 */
public";

%javamethodmodifiers glp_ios_pool_size(glp_tree *T) "
/**
 */
public";

%javamethodmodifiers glp_ios_add_row(glp_tree *T, const char *name, int klass, int flags, int len, const int ind[], const double val[], int type, double rhs) "
/**
 */
public";

%javamethodmodifiers glp_ios_del_row(glp_tree *T, int i) "
/**
 */
public";

%javamethodmodifiers glp_ios_clear_pool(glp_tree *T) "
/**
 */
public";

%javamethodmodifiers glp_ios_can_branch(glp_tree *T, int j) "
/**
 * glp_ios_can_branch - check if can branch upon specified variable .
 * <p>SYNOPSIS</p>
 * <p>int glp_ios_can_branch(glp_tree *tree, int j);</p>
 * <p>RETURNS</p>
 * <p>If j-th variable (column) can be used to branch upon, the routine glp_ios_can_branch returns non-zero, otherwise zero. </p>
 */
public";

%javamethodmodifiers glp_ios_branch_upon(glp_tree *T, int j, int sel) "
/**
 * glp_ios_branch_upon - choose variable to branch upon .
 * <p>SYNOPSIS</p>
 * <p>void glp_ios_branch_upon(glp_tree *tree, int j, int sel);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_ios_branch_upon can be called from the user-defined callback routine in response to the reason GLP_IBRANCH to choose a branching variable, whose ordinal number is j. Should note that only variables, for which the routine glp_ios_can_branch returns non-zero, can be used to branch upon.</p>
 * <p>The parameter sel is a flag that indicates which branch (subproblem) should be selected next to continue the search:</p>
 * <p>GLP_DN_BRNCH - select down-branch; GLP_UP_BRNCH - select up-branch; GLP_NO_BRNCH - use general selection technique. </p>
 */
public";

%javamethodmodifiers glp_ios_select_node(glp_tree *T, int p) "
/**
 * glp_ios_select_node - select subproblem to continue the search .
 * <p>SYNOPSIS</p>
 * <p>void glp_ios_select_node(glp_tree *tree, int p);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_ios_select_node can be called from the user-defined callback routine in response to the reason GLP_ISELECT to select an active subproblem, whose reference number is p. The search will be continued from the subproblem selected. </p>
 */
public";

%javamethodmodifiers glp_ios_heur_sol(glp_tree *T, const double x[]) "
/**
 * glp_ios_heur_sol - provide solution found by heuristic .
 * <p>SYNOPSIS</p>
 * <p>int glp_ios_heur_sol(glp_tree *tree, const double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_ios_heur_sol can be called from the user-defined callback routine in response to the reason GLP_IHEUR to provide an integer feasible solution found by a primal heuristic.</p>
 * <p>Primal values of *all* variables (columns) found by the heuristic should be placed in locations x[1], ..., x[n], where n is the number of columns in the original problem object. Note that the routine glp_ios_heur_sol *does not* check primal feasibility of the solution provided.</p>
 * <p>Using the solution passed in the array x the routine computes value of the objective function. If the objective value is better than the best known integer feasible solution, the routine computes values of auxiliary variables (rows) and stores all solution components in the problem object.</p>
 * <p>RETURNS</p>
 * <p>If the provided solution is accepted, the routine glp_ios_heur_sol returns zero. Otherwise, if the provided solution is rejected, the routine returns non-zero. </p>
 */
public";

%javamethodmodifiers glp_ios_terminate(glp_tree *T) "
/**
 * glp_ios_terminate - terminate the solution process. .
 * <p>SYNOPSIS</p>
 * <p>void glp_ios_terminate(glp_tree *tree);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_ios_terminate sets a flag indicating that the MIP solver should prematurely terminate the search. </p>
 */
public";

%javamethodmodifiers glp_init_mpscp(glp_mpscp *parm) "
/**
 * glp_init_mpscp - initialize MPS format control parameters .
 * <p>SYNOPSIS</p>
 * <p>void glp_init_mpscp(glp_mpscp *parm);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_init_mpscp initializes control parameters, which are used by the MPS input/output routines glp_read_mps and glp_write_mps, with default values.</p>
 * <p>Default values of the control parameters are stored in the glp_mpscp structure, which the parameter parm points to. </p>
 */
public";

%javamethodmodifiers glp_read_mps(glp_prob *P, int fmt, const glp_mpscp *parm, const char *fname) "
/**
 */
public";

%javamethodmodifiers glp_write_mps(glp_prob *P, int fmt, const glp_mpscp *parm, const char *fname) "
/**
 */
public";

%javamethodmodifiers glp_init_cpxcp(glp_cpxcp *parm) "
/**
 * glp_init_cpxcp - initialize CPLEX LP format control parameters .
 * <p>SYNOPSIS</p>
 * <p>void glp_init_cpxcp(glp_cpxcp *parm):</p>
 * <p>The routine glp_init_cpxcp initializes control parameters used by the CPLEX LP input/output routines glp_read_lp and glp_write_lp with default values.</p>
 * <p>Default values of the control parameters are stored in the glp_cpxcp structure, which the parameter parm points to. </p>
 */
public";

%javamethodmodifiers glp_read_lp(glp_prob *P, const glp_cpxcp *parm, const char *fname) "
/**
 */
public";

%javamethodmodifiers glp_write_lp(glp_prob *P, const glp_cpxcp *parm, const char *fname) "
/**
 */
public";

%javamethodmodifiers glp_read_prob(glp_prob *P, int flags, const char *fname) "
/**
 * glp_read_prob - read problem data in GLPK format .
 * <p>SYNOPSIS</p>
 * <p>int glp_read_prob(glp_prob *P, int flags, const char *fname);</p>
 * <p>The routine glp_read_prob reads problem data in GLPK LP/MIP format from a text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public";

%javamethodmodifiers glp_write_prob(glp_prob *P, int flags, const char *fname) "
/**
 * glp_write_prob - write problem data in GLPK format .
 * <p>SYNOPSIS</p>
 * <p>int glp_write_prob(glp_prob *P, int flags, const char *fname);</p>
 * <p>The routine glp_write_prob writes problem data in GLPK LP/MIP format to a text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public";

%javamethodmodifiers glp_mpl_alloc_wksp(void) "
/**
 */
public";

%javamethodmodifiers glp_mpl_read_model(glp_tran *tran, const char *fname, int skip) "
/**
 */
public";

%javamethodmodifiers glp_mpl_read_data(glp_tran *tran, const char *fname) "
/**
 */
public";

%javamethodmodifiers glp_mpl_generate(glp_tran *tran, const char *fname) "
/**
 */
public";

%javamethodmodifiers glp_mpl_build_prob(glp_tran *tran, glp_prob *prob) "
/**
 */
public";

%javamethodmodifiers glp_mpl_postsolve(glp_tran *tran, glp_prob *prob, int sol) "
/**
 */
public";

%javamethodmodifiers glp_mpl_free_wksp(glp_tran *tran) "
/**
 */
public";

%javamethodmodifiers glp_main(int argc, const char *argv[]) "
/**
 */
public";

%javamethodmodifiers glp_read_cnfsat(glp_prob *P, const char *fname) "
/**
 */
public";

%javamethodmodifiers glp_check_cnfsat(glp_prob *P) "
/**
 */
public";

%javamethodmodifiers glp_write_cnfsat(glp_prob *P, const char *fname) "
/**
 */
public";

%javamethodmodifiers glp_minisat1(glp_prob *P) "
/**
 */
public";

%javamethodmodifiers glp_intfeas1(glp_prob *P, int use_bound, int obj_bound) "
/**
 */
public";

%javamethodmodifiers glp_init_env(void) "
/**
 * glp_init_env - initialize GLPK environment .
 * <p>SYNOPSIS</p>
 * <p>int glp_init_env(void);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_init_env initializes the GLPK environment. Normally the application program does not need to call this routine, because it is called automatically on the first call to any API routine.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_init_env returns one of the following codes:</p>
 * <p>0 - initialization successful; 1 - environment has been already initialized; 2 - initialization failed (insufficient memory); 3 - initialization failed (unsupported programming model). </p>
 */
public";

%javamethodmodifiers glp_version(void) "
/**
 * glp_version - determine library version .
 * <p>SYNOPSIS</p>
 * <p>const char *glp_version(void);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_version returns a pointer to a null-terminated character string, which specifies the version of the GLPK library in the form \"X.Y\", where X is the major version number, and Y is the minor version number, for example, \"4.16\". </p>
 */
public";

%javamethodmodifiers glp_free_env(void) "
/**
 * glp_free_env - free GLPK environment .
 * <p>SYNOPSIS</p>
 * <p>int glp_free_env(void);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_free_env frees all resources used by GLPK routines (memory blocks, etc.) which are currently still in use.</p>
 * <p>Normally the application program does not need to call this routine, because GLPK routines always free all unused resources. However, if the application program even has deleted all problem objects, there will be several memory blocks still allocated for the library needs. For some reasons the application program may want GLPK to free this memory, in which case it should call glp_free_env.</p>
 * <p>Note that a call to glp_free_env invalidates all problem objects as if no GLPK routine were called.</p>
 * <p>RETURNS</p>
 * <p>0 - termination successful; 1 - environment is inactive (was not initialized). </p>
 */
public";

%javamethodmodifiers glp_printf(const char *fmt,...) "
/**
 * glp_printf - write formatted output to terminal .
 * <p>SYNOPSIS</p>
 * <p>void glp_printf(const char *fmt, ...);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_printf uses the format control string fmt to format its parameters and writes the formatted output to the terminal. </p>
 */
public";

%javamethodmodifiers glp_vprintf(const char *fmt, va_list arg) "
/**
 * glp_vprintf - write formatted output to terminal .
 * <p>SYNOPSIS</p>
 * <p>void glp_vprintf(const char *fmt, va_list arg);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_vprintf uses the format control string fmt to format its parameters specified by the list arg and writes the formatted output to the terminal. </p>
 */
public";

%javamethodmodifiers glp_term_out(int flag) "
/**
 * glp_term_out - enable/disable terminal output .
 * <p>SYNOPSIS</p>
 * <p>int glp_term_out(int flag);</p>
 * <p>DESCRIPTION</p>
 * <p>Depending on the parameter flag the routine glp_term_out enables or disables terminal output performed by glpk routines:</p>
 * <p>GLP_ON - enable terminal output; GLP_OFF - disable terminal output.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_term_out returns the previous value of the terminal output flag. </p>
 */
public";

%javamethodmodifiers glp_term_hook(int(*func)(void *info, const char *s), void *info) "
/**
 * glp_term_hook - install hook to intercept terminal output .
 * <p>SYNOPSIS</p>
 * <p>void glp_term_hook(int (*func)(void *info, const char *s), void *info);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_term_hook installs a user-defined hook routine to intercept all terminal output performed by glpk routines.</p>
 * <p>This feature can be used to redirect the terminal output to other destination, for example to a file or a text window.</p>
 * <p>The parameter func specifies the user-defined hook routine. It is called from an internal printing routine, which passes to it two parameters: info and s. The parameter info is a transit pointer, specified in the corresponding call to the routine glp_term_hook; it may be used to pass some information to the hook routine. The parameter s is a pointer to the null terminated character string, which is intended to be written to the terminal. If the hook routine returns zero, the printing routine writes the string s to the terminal in a usual way; otherwise, if the hook routine returns non-zero, no terminal output is performed.</p>
 * <p>To uninstall the hook routine the parameters func and info should be specified as NULL. </p>
 */
public";

%javamethodmodifiers glp_open_tee(const char *fname) "
/**
 * glp_open_tee - start copying terminal output to text file .
 * <p>SYNOPSIS</p>
 * <p>int glp_open_tee(const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_open_tee starts copying all the terminal output to an output text file, whose name is specified by the character string fname.</p>
 * <p>RETURNS</p>
 * <p>0 - operation successful 1 - copying terminal output is already active 2 - unable to create output file </p>
 */
public";

%javamethodmodifiers glp_close_tee(void) "
/**
 * glp_close_tee - stop copying terminal output to text file .
 * <p>SYNOPSIS</p>
 * <p>int glp_close_tee(void);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_close_tee stops copying the terminal output to the output text file previously open by the routine glp_open_tee closing that file.</p>
 * <p>RETURNS</p>
 * <p>0 - operation successful 1 - copying terminal output was not started </p>
 */
public";

%javamethodmodifiers glp_error_(const char *file, int line) "
/**
 */
public";

%javamethodmodifiers glp_assert_(const char *expr, const char *file, int line) "
/**
 * glp_assert - check for logical condition .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" void glp_assert(int expr);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_assert (implemented as a macro) checks for a logical condition specified by the parameter expr. If the condition is false (i.e. the value of expr is zero), the routine writes a message to the terminal and abnormally terminates the program. </p>
 */
public";

%javamethodmodifiers glp_error_hook(void(*func)(void *info), void *info) "
/**
 * glp_error_hook - install hook to intercept abnormal termination .
 * <p>SYNOPSIS</p>
 * <p>void glp_error_hook(void (*func)(void *info), void *info);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_error_hook installs a user-defined hook routine to intercept abnormal termination.</p>
 * <p>The parameter func specifies the user-defined hook routine. It is called from the routine glp_error before the latter calls the abort function to abnormally terminate the application program because of fatal error. The parameter info is a transit pointer, specified in the corresponding call to the routine glp_error_hook; it may be used to pass some information to the hook routine.</p>
 * <p>To uninstall the hook routine the parameters func and info should be specified as NULL. </p>
 */
public";

%javamethodmodifiers glp_malloc(int size) "
/**
 * glp_malloc - allocate memory block .
 * <p>SYNOPSIS</p>
 * <p>void *glp_malloc(int size);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_malloc allocates a memory block of size bytes long.</p>
 * <p>Note that being allocated the memory block contains arbitrary data (not binary zeros).</p>
 * <p>RETURNS</p>
 * <p>The routine glp_malloc returns a pointer to the allocated block. To free this block the routine glp_free (not free!) must be used. </p>
 */
public";

%javamethodmodifiers glp_calloc(int n, int size) "
/**
 * glp_calloc - allocate memory block .
 * <p>SYNOPSIS</p>
 * <p>void *glp_calloc(int n, int size);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_calloc allocates a memory block of n * size bytes long.</p>
 * <p>Note that being allocated the memory block contains arbitrary data (not binary zeros).</p>
 * <p>RETURNS</p>
 * <p>The routine glp_calloc returns a pointer to the allocated block. To free this block the routine glp_free (not free!) must be used. </p>
 */
public";

%javamethodmodifiers glp_free(void *ptr) "
/**
 * glp_free - free memory block .
 * <p>SYNOPSIS</p>
 * <p>void glp_free(void *ptr);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_free frees a memory block pointed to by ptr, which was previuosly allocated by the routine glp_malloc or glp_calloc. </p>
 */
public";

%javamethodmodifiers glp_mem_limit(int limit) "
/**
 * glp_mem_limit - set memory usage limit .
 * <p>SYNOPSIS</p>
 * <p>void glp_mem_limit(int limit);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_mem_limit limits the amount of memory available for dynamic allocation (in GLPK routines) to limit megabytes. </p>
 */
public";

%javamethodmodifiers glp_mem_usage(int *count, int *cpeak, size_t *total, size_t *tpeak) "
/**
 * glp_mem_usage - get memory usage information .
 * <p>SYNOPSIS</p>
 * <p>void glp_mem_usage(int *count, int *cpeak, size_t *total, size_t *tpeak);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_mem_usage reports some information about utilization of the memory by GLPK routines. Information is stored to locations specified by corresponding parameters (see below). Any parameter can be specified as NULL, in which case its value is not stored.</p>
 * <p>*count is the number of the memory blocks currently allocated by the routines glp_malloc and glp_calloc (one call to glp_malloc or glp_calloc results in allocating one memory block).</p>
 * <p>*cpeak is the peak value of *count reached since the initialization of the GLPK library environment.</p>
 * <p>*total is the total amount, in bytes, of the memory blocks currently allocated by the routines glp_malloc and glp_calloc.</p>
 * <p>*tpeak is the peak value of *total reached since the initialization of the GLPK library envirionment. </p>
 */
public";

%javamethodmodifiers glp_create_graph(int v_size, int a_size) "
/**
 */
public";

%javamethodmodifiers glp_set_graph_name(glp_graph *G, const char *name) "
/**
 * glp_set_graph_name - assign (change) graph name .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_graph_name(glp_graph *G, const char *name);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_graph_name assigns a symbolic name specified by the character string name (1 to 255 chars) to the graph.</p>
 * <p>If the parameter name is NULL or an empty string, the routine erases the existing symbolic name of the graph. </p>
 */
public";

%javamethodmodifiers glp_add_vertices(glp_graph *G, int nadd) "
/**
 * glp_add_vertices - add new vertices to graph .
 * <p>SYNOPSIS</p>
 * <p>int glp_add_vertices(glp_graph *G, int nadd);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_add_vertices adds nadd vertices to the specified graph. New vertices are always added to the end of the vertex list, so ordinal numbers of existing vertices remain unchanged.</p>
 * <p>Being added each new vertex is isolated (has no incident arcs).</p>
 * <p>RETURNS</p>
 * <p>The routine glp_add_vertices returns an ordinal number of the first new vertex added to the graph. </p>
 */
public";

%javamethodmodifiers glp_set_vertex_name(glp_graph *G, int i, const char *name) "
/**
 */
public";

%javamethodmodifiers glp_add_arc(glp_graph *G, int i, int j) "
/**
 * glp_add_arc - add new arc to graph .
 * <p>SYNOPSIS</p>
 * <p>glp_arc *glp_add_arc(glp_graph *G, int i, int j);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_add_arc adds a new arc to the specified graph.</p>
 * <p>The parameters i and j specify the ordinal numbers of, resp., tail and head vertices of the arc. Note that self-loops and multiple arcs are allowed.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_add_arc returns a pointer to the arc added. </p>
 */
public";

%javamethodmodifiers glp_del_vertices(glp_graph *G, int ndel, const int num[]) "
/**
 * glp_del_vertices - delete vertices from graph .
 * <p>SYNOPSIS</p>
 * <p>void glp_del_vertices(glp_graph *G, int ndel, const int num[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_del_vertices deletes vertices along with all incident arcs from the specified graph. Ordinal numbers of vertices to be deleted should be placed in locations num[1], ..., num[ndel], ndel > 0.</p>
 * <p>Note that deleting vertices involves changing ordinal numbers of other vertices remaining in the graph. New ordinal numbers of the remaining vertices are assigned under the assumption that the original order of vertices is not changed. </p>
 */
public";

%javamethodmodifiers glp_del_arc(glp_graph *G, glp_arc *a) "
/**
 * glp_del_arc - delete arc from graph .
 * <p>SYNOPSIS</p>
 * <p>void glp_del_arc(glp_graph *G, glp_arc *a);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_del_arc deletes an arc from the specified graph. The arc to be deleted must exist. </p>
 */
public";

%javamethodmodifiers glp_erase_graph(glp_graph *G, int v_size, int a_size) "
/**
 */
public";

%javamethodmodifiers glp_delete_graph(glp_graph *G) "
/**
 * glp_delete_graph - delete graph .
 * <p>SYNOPSIS</p>
 * <p>void glp_delete_graph(glp_graph *G);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_delete_graph deletes the specified graph and frees all the memory allocated to this program object. </p>
 */
public";

%javamethodmodifiers glp_create_v_index(glp_graph *G) "
/**
 */
public";

%javamethodmodifiers glp_find_vertex(glp_graph *G, const char *name) "
/**
 */
public";

%javamethodmodifiers glp_delete_v_index(glp_graph *G) "
/**
 */
public";

%javamethodmodifiers glp_read_graph(glp_graph *G, const char *fname) "
/**
 * glp_read_graph - read graph from plain text file .
 * <p>SYNOPSIS</p>
 * <p>int glp_read_graph(glp_graph *G, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_read_graph reads a graph from a plain text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public";

%javamethodmodifiers glp_write_graph(glp_graph *G, const char *fname) "
/**
 * glp_write_graph - write graph to plain text file .
 * <p>SYNOPSIS</p>
 * <p>int glp_write_graph(glp_graph *G, const char *fname).</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_write_graph writes the specified graph to a plain text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public";

%javamethodmodifiers glp_mincost_lp(glp_prob *P, glp_graph *G, int names, int v_rhs, int a_low, int a_cap, int a_cost) "
/**
 * glp_mincost_lp - convert minimum cost flow problem to LP .
 * <p>SYNOPSIS</p>
 * <p>void glp_mincost_lp(glp_prob *lp, glp_graph *G, int names, int v_rhs, int a_low, int a_cap, int a_cost);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_mincost_lp builds an LP problem, which corresponds to the minimum cost flow problem on the specified network G. </p>
 */
public";

%javamethodmodifiers glp_mincost_okalg(glp_graph *G, int v_rhs, int a_low, int a_cap, int a_cost, double *sol, int a_x, int v_pi) "
/**
 */
public";

%javamethodmodifiers glp_mincost_relax4(glp_graph *G, int v_rhs, int a_low, int a_cap, int a_cost, int crash, double *sol, int a_x, int a_rc) "
/**
 */
public";

%javamethodmodifiers glp_maxflow_lp(glp_prob *P, glp_graph *G, int names, int s, int t, int a_cap) "
/**
 * glp_maxflow_lp - convert maximum flow problem to LP .
 * <p>SYNOPSIS</p>
 * <p>void glp_maxflow_lp(glp_prob *lp, glp_graph *G, int names, int s, int t, int a_cap);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_maxflow_lp builds an LP problem, which corresponds to the maximum flow problem on the specified network G. </p>
 */
public";

%javamethodmodifiers glp_maxflow_ffalg(glp_graph *G, int s, int t, int a_cap, double *sol, int a_x, int v_cut) "
/**
 */
public";

%javamethodmodifiers glp_check_asnprob(glp_graph *G, int v_set) "
/**
 * glp_check_asnprob - check correctness of assignment problem data .
 * <p>SYNOPSIS</p>
 * <p>int glp_check_asnprob(glp_graph *G, int v_set);</p>
 * <p>RETURNS</p>
 * <p>If the specified assignment problem data are correct, the routine glp_check_asnprob returns zero, otherwise, non-zero. </p>
 */
public";

%javamethodmodifiers glp_asnprob_lp(glp_prob *P, int form, glp_graph *G, int names, int v_set, int a_cost) "
/**
 * glp_asnprob_lp - convert assignment problem to LP .
 * <p>SYNOPSIS</p>
 * <p>int glp_asnprob_lp(glp_prob *P, int form, glp_graph *G, int names, int v_set, int a_cost);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_asnprob_lp builds an LP problem, which corresponds to the assignment problem on the specified graph G.</p>
 * <p>RETURNS</p>
 * <p>If the LP problem has been successfully built, the routine returns zero, otherwise, non-zero. </p>
 */
public";

%javamethodmodifiers glp_asnprob_okalg(int form, glp_graph *G, int v_set, int a_cost, double *sol, int a_x) "
/**
 */
public";

%javamethodmodifiers glp_asnprob_hall(glp_graph *G, int v_set, int a_x) "
/**
 * glp_asnprob_hall - find bipartite matching of maximum cardinality .
 * <p>SYNOPSIS</p>
 * <p>int glp_asnprob_hall(glp_graph *G, int v_set, int a_x);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_asnprob_hall finds a matching of maximal cardinality in the specified bipartite graph G. It uses a version of the Fortran routine MC21A developed by I.S.Duff [1], which implements Hall's algorithm [2].</p>
 * <p>RETURNS</p>
 * <p>The routine glp_asnprob_hall returns the cardinality of the matching found. However, if the specified graph is incorrect (as detected by the routine glp_check_asnprob), the routine returns negative value.</p>
 * <p>REFERENCES</p>
 * <p>1. I.S.Duff, Algorithm 575: Permutations for zero-free diagonal, ACM Trans. on Math. Softw. 7 (1981), 387-390.</p>
 * <p>2. M.Hall, \"An Algorithm for distinct representatives,\" Amer. Math. Monthly 63 (1956), 716-717. </p>
 */
public";

%javamethodmodifiers glp_cpp(glp_graph *G, int v_t, int v_es, int v_ls) "
/**
 */
public";

%javamethodmodifiers glp_read_mincost(glp_graph *G, int v_rhs, int a_low, int a_cap, int a_cost, const char *fname) "
/**
 * glp_read_mincost - read min-cost flow problem data in DIMACS format .
 * <p>SYNOPSIS</p>
 * <p>int glp_read_mincost(glp_graph *G, int v_rhs, int a_low, int a_cap, int a_cost, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_read_mincost reads minimum cost flow problem data in DIMACS format from a text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public";

%javamethodmodifiers glp_write_mincost(glp_graph *G, int v_rhs, int a_low, int a_cap, int a_cost, const char *fname) "
/**
 * glp_write_mincost - write min-cost flow problem data in DIMACS format .
 * <p>SYNOPSIS</p>
 * <p>int glp_write_mincost(glp_graph *G, int v_rhs, int a_low, int a_cap, int a_cost, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_write_mincost writes minimum cost flow problem data in DIMACS format to a text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public";

%javamethodmodifiers glp_read_maxflow(glp_graph *G, int *s, int *t, int a_cap, const char *fname) "
/**
 * glp_read_maxflow - read maximum flow problem data in DIMACS format .
 * <p>SYNOPSIS</p>
 * <p>int glp_read_maxflow(glp_graph *G, int *s, int *t, int a_cap, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_read_maxflow reads maximum flow problem data in DIMACS format from a text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public";

%javamethodmodifiers glp_write_maxflow(glp_graph *G, int s, int t, int a_cap, const char *fname) "
/**
 * glp_write_maxflow - write maximum flow problem data in DIMACS format .
 * <p>SYNOPSIS</p>
 * <p>int glp_write_maxflow(glp_graph *G, int s, int t, int a_cap, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_write_maxflow writes maximum flow problem data in DIMACS format to a text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public";

%javamethodmodifiers glp_read_asnprob(glp_graph *G, int v_set, int a_cost, const char *fname) "
/**
 * glp_read_asnprob - read assignment problem data in DIMACS format .
 * <p>SYNOPSIS</p>
 * <p>int glp_read_asnprob(glp_graph *G, int v_set, int a_cost, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_read_asnprob reads assignment problem data in DIMACS format from a text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public";

%javamethodmodifiers glp_write_asnprob(glp_graph *G, int v_set, int a_cost, const char *fname) "
/**
 * glp_write_asnprob - write assignment problem data in DIMACS format .
 * <p>SYNOPSIS</p>
 * <p>int glp_write_asnprob(glp_graph *G, int v_set, int a_cost, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_write_asnprob writes assignment problem data in DIMACS format to a text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public";

%javamethodmodifiers glp_read_ccdata(glp_graph *G, int v_wgt, const char *fname) "
/**
 * glp_read_ccdata - read graph in DIMACS clique/coloring format .
 * <p>SYNOPSIS</p>
 * <p>int glp_read_ccdata(glp_graph *G, int v_wgt, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_read_ccdata reads an (undirected) graph in DIMACS clique/coloring format from a text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public";

%javamethodmodifiers glp_write_ccdata(glp_graph *G, int v_wgt, const char *fname) "
/**
 * glp_write_ccdata - write graph in DIMACS clique/coloring format .
 * <p>SYNOPSIS</p>
 * <p>int glp_write_ccdata(glp_graph *G, int v_wgt, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_write_ccdata writes the specified graph in DIMACS clique/coloring format to a text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public";

%javamethodmodifiers glp_netgen(glp_graph *G, int v_rhs, int a_cap, int a_cost, const int parm[1+15]) "
/**
 */
public";

%javamethodmodifiers glp_netgen_prob(int nprob, int parm[1+15]) "
/**
 */
public";

%javamethodmodifiers glp_gridgen(glp_graph *G, int v_rhs, int a_cap, int a_cost, const int parm[1+14]) "
/**
 */
public";

%javamethodmodifiers glp_rmfgen(glp_graph *G, int *s, int *t, int a_cap, const int parm[1+5]) "
/**
 */
public";

%javamethodmodifiers glp_weak_comp(glp_graph *G, int v_num) "
/**
 * glp_weak_comp - find all weakly connected components of graph .
 * <p>SYNOPSIS</p>
 * <p>int glp_weak_comp(glp_graph *G, int v_num);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_weak_comp finds all weakly connected components of the specified graph.</p>
 * <p>The parameter v_num specifies an offset of the field of type int in the vertex data block, to which the routine stores the number of a (weakly) connected component containing that vertex. If v_num < 0, no component numbers are stored.</p>
 * <p>The components are numbered in arbitrary order from 1 to nc, where nc is the total number of components found, 0 <= nc <= |V|.</p>
 * <p>RETURNS</p>
 * <p>The routine returns nc, the total number of components found. </p>
 */
public";

%javamethodmodifiers glp_strong_comp(glp_graph *G, int v_num) "
/**
 * glp_strong_comp - find all strongly connected components of graph .
 * <p>SYNOPSIS</p>
 * <p>int glp_strong_comp(glp_graph *G, int v_num);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_strong_comp finds all strongly connected components of the specified graph.</p>
 * <p>The parameter v_num specifies an offset of the field of type int in the vertex data block, to which the routine stores the number of a strongly connected component containing that vertex. If v_num < 0, no component numbers are stored.</p>
 * <p>The components are numbered in arbitrary order from 1 to nc, where nc is the total number of components found, 0 <= nc <= |V|. However, the component numbering has the property that for every arc (i->j) in the graph the condition num(i) >= num(j) holds.</p>
 * <p>RETURNS</p>
 * <p>The routine returns nc, the total number of components found. </p>
 */
public";

%javamethodmodifiers glp_top_sort(glp_graph *G, int v_num) "
/**
 */
public";

%javamethodmodifiers glp_wclique_exact(glp_graph *G, int v_wgt, double *sol, int v_set) "
/**
 */
public";

%javamethodmodifiers bigmul(int n, int m, unsigned short x[], unsigned short y[]) "
/**
 * bigmul - multiply unsigned integer numbers of arbitrary precision .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" void bigmul(int n, int m, unsigned short x[], unsigned short y[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine bigmul multiplies unsigned integer numbers of arbitrary precision.</p>
 * <p>n is the number of digits of multiplicand, n >= 1;</p>
 * <p>m is the number of digits of multiplier, m >= 1;</p>
 * <p>x is an array containing digits of the multiplicand in elements x[m], x[m+1], ..., x[n+m-1]. Contents of x[0], x[1], ..., x[m-1] are ignored on entry.</p>
 * <p>y is an array containing digits of the multiplier in elements y[0], y[1], ..., y[m-1].</p>
 * <p>On exit digits of the product are stored in elements x[0], x[1], ..., x[n+m-1]. The array y is not changed. </p>
 */
public";

%javamethodmodifiers bigdiv(int n, int m, unsigned short x[], unsigned short y[]) "
/**
 * bigdiv - divide unsigned integer numbers of arbitrary precision .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" void bigdiv(int n, int m, unsigned short x[], unsigned short y[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine bigdiv divides one unsigned integer number of arbitrary precision by another with the algorithm described in [1].</p>
 * <p>n is the difference between the number of digits of dividend and the number of digits of divisor, n >= 0.</p>
 * <p>m is the number of digits of divisor, m >= 1.</p>
 * <p>x is an array containing digits of the dividend in elements x[0], x[1], ..., x[n+m-1].</p>
 * <p>y is an array containing digits of the divisor in elements y[0], y[1], ..., y[m-1]. The highest digit y[m-1] must be non-zero.</p>
 * <p>On exit n+1 digits of the quotient are stored in elements x[m], x[m+1], ..., x[n+m], and m digits of the remainder are stored in elements x[0], x[1], ..., x[m-1]. The array y is changed but then restored.</p>
 * <p>REFERENCES</p>
 * <p>1. D. Knuth. The Art of Computer Programming. Vol. 2: Seminumerical Algorithms. Stanford University, 1969. </p>
 */
public";

%javamethodmodifiers xlset(int x) "
/**
 * xlset - expand integer to long integer .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" glp_long xlset(int x);</p>
 * <p>RETURNS</p>
 * <p>The routine xlset returns x expanded to long integer. </p>
 */
public";

%javamethodmodifiers xlneg(glp_long x) "
/**
 * xlneg - negate long integer .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" glp_long xlneg(glp_long x);</p>
 * <p>RETURNS</p>
 * <p>The routine xlneg returns the difference 0 - x. </p>
 */
public";

%javamethodmodifiers xladd(glp_long x, glp_long y) "
/**
 * xladd - add long integers .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" glp_long xladd(glp_long x, glp_long y);</p>
 * <p>RETURNS</p>
 * <p>The routine xladd returns the sum x + y. </p>
 */
public";

%javamethodmodifiers xlsub(glp_long x, glp_long y) "
/**
 * xlsub - subtract long integers .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" glp_long xlsub(glp_long x, glp_long y);</p>
 * <p>RETURNS</p>
 * <p>The routine xlsub returns the difference x - y. </p>
 */
public";

%javamethodmodifiers xlcmp(glp_long x, glp_long y) "
/**
 * xlcmp - compare long integers .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" int xlcmp(glp_long x, glp_long y);</p>
 * <p>RETURNS</p>
 * <p>The routine xlcmp returns the sign of the difference x - y. </p>
 */
public";

%javamethodmodifiers xlmul(glp_long x, glp_long y) "
/**
 * xlmul - multiply long integers .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" glp_long xlmul(glp_long x, glp_long y);</p>
 * <p>RETURNS</p>
 * <p>The routine xlmul returns the product x * y. </p>
 */
public";

%javamethodmodifiers xldiv(glp_long x, glp_long y) "
/**
 * xldiv - divide long integers .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" glp_ldiv xldiv(glp_long x, glp_long y);</p>
 * <p>RETURNS</p>
 * <p>The routine xldiv returns a structure of type glp_ldiv containing members quot (the quotient) and rem (the remainder), both of type glp_long. </p>
 */
public";

%javamethodmodifiers xltod(glp_long x) "
/**
 * xltod - convert long integer to double .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" double xltod(glp_long x);</p>
 * <p>RETURNS</p>
 * <p>The routine xltod returns x converted to double. </p>
 */
public";

%javamethodmodifiers xltoa(glp_long x, char *s) "
/**
 */
public";

%javamethodmodifiers str2int(const char *str, int *val) "
/**
 * str2int - convert character string to value of int type .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" int str2int(const char *str, int *val);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine str2int converts the character string str to a value of integer type and stores the value into location, which the parameter val points to (in the case of error content of this location is not changed).</p>
 * <p>RETURNS</p>
 * <p>The routine returns one of the following error codes:</p>
 * <p>0 - no error; 1 - value out of range; 2 - character string is syntactically incorrect. </p>
 */
public";

%javamethodmodifiers str2num(const char *str, double *val) "
/**
 * str2num - convert character string to value of double type .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" int str2num(const char *str, double *val);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine str2num converts the character string str to a value of double type and stores the value into location, which the parameter val points to (in the case of error content of this location is not changed).</p>
 * <p>RETURNS</p>
 * <p>The routine returns one of the following error codes:</p>
 * <p>0 - no error; 1 - value out of range; 2 - character string is syntactically incorrect. </p>
 */
public";

%javamethodmodifiers strspx(char *str) "
/**
 * strspx - remove all spaces from character string .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" char *strspx(char *str);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine strspx removes all spaces from the character string str.</p>
 * <p>RETURNS</p>
 * <p>The routine returns a pointer to the character string.</p>
 * <p>EXAMPLES</p>
 * <p>strspx(\"   Errare   humanum   est   \") => \"Errarehumanumest\"</p>
 * <p>strspx(\"      \") => \"\" </p>
 */
public";

%javamethodmodifiers strtrim(char *str) "
/**
 * strtrim - remove trailing spaces from character string .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" char *strtrim(char *str);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine strtrim removes trailing spaces from the character string str.</p>
 * <p>RETURNS</p>
 * <p>The routine returns a pointer to the character string.</p>
 * <p>EXAMPLES</p>
 * <p>strtrim(\"Errare humanum est   \") => \"Errare humanum est\"</p>
 * <p>strtrim(\"      \") => \"\" </p>
 */
public";

%javamethodmodifiers strrev(char *s) "
/**
 * strrev - reverse character string .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" char *strrev(char *s);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine strrev changes characters in a character string s to the reverse order, except the terminating null character.</p>
 * <p>RETURNS</p>
 * <p>The routine returns the pointer s.</p>
 * <p>EXAMPLES</p>
 * <p>strrev(\"\") => \"\"</p>
 * <p>strrev(\"Today is Monday\") => \"yadnoM si yadoT\" </p>
 */
public";

%javamethodmodifiers gcd(int x, int y) "
/**
 * gcd - find greatest common divisor of two integers .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" int gcd(int x, int y);</p>
 * <p>RETURNS</p>
 * <p>The routine gcd returns gcd(x, y), the greatest common divisor of the two positive integers given.</p>
 * <p>ALGORITHM</p>
 * <p>The routine gcd is based on Euclid's algorithm.</p>
 * <p>REFERENCES</p>
 * <p>Don Knuth, The Art of Computer Programming, Vol.2: Seminumerical Algorithms, 3rd Edition, Addison-Wesley, 1997. Section 4.5.2: The Greatest Common Divisor, pp. 333-56. </p>
 */
public";

%javamethodmodifiers gcdn(int n, int x[]) "
/**
 * gcdn - find greatest common divisor of n integers .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" int gcdn(int n, int x[]);</p>
 * <p>RETURNS</p>
 * <p>The routine gcdn returns gcd(x[1], x[2], ..., x[n]), the greatest common divisor of n positive integers given, n > 0.</p>
 * <p>BACKGROUND</p>
 * <p>The routine gcdn is based on the following identity:</p>
 * <p>gcd(x, y, z) = gcd(gcd(x, y), z).</p>
 * <p>REFERENCES</p>
 * <p>Don Knuth, The Art of Computer Programming, Vol.2: Seminumerical Algorithms, 3rd Edition, Addison-Wesley, 1997. Section 4.5.2: The Greatest Common Divisor, pp. 333-56. </p>
 */
public";

%javamethodmodifiers lcm(int x, int y) "
/**
 * lcm - find least common multiple of two integers .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" int lcm(int x, int y);</p>
 * <p>RETURNS</p>
 * <p>The routine lcm returns lcm(x, y), the least common multiple of the two positive integers given. In case of integer overflow the routine returns zero.</p>
 * <p>BACKGROUND</p>
 * <p>The routine lcm is based on the following identity:</p>
 * <p>lcm(x, y) = (x * y) / gcd(x, y) = x * [y / gcd(x, y)],</p>
 * <p>where gcd(x, y) is the greatest common divisor of x and y. </p>
 */
public";

%javamethodmodifiers lcmn(int n, int x[]) "
/**
 * lcmn - find least common multiple of n integers .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" int lcmn(int n, int x[]);</p>
 * <p>RETURNS</p>
 * <p>The routine lcmn returns lcm(x[1], x[2], ..., x[n]), the least common multiple of n positive integers given, n > 0. In case of integer overflow the routine returns zero.</p>
 * <p>BACKGROUND</p>
 * <p>The routine lcmn is based on the following identity:</p>
 * <p>lcmn(x, y, z) = lcm(lcm(x, y), z),</p>
 * <p>where lcm(x, y) is the least common multiple of x and y. </p>
 */
public";

%javamethodmodifiers round2n(double x) "
/**
 * round2n - round floating-point number to nearest power of two .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" double round2n(double x);</p>
 * <p>RETURNS</p>
 * <p>Given a positive floating-point value x the routine round2n returns 2^n such that |x - 2^n| is minimal.</p>
 * <p>EXAMPLES</p>
 * <p>round2n(10.1) = 2^3 = 8 round2n(15.3) = 2^4 = 16 round2n(0.01) = 2^(-7) = 0.0078125</p>
 * <p>BACKGROUND</p>
 * <p>Let x = f * 2^e, where 0.5 <= f < 1 is a normalized fractional part, e is an integer exponent. Then, obviously, 0.5 * 2^e <= x < 2^e, so if x - 0.5 * 2^e <= 2^e - x, we choose 0.5 * 2^e = 2^(e-1), and 2^e otherwise. The latter condition can be written as 2 * x <= 1.5 * 2^e or 2 * f * 2^e <= 1.5 * 2^e or, finally, f <= 0.75. </p>
 */
public";

%javamethodmodifiers fp2rat(double x, double eps, double *p, double *q) "
/**
 * fp2rat - convert floating-point number to rational number .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" int fp2rat(double x, double eps, double *p, double *q);</p>
 * <p>DESCRIPTION</p>
 * <p>Given a floating-point number 0 <= x < 1 the routine fp2rat finds its \"best\" rational approximation p / q, where p >= 0 and q > 0 are integer numbers, such that |x - p / q| <= eps.</p>
 * <p>RETURNS</p>
 * <p>The routine fp2rat returns the number of iterations used to achieve the specified precision eps.</p>
 * <p>EXAMPLES</p>
 * <p>For x = sqrt(2) - 1 = 0.414213562373095 and eps = 1e-6 the routine gives p = 408 and q = 985, where 408 / 985 = 0.414213197969543.</p>
 * <p>BACKGROUND</p>
 * <p>It is well known that every positive real number x can be expressed as the following continued fraction:</p>
 * <p>x = b[0] + a[1] ------------------------ b[1] + a[2] ----------------- b[2] + a[3] ---------- b[3] + ...</p>
 * <p>where:</p>
 * <p>a[k] = 1, k = 0, 1, 2, ...</p>
 * <p>b[k] = floor(x[k]), k = 0, 1, 2, ...</p>
 * <p>x[0] = x,</p>
 * <p>x[k] = 1 / frac(x[k-1]), k = 1, 2, 3, ...</p>
 * <p>To find the \"best\" rational approximation of x the routine computes partial fractions f[k] by dropping after k terms as follows:</p>
 * <p>f[k] = A[k] / B[k],</p>
 * <p>where:</p>
 * <p>A[-1] = 1, A[0] = b[0], B[-1] = 0, B[0] = 1,</p>
 * <p>A[k] = b[k] * A[k-1] + a[k] * A[k-2],</p>
 * <p>B[k] = b[k] * B[k-1] + a[k] * B[k-2].</p>
 * <p>Once the condition</p>
 * <p>|x - f[k]| <= eps</p>
 * <p>has been satisfied, the routine reports p = A[k] and q = B[k] as the final answer.</p>
 * <p>In the table below here is some statistics obtained for one million random numbers uniformly distributed in the range [0, 1).</p>
 * <p>eps max p mean p max q mean q max k mean k ------------------------------------------------------------- 1e-1 8 1.6 9 3.2 3 1.4 1e-2 98 6.2 99 12.4 5 2.4 1e-3 997 20.7 998 41.5 8 3.4 1e-4 9959 66.6 9960 133.5 10 4.4 1e-5 97403 211.7 97404 424.2 13 5.3 1e-6 479669 669.9 479670 1342.9 15 6.3 1e-7 1579030 2127.3 3962146 4257.8 16 7.3 1e-8 26188823 6749.4 26188824 13503.4 19 8.2</p>
 * <p>REFERENCES</p>
 * <p>W. B. Jones and W. J. Thron, \"Continued Fractions: Analytic Theory
  and Applications,\" Encyclopedia on Mathematics and Its Applications, Addison-Wesley, 1980. </p>
 */
public";

%javamethodmodifiers jday(int d, int m, int y) "
/**
 * jday - convert calendar date to Julian day number .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" int jday(int d, int m, int y);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine jday converts a calendar date, Gregorian calendar, to corresponding Julian day number j.</p>
 * <p>From the given day d, month m, and year y, the Julian day number j is computed without using tables.</p>
 * <p>The routine is valid for 1 <= y <= 4000.</p>
 * <p>RETURNS</p>
 * <p>The routine jday returns the Julian day number, or negative value if the specified date is incorrect.</p>
 * <p>REFERENCES</p>
 * <p>R. G. Tantzen, Algorithm 199: conversions between calendar date and Julian day number, Communications of the ACM, vol. 6, no. 8, p. 444, Aug. 1963. </p>
 */
public";

%javamethodmodifiers jdate(int j, int *d, int *m, int *y) "
/**
 * jdate - convert Julian day number to calendar date .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" void jdate(int j, int *d, int *m, int *y);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine jdate converts a Julian day number j to corresponding calendar date, Gregorian calendar.</p>
 * <p>The day d, month m, and year y are computed without using tables and stored in corresponding locations.</p>
 * <p>The routine is valid for 1721426 <= j <= 3182395.</p>
 * <p>RETURNS</p>
 * <p>If the conversion is successful, the routine returns zero, otherwise non-zero.</p>
 * <p>REFERENCES</p>
 * <p>R. G. Tantzen, Algorithm 199: conversions between calendar date and Julian day number, Communications of the ACM, vol. 6, no. 8, p. 444, Aug. 1963. </p>
 */
public";

%javamethodmodifiers bigmul(int n, int m, unsigned short x[], unsigned short y[]) "
/**
 * bigmul - multiply unsigned integer numbers of arbitrary precision .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" void bigmul(int n, int m, unsigned short x[], unsigned short y[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine bigmul multiplies unsigned integer numbers of arbitrary precision.</p>
 * <p>n is the number of digits of multiplicand, n >= 1;</p>
 * <p>m is the number of digits of multiplier, m >= 1;</p>
 * <p>x is an array containing digits of the multiplicand in elements x[m], x[m+1], ..., x[n+m-1]. Contents of x[0], x[1], ..., x[m-1] are ignored on entry.</p>
 * <p>y is an array containing digits of the multiplier in elements y[0], y[1], ..., y[m-1].</p>
 * <p>On exit digits of the product are stored in elements x[0], x[1], ..., x[n+m-1]. The array y is not changed. </p>
 */
public";

%javamethodmodifiers bigdiv(int n, int m, unsigned short x[], unsigned short y[]) "
/**
 * bigdiv - divide unsigned integer numbers of arbitrary precision .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" void bigdiv(int n, int m, unsigned short x[], unsigned short y[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine bigdiv divides one unsigned integer number of arbitrary precision by another with the algorithm described in [1].</p>
 * <p>n is the difference between the number of digits of dividend and the number of digits of divisor, n >= 0.</p>
 * <p>m is the number of digits of divisor, m >= 1.</p>
 * <p>x is an array containing digits of the dividend in elements x[0], x[1], ..., x[n+m-1].</p>
 * <p>y is an array containing digits of the divisor in elements y[0], y[1], ..., y[m-1]. The highest digit y[m-1] must be non-zero.</p>
 * <p>On exit n+1 digits of the quotient are stored in elements x[m], x[m+1], ..., x[n+m], and m digits of the remainder are stored in elements x[0], x[1], ..., x[m-1]. The array y is changed but then restored.</p>
 * <p>REFERENCES</p>
 * <p>1. D. Knuth. The Art of Computer Programming. Vol. 2: Seminumerical Algorithms. Stanford University, 1969. </p>
 */
public";

%javamethodmodifiers xlset(int x) "
/**
 * xlset - expand integer to long integer .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" glp_long xlset(int x);</p>
 * <p>RETURNS</p>
 * <p>The routine xlset returns x expanded to long integer. </p>
 */
public";

%javamethodmodifiers xlneg(glp_long x) "
/**
 * xlneg - negate long integer .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" glp_long xlneg(glp_long x);</p>
 * <p>RETURNS</p>
 * <p>The routine xlneg returns the difference 0 - x. </p>
 */
public";

%javamethodmodifiers xladd(glp_long x, glp_long y) "
/**
 * xladd - add long integers .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" glp_long xladd(glp_long x, glp_long y);</p>
 * <p>RETURNS</p>
 * <p>The routine xladd returns the sum x + y. </p>
 */
public";

%javamethodmodifiers xlsub(glp_long x, glp_long y) "
/**
 * xlsub - subtract long integers .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" glp_long xlsub(glp_long x, glp_long y);</p>
 * <p>RETURNS</p>
 * <p>The routine xlsub returns the difference x - y. </p>
 */
public";

%javamethodmodifiers xlcmp(glp_long x, glp_long y) "
/**
 * xlcmp - compare long integers .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" int xlcmp(glp_long x, glp_long y);</p>
 * <p>RETURNS</p>
 * <p>The routine xlcmp returns the sign of the difference x - y. </p>
 */
public";

%javamethodmodifiers xlmul(glp_long x, glp_long y) "
/**
 * xlmul - multiply long integers .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" glp_long xlmul(glp_long x, glp_long y);</p>
 * <p>RETURNS</p>
 * <p>The routine xlmul returns the product x * y. </p>
 */
public";

%javamethodmodifiers xldiv(glp_long x, glp_long y) "
/**
 * xldiv - divide long integers .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" glp_ldiv xldiv(glp_long x, glp_long y);</p>
 * <p>RETURNS</p>
 * <p>The routine xldiv returns a structure of type glp_ldiv containing members quot (the quotient) and rem (the remainder), both of type glp_long. </p>
 */
public";

%javamethodmodifiers xltod(glp_long x) "
/**
 * xltod - convert long integer to double .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" double xltod(glp_long x);</p>
 * <p>RETURNS</p>
 * <p>The routine xltod returns x converted to double. </p>
 */
public";

%javamethodmodifiers xltoa(glp_long x, char *s) "
/**
 */
public";

%javamethodmodifiers str2int(const char *str, int *_val) "
/**
 * str2int - convert character string to value of int type .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" int str2int(const char *str, int *val);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine str2int converts the character string str to a value of integer type and stores the value into location, which the parameter val points to (in the case of error content of this location is not changed).</p>
 * <p>RETURNS</p>
 * <p>The routine returns one of the following error codes:</p>
 * <p>0 - no error; 1 - value out of range; 2 - character string is syntactically incorrect. </p>
 */
public";

%javamethodmodifiers str2num(const char *str, double *_val) "
/**
 * str2num - convert character string to value of double type .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" int str2num(const char *str, double *val);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine str2num converts the character string str to a value of double type and stores the value into location, which the parameter val points to (in the case of error content of this location is not changed).</p>
 * <p>RETURNS</p>
 * <p>The routine returns one of the following error codes:</p>
 * <p>0 - no error; 1 - value out of range; 2 - character string is syntactically incorrect. </p>
 */
public";

%javamethodmodifiers strspx(char *str) "
/**
 * strspx - remove all spaces from character string .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" char *strspx(char *str);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine strspx removes all spaces from the character string str.</p>
 * <p>RETURNS</p>
 * <p>The routine returns a pointer to the character string.</p>
 * <p>EXAMPLES</p>
 * <p>strspx(\"   Errare   humanum   est   \") => \"Errarehumanumest\"</p>
 * <p>strspx(\"      \") => \"\" </p>
 */
public";

%javamethodmodifiers strtrim(char *str) "
/**
 * strtrim - remove trailing spaces from character string .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" char *strtrim(char *str);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine strtrim removes trailing spaces from the character string str.</p>
 * <p>RETURNS</p>
 * <p>The routine returns a pointer to the character string.</p>
 * <p>EXAMPLES</p>
 * <p>strtrim(\"Errare humanum est   \") => \"Errare humanum est\"</p>
 * <p>strtrim(\"      \") => \"\" </p>
 */
public";

%javamethodmodifiers strrev(char *s) "
/**
 * strrev - reverse character string .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" char *strrev(char *s);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine strrev changes characters in a character string s to the reverse order, except the terminating null character.</p>
 * <p>RETURNS</p>
 * <p>The routine returns the pointer s.</p>
 * <p>EXAMPLES</p>
 * <p>strrev(\"\") => \"\"</p>
 * <p>strrev(\"Today is Monday\") => \"yadnoM si yadoT\" </p>
 */
public";

%javamethodmodifiers gcd(int x, int y) "
/**
 * gcd - find greatest common divisor of two integers .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" int gcd(int x, int y);</p>
 * <p>RETURNS</p>
 * <p>The routine gcd returns gcd(x, y), the greatest common divisor of the two positive integers given.</p>
 * <p>ALGORITHM</p>
 * <p>The routine gcd is based on Euclid's algorithm.</p>
 * <p>REFERENCES</p>
 * <p>Don Knuth, The Art of Computer Programming, Vol.2: Seminumerical Algorithms, 3rd Edition, Addison-Wesley, 1997. Section 4.5.2: The Greatest Common Divisor, pp. 333-56. </p>
 */
public";

%javamethodmodifiers gcdn(int n, int x[]) "
/**
 * gcdn - find greatest common divisor of n integers .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" int gcdn(int n, int x[]);</p>
 * <p>RETURNS</p>
 * <p>The routine gcdn returns gcd(x[1], x[2], ..., x[n]), the greatest common divisor of n positive integers given, n > 0.</p>
 * <p>BACKGROUND</p>
 * <p>The routine gcdn is based on the following identity:</p>
 * <p>gcd(x, y, z) = gcd(gcd(x, y), z).</p>
 * <p>REFERENCES</p>
 * <p>Don Knuth, The Art of Computer Programming, Vol.2: Seminumerical Algorithms, 3rd Edition, Addison-Wesley, 1997. Section 4.5.2: The Greatest Common Divisor, pp. 333-56. </p>
 */
public";

%javamethodmodifiers lcm(int x, int y) "
/**
 * lcm - find least common multiple of two integers .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" int lcm(int x, int y);</p>
 * <p>RETURNS</p>
 * <p>The routine lcm returns lcm(x, y), the least common multiple of the two positive integers given. In case of integer overflow the routine returns zero.</p>
 * <p>BACKGROUND</p>
 * <p>The routine lcm is based on the following identity:</p>
 * <p>lcm(x, y) = (x * y) / gcd(x, y) = x * [y / gcd(x, y)],</p>
 * <p>where gcd(x, y) is the greatest common divisor of x and y. </p>
 */
public";

%javamethodmodifiers lcmn(int n, int x[]) "
/**
 * lcmn - find least common multiple of n integers .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" int lcmn(int n, int x[]);</p>
 * <p>RETURNS</p>
 * <p>The routine lcmn returns lcm(x[1], x[2], ..., x[n]), the least common multiple of n positive integers given, n > 0. In case of integer overflow the routine returns zero.</p>
 * <p>BACKGROUND</p>
 * <p>The routine lcmn is based on the following identity:</p>
 * <p>lcmn(x, y, z) = lcm(lcm(x, y), z),</p>
 * <p>where lcm(x, y) is the least common multiple of x and y. </p>
 */
public";

%javamethodmodifiers round2n(double x) "
/**
 * round2n - round floating-point number to nearest power of two .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" double round2n(double x);</p>
 * <p>RETURNS</p>
 * <p>Given a positive floating-point value x the routine round2n returns 2^n such that |x - 2^n| is minimal.</p>
 * <p>EXAMPLES</p>
 * <p>round2n(10.1) = 2^3 = 8 round2n(15.3) = 2^4 = 16 round2n(0.01) = 2^(-7) = 0.0078125</p>
 * <p>BACKGROUND</p>
 * <p>Let x = f * 2^e, where 0.5 <= f < 1 is a normalized fractional part, e is an integer exponent. Then, obviously, 0.5 * 2^e <= x < 2^e, so if x - 0.5 * 2^e <= 2^e - x, we choose 0.5 * 2^e = 2^(e-1), and 2^e otherwise. The latter condition can be written as 2 * x <= 1.5 * 2^e or 2 * f * 2^e <= 1.5 * 2^e or, finally, f <= 0.75. </p>
 */
public";

%javamethodmodifiers fp2rat(double x, double eps, double *p, double *q) "
/**
 * fp2rat - convert floating-point number to rational number .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" int fp2rat(double x, double eps, double *p, double *q);</p>
 * <p>DESCRIPTION</p>
 * <p>Given a floating-point number 0 <= x < 1 the routine fp2rat finds its \"best\" rational approximation p / q, where p >= 0 and q > 0 are integer numbers, such that |x - p / q| <= eps.</p>
 * <p>RETURNS</p>
 * <p>The routine fp2rat returns the number of iterations used to achieve the specified precision eps.</p>
 * <p>EXAMPLES</p>
 * <p>For x = sqrt(2) - 1 = 0.414213562373095 and eps = 1e-6 the routine gives p = 408 and q = 985, where 408 / 985 = 0.414213197969543.</p>
 * <p>BACKGROUND</p>
 * <p>It is well known that every positive real number x can be expressed as the following continued fraction:</p>
 * <p>x = b[0] + a[1] ------------------------ b[1] + a[2] ----------------- b[2] + a[3] ---------- b[3] + ...</p>
 * <p>where:</p>
 * <p>a[k] = 1, k = 0, 1, 2, ...</p>
 * <p>b[k] = floor(x[k]), k = 0, 1, 2, ...</p>
 * <p>x[0] = x,</p>
 * <p>x[k] = 1 / frac(x[k-1]), k = 1, 2, 3, ...</p>
 * <p>To find the \"best\" rational approximation of x the routine computes partial fractions f[k] by dropping after k terms as follows:</p>
 * <p>f[k] = A[k] / B[k],</p>
 * <p>where:</p>
 * <p>A[-1] = 1, A[0] = b[0], B[-1] = 0, B[0] = 1,</p>
 * <p>A[k] = b[k] * A[k-1] + a[k] * A[k-2],</p>
 * <p>B[k] = b[k] * B[k-1] + a[k] * B[k-2].</p>
 * <p>Once the condition</p>
 * <p>|x - f[k]| <= eps</p>
 * <p>has been satisfied, the routine reports p = A[k] and q = B[k] as the final answer.</p>
 * <p>In the table below here is some statistics obtained for one million random numbers uniformly distributed in the range [0, 1).</p>
 * <p>eps max p mean p max q mean q max k mean k ------------------------------------------------------------- 1e-1 8 1.6 9 3.2 3 1.4 1e-2 98 6.2 99 12.4 5 2.4 1e-3 997 20.7 998 41.5 8 3.4 1e-4 9959 66.6 9960 133.5 10 4.4 1e-5 97403 211.7 97404 424.2 13 5.3 1e-6 479669 669.9 479670 1342.9 15 6.3 1e-7 1579030 2127.3 3962146 4257.8 16 7.3 1e-8 26188823 6749.4 26188824 13503.4 19 8.2</p>
 * <p>REFERENCES</p>
 * <p>W. B. Jones and W. J. Thron, \"Continued Fractions: Analytic Theory
  and Applications,\" Encyclopedia on Mathematics and Its Applications, Addison-Wesley, 1980. </p>
 */
public";

%javamethodmodifiers jday(int d, int m, int y) "
/**
 * jday - convert calendar date to Julian day number .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" int jday(int d, int m, int y);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine jday converts a calendar date, Gregorian calendar, to corresponding Julian day number j.</p>
 * <p>From the given day d, month m, and year y, the Julian day number j is computed without using tables.</p>
 * <p>The routine is valid for 1 <= y <= 4000.</p>
 * <p>RETURNS</p>
 * <p>The routine jday returns the Julian day number, or negative value if the specified date is incorrect.</p>
 * <p>REFERENCES</p>
 * <p>R. G. Tantzen, Algorithm 199: conversions between calendar date and Julian day number, Communications of the ACM, vol. 6, no. 8, p. 444, Aug. 1963. </p>
 */
public";

%javamethodmodifiers jdate(int j, int *_d, int *_m, int *_y) "
/**
 * jdate - convert Julian day number to calendar date .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplib.h\" void jdate(int j, int *d, int *m, int *y);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine jdate converts a Julian day number j to corresponding calendar date, Gregorian calendar.</p>
 * <p>The day d, month m, and year y are computed without using tables and stored in corresponding locations.</p>
 * <p>The routine is valid for 1721426 <= j <= 3182395.</p>
 * <p>RETURNS</p>
 * <p>If the conversion is successful, the routine returns zero, otherwise non-zero.</p>
 * <p>REFERENCES</p>
 * <p>R. G. Tantzen, Algorithm 199: conversions between calendar date and Julian day number, Communications of the ACM, vol. 6, no. 8, p. 444, Aug. 1963. </p>
 */
public";

%javamethodmodifiers lpf_create_it(void) "
/**
 * lpf_create_it - create LP basis factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplpf.h\" LPF *lpf_create_it(void);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine lpf_create_it creates a program object, which represents a factorization of LP basis.</p>
 * <p>RETURNS</p>
 * <p>The routine lpf_create_it returns a pointer to the object created. </p>
 */
public";

%javamethodmodifiers lpf_factorize(LPF *lpf, int m, const int bh[], int(*col)(void *info, int j, int ind[], double val[]), void *info) "
/**
 * lpf_factorize - compute LP basis factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplpf.h\" int lpf_factorize(LPF *lpf, int m, const int bh[], int (*col) (void *info, int j, int ind[], double val[]), void *info);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine lpf_factorize computes the factorization of the basis matrix B specified by the routine col.</p>
 * <p>The parameter lpf specified the basis factorization data structure created with the routine lpf_create_it.</p>
 * <p>The parameter m specifies the order of B, m > 0.</p>
 * <p>The array bh specifies the basis header: bh[j], 1 <= j <= m, is the number of j-th column of B in some original matrix. The array bh is optional and can be specified as NULL.</p>
 * <p>The formal routine col specifies the matrix B to be factorized. To obtain j-th column of A the routine lpf_factorize calls the routine col with the parameter j (1 <= j <= n). In response the routine col should store row indices and numerical values of non-zero elements of j-th column of B to locations ind[1,...,len] and val[1,...,len], respectively, where len is the number of non-zeros in j-th column returned on exit. Neither zero nor duplicate elements are allowed.</p>
 * <p>The parameter info is a transit pointer passed to the routine col.</p>
 * <p>RETURNS</p>
 * <p>0 The factorization has been successfully computed.</p>
 * <p>LPF_ESING The specified matrix is singular within the working precision.</p>
 * <p>LPF_ECOND The specified matrix is ill-conditioned.</p>
 * <p>For more details see comments to the routine luf_factorize. </p>
 */
public";

%javamethodmodifiers r_prod(LPF *lpf, double y[], double a, const double x[]) "
/**
 */
public";

%javamethodmodifiers rt_prod(LPF *lpf, double y[], double a, const double x[]) "
/**
 */
public";

%javamethodmodifiers s_prod(LPF *lpf, double y[], double a, const double x[]) "
/**
 */
public";

%javamethodmodifiers st_prod(LPF *lpf, double y[], double a, const double x[]) "
/**
 */
public";

%javamethodmodifiers lpf_ftran(LPF *lpf, double x[]) "
/**
 * lpf_ftran - perform forward transformation (solve system B*x = b) .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplpf.h\" void lpf_ftran(LPF *lpf, double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine lpf_ftran performs forward transformation, i.e. solves the system B*x = b, where B is the basis matrix, x is the vector of unknowns to be computed, b is the vector of right-hand sides.</p>
 * <p>On entry elements of the vector b should be stored in dense format in locations x[1], ..., x[m], where m is the number of rows. On exit the routine stores elements of the vector x in the same locations.</p>
 * <p>BACKGROUND</p>
 * <p>Solution of the system B * x = b can be obtained by solving the following augmented system:</p>
 * <p>( B F^) ( x ) ( b ) ( ) ( ) = ( ) ( G^ H^) ( y ) ( 0 )</p>
 * <p>which, using the main equality, can be written as follows:</p>
 * <p>( L0 0 ) ( U0 R ) ( x ) ( b ) P ( ) ( ) Q ( ) = ( ) ( S I ) ( 0 C ) ( y ) ( 0 )</p>
 * <p>therefore,</p>
 * <p>( x ) ( U0 R )-1 ( L0 0 )-1 ( b ) ( ) = Q' ( ) ( ) P' ( ) ( y ) ( 0 C ) ( S I ) ( 0 )</p>
 * <p>Thus, computing the solution includes the following steps:</p>
 * <p>1. Compute</p>
 * <p>( f ) ( b ) ( ) = P' ( ) ( g ) ( 0 )</p>
 * <p>2. Solve the system</p>
 * <p>( f1 ) ( L0 0 )-1 ( f ) ( L0 0 ) ( f1 ) ( f ) ( ) = ( ) ( ) => ( ) ( ) = ( ) ( g1 ) ( S I ) ( g ) ( S I ) ( g1 ) ( g )</p>
 * <p>from which it follows that:</p>
 * <p>{ L0 * f1 = f f1 = inv(L0) * f { => { S * f1 + g1 = g g1 = g - S * f1</p>
 * <p>3. Solve the system</p>
 * <p>( f2 ) ( U0 R )-1 ( f1 ) ( U0 R ) ( f2 ) ( f1 ) ( ) = ( ) ( ) => ( ) ( ) = ( ) ( g2 ) ( 0 C ) ( g1 ) ( 0 C ) ( g2 ) ( g1 )</p>
 * <p>from which it follows that:</p>
 * <p>{ U0 * f2 + R * g2 = f1 f2 = inv(U0) * (f1 - R * g2) { => { C * g2 = g1 g2 = inv(C) * g1</p>
 * <p>4. Compute</p>
 * <p>( x ) ( f2 ) ( ) = Q' ( ) ( y ) ( g2 ) </p>
 */
public";

%javamethodmodifiers lpf_btran(LPF *lpf, double x[]) "
/**
 * lpf_btran - perform backward transformation (solve system B'*x = b) .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplpf.h\" void lpf_btran(LPF *lpf, double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine lpf_btran performs backward transformation, i.e. solves the system B'*x = b, where B' is a matrix transposed to the basis matrix B, x is the vector of unknowns to be computed, b is the vector of right-hand sides.</p>
 * <p>On entry elements of the vector b should be stored in dense format in locations x[1], ..., x[m], where m is the number of rows. On exit the routine stores elements of the vector x in the same locations.</p>
 * <p>BACKGROUND</p>
 * <p>Solution of the system B' * x = b, where B' is a matrix transposed to B, can be obtained by solving the following augmented system:</p>
 * <p>( B F^)T ( x ) ( b ) ( ) ( ) = ( ) ( G^ H^) ( y ) ( 0 )</p>
 * <p>which, using the main equality, can be written as follows:</p>
 * <p>T ( U0 R )T ( L0 0 )T T ( x ) ( b ) Q ( ) ( ) P ( ) = ( ) ( 0 C ) ( S I ) ( y ) ( 0 )</p>
 * <p>or, equivalently, as follows:</p>
 * <p>( U'0 0 ) ( L'0 S') ( x ) ( b ) Q' ( ) ( ) P' ( ) = ( ) ( R' C') ( 0 I ) ( y ) ( 0 )</p>
 * <p>therefore,</p>
 * <p>( x ) ( L'0 S')-1 ( U'0 0 )-1 ( b ) ( ) = P ( ) ( ) Q ( ) ( y ) ( 0 I ) ( R' C') ( 0 )</p>
 * <p>Thus, computing the solution includes the following steps:</p>
 * <p>1. Compute</p>
 * <p>( f ) ( b ) ( ) = Q ( ) ( g ) ( 0 )</p>
 * <p>2. Solve the system</p>
 * <p>( f1 ) ( U'0 0 )-1 ( f ) ( U'0 0 ) ( f1 ) ( f ) ( ) = ( ) ( ) => ( ) ( ) = ( ) ( g1 ) ( R' C') ( g ) ( R' C') ( g1 ) ( g )</p>
 * <p>from which it follows that:</p>
 * <p>{ U'0 * f1 = f f1 = inv(U'0) * f { => { R' * f1 + C' * g1 = g g1 = inv(C') * (g - R' * f1)</p>
 * <p>3. Solve the system</p>
 * <p>( f2 ) ( L'0 S')-1 ( f1 ) ( L'0 S') ( f2 ) ( f1 ) ( ) = ( ) ( ) => ( ) ( ) = ( ) ( g2 ) ( 0 I ) ( g1 ) ( 0 I ) ( g2 ) ( g1 )</p>
 * <p>from which it follows that:</p>
 * <p>{ L'0 * f2 + S' * g2 = f1 { => f2 = inv(L'0) * ( f1 - S' * g2) { g2 = g1</p>
 * <p>4. Compute</p>
 * <p>( x ) ( f2 ) ( ) = P ( ) ( y ) ( g2 ) </p>
 */
public";

%javamethodmodifiers enlarge_sva(LPF *lpf, int new_size) "
/**
 */
public";

%javamethodmodifiers lpf_update_it(LPF *lpf, int j, int bh, int len, const int ind[], const double val[]) "
/**
 * lpf_update_it - update LP basis factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplpf.h\" int lpf_update_it(LPF *lpf, int j, int bh, int len, const int ind[], const double val[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine lpf_update_it updates the factorization of the basis matrix B after replacing its j-th column by a new vector.</p>
 * <p>The parameter j specifies the number of column of B, which has been replaced, 1 <= j <= m, where m is the order of B.</p>
 * <p>The parameter bh specifies the basis header entry for the new column of B, which is the number of the new column in some original matrix. This parameter is optional and can be specified as 0.</p>
 * <p>Row indices and numerical values of non-zero elements of the new column of B should be placed in locations ind[1], ..., ind[len] and val[1], ..., val[len], resp., where len is the number of non-zeros in the column. Neither zero nor duplicate elements are allowed.</p>
 * <p>RETURNS</p>
 * <p>0 The factorization has been successfully updated.</p>
 * <p>LPF_ESING New basis B is singular within the working precision.</p>
 * <p>LPF_ELIMIT Maximal number of additional rows and columns has been reached.</p>
 * <p>BACKGROUND</p>
 * <p>Let j-th column of the current basis matrix B have to be replaced by a new column a. This replacement is equivalent to removing the old j-th column by fixing it at zero and introducing the new column as follows:</p>
 * <p>( B F^| a ) ( B F^) ( | ) ( ) ---> ( G^ H^| 0 ) ( G^ H^) (-------+---) ( e'j 0 | 0 )</p>
 * <p>where ej is a unit vector with 1 in j-th position which used to fix the old j-th column of B (at zero). Then using the main equality we have:</p>
 * <p>( B F^| a ) ( B0 F | f ) ( | ) ( P 0 ) ( | ) ( Q 0 ) ( G^ H^| 0 ) = ( ) ( G H | g ) ( ) = (-------+---) ( 0 1 ) (-------+---) ( 0 1 ) ( e'j 0 | 0 ) ( v' w'| 0 )</p>
 * <p>[ ( B0 F )| ( f ) ] [ ( B0 F ) | ( f ) ] [ P ( )| P ( ) ] ( Q 0 ) [ P ( ) Q| P ( ) ] = [ ( G H )| ( g ) ] ( ) = [ ( G H ) | ( g ) ] [------------+-------- ] ( 0 1 ) [-------------+---------] [ ( v' w')| 0 ] [ ( v' w') Q| 0 ]</p>
 * <p>where:</p>
 * <p>( a ) ( f ) ( f ) ( a ) ( ) = P ( ) => ( ) = P' * ( ) ( 0 ) ( g ) ( g ) ( 0 )</p>
 * <p>( ej ) ( v ) ( v ) ( ej ) ( e'j 0 ) = ( v' w' ) Q => ( ) = Q' ( ) => ( ) = Q ( ) ( 0 ) ( w ) ( w ) ( 0 )</p>
 * <p>On the other hand:</p>
 * <p>( B0| F f ) ( P 0 ) (---+------) ( Q 0 ) ( B0 new F ) ( ) ( G | H g ) ( ) = new P ( ) new Q ( 0 1 ) ( | ) ( 0 1 ) ( new G new H ) ( v'| w' 0 )</p>
 * <p>where: ( G ) ( H g ) new F = ( F f ), new G = ( ), new H = ( ), ( v') ( w' 0 )</p>
 * <p>( P 0 ) ( Q 0 ) new P = ( ) , new Q = ( ) . ( 0 1 ) ( 0 1 )</p>
 * <p>The factorization structure for the new augmented matrix remains the same, therefore:</p>
 * <p>( B0 new F ) ( L0 0 ) ( U0 new R ) new P ( ) new Q = ( ) ( ) ( new G new H ) ( new S I ) ( 0 new C )</p>
 * <p>where:</p>
 * <p>new F = L0 * new R =></p>
 * <p>new R = inv(L0) * new F = inv(L0) * (F f) = ( R inv(L0)*f )</p>
 * <p>new G = new S * U0 =></p>
 * <p>( G ) ( S ) new S = new G * inv(U0) = ( ) * inv(U0) = ( ) ( v') ( v'*inv(U0) )</p>
 * <p>new H = new S * new R + new C =></p>
 * <p>new C = new H - new S * new R =</p>
 * <p>( H g ) ( S ) = ( ) - ( ) * ( R inv(L0)*f ) = ( w' 0 ) ( v'*inv(U0) )</p>
 * <p>( H - S*R g - S*inv(L0)*f ) ( C x ) = ( ) = ( ) ( w'- v'*inv(U0)*R -v'*inv(U0)*inv(L0)*f) ( y' z )</p>
 * <p>Note that new C is resulted by expanding old C with new column x, row y', and diagonal element z, where:</p>
 * <p>x = g - S * inv(L0) * f = g - S * (new column of R)</p>
 * <p>y = w - R'* inv(U'0)* v = w - R'* (new row of S)</p>
 * <p>z = - (new row of S) * (new column of R)</p>
 * <p>Finally, to replace old B by new B we have to permute j-th and last (just added) columns of the matrix</p>
 * <p>( B F^| a ) ( | ) ( G^ H^| 0 ) (-------+---) ( e'j 0 | 0 )</p>
 * <p>and to keep the main equality do the same for matrix Q. </p>
 */
public";

%javamethodmodifiers lpf_delete_it(LPF *lpf) "
/**
 * lpf_delete_it - delete LP basis factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplpf.h\" void lpf_delete_it(LPF *lpf)</p>
 * <p>DESCRIPTION</p>
 * <p>The routine lpf_delete_it deletes LP basis factorization specified by the parameter lpf and frees all memory allocated to this program object. </p>
 */
public";

%javamethodmodifiers lpf_create_it(void) "
/**
 * lpf_create_it - create LP basis factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplpf.h\" LPF *lpf_create_it(void);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine lpf_create_it creates a program object, which represents a factorization of LP basis.</p>
 * <p>RETURNS</p>
 * <p>The routine lpf_create_it returns a pointer to the object created. </p>
 */
public";

%javamethodmodifiers lpf_factorize(LPF *lpf, int m, const int bh[], int(*col)(void *info, int j, int ind[], double val[]), void *info) "
/**
 * lpf_factorize - compute LP basis factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplpf.h\" int lpf_factorize(LPF *lpf, int m, const int bh[], int (*col) (void *info, int j, int ind[], double val[]), void *info);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine lpf_factorize computes the factorization of the basis matrix B specified by the routine col.</p>
 * <p>The parameter lpf specified the basis factorization data structure created with the routine lpf_create_it.</p>
 * <p>The parameter m specifies the order of B, m > 0.</p>
 * <p>The array bh specifies the basis header: bh[j], 1 <= j <= m, is the number of j-th column of B in some original matrix. The array bh is optional and can be specified as NULL.</p>
 * <p>The formal routine col specifies the matrix B to be factorized. To obtain j-th column of A the routine lpf_factorize calls the routine col with the parameter j (1 <= j <= n). In response the routine col should store row indices and numerical values of non-zero elements of j-th column of B to locations ind[1,...,len] and val[1,...,len], respectively, where len is the number of non-zeros in j-th column returned on exit. Neither zero nor duplicate elements are allowed.</p>
 * <p>The parameter info is a transit pointer passed to the routine col.</p>
 * <p>RETURNS</p>
 * <p>0 The factorization has been successfully computed.</p>
 * <p>LPF_ESING The specified matrix is singular within the working precision.</p>
 * <p>LPF_ECOND The specified matrix is ill-conditioned.</p>
 * <p>For more details see comments to the routine luf_factorize. </p>
 */
public";

%javamethodmodifiers lpf_ftran(LPF *lpf, double x[]) "
/**
 * lpf_ftran - perform forward transformation (solve system B*x = b) .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplpf.h\" void lpf_ftran(LPF *lpf, double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine lpf_ftran performs forward transformation, i.e. solves the system B*x = b, where B is the basis matrix, x is the vector of unknowns to be computed, b is the vector of right-hand sides.</p>
 * <p>On entry elements of the vector b should be stored in dense format in locations x[1], ..., x[m], where m is the number of rows. On exit the routine stores elements of the vector x in the same locations.</p>
 * <p>BACKGROUND</p>
 * <p>Solution of the system B * x = b can be obtained by solving the following augmented system:</p>
 * <p>( B F^) ( x ) ( b ) ( ) ( ) = ( ) ( G^ H^) ( y ) ( 0 )</p>
 * <p>which, using the main equality, can be written as follows:</p>
 * <p>( L0 0 ) ( U0 R ) ( x ) ( b ) P ( ) ( ) Q ( ) = ( ) ( S I ) ( 0 C ) ( y ) ( 0 )</p>
 * <p>therefore,</p>
 * <p>( x ) ( U0 R )-1 ( L0 0 )-1 ( b ) ( ) = Q' ( ) ( ) P' ( ) ( y ) ( 0 C ) ( S I ) ( 0 )</p>
 * <p>Thus, computing the solution includes the following steps:</p>
 * <p>1. Compute</p>
 * <p>( f ) ( b ) ( ) = P' ( ) ( g ) ( 0 )</p>
 * <p>2. Solve the system</p>
 * <p>( f1 ) ( L0 0 )-1 ( f ) ( L0 0 ) ( f1 ) ( f ) ( ) = ( ) ( ) => ( ) ( ) = ( ) ( g1 ) ( S I ) ( g ) ( S I ) ( g1 ) ( g )</p>
 * <p>from which it follows that:</p>
 * <p>{ L0 * f1 = f f1 = inv(L0) * f { => { S * f1 + g1 = g g1 = g - S * f1</p>
 * <p>3. Solve the system</p>
 * <p>( f2 ) ( U0 R )-1 ( f1 ) ( U0 R ) ( f2 ) ( f1 ) ( ) = ( ) ( ) => ( ) ( ) = ( ) ( g2 ) ( 0 C ) ( g1 ) ( 0 C ) ( g2 ) ( g1 )</p>
 * <p>from which it follows that:</p>
 * <p>{ U0 * f2 + R * g2 = f1 f2 = inv(U0) * (f1 - R * g2) { => { C * g2 = g1 g2 = inv(C) * g1</p>
 * <p>4. Compute</p>
 * <p>( x ) ( f2 ) ( ) = Q' ( ) ( y ) ( g2 ) </p>
 */
public";

%javamethodmodifiers lpf_btran(LPF *lpf, double x[]) "
/**
 * lpf_btran - perform backward transformation (solve system B'*x = b) .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplpf.h\" void lpf_btran(LPF *lpf, double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine lpf_btran performs backward transformation, i.e. solves the system B'*x = b, where B' is a matrix transposed to the basis matrix B, x is the vector of unknowns to be computed, b is the vector of right-hand sides.</p>
 * <p>On entry elements of the vector b should be stored in dense format in locations x[1], ..., x[m], where m is the number of rows. On exit the routine stores elements of the vector x in the same locations.</p>
 * <p>BACKGROUND</p>
 * <p>Solution of the system B' * x = b, where B' is a matrix transposed to B, can be obtained by solving the following augmented system:</p>
 * <p>( B F^)T ( x ) ( b ) ( ) ( ) = ( ) ( G^ H^) ( y ) ( 0 )</p>
 * <p>which, using the main equality, can be written as follows:</p>
 * <p>T ( U0 R )T ( L0 0 )T T ( x ) ( b ) Q ( ) ( ) P ( ) = ( ) ( 0 C ) ( S I ) ( y ) ( 0 )</p>
 * <p>or, equivalently, as follows:</p>
 * <p>( U'0 0 ) ( L'0 S') ( x ) ( b ) Q' ( ) ( ) P' ( ) = ( ) ( R' C') ( 0 I ) ( y ) ( 0 )</p>
 * <p>therefore,</p>
 * <p>( x ) ( L'0 S')-1 ( U'0 0 )-1 ( b ) ( ) = P ( ) ( ) Q ( ) ( y ) ( 0 I ) ( R' C') ( 0 )</p>
 * <p>Thus, computing the solution includes the following steps:</p>
 * <p>1. Compute</p>
 * <p>( f ) ( b ) ( ) = Q ( ) ( g ) ( 0 )</p>
 * <p>2. Solve the system</p>
 * <p>( f1 ) ( U'0 0 )-1 ( f ) ( U'0 0 ) ( f1 ) ( f ) ( ) = ( ) ( ) => ( ) ( ) = ( ) ( g1 ) ( R' C') ( g ) ( R' C') ( g1 ) ( g )</p>
 * <p>from which it follows that:</p>
 * <p>{ U'0 * f1 = f f1 = inv(U'0) * f { => { R' * f1 + C' * g1 = g g1 = inv(C') * (g - R' * f1)</p>
 * <p>3. Solve the system</p>
 * <p>( f2 ) ( L'0 S')-1 ( f1 ) ( L'0 S') ( f2 ) ( f1 ) ( ) = ( ) ( ) => ( ) ( ) = ( ) ( g2 ) ( 0 I ) ( g1 ) ( 0 I ) ( g2 ) ( g1 )</p>
 * <p>from which it follows that:</p>
 * <p>{ L'0 * f2 + S' * g2 = f1 { => f2 = inv(L'0) * ( f1 - S' * g2) { g2 = g1</p>
 * <p>4. Compute</p>
 * <p>( x ) ( f2 ) ( ) = P ( ) ( y ) ( g2 ) </p>
 */
public";

%javamethodmodifiers lpf_update_it(LPF *lpf, int j, int bh, int len, const int ind[], const double val[]) "
/**
 * lpf_update_it - update LP basis factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplpf.h\" int lpf_update_it(LPF *lpf, int j, int bh, int len, const int ind[], const double val[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine lpf_update_it updates the factorization of the basis matrix B after replacing its j-th column by a new vector.</p>
 * <p>The parameter j specifies the number of column of B, which has been replaced, 1 <= j <= m, where m is the order of B.</p>
 * <p>The parameter bh specifies the basis header entry for the new column of B, which is the number of the new column in some original matrix. This parameter is optional and can be specified as 0.</p>
 * <p>Row indices and numerical values of non-zero elements of the new column of B should be placed in locations ind[1], ..., ind[len] and val[1], ..., val[len], resp., where len is the number of non-zeros in the column. Neither zero nor duplicate elements are allowed.</p>
 * <p>RETURNS</p>
 * <p>0 The factorization has been successfully updated.</p>
 * <p>LPF_ESING New basis B is singular within the working precision.</p>
 * <p>LPF_ELIMIT Maximal number of additional rows and columns has been reached.</p>
 * <p>BACKGROUND</p>
 * <p>Let j-th column of the current basis matrix B have to be replaced by a new column a. This replacement is equivalent to removing the old j-th column by fixing it at zero and introducing the new column as follows:</p>
 * <p>( B F^| a ) ( B F^) ( | ) ( ) ---> ( G^ H^| 0 ) ( G^ H^) (-------+---) ( e'j 0 | 0 )</p>
 * <p>where ej is a unit vector with 1 in j-th position which used to fix the old j-th column of B (at zero). Then using the main equality we have:</p>
 * <p>( B F^| a ) ( B0 F | f ) ( | ) ( P 0 ) ( | ) ( Q 0 ) ( G^ H^| 0 ) = ( ) ( G H | g ) ( ) = (-------+---) ( 0 1 ) (-------+---) ( 0 1 ) ( e'j 0 | 0 ) ( v' w'| 0 )</p>
 * <p>[ ( B0 F )| ( f ) ] [ ( B0 F ) | ( f ) ] [ P ( )| P ( ) ] ( Q 0 ) [ P ( ) Q| P ( ) ] = [ ( G H )| ( g ) ] ( ) = [ ( G H ) | ( g ) ] [------------+-------- ] ( 0 1 ) [-------------+---------] [ ( v' w')| 0 ] [ ( v' w') Q| 0 ]</p>
 * <p>where:</p>
 * <p>( a ) ( f ) ( f ) ( a ) ( ) = P ( ) => ( ) = P' * ( ) ( 0 ) ( g ) ( g ) ( 0 )</p>
 * <p>( ej ) ( v ) ( v ) ( ej ) ( e'j 0 ) = ( v' w' ) Q => ( ) = Q' ( ) => ( ) = Q ( ) ( 0 ) ( w ) ( w ) ( 0 )</p>
 * <p>On the other hand:</p>
 * <p>( B0| F f ) ( P 0 ) (---+------) ( Q 0 ) ( B0 new F ) ( ) ( G | H g ) ( ) = new P ( ) new Q ( 0 1 ) ( | ) ( 0 1 ) ( new G new H ) ( v'| w' 0 )</p>
 * <p>where: ( G ) ( H g ) new F = ( F f ), new G = ( ), new H = ( ), ( v') ( w' 0 )</p>
 * <p>( P 0 ) ( Q 0 ) new P = ( ) , new Q = ( ) . ( 0 1 ) ( 0 1 )</p>
 * <p>The factorization structure for the new augmented matrix remains the same, therefore:</p>
 * <p>( B0 new F ) ( L0 0 ) ( U0 new R ) new P ( ) new Q = ( ) ( ) ( new G new H ) ( new S I ) ( 0 new C )</p>
 * <p>where:</p>
 * <p>new F = L0 * new R =></p>
 * <p>new R = inv(L0) * new F = inv(L0) * (F f) = ( R inv(L0)*f )</p>
 * <p>new G = new S * U0 =></p>
 * <p>( G ) ( S ) new S = new G * inv(U0) = ( ) * inv(U0) = ( ) ( v') ( v'*inv(U0) )</p>
 * <p>new H = new S * new R + new C =></p>
 * <p>new C = new H - new S * new R =</p>
 * <p>( H g ) ( S ) = ( ) - ( ) * ( R inv(L0)*f ) = ( w' 0 ) ( v'*inv(U0) )</p>
 * <p>( H - S*R g - S*inv(L0)*f ) ( C x ) = ( ) = ( ) ( w'- v'*inv(U0)*R -v'*inv(U0)*inv(L0)*f) ( y' z )</p>
 * <p>Note that new C is resulted by expanding old C with new column x, row y', and diagonal element z, where:</p>
 * <p>x = g - S * inv(L0) * f = g - S * (new column of R)</p>
 * <p>y = w - R'* inv(U'0)* v = w - R'* (new row of S)</p>
 * <p>z = - (new row of S) * (new column of R)</p>
 * <p>Finally, to replace old B by new B we have to permute j-th and last (just added) columns of the matrix</p>
 * <p>( B F^| a ) ( | ) ( G^ H^| 0 ) (-------+---) ( e'j 0 | 0 )</p>
 * <p>and to keep the main equality do the same for matrix Q. </p>
 */
public";

%javamethodmodifiers lpf_delete_it(LPF *lpf) "
/**
 * lpf_delete_it - delete LP basis factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glplpf.h\" void lpf_delete_it(LPF *lpf)</p>
 * <p>DESCRIPTION</p>
 * <p>The routine lpf_delete_it deletes LP basis factorization specified by the parameter lpf and frees all memory allocated to this program object. </p>
 */
public";

%javamethodmodifiers lpx_create_prob(void) "
/**
 */
public";

%javamethodmodifiers lpx_set_prob_name(LPX *lp, const char *name) "
/**
 */
public";

%javamethodmodifiers lpx_set_obj_name(LPX *lp, const char *name) "
/**
 */
public";

%javamethodmodifiers lpx_set_obj_dir(LPX *lp, int dir) "
/**
 */
public";

%javamethodmodifiers lpx_add_rows(LPX *lp, int nrs) "
/**
 */
public";

%javamethodmodifiers lpx_add_cols(LPX *lp, int ncs) "
/**
 */
public";

%javamethodmodifiers lpx_set_row_name(LPX *lp, int i, const char *name) "
/**
 */
public";

%javamethodmodifiers lpx_set_col_name(LPX *lp, int j, const char *name) "
/**
 */
public";

%javamethodmodifiers lpx_set_row_bnds(LPX *lp, int i, int type, double lb, double ub) "
/**
 */
public";

%javamethodmodifiers lpx_set_col_bnds(LPX *lp, int j, int type, double lb, double ub) "
/**
 */
public";

%javamethodmodifiers lpx_set_obj_coef(glp_prob *lp, int j, double coef) "
/**
 */
public";

%javamethodmodifiers lpx_set_mat_row(LPX *lp, int i, int len, const int ind[], const double val[]) "
/**
 */
public";

%javamethodmodifiers lpx_set_mat_col(LPX *lp, int j, int len, const int ind[], const double val[]) "
/**
 */
public";

%javamethodmodifiers lpx_load_matrix(LPX *lp, int ne, const int ia[], const int ja[], const double ar[]) "
/**
 */
public";

%javamethodmodifiers lpx_del_rows(LPX *lp, int nrs, const int num[]) "
/**
 */
public";

%javamethodmodifiers lpx_del_cols(LPX *lp, int ncs, const int num[]) "
/**
 */
public";

%javamethodmodifiers lpx_delete_prob(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_get_prob_name(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_get_obj_name(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_get_obj_dir(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_get_num_rows(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_get_num_cols(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_get_row_name(LPX *lp, int i) "
/**
 */
public";

%javamethodmodifiers lpx_get_col_name(LPX *lp, int j) "
/**
 */
public";

%javamethodmodifiers lpx_get_row_type(LPX *lp, int i) "
/**
 */
public";

%javamethodmodifiers lpx_get_row_lb(LPX *lp, int i) "
/**
 */
public";

%javamethodmodifiers lpx_get_row_ub(LPX *lp, int i) "
/**
 */
public";

%javamethodmodifiers lpx_get_row_bnds(LPX *lp, int i, int *typx, double *lb, double *ub) "
/**
 */
public";

%javamethodmodifiers lpx_get_col_type(LPX *lp, int j) "
/**
 */
public";

%javamethodmodifiers lpx_get_col_lb(LPX *lp, int j) "
/**
 */
public";

%javamethodmodifiers lpx_get_col_ub(LPX *lp, int j) "
/**
 */
public";

%javamethodmodifiers lpx_get_col_bnds(LPX *lp, int j, int *typx, double *lb, double *ub) "
/**
 */
public";

%javamethodmodifiers lpx_get_obj_coef(LPX *lp, int j) "
/**
 */
public";

%javamethodmodifiers lpx_get_num_nz(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_get_mat_row(LPX *lp, int i, int ind[], double val[]) "
/**
 */
public";

%javamethodmodifiers lpx_get_mat_col(LPX *lp, int j, int ind[], double val[]) "
/**
 */
public";

%javamethodmodifiers lpx_create_index(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_find_row(LPX *lp, const char *name) "
/**
 */
public";

%javamethodmodifiers lpx_find_col(LPX *lp, const char *name) "
/**
 */
public";

%javamethodmodifiers lpx_delete_index(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_scale_prob(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_unscale_prob(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_set_row_stat(LPX *lp, int i, int stat) "
/**
 */
public";

%javamethodmodifiers lpx_set_col_stat(LPX *lp, int j, int stat) "
/**
 */
public";

%javamethodmodifiers lpx_std_basis(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_adv_basis(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_cpx_basis(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_simplex(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_exact(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_get_status(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_get_prim_stat(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_get_dual_stat(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_get_obj_val(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_get_row_stat(LPX *lp, int i) "
/**
 */
public";

%javamethodmodifiers lpx_get_row_prim(LPX *lp, int i) "
/**
 */
public";

%javamethodmodifiers lpx_get_row_dual(LPX *lp, int i) "
/**
 */
public";

%javamethodmodifiers lpx_get_row_info(LPX *lp, int i, int *tagx, double *vx, double *dx) "
/**
 */
public";

%javamethodmodifiers lpx_get_col_stat(LPX *lp, int j) "
/**
 */
public";

%javamethodmodifiers lpx_get_col_prim(LPX *lp, int j) "
/**
 */
public";

%javamethodmodifiers lpx_get_col_dual(glp_prob *lp, int j) "
/**
 */
public";

%javamethodmodifiers lpx_get_col_info(LPX *lp, int j, int *tagx, double *vx, double *dx) "
/**
 */
public";

%javamethodmodifiers lpx_get_ray_info(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_check_kkt(LPX *lp, int scaled, LPXKKT *kkt) "
/**
 */
public";

%javamethodmodifiers lpx_warm_up(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_eval_tab_row(LPX *lp, int k, int ind[], double val[]) "
/**
 */
public";

%javamethodmodifiers lpx_eval_tab_col(LPX *lp, int k, int ind[], double val[]) "
/**
 */
public";

%javamethodmodifiers lpx_transform_row(LPX *lp, int len, int ind[], double val[]) "
/**
 */
public";

%javamethodmodifiers lpx_transform_col(LPX *lp, int len, int ind[], double val[]) "
/**
 */
public";

%javamethodmodifiers lpx_prim_ratio_test(LPX *lp, int len, const int ind[], const double val[], int how, double tol) "
/**
 */
public";

%javamethodmodifiers lpx_dual_ratio_test(LPX *lp, int len, const int ind[], const double val[], int how, double tol) "
/**
 */
public";

%javamethodmodifiers lpx_interior(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_ipt_status(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_ipt_obj_val(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_ipt_row_prim(LPX *lp, int i) "
/**
 */
public";

%javamethodmodifiers lpx_ipt_row_dual(LPX *lp, int i) "
/**
 */
public";

%javamethodmodifiers lpx_ipt_col_prim(LPX *lp, int j) "
/**
 */
public";

%javamethodmodifiers lpx_ipt_col_dual(LPX *lp, int j) "
/**
 */
public";

%javamethodmodifiers lpx_set_class(LPX *lp, int klass) "
/**
 */
public";

%javamethodmodifiers lpx_get_class(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_set_col_kind(LPX *lp, int j, int kind) "
/**
 */
public";

%javamethodmodifiers lpx_get_col_kind(LPX *lp, int j) "
/**
 */
public";

%javamethodmodifiers lpx_get_num_int(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_get_num_bin(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_integer(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_intopt(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_mip_status(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_mip_obj_val(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_mip_row_val(LPX *lp, int i) "
/**
 */
public";

%javamethodmodifiers lpx_mip_col_val(LPX *lp, int j) "
/**
 */
public";

%javamethodmodifiers lpx_check_int(LPX *lp, LPXKKT *kkt) "
/**
 */
public";

%javamethodmodifiers lpx_reset_parms(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_set_int_parm(LPX *lp, int parm, int val) "
/**
 */
public";

%javamethodmodifiers lpx_get_int_parm(LPX *lp, int parm) "
/**
 */
public";

%javamethodmodifiers lpx_set_real_parm(LPX *lp, int parm, double val) "
/**
 */
public";

%javamethodmodifiers lpx_get_real_parm(LPX *lp, int parm) "
/**
 */
public";

%javamethodmodifiers lpx_read_mps(const char *fname) "
/**
 */
public";

%javamethodmodifiers lpx_write_mps(LPX *lp, const char *fname) "
/**
 */
public";

%javamethodmodifiers lpx_read_bas(LPX *lp, const char *fname) "
/**
 */
public";

%javamethodmodifiers lpx_write_bas(LPX *lp, const char *fname) "
/**
 */
public";

%javamethodmodifiers lpx_read_freemps(const char *fname) "
/**
 */
public";

%javamethodmodifiers lpx_write_freemps(LPX *lp, const char *fname) "
/**
 */
public";

%javamethodmodifiers lpx_read_cpxlp(const char *fname) "
/**
 */
public";

%javamethodmodifiers lpx_write_cpxlp(LPX *lp, const char *fname) "
/**
 */
public";

%javamethodmodifiers lpx_read_model(const char *model, const char *data, const char *output) "
/**
 */
public";

%javamethodmodifiers lpx_print_prob(LPX *lp, const char *fname) "
/**
 */
public";

%javamethodmodifiers lpx_print_sol(LPX *lp, const char *fname) "
/**
 */
public";

%javamethodmodifiers lpx_print_sens_bnds(LPX *lp, const char *fname) "
/**
 */
public";

%javamethodmodifiers lpx_print_ips(LPX *lp, const char *fname) "
/**
 */
public";

%javamethodmodifiers lpx_print_mip(LPX *lp, const char *fname) "
/**
 */
public";

%javamethodmodifiers lpx_is_b_avail(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_write_pb(LPX *lp, const char *fname, int normalized, int binarize) "
/**
 */
public";

%javamethodmodifiers lpx_main(int argc, const char *argv[]) "
/**
 */
public";

%javamethodmodifiers lpx_create_prob(void) "
/**
 */
public";

%javamethodmodifiers lpx_set_prob_name(LPX *lp, const char *name) "
/**
 */
public";

%javamethodmodifiers lpx_set_obj_name(LPX *lp, const char *name) "
/**
 */
public";

%javamethodmodifiers lpx_set_obj_dir(LPX *lp, int dir) "
/**
 */
public";

%javamethodmodifiers lpx_add_rows(LPX *lp, int nrs) "
/**
 */
public";

%javamethodmodifiers lpx_add_cols(LPX *lp, int ncs) "
/**
 */
public";

%javamethodmodifiers lpx_set_row_name(LPX *lp, int i, const char *name) "
/**
 */
public";

%javamethodmodifiers lpx_set_col_name(LPX *lp, int j, const char *name) "
/**
 */
public";

%javamethodmodifiers lpx_set_row_bnds(LPX *lp, int i, int type, double lb, double ub) "
/**
 */
public";

%javamethodmodifiers lpx_set_col_bnds(LPX *lp, int j, int type, double lb, double ub) "
/**
 */
public";

%javamethodmodifiers lpx_set_obj_coef(glp_prob *lp, int j, double coef) "
/**
 */
public";

%javamethodmodifiers lpx_set_mat_row(LPX *lp, int i, int len, const int ind[], const double val[]) "
/**
 */
public";

%javamethodmodifiers lpx_set_mat_col(LPX *lp, int j, int len, const int ind[], const double val[]) "
/**
 */
public";

%javamethodmodifiers lpx_load_matrix(LPX *lp, int ne, const int ia[], const int ja[], const double ar[]) "
/**
 */
public";

%javamethodmodifiers lpx_del_rows(LPX *lp, int nrs, const int num[]) "
/**
 */
public";

%javamethodmodifiers lpx_del_cols(LPX *lp, int ncs, const int num[]) "
/**
 */
public";

%javamethodmodifiers lpx_delete_prob(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_get_prob_name(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_get_obj_name(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_get_obj_dir(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_get_num_rows(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_get_num_cols(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_get_row_name(LPX *lp, int i) "
/**
 */
public";

%javamethodmodifiers lpx_get_col_name(LPX *lp, int j) "
/**
 */
public";

%javamethodmodifiers lpx_get_row_type(LPX *lp, int i) "
/**
 */
public";

%javamethodmodifiers lpx_get_row_lb(glp_prob *lp, int i) "
/**
 */
public";

%javamethodmodifiers lpx_get_row_ub(glp_prob *lp, int i) "
/**
 */
public";

%javamethodmodifiers lpx_get_row_bnds(glp_prob *lp, int i, int *typx, double *lb, double *ub) "
/**
 */
public";

%javamethodmodifiers lpx_get_col_type(LPX *lp, int j) "
/**
 */
public";

%javamethodmodifiers lpx_get_col_lb(glp_prob *lp, int j) "
/**
 */
public";

%javamethodmodifiers lpx_get_col_ub(glp_prob *lp, int j) "
/**
 */
public";

%javamethodmodifiers lpx_get_col_bnds(glp_prob *lp, int j, int *typx, double *lb, double *ub) "
/**
 */
public";

%javamethodmodifiers lpx_get_obj_coef(LPX *lp, int j) "
/**
 */
public";

%javamethodmodifiers lpx_get_num_nz(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_get_mat_row(LPX *lp, int i, int ind[], double val[]) "
/**
 */
public";

%javamethodmodifiers lpx_get_mat_col(LPX *lp, int j, int ind[], double val[]) "
/**
 */
public";

%javamethodmodifiers lpx_create_index(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_find_row(LPX *lp, const char *name) "
/**
 */
public";

%javamethodmodifiers lpx_find_col(LPX *lp, const char *name) "
/**
 */
public";

%javamethodmodifiers lpx_delete_index(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_scale_prob(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_unscale_prob(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_set_row_stat(LPX *lp, int i, int stat) "
/**
 */
public";

%javamethodmodifiers lpx_set_col_stat(LPX *lp, int j, int stat) "
/**
 */
public";

%javamethodmodifiers lpx_std_basis(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_adv_basis(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_cpx_basis(LPX *lp) "
/**
 */
public";

%javamethodmodifiers fill_smcp(LPX *lp, glp_smcp *parm) "
/**
 */
public";

%javamethodmodifiers lpx_simplex(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_exact(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_get_status(glp_prob *lp) "
/**
 */
public";

%javamethodmodifiers lpx_get_prim_stat(glp_prob *lp) "
/**
 */
public";

%javamethodmodifiers lpx_get_dual_stat(glp_prob *lp) "
/**
 */
public";

%javamethodmodifiers lpx_get_obj_val(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_get_row_stat(LPX *lp, int i) "
/**
 */
public";

%javamethodmodifiers lpx_get_row_prim(LPX *lp, int i) "
/**
 */
public";

%javamethodmodifiers lpx_get_row_dual(LPX *lp, int i) "
/**
 */
public";

%javamethodmodifiers lpx_get_row_info(glp_prob *lp, int i, int *tagx, double *vx, double *dx) "
/**
 */
public";

%javamethodmodifiers lpx_get_col_stat(LPX *lp, int j) "
/**
 */
public";

%javamethodmodifiers lpx_get_col_prim(LPX *lp, int j) "
/**
 */
public";

%javamethodmodifiers lpx_get_col_dual(glp_prob *lp, int j) "
/**
 */
public";

%javamethodmodifiers lpx_get_col_info(glp_prob *lp, int j, int *tagx, double *vx, double *dx) "
/**
 */
public";

%javamethodmodifiers lpx_get_ray_info(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_check_kkt(LPX *lp, int scaled, LPXKKT *kkt) "
/**
 */
public";

%javamethodmodifiers lpx_warm_up(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_eval_tab_row(LPX *lp, int k, int ind[], double val[]) "
/**
 */
public";

%javamethodmodifiers lpx_eval_tab_col(LPX *lp, int k, int ind[], double val[]) "
/**
 */
public";

%javamethodmodifiers lpx_transform_row(LPX *lp, int len, int ind[], double val[]) "
/**
 */
public";

%javamethodmodifiers lpx_transform_col(LPX *lp, int len, int ind[], double val[]) "
/**
 */
public";

%javamethodmodifiers lpx_prim_ratio_test(LPX *lp, int len, const int ind[], const double val[], int how, double tol) "
/**
 */
public";

%javamethodmodifiers lpx_dual_ratio_test(LPX *lp, int len, const int ind[], const double val[], int how, double tol) "
/**
 */
public";

%javamethodmodifiers lpx_interior(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_ipt_status(glp_prob *lp) "
/**
 */
public";

%javamethodmodifiers lpx_ipt_obj_val(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_ipt_row_prim(LPX *lp, int i) "
/**
 */
public";

%javamethodmodifiers lpx_ipt_row_dual(LPX *lp, int i) "
/**
 */
public";

%javamethodmodifiers lpx_ipt_col_prim(LPX *lp, int j) "
/**
 */
public";

%javamethodmodifiers lpx_ipt_col_dual(LPX *lp, int j) "
/**
 */
public";

%javamethodmodifiers lpx_set_class(LPX *lp, int klass) "
/**
 */
public";

%javamethodmodifiers lpx_get_class(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_set_col_kind(LPX *lp, int j, int kind) "
/**
 */
public";

%javamethodmodifiers lpx_get_col_kind(LPX *lp, int j) "
/**
 */
public";

%javamethodmodifiers lpx_get_num_int(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_get_num_bin(LPX *lp) "
/**
 */
public";

%javamethodmodifiers solve_mip(LPX *lp, int presolve) "
/**
 */
public";

%javamethodmodifiers lpx_integer(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_intopt(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_mip_status(glp_prob *lp) "
/**
 */
public";

%javamethodmodifiers lpx_mip_obj_val(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_mip_row_val(LPX *lp, int i) "
/**
 */
public";

%javamethodmodifiers lpx_mip_col_val(LPX *lp, int j) "
/**
 */
public";

%javamethodmodifiers lpx_check_int(LPX *lp, LPXKKT *kkt) "
/**
 */
public";

%javamethodmodifiers reset_parms(LPX *lp) "
/**
 */
public";

%javamethodmodifiers access_parms(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_reset_parms(LPX *lp) "
/**
 */
public";

%javamethodmodifiers lpx_set_int_parm(LPX *lp, int parm, int val) "
/**
 */
public";

%javamethodmodifiers lpx_get_int_parm(LPX *lp, int parm) "
/**
 */
public";

%javamethodmodifiers lpx_set_real_parm(LPX *lp, int parm, double val) "
/**
 */
public";

%javamethodmodifiers lpx_get_real_parm(LPX *lp, int parm) "
/**
 */
public";

%javamethodmodifiers lpx_read_mps(const char *fname) "
/**
 */
public";

%javamethodmodifiers lpx_write_mps(LPX *lp, const char *fname) "
/**
 */
public";

%javamethodmodifiers lpx_read_bas(LPX *lp, const char *fname) "
/**
 */
public";

%javamethodmodifiers lpx_write_bas(LPX *lp, const char *fname) "
/**
 */
public";

%javamethodmodifiers lpx_read_freemps(const char *fname) "
/**
 */
public";

%javamethodmodifiers lpx_write_freemps(LPX *lp, const char *fname) "
/**
 */
public";

%javamethodmodifiers lpx_read_cpxlp(const char *fname) "
/**
 */
public";

%javamethodmodifiers lpx_write_cpxlp(LPX *lp, const char *fname) "
/**
 */
public";

%javamethodmodifiers lpx_read_model(const char *model, const char *data, const char *output) "
/**
 */
public";

%javamethodmodifiers lpx_print_prob(LPX *lp, const char *fname) "
/**
 */
public";

%javamethodmodifiers lpx_print_sol(LPX *lp, const char *fname) "
/**
 */
public";

%javamethodmodifiers lpx_print_sens_bnds(LPX *lp, const char *fname) "
/**
 */
public";

%javamethodmodifiers lpx_print_ips(LPX *lp, const char *fname) "
/**
 */
public";

%javamethodmodifiers lpx_print_mip(LPX *lp, const char *fname) "
/**
 */
public";

%javamethodmodifiers lpx_is_b_avail(glp_prob *lp) "
/**
 */
public";

%javamethodmodifiers lpx_main(int argc, const char *argv[]) "
/**
 */
public";

%javamethodmodifiers lpx_put_solution(glp_prob *lp, int inval, const int *p_stat, const int *d_stat, const double *obj_val, const int r_stat[], const double r_prim[], const double r_dual[], const int c_stat[], const double c_prim[], const double c_dual[]) "
/**
 * lpx_put_solution - store basic solution components .
 * <p>SYNOPSIS</p>
 * <p>void lpx_put_solution(glp_prob *lp, int inval, const int *p_stat, const int *d_stat, const double *obj_val, const int r_stat[], const double r_prim[], const double r_dual[], const int c_stat[], const double c_prim[], const double c_dual[])</p>
 * <p>DESCRIPTION</p>
 * <p>The routine lpx_put_solution stores basic solution components to the specified problem object.</p>
 * <p>The parameter inval is the basis factorization invalidity flag. If this flag is clear, the current status of the basis factorization remains unchanged. If this flag is set, the routine invalidates the basis factorization.</p>
 * <p>The parameter p_stat is a pointer to the status of primal basic solution, which should be specified as follows:</p>
 * <p>GLP_UNDEF - primal solution is undefined; GLP_FEAS - primal solution is feasible; GLP_INFEAS - primal solution is infeasible; GLP_NOFEAS - no primal feasible solution exists.</p>
 * <p>If the parameter p_stat is NULL, the current status of primal basic solution remains unchanged.</p>
 * <p>The parameter d_stat is a pointer to the status of dual basic solution, which should be specified as follows:</p>
 * <p>GLP_UNDEF - dual solution is undefined; GLP_FEAS - dual solution is feasible; GLP_INFEAS - dual solution is infeasible; GLP_NOFEAS - no dual feasible solution exists.</p>
 * <p>If the parameter d_stat is NULL, the current status of dual basic solution remains unchanged.</p>
 * <p>The parameter obj_val is a pointer to the objective function value. If it is NULL, the current value of the objective function remains unchanged.</p>
 * <p>The array element r_stat[i], 1 <= i <= m (where m is the number of rows in the problem object), specifies the status of i-th auxiliary variable, which should be specified as follows:</p>
 * <p>GLP_BS - basic variable; GLP_NL - non-basic variable on lower bound; GLP_NU - non-basic variable on upper bound; GLP_NF - non-basic free variable; GLP_NS - non-basic fixed variable.</p>
 * <p>If the parameter r_stat is NULL, the current statuses of auxiliary variables remain unchanged.</p>
 * <p>The array element r_prim[i], 1 <= i <= m (where m is the number of rows in the problem object), specifies a primal value of i-th auxiliary variable. If the parameter r_prim is NULL, the current primal values of auxiliary variables remain unchanged.</p>
 * <p>The array element r_dual[i], 1 <= i <= m (where m is the number of rows in the problem object), specifies a dual value (reduced cost) of i-th auxiliary variable. If the parameter r_dual is NULL, the current dual values of auxiliary variables remain unchanged.</p>
 * <p>The array element c_stat[j], 1 <= j <= n (where n is the number of columns in the problem object), specifies the status of j-th structural variable, which should be specified as follows:</p>
 * <p>GLP_BS - basic variable; GLP_NL - non-basic variable on lower bound; GLP_NU - non-basic variable on upper bound; GLP_NF - non-basic free variable; GLP_NS - non-basic fixed variable.</p>
 * <p>If the parameter c_stat is NULL, the current statuses of structural variables remain unchanged.</p>
 * <p>The array element c_prim[j], 1 <= j <= n (where n is the number of columns in the problem object), specifies a primal value of j-th structural variable. If the parameter c_prim is NULL, the current primal values of structural variables remain unchanged.</p>
 * <p>The array element c_dual[j], 1 <= j <= n (where n is the number of columns in the problem object), specifies a dual value (reduced cost) of j-th structural variable. If the parameter c_dual is NULL, the current dual values of structural variables remain unchanged. </p>
 */
public";

%javamethodmodifiers lpx_put_mip_soln(glp_prob *lp, int i_stat, double row_mipx[], double col_mipx[]) "
/**
 */
public";

%javamethodmodifiers lpx_write_pb(LPX *lp, const char *fname, int normalized, int binarize) "
/**
 */
public";

%javamethodmodifiers luf_create_it(void) "
/**
 * luf_create_it - create LU-factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpluf.h\" LUF *luf_create_it(void);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine luf_create_it creates a program object, which represents LU-factorization of a square matrix.</p>
 * <p>RETURNS</p>
 * <p>The routine luf_create_it returns a pointer to the object created. </p>
 */
public";

%javamethodmodifiers luf_defrag_sva(LUF *luf) "
/**
 * luf_defrag_sva - defragment the sparse vector area .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpluf.h\" void luf_defrag_sva(LUF *luf);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine luf_defrag_sva defragments the sparse vector area (SVA) gathering all unused locations in one continuous extent. In order to do that the routine moves all unused locations from the left part of SVA (which contains rows and columns of the matrix V) to the middle part (which contains free locations). This is attained by relocating elements of rows and columns of the matrix V toward the beginning of the left part.</p>
 * <p>NOTE that this \"garbage collection\" involves changing row and column pointers of the matrix V. </p>
 */
public";

%javamethodmodifiers luf_enlarge_row(LUF *luf, int i, int cap) "
/**
 * luf_enlarge_row - enlarge row capacity .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpluf.h\" int luf_enlarge_row(LUF *luf, int i, int cap);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine luf_enlarge_row enlarges capacity of the i-th row of the matrix V to cap locations (assuming that its current capacity is less than cap). In order to do that the routine relocates elements of the i-th row to the end of the left part of SVA (which contains rows and columns of the matrix V) and then expands the left part by allocating cap free locations from the free part. If there are less than cap free locations, the routine defragments the sparse vector area.</p>
 * <p>Due to \"garbage collection\" this operation may change row and column pointers of the matrix V.</p>
 * <p>RETURNS</p>
 * <p>If no error occured, the routine returns zero. Otherwise, in case of overflow of the sparse vector area, the routine returns non-zero. </p>
 */
public";

%javamethodmodifiers luf_enlarge_col(LUF *luf, int j, int cap) "
/**
 * luf_enlarge_col - enlarge column capacity .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpluf.h\" int luf_enlarge_col(LUF *luf, int j, int cap);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine luf_enlarge_col enlarges capacity of the j-th column of the matrix V to cap locations (assuming that its current capacity is less than cap). In order to do that the routine relocates elements of the j-th column to the end of the left part of SVA (which contains rows and columns of the matrix V) and then expands the left part by allocating cap free locations from the free part. If there are less than cap free locations, the routine defragments the sparse vector area.</p>
 * <p>Due to \"garbage collection\" this operation may change row and column pointers of the matrix V.</p>
 * <p>RETURNS</p>
 * <p>If no error occured, the routine returns zero. Otherwise, in case of overflow of the sparse vector area, the routine returns non-zero. </p>
 */
public";

%javamethodmodifiers reallocate(LUF *luf, int n) "
/**
 */
public";

%javamethodmodifiers initialize(LUF *luf, int(*col)(void *info, int j, int rn[], double aj[]), void *info) "
/**
 */
public";

%javamethodmodifiers find_pivot(LUF *luf, int *_p, int *_q) "
/**
 */
public";

%javamethodmodifiers eliminate(LUF *luf, int p, int q) "
/**
 */
public";

%javamethodmodifiers build_v_cols(LUF *luf) "
/**
 */
public";

%javamethodmodifiers build_f_rows(LUF *luf) "
/**
 */
public";

%javamethodmodifiers luf_factorize(LUF *luf, int n, int(*col)(void *info, int j, int ind[], double val[]), void *info) "
/**
 * luf_factorize - compute LU-factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpluf.h\" int luf_factorize(LUF *luf, int n, int (*col)(void *info, int j, int ind[], double val[]), void *info);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine luf_factorize computes LU-factorization of a specified square matrix A.</p>
 * <p>The parameter luf specifies LU-factorization program object created by the routine luf_create_it.</p>
 * <p>The parameter n specifies the order of A, n > 0.</p>
 * <p>The formal routine col specifies the matrix A to be factorized. To obtain j-th column of A the routine luf_factorize calls the routine col with the parameter j (1 <= j <= n). In response the routine col should store row indices and numerical values of non-zero elements of j-th column of A to locations ind[1,...,len] and val[1,...,len], respectively, where len is the number of non-zeros in j-th column returned on exit. Neither zero nor duplicate elements are allowed.</p>
 * <p>The parameter info is a transit pointer passed to the routine col.</p>
 * <p>RETURNS</p>
 * <p>0 LU-factorization has been successfully computed.</p>
 * <p>LUF_ESING The specified matrix is singular within the working precision. (On some elimination step the active submatrix is exactly zero, so no pivot can be chosen.)</p>
 * <p>LUF_ECOND The specified matrix is ill-conditioned. (On some elimination step too intensive growth of elements of the active submatix has been detected.)</p>
 * <p>If matrix A is well scaled, the return code LUF_ECOND may also mean that the threshold pivoting tolerance piv_tol should be increased.</p>
 * <p>In case of non-zero return code the factorization becomes invalid. It should not be used in other operations until the cause of failure has been eliminated and the factorization has been recomputed again with the routine luf_factorize.</p>
 * <p>REPAIRING SINGULAR MATRIX</p>
 * <p>If the routine luf_factorize returns non-zero code, it provides all necessary information that can be used for \"repairing\" the matrix A, where \"repairing\" means replacing linearly dependent columns of the matrix A by appropriate columns of the unity matrix. This feature is needed when this routine is used for factorizing the basis matrix within the simplex method procedure.</p>
 * <p>On exit linearly dependent columns of the (partially transformed) matrix U have numbers rank+1, rank+2, ..., n, where rank is estimated rank of the matrix A stored by the routine to the member luf->rank. The correspondence between columns of A and U is the same as between columns of V and U. Thus, linearly dependent columns of the matrix A have numbers qq_col[rank+1], qq_col[rank+2], ..., qq_col[n], where qq_col is the column-like representation of the permutation matrix Q. It is understood that each j-th linearly dependent column of the matrix U should be replaced by the unity vector, where all elements are zero except the unity diagonal element u[j,j]. On the other hand j-th row of the matrix U corresponds to the row of the matrix V (and therefore of the matrix A) with the number pp_row[j], where pp_row is the row-like representation of the permutation matrix P. Thus, each j-th linearly dependent column of the matrix U should be replaced by column of the unity matrix with the number pp_row[j].</p>
 * <p>The code that repairs the matrix A may look like follows:</p>
 * <p>for (j = rank+1; j <= n; j++) { replace the column qq_col[j] of the matrix A by the column pp_row[j] of the unity matrix; }</p>
 * <p>where rank, pp_row, and qq_col are members of the structure LUF. </p>
 */
public";

%javamethodmodifiers luf_f_solve(LUF *luf, int tr, double x[]) "
/**
 * luf_f_solve - solve system F*x = b or F'*x = b .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpluf.h\" void luf_f_solve(LUF *luf, int tr, double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine luf_f_solve solves either the system F*x = b (if the flag tr is zero) or the system F'*x = b (if the flag tr is non-zero), where the matrix F is a component of LU-factorization specified by the parameter luf, F' is a matrix transposed to F.</p>
 * <p>On entry the array x should contain elements of the right-hand side vector b in locations x[1], ..., x[n], where n is the order of the matrix F. On exit this array will contain elements of the solution vector x in the same locations. </p>
 */
public";

%javamethodmodifiers luf_v_solve(LUF *luf, int tr, double x[]) "
/**
 * luf_v_solve - solve system V*x = b or V'*x = b .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpluf.h\" void luf_v_solve(LUF *luf, int tr, double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine luf_v_solve solves either the system V*x = b (if the flag tr is zero) or the system V'*x = b (if the flag tr is non-zero), where the matrix V is a component of LU-factorization specified by the parameter luf, V' is a matrix transposed to V.</p>
 * <p>On entry the array x should contain elements of the right-hand side vector b in locations x[1], ..., x[n], where n is the order of the matrix V. On exit this array will contain elements of the solution vector x in the same locations. </p>
 */
public";

%javamethodmodifiers luf_a_solve(LUF *luf, int tr, double x[]) "
/**
 * luf_a_solve - solve system A*x = b or A'*x = b .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpluf.h\" void luf_a_solve(LUF *luf, int tr, double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine luf_a_solve solves either the system A*x = b (if the flag tr is zero) or the system A'*x = b (if the flag tr is non-zero), where the parameter luf specifies LU-factorization of the matrix A, A' is a matrix transposed to A.</p>
 * <p>On entry the array x should contain elements of the right-hand side vector b in locations x[1], ..., x[n], where n is the order of the matrix A. On exit this array will contain elements of the solution vector x in the same locations. </p>
 */
public";

%javamethodmodifiers luf_delete_it(LUF *luf) "
/**
 * luf_delete_it - delete LU-factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpluf.h\" void luf_delete_it(LUF *luf);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine luf_delete deletes LU-factorization specified by the parameter luf and frees all the memory allocated to this program object. </p>
 */
public";

%javamethodmodifiers luf_create_it(void) "
/**
 * luf_create_it - create LU-factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpluf.h\" LUF *luf_create_it(void);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine luf_create_it creates a program object, which represents LU-factorization of a square matrix.</p>
 * <p>RETURNS</p>
 * <p>The routine luf_create_it returns a pointer to the object created. </p>
 */
public";

%javamethodmodifiers luf_defrag_sva(LUF *luf) "
/**
 * luf_defrag_sva - defragment the sparse vector area .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpluf.h\" void luf_defrag_sva(LUF *luf);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine luf_defrag_sva defragments the sparse vector area (SVA) gathering all unused locations in one continuous extent. In order to do that the routine moves all unused locations from the left part of SVA (which contains rows and columns of the matrix V) to the middle part (which contains free locations). This is attained by relocating elements of rows and columns of the matrix V toward the beginning of the left part.</p>
 * <p>NOTE that this \"garbage collection\" involves changing row and column pointers of the matrix V. </p>
 */
public";

%javamethodmodifiers luf_enlarge_row(LUF *luf, int i, int cap) "
/**
 * luf_enlarge_row - enlarge row capacity .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpluf.h\" int luf_enlarge_row(LUF *luf, int i, int cap);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine luf_enlarge_row enlarges capacity of the i-th row of the matrix V to cap locations (assuming that its current capacity is less than cap). In order to do that the routine relocates elements of the i-th row to the end of the left part of SVA (which contains rows and columns of the matrix V) and then expands the left part by allocating cap free locations from the free part. If there are less than cap free locations, the routine defragments the sparse vector area.</p>
 * <p>Due to \"garbage collection\" this operation may change row and column pointers of the matrix V.</p>
 * <p>RETURNS</p>
 * <p>If no error occured, the routine returns zero. Otherwise, in case of overflow of the sparse vector area, the routine returns non-zero. </p>
 */
public";

%javamethodmodifiers luf_enlarge_col(LUF *luf, int j, int cap) "
/**
 * luf_enlarge_col - enlarge column capacity .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpluf.h\" int luf_enlarge_col(LUF *luf, int j, int cap);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine luf_enlarge_col enlarges capacity of the j-th column of the matrix V to cap locations (assuming that its current capacity is less than cap). In order to do that the routine relocates elements of the j-th column to the end of the left part of SVA (which contains rows and columns of the matrix V) and then expands the left part by allocating cap free locations from the free part. If there are less than cap free locations, the routine defragments the sparse vector area.</p>
 * <p>Due to \"garbage collection\" this operation may change row and column pointers of the matrix V.</p>
 * <p>RETURNS</p>
 * <p>If no error occured, the routine returns zero. Otherwise, in case of overflow of the sparse vector area, the routine returns non-zero. </p>
 */
public";

%javamethodmodifiers luf_factorize(LUF *luf, int n, int(*col)(void *info, int j, int ind[], double val[]), void *info) "
/**
 * luf_factorize - compute LU-factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpluf.h\" int luf_factorize(LUF *luf, int n, int (*col)(void *info, int j, int ind[], double val[]), void *info);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine luf_factorize computes LU-factorization of a specified square matrix A.</p>
 * <p>The parameter luf specifies LU-factorization program object created by the routine luf_create_it.</p>
 * <p>The parameter n specifies the order of A, n > 0.</p>
 * <p>The formal routine col specifies the matrix A to be factorized. To obtain j-th column of A the routine luf_factorize calls the routine col with the parameter j (1 <= j <= n). In response the routine col should store row indices and numerical values of non-zero elements of j-th column of A to locations ind[1,...,len] and val[1,...,len], respectively, where len is the number of non-zeros in j-th column returned on exit. Neither zero nor duplicate elements are allowed.</p>
 * <p>The parameter info is a transit pointer passed to the routine col.</p>
 * <p>RETURNS</p>
 * <p>0 LU-factorization has been successfully computed.</p>
 * <p>LUF_ESING The specified matrix is singular within the working precision. (On some elimination step the active submatrix is exactly zero, so no pivot can be chosen.)</p>
 * <p>LUF_ECOND The specified matrix is ill-conditioned. (On some elimination step too intensive growth of elements of the active submatix has been detected.)</p>
 * <p>If matrix A is well scaled, the return code LUF_ECOND may also mean that the threshold pivoting tolerance piv_tol should be increased.</p>
 * <p>In case of non-zero return code the factorization becomes invalid. It should not be used in other operations until the cause of failure has been eliminated and the factorization has been recomputed again with the routine luf_factorize.</p>
 * <p>REPAIRING SINGULAR MATRIX</p>
 * <p>If the routine luf_factorize returns non-zero code, it provides all necessary information that can be used for \"repairing\" the matrix A, where \"repairing\" means replacing linearly dependent columns of the matrix A by appropriate columns of the unity matrix. This feature is needed when this routine is used for factorizing the basis matrix within the simplex method procedure.</p>
 * <p>On exit linearly dependent columns of the (partially transformed) matrix U have numbers rank+1, rank+2, ..., n, where rank is estimated rank of the matrix A stored by the routine to the member luf->rank. The correspondence between columns of A and U is the same as between columns of V and U. Thus, linearly dependent columns of the matrix A have numbers qq_col[rank+1], qq_col[rank+2], ..., qq_col[n], where qq_col is the column-like representation of the permutation matrix Q. It is understood that each j-th linearly dependent column of the matrix U should be replaced by the unity vector, where all elements are zero except the unity diagonal element u[j,j]. On the other hand j-th row of the matrix U corresponds to the row of the matrix V (and therefore of the matrix A) with the number pp_row[j], where pp_row is the row-like representation of the permutation matrix P. Thus, each j-th linearly dependent column of the matrix U should be replaced by column of the unity matrix with the number pp_row[j].</p>
 * <p>The code that repairs the matrix A may look like follows:</p>
 * <p>for (j = rank+1; j <= n; j++) { replace the column qq_col[j] of the matrix A by the column pp_row[j] of the unity matrix; }</p>
 * <p>where rank, pp_row, and qq_col are members of the structure LUF. </p>
 */
public";

%javamethodmodifiers luf_f_solve(LUF *luf, int tr, double x[]) "
/**
 * luf_f_solve - solve system F*x = b or F'*x = b .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpluf.h\" void luf_f_solve(LUF *luf, int tr, double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine luf_f_solve solves either the system F*x = b (if the flag tr is zero) or the system F'*x = b (if the flag tr is non-zero), where the matrix F is a component of LU-factorization specified by the parameter luf, F' is a matrix transposed to F.</p>
 * <p>On entry the array x should contain elements of the right-hand side vector b in locations x[1], ..., x[n], where n is the order of the matrix F. On exit this array will contain elements of the solution vector x in the same locations. </p>
 */
public";

%javamethodmodifiers luf_v_solve(LUF *luf, int tr, double x[]) "
/**
 * luf_v_solve - solve system V*x = b or V'*x = b .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpluf.h\" void luf_v_solve(LUF *luf, int tr, double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine luf_v_solve solves either the system V*x = b (if the flag tr is zero) or the system V'*x = b (if the flag tr is non-zero), where the matrix V is a component of LU-factorization specified by the parameter luf, V' is a matrix transposed to V.</p>
 * <p>On entry the array x should contain elements of the right-hand side vector b in locations x[1], ..., x[n], where n is the order of the matrix V. On exit this array will contain elements of the solution vector x in the same locations. </p>
 */
public";

%javamethodmodifiers luf_a_solve(LUF *luf, int tr, double x[]) "
/**
 * luf_a_solve - solve system A*x = b or A'*x = b .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpluf.h\" void luf_a_solve(LUF *luf, int tr, double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine luf_a_solve solves either the system A*x = b (if the flag tr is zero) or the system A'*x = b (if the flag tr is non-zero), where the parameter luf specifies LU-factorization of the matrix A, A' is a matrix transposed to A.</p>
 * <p>On entry the array x should contain elements of the right-hand side vector b in locations x[1], ..., x[n], where n is the order of the matrix A. On exit this array will contain elements of the solution vector x in the same locations. </p>
 */
public";

%javamethodmodifiers luf_delete_it(LUF *luf) "
/**
 * luf_delete_it - delete LU-factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpluf.h\" void luf_delete_it(LUF *luf);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine luf_delete deletes LU-factorization specified by the parameter luf and frees all the memory allocated to this program object. </p>
 */
public";

%javamethodmodifiers lux_create(int n) "
/**
 */
public";

%javamethodmodifiers initialize(LUX *lux, int(*col)(void *info, int j, int ind[], mpq_t val[]), void *info, LUXWKA *wka) "
/**
 */
public";

%javamethodmodifiers find_pivot(LUX *lux, LUXWKA *wka) "
/**
 */
public";

%javamethodmodifiers eliminate(LUX *lux, LUXWKA *wka, LUXELM *piv, int flag[], mpq_t work[]) "
/**
 */
public";

%javamethodmodifiers lux_decomp(LUX *lux, int(*col)(void *info, int j, int ind[], mpq_t val[]), void *info) "
/**
 */
public";

%javamethodmodifiers lux_f_solve(LUX *lux, int tr, mpq_t x[]) "
/**
 */
public";

%javamethodmodifiers lux_v_solve(LUX *lux, int tr, mpq_t x[]) "
/**
 */
public";

%javamethodmodifiers lux_solve(LUX *lux, int tr, mpq_t x[]) "
/**
 */
public";

%javamethodmodifiers lux_delete(LUX *lux) "
/**
 */
public";

%javamethodmodifiers lux_create(int n) "
/**
 */
public";

%javamethodmodifiers lux_decomp(LUX *lux, int(*col)(void *info, int j, int ind[], mpq_t val[]), void *info) "
/**
 */
public";

%javamethodmodifiers lux_f_solve(LUX *lux, int tr, mpq_t x[]) "
/**
 */
public";

%javamethodmodifiers lux_v_solve(LUX *lux, int tr, mpq_t x[]) "
/**
 */
public";

%javamethodmodifiers lux_solve(LUX *lux, int tr, mpq_t x[]) "
/**
 */
public";

%javamethodmodifiers lux_delete(LUX *lux) "
/**
 */
public";

%javamethodmodifiers check_fvs(int n, int nnz, int ind[], double vec[]) "
/**
 */
public";

%javamethodmodifiers check_pattern(int m, int n, int A_ptr[], int A_ind[]) "
/**
 */
public";

%javamethodmodifiers transpose(int m, int n, int A_ptr[], int A_ind[], double A_val[], int AT_ptr[], int AT_ind[], double AT_val[]) "
/**
 */
public";

%javamethodmodifiers adat_symbolic(int m, int n, int P_per[], int A_ptr[], int A_ind[], int S_ptr[]) "
/**
 */
public";

%javamethodmodifiers adat_numeric(int m, int n, int P_per[], int A_ptr[], int A_ind[], double A_val[], double D_diag[], int S_ptr[], int S_ind[], double S_val[], double S_diag[]) "
/**
 */
public";

%javamethodmodifiers min_degree(int n, int A_ptr[], int A_ind[], int P_per[]) "
/**
 */
public";

%javamethodmodifiers amd_order1(int n, int A_ptr[], int A_ind[], int P_per[]) "
/**
 */
public";

%javamethodmodifiers allocate(size_t n, size_t size) "
/**
 */
public";

%javamethodmodifiers release(void *ptr) "
/**
 */
public";

%javamethodmodifiers symamd_ord(int n, int A_ptr[], int A_ind[], int P_per[]) "
/**
 */
public";

%javamethodmodifiers chol_symbolic(int n, int A_ptr[], int A_ind[], int U_ptr[]) "
/**
 */
public";

%javamethodmodifiers chol_numeric(int n, int A_ptr[], int A_ind[], double A_val[], double A_diag[], int U_ptr[], int U_ind[], double U_val[], double U_diag[]) "
/**
 */
public";

%javamethodmodifiers u_solve(int n, int U_ptr[], int U_ind[], double U_val[], double U_diag[], double x[]) "
/**
 */
public";

%javamethodmodifiers ut_solve(int n, int U_ptr[], int U_ind[], double U_val[], double U_diag[], double x[]) "
/**
 */
public";

%javamethodmodifiers check_fvs(int n, int nnz, int ind[], double vec[]) "
/**
 */
public";

%javamethodmodifiers check_pattern(int m, int n, int A_ptr[], int A_ind[]) "
/**
 */
public";

%javamethodmodifiers transpose(int m, int n, int A_ptr[], int A_ind[], double A_val[], int AT_ptr[], int AT_ind[], double AT_val[]) "
/**
 */
public";

%javamethodmodifiers adat_symbolic(int m, int n, int P_per[], int A_ptr[], int A_ind[], int S_ptr[]) "
/**
 */
public";

%javamethodmodifiers adat_numeric(int m, int n, int P_per[], int A_ptr[], int A_ind[], double A_val[], double D_diag[], int S_ptr[], int S_ind[], double S_val[], double S_diag[]) "
/**
 */
public";

%javamethodmodifiers min_degree(int n, int A_ptr[], int A_ind[], int P_per[]) "
/**
 */
public";

%javamethodmodifiers amd_order1(int n, int A_ptr[], int A_ind[], int P_per[]) "
/**
 */
public";

%javamethodmodifiers symamd_ord(int n, int A_ptr[], int A_ind[], int P_per[]) "
/**
 */
public";

%javamethodmodifiers chol_symbolic(int n, int A_ptr[], int A_ind[], int U_ptr[]) "
/**
 */
public";

%javamethodmodifiers chol_numeric(int n, int A_ptr[], int A_ind[], double A_val[], double A_diag[], int U_ptr[], int U_ind[], double U_val[], double U_diag[]) "
/**
 */
public";

%javamethodmodifiers u_solve(int n, int U_ptr[], int U_ind[], double U_val[], double U_diag[], double x[]) "
/**
 */
public";

%javamethodmodifiers ut_solve(int n, int U_ptr[], int U_ind[], double U_val[], double U_diag[], double x[]) "
/**
 */
public";

%javamethodmodifiers enter_context(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers print_context(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers get_char(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers append_char(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers get_token(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers unget_token(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers is_keyword(MPL *mpl, char *keyword) "
/**
 */
public";

%javamethodmodifiers is_reserved(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers make_code(MPL *mpl, int op, OPERANDS *arg, int type, int dim) "
/**
 */
public";

%javamethodmodifiers make_unary(MPL *mpl, int op, CODE *x, int type, int dim) "
/**
 */
public";

%javamethodmodifiers make_binary(MPL *mpl, int op, CODE *x, CODE *y, int type, int dim) "
/**
 */
public";

%javamethodmodifiers make_ternary(MPL *mpl, int op, CODE *x, CODE *y, CODE *z, int type, int dim) "
/**
 */
public";

%javamethodmodifiers numeric_literal(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers string_literal(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers create_arg_list(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expand_arg_list(MPL *mpl, ARG_LIST *list, CODE *x) "
/**
 */
public";

%javamethodmodifiers arg_list_len(MPL *mpl, ARG_LIST *list) "
/**
 */
public";

%javamethodmodifiers subscript_list(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers object_reference(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers numeric_argument(MPL *mpl, char *func) "
/**
 */
public";

%javamethodmodifiers symbolic_argument(MPL *mpl, char *func) "
/**
 */
public";

%javamethodmodifiers elemset_argument(MPL *mpl, char *func) "
/**
 */
public";

%javamethodmodifiers function_reference(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers create_domain(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers create_block(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers append_block(MPL *mpl, DOMAIN *domain, DOMAIN_BLOCK *block) "
/**
 */
public";

%javamethodmodifiers append_slot(MPL *mpl, DOMAIN_BLOCK *block, char *name, CODE *code) "
/**
 */
public";

%javamethodmodifiers expression_list(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers literal_set(MPL *mpl, CODE *code) "
/**
 */
public";

%javamethodmodifiers indexing_expression(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers close_scope(MPL *mpl, DOMAIN *domain) "
/**
 */
public";

%javamethodmodifiers iterated_expression(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers domain_arity(MPL *mpl, DOMAIN *domain) "
/**
 */
public";

%javamethodmodifiers set_expression(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers branched_expression(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers primary_expression(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers error_preceding(MPL *mpl, char *opstr) "
/**
 */
public";

%javamethodmodifiers error_following(MPL *mpl, char *opstr) "
/**
 */
public";

%javamethodmodifiers error_dimension(MPL *mpl, char *opstr, int dim1, int dim2) "
/**
 */
public";

%javamethodmodifiers expression_0(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expression_1(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expression_2(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expression_3(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expression_4(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expression_5(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expression_6(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expression_7(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expression_8(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expression_9(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expression_10(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expression_11(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expression_12(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expression_13(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers set_statement(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers parameter_statement(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers variable_statement(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers constraint_statement(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers objective_statement(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers table_statement(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers solve_statement(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers check_statement(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers display_statement(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers printf_statement(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers for_statement(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers end_statement(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers simple_statement(MPL *mpl, int spec) "
/**
 */
public";

%javamethodmodifiers model_section(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers create_slice(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expand_slice(MPL *mpl, SLICE *slice, SYMBOL *sym) "
/**
 */
public";

%javamethodmodifiers slice_dimen(MPL *mpl, SLICE *slice) "
/**
 */
public";

%javamethodmodifiers slice_arity(MPL *mpl, SLICE *slice) "
/**
 */
public";

%javamethodmodifiers fake_slice(MPL *mpl, int dim) "
/**
 */
public";

%javamethodmodifiers delete_slice(MPL *mpl, SLICE *slice) "
/**
 */
public";

%javamethodmodifiers is_number(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers is_symbol(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers is_literal(MPL *mpl, char *literal) "
/**
 */
public";

%javamethodmodifiers read_number(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers read_symbol(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers read_slice(MPL *mpl, char *name, int dim) "
/**
 */
public";

%javamethodmodifiers select_set(MPL *mpl, char *name) "
/**
 */
public";

%javamethodmodifiers simple_format(MPL *mpl, SET *set, MEMBER *memb, SLICE *slice) "
/**
 */
public";

%javamethodmodifiers matrix_format(MPL *mpl, SET *set, MEMBER *memb, SLICE *slice, int tr) "
/**
 */
public";

%javamethodmodifiers set_data(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers select_parameter(MPL *mpl, char *name) "
/**
 */
public";

%javamethodmodifiers set_default(MPL *mpl, PARAMETER *par, SYMBOL *altval) "
/**
 */
public";

%javamethodmodifiers read_value(MPL *mpl, PARAMETER *par, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers plain_format(MPL *mpl, PARAMETER *par, SLICE *slice) "
/**
 */
public";

%javamethodmodifiers tabular_format(MPL *mpl, PARAMETER *par, SLICE *slice, int tr) "
/**
 */
public";

%javamethodmodifiers tabbing_format(MPL *mpl, SYMBOL *altval) "
/**
 */
public";

%javamethodmodifiers parameter_data(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers data_section(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers fp_add(MPL *mpl, double x, double y) "
/**
 */
public";

%javamethodmodifiers fp_sub(MPL *mpl, double x, double y) "
/**
 */
public";

%javamethodmodifiers fp_less(MPL *mpl, double x, double y) "
/**
 */
public";

%javamethodmodifiers fp_mul(MPL *mpl, double x, double y) "
/**
 */
public";

%javamethodmodifiers fp_div(MPL *mpl, double x, double y) "
/**
 */
public";

%javamethodmodifiers fp_idiv(MPL *mpl, double x, double y) "
/**
 */
public";

%javamethodmodifiers fp_mod(MPL *mpl, double x, double y) "
/**
 */
public";

%javamethodmodifiers fp_power(MPL *mpl, double x, double y) "
/**
 */
public";

%javamethodmodifiers fp_exp(MPL *mpl, double x) "
/**
 */
public";

%javamethodmodifiers fp_log(MPL *mpl, double x) "
/**
 */
public";

%javamethodmodifiers fp_log10(MPL *mpl, double x) "
/**
 */
public";

%javamethodmodifiers fp_sqrt(MPL *mpl, double x) "
/**
 */
public";

%javamethodmodifiers fp_sin(MPL *mpl, double x) "
/**
 */
public";

%javamethodmodifiers fp_cos(MPL *mpl, double x) "
/**
 */
public";

%javamethodmodifiers fp_atan(MPL *mpl, double x) "
/**
 */
public";

%javamethodmodifiers fp_atan2(MPL *mpl, double y, double x) "
/**
 */
public";

%javamethodmodifiers fp_round(MPL *mpl, double x, double n) "
/**
 */
public";

%javamethodmodifiers fp_trunc(MPL *mpl, double x, double n) "
/**
 */
public";

%javamethodmodifiers fp_irand224(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers fp_uniform01(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers fp_uniform(MPL *mpl, double a, double b) "
/**
 */
public";

%javamethodmodifiers fp_normal01(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers fp_normal(MPL *mpl, double mu, double sigma) "
/**
 */
public";

%javamethodmodifiers fn_gmtime(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers fn_str2time(MPL *mpl, const char *str, const char *fmt) "
/**
 */
public";

%javamethodmodifiers fn_time2str(MPL *mpl, char *str, double t, const char *fmt) "
/**
 */
public";

%javamethodmodifiers create_string(MPL *mpl, char buf[MAX_LENGTH+1]) "
/**
 */
public";

%javamethodmodifiers copy_string(MPL *mpl, STRING *str) "
/**
 */
public";

%javamethodmodifiers compare_strings(MPL *mpl, STRING *str1, STRING *str2) "
/**
 */
public";

%javamethodmodifiers fetch_string(MPL *mpl, STRING *str, char buf[MAX_LENGTH+1]) "
/**
 */
public";

%javamethodmodifiers delete_string(MPL *mpl, STRING *str) "
/**
 */
public";

%javamethodmodifiers create_symbol_num(MPL *mpl, double num) "
/**
 */
public";

%javamethodmodifiers create_symbol_str(MPL *mpl, STRING *str) "
/**
 */
public";

%javamethodmodifiers copy_symbol(MPL *mpl, SYMBOL *sym) "
/**
 */
public";

%javamethodmodifiers compare_symbols(MPL *mpl, SYMBOL *sym1, SYMBOL *sym2) "
/**
 */
public";

%javamethodmodifiers delete_symbol(MPL *mpl, SYMBOL *sym) "
/**
 */
public";

%javamethodmodifiers format_symbol(MPL *mpl, SYMBOL *sym) "
/**
 */
public";

%javamethodmodifiers concat_symbols(MPL *mpl, SYMBOL *sym1, SYMBOL *sym2) "
/**
 */
public";

%javamethodmodifiers create_tuple(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expand_tuple(MPL *mpl, TUPLE *tuple, SYMBOL *sym) "
/**
 */
public";

%javamethodmodifiers tuple_dimen(MPL *mpl, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers copy_tuple(MPL *mpl, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers compare_tuples(MPL *mpl, TUPLE *tuple1, TUPLE *tuple2) "
/**
 */
public";

%javamethodmodifiers build_subtuple(MPL *mpl, TUPLE *tuple, int dim) "
/**
 */
public";

%javamethodmodifiers delete_tuple(MPL *mpl, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers format_tuple(MPL *mpl, int c, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers create_elemset(MPL *mpl, int dim) "
/**
 */
public";

%javamethodmodifiers find_tuple(MPL *mpl, ELEMSET *set, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers add_tuple(MPL *mpl, ELEMSET *set, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers check_then_add(MPL *mpl, ELEMSET *set, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers copy_elemset(MPL *mpl, ELEMSET *set) "
/**
 */
public";

%javamethodmodifiers delete_elemset(MPL *mpl, ELEMSET *set) "
/**
 */
public";

%javamethodmodifiers arelset_size(MPL *mpl, double t0, double tf, double dt) "
/**
 */
public";

%javamethodmodifiers arelset_member(MPL *mpl, double t0, double tf, double dt, int j) "
/**
 */
public";

%javamethodmodifiers create_arelset(MPL *mpl, double t0, double tf, double dt) "
/**
 */
public";

%javamethodmodifiers set_union(MPL *mpl, ELEMSET *X, ELEMSET *Y) "
/**
 */
public";

%javamethodmodifiers set_diff(MPL *mpl, ELEMSET *X, ELEMSET *Y) "
/**
 */
public";

%javamethodmodifiers set_symdiff(MPL *mpl, ELEMSET *X, ELEMSET *Y) "
/**
 */
public";

%javamethodmodifiers set_inter(MPL *mpl, ELEMSET *X, ELEMSET *Y) "
/**
 */
public";

%javamethodmodifiers set_cross(MPL *mpl, ELEMSET *X, ELEMSET *Y) "
/**
 */
public";

%javamethodmodifiers constant_term(MPL *mpl, double coef) "
/**
 */
public";

%javamethodmodifiers single_variable(MPL *mpl, ELEMVAR *var) "
/**
 */
public";

%javamethodmodifiers copy_formula(MPL *mpl, FORMULA *form) "
/**
 */
public";

%javamethodmodifiers delete_formula(MPL *mpl, FORMULA *form) "
/**
 */
public";

%javamethodmodifiers linear_comb(MPL *mpl, double a, FORMULA *fx, double b, FORMULA *fy) "
/**
 */
public";

%javamethodmodifiers remove_constant(MPL *mpl, FORMULA *form, double *coef) "
/**
 */
public";

%javamethodmodifiers reduce_terms(MPL *mpl, FORMULA *form) "
/**
 */
public";

%javamethodmodifiers delete_value(MPL *mpl, int type, VALUE *value) "
/**
 */
public";

%javamethodmodifiers create_array(MPL *mpl, int type, int dim) "
/**
 */
public";

%javamethodmodifiers find_member(MPL *mpl, ARRAY *array, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers add_member(MPL *mpl, ARRAY *array, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers delete_array(MPL *mpl, ARRAY *array) "
/**
 */
public";

%javamethodmodifiers assign_dummy_index(MPL *mpl, DOMAIN_SLOT *slot, SYMBOL *value) "
/**
 */
public";

%javamethodmodifiers update_dummy_indices(MPL *mpl, DOMAIN_BLOCK *block) "
/**
 */
public";

%javamethodmodifiers enter_domain_block(MPL *mpl, DOMAIN_BLOCK *block, TUPLE *tuple, void *info, void(*func)(MPL *mpl, void *info)) "
/**
 */
public";

%javamethodmodifiers eval_within_domain(MPL *mpl, DOMAIN *domain, TUPLE *tuple, void *info, void(*func)(MPL *mpl, void *info)) "
/**
 */
public";

%javamethodmodifiers loop_within_domain(MPL *mpl, DOMAIN *domain, void *info, int(*func)(MPL *mpl, void *info)) "
/**
 */
public";

%javamethodmodifiers out_of_domain(MPL *mpl, char *name, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers get_domain_tuple(MPL *mpl, DOMAIN *domain) "
/**
 */
public";

%javamethodmodifiers clean_domain(MPL *mpl, DOMAIN *domain) "
/**
 */
public";

%javamethodmodifiers check_elem_set(MPL *mpl, SET *set, TUPLE *tuple, ELEMSET *refer) "
/**
 */
public";

%javamethodmodifiers take_member_set(MPL *mpl, SET *set, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers eval_member_set(MPL *mpl, SET *set, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers eval_whole_set(MPL *mpl, SET *set) "
/**
 */
public";

%javamethodmodifiers clean_set(MPL *mpl, SET *set) "
/**
 */
public";

%javamethodmodifiers check_value_num(MPL *mpl, PARAMETER *par, TUPLE *tuple, double value) "
/**
 */
public";

%javamethodmodifiers take_member_num(MPL *mpl, PARAMETER *par, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers eval_member_num(MPL *mpl, PARAMETER *par, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers check_value_sym(MPL *mpl, PARAMETER *par, TUPLE *tuple, SYMBOL *value) "
/**
 */
public";

%javamethodmodifiers take_member_sym(MPL *mpl, PARAMETER *par, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers eval_member_sym(MPL *mpl, PARAMETER *par, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers eval_whole_par(MPL *mpl, PARAMETER *par) "
/**
 */
public";

%javamethodmodifiers clean_parameter(MPL *mpl, PARAMETER *par) "
/**
 */
public";

%javamethodmodifiers take_member_var(MPL *mpl, VARIABLE *var, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers eval_member_var(MPL *mpl, VARIABLE *var, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers eval_whole_var(MPL *mpl, VARIABLE *var) "
/**
 */
public";

%javamethodmodifiers clean_variable(MPL *mpl, VARIABLE *var) "
/**
 */
public";

%javamethodmodifiers take_member_con(MPL *mpl, CONSTRAINT *con, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers eval_member_con(MPL *mpl, CONSTRAINT *con, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers eval_whole_con(MPL *mpl, CONSTRAINT *con) "
/**
 */
public";

%javamethodmodifiers clean_constraint(MPL *mpl, CONSTRAINT *con) "
/**
 */
public";

%javamethodmodifiers mpl_tab_num_args(TABDCA *dca) "
/**
 */
public";

%javamethodmodifiers mpl_tab_get_arg(TABDCA *dca, int k) "
/**
 */
public";

%javamethodmodifiers mpl_tab_num_flds(TABDCA *dca) "
/**
 */
public";

%javamethodmodifiers mpl_tab_get_name(TABDCA *dca, int k) "
/**
 */
public";

%javamethodmodifiers mpl_tab_get_type(TABDCA *dca, int k) "
/**
 */
public";

%javamethodmodifiers mpl_tab_get_num(TABDCA *dca, int k) "
/**
 */
public";

%javamethodmodifiers mpl_tab_get_str(TABDCA *dca, int k) "
/**
 */
public";

%javamethodmodifiers mpl_tab_set_num(TABDCA *dca, int k, double num) "
/**
 */
public";

%javamethodmodifiers mpl_tab_set_str(TABDCA *dca, int k, const char *str) "
/**
 */
public";

%javamethodmodifiers mpl_tab_drv_open(MPL *mpl, int mode) "
/**
 */
public";

%javamethodmodifiers mpl_tab_drv_read(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers mpl_tab_drv_write(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers mpl_tab_drv_close(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers eval_numeric(MPL *mpl, CODE *code) "
/**
 */
public";

%javamethodmodifiers eval_symbolic(MPL *mpl, CODE *code) "
/**
 */
public";

%javamethodmodifiers eval_logical(MPL *mpl, CODE *code) "
/**
 */
public";

%javamethodmodifiers eval_tuple(MPL *mpl, CODE *code) "
/**
 */
public";

%javamethodmodifiers eval_elemset(MPL *mpl, CODE *code) "
/**
 */
public";

%javamethodmodifiers is_member(MPL *mpl, CODE *code, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers eval_formula(MPL *mpl, CODE *code) "
/**
 */
public";

%javamethodmodifiers clean_code(MPL *mpl, CODE *code) "
/**
 */
public";

%javamethodmodifiers execute_table(MPL *mpl, TABLE *tab) "
/**
 */
public";

%javamethodmodifiers free_dca(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers clean_table(MPL *mpl, TABLE *tab) "
/**
 */
public";

%javamethodmodifiers execute_check(MPL *mpl, CHECK *chk) "
/**
 */
public";

%javamethodmodifiers clean_check(MPL *mpl, CHECK *chk) "
/**
 */
public";

%javamethodmodifiers execute_display(MPL *mpl, DISPLAY *dpy) "
/**
 */
public";

%javamethodmodifiers clean_display(MPL *mpl, DISPLAY *dpy) "
/**
 */
public";

%javamethodmodifiers execute_printf(MPL *mpl, PRINTF *prt) "
/**
 */
public";

%javamethodmodifiers clean_printf(MPL *mpl, PRINTF *prt) "
/**
 */
public";

%javamethodmodifiers execute_for(MPL *mpl, FOR *fur) "
/**
 */
public";

%javamethodmodifiers clean_for(MPL *mpl, FOR *fur) "
/**
 */
public";

%javamethodmodifiers execute_statement(MPL *mpl, STATEMENT *stmt) "
/**
 */
public";

%javamethodmodifiers clean_statement(MPL *mpl, STATEMENT *stmt) "
/**
 */
public";

%javamethodmodifiers alloc_content(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers generate_model(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers build_problem(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers postsolve_model(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers clean_model(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers open_input(MPL *mpl, char *file) "
/**
 */
public";

%javamethodmodifiers read_char(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers close_input(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers open_output(MPL *mpl, char *file) "
/**
 */
public";

%javamethodmodifiers write_char(MPL *mpl, int c) "
/**
 */
public";

%javamethodmodifiers write_text(MPL *mpl, char *fmt,...) "
/**
 */
public";

%javamethodmodifiers flush_output(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers error(MPL *mpl, char *fmt,...) "
/**
 */
public";

%javamethodmodifiers warning(MPL *mpl, char *fmt,...) "
/**
 */
public";

%javamethodmodifiers mpl_initialize(void) "
/**
 */
public";

%javamethodmodifiers mpl_read_model(MPL *mpl, char *file, int skip_data) "
/**
 */
public";

%javamethodmodifiers mpl_read_data(MPL *mpl, char *file) "
/**
 */
public";

%javamethodmodifiers mpl_generate(MPL *mpl, char *file) "
/**
 */
public";

%javamethodmodifiers mpl_get_prob_name(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers mpl_get_num_rows(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers mpl_get_num_cols(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers mpl_get_row_name(MPL *mpl, int i) "
/**
 */
public";

%javamethodmodifiers mpl_get_row_kind(MPL *mpl, int i) "
/**
 */
public";

%javamethodmodifiers mpl_get_row_bnds(MPL *mpl, int i, double *lb, double *ub) "
/**
 */
public";

%javamethodmodifiers mpl_get_mat_row(MPL *mpl, int i, int ndx[], double val[]) "
/**
 */
public";

%javamethodmodifiers mpl_get_row_c0(MPL *mpl, int i) "
/**
 */
public";

%javamethodmodifiers mpl_get_col_name(MPL *mpl, int j) "
/**
 */
public";

%javamethodmodifiers mpl_get_col_kind(MPL *mpl, int j) "
/**
 */
public";

%javamethodmodifiers mpl_get_col_bnds(MPL *mpl, int j, double *lb, double *ub) "
/**
 */
public";

%javamethodmodifiers mpl_has_solve_stmt(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers mpl_put_row_soln(MPL *mpl, int i, int stat, double prim, double dual) "
/**
 */
public";

%javamethodmodifiers mpl_put_col_soln(MPL *mpl, int j, int stat, double prim, double dual) "
/**
 */
public";

%javamethodmodifiers mpl_postsolve(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers mpl_terminate(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers enter_context(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers print_context(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers get_char(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers append_char(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers get_token(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers unget_token(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers is_keyword(MPL *mpl, char *keyword) "
/**
 */
public";

%javamethodmodifiers is_reserved(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers make_code(MPL *mpl, int op, OPERANDS *arg, int type, int dim) "
/**
 */
public";

%javamethodmodifiers make_unary(MPL *mpl, int op, CODE *x, int type, int dim) "
/**
 */
public";

%javamethodmodifiers make_binary(MPL *mpl, int op, CODE *x, CODE *y, int type, int dim) "
/**
 */
public";

%javamethodmodifiers make_ternary(MPL *mpl, int op, CODE *x, CODE *y, CODE *z, int type, int dim) "
/**
 */
public";

%javamethodmodifiers numeric_literal(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers string_literal(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers create_arg_list(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expand_arg_list(MPL *mpl, ARG_LIST *list, CODE *x) "
/**
 */
public";

%javamethodmodifiers arg_list_len(MPL *mpl, ARG_LIST *list) "
/**
 */
public";

%javamethodmodifiers subscript_list(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers object_reference(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers numeric_argument(MPL *mpl, char *func) "
/**
 */
public";

%javamethodmodifiers symbolic_argument(MPL *mpl, char *func) "
/**
 */
public";

%javamethodmodifiers elemset_argument(MPL *mpl, char *func) "
/**
 */
public";

%javamethodmodifiers function_reference(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers create_domain(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers create_block(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers append_block(MPL *mpl, DOMAIN *domain, DOMAIN_BLOCK *block) "
/**
 */
public";

%javamethodmodifiers append_slot(MPL *mpl, DOMAIN_BLOCK *block, char *name, CODE *code) "
/**
 */
public";

%javamethodmodifiers expression_list(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers literal_set(MPL *mpl, CODE *code) "
/**
 */
public";

%javamethodmodifiers indexing_expression(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers close_scope(MPL *mpl, DOMAIN *domain) "
/**
 */
public";

%javamethodmodifiers link_up(CODE *code) "
/**
 */
public";

%javamethodmodifiers iterated_expression(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers domain_arity(MPL *mpl, DOMAIN *domain) "
/**
 */
public";

%javamethodmodifiers set_expression(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers branched_expression(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers primary_expression(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers error_preceding(MPL *mpl, char *opstr) "
/**
 */
public";

%javamethodmodifiers error_following(MPL *mpl, char *opstr) "
/**
 */
public";

%javamethodmodifiers error_dimension(MPL *mpl, char *opstr, int dim1, int dim2) "
/**
 */
public";

%javamethodmodifiers expression_0(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expression_1(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expression_2(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expression_3(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expression_4(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expression_5(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expression_6(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expression_7(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expression_8(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expression_9(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expression_10(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expression_11(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expression_12(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expression_13(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers set_statement(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers parameter_statement(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers variable_statement(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers constraint_statement(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers objective_statement(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers table_statement(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers solve_statement(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers check_statement(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers display_statement(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers printf_statement(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers for_statement(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers end_statement(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers simple_statement(MPL *mpl, int spec) "
/**
 */
public";

%javamethodmodifiers model_section(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers create_slice(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expand_slice(MPL *mpl, SLICE *slice, SYMBOL *sym) "
/**
 */
public";

%javamethodmodifiers slice_dimen(MPL *mpl, SLICE *slice) "
/**
 */
public";

%javamethodmodifiers slice_arity(MPL *mpl, SLICE *slice) "
/**
 */
public";

%javamethodmodifiers fake_slice(MPL *mpl, int dim) "
/**
 */
public";

%javamethodmodifiers delete_slice(MPL *mpl, SLICE *slice) "
/**
 */
public";

%javamethodmodifiers is_number(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers is_symbol(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers is_literal(MPL *mpl, char *literal) "
/**
 */
public";

%javamethodmodifiers read_number(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers read_symbol(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers read_slice(MPL *mpl, char *name, int dim) "
/**
 */
public";

%javamethodmodifiers select_set(MPL *mpl, char *name) "
/**
 */
public";

%javamethodmodifiers simple_format(MPL *mpl, SET *set, MEMBER *memb, SLICE *slice) "
/**
 */
public";

%javamethodmodifiers matrix_format(MPL *mpl, SET *set, MEMBER *memb, SLICE *slice, int tr) "
/**
 */
public";

%javamethodmodifiers set_data(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers select_parameter(MPL *mpl, char *name) "
/**
 */
public";

%javamethodmodifiers set_default(MPL *mpl, PARAMETER *par, SYMBOL *altval) "
/**
 */
public";

%javamethodmodifiers read_value(MPL *mpl, PARAMETER *par, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers plain_format(MPL *mpl, PARAMETER *par, SLICE *slice) "
/**
 */
public";

%javamethodmodifiers tabular_format(MPL *mpl, PARAMETER *par, SLICE *slice, int tr) "
/**
 */
public";

%javamethodmodifiers tabbing_format(MPL *mpl, SYMBOL *altval) "
/**
 */
public";

%javamethodmodifiers parameter_data(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers data_section(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers fp_add(MPL *mpl, double x, double y) "
/**
 */
public";

%javamethodmodifiers fp_sub(MPL *mpl, double x, double y) "
/**
 */
public";

%javamethodmodifiers fp_less(MPL *mpl, double x, double y) "
/**
 */
public";

%javamethodmodifiers fp_mul(MPL *mpl, double x, double y) "
/**
 */
public";

%javamethodmodifiers fp_div(MPL *mpl, double x, double y) "
/**
 */
public";

%javamethodmodifiers fp_idiv(MPL *mpl, double x, double y) "
/**
 */
public";

%javamethodmodifiers fp_mod(MPL *mpl, double x, double y) "
/**
 */
public";

%javamethodmodifiers fp_power(MPL *mpl, double x, double y) "
/**
 */
public";

%javamethodmodifiers fp_exp(MPL *mpl, double x) "
/**
 */
public";

%javamethodmodifiers fp_log(MPL *mpl, double x) "
/**
 */
public";

%javamethodmodifiers fp_log10(MPL *mpl, double x) "
/**
 */
public";

%javamethodmodifiers fp_sqrt(MPL *mpl, double x) "
/**
 */
public";

%javamethodmodifiers fp_sin(MPL *mpl, double x) "
/**
 */
public";

%javamethodmodifiers fp_cos(MPL *mpl, double x) "
/**
 */
public";

%javamethodmodifiers fp_atan(MPL *mpl, double x) "
/**
 */
public";

%javamethodmodifiers fp_atan2(MPL *mpl, double y, double x) "
/**
 */
public";

%javamethodmodifiers fp_round(MPL *mpl, double x, double n) "
/**
 */
public";

%javamethodmodifiers fp_trunc(MPL *mpl, double x, double n) "
/**
 */
public";

%javamethodmodifiers fp_irand224(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers fp_uniform01(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers fp_uniform(MPL *mpl, double a, double b) "
/**
 */
public";

%javamethodmodifiers fp_normal01(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers fp_normal(MPL *mpl, double mu, double sigma) "
/**
 */
public";

%javamethodmodifiers create_string(MPL *mpl, char buf[MAX_LENGTH+1]) "
/**
 */
public";

%javamethodmodifiers copy_string(MPL *mpl, STRING *str) "
/**
 */
public";

%javamethodmodifiers compare_strings(MPL *mpl, STRING *str1, STRING *str2) "
/**
 */
public";

%javamethodmodifiers fetch_string(MPL *mpl, STRING *str, char buf[MAX_LENGTH+1]) "
/**
 */
public";

%javamethodmodifiers delete_string(MPL *mpl, STRING *str) "
/**
 */
public";

%javamethodmodifiers create_symbol_num(MPL *mpl, double num) "
/**
 */
public";

%javamethodmodifiers create_symbol_str(MPL *mpl, STRING *str) "
/**
 */
public";

%javamethodmodifiers copy_symbol(MPL *mpl, SYMBOL *sym) "
/**
 */
public";

%javamethodmodifiers compare_symbols(MPL *mpl, SYMBOL *sym1, SYMBOL *sym2) "
/**
 */
public";

%javamethodmodifiers delete_symbol(MPL *mpl, SYMBOL *sym) "
/**
 */
public";

%javamethodmodifiers format_symbol(MPL *mpl, SYMBOL *sym) "
/**
 */
public";

%javamethodmodifiers concat_symbols(MPL *mpl, SYMBOL *sym1, SYMBOL *sym2) "
/**
 */
public";

%javamethodmodifiers create_tuple(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers expand_tuple(MPL *mpl, TUPLE *tuple, SYMBOL *sym) "
/**
 */
public";

%javamethodmodifiers tuple_dimen(MPL *mpl, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers copy_tuple(MPL *mpl, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers compare_tuples(MPL *mpl, TUPLE *tuple1, TUPLE *tuple2) "
/**
 */
public";

%javamethodmodifiers build_subtuple(MPL *mpl, TUPLE *tuple, int dim) "
/**
 */
public";

%javamethodmodifiers delete_tuple(MPL *mpl, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers format_tuple(MPL *mpl, int c, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers create_elemset(MPL *mpl, int dim) "
/**
 */
public";

%javamethodmodifiers find_tuple(MPL *mpl, ELEMSET *set, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers add_tuple(MPL *mpl, ELEMSET *set, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers check_then_add(MPL *mpl, ELEMSET *set, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers copy_elemset(MPL *mpl, ELEMSET *set) "
/**
 */
public";

%javamethodmodifiers delete_elemset(MPL *mpl, ELEMSET *set) "
/**
 */
public";

%javamethodmodifiers arelset_size(MPL *mpl, double t0, double tf, double dt) "
/**
 */
public";

%javamethodmodifiers arelset_member(MPL *mpl, double t0, double tf, double dt, int j) "
/**
 */
public";

%javamethodmodifiers create_arelset(MPL *mpl, double t0, double tf, double dt) "
/**
 */
public";

%javamethodmodifiers set_union(MPL *mpl, ELEMSET *X, ELEMSET *Y) "
/**
 */
public";

%javamethodmodifiers set_diff(MPL *mpl, ELEMSET *X, ELEMSET *Y) "
/**
 */
public";

%javamethodmodifiers set_symdiff(MPL *mpl, ELEMSET *X, ELEMSET *Y) "
/**
 */
public";

%javamethodmodifiers set_inter(MPL *mpl, ELEMSET *X, ELEMSET *Y) "
/**
 */
public";

%javamethodmodifiers set_cross(MPL *mpl, ELEMSET *X, ELEMSET *Y) "
/**
 */
public";

%javamethodmodifiers constant_term(MPL *mpl, double coef) "
/**
 */
public";

%javamethodmodifiers single_variable(MPL *mpl, ELEMVAR *var) "
/**
 */
public";

%javamethodmodifiers copy_formula(MPL *mpl, FORMULA *form) "
/**
 */
public";

%javamethodmodifiers delete_formula(MPL *mpl, FORMULA *form) "
/**
 */
public";

%javamethodmodifiers linear_comb(MPL *mpl, double a, FORMULA *fx, double b, FORMULA *fy) "
/**
 */
public";

%javamethodmodifiers remove_constant(MPL *mpl, FORMULA *form, double *coef) "
/**
 */
public";

%javamethodmodifiers reduce_terms(MPL *mpl, FORMULA *form) "
/**
 */
public";

%javamethodmodifiers delete_value(MPL *mpl, int type, VALUE *value) "
/**
 */
public";

%javamethodmodifiers create_array(MPL *mpl, int type, int dim) "
/**
 */
public";

%javamethodmodifiers compare_member_tuples(void *info, const void *key1, const void *key2) "
/**
 */
public";

%javamethodmodifiers find_member(MPL *mpl, ARRAY *array, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers add_member(MPL *mpl, ARRAY *array, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers delete_array(MPL *mpl, ARRAY *array) "
/**
 */
public";

%javamethodmodifiers assign_dummy_index(MPL *mpl, DOMAIN_SLOT *slot, SYMBOL *value) "
/**
 */
public";

%javamethodmodifiers update_dummy_indices(MPL *mpl, DOMAIN_BLOCK *block) "
/**
 */
public";

%javamethodmodifiers enter_domain_block(MPL *mpl, DOMAIN_BLOCK *block, TUPLE *tuple, void *info, void(*func)(MPL *mpl, void *info)) "
/**
 */
public";

%javamethodmodifiers eval_domain_func(MPL *mpl, void *_my_info) "
/**
 */
public";

%javamethodmodifiers eval_within_domain(MPL *mpl, DOMAIN *domain, TUPLE *tuple, void *info, void(*func)(MPL *mpl, void *info)) "
/**
 */
public";

%javamethodmodifiers loop_domain_func(MPL *mpl, void *_my_info) "
/**
 */
public";

%javamethodmodifiers loop_within_domain(MPL *mpl, DOMAIN *domain, void *info, int(*func)(MPL *mpl, void *info)) "
/**
 */
public";

%javamethodmodifiers out_of_domain(MPL *mpl, char *name, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers get_domain_tuple(MPL *mpl, DOMAIN *domain) "
/**
 */
public";

%javamethodmodifiers clean_domain(MPL *mpl, DOMAIN *domain) "
/**
 */
public";

%javamethodmodifiers check_elem_set(MPL *mpl, SET *set, TUPLE *tuple, ELEMSET *refer) "
/**
 */
public";

%javamethodmodifiers take_member_set(MPL *mpl, SET *set, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers eval_set_func(MPL *mpl, void *_info) "
/**
 */
public";

%javamethodmodifiers saturate_set(MPL *mpl, SET *set) "
/**
 */
public";

%javamethodmodifiers eval_member_set(MPL *mpl, SET *set, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers whole_set_func(MPL *mpl, void *info) "
/**
 */
public";

%javamethodmodifiers eval_whole_set(MPL *mpl, SET *set) "
/**
 */
public";

%javamethodmodifiers clean_set(MPL *mpl, SET *set) "
/**
 */
public";

%javamethodmodifiers check_value_num(MPL *mpl, PARAMETER *par, TUPLE *tuple, double value) "
/**
 */
public";

%javamethodmodifiers take_member_num(MPL *mpl, PARAMETER *par, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers eval_num_func(MPL *mpl, void *_info) "
/**
 */
public";

%javamethodmodifiers eval_member_num(MPL *mpl, PARAMETER *par, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers check_value_sym(MPL *mpl, PARAMETER *par, TUPLE *tuple, SYMBOL *value) "
/**
 */
public";

%javamethodmodifiers take_member_sym(MPL *mpl, PARAMETER *par, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers eval_sym_func(MPL *mpl, void *_info) "
/**
 */
public";

%javamethodmodifiers eval_member_sym(MPL *mpl, PARAMETER *par, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers whole_par_func(MPL *mpl, void *info) "
/**
 */
public";

%javamethodmodifiers eval_whole_par(MPL *mpl, PARAMETER *par) "
/**
 */
public";

%javamethodmodifiers clean_parameter(MPL *mpl, PARAMETER *par) "
/**
 */
public";

%javamethodmodifiers take_member_var(MPL *mpl, VARIABLE *var, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers eval_var_func(MPL *mpl, void *_info) "
/**
 */
public";

%javamethodmodifiers eval_member_var(MPL *mpl, VARIABLE *var, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers whole_var_func(MPL *mpl, void *info) "
/**
 */
public";

%javamethodmodifiers eval_whole_var(MPL *mpl, VARIABLE *var) "
/**
 */
public";

%javamethodmodifiers clean_variable(MPL *mpl, VARIABLE *var) "
/**
 */
public";

%javamethodmodifiers take_member_con(MPL *mpl, CONSTRAINT *con, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers eval_con_func(MPL *mpl, void *_info) "
/**
 */
public";

%javamethodmodifiers eval_member_con(MPL *mpl, CONSTRAINT *con, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers whole_con_func(MPL *mpl, void *info) "
/**
 */
public";

%javamethodmodifiers eval_whole_con(MPL *mpl, CONSTRAINT *con) "
/**
 */
public";

%javamethodmodifiers clean_constraint(MPL *mpl, CONSTRAINT *con) "
/**
 */
public";

%javamethodmodifiers iter_num_func(MPL *mpl, void *_info) "
/**
 */
public";

%javamethodmodifiers eval_numeric(MPL *mpl, CODE *code) "
/**
 */
public";

%javamethodmodifiers eval_symbolic(MPL *mpl, CODE *code) "
/**
 */
public";

%javamethodmodifiers iter_log_func(MPL *mpl, void *_info) "
/**
 */
public";

%javamethodmodifiers eval_logical(MPL *mpl, CODE *code) "
/**
 */
public";

%javamethodmodifiers eval_tuple(MPL *mpl, CODE *code) "
/**
 */
public";

%javamethodmodifiers iter_set_func(MPL *mpl, void *_info) "
/**
 */
public";

%javamethodmodifiers eval_elemset(MPL *mpl, CODE *code) "
/**
 */
public";

%javamethodmodifiers null_func(MPL *mpl, void *info) "
/**
 */
public";

%javamethodmodifiers is_member(MPL *mpl, CODE *code, TUPLE *tuple) "
/**
 */
public";

%javamethodmodifiers iter_form_func(MPL *mpl, void *_info) "
/**
 */
public";

%javamethodmodifiers eval_formula(MPL *mpl, CODE *code) "
/**
 */
public";

%javamethodmodifiers clean_code(MPL *mpl, CODE *code) "
/**
 */
public";

%javamethodmodifiers mpl_tab_num_args(TABDCA *dca) "
/**
 */
public";

%javamethodmodifiers mpl_tab_get_arg(TABDCA *dca, int k) "
/**
 */
public";

%javamethodmodifiers mpl_tab_num_flds(TABDCA *dca) "
/**
 */
public";

%javamethodmodifiers mpl_tab_get_name(TABDCA *dca, int k) "
/**
 */
public";

%javamethodmodifiers mpl_tab_get_type(TABDCA *dca, int k) "
/**
 */
public";

%javamethodmodifiers mpl_tab_get_num(TABDCA *dca, int k) "
/**
 */
public";

%javamethodmodifiers mpl_tab_get_str(TABDCA *dca, int k) "
/**
 */
public";

%javamethodmodifiers mpl_tab_set_num(TABDCA *dca, int k, double num) "
/**
 */
public";

%javamethodmodifiers mpl_tab_set_str(TABDCA *dca, int k, const char *str) "
/**
 */
public";

%javamethodmodifiers write_func(MPL *mpl, void *info) "
/**
 */
public";

%javamethodmodifiers execute_table(MPL *mpl, TABLE *tab) "
/**
 */
public";

%javamethodmodifiers free_dca(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers clean_table(MPL *mpl, TABLE *tab) "
/**
 */
public";

%javamethodmodifiers check_func(MPL *mpl, void *info) "
/**
 */
public";

%javamethodmodifiers execute_check(MPL *mpl, CHECK *chk) "
/**
 */
public";

%javamethodmodifiers clean_check(MPL *mpl, CHECK *chk) "
/**
 */
public";

%javamethodmodifiers display_set(MPL *mpl, SET *set, MEMBER *memb) "
/**
 */
public";

%javamethodmodifiers display_par(MPL *mpl, PARAMETER *par, MEMBER *memb) "
/**
 */
public";

%javamethodmodifiers display_var(MPL *mpl, VARIABLE *var, MEMBER *memb, int suff) "
/**
 */
public";

%javamethodmodifiers display_con(MPL *mpl, CONSTRAINT *con, MEMBER *memb, int suff) "
/**
 */
public";

%javamethodmodifiers display_memb(MPL *mpl, CODE *code) "
/**
 */
public";

%javamethodmodifiers display_code(MPL *mpl, CODE *code) "
/**
 */
public";

%javamethodmodifiers display_func(MPL *mpl, void *info) "
/**
 */
public";

%javamethodmodifiers execute_display(MPL *mpl, DISPLAY *dpy) "
/**
 */
public";

%javamethodmodifiers clean_display(MPL *mpl, DISPLAY *dpy) "
/**
 */
public";

%javamethodmodifiers print_char(MPL *mpl, int c) "
/**
 */
public";

%javamethodmodifiers print_text(MPL *mpl, char *fmt,...) "
/**
 */
public";

%javamethodmodifiers printf_func(MPL *mpl, void *info) "
/**
 */
public";

%javamethodmodifiers execute_printf(MPL *mpl, PRINTF *prt) "
/**
 */
public";

%javamethodmodifiers clean_printf(MPL *mpl, PRINTF *prt) "
/**
 */
public";

%javamethodmodifiers for_func(MPL *mpl, void *info) "
/**
 */
public";

%javamethodmodifiers execute_for(MPL *mpl, FOR *fur) "
/**
 */
public";

%javamethodmodifiers clean_for(MPL *mpl, FOR *fur) "
/**
 */
public";

%javamethodmodifiers execute_statement(MPL *mpl, STATEMENT *stmt) "
/**
 */
public";

%javamethodmodifiers clean_statement(MPL *mpl, STATEMENT *stmt) "
/**
 */
public";

%javamethodmodifiers alloc_content(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers generate_model(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers build_problem(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers postsolve_model(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers clean_model(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers open_input(MPL *mpl, char *file) "
/**
 */
public";

%javamethodmodifiers read_char(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers close_input(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers open_output(MPL *mpl, char *file) "
/**
 */
public";

%javamethodmodifiers write_char(MPL *mpl, int c) "
/**
 */
public";

%javamethodmodifiers write_text(MPL *mpl, char *fmt,...) "
/**
 */
public";

%javamethodmodifiers flush_output(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers error(MPL *mpl, char *fmt,...) "
/**
 */
public";

%javamethodmodifiers warning(MPL *mpl, char *fmt,...) "
/**
 */
public";

%javamethodmodifiers mpl_initialize(void) "
/**
 */
public";

%javamethodmodifiers mpl_read_model(MPL *mpl, char *file, int skip_data) "
/**
 */
public";

%javamethodmodifiers mpl_read_data(MPL *mpl, char *file) "
/**
 */
public";

%javamethodmodifiers mpl_generate(MPL *mpl, char *file) "
/**
 */
public";

%javamethodmodifiers mpl_get_prob_name(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers mpl_get_num_rows(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers mpl_get_num_cols(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers mpl_get_row_name(MPL *mpl, int i) "
/**
 */
public";

%javamethodmodifiers mpl_get_row_kind(MPL *mpl, int i) "
/**
 */
public";

%javamethodmodifiers mpl_get_row_bnds(MPL *mpl, int i, double *_lb, double *_ub) "
/**
 */
public";

%javamethodmodifiers mpl_get_mat_row(MPL *mpl, int i, int ndx[], double val[]) "
/**
 */
public";

%javamethodmodifiers mpl_get_row_c0(MPL *mpl, int i) "
/**
 */
public";

%javamethodmodifiers mpl_get_col_name(MPL *mpl, int j) "
/**
 */
public";

%javamethodmodifiers mpl_get_col_kind(MPL *mpl, int j) "
/**
 */
public";

%javamethodmodifiers mpl_get_col_bnds(MPL *mpl, int j, double *_lb, double *_ub) "
/**
 */
public";

%javamethodmodifiers mpl_has_solve_stmt(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers mpl_put_row_soln(MPL *mpl, int i, int stat, double prim, double dual) "
/**
 */
public";

%javamethodmodifiers mpl_put_col_soln(MPL *mpl, int j, int stat, double prim, double dual) "
/**
 */
public";

%javamethodmodifiers mpl_postsolve(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers mpl_terminate(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers fn_gmtime(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers error1(MPL *mpl, const char *str, const char *s, const char *fmt, const char *f, const char *msg) "
/**
 */
public";

%javamethodmodifiers fn_str2time(MPL *mpl, const char *str, const char *fmt) "
/**
 */
public";

%javamethodmodifiers error2(MPL *mpl, const char *fmt, const char *f, const char *msg) "
/**
 */
public";

%javamethodmodifiers weekday(int j) "
/**
 */
public";

%javamethodmodifiers firstday(int year) "
/**
 */
public";

%javamethodmodifiers fn_time2str(MPL *mpl, char *str, double t, const char *fmt) "
/**
 */
public";

%javamethodmodifiers read_char(struct csv *csv) "
/**
 */
public";

%javamethodmodifiers read_field(struct csv *csv) "
/**
 */
public";

%javamethodmodifiers csv_open_file(TABDCA *dca, int mode) "
/**
 */
public";

%javamethodmodifiers csv_read_record(TABDCA *dca, struct csv *csv) "
/**
 */
public";

%javamethodmodifiers csv_write_record(TABDCA *dca, struct csv *csv) "
/**
 */
public";

%javamethodmodifiers csv_close_file(TABDCA *dca, struct csv *csv) "
/**
 */
public";

%javamethodmodifiers read_byte(struct dbf *dbf) "
/**
 */
public";

%javamethodmodifiers read_header(TABDCA *dca, struct dbf *dbf) "
/**
 */
public";

%javamethodmodifiers parse_third_arg(TABDCA *dca, struct dbf *dbf) "
/**
 */
public";

%javamethodmodifiers write_byte(struct dbf *dbf, int b) "
/**
 */
public";

%javamethodmodifiers write_header(TABDCA *dca, struct dbf *dbf) "
/**
 */
public";

%javamethodmodifiers dbf_open_file(TABDCA *dca, int mode) "
/**
 */
public";

%javamethodmodifiers dbf_read_record(TABDCA *dca, struct dbf *dbf) "
/**
 */
public";

%javamethodmodifiers dbf_write_record(TABDCA *dca, struct dbf *dbf) "
/**
 */
public";

%javamethodmodifiers dbf_close_file(TABDCA *dca, struct dbf *dbf) "
/**
 */
public";

%javamethodmodifiers mpl_tab_drv_open(MPL *mpl, int mode) "
/**
 */
public";

%javamethodmodifiers mpl_tab_drv_read(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers mpl_tab_drv_write(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers mpl_tab_drv_close(MPL *mpl) "
/**
 */
public";

%javamethodmodifiers glp_init_mpscp(glp_mpscp *parm) "
/**
 * glp_init_mpscp - initialize MPS format control parameters .
 * <p>SYNOPSIS</p>
 * <p>void glp_init_mpscp(glp_mpscp *parm);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_init_mpscp initializes control parameters, which are used by the MPS input/output routines glp_read_mps and glp_write_mps, with default values.</p>
 * <p>Default values of the control parameters are stored in the glp_mpscp structure, which the parameter parm points to. </p>
 */
public";

%javamethodmodifiers check_parm(const char *func, const glp_mpscp *parm) "
/**
 */
public";

%javamethodmodifiers error(struct csa *csa, const char *fmt,...) "
/**
 */
public";

%javamethodmodifiers warning(struct csa *csa, const char *fmt,...) "
/**
 */
public";

%javamethodmodifiers read_char(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers indicator(struct csa *csa, int name) "
/**
 */
public";

%javamethodmodifiers read_field(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers patch_name(struct csa *csa, char *name) "
/**
 */
public";

%javamethodmodifiers read_number(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers skip_field(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers read_name(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers read_rows(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers read_columns(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers read_rhs(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers read_ranges(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers read_bounds(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers glp_read_mps(glp_prob *P, int fmt, const glp_mpscp *parm, const char *fname) "
/**
 */
public";

%javamethodmodifiers mps_name(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers row_name(struct csa *csa, int i) "
/**
 */
public";

%javamethodmodifiers col_name(struct csa *csa, int j) "
/**
 */
public";

%javamethodmodifiers mps_numb(struct csa *csa, double val) "
/**
 */
public";

%javamethodmodifiers glp_write_mps(glp_prob *P, int fmt, const glp_mpscp *parm, const char *fname) "
/**
 */
public";

%javamethodmodifiers mc21a(int n, const int icn[], const int ip[], const int lenr[], int iperm[], int pr[], int arp[], int cv[], int out[]) "
/**
 * mc21a - permutations for zero-free diagonal .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnet.h\" int mc21a(int n, const int icn[], const int ip[], const int lenr[], int iperm[], int pr[], int arp[], int cv[], int out[]);</p>
 * <p>DESCRIPTION</p>
 * <p>Given the pattern of nonzeros of a sparse matrix, the routine mc21a attempts to find a permutation of its rows that makes the matrix have no zeros on its diagonal.</p>
 * <p>INPUT PARAMETERS</p>
 * <p>n order of matrix.</p>
 * <p>icn array containing the column indices of the non-zeros. Those belonging to a single row must be contiguous but the ordering of column indices within each row is unimportant and wasted space between rows is permitted.</p>
 * <p>ip ip[i], i = 1,2,...,n, is the position in array icn of the first column index of a non-zero in row i.</p>
 * <p>lenr lenr[i], i = 1,2,...,n, is the number of non-zeros in row i.</p>
 * <p>OUTPUT PARAMETER</p>
 * <p>iperm contains permutation to make diagonal have the smallest number of zeros on it. Elements (iperm[i], i), i = 1,2,...,n, are non-zero at the end of the algorithm unless the matrix is structurally singular. In this case, (iperm[i], i) will be zero for n - numnz entries.</p>
 * <p>WORKING ARRAYS</p>
 * <p>pr working array of length [1+n], where pr[0] is not used. pr[i] is the previous row to i in the depth first search.</p>
 * <p>arp working array of length [1+n], where arp[0] is not used. arp[i] is one less than the number of non-zeros in row i which have not been scanned when looking for a cheap assignment.</p>
 * <p>cv working array of length [1+n], where cv[0] is not used. cv[i] is the most recent row extension at which column i was visited.</p>
 * <p>out working array of length [1+n], where out[0] is not used. out[i] is one less than the number of non-zeros in row i which have not been scanned during one pass through the main loop.</p>
 * <p>RETURNS</p>
 * <p>The routine mc21a returns numnz, the number of non-zeros on diagonal of permuted matrix. </p>
 */
public";

%javamethodmodifiers mc13d(int n, const int icn[], const int ip[], const int lenr[], int ior[], int ib[], int lowl[], int numb[], int prev[]) "
/**
 * mc13d - permutations to block triangular form .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnet.h\" int mc13d(int n, const int icn[], const int ip[], const int lenr[], int ior[], int ib[], int lowl[], int numb[], int prev[]);</p>
 * <p>DESCRIPTION</p>
 * <p>Given the column numbers of the nonzeros in each row of the sparse matrix, the routine mc13d finds a symmetric permutation that makes the matrix block lower triangular.</p>
 * <p>INPUT PARAMETERS</p>
 * <p>n order of the matrix.</p>
 * <p>icn array containing the column indices of the non-zeros. Those belonging to a single row must be contiguous but the ordering of column indices within each row is unimportant and wasted space between rows is permitted.</p>
 * <p>ip ip[i], i = 1,2,...,n, is the position in array icn of the first column index of a non-zero in row i.</p>
 * <p>lenr lenr[i], i = 1,2,...,n, is the number of non-zeros in row i.</p>
 * <p>OUTPUT PARAMETERS</p>
 * <p>ior ior[i], i = 1,2,...,n, gives the position on the original ordering of the row or column which is in position i in the permuted form.</p>
 * <p>ib ib[i], i = 1,2,...,num, is the row number in the permuted matrix of the beginning of block i, 1 <= num <= n.</p>
 * <p>WORKING ARRAYS</p>
 * <p>arp working array of length [1+n], where arp[0] is not used. arp[i] is one less than the number of unsearched edges leaving node i. At the end of the algorithm it is set to a permutation which puts the matrix in block lower triangular form.</p>
 * <p>ib working array of length [1+n], where ib[0] is not used. ib[i] is the position in the ordering of the start of the ith block. ib[n+1-i] holds the node number of the ith node on the stack.</p>
 * <p>lowl working array of length [1+n], where lowl[0] is not used. lowl[i] is the smallest stack position of any node to which a path from node i has been found. It is set to n+1 when node i is removed from the stack.</p>
 * <p>numb working array of length [1+n], where numb[0] is not used. numb[i] is the position of node i in the stack if it is on it, is the permuted order of node i for those nodes whose final position has been found and is otherwise zero.</p>
 * <p>prev working array of length [1+n], where prev[0] is not used. prev[i] is the node at the end of the path when node i was placed on the stack.</p>
 * <p>RETURNS</p>
 * <p>The routine mc13d returns num, the number of blocks found. </p>
 */
public";

%javamethodmodifiers okalg(int nv, int na, const int tail[], const int head[], const int low[], const int cap[], const int cost[], int x[], int pi[]) "
/**
 */
public";

%javamethodmodifiers ffalg(int nv, int na, const int tail[], const int head[], int s, int t, const int cap[], int x[], char cut[]) "
/**
 * ffalg - Ford-Fulkerson algorithm .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnet.h\" void ffalg(int nv, int na, const int tail[], const int head[], int s, int t, const int cap[], int x[], char cut[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ffalg implements the Ford-Fulkerson algorithm to find a maximal flow in the specified flow network.</p>
 * <p>INPUT PARAMETERS</p>
 * <p>nv is the number of nodes, nv >= 2.</p>
 * <p>na is the number of arcs, na >= 0.</p>
 * <p>tail[a], a = 1,...,na, is the index of tail node of arc a.</p>
 * <p>head[a], a = 1,...,na, is the index of head node of arc a.</p>
 * <p>s is the source node index, 1 <= s <= nv.</p>
 * <p>t is the sink node index, 1 <= t <= nv, t != s.</p>
 * <p>cap[a], a = 1,...,na, is the capacity of arc a, cap[a] >= 0.</p>
 * <p>NOTE: Multiple arcs are allowed, but self-loops are not allowed.</p>
 * <p>OUTPUT PARAMETERS</p>
 * <p>x[a], a = 1,...,na, is optimal value of the flow through arc a.</p>
 * <p>cut[i], i = 1,...,nv, is 1 if node i is labelled, and 0 otherwise. The set of arcs, whose one endpoint is labelled and other is not, defines the minimal cut corresponding to the maximal flow found. If the parameter cut is NULL, the cut information are not stored.</p>
 * <p>REFERENCES</p>
 * <p>L.R.Ford, Jr., and D.R.Fulkerson, \"Flows in Networks,\" The RAND Corp., Report R-375-PR (August 1962), Chap. I \"Static Maximal Flow,\" pp.30-33. </p>
 */
public";

%javamethodmodifiers wclique(int n, const int w[], const unsigned char a[], int ind[]) "
/**
 */
public";

%javamethodmodifiers kellerman(int n, int(*func)(void *info, int i, int ind[]), void *info, void *H) "
/**
 */
public";

%javamethodmodifiers mc21a(int n, const int icn[], const int ip[], const int lenr[], int iperm[], int pr[], int arp[], int cv[], int out[]) "
/**
 * mc21a - permutations for zero-free diagonal .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnet.h\" int mc21a(int n, const int icn[], const int ip[], const int lenr[], int iperm[], int pr[], int arp[], int cv[], int out[]);</p>
 * <p>DESCRIPTION</p>
 * <p>Given the pattern of nonzeros of a sparse matrix, the routine mc21a attempts to find a permutation of its rows that makes the matrix have no zeros on its diagonal.</p>
 * <p>INPUT PARAMETERS</p>
 * <p>n order of matrix.</p>
 * <p>icn array containing the column indices of the non-zeros. Those belonging to a single row must be contiguous but the ordering of column indices within each row is unimportant and wasted space between rows is permitted.</p>
 * <p>ip ip[i], i = 1,2,...,n, is the position in array icn of the first column index of a non-zero in row i.</p>
 * <p>lenr lenr[i], i = 1,2,...,n, is the number of non-zeros in row i.</p>
 * <p>OUTPUT PARAMETER</p>
 * <p>iperm contains permutation to make diagonal have the smallest number of zeros on it. Elements (iperm[i], i), i = 1,2,...,n, are non-zero at the end of the algorithm unless the matrix is structurally singular. In this case, (iperm[i], i) will be zero for n - numnz entries.</p>
 * <p>WORKING ARRAYS</p>
 * <p>pr working array of length [1+n], where pr[0] is not used. pr[i] is the previous row to i in the depth first search.</p>
 * <p>arp working array of length [1+n], where arp[0] is not used. arp[i] is one less than the number of non-zeros in row i which have not been scanned when looking for a cheap assignment.</p>
 * <p>cv working array of length [1+n], where cv[0] is not used. cv[i] is the most recent row extension at which column i was visited.</p>
 * <p>out working array of length [1+n], where out[0] is not used. out[i] is one less than the number of non-zeros in row i which have not been scanned during one pass through the main loop.</p>
 * <p>RETURNS</p>
 * <p>The routine mc21a returns numnz, the number of non-zeros on diagonal of permuted matrix. </p>
 */
public";

%javamethodmodifiers mc13d(int n, const int icn[], const int ip[], const int lenr[], int ior[], int ib[], int lowl[], int numb[], int prev[]) "
/**
 * mc13d - permutations to block triangular form .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnet.h\" int mc13d(int n, const int icn[], const int ip[], const int lenr[], int ior[], int ib[], int lowl[], int numb[], int prev[]);</p>
 * <p>DESCRIPTION</p>
 * <p>Given the column numbers of the nonzeros in each row of the sparse matrix, the routine mc13d finds a symmetric permutation that makes the matrix block lower triangular.</p>
 * <p>INPUT PARAMETERS</p>
 * <p>n order of the matrix.</p>
 * <p>icn array containing the column indices of the non-zeros. Those belonging to a single row must be contiguous but the ordering of column indices within each row is unimportant and wasted space between rows is permitted.</p>
 * <p>ip ip[i], i = 1,2,...,n, is the position in array icn of the first column index of a non-zero in row i.</p>
 * <p>lenr lenr[i], i = 1,2,...,n, is the number of non-zeros in row i.</p>
 * <p>OUTPUT PARAMETERS</p>
 * <p>ior ior[i], i = 1,2,...,n, gives the position on the original ordering of the row or column which is in position i in the permuted form.</p>
 * <p>ib ib[i], i = 1,2,...,num, is the row number in the permuted matrix of the beginning of block i, 1 <= num <= n.</p>
 * <p>WORKING ARRAYS</p>
 * <p>arp working array of length [1+n], where arp[0] is not used. arp[i] is one less than the number of unsearched edges leaving node i. At the end of the algorithm it is set to a permutation which puts the matrix in block lower triangular form.</p>
 * <p>ib working array of length [1+n], where ib[0] is not used. ib[i] is the position in the ordering of the start of the ith block. ib[n+1-i] holds the node number of the ith node on the stack.</p>
 * <p>lowl working array of length [1+n], where lowl[0] is not used. lowl[i] is the smallest stack position of any node to which a path from node i has been found. It is set to n+1 when node i is removed from the stack.</p>
 * <p>numb working array of length [1+n], where numb[0] is not used. numb[i] is the position of node i in the stack if it is on it, is the permuted order of node i for those nodes whose final position has been found and is otherwise zero.</p>
 * <p>prev working array of length [1+n], where prev[0] is not used. prev[i] is the node at the end of the path when node i was placed on the stack.</p>
 * <p>RETURNS</p>
 * <p>The routine mc13d returns num, the number of blocks found. </p>
 */
public";

%javamethodmodifiers cresup(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers chain(struct csa *csa, int lpick, int lsorc) "
/**
 */
public";

%javamethodmodifiers chnarc(struct csa *csa, int lsorc) "
/**
 */
public";

%javamethodmodifiers sort(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers pickj(struct csa *csa, int it) "
/**
 */
public";

%javamethodmodifiers assign(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers setran(struct csa *csa, int iseed) "
/**
 */
public";

%javamethodmodifiers iran(struct csa *csa, int ilow, int ihigh) "
/**
 */
public";

%javamethodmodifiers glp_netgen(glp_graph *G_, int _v_rhs, int _a_cap, int _a_cost, const int parm[1+15]) "
/**
 */
public";

%javamethodmodifiers glp_netgen_prob(int nprob, int parm[1+15]) "
/**
 */
public";

%javamethodmodifiers assign_capacities(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers assign_costs(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers assign_imbalance(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers exponential(struct csa *csa, double lambda[1]) "
/**
 */
public";

%javamethodmodifiers gen_additional_arcs(struct csa *csa, struct arcs *arc_ptr) "
/**
 */
public";

%javamethodmodifiers gen_basic_grid(struct csa *csa, struct arcs *arc_ptr) "
/**
 */
public";

%javamethodmodifiers gen_more_arcs(struct csa *csa, struct arcs *arc_ptr) "
/**
 */
public";

%javamethodmodifiers generate(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers output(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers randy(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers select_source_sinks(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers uniform(struct csa *csa, double a[2]) "
/**
 */
public";

%javamethodmodifiers glp_gridgen(glp_graph *G_, int _v_rhs, int _a_cap, int _a_cost, const int parm[1+14]) "
/**
 */
public";

%javamethodmodifiers make_edge(struct csa *csa, int from, int to, int c1, int c2) "
/**
 */
public";

%javamethodmodifiers permute(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers connect(struct csa *csa, int offset, int cv, int x1, int y1) "
/**
 */
public";

%javamethodmodifiers gen_rmf(struct csa *csa, int a, int b, int c1, int c2) "
/**
 */
public";

%javamethodmodifiers print_max_format(struct csa *csa, network *n, char *comm[], int dim) "
/**
 */
public";

%javamethodmodifiers gen_free_net(network *n) "
/**
 */
public";

%javamethodmodifiers glp_rmfgen(glp_graph *G_, int *_s, int *_t, int _a_cap, const int parm[1+5]) "
/**
 */
public";

%javamethodmodifiers overflow(int u, int v) "
/**
 * okalg - out-of-kilter algorithm .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnet.h\" int okalg(int nv, int na, const int tail[], const int head[], const int low[], const int cap[], const int cost[], int x[], int pi[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine okalg implements the out-of-kilter algorithm to find a minimal-cost circulation in the specified flow network.</p>
 * <p>INPUT PARAMETERS</p>
 * <p>nv is the number of nodes, nv >= 0.</p>
 * <p>na is the number of arcs, na >= 0.</p>
 * <p>tail[a], a = 1,...,na, is the index of tail node of arc a.</p>
 * <p>head[a], a = 1,...,na, is the index of head node of arc a.</p>
 * <p>low[a], a = 1,...,na, is an lower bound to the flow through arc a.</p>
 * <p>cap[a], a = 1,...,na, is an upper bound to the flow through arc a, which is the capacity of the arc.</p>
 * <p>cost[a], a = 1,...,na, is a per-unit cost of the flow through arc a.</p>
 * <p>NOTES</p>
 * <p>1. Multiple arcs are allowed, but self-loops are not allowed.</p>
 * <p>2. It is required that 0 <= low[a] <= cap[a] for all arcs.</p>
 * <p>3. Arc costs may have any sign.</p>
 * <p>OUTPUT PARAMETERS</p>
 * <p>x[a], a = 1,...,na, is optimal value of the flow through arc a.</p>
 * <p>pi[i], i = 1,...,nv, is Lagrange multiplier for flow conservation equality constraint corresponding to node i (the node potential).</p>
 * <p>RETURNS</p>
 * <p>0 optimal circulation found;</p>
 * <p>1 there is no feasible circulation;</p>
 * <p>2 integer overflow occured;</p>
 * <p>3 optimality test failed (logic error).</p>
 * <p>REFERENCES</p>
 * <p>L.R.Ford, Jr., and D.R.Fulkerson, \"Flows in Networks,\" The RAND Corp., Report R-375-PR (August 1962), Chap. III \"Minimal Cost Flow
  Problems,\" pp.113-26. </p>
 */
public";

%javamethodmodifiers okalg(int nv, int na, const int tail[], const int head[], const int low[], const int cap[], const int cost[], int x[], int pi[]) "
/**
 */
public";

%javamethodmodifiers ffalg(int nv, int na, const int tail[], const int head[], int s, int t, const int cap[], int x[], char cut[]) "
/**
 * ffalg - Ford-Fulkerson algorithm .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnet.h\" void ffalg(int nv, int na, const int tail[], const int head[], int s, int t, const int cap[], int x[], char cut[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine ffalg implements the Ford-Fulkerson algorithm to find a maximal flow in the specified flow network.</p>
 * <p>INPUT PARAMETERS</p>
 * <p>nv is the number of nodes, nv >= 2.</p>
 * <p>na is the number of arcs, na >= 0.</p>
 * <p>tail[a], a = 1,...,na, is the index of tail node of arc a.</p>
 * <p>head[a], a = 1,...,na, is the index of head node of arc a.</p>
 * <p>s is the source node index, 1 <= s <= nv.</p>
 * <p>t is the sink node index, 1 <= t <= nv, t != s.</p>
 * <p>cap[a], a = 1,...,na, is the capacity of arc a, cap[a] >= 0.</p>
 * <p>NOTE: Multiple arcs are allowed, but self-loops are not allowed.</p>
 * <p>OUTPUT PARAMETERS</p>
 * <p>x[a], a = 1,...,na, is optimal value of the flow through arc a.</p>
 * <p>cut[i], i = 1,...,nv, is 1 if node i is labelled, and 0 otherwise. The set of arcs, whose one endpoint is labelled and other is not, defines the minimal cut corresponding to the maximal flow found. If the parameter cut is NULL, the cut information are not stored.</p>
 * <p>REFERENCES</p>
 * <p>L.R.Ford, Jr., and D.R.Fulkerson, \"Flows in Networks,\" The RAND Corp., Report R-375-PR (August 1962), Chap. I \"Static Maximal Flow,\" pp.30-33. </p>
 */
public";

%javamethodmodifiers sub(struct csa *csa, int ct, int table[], int level, int weight, int l_weight) "
/**
 */
public";

%javamethodmodifiers wclique(int _n, const int w[], const unsigned char _a[], int ind[]) "
/**
 */
public";

%javamethodmodifiers kellerman(int n, int(*func)(void *info, int i, int ind[]), void *info, void *H_) "
/**
 */
public";

%javamethodmodifiers npp_create_wksp(void) "
/**
 */
public";

%javamethodmodifiers npp_insert_row(NPP *npp, NPPROW *row, int where) "
/**
 */
public";

%javamethodmodifiers npp_remove_row(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_activate_row(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_deactivate_row(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_insert_col(NPP *npp, NPPCOL *col, int where) "
/**
 */
public";

%javamethodmodifiers npp_remove_col(NPP *npp, NPPCOL *col) "
/**
 */
public";

%javamethodmodifiers npp_activate_col(NPP *npp, NPPCOL *col) "
/**
 */
public";

%javamethodmodifiers npp_deactivate_col(NPP *npp, NPPCOL *col) "
/**
 */
public";

%javamethodmodifiers npp_add_row(NPP *npp) "
/**
 */
public";

%javamethodmodifiers npp_add_col(NPP *npp) "
/**
 */
public";

%javamethodmodifiers npp_add_aij(NPP *npp, NPPROW *row, NPPCOL *col, double val) "
/**
 */
public";

%javamethodmodifiers npp_row_nnz(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_col_nnz(NPP *npp, NPPCOL *col) "
/**
 */
public";

%javamethodmodifiers npp_push_tse(NPP *npp, int(*func)(NPP *npp, void *info), int size) "
/**
 */
public";

%javamethodmodifiers npp_erase_row(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_del_row(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_del_col(NPP *npp, NPPCOL *col) "
/**
 */
public";

%javamethodmodifiers npp_del_aij(NPP *npp, NPPAIJ *aij) "
/**
 */
public";

%javamethodmodifiers npp_load_prob(NPP *npp, glp_prob *orig, int names, int sol, int scaling) "
/**
 */
public";

%javamethodmodifiers npp_build_prob(NPP *npp, glp_prob *prob) "
/**
 */
public";

%javamethodmodifiers npp_postprocess(NPP *npp, glp_prob *prob) "
/**
 */
public";

%javamethodmodifiers npp_unload_sol(NPP *npp, glp_prob *orig) "
/**
 */
public";

%javamethodmodifiers npp_delete_wksp(NPP *npp) "
/**
 */
public";

%javamethodmodifiers npp_free_row(NPP *npp, NPPROW *p) "
/**
 */
public";

%javamethodmodifiers npp_geq_row(NPP *npp, NPPROW *p) "
/**
 */
public";

%javamethodmodifiers npp_leq_row(NPP *npp, NPPROW *p) "
/**
 */
public";

%javamethodmodifiers npp_free_col(NPP *npp, NPPCOL *q) "
/**
 */
public";

%javamethodmodifiers npp_lbnd_col(NPP *npp, NPPCOL *q) "
/**
 */
public";

%javamethodmodifiers npp_ubnd_col(NPP *npp, NPPCOL *q) "
/**
 */
public";

%javamethodmodifiers npp_dbnd_col(NPP *npp, NPPCOL *q) "
/**
 */
public";

%javamethodmodifiers npp_fixed_col(NPP *npp, NPPCOL *q) "
/**
 */
public";

%javamethodmodifiers npp_make_equality(NPP *npp, NPPROW *p) "
/**
 */
public";

%javamethodmodifiers npp_make_fixed(NPP *npp, NPPCOL *q) "
/**
 */
public";

%javamethodmodifiers npp_empty_row(NPP *npp, NPPROW *p) "
/**
 * npp_empty_row - process empty row .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" int npp_empty_row(NPP *npp, NPPROW *p);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine npp_empty_row processes row p, which is empty, i.e. coefficients at all columns in this row are zero:</p>
 * <p>L[p] <= sum 0 x[j] <= U[p], (1)</p>
 * <p>where L[p] <= U[p].</p>
 * <p>RETURNS</p>
 * <p>0 - success;</p>
 * <p>1 - problem has no primal feasible solution.</p>
 * <p>PROBLEM TRANSFORMATION</p>
 * <p>If the following conditions hold:</p>
 * <p>L[p] <= +eps, U[p] >= -eps, (2)</p>
 * <p>where eps is an absolute tolerance for row value, the row p is redundant. In this case it can be replaced by equivalent redundant row, which is free (unbounded), and then removed from the problem. Otherwise, the row p is infeasible and, thus, the problem has no primal feasible solution.</p>
 * <p>RECOVERING BASIC SOLUTION</p>
 * <p>See the routine npp_free_row.</p>
 * <p>RECOVERING INTERIOR-POINT SOLUTION</p>
 * <p>See the routine npp_free_row.</p>
 * <p>RECOVERING MIP SOLUTION</p>
 * <p>None needed. </p>
 */
public";

%javamethodmodifiers npp_empty_col(NPP *npp, NPPCOL *q) "
/**
 */
public";

%javamethodmodifiers npp_implied_value(NPP *npp, NPPCOL *q, double s) "
/**
 * npp_implied_value - process implied column value .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" int npp_implied_value(NPP *npp, NPPCOL *q, double s);</p>
 * <p>DESCRIPTION</p>
 * <p>For column q:</p>
 * <p>l[q] <= x[q] <= u[q], (1)</p>
 * <p>where l[q] < u[q], the routine npp_implied_value processes its implied value s[q]. If this implied value satisfies to the current column bounds and integrality condition, the routine fixes column q at the given point. Note that the column is kept in the problem in any case.</p>
 * <p>RETURNS</p>
 * <p>0 - column has been fixed;</p>
 * <p>1 - implied value violates to current column bounds;</p>
 * <p>2 - implied value violates integrality condition.</p>
 * <p>ALGORITHM</p>
 * <p>Implied column value s[q] satisfies to the current column bounds if the following condition holds:</p>
 * <p>l[q] - eps <= s[q] <= u[q] + eps, (2)</p>
 * <p>where eps is an absolute tolerance for column value. If the column is integral, the following condition also must hold:</p>
 * <p>|s[q] - floor(s[q]+0.5)| <= eps, (3)</p>
 * <p>where floor(s[q]+0.5) is the nearest integer to s[q].</p>
 * <p>If both condition (2) and (3) are satisfied, the column can be fixed at the value s[q], or, if it is integral, at floor(s[q]+0.5). Otherwise, if s[q] violates (2) or (3), the problem has no feasible solution.</p>
 * <p>Note: If s[q] is close to l[q] or u[q], it seems to be reasonable to fix the column at its lower or upper bound, resp. rather than at the implied value. </p>
 */
public";

%javamethodmodifiers npp_eq_singlet(NPP *npp, NPPROW *p) "
/**
 */
public";

%javamethodmodifiers npp_implied_lower(NPP *npp, NPPCOL *q, double l) "
/**
 * npp_implied_lower - process implied column lower bound .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" int npp_implied_lower(NPP *npp, NPPCOL *q, double l);</p>
 * <p>DESCRIPTION</p>
 * <p>For column q:</p>
 * <p>l[q] <= x[q] <= u[q], (1)</p>
 * <p>where l[q] < u[q], the routine npp_implied_lower processes its implied lower bound l'[q]. As the result the current column lower bound may increase. Note that the column is kept in the problem in any case.</p>
 * <p>RETURNS</p>
 * <p>0 - current column lower bound has not changed;</p>
 * <p>1 - current column lower bound has changed, but not significantly;</p>
 * <p>2 - current column lower bound has significantly changed;</p>
 * <p>3 - column has been fixed on its upper bound;</p>
 * <p>4 - implied lower bound violates current column upper bound.</p>
 * <p>ALGORITHM</p>
 * <p>If column q is integral, before processing its implied lower bound should be rounded up:</p>
 * <p>( floor(l'[q]+0.5), if |l'[q] - floor(l'[q]+0.5)| <= eps l'[q] := < (2) ( ceil(l'[q]), otherwise</p>
 * <p>where floor(l'[q]+0.5) is the nearest integer to l'[q], ceil(l'[q]) is smallest integer not less than l'[q], and eps is an absolute tolerance for column value.</p>
 * <p>Processing implied column lower bound l'[q] includes the following cases:</p>
 * <p>1) if l'[q] < l[q] + eps, implied lower bound is redundant;</p>
 * <p>2) if l[q] + eps <= l[q] <= u[q] + eps, current column lower bound l[q] can be strengthened by replacing it with l'[q]. If in this case new column lower bound becomes close to current column upper bound u[q], the column can be fixed on its upper bound;</p>
 * <p>3) if l'[q] > u[q] + eps, implied lower bound violates current column upper bound u[q], in which case the problem has no primal feasible solution. </p>
 */
public";

%javamethodmodifiers npp_implied_upper(NPP *npp, NPPCOL *q, double u) "
/**
 * npp_implied_upper - process implied column upper bound .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" int npp_implied_upper(NPP *npp, NPPCOL *q, double u);</p>
 * <p>DESCRIPTION</p>
 * <p>For column q:</p>
 * <p>l[q] <= x[q] <= u[q], (1)</p>
 * <p>where l[q] < u[q], the routine npp_implied_upper processes its implied upper bound u'[q]. As the result the current column upper bound may decrease. Note that the column is kept in the problem in any case.</p>
 * <p>RETURNS</p>
 * <p>0 - current column upper bound has not changed;</p>
 * <p>1 - current column upper bound has changed, but not significantly;</p>
 * <p>2 - current column upper bound has significantly changed;</p>
 * <p>3 - column has been fixed on its lower bound;</p>
 * <p>4 - implied upper bound violates current column lower bound.</p>
 * <p>ALGORITHM</p>
 * <p>If column q is integral, before processing its implied upper bound should be rounded down:</p>
 * <p>( floor(u'[q]+0.5), if |u'[q] - floor(l'[q]+0.5)| <= eps u'[q] := < (2) ( floor(l'[q]), otherwise</p>
 * <p>where floor(u'[q]+0.5) is the nearest integer to u'[q], floor(u'[q]) is largest integer not greater than u'[q], and eps is an absolute tolerance for column value.</p>
 * <p>Processing implied column upper bound u'[q] includes the following cases:</p>
 * <p>1) if u'[q] > u[q] - eps, implied upper bound is redundant;</p>
 * <p>2) if l[q] - eps <= u[q] <= u[q] - eps, current column upper bound u[q] can be strengthened by replacing it with u'[q]. If in this case new column upper bound becomes close to current column lower bound, the column can be fixed on its lower bound;</p>
 * <p>3) if u'[q] < l[q] - eps, implied upper bound violates current column lower bound l[q], in which case the problem has no primal feasible solution. </p>
 */
public";

%javamethodmodifiers npp_ineq_singlet(NPP *npp, NPPROW *p) "
/**
 */
public";

%javamethodmodifiers npp_implied_slack(NPP *npp, NPPCOL *q) "
/**
 */
public";

%javamethodmodifiers npp_implied_free(NPP *npp, NPPCOL *q) "
/**
 */
public";

%javamethodmodifiers npp_eq_doublet(NPP *npp, NPPROW *p) "
/**
 */
public";

%javamethodmodifiers npp_forcing_row(NPP *npp, NPPROW *p, int at) "
/**
 */
public";

%javamethodmodifiers npp_analyze_row(NPP *npp, NPPROW *p) "
/**
 * npp_analyze_row - perform general row analysis .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" int npp_analyze_row(NPP *npp, NPPROW *p);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine npp_analyze_row performs analysis of row p of general format:</p>
 * <p>L[p] <= sum a[p,j] x[j] <= U[p], (1) j</p>
 * <p>l[j] <= x[j] <= u[j], (2)</p>
 * <p>where L[p] <= U[p] and l[j] <= u[j] for all a[p,j] != 0.</p>
 * <p>RETURNS</p>
 * <p>0x?0 - row lower bound does not exist or is redundant;</p>
 * <p>0x?1 - row lower bound can be active;</p>
 * <p>0x?2 - row lower bound is a forcing bound;</p>
 * <p>0x0? - row upper bound does not exist or is redundant;</p>
 * <p>0x1? - row upper bound can be active;</p>
 * <p>0x2? - row upper bound is a forcing bound;</p>
 * <p>0x33 - row bounds are inconsistent with column bounds.</p>
 * <p>ALGORITHM</p>
 * <p>Analysis of row (1) is based on analysis of its implied lower and upper bounds, which are determined by bounds of corresponding columns (variables) as follows:</p>
 * <p>L'[p] = inf sum a[p,j] x[j] = j (3) = sum a[p,j] l[j] + sum a[p,j] u[j], j in Jp j in Jn</p>
 * <p>U'[p] = sup sum a[p,j] x[j] = (4) = sum a[p,j] u[j] + sum a[p,j] l[j], j in Jp j in Jn</p>
 * <p>Jp = {j: a[p,j] > 0}, Jn = {j: a[p,j] < 0}. (5)</p>
 * <p>(Note that bounds of all columns in row p are assumed to be correct, so L'[p] <= U'[p].)</p>
 * <p>Analysis of row lower bound L[p] includes the following cases:</p>
 * <p>1) if L[p] > U'[p] + eps, where eps is an absolute tolerance for row value, row lower bound L[p] and implied row upper bound U'[p] are inconsistent, ergo, the problem has no primal feasible solution;</p>
 * <p>2) if U'[p] - eps <= L[p] <= U'[p] + eps, i.e. if L[p] =~ U'[p], the row is a forcing row on its lower bound (see description of the routine npp_forcing_row);</p>
 * <p>3) if L[p] > L'[p] + eps, row lower bound L[p] can be active (this conclusion does not account other rows in the problem);</p>
 * <p>4) if L[p] <= L'[p] + eps, row lower bound L[p] cannot be active, so it is redundant and can be removed (replaced by -oo).</p>
 * <p>Analysis of row upper bound U[p] is performed in a similar way and includes the following cases:</p>
 * <p>1) if U[p] < L'[p] - eps, row upper bound U[p] and implied row lower bound L'[p] are inconsistent, ergo the problem has no primal feasible solution;</p>
 * <p>2) if L'[p] - eps <= U[p] <= L'[p] + eps, i.e. if U[p] =~ L'[p], the row is a forcing row on its upper bound (see description of the routine npp_forcing_row);</p>
 * <p>3) if U[p] < U'[p] - eps, row upper bound U[p] can be active (this conclusion does not account other rows in the problem);</p>
 * <p>4) if U[p] >= U'[p] - eps, row upper bound U[p] cannot be active, so it is redundant and can be removed (replaced by +oo). </p>
 */
public";

%javamethodmodifiers npp_inactive_bound(NPP *npp, NPPROW *p, int which) "
/**
 */
public";

%javamethodmodifiers npp_implied_bounds(NPP *npp, NPPROW *p) "
/**
 * npp_implied_bounds - determine implied column bounds .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" void npp_implied_bounds(NPP *npp, NPPROW *p);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine npp_implied_bounds inspects general row (constraint) p:</p>
 * <p>L[p] <= sum a[p,j] x[j] <= U[p], (1)</p>
 * <p>l[j] <= x[j] <= u[j], (2)</p>
 * <p>where L[p] <= U[p] and l[j] <= u[j] for all a[p,j] != 0, to compute implied bounds of columns (variables x[j]) in this row.</p>
 * <p>The routine stores implied column bounds l'[j] and u'[j] in column descriptors (NPPCOL); it does not change current column bounds l[j] and u[j]. (Implied column bounds can be then used to strengthen the current column bounds; see the routines npp_implied_lower and npp_implied_upper).</p>
 * <p>ALGORITHM</p>
 * <p>Current column bounds (2) define implied lower and upper bounds of row (1) as follows:</p>
 * <p>L'[p] = inf sum a[p,j] x[j] = j (3) = sum a[p,j] l[j] + sum a[p,j] u[j], j in Jp j in Jn</p>
 * <p>U'[p] = sup sum a[p,j] x[j] = (4) = sum a[p,j] u[j] + sum a[p,j] l[j], j in Jp j in Jn</p>
 * <p>Jp = {j: a[p,j] > 0}, Jn = {j: a[p,j] < 0}. (5)</p>
 * <p>(Note that bounds of all columns in row p are assumed to be correct, so L'[p] <= U'[p].)</p>
 * <p>If L[p] > L'[p] and/or U[p] < U'[p], the lower and/or upper bound of row (1) can be active, in which case such row defines implied bounds of its variables.</p>
 * <p>Let x[k] be some variable having in row (1) coefficient a[p,k] != 0. Consider a case when row lower bound can be active (L[p] > L'[p]):</p>
 * <p>sum a[p,j] x[j] >= L[p] ==> j</p>
 * <p>sum a[p,j] x[j] + a[p,k] x[k] >= L[p] ==> j!=k (6) a[p,k] x[k] >= L[p] - sum a[p,j] x[j] ==> j!=k</p>
 * <p>a[p,k] x[k] >= L[p,k],</p>
 * <p>where</p>
 * <p>L[p,k] = inf(L[p] - sum a[p,j] x[j]) = j!=k</p>
 * <p>= L[p] - sup sum a[p,j] x[j] = (7) j!=k</p>
 * <p>= L[p] - sum a[p,j] u[j] - sum a[p,j] l[j]. j in Jpk} j in Jnk}</p>
 * <p>Thus:</p>
 * <p>x[k] >= l'[k] = L[p,k] / a[p,k], if a[p,k] > 0, (8)</p>
 * <p>x[k] <= u'[k] = L[p,k] / a[p,k], if a[p,k] < 0. (9)</p>
 * <p>where l'[k] and u'[k] are implied lower and upper bounds of variable x[k], resp.</p>
 * <p>Now consider a similar case when row upper bound can be active (U[p] < U'[p]):</p>
 * <p>sum a[p,j] x[j] <= U[p] ==> j</p>
 * <p>sum a[p,j] x[j] + a[p,k] x[k] <= U[p] ==> j!=k (10) a[p,k] x[k] <= U[p] - sum a[p,j] x[j] ==> j!=k</p>
 * <p>a[p,k] x[k] <= U[p,k],</p>
 * <p>where:</p>
 * <p>U[p,k] = sup(U[p] - sum a[p,j] x[j]) = j!=k</p>
 * <p>= U[p] - inf sum a[p,j] x[j] = (11) j!=k</p>
 * <p>= U[p] - sum a[p,j] l[j] - sum a[p,j] u[j]. j in Jpk} j in Jnk}</p>
 * <p>Thus:</p>
 * <p>x[k] <= u'[k] = U[p,k] / a[p,k], if a[p,k] > 0, (12)</p>
 * <p>x[k] >= l'[k] = U[p,k] / a[p,k], if a[p,k] < 0. (13)</p>
 * <p>Note that in formulae (8), (9), (12), and (13) coefficient a[p,k] must not be too small in magnitude relatively to other non-zero coefficients in row (1), i.e. the following condition must hold:</p>
 * <p>|a[p,k]| >= eps * max(1, |a[p,j]|), (14) j</p>
 * <p>where eps is a relative tolerance for constraint coefficients. Otherwise the implied column bounds can be numerical inreliable. For example, using formula (8) for the following inequality constraint:</p>
 * <p>1e-12 x1 - x2 - x3 >= 0,</p>
 * <p>where x1 >= -1, x2, x3, >= 0, may lead to numerically unreliable conclusion that x1 >= 0.</p>
 * <p>Using formulae (8), (9), (12), and (13) to compute implied bounds for one variable requires |J| operations, where J = {j: a[p,j] != 0}, because this needs computing L[p,k] and U[p,k]. Thus, computing implied bounds for all variables in row (1) would require |J|^2 operations, that is not a good technique. However, the total number of operations can be reduced to |J| as follows.</p>
 * <p>Let a[p,k] > 0. Then from (7) and (11) we have:</p>
 * <p>L[p,k] = L[p] - (U'[p] - a[p,k] u[k]) =</p>
 * <p>= L[p] - U'[p] + a[p,k] u[k],</p>
 * <p>U[p,k] = U[p] - (L'[p] - a[p,k] l[k]) =</p>
 * <p>= U[p] - L'[p] + a[p,k] l[k],</p>
 * <p>where L'[p] and U'[p] are implied row lower and upper bounds defined by formulae (3) and (4). Substituting these expressions into (8) and (12) gives:</p>
 * <p>l'[k] = L[p,k] / a[p,k] = u[k] + (L[p] - U'[p]) / a[p,k], (15)</p>
 * <p>u'[k] = U[p,k] / a[p,k] = l[k] + (U[p] - L'[p]) / a[p,k]. (16)</p>
 * <p>Similarly, if a[p,k] < 0, according to (7) and (11) we have:</p>
 * <p>L[p,k] = L[p] - (U'[p] - a[p,k] l[k]) =</p>
 * <p>= L[p] - U'[p] + a[p,k] l[k],</p>
 * <p>U[p,k] = U[p] - (L'[p] - a[p,k] u[k]) =</p>
 * <p>= U[p] - L'[p] + a[p,k] u[k],</p>
 * <p>and substituting these expressions into (8) and (12) gives:</p>
 * <p>l'[k] = U[p,k] / a[p,k] = u[k] + (U[p] - L'[p]) / a[p,k], (17)</p>
 * <p>u'[k] = L[p,k] / a[p,k] = l[k] + (L[p] - U'[p]) / a[p,k]. (18)</p>
 * <p>Note that formulae (15)-(18) can be used only if L'[p] and U'[p] exist. However, if for some variable x[j] it happens that l[j] = -oo and/or u[j] = +oo, values of L'[p] (if a[p,j] > 0) and/or U'[p] (if a[p,j] < 0) are undefined. Consider, therefore, the most general situation, when some column bounds (2) may not exist.</p>
 * <p>Let:</p>
 * <p>J' = {j : (a[p,j] > 0 and l[j] = -oo) or (19) (a[p,j] < 0 and u[j] = +oo)}.</p>
 * <p>Then (assuming that row upper bound U[p] can be active) the following three cases are possible:</p>
 * <p>1) |J'| = 0. In this case L'[p] exists, thus, for all variables x[j] in row (1) we can use formulae (16) and (17);</p>
 * <p>2) J' = {k}. In this case L'[p] = -oo, however, U[p,k] (11) exists, so for variable x[k] we can use formulae (12) and (13). Note that for all other variables x[j] (j != k) l'[j] = -oo (if a[p,j] < 0) or u'[j] = +oo (if a[p,j] > 0);</p>
 * <p>3) |J'| > 1. In this case for all variables x[j] in row [1] we have l'[j] = -oo (if a[p,j] < 0) or u'[j] = +oo (if a[p,j] > 0).</p>
 * <p>Similarly, let:</p>
 * <p>J'' = {j : (a[p,j] > 0 and u[j] = +oo) or (20) (a[p,j] < 0 and l[j] = -oo)}.</p>
 * <p>Then (assuming that row lower bound L[p] can be active) the following three cases are possible:</p>
 * <p>1) |J''| = 0. In this case U'[p] exists, thus, for all variables x[j] in row (1) we can use formulae (15) and (18);</p>
 * <p>2) J'' = {k}. In this case U'[p] = +oo, however, L[p,k] (7) exists, so for variable x[k] we can use formulae (8) and (9). Note that for all other variables x[j] (j != k) l'[j] = -oo (if a[p,j] > 0) or u'[j] = +oo (if a[p,j] < 0);</p>
 * <p>3) |J''| > 1. In this case for all variables x[j] in row (1) we have l'[j] = -oo (if a[p,j] > 0) or u'[j] = +oo (if a[p,j] < 0). </p>
 */
public";

%javamethodmodifiers npp_binarize_prob(NPP *npp) "
/**
 */
public";

%javamethodmodifiers npp_is_packing(NPP *npp, NPPROW *row) "
/**
 * npp_is_packing - test if constraint is packing inequality .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" int npp_is_packing(NPP *npp, NPPROW *row);</p>
 * <p>RETURNS</p>
 * <p>If the specified row (constraint) is packing inequality (see below), the routine npp_is_packing returns non-zero. Otherwise, it returns zero.</p>
 * <p>PACKING INEQUALITIES</p>
 * <p>In canonical format the packing inequality is the following:</p>
 * <p>sum x[j] <= 1, (1) j in J</p>
 * <p>where all variables x[j] are binary. This inequality expresses the condition that in any integer feasible solution at most one variable from set J can take non-zero (unity) value while other variables must be equal to zero. W.l.o.g. it is assumed that |J| >= 2, because if J is empty or |J| = 1, the inequality (1) is redundant.</p>
 * <p>In general case the packing inequality may include original variables x[j] as well as their complements x~[j]:</p>
 * <p>sum x[j] + sum x~[j] <= 1, (2) j in Jp j in Jn</p>
 * <p>where Jp and Jn are not intersected. Therefore, using substitution x~[j] = 1 - x[j] gives the packing inequality in generalized format:</p>
 * <p>sum x[j] - sum x[j] <= 1 - |Jn|. (3) j in Jp j in Jn </p>
 */
public";

%javamethodmodifiers npp_hidden_packing(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_implied_packing(NPP *npp, NPPROW *row, int which, NPPCOL *var[], char set[]) "
/**
 * npp_implied_packing - identify implied packing inequality .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" int npp_implied_packing(NPP *npp, NPPROW *row, int which, NPPCOL *var[], char set[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine npp_implied_packing processes specified row (constraint) of general format:</p>
 * <p>L <= sum a[j] x[j] <= U. (1) j</p>
 * <p>If which = 0, only lower bound L, which must exist, is considered, while upper bound U is ignored. Similarly, if which = 1, only upper bound U, which must exist, is considered, while lower bound L is ignored. Thus, if the specified row is a double-sided inequality or equality constraint, this routine should be called twice for both lower and upper bounds.</p>
 * <p>The routine npp_implied_packing attempts to find a non-trivial (i.e. having not less than two binary variables) packing inequality:</p>
 * <p>sum x[j] - sum x[j] <= 1 - |Jn|, (2) j in Jp j in Jn</p>
 * <p>which is relaxation of the constraint (1) in the sense that any solution satisfying to that constraint also satisfies to the packing inequality (2). If such relaxation exists, the routine stores pointers to descriptors of corresponding binary variables and their flags, resp., to locations var[1], var[2], ..., var[len] and set[1], set[2], ..., set[len], where set[j] = 0 means that j in Jp and set[j] = 1 means that j in Jn.</p>
 * <p>RETURNS</p>
 * <p>The routine npp_implied_packing returns len, which is the total number of binary variables in the packing inequality found, len >= 2. However, if the relaxation does not exist, the routine returns zero.</p>
 * <p>ALGORITHM</p>
 * <p>If which = 0, the constraint coefficients (1) are multiplied by -1 and b is assigned -L; if which = 1, the constraint coefficients (1) are not changed and b is assigned +U. In both cases the specified constraint gets the following format:</p>
 * <p>sum a[j] x[j] <= b. (3) j</p>
 * <p>(Note that (3) is a relaxation of (1), because one of bounds L or U is ignored.)</p>
 * <p>Let J be set of binary variables, Kp be set of non-binary (integer or continuous) variables with a[j] > 0, and Kn be set of non-binary variables with a[j] < 0. Then the inequality (3) can be written as follows:</p>
 * <p>sum a[j] x[j] <= b - sum a[j] x[j] - sum a[j] x[j]. (4) j in J j in Kp j in Kn</p>
 * <p>To get rid of non-binary variables we can replace the inequality (4) by the following relaxed inequality:</p>
 * <p>sum a[j] x[j] <= b~, (5) j in J</p>
 * <p>where:</p>
 * <p>b~ = sup(b - sum a[j] x[j] - sum a[j] x[j]) = j in Kp j in Kn</p>
 * <p>= b - inf sum a[j] x[j] - inf sum a[j] x[j] = (6) j in Kp j in Kn</p>
 * <p>= b - sum a[j] l[j] - sum a[j] u[j]. j in Kp j in Kn</p>
 * <p>Note that if lower bound l[j] (if j in Kp) or upper bound u[j] (if j in Kn) of some non-binary variable x[j] does not exist, then formally b = +oo, in which case further analysis is not performed.</p>
 * <p>Let Bp = {j in J: a[j] > 0}, Bn = {j in J: a[j] < 0}. To make all the inequality coefficients in (5) positive, we replace all x[j] in Bn by their complementaries, substituting x[j] = 1 - x~[j] for all j in Bn, that gives:</p>
 * <p>sum a[j] x[j] - sum a[j] x~[j] <= b~ - sum a[j]. (7) j in Bp j in Bn j in Bn</p>
 * <p>This inequality is a relaxation of the original constraint (1), and it is a binary knapsack inequality. Writing it in the standard format we have:</p>
 * <p>sum alfa[j] z[j] <= beta, (8) j in J</p>
 * <p>where: ( + a[j], if j in Bp, alfa[j] = < (9) ( - a[j], if j in Bn,</p>
 * <p>( x[j], if j in Bp, z[j] = < (10) ( 1 - x[j], if j in Bn,</p>
 * <p>beta = b~ - sum a[j]. (11) j in Bn</p>
 * <p>In the inequality (8) all coefficients are positive, therefore, the packing relaxation to be found for this inequality is the following:</p>
 * <p>sum z[j] <= 1. (12) j in P</p>
 * <p>It is obvious that set P within J, which we would like to find, must satisfy to the following condition:</p>
 * <p>alfa[j] + alfa[k] > beta + eps for all j, k in P, j != k, (13)</p>
 * <p>where eps is an absolute tolerance for value of the linear form. Thus, it is natural to take P = {j: alpha[j] > (beta + eps) / 2}. Moreover, if in the equality (8) there exist coefficients alfa[k], for which alfa[k] <= (beta + eps) / 2, but which, nevertheless, satisfies to the condition (13) for all j in P, *one* corresponding variable z[k] (having, for example, maximal coefficient alfa[k]) can be included in set P, that allows increasing the number of binary variables in (12) by one.</p>
 * <p>Once the set P has been built, for the inequality (12) we need to perform back substitution according to (10) in order to express it through the original binary variables. As the result of such back substitution the relaxed packing inequality get its final format (2), where Jp = J intersect Bp, and Jn = J intersect Bn. </p>
 */
public";

%javamethodmodifiers npp_is_covering(NPP *npp, NPPROW *row) "
/**
 * npp_is_covering - test if constraint is covering inequality .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" int npp_is_covering(NPP *npp, NPPROW *row);</p>
 * <p>RETURNS</p>
 * <p>If the specified row (constraint) is covering inequality (see below), the routine npp_is_covering returns non-zero. Otherwise, it returns zero.</p>
 * <p>COVERING INEQUALITIES</p>
 * <p>In canonical format the covering inequality is the following:</p>
 * <p>sum x[j] >= 1, (1) j in J</p>
 * <p>where all variables x[j] are binary. This inequality expresses the condition that in any integer feasible solution variables in set J cannot be all equal to zero at the same time, i.e. at least one variable must take non-zero (unity) value. W.l.o.g. it is assumed that |J| >= 2, because if J is empty, the inequality (1) is infeasible, and if |J| = 1, the inequality (1) is a forcing row.</p>
 * <p>In general case the covering inequality may include original variables x[j] as well as their complements x~[j]:</p>
 * <p>sum x[j] + sum x~[j] >= 1, (2) j in Jp j in Jn</p>
 * <p>where Jp and Jn are not intersected. Therefore, using substitution x~[j] = 1 - x[j] gives the packing inequality in generalized format:</p>
 * <p>sum x[j] - sum x[j] >= 1 - |Jn|. (3) j in Jp j in Jn</p>
 * <p>(May note that the inequality (3) cuts off infeasible solutions, where x[j] = 0 for all j in Jp and x[j] = 1 for all j in Jn.)</p>
 * <p>NOTE: If |J| = 2, the inequality (3) is equivalent to packing inequality (see the routine npp_is_packing). </p>
 */
public";

%javamethodmodifiers npp_hidden_covering(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_is_partitioning(NPP *npp, NPPROW *row) "
/**
 * npp_is_partitioning - test if constraint is partitioning equality .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" int npp_is_partitioning(NPP *npp, NPPROW *row);</p>
 * <p>RETURNS</p>
 * <p>If the specified row (constraint) is partitioning equality (see below), the routine npp_is_partitioning returns non-zero. Otherwise, it returns zero.</p>
 * <p>PARTITIONING EQUALITIES</p>
 * <p>In canonical format the partitioning equality is the following:</p>
 * <p>sum x[j] = 1, (1) j in J</p>
 * <p>where all variables x[j] are binary. This equality expresses the condition that in any integer feasible solution exactly one variable in set J must take non-zero (unity) value while other variables must be equal to zero. W.l.o.g. it is assumed that |J| >= 2, because if J is empty, the inequality (1) is infeasible, and if |J| = 1, the inequality (1) is a fixing row.</p>
 * <p>In general case the partitioning equality may include original variables x[j] as well as their complements x~[j]:</p>
 * <p>sum x[j] + sum x~[j] = 1, (2) j in Jp j in Jn</p>
 * <p>where Jp and Jn are not intersected. Therefore, using substitution x~[j] = 1 - x[j] leads to the partitioning equality in generalized format:</p>
 * <p>sum x[j] - sum x[j] = 1 - |Jn|. (3) j in Jp j in Jn </p>
 */
public";

%javamethodmodifiers npp_reduce_ineq_coef(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_clean_prob(NPP *npp) "
/**
 * npp_clean_prob - perform initial LP/MIP processing .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" void npp_clean_prob(NPP *npp);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine npp_clean_prob performs initial LP/MIP processing that currently includes:</p>
 * <p>1) removing free rows;</p>
 * <p>2) replacing double-sided constraint rows with almost identical bounds, by equality constraint rows;</p>
 * <p>3) removing fixed columns;</p>
 * <p>4) replacing double-bounded columns with almost identical bounds by fixed columns and removing those columns;</p>
 * <p>5) initial processing constraint coefficients (not implemented);</p>
 * <p>6) initial processing objective coefficients (not implemented). </p>
 */
public";

%javamethodmodifiers npp_process_row(NPP *npp, NPPROW *row, int hard) "
/**
 * npp_process_row - perform basic row processing .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" int npp_process_row(NPP *npp, NPPROW *row, int hard);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine npp_process_row performs basic row processing that currently includes:</p>
 * <p>1) removing empty row;</p>
 * <p>2) removing equality constraint row singleton and corresponding column;</p>
 * <p>3) removing inequality constraint row singleton and corresponding column if it was fixed;</p>
 * <p>4) performing general row analysis;</p>
 * <p>5) removing redundant row bounds;</p>
 * <p>6) removing forcing row and corresponding columns;</p>
 * <p>7) removing row which becomes free due to redundant bounds;</p>
 * <p>8) computing implied bounds for all columns in the row and using them to strengthen current column bounds (MIP only, optional, performed if the flag hard is on).</p>
 * <p>Additionally the routine may activate affected rows and/or columns for further processing.</p>
 * <p>RETURNS</p>
 * <p>0 success;</p>
 * <p>GLP_ENOPFS primal/integer infeasibility detected;</p>
 * <p>GLP_ENODFS dual infeasibility detected. </p>
 */
public";

%javamethodmodifiers npp_improve_bounds(NPP *npp, NPPROW *row, int flag) "
/**
 * npp_improve_bounds - improve current column bounds .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" int npp_improve_bounds(NPP *npp, NPPROW *row, int flag);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine npp_improve_bounds analyzes specified row (inequality or equality constraint) to determine implied column bounds and then uses these bounds to improve (strengthen) current column bounds.</p>
 * <p>If the flag is on and current column bounds changed significantly or the column was fixed, the routine activate rows affected by the column for further processing. (This feature is intended to be used in the main loop of the routine npp_process_row.)</p>
 * <p>NOTE: This operation can be used for MIP problem only.</p>
 * <p>RETURNS</p>
 * <p>The routine npp_improve_bounds returns the number of significantly changed bounds plus the number of column having been fixed due to bound improvements. However, if the routine detects primal/integer infeasibility, it returns a negative value. </p>
 */
public";

%javamethodmodifiers npp_process_col(NPP *npp, NPPCOL *col) "
/**
 * npp_process_col - perform basic column processing .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" int npp_process_col(NPP *npp, NPPCOL *col);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine npp_process_col performs basic column processing that currently includes:</p>
 * <p>1) fixing and removing empty column;</p>
 * <p>2) removing column singleton, which is implied slack variable, and corresponding row if it becomes free;</p>
 * <p>3) removing bounds of column, which is implied free variable, and replacing corresponding row by equality constraint.</p>
 * <p>Additionally the routine may activate affected rows and/or columns for further processing.</p>
 * <p>RETURNS</p>
 * <p>0 success;</p>
 * <p>GLP_ENOPFS primal/integer infeasibility detected;</p>
 * <p>GLP_ENODFS dual infeasibility detected. </p>
 */
public";

%javamethodmodifiers npp_process_prob(NPP *npp, int hard) "
/**
 * npp_process_prob - perform basic LP/MIP processing .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" int npp_process_prob(NPP *npp, int hard);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine npp_process_prob performs basic LP/MIP processing that currently includes:</p>
 * <p>1) initial LP/MIP processing (see the routine npp_clean_prob),</p>
 * <p>2) basic row processing (see the routine npp_process_row), and</p>
 * <p>3) basic column processing (see the routine npp_process_col).</p>
 * <p>If the flag hard is on, the routine attempts to improve current column bounds multiple times within the main processing loop, in which case this feature may take a time. Otherwise, if the flag hard is off, improving column bounds is performed only once at the end of the main loop. (Note that this feature is used for MIP only.)</p>
 * <p>The routine uses two sets: the set of active rows and the set of active columns. Rows/columns are marked by a flag (the field temp in NPPROW/NPPCOL). If the flag is non-zero, the row/column is active, in which case it is placed in the beginning of the row/column list; otherwise, if the flag is zero, the row/column is inactive, in which case it is placed in the end of the row/column list. If a row/column being currently processed may affect other rows/columns, the latters are activated for further processing.</p>
 * <p>RETURNS</p>
 * <p>0 success;</p>
 * <p>GLP_ENOPFS primal/integer infeasibility detected;</p>
 * <p>GLP_ENODFS dual infeasibility detected. </p>
 */
public";

%javamethodmodifiers npp_simplex(NPP *npp, const glp_smcp *parm) "
/**
 */
public";

%javamethodmodifiers npp_integer(NPP *npp, const glp_iocp *parm) "
/**
 */
public";

%javamethodmodifiers npp_sat_free_row(NPP *npp, NPPROW *p) "
/**
 */
public";

%javamethodmodifiers npp_sat_fixed_col(NPP *npp, NPPCOL *q) "
/**
 */
public";

%javamethodmodifiers npp_sat_is_bin_comb(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_sat_num_pos_coef(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_sat_num_neg_coef(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_sat_is_cover_ineq(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_sat_is_pack_ineq(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_sat_is_partn_eq(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_sat_reverse_row(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_sat_split_pack(NPP *npp, NPPROW *row, int nnn) "
/**
 */
public";

%javamethodmodifiers npp_sat_encode_pack(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_sat_encode_sum2(NPP *npp, NPPLSE *set, NPPSED *sed) "
/**
 */
public";

%javamethodmodifiers npp_sat_encode_sum3(NPP *npp, NPPLSE *set, NPPSED *sed) "
/**
 */
public";

%javamethodmodifiers npp_sat_encode_sum_ax(NPP *npp, NPPROW *row, NPPLIT y[]) "
/**
 */
public";

%javamethodmodifiers npp_sat_normalize_clause(NPP *npp, int size, NPPLIT lit[]) "
/**
 */
public";

%javamethodmodifiers npp_sat_encode_clause(NPP *npp, int size, NPPLIT lit[]) "
/**
 */
public";

%javamethodmodifiers npp_sat_encode_geq(NPP *npp, int n, NPPLIT y[], int rhs) "
/**
 */
public";

%javamethodmodifiers npp_sat_encode_leq(NPP *npp, int n, NPPLIT y[], int rhs) "
/**
 */
public";

%javamethodmodifiers npp_sat_encode_row(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_sat_encode_prob(NPP *npp) "
/**
 */
public";

%javamethodmodifiers npp_create_wksp(void) "
/**
 */
public";

%javamethodmodifiers npp_insert_row(NPP *npp, NPPROW *row, int where) "
/**
 */
public";

%javamethodmodifiers npp_remove_row(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_activate_row(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_deactivate_row(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_insert_col(NPP *npp, NPPCOL *col, int where) "
/**
 */
public";

%javamethodmodifiers npp_remove_col(NPP *npp, NPPCOL *col) "
/**
 */
public";

%javamethodmodifiers npp_activate_col(NPP *npp, NPPCOL *col) "
/**
 */
public";

%javamethodmodifiers npp_deactivate_col(NPP *npp, NPPCOL *col) "
/**
 */
public";

%javamethodmodifiers npp_add_row(NPP *npp) "
/**
 */
public";

%javamethodmodifiers npp_add_col(NPP *npp) "
/**
 */
public";

%javamethodmodifiers npp_add_aij(NPP *npp, NPPROW *row, NPPCOL *col, double val) "
/**
 */
public";

%javamethodmodifiers npp_row_nnz(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_col_nnz(NPP *npp, NPPCOL *col) "
/**
 */
public";

%javamethodmodifiers npp_push_tse(NPP *npp, int(*func)(NPP *npp, void *info), int size) "
/**
 */
public";

%javamethodmodifiers npp_erase_row(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_del_row(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_del_col(NPP *npp, NPPCOL *col) "
/**
 */
public";

%javamethodmodifiers npp_del_aij(NPP *npp, NPPAIJ *aij) "
/**
 */
public";

%javamethodmodifiers npp_load_prob(NPP *npp, glp_prob *orig, int names, int sol, int scaling) "
/**
 */
public";

%javamethodmodifiers npp_build_prob(NPP *npp, glp_prob *prob) "
/**
 */
public";

%javamethodmodifiers npp_postprocess(NPP *npp, glp_prob *prob) "
/**
 */
public";

%javamethodmodifiers npp_unload_sol(NPP *npp, glp_prob *orig) "
/**
 */
public";

%javamethodmodifiers npp_delete_wksp(NPP *npp) "
/**
 */
public";

%javamethodmodifiers rcv_free_row(NPP *npp, void *info) "
/**
 */
public";

%javamethodmodifiers npp_free_row(NPP *npp, NPPROW *p) "
/**
 */
public";

%javamethodmodifiers rcv_geq_row(NPP *npp, void *info) "
/**
 */
public";

%javamethodmodifiers npp_geq_row(NPP *npp, NPPROW *p) "
/**
 */
public";

%javamethodmodifiers rcv_leq_row(NPP *npp, void *info) "
/**
 * npp_leq_row - process row of 'not greater than' type .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" void npp_leq_row(NPP *npp, NPPROW *p);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine npp_leq_row processes row p, which is 'not greater than' inequality constraint:</p>
 * <p>(L[p] <=) sum a[p,j] x[j] <= U[p], (1) j</p>
 * <p>where L[p] < U[p], and lower bound may not exist (L[p] = +oo).</p>
 * <p>PROBLEM TRANSFORMATION</p>
 * <p>Constraint (1) can be replaced by equality constraint:</p>
 * <p>sum a[p,j] x[j] + s = L[p], (2) j</p>
 * <p>where</p>
 * <p>0 <= s (<= U[p] - L[p]) (3)</p>
 * <p>is a non-negative slack variable.</p>
 * <p>Since in the primal system there appears column s having the only non-zero coefficient in row p, in the dual system there appears a new row:</p>
 * <p>(+1) pi[p] + lambda = 0, (4)</p>
 * <p>where (+1) is coefficient of column s in row p, pi[p] is multiplier of row p, lambda is multiplier of column q, 0 is coefficient of column s in the objective row.</p>
 * <p>RECOVERING BASIC SOLUTION</p>
 * <p>Status of row p in solution to the original problem is determined by its status and status of column q in solution to the transformed problem as follows:</p>
 * <p>+--------------------------------------+------------------+ | Transformed problem | Original problem | +-----------------+--------------------+------------------+ | Status of row p | Status of column s | Status of row p | +-----------------+--------------------+------------------+ | GLP_BS | GLP_BS | N/A | | GLP_BS | GLP_NL | GLP_BS | | GLP_BS | GLP_NU | GLP_BS | | GLP_NS | GLP_BS | GLP_BS | | GLP_NS | GLP_NL | GLP_NU | | GLP_NS | GLP_NU | GLP_NL | +-----------------+--------------------+------------------+</p>
 * <p>Value of row multiplier pi[p] in solution to the original problem is the same as in solution to the transformed problem.</p>
 * <p>1. In solution to the transformed problem row p and column q cannot be basic at the same time; otherwise the basis matrix would have two linear dependent columns: unity column of auxiliary variable of row p and unity column of variable s.</p>
 * <p>2. Though in the transformed problem row p is equality constraint, it may be basic due to primal degeneracy.</p>
 * <p>RECOVERING INTERIOR-POINT SOLUTION</p>
 * <p>Value of row multiplier pi[p] in solution to the original problem is the same as in solution to the transformed problem.</p>
 * <p>RECOVERING MIP SOLUTION</p>
 * <p>None needed. </p>
 */
public";

%javamethodmodifiers npp_leq_row(NPP *npp, NPPROW *p) "
/**
 */
public";

%javamethodmodifiers rcv_free_col(NPP *npp, void *info) "
/**
 */
public";

%javamethodmodifiers npp_free_col(NPP *npp, NPPCOL *q) "
/**
 */
public";

%javamethodmodifiers rcv_lbnd_col(NPP *npp, void *info) "
/**
 */
public";

%javamethodmodifiers npp_lbnd_col(NPP *npp, NPPCOL *q) "
/**
 */
public";

%javamethodmodifiers rcv_ubnd_col(NPP *npp, void *info) "
/**
 * npp_ubnd_col - process column with upper bound .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" void npp_ubnd_col(NPP *npp, NPPCOL *q);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine npp_ubnd_col processes column q, which has upper bound:</p>
 * <p>(l[q] <=) x[q] <= u[q], (1)</p>
 * <p>where l[q] < u[q], and lower bound may not exist (l[q] = -oo).</p>
 * <p>PROBLEM TRANSFORMATION</p>
 * <p>Column q can be replaced as follows:</p>
 * <p>x[q] = u[q] - s, (2)</p>
 * <p>where</p>
 * <p>0 <= s (<= u[q] - l[q]) (3)</p>
 * <p>is a non-negative variable.</p>
 * <p>Substituting x[q] from (2) into the objective row, we have:</p>
 * <p>z = sum c[j] x[j] + c0 = j</p>
 * <p>= sum c[j] x[j] + c[q] x[q] + c0 = j!=q</p>
 * <p>= sum c[j] x[j] + c[q] (u[q] - s) + c0 = j!=q</p>
 * <p>= sum c[j] x[j] - c[q] s + c~0,</p>
 * <p>where</p>
 * <p>c~0 = c0 + c[q] u[q] (4)</p>
 * <p>is the constant term of the objective in the transformed problem. Similarly, substituting x[q] into constraint row i, we have:</p>
 * <p>L[i] <= sum a[i,j] x[j] <= U[i] ==> j</p>
 * <p>L[i] <= sum a[i,j] x[j] + a[i,q] x[q] <= U[i] ==> j!=q</p>
 * <p>L[i] <= sum a[i,j] x[j] + a[i,q] (u[q] - s) <= U[i] ==> j!=q</p>
 * <p>L~[i] <= sum a[i,j] x[j] - a[i,q] s <= U~[i], j!=q</p>
 * <p>where</p>
 * <p>L~[i] = L[i] - a[i,q] u[q], U~[i] = U[i] - a[i,q] u[q] (5)</p>
 * <p>are lower and upper bounds of row i in the transformed problem, resp.</p>
 * <p>Note that in the transformed problem coefficients c[q] and a[i,q] change their sign. Thus, the row of the dual system corresponding to column q:</p>
 * <p>sum a[i,q] pi[i] + lambda[q] = c[q] (6) i</p>
 * <p>in the transformed problem becomes the following:</p>
 * <p>sum (-a[i,q]) pi[i] + lambda[s] = -c[q]. (7) i</p>
 * <p>Therefore:</p>
 * <p>lambda[q] = - lambda[s], (8)</p>
 * <p>where lambda[q] is multiplier for column q, lambda[s] is multiplier for column s.</p>
 * <p>RECOVERING BASIC SOLUTION</p>
 * <p>With respect to (8) status of column q in solution to the original problem is determined by status of column s in solution to the transformed problem as follows:</p>
 * <p>+-----------------------+--------------------+ | Status of column s | Status of column q | | (transformed problem) | (original problem) | +-----------------------+--------------------+ | GLP_BS | GLP_BS | | GLP_NL | GLP_NU | | GLP_NU | GLP_NL | +-----------------------+--------------------+</p>
 * <p>Value of column q is computed with formula (2).</p>
 * <p>RECOVERING INTERIOR-POINT SOLUTION</p>
 * <p>Value of column q is computed with formula (2).</p>
 * <p>RECOVERING MIP SOLUTION</p>
 * <p>Value of column q is computed with formula (2). </p>
 */
public";

%javamethodmodifiers npp_ubnd_col(NPP *npp, NPPCOL *q) "
/**
 */
public";

%javamethodmodifiers rcv_dbnd_col(NPP *npp, void *info) "
/**
 */
public";

%javamethodmodifiers npp_dbnd_col(NPP *npp, NPPCOL *q) "
/**
 */
public";

%javamethodmodifiers rcv_fixed_col(NPP *npp, void *info) "
/**
 */
public";

%javamethodmodifiers npp_fixed_col(NPP *npp, NPPCOL *q) "
/**
 */
public";

%javamethodmodifiers rcv_make_equality(NPP *npp, void *info) "
/**
 */
public";

%javamethodmodifiers npp_make_equality(NPP *npp, NPPROW *p) "
/**
 */
public";

%javamethodmodifiers rcv_make_fixed(NPP *npp, void *info) "
/**
 */
public";

%javamethodmodifiers npp_make_fixed(NPP *npp, NPPCOL *q) "
/**
 */
public";

%javamethodmodifiers npp_implied_bounds(NPP *npp, NPPROW *p) "
/**
 * npp_implied_bounds - determine implied column bounds .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" void npp_implied_bounds(NPP *npp, NPPROW *p);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine npp_implied_bounds inspects general row (constraint) p:</p>
 * <p>L[p] <= sum a[p,j] x[j] <= U[p], (1)</p>
 * <p>l[j] <= x[j] <= u[j], (2)</p>
 * <p>where L[p] <= U[p] and l[j] <= u[j] for all a[p,j] != 0, to compute implied bounds of columns (variables x[j]) in this row.</p>
 * <p>The routine stores implied column bounds l'[j] and u'[j] in column descriptors (NPPCOL); it does not change current column bounds l[j] and u[j]. (Implied column bounds can be then used to strengthen the current column bounds; see the routines npp_implied_lower and npp_implied_upper).</p>
 * <p>ALGORITHM</p>
 * <p>Current column bounds (2) define implied lower and upper bounds of row (1) as follows:</p>
 * <p>L'[p] = inf sum a[p,j] x[j] = j (3) = sum a[p,j] l[j] + sum a[p,j] u[j], j in Jp j in Jn</p>
 * <p>U'[p] = sup sum a[p,j] x[j] = (4) = sum a[p,j] u[j] + sum a[p,j] l[j], j in Jp j in Jn</p>
 * <p>Jp = {j: a[p,j] > 0}, Jn = {j: a[p,j] < 0}. (5)</p>
 * <p>(Note that bounds of all columns in row p are assumed to be correct, so L'[p] <= U'[p].)</p>
 * <p>If L[p] > L'[p] and/or U[p] < U'[p], the lower and/or upper bound of row (1) can be active, in which case such row defines implied bounds of its variables.</p>
 * <p>Let x[k] be some variable having in row (1) coefficient a[p,k] != 0. Consider a case when row lower bound can be active (L[p] > L'[p]):</p>
 * <p>sum a[p,j] x[j] >= L[p] ==> j</p>
 * <p>sum a[p,j] x[j] + a[p,k] x[k] >= L[p] ==> j!=k (6) a[p,k] x[k] >= L[p] - sum a[p,j] x[j] ==> j!=k</p>
 * <p>a[p,k] x[k] >= L[p,k],</p>
 * <p>where</p>
 * <p>L[p,k] = inf(L[p] - sum a[p,j] x[j]) = j!=k</p>
 * <p>= L[p] - sup sum a[p,j] x[j] = (7) j!=k</p>
 * <p>= L[p] - sum a[p,j] u[j] - sum a[p,j] l[j]. j in Jpk} j in Jnk}</p>
 * <p>Thus:</p>
 * <p>x[k] >= l'[k] = L[p,k] / a[p,k], if a[p,k] > 0, (8)</p>
 * <p>x[k] <= u'[k] = L[p,k] / a[p,k], if a[p,k] < 0. (9)</p>
 * <p>where l'[k] and u'[k] are implied lower and upper bounds of variable x[k], resp.</p>
 * <p>Now consider a similar case when row upper bound can be active (U[p] < U'[p]):</p>
 * <p>sum a[p,j] x[j] <= U[p] ==> j</p>
 * <p>sum a[p,j] x[j] + a[p,k] x[k] <= U[p] ==> j!=k (10) a[p,k] x[k] <= U[p] - sum a[p,j] x[j] ==> j!=k</p>
 * <p>a[p,k] x[k] <= U[p,k],</p>
 * <p>where:</p>
 * <p>U[p,k] = sup(U[p] - sum a[p,j] x[j]) = j!=k</p>
 * <p>= U[p] - inf sum a[p,j] x[j] = (11) j!=k</p>
 * <p>= U[p] - sum a[p,j] l[j] - sum a[p,j] u[j]. j in Jpk} j in Jnk}</p>
 * <p>Thus:</p>
 * <p>x[k] <= u'[k] = U[p,k] / a[p,k], if a[p,k] > 0, (12)</p>
 * <p>x[k] >= l'[k] = U[p,k] / a[p,k], if a[p,k] < 0. (13)</p>
 * <p>Note that in formulae (8), (9), (12), and (13) coefficient a[p,k] must not be too small in magnitude relatively to other non-zero coefficients in row (1), i.e. the following condition must hold:</p>
 * <p>|a[p,k]| >= eps * max(1, |a[p,j]|), (14) j</p>
 * <p>where eps is a relative tolerance for constraint coefficients. Otherwise the implied column bounds can be numerical inreliable. For example, using formula (8) for the following inequality constraint:</p>
 * <p>1e-12 x1 - x2 - x3 >= 0,</p>
 * <p>where x1 >= -1, x2, x3, >= 0, may lead to numerically unreliable conclusion that x1 >= 0.</p>
 * <p>Using formulae (8), (9), (12), and (13) to compute implied bounds for one variable requires |J| operations, where J = {j: a[p,j] != 0}, because this needs computing L[p,k] and U[p,k]. Thus, computing implied bounds for all variables in row (1) would require |J|^2 operations, that is not a good technique. However, the total number of operations can be reduced to |J| as follows.</p>
 * <p>Let a[p,k] > 0. Then from (7) and (11) we have:</p>
 * <p>L[p,k] = L[p] - (U'[p] - a[p,k] u[k]) =</p>
 * <p>= L[p] - U'[p] + a[p,k] u[k],</p>
 * <p>U[p,k] = U[p] - (L'[p] - a[p,k] l[k]) =</p>
 * <p>= U[p] - L'[p] + a[p,k] l[k],</p>
 * <p>where L'[p] and U'[p] are implied row lower and upper bounds defined by formulae (3) and (4). Substituting these expressions into (8) and (12) gives:</p>
 * <p>l'[k] = L[p,k] / a[p,k] = u[k] + (L[p] - U'[p]) / a[p,k], (15)</p>
 * <p>u'[k] = U[p,k] / a[p,k] = l[k] + (U[p] - L'[p]) / a[p,k]. (16)</p>
 * <p>Similarly, if a[p,k] < 0, according to (7) and (11) we have:</p>
 * <p>L[p,k] = L[p] - (U'[p] - a[p,k] l[k]) =</p>
 * <p>= L[p] - U'[p] + a[p,k] l[k],</p>
 * <p>U[p,k] = U[p] - (L'[p] - a[p,k] u[k]) =</p>
 * <p>= U[p] - L'[p] + a[p,k] u[k],</p>
 * <p>and substituting these expressions into (8) and (12) gives:</p>
 * <p>l'[k] = U[p,k] / a[p,k] = u[k] + (U[p] - L'[p]) / a[p,k], (17)</p>
 * <p>u'[k] = L[p,k] / a[p,k] = l[k] + (L[p] - U'[p]) / a[p,k]. (18)</p>
 * <p>Note that formulae (15)-(18) can be used only if L'[p] and U'[p] exist. However, if for some variable x[j] it happens that l[j] = -oo and/or u[j] = +oo, values of L'[p] (if a[p,j] > 0) and/or U'[p] (if a[p,j] < 0) are undefined. Consider, therefore, the most general situation, when some column bounds (2) may not exist.</p>
 * <p>Let:</p>
 * <p>J' = {j : (a[p,j] > 0 and l[j] = -oo) or (19) (a[p,j] < 0 and u[j] = +oo)}.</p>
 * <p>Then (assuming that row upper bound U[p] can be active) the following three cases are possible:</p>
 * <p>1) |J'| = 0. In this case L'[p] exists, thus, for all variables x[j] in row (1) we can use formulae (16) and (17);</p>
 * <p>2) J' = {k}. In this case L'[p] = -oo, however, U[p,k] (11) exists, so for variable x[k] we can use formulae (12) and (13). Note that for all other variables x[j] (j != k) l'[j] = -oo (if a[p,j] < 0) or u'[j] = +oo (if a[p,j] > 0);</p>
 * <p>3) |J'| > 1. In this case for all variables x[j] in row [1] we have l'[j] = -oo (if a[p,j] < 0) or u'[j] = +oo (if a[p,j] > 0).</p>
 * <p>Similarly, let:</p>
 * <p>J'' = {j : (a[p,j] > 0 and u[j] = +oo) or (20) (a[p,j] < 0 and l[j] = -oo)}.</p>
 * <p>Then (assuming that row lower bound L[p] can be active) the following three cases are possible:</p>
 * <p>1) |J''| = 0. In this case U'[p] exists, thus, for all variables x[j] in row (1) we can use formulae (15) and (18);</p>
 * <p>2) J'' = {k}. In this case U'[p] = +oo, however, L[p,k] (7) exists, so for variable x[k] we can use formulae (8) and (9). Note that for all other variables x[j] (j != k) l'[j] = -oo (if a[p,j] > 0) or u'[j] = +oo (if a[p,j] < 0);</p>
 * <p>3) |J''| > 1. In this case for all variables x[j] in row (1) we have l'[j] = -oo (if a[p,j] > 0) or u'[j] = +oo (if a[p,j] < 0). </p>
 */
public";

%javamethodmodifiers npp_empty_row(NPP *npp, NPPROW *p) "
/**
 * npp_empty_row - process empty row .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" int npp_empty_row(NPP *npp, NPPROW *p);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine npp_empty_row processes row p, which is empty, i.e. coefficients at all columns in this row are zero:</p>
 * <p>L[p] <= sum 0 x[j] <= U[p], (1)</p>
 * <p>where L[p] <= U[p].</p>
 * <p>RETURNS</p>
 * <p>0 - success;</p>
 * <p>1 - problem has no primal feasible solution.</p>
 * <p>PROBLEM TRANSFORMATION</p>
 * <p>If the following conditions hold:</p>
 * <p>L[p] <= +eps, U[p] >= -eps, (2)</p>
 * <p>where eps is an absolute tolerance for row value, the row p is redundant. In this case it can be replaced by equivalent redundant row, which is free (unbounded), and then removed from the problem. Otherwise, the row p is infeasible and, thus, the problem has no primal feasible solution.</p>
 * <p>RECOVERING BASIC SOLUTION</p>
 * <p>See the routine npp_free_row.</p>
 * <p>RECOVERING INTERIOR-POINT SOLUTION</p>
 * <p>See the routine npp_free_row.</p>
 * <p>RECOVERING MIP SOLUTION</p>
 * <p>None needed. </p>
 */
public";

%javamethodmodifiers rcv_empty_col(NPP *npp, void *info) "
/**
 */
public";

%javamethodmodifiers npp_empty_col(NPP *npp, NPPCOL *q) "
/**
 */
public";

%javamethodmodifiers npp_implied_value(NPP *npp, NPPCOL *q, double s) "
/**
 * npp_implied_value - process implied column value .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" int npp_implied_value(NPP *npp, NPPCOL *q, double s);</p>
 * <p>DESCRIPTION</p>
 * <p>For column q:</p>
 * <p>l[q] <= x[q] <= u[q], (1)</p>
 * <p>where l[q] < u[q], the routine npp_implied_value processes its implied value s[q]. If this implied value satisfies to the current column bounds and integrality condition, the routine fixes column q at the given point. Note that the column is kept in the problem in any case.</p>
 * <p>RETURNS</p>
 * <p>0 - column has been fixed;</p>
 * <p>1 - implied value violates to current column bounds;</p>
 * <p>2 - implied value violates integrality condition.</p>
 * <p>ALGORITHM</p>
 * <p>Implied column value s[q] satisfies to the current column bounds if the following condition holds:</p>
 * <p>l[q] - eps <= s[q] <= u[q] + eps, (2)</p>
 * <p>where eps is an absolute tolerance for column value. If the column is integral, the following condition also must hold:</p>
 * <p>|s[q] - floor(s[q]+0.5)| <= eps, (3)</p>
 * <p>where floor(s[q]+0.5) is the nearest integer to s[q].</p>
 * <p>If both condition (2) and (3) are satisfied, the column can be fixed at the value s[q], or, if it is integral, at floor(s[q]+0.5). Otherwise, if s[q] violates (2) or (3), the problem has no feasible solution.</p>
 * <p>Note: If s[q] is close to l[q] or u[q], it seems to be reasonable to fix the column at its lower or upper bound, resp. rather than at the implied value. </p>
 */
public";

%javamethodmodifiers rcv_eq_singlet(NPP *npp, void *info) "
/**
 */
public";

%javamethodmodifiers npp_eq_singlet(NPP *npp, NPPROW *p) "
/**
 */
public";

%javamethodmodifiers npp_implied_lower(NPP *npp, NPPCOL *q, double l) "
/**
 * npp_implied_lower - process implied column lower bound .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" int npp_implied_lower(NPP *npp, NPPCOL *q, double l);</p>
 * <p>DESCRIPTION</p>
 * <p>For column q:</p>
 * <p>l[q] <= x[q] <= u[q], (1)</p>
 * <p>where l[q] < u[q], the routine npp_implied_lower processes its implied lower bound l'[q]. As the result the current column lower bound may increase. Note that the column is kept in the problem in any case.</p>
 * <p>RETURNS</p>
 * <p>0 - current column lower bound has not changed;</p>
 * <p>1 - current column lower bound has changed, but not significantly;</p>
 * <p>2 - current column lower bound has significantly changed;</p>
 * <p>3 - column has been fixed on its upper bound;</p>
 * <p>4 - implied lower bound violates current column upper bound.</p>
 * <p>ALGORITHM</p>
 * <p>If column q is integral, before processing its implied lower bound should be rounded up:</p>
 * <p>( floor(l'[q]+0.5), if |l'[q] - floor(l'[q]+0.5)| <= eps l'[q] := < (2) ( ceil(l'[q]), otherwise</p>
 * <p>where floor(l'[q]+0.5) is the nearest integer to l'[q], ceil(l'[q]) is smallest integer not less than l'[q], and eps is an absolute tolerance for column value.</p>
 * <p>Processing implied column lower bound l'[q] includes the following cases:</p>
 * <p>1) if l'[q] < l[q] + eps, implied lower bound is redundant;</p>
 * <p>2) if l[q] + eps <= l[q] <= u[q] + eps, current column lower bound l[q] can be strengthened by replacing it with l'[q]. If in this case new column lower bound becomes close to current column upper bound u[q], the column can be fixed on its upper bound;</p>
 * <p>3) if l'[q] > u[q] + eps, implied lower bound violates current column upper bound u[q], in which case the problem has no primal feasible solution. </p>
 */
public";

%javamethodmodifiers npp_implied_upper(NPP *npp, NPPCOL *q, double u) "
/**
 * npp_implied_upper - process implied column upper bound .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" int npp_implied_upper(NPP *npp, NPPCOL *q, double u);</p>
 * <p>DESCRIPTION</p>
 * <p>For column q:</p>
 * <p>l[q] <= x[q] <= u[q], (1)</p>
 * <p>where l[q] < u[q], the routine npp_implied_upper processes its implied upper bound u'[q]. As the result the current column upper bound may decrease. Note that the column is kept in the problem in any case.</p>
 * <p>RETURNS</p>
 * <p>0 - current column upper bound has not changed;</p>
 * <p>1 - current column upper bound has changed, but not significantly;</p>
 * <p>2 - current column upper bound has significantly changed;</p>
 * <p>3 - column has been fixed on its lower bound;</p>
 * <p>4 - implied upper bound violates current column lower bound.</p>
 * <p>ALGORITHM</p>
 * <p>If column q is integral, before processing its implied upper bound should be rounded down:</p>
 * <p>( floor(u'[q]+0.5), if |u'[q] - floor(l'[q]+0.5)| <= eps u'[q] := < (2) ( floor(l'[q]), otherwise</p>
 * <p>where floor(u'[q]+0.5) is the nearest integer to u'[q], floor(u'[q]) is largest integer not greater than u'[q], and eps is an absolute tolerance for column value.</p>
 * <p>Processing implied column upper bound u'[q] includes the following cases:</p>
 * <p>1) if u'[q] > u[q] - eps, implied upper bound is redundant;</p>
 * <p>2) if l[q] - eps <= u[q] <= u[q] - eps, current column upper bound u[q] can be strengthened by replacing it with u'[q]. If in this case new column upper bound becomes close to current column lower bound, the column can be fixed on its lower bound;</p>
 * <p>3) if u'[q] < l[q] - eps, implied upper bound violates current column lower bound l[q], in which case the problem has no primal feasible solution. </p>
 */
public";

%javamethodmodifiers rcv_ineq_singlet(NPP *npp, void *info) "
/**
 */
public";

%javamethodmodifiers npp_ineq_singlet(NPP *npp, NPPROW *p) "
/**
 */
public";

%javamethodmodifiers rcv_implied_slack(NPP *npp, void *info) "
/**
 */
public";

%javamethodmodifiers npp_implied_slack(NPP *npp, NPPCOL *q) "
/**
 */
public";

%javamethodmodifiers rcv_implied_free(NPP *npp, void *info) "
/**
 */
public";

%javamethodmodifiers npp_implied_free(NPP *npp, NPPCOL *q) "
/**
 */
public";

%javamethodmodifiers rcv_eq_doublet(NPP *npp, void *info) "
/**
 */
public";

%javamethodmodifiers npp_eq_doublet(NPP *npp, NPPROW *p) "
/**
 */
public";

%javamethodmodifiers rcv_forcing_row(NPP *npp, void *info) "
/**
 */
public";

%javamethodmodifiers npp_forcing_row(NPP *npp, NPPROW *p, int at) "
/**
 */
public";

%javamethodmodifiers npp_analyze_row(NPP *npp, NPPROW *p) "
/**
 * npp_analyze_row - perform general row analysis .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" int npp_analyze_row(NPP *npp, NPPROW *p);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine npp_analyze_row performs analysis of row p of general format:</p>
 * <p>L[p] <= sum a[p,j] x[j] <= U[p], (1) j</p>
 * <p>l[j] <= x[j] <= u[j], (2)</p>
 * <p>where L[p] <= U[p] and l[j] <= u[j] for all a[p,j] != 0.</p>
 * <p>RETURNS</p>
 * <p>0x?0 - row lower bound does not exist or is redundant;</p>
 * <p>0x?1 - row lower bound can be active;</p>
 * <p>0x?2 - row lower bound is a forcing bound;</p>
 * <p>0x0? - row upper bound does not exist or is redundant;</p>
 * <p>0x1? - row upper bound can be active;</p>
 * <p>0x2? - row upper bound is a forcing bound;</p>
 * <p>0x33 - row bounds are inconsistent with column bounds.</p>
 * <p>ALGORITHM</p>
 * <p>Analysis of row (1) is based on analysis of its implied lower and upper bounds, which are determined by bounds of corresponding columns (variables) as follows:</p>
 * <p>L'[p] = inf sum a[p,j] x[j] = j (3) = sum a[p,j] l[j] + sum a[p,j] u[j], j in Jp j in Jn</p>
 * <p>U'[p] = sup sum a[p,j] x[j] = (4) = sum a[p,j] u[j] + sum a[p,j] l[j], j in Jp j in Jn</p>
 * <p>Jp = {j: a[p,j] > 0}, Jn = {j: a[p,j] < 0}. (5)</p>
 * <p>(Note that bounds of all columns in row p are assumed to be correct, so L'[p] <= U'[p].)</p>
 * <p>Analysis of row lower bound L[p] includes the following cases:</p>
 * <p>1) if L[p] > U'[p] + eps, where eps is an absolute tolerance for row value, row lower bound L[p] and implied row upper bound U'[p] are inconsistent, ergo, the problem has no primal feasible solution;</p>
 * <p>2) if U'[p] - eps <= L[p] <= U'[p] + eps, i.e. if L[p] =~ U'[p], the row is a forcing row on its lower bound (see description of the routine npp_forcing_row);</p>
 * <p>3) if L[p] > L'[p] + eps, row lower bound L[p] can be active (this conclusion does not account other rows in the problem);</p>
 * <p>4) if L[p] <= L'[p] + eps, row lower bound L[p] cannot be active, so it is redundant and can be removed (replaced by -oo).</p>
 * <p>Analysis of row upper bound U[p] is performed in a similar way and includes the following cases:</p>
 * <p>1) if U[p] < L'[p] - eps, row upper bound U[p] and implied row lower bound L'[p] are inconsistent, ergo the problem has no primal feasible solution;</p>
 * <p>2) if L'[p] - eps <= U[p] <= L'[p] + eps, i.e. if U[p] =~ L'[p], the row is a forcing row on its upper bound (see description of the routine npp_forcing_row);</p>
 * <p>3) if U[p] < U'[p] - eps, row upper bound U[p] can be active (this conclusion does not account other rows in the problem);</p>
 * <p>4) if U[p] >= U'[p] - eps, row upper bound U[p] cannot be active, so it is redundant and can be removed (replaced by +oo). </p>
 */
public";

%javamethodmodifiers rcv_inactive_bound(NPP *npp, void *info) "
/**
 */
public";

%javamethodmodifiers npp_inactive_bound(NPP *npp, NPPROW *p, int which) "
/**
 */
public";

%javamethodmodifiers reduce_ineq_coef(NPP *npp, struct elem *ptr, double *_b) "
/**
 * npp_reduce_ineq_coef - reduce inequality constraint coefficients .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" int npp_reduce_ineq_coef(NPP *npp, NPPROW *row);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine npp_reduce_ineq_coef processes specified inequality constraint attempting to replace it by an equivalent constraint, where magnitude of coefficients at binary variables is smaller than in the original constraint. If the inequality is double-sided, it is replaced by a pair of single-sided inequalities, if necessary.</p>
 * <p>RETURNS</p>
 * <p>The routine npp_reduce_ineq_coef returns the number of coefficients reduced.</p>
 * <p>BACKGROUND</p>
 * <p>Consider an inequality constraint:</p>
 * <p>sum a[j] x[j] >= b. (1) j in J</p>
 * <p>(In case of '<=' inequality it can be transformed to '>=' format by multiplying both its sides by -1.) Let x[k] be a binary variable; other variables can be integer as well as continuous. We can write constraint (1) as follows:</p>
 * <p>a[k] x[k] + t[k] >= b, (2)</p>
 * <p>where:</p>
 * <p>t[k] = sum a[j] x[j]. (3) j in Jk}</p>
 * <p>Since x[k] is binary, constraint (2) is equivalent to disjunction of the following two constraints:</p>
 * <p>x[k] = 0, t[k] >= b (4)</p>
 * <p>OR</p>
 * <p>x[k] = 1, t[k] >= b - a[k]. (5)</p>
 * <p>Let also that for the partial sum t[k] be known some its implied lower bound inf t[k].</p>
 * <p>Case a[k] > 0. Let inf t[k] < b, since otherwise both constraints (4) and (5) and therefore constraint (2) are redundant. If inf t[k] > b - a[k], only constraint (5) is redundant, in which case it can be replaced with the following redundant and therefore equivalent constraint:</p>
 * <p>t[k] >= b - a'[k] = inf t[k], (6)</p>
 * <p>where:</p>
 * <p>a'[k] = b - inf t[k]. (7)</p>
 * <p>Thus, the original constraint (2) is equivalent to the following constraint with coefficient at variable x[k] changed:</p>
 * <p>a'[k] x[k] + t[k] >= b. (8)</p>
 * <p>From inf t[k] < b it follows that a'[k] > 0, i.e. the coefficient at x[k] keeps its sign. And from inf t[k] > b - a[k] it follows that a'[k] < a[k], i.e. the coefficient reduces in magnitude.</p>
 * <p>Case a[k] < 0. Let inf t[k] < b - a[k], since otherwise both constraints (4) and (5) and therefore constraint (2) are redundant. If inf t[k] > b, only constraint (4) is redundant, in which case it can be replaced with the following redundant and therefore equivalent constraint:</p>
 * <p>t[k] >= b' = inf t[k]. (9)</p>
 * <p>Rewriting constraint (5) as follows:</p>
 * <p>t[k] >= b - a[k] = b' - a'[k], (10)</p>
 * <p>where:</p>
 * <p>a'[k] = a[k] + b' - b = a[k] + inf t[k] - b, (11)</p>
 * <p>we can see that disjunction of constraint (9) and (10) is equivalent to disjunction of constraint (4) and (5), from which it follows that the original constraint (2) is equivalent to the following constraint with both coefficient at variable x[k] and right-hand side changed:</p>
 * <p>a'[k] x[k] + t[k] >= b'. (12)</p>
 * <p>From inf t[k] < b - a[k] it follows that a'[k] < 0, i.e. the coefficient at x[k] keeps its sign. And from inf t[k] > b it follows that a'[k] > a[k], i.e. the coefficient reduces in magnitude.</p>
 * <p>PROBLEM TRANSFORMATION</p>
 * <p>In the routine npp_reduce_ineq_coef the following implied lower bound of the partial sum (3) is used:</p>
 * <p>inf t[k] = sum a[j] l[j] + sum a[j] u[j], (13) j in Jpk} k in Jnk}</p>
 * <p>where Jp = {j : a[j] > 0}, Jn = {j : a[j] < 0}, l[j] and u[j] are lower and upper bounds, resp., of variable x[j].</p>
 * <p>In order to compute inf t[k] more efficiently, the following formula, which is equivalent to (13), is actually used:</p>
 * <p>( h - a[k] l[k] = h, if a[k] > 0, inf t[k] = < (14) ( h - a[k] u[k] = h - a[k], if a[k] < 0,</p>
 * <p>where:</p>
 * <p>h = sum a[j] l[j] + sum a[j] u[j] (15) j in Jp j in Jn</p>
 * <p>is the implied lower bound of row (1).</p>
 * <p>Reduction of positive coefficient (a[k] > 0) does not change value of h, since l[k] = 0. In case of reduction of negative coefficient (a[k] < 0) from (11) it follows that:</p>
 * <p>delta a[k] = a'[k] - a[k] = inf t[k] - b (> 0), (16)</p>
 * <p>so new value of h (accounting that u[k] = 1) can be computed as follows:</p>
 * <p>h := h + delta a[k] = h + (inf t[k] - b). (17)</p>
 * <p>RECOVERING SOLUTION</p>
 * <p>None needed. </p>
 */
public";

%javamethodmodifiers npp_reduce_ineq_coef(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers rcv_binarize_prob(NPP *npp, void *info) "
/**
 */
public";

%javamethodmodifiers npp_binarize_prob(NPP *npp) "
/**
 */
public";

%javamethodmodifiers copy_form(NPP *npp, NPPROW *row, double s) "
/**
 */
public";

%javamethodmodifiers drop_form(NPP *npp, struct elem *ptr) "
/**
 */
public";

%javamethodmodifiers npp_is_packing(NPP *npp, NPPROW *row) "
/**
 * npp_is_packing - test if constraint is packing inequality .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" int npp_is_packing(NPP *npp, NPPROW *row);</p>
 * <p>RETURNS</p>
 * <p>If the specified row (constraint) is packing inequality (see below), the routine npp_is_packing returns non-zero. Otherwise, it returns zero.</p>
 * <p>PACKING INEQUALITIES</p>
 * <p>In canonical format the packing inequality is the following:</p>
 * <p>sum x[j] <= 1, (1) j in J</p>
 * <p>where all variables x[j] are binary. This inequality expresses the condition that in any integer feasible solution at most one variable from set J can take non-zero (unity) value while other variables must be equal to zero. W.l.o.g. it is assumed that |J| >= 2, because if J is empty or |J| = 1, the inequality (1) is redundant.</p>
 * <p>In general case the packing inequality may include original variables x[j] as well as their complements x~[j]:</p>
 * <p>sum x[j] + sum x~[j] <= 1, (2) j in Jp j in Jn</p>
 * <p>where Jp and Jn are not intersected. Therefore, using substitution x~[j] = 1 - x[j] gives the packing inequality in generalized format:</p>
 * <p>sum x[j] - sum x[j] <= 1 - |Jn|. (3) j in Jp j in Jn </p>
 */
public";

%javamethodmodifiers hidden_packing(NPP *npp, struct elem *ptr, double *_b) "
/**
 * npp_hidden_packing - identify hidden packing inequality .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" int npp_hidden_packing(NPP *npp, NPPROW *row);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine npp_hidden_packing processes specified inequality constraint, which includes only binary variables, and the number of the variables is not less than two. If the original inequality is equivalent to a packing inequality, the routine replaces it by this equivalent inequality. If the original constraint is double-sided inequality, it is replaced by a pair of single-sided inequalities, if necessary.</p>
 * <p>RETURNS</p>
 * <p>If the original inequality constraint was replaced by equivalent packing inequality, the routine npp_hidden_packing returns non-zero. Otherwise, it returns zero.</p>
 * <p>PROBLEM TRANSFORMATION</p>
 * <p>Consider an inequality constraint:</p>
 * <p>sum a[j] x[j] <= b, (1) j in J</p>
 * <p>where all variables x[j] are binary, and |J| >= 2. (In case of '>=' inequality it can be transformed to '<=' format by multiplying both its sides by -1.)</p>
 * <p>Let Jp = {j: a[j] > 0}, Jn = {j: a[j] < 0}. Performing substitution x[j] = 1 - x~[j] for all j in Jn, we have:</p>
 * <p>sum a[j] x[j] <= b ==> j in J</p>
 * <p>sum a[j] x[j] + sum a[j] x[j] <= b ==> j in Jp j in Jn</p>
 * <p>sum a[j] x[j] + sum a[j] (1 - x~[j]) <= b ==> j in Jp j in Jn</p>
 * <p>sum a[j] x[j] - sum a[j] x~[j] <= b - sum a[j]. j in Jp j in Jn j in Jn</p>
 * <p>Thus, meaning the transformation above, we can assume that in inequality (1) all coefficients a[j] are positive. Moreover, we can assume that a[j] <= b. In fact, let a[j] > b; then the following three cases are possible:</p>
 * <p>1) b < 0. In this case inequality (1) is infeasible, so the problem has no feasible solution (see the routine npp_analyze_row);</p>
 * <p>2) b = 0. In this case inequality (1) is a forcing inequality on its upper bound (see the routine npp_forcing row), from which it follows that all variables x[j] should be fixed at zero;</p>
 * <p>3) b > 0. In this case inequality (1) defines an implied zero upper bound for variable x[j] (see the routine npp_implied_bounds), from which it follows that x[j] should be fixed at zero.</p>
 * <p>It is assumed that all three cases listed above have been recognized by the routine npp_process_prob, which performs basic MIP processing prior to a call the routine npp_hidden_packing. So, if one of these cases occurs, we should just skip processing such constraint.</p>
 * <p>Thus, let 0 < a[j] <= b. Then it is obvious that constraint (1) is equivalent to packing inquality only if:</p>
 * <p>a[j] + a[k] > b + eps (2)</p>
 * <p>for all j, k in J, j != k, where eps is an absolute tolerance for row (linear form) value. Checking the condition (2) for all j and k, j != k, requires time O(|J|^2). However, this time can be reduced to O(|J|), if use minimal a[j] and a[k], in which case it is sufficient to check the condition (2) only once.</p>
 * <p>Once the original inequality (1) is replaced by equivalent packing inequality, we need to perform back substitution x~[j] = 1 - x[j] for all j in Jn (see above).</p>
 * <p>RECOVERING SOLUTION</p>
 * <p>None needed. </p>
 */
public";

%javamethodmodifiers npp_hidden_packing(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_implied_packing(NPP *npp, NPPROW *row, int which, NPPCOL *var[], char set[]) "
/**
 * npp_implied_packing - identify implied packing inequality .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" int npp_implied_packing(NPP *npp, NPPROW *row, int which, NPPCOL *var[], char set[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine npp_implied_packing processes specified row (constraint) of general format:</p>
 * <p>L <= sum a[j] x[j] <= U. (1) j</p>
 * <p>If which = 0, only lower bound L, which must exist, is considered, while upper bound U is ignored. Similarly, if which = 1, only upper bound U, which must exist, is considered, while lower bound L is ignored. Thus, if the specified row is a double-sided inequality or equality constraint, this routine should be called twice for both lower and upper bounds.</p>
 * <p>The routine npp_implied_packing attempts to find a non-trivial (i.e. having not less than two binary variables) packing inequality:</p>
 * <p>sum x[j] - sum x[j] <= 1 - |Jn|, (2) j in Jp j in Jn</p>
 * <p>which is relaxation of the constraint (1) in the sense that any solution satisfying to that constraint also satisfies to the packing inequality (2). If such relaxation exists, the routine stores pointers to descriptors of corresponding binary variables and their flags, resp., to locations var[1], var[2], ..., var[len] and set[1], set[2], ..., set[len], where set[j] = 0 means that j in Jp and set[j] = 1 means that j in Jn.</p>
 * <p>RETURNS</p>
 * <p>The routine npp_implied_packing returns len, which is the total number of binary variables in the packing inequality found, len >= 2. However, if the relaxation does not exist, the routine returns zero.</p>
 * <p>ALGORITHM</p>
 * <p>If which = 0, the constraint coefficients (1) are multiplied by -1 and b is assigned -L; if which = 1, the constraint coefficients (1) are not changed and b is assigned +U. In both cases the specified constraint gets the following format:</p>
 * <p>sum a[j] x[j] <= b. (3) j</p>
 * <p>(Note that (3) is a relaxation of (1), because one of bounds L or U is ignored.)</p>
 * <p>Let J be set of binary variables, Kp be set of non-binary (integer or continuous) variables with a[j] > 0, and Kn be set of non-binary variables with a[j] < 0. Then the inequality (3) can be written as follows:</p>
 * <p>sum a[j] x[j] <= b - sum a[j] x[j] - sum a[j] x[j]. (4) j in J j in Kp j in Kn</p>
 * <p>To get rid of non-binary variables we can replace the inequality (4) by the following relaxed inequality:</p>
 * <p>sum a[j] x[j] <= b~, (5) j in J</p>
 * <p>where:</p>
 * <p>b~ = sup(b - sum a[j] x[j] - sum a[j] x[j]) = j in Kp j in Kn</p>
 * <p>= b - inf sum a[j] x[j] - inf sum a[j] x[j] = (6) j in Kp j in Kn</p>
 * <p>= b - sum a[j] l[j] - sum a[j] u[j]. j in Kp j in Kn</p>
 * <p>Note that if lower bound l[j] (if j in Kp) or upper bound u[j] (if j in Kn) of some non-binary variable x[j] does not exist, then formally b = +oo, in which case further analysis is not performed.</p>
 * <p>Let Bp = {j in J: a[j] > 0}, Bn = {j in J: a[j] < 0}. To make all the inequality coefficients in (5) positive, we replace all x[j] in Bn by their complementaries, substituting x[j] = 1 - x~[j] for all j in Bn, that gives:</p>
 * <p>sum a[j] x[j] - sum a[j] x~[j] <= b~ - sum a[j]. (7) j in Bp j in Bn j in Bn</p>
 * <p>This inequality is a relaxation of the original constraint (1), and it is a binary knapsack inequality. Writing it in the standard format we have:</p>
 * <p>sum alfa[j] z[j] <= beta, (8) j in J</p>
 * <p>where: ( + a[j], if j in Bp, alfa[j] = < (9) ( - a[j], if j in Bn,</p>
 * <p>( x[j], if j in Bp, z[j] = < (10) ( 1 - x[j], if j in Bn,</p>
 * <p>beta = b~ - sum a[j]. (11) j in Bn</p>
 * <p>In the inequality (8) all coefficients are positive, therefore, the packing relaxation to be found for this inequality is the following:</p>
 * <p>sum z[j] <= 1. (12) j in P</p>
 * <p>It is obvious that set P within J, which we would like to find, must satisfy to the following condition:</p>
 * <p>alfa[j] + alfa[k] > beta + eps for all j, k in P, j != k, (13)</p>
 * <p>where eps is an absolute tolerance for value of the linear form. Thus, it is natural to take P = {j: alpha[j] > (beta + eps) / 2}. Moreover, if in the equality (8) there exist coefficients alfa[k], for which alfa[k] <= (beta + eps) / 2, but which, nevertheless, satisfies to the condition (13) for all j in P, *one* corresponding variable z[k] (having, for example, maximal coefficient alfa[k]) can be included in set P, that allows increasing the number of binary variables in (12) by one.</p>
 * <p>Once the set P has been built, for the inequality (12) we need to perform back substitution according to (10) in order to express it through the original binary variables. As the result of such back substitution the relaxed packing inequality get its final format (2), where Jp = J intersect Bp, and Jn = J intersect Bn. </p>
 */
public";

%javamethodmodifiers npp_is_covering(NPP *npp, NPPROW *row) "
/**
 * npp_is_covering - test if constraint is covering inequality .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" int npp_is_covering(NPP *npp, NPPROW *row);</p>
 * <p>RETURNS</p>
 * <p>If the specified row (constraint) is covering inequality (see below), the routine npp_is_covering returns non-zero. Otherwise, it returns zero.</p>
 * <p>COVERING INEQUALITIES</p>
 * <p>In canonical format the covering inequality is the following:</p>
 * <p>sum x[j] >= 1, (1) j in J</p>
 * <p>where all variables x[j] are binary. This inequality expresses the condition that in any integer feasible solution variables in set J cannot be all equal to zero at the same time, i.e. at least one variable must take non-zero (unity) value. W.l.o.g. it is assumed that |J| >= 2, because if J is empty, the inequality (1) is infeasible, and if |J| = 1, the inequality (1) is a forcing row.</p>
 * <p>In general case the covering inequality may include original variables x[j] as well as their complements x~[j]:</p>
 * <p>sum x[j] + sum x~[j] >= 1, (2) j in Jp j in Jn</p>
 * <p>where Jp and Jn are not intersected. Therefore, using substitution x~[j] = 1 - x[j] gives the packing inequality in generalized format:</p>
 * <p>sum x[j] - sum x[j] >= 1 - |Jn|. (3) j in Jp j in Jn</p>
 * <p>(May note that the inequality (3) cuts off infeasible solutions, where x[j] = 0 for all j in Jp and x[j] = 1 for all j in Jn.)</p>
 * <p>NOTE: If |J| = 2, the inequality (3) is equivalent to packing inequality (see the routine npp_is_packing). </p>
 */
public";

%javamethodmodifiers hidden_covering(NPP *npp, struct elem *ptr, double *_b) "
/**
 * npp_hidden_covering - identify hidden covering inequality .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" int npp_hidden_covering(NPP *npp, NPPROW *row);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine npp_hidden_covering processes specified inequality constraint, which includes only binary variables, and the number of the variables is not less than three. If the original inequality is equivalent to a covering inequality (see below), the routine replaces it by the equivalent inequality. If the original constraint is double-sided inequality, it is replaced by a pair of single-sided inequalities, if necessary.</p>
 * <p>RETURNS</p>
 * <p>If the original inequality constraint was replaced by equivalent covering inequality, the routine npp_hidden_covering returns non-zero. Otherwise, it returns zero.</p>
 * <p>PROBLEM TRANSFORMATION</p>
 * <p>Consider an inequality constraint:</p>
 * <p>sum a[j] x[j] >= b, (1) j in J</p>
 * <p>where all variables x[j] are binary, and |J| >= 3. (In case of '<=' inequality it can be transformed to '>=' format by multiplying both its sides by -1.)</p>
 * <p>Let Jp = {j: a[j] > 0}, Jn = {j: a[j] < 0}. Performing substitution x[j] = 1 - x~[j] for all j in Jn, we have:</p>
 * <p>sum a[j] x[j] >= b ==> j in J</p>
 * <p>sum a[j] x[j] + sum a[j] x[j] >= b ==> j in Jp j in Jn</p>
 * <p>sum a[j] x[j] + sum a[j] (1 - x~[j]) >= b ==> j in Jp j in Jn</p>
 * <p>sum m a[j] x[j] - sum a[j] x~[j] >= b - sum a[j]. j in Jp j in Jn j in Jn</p>
 * <p>Thus, meaning the transformation above, we can assume that in inequality (1) all coefficients a[j] are positive. Moreover, we can assume that b > 0, because otherwise the inequality (1) would be redundant (see the routine npp_analyze_row). It is then obvious that constraint (1) is equivalent to covering inequality only if:</p>
 * <p>a[j] >= b, (2)</p>
 * <p>for all j in J.</p>
 * <p>Once the original inequality (1) is replaced by equivalent covering inequality, we need to perform back substitution x~[j] = 1 - x[j] for all j in Jn (see above).</p>
 * <p>RECOVERING SOLUTION</p>
 * <p>None needed. </p>
 */
public";

%javamethodmodifiers npp_hidden_covering(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_is_partitioning(NPP *npp, NPPROW *row) "
/**
 * npp_is_partitioning - test if constraint is partitioning equality .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" int npp_is_partitioning(NPP *npp, NPPROW *row);</p>
 * <p>RETURNS</p>
 * <p>If the specified row (constraint) is partitioning equality (see below), the routine npp_is_partitioning returns non-zero. Otherwise, it returns zero.</p>
 * <p>PARTITIONING EQUALITIES</p>
 * <p>In canonical format the partitioning equality is the following:</p>
 * <p>sum x[j] = 1, (1) j in J</p>
 * <p>where all variables x[j] are binary. This equality expresses the condition that in any integer feasible solution exactly one variable in set J must take non-zero (unity) value while other variables must be equal to zero. W.l.o.g. it is assumed that |J| >= 2, because if J is empty, the inequality (1) is infeasible, and if |J| = 1, the inequality (1) is a fixing row.</p>
 * <p>In general case the partitioning equality may include original variables x[j] as well as their complements x~[j]:</p>
 * <p>sum x[j] + sum x~[j] = 1, (2) j in Jp j in Jn</p>
 * <p>where Jp and Jn are not intersected. Therefore, using substitution x~[j] = 1 - x[j] leads to the partitioning equality in generalized format:</p>
 * <p>sum x[j] - sum x[j] = 1 - |Jn|. (3) j in Jp j in Jn </p>
 */
public";

%javamethodmodifiers npp_clean_prob(NPP *npp) "
/**
 * npp_clean_prob - perform initial LP/MIP processing .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" void npp_clean_prob(NPP *npp);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine npp_clean_prob performs initial LP/MIP processing that currently includes:</p>
 * <p>1) removing free rows;</p>
 * <p>2) replacing double-sided constraint rows with almost identical bounds, by equality constraint rows;</p>
 * <p>3) removing fixed columns;</p>
 * <p>4) replacing double-bounded columns with almost identical bounds by fixed columns and removing those columns;</p>
 * <p>5) initial processing constraint coefficients (not implemented);</p>
 * <p>6) initial processing objective coefficients (not implemented). </p>
 */
public";

%javamethodmodifiers npp_process_row(NPP *npp, NPPROW *row, int hard) "
/**
 * npp_process_row - perform basic row processing .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" int npp_process_row(NPP *npp, NPPROW *row, int hard);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine npp_process_row performs basic row processing that currently includes:</p>
 * <p>1) removing empty row;</p>
 * <p>2) removing equality constraint row singleton and corresponding column;</p>
 * <p>3) removing inequality constraint row singleton and corresponding column if it was fixed;</p>
 * <p>4) performing general row analysis;</p>
 * <p>5) removing redundant row bounds;</p>
 * <p>6) removing forcing row and corresponding columns;</p>
 * <p>7) removing row which becomes free due to redundant bounds;</p>
 * <p>8) computing implied bounds for all columns in the row and using them to strengthen current column bounds (MIP only, optional, performed if the flag hard is on).</p>
 * <p>Additionally the routine may activate affected rows and/or columns for further processing.</p>
 * <p>RETURNS</p>
 * <p>0 success;</p>
 * <p>GLP_ENOPFS primal/integer infeasibility detected;</p>
 * <p>GLP_ENODFS dual infeasibility detected. </p>
 */
public";

%javamethodmodifiers npp_improve_bounds(NPP *npp, NPPROW *row, int flag) "
/**
 * npp_improve_bounds - improve current column bounds .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" int npp_improve_bounds(NPP *npp, NPPROW *row, int flag);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine npp_improve_bounds analyzes specified row (inequality or equality constraint) to determine implied column bounds and then uses these bounds to improve (strengthen) current column bounds.</p>
 * <p>If the flag is on and current column bounds changed significantly or the column was fixed, the routine activate rows affected by the column for further processing. (This feature is intended to be used in the main loop of the routine npp_process_row.)</p>
 * <p>NOTE: This operation can be used for MIP problem only.</p>
 * <p>RETURNS</p>
 * <p>The routine npp_improve_bounds returns the number of significantly changed bounds plus the number of column having been fixed due to bound improvements. However, if the routine detects primal/integer infeasibility, it returns a negative value. </p>
 */
public";

%javamethodmodifiers npp_process_col(NPP *npp, NPPCOL *col) "
/**
 * npp_process_col - perform basic column processing .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" int npp_process_col(NPP *npp, NPPCOL *col);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine npp_process_col performs basic column processing that currently includes:</p>
 * <p>1) fixing and removing empty column;</p>
 * <p>2) removing column singleton, which is implied slack variable, and corresponding row if it becomes free;</p>
 * <p>3) removing bounds of column, which is implied free variable, and replacing corresponding row by equality constraint.</p>
 * <p>Additionally the routine may activate affected rows and/or columns for further processing.</p>
 * <p>RETURNS</p>
 * <p>0 success;</p>
 * <p>GLP_ENOPFS primal/integer infeasibility detected;</p>
 * <p>GLP_ENODFS dual infeasibility detected. </p>
 */
public";

%javamethodmodifiers npp_process_prob(NPP *npp, int hard) "
/**
 * npp_process_prob - perform basic LP/MIP processing .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpnpp.h\" int npp_process_prob(NPP *npp, int hard);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine npp_process_prob performs basic LP/MIP processing that currently includes:</p>
 * <p>1) initial LP/MIP processing (see the routine npp_clean_prob),</p>
 * <p>2) basic row processing (see the routine npp_process_row), and</p>
 * <p>3) basic column processing (see the routine npp_process_col).</p>
 * <p>If the flag hard is on, the routine attempts to improve current column bounds multiple times within the main processing loop, in which case this feature may take a time. Otherwise, if the flag hard is off, improving column bounds is performed only once at the end of the main loop. (Note that this feature is used for MIP only.)</p>
 * <p>The routine uses two sets: the set of active rows and the set of active columns. Rows/columns are marked by a flag (the field temp in NPPROW/NPPCOL). If the flag is non-zero, the row/column is active, in which case it is placed in the beginning of the row/column list; otherwise, if the flag is zero, the row/column is inactive, in which case it is placed in the end of the row/column list. If a row/column being currently processed may affect other rows/columns, the latters are activated for further processing.</p>
 * <p>RETURNS</p>
 * <p>0 success;</p>
 * <p>GLP_ENOPFS primal/integer infeasibility detected;</p>
 * <p>GLP_ENODFS dual infeasibility detected. </p>
 */
public";

%javamethodmodifiers npp_simplex(NPP *npp, const glp_smcp *parm) "
/**
 */
public";

%javamethodmodifiers npp_integer(NPP *npp, const glp_iocp *parm) "
/**
 */
public";

%javamethodmodifiers npp_sat_free_row(NPP *npp, NPPROW *p) "
/**
 */
public";

%javamethodmodifiers rcv_sat_fixed_col(NPP *, void *) "
/**
 */
public";

%javamethodmodifiers npp_sat_fixed_col(NPP *npp, NPPCOL *q) "
/**
 */
public";

%javamethodmodifiers npp_sat_is_bin_comb(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_sat_num_pos_coef(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_sat_num_neg_coef(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_sat_is_cover_ineq(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_sat_is_pack_ineq(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_sat_is_partn_eq(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_sat_reverse_row(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_sat_split_pack(NPP *npp, NPPROW *row, int nlit) "
/**
 */
public";

%javamethodmodifiers npp_sat_encode_pack(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_sat_encode_sum2(NPP *npp, NPPLSE *set, NPPSED *sed) "
/**
 */
public";

%javamethodmodifiers npp_sat_encode_sum3(NPP *npp, NPPLSE *set, NPPSED *sed) "
/**
 */
public";

%javamethodmodifiers remove_lse(NPP *npp, NPPLSE *set, NPPCOL *col) "
/**
 */
public";

%javamethodmodifiers npp_sat_encode_sum_ax(NPP *npp, NPPROW *row, NPPLIT y[]) "
/**
 */
public";

%javamethodmodifiers npp_sat_normalize_clause(NPP *npp, int size, NPPLIT lit[]) "
/**
 */
public";

%javamethodmodifiers npp_sat_encode_clause(NPP *npp, int size, NPPLIT lit[]) "
/**
 */
public";

%javamethodmodifiers npp_sat_encode_geq(NPP *npp, int n, NPPLIT y[], int rhs) "
/**
 */
public";

%javamethodmodifiers npp_sat_encode_leq(NPP *npp, int n, NPPLIT y[], int rhs) "
/**
 */
public";

%javamethodmodifiers npp_sat_encode_row(NPP *npp, NPPROW *row) "
/**
 */
public";

%javamethodmodifiers npp_sat_encode_prob(NPP *npp) "
/**
 */
public";

%javamethodmodifiers genqmd(int *_neqns, int xadj[], int adjncy[], int perm[], int invp[], int deg[], int marker[], int rchset[], int nbrhd[], int qsize[], int qlink[], int *_nofsub) "
/**
 * genqmd - GENeral Quotient Minimum Degree algorithm .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpqmd.h\" void genqmd(int *neqns, int xadj[], int adjncy[], int perm[], int invp[], int deg[], int marker[], int rchset[], int nbrhd[], int qsize[], int qlink[], int *nofsub);</p>
 * <p>PURPOSE</p>
 * <p>This routine implements the minimum degree algorithm. It makes use of the implicit representation of the elimination graph by quotient graphs, and the notion of indistinguishable nodes.</p>
 * <p>CAUTION</p>
 * <p>The adjancy vector adjncy will be destroyed.</p>
 * <p>INPUT PARAMETERS</p>
 * <p>neqns - number of equations; (xadj, adjncy) - the adjancy structure.</p>
 * <p>OUTPUT PARAMETERS</p>
 * <p>perm - the minimum degree ordering; invp - the inverse of perm.</p>
 * <p>WORKING PARAMETERS</p>
 * <p>deg - the degree vector. deg[i] is negative means node i has been numbered; marker - a marker vector, where marker[i] is negative means node i has been merged with another nodeand thus can be ignored; rchset - vector used for the reachable set; nbrhd - vector used for neighborhood set; qsize - vector used to store the size of indistinguishable supernodes; qlink - vector used to store indistinguishable nodes, i, qlink[i], qlink[qlink[i]], ... are the members of the supernode represented by i.</p>
 * <p>PROGRAM SUBROUTINES</p>
 * <p>qmdrch, qmdqt, qmdupd. </p>
 */
public";

%javamethodmodifiers qmdrch(int *_root, int xadj[], int adjncy[], int deg[], int marker[], int *_rchsze, int rchset[], int *_nhdsze, int nbrhd[]) "
/**
 * qmdrch - Quotient MD ReaCHable set .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpqmd.h\" void qmdrch(int *root, int xadj[], int adjncy[], int deg[], int marker[], int *rchsze, int rchset[], int *nhdsze, int nbrhd[]);</p>
 * <p>PURPOSE</p>
 * <p>This subroutine determines the reachable set of a node through a given subset. The adjancy structure is assumed to be stored in a quotient graph format.</p>
 * <p>INPUT PARAMETERS</p>
 * <p>root - the given node not in the subset; (xadj, adjncy) - the adjancy structure pair; deg - the degree vector. deg[i] < 0 means the node belongs to the given subset.</p>
 * <p>OUTPUT PARAMETERS</p>
 * <p>(rchsze, rchset) - the reachable set; (nhdsze, nbrhd) - the neighborhood set.</p>
 * <p>UPDATED PARAMETERS</p>
 * <p>marker - the marker vector for reach and nbrhd sets. > 0 means the node is in reach set. < 0 means the node has been merged with others in the quotient or it is in nbrhd set. </p>
 */
public";

%javamethodmodifiers qmdqt(int *_root, int xadj[], int adjncy[], int marker[], int *_rchsze, int rchset[], int nbrhd[]) "
/**
 * qmdqt - Quotient MD Quotient graph Transformation .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpqmd.h\" void qmdqt(int *root, int xadj[], int adjncy[], int marker[], int *rchsze, int rchset[], int nbrhd[]);</p>
 * <p>PURPOSE</p>
 * <p>This subroutine performs the quotient graph transformation after a node has been eliminated.</p>
 * <p>INPUT PARAMETERS</p>
 * <p>root - the node just eliminated. It becomes the representative of the new supernode; (xadj, adjncy) - the adjancy structure; (rchsze, rchset) - the reachable set of root in the old quotient graph; nbrhd - the neighborhood set which will be merged with root to form the new supernode; marker - the marker vector.</p>
 * <p>UPDATED PARAMETERS</p>
 * <p>adjncy - becomes the adjncy of the quotient graph. </p>
 */
public";

%javamethodmodifiers qmdupd(int xadj[], int adjncy[], int *_nlist, int list[], int deg[], int qsize[], int qlink[], int marker[], int rchset[], int nbrhd[]) "
/**
 * qmdupd - Quotient MD UPDate .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpqmd.h\" void qmdupd(int xadj[], int adjncy[], int *nlist, int list[], int deg[], int qsize[], int qlink[], int marker[], int rchset[], int nbrhd[]);</p>
 * <p>PURPOSE</p>
 * <p>This routine performs degree update for a set of nodes in the minimum degree algorithm.</p>
 * <p>INPUT PARAMETERS</p>
 * <p>(xadj, adjncy) - the adjancy structure; (nlist, list) - the list of nodes whose degree has to be updated.</p>
 * <p>UPDATED PARAMETERS</p>
 * <p>deg - the degree vector; qsize - size of indistinguishable supernodes; qlink - linked list for indistinguishable nodes; marker - used to mark those nodes in reach/nbrhd sets.</p>
 * <p>WORKING PARAMETERS</p>
 * <p>rchset - the reachable set; nbrhd - the neighborhood set.</p>
 * <p>PROGRAM SUBROUTINES</p>
 * <p>qmdmrg. </p>
 */
public";

%javamethodmodifiers qmdmrg(int xadj[], int adjncy[], int deg[], int qsize[], int qlink[], int marker[], int *_deg0, int *_nhdsze, int nbrhd[], int rchset[], int ovrlp[]) "
/**
 * qmdmrg - Quotient MD MeRGe .
 * <p>SYNOPSIS</p>
 * <p>#include \"qmdmrg.h\" void qmdmrg(int xadj[], int adjncy[], int deg[], int qsize[], int qlink[], int marker[], int *deg0, int *nhdsze, int nbrhd[], int rchset[], int ovrlp[]);</p>
 * <p>PURPOSE</p>
 * <p>This routine merges indistinguishable nodes in the minimum degree ordering algorithm. It also computes the new degrees of these new supernodes.</p>
 * <p>INPUT PARAMETERS</p>
 * <p>(xadj, adjncy) - the adjancy structure; deg0 - the number of nodes in the given set; (nhdsze, nbrhd) - the set of eliminated supernodes adjacent to some nodes in the set.</p>
 * <p>UPDATED PARAMETERS</p>
 * <p>deg - the degree vector; qsize - size of indistinguishable nodes; qlink - linked list for indistinguishable nodes; marker - the given set is given by those nodes with marker value set to 1. Those nodes with degree updated will have marker value set to 2.</p>
 * <p>WORKING PARAMETERS</p>
 * <p>rchset - the reachable set; ovrlp - temp vector to store the intersection of two reachable sets. </p>
 */
public";

%javamethodmodifiers genqmd(int *neqns, int xadj[], int adjncy[], int perm[], int invp[], int deg[], int marker[], int rchset[], int nbrhd[], int qsize[], int qlink[], int *nofsub) "
/**
 * genqmd - GENeral Quotient Minimum Degree algorithm .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpqmd.h\" void genqmd(int *neqns, int xadj[], int adjncy[], int perm[], int invp[], int deg[], int marker[], int rchset[], int nbrhd[], int qsize[], int qlink[], int *nofsub);</p>
 * <p>PURPOSE</p>
 * <p>This routine implements the minimum degree algorithm. It makes use of the implicit representation of the elimination graph by quotient graphs, and the notion of indistinguishable nodes.</p>
 * <p>CAUTION</p>
 * <p>The adjancy vector adjncy will be destroyed.</p>
 * <p>INPUT PARAMETERS</p>
 * <p>neqns - number of equations; (xadj, adjncy) - the adjancy structure.</p>
 * <p>OUTPUT PARAMETERS</p>
 * <p>perm - the minimum degree ordering; invp - the inverse of perm.</p>
 * <p>WORKING PARAMETERS</p>
 * <p>deg - the degree vector. deg[i] is negative means node i has been numbered; marker - a marker vector, where marker[i] is negative means node i has been merged with another nodeand thus can be ignored; rchset - vector used for the reachable set; nbrhd - vector used for neighborhood set; qsize - vector used to store the size of indistinguishable supernodes; qlink - vector used to store indistinguishable nodes, i, qlink[i], qlink[qlink[i]], ... are the members of the supernode represented by i.</p>
 * <p>PROGRAM SUBROUTINES</p>
 * <p>qmdrch, qmdqt, qmdupd. </p>
 */
public";

%javamethodmodifiers qmdrch(int *root, int xadj[], int adjncy[], int deg[], int marker[], int *rchsze, int rchset[], int *nhdsze, int nbrhd[]) "
/**
 * qmdrch - Quotient MD ReaCHable set .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpqmd.h\" void qmdrch(int *root, int xadj[], int adjncy[], int deg[], int marker[], int *rchsze, int rchset[], int *nhdsze, int nbrhd[]);</p>
 * <p>PURPOSE</p>
 * <p>This subroutine determines the reachable set of a node through a given subset. The adjancy structure is assumed to be stored in a quotient graph format.</p>
 * <p>INPUT PARAMETERS</p>
 * <p>root - the given node not in the subset; (xadj, adjncy) - the adjancy structure pair; deg - the degree vector. deg[i] < 0 means the node belongs to the given subset.</p>
 * <p>OUTPUT PARAMETERS</p>
 * <p>(rchsze, rchset) - the reachable set; (nhdsze, nbrhd) - the neighborhood set.</p>
 * <p>UPDATED PARAMETERS</p>
 * <p>marker - the marker vector for reach and nbrhd sets. > 0 means the node is in reach set. < 0 means the node has been merged with others in the quotient or it is in nbrhd set. </p>
 */
public";

%javamethodmodifiers qmdqt(int *root, int xadj[], int adjncy[], int marker[], int *rchsze, int rchset[], int nbrhd[]) "
/**
 * qmdqt - Quotient MD Quotient graph Transformation .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpqmd.h\" void qmdqt(int *root, int xadj[], int adjncy[], int marker[], int *rchsze, int rchset[], int nbrhd[]);</p>
 * <p>PURPOSE</p>
 * <p>This subroutine performs the quotient graph transformation after a node has been eliminated.</p>
 * <p>INPUT PARAMETERS</p>
 * <p>root - the node just eliminated. It becomes the representative of the new supernode; (xadj, adjncy) - the adjancy structure; (rchsze, rchset) - the reachable set of root in the old quotient graph; nbrhd - the neighborhood set which will be merged with root to form the new supernode; marker - the marker vector.</p>
 * <p>UPDATED PARAMETERS</p>
 * <p>adjncy - becomes the adjncy of the quotient graph. </p>
 */
public";

%javamethodmodifiers qmdupd(int xadj[], int adjncy[], int *nlist, int list[], int deg[], int qsize[], int qlink[], int marker[], int rchset[], int nbrhd[]) "
/**
 * qmdupd - Quotient MD UPDate .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpqmd.h\" void qmdupd(int xadj[], int adjncy[], int *nlist, int list[], int deg[], int qsize[], int qlink[], int marker[], int rchset[], int nbrhd[]);</p>
 * <p>PURPOSE</p>
 * <p>This routine performs degree update for a set of nodes in the minimum degree algorithm.</p>
 * <p>INPUT PARAMETERS</p>
 * <p>(xadj, adjncy) - the adjancy structure; (nlist, list) - the list of nodes whose degree has to be updated.</p>
 * <p>UPDATED PARAMETERS</p>
 * <p>deg - the degree vector; qsize - size of indistinguishable supernodes; qlink - linked list for indistinguishable nodes; marker - used to mark those nodes in reach/nbrhd sets.</p>
 * <p>WORKING PARAMETERS</p>
 * <p>rchset - the reachable set; nbrhd - the neighborhood set.</p>
 * <p>PROGRAM SUBROUTINES</p>
 * <p>qmdmrg. </p>
 */
public";

%javamethodmodifiers qmdmrg(int xadj[], int adjncy[], int deg[], int qsize[], int qlink[], int marker[], int *deg0, int *nhdsze, int nbrhd[], int rchset[], int ovrlp[]) "
/**
 * qmdmrg - Quotient MD MeRGe .
 * <p>SYNOPSIS</p>
 * <p>#include \"qmdmrg.h\" void qmdmrg(int xadj[], int adjncy[], int deg[], int qsize[], int qlink[], int marker[], int *deg0, int *nhdsze, int nbrhd[], int rchset[], int ovrlp[]);</p>
 * <p>PURPOSE</p>
 * <p>This routine merges indistinguishable nodes in the minimum degree ordering algorithm. It also computes the new degrees of these new supernodes.</p>
 * <p>INPUT PARAMETERS</p>
 * <p>(xadj, adjncy) - the adjancy structure; deg0 - the number of nodes in the given set; (nhdsze, nbrhd) - the set of eliminated supernodes adjacent to some nodes in the set.</p>
 * <p>UPDATED PARAMETERS</p>
 * <p>deg - the degree vector; qsize - size of indistinguishable nodes; qlink - linked list for indistinguishable nodes; marker - the given set is given by those nodes with marker value set to 1. Those nodes with degree updated will have marker value set to 2.</p>
 * <p>WORKING PARAMETERS</p>
 * <p>rchset - the reachable set; ovrlp - temp vector to store the intersection of two reachable sets. </p>
 */
public";

%javamethodmodifiers put_byte(FILE *fp, int c) "
/**
 * rgr_write_bmp16 - write 16-color raster image in BMP file format .
 * <p>SYNOPSIS</p>
 * <p>#include \"glprgr.h\" int rgr_write_bmp16(const char *fname, int m, int n, const char map[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine rgr_write_bmp16 writes 16-color raster image in uncompressed BMP file format (Windows bitmap) to a binary file whose name is specified by the character string fname.</p>
 * <p>The parameters m and n specify, respectively, the number of rows and the numbers of columns (i.e. height and width) of the raster image.</p>
 * <p>The character array map has m*n elements. Elements map[0, ..., n-1] correspond to the first (top) scanline, elements map[n, ..., 2*n-1] correspond to the second scanline, etc.</p>
 * <p>Each element of the array map specifies a color of the corresponding pixel as 8-bit binary number XXXXIRGB, where four high-order bits (X) are ignored, I is high intensity bit, R is red color bit, G is green color bit, and B is blue color bit. Thus, all 16 possible colors are coded as following hexadecimal numbers:</p>
 * <p>0x00 = black 0x08 = dark gray 0x01 = blue 0x09 = bright blue 0x02 = green 0x0A = bright green 0x03 = cyan 0x0B = bright cyan 0x04 = red 0x0C = bright red 0x05 = magenta 0x0D = bright magenta 0x06 = brown 0x0E = yellow 0x07 = light gray 0x0F = white</p>
 * <p>RETURNS</p>
 * <p>If no error occured, the routine returns zero; otherwise, it prints an appropriate error message and returns non-zero. </p>
 */
public";

%javamethodmodifiers put_word(FILE *fp, int w) "
/**
 */
public";

%javamethodmodifiers put_dword(FILE *fp, int d) "
/**
 */
public";

%javamethodmodifiers rgr_write_bmp16(const char *fname, int m, int n, const char map[]) "
/**
 */
public";

%javamethodmodifiers rgr_write_bmp16(const char *fname, int m, int n, const char map[]) "
/**
 */
public";

%javamethodmodifiers ascnt1(struct relax4_csa *csa, int dm, int *delx, int *nlabel, int *feasbl, int *svitch, int nscan, int curnode, int *prevnode) "
/**
 * RELAX-IV (version of October 1994) .
 * <p>ascnt1 - multi-node price adjustment for positive deficit case</p>
 * <p>PURPOSE</p>
 * <p>This routine implements the relaxation method of Bertsekas and Tseng (see [1], [2]) for linear cost ordinary network flow problems.</p>
 * <p>[1] Bertsekas, D. P., \"A Unified Framework for Primal-Dual Methods\" Mathematical Programming, Vol. 32, 1985, pp. 125-145. [2] Bertsekas, D. P., and Tseng, P., \"Relaxation Methods for
      Minimum Cost\" Operations Research, Vol. 26, 1988, pp. 93-114.</p>
 * <p>The relaxation method is also described in the books:</p>
 * <p>[3] Bertsekas, D. P., \"Linear Network Optimization: Algorithms and
      Codes\" MIT Press, 1991. [4] Bertsekas, D. P. and Tsitsiklis, J. N., \"Parallel and Distributed
      Computation: Numerical Methods\", Prentice-Hall, 1989. [5] Bertsekas, D. P., \"Network Optimization: Continuous and Discrete
      Models\", Athena Scientific, 1998.</p>
 * <p>RELEASE NOTE</p>
 * <p>This version of relaxation code has option for a special crash procedure for the initial price-flow pair. This is recommended for difficult problems where the default initialization results in long running times. crash = 1 corresponds to an auction/shortest path method</p>
 * <p>These initializations are recommended in the absence of any prior information on a favorable initial flow-price vector pair that satisfies complementary slackness.</p>
 * <p>The relaxation portion of the code differs from the code RELAXT-III and other earlier relaxation codes in that it maintains the set of nodes with nonzero deficit in a fifo queue. Like its predecessor RELAXT-III, this code maintains a linked list of balanced (i.e., of zero reduced cost) arcs so to reduce the work in labeling and scanning. Unlike RELAXT-III, it does not use selectively shortest path iterations for initialization.</p>
 * <p>SOURCE</p>
 * <p>The original Fortran code was written by Dimitri P. Bertsekas and Paul Tseng, with a contribution by Jonathan Eckstein in the phase II initialization. The original Fortran routine AUCTION was written by Dimitri P. Bertsekas and is based on the method described in the paper:</p>
 * <p>[6] Bertsekas, D. P., \"An Auction/Sequential Shortest Path Algorithm
      for the Minimum Cost Flow Problem\", LIDS Report P-2146, MIT, Nov. 1992.</p>
 * <p>For inquiries about the original Fortran code, please contact:</p>
 * <p>Dimitri P. Bertsekas Laboratory for information and decision systems Massachusetts Institute of Technology Cambridge, MA 02139 (617) 253-7267, dimitrib@mit.edu</p>
 * <p>This code is the result of translation of the original Fortran code. The translation was made by Andrew Makhorin <mao@gnu.org>.</p>
 * <p>USER GUIDELINES</p>
 * <p>This routine is in the public domain to be used only for research purposes. It cannot be used as part of a commercial product, or to satisfy in any part commercial delivery requirements to government or industry, without prior agreement with the authors. Users are requested to acknowledge the authorship of the code, and the relaxation method.</p>
 * <p>No modification should be made to this code other than the minimal necessary to make it compatible with specific platforms.</p>
 * <p>INPUT PARAMETERS (see notes 1, 2, 4)</p>
 * <p>n = number of nodes na = number of arcs large = a very large integer to represent infinity (see note 3) repeat = true if initialization is to be skipped (false otherwise) crash = 0 if default initialization is used 1 if auction initialization is used startn[j] = starting node for arc j, j = 1,...,na endn[j] = ending node for arc j, j = 1,...,na fou[i] = first arc out of node i, i = 1,...,n nxtou[j] = next arc out of the starting node of arc j, j = 1,...,na fin[i] = first arc into node i, i = 1,...,n nxtin[j] = next arc into the ending node of arc j, j = 1,...,na</p>
 * <p>UPDATED PARAMETERS (see notes 1, 3, 4)</p>
 * <p>rc[j] = reduced cost of arc j, j = 1,...,na u[j] = capacity of arc j on input and (capacity of arc j) - x[j] on output, j = 1,...,na dfct[i] = demand at node i on input and zero on output, i = 1,...,n</p>
 * <p>OUTPUT PARAMETERS (see notes 1, 3, 4)</p>
 * <p>x[j] = flow on arc j, j = 1,...,na nmultinode = number of multinode relaxation iterations in RELAX4 iter = number of relaxation iterations in RELAX4 num_augm = number of flow augmentation steps in RELAX4 num_ascnt = number of multinode ascent steps in RELAX4 nsp = number of auction/shortest path iterations</p>
 * <p>WORKING PARAMETERS (see notes 1, 4, 5)</p>
 * <p>label[1+n], prdcsr[1+n], save[1+na], tfstou[1+n], tnxtou[1+na], tfstin[1+n], tnxtin[1+na], nxtqueue[1+n], scan[1+n], mark[1+n], extend_arc[1+n], sb_level[1+n], sb_arc[1+n]</p>
 * <p>RETURNS</p>
 * <p>0 = normal return 1,...,8 = problem is found to be infeasible</p>
 * <p>NOTE 1</p>
 * <p>To run in limited memory systems, declare the arrays startn, endn, nxtin, nxtou, fin, fou, label, prdcsr, save, tfstou, tnxtou, tfstin, tnxtin, ddpos, ddneg, nxtqueue as short instead.</p>
 * <p>NOTE 2</p>
 * <p>This routine makes no effort to initialize with a favorable x from amongst those flow vectors that satisfy complementary slackness with the initial reduced cost vector rc. If a favorable x is known, then it can be passed, together with the corresponding arrays u and dfct, to this routine directly. This, however, requires that the capacity tightening portion and the flow initialization portion of this routine (up to line labeled 90) be skipped.</p>
 * <p>NOTE 3</p>
 * <p>All problem data should be less than large in magnitude, and large should be less than, say, 1/4 the largest int of the machine used. This will guard primarily against overflow in uncapacitated problems where the arc capacities are taken finite but very large. Note, however, that as in all codes operating with integers, overflow may occur if some of the problem data takes very large values.</p>
 * <p>NOTE 4</p>
 * <p>[This note being specific to Fortran was removed.-A.M.]</p>
 * <p>NOTE 5</p>
 * <p>ddpos and ddneg are arrays that give the directional derivatives for all positive and negative single-node price changes. These are used only in phase II of the initialization procedure, before the linked list of balanced arcs comes to play. Therefore, to reduce storage, they are equivalence to tfstou and tfstin, which are of the same size (number of nodes) and are used only after the tree comes into use.</p>
 * <p>PURPOSE</p>
 * <p>This subroutine performs the multi-node price adjustment step for the case where the scanned nodes have positive deficit. It first checks if decreasing the price of the scanned nodes increases the dual cost. If yes, then it decreases the price of all scanned nodes. There are two possibilities for price decrease: if switch = true, then the set of scanned nodes corresponds to an elementary direction of maximal rate of ascent, in which case the price of all scanned nodes are decreased until the next breakpoint in the dual cost is encountered. At this point, some arc becomes balanced and more node(s) are added to the labeled set and the subroutine is exited. If switch = false, then the price of all scanned nodes are decreased until the rate of ascent becomes negative (this corresponds to the price adjustment step in which both the line search and the degenerate ascent iteration are implemented).</p>
 * <p>INPUT PARAMETERS</p>
 * <p>dm = total deficit of scanned nodes switch = true if labeling is to continue after price change nscan = number of scanned nodes curnode = most recently scanned node n = number of nodes na = number of arcs large = a very large integer to represent infinity (see note 3) startn[i] = starting node for the i-th arc, i = 1,...,na endn[i] = ending node for the i-th arc, i = 1,...,na fou[i] = first arc leaving i-th node, i = 1,...,n nxtou[i] = next arc leaving the starting node of j-th arc, i = 1,...,na fin[i] = first arc entering i-th node, i = 1,...,n nxtin[i] = next arc entering the ending node of j-th arc, i = 1,...,na</p>
 * <p>UPDATED PARAMETERS</p>
 * <p>delx = a lower estimate of the total flow on balanced arcs in the scanned-nodes cut nlabel = number of labeled nodes feasbl = false if problem is found to be infeasible prevnode = the node before curnode in queue rc[j] = reduced cost of arc j, j = 1,...,na u[j] = residual capacity of arc j, j = 1,...,na x[j] = flow on arc j, j = 1,...,na dfct[i] = deficit at node i, i = 1,...,n label[k] = k-th node labeled, k = 1,...,nlabel prdcsr[i] = predecessor of node i in tree of labeled nodes (0 if i is unlabeled), i = 1,...,n tfstou[i] = first balanced arc out of node i, i = 1,...,n tnxtou[j] = next balanced arc out of the starting node of arc j, j = 1,...,na tfstin[i] = first balanced arc into node i, i = 1,...,n tnxtin[j] = next balanced arc into the ending node of arc j, j = 1,...,na nxtqueue[i] = node following node i in the fifo queue (0 if node is not in the queue), i = 1,...,n scan[i] = true if node i is scanned, i = 1,...,n mark[i] = true if node i is labeled, i = 1,...,n</p>
 * <p>WORKING PARAMETERS</p>
 * <p>save[1+na] </p>
 */
public";

%javamethodmodifiers ascnt2(struct relax4_csa *csa, int dm, int *delx, int *nlabel, int *feasbl, int *svitch, int nscan, int curnode, int *prevnode) "
/**
 * ascnt2 - multi-node price adjustment for negative deficit case .
 * <p>PURPOSE</p>
 * <p>This routine is analogous to ascnt1 but for the case where the scanned nodes have negative deficit. </p>
 */
public";

%javamethodmodifiers auction(struct relax4_csa *csa) "
/**
 * auction - compute good initial flow and prices .
 * <p>PURPOSE</p>
 * <p>This subroutine uses a version of the auction algorithm for min cost network flow to compute a good initial flow and prices for the problem.</p>
 * <p>INPUT PARAMETERS</p>
 * <p>n = number of nodes na = number of arcs large = a very large integer to represent infinity (see note 3) startn[i] = starting node for the i-th arc, i = 1,...,na endn[i] = ending node for the i-th arc, i = 1,...,na fou[i] = first arc leaving i-th node, i = 1,...,n nxtou[i] = next arc leaving the starting node of j-th arc, i = 1,...,na fin[i] = first arc entering i-th node, i = 1,...,n nxtin[i] = next arc entering the ending node of j-th arc, i = 1,...,na</p>
 * <p>UPDATED PARAMETERS</p>
 * <p>rc[j] = reduced cost of arc j, j = 1,...,na u[j] = residual capacity of arc j, j = 1,...,na x[j] = flow on arc j, j = 1,...,na dfct[i] = deficit at node i, i = 1,...,n</p>
 * <p>OUTPUT PARAMETERS</p>
 * <p>nsp = number of auction/shortest path iterations</p>
 * <p>WORKING PARAMETERS</p>
 * <p>p[1+n], prdcsr[1+n], save[1+na], fpushf[1+n], nxtpushf[1+na], fpushb[1+n], nxtpushb[1+na], nxtqueue[1+n], extend_arc[1+n], sb_level[1+n], sb_arc[1+n], path_id[1+n]</p>
 * <p>RETURNS</p>
 * <p>0 = normal return 1 = problem is found to be infeasible </p>
 */
public";

%javamethodmodifiers relax4(struct relax4_csa *csa) "
/**
 */
public";

%javamethodmodifiers relax4_inidat(struct relax4_csa *csa) "
/**
 * relax4_inidat - construct linked lists for network topology .
 * <p>PURPOSE</p>
 * <p>This routine constructs two linked lists for the network topology: one list (given by fou, nxtou) for the outgoing arcs of nodes and one list (given by fin, nxtin) for the incoming arcs of nodes. These two lists are required by RELAX4.</p>
 * <p>INPUT PARAMETERS</p>
 * <p>n = number of nodes na = number of arcs startn[j] = starting node for arc j, j = 1,...,na endn[j] = ending node for arc j, j = 1,...,na</p>
 * <p>OUTPUT PARAMETERS</p>
 * <p>fou[i] = first arc out of node i, i = 1,...,n nxtou[j] = next arc out of the starting node of arc j, j = 1,...,na fin[i] = first arc into node i, i = 1,...,n nxtin[j] = next arc into the ending node of arc j, j = 1,...,na</p>
 * <p>WORKING PARAMETERS</p>
 * <p>tempin[1+n], tempou[1+n] </p>
 */
public";

%javamethodmodifiers relax4(struct relax4_csa *csa) "
/**
 */
public";

%javamethodmodifiers relax4_inidat(struct relax4_csa *csa) "
/**
 * relax4_inidat - construct linked lists for network topology .
 * <p>PURPOSE</p>
 * <p>This routine constructs two linked lists for the network topology: one list (given by fou, nxtou) for the outgoing arcs of nodes and one list (given by fin, nxtin) for the incoming arcs of nodes. These two lists are required by RELAX4.</p>
 * <p>INPUT PARAMETERS</p>
 * <p>n = number of nodes na = number of arcs startn[j] = starting node for arc j, j = 1,...,na endn[j] = ending node for arc j, j = 1,...,na</p>
 * <p>OUTPUT PARAMETERS</p>
 * <p>fou[i] = first arc out of node i, i = 1,...,n nxtou[j] = next arc out of the starting node of arc j, j = 1,...,na fin[i] = first arc into node i, i = 1,...,n nxtin[j] = next arc into the ending node of arc j, j = 1,...,na</p>
 * <p>WORKING PARAMETERS</p>
 * <p>tempin[1+n], tempou[1+n] </p>
 */
public";

%javamethodmodifiers rng_create_rand(void) "
/**
 * rng_create_rand - create pseudo-random number generator .
 * <p>SYNOPSIS</p>
 * <p>#include \"glprng.h\" RNG *rng_create_rand(void);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine rng_create_rand creates and initializes a pseudo-random number generator.</p>
 * <p>RETURNS</p>
 * <p>The routine returns a pointer to the generator created. </p>
 */
public";

%javamethodmodifiers rng_init_rand(RNG *rand, int seed) "
/**
 * rng_init_rand - initialize pseudo-random number generator .
 * <p>SYNOPSIS</p>
 * <p>#include \"glprng.h\" void rng_init_rand(RNG *rand, int seed);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine rng_init_rand initializes the pseudo-random number generator. The parameter seed may be any integer number. Note that on creating the generator this routine is called with the parameter seed equal to 1. </p>
 */
public";

%javamethodmodifiers rng_next_rand(RNG *rand) "
/**
 * rng_next_rand - obtain pseudo-random integer in the range [0, 2^31-1] .
 * <p>SYNOPSIS</p>
 * <p>#include \"glprng.h\" int rng_next_rand(RNG *rand);</p>
 * <p>RETURNS</p>
 * <p>The routine rng_next_rand returns a next pseudo-random integer which is uniformly distributed between 0 and 2^31-1, inclusive. The period length of the generated numbers is 2^85 - 2^30. The low order bits of the generated numbers are just as random as the high-order bits. </p>
 */
public";

%javamethodmodifiers rng_unif_rand(RNG *rand, int m) "
/**
 */
public";

%javamethodmodifiers rng_delete_rand(RNG *rand) "
/**
 * rng_delete_rand - delete pseudo-random number generator .
 * <p>SYNOPSIS</p>
 * <p>#include \"glprng.h\" void rng_delete_rand(RNG *rand);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine rng_delete_rand frees all the memory allocated to the specified pseudo-random number generator. </p>
 */
public";

%javamethodmodifiers rng_unif_01(RNG *rand) "
/**
 * rng_unif_01 - obtain pseudo-random number in the range [0, 1] .
 * <p>SYNOPSIS</p>
 * <p>#include \"glprng.h\" double rng_unif_01(RNG *rand);</p>
 * <p>RETURNS</p>
 * <p>The routine rng_unif_01 returns a next pseudo-random number which is uniformly distributed in the range [0, 1]. </p>
 */
public";

%javamethodmodifiers rng_uniform(RNG *rand, double a, double b) "
/**
 * rng_uniform - obtain pseudo-random number in the range [a, b] .
 * <p>SYNOPSIS</p>
 * <p>#include \"glprng.h\" double rng_uniform(RNG *rand, double a, double b);</p>
 * <p>RETURNS</p>
 * <p>The routine rng_uniform returns a next pseudo-random number which is uniformly distributed in the range [a, b]. </p>
 */
public";

%javamethodmodifiers flip_cycle(RNG *rand) "
/**
 */
public";

%javamethodmodifiers rng_create_rand(void) "
/**
 * rng_create_rand - create pseudo-random number generator .
 * <p>SYNOPSIS</p>
 * <p>#include \"glprng.h\" RNG *rng_create_rand(void);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine rng_create_rand creates and initializes a pseudo-random number generator.</p>
 * <p>RETURNS</p>
 * <p>The routine returns a pointer to the generator created. </p>
 */
public";

%javamethodmodifiers rng_init_rand(RNG *rand, int seed) "
/**
 * rng_init_rand - initialize pseudo-random number generator .
 * <p>SYNOPSIS</p>
 * <p>#include \"glprng.h\" void rng_init_rand(RNG *rand, int seed);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine rng_init_rand initializes the pseudo-random number generator. The parameter seed may be any integer number. Note that on creating the generator this routine is called with the parameter seed equal to 1. </p>
 */
public";

%javamethodmodifiers rng_next_rand(RNG *rand) "
/**
 * rng_next_rand - obtain pseudo-random integer in the range [0, 2^31-1] .
 * <p>SYNOPSIS</p>
 * <p>#include \"glprng.h\" int rng_next_rand(RNG *rand);</p>
 * <p>RETURNS</p>
 * <p>The routine rng_next_rand returns a next pseudo-random integer which is uniformly distributed between 0 and 2^31-1, inclusive. The period length of the generated numbers is 2^85 - 2^30. The low order bits of the generated numbers are just as random as the high-order bits. </p>
 */
public";

%javamethodmodifiers rng_unif_rand(RNG *rand, int m) "
/**
 */
public";

%javamethodmodifiers rng_delete_rand(RNG *rand) "
/**
 * rng_delete_rand - delete pseudo-random number generator .
 * <p>SYNOPSIS</p>
 * <p>#include \"glprng.h\" void rng_delete_rand(RNG *rand);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine rng_delete_rand frees all the memory allocated to the specified pseudo-random number generator. </p>
 */
public";

%javamethodmodifiers rng_unif_01(RNG *rand) "
/**
 * rng_unif_01 - obtain pseudo-random number in the range [0, 1] .
 * <p>SYNOPSIS</p>
 * <p>#include \"glprng.h\" double rng_unif_01(RNG *rand);</p>
 * <p>RETURNS</p>
 * <p>The routine rng_unif_01 returns a next pseudo-random number which is uniformly distributed in the range [0, 1]. </p>
 */
public";

%javamethodmodifiers rng_uniform(RNG *rand, double a, double b) "
/**
 * rng_uniform - obtain pseudo-random number in the range [a, b] .
 * <p>SYNOPSIS</p>
 * <p>#include \"glprng.h\" double rng_uniform(RNG *rand, double a, double b);</p>
 * <p>RETURNS</p>
 * <p>The routine rng_uniform returns a next pseudo-random number which is uniformly distributed in the range [a, b]. </p>
 */
public";

%javamethodmodifiers scf_create_it(int n_max) "
/**
 * scf_create_it - create Schur complement factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpscf.h\" SCF *scf_create_it(int n_max);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine scf_create_it creates the factorization of matrix C, which initially has no rows and columns.</p>
 * <p>The parameter n_max specifies the maximal order of matrix C to be factorized, 1 <= n_max <= 32767.</p>
 * <p>RETURNS</p>
 * <p>The routine scf_create_it returns a pointer to the structure SCF, which defines the factorization. </p>
 */
public";

%javamethodmodifiers f_loc(SCF *scf, int i, int j) "
/**
 */
public";

%javamethodmodifiers u_loc(SCF *scf, int i, int j) "
/**
 */
public";

%javamethodmodifiers bg_transform(SCF *scf, int k, double un[]) "
/**
 */
public";

%javamethodmodifiers givens(double a, double b, double *c, double *s) "
/**
 */
public";

%javamethodmodifiers gr_transform(SCF *scf, int k, double un[]) "
/**
 */
public";

%javamethodmodifiers transform(SCF *scf, int k, double un[]) "
/**
 */
public";

%javamethodmodifiers estimate_rank(SCF *scf) "
/**
 */
public";

%javamethodmodifiers scf_update_exp(SCF *scf, const double x[], const double y[], double z) "
/**
 * scf_update_exp - update factorization on expanding C .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpscf.h\" int scf_update_exp(SCF *scf, const double x[], const double y[], double z);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine scf_update_exp updates the factorization of matrix C on expanding it by adding a new row and column as follows:</p>
 * <p>( C x ) new C = ( ) ( y' z )</p>
 * <p>where x[1,...,n] is a new column, y[1,...,n] is a new row, and z is a new diagonal element.</p>
 * <p>If on entry the factorization is empty, the parameters x and y can be specified as NULL.</p>
 * <p>RETURNS</p>
 * <p>0 The factorization has been successfully updated.</p>
 * <p>SCF_ESING The factorization has been successfully updated, however, new matrix C is singular within working precision. Note that the new factorization remains valid.</p>
 * <p>SCF_ELIMIT There is not enough room to expand the factorization, because n = n_max. The factorization remains unchanged.</p>
 * <p>ALGORITHM</p>
 * <p>We can see that:</p>
 * <p>( F 0 ) ( C x ) ( FC Fx ) ( UP Fx ) ( ) ( ) = ( ) = ( ) = ( 0 1 ) ( y' z ) ( y' z ) ( y' z )</p>
 * <p>( U Fx ) ( P 0 ) = ( ) ( ), ( y'P' z ) ( 0 1 )</p>
 * <p>therefore to keep the main equality F * C = U * P we can take:</p>
 * <p>( F 0 ) ( U Fx ) ( P 0 ) new F = ( ), new U = ( ), new P = ( ), ( 0 1 ) ( y'P' z ) ( 0 1 )</p>
 * <p>and eliminate the row spike y'P' in the last row of new U to restore its upper triangular structure. </p>
 */
public";

%javamethodmodifiers solve(SCF *scf, double x[]) "
/**
 */
public";

%javamethodmodifiers tsolve(SCF *scf, double x[]) "
/**
 */
public";

%javamethodmodifiers scf_solve_it(SCF *scf, int tr, double x[]) "
/**
 * scf_solve_it - solve either system C * x = b or C' * x = b .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpscf.h\" void scf_solve_it(SCF *scf, int tr, double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine scf_solve_it solves either the system C * x = b (if tr is zero) or the system C' * x = b, where C' is a matrix transposed to C (if tr is non-zero). C is assumed to be non-singular.</p>
 * <p>On entry the array x should contain the right-hand side vector b in locations x[1], ..., x[n], where n is the order of matrix C. On exit the array x contains the solution vector x in the same locations. </p>
 */
public";

%javamethodmodifiers scf_reset_it(SCF *scf) "
/**
 */
public";

%javamethodmodifiers scf_delete_it(SCF *scf) "
/**
 * scf_delete_it - delete Schur complement factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpscf.h\" void scf_delete_it(SCF *scf);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine scf_delete_it deletes the specified factorization and frees all the memory allocated to this object. </p>
 */
public";

%javamethodmodifiers scf_create_it(int n_max) "
/**
 * scf_create_it - create Schur complement factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpscf.h\" SCF *scf_create_it(int n_max);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine scf_create_it creates the factorization of matrix C, which initially has no rows and columns.</p>
 * <p>The parameter n_max specifies the maximal order of matrix C to be factorized, 1 <= n_max <= 32767.</p>
 * <p>RETURNS</p>
 * <p>The routine scf_create_it returns a pointer to the structure SCF, which defines the factorization. </p>
 */
public";

%javamethodmodifiers scf_update_exp(SCF *scf, const double x[], const double y[], double z) "
/**
 * scf_update_exp - update factorization on expanding C .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpscf.h\" int scf_update_exp(SCF *scf, const double x[], const double y[], double z);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine scf_update_exp updates the factorization of matrix C on expanding it by adding a new row and column as follows:</p>
 * <p>( C x ) new C = ( ) ( y' z )</p>
 * <p>where x[1,...,n] is a new column, y[1,...,n] is a new row, and z is a new diagonal element.</p>
 * <p>If on entry the factorization is empty, the parameters x and y can be specified as NULL.</p>
 * <p>RETURNS</p>
 * <p>0 The factorization has been successfully updated.</p>
 * <p>SCF_ESING The factorization has been successfully updated, however, new matrix C is singular within working precision. Note that the new factorization remains valid.</p>
 * <p>SCF_ELIMIT There is not enough room to expand the factorization, because n = n_max. The factorization remains unchanged.</p>
 * <p>ALGORITHM</p>
 * <p>We can see that:</p>
 * <p>( F 0 ) ( C x ) ( FC Fx ) ( UP Fx ) ( ) ( ) = ( ) = ( ) = ( 0 1 ) ( y' z ) ( y' z ) ( y' z )</p>
 * <p>( U Fx ) ( P 0 ) = ( ) ( ), ( y'P' z ) ( 0 1 )</p>
 * <p>therefore to keep the main equality F * C = U * P we can take:</p>
 * <p>( F 0 ) ( U Fx ) ( P 0 ) new F = ( ), new U = ( ), new P = ( ), ( 0 1 ) ( y'P' z ) ( 0 1 )</p>
 * <p>and eliminate the row spike y'P' in the last row of new U to restore its upper triangular structure. </p>
 */
public";

%javamethodmodifiers scf_solve_it(SCF *scf, int tr, double x[]) "
/**
 * scf_solve_it - solve either system C * x = b or C' * x = b .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpscf.h\" void scf_solve_it(SCF *scf, int tr, double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine scf_solve_it solves either the system C * x = b (if tr is zero) or the system C' * x = b, where C' is a matrix transposed to C (if tr is non-zero). C is assumed to be non-singular.</p>
 * <p>On entry the array x should contain the right-hand side vector b in locations x[1], ..., x[n], where n is the order of matrix C. On exit the array x contains the solution vector x in the same locations. </p>
 */
public";

%javamethodmodifiers scf_reset_it(SCF *scf) "
/**
 */
public";

%javamethodmodifiers scf_delete_it(SCF *scf) "
/**
 * scf_delete_it - delete Schur complement factorization .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpscf.h\" void scf_delete_it(SCF *scf);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine scf_delete_it deletes the specified factorization and frees all the memory allocated to this object. </p>
 */
public";

%javamethodmodifiers min_row_aij(glp_prob *lp, int i, int scaled) "
/**
 */
public";

%javamethodmodifiers max_row_aij(glp_prob *lp, int i, int scaled) "
/**
 */
public";

%javamethodmodifiers min_col_aij(glp_prob *lp, int j, int scaled) "
/**
 */
public";

%javamethodmodifiers max_col_aij(glp_prob *lp, int j, int scaled) "
/**
 */
public";

%javamethodmodifiers min_mat_aij(glp_prob *lp, int scaled) "
/**
 */
public";

%javamethodmodifiers max_mat_aij(glp_prob *lp, int scaled) "
/**
 */
public";

%javamethodmodifiers eq_scaling(glp_prob *lp, int flag) "
/**
 */
public";

%javamethodmodifiers gm_scaling(glp_prob *lp, int flag) "
/**
 */
public";

%javamethodmodifiers max_row_ratio(glp_prob *lp) "
/**
 */
public";

%javamethodmodifiers max_col_ratio(glp_prob *lp) "
/**
 */
public";

%javamethodmodifiers gm_iterate(glp_prob *lp, int it_max, double tau) "
/**
 */
public";

%javamethodmodifiers scale_prob(glp_prob *lp, int flags) "
/**
 * scale_prob - scale problem data .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpscl.h\" void scale_prob(glp_prob *lp, int flags);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine scale_prob performs automatic scaling of problem data for the specified problem object. </p>
 */
public";

%javamethodmodifiers glp_scale_prob(glp_prob *lp, int flags) "
/**
 * glp_scale_prob - scale problem data .
 * <p>SYNOPSIS</p>
 * <p>void glp_scale_prob(glp_prob *lp, int flags);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_scale_prob performs automatic scaling of problem data for the specified problem object.</p>
 * <p>The parameter flags specifies scaling options used by the routine. Options can be combined with the bitwise OR operator and may be the following:</p>
 * <p>GLP_SF_GM perform geometric mean scaling; GLP_SF_EQ perform equilibration scaling; GLP_SF_2N round scale factors to nearest power of two; GLP_SF_SKIP skip scaling, if the problem is well scaled.</p>
 * <p>The parameter flags may be specified as GLP_SF_AUTO, in which case the routine chooses scaling options automatically. </p>
 */
public";

%javamethodmodifiers next_char(glp_data *data) "
/**
 */
public";

%javamethodmodifiers glp_sdf_open_file(const char *fname) "
/**
 */
public";

%javamethodmodifiers glp_sdf_set_jump(glp_data *data, void *jump) "
/**
 */
public";

%javamethodmodifiers glp_sdf_error(glp_data *data, const char *fmt,...) "
/**
 */
public";

%javamethodmodifiers glp_sdf_warning(glp_data *data, const char *fmt,...) "
/**
 */
public";

%javamethodmodifiers skip_pad(glp_data *data) "
/**
 */
public";

%javamethodmodifiers next_item(glp_data *data) "
/**
 */
public";

%javamethodmodifiers glp_sdf_read_int(glp_data *data) "
/**
 */
public";

%javamethodmodifiers glp_sdf_read_num(glp_data *data) "
/**
 */
public";

%javamethodmodifiers glp_sdf_read_item(glp_data *data) "
/**
 */
public";

%javamethodmodifiers glp_sdf_read_text(glp_data *data) "
/**
 */
public";

%javamethodmodifiers glp_sdf_line(glp_data *data) "
/**
 */
public";

%javamethodmodifiers glp_sdf_close_file(glp_data *data) "
/**
 */
public";

%javamethodmodifiers glp_sdf_open_file(const char *fname) "
/**
 */
public";

%javamethodmodifiers glp_sdf_set_jump(glp_data *data, void *jump) "
/**
 */
public";

%javamethodmodifiers glp_sdf_error(glp_data *data, const char *fmt,...) "
/**
 */
public";

%javamethodmodifiers glp_sdf_warning(glp_data *data, const char *fmt,...) "
/**
 */
public";

%javamethodmodifiers glp_sdf_read_int(glp_data *data) "
/**
 */
public";

%javamethodmodifiers glp_sdf_read_num(glp_data *data) "
/**
 */
public";

%javamethodmodifiers glp_sdf_read_item(glp_data *data) "
/**
 */
public";

%javamethodmodifiers glp_sdf_read_text(glp_data *data) "
/**
 */
public";

%javamethodmodifiers glp_sdf_line(glp_data *data) "
/**
 */
public";

%javamethodmodifiers glp_sdf_close_file(glp_data *data) "
/**
 */
public";

%javamethodmodifiers spm_create_mat(int m, int n) "
/**
 * spm_create_mat - create general sparse matrix .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpspm.h\" SPM *spm_create_mat(int m, int n);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine spm_create_mat creates a general sparse matrix having m rows and n columns. Being created the matrix is zero (empty), i.e. has no elements.</p>
 * <p>RETURNS</p>
 * <p>The routine returns a pointer to the matrix created. </p>
 */
public";

%javamethodmodifiers spm_new_elem(SPM *A, int i, int j, double val) "
/**
 * spm_new_elem - add new element to sparse matrix .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpspm.h\" SPME *spm_new_elem(SPM *A, int i, int j, double val);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine spm_new_elem adds a new element to the specified sparse matrix. Parameters i, j, and val specify the row number, the column number, and a numerical value of the element, respectively.</p>
 * <p>RETURNS</p>
 * <p>The routine returns a pointer to the new element added. </p>
 */
public";

%javamethodmodifiers spm_delete_mat(SPM *A) "
/**
 * spm_delete_mat - delete general sparse matrix .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpspm.h\" void spm_delete_mat(SPM *A);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine deletes the specified general sparse matrix freeing all the memory allocated to this object. </p>
 */
public";

%javamethodmodifiers spm_test_mat_e(int n, int c) "
/**
 * spm_test_mat_e - create test sparse matrix of E(n,c) class .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpspm.h\" SPM *spm_test_mat_e(int n, int c);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine spm_test_mat_e creates a test sparse matrix of E(n,c) class as described in the book: Ole 0sterby, Zahari Zlatev. Direct Methods for Sparse Matrices. Springer-Verlag, 1983.</p>
 * <p>Matrix of E(n,c) class is a symmetric positive definite matrix of the order n. It has the number 4 on its main diagonal and the number -1 on its four co-diagonals, two of which are neighbour to the main diagonal and two others are shifted from the main diagonal on the distance c.</p>
 * <p>It is necessary that n >= 3 and 2 <= c <= n-1.</p>
 * <p>RETURNS</p>
 * <p>The routine returns a pointer to the matrix created. </p>
 */
public";

%javamethodmodifiers spm_test_mat_d(int n, int c) "
/**
 * spm_test_mat_d - create test sparse matrix of D(n,c) class .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpspm.h\" SPM *spm_test_mat_d(int n, int c);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine spm_test_mat_d creates a test sparse matrix of D(n,c) class as described in the book: Ole 0sterby, Zahari Zlatev. Direct Methods for Sparse Matrices. Springer-Verlag, 1983.</p>
 * <p>Matrix of D(n,c) class is a non-singular matrix of the order n. It has unity main diagonal, three co-diagonals above the main diagonal on the distance c, which are cyclically continued below the main diagonal, and a triangle block of the size 10x10 in the upper right corner.</p>
 * <p>It is necessary that n >= 14 and 1 <= c <= n-13.</p>
 * <p>RETURNS</p>
 * <p>The routine returns a pointer to the matrix created. </p>
 */
public";

%javamethodmodifiers spm_show_mat(const SPM *A, const char *fname) "
/**
 * spm_show_mat - write sparse matrix pattern in BMP file format .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpspm.h\" int spm_show_mat(const SPM *A, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine spm_show_mat writes pattern of the specified sparse matrix in uncompressed BMP file format (Windows bitmap) to a binary file whose name is specified by the character string fname.</p>
 * <p>Each pixel corresponds to one matrix element. The pixel colors have the following meaning:</p>
 * <p>Black structurally zero element White positive element Cyan negative element Green zero element Red duplicate element</p>
 * <p>RETURNS</p>
 * <p>If no error occured, the routine returns zero. Otherwise, it prints an appropriate error message and returns non-zero. </p>
 */
public";

%javamethodmodifiers spm_read_hbm(const char *fname) "
/**
 * spm_read_hbm - read sparse matrix in Harwell-Boeing format .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpspm.h\" SPM *spm_read_hbm(const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine spm_read_hbm reads a sparse matrix in the Harwell-Boeing format from a text file whose name is the character string fname.</p>
 * <p>Detailed description of the Harwell-Boeing format recognised by this routine can be found in the following report:</p>
 * <p>I.S.Duff, R.G.Grimes, J.G.Lewis. User's Guide for the Harwell-Boeing Sparse Matrix Collection (Release I), TR/PA/92/86, October 1992.</p>
 * <p>NOTE</p>
 * <p>The routine spm_read_hbm reads the matrix \"as is\", due to which zero and/or duplicate elements can appear in the matrix.</p>
 * <p>RETURNS</p>
 * <p>If no error occured, the routine returns a pointer to the matrix created. Otherwise, the routine prints an appropriate error message and returns NULL. </p>
 */
public";

%javamethodmodifiers spm_count_nnz(const SPM *A) "
/**
 * spm_count_nnz - determine number of non-zeros in sparse matrix .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpspm.h\" int spm_count_nnz(const SPM *A);</p>
 * <p>RETURNS</p>
 * <p>The routine spm_count_nnz returns the number of structural non-zero elements in the specified sparse matrix. </p>
 */
public";

%javamethodmodifiers spm_drop_zeros(SPM *A, double eps) "
/**
 * spm_drop_zeros - remove zero elements from sparse matrix .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpspm.h\" int spm_drop_zeros(SPM *A, double eps);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine spm_drop_zeros removes all elements from the specified sparse matrix, whose absolute value is less than eps.</p>
 * <p>If the parameter eps is 0, only zero elements are removed from the matrix.</p>
 * <p>RETURNS</p>
 * <p>The routine returns the number of elements removed. </p>
 */
public";

%javamethodmodifiers spm_read_mat(const char *fname) "
/**
 * spm_read_mat - read sparse matrix from text file .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpspm.h\" SPM *spm_read_mat(const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine reads a sparse matrix from a text file whose name is specified by the parameter fname.</p>
 * <p>For the file format see description of the routine spm_write_mat.</p>
 * <p>RETURNS</p>
 * <p>On success the routine returns a pointer to the matrix created, otherwise NULL. </p>
 */
public";

%javamethodmodifiers spm_write_mat(const SPM *A, const char *fname) "
/**
 * spm_write_mat - write sparse matrix to text file .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpspm.h\" int spm_write_mat(const SPM *A, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine spm_write_mat writes the specified sparse matrix to a text file whose name is specified by the parameter fname. This file can be read back with the routine spm_read_mat.</p>
 * <p>RETURNS</p>
 * <p>On success the routine returns zero, otherwise non-zero.</p>
 * <p>FILE FORMAT</p>
 * <p>The file created by the routine spm_write_mat is a plain text file, which contains the following information:</p>
 * <p>m n nnz row[1] col[1] val[1] row[2] col[2] val[2] . . . row[nnz] col[nnz] val[nnz]</p>
 * <p>where: m is the number of rows; n is the number of columns; nnz is the number of non-zeros; row[k], k = 1,...,nnz, are row indices; col[k], k = 1,...,nnz, are column indices; val[k], k = 1,...,nnz, are element values. </p>
 */
public";

%javamethodmodifiers spm_transpose(const SPM *A) "
/**
 * spm_transpose - transpose sparse matrix .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpspm.h\" SPM *spm_transpose(const SPM *A);</p>
 * <p>RETURNS</p>
 * <p>The routine computes and returns sparse matrix B, which is a matrix transposed to sparse matrix A. </p>
 */
public";

%javamethodmodifiers spm_add_sym(const SPM *A, const SPM *B) "
/**
 */
public";

%javamethodmodifiers spm_add_num(SPM *C, double alfa, const SPM *A, double beta, const SPM *B) "
/**
 */
public";

%javamethodmodifiers spm_add_mat(double alfa, const SPM *A, double beta, const SPM *B) "
/**
 */
public";

%javamethodmodifiers spm_mul_sym(const SPM *A, const SPM *B) "
/**
 */
public";

%javamethodmodifiers spm_mul_num(SPM *C, const SPM *A, const SPM *B) "
/**
 */
public";

%javamethodmodifiers spm_mul_mat(const SPM *A, const SPM *B) "
/**
 */
public";

%javamethodmodifiers spm_create_per(int n) "
/**
 */
public";

%javamethodmodifiers spm_check_per(PER *P) "
/**
 */
public";

%javamethodmodifiers spm_delete_per(PER *P) "
/**
 */
public";

%javamethodmodifiers spm_create_mat(int m, int n) "
/**
 * spm_create_mat - create general sparse matrix .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpspm.h\" SPM *spm_create_mat(int m, int n);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine spm_create_mat creates a general sparse matrix having m rows and n columns. Being created the matrix is zero (empty), i.e. has no elements.</p>
 * <p>RETURNS</p>
 * <p>The routine returns a pointer to the matrix created. </p>
 */
public";

%javamethodmodifiers spm_new_elem(SPM *A, int i, int j, double val) "
/**
 * spm_new_elem - add new element to sparse matrix .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpspm.h\" SPME *spm_new_elem(SPM *A, int i, int j, double val);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine spm_new_elem adds a new element to the specified sparse matrix. Parameters i, j, and val specify the row number, the column number, and a numerical value of the element, respectively.</p>
 * <p>RETURNS</p>
 * <p>The routine returns a pointer to the new element added. </p>
 */
public";

%javamethodmodifiers spm_delete_mat(SPM *A) "
/**
 * spm_delete_mat - delete general sparse matrix .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpspm.h\" void spm_delete_mat(SPM *A);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine deletes the specified general sparse matrix freeing all the memory allocated to this object. </p>
 */
public";

%javamethodmodifiers spm_test_mat_e(int n, int c) "
/**
 * spm_test_mat_e - create test sparse matrix of E(n,c) class .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpspm.h\" SPM *spm_test_mat_e(int n, int c);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine spm_test_mat_e creates a test sparse matrix of E(n,c) class as described in the book: Ole 0sterby, Zahari Zlatev. Direct Methods for Sparse Matrices. Springer-Verlag, 1983.</p>
 * <p>Matrix of E(n,c) class is a symmetric positive definite matrix of the order n. It has the number 4 on its main diagonal and the number -1 on its four co-diagonals, two of which are neighbour to the main diagonal and two others are shifted from the main diagonal on the distance c.</p>
 * <p>It is necessary that n >= 3 and 2 <= c <= n-1.</p>
 * <p>RETURNS</p>
 * <p>The routine returns a pointer to the matrix created. </p>
 */
public";

%javamethodmodifiers spm_test_mat_d(int n, int c) "
/**
 * spm_test_mat_d - create test sparse matrix of D(n,c) class .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpspm.h\" SPM *spm_test_mat_d(int n, int c);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine spm_test_mat_d creates a test sparse matrix of D(n,c) class as described in the book: Ole 0sterby, Zahari Zlatev. Direct Methods for Sparse Matrices. Springer-Verlag, 1983.</p>
 * <p>Matrix of D(n,c) class is a non-singular matrix of the order n. It has unity main diagonal, three co-diagonals above the main diagonal on the distance c, which are cyclically continued below the main diagonal, and a triangle block of the size 10x10 in the upper right corner.</p>
 * <p>It is necessary that n >= 14 and 1 <= c <= n-13.</p>
 * <p>RETURNS</p>
 * <p>The routine returns a pointer to the matrix created. </p>
 */
public";

%javamethodmodifiers spm_show_mat(const SPM *A, const char *fname) "
/**
 * spm_show_mat - write sparse matrix pattern in BMP file format .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpspm.h\" int spm_show_mat(const SPM *A, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine spm_show_mat writes pattern of the specified sparse matrix in uncompressed BMP file format (Windows bitmap) to a binary file whose name is specified by the character string fname.</p>
 * <p>Each pixel corresponds to one matrix element. The pixel colors have the following meaning:</p>
 * <p>Black structurally zero element White positive element Cyan negative element Green zero element Red duplicate element</p>
 * <p>RETURNS</p>
 * <p>If no error occured, the routine returns zero. Otherwise, it prints an appropriate error message and returns non-zero. </p>
 */
public";

%javamethodmodifiers spm_read_hbm(const char *fname) "
/**
 * spm_read_hbm - read sparse matrix in Harwell-Boeing format .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpspm.h\" SPM *spm_read_hbm(const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine spm_read_hbm reads a sparse matrix in the Harwell-Boeing format from a text file whose name is the character string fname.</p>
 * <p>Detailed description of the Harwell-Boeing format recognised by this routine can be found in the following report:</p>
 * <p>I.S.Duff, R.G.Grimes, J.G.Lewis. User's Guide for the Harwell-Boeing Sparse Matrix Collection (Release I), TR/PA/92/86, October 1992.</p>
 * <p>NOTE</p>
 * <p>The routine spm_read_hbm reads the matrix \"as is\", due to which zero and/or duplicate elements can appear in the matrix.</p>
 * <p>RETURNS</p>
 * <p>If no error occured, the routine returns a pointer to the matrix created. Otherwise, the routine prints an appropriate error message and returns NULL. </p>
 */
public";

%javamethodmodifiers spm_count_nnz(const SPM *A) "
/**
 * spm_count_nnz - determine number of non-zeros in sparse matrix .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpspm.h\" int spm_count_nnz(const SPM *A);</p>
 * <p>RETURNS</p>
 * <p>The routine spm_count_nnz returns the number of structural non-zero elements in the specified sparse matrix. </p>
 */
public";

%javamethodmodifiers spm_drop_zeros(SPM *A, double eps) "
/**
 * spm_drop_zeros - remove zero elements from sparse matrix .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpspm.h\" int spm_drop_zeros(SPM *A, double eps);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine spm_drop_zeros removes all elements from the specified sparse matrix, whose absolute value is less than eps.</p>
 * <p>If the parameter eps is 0, only zero elements are removed from the matrix.</p>
 * <p>RETURNS</p>
 * <p>The routine returns the number of elements removed. </p>
 */
public";

%javamethodmodifiers spm_read_mat(const char *fname) "
/**
 * spm_read_mat - read sparse matrix from text file .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpspm.h\" SPM *spm_read_mat(const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine reads a sparse matrix from a text file whose name is specified by the parameter fname.</p>
 * <p>For the file format see description of the routine spm_write_mat.</p>
 * <p>RETURNS</p>
 * <p>On success the routine returns a pointer to the matrix created, otherwise NULL. </p>
 */
public";

%javamethodmodifiers spm_write_mat(const SPM *A, const char *fname) "
/**
 * spm_write_mat - write sparse matrix to text file .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpspm.h\" int spm_write_mat(const SPM *A, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine spm_write_mat writes the specified sparse matrix to a text file whose name is specified by the parameter fname. This file can be read back with the routine spm_read_mat.</p>
 * <p>RETURNS</p>
 * <p>On success the routine returns zero, otherwise non-zero.</p>
 * <p>FILE FORMAT</p>
 * <p>The file created by the routine spm_write_mat is a plain text file, which contains the following information:</p>
 * <p>m n nnz row[1] col[1] val[1] row[2] col[2] val[2] . . . row[nnz] col[nnz] val[nnz]</p>
 * <p>where: m is the number of rows; n is the number of columns; nnz is the number of non-zeros; row[k], k = 1,...,nnz, are row indices; col[k], k = 1,...,nnz, are column indices; val[k], k = 1,...,nnz, are element values. </p>
 */
public";

%javamethodmodifiers spm_transpose(const SPM *A) "
/**
 * spm_transpose - transpose sparse matrix .
 * <p>SYNOPSIS</p>
 * <p>#include \"glpspm.h\" SPM *spm_transpose(const SPM *A);</p>
 * <p>RETURNS</p>
 * <p>The routine computes and returns sparse matrix B, which is a matrix transposed to sparse matrix A. </p>
 */
public";

%javamethodmodifiers spm_add_sym(const SPM *A, const SPM *B) "
/**
 */
public";

%javamethodmodifiers spm_add_num(SPM *C, double alfa, const SPM *A, double beta, const SPM *B) "
/**
 */
public";

%javamethodmodifiers spm_add_mat(double alfa, const SPM *A, double beta, const SPM *B) "
/**
 */
public";

%javamethodmodifiers spm_mul_sym(const SPM *A, const SPM *B) "
/**
 */
public";

%javamethodmodifiers spm_mul_num(SPM *C, const SPM *A, const SPM *B) "
/**
 */
public";

%javamethodmodifiers spm_mul_mat(const SPM *A, const SPM *B) "
/**
 */
public";

%javamethodmodifiers spm_create_per(int n) "
/**
 */
public";

%javamethodmodifiers spm_check_per(PER *P) "
/**
 */
public";

%javamethodmodifiers spm_delete_per(PER *P) "
/**
 */
public";

%javamethodmodifiers spx_primal(glp_prob *lp, const glp_smcp *parm) "
/**
 */
public";

%javamethodmodifiers spx_dual(glp_prob *lp, const glp_smcp *parm) "
/**
 */
public";

%javamethodmodifiers alloc_csa(glp_prob *lp) "
/**
 */
public";

%javamethodmodifiers alloc_N(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers build_N(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers init_csa(struct csa *csa, glp_prob *lp) "
/**
 */
public";

%javamethodmodifiers inv_col(void *info, int i, int ind[], double val[]) "
/**
 */
public";

%javamethodmodifiers invert_B(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers update_B(struct csa *csa, int i, int k) "
/**
 */
public";

%javamethodmodifiers error_ftran(struct csa *csa, double h[], double x[], double r[]) "
/**
 */
public";

%javamethodmodifiers refine_ftran(struct csa *csa, double h[], double x[]) "
/**
 */
public";

%javamethodmodifiers error_btran(struct csa *csa, double h[], double x[], double r[]) "
/**
 */
public";

%javamethodmodifiers refine_btran(struct csa *csa, double h[], double x[]) "
/**
 */
public";

%javamethodmodifiers add_N_col(struct csa *csa, int j, int k) "
/**
 */
public";

%javamethodmodifiers del_N_col(struct csa *csa, int j, int k) "
/**
 */
public";

%javamethodmodifiers get_xN(struct csa *csa, int j) "
/**
 */
public";

%javamethodmodifiers eval_beta(struct csa *csa, double beta[]) "
/**
 */
public";

%javamethodmodifiers eval_pi(struct csa *csa, double pi[]) "
/**
 */
public";

%javamethodmodifiers eval_cost(struct csa *csa, double pi[], int j) "
/**
 */
public";

%javamethodmodifiers eval_bbar(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers eval_cbar(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers reset_refsp(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers eval_gamma(struct csa *csa, int j) "
/**
 */
public";

%javamethodmodifiers chuzc(struct csa *csa, double tol_dj) "
/**
 */
public";

%javamethodmodifiers eval_tcol(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers refine_tcol(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers sort_tcol(struct csa *csa, double tol_piv) "
/**
 */
public";

%javamethodmodifiers chuzr(struct csa *csa, double rtol) "
/**
 */
public";

%javamethodmodifiers eval_rho(struct csa *csa, double rho[]) "
/**
 */
public";

%javamethodmodifiers refine_rho(struct csa *csa, double rho[]) "
/**
 */
public";

%javamethodmodifiers eval_trow(struct csa *csa, double rho[]) "
/**
 */
public";

%javamethodmodifiers update_bbar(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers reeval_cost(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers update_cbar(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers update_gamma(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers err_in_bbar(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers err_in_cbar(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers err_in_gamma(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers change_basis(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers set_aux_obj(struct csa *csa, double tol_bnd) "
/**
 */
public";

%javamethodmodifiers set_orig_obj(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers check_stab(struct csa *csa, double tol_bnd) "
/**
 */
public";

%javamethodmodifiers check_feas(struct csa *csa, double tol_bnd) "
/**
 */
public";

%javamethodmodifiers eval_obj(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers display(struct csa *csa, const glp_smcp *parm, int spec) "
/**
 */
public";

%javamethodmodifiers store_sol(struct csa *csa, glp_prob *lp, int p_stat, int d_stat, int ray) "
/**
 */
public";

%javamethodmodifiers free_csa(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers spx_primal(glp_prob *lp, const glp_smcp *parm) "
/**
 */
public";

%javamethodmodifiers alloc_csa(glp_prob *lp) "
/**
 */
public";

%javamethodmodifiers init_csa(struct csa *csa, glp_prob *lp) "
/**
 */
public";

%javamethodmodifiers inv_col(void *info, int i, int ind[], double val[]) "
/**
 */
public";

%javamethodmodifiers invert_B(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers update_B(struct csa *csa, int i, int k) "
/**
 */
public";

%javamethodmodifiers error_ftran(struct csa *csa, double h[], double x[], double r[]) "
/**
 */
public";

%javamethodmodifiers refine_ftran(struct csa *csa, double h[], double x[]) "
/**
 */
public";

%javamethodmodifiers error_btran(struct csa *csa, double h[], double x[], double r[]) "
/**
 */
public";

%javamethodmodifiers refine_btran(struct csa *csa, double h[], double x[]) "
/**
 */
public";

%javamethodmodifiers get_xN(struct csa *csa, int j) "
/**
 */
public";

%javamethodmodifiers eval_beta(struct csa *csa, double beta[]) "
/**
 */
public";

%javamethodmodifiers eval_pi(struct csa *csa, double pi[]) "
/**
 */
public";

%javamethodmodifiers eval_cost(struct csa *csa, double pi[], int j) "
/**
 */
public";

%javamethodmodifiers eval_bbar(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers eval_cbar(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers reset_refsp(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers eval_gamma(struct csa *csa, double gamma[]) "
/**
 */
public";

%javamethodmodifiers chuzr(struct csa *csa, double tol_bnd) "
/**
 */
public";

%javamethodmodifiers eval_rho(struct csa *csa, double rho[]) "
/**
 */
public";

%javamethodmodifiers refine_rho(struct csa *csa, double rho[]) "
/**
 */
public";

%javamethodmodifiers eval_trow1(struct csa *csa, double rho[]) "
/**
 */
public";

%javamethodmodifiers eval_trow2(struct csa *csa, double rho[]) "
/**
 */
public";

%javamethodmodifiers eval_trow(struct csa *csa, double rho[]) "
/**
 */
public";

%javamethodmodifiers sort_trow(struct csa *csa, double tol_piv) "
/**
 */
public";

%javamethodmodifiers chuzc(struct csa *csa, double rtol) "
/**
 */
public";

%javamethodmodifiers eval_tcol(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers refine_tcol(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers update_cbar(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers update_bbar(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers update_gamma(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers err_in_bbar(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers err_in_cbar(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers err_in_gamma(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers change_basis(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers check_feas(struct csa *csa, double tol_dj) "
/**
 */
public";

%javamethodmodifiers set_aux_bnds(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers set_orig_bnds(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers check_stab(struct csa *csa, double tol_dj) "
/**
 */
public";

%javamethodmodifiers eval_obj(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers display(struct csa *csa, const glp_smcp *parm, int spec) "
/**
 */
public";

%javamethodmodifiers store_sol(struct csa *csa, glp_prob *lp, int p_stat, int d_stat, int ray) "
/**
 */
public";

%javamethodmodifiers free_csa(struct csa *csa) "
/**
 */
public";

%javamethodmodifiers spx_dual(glp_prob *lp, const glp_smcp *parm) "
/**
 */
public";

%javamethodmodifiers db_iodbc_open_int(TABDCA *dca, int mode, const char **sqllines) "
/**
 */
public";

%javamethodmodifiers db_mysql_open_int(TABDCA *dca, int mode, const char **sqllines) "
/**
 */
public";

%javamethodmodifiers db_iodbc_open(TABDCA *dca, int mode) "
/**
 */
public";

%javamethodmodifiers db_iodbc_read(TABDCA *dca, void *link) "
/**
 */
public";

%javamethodmodifiers db_iodbc_write(TABDCA *dca, void *link) "
/**
 */
public";

%javamethodmodifiers db_iodbc_close(TABDCA *dca, void *link) "
/**
 */
public";

%javamethodmodifiers db_mysql_open(TABDCA *dca, int mode) "
/**
 */
public";

%javamethodmodifiers db_mysql_read(TABDCA *dca, void *link) "
/**
 */
public";

%javamethodmodifiers db_mysql_write(TABDCA *dca, void *link) "
/**
 */
public";

%javamethodmodifiers db_mysql_close(TABDCA *dca, void *link) "
/**
 */
public";

%javamethodmodifiers db_iodbc_open(TABDCA *dca, int mode) "
/**
 */
public";

%javamethodmodifiers db_iodbc_read(TABDCA *dca, void *link) "
/**
 */
public";

%javamethodmodifiers db_iodbc_write(TABDCA *dca, void *link) "
/**
 */
public";

%javamethodmodifiers db_iodbc_close(TABDCA *dca, void *link) "
/**
 */
public";

%javamethodmodifiers db_mysql_open(TABDCA *dca, int mode) "
/**
 */
public";

%javamethodmodifiers db_mysql_read(TABDCA *dca, void *link) "
/**
 */
public";

%javamethodmodifiers db_mysql_write(TABDCA *dca, void *link) "
/**
 */
public";

%javamethodmodifiers db_mysql_close(TABDCA *dca, void *link) "
/**
 */
public";

%javamethodmodifiers ssx_create(int m, int n, int nnz) "
/**
 */
public";

%javamethodmodifiers ssx_factorize(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_get_xNj(SSX *ssx, int j, mpq_t x) "
/**
 */
public";

%javamethodmodifiers ssx_eval_bbar(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_eval_pi(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_eval_dj(SSX *ssx, int j, mpq_t dj) "
/**
 */
public";

%javamethodmodifiers ssx_eval_cbar(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_eval_rho(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_eval_row(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_eval_col(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_chuzc(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_chuzr(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_update_bbar(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_update_pi(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_update_cbar(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_change_basis(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_delete(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_phase_I(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_phase_II(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_driver(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_create(int m, int n, int nnz) "
/**
 */
public";

%javamethodmodifiers basis_col(void *info, int j, int ind[], mpq_t val[]) "
/**
 */
public";

%javamethodmodifiers ssx_factorize(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_get_xNj(SSX *ssx, int j, mpq_t x) "
/**
 */
public";

%javamethodmodifiers ssx_eval_bbar(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_eval_pi(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_eval_dj(SSX *ssx, int j, mpq_t dj) "
/**
 */
public";

%javamethodmodifiers ssx_eval_cbar(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_eval_rho(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_eval_row(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_eval_col(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_chuzc(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_chuzr(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_update_bbar(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_update_pi(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_update_cbar(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_change_basis(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_delete(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers show_progress(SSX *ssx, int phase) "
/**
 */
public";

%javamethodmodifiers ssx_phase_I(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_phase_II(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers ssx_driver(SSX *ssx) "
/**
 */
public";

%javamethodmodifiers get_char(struct dsa *dsa) "
/**
 */
public";

%javamethodmodifiers skip_spaces(struct dsa *dsa, int across) "
/**
 */
public";

%javamethodmodifiers scan_keyword(struct dsa *dsa) "
/**
 */
public";

%javamethodmodifiers check_colon(struct dsa *dsa) "
/**
 */
public";

%javamethodmodifiers scan_token(struct dsa *dsa, int across) "
/**
 */
public";

%javamethodmodifiers check_newline(struct dsa *dsa) "
/**
 */
public";

%javamethodmodifiers scan_comment(struct dsa *dsa) "
/**
 */
public";

%javamethodmodifiers scan_integer(struct dsa *dsa, int across, int *val) "
/**
 */
public";

%javamethodmodifiers scan_number(struct dsa *dsa, int across, double *val) "
/**
 */
public";

%javamethodmodifiers tsp_read_data(char *fname) "
/**
 */
public";

%javamethodmodifiers tsp_free_data(TSP *tsp) "
/**
 */
public";

%javamethodmodifiers rad(double x) "
/**
 */
public";

%javamethodmodifiers tsp_distance(TSP *tsp, int i, int j) "
/**
 */
public";

%javamethodmodifiers tsp_read_data(char *fname) "
/**
 */
public";

%javamethodmodifiers tsp_free_data(TSP *tsp) "
/**
 */
public";

%javamethodmodifiers tsp_distance(TSP *tsp, int i, int j) "
/**
 */
public";
