#############################################################################
##  
#W  fibo.g                 GAP4 Package `FactInt'                 Stefan Kohl
##
##  This file contains a database of factors of Fibonacci numbers.
##
#############################################################################

MakeReadWriteGlobal( "FACTORS_FIB" );
FACTORS_FIB :=
[ 1003666289, 1016307041, 1043766587, 1097233061, 1109581873, 1174427453,
  1240154177, 1258740001, 1270083883, 1297027681, 1353439001, 1360418597,
  1368322369, 1435522969, 1454976293, 1493656753, 1550853481, 1647000181,
  1655770201, 1769526527, 1784390549, 1808388451, 1828620361, 1837202669,
  1932300241, 1952755969, 2009966099, 2114537501, 2117130049, 2191174861,
  2214453361, 2607553541, 2668186121, 2710260697, 2854472449, 2856113921,
  2864461601, 2901110281, 2954909161, 2971215073, 3080261369, 3163171441,
  3164852861, 3306742181, 3318023281, 3331306969, 3336915203, 3354287957,
  3383288581, 3415914041, 3465148147, 3473266369, 3516376261, 3537386857,
  3547078721, 3599504551, 3619658657, 3821263937, 3955824601, 4057630561,
  4322114369, 4333249681, 4353947431, 4360974949, 4381535761, 4692901883,
  4716437207, 4717331869, 5049205307, 5216440441, 5301729413, 5639710969,
  5644065667, 5648966761, 5688689453, 5738108801, 5883010433, 5974828049,
  6135922241, 6202401259, 6320315821, 6387083201, 6567762529, 6643838879,
  6870470209, 6911530261, 6918474869, 7005329677, 7038398989, 7096612381,
  7116439969, 7188487771, 7378607647, 7820838901, 7872253927, 7998082133,
  8288823481, 8303168327, 8310112721, 8336942267, 8411395441, 8541593161,
  8663131853, 9022425301, 9157663121, 9237507401, 9263072321, 9320165401,
  9465278929, 9602982001, 9858431581, 10069148777, 10424083697, 10543705069,
  10694421739, 10745088481, 10749957121, 10783342081, 11166702227,
  11899937029, 12280217041, 12317523121, 12340209383, 12361187009,
  12364910977, 12370533881, 12748437199, 13043111509, 13567893533,
  13631732633, 13837648441, 13953397457, 14279673833, 14629892449,
  14686239709, 14736206161, 15062006801, 15806979101, 16061684237,
  16856134241, 16923049609, 17387541121, 18104700793, 18546805133,
  19073614849, 19997474011, 20567460049, 20669776469, 21176476637,
  23143579913, 24994118449, 26024651929, 26030477521, 28143378001,
  29138888651, 31603395781, 31886344849, 32386142297, 33365519393,
  35537616083, 36768087721, 36836894821, 39589685693, 40281313801,
  41725948237, 41773163881, 42669355669, 43397676601, 44614641121,
  46165371073, 48175086409, 49114912141, 49721203549, 50187047747,
  54059112661, 54184296181, 54323672041, 54975368761, 55079759333,
  61182778621, 64343104471, 64390759997, 64474965673, 64690797641,
  66199696261, 66265118449, 67031206681, 70963651961, 72208475461,
  73327699969, 75350070457, 76984462699, 81143477963, 82061511001,
  83629033601, 84738793193, 90147673417, 92206663291, 92579793601,
  93251696081, 93750172283, 95305716283, 99979884881, 104264251753,
  104600155609, 106205194357, 108713769721, 113760088381, 114150315493,
  117169733521, 119218851371, 120196353941, 123643882069, 126192465881,
  129453018593, 132605449901, 139509555271, 148320002521, 151817708621,
  164154312001, 177962167367, 179068261321, 184715524801, 186812208641,
  193208122057, 196317700541, 200872171147, 201912469249, 203421415129,
  203572412497, 207753186701, 227150265697, 229602768949, 245329617161,
  245701220509, 252605941501, 310932648259, 316590102769, 316722762859,
  340399154629, 347502052673, 359239103599, 361575655741, 369282510197,
  386610981607, 399660629491, 404112157123, 404656773793, 409100738617,
  414988698461, 448607550257, 459807660691, 466269593837, 561434197549,
  562766385967, 585919814281, 593985111211, 598619413471, 642738983137,
  657727932781, 722601451307, 761882591401, 770857978613, 823837075741,
  849570487921, 960700389041, 972663078773, 1006118006507, 1027912163389,
  1051224514831, 1116312758369, 1156984541407, 1194215681621, 1196762644057,
  1250839826281, 1266715025281, 1270029990781, 1322154751061, 1369471729429,
  1371955936801, 1484249136401, 1517456267839, 1599014169601, 1608513413473,
  1639343785721, 1784714380021, 1795220677069, 1836084445651, 1844139855023,
  1870522178801, 1963812794309, 2043118036369, 2082966602729, 2139244501969,
  2152958650459, 2170732312961, 2192843129417, 2210448070697, 2424917505169,
  2476673936041, 2569733895941, 2576582465657, 2686039424221, 2705622682163,
  2741218753681, 2757586237369, 2915186157721, 3020733700601, 3345860598013,
  3467131047901, 3565818352751, 3827019260681, 3936504300121, 4014648883841,
  4311537234701, 4322424761927, 4531100550901, 4632894751907, 4791205378649,
  4828253906741, 4870723671313, 4953066392881, 5465167948001, 5477332620091,
  5600748293801, 6086461133983, 6274653314021, 6430515046741, 6641555895901,
  6782976947987, 6854280100961, 6857029027549, 6936488411701, 8346682124689,
  8771441328469, 9382599520669, 9506372193863, 10812055185331,
  11841524567731, 11862575248703, 11868899378561, 12933833823941,
  14821985227373, 15229266824729, 15342452091961, 15950033877233,
  16093097817593, 16594230150241, 16892304192301, 17075535700033,
  18736753266019, 20266379551129, 20778644396941, 20862774425341,
  21423730326721, 22221540969737, 22700849209613, 23230657239121,
  23725145626561, 23735900452321, 24848660119363, 25033626656641,
  25047390419633, 27932732439809, 28677143808961, 31840675992661,
  32529675488417, 32566223208133, 33128448586319, 33481417483721,
  33637840386809, 33816563175289, 37309023160481, 38482544680537,
  39488879317091, 40785018272633, 41510105455501, 42848407775681,
  43084912634851, 45688564527041, 48265838239823, 49649320649221,
  51073328790989, 52285211663261, 57157491464963, 59666387254501,
  61025309469041, 66163448516461, 66490765817401, 73254041816089,
  77894162661647, 80256319951861, 84388938382141, 85542646443577,
  85607646594577, 87129547172401, 89311781152481, 92180471494753,
  98102710780517, 101731310703289, 104446810724929, 111359800682371,
  118143291717707, 122887425153289, 124134848933957, 126213229732669,
  136888723981183, 140207234004601, 140229188484397, 141600090215093,
  143236388738249, 145150780364101, 163545836607653, 163674763583689,
  171246170261359, 174795553490801, 201062946718741, 201562805274601,
  203357221762049, 221903616003409, 235997096056853, 236235695207989,
  258422401920467, 263849805823819, 265272771839851, 303039789569567,
  311306833878041, 316799777709229, 320657355925861, 322458613167451,
  351301301942501, 359131890245101, 449187076348273, 468535826053501,
  474672373905841, 479836483312919, 480405122406661, 511715857773521,
  533975715909289, 582233977115909, 582416774750273, 594960058508093,
  596107814364089, 627655040817361, 628774904181521, 676934614737167,
  688846502588399, 689667151970161, 737066046375289, 758275080626801,
  761227665342913, 767056342442009, 818303948755277, 864351271995241,
  893844775132847, 940094299967491, 942072341591041, 952879788356681,
  1033043205255409, 1050474234583201, 1052645985555841, 1066737847220321,
  1076012367720403, 1076312899454363, 1077776264469061, 1078880662669127,
  1091346396980401, 1114769954367361, 1150184101339307, 1154149773784223,
  1205739181320733, 1254118270115351, 1408536153375781, 1459000305513721,
  1535414556003613, 1558450527658669, 1596164984379521, 1621212105820049,
  1665088321800481, 1866056170744477, 1983000765501001, 2107028233569599,
  2201228236641589, 2385377797192381, 2441129996120243, 2441738887963981,
  2494887570160189, 2498744410754149, 2517975182669813, 2535918135079561,
  2746348619173417, 2918000731816531, 3038624652573481, 3116523496881881,
  3126295447311401, 3198068921977967, 3231124141939501, 3278679706652741,
  3490125311294161, 3558039391073701, 3564873012035809, 3772191484024417,
  3943480033796491, 4000643765894231, 4035936389347157, 4173592724422721,
  4304994428485397, 4386848568249611, 4523819299182451, 4817807925924421,
  5257480026438961, 5303337419059397, 5307027867738937, 5449038756620509,
  5836312049326721, 6368731219987307, 6923104559934229, 6950680026641927,
  6982111964759801, 7288331127303673, 7901346123803597, 8097429243052573,
  8242065050061761, 8293976826829399, 8481116649425701, 8550224389674481,
  8920293496632083, 9207609261398081, 9208154892884357, 10341247759646081,
  10496059430146001, 10999042492449833, 11066449548850921, 11136890221406863,
  11456220552597241, 12441241017224321, 13052171822937661, 13373763765986881,
  14331800109223159, 16054441098650821, 17642247580301401, 17672296363133261,
  17970660075828673, 18253437603966181, 19531306748486501, 21373261504197751,
  22235502640988369, 22549039789436761, 23317837226040061, 24788343516808013,
  25008386631867389, 25770975208014221, 28770822474564239, 31498587119111339,
  32083440797931137, 32170944747810641, 32242356485644069, 32361122672259149,
  32845130922638389, 33758740830460183, 34260977417268029, 34482885205518361,
  42136290591640129, 42426476041450801, 46415343154434259, 47010552106184753,
  49098524855733491, 51793685214662401, 52601970578546783, 56678557502141579,
  59996854928656801, 61859474392640261, 63879037028000297, 65494688793368423,
  68520477202692467, 68541957733949701, 73872456598219381, 76566426675034441,
  78439756057054169, 80642113181244469, 85526722937689093, 94491842183551489,
  99194853094755497, 100049587197598387, 104712482697806353,
  105117617351706859, 110588112062920249, 111331562323253269,
  117838518633351469, 121200596585497061, 125090447782502159,
  137096217949680001, 145282738021003201, 148183743669565231,
  148950950810490737, 161336933569119611, 170301425972639233,
  173040421686336917, 173321310054541991, 197907695243868721,
  205151568022959109, 212309715915957817, 222448929009201481,
  248773766357061401, 271293387891105049, 290341026883813109,
  297787274080554953, 313195711516578281, 319702847642258783,
  324968740886536921, 347366417511089201, 393867451788289513,
  395586472506832921, 400892271029643691, 404275734463249277,
  417557731140104453, 458500259538957193, 572087591261946589,
  585802472031540853, 586281391556115841, 671040394220849329,
  717185107125886549, 753249714226730309, 754276330346432303,
  834428410879506721, 859886421593527043, 860882346042166879,
  881811033467161969, 886000936153274021, 900164950225760603,
  910257559954057439, 955921950316735037, 965840862268529759,
  1032512153239041931, 1143800237963593361, 1204966861388885141,
  1292528726309580481, 1303309310797189261, 1444159651716257659,
  1468997178779718281, 1528527683761524871, 1586361987756363049,
  1688091012426475049, 1999653272832963841, 2020608234013767329,
  2206456200865197103, 2228536579597318057, 2301751898421269953,
  2337127044022973021, 2350117027000544947, 2553105939466879921,
  2555795333678066429, 2992628320901882161, 3169251245945843761,
  3263039535803245519, 3446650156490167901, 3482304046527908383,
  3571442321831904937, 3717101226883686821, 3904919893017807509,
  4603546943052380929, 4959318126280687189, 5195875312324446209,
  5608873567304433409, 5687182485808243129, 5741461760879844361,
  5922309413062354009, 6279830532252706321, 7175323114950564593,
  7643696695096956649, 7654861102843433881, 7698999052751136773,
  8287296987284891561, 8302568897206778357, 8885812256785434407,
  9024686010889754273, 9456946117108451513, 9623520524969002343,
  9662360812131272153, 9906293406944653501, 10424204306491346737,
  11614654211954032961, 13095384194065076117, 13253086025993542387,
  13264519466034652481, 13343097459037867049, 14167898020159929481,
  15670596807846410359, 15970565008944994529, 16312246063516015073,
  17276792316211992881, 17505440236343865677, 20415253966247698801,
  23692245912756822601, 23812215284009787769, 28186756596622582369,
  30362561855982035333, 37202043349013064289, 40197222522537856361,
  40729012583008994401, 43583206934709081001, 44607276283528829839,
  49258624519847932639, 51016310064806842883, 52471477541626010209,
  66932254279484647441, 72376853400026778781, 73842573103586899487,
  76674415738994499773, 78982487870939058281, 80475423858449593021,
  81922033248592814089, 84817574770589638001, 86409516719752275209,
  88999250837499877681, 97389944419638836239, 101501176368069526561,
  115561578124838522881, 118021448662479038881, 127654132789883268521,
  138259218819774258197, 143860188296781167161, 158414167964045700001,
  159512939815855788121, 160124643088042710673, 160151348989164092909,
  162302467515721218821, 168579258383409659449, 169360439829648789853,
  186374563189054810201, 196392108054438935117, 196447231496394995461,
  217533000184835774779, 227993117754975870677, 272602401466814027129,
  328424797286984008609, 345802651979922515711, 365577168608254038823,
  372961972274566497161, 417739114281337726513, 441720958100381917103,
  461740953705414265853, 478061565712797524641, 579525284061453527209,
  587844315337792746053, 632890270126128456721, 845417665832830648601,
  919046182779201475951, 964537359154707797801, 964838287139321446051,
  1112118152741317993811, 1378497303338047612061, 1405898788412057400553,
  1627727616354246028751, 1686454671192230445929, 1781606650603740158969,
  1846858344247612322281, 1929584153756850496621, 1945042261468790758531,
  2170208701449020077201, 2224700455311857347241, 3160438834174817356001,
  3531495042124863863141, 3891324187650256896001, 4315428922959401898689,
  4698167634523379875583, 4724062413782674859069, 5260944339485659754393,
  5362483966272446452741, 5568053048227732210073, 5636517080386809396781,
  6254838942964147339957, 6556208367360005292317, 6643248296130757140737,
  8489567590713897905501, 9304861037267580847793, 10304159436663546012721,
  10635841025639256246541, 11351139025429989441413, 12369243068750242280033,
  12702695072081241539401, 14142131474028516189193, 14297347971975757800833,
  15360894609285281651561, 15634731455464012955341, 16000411124306403070561,
  16262153028670302865367, 17231203730201189308301, 19469944773409593857689,
  21585122600554804312561, 22054919149909719709751, 25013036253802426825129,
  27520930737677877058673, 28546908862296149233369, 32971978671645905645521,
  34201673799023762317333, 36448117857891321536401, 36595087477983000594301,
  40419554618353133555809, 44444142000883733457541, 46452589505548370052101,
  46724505421882309671121, 46878833122606699500317, 47831560297620361798553,
  49279722643391864192801, 49284706967787569058301, 56058952425321966662183,
  64455877349703042877309, 69437671937928401952347, 71770902070121337353161,
  72846749180048315217661, 85218882568302661649153, 90166509474958826619701,
  97415813466381445596089, 97420733208491869044199, 100213776846657651262073,
  112449868882584427122497, 114087288048701953998401,
  118972792942270488578429, 120570028745492370271501,
  123944171348849444948627, 133351074933356474419349,
  138787200818838488796281, 140997186409836049132841,
  142240444249423907190721, 142698186735199477821277,
  180501911066713425499001, 191590395963717030369913,
  198242280267590712702233, 200996663240698258054501,
  224189164930816106106049, 252171167457207277136719,
  275363930639344038915061, 300243025225039708236889,
  306211903657739796051001, 317351386961794678797301,
  349619996930737079890201, 389678749007629271532733,
  403876015898686909877891, 412670427844921037470771,
  470039965023902754923207, 585743430844669713563089,
  612606107755058997065597, 629221849462814156121301,
  647277670717998240943861, 689529693448123842995171,
  878132240443974874201601, 883364563627459323040861,
  1027729298220237292846693, 1045794092558661358680161,
  1273802627370318382097141, 1483547330343905886515273,
  1966344318693345608565721, 2126105960876701042477457,
  2442882935400038849127521, 2586982700656733994659533,
  2820928659522677780723681, 2959707364050967146316591,
  3150927827816930878141597, 3647646099535497480264359,
  3955434352527379623598597, 3961793656824010600647617,
  4701907222895068350249889, 5527278404454199535821801,
  5745394618509260782194541, 6110578634294886534808481,
  6563589514883537474323387, 6990555486997260704693177,
  6999457984986943862155037, 7376884504680981519248993,
  8239615882656632140266601, 9164259601748159235188401,
  10245029712795120034405043, 11209692506253906608469121,
  11260169813534893704769219, 11445418320446409915755717,
  11981661982050957053616001, 12020126510714734783009241,
  12026063840498208554568289, 12072125815683341020398173,
  12158771296959377863294133, 12615632641152025840707529,
  13344964190088977739771473, 13780495531127210356018421,
  14187954345303564388390001, 14227819087566557566797401,
  15822615815400320161700033, 16188856575286517818849171,
  17340889195212892399797173, 17455376699833697949206933,
  18626243184683463348283529, 20955481081478349560251309,
  23670698911880865758980387, 27752129035785622184033593,
  28163700810443011860841849, 32539100603113685024545201,
  35668796989484800666122809, 36302689192832119042589867,
  37125857850184727260788881, 41071004474575750019238941,
  42617146790676471298183229, 47381053174782191395897031,
  58351516230584163679868441, 62379555831803099867272961,
  64350963924373587143089997, 67712817361580804952011621,
  96049657917279874851369421, 103622818018019189912918429,
  105360626454788188427221121, 136299772702544437679660333,
  137060450839316821906173041, 137463485860772646805813637,
  156525289282548414081799081, 185790722054921374395775013,
  190792252302133997488884353, 196418919424255540016736161,
  201706252877348951248047497, 303428489268486159678418501,
  478330258123360554199869169, 504752765667203736366779801,
  505471005740691524853293621, 562627837283291940137654881,
  641466124349607697016238097, 658078658277725444483848541,
  662274006922117144633042051, 669652072271051271698436113,
  757810806256989128439975793, 817691446812956253389205301,
  918229218981115419161903071, 926918599457468125920827581,
  930507731557590226767593761, 935527893146187207403151261,
  954423225346040964978868549, 1066340417491710595814572169,
  1135879408779734256195614761, 1226244816494972899766403949,
  1230026721719313471360714649, 1269110035567349575500939169,
  1272978791049666311493991681, 1284145418062487805715353557,
  2430014747700999423017017501, 2811666624525811646469915877,
  2937020577790588869379344557, 2971841379558728500308112219,
  3418816640903898929534613769, 3608749221143171422606053857,
  3643684402534298380040912641, 4072353155773627601222196481,
  5050260704396247169315999021, 5500902230146438151405489047,
  5890430821204665088535469913, 6100804791163473872231629367,
  6711868167589546040730104281, 6927250173726731623520538349,
  8175789237238547574551461093, 10100521408792719066483062311,
  12347107561462371153028960441, 12812807672672518125975550387,
  12842054866056446184519361561, 13989786889408090766142164789,
  15930915578359831774855177129, 16372649304949588683920725489,
  19134702400093278081449423917, 26093837057017247269531221521,
  32359266836420052877591635109, 34040411535767969315747440867,
  39586709834808244008811690207, 43137227648024611864946839441,
  49515268247820822204156890633, 50354633016533380504238521909,
  52288798913069010095615928073, 57907365333787128886141126177,
  62717654313498903288590615641, 72195777446499975249912346541,
  90657498718024645326392940193, 115646893546501649858470926673,
  116199736637257550071295992177, 120074026624398979403194983601,
  123741394530748822691747768873, 125558304080295269277424839497,
  153037630649666194962091443041, 164344610046410138896156070813,
  192347474285460831200493920089, 217596464470297558206812683777,
  299961374372702604932397213521, 311680756181475991522861299701,
  329541040898736809891408309777, 361550655697011119582062819781,
  383151857826630341231355897481, 405200132445106923681094442501,
  516370563481195090455241876537, 529524906029701061263925953309,
  530974881763927371142458559129, 537771403239312279772324930133,
  573005680996120855900783871963, 619802607259514583330235693729,
  631484089583693149557829547141, 693082088640921294810854855809,
  824345650181758925250079965109, 873757179900549251563653697571,
  905674234408506526265097390431, 956734616715046328502480330601,
  1020930432032326933976826008497, 1090414335383168463561145167623,
  1370640253413013645946259484793, 1403981099723321029379913948641,
  1660205532813870854128220799877, 1699025090503783326202175396329,
  1702945513191305556907097618161, 2871307447985313921708888731089,
  2900839194578436063903816717541, 3041266742295771985148799223649,
  3219614693083858472025795467033, 3252336525249736694804553589211,
  3768695026320506495615952689771, 4558282384863830955384586674337,
  4754563243207008731371873914797, 4840420170661589510310078566401,
  5373430329122468821883671012169, 5677311686988237059841003204301,
  5690484979405478934633378760841, 6861121308187330908986328104917,
  6868615650726652471695323898169, 7114595835374122691553059173213,
  7623176943894417754223112508213, 9220407243723719942154317888399,
  10157807305963434099105034917037, 12055334654946982453464994276837,
  16247350756640617732192770750349, 27653866239836258463881623092961,
  28849565804292967113209415835001, 36036960414811969810787847118289,
  43561231976081277978655158673967, 55010483350408487052485570744297,
  55678135331080359350346681814561, 65790321679740490371744098034257,
  84932412915268787366637613595249, 106300393601859050294647534380697,
  111337025457586528883498206543931, 129082124355531285014369062302613,
  213814524649413574929383838148741, 255070411941335685950739745685341,
  275558088746628000175142150362049, 327556514659970602808808412671913,
  461260622582580115020470322214561, 542202788462733966380018208818089,
  1149884364774317448679684799063561, 1269485331398883566721960085614767,
  1316534463290847218590097513564513, 1342874889289644763267952824739273,
  1464508308408595529930658774839689, 1517416544639719175645264380247161,
  1980471595049441171403404227575101, 2684571411430027028247905903965201,
  2800076631444853778881663695403201, 3287487920278293408294269143124011,
  4677306043367904676926312147328153, 7146831801094929757704917464134401,
  7915192391491235383593622394399717, 9581560282865469527325716648943313,
  9609296992394725016206404165562861, 12895896944382093337795275602634469,
  15318508443810774614619603643486769, 24949586896499848287125235667356281,
  25013378664247449571576319242327981, 38074001361639245985686714500108609,
  78950326532490259440203791059070393, 82426652486556160280220461363904673,
  87426439096566323815478492553863521, 115247030905506311529891723062628161,
  128955073914024460192651484843195641, 135263838653434038307643992992133441,
  145656255274098473410432516973377097, 147544951420273127375119897163559661,
  163432894718897814320076670502885071, 168267467794789892931914095730854909,
  227693725298545340302283668318476481, 284813856967631789624651697663515149,
  319312180414074540857597288368326881, 334975899717478192174659260886338213,
  343447555562259627304842067279609489, 415596322649845773295720736044732151,
  479241609989095708599374537599903429, 482282203753826493012177501106954321,
  1226013535493914575737104535462481893, 1349538077674055461741903165711845661,
  1417608737626965887450074115382181513, 1589546141427272679433846364366380457,
  1629657085554814314951852158148550373, 3265459874889974301958128640187194421,
  4966336310413757728406317515606275329, 4967694409687530204298076715216528113,
  5280544535667472291277149119296546201, 7442061848971821413925946481657874173,
  7498125774422297927481142094102201027,
  8909495119748227149127799699351214961,
  9952648158500556841649035737455844289,
  11957954590103942275063852978039182929,
  15636705475517134545061743537722067281,
  17218960634655314412985745259631698569,
  20979159680268267283886770880010231337,
  21937080329465122026187124199656961913,
  22469617515216274972459349854327642081,
  28239740933183761240827618406950395621,
  33781171015631627701406786489962619501,
  40917977099577716278013687200836805493,
  43219877626484550971962471774087607599,
  43274370280887890687749341750584741809,
  46235392144586222367191440726672730987,
  57314120955051297736679165379998262001,
  73330281865487664068079924400662001093,
  79294907482525831172666228553046708561,
  111563103944402441480308843338387667157,
  188114752716182481542615469389235776029,
  216913841513988014390392583520681471857,
  389678426275593986752662955603693114561,
  436782169201002048261171378550055269633,
  471991644996070811213117005172115579281,
  474660128686813741388532659647585617001,
  553817264667751392439654980478140448429,
  675810521086017102935672879944220886181,
  775837786053758555549491982006941864421,
  1112015857652870954595728597416729648799,
  1286571476356214363857758285867974205241,
  1460156176130694384200777949474140539901,
  1694475987011060512114694432052112730581,
  1963007348390950600033407902951373073993,
  3001949101336686906107454320302466346629,
  3936305209623645367566417846428600876161,
  5257313110054756968734485223501326888597,
  5842883403557370083918319166129968648661,
  9828290803810117915463313327249992699417,
  47945418182865191902048401622798029135257,
  68629989962141678466136249619905115760161,
  73483350528661634941003491044929827858529,
  86595869789221068395014209191889362885201,
  108944170944009875978306751482234414702393,
  124817321931787434694203190366592770211101,
  142891866807558483828357498313185273935669,
  191782505151874799799825102831271417475449,
  344691953249605140842104770856490718942517,
  375349865274017290301682245798655940484521,
  430267212525867121951740619093594938058573,
  444111888848805843163235784298630863264881,
  472637968735705963164896157847752919263649,
  547497418496144666543167613835090178297001,
  553943420108693463296858467957051760512937,
  924503867289824805827159934087885660335843,
  1348763794031914156041797647143983548205749,
  1558583251423132840655438799726119705876273,
  5106898411595425599720553692369228331943057,
  5219534137983025159078847113619467285727377,
  12212660314113533056882499696953971296188553,
  12722327040132186089258010295231047801838093,
  24216191671442408226762026802756956706931169,
  43970815898058068152719337553779240208768201,
  104489406798697025053110107015655603906769001,
  104990418946773667410736999685208265866007631,
  214979797032908476941753114627650494795860641,
  264438702655226193752458581121055151414928921,
  392203219223925091091385298682949359657424601,
  511298853399838746094759953887580580459522069,
  698701157888711743873102798320227830873021729,
  1142059735200417842620494388293215303693455057,
  1549881004815549144203733902192126912788892869,
  2239725692573574774225418974731846140272212489,
  2419211530537373922717347917531835521445794561,
  9283622964639019423529121698442566463089390281,
  32663115224038289868650135217134309651239908119,
  75133866360271708828388764003377729428919569893,
  307203719010249860094186673433457816461942845097,
  666146992336447094037882680026427177876016818933,
  683277932680333429026251644060030270130798910137,
  726796986826035940911404502049392514854936553261,
  910446191230380691954806629890500182138844362909,
  1608704062671045700722861278055815879940511118453,
  2704719196143346692298887124435589105513805538379,
  5643662817995620380085434549192664838250428725429,
  10837399157311960843528910542685545748152881169441,
  27100744230763476331608468125704435058854674830597,
  27356464387475451826849237900258696206465693749957,
  44572961316701091570454843936327625650477556780221,
  49112877772690986784155213416124904587079758531091,
  118869391634972852522952098964476155238134997314729,
  127391874411097592672469891375644477141948573020237,
  198160071001853267796700692507490184570501064382201,
  633426720425379484021066748657186732303238835596889,
  767037979181178701644899756446547170152053117618949,
  1280819632152317623645492492119854765613719836542829,
  5535044652513405861762906574795495993731722658626641,
  7204338025090306465053435447585274989066236336317481,
  10751022445642353590215353302130394804164957484862897,
  11155343204218537406813313601234143763016570579820689,
  16858791493852006991125693680612934215433660323341561,
  26269420111435940130956773477854002520584945429174941,
  63806927452714047340778156846369278969435365966728521,
  180249374207654999655624116221570357240692774273973649,
  315091866755674886636171396413093944004085095910859077,
  591045866085042506389105054361881124597940603179391791,
  683947238399029925033711768294717540495219762245783337,
  1171266446222833267851409604104331211834067048447153001,
  1263395351795079479028868354070423429482680228613646293,
  1624464648249211515329083729905902386498198626045929519,
  2226344802649718015530074785595440148704264914900953857,
  3151242725437770750411540357262926352546654079835233941,
  9858624353001128920208414835866447607009753854238077581,
  10100069287571741938486523500812994394866300651332864937,
  14459470923426350620886866234819533010560061654086793457,
  177736127099922813767360469853533109979011440647545873549,
  325607314302580367352565581556109355606485506845606071549,
  402310645982760211964572510392536242545912271029816655397,
  813931896158525800515317682845549869035970880548027162481,
  834484880498372128537891307445941852925566419249911616229,
  2416423364226955152383303968756154137928463542120118369457,
  4526483582630502302599448017416286765824514198161691031041,
  6575550427909060965706137312528987434587252504405400632261,
  9314852044499095088136174224518688537294606645165137816589,
  21524172250942205268519976122584760101596353846237982087969,
  25418817756696318660935848828473885007681729473703240852141,
  31111499775948353141795434143457487913853238278585940539417,
  89824816176020664407957288521932489478482660934516789842973,
  136140803975431579096921434427867417119576043373923793863351,
  238926873365355594970898083475341039504072291847031600219301,
  241245732821994564754865847293001548284668180469528010576021,
  1687733481506255251903139456476245146806742007876216630876557,
  3065896180742949239692711943996471282190375231037084860437761,
  53865562038701008975397146407705442118820462326130285905669299,
  1966705880336020055150046708877493750619434827700658291236057029,
  4812597574939002689262045761968677700183085357523728584467570457,
  6723031508880710825207366434750325848261029572818998311648849981,
  22966686648632120276391228028485200841318497622533370591664502461,
  26872515696230594211399467081043889858122353633423500997472853513,
  25877751119622277066064295975031846490443388866966852062428892847729,
  35980201101257391549860360923563262525974949247991832187257385201689,
  415525449892925575793052927259336793621208218984261249761160849986781,
  57490131422237119538947323064108369354763411739839193426140731363438441,
  1337873301998533414875239339276051370134922822925229050035977065459942781,
  7989930331870878172694349568563967453474817377713504694454418890569410437,
  132104063592935792399089640664945066500367446060489058713719073024064583333,
  4869119598595521570242968281826869140185893064143426209281625066012493019513,
  242476693680113970844399844268665411909828940569848174382224682362558460739162851,
  337249668874543092270471370411907635658999967241919756476127700929950383177812840893093,
  857530162443103645092016365167333548053095312130794224202009189528601953890493642138861 ];
MakeReadOnlyGlobal( "FACTORS_FIB" );

#############################################################################
##
#E  fibo.g . . . . . . . . . . . . . . . . . . . . . . . . . . . .  ends here