/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog.search.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.TermQuery;
import thredds.ui.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.Field;
import ucar.util.prefs.ui.PrefPanel;

public class CatalogSearcher
extends JPanel {
    private static final String SOURCE_WINDOW_SIZE = "SourceWindowSize";
    private static final String STATUS_WINDOW_SIZE = "StatusWindowSize";
    private PreferencesExt prefs;
    private Component myParent;
    private PrefPanel queryPanel;
    private JSplitPane splitV;
    private TextHistoryPane resultTA;
    private boolean debugEvents = false;

    public CatalogSearcher(PreferencesExt prefs, Component parent) {
        this.prefs = prefs;
        this.myParent = parent;
        this.queryPanel = this.makeQueryInputPanel();
        this.resultTA = new TextHistoryPane(false);
        this.splitV = new JSplitPane(0, false, this.queryPanel, this.resultTA);
        this.splitV.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitV, "Center");
        JPanel buttPanel = new JPanel();
        this.add((Component)buttPanel, "South");
        this.queryPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CatalogSearcher.this.makeQuery();
            }
        });
    }

    public void save() {
        this.prefs.putInt("splitPos", this.splitV.getDividerLocation());
    }

    private void makeQuery() {
        this.resultTA.clear();
        Field.Text f = (Field.Text)this.queryPanel.getField("name");
        String nameValue = f.getText();
        this.resultTA.appendLine("Look for docs with name containing " + nameValue);
        try {
            IndexSearcher searcher = new IndexSearcher("index");
            StandardAnalyzer analyzer = new StandardAnalyzer();
            TermQuery query = new TermQuery(new Term("name", nameValue));
            Hits hits = searcher.search(query);
            this.resultTA.appendLine(" " + hits.length() + " total matching documents");
            for (int i = 0; i < hits.length(); ++i) {
                Document doc = hits.doc(i);
                this.showDoc(doc);
            }
            searcher.close();
        }
        catch (Exception e) {
            this.resultTA.appendLine("Lucene ERROR = " + e.getMessage());
        }
    }

    private void showDoc(Document doc) {
        this.resultTA.appendLine("Document:");
        Enumeration e = doc.fields();
        while (e.hasMoreElements()) {
            Field f = (Field)e.nextElement();
            this.resultTA.appendLine("   " + f.name() + " = " + f.stringValue());
        }
        this.resultTA.appendLine("");
    }

    private PrefPanel makeQueryInputPanel() {
        PreferencesExt prefNode = (PreferencesExt)this.prefs.node("queryInput");
        PrefPanel pp = new PrefPanel("Query", prefNode);
        int row = 0;
        pp.addHeading("Search on", row++);
        pp.addTextField("name", "name", "", 0, row++, null);
        pp.addTextField("keyword", "keyword", "", 0, row++, null);
        pp.addTextField("summary", "summary", "", 0, row++, null);
        pp.finish();
        return pp;
    }
}

