/* $Id: glue-gui-gtk-button.c,v 1.3 2009-08-24 16:34:36 sand Exp $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <string.h>

#include <gtk/gtk.h>

#include "glue-gui-gtk-button.h"

typedef struct {
	GtkButtonClass parent_class;

	void (*button_pressed) (GuiGtkButton *button);
	void (*button_released) (GuiGtkButton *button);
} GuiGtkButtonClass;

enum {
	BUTTON_PRESSED,
	BUTTON_RELEASED,
	GUI_GTK_BUTTON_LAST_SIGNAL
};

static guint gui_gtk_button_signals[GUI_GTK_BUTTON_LAST_SIGNAL] = { 0, 0 };

static void
gui_gtk_button_class_init(GuiGtkButtonClass *class)
{
	gui_gtk_button_signals[BUTTON_PRESSED] =
		g_signal_new("button-pressed",
			G_TYPE_FROM_CLASS(class),
			G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION, /* FIXME */
			G_STRUCT_OFFSET(GuiGtkButtonClass, button_pressed),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gui_gtk_button_signals[BUTTON_RELEASED] =
		g_signal_new("button-released",
			G_TYPE_FROM_CLASS(class),
			G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION, /* FIXME */
			G_STRUCT_OFFSET(GuiGtkButtonClass, button_released),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static gboolean
gui_gtk_button_press_event(GtkWidget *w, GdkEventButton *event, void *_button)
{
	GuiGtkButton *button = (GuiGtkButton *) _button;

	g_signal_emit(G_OBJECT(button),
			gui_gtk_button_signals[BUTTON_PRESSED], 0);

	return FALSE;
}

static gboolean
gui_gtk_button_release_event(GtkWidget *w, GdkEventButton *event, void *_button)
{
	GuiGtkButton *button = (GuiGtkButton *) _button;

	g_signal_emit(G_OBJECT(button),
			gui_gtk_button_signals[BUTTON_RELEASED], 0);

	return FALSE;
}

static void
gui_gtk_button_init(GuiGtkButton *button)
{
	g_signal_connect(G_OBJECT(button), "button-press-event",
			  G_CALLBACK(gui_gtk_button_press_event), button);
	g_signal_connect(G_OBJECT(button), "button-release-event",
			  G_CALLBACK(gui_gtk_button_release_event), button);
}

GType
gui_gtk_button_get_type(void)
{
	static GType ttt_type = 0;

	if (! ttt_type) {
		static const GTypeInfo ttt_info = {
			sizeof(GuiGtkButtonClass),
			NULL,	/* base_init */
			NULL,	/* base_finalize */
			(GClassInitFunc) gui_gtk_button_class_init,
			NULL,	/* class_finalize */
			NULL,	/* class_data */
			sizeof(GuiGtkButton),
			0,	/* n_preallocs */
			(GInstanceInitFunc) gui_gtk_button_init,
		};

		ttt_type = g_type_register_static (GTK_TYPE_BUTTON,
				"Button", &ttt_info, 0);
	}

	return ttt_type;
}

#define GUIGTKBUTTON_TYPE	gui_gtk_button_get_type()

GtkWidget *
gui_gtk_button_new(const char *desc)
{
	GtkWidget *button;
	GtkWidget *icon;

	button = GTK_WIDGET(g_object_new(GUIGTKBUTTON_TYPE, NULL));
	GTK_WIDGET_UNSET_FLAGS(button, GTK_CAN_FOCUS);

	gtk_button_set_label(GTK_BUTTON(button), desc);
	if (strcmp(desc, "Power") == 0) {
		icon = gtk_image_new_from_stock("gtk-yes",
				GTK_ICON_SIZE_BUTTON);
	} else if (strcmp(desc, "Reset") == 0) {
		icon = gtk_image_new_from_stock("gtk-refresh",
				GTK_ICON_SIZE_BUTTON);
	} else {
		icon = NULL;
	}
	if (icon) {
		gtk_button_set_image(GTK_BUTTON(button), icon);
	}

	return GTK_WIDGET(button);
}
