/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.AlignViewport;
import jalview.appletgui.AlignmentPanel;
import jalview.bin.JalviewLite;
import jalview.datamodel.SearchResults;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

public class Finder
extends Panel
implements ActionListener {
    AlignViewport av;
    AlignmentPanel ap;
    Frame frame;
    SearchResults searchResults;
    int seqIndex = 0;
    int resIndex = 0;
    Label jLabel1 = new Label();
    protected TextField textfield = new TextField();
    protected Button findAll = new Button();
    protected Button findNext = new Button();
    Panel jPanel1 = new Panel();
    GridLayout gridLayout1 = new GridLayout();
    protected Button createNewGroup = new Button();
    Checkbox caseSensitive = new Checkbox();

    public Finder(final AlignmentPanel ap) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.av = ap.av;
        this.ap = ap;
        this.frame = new Frame();
        this.frame.add(this);
        JalviewLite.addFrame(this.frame, "Find", 340, 120);
        this.frame.repaint();
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ap.highlightSearchResults(null);
            }
        });
        this.textfield.requestFocus();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.textfield) {
            this.doSearch(false);
        } else if (evt.getSource() == this.findNext) {
            this.doSearch(false);
        } else if (evt.getSource() == this.findAll) {
            this.resIndex = 0;
            this.seqIndex = 0;
            this.doSearch(true);
        } else if (evt.getSource() == this.createNewGroup) {
            this.createNewGroup_actionPerformed();
        }
    }

    public void createNewGroup_actionPerformed() {
        SequenceI[] seqs = new SequenceI[this.searchResults.getSize()];
        SequenceFeature[] features = new SequenceFeature[this.searchResults.getSize()];
        for (int i = 0; i < this.searchResults.getSize(); ++i) {
            seqs[i] = this.searchResults.getResultSequence(i);
            features[i] = new SequenceFeature(this.textfield.getText().trim(), "Search Results", null, this.searchResults.getResultStart(i), this.searchResults.getResultEnd(i), "Search Results");
        }
        if (this.ap.seqPanel.seqCanvas.getFeatureRenderer().amendFeatures(seqs, features, true, this.ap)) {
            this.ap.alignFrame.sequenceFeatures.setState(true);
            this.av.showSequenceFeatures(true);
            this.ap.highlightSearchResults(null);
        }
    }

    void doSearch(boolean findAll) {
        if (JalviewLite.currentAlignFrame != null) {
            this.ap = JalviewLite.currentAlignFrame.alignPanel;
            this.av = this.ap.av;
        }
        this.createNewGroup.setEnabled(false);
        jalview.analysis.Finder finder = new jalview.analysis.Finder(this.av.getAlignment(), this.av.getSelectionGroup(), this.seqIndex, this.resIndex);
        finder.setCaseSensitive(this.caseSensitive.getState());
        finder.setFindAll(findAll);
        String searchString = this.textfield.getText();
        finder.find(searchString);
        this.seqIndex = finder.getSeqIndex();
        this.resIndex = finder.getResIndex();
        this.searchResults = finder.getSearchResults();
        Vector idMatch = finder.getIdMatch();
        if (this.searchResults.getSize() == 0 && idMatch.size() > 0) {
            this.ap.idPanel.highlightSearchResults(idMatch);
        }
        if (this.searchResults.getSize() > 0) {
            this.createNewGroup.setEnabled(true);
        } else {
            this.searchResults = null;
            this.resIndex = 0;
            this.seqIndex = 0;
        }
        this.ap.highlightSearchResults(this.searchResults);
        if (findAll) {
            String message = (this.searchResults == null ? 0 : this.searchResults.getSize()) + " matches found.";
            this.ap.alignFrame.statusBar.setText("Search results: " + searchString + " : " + message);
        }
    }

    private void jbInit() throws Exception {
        this.jLabel1.setFont(new Font("Verdana", 0, 12));
        this.jLabel1.setText("Find");
        this.jLabel1.setBounds(new Rectangle(3, 30, 34, 15));
        this.setLayout(null);
        this.textfield.setFont(new Font("Verdana", 0, 10));
        this.textfield.setText("");
        this.textfield.setBounds(new Rectangle(40, 27, 133, 21));
        this.textfield.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                Finder.this.textfield_keyTyped(e);
            }
        });
        this.textfield.addActionListener(this);
        this.findAll.setFont(new Font("Verdana", 0, 10));
        this.findAll.setLabel("Find all");
        this.findAll.addActionListener(this);
        this.findNext.setEnabled(false);
        this.findNext.setFont(new Font("Verdana", 0, 10));
        this.findNext.setLabel("Find Next");
        this.findNext.addActionListener(this);
        this.jPanel1.setBounds(new Rectangle(180, 5, 141, 64));
        this.jPanel1.setLayout(this.gridLayout1);
        this.gridLayout1.setHgap(0);
        this.gridLayout1.setRows(3);
        this.gridLayout1.setVgap(2);
        this.createNewGroup.setEnabled(false);
        this.createNewGroup.setFont(new Font("Verdana", 0, 10));
        this.createNewGroup.setLabel("New Feature");
        this.createNewGroup.addActionListener(this);
        this.caseSensitive.setLabel("Match Case");
        this.caseSensitive.setBounds(new Rectangle(40, 49, 126, 23));
        this.jPanel1.add((Component)this.findNext, null);
        this.jPanel1.add((Component)this.findAll, null);
        this.jPanel1.add((Component)this.createNewGroup, null);
        this.add(this.caseSensitive);
        this.add((Component)this.textfield, null);
        this.add((Component)this.jLabel1, null);
        this.add((Component)this.jPanel1, null);
    }

    void textfield_keyTyped(KeyEvent e) {
        this.findNext.setEnabled(true);
    }
}

