/* times.h -- Time/date utility routines
 *
 * Copyright (c) 1994-2010 Carnegie Mellon University.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The name "Carnegie Mellon University" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For permission or any legal
 *    details, please contact
 *      Carnegie Mellon University
 *      Center for Technology Transfer and Enterprise Creation
 *      4615 Forbes Avenue
 *      Suite 302
 *      Pittsburgh, PA  15213
 *      (412) 268-7393, fax: (412) 268-7395
 *      innovation@andrew.cmu.edu
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Computing Services
 *     at Carnegie Mellon University (http://www.cmu.edu/computing/)."
 *
 * CARNEGIE MELLON UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef __CYRUS__TIME_H__
#define __CYRUS__TIME_H__

#include <time.h>
#include <sys/time.h>

/* Factor for converting days to seconds. */
#define DAY2SEC (24 * 60 * 60)

/* Default precision to print timeval is millisecond (timeval_ms)
 * change to timeval_us in times.c to print microsecond. */
enum timeval_precision { timeval_s, timeval_ms, timeval_us };

/*
 * RFC822 datetime format
 */
/* Size in bytes of longest date format
 * generated by time_to_rfc822(),
 * not including the nul terminator. */
#define RFC822_DATETIME_MAX 31
int time_from_rfc822(const char *s, time_t *tp);
int day_from_rfc822(const char *s, time_t *tp);
int time_to_rfc822(time_t t, char *buf, size_t len);

/*
 * ISO8601 (RFC3339) datetime format
 */
int time_from_iso8601(const char *s, time_t *);
int time_to_iso8601(time_t t, char *buf, size_t len);
int timeval_to_iso8601(const struct timeval *t, enum timeval_precision tv_prec,
                       char *buf, size_t len);

/*
 * RFC3501 datetime format
 */
/* Size in bytes of longest date format accepted by
 * time_from_rfc3501(), and generated by time_to_rfc3501(),
 * not including the nul terminator. */
#define RFC3501_DATETIME_MAX 26
int time_to_rfc3501(time_t t, char *buf, size_t len);
int time_from_rfc3501(const char *s, time_t *tp);

#define RFC3339_DATETIME_MAX 21
int time_to_rfc3339(time_t t, char *buf, size_t len);

#endif /* __CYRUS__TIME_H__ */
