#ifndef H_CDW_FILE
#define H_CDW_FILE

#include <stdbool.h>
#include <unistd.h> /* ssize_t */

#include "main.h"
#include "cdw_dll.h"

typedef enum {
	CDW_FS_DIR   = 1, /* don't use 0, because it's useless in binary masks */
	CDW_FS_FILE  = 2,
	CDW_FS_LINK  = 4,
	CDW_FS_OTHER = 8
} cdw_file_type_t;

typedef long long int cdw_file_size_t;

typedef struct {
	/* index of letter in fullpath that is first letter of file name,
	   i.e. first letter after last slash */
	ssize_t name_start;

	/* full, non-relative path to a given file */
	char *fullpath;

	/* sometimes file fullpath can contain characters that can't be printed
	   in ncurses window, like in "Schlaflos_in_M�nchen/"; a file path
	   with such non-printable char is used to refer to file in file
	   system, but at the same time cdw must be able to print the string
	   in ncurses window; "printable_fullpath" is such a string; */
	char *printable_fullpath;

	/* stored values are those of enum file_type: if fullpath of
	   the file points to a link, then "type" stores information
	   about target of the link */
	int type;

	/* size of file in bytes */
	cdw_file_size_t size;
	/* is the file a reference to parent dir, i.e. is it ".." entity?
	   may be useful when "name" field will be removed - this will allow
	   to avoid using strcmp() to check if file is a reference to parent dir */
	bool is_ref_to_parent_dir;
	/* is this file a link? this is an important distinction,
	   because if file is a link, then "type" field holds information
	   about target of the link */
	bool link;
	/* stat() failed for this file: may be invalid file (e.g. broken link) or other reason */
	bool invalid;
} cdw_file_t;


cdw_file_t *cdw_file_new(const char *dirpath, const char *name);
cdw_rv_t cdw_file_delete(cdw_file_t **file);

cdw_file_t *cdw_file_duplicate(const cdw_file_t *file);
bool cdw_file_equal(const void *_file1, const void *_file2);

cdw_rv_t cdw_file_dealloc_files_from_list(cdw_dll_item_t *list);

void cdw_file_display_file(void *display, void *data, size_t row, size_t h_offset, bool isreverse);

/* for unit testing */
void cdw_file_run_tests(void);

#endif /* H_CDW_FILE */
