#! /bin/sh
#=======================================================================
# This script attempts to build and check a program on every UNIX C
# and C++ compiler available to the author.
#
# Because of wide variations in optimizer switches, no attempt is yet
# made to validate the same compiler at multiple optimization levels:
# that job is left for the installer.
#
# Usage:
#	build-all.sh |& tee -a typescript.xxx
#
# The program author can examine the output in the typescript.xxx file
# to determine what, if any, changes are needed in the code to ensure
# that it will build correctly.
# [30-Sep-1995]
#=======================================================================

# On DECstation ULTRIX, /bin/sh does not support shell functions, but
# /usr/bin/ksh and /usr/local/bin/bash do.  We therefore change shells
# on that system.

SHELL=/bin/sh
if [ -f /usr/bin/ksh ]
then
    SHELL=/usr/bin/ksh
fi

$SHELL <<END-OF-FILE

doconfig ()
{
    if [ -f \$1 ]
    then
	echo ============================================================
	echo configuring for \$1 \$2
	date
	uname -a
	make distclean >/dev/null 2>&1
	CC="\$1 \$2" ./configure && make && make check
	date
    fi
}

# Here is a list of known compilers on DEC (MIPS ULTRIX and Alpha
# OSF/1), HP (PA-RISC HP-UX), IBM (POWER AIX), IBM PC (Intel LINUX),
# NeXT (Motorola 68K Mach) SGI (MIPS), and Sun (SPARC SunOS and SPARC
# Solaris) systems.  We try all that actually exist on this system.

doconfig /bin/CC
doconfig /bin/c89
doconfig /bin/cc
doconfig /bin/cxx
doconfig /bin/xlC
doconfig /opt/SUNWspro/bin/CC
doconfig /opt/SUNWspro/bin/cc
doconfig /usr/bin/CC
doconfig /usr/bin/c89
doconfig /usr/bin/cc
doconfig /usr/bin/g++
doconfig /usr/bin/gcc
doconfig /usr/ccs/bin/c89
doconfig /usr/ccs/bin/cc
doconfig /usr/lang/CC
doconfig /usr/lang/acc
doconfig /usr/local/bin/g++
doconfig /usr/local/bin/gcc
doconfig /usr/local/bin/lcc "-A -A"
doconfig /usr/ucb/cc

END-OF-FILE
