/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.nio.CharBuffer;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerException;
import net.sf.saxon.charcode.CharacterSet;
import net.sf.saxon.charcode.CharacterSetFactory;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.XMLChar;

public class CDATAFilter
extends ProxyReceiver {
    private StringBuffer buffer = new StringBuffer();
    private Stack stack = new Stack();
    private int[] nameList;
    private CharacterSet characterSet;

    public void setOutputProperties(Properties properties) throws TransformerException {
        this.nameList = this.getCdataElements(properties);
        this.characterSet = CharacterSetFactory.getCharacterSet(properties);
    }

    public void startElement(int n, int n2, int n3) throws TransformerException {
        this.flush(this.buffer);
        this.stack.push(new Integer(n & 0xFFFFF));
        super.startElement(n, n2, n3);
    }

    public void endElement() throws TransformerException {
        this.flush(this.buffer);
        this.stack.pop();
        super.endElement();
    }

    public void processingInstruction(String string, CharSequence charSequence, int n) throws TransformerException {
        this.flush(this.buffer);
        super.processingInstruction(string, charSequence, n);
    }

    public void characters(CharSequence charSequence, int n) throws TransformerException {
        if ((n & 1) != 0) {
            this.flush(this.buffer);
            super.characters(charSequence, n);
        } else {
            this.buffer.append(charSequence.toString());
        }
    }

    public void comment(CharSequence charSequence, int n) throws TransformerException {
        this.flush(this.buffer);
        super.comment(charSequence, n);
    }

    public void flush(StringBuffer stringBuffer) throws TransformerException {
        int n;
        boolean bl;
        int n2 = stringBuffer.length();
        if (n2 == 0) {
            return;
        }
        if (this.stack.isEmpty()) {
            bl = false;
        } else {
            n = (Integer)this.stack.peek();
            bl = this.isCDATA(n);
        }
        if (bl) {
            n = 0;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = stringBuffer.charAt(n3);
                int n5 = 1;
                if (XMLChar.isHighSurrogate((char)n4)) {
                    n4 = XMLChar.supplemental((char)n4, stringBuffer.charAt(n3 + 1));
                    n5 = 2;
                }
                if (!this.characterSet.inCharset(n4)) {
                    char[] cArray = new char[n3 - n];
                    stringBuffer.getChars(n, n3, cArray, 0);
                    this.flushCDATA(cArray, n3 - n);
                    while (n3 < n2) {
                        super.characters(CharBuffer.wrap(stringBuffer, n3, n3 + n5), 0);
                        n4 = stringBuffer.charAt(n3 += n5);
                        n5 = 1;
                        if (XMLChar.isHighSurrogate((char)n4)) {
                            n4 = XMLChar.supplemental((char)n4, stringBuffer.charAt(n3 + 1));
                            n5 = 2;
                        }
                        if (this.characterSet.inCharset(n4)) break;
                    }
                    n = n3;
                    continue;
                }
                ++n3;
            }
            char[] cArray = new char[n2 - n];
            stringBuffer.getChars(n, n2, cArray, 0);
            this.flushCDATA(cArray, n2 - n);
        } else {
            char[] cArray = new char[n2];
            stringBuffer.getChars(0, n2, cArray, 0);
            super.characters(CharBuffer.wrap(cArray, 0, n2), 0);
        }
        stringBuffer.setLength(0);
    }

    private void flushCDATA(char[] cArray, int n) throws TransformerException {
        super.characters("<![CDATA[", 1);
        int n2 = 0;
        int n3 = 0;
        while (n2 < n - 2) {
            if (cArray[n2] == ']' && cArray[n2 + 1] == ']' && cArray[n2 + 2] == '>') {
                super.characters(CharBuffer.wrap(cArray, n3, n2 + 2 - n3), 1);
                super.characters("]]><![CDATA[", 1);
                n3 = n2 + 2;
            }
            ++n2;
        }
        super.characters(CharBuffer.wrap(cArray, n3, n - n3), 1);
        super.characters("]]>", 1);
    }

    private boolean isCDATA(int n) {
        int n2 = 0;
        while (n2 < this.nameList.length) {
            if (this.nameList[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private int[] getCdataElements(Properties properties) {
        String string = properties.getProperty("cdata-section-elements");
        if (string == null) {
            return new int[0];
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
            ++n;
        }
        int[] nArray = new int[n];
        n = 0;
        StringTokenizer stringTokenizer2 = new StringTokenizer(string);
        while (stringTokenizer2.hasMoreTokens()) {
            String string2 = stringTokenizer2.nextToken();
            nArray[n++] = this.namePool.getFingerprintForExpandedName(string2);
        }
        return nArray;
    }
}

