/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.reflect;

import java.util.LinkedList;
import java.util.List;
import net.sf.jiapi.file.ClassFile;
import net.sf.jiapi.file.ConstantPool;
import net.sf.jiapi.file.Field;
import net.sf.jiapi.file.Interface;
import net.sf.jiapi.file.Method;
import net.sf.jiapi.file.ProgramElement;
import net.sf.jiapi.file.attribute.CodeAttribute;
import net.sf.jiapi.file.attribute.SyntheticAttribute;
import net.sf.jiapi.reflect.FieldExistsException;
import net.sf.jiapi.reflect.JiapiField;
import net.sf.jiapi.reflect.JiapiMethod;
import net.sf.jiapi.reflect.Signature;
import net.sf.jiapi.reflect.TypeHelper;

class ClassBuilder {
    private ClassFile clazz;

    ClassBuilder(ClassFile clazz) {
        this.clazz = clazz;
    }

    JiapiField addField(short modifiers, String type, String name) throws FieldExistsException {
        ConstantPool cp = this.clazz.getConstantPool();
        List fields = this.clazz.getFields();
        for (Field field : fields) {
            if (!field.getName().equals(name)) continue;
            throw new FieldExistsException(new JiapiField(field));
        }
        LinkedList<SyntheticAttribute> attrs = new LinkedList<SyntheticAttribute>();
        attrs.add(new SyntheticAttribute(cp));
        Field f = new Field(cp, modifiers, name, TypeHelper.typeToDescriptor(type), attrs);
        fields.add(f);
        return new JiapiField(f);
    }

    JiapiMethod addMethod(short modifiers, String name, Signature signature) {
        ConstantPool cp = this.clazz.getConstantPool();
        LinkedList<Object> attrs = new LinkedList<Object>();
        attrs.add(new SyntheticAttribute(cp));
        short maxStack = 0;
        int maxLocals = signature.getParameters().length + 1;
        attrs.add(new CodeAttribute(cp, maxStack, (short)maxLocals));
        Method m = new Method(cp, modifiers, name, signature.getDescriptor(), attrs);
        this.clazz.getMethods().add(m);
        return new JiapiMethod(m);
    }

    void addInterface(String name) {
        ConstantPool constantPool = this.clazz.getConstantPool();
        short cInfo = constantPool.addClassInfo(name).getEntryIndex();
        List interfaces = this.clazz.getInterfaces();
        interfaces.add(new Interface(constantPool, cInfo));
    }

    ProgramElement getClassFile() {
        return this.clazz;
    }
}

