/*
 * Decompiled with CFR 0.152.
 */
package com.android.dex.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public final class FileUtils {
    private FileUtils() {
    }

    public static byte[] readFile(String string) {
        File file = new File(string);
        return FileUtils.readFile(file);
    }

    public static byte[] readFile(File file) {
        if (!file.exists()) {
            throw new RuntimeException(file + ": file not found");
        }
        if (!file.isFile()) {
            throw new RuntimeException(file + ": not a file");
        }
        if (!file.canRead()) {
            throw new RuntimeException(file + ": file not readable");
        }
        long l = file.length();
        int n = (int)l;
        if ((long)n != l) {
            throw new RuntimeException(file + ": file too long");
        }
        byte[] byArray = new byte[n];
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            int n2 = 0;
            while (n > 0) {
                int n3 = fileInputStream.read(byArray, n2, n);
                if (n3 == -1) {
                    throw new RuntimeException(file + ": unexpected EOF");
                }
                n2 += n3;
                n -= n3;
            }
            fileInputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(file + ": trouble reading", iOException);
        }
        return byArray;
    }

    public static boolean hasArchiveSuffix(String string) {
        return string.endsWith(".zip") || string.endsWith(".jar") || string.endsWith(".apk");
    }
}

