/*
 * SPDX-License-Identifier: MIT
 *
 * Copyright (C) 2011-2015 Mathieu Desnoyers <mathieu.desnoyers@efficios.com>
 */

#include <lttng/tracepoint.h>
#include <stdarg.h>

LTTNG_UST_TRACEPOINT_EVENT_CLASS(lttng_ust_tracelog, tlclass,
	LTTNG_UST_TP_ARGS(const char *, file, int, line, const char *, func,
		const char *, msg, unsigned int, len, void *, ip),
	LTTNG_UST_TP_FIELDS(
		lttng_ust_field_integer(int, line, line)
		lttng_ust_field_string(file, file)
		lttng_ust_field_string(func, func)
		lttng_ust_field_sequence_text(char, msg, msg, unsigned int, len)
		lttng_ust_field_unused(ip)
	)
)

#define LTTNG_UST_TP_TRACELOG_TEMPLATE(_level_enum) \
	LTTNG_UST_TRACEPOINT_EVENT_INSTANCE(lttng_ust_tracelog, tlclass, \
		lttng_ust_tracelog, _level_enum, \
		LTTNG_UST_TP_ARGS(const char *, file, int, line, const char *, func, \
			const char *, msg, unsigned int, len, void *, ip) \
	) \
	LTTNG_UST_TRACEPOINT_LOGLEVEL(lttng_ust_tracelog, _level_enum, _level_enum)

LTTNG_UST_TP_TRACELOG_TEMPLATE(LTTNG_UST_TRACEPOINT_LOGLEVEL_EMERG)
LTTNG_UST_TP_TRACELOG_TEMPLATE(LTTNG_UST_TRACEPOINT_LOGLEVEL_ALERT)
LTTNG_UST_TP_TRACELOG_TEMPLATE(LTTNG_UST_TRACEPOINT_LOGLEVEL_CRIT)
LTTNG_UST_TP_TRACELOG_TEMPLATE(LTTNG_UST_TRACEPOINT_LOGLEVEL_ERR)
LTTNG_UST_TP_TRACELOG_TEMPLATE(LTTNG_UST_TRACEPOINT_LOGLEVEL_WARNING)
LTTNG_UST_TP_TRACELOG_TEMPLATE(LTTNG_UST_TRACEPOINT_LOGLEVEL_NOTICE)
LTTNG_UST_TP_TRACELOG_TEMPLATE(LTTNG_UST_TRACEPOINT_LOGLEVEL_INFO)
LTTNG_UST_TP_TRACELOG_TEMPLATE(LTTNG_UST_TRACEPOINT_LOGLEVEL_DEBUG_SYSTEM)
LTTNG_UST_TP_TRACELOG_TEMPLATE(LTTNG_UST_TRACEPOINT_LOGLEVEL_DEBUG_PROGRAM)
LTTNG_UST_TP_TRACELOG_TEMPLATE(LTTNG_UST_TRACEPOINT_LOGLEVEL_DEBUG_PROCESS)
LTTNG_UST_TP_TRACELOG_TEMPLATE(LTTNG_UST_TRACEPOINT_LOGLEVEL_DEBUG_MODULE)
LTTNG_UST_TP_TRACELOG_TEMPLATE(LTTNG_UST_TRACEPOINT_LOGLEVEL_DEBUG_UNIT)
LTTNG_UST_TP_TRACELOG_TEMPLATE(LTTNG_UST_TRACEPOINT_LOGLEVEL_DEBUG_FUNCTION)
LTTNG_UST_TP_TRACELOG_TEMPLATE(LTTNG_UST_TRACEPOINT_LOGLEVEL_DEBUG_LINE)
LTTNG_UST_TP_TRACELOG_TEMPLATE(LTTNG_UST_TRACEPOINT_LOGLEVEL_DEBUG)
