/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright (c) 2024 Linaro Limited
 * Author: Raymond Mao <raymond.mao@linaro.org>
 */

#ifndef _SMBIOS_DEF_H_
#define _SMBIOS_DEF_H_

/*
 * BIOS characteristics
 */

#define BIOS_CHARACTERISTICS_PCI_SUPPORTED	0x80 /* BIT(7) */
#define BIOS_CHARACTERISTICS_UPGRADEABLE	0x800 /* BIT(11) */
#define BIOS_CHARACTERISTICS_SELECTABLE_BOOT	0x10000  /* BIT(16) */

#define BIOS_CHARACTERISTICS_EXT1_ACPI		1 /* BIT(0) */
#define BIOS_CHARACTERISTICS_EXT2_UEFI		8 /* BIT(3) */
#define BIOS_CHARACTERISTICS_EXT2_TARGET	4 /* BIT(2) */

/*
 * System Information
 */

#define SMBIOS_WAKEUP_TYPE_RESERVED		0
#define SMBIOS_WAKEUP_TYPE_OTHER		1
#define SMBIOS_WAKEUP_TYPE_UNKNOWN		2
#define SMBIOS_WAKEUP_TYPE_APM_TIMER		3
#define SMBIOS_WAKEUP_TYPE_MODEM_RING		4
#define SMBIOS_WAKEUP_TYPE_LAN_REMOTE		5
#define SMBIOS_WAKEUP_TYPE_POWER_SWITCH		6
#define SMBIOS_WAKEUP_TYPE_PCI_PME		7
#define SMBIOS_WAKEUP_TYPE_AC_POWER_RESTORED	8

/*
 * Baseboard Information
 */

#define SMBIOS_BOARD_FEAT_HOST_BOARD		1 /* BIT(0) */
#define SMBIOS_BOARD_FEAT_REQ_AUX		2 /* BIT(1) */
#define SMBIOS_BOARD_FEAT_REMOVABLE		4 /* BIT(2) */
#define SMBIOS_BOARD_FEAT_REPLACEABLE		8 /* BIT(3) */
#define SMBIOS_BOARD_FEAT_HOT_SWAPPABLE		16 /* BIT(4) */

#define SMBIOS_BOARD_TYPE_UNKNOWN		1
#define SMBIOS_BOARD_TYPE_OTHER			2
#define SMBIOS_BOARD_TYPE_SERVER_BLADE		3
#define SMBIOS_BOARD_TYPE_CON_SWITCH		4
#define SMBIOS_BOARD_TYPE_SM_MODULE		5
#define SMBIOS_BOARD_TYPE_PROCESSOR_MODULE	6
#define SMBIOS_BOARD_TYPE_IO_MODULE		7
#define SMBIOS_BOARD_TYPE_MEM_MODULE		8
#define SMBIOS_BOARD_TYPE_DAUGHTER_BOARD	9
#define SMBIOS_BOARD_TYPE_MOTHERBOARD		10
#define SMBIOS_BOARD_TYPE_PROC_MEM_MODULE	11
#define SMBIOS_BOARD_TYPE_PROC_IO_MODULE	12
#define SMBIOS_BOARD_TYPE_INTERCON		13

/*
 * System Enclosure or Chassis
 */
#define SMBIOS_ENCLOSURE_UNKNOWN	2
#define SMBIOS_ENCLOSURE_DESKTOP	3

#define SMBIOS_STATE_OTHER		1
#define SMBIOS_STATE_UNKNOWN		2
#define SMBIOS_STATE_SAFE		3
#define SMBIOS_STATE_WARNING		4
#define SMBIOS_STATE_CRITICAL		5
#define SMBIOS_STATE_NONRECOVERABLE	6

#define SMBIOS_SECURITY_OTHER		1
#define SMBIOS_SECURITY_UNKNOWN		2
#define SMBIOS_SECURITY_NONE		3
#define SMBIOS_SECURITY_EXTINT_LOCK	4
#define SMBIOS_SECURITY_EXTINT_EN	5

#define SMBIOS_ENCLOSURE_OEM_UND	0
#define SMBIOS_ENCLOSURE_HEIGHT_UND	0
#define SMBIOS_POWCORD_NUM_UND		0
#define SMBIOS_ELEMENT_TYPE_SELECT	0x80 /* BIT(7) */

/*
 * Processor Information
 */

#define SMBIOS_PROCESSOR_TYPE_OTHER	1
#define SMBIOS_PROCESSOR_TYPE_UNKNOWN	2
#define SMBIOS_PROCESSOR_TYPE_CENTRAL	3
#define SMBIOS_PROCESSOR_TYPE_MATH	4
#define SMBIOS_PROCESSOR_TYPE_DSP	5
#define SMBIOS_PROCESSOR_TYPE_VIDEO	6

#define SMBIOS_PROCESSOR_STATUS_UNKNOWN		0
#define SMBIOS_PROCESSOR_STATUS_ENABLED		1
#define SMBIOS_PROCESSOR_STATUS_DISABLED_USER	2
#define SMBIOS_PROCESSOR_STATUS_DISABLED_BIOS	3
#define SMBIOS_PROCESSOR_STATUS_IDLE		4
#define SMBIOS_PROCESSOR_STATUS_OTHER		7

#define SMBIOS_PROCESSOR_UPGRADE_OTHER		1
#define SMBIOS_PROCESSOR_UPGRADE_UNKNOWN	2
#define SMBIOS_PROCESSOR_UPGRADE_NONE		6

#define SMBIOS_PROCESSOR_FAMILY_OTHER	1
#define SMBIOS_PROCESSOR_FAMILY_UNKNOWN	2
#define SMBIOS_PROCESSOR_FAMILY_RSVD	255
#define SMBIOS_PROCESSOR_FAMILY_ARMV7	256
#define SMBIOS_PROCESSOR_FAMILY_ARMV8	257
#define SMBIOS_PROCESSOR_FAMILY_RV32	512
#define SMBIOS_PROCESSOR_FAMILY_RV64	513

#define SMBIOS_PROCESSOR_FAMILY_EXT	0xfe

/* Processor Characteristics */
#define SMBIOS_PROCESSOR_RSVD		1 /* BIT(0) */
#define SMBIOS_PROCESSOR_UND		2 /* BIT(1) */
#define SMBIOS_PROCESSOR_64BIT		4 /* BIT(2) */
#define SMBIOS_PROCESSOR_MULTICORE	8 /* BIT(3) */
#define SMBIOS_PROCESSOR_HWTHREAD	16 /* BIT(4) */
#define SMBIOS_PROCESSOR_EXEC_PROT	32 /* BIT(5) */
#define SMBIOS_PROCESSOR_ENH_VIRT	64 /* BIT(6) */
#define SMBIOS_PROCESSOR_POW_CON	0x80 /* BIT(7) */
#define SMBIOS_PROCESSOR_128BIT		0x100 /* BIT(8) */
#define SMBIOS_PROCESSOR_ARM64_SOCID	0x200 /* BIT(9) */

/*
 * Cache Information
 */

#define SMBIOS_CACHE_SIZE_EXT_KB (2047 * 1024) /* 2047 MiB */
#define SMBIOS_CACHE_HANDLE_NONE 0xffff

/* System Cache Type */
#define SMBIOS_CACHE_SYSCACHE_TYPE_OTHER	1
#define SMBIOS_CACHE_SYSCACHE_TYPE_UNKNOWN	2
#define SMBIOS_CACHE_SYSCACHE_TYPE_INST		3
#define SMBIOS_CACHE_SYSCACHE_TYPE_DATA		4
#define SMBIOS_CACHE_SYSCACHE_TYPE_UNIFIED	5

/* Cache Speed */
#define SMBIOS_CACHE_SPEED_UNKNOWN	0

/* SRAM Type */
#define SMBIOS_CACHE_SRAM_TYPE_UNKNOWN	2 /* BIT(1) */

/* Error Correction Type */
#define SMBIOS_CACHE_ERRCORR_OTHER	1
#define SMBIOS_CACHE_ERRCORR_UNKNOWN	2
#define SMBIOS_CACHE_ERRCORR_NONE	3
#define SMBIOS_CACHE_ERRCORR_PARITY	4
#define SMBIOS_CACHE_ERRCORR_SBITECC	5
#define SMBIOS_CACHE_ERRCORR_MBITECC	6

/* Cache Configuration */
#define SMBIOS_CACHE_LEVEL_1	0
#define SMBIOS_CACHE_LEVEL_2	1
#define SMBIOS_CACHE_LEVEL_3	2
#define SMBIOS_CACHE_LEVEL_4	3
#define SMBIOS_CACHE_LEVEL_5	4
#define SMBIOS_CACHE_LEVEL_6	5
#define SMBIOS_CACHE_LEVEL_7	6
#define SMBIOS_CACHE_LEVEL_8	7
#define SMBIOS_CACHE_SOCKETED	8 /* BIT(3) */
#define SMBIOS_CACHE_LOCATE_EXTERNAL	32 /* BIT(5) */
#define SMBIOS_CACHE_LOCATE_RESERVED	64 /* BIT(6) */
#define SMBIOS_CACHE_LOCATE_UNKNOWN	96 /* (BIT(5) | BIT(6)) */
#define SMBIOS_CACHE_ENABLED	0x80 /* BIT(7) */
#define SMBIOS_CACHE_OP_WB	0x100 /* BIT(8), Write Back */
#define SMBIOS_CACHE_OP_VAR	0x200 /* BIT(9), Varies with Memory Address */
#define SMBIOS_CACHE_OP_UND	0x300 /* (BIT(8) | BIT(9)), Unknown*/

/* Cache Granularity */
#define SMBIOS_CACHE_GRANU_1K	0
#define SMBIOS_CACHE_GRANU_64K	1

/* Cache Associativity */
#define SMBIOS_CACHE_ASSOC_OTHER	1
#define SMBIOS_CACHE_ASSOC_UNKNOWN	2
#define SMBIOS_CACHE_ASSOC_DMAPPED	3
#define SMBIOS_CACHE_ASSOC_2WAY		4
#define SMBIOS_CACHE_ASSOC_4WAY		5
#define SMBIOS_CACHE_ASSOC_FULLY	6
#define SMBIOS_CACHE_ASSOC_8WAY		7
#define SMBIOS_CACHE_ASSOC_16WAY	8
#define SMBIOS_CACHE_ASSOC_12WAY	9
#define SMBIOS_CACHE_ASSOC_24WAY	10
#define SMBIOS_CACHE_ASSOC_32WAY	11
#define SMBIOS_CACHE_ASSOC_48WAY	12
#define SMBIOS_CACHE_ASSOC_64WAY	13
#define SMBIOS_CACHE_ASSOC_20WAY	14

#endif /* _SMBIOS_DEF_H_ */
